```
% pandoc -f rst -t native
.. figure:: image.png
   :alt: my alt

   Caption
^D
[ Figure
    ( "" , [] , [] )
    (Caption Nothing [ Plain [ Str "Caption" ] ])
    [ Plain
        [ Image
            ( "" , [] , [] )
            [ Str "my" , Space , Str "alt" ]
            ( "image.png" , "" )
        ]
    ]
]
```

```
% pandoc -f rst -t native
.. figure:: image.png

   Caption
^D
[ Figure
    ( "" , [] , [] )
    (Caption Nothing [ Plain [ Str "Caption" ] ])
    [ Plain
        [ Image
            ( "" , [] , [] ) [ Str "Caption" ] ( "image.png" , "" )
        ]
    ]
]
```

```
% pandoc -f native -t markdown
[ Figure
    ( "" , [] , [] )
    (Caption
       Nothing [ Plain [ Str "Caption" ] ])
    [ Plain
        [ Image ( "" , [] , [] ) [ Str "my", Space, Str "alt" ] ( "image.png" , "" )
        ]
    ]
]
^D
![Caption](image.png){alt="my alt"}
```

Ignore `\pandocbounded`:
```
% pandoc -f latex -t native
\begin{figure}
\centering
\pandocbounded{\includegraphics[keepaspectratio,alt={Caption}]{image.png}}
\caption{Caption}
\end{figure}
^D
[ Figure
    ( "" , [] , [] )
    (Caption Nothing [ Plain [ Str "Caption" ] ])
    [ Para
        [ Image
            ( "" , [] , [] ) [ Str "Caption" ] ( "image.png" , "" )
        ]
    ]
]
```
