Parsing PARAMETERS of Org-mode blocks

```
% pandoc -f org --to=native
#+attr_html: :width 10px
#+BEGIN_myex :this that
huhu
#+END_myex
^D
[ Div
    ( ""
    , [ "myex" ]
    , [ ( "width" , "10px" ) , ( "this" , "that" ) ]
    )
    [ Para [ Str "huhu" ] ]
]
```

Python-style parameters are accepted, too.

```
% pandoc -f org --to=native
#+BEGIN_myblock width=10px
[[image.svg][logo]]
#+END_myblock
^D
[ Div
    ( "" , [ "myblock" ] , [ ( "width" , "10px" ) ] )
    [ Para
        [ Span
            ( ""
            , [ "spurious-link" ]
            , [ ( "target" , "image.svg" ) ]
            )
            [ Emph [ Str "logo" ] ]
        ]
    ]
]
```

The fallback is to put the remainder of the line into a `parameters`
attribute.

```
% pandoc -f org --to=native
#+BEGIN_myblock these are parameters in an unsupported format
/OK/
#+END_myblock
^D
[ Div
    ( ""
    , [ "myblock" ]
    , [ ( "parameters"
        , "these are parameters in an unsupported format"
        )
      ]
    )
    [ Para [ Emph [ Str "OK" ] ] ]
]
```

Also works on dynamic blocks.

```
% pandoc -f org --to=markdown
#+BEGIN: clocktable :scope subtree :maxlevel 3
#+CAPTION: Clock summary at [2025-10-18 Sat 17:23]
| Headline     | Time   |
|--------------+--------|
| *Total time* | *0:00* |
#+END:
^D
::: {.clocktable scope="subtree" maxlevel="3"}
  Headline         Time
  ---------------- ----------
  **Total time**   **0:00**

  : Clock summary at \[2025-10-18 Sat 17:23\]
:::
```
