# 1 "src/Text/CSL/Data/Embedded.hsb"
{-# LANGUAGE OverloadedStrings #-}
-- to be processed using hsb2hs
module Text.CSL.Data.Embedded (localeFiles, defaultCSL) where
import qualified Data.ByteString as S

localeFiles :: [(FilePath, S.ByteString)]
localeFiles = [("locales-af-ZA.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"af-ZA\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\" \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"year\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" prefix=\"/\"/>\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" prefix=\"/\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">toegang verkry</term>\n    <term name=\"and\">en</term>\n    <term name=\"and others\">and others</term>\n    <term name=\"anonymous\">anonymous</term>\n    <term name=\"anonymous\" form=\"short\">anon</term>\n    <term name=\"at\">at</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">by</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">cited</term>\n    <term name=\"edition\">\n      <single>edition</single>\n      <multiple>editions</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">ed</term>\n    <term name=\"et-al\">et al.</term>\n    <term name=\"forthcoming\">voorhande</term>\n    <term name=\"from\">van</term>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\">in</term>\n    <term name=\"in press\">in press</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">interview</term>\n    <term name=\"letter\">letter</term>\n    <term name=\"no date\">no date</term>\n    <term name=\"no date\" form=\"short\">n.d.</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">presented at the</term>\n    <term name=\"reference\">\n      <single>reference</single>\n      <multiple>references</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">opgehaal</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">AD</term>\n    <term name=\"bc\">BC</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\156</term>\n    <term name=\"close-quote\">\226\128\157</term>\n    <term name=\"open-inner-quote\">\226\128\152</term>\n    <term name=\"close-inner-quote\">\226\128\153</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">th</term>\n    <term name=\"ordinal-01\">st</term>\n    <term name=\"ordinal-02\">nd</term>\n    <term name=\"ordinal-03\">rd</term>\n    <term name=\"ordinal-11\">th</term>\n    <term name=\"ordinal-12\">th</term>\n    <term name=\"ordinal-13\">th</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">first</term>\n    <term name=\"long-ordinal-02\">second</term>\n    <term name=\"long-ordinal-03\">third</term>\n    <term name=\"long-ordinal-04\">fourth</term>\n    <term name=\"long-ordinal-05\">fifth</term>\n    <term name=\"long-ordinal-06\">sixth</term>\n    <term name=\"long-ordinal-07\">seventh</term>\n    <term name=\"long-ordinal-08\">eighth</term>\n    <term name=\"long-ordinal-09\">ninth</term>\n    <term name=\"long-ordinal-10\">tenth</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>book</single>\n      <multiple>books</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>chapter</single>\n      <multiple>chapters</multiple>\n    </term>\n    <term name=\"column\">\n      <single>column</single>\n      <multiple>columns</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>figure</single>\n      <multiple>figures</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folio</single>\n      <multiple>folios</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>number</single>\n      <multiple>numbers</multiple>\n    </term>\n    <term name=\"line\">\n      <single>re\195\171l</single>\n      <multiple>re\195\171ls</multiple>\n    </term>\n    <term name=\"note\">\n      <single>note</single>\n      <multiple>notes</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>bladsy</single>\n      <multiple>bladsye</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>paragraaf</single>\n      <multiple>paragrawe</multiple>\n    </term>\n    <term name=\"part\">\n      <single>part</single>\n      <multiple>parts</multiple>\n    </term>\n    <term name=\"section\">\n      <single>section</single>\n      <multiple>sections</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>verse</single>\n      <multiple>verses</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>volume</single>\n      <multiple>volumes</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">bk</term>\n    <term name=\"chapter\" form=\"short\">chap</term>\n    <term name=\"column\" form=\"short\">col</term>\n    <term name=\"figure\" form=\"short\">fig</term>\n    <term name=\"folio\" form=\"short\">f</term>\n    <term name=\"issue\" form=\"short\">no</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op</term>\n    <term name=\"page\" form=\"short\">\n      <single>bl</single>\n      <multiple>bll</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">para</term>\n    <term name=\"part\" form=\"short\">pt</term>\n    <term name=\"section\" form=\"short\">sec</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v</single>\n      <multiple>vv</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>vol</single>\n      <multiple>vols</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>redakteur</single>\n      <multiple>redakteurs</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>vertaler</single>\n      <multiple>vertalers</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>editor &amp; translator</single>\n      <multiple>editors &amp; translators</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>red</single>\n      <multiple>reds</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ed.</single>\n      <multiple>eds.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>vert</single>\n      <multiple>verts</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ed. &amp; tran.</single>\n      <multiple>eds. &amp; trans.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">onder redaksie van</term>\n    <term name=\"editorial-director\" form=\"verb\">edited by</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">interview by</term>\n    <term name=\"recipient\" form=\"verb\">to</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">vertaal deur</term>\n    <term name=\"editortranslator\" form=\"verb\">edited &amp; translated by</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">by</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">red</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">verts</term>\n    <term name=\"editortranslator\" form=\"verb-short\">ed. &amp; trans. by</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">Januarie</term>\n    <term name=\"month-02\">Februarie</term>\n    <term name=\"month-03\">Maart</term>\n    <term name=\"month-04\">April</term>\n    <term name=\"month-05\">Mei</term>\n    <term name=\"month-06\">Junie</term>\n    <term name=\"month-07\">Julie</term>\n    <term name=\"month-08\">Augustus</term>\n    <term name=\"month-09\">September</term>\n    <term name=\"month-10\">Oktober</term>\n    <term name=\"month-11\">November</term>\n    <term name=\"month-12\">Desember</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">Jan</term>\n    <term name=\"month-02\" form=\"short\">Feb</term>\n    <term name=\"month-03\" form=\"short\">Mrt</term>\n    <term name=\"month-04\" form=\"short\">Apr</term>\n    <term name=\"month-05\" form=\"short\">Mei</term>\n    <term name=\"month-06\" form=\"short\">Jun</term>\n    <term name=\"month-07\" form=\"short\">Jul</term>\n    <term name=\"month-08\" form=\"short\">Aug</term>\n    <term name=\"month-09\" form=\"short\">Sep</term>\n    <term name=\"month-10\" form=\"short\">Okt</term>\n    <term name=\"month-11\" form=\"short\">Nov</term>\n    <term name=\"month-12\" form=\"short\">Des</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">Spring</term>\n    <term name=\"season-02\">Summer</term>\n    <term name=\"season-03\">Autumn</term>\n    <term name=\"season-04\">Winter</term>\n  </terms>\n</locale>\n"),("locales-ar-AR.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"ar-AR\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\" \"/>\n    <date-part name=\"month\" suffix=\", \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" suffix=\"/\"/>\n    <date-part name=\"month\" form=\"numeric\" suffix=\"/\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">\216\170\216\167\216\177\217\138\216\174 \216\167\217\132\217\136\216\181\217\136\217\132</term>\n    <term name=\"and\">\217\136</term>\n    <term name=\"and others\">\217\136\216\162\216\174\216\177\217\136\217\134</term>\n    <term name=\"anonymous\">\217\133\216\172\217\135\217\136\217\132</term>\n    <term name=\"anonymous\" form=\"short\">\217\133\216\172\217\135\217\136\217\132</term>\n    <term name=\"at\">\216\185\217\134\216\175</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">\216\185\217\134 \216\183\216\177\217\138\217\130</term>\n    <term name=\"circa\">\216\173\217\136\216\167\217\132\217\138</term>\n    <term name=\"circa\" form=\"short\">\216\173\217\136.</term>\n    <term name=\"cited\">\217\136\216\171\217\130</term>\n    <term name=\"edition\">\n      <single>\216\167\217\132\216\183\216\168\216\185\216\169</single>\n      <multiple>\216\167\217\132\216\183\216\168\216\185\216\167\216\170</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">\216\183.</term>\n    <term name=\"et-al\">\217\136\216\162\216\174.</term>\n    <term name=\"forthcoming\">\216\167\217\132\216\170\216\167\217\132\217\138</term>\n    <term name=\"from\">\217\133\217\134</term>\n    <term name=\"ibid\">\216\167\217\132\217\133\216\177\216\172\216\185 \216\167\217\132\216\179\216\167\216\168\217\130</term>\n    <term name=\"in\">\217\129\217\138</term>\n    <term name=\"in press\">\217\130\217\138\216\175 \216\167\217\132\217\134\216\180\216\177</term>\n    <term name=\"internet\">\216\167\217\134\216\170\216\177\217\134\216\170</term>\n    <term name=\"interview\">\217\133\217\130\216\167\216\168\217\132\216\169</term>\n    <term name=\"letter\">\216\174\216\183\216\167\216\168</term>\n    <term name=\"no date\">\216\175\217\136\217\134 \216\170\216\167\216\177\217\138\216\174</term>\n    <term name=\"no date\" form=\"short\">\216\175.\216\170</term>\n    <term name=\"online\">\216\185\217\132\217\137 \216\167\217\132\216\174\216\183 \216\167\217\132\217\133\216\168\216\167\216\180\216\177</term>\n    <term name=\"presented at\">\217\130\217\143\216\175\217\145\217\142\217\133 \217\129\217\138</term>\n    <term name=\"reference\">\n      <single>\217\133\216\177\216\172\216\185</single>\n      <multiple>\217\133\216\177\216\167\216\172\216\185</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>\217\133\216\177\216\172\216\185</single>\n      <multiple>\217\133\216\177\216\167\216\172\216\185</multiple>\n    </term>\n    <term name=\"retrieved\">\216\167\216\179\216\170\216\177\216\172\216\185 \217\129\217\138</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">\216\168.\217\133.</term>\n    <term name=\"bc\">\217\130.\217\133.</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\"</term>\n    <term name=\"close-quote\">\"</term>\n    <term name=\"open-inner-quote\">'</term>\n    <term name=\"close-inner-quote\">'</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\"/>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">\216\167\217\132\216\167\217\136\217\132</term>\n    <term name=\"long-ordinal-02\">\216\167\217\132\216\171\216\167\217\134\217\138</term>\n    <term name=\"long-ordinal-03\">\216\167\217\132\216\171\216\167\217\132\216\171</term>\n    <term name=\"long-ordinal-04\">\216\167\217\132\216\177\216\167\216\168\216\185</term>\n    <term name=\"long-ordinal-05\">\216\167\217\132\216\174\216\167\217\133\216\179</term>\n    <term name=\"long-ordinal-06\">\216\167\217\132\216\179\216\167\216\175\216\179</term>\n    <term name=\"long-ordinal-07\">\216\167\217\132\216\179\216\167\216\168\216\185</term>\n    <term name=\"long-ordinal-08\">\216\167\217\132\216\171\216\167\217\133\217\134</term>\n    <term name=\"long-ordinal-09\">\216\167\217\132\216\170\216\167\216\179\216\185</term>\n    <term name=\"long-ordinal-10\">\216\167\217\132\216\185\216\167\216\180\216\177</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>\217\131\216\170\216\167\216\168</single>\n      <multiple>\217\131\216\170\216\168</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>\217\129\216\181\217\132</single>\n      <multiple>\217\129\216\181\217\136\217\132</multiple>\n    </term>\n    <term name=\"column\">\n      <single>\216\185\217\133\217\136\216\175</single>\n      <multiple>\216\163\216\185\217\133\216\175\216\169</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>\216\177\216\179\217\133 \216\170\217\136\216\182\217\138\216\173\217\138</single>\n      <multiple>\216\177\216\179\217\136\217\133 \216\170\217\136\216\182\217\138\216\173\217\138\216\169</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>\217\136\216\177\217\130\216\169</single>\n      <multiple>\216\163\217\136\216\177\216\167\217\130</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>\216\185\216\175\216\175</single>\n      <multiple>\216\163\216\185\216\175\216\167\216\175</multiple>\n    </term>\n    <term name=\"line\">\n      <single>\216\179\216\183\216\177</single>\n      <multiple>\216\163\216\179\216\183\216\177</multiple>\n    </term>\n    <term name=\"note\">\n      <single>\217\133\217\132\216\167\216\173\216\184\216\169</single>\n      <multiple>\217\133\217\132\216\167\216\173\216\184\216\167\216\170</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>\217\134\217\136\216\170\217\135 \217\133\217\136\216\179\217\138\217\130\217\138\216\169</single>\n      <multiple>\217\134\217\136\216\170 \217\133\217\136\216\179\217\138\217\130\217\138\216\169</multiple>\n    </term>\n    <term name=\"page\">\n      <single>\216\181\217\129\216\173\216\169</single>\n      <multiple>\216\181\217\129\216\173\216\167\216\170</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>\217\129\217\130\216\177\216\169</single>\n      <multiple>\217\129\217\130\216\177\216\167\216\170</multiple>\n    </term>\n    <term name=\"part\">\n      <single>\216\172\216\178\216\161</single>\n      <multiple>\216\163\216\172\216\178\216\167\216\161</multiple>\n    </term>\n    <term name=\"section\">\n      <single>\217\130\216\179\217\133</single>\n      <multiple>\216\163\217\130\216\179\216\167\217\133</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>\216\170\217\129\216\179\217\138\216\177 \217\129\216\177\216\185\217\138</single>\n      <multiple>\216\170\217\129\216\179\217\138\216\177\216\167\216\170 \217\129\216\177\216\185\217\138\216\169</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>\216\168\217\138\216\170 \216\180\216\185\216\177</single>\n      <multiple>\216\163\216\168\217\138\216\167\216\170 \216\180\216\185\216\177</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>\217\133\216\172\217\132\216\175</single>\n      <multiple>\217\133\216\172\217\132\216\175\216\167\216\170</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">\217\131\216\170\216\167\216\168</term>\n    <term name=\"chapter\" form=\"short\">\217\129\216\181\217\132</term>\n    <term name=\"column\" form=\"short\">\216\185\217\133\217\136\216\175</term>\n    <term name=\"figure\" form=\"short\">\216\177\216\179\217\133 \216\170\217\136\216\182\217\138\216\173\217\138</term>\n    <term name=\"folio\" form=\"short\">\217\133\216\183\217\136\217\138\216\169</term>\n    <term name=\"issue\" form=\"short\">\216\185\216\175\216\175</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">\217\134\217\136\216\170\216\169 \217\133\217\136\216\179\217\138\217\130\217\138\216\169</term>\n    <term name=\"page\" form=\"short\">\n      <single>\216\181</single>\n      <multiple>\216\181.\216\181.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">\217\129\217\130\216\177\216\169</term>\n    <term name=\"part\" form=\"short\">\216\172.</term>\n    <term name=\"section\" form=\"short\">\217\130\216\179\217\133</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>\216\170\217\129\216\179\217\138\216\177 \217\129\216\177\216\185\217\138</single>\n      <multiple>\216\170\217\129\216\179\217\138\216\177\216\167\216\170 \217\129\216\177\216\185\217\138\216\169</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>\216\168\217\138\216\170 \216\180\216\185\216\177</single>\n      <multiple>\216\163\216\168\217\138\216\167\216\170 \216\180\216\185\216\177</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>\217\133\216\172.</single>\n      <multiple>\217\133\216\172.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>\217\133\216\173\216\177\216\177</single>\n      <multiple>\217\133\216\173\216\177\216\177\217\138\217\134</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>\216\177\216\166\217\138\216\179 \216\167\217\132\216\170\216\173\216\177\217\138\216\177</single>\n      <multiple>\216\177\216\164\216\179\216\167\216\161 \216\167\217\132\216\170\216\173\216\177\217\138\216\177</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>\217\133\216\170\216\177\216\172\217\133</single>\n      <multiple>\217\133\216\170\216\177\216\172\217\133\217\138\217\134</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>\217\133\216\170\216\177\216\172\217\133 \217\136\217\133\216\173\216\177\216\177</single>\n      <multiple>\217\133\216\170\216\177\216\172\217\133\217\138\217\134 \217\136\217\133\216\173\216\177\216\177\217\138\217\134</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>\217\133\216\173\216\177\216\177</single>\n      <multiple>\217\133\216\173\216\177\216\177\217\138\217\134</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>\217\133\216\180\216\177\217\129 \216\185\217\132\217\137 \216\167\217\132\216\183\216\168\216\185\216\169</single>\n      <multiple>\217\133\216\180\216\177\217\129\217\138\217\134 \216\185\217\132\217\137 \216\167\217\132\216\183\216\168\216\185\216\169</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>\217\133\216\170\216\177\216\172\217\133</single>\n      <multiple>\217\133\216\170\216\177\216\172\217\133\217\138\217\134</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>\217\133\216\170\216\177\216\172\217\133 \217\136\217\133\216\180\216\177\217\129 \216\185\217\132\217\137 \216\167\217\132\216\183\216\168\216\167\216\185\217\135</single>\n      <multiple>\217\133\216\170\216\177\216\172\217\133\217\138\217\134 \217\136\217\133\216\180\216\177\217\129\217\138\217\134 \216\185\217\132\217\137 \216\167\217\132\216\183\216\168\216\167\216\185\217\135</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">\216\170\216\173\216\177\217\138\216\177</term>\n    <term name=\"editorial-director\" form=\"verb\">\216\167\216\185\216\175\216\167\216\175</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">\217\133\217\130\216\167\216\168\217\132\216\169 \216\168\217\136\216\167\216\179\216\183\216\169</term>\n    <term name=\"recipient\" form=\"verb\">\217\133\216\177\216\179\217\132 \216\167\217\132\217\137</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">\216\170\216\177\216\172\217\133\216\169</term>\n    <term name=\"editortranslator\" form=\"verb\">\216\167\216\185\216\175\216\167\216\175 \217\136\216\170\216\177\216\172\217\133\216\169</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\"/>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">\216\170\216\173\216\177\217\138\216\177</term>\n    <term name=\"editorial-director\" form=\"verb-short\">\216\167\216\180\216\177\217\129 \216\185\217\132\217\137 \216\167\217\132\216\183\216\168\216\185\216\169</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">\216\170\216\177\216\172\217\133\216\169</term>\n    <term name=\"editortranslator\" form=\"verb-short\">\216\170\216\177\216\172\217\133\217\135 \217\136\216\167\216\180\216\177\217\129 \216\185\217\132\217\137 \216\167\217\132\216\183\216\168\216\167\216\185\217\135</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">\217\138\217\134\216\167\217\138\216\177</term>\n    <term name=\"month-02\">\217\129\216\168\216\177\216\167\217\138\216\177</term>\n    <term name=\"month-03\">\217\133\216\167\216\177\216\179</term>\n    <term name=\"month-04\">\216\167\216\168\216\177\217\138\217\132</term>\n    <term name=\"month-05\">\217\133\216\167\217\138\217\136</term>\n    <term name=\"month-06\">\217\138\217\136\217\134\217\138\217\136</term>\n    <term name=\"month-07\">\217\138\217\136\217\132\217\138\217\136</term>\n    <term name=\"month-08\">\216\167\216\186\216\179\216\183\216\179</term>\n    <term name=\"month-09\">\216\179\216\168\216\170\217\133\216\168\216\177</term>\n    <term name=\"month-10\">\216\167\217\131\216\170\217\136\216\168\216\177</term>\n    <term name=\"month-11\">\217\134\217\136\217\129\217\133\216\168\216\177</term>\n    <term name=\"month-12\">\216\175\217\138\216\179\217\133\216\168\216\177</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">\217\138\217\134\216\167\217\138\216\177</term>\n    <term name=\"month-02\" form=\"short\">\217\129\216\168\216\177\216\167\217\138\216\177</term>\n    <term name=\"month-03\" form=\"short\">\217\133\216\167\216\177\216\179</term>\n    <term name=\"month-04\" form=\"short\">\216\167\216\168\216\177\217\138\217\132</term>\n    <term name=\"month-05\" form=\"short\">\217\133\216\167\217\138\217\136</term>\n    <term name=\"month-06\" form=\"short\">\217\138\217\136\217\134\217\138\217\136</term>\n    <term name=\"month-07\" form=\"short\">\217\138\217\136\217\132\217\138\217\136</term>\n    <term name=\"month-08\" form=\"short\">\216\167\216\186\216\179\216\183\216\179</term>\n    <term name=\"month-09\" form=\"short\">\216\179\216\168\216\170\217\133\216\168\216\177</term>\n    <term name=\"month-10\" form=\"short\">\216\167\217\131\216\170\217\136\216\168\216\177</term>\n    <term name=\"month-11\" form=\"short\">\217\134\217\136\217\129\217\133\216\168\216\177</term>\n    <term name=\"month-12\" form=\"short\">\216\175\217\138\216\179\217\133\216\168\216\177</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">\216\167\217\132\216\177\216\168\217\138\216\185</term>\n    <term name=\"season-02\">\216\167\217\132\216\181\217\138\217\129</term>\n    <term name=\"season-03\">\216\167\217\132\216\174\216\177\217\138\217\129</term>\n    <term name=\"season-04\">\216\167\217\132\216\180\216\170\216\167\216\161</term>\n  </terms>\n</locale>\n"),("locales-bg-BG.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"bg-BG\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\" \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\".\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\".\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">\208\190\209\130\208\178\208\190\209\128\208\181\208\189 \208\189\208\176</term>\n    <term name=\"and\">\208\184</term>\n    <term name=\"and others\">\208\184 \208\180\209\128\209\131\208\179\208\184</term>\n    <term name=\"anonymous\">\208\176\208\189\208\190\208\189\208\184\208\188\208\181\208\189</term>\n    <term name=\"anonymous\" form=\"short\">\208\176\208\189\208\190\208\189</term>\n    <term name=\"at\">\208\178</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">by</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">\209\134\208\184\209\130\208\184\209\128\208\176\208\189</term>\n    <term name=\"edition\">\n      <single>\208\184\208\183\208\180\208\176\208\189\208\184\208\181</single>\n      <multiple>\208\184\208\183\208\180\208\176\208\189\208\184\209\143</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">\208\184\208\183\208\180</term>\n    <term name=\"et-al\">\208\184 \209\129\209\138\208\176\208\178\209\130.</term>\n    <term name=\"forthcoming\">\208\191\209\128\208\181\208\180\209\129\209\130\208\190\209\143\209\137</term>\n    <term name=\"from\">\208\190\209\130</term>\n    <term name=\"ibid\">\208\191\208\176\208\186 \209\130\208\176\208\188</term>\n    <term name=\"in\">\208\178</term>\n    <term name=\"in press\">\208\191\208\190\208\180 \208\191\208\181\209\135\208\176\209\130</term>\n    <term name=\"internet\">\208\184\208\189\209\130\208\181\209\128\208\189\208\181\209\130</term>\n    <term name=\"interview\">\208\184\208\189\209\130\208\181\209\128\208\178\209\142</term>\n    <term name=\"letter\">\208\191\208\184\209\129\208\188\208\190</term>\n    <term name=\"no date\">no date</term>\n    <term name=\"no date\" form=\"short\">\208\177\208\181\208\183 \208\180\208\176\209\130\208\176</term>\n    <term name=\"online\">\208\190\208\189\208\187\208\176\208\185\208\189</term>\n    <term name=\"presented at\">\208\191\209\128\208\181\208\180\209\129\209\130\208\176\208\178\208\181\208\189 \208\189\208\176</term>\n    <term name=\"reference\">\n      <single>reference</single>\n      <multiple>references</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">\208\184\208\183\209\130\208\181\208\179\208\187\208\181\208\189 \208\189\208\176</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">AD</term>\n    <term name=\"bc\">BC</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\158</term>\n    <term name=\"close-quote\">\226\128\156</term>\n    <term name=\"open-inner-quote\">\226\128\158</term>\n    <term name=\"close-inner-quote\">\226\128\156</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">th</term>\n    <term name=\"ordinal-01\">st</term>\n    <term name=\"ordinal-02\">nd</term>\n    <term name=\"ordinal-03\">rd</term>\n    <term name=\"ordinal-11\">th</term>\n    <term name=\"ordinal-12\">th</term>\n    <term name=\"ordinal-13\">th</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">first</term>\n    <term name=\"long-ordinal-02\">second</term>\n    <term name=\"long-ordinal-03\">third</term>\n    <term name=\"long-ordinal-04\">fourth</term>\n    <term name=\"long-ordinal-05\">fifth</term>\n    <term name=\"long-ordinal-06\">sixth</term>\n    <term name=\"long-ordinal-07\">seventh</term>\n    <term name=\"long-ordinal-08\">eighth</term>\n    <term name=\"long-ordinal-09\">ninth</term>\n    <term name=\"long-ordinal-10\">tenth</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>\208\186\208\189\208\184\208\179\208\176</single>\n      <multiple>\208\186\208\189\208\184\208\179\208\184</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>\208\179\208\187\208\176\208\178\208\176</single>\n      <multiple>\208\179\208\187\208\176\208\178\208\184</multiple>\n    </term>\n    <term name=\"column\">\n      <single>\208\186\208\190\208\187\208\190\208\189\208\176</single>\n      <multiple>\208\186\208\190\208\187\208\190\208\189\208\184</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>\209\132\208\184\208\179\209\131\209\128\208\176</single>\n      <multiple>\209\132\208\184\208\179\209\131\209\128\208\184</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>\209\132\208\190\208\187\208\184\208\190</single>\n      <multiple>\209\132\208\190\208\187\208\184\209\143</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>\208\177\209\128\208\190\208\185</single>\n      <multiple>\208\177\209\128\208\190\208\181\208\178\208\181</multiple>\n    </term>\n    <term name=\"line\">\n      <single>\209\128\208\181\208\180</single>\n      <multiple>\209\128\208\181\208\180\208\190\208\178\208\181</multiple>\n    </term>\n    <term name=\"note\">\n      <single>\208\177\208\181\208\187\208\181\208\182\208\186\208\176</single>\n      <multiple>\208\177\208\181\208\187\208\181\208\182\208\186\208\184</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>\208\190\208\191\209\131\209\129</single>\n      <multiple>\208\190\208\191\209\131\209\129\208\184</multiple>\n    </term>\n    <term name=\"page\">\n      <single>\209\129\209\130\209\128\208\176\208\189\208\184\209\134\208\176</single>\n      <multiple>\209\129\209\130\209\128\208\176\208\189\208\184\209\134\208\184</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>\208\191\208\176\209\128\208\176\208\179\209\128\208\176\209\132</single>\n      <multiple>\208\191\208\176\209\128\208\176\208\179\209\128\208\176\209\132\208\184</multiple>\n    </term>\n    <term name=\"part\">\n      <single>\209\135\208\176\209\129\209\130</single>\n      <multiple>\209\135\208\176\209\129\209\130\208\184</multiple>\n    </term>\n    <term name=\"section\">\n      <single>\209\128\208\176\208\183\208\180\208\181\208\187</single>\n      <multiple>\209\128\208\176\208\183\208\180\208\181\208\187\208\184</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>\209\129\209\130\208\184\209\133</single>\n      <multiple>\209\129\209\130\208\184\209\133\208\190\208\178\208\181</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>\209\130\208\190\208\188</single>\n      <multiple>\209\130\208\190\208\188\208\190\208\178\208\181</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">\208\186\208\189</term>\n    <term name=\"chapter\" form=\"short\">\208\179\208\187</term>\n    <term name=\"column\" form=\"short\">\208\186\208\190\208\187</term>\n    <term name=\"figure\" form=\"short\">\209\132\208\184\208\179</term>\n    <term name=\"folio\" form=\"short\">\209\132\208\190\208\187</term>\n    <term name=\"issue\" form=\"short\">\208\177\209\128</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">\208\190\208\191</term>\n    <term name=\"page\" form=\"short\">\n      <single>\209\129</single>\n      <multiple>\209\129-\209\134\208\184</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">\208\191</term>\n    <term name=\"part\" form=\"short\">\209\135</term>\n    <term name=\"section\" form=\"short\">\209\128\208\176\208\183\208\180</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>\209\129\209\130</single>\n      <multiple>\209\129\209\130-\208\190\208\178\208\181</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>\209\130\208\190\208\188</single>\n      <multiple>\209\130-\208\190\208\178\208\181</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>\209\128\208\181\208\180\208\176\208\186\209\130\208\190\209\128</single>\n      <multiple>\209\128\208\181\208\180\208\176\208\186\209\130\208\190\209\128\208\184</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>\208\191\209\128\208\181\208\178\208\190\208\180\208\176\209\135</single>\n      <multiple>\208\191\209\128\208\181\208\178\208\190\208\180\208\176\209\135\208\184</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>editor &amp; translator</single>\n      <multiple>editors &amp; translators</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>\209\128\208\181\208\180</single>\n      <multiple>\209\128\208\181\208\180-\209\128\208\184</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ed.</single>\n      <multiple>eds.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>\208\191\209\128\208\181\208\178</single>\n      <multiple>\208\191\209\128\208\181\208\178-\209\135\208\184</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ed. &amp; tran.</single>\n      <multiple>eds. &amp; trans.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">\209\128\208\181\208\180\208\176\208\186\209\130\208\184\209\128\208\176\208\189 \208\190\209\130</term>\n    <term name=\"editorial-director\" form=\"verb\">edited by</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">\208\184\208\189\209\130\208\181\209\128\208\178\209\142\208\184\209\128\208\176\208\189 \208\190\209\130</term>\n    <term name=\"recipient\" form=\"verb\">\208\180\208\190</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">\208\191\209\128\208\181\208\178\208\181\208\180\208\181\208\189 \208\190\209\130</term>\n    <term name=\"editortranslator\" form=\"verb\">edited &amp; translated by</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">by</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">\209\128\208\181\208\180</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">\208\191\209\128\208\181\208\178</term>\n    <term name=\"editortranslator\" form=\"verb-short\">ed. &amp; trans. by</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">\208\175\208\189\209\131\208\176\209\128\208\184</term>\n    <term name=\"month-02\">\208\164\208\181\208\178\209\128\209\131\208\176\209\128\208\184</term>\n    <term name=\"month-03\">\208\156\208\176\209\128\209\130</term>\n    <term name=\"month-04\">\208\144\208\191\209\128\208\184\208\187</term>\n    <term name=\"month-05\">\208\156\208\176\208\185</term>\n    <term name=\"month-06\">\208\174\208\189\208\184</term>\n    <term name=\"month-07\">\208\174\208\187\208\184</term>\n    <term name=\"month-08\">\208\144\208\178\208\179\209\131\209\129\209\130</term>\n    <term name=\"month-09\">\208\161\208\181\208\191\209\130\208\181\208\188\208\178\209\128\208\184</term>\n    <term name=\"month-10\">\208\158\208\186\209\130\208\190\208\188\208\178\209\128\208\184</term>\n    <term name=\"month-11\">\208\157\208\190\208\181\208\188\208\178\209\128\208\184</term>\n    <term name=\"month-12\">\208\148\208\181\208\186\208\181\208\188\208\178\209\128\208\184</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">\208\175\208\189\209\131</term>\n    <term name=\"month-02\" form=\"short\">\208\164\208\181\208\178</term>\n    <term name=\"month-03\" form=\"short\">\208\156\208\176\209\128</term>\n    <term name=\"month-04\" form=\"short\">\208\144\208\191\209\128</term>\n    <term name=\"month-05\" form=\"short\">\208\156\208\176\208\185</term>\n    <term name=\"month-06\" form=\"short\">\208\174\208\189\208\184</term>\n    <term name=\"month-07\" form=\"short\">\208\174\208\187\208\184</term>\n    <term name=\"month-08\" form=\"short\">\208\144\208\178\208\179</term>\n    <term name=\"month-09\" form=\"short\">\208\161\208\181\208\191</term>\n    <term name=\"month-10\" form=\"short\">\208\158\208\186\209\130</term>\n    <term name=\"month-11\" form=\"short\">\208\157\208\190\208\181</term>\n    <term name=\"month-12\" form=\"short\">\208\148\208\181\208\186</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">Spring</term>\n    <term name=\"season-02\">Summer</term>\n    <term name=\"season-03\">Autumn</term>\n    <term name=\"season-04\">Winter</term>\n  </terms>\n</locale>\n"),("locales-ca-AD.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"ca-AD\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\" \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">accedit</term>\n    <term name=\"and\">i</term>\n    <term name=\"and others\">i altres</term>\n    <term name=\"anonymous\">an\195\178nim</term>\n    <term name=\"anonymous\" form=\"short\">an\195\178n.</term>\n    <term name=\"at\">a</term>\n    <term name=\"available at\">disponible a</term>\n    <term name=\"by\">per</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">citat</term>\n    <term name=\"edition\">\n      <single>edici\195\179</single>\n      <multiple>edicions</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">ed.</term>\n    <term name=\"et-al\">et al.</term>\n    <term name=\"forthcoming\">previst</term>\n    <term name=\"from\">de</term>\n    <term name=\"ibid\">ib\195\173d.</term>\n    <term name=\"in\">en</term>\n    <term name=\"in press\">en impremta</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">entrevista</term>\n    <term name=\"letter\">carta</term>\n    <term name=\"no date\">sense data</term>\n    <term name=\"no date\" form=\"short\">s.d.</term>\n    <term name=\"online\">en l\195\173nia</term>\n    <term name=\"presented at\">presentat a</term>\n    <term name=\"reference\">\n      <single>refer\195\168ncia</single>\n      <multiple>refer\195\168ncies</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>ref.</multiple>\n    </term>\n    <term name=\"retrieved\">recuperat</term>\n    <term name=\"scale\">escala</term>\n    <term name=\"version\">versi\195\179</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">dC</term>\n    <term name=\"bc\">aC</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\194\171</term>\n    <term name=\"close-quote\">\194\187</term>\n    <term name=\"open-inner-quote\">\226\128\156</term>\n    <term name=\"close-inner-quote\">\226\128\157</term>\n    <term name=\"page-range-delimiter\">-</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">a</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">primera</term>\n    <term name=\"long-ordinal-02\">segona</term>\n    <term name=\"long-ordinal-03\">tercera</term>\n    <term name=\"long-ordinal-04\">quarta</term>\n    <term name=\"long-ordinal-05\">cinquena</term>\n    <term name=\"long-ordinal-06\">sisena</term>\n    <term name=\"long-ordinal-07\">setena</term>\n    <term name=\"long-ordinal-08\">vuitena</term>\n    <term name=\"long-ordinal-09\">novena</term>\n    <term name=\"long-ordinal-10\">desena</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>llibre</single>\n      <multiple>llibres</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>cap\195\173tol</single>\n      <multiple>cap\195\173tols</multiple>\n    </term>\n    <term name=\"column\">\n      <single>columna</single>\n      <multiple>columnes</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>figura</single>\n      <multiple>figures</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>foli</single>\n      <multiple>folis</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>n\195\186mero</single>\n      <multiple>n\195\186meros</multiple>\n    </term>\n    <term name=\"line\">\n      <single>l\195\173nia</single>\n      <multiple>l\195\173nies</multiple>\n    </term>\n    <term name=\"note\">\n      <single>nota</single>\n      <multiple>notes</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>p\195\160gina</single>\n      <multiple>p\195\160gines</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>par\195\160graf</single>\n      <multiple>par\195\160grafs</multiple>\n    </term>\n    <term name=\"part\">\n      <single>part</single>\n      <multiple>parts</multiple>\n    </term>\n    <term name=\"section\">\n      <single>secci\195\179</single>\n      <multiple>seccions</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub voce</single>\n      <multiple>sub vocibus</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>vers</single>\n      <multiple>versos</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>volum</single>\n      <multiple>volums</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">llib.</term>\n    <term name=\"chapter\" form=\"short\">cap.</term>\n    <term name=\"column\" form=\"short\">col.</term>\n    <term name=\"figure\" form=\"short\">fig.</term>\n    <term name=\"folio\" form=\"short\">f.</term>\n    <term name=\"issue\" form=\"short\">n\195\186m.</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op.</term>\n    <term name=\"page\" form=\"short\">\n      <single>p.</single>\n      <multiple>p.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">par.</term>\n    <term name=\"part\" form=\"short\">pt.</term>\n    <term name=\"section\" form=\"short\">sec.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.v.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v.</single>\n      <multiple>v.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>vol.</single>\n      <multiple>vol.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>il\194\183lustrador</single>\n      <multiple>il\194\183lustradors</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>traductor</single>\n      <multiple>traductors</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>editor i traductor</single>\n      <multiple>editors i traductors</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dir.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>ed.</single>\n      <multiple>ed.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ed.</single>\n      <multiple>ed.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>il\194\183lust.</single>\n      <multiple>il\194\183lust.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>trad.</single>\n      <multiple>trad.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ed. i trad.</single>\n      <multiple>ed. i trad.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">dirigit per</term>\n    <term name=\"editor\" form=\"verb\">editat per</term>\n    <term name=\"editorial-director\" form=\"verb\">editat per</term>\n    <term name=\"illustrator\" form=\"verb\">il\194\183lustrat per</term>\n    <term name=\"interviewer\" form=\"verb\">entrevistat per</term>\n    <term name=\"recipient\" form=\"verb\">a</term>\n    <term name=\"reviewed-author\" form=\"verb\">per</term>\n    <term name=\"translator\" form=\"verb\">tradu\195\175t per</term>\n    <term name=\"editortranslator\" form=\"verb\">editat i tradu\195\175t per</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">per</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">ed.</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed.</term>\n    <term name=\"illustrator\" form=\"verb-short\">il\194\183lust.</term>\n    <term name=\"translator\" form=\"verb-short\">trad.</term>\n    <term name=\"editortranslator\" form=\"verb-short\">ed. i trad. per</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">gener</term>\n    <term name=\"month-02\">febrer</term>\n    <term name=\"month-03\">mar\195\167</term>\n    <term name=\"month-04\">abril</term>\n    <term name=\"month-05\">maig</term>\n    <term name=\"month-06\">juny</term>\n    <term name=\"month-07\">juliol</term>\n    <term name=\"month-08\">agost</term>\n    <term name=\"month-09\">setembre</term>\n    <term name=\"month-10\">octubre</term>\n    <term name=\"month-11\">novembre</term>\n    <term name=\"month-12\">desembre</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">gen.</term>\n    <term name=\"month-02\" form=\"short\">feb.</term>\n    <term name=\"month-03\" form=\"short\">mar\195\167</term>\n    <term name=\"month-04\" form=\"short\">abr.</term>\n    <term name=\"month-05\" form=\"short\">maig</term>\n    <term name=\"month-06\" form=\"short\">juny</term>\n    <term name=\"month-07\" form=\"short\">jul.</term>\n    <term name=\"month-08\" form=\"short\">ago.</term>\n    <term name=\"month-09\" form=\"short\">set.</term>\n    <term name=\"month-10\" form=\"short\">oct.</term>\n    <term name=\"month-11\" form=\"short\">nov.</term>\n    <term name=\"month-12\" form=\"short\">des.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">primavera</term>\n    <term name=\"season-02\">estiu</term>\n    <term name=\"season-03\">tardor</term>\n    <term name=\"season-04\">hivern</term>\n  </terms>\n</locale>\n"),("locales-cs-CZ.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"cs-CZ\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\". \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"year\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" prefix=\"-\" range-delimiter=\"/\"/>\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" prefix=\"-\" range-delimiter=\"/\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">p\197\153\195\173stup</term>\n    <term name=\"and\">a</term>\n    <term name=\"and others\">a dal\197\161\195\173</term>\n    <term name=\"anonymous\">anonymous</term>\n    <term name=\"anonymous\" form=\"short\">anon.</term>\n    <term name=\"at\">v</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">by</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">citov\195\161n</term>\n    <term name=\"edition\">\n      <single>vyd\195\161n\195\173</single>\n      <multiple>vyd\195\161n\195\173</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">vyd.</term>\n    <term name=\"et-al\">et al.</term>\n    <term name=\"forthcoming\">nadch\195\161zej\195\173c\195\173</term>\n    <term name=\"from\">z</term>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\">v</term>\n    <term name=\"in press\">v tisku</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">interview</term>\n    <term name=\"letter\">dopis</term>\n    <term name=\"no date\">bez data</term>\n    <term name=\"no date\" form=\"short\">nedatov\195\161no</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">prezentov\195\161n v</term>\n    <term name=\"reference\">\n      <single>reference</single>\n      <multiple>references</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">z\195\173sk\195\161no</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">n. l.</term>\n    <term name=\"bc\">p\197\153. n. l.</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\158</term>\n    <term name=\"close-quote\">\226\128\156</term>\n    <term name=\"open-inner-quote\">\226\128\154</term>\n    <term name=\"close-inner-quote\">\226\128\152</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">.</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">prvn\195\173</term>\n    <term name=\"long-ordinal-02\">druh\195\169</term>\n    <term name=\"long-ordinal-03\">t\197\153et\195\173</term>\n    <term name=\"long-ordinal-04\">\196\141tvrt\195\169</term>\n    <term name=\"long-ordinal-05\">p\195\161t\195\169</term>\n    <term name=\"long-ordinal-06\">\197\161est\195\169</term>\n    <term name=\"long-ordinal-07\">sedm\195\169</term>\n    <term name=\"long-ordinal-08\">osm\195\169</term>\n    <term name=\"long-ordinal-09\">dev\195\161t\195\169</term>\n    <term name=\"long-ordinal-10\">des\195\161t\195\169</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>kniha</single>\n      <multiple>knihy</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>kapitola</single>\n      <multiple>kapitoly</multiple>\n    </term>\n    <term name=\"column\">\n      <single>sloupec</single>\n      <multiple>sloupce</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>obr\195\161zek</single>\n      <multiple>obr\195\161zky</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>list</single>\n      <multiple>listy</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>\196\141\195\173slo</single>\n      <multiple>\196\141\195\173slo</multiple>\n    </term>\n    <term name=\"line\">\n      <single>\197\153\195\161dek</single>\n      <multiple>\197\153\195\161dky</multiple>\n    </term>\n    <term name=\"note\">\n      <single>pozn\195\161mka</single>\n      <multiple>pozn\195\161mky</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>strana</single>\n      <multiple>strany</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>odstavec</single>\n      <multiple>odstavce</multiple>\n    </term>\n    <term name=\"part\">\n      <single>\196\141\195\161st</single>\n      <multiple>\196\141\195\161sti</multiple>\n    </term>\n    <term name=\"section\">\n      <single>sekce</single>\n      <multiple>sekce</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>ver\197\161</single>\n      <multiple>ver\197\161e</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>ro\196\141n\195\173k</single>\n      <multiple>ro\196\141n\195\173ky</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">kn.</term>\n    <term name=\"chapter\" form=\"short\">kap.</term>\n    <term name=\"column\" form=\"short\">sl.</term>\n    <term name=\"figure\" form=\"short\">obr.</term>\n    <term name=\"folio\" form=\"short\">l.</term>\n    <term name=\"issue\" form=\"short\">\196\141\195\173s.</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op.</term>\n    <term name=\"page\" form=\"short\">\n      <single>s.</single>\n      <multiple>s.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">odst.</term>\n    <term name=\"part\" form=\"short\">\196\141.</term>\n    <term name=\"section\" form=\"short\">sek.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v.</single>\n      <multiple>v.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>ro\196\141.</single>\n      <multiple>ro\196\141.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>editor</single>\n      <multiple>edito\197\153i</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>p\197\153ekladatel</single>\n      <multiple>p\197\153ekladatel\195\169</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>editor a p\197\153ekladatel</single>\n      <multiple>edito\197\153i a p\197\153ekladatel\195\169</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>ed.</single>\n      <multiple>ed.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ed.</single>\n      <multiple>ed.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>p\197\153ekl.</single>\n      <multiple>p\197\153ekl.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ed. a p\197\153ekl.</single>\n      <multiple>ed. a p\197\153ekl.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">editoval</term>\n    <term name=\"editorial-director\" form=\"verb\">editoval</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">rozhovor vedl</term>\n    <term name=\"recipient\" form=\"verb\">pro</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">p\197\153elo\197\190il</term>\n    <term name=\"editortranslator\" form=\"verb\">editoval a p\197\153elo\197\190il</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">by</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">ed.</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">p\197\153ekl.</term>\n    <term name=\"editortranslator\" form=\"verb-short\">ed. a p\197\153el.</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">leden</term>\n    <term name=\"month-02\">\195\186nor</term>\n    <term name=\"month-03\">b\197\153ezen</term>\n    <term name=\"month-04\">duben</term>\n    <term name=\"month-05\">kv\196\155ten</term>\n    <term name=\"month-06\">\196\141erven</term>\n    <term name=\"month-07\">\196\141ervenec</term>\n    <term name=\"month-08\">srpen</term>\n    <term name=\"month-09\">z\195\161\197\153\195\173</term>\n    <term name=\"month-10\">\197\153\195\173jen</term>\n    <term name=\"month-11\">listopad</term>\n    <term name=\"month-12\">prosinec</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">led.</term>\n    <term name=\"month-02\" form=\"short\">\195\186no.</term>\n    <term name=\"month-03\" form=\"short\">b\197\153e.</term>\n    <term name=\"month-04\" form=\"short\">dub.</term>\n    <term name=\"month-05\" form=\"short\">kv\196\155.</term>\n    <term name=\"month-06\" form=\"short\">\196\141er.</term>\n    <term name=\"month-07\" form=\"short\">\196\141vc.</term>\n    <term name=\"month-08\" form=\"short\">srp.</term>\n    <term name=\"month-09\" form=\"short\">z\195\161\197\153.</term>\n    <term name=\"month-10\" form=\"short\">\197\153\195\173j.</term>\n    <term name=\"month-11\" form=\"short\">lis.</term>\n    <term name=\"month-12\" form=\"short\">pro.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">jaro</term>\n    <term name=\"season-02\">l\195\169to</term>\n    <term name=\"season-03\">podzim</term>\n    <term name=\"season-04\">zima</term>\n  </terms>\n</locale>\n"),("locales-da-DK.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"da-DK\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\". \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\"-\" range-delimiter=\"/\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\"-\" range-delimiter=\"/\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">\195\165bnet</term>\n    <term name=\"and\">og</term>\n    <term name=\"and others\">med flere</term>\n    <term name=\"anonymous\">anonym</term>\n    <term name=\"anonymous\" form=\"short\">anon.</term>\n    <term name=\"at\">p\195\165</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">af</term>\n    <term name=\"circa\">cirka</term>\n    <term name=\"circa\" form=\"short\">ca.</term>\n    <term name=\"cited\">citeret</term>\n    <term name=\"edition\">\n      <single>udgave</single>\n      <multiple>udgaver</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">udg.</term>\n    <term name=\"et-al\">et al.</term>\n    <term name=\"forthcoming\">kommende</term>\n    <term name=\"from\">fra</term>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\">i</term>\n    <term name=\"in press\">i tryk</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">interview</term>\n    <term name=\"letter\">brev</term>\n    <term name=\"no date\">ingen dato</term>\n    <term name=\"no date\" form=\"short\">udateret</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">pr\195\166senteret ved</term>\n    <term name=\"reference\">\n      <single>reference</single>\n      <multiple>referencer</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refr.</multiple>\n    </term>\n    <term name=\"retrieved\">hentet</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">e.Kr</term>\n    <term name=\"bc\">f.Kr</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\194\171</term>\n    <term name=\"close-quote\">\194\187</term>\n    <term name=\"open-inner-quote\">\226\128\152</term>\n    <term name=\"close-inner-quote\">\226\128\153</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">.</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">f\195\184rste</term>\n    <term name=\"long-ordinal-02\">anden</term>\n    <term name=\"long-ordinal-03\">tredje</term>\n    <term name=\"long-ordinal-04\">fjerde</term>\n    <term name=\"long-ordinal-05\">femte</term>\n    <term name=\"long-ordinal-06\">sjette</term>\n    <term name=\"long-ordinal-07\">syvende</term>\n    <term name=\"long-ordinal-08\">ottende</term>\n    <term name=\"long-ordinal-09\">niende</term>\n    <term name=\"long-ordinal-10\">tiende</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>bog</single>\n      <multiple>b\195\184ger</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>kapitel</single>\n      <multiple>kapitler</multiple>\n    </term>\n    <term name=\"column\">\n      <single>kolonne</single>\n      <multiple>kolonner</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>figur</single>\n      <multiple>figurer</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folio</single>\n      <multiple>folier</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>nummer</single>\n      <multiple>numre</multiple>\n    </term>\n    <term name=\"line\">\n      <single>linje</single>\n      <multiple>linjer</multiple>\n    </term>\n    <term name=\"note\">\n      <single>note</single>\n      <multiple>noter</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opuser</multiple>\n    </term>\n    <term name=\"page\">\n      <single>side</single>\n      <multiple>sider</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>afsnit</single>\n      <multiple>afsnit</multiple>\n    </term>\n    <term name=\"part\">\n      <single>del</single>\n      <multiple>dele</multiple>\n    </term>\n    <term name=\"section\">\n      <single>sektion</single>\n      <multiple>sektionerne</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>vers</single>\n      <multiple>vers</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>bind</single>\n      <multiple>bind</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">b.</term>\n    <term name=\"chapter\" form=\"short\">kap.</term>\n    <term name=\"column\" form=\"short\">kol.</term>\n    <term name=\"figure\" form=\"short\">fig.</term>\n    <term name=\"folio\" form=\"short\">fol.</term>\n    <term name=\"issue\" form=\"short\">nr.</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op.</term>\n    <term name=\"page\" form=\"short\">\n      <single>s.</single>\n      <multiple>s.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">afs.</term>\n    <term name=\"part\" form=\"short\">d.</term>\n    <term name=\"section\" form=\"short\">sekt.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v.</single>\n      <multiple>v.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>bd.</single>\n      <multiple>bd.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>redakt\195\184r</single>\n      <multiple>redakt\195\184rer</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>redakt\195\184r</single>\n      <multiple>redakt\195\184rer</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>overs\195\166tter</single>\n      <multiple>overs\195\166ttere</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>redakt\195\184r &amp; overs\195\166tter</single>\n      <multiple>redakt\195\184rer &amp; overs\195\166ttere</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>red.</single>\n      <multiple>red.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>red.</single>\n      <multiple>red.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>overs.</single>\n      <multiple>overs.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>red. &amp; overs.</single>\n      <multiple>red. &amp; overs.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">redigeret af</term>\n    <term name=\"editorial-director\" form=\"verb\">redigeret af</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">interviewet af</term>\n    <term name=\"recipient\" form=\"verb\">modtaget af</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">oversat af</term>\n    <term name=\"editortranslator\" form=\"verb\">redigeret &amp; oversat af</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">af</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">red.</term>\n    <term name=\"editorial-director\" form=\"verb-short\">red.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">overs.</term>\n    <term name=\"editortranslator\" form=\"verb-short\">red. &amp; overs. af</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">Januar</term>\n    <term name=\"month-02\">Februar</term>\n    <term name=\"month-03\">Marts</term>\n    <term name=\"month-04\">April</term>\n    <term name=\"month-05\">Maj</term>\n    <term name=\"month-06\">Juni</term>\n    <term name=\"month-07\">Juli</term>\n    <term name=\"month-08\">August</term>\n    <term name=\"month-09\">September</term>\n    <term name=\"month-10\">Oktober</term>\n    <term name=\"month-11\">November</term>\n    <term name=\"month-12\">December</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">Jan.</term>\n    <term name=\"month-02\" form=\"short\">Feb.</term>\n    <term name=\"month-03\" form=\"short\">Mar.</term>\n    <term name=\"month-04\" form=\"short\">Apr.</term>\n    <term name=\"month-05\" form=\"short\">Maj</term>\n    <term name=\"month-06\" form=\"short\">Jun.</term>\n    <term name=\"month-07\" form=\"short\">Jul.</term>\n    <term name=\"month-08\" form=\"short\">Aug.</term>\n    <term name=\"month-09\" form=\"short\">Sep.</term>\n    <term name=\"month-10\" form=\"short\">Okt.</term>\n    <term name=\"month-11\" form=\"short\">Nov.</term>\n    <term name=\"month-12\" form=\"short\">Dec.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">For\195\165r</term>\n    <term name=\"season-02\">Sommer</term>\n    <term name=\"season-03\">Efter\195\165r</term>\n    <term name=\"season-04\">vinter</term>\n  </terms>\n</locale>\n"),("locales-de-AT.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"de-AT\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\". \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\".\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\".\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">zugegriffen</term>\n    <term name=\"and\">und</term>\n    <term name=\"and others\">und andere</term>\n    <term name=\"anonymous\">ohne Autor</term>\n    <term name=\"anonymous\" form=\"short\">o. A.</term>\n    <term name=\"at\">auf</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">von</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">ca.</term>\n    <term name=\"cited\">zitiert</term>\n    <term name=\"edition\">\n      <single>Auflage</single>\n      <multiple>Auflagen</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">Aufl.</term>\n    <term name=\"et-al\">u. a.</term>\n    <term name=\"forthcoming\">i. E.</term>\n    <term name=\"from\">von</term>\n    <term name=\"ibid\">ebd.</term>\n    <term name=\"in\">in</term>\n    <term name=\"in press\">im Druck</term>\n    <term name=\"internet\">Internet</term>\n    <term name=\"interview\">Interview</term>\n    <term name=\"letter\">Brief</term>\n    <term name=\"no date\">ohne Datum</term>\n    <term name=\"no date\" form=\"short\">o. J.</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">gehalten auf der</term>\n    <term name=\"reference\">\n      <single>Referenz</single>\n      <multiple>Referenzen</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>Ref.</single>\n      <multiple>Ref.</multiple>\n    </term>\n    <term name=\"retrieved\">abgerufen</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">n. Chr.</term>\n    <term name=\"bc\">v. Chr.</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\158</term>\n    <term name=\"close-quote\">\226\128\156</term>\n    <term name=\"open-inner-quote\">\226\128\154</term>\n    <term name=\"close-inner-quote\">\226\128\152</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">.</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">erster</term>\n    <term name=\"long-ordinal-02\">zweiter</term>\n    <term name=\"long-ordinal-03\">dritter</term>\n    <term name=\"long-ordinal-04\">vierter</term>\n    <term name=\"long-ordinal-05\">f\195\188nfter</term>\n    <term name=\"long-ordinal-06\">sechster</term>\n    <term name=\"long-ordinal-07\">siebter</term>\n    <term name=\"long-ordinal-08\">achter</term>\n    <term name=\"long-ordinal-09\">neunter</term>\n    <term name=\"long-ordinal-10\">zehnter</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>Buch</single>\n      <multiple>B\195\188cher</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>Kapitel</single>\n      <multiple>Kapitel</multiple>\n    </term>\n    <term name=\"column\">\n      <single>Spalte</single>\n      <multiple>Spalten</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>Abbildung</single>\n      <multiple>Abbildungen</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>Blatt</single>\n      <multiple>Bl\195\164tter</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>Nummer</single>\n      <multiple>Nummern</multiple>\n    </term>\n    <term name=\"line\">\n      <single>Zeile</single>\n      <multiple>Zeilen</multiple>\n    </term>\n    <term name=\"note\">\n      <single>Note</single>\n      <multiple>Noten</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>Opus</single>\n      <multiple>Opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>Seite</single>\n      <multiple>Seiten</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>Absatz</single>\n      <multiple>Abs\195\164tze</multiple>\n    </term>\n    <term name=\"part\">\n      <single>Teil</single>\n      <multiple>Teile</multiple>\n    </term>\n    <term name=\"section\">\n      <single>Abschnitt</single>\n      <multiple>Abschnitte</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>Vers</single>\n      <multiple>Verse</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>Band</single>\n      <multiple>B\195\164nde</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">B.</term>\n    <term name=\"chapter\" form=\"short\">Kap.</term>\n    <term name=\"column\" form=\"short\">Sp.</term>\n    <term name=\"figure\" form=\"short\">Abb.</term>\n    <term name=\"folio\" form=\"short\">Fol.</term>\n    <term name=\"issue\" form=\"short\">Nr.</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op.</term>\n    <term name=\"page\" form=\"short\">\n      <single>S.</single>\n      <multiple>S.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">Abs.</term>\n    <term name=\"part\" form=\"short\">Teil</term>\n    <term name=\"section\" form=\"short\">Abschn.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>V.</single>\n      <multiple>V.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>Bd.</single>\n      <multiple>Bd.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>Herausgeber</single>\n      <multiple>Herausgeber</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>Herausgeber</single>\n      <multiple>Herausgeber</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>\195\156bersetzer</single>\n      <multiple>\195\156bersetzer</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>Herausgeber &amp; \195\156bersetzer</single>\n      <multiple>Herausgeber &amp; \195\156bersetzer</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>Hrsg.</single>\n      <multiple>Hrsg.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>Hrsg.</single>\n      <multiple>Hrsg.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>\195\156bers.</single>\n      <multiple>\195\156bers.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>Hrsg. &amp; \195\156bers.</single>\n      <multiple>Hrsg. &amp; \195\156bers</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">herausgegeben von</term>\n    <term name=\"editorial-director\" form=\"verb\">herausgegeben von</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">interviewt von</term>\n    <term name=\"recipient\" form=\"verb\">an</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">\195\188bersetzt von</term>\n    <term name=\"editortranslator\" form=\"verb\">herausgegeben und \195\188bersetzt von</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">von</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">hg. von</term>\n    <term name=\"editorial-director\" form=\"verb-short\">hg. von</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">\195\188bers. von</term>\n    <term name=\"editortranslator\" form=\"verb-short\">hg. &amp; \195\188bers. von</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">Januar</term>\n    <term name=\"month-02\">Februar</term>\n    <term name=\"month-03\">M\195\164rz</term>\n    <term name=\"month-04\">April</term>\n    <term name=\"month-05\">Mai</term>\n    <term name=\"month-06\">Juni</term>\n    <term name=\"month-07\">Juli</term>\n    <term name=\"month-08\">August</term>\n    <term name=\"month-09\">September</term>\n    <term name=\"month-10\">Oktober</term>\n    <term name=\"month-11\">November</term>\n    <term name=\"month-12\">Dezember</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">Jan.</term>\n    <term name=\"month-02\" form=\"short\">Feb.</term>\n    <term name=\"month-03\" form=\"short\">M\195\164rz</term>\n    <term name=\"month-04\" form=\"short\">Apr.</term>\n    <term name=\"month-05\" form=\"short\">Mai</term>\n    <term name=\"month-06\" form=\"short\">Juni</term>\n    <term name=\"month-07\" form=\"short\">Juli</term>\n    <term name=\"month-08\" form=\"short\">Aug.</term>\n    <term name=\"month-09\" form=\"short\">Sep.</term>\n    <term name=\"month-10\" form=\"short\">Okt.</term>\n    <term name=\"month-11\" form=\"short\">Nov.</term>\n    <term name=\"month-12\" form=\"short\">Dez.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">Fr\195\188hjahr</term>\n    <term name=\"season-02\">Sommer</term>\n    <term name=\"season-03\">Herbst</term>\n    <term name=\"season-04\">Winter</term>\n  </terms>\n</locale>\n"),("locales-de-CH.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"de-CH\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\". \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\".\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\".\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">zugegriffen</term>\n    <term name=\"and\">und</term>\n    <term name=\"and others\">und andere</term>\n    <term name=\"anonymous\">ohne Autor</term>\n    <term name=\"anonymous\" form=\"short\">o. A.</term>\n    <term name=\"at\">auf</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">von</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">ca.</term>\n    <term name=\"cited\">zitiert</term>\n    <term name=\"edition\">\n      <single>Auflage</single>\n      <multiple>Auflagen</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">Aufl.</term>\n    <term name=\"et-al\">u. a.</term>\n    <term name=\"forthcoming\">i. E.</term>\n    <term name=\"from\">von</term>\n    <term name=\"ibid\">ebd.</term>\n    <term name=\"in\">in</term>\n    <term name=\"in press\">im Druck</term>\n    <term name=\"internet\">Internet</term>\n    <term name=\"interview\">Interview</term>\n    <term name=\"letter\">Brief</term>\n    <term name=\"no date\">ohne Datum</term>\n    <term name=\"no date\" form=\"short\">o. J.</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">gehalten auf der</term>\n    <term name=\"reference\">\n      <single>Referenz</single>\n      <multiple>Referenzen</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>Ref.</single>\n      <multiple>Ref.</multiple>\n    </term>\n    <term name=\"retrieved\">abgerufen</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">n. Chr.</term>\n    <term name=\"bc\">v. Chr.</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\158</term>\n    <term name=\"close-quote\">\226\128\156</term>\n    <term name=\"open-inner-quote\">\226\128\154</term>\n    <term name=\"close-inner-quote\">\226\128\152</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">.</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">erster</term>\n    <term name=\"long-ordinal-02\">zweiter</term>\n    <term name=\"long-ordinal-03\">dritter</term>\n    <term name=\"long-ordinal-04\">vierter</term>\n    <term name=\"long-ordinal-05\">f\195\188nfter</term>\n    <term name=\"long-ordinal-06\">sechster</term>\n    <term name=\"long-ordinal-07\">siebter</term>\n    <term name=\"long-ordinal-08\">achter</term>\n    <term name=\"long-ordinal-09\">neunter</term>\n    <term name=\"long-ordinal-10\">zehnter</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>Buch</single>\n      <multiple>B\195\188cher</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>Kapitel</single>\n      <multiple>Kapitel</multiple>\n    </term>\n    <term name=\"column\">\n      <single>Spalte</single>\n      <multiple>Spalten</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>Abbildung</single>\n      <multiple>Abbildungen</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>Blatt</single>\n      <multiple>Bl\195\164tter</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>Nummer</single>\n      <multiple>Nummern</multiple>\n    </term>\n    <term name=\"line\">\n      <single>Zeile</single>\n      <multiple>Zeilen</multiple>\n    </term>\n    <term name=\"note\">\n      <single>Note</single>\n      <multiple>Noten</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>Opus</single>\n      <multiple>Opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>Seite</single>\n      <multiple>Seiten</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>Absatz</single>\n      <multiple>Abs\195\164tze</multiple>\n    </term>\n    <term name=\"part\">\n      <single>Teil</single>\n      <multiple>Teile</multiple>\n    </term>\n    <term name=\"section\">\n      <single>Abschnitt</single>\n      <multiple>Abschnitte</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>Vers</single>\n      <multiple>Verse</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>Band</single>\n      <multiple>B\195\164nde</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">B.</term>\n    <term name=\"chapter\" form=\"short\">Kap.</term>\n    <term name=\"column\" form=\"short\">Sp.</term>\n    <term name=\"figure\" form=\"short\">Abb.</term>\n    <term name=\"folio\" form=\"short\">Fol.</term>\n    <term name=\"issue\" form=\"short\">Nr.</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op.</term>\n    <term name=\"page\" form=\"short\">\n      <single>S.</single>\n      <multiple>S.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">Abs.</term>\n    <term name=\"part\" form=\"short\">Teil</term>\n    <term name=\"section\" form=\"short\">Abschn.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>V.</single>\n      <multiple>V.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>Bd.</single>\n      <multiple>Bd.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>Herausgeber</single>\n      <multiple>Herausgeber</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>Herausgeber</single>\n      <multiple>Herausgeber</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>\195\156bersetzer</single>\n      <multiple>\195\156bersetzer</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>Herausgeber &amp; \195\156bersetzer</single>\n      <multiple>Herausgeber &amp; \195\156bersetzer</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>Hrsg.</single>\n      <multiple>Hrsg.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>Hrsg.</single>\n      <multiple>Hrsg.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>\195\156bers.</single>\n      <multiple>\195\156bers.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>Hrsg. &amp; \195\156bers.</single>\n      <multiple>Hrsg. &amp; \195\156bers</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">herausgegeben von</term>\n    <term name=\"editorial-director\" form=\"verb\">herausgegeben von</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">interviewt von</term>\n    <term name=\"recipient\" form=\"verb\">an</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">\195\188bersetzt von</term>\n    <term name=\"editortranslator\" form=\"verb\">herausgegeben und \195\188bersetzt von</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">von</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">hg. von</term>\n    <term name=\"editorial-director\" form=\"verb-short\">hg. von</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">\195\188bers. von</term>\n    <term name=\"editortranslator\" form=\"verb-short\">hg. &amp; \195\188bers. von</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">Januar</term>\n    <term name=\"month-02\">Februar</term>\n    <term name=\"month-03\">M\195\164rz</term>\n    <term name=\"month-04\">April</term>\n    <term name=\"month-05\">Mai</term>\n    <term name=\"month-06\">Juni</term>\n    <term name=\"month-07\">Juli</term>\n    <term name=\"month-08\">August</term>\n    <term name=\"month-09\">September</term>\n    <term name=\"month-10\">Oktober</term>\n    <term name=\"month-11\">November</term>\n    <term name=\"month-12\">Dezember</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">Jan.</term>\n    <term name=\"month-02\" form=\"short\">Feb.</term>\n    <term name=\"month-03\" form=\"short\">M\195\164rz</term>\n    <term name=\"month-04\" form=\"short\">Apr.</term>\n    <term name=\"month-05\" form=\"short\">Mai</term>\n    <term name=\"month-06\" form=\"short\">Juni</term>\n    <term name=\"month-07\" form=\"short\">Juli</term>\n    <term name=\"month-08\" form=\"short\">Aug.</term>\n    <term name=\"month-09\" form=\"short\">Sep.</term>\n    <term name=\"month-10\" form=\"short\">Okt.</term>\n    <term name=\"month-11\" form=\"short\">Nov.</term>\n    <term name=\"month-12\" form=\"short\">Dez.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">Fr\195\188hjahr</term>\n    <term name=\"season-02\">Sommer</term>\n    <term name=\"season-03\">Herbst</term>\n    <term name=\"season-04\">Winter</term>\n  </terms>\n</locale>\n"),("locales-de-DE.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"de-DE\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\". \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\".\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\".\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">zugegriffen</term>\n    <term name=\"and\">und</term>\n    <term name=\"and others\">und andere</term>\n    <term name=\"anonymous\">ohne Autor</term>\n    <term name=\"anonymous\" form=\"short\">o. A.</term>\n    <term name=\"at\">auf</term>\n    <term name=\"available at\">verf\195\188gbar unter</term>\n    <term name=\"by\">von</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">ca.</term>\n    <term name=\"cited\">zitiert</term>\n    <term name=\"edition\">\n      <single>Auflage</single>\n      <multiple>Auflagen</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">Aufl.</term>\n    <term name=\"et-al\">u. a.</term>\n    <term name=\"forthcoming\">i. E.</term>\n    <term name=\"from\">von</term>\n    <term name=\"ibid\">ebd.</term>\n    <term name=\"in\">in</term>\n    <term name=\"in press\">im Druck</term>\n    <term name=\"internet\">Internet</term>\n    <term name=\"interview\">Interview</term>\n    <term name=\"letter\">Brief</term>\n    <term name=\"no date\">ohne Datum</term>\n    <term name=\"no date\" form=\"short\">o. J.</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">gehalten auf der</term>\n    <term name=\"reference\">\n      <single>Referenz</single>\n      <multiple>Referenzen</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>Ref.</single>\n      <multiple>Ref.</multiple>\n    </term>\n    <term name=\"retrieved\">abgerufen</term>\n    <term name=\"scale\">Ma\195\159stab</term>\n    <term name=\"version\">Version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">n. Chr.</term>\n    <term name=\"bc\">v. Chr.</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\158</term>\n    <term name=\"close-quote\">\226\128\156</term>\n    <term name=\"open-inner-quote\">\226\128\154</term>\n    <term name=\"close-inner-quote\">\226\128\152</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">.</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">erster</term>\n    <term name=\"long-ordinal-02\">zweiter</term>\n    <term name=\"long-ordinal-03\">dritter</term>\n    <term name=\"long-ordinal-04\">vierter</term>\n    <term name=\"long-ordinal-05\">f\195\188nfter</term>\n    <term name=\"long-ordinal-06\">sechster</term>\n    <term name=\"long-ordinal-07\">siebter</term>\n    <term name=\"long-ordinal-08\">achter</term>\n    <term name=\"long-ordinal-09\">neunter</term>\n    <term name=\"long-ordinal-10\">zehnter</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>Buch</single>\n      <multiple>B\195\188cher</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>Kapitel</single>\n      <multiple>Kapitel</multiple>\n    </term>\n    <term name=\"column\">\n      <single>Spalte</single>\n      <multiple>Spalten</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>Abbildung</single>\n      <multiple>Abbildungen</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>Blatt</single>\n      <multiple>Bl\195\164tter</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>Nummer</single>\n      <multiple>Nummern</multiple>\n    </term>\n    <term name=\"line\">\n      <single>Zeile</single>\n      <multiple>Zeilen</multiple>\n    </term>\n    <term name=\"note\">\n      <single>Note</single>\n      <multiple>Noten</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>Opus</single>\n      <multiple>Opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>Seite</single>\n      <multiple>Seiten</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>Absatz</single>\n      <multiple>Abs\195\164tze</multiple>\n    </term>\n    <term name=\"part\">\n      <single>Teil</single>\n      <multiple>Teile</multiple>\n    </term>\n    <term name=\"section\">\n      <single>Abschnitt</single>\n      <multiple>Abschnitte</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>Vers</single>\n      <multiple>Verse</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>Band</single>\n      <multiple>B\195\164nde</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">B.</term>\n    <term name=\"chapter\" form=\"short\">Kap.</term>\n    <term name=\"column\" form=\"short\">Sp.</term>\n    <term name=\"figure\" form=\"short\">Abb.</term>\n    <term name=\"folio\" form=\"short\">Fol.</term>\n    <term name=\"issue\" form=\"short\">Nr.</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op.</term>\n    <term name=\"page\" form=\"short\">\n      <single>S.</single>\n      <multiple>S.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">Abs.</term>\n    <term name=\"part\" form=\"short\">Teil</term>\n    <term name=\"section\" form=\"short\">Abschn.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>V.</single>\n      <multiple>V.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>Bd.</single>\n      <multiple>Bd.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>Regisseur</single>\n      <multiple>Regisseure</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>Herausgeber</single>\n      <multiple>Herausgeber</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>Herausgeber</single>\n      <multiple>Herausgeber</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>Illustrator</single>\n      <multiple>illustratoren</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>\195\156bersetzer</single>\n      <multiple>\195\156bersetzer</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>Herausgeber &amp; \195\156bersetzer</single>\n      <multiple>Herausgeber &amp; \195\156bersetzer</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>Reg.</single>\n      <multiple>Reg..</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>Hrsg.</single>\n      <multiple>Hrsg.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>Hrsg.</single>\n      <multiple>Hrsg.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>Ill.</single>\n      <multiple>Ill.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>\195\156bers.</single>\n      <multiple>\195\156bers.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>Hrsg. &amp; \195\156bers.</single>\n      <multiple>Hrsg. &amp; \195\156bers</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">herausgegeben von</term>\n    <term name=\"editorial-director\" form=\"verb\">herausgegeben von</term>\n    <term name=\"illustrator\" form=\"verb\">illustriert von</term>\n    <term name=\"interviewer\" form=\"verb\">interviewt von</term>\n    <term name=\"recipient\" form=\"verb\">an</term>\n    <term name=\"reviewed-author\" form=\"verb\">von</term>\n    <term name=\"translator\" form=\"verb\">\195\188bersetzt von</term>\n    <term name=\"editortranslator\" form=\"verb\">herausgegeben und \195\188bersetzt von</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">von</term>\n    <term name=\"director\" form=\"verb-short\">Reg.</term>\n    <term name=\"editor\" form=\"verb-short\">hg. von</term>\n    <term name=\"editorial-director\" form=\"verb-short\">hg. von</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus. von</term>\n    <term name=\"translator\" form=\"verb-short\">\195\188bers. von</term>\n    <term name=\"editortranslator\" form=\"verb-short\">hg. &amp; \195\188bers. von</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">Januar</term>\n    <term name=\"month-02\">Februar</term>\n    <term name=\"month-03\">M\195\164rz</term>\n    <term name=\"month-04\">April</term>\n    <term name=\"month-05\">Mai</term>\n    <term name=\"month-06\">Juni</term>\n    <term name=\"month-07\">Juli</term>\n    <term name=\"month-08\">August</term>\n    <term name=\"month-09\">September</term>\n    <term name=\"month-10\">Oktober</term>\n    <term name=\"month-11\">November</term>\n    <term name=\"month-12\">Dezember</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">Jan.</term>\n    <term name=\"month-02\" form=\"short\">Feb.</term>\n    <term name=\"month-03\" form=\"short\">M\195\164rz</term>\n    <term name=\"month-04\" form=\"short\">Apr.</term>\n    <term name=\"month-05\" form=\"short\">Mai</term>\n    <term name=\"month-06\" form=\"short\">Juni</term>\n    <term name=\"month-07\" form=\"short\">Juli</term>\n    <term name=\"month-08\" form=\"short\">Aug.</term>\n    <term name=\"month-09\" form=\"short\">Sep.</term>\n    <term name=\"month-10\" form=\"short\">Okt.</term>\n    <term name=\"month-11\" form=\"short\">Nov.</term>\n    <term name=\"month-12\" form=\"short\">Dez.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">Fr\195\188hjahr</term>\n    <term name=\"season-02\">Sommer</term>\n    <term name=\"season-03\">Herbst</term>\n    <term name=\"season-04\">Winter</term>\n  </terms>\n</locale>\n"),("locales-el-GR.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"el-GR\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\" \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">\206\183\206\188\206\181\207\129\206\191\206\188\206\183\206\189\206\175\206\177 \207\128\207\129\207\140\207\131\206\178\206\177\207\131\206\183\207\130</term>\n    <term name=\"and\">\206\186\206\177\206\185</term>\n    <term name=\"and others\">\206\186\206\177\206\185 \206\172\206\187\206\187\206\191\206\185</term>\n    <term name=\"anonymous\">\206\177\206\189\207\142\206\189\207\133\206\188\206\191</term>\n    <term name=\"anonymous\" form=\"short\">\206\177\206\189\207\142\206\189.</term>\n    <term name=\"at\">\206\181\207\134.</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">\206\177\207\128\207\140</term>\n    <term name=\"circa\">\207\128\206\181\207\129\206\175\207\128\206\191\207\133</term>\n    <term name=\"circa\" form=\"short\">\207\128\206\181\207\129.</term>\n    <term name=\"cited\">\207\128\206\177\207\129\206\177\207\132\206\175\206\184\206\181\207\132\206\177\206\185</term>\n    <term name=\"edition\">\n      <single>\206\173\206\186\206\180\206\191\207\131\206\183</single>\n      <multiple>\206\181\206\186\206\180\207\140\207\131\206\181\206\185\207\130</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">\206\173\206\186\206\180.</term>\n    <term name=\"et-al\">\206\186.\206\172.</term>\n    <term name=\"forthcoming\">\207\128\207\129\206\191\207\131\206\181\207\135\206\173\207\130</term>\n    <term name=\"from\">\206\177\207\128\207\140</term>\n    <term name=\"ibid\">\207\131\207\132\206\191 \206\175\206\180\206\185\206\191</term>\n    <term name=\"in\">\207\131\207\132\206\191</term>\n    <term name=\"in press\">\207\133\207\128\207\140 \206\173\206\186\206\180\206\191\207\131\206\183</term>\n    <term name=\"internet\">\206\180\206\185\206\177\206\180\206\175\206\186\207\132\207\133\206\191</term>\n    <term name=\"interview\">\207\131\207\133\206\189\206\173\206\189\207\132\206\181\207\133\206\190\206\183</term>\n    <term name=\"letter\">\206\181\207\128\206\185\207\131\207\132\206\191\206\187\206\174</term>\n    <term name=\"no date\">\207\135\207\137\207\129\206\175\207\130 \207\135\207\129\206\191\206\189\206\191\206\187\206\191\206\179\206\175\206\177</term>\n    <term name=\"no date\" form=\"short\">\207\135.\207\135.</term>\n    <term name=\"online\">\206\173\206\186\206\180\206\191\207\131\206\183 \207\131\206\181 \207\136\206\183\207\134\206\185\206\177\206\186\206\174 \206\188\206\191\207\129\207\134\206\174</term>\n    <term name=\"presented at\">\207\128\206\177\207\129\206\191\207\133\207\131\206\185\206\172\207\131\207\132\206\183\206\186\206\181 \207\131\207\132\206\191</term>\n    <term name=\"reference\">\n      <single>\207\128\206\177\207\129\206\177\207\128\206\191\206\188\207\128\206\174</single>\n      <multiple>\207\128\206\177\207\129\206\177\207\128\206\191\206\188\207\128\206\173\207\130</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>\207\128\206\177\207\129.</single>\n      <multiple>\207\128\206\177\207\129.</multiple>\n    </term>\n    <term name=\"retrieved\">\206\177\206\189\206\177\206\186\207\132\206\174\206\184\206\183\206\186\206\181</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">\206\188.\206\167.</term>\n    <term name=\"bc\">\207\128.\206\167.</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\152</term>\n    <term name=\"close-quote\">\226\128\153</term>\n    <term name=\"open-inner-quote\">'</term>\n    <term name=\"close-inner-quote\">'</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">\206\191\207\130</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">\207\128\207\129\207\142\207\132\206\191\207\130</term>\n    <term name=\"long-ordinal-02\">\206\180\206\181\207\141\207\132\206\181\207\129\206\191\207\130</term>\n    <term name=\"long-ordinal-03\">\207\132\207\129\206\175\207\132\206\191\207\130</term>\n    <term name=\"long-ordinal-04\">\207\132\206\173\207\132\206\177\207\129\207\132\206\191\207\130</term>\n    <term name=\"long-ordinal-05\">\207\128\206\173\206\188\207\128\207\132\206\191\207\130</term>\n    <term name=\"long-ordinal-06\">\206\173\206\186\207\132\206\191\207\130</term>\n    <term name=\"long-ordinal-07\">\206\173\206\178\206\180\206\191\206\188\206\191\207\130</term>\n    <term name=\"long-ordinal-08\">\207\140\206\179\206\180\206\191\206\191\207\130</term>\n    <term name=\"long-ordinal-09\">\206\173\206\189\206\177\207\132\206\191\207\130</term>\n    <term name=\"long-ordinal-10\">\206\180\206\173\206\186\206\177\207\132\206\191\207\130</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>\206\178\206\185\206\178\206\187\206\175\206\191</single>\n      <multiple>\206\178\206\185\206\178\206\187\206\175\206\191</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>\206\186\206\181\207\134\206\172\206\187\206\177\206\185\206\191</single>\n      <multiple>\206\186\206\181\207\134\206\172\206\187\206\177\206\185\206\177</multiple>\n    </term>\n    <term name=\"column\">\n      <single>\207\131\207\132\206\174\206\187\206\183</single>\n      <multiple>\207\131\207\132\206\174\206\187\206\181\207\130</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>\206\181\206\185\206\186\207\140\206\189\206\177</single>\n      <multiple>\206\181\206\185\206\186\207\140\206\189\206\181\207\130</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>\207\134\206\172\206\186\206\181\206\187\206\191\207\130</single>\n      <multiple>\207\134\206\172\206\186\206\181\206\187\206\191\206\185</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>\207\132\206\181\207\141\207\135\206\191\207\130</single>\n      <multiple>\207\132\206\181\207\141\207\135\206\183</multiple>\n    </term>\n    <term name=\"line\">\n      <single>\207\131\206\181\206\185\207\129\206\172</single>\n      <multiple>\207\131\206\181\206\185\207\129\206\173\207\130</multiple>\n    </term>\n    <term name=\"note\">\n      <single>\207\131\206\183\206\188\206\181\206\175\207\137\207\131\206\183</single>\n      <multiple>\207\131\206\183\206\188\206\181\206\185\207\142\207\131\206\181\206\185\207\130</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>\206\173\207\129\206\179\206\191</single>\n      <multiple>\206\173\207\129\206\179\206\177</multiple>\n    </term>\n    <term name=\"page\">\n      <single>\207\131\206\181\206\187\206\175\206\180\206\177</single>\n      <multiple>\207\131\206\181\206\187\206\175\206\180\206\181\207\130</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>\207\128\206\177\207\129\206\172\206\179\207\129\206\177\207\134\206\191\207\130</single>\n      <multiple>\207\128\206\177\207\129\206\172\206\179\207\129\206\177\207\134\206\191\206\185</multiple>\n    </term>\n    <term name=\"part\">\n      <single>\206\188\206\173\207\129\206\191\207\130</single>\n      <multiple>\206\188\206\173\207\129\206\183</multiple>\n    </term>\n    <term name=\"section\">\n      <single>\207\132\206\188\206\174\206\188\206\177</single>\n      <multiple>\207\132\206\188\206\174\206\188\206\177\207\132\206\177</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>\206\187\206\174\206\188\206\188\206\177</single>\n      <multiple>\206\187\206\174\206\188\206\188\206\177\207\132\206\177</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>\207\131\207\132\206\175\207\135\206\191\207\130</single>\n      <multiple>\207\131\207\132\206\175\207\135\206\191\206\185</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>\207\132\207\140\206\188\206\191\207\130</single>\n      <multiple>\207\132\207\140\206\188\206\191\206\185</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">\206\178\206\185\206\178.</term>\n    <term name=\"chapter\" form=\"short\">\206\186\206\181\207\134.</term>\n    <term name=\"column\" form=\"short\">\207\131\207\132.</term>\n    <term name=\"figure\" form=\"short\">\206\181\206\185\206\186.</term>\n    <term name=\"folio\" form=\"short\">\207\134\206\172\206\186</term>\n    <term name=\"issue\" form=\"short\">\207\132\207\135.</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">\206\173\207\129\206\179.</term>\n    <term name=\"page\" form=\"short\">\n      <single>\207\131</single>\n      <multiple>\207\131\207\131</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">\207\128\206\177\207\129.</term>\n    <term name=\"part\" form=\"short\">\206\188\206\173\207\129.</term>\n    <term name=\"section\" form=\"short\">\207\132\206\188.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>\206\187\206\174\206\188.</single>\n      <multiple>\206\187\206\174\206\188.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>\207\131\207\132.</single>\n      <multiple>\207\131\207\132.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>\207\132.</single>\n      <multiple>\207\132.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>\206\181\207\128\206\185\206\188\206\181\206\187\206\183\207\132\206\174\207\130</single>\n      <multiple>\206\181\207\128\206\185\206\188\206\181\206\187\206\183\207\132\206\173\207\130</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>\206\180\206\185\206\181\207\133\206\184\207\133\206\189\207\132\206\174\207\130 \207\131\206\181\206\185\207\129\206\172\207\130</single>\n      <multiple>\206\180\206\185\206\181\207\133\206\184\207\133\206\189\207\132\206\173\207\130 \207\131\206\181\206\185\207\129\206\172\207\130</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>\206\188\206\181\207\132\206\177\207\134\207\129\206\177\207\131\207\132\206\174\207\130</single>\n      <multiple>\206\188\206\181\207\132\206\177\207\134\207\129\206\177\207\131\207\132\206\173\207\130</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>\206\188\206\181\207\132\206\177\207\134\207\129\206\177\207\131\207\132\206\174\207\130 \206\186\206\177\206\185 \206\181\207\128\206\185\206\188\206\181\206\187\206\183\207\132\206\174\207\130</single>\n      <multiple>\206\188\206\181\207\132\206\177\207\134\207\129\206\177\207\131\207\132\206\173\207\130 \206\186\206\177\206\185 \206\181\207\128\206\185\206\188\206\181\206\187\206\183\207\132\206\173\207\130</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>\206\181\207\128\206\185\206\188.</single>\n      <multiple>\206\181\207\128\206\185\206\188.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>\206\180/\206\189\207\132\206\174\207\130 \207\131\206\181\206\185\207\129\206\172\207\130</single>\n      <multiple>\206\180/\206\189\207\132\206\173\207\130 \207\131\206\181\206\185\207\129\206\177\207\130</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>\206\188\207\132\207\134.</single>\n      <multiple>\206\188\207\132\207\134.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>\206\188\207\132\207\134. \206\186\206\177\206\185 \206\181\207\128\206\185\206\188.</single>\n      <multiple>\206\188\207\132\207\134. \206\186\206\177\206\185 \206\181\207\128\206\185\206\188.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">\206\181\207\128\206\185\206\188\206\173\206\187\206\181\206\185\206\177</term>\n    <term name=\"editorial-director\" form=\"verb\">\206\180\206\185\206\181\207\141\206\184\207\133\206\189\207\131\206\183 \207\131\206\181\206\185\207\129\206\172\207\130</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">\207\131\207\133\206\189\206\173\206\189\207\132\206\181\207\133\206\190\206\183</term>\n    <term name=\"recipient\" form=\"verb\">\207\128\206\177\207\129\206\177\206\187\206\174\207\128\207\132\206\183\207\130</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">\206\188\206\181\207\132\206\172\207\134\207\129\206\177\207\131\206\183</term>\n    <term name=\"editortranslator\" form=\"verb\">\206\188\206\181\207\132\206\172\207\134\207\129\206\177\207\131\206\183 \206\186\206\177\206\185 \206\181\207\128\206\185\206\188\206\173\206\187\206\181\206\185\206\177</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">\207\131\207\132\206\191\206\189 \207\131\207\133\206\187\206\187. \207\132\207\140\206\188\206\191</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">\206\181\207\128\206\185\206\188\206\173\206\187.</term>\n    <term name=\"editorial-director\" form=\"verb-short\">\206\180/\206\189\207\131\206\183 \207\131\206\181\206\185\207\129\206\172\207\130</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">\206\188\206\181\207\132\206\172\207\134\207\129.</term>\n    <term name=\"editortranslator\" form=\"verb-short\">\206\188\206\181\207\132\206\172\207\134\207\129. \206\186\206\177\206\185 \206\181\207\128\206\185\206\188\206\173\206\187.</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">\206\153\206\177\206\189\206\191\207\133\206\172\207\129\206\185\206\191\207\130</term>\n    <term name=\"month-02\">\206\166\206\181\206\178\207\129\206\191\207\133\206\172\207\129\206\185\206\191\207\130</term>\n    <term name=\"month-03\">\206\156\206\172\207\129\207\132\206\185\206\191\207\130</term>\n    <term name=\"month-04\">\206\145\207\128\207\129\206\175\206\187\206\185\206\191\207\130</term>\n    <term name=\"month-05\">\206\156\206\172\206\185\206\191\207\130</term>\n    <term name=\"month-06\">\206\153\206\191\207\141\206\189\206\185\206\191\207\130</term>\n    <term name=\"month-07\">\206\153\206\191\207\141\206\187\206\185\206\191\207\130</term>\n    <term name=\"month-08\">\206\145\207\141\206\179\206\191\207\133\207\131\207\132\206\191\207\130</term>\n    <term name=\"month-09\">\206\163\206\181\207\128\207\132\206\173\206\188\206\178\207\129\206\185\206\191\207\130</term>\n    <term name=\"month-10\">\206\159\206\186\207\132\207\142\206\178\207\129\206\185\206\191\207\130</term>\n    <term name=\"month-11\">\206\157\206\191\206\173\206\188\206\178\207\129\206\185\206\191\207\130</term>\n    <term name=\"month-12\">\206\148\206\181\206\186\206\173\206\188\206\178\207\129\206\185\206\191\207\130</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">\206\153\206\177\206\189\206\191\207\133\206\177\207\129\206\175\206\191\207\133</term>\n    <term name=\"month-02\" form=\"short\">\206\166\206\181\206\178\207\129\206\191\207\133\206\177\207\129\206\175\206\191\207\133</term>\n    <term name=\"month-03\" form=\"short\">\206\156\206\177\207\129\207\132\206\175\206\191\207\133</term>\n    <term name=\"month-04\" form=\"short\">\206\145\207\128\207\129\206\185\206\187\206\175\206\191\207\133</term>\n    <term name=\"month-05\" form=\"short\">\206\156\206\177\206\144\206\191\207\133</term>\n    <term name=\"month-06\" form=\"short\">\206\153\206\191\207\133\206\189\206\175\206\191\207\133</term>\n    <term name=\"month-07\" form=\"short\">\206\153\206\191\207\133\206\187\206\175\206\191\207\133</term>\n    <term name=\"month-08\" form=\"short\">\206\145\207\133\206\179\206\191\207\141\207\131\207\132\206\191\207\133</term>\n    <term name=\"month-09\" form=\"short\">\206\163\206\181\207\128\207\132\206\181\206\188\206\178\207\129\206\175\206\191\207\133</term>\n    <term name=\"month-10\" form=\"short\">\206\159\206\186\207\132\207\137\206\178\207\129\206\175\206\191\207\133</term>\n    <term name=\"month-11\" form=\"short\">\206\157\206\191\206\181\206\188\206\178\207\129\206\175\206\191\207\133</term>\n    <term name=\"month-12\" form=\"short\">\206\148\206\181\206\186\206\181\206\188\206\178\207\129\206\175\206\191\207\133</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">\206\134\206\189\206\191\206\185\206\190\206\183</term>\n    <term name=\"season-02\">\206\154\206\177\206\187\206\191\206\186\206\177\206\175\207\129\206\185</term>\n    <term name=\"season-03\">\206\166\206\184\206\185\206\189\207\140\207\128\207\137\207\129\206\191</term>\n    <term name=\"season-04\">\206\167\206\181\206\185\206\188\207\142\206\189\206\177\207\130</term>\n  </terms>\n</locale>\n"),("locales-en-GB.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"en-GB\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\" \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">accessed</term>\n    <term name=\"and\">and</term>\n    <term name=\"and others\">and others</term>\n    <term name=\"anonymous\">anonymous</term>\n    <term name=\"anonymous\" form=\"short\">anon.</term>\n    <term name=\"at\">at</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">by</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">cited</term>\n    <term name=\"edition\">\n      <single>edition</single>\n      <multiple>editions</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">ed.</term>\n    <term name=\"et-al\">et al.</term>\n    <term name=\"forthcoming\">forthcoming</term>\n    <term name=\"from\">from</term>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\">in</term>\n    <term name=\"in press\">in press</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">interview</term>\n    <term name=\"letter\">letter</term>\n    <term name=\"no date\">no date</term>\n    <term name=\"no date\" form=\"short\">n.d.</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">presented at the</term>\n    <term name=\"reference\">\n      <single>reference</single>\n      <multiple>references</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">retrieved</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">AD</term>\n    <term name=\"bc\">BC</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\152</term>\n    <term name=\"close-quote\">\226\128\153</term>\n    <term name=\"open-inner-quote\">\226\128\156</term>\n    <term name=\"close-inner-quote\">\226\128\157</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">th</term>\n    <term name=\"ordinal-01\">st</term>\n    <term name=\"ordinal-02\">nd</term>\n    <term name=\"ordinal-03\">rd</term>\n    <term name=\"ordinal-11\">th</term>\n    <term name=\"ordinal-12\">th</term>\n    <term name=\"ordinal-13\">th</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">first</term>\n    <term name=\"long-ordinal-02\">second</term>\n    <term name=\"long-ordinal-03\">third</term>\n    <term name=\"long-ordinal-04\">fourth</term>\n    <term name=\"long-ordinal-05\">fifth</term>\n    <term name=\"long-ordinal-06\">sixth</term>\n    <term name=\"long-ordinal-07\">seventh</term>\n    <term name=\"long-ordinal-08\">eighth</term>\n    <term name=\"long-ordinal-09\">ninth</term>\n    <term name=\"long-ordinal-10\">tenth</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>book</single>\n      <multiple>books</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>chapter</single>\n      <multiple>chapters</multiple>\n    </term>\n    <term name=\"column\">\n      <single>column</single>\n      <multiple>columns</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>figure</single>\n      <multiple>figures</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folio</single>\n      <multiple>folios</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>number</single>\n      <multiple>numbers</multiple>\n    </term>\n    <term name=\"line\">\n      <single>line</single>\n      <multiple>lines</multiple>\n    </term>\n    <term name=\"note\">\n      <single>note</single>\n      <multiple>notes</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>page</single>\n      <multiple>pages</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>paragraph</single>\n      <multiple>paragraph</multiple>\n    </term>\n    <term name=\"part\">\n      <single>part</single>\n      <multiple>parts</multiple>\n    </term>\n    <term name=\"section\">\n      <single>section</single>\n      <multiple>sections</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>verse</single>\n      <multiple>verses</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>volume</single>\n      <multiple>volumes</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">bk.</term>\n    <term name=\"chapter\" form=\"short\">chap.</term>\n    <term name=\"column\" form=\"short\">col.</term>\n    <term name=\"figure\" form=\"short\">fig.</term>\n    <term name=\"folio\" form=\"short\">f.</term>\n    <term name=\"issue\" form=\"short\">no.</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op.</term>\n    <term name=\"page\" form=\"short\">\n      <single>p.</single>\n      <multiple>pp.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">para.</term>\n    <term name=\"part\" form=\"short\">pt.</term>\n    <term name=\"section\" form=\"short\">sec.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v.</single>\n      <multiple>vv.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>vol.</single>\n      <multiple>vols.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>translator</single>\n      <multiple>translators</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>editor &amp; translator</single>\n      <multiple>editors &amp; translators</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>ed.</single>\n      <multiple>eds.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ed.</single>\n      <multiple>eds.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>tran.</single>\n      <multiple>trans.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ed. &amp; tran.</single>\n      <multiple>eds. &amp; trans.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">edited by</term>\n    <term name=\"editorial-director\" form=\"verb\">edited by</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">interview by</term>\n    <term name=\"recipient\" form=\"verb\">to</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">translated by</term>\n    <term name=\"editortranslator\" form=\"verb\">edited &amp; translated by</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">by</term>\n    <term name=\"director\" form=\"verb-short\">dir. by</term>\n    <term name=\"editor\" form=\"verb-short\">ed. by</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed. by</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus. by</term>\n    <term name=\"translator\" form=\"verb-short\">trans. by</term>\n    <term name=\"editortranslator\" form=\"verb-short\">ed. &amp; trans. by</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">January</term>\n    <term name=\"month-02\">February</term>\n    <term name=\"month-03\">March</term>\n    <term name=\"month-04\">April</term>\n    <term name=\"month-05\">May</term>\n    <term name=\"month-06\">June</term>\n    <term name=\"month-07\">July</term>\n    <term name=\"month-08\">August</term>\n    <term name=\"month-09\">September</term>\n    <term name=\"month-10\">October</term>\n    <term name=\"month-11\">November</term>\n    <term name=\"month-12\">December</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">Jan.</term>\n    <term name=\"month-02\" form=\"short\">Feb.</term>\n    <term name=\"month-03\" form=\"short\">Mar.</term>\n    <term name=\"month-04\" form=\"short\">Apr.</term>\n    <term name=\"month-05\" form=\"short\">May</term>\n    <term name=\"month-06\" form=\"short\">Jun.</term>\n    <term name=\"month-07\" form=\"short\">Jul.</term>\n    <term name=\"month-08\" form=\"short\">Aug.</term>\n    <term name=\"month-09\" form=\"short\">Sep.</term>\n    <term name=\"month-10\" form=\"short\">Oct.</term>\n    <term name=\"month-11\" form=\"short\">Nov.</term>\n    <term name=\"month-12\" form=\"short\">Dec.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">Spring</term>\n    <term name=\"season-02\">Summer</term>\n    <term name=\"season-03\">Autumn</term>\n    <term name=\"season-04\">Winter</term>\n  </terms>\n</locale>\n"),("locales-en-US.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"en-US\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"true\"/>\n  <date form=\"text\">\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"day\" suffix=\", \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">accessed</term>\n    <term name=\"and\">and</term>\n    <term name=\"and others\">and others</term>\n    <term name=\"anonymous\">anonymous</term>\n    <term name=\"anonymous\" form=\"short\">anon.</term>\n    <term name=\"at\">at</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">by</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">cited</term>\n    <term name=\"edition\">\n      <single>edition</single>\n      <multiple>editions</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">ed.</term>\n    <term name=\"et-al\">et al.</term>\n    <term name=\"forthcoming\">forthcoming</term>\n    <term name=\"from\">from</term>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\">in</term>\n    <term name=\"in press\">in press</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">interview</term>\n    <term name=\"letter\">letter</term>\n    <term name=\"no date\">no date</term>\n    <term name=\"no date\" form=\"short\">n.d.</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">presented at the</term>\n    <term name=\"reference\">\n      <single>reference</single>\n      <multiple>references</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">retrieved</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">AD</term>\n    <term name=\"bc\">BC</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\156</term>\n    <term name=\"close-quote\">\226\128\157</term>\n    <term name=\"open-inner-quote\">\226\128\152</term>\n    <term name=\"close-inner-quote\">\226\128\153</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">th</term>\n    <term name=\"ordinal-01\">st</term>\n    <term name=\"ordinal-02\">nd</term>\n    <term name=\"ordinal-03\">rd</term>\n    <term name=\"ordinal-11\">th</term>\n    <term name=\"ordinal-12\">th</term>\n    <term name=\"ordinal-13\">th</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">first</term>\n    <term name=\"long-ordinal-02\">second</term>\n    <term name=\"long-ordinal-03\">third</term>\n    <term name=\"long-ordinal-04\">fourth</term>\n    <term name=\"long-ordinal-05\">fifth</term>\n    <term name=\"long-ordinal-06\">sixth</term>\n    <term name=\"long-ordinal-07\">seventh</term>\n    <term name=\"long-ordinal-08\">eighth</term>\n    <term name=\"long-ordinal-09\">ninth</term>\n    <term name=\"long-ordinal-10\">tenth</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>book</single>\n      <multiple>books</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>chapter</single>\n      <multiple>chapters</multiple>\n    </term>\n    <term name=\"column\">\n      <single>column</single>\n      <multiple>columns</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>figure</single>\n      <multiple>figures</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folio</single>\n      <multiple>folios</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>number</single>\n      <multiple>numbers</multiple>\n    </term>\n    <term name=\"line\">\n      <single>line</single>\n      <multiple>lines</multiple>\n    </term>\n    <term name=\"note\">\n      <single>note</single>\n      <multiple>notes</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>page</single>\n      <multiple>pages</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>paragraph</single>\n      <multiple>paragraph</multiple>\n    </term>\n    <term name=\"part\">\n      <single>part</single>\n      <multiple>parts</multiple>\n    </term>\n    <term name=\"section\">\n      <single>section</single>\n      <multiple>sections</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>verse</single>\n      <multiple>verses</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>volume</single>\n      <multiple>volumes</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">bk.</term>\n    <term name=\"chapter\" form=\"short\">chap.</term>\n    <term name=\"column\" form=\"short\">col.</term>\n    <term name=\"figure\" form=\"short\">fig.</term>\n    <term name=\"folio\" form=\"short\">f.</term>\n    <term name=\"issue\" form=\"short\">no.</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op.</term>\n    <term name=\"page\" form=\"short\">\n      <single>p.</single>\n      <multiple>pp.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">para.</term>\n    <term name=\"part\" form=\"short\">pt.</term>\n    <term name=\"section\" form=\"short\">sec.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v.</single>\n      <multiple>vv.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>vol.</single>\n      <multiple>vols.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>translator</single>\n      <multiple>translators</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>editor &amp; translator</single>\n      <multiple>editors &amp; translators</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>ed.</single>\n      <multiple>eds.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ed.</single>\n      <multiple>eds.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>tran.</single>\n      <multiple>trans.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ed. &amp; tran.</single>\n      <multiple>eds. &amp; trans.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">edited by</term>\n    <term name=\"editorial-director\" form=\"verb\">edited by</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">interview by</term>\n    <term name=\"recipient\" form=\"verb\">to</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">translated by</term>\n    <term name=\"editortranslator\" form=\"verb\">edited &amp; translated by</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">by</term>\n    <term name=\"director\" form=\"verb-short\">dir. by</term>\n    <term name=\"editor\" form=\"verb-short\">ed. by</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed. by</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus. by</term>\n    <term name=\"translator\" form=\"verb-short\">trans. by</term>\n    <term name=\"editortranslator\" form=\"verb-short\">ed. &amp; trans. by</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">January</term>\n    <term name=\"month-02\">February</term>\n    <term name=\"month-03\">March</term>\n    <term name=\"month-04\">April</term>\n    <term name=\"month-05\">May</term>\n    <term name=\"month-06\">June</term>\n    <term name=\"month-07\">July</term>\n    <term name=\"month-08\">August</term>\n    <term name=\"month-09\">September</term>\n    <term name=\"month-10\">October</term>\n    <term name=\"month-11\">November</term>\n    <term name=\"month-12\">December</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">Jan.</term>\n    <term name=\"month-02\" form=\"short\">Feb.</term>\n    <term name=\"month-03\" form=\"short\">Mar.</term>\n    <term name=\"month-04\" form=\"short\">Apr.</term>\n    <term name=\"month-05\" form=\"short\">May</term>\n    <term name=\"month-06\" form=\"short\">Jun.</term>\n    <term name=\"month-07\" form=\"short\">Jul.</term>\n    <term name=\"month-08\" form=\"short\">Aug.</term>\n    <term name=\"month-09\" form=\"short\">Sep.</term>\n    <term name=\"month-10\" form=\"short\">Oct.</term>\n    <term name=\"month-11\" form=\"short\">Nov.</term>\n    <term name=\"month-12\" form=\"short\">Dec.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">Spring</term>\n    <term name=\"season-02\">Summer</term>\n    <term name=\"season-03\">Autumn</term>\n    <term name=\"season-04\">Winter</term>\n  </terms>\n</locale>\n"),("locales-es-ES.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"es-ES\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\" de \"/>\n    <date-part name=\"month\" suffix=\" de \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">accedido</term>\n    <term name=\"and\">y</term>\n    <term name=\"and others\">y otros</term>\n    <term name=\"anonymous\">an\195\179nimo</term>\n    <term name=\"anonymous\" form=\"short\">an\195\179n.</term>\n    <term name=\"at\">en</term>\n    <term name=\"available at\">disponible en</term>\n    <term name=\"by\">de</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">citado</term>\n    <term name=\"edition\">\n      <single>edici\195\179n</single>\n      <multiple>ediciones</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">ed.</term>\n    <term name=\"et-al\">et&#160;al.</term>\n    <term name=\"forthcoming\">previsto</term>\n    <term name=\"from\">a partir de</term>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\">en</term>\n    <term name=\"in press\">en imprenta</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">entrevista</term>\n    <term name=\"letter\">carta</term>\n    <term name=\"no date\">sin fecha</term>\n    <term name=\"no date\" form=\"short\">s.&#160;f.</term>\n    <term name=\"online\">en l\195\173nea</term>\n    <term name=\"presented at\">presentado en</term>\n    <term name=\"reference\">\n      <single>referencia</single>\n      <multiple>referencias</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">recuperado</term>\n    <term name=\"scale\">escala</term>\n    <term name=\"version\">versi\195\179n</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">d.&#160;C.</term>\n    <term name=\"bc\">a.&#160;C.</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\194\171</term>\n    <term name=\"close-quote\">\194\187</term>\n    <term name=\"open-inner-quote\">\226\128\156</term>\n    <term name=\"close-inner-quote\">\226\128\157</term>\n    <term name=\"page-range-delimiter\">-</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">.\194\170</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">primera</term>\n    <term name=\"long-ordinal-02\">segunda</term>\n    <term name=\"long-ordinal-03\">tercera</term>\n    <term name=\"long-ordinal-04\">cuarta</term>\n    <term name=\"long-ordinal-05\">quinta</term>\n    <term name=\"long-ordinal-06\">sexta</term>\n    <term name=\"long-ordinal-07\">s\195\169ptima</term>\n    <term name=\"long-ordinal-08\">octava</term>\n    <term name=\"long-ordinal-09\">novena</term>\n    <term name=\"long-ordinal-10\">d\195\169cima</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>libro</single>\n      <multiple>libros</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>cap\195\173tulo</single>\n      <multiple>cap\195\173tulos</multiple>\n    </term>\n    <term name=\"column\">\n      <single>columna</single>\n      <multiple>columnas</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>figura</single>\n      <multiple>figuras</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folio</single>\n      <multiple>folios</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>n\195\186mero</single>\n      <multiple>n\195\186meros</multiple>\n    </term>\n    <term name=\"line\">\n      <single>l\195\173nea</single>\n      <multiple>l\195\173neas</multiple>\n    </term>\n    <term name=\"note\">\n      <single>nota</single>\n      <multiple>notas</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>p\195\161gina</single>\n      <multiple>p\195\161ginas</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>p\195\161rrafo</single>\n      <multiple>p\195\161rrafos</multiple>\n    </term>\n    <term name=\"part\">\n      <single>parte</single>\n      <multiple>partes</multiple>\n    </term>\n    <term name=\"section\">\n      <single>secci\195\179n</single>\n      <multiple>secciones</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub voce</single>\n      <multiple>sub vocibus</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>verso</single>\n      <multiple>versos</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>volumen</single>\n      <multiple>vol\195\186menes</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">lib.</term>\n    <term name=\"chapter\" form=\"short\">cap.</term>\n    <term name=\"column\" form=\"short\">col.</term>\n    <term name=\"figure\" form=\"short\">fig.</term>\n    <term name=\"folio\" form=\"short\">f.</term>\n    <term name=\"issue\" form=\"short\">n.\194\186</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op.</term>\n    <term name=\"page\" form=\"short\">\n      <single>p.</single>\n      <multiple>pp.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">p\195\161rr.</term>\n    <term name=\"part\" form=\"short\">pt.</term>\n    <term name=\"section\" form=\"short\">sec.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.&#160;v.</single>\n      <multiple>s.&#160;vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v.</single>\n      <multiple>vv.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>vol.</single>\n      <multiple>vols.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directores</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>editor</single>\n      <multiple>editores</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>editor</single>\n      <multiple>editores</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>ilustrador</single>\n      <multiple>ilustradores</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>traductor</single>\n      <multiple>traductores</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>editor y traductor</single>\n      <multiple>editores y traductores</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>ed.</single>\n      <multiple>eds.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ed.</single>\n      <multiple>eds.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ilust.</single>\n      <multiple>ilusts.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>trad.</single>\n      <multiple>trads.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ed. y trad.</single>\n      <multiple>eds. y trads.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">dirigido por</term>\n    <term name=\"editor\" form=\"verb\">editado por</term>\n    <term name=\"editorial-director\" form=\"verb\">editado por</term>\n    <term name=\"illustrator\" form=\"verb\">ilustrado por</term>\n    <term name=\"interviewer\" form=\"verb\">entrevistado por</term>\n    <term name=\"recipient\" form=\"verb\">a</term>\n    <term name=\"reviewed-author\" form=\"verb\">por</term>\n    <term name=\"translator\" form=\"verb\">traducido por</term>\n    <term name=\"editortranslator\" form=\"verb\">editado y traducido por</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">de</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">ed.</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed.</term>\n    <term name=\"illustrator\" form=\"verb-short\">ilust.</term>\n    <term name=\"translator\" form=\"verb-short\">trad.</term>\n    <term name=\"editortranslator\" form=\"verb-short\">ed. y trad.</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">enero</term>\n    <term name=\"month-02\">febrero</term>\n    <term name=\"month-03\">marzo</term>\n    <term name=\"month-04\">abril</term>\n    <term name=\"month-05\">mayo</term>\n    <term name=\"month-06\">junio</term>\n    <term name=\"month-07\">julio</term>\n    <term name=\"month-08\">agosto</term>\n    <term name=\"month-09\">septiembre</term>\n    <term name=\"month-10\">octubre</term>\n    <term name=\"month-11\">noviembre</term>\n    <term name=\"month-12\">diciembre</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">ene.</term>\n    <term name=\"month-02\" form=\"short\">feb.</term>\n    <term name=\"month-03\" form=\"short\">mar.</term>\n    <term name=\"month-04\" form=\"short\">abr.</term>\n    <term name=\"month-05\" form=\"short\">may</term>\n    <term name=\"month-06\" form=\"short\">jun.</term>\n    <term name=\"month-07\" form=\"short\">jul.</term>\n    <term name=\"month-08\" form=\"short\">ago.</term>\n    <term name=\"month-09\" form=\"short\">sep.</term>\n    <term name=\"month-10\" form=\"short\">oct.</term>\n    <term name=\"month-11\" form=\"short\">nov.</term>\n    <term name=\"month-12\" form=\"short\">dic.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">primavera</term>\n    <term name=\"season-02\">verano</term>\n    <term name=\"season-03\">oto\195\177o</term>\n    <term name=\"season-04\">invierno</term>\n  </terms>\n</locale>\n"),("locales-et-EE.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"et-EE\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\". \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\".\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\".\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">vaadatud</term>\n    <term name=\"and\">ja</term>\n    <term name=\"and others\">ja teised</term>\n    <term name=\"anonymous\">anon\195\188\195\188mne</term>\n    <term name=\"anonymous\" form=\"short\">anon</term>\n    <term name=\"at\"/>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\"/>\n    <term name=\"circa\">umbes</term>\n    <term name=\"circa\" form=\"short\">u</term>\n    <term name=\"cited\">tsiteeritud</term>\n    <term name=\"edition\">\n      <single>v\195\164ljaanne</single>\n      <multiple>v\195\164ljaanded</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">tr</term>\n    <term name=\"et-al\">et al.</term>\n    <term name=\"forthcoming\">ilmumisel</term>\n    <term name=\"from\"/>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\"/>\n    <term name=\"in press\">tr\195\188kis</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">intervjuu</term>\n    <term name=\"letter\">kiri</term>\n    <term name=\"no date\">s.a.</term>\n    <term name=\"no date\" form=\"short\">s.a.</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">esitatud</term>\n    <term name=\"reference\">\n      <single>viide</single>\n      <multiple>viited</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>viide</single>\n      <multiple>viited</multiple>\n    </term>\n    <term name=\"retrieved\">salvestatud</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">pKr</term>\n    <term name=\"bc\">eKr</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\158</term>\n    <term name=\"close-quote\">\226\128\156</term>\n    <term name=\"open-inner-quote\">\226\128\152</term>\n    <term name=\"close-inner-quote\">\226\128\153</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\"/>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">esimene</term>\n    <term name=\"long-ordinal-02\">teine</term>\n    <term name=\"long-ordinal-03\">kolmas</term>\n    <term name=\"long-ordinal-04\">neljas</term>\n    <term name=\"long-ordinal-05\">viies</term>\n    <term name=\"long-ordinal-06\">kuues</term>\n    <term name=\"long-ordinal-07\">seitsmes</term>\n    <term name=\"long-ordinal-08\">kaheksas</term>\n    <term name=\"long-ordinal-09\">\195\188heksas</term>\n    <term name=\"long-ordinal-10\">k\195\188mnes</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>raamat</single>\n      <multiple>raamatud</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>peat\195\188kk</single>\n      <multiple>peat\195\188kid</multiple>\n    </term>\n    <term name=\"column\">\n      <single>veerg</single>\n      <multiple>veerud</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>joonis</single>\n      <multiple>joonised</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>foolio</single>\n      <multiple>fooliod</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>number</single>\n      <multiple>numbrid</multiple>\n    </term>\n    <term name=\"line\">\n      <single>rida</single>\n      <multiple>read</multiple>\n    </term>\n    <term name=\"note\">\n      <single>viide</single>\n      <multiple>viited</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>lehek\195\188lg</single>\n      <multiple>lehek\195\188ljed</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>l\195\181ik</single>\n      <multiple>l\195\181igud</multiple>\n    </term>\n    <term name=\"part\">\n      <single>osa</single>\n      <multiple>osad</multiple>\n    </term>\n    <term name=\"section\">\n      <single>alajaotis</single>\n      <multiple>alajaotised</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>v\195\164rss</single>\n      <multiple>v\195\164rsid</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>k\195\182ide</single>\n      <multiple>k\195\182ited</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">rmt</term>\n    <term name=\"chapter\" form=\"short\">ptk</term>\n    <term name=\"column\" form=\"short\">v</term>\n    <term name=\"figure\" form=\"short\">joon</term>\n    <term name=\"folio\" form=\"short\">f</term>\n    <term name=\"issue\" form=\"short\">nr</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op</term>\n    <term name=\"page\" form=\"short\">\n      <single>lk</single>\n      <multiple>lk</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">l\195\181ik</term>\n    <term name=\"part\" form=\"short\">osa</term>\n    <term name=\"section\" form=\"short\">alajaot.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v</single>\n      <multiple>vv</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>kd</single>\n      <multiple>kd</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>toimetaja</single>\n      <multiple>toimetajad</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>toimetaja</single>\n      <multiple>toimetajad</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>t\195\181lkija</single>\n      <multiple>t\195\181lkijad</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>toimetaja &amp; t\195\181lkija</single>\n      <multiple>toimetajad &amp; t\195\181lkijad</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>toim</single>\n      <multiple>toim</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>toim</single>\n      <multiple>toim</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>t\195\181lk</single>\n      <multiple>t\195\181lk</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>toim &amp; t\195\181lk</single>\n      <multiple>toim &amp; t\195\181lk</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">toimetanud</term>\n    <term name=\"editorial-director\" form=\"verb\">toimetanud</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">intervjueerinud</term>\n    <term name=\"recipient\" form=\"verb\"/>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">t\195\181lkinud</term>\n    <term name=\"editortranslator\" form=\"verb\">toimetanud &amp; t\195\181lkinud</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\"/>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">toim</term>\n    <term name=\"editorial-director\" form=\"verb-short\">toim</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">t\195\181lk</term>\n    <term name=\"editortranslator\" form=\"verb-short\">toim &amp; t\195\181lk</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">jaanuar</term>\n    <term name=\"month-02\">veebruar</term>\n    <term name=\"month-03\">m\195\164rts</term>\n    <term name=\"month-04\">aprill</term>\n    <term name=\"month-05\">mai</term>\n    <term name=\"month-06\">juuni</term>\n    <term name=\"month-07\">juuli</term>\n    <term name=\"month-08\">august</term>\n    <term name=\"month-09\">september</term>\n    <term name=\"month-10\">oktoober</term>\n    <term name=\"month-11\">november</term>\n    <term name=\"month-12\">detsember</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">jaan</term>\n    <term name=\"month-02\" form=\"short\">veebr</term>\n    <term name=\"month-03\" form=\"short\">m\195\164rts</term>\n    <term name=\"month-04\" form=\"short\">apr</term>\n    <term name=\"month-05\" form=\"short\">mai</term>\n    <term name=\"month-06\" form=\"short\">juuni</term>\n    <term name=\"month-07\" form=\"short\">juuli</term>\n    <term name=\"month-08\" form=\"short\">aug</term>\n    <term name=\"month-09\" form=\"short\">sept</term>\n    <term name=\"month-10\" form=\"short\">okt</term>\n    <term name=\"month-11\" form=\"short\">nov</term>\n    <term name=\"month-12\" form=\"short\">dets</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">kevad</term>\n    <term name=\"season-02\">suvi</term>\n    <term name=\"season-03\">s\195\188gis</term>\n    <term name=\"season-04\">talv</term>\n  </terms>\n</locale>\n"),("locales-eu.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"eu\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"year\" suffix=\"(e)ko \"/>\n    <date-part name=\"month\" suffix=\"aren \"/>\n    <date-part name=\"day\" suffix=\"a\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"year\" suffix=\"/\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"day\" form=\"numeric-leading-zeros\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">eskuratua</term>\n    <term name=\"and\">eta</term>\n    <term name=\"and others\">eta beste</term>\n    <term name=\"anonymous\">ezezaguna</term>\n    <term name=\"anonymous\" form=\"short\">ezez.</term>\n    <term name=\"at\">-(e)n</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">-(e)k egina</term>\n    <term name=\"circa\">inguru</term>\n    <term name=\"circa\" form=\"short\">ing.</term>\n    <term name=\"cited\">aipatua</term>\n    <term name=\"edition\">\n      <single>argitalpena</single>\n      <multiple>argitalpenak</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">arg.</term>\n    <term name=\"et-al\">et al.</term>\n    <term name=\"forthcoming\">bidean</term>\n    <term name=\"from\">-(e)tik</term>\n    <term name=\"ibid\">ib\195\173d.</term>\n    <term name=\"in\">in</term>\n    <term name=\"in press\">moldiztegian</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">elkarrizketa</term>\n    <term name=\"letter\">gutuna</term>\n    <term name=\"no date\">datarik gabe</term>\n    <term name=\"no date\" form=\"short\">d. g.</term>\n    <term name=\"online\">sarean</term>\n    <term name=\"presented at\">-(e)n aurkeztua</term>\n    <term name=\"reference\">\n      <single>aipamena</single>\n      <multiple>aipamenak</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>aip.</single>\n      <multiple>aip.</multiple>\n    </term>\n    <term name=\"retrieved\">berreskuratua</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">K.a.</term>\n    <term name=\"bc\">K.o.</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\194\171</term>\n    <term name=\"close-quote\">\194\187</term>\n    <term name=\"open-inner-quote\">\226\128\156</term>\n    <term name=\"close-inner-quote\">\226\128\157</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">.</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">lehengo</term>\n    <term name=\"long-ordinal-02\">bigarren</term>\n    <term name=\"long-ordinal-03\">hirugarren</term>\n    <term name=\"long-ordinal-04\">laugarren</term>\n    <term name=\"long-ordinal-05\">bosgarren</term>\n    <term name=\"long-ordinal-06\">seigarren</term>\n    <term name=\"long-ordinal-07\">zazpigarren</term>\n    <term name=\"long-ordinal-08\">zortzigarren</term>\n    <term name=\"long-ordinal-09\">bederatzigarren</term>\n    <term name=\"long-ordinal-10\">hamargarren</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>liburua</single>\n      <multiple>liburuak</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>kapitulua</single>\n      <multiple>kapituluak</multiple>\n    </term>\n    <term name=\"column\">\n      <single>zutabea</single>\n      <multiple>zutabeak</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>irudia</single>\n      <multiple>irudiak</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>orria</single>\n      <multiple>orriak</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>zenbakia</single>\n      <multiple>zenbakiak</multiple>\n    </term>\n    <term name=\"line\">\n      <single>lerroa</single>\n      <multiple>lerroak</multiple>\n    </term>\n    <term name=\"note\">\n      <single>oharra</single>\n      <multiple>oharrak</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>obra</single>\n      <multiple>obrak</multiple>\n    </term>\n    <term name=\"page\">\n      <single>orrialdea</single>\n      <multiple>orrialdeak</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>paragrafoa</single>\n      <multiple>paragrafoak</multiple>\n    </term>\n    <term name=\"part\">\n      <single>zatia</single>\n      <multiple>zatiak</multiple>\n    </term>\n    <term name=\"section\">\n      <single>atala</single>\n      <multiple>atalak</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub voce</single>\n      <multiple>sub vocem</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>bertsoa</single>\n      <multiple>bertsoak</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>luburikia</single>\n      <multiple>luburukiak</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">lib.</term>\n    <term name=\"chapter\" form=\"short\">kap.</term>\n    <term name=\"column\" form=\"short\">zut.</term>\n    <term name=\"figure\" form=\"short\">iru.</term>\n    <term name=\"folio\" form=\"short\">or.</term>\n    <term name=\"issue\" form=\"short\">zenb.</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op.</term>\n    <term name=\"page\" form=\"short\">\n      <single>or.</single>\n      <multiple>or.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">par.</term>\n    <term name=\"part\" form=\"short\">zt.</term>\n    <term name=\"section\" form=\"short\">atal.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.v.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>b.</single>\n      <multiple>bb.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>libk.</single>\n      <multiple>libk.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>argitaratzailea</single>\n      <multiple>argitaratzaileak</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>argitaratzailea</single>\n      <multiple>argitaratzaileak</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>itzultzailea</single>\n      <multiple>itzultzaileak</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>argitaratzaile eta itzultzailea</single>\n      <multiple>argitaratzaile eta itzultzaileak</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>arg.</single>\n      <multiple>arg.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>arg.</single>\n      <multiple>arg.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>itzul.</single>\n      <multiple>itzul.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>arg. eta itzul.</single>\n      <multiple>arg. eta itzul.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">-(e)k argitaratua</term>\n    <term name=\"editorial-director\" form=\"verb\">-(e)k argitaratua</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">-(e)k elkarrizketatua</term>\n    <term name=\"recipient\" form=\"verb\">-(r)entzat</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">-(e)k itzulia</term>\n    <term name=\"editortranslator\" form=\"verb\">-(e)k argitaratu eta itzulia</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\"/>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">arg.</term>\n    <term name=\"editorial-director\" form=\"verb-short\">arg.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">itzul.</term>\n    <term name=\"editortranslator\" form=\"verb-short\">-(e)k arg. eta itzul.</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">urtarrilak</term>\n    <term name=\"month-02\">otsailak</term>\n    <term name=\"month-03\">martxoak</term>\n    <term name=\"month-04\">apirilak</term>\n    <term name=\"month-05\">maiatzak</term>\n    <term name=\"month-06\">ekainak</term>\n    <term name=\"month-07\">uztailak</term>\n    <term name=\"month-08\">abuztuak</term>\n    <term name=\"month-09\">irailak</term>\n    <term name=\"month-10\">urriak</term>\n    <term name=\"month-11\">azaroak</term>\n    <term name=\"month-12\">abenduak</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">urt.</term>\n    <term name=\"month-02\" form=\"short\">ots.</term>\n    <term name=\"month-03\" form=\"short\">martx.</term>\n    <term name=\"month-04\" form=\"short\">apr.</term>\n    <term name=\"month-05\" form=\"short\">mai.</term>\n    <term name=\"month-06\" form=\"short\">eka.</term>\n    <term name=\"month-07\" form=\"short\">uzt.</term>\n    <term name=\"month-08\" form=\"short\">abz.</term>\n    <term name=\"month-09\" form=\"short\">ira.</term>\n    <term name=\"month-10\" form=\"short\">urr.</term>\n    <term name=\"month-11\" form=\"short\">aza.</term>\n    <term name=\"month-12\" form=\"short\">abe.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">udaberria</term>\n    <term name=\"season-02\">uda</term>\n    <term name=\"season-03\">udazkena</term>\n    <term name=\"season-04\">negua</term>\n  </terms>\n</locale>\n"),("locales-fa-IR.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"fa-IR\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"true\"/>\n  <date form=\"text\">\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\", \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">\216\175\216\179\216\170\216\177\216\179\219\140</term>\n    <term name=\"and\">\217\136</term>\n    <term name=\"and others\">\217\136 \216\175\219\140\218\175\216\177\216\167\217\134</term>\n    <term name=\"anonymous\">\217\134\216\167\216\180\217\134\216\167\216\179</term>\n    <term name=\"anonymous\" form=\"short\">\217\134\216\167\216\180\217\134\216\167\216\179</term>\n    <term name=\"at\">\216\175\216\177</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">\216\170\217\136\216\179\216\183</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">\219\140\216\167\216\175\218\169\216\177\216\175</term>\n    <term name=\"edition\">\n      <single>\217\136\219\140\216\177\216\167\219\140\216\180</single>\n      <multiple>\217\136\219\140\216\177\216\167\219\140\216\180\226\128\140\217\135\216\167\219\140</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">\217\136\219\140\216\177\216\167\219\140\216\180</term>\n    <term name=\"et-al\">\217\136 \216\175\219\140\218\175\216\177\216\167\217\134</term>\n    <term name=\"forthcoming\">forthcoming</term>\n    <term name=\"from\">\216\167\216\178</term>\n    <term name=\"ibid\">\217\135\217\133\216\167\217\134</term>\n    <term name=\"in\">\216\175\216\177</term>\n    <term name=\"in press\">\216\178\219\140\216\177 \218\134\216\167\217\190</term>\n    <term name=\"internet\">\216\167\219\140\217\134\216\170\216\177\217\134\216\170</term>\n    <term name=\"interview\">\217\133\216\181\216\167\216\173\216\168\217\135</term>\n    <term name=\"letter\">\217\134\216\167\217\133\217\135</term>\n    <term name=\"no date\">\216\168\216\175\217\136\217\134 \216\170\216\167\216\177\219\140\216\174</term>\n    <term name=\"no date\" form=\"short\">\216\168\216\175\217\136\217\134 \216\170\216\167\216\177\219\140\216\174</term>\n    <term name=\"online\">\216\168\216\177\216\174\216\183</term>\n    <term name=\"presented at\">\216\167\216\177\216\167\216\166\217\135 \216\180\216\175\217\135 \216\175\216\177</term>\n    <term name=\"reference\">\n      <single>\217\133\216\177\216\172\216\185</single>\n      <multiple>\217\133\216\177\216\167\216\172\216\185</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>\217\133\216\177\216\172\216\185</single>\n      <multiple>\217\133\216\177\216\167\216\172\216\185</multiple>\n    </term>\n    <term name=\"retrieved\">retrieved</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">AD</term>\n    <term name=\"bc\">BC</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\156</term>\n    <term name=\"close-quote\">\226\128\157</term>\n    <term name=\"open-inner-quote\">\226\128\152</term>\n    <term name=\"close-inner-quote\">\226\128\153</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">th</term>\n    <term name=\"ordinal-01\">st</term>\n    <term name=\"ordinal-02\">nd</term>\n    <term name=\"ordinal-03\">rd</term>\n    <term name=\"ordinal-11\">th</term>\n    <term name=\"ordinal-12\">th</term>\n    <term name=\"ordinal-13\">th</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">\216\167\217\136\217\132</term>\n    <term name=\"long-ordinal-02\">\216\175\217\136\217\133</term>\n    <term name=\"long-ordinal-03\">\216\179\217\136\217\133</term>\n    <term name=\"long-ordinal-04\">\218\134\217\135\216\167\216\177\217\133</term>\n    <term name=\"long-ordinal-05\">\217\190\217\134\216\172\217\133</term>\n    <term name=\"long-ordinal-06\">\216\180\216\180\217\133</term>\n    <term name=\"long-ordinal-07\">\217\135\217\129\216\170\217\133</term>\n    <term name=\"long-ordinal-08\">\217\135\216\180\216\170\217\133</term>\n    <term name=\"long-ordinal-09\">\217\134\217\135\217\133</term>\n    <term name=\"long-ordinal-10\">\216\175\217\135\217\133</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>\218\169\216\170\216\167\216\168</single>\n      <multiple>\218\169\216\170\216\167\216\168\226\128\140\217\135\216\167\219\140</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>\217\129\216\181\217\132</single>\n      <multiple>\217\129\216\181\217\132\226\128\140\217\135\216\167\219\140</multiple>\n    </term>\n    <term name=\"column\">\n      <single>\216\179\216\170\217\136\217\134</single>\n      <multiple>\216\179\216\170\217\136\217\134\226\128\140\217\135\216\167\219\140</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>\216\170\216\181\217\136\219\140\216\177</single>\n      <multiple>\216\170\216\181\216\167\217\136\219\140\216\177</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>\216\168\216\177\218\175</single>\n      <multiple>\216\168\216\177\218\175\226\128\140\217\135\216\167\219\140</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>\216\180\217\133\216\167\216\177\217\135</single>\n      <multiple>\216\180\217\133\216\167\216\177\217\135\226\128\140\217\135\216\167\219\140</multiple>\n    </term>\n    <term name=\"line\">\n      <single>\216\174\216\183</single>\n      <multiple>\216\174\216\183\217\136\216\183</multiple>\n    </term>\n    <term name=\"note\">\n      <single>\219\140\216\167\216\175\216\175\216\167\216\180\216\170</single>\n      <multiple>\219\140\216\167\216\175\216\175\216\167\216\180\216\170\226\128\140\217\135\216\167\219\140</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>\217\130\216\183\216\185\217\135</single>\n      <multiple>\217\130\216\183\216\185\216\167\216\170</multiple>\n    </term>\n    <term name=\"page\">\n      <single>\216\181\217\129\216\173\217\135</single>\n      <multiple>\216\181\217\129\216\173\216\167\216\170</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>\217\190\216\167\216\177\216\167\218\175\216\177\216\167\217\129</single>\n      <multiple>\217\190\216\167\216\177\216\167\218\175\216\177\216\167\217\129\226\128\140\217\135\216\167\219\140</multiple>\n    </term>\n    <term name=\"part\">\n      <single>\216\168\216\174\216\180</single>\n      <multiple>\216\168\216\174\216\180\226\128\140\217\135\216\167\219\140</multiple>\n    </term>\n    <term name=\"section\">\n      <single>\217\130\216\179\217\133\216\170</single>\n      <multiple>\217\130\216\179\217\133\216\170\226\128\140\217\135\216\167\219\140</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>\216\168\219\140\216\170</single>\n      <multiple>\216\168\219\140\216\170\226\128\140\217\135\216\167\219\140</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>\216\172\217\132\216\175</single>\n      <multiple>\216\172\217\132\216\175\217\135\216\167\219\140</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">\218\169\216\170\216\167\216\168</term>\n    <term name=\"chapter\" form=\"short\">\217\129\216\181\217\132</term>\n    <term name=\"column\" form=\"short\">\216\179\216\170\217\136\217\134</term>\n    <term name=\"figure\" form=\"short\">\216\170\216\181\217\136\219\140\216\177</term>\n    <term name=\"folio\" form=\"short\">\216\168\216\177\218\175</term>\n    <term name=\"issue\" form=\"short\">\216\180</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">\217\130\216\183\216\185\217\135</term>\n    <term name=\"page\" form=\"short\">\n      <single>\216\181</single>\n      <multiple>\216\181\216\181</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">\217\190\216\167\216\177\216\167\218\175\216\177\216\167\217\129</term>\n    <term name=\"part\" form=\"short\">\216\168\216\174\216\180</term>\n    <term name=\"section\" form=\"short\">\217\130\216\179\217\133\216\170</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v</single>\n      <multiple>s.vv</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>\216\168\219\140\216\170</single>\n      <multiple>\216\167\216\168\219\140\216\167\216\170</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>\216\172</single>\n      <multiple>\216\172\216\172</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>\217\136\219\140\216\177\216\167\219\140\216\180\218\175\216\177</single>\n      <multiple>\217\136\219\140\216\177\216\167\219\140\216\180\218\175\216\177\216\167\217\134</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>\217\136\219\140\216\177\216\167\219\140\216\180\218\175\216\177</single>\n      <multiple>\217\136\219\140\216\177\216\167\219\140\216\180\218\175\216\177\216\167\217\134</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>\217\133\216\170\216\177\216\172\217\133</single>\n      <multiple>\217\133\216\170\216\177\216\172\217\133\219\140\217\134</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>\217\136\219\140\216\177\216\167\219\140\216\180\218\175\216\177 \217\136 \217\133\216\170\216\177\216\172\217\133</single>\n      <multiple>\217\136\219\140\216\177\216\167\219\140\216\180\218\175\216\177\216\167\217\134 \217\136 \217\133\216\170\216\177\216\172\217\133\219\140\217\134</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>\217\136\219\140\216\177\216\167\219\140\216\180\218\175\216\177</single>\n      <multiple>\217\136\219\140\216\177\216\167\219\140\216\180\218\175\216\177\216\167\217\134</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>\217\136\219\140\216\177\216\167\219\140\216\180\218\175\216\177</single>\n      <multiple>\217\136\219\140\216\177\216\167\219\140\216\180\218\175\216\177\216\167\217\134</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>\217\133\216\170\216\177\216\172\217\133</single>\n      <multiple>\217\133\216\170\216\177\216\172\217\133\219\140\217\134</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>\217\136\219\140\216\177\216\167\219\140\216\180\218\175\216\177 \217\136 \217\133\216\170\216\177\216\172\217\133</single>\n      <multiple>\217\136\219\140\216\177\216\167\219\140\216\180\218\175\216\177\216\167\217\134 \217\136 \217\133\216\170\216\177\216\172\217\133\219\140\217\134</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">edited by</term>\n    <term name=\"editorial-director\" form=\"verb\">\217\136\219\140\216\177\216\167\216\179\216\170\217\135\226\128\140\219\140</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">\217\133\216\181\216\167\216\173\216\168\217\135 \216\170\217\136\216\179\216\183</term>\n    <term name=\"recipient\" form=\"verb\">\216\168\217\135</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">\216\170\216\177\216\172\217\133\217\135\226\128\140\219\140</term>\n    <term name=\"editortranslator\" form=\"verb\">\216\170\216\177\216\172\217\133\217\135 \217\136 \217\136\219\140\216\177\216\167\216\179\216\170\217\135\226\128\140\219\140</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">\216\170\217\136\216\179\216\183</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">\217\136\219\140\216\177\216\167\216\179\216\170\217\135\226\128\140\219\140</term>\n    <term name=\"editorial-director\" form=\"verb-short\">\217\136\219\140\216\177\216\167\216\179\216\170\217\135\226\128\140\219\140</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">\216\170\216\177\216\172\217\133\217\135\226\128\140\219\140</term>\n    <term name=\"editortranslator\" form=\"verb-short\">\216\170\216\177\216\172\217\133\217\135 \217\136 \217\136\219\140\216\177\216\167\216\179\216\170\217\135\226\128\140\219\140</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">\218\152\216\167\217\134\217\136\219\140\217\135</term>\n    <term name=\"month-02\">\217\129\217\136\216\177\219\140\217\135</term>\n    <term name=\"month-03\">\217\133\216\167\216\177\216\179</term>\n    <term name=\"month-04\">\216\162\217\136\216\177\219\140\217\132</term>\n    <term name=\"month-05\">\217\133\219\140</term>\n    <term name=\"month-06\">\218\152\217\136\216\166\217\134</term>\n    <term name=\"month-07\">\216\172\217\136\217\132\216\167\219\140</term>\n    <term name=\"month-08\">\216\162\218\175\217\136\216\179\216\170</term>\n    <term name=\"month-09\">\216\179\217\190\216\170\216\167\217\133\216\168\216\177</term>\n    <term name=\"month-10\">\216\167\218\169\216\170\216\168\216\177</term>\n    <term name=\"month-11\">\217\134\217\136\216\167\217\133\216\168\216\177</term>\n    <term name=\"month-12\">\216\175\216\179\216\167\217\133\216\168\216\177</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">\218\152\216\167\217\134\217\136\219\140\217\135</term>\n    <term name=\"month-02\" form=\"short\">\217\129\217\136\216\177\219\140\217\135</term>\n    <term name=\"month-03\" form=\"short\">\217\133\216\167\216\177\216\179</term>\n    <term name=\"month-04\" form=\"short\">\216\162\217\136\216\177\219\140\217\132</term>\n    <term name=\"month-05\" form=\"short\">\217\133\219\140</term>\n    <term name=\"month-06\" form=\"short\">\218\152\217\136\216\166\217\134</term>\n    <term name=\"month-07\" form=\"short\">\216\172\217\136\217\132\216\167\219\140</term>\n    <term name=\"month-08\" form=\"short\">\216\162\218\175\217\136\216\179\216\170</term>\n    <term name=\"month-09\" form=\"short\">\216\179\217\190\216\170\216\167\217\133\216\168\216\177</term>\n    <term name=\"month-10\" form=\"short\">\216\167\218\169\216\170\216\168\216\177</term>\n    <term name=\"month-11\" form=\"short\">\217\134\217\136\216\167\217\133\216\168\216\177</term>\n    <term name=\"month-12\" form=\"short\">\216\175\216\179\216\167\217\133\216\168\216\177</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">\216\168\217\135\216\167\216\177</term>\n    <term name=\"season-02\">\216\170\216\167\216\168\216\179\216\170\216\167\217\134</term>\n    <term name=\"season-03\">\217\190\216\167\219\140\219\140\216\178</term>\n    <term name=\"season-04\">\216\178\217\133\216\179\216\170\216\167\217\134</term>\n  </terms>\n</locale>\n"),("locales-fi-FI.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"fi-FI\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\". \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" suffix=\".\"/>\n    <date-part name=\"month\" suffix=\".\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">viitattu</term>\n    <term name=\"and\">ja</term>\n    <term name=\"and others\">ym.</term>\n    <term name=\"anonymous\">tuntematon</term>\n    <term name=\"anonymous\" form=\"short\">tuntematon</term>\n    <term name=\"at\">osoitteessa</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">tekij\195\164</term>\n    <term name=\"circa\">noin</term>\n    <term name=\"circa\" form=\"short\">n.</term>\n    <term name=\"cited\">viitattu</term>\n    <term name=\"edition\">\n      <single>painos</single>\n      <multiple>painokset</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">p.</term>\n    <term name=\"et-al\">ym.</term>\n    <term name=\"forthcoming\">tulossa</term>\n    <term name=\"from\">alkaen</term>\n    <term name=\"ibid\">mt.</term>\n    <term name=\"in\">teoksessa</term>\n    <term name=\"in press\">painossa</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">haastattelu</term>\n    <term name=\"letter\">kirje</term>\n    <term name=\"no date\">ei p\195\164iv\195\164m\195\164\195\164r\195\164\195\164</term>\n    <term name=\"no date\" form=\"short\">n.d.</term>\n    <term name=\"online\">verkossa</term>\n    <term name=\"presented at\">esitetty tilaisuudessa</term>\n    <term name=\"reference\">\n      <single>viittaus</single>\n      <multiple>viittaukset</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>viit..</single>\n      <multiple>viit.</multiple>\n    </term>\n    <term name=\"retrieved\">noudettu</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">eaa.</term>\n    <term name=\"bc\">jaa.</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\157</term>\n    <term name=\"close-quote\">\226\128\157</term>\n    <term name=\"open-inner-quote\">\226\128\153</term>\n    <term name=\"close-inner-quote\">\226\128\153</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">.</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">ensimm\195\164inen</term>\n    <term name=\"long-ordinal-02\">toinen</term>\n    <term name=\"long-ordinal-03\">kolmas</term>\n    <term name=\"long-ordinal-04\">nelj\195\164s</term>\n    <term name=\"long-ordinal-05\">viides</term>\n    <term name=\"long-ordinal-06\">kuudes</term>\n    <term name=\"long-ordinal-07\">seitsem\195\164s</term>\n    <term name=\"long-ordinal-08\">kahdeksas</term>\n    <term name=\"long-ordinal-09\">yhdeks\195\164s</term>\n    <term name=\"long-ordinal-10\">kymmenes</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>kirja</single>\n      <multiple>kirjat</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>luku</single>\n      <multiple>luvut</multiple>\n    </term>\n    <term name=\"column\">\n      <single>palsta</single>\n      <multiple>palstat</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>kuvio</single>\n      <multiple>kuviot</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folio</single>\n      <multiple>foliot</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>numero</single>\n      <multiple>numerot</multiple>\n    </term>\n    <term name=\"line\">\n      <single>rivi</single>\n      <multiple>rivit</multiple>\n    </term>\n    <term name=\"note\">\n      <single>muistiinpano</single>\n      <multiple>muistiinpanot</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opukset</multiple>\n    </term>\n    <term name=\"page\">\n      <single>sivu</single>\n      <multiple>sivut</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>kappale</single>\n      <multiple>kappaleet</multiple>\n    </term>\n    <term name=\"part\">\n      <single>osa</single>\n      <multiple>osat</multiple>\n    </term>\n    <term name=\"section\">\n      <single>osa</single>\n      <multiple>osat</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>s\195\164keist\195\182</single>\n      <multiple>s\195\164keist\195\182t</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>vuosikerta</single>\n      <multiple>vuosikerrat</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">kirja</term>\n    <term name=\"chapter\" form=\"short\">luku</term>\n    <term name=\"column\" form=\"short\">palsta</term>\n    <term name=\"figure\" form=\"short\">kuv.</term>\n    <term name=\"folio\" form=\"short\">fol.</term>\n    <term name=\"issue\" form=\"short\">nro</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op.</term>\n    <term name=\"page\" form=\"short\">\n      <single>s.</single>\n      <multiple>ss.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">kappale</term>\n    <term name=\"part\" form=\"short\">osa</term>\n    <term name=\"section\" form=\"short\">osa</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>s\195\164k.</single>\n      <multiple>s\195\164k.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>vol.</single>\n      <multiple>vol.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>toimittaja</single>\n      <multiple>toimittajat</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>toimittaja</single>\n      <multiple>toimittajat</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>suomentaja</single>\n      <multiple>suomentajat</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>toimittaja ja suomentaja</single>\n      <multiple>toimittajat ja suomentajat</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>toim.</single>\n      <multiple>toim.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>toim.</single>\n      <multiple>toim.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>suom.</single>\n      <multiple>suom.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>toim. ja suom.</single>\n      <multiple>toim. ja suom.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">toimittanut</term>\n    <term name=\"editorial-director\" form=\"verb\">toimittanut</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">haastatellut</term>\n    <term name=\"recipient\" form=\"verb\">vastaanottaja</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">suomentanut</term>\n    <term name=\"editortranslator\" form=\"verb\">toimittanut ja suomentanut</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\"/>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">toim.</term>\n    <term name=\"editorial-director\" form=\"verb-short\">toim.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">suom.</term>\n    <term name=\"editortranslator\" form=\"verb-short\">toim. ja suom.</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">tammikuu</term>\n    <term name=\"month-02\">helmikuu</term>\n    <term name=\"month-03\">maaliskuu</term>\n    <term name=\"month-04\">huhtikuu</term>\n    <term name=\"month-05\">toukokuu</term>\n    <term name=\"month-06\">kes\195\164kuu</term>\n    <term name=\"month-07\">hein\195\164kuu</term>\n    <term name=\"month-08\">elokuu</term>\n    <term name=\"month-09\">syyskuu</term>\n    <term name=\"month-10\">lokakuu</term>\n    <term name=\"month-11\">marraskuu</term>\n    <term name=\"month-12\">joulukuu</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">tammi</term>\n    <term name=\"month-02\" form=\"short\">helmi</term>\n    <term name=\"month-03\" form=\"short\">maalis</term>\n    <term name=\"month-04\" form=\"short\">huhti</term>\n    <term name=\"month-05\" form=\"short\">touko</term>\n    <term name=\"month-06\" form=\"short\">kes\195\164</term>\n    <term name=\"month-07\" form=\"short\">hein\195\164</term>\n    <term name=\"month-08\" form=\"short\">elo</term>\n    <term name=\"month-09\" form=\"short\">syys</term>\n    <term name=\"month-10\" form=\"short\">loka</term>\n    <term name=\"month-11\" form=\"short\">marras</term>\n    <term name=\"month-12\" form=\"short\">joulu</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">kev\195\164t</term>\n    <term name=\"season-02\">kes\195\164</term>\n    <term name=\"season-03\">syksy</term>\n    <term name=\"season-04\">talvi</term>\n  </terms>\n</locale>\n"),("locales-fr-CA.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"fr-CA\">\n  <info>\n    <translator>\n      <name>Gr\195\169goire Colly</name>\n    </translator>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\" limit-day-ordinals-to-day-1=\"true\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\" \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">consult\195\169 le</term>\n    <term name=\"and\">et</term>\n    <term name=\"and others\">et autres</term>\n    <term name=\"anonymous\">anonyme</term>\n    <term name=\"anonymous\" form=\"short\">anon.</term>\n    <term name=\"at\">sur</term>\n    <term name=\"available at\">disponible sur</term>\n    <term name=\"by\">par</term>\n    <term name=\"circa\">vers</term>\n    <term name=\"circa\" form=\"short\">v.</term>\n    <term name=\"cited\">cit\195\169</term>\n    <term name=\"edition\" gender=\"feminine\">\n      <single>\195\169dition</single>\n      <multiple>\195\169ditions</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">\195\169d.</term>\n    <term name=\"et-al\">et al.</term>\n    <term name=\"forthcoming\">\195\160 para\195\174tre</term>\n    <term name=\"from\">\195\160 l'adresse</term>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\">dans</term>\n    <term name=\"in press\">sous presse</term>\n    <term name=\"internet\">Internet</term>\n    <term name=\"interview\">entretien</term>\n    <term name=\"letter\">lettre</term>\n    <term name=\"no date\">sans date</term>\n    <term name=\"no date\" form=\"short\">s.&#160;d.</term>\n    <term name=\"online\">en ligne</term>\n    <term name=\"presented at\">pr\195\169sent\195\169 \195\160</term>\n    <term name=\"reference\">\n      <single>r\195\169f\195\169rence</single>\n      <multiple>r\195\169f\195\169rences</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>r\195\169f.</single>\n      <multiple>r\195\169f.</multiple>\n    </term>\n    <term name=\"retrieved\">consult\195\169</term>\n    <term name=\"scale\">\195\169chelle</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">apr. J.-C.</term>\n    <term name=\"bc\">av. J.-C.</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\194\171&#160;</term>\n    <term name=\"close-quote\">&#160;\194\187</term>\n    <term name=\"open-inner-quote\">\226\128\156</term>\n    <term name=\"close-inner-quote\">\226\128\157</term>\n    <term name=\"page-range-delimiter\">&#8209;</term> <!-- non-breaking hyphen -->\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">\225\181\137</term>\n   \t<term name=\"ordinal-01\" gender-form=\"feminine\" match=\"whole-number\">\202\179\225\181\137</term>\n    <term name=\"ordinal-01\" gender-form=\"masculine\" match=\"whole-number\">\225\181\137\202\179</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">premier</term>\n    <term name=\"long-ordinal-02\">deuxi\195\168me</term>\n    <term name=\"long-ordinal-03\">troisi\195\168me</term>\n    <term name=\"long-ordinal-04\">quatri\195\168me</term>\n    <term name=\"long-ordinal-05\">cinqui\195\168me</term>\n    <term name=\"long-ordinal-06\">sixi\195\168me</term>\n    <term name=\"long-ordinal-07\">septi\195\168me</term>\n    <term name=\"long-ordinal-08\">huiti\195\168me</term>\n    <term name=\"long-ordinal-09\">neuvi\195\168me</term>\n    <term name=\"long-ordinal-10\">dixi\195\168me</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>livre</single>\n      <multiple>livres</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>chapitre</single>\n      <multiple>chapitres</multiple>\n    </term>\n    <term name=\"column\">\n      <single>colonne</single>\n      <multiple>colonnes</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>figure</single>\n      <multiple>figures</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folio</single>\n      <multiple>folios</multiple>\n    </term>\n    <term name=\"issue\" gender=\"masculine\">\n      <single>num\195\169ro</single>\n      <multiple>num\195\169ros</multiple>\n    </term>\n    <term name=\"line\">\n      <single>ligne</single>\n      <multiple>lignes</multiple>\n    </term>\n    <term name=\"note\">\n      <single>note</single>\n      <multiple>notes</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opus</multiple>\n    </term>\n    <term name=\"page\">\n      <single>page</single>\n      <multiple>pages</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>paragraphe</single>\n      <multiple>paragraphes</multiple>\n    </term>\n    <term name=\"part\">\n      <single>partie</single>\n      <multiple>parties</multiple>\n    </term>\n    <term name=\"section\">\n      <single>section</single>\n      <multiple>sections</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>verset</single>\n      <multiple>versets</multiple>\n    </term>\n    <term name=\"volume\" gender=\"masculine\">\n      <single>volume</single>\n      <multiple>volumes</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">liv.</term>\n    <term name=\"chapter\" form=\"short\">chap.</term>\n    <term name=\"column\" form=\"short\">col.</term>\n    <term name=\"figure\" form=\"short\">fig.</term>\n    <term name=\"folio\" form=\"short\">\n      <single>f\225\181\146</single>\n      <multiple>f\225\181\146\203\162</multiple>\n    </term>\n    <term name=\"issue\" form=\"short\">\n      <single>n\225\181\146</single>\n      <multiple>n\225\181\146\203\162</multiple>\n    </term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op.</term>\n    <term name=\"page\" form=\"short\">\n      <single>p.</single>\n      <multiple>p.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">paragr.</term>\n    <term name=\"part\" form=\"short\">part.</term>\n    <term name=\"section\" form=\"short\">sect.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.&#160;v.</single>\n      <multiple>s.&#160;vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v.</single>\n      <multiple>v.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>vol.</single>\n      <multiple>vol.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>r\195\169alisateur</single>\n      <multiple>r\195\169alisateurs</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>\195\169diteur</single>\n      <multiple>\195\169diteurs</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>directeur</single>\n      <multiple>directeurs</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrateur</single>\n      <multiple>illustrateurs</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>traducteur</single>\n      <multiple>traducteurs</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>\195\169diteur et traducteur</single>\n      <multiple>\195\169diteurs et traducteurs</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>r\195\169al.</single>\n      <multiple>r\195\169al.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>\195\169d.</single>\n      <multiple>\195\169d.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dir.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ill.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>trad.</single>\n      <multiple>trad.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>\195\169d. et trad.</single>\n      <multiple>\195\169d. et trad.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">r\195\169alis\195\169 par</term>\n    <term name=\"editor\" form=\"verb\">\195\169dit\195\169 par</term>\n    <term name=\"editorial-director\" form=\"verb\">sous la direction de</term>\n    <term name=\"illustrator\" form=\"verb\">illustr\195\169 par</term>\n    <term name=\"interviewer\" form=\"verb\">entretien r\195\169alis\195\169 par</term>\n    <term name=\"recipient\" form=\"verb\">\195\160</term>\n    <term name=\"reviewed-author\" form=\"verb\">par</term>\n    <term name=\"translator\" form=\"verb\">traduit par</term>\n    <term name=\"editortranslator\" form=\"verb\">\195\169dit\195\169 et traduit par</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">par</term>\n    <term name=\"director\" form=\"verb-short\">r\195\169al. par</term>\n    <term name=\"editor\" form=\"verb-short\">\195\169d. par</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ss la dir. de</term>\n    <term name=\"illustrator\" form=\"verb-short\">ill. par</term>\n    <term name=\"translator\" form=\"verb-short\">trad. par</term>\n    <term name=\"editortranslator\" form=\"verb-short\">\195\169d. et trad. par</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\" gender=\"masculine\">janvier</term>\n    <term name=\"month-02\" gender=\"masculine\">f\195\169vrier</term>\n    <term name=\"month-03\" gender=\"masculine\">mars</term>\n    <term name=\"month-04\" gender=\"masculine\">avril</term>\n    <term name=\"month-05\" gender=\"masculine\">mai</term>\n    <term name=\"month-06\" gender=\"masculine\">juin</term>\n    <term name=\"month-07\" gender=\"masculine\">juillet</term>\n    <term name=\"month-08\" gender=\"masculine\">ao\195\187t</term>\n    <term name=\"month-09\" gender=\"masculine\">septembre</term>\n    <term name=\"month-10\" gender=\"masculine\">octobre</term>\n    <term name=\"month-11\" gender=\"masculine\">novembre</term>\n    <term name=\"month-12\" gender=\"masculine\">d\195\169cembre</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">janv.</term>\n    <term name=\"month-02\" form=\"short\">f\195\169vr.</term>\n    <term name=\"month-03\" form=\"short\">mars</term>\n    <term name=\"month-04\" form=\"short\">avr.</term>\n    <term name=\"month-05\" form=\"short\">mai</term>\n    <term name=\"month-06\" form=\"short\">juin</term>\n    <term name=\"month-07\" form=\"short\">juill.</term>\n    <term name=\"month-08\" form=\"short\">ao\195\187t</term>\n    <term name=\"month-09\" form=\"short\">sept.</term>\n    <term name=\"month-10\" form=\"short\">oct.</term>\n    <term name=\"month-11\" form=\"short\">nov.</term>\n    <term name=\"month-12\" form=\"short\">d\195\169c.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">printemps</term>\n    <term name=\"season-02\">\195\169t\195\169</term>\n    <term name=\"season-03\">automne</term>\n    <term name=\"season-04\">hiver</term>\n  </terms>\n</locale>\n"),("locales-fr-FR.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"fr-FR\">\n  <info>\n    <translator>\n      <name>Gr\195\169goire Colly</name>\n    </translator>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\" limit-day-ordinals-to-day-1=\"true\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\" \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">consult\195\169 le</term>\n    <term name=\"and\">et</term>\n    <term name=\"and others\">et autres</term>\n    <term name=\"anonymous\">anonyme</term>\n    <term name=\"anonymous\" form=\"short\">anon.</term>\n    <term name=\"at\">sur</term>\n    <term name=\"available at\">disponible sur</term>\n    <term name=\"by\">par</term>\n    <term name=\"circa\">vers</term>\n    <term name=\"circa\" form=\"short\">v.</term>\n    <term name=\"cited\">cit\195\169</term>\n    <term name=\"edition\" gender=\"feminine\">\n      <single>\195\169dition</single>\n      <multiple>\195\169ditions</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">\195\169d.</term>\n    <term name=\"et-al\">et al.</term>\n    <term name=\"forthcoming\">\195\160 para\195\174tre</term>\n    <term name=\"from\">\195\160 l'adresse</term>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\">in</term>\n    <term name=\"in press\">sous presse</term>\n    <term name=\"internet\">Internet</term>\n    <term name=\"interview\">entretien</term>\n    <term name=\"letter\">lettre</term>\n    <term name=\"no date\">sans date</term>\n    <term name=\"no date\" form=\"short\">s.&#160;d.</term>\n    <term name=\"online\">en ligne</term>\n    <term name=\"presented at\">pr\195\169sent\195\169 \195\160</term>\n    <term name=\"reference\">\n      <single>r\195\169f\195\169rence</single>\n      <multiple>r\195\169f\195\169rences</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>r\195\169f.</single>\n      <multiple>r\195\169f.</multiple>\n    </term>\n    <term name=\"retrieved\">consult\195\169</term>\n    <term name=\"scale\">\195\169chelle</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">apr. J.-C.</term>\n    <term name=\"bc\">av. J.-C.</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\194\171&#160;</term>\n    <term name=\"close-quote\">&#160;\194\187</term>\n    <term name=\"open-inner-quote\">\226\128\156</term>\n    <term name=\"close-inner-quote\">\226\128\157</term>\n    <term name=\"page-range-delimiter\">&#8209;</term> <!-- non-breaking hyphen -->\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">\225\181\137</term>\n    <term name=\"ordinal-01\" gender-form=\"feminine\" match=\"whole-number\">\202\179\225\181\137</term>\n    <term name=\"ordinal-01\" gender-form=\"masculine\" match=\"whole-number\">\225\181\137\202\179</term>\n    \n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">premier</term>\n    <term name=\"long-ordinal-02\">deuxi\195\168me</term>\n    <term name=\"long-ordinal-03\">troisi\195\168me</term>\n    <term name=\"long-ordinal-04\">quatri\195\168me</term>\n    <term name=\"long-ordinal-05\">cinqui\195\168me</term>\n    <term name=\"long-ordinal-06\">sixi\195\168me</term>\n    <term name=\"long-ordinal-07\">septi\195\168me</term>\n    <term name=\"long-ordinal-08\">huiti\195\168me</term>\n    <term name=\"long-ordinal-09\">neuvi\195\168me</term>\n    <term name=\"long-ordinal-10\">dixi\195\168me</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>livre</single>\n      <multiple>livres</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>chapitre</single>\n      <multiple>chapitres</multiple>\n    </term>\n    <term name=\"column\">\n      <single>colonne</single>\n      <multiple>colonnes</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>figure</single>\n      <multiple>figures</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folio</single>\n      <multiple>folios</multiple>\n    </term>\n    <term name=\"issue\" gender=\"masculine\">\n      <single>num\195\169ro</single>\n      <multiple>num\195\169ros</multiple>\n    </term>\n    <term name=\"line\">\n      <single>ligne</single>\n      <multiple>lignes</multiple>\n    </term>\n    <term name=\"note\">\n      <single>note</single>\n      <multiple>notes</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opus</multiple>\n    </term>\n    <term name=\"page\">\n      <single>page</single>\n      <multiple>pages</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>paragraphe</single>\n      <multiple>paragraphes</multiple>\n    </term>\n    <term name=\"part\">\n      <single>partie</single>\n      <multiple>parties</multiple>\n    </term>\n    <term name=\"section\">\n      <single>section</single>\n      <multiple>sections</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>verset</single>\n      <multiple>versets</multiple>\n    </term>\n    <term name=\"volume\" gender=\"masculine\">\n      <single>volume</single>\n      <multiple>volumes</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">liv.</term>\n    <term name=\"chapter\" form=\"short\">chap.</term>\n    <term name=\"column\" form=\"short\">col.</term>\n    <term name=\"figure\" form=\"short\">fig.</term>\n    <term name=\"folio\" form=\"short\">\n      <single>f\225\181\146</single>\n      <multiple>f\225\181\146\203\162</multiple>\n    </term>\n    <term name=\"issue\" form=\"short\">\n      <single>n\225\181\146</single>\n      <multiple>n\225\181\146\203\162</multiple>\n    </term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op.</term>\n    <term name=\"page\" form=\"short\">\n      <single>p.</single>\n      <multiple>p.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">paragr.</term>\n    <term name=\"part\" form=\"short\">part.</term>\n    <term name=\"section\" form=\"short\">sect.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.&#160;v.</single>\n      <multiple>s.&#160;vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v.</single>\n      <multiple>v.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>vol.</single>\n      <multiple>vol.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>r\195\169alisateur</single>\n      <multiple>r\195\169alisateurs</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>\195\169diteur</single>\n      <multiple>\195\169diteurs</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>directeur</single>\n      <multiple>directeurs</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrateur</single>\n      <multiple>illustrateurs</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>traducteur</single>\n      <multiple>traducteurs</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>\195\169diteur et traducteur</single>\n      <multiple>\195\169diteurs et traducteurs</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>r\195\169al.</single>\n      <multiple>r\195\169al.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>\195\169d.</single>\n      <multiple>\195\169d.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dir.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ill.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>trad.</single>\n      <multiple>trad.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>\195\169d. et trad.</single>\n      <multiple>\195\169d. et trad.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">r\195\169alis\195\169 par</term>\n    <term name=\"editor\" form=\"verb\">\195\169dit\195\169 par</term>\n    <term name=\"editorial-director\" form=\"verb\">sous la direction de</term>\n    <term name=\"illustrator\" form=\"verb\">illustr\195\169 par</term>\n    <term name=\"interviewer\" form=\"verb\">entretien r\195\169alis\195\169 par</term>\n    <term name=\"recipient\" form=\"verb\">\195\160</term>\n    <term name=\"reviewed-author\" form=\"verb\">par</term>\n    <term name=\"translator\" form=\"verb\">traduit par</term>\n    <term name=\"editortranslator\" form=\"verb\">\195\169dit\195\169 et traduit par</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">par</term>\n    <term name=\"director\" form=\"verb-short\">r\195\169al. par</term>\n    <term name=\"editor\" form=\"verb-short\">\195\169d. par</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ss la dir. de</term>\n    <term name=\"illustrator\" form=\"verb-short\">ill. par</term>\n    <term name=\"translator\" form=\"verb-short\">trad. par</term>\n    <term name=\"editortranslator\" form=\"verb-short\">\195\169d. et trad. par</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\" gender=\"masculine\">janvier</term>\n    <term name=\"month-02\" gender=\"masculine\">f\195\169vrier</term>\n    <term name=\"month-03\" gender=\"masculine\">mars</term>\n    <term name=\"month-04\" gender=\"masculine\">avril</term>\n    <term name=\"month-05\" gender=\"masculine\">mai</term>\n    <term name=\"month-06\" gender=\"masculine\">juin</term>\n    <term name=\"month-07\" gender=\"masculine\">juillet</term>\n    <term name=\"month-08\" gender=\"masculine\">ao\195\187t</term>\n    <term name=\"month-09\" gender=\"masculine\">septembre</term>\n    <term name=\"month-10\" gender=\"masculine\">octobre</term>\n    <term name=\"month-11\" gender=\"masculine\">novembre</term>\n    <term name=\"month-12\" gender=\"masculine\">d\195\169cembre</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">janv.</term>\n    <term name=\"month-02\" form=\"short\">f\195\169vr.</term>\n    <term name=\"month-03\" form=\"short\">mars</term>\n    <term name=\"month-04\" form=\"short\">avr.</term>\n    <term name=\"month-05\" form=\"short\">mai</term>\n    <term name=\"month-06\" form=\"short\">juin</term>\n    <term name=\"month-07\" form=\"short\">juill.</term>\n    <term name=\"month-08\" form=\"short\">ao\195\187t</term>\n    <term name=\"month-09\" form=\"short\">sept.</term>\n    <term name=\"month-10\" form=\"short\">oct.</term>\n    <term name=\"month-11\" form=\"short\">nov.</term>\n    <term name=\"month-12\" form=\"short\">d\195\169c.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">printemps</term>\n    <term name=\"season-02\">\195\169t\195\169</term>\n    <term name=\"season-03\">automne</term>\n    <term name=\"season-04\">hiver</term>\n  </terms>\n</locale>\n"),("locales-he-IL.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"he-IL\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\" \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">\215\146\215\153\215\169\215\148</term>\n    <term name=\"and\">\215\149</term>\n    <term name=\"and others\">and others</term>\n    <term name=\"anonymous\">anonymous</term>\n    <term name=\"anonymous\" form=\"short\">anon</term>\n    <term name=\"at\">-\215\145</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">by</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">cited</term>\n    <term name=\"edition\">\n      <single>edition</single>\n      <multiple>editions</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">ed</term>\n    <term name=\"et-al\">\215\149\215\144\215\151\215\168\215\153\215\157</term>\n    <term name=\"forthcoming\">forthcoming</term>\n    <term name=\"from\">\215\158\215\170\215\149\215\154</term>\n    <term name=\"ibid\">\215\169\215\157</term>\n    <term name=\"in\">\215\145\215\170\215\149\215\154</term>\n    <term name=\"in press\">in press</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">interview</term>\n    <term name=\"letter\">letter</term>\n    <term name=\"no date\">no date</term>\n    <term name=\"no date\" form=\"short\">nd</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">presented at the</term>\n    <term name=\"reference\">\n      <single>reference</single>\n      <multiple>references</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">\215\144\215\149\215\151\215\150\215\168</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">AD</term>\n    <term name=\"bc\">BC</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\156</term>\n    <term name=\"close-quote\">\226\128\157</term>\n    <term name=\"open-inner-quote\">\226\128\152</term>\n    <term name=\"close-inner-quote\">\226\128\153</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">th</term>\n    <term name=\"ordinal-01\">st</term>\n    <term name=\"ordinal-02\">nd</term>\n    <term name=\"ordinal-03\">rd</term>\n    <term name=\"ordinal-11\">th</term>\n    <term name=\"ordinal-12\">th</term>\n    <term name=\"ordinal-13\">th</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">first</term>\n    <term name=\"long-ordinal-02\">second</term>\n    <term name=\"long-ordinal-03\">third</term>\n    <term name=\"long-ordinal-04\">fourth</term>\n    <term name=\"long-ordinal-05\">fifth</term>\n    <term name=\"long-ordinal-06\">sixth</term>\n    <term name=\"long-ordinal-07\">seventh</term>\n    <term name=\"long-ordinal-08\">eighth</term>\n    <term name=\"long-ordinal-09\">ninth</term>\n    <term name=\"long-ordinal-10\">tenth</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>\215\161\215\164\215\168</single>\n      <multiple>\215\161\215\164\215\168\215\153\215\157</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>\215\164\215\168\215\167</single>\n      <multiple>\215\164\215\168\215\167\215\153\215\157</multiple>\n    </term>\n    <term name=\"column\">\n      <single>\215\152\215\149\215\168</single>\n      <multiple>\215\152\215\149\215\168\215\153\215\157</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>figure</single>\n      <multiple>figures</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folio</single>\n      <multiple>folios</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>\215\158\215\161\215\164\215\168</single>\n      <multiple>\215\158\215\161\215\164\215\168\215\153\215\157</multiple>\n    </term>\n    <term name=\"line\">\n      <single>\215\169\215\149\215\168\215\148</single>\n      <multiple>\215\169\215\149\215\168\215\149\215\170</multiple>\n    </term>\n    <term name=\"note\">\n      <single>note</single>\n      <multiple>notes</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>\215\144\215\149\215\164\215\149\215\161</single>\n      <multiple>\215\144\215\149\215\164\215\168\215\148</multiple>\n    </term>\n    <term name=\"page\">\n      <single>\215\162\215\158\215\149\215\147</single>\n      <multiple>\215\162\215\158\215\149\215\147\215\153\215\157</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>paragraph</single>\n      <multiple>\215\164\215\153\215\161\215\167\215\148</multiple>\n    </term>\n    <term name=\"part\">\n      <single>part</single>\n      <multiple>parts</multiple>\n    </term>\n    <term name=\"section\">\n      <single>section</single>\n      <multiple>sections</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>\215\145\215\153\215\170</single>\n      <multiple>\215\145\215\170\215\153\215\157</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>\215\155\215\168\215\154</single>\n      <multiple>\215\155\215\168\215\155\215\153\215\157</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">bk</term>\n    <term name=\"chapter\" form=\"short\">chap</term>\n    <term name=\"column\" form=\"short\">col</term>\n    <term name=\"figure\" form=\"short\">fig</term>\n    <term name=\"folio\" form=\"short\">f</term>\n    <term name=\"issue\" form=\"short\">no</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op</term>\n    <term name=\"page\" form=\"short\">\n      <single>'\215\162\215\158</single>\n      <multiple>'\215\162\215\158</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">para</term>\n    <term name=\"part\" form=\"short\">pt</term>\n    <term name=\"section\" form=\"short\">sec</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v</single>\n      <multiple>vv</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>vol</single>\n      <multiple>vols</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>\215\162\215\149\215\168\215\154</single>\n      <multiple>\215\162\215\149\215\168\215\155\215\153\215\157</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>\215\158\215\170\215\168\215\146\215\157</single>\n      <multiple>\215\158\215\170\215\168\215\146\215\158\215\153\215\157</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>editor &amp; translator</single>\n      <multiple>editors &amp; translators</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>ed</single>\n      <multiple>eds</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ed.</single>\n      <multiple>eds.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>tran</single>\n      <multiple>trans</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ed. &amp; tran.</single>\n      <multiple>eds. &amp; trans.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">\215\160\215\162\215\168\215\154 \215\162\"\215\153</term>\n    <term name=\"editorial-director\" form=\"verb\">edited by</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">interview by</term>\n    <term name=\"recipient\" form=\"verb\">to</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">\215\170\215\149\215\168\215\146\215\157 \215\162\"\215\153</term>\n    <term name=\"editortranslator\" form=\"verb\">edited &amp; translated by</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">by</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">ed</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">trans</term>\n    <term name=\"editortranslator\" form=\"verb-short\">ed. &amp; trans. by</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">\215\153\215\160\215\149\215\144\215\168</term>\n    <term name=\"month-02\">\215\164\215\145\215\168\215\149\215\144\215\168</term>\n    <term name=\"month-03\">\215\158\215\168\215\165</term>\n    <term name=\"month-04\">\215\144\215\164\215\168\215\153\215\156</term>\n    <term name=\"month-05\">\215\158\215\144\215\153</term>\n    <term name=\"month-06\">\215\153\215\149\215\160\215\153</term>\n    <term name=\"month-07\">\215\153\215\149\215\156\215\153</term>\n    <term name=\"month-08\">\215\144\215\149\215\146\215\149\215\161\215\152</term>\n    <term name=\"month-09\">\215\161\215\164\215\152\215\158\215\145\215\168</term>\n    <term name=\"month-10\">\215\144\215\149\215\167\215\152\215\149\215\145\215\168</term>\n    <term name=\"month-11\">\215\160\215\149\215\145\215\158\215\145\215\168</term>\n    <term name=\"month-12\">\215\147\215\166\215\158\215\145\215\168</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">Jan</term>\n    <term name=\"month-02\" form=\"short\">Feb</term>\n    <term name=\"month-03\" form=\"short\">Mar</term>\n    <term name=\"month-04\" form=\"short\">Apr</term>\n    <term name=\"month-05\" form=\"short\">May</term>\n    <term name=\"month-06\" form=\"short\">Jun</term>\n    <term name=\"month-07\" form=\"short\">Jul</term>\n    <term name=\"month-08\" form=\"short\">Aug</term>\n    <term name=\"month-09\" form=\"short\">Sep</term>\n    <term name=\"month-10\" form=\"short\">Oct</term>\n    <term name=\"month-11\" form=\"short\">Nov</term>\n    <term name=\"month-12\" form=\"short\">Dec</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">Spring</term>\n    <term name=\"season-02\">Summer</term>\n    <term name=\"season-03\">Autumn</term>\n    <term name=\"season-04\">Winter</term>\n  </terms>\n</locale>\n"),("locales-hr-HR.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"hr-HR\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\". \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\" suffix=\".\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"year\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" prefix=\"-\" range-delimiter=\"/\"/>\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" prefix=\"-\" range-delimiter=\"/\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">pristupljeno</term>\n    <term name=\"and\">i</term>\n    <term name=\"and others\">i ostali</term>\n    <term name=\"anonymous\">anonim</term>\n    <term name=\"anonymous\" form=\"short\">anon.</term>\n    <term name=\"at\">na</term>\n    <term name=\"available at\">pristupa\196\141no na</term>\n    <term name=\"by\">od</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">citirano</term>\n    <term name=\"edition\">\n      <single>izdanje</single>\n      <multiple>izdanja</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">izd.</term>\n    <term name=\"et-al\">i ostali</term>\n    <term name=\"forthcoming\">u pripremi</term>\n    <term name=\"from\">od</term>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\">u</term>\n    <term name=\"in press\">u \197\161tampi</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">intervju</term>\n    <term name=\"letter\">pismo</term>\n    <term name=\"no date\">bez datuma</term>\n    <term name=\"no date\" form=\"short\">bez datuma</term>\n    <term name=\"online\">na internetu</term>\n    <term name=\"presented at\">predstavljeno na</term>\n    <term name=\"reference\">\n      <single>reference</single>\n      <multiple>reference</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>ref.</multiple>\n    </term>\n    <term name=\"retrieved\">preuzeto</term>\n    <term name=\"scale\">skala</term>\n    <term name=\"version\">verzija</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">AD</term>\n    <term name=\"bc\">BC</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\158</term>\n    <term name=\"close-quote\">\226\128\156</term>\n    <term name=\"open-inner-quote\">\226\128\154</term>\n    <term name=\"close-inner-quote\">\226\128\152</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">th</term>\n    <term name=\"ordinal-01\">st</term>\n    <term name=\"ordinal-02\">nd</term>\n    <term name=\"ordinal-03\">rd</term>\n    <term name=\"ordinal-11\">th</term>\n    <term name=\"ordinal-12\">th</term>\n    <term name=\"ordinal-13\">th</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">prvi</term>\n    <term name=\"long-ordinal-02\">drugi</term>\n    <term name=\"long-ordinal-03\">tre\196\135i</term>\n    <term name=\"long-ordinal-04\">\196\141etvrti</term>\n    <term name=\"long-ordinal-05\">peti</term>\n    <term name=\"long-ordinal-06\">\197\161esti</term>\n    <term name=\"long-ordinal-07\">sedmi</term>\n    <term name=\"long-ordinal-08\">osmi</term>\n    <term name=\"long-ordinal-09\">deveti</term>\n    <term name=\"long-ordinal-10\">deseti</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>knjiga</single>\n      <multiple>knjige</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>poglavlje</single>\n      <multiple>poglavlja</multiple>\n    </term>\n    <term name=\"column\">\n      <single>kolona</single>\n      <multiple>kolone</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>crte\197\190</single>\n      <multiple>crte\197\190i</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folija</single>\n      <multiple>folije</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>broj</single>\n      <multiple>brojevi</multiple>\n    </term>\n    <term name=\"line\">\n      <single>linija</single>\n      <multiple>linije</multiple>\n    </term>\n    <term name=\"note\">\n      <single>bele\197\161ka</single>\n      <multiple>bele\197\161ke</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>stranica</single>\n      <multiple>stranice</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>paragraf</single>\n      <multiple>paragrafi</multiple>\n    </term>\n    <term name=\"part\">\n      <single>deo</single>\n      <multiple>delova</multiple>\n    </term>\n    <term name=\"section\">\n      <single>odeljak</single>\n      <multiple>odeljaka</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>strofa</single>\n      <multiple>strofe</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>tom</single>\n      <multiple>tomova</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">knj</term>\n    <term name=\"chapter\" form=\"short\">pog</term>\n    <term name=\"column\" form=\"short\">kol</term>\n    <term name=\"figure\" form=\"short\">\209\134\209\128\209\130</term>\n    <term name=\"folio\" form=\"short\">fol</term>\n    <term name=\"issue\" form=\"short\">izd</term>\n    <term name=\"line\" form=\"short\">l</term>\n    <term name=\"note\" form=\"short\">n</term>\n    <term name=\"opus\" form=\"short\">op</term>\n    <term name=\"page\" form=\"short\">\n      <single>str.</single>\n      <multiple>str.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">par</term>\n    <term name=\"part\" form=\"short\">deo</term>\n    <term name=\"section\" form=\"short\">od</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>s</single>\n      <multiple>s</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>tom</single>\n      <multiple>tomova</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>prire\196\145iva\196\141</single>\n      <multiple>prire\196\145iva\196\141i</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>prire\196\145iva\196\141</single>\n      <multiple>prire\196\145iva\196\141i</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>ilustrator</single>\n      <multiple>ilustratori</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>prevodilac</single>\n      <multiple>prevodioci</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>prire\196\145iva\196\141 &amp; prevodilac</single>\n      <multiple>prire\196\145iva\196\141i &amp; prevodioci</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>prir.</single>\n      <multiple>prir.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>prir.</single>\n      <multiple>prir.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>prir.</single>\n      <multiple>prir.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>il.</single>\n      <multiple>il.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>prev.</single>\n      <multiple>prev.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>prir. &amp; prev.</single>\n      <multiple>prir. &amp; prev.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">priredio</term>\n    <term name=\"editorial-director\" form=\"verb\">priredio</term>\n    <term name=\"illustrator\" form=\"verb\">ilustrovao</term>\n    <term name=\"interviewer\" form=\"verb\">intervjuisao</term>\n    <term name=\"recipient\" form=\"verb\">prima</term>\n    <term name=\"reviewed-author\" form=\"verb\">od</term>\n    <term name=\"translator\" form=\"verb\">preveo</term>\n    <term name=\"editortranslator\" form=\"verb\">priredio &amp; preveo by</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">by</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">prir.</term>\n    <term name=\"editorial-director\" form=\"verb-short\">prir.</term>\n    <term name=\"illustrator\" form=\"verb-short\">ilus.</term>\n    <term name=\"translator\" form=\"verb-short\">prev.</term>\n    <term name=\"editortranslator\" form=\"verb-short\">prir. &amp; prev. by</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">januar</term>\n    <term name=\"month-02\">februar</term>\n    <term name=\"month-03\">mart</term>\n    <term name=\"month-04\">april</term>\n    <term name=\"month-05\">maj</term>\n    <term name=\"month-06\">jun</term>\n    <term name=\"month-07\">jul</term>\n    <term name=\"month-08\">avgust</term>\n    <term name=\"month-09\">septembar</term>\n    <term name=\"month-10\">oktobar</term>\n    <term name=\"month-11\">novembar</term>\n    <term name=\"month-12\">decembar</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">jan.</term>\n    <term name=\"month-02\" form=\"short\">feb.</term>\n    <term name=\"month-03\" form=\"short\">mart</term>\n    <term name=\"month-04\" form=\"short\">apr.</term>\n    <term name=\"month-05\" form=\"short\">maj</term>\n    <term name=\"month-06\" form=\"short\">jun</term>\n    <term name=\"month-07\" form=\"short\">jul</term>\n    <term name=\"month-08\" form=\"short\">avg.</term>\n    <term name=\"month-09\" form=\"short\">sep.</term>\n    <term name=\"month-10\" form=\"short\">okt.</term>\n    <term name=\"month-11\" form=\"short\">nov.</term>\n    <term name=\"month-12\" form=\"short\">dec.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">prole\196\135e</term>\n    <term name=\"season-02\">leto</term>\n    <term name=\"season-03\">jesen</term>\n    <term name=\"season-04\">zima</term>\n  </terms>\n</locale>\n"),("locales-hu-HU.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"hu-HU\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"year\"/>\n    <date-part name=\"month\" prefix=\". \"/>\n    <date-part name=\"day\" prefix=\" \" suffix=\".\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"year\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" prefix=\".\"/>\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" prefix=\".\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">el\195\169r\195\169s</term>\n    <term name=\"and\">\195\169s</term>\n    <term name=\"and others\">\195\169s m\195\161sok</term>\n    <term name=\"anonymous\">n\195\169v n\195\169lk\195\188l</term>\n    <term name=\"anonymous\" form=\"short\">nn</term>\n    <term name=\"at\"/>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">by</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">id\195\169zi</term>\n    <term name=\"edition\">\n      <single>edition</single>\n      <multiple>editions</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">ed</term>\n    <term name=\"et-al\">et al.</term>\n    <term name=\"forthcoming\">megjelen\195\169s alatt</term>\n    <term name=\"from\">forr\195\161s</term>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\">in</term>\n    <term name=\"in press\">nyomtat\195\161s alatt</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">interj\195\186</term>\n    <term name=\"letter\">lev\195\169l</term>\n    <term name=\"no date\">no date</term>\n    <term name=\"no date\" form=\"short\">nd</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">el\197\145ad\195\161s</term>\n    <term name=\"reference\">\n      <single>reference</single>\n      <multiple>references</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">el\195\169r\195\169s</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">AD</term>\n    <term name=\"bc\">BC</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\158</term>\n    <term name=\"close-quote\">\226\128\157</term>\n    <term name=\"open-inner-quote\">\194\187</term>\n    <term name=\"close-inner-quote\">\194\171</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">th</term>\n    <term name=\"ordinal-01\">st</term>\n    <term name=\"ordinal-02\">nd</term>\n    <term name=\"ordinal-03\">rd</term>\n    <term name=\"ordinal-11\">th</term>\n    <term name=\"ordinal-12\">th</term>\n    <term name=\"ordinal-13\">th</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">first</term>\n    <term name=\"long-ordinal-02\">second</term>\n    <term name=\"long-ordinal-03\">third</term>\n    <term name=\"long-ordinal-04\">fourth</term>\n    <term name=\"long-ordinal-05\">fifth</term>\n    <term name=\"long-ordinal-06\">sixth</term>\n    <term name=\"long-ordinal-07\">seventh</term>\n    <term name=\"long-ordinal-08\">eighth</term>\n    <term name=\"long-ordinal-09\">ninth</term>\n    <term name=\"long-ordinal-10\">tenth</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>k\195\182nyv</single>\n      <multiple>k\195\182nyv</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>fejezet</single>\n      <multiple>fejezet</multiple>\n    </term>\n    <term name=\"column\">\n      <single>oszlop</single>\n      <multiple>oszlop</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>\195\161bra</single>\n      <multiple>\195\161bra</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>f\195\179li\195\161ns</single>\n      <multiple>f\195\179li\195\161ns</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>sz\195\161m</single>\n      <multiple>sz\195\161m</multiple>\n    </term>\n    <term name=\"line\">\n      <single>sor</single>\n      <multiple>sor</multiple>\n    </term>\n    <term name=\"note\">\n      <single>jegyzet</single>\n      <multiple>jegyzet</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>oldal</single>\n      <multiple>oldal</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>bekezd\195\169s</single>\n      <multiple>bekezd\195\169s</multiple>\n    </term>\n    <term name=\"part\">\n      <single>r\195\169sz</single>\n      <multiple>r\195\169sz</multiple>\n    </term>\n    <term name=\"section\">\n      <single>szakasz</single>\n      <multiple>szakasz</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>versszak</single>\n      <multiple>versszak</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>k\195\182tet</single>\n      <multiple>k\195\182tet</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">k\195\182nyv</term>\n    <term name=\"chapter\" form=\"short\">fej</term>\n    <term name=\"column\" form=\"short\">oszl</term>\n    <term name=\"figure\" form=\"short\">\195\161br</term>\n    <term name=\"folio\" form=\"short\">fol</term>\n    <term name=\"issue\" form=\"short\">sz</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op</term>\n    <term name=\"page\" form=\"short\">\n      <single>o</single>\n      <multiple>o</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">bek</term>\n    <term name=\"part\" form=\"short\">r\195\169sz</term>\n    <term name=\"section\" form=\"short\">szak</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>vsz</single>\n      <multiple>vsz</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>vol</single>\n      <multiple>vols</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>szerkeszt\197\145</single>\n      <multiple>szerkeszt\197\145</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>ford\195\173t\195\179</single>\n      <multiple>ford\195\173t\195\179</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>editor &amp; translator</single>\n      <multiple>editors &amp; translators</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>szerk</single>\n      <multiple>szerk</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ed.</single>\n      <multiple>eds.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>ford</single>\n      <multiple>ford</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ed. &amp; tran.</single>\n      <multiple>eds. &amp; trans.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">szerkesztette</term>\n    <term name=\"editorial-director\" form=\"verb\">edited by</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">interj\195\186k\195\169sz\195\173t\197\145</term>\n    <term name=\"recipient\" form=\"verb\">c\195\173mzett</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">ford\195\173totta</term>\n    <term name=\"editortranslator\" form=\"verb\">edited &amp; translated by</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">by</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">szerk</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">ford</term>\n    <term name=\"editortranslator\" form=\"verb-short\">ed. &amp; trans. by</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">janu\195\161r</term>\n    <term name=\"month-02\">febru\195\161r</term>\n    <term name=\"month-03\">m\195\161rcius</term>\n    <term name=\"month-04\">\195\161prilis</term>\n    <term name=\"month-05\">m\195\161jus</term>\n    <term name=\"month-06\">j\195\186nius</term>\n    <term name=\"month-07\">j\195\186lius</term>\n    <term name=\"month-08\">augusztus</term>\n    <term name=\"month-09\">szeptember</term>\n    <term name=\"month-10\">okt\195\179ber</term>\n    <term name=\"month-11\">november</term>\n    <term name=\"month-12\">december</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">jan</term>\n    <term name=\"month-02\" form=\"short\">febr</term>\n    <term name=\"month-03\" form=\"short\">m\195\161rc</term>\n    <term name=\"month-04\" form=\"short\">\195\161pr</term>\n    <term name=\"month-05\" form=\"short\">m\195\161j</term>\n    <term name=\"month-06\" form=\"short\">j\195\186n</term>\n    <term name=\"month-07\" form=\"short\">j\195\186l</term>\n    <term name=\"month-08\" form=\"short\">aug</term>\n    <term name=\"month-09\" form=\"short\">szept</term>\n    <term name=\"month-10\" form=\"short\">okt</term>\n    <term name=\"month-11\" form=\"short\">nov</term>\n    <term name=\"month-12\" form=\"short\">dec</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">Spring</term>\n    <term name=\"season-02\">Summer</term>\n    <term name=\"season-03\">Autumn</term>\n    <term name=\"season-04\">Winter</term>\n  </terms>\n</locale>\n"),("locales-is-IS.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"is-IS\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\". \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" suffix=\".\"/>\n    <date-part name=\"month\" suffix=\".\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">s\195\179tt</term>\n    <term name=\"and\">og</term>\n    <term name=\"and others\">og fleiri</term>\n    <term name=\"anonymous\">nafnlaus</term>\n    <term name=\"anonymous\" form=\"short\">nafnl.</term>\n    <term name=\"at\">af</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">eftir</term>\n    <term name=\"circa\">sirka</term>\n    <term name=\"circa\" form=\"short\">u.\195\190.b.</term>\n    <term name=\"cited\">tilvitnun</term>\n    <term name=\"edition\">\n      <single>\195\186tg\195\161fa</single>\n      <multiple>\195\186tg\195\161fur</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">\195\186tg.</term>\n    <term name=\"et-al\">o.fl.</term>\n    <term name=\"forthcoming\">\195\179birt</term>\n    <term name=\"from\">af</term>\n    <term name=\"ibid\">sama heimild</term>\n    <term name=\"in\">\195\173</term>\n    <term name=\"in press\">\195\173 prentun</term>\n    <term name=\"internet\">rafr\195\166nt</term>\n    <term name=\"interview\">vi\195\176tal</term>\n    <term name=\"letter\">br\195\169f</term>\n    <term name=\"no date\">engin dagsetning</term>\n    <term name=\"no date\" form=\"short\">e.d.</term>\n    <term name=\"online\">rafr\195\166nt</term>\n    <term name=\"presented at\">flutt \195\161</term>\n    <term name=\"reference\">\n      <single>tilvitnun</single>\n      <multiple>tilvitnanir</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>tilv.</single>\n      <multiple>tilv.</multiple>\n    </term>\n    <term name=\"retrieved\">s\195\179tt</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">e.Kr.</term>\n    <term name=\"bc\">f.Kr.</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\158</term>\n    <term name=\"close-quote\">\226\128\156</term>\n    <term name=\"open-inner-quote\">\226\128\152</term>\n    <term name=\"close-inner-quote\">\226\128\153</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">.</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">fyrsti</term>\n    <term name=\"long-ordinal-02\">annar</term>\n    <term name=\"long-ordinal-03\">\195\190ri\195\176ji</term>\n    <term name=\"long-ordinal-04\">fj\195\179r\195\176i</term>\n    <term name=\"long-ordinal-05\">fimmti</term>\n    <term name=\"long-ordinal-06\">sj\195\182tti</term>\n    <term name=\"long-ordinal-07\">sj\195\182undi</term>\n    <term name=\"long-ordinal-08\">\195\161ttundi</term>\n    <term name=\"long-ordinal-09\">n\195\173undi</term>\n    <term name=\"long-ordinal-10\">t\195\173undi</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>b\195\179k</single>\n      <multiple>b\195\166kur</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>kafli</single>\n      <multiple>kaflar</multiple>\n    </term>\n    <term name=\"column\">\n      <single>d\195\161lkur</single>\n      <multiple>d\195\161lkar</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>mynd</single>\n      <multiple>myndir</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>handrit</single>\n      <multiple>handrit</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>n\195\186mer</single>\n      <multiple>n\195\186mer</multiple>\n    </term>\n    <term name=\"line\">\n      <single>l\195\173na</single>\n      <multiple>l\195\173nur</multiple>\n    </term>\n    <term name=\"note\">\n      <single>skilabo\195\176</single>\n      <multiple>skilabo\195\176</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>t\195\179nverk</single>\n      <multiple>t\195\179nverk</multiple>\n    </term>\n    <term name=\"page\">\n      <single>bla\195\176s\195\173\195\176a</single>\n      <multiple>bla\195\176s\195\173\195\176ur</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>m\195\161lsgrein</single>\n      <multiple>m\195\161lsgreinar</multiple>\n    </term>\n    <term name=\"part\">\n      <single>hluti</single>\n      <multiple>hlutar</multiple>\n    </term>\n    <term name=\"section\">\n      <single>hluti</single>\n      <multiple>hlutar</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>vers</single>\n      <multiple>vers</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>bindi</single>\n      <multiple>bindi</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">b.</term>\n    <term name=\"chapter\" form=\"short\">k.</term>\n    <term name=\"column\" form=\"short\">d.</term>\n    <term name=\"figure\" form=\"short\">mynd.</term>\n    <term name=\"folio\" form=\"short\">handr.</term>\n    <term name=\"issue\" form=\"short\">nr.</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">t\195\179nv.</term>\n    <term name=\"page\" form=\"short\">\n      <single>bls.</single>\n      <multiple>bls.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">m\195\161lsgr.</term>\n    <term name=\"part\" form=\"short\">hl.</term>\n    <term name=\"section\" form=\"short\">hl.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v.</single>\n      <multiple>v.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>bindi</single>\n      <multiple>bindi</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>ritstj\195\179ri</single>\n      <multiple>ritstj\195\179rar</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>ritstj\195\179ri</single>\n      <multiple>ritstj\195\179rar</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>\195\190\195\189\195\176andi</single>\n      <multiple>\195\190\195\189\195\176endur</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>ritstj\195\179ri og \195\190\195\189\195\176andi</single>\n      <multiple>ritstj\195\179rar og \195\190\195\189\195\176endur</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>ritstj.</single>\n      <multiple>ritstj.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ritstj.</single>\n      <multiple>ritstj.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>\195\190\195\189\195\176.</single>\n      <multiple>\195\190\195\189\195\176.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ritstj. og \195\190\195\189\195\176.</single>\n      <multiple>ritstj. og \195\190\195\189\195\176.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">ritstj\195\179ri</term>\n    <term name=\"editorial-director\" form=\"verb\">ritstj\195\179ri</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">vi\195\176tal t\195\179k</term>\n    <term name=\"recipient\" form=\"verb\">til</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">\195\190\195\189ddi</term>\n    <term name=\"editortranslator\" form=\"verb\">ritstj\195\179ri og \195\190\195\189\195\176andi</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">eftir</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">ritst.</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ritst.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">\195\190\195\189\195\176.</term>\n    <term name=\"editortranslator\" form=\"verb-short\">ritst. og \195\190\195\189\195\176.</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">jan\195\186ar</term>\n    <term name=\"month-02\">febr\195\186ar</term>\n    <term name=\"month-03\">mars</term>\n    <term name=\"month-04\">apr\195\173l</term>\n    <term name=\"month-05\">ma\195\173</term>\n    <term name=\"month-06\">j\195\186n\195\173</term>\n    <term name=\"month-07\">j\195\186l\195\173</term>\n    <term name=\"month-08\">\195\161g\195\186st</term>\n    <term name=\"month-09\">september</term>\n    <term name=\"month-10\">okt\195\179ber</term>\n    <term name=\"month-11\">n\195\179vember</term>\n    <term name=\"month-12\">desember</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">jan.</term>\n    <term name=\"month-02\" form=\"short\">feb.</term>\n    <term name=\"month-03\" form=\"short\">mar.</term>\n    <term name=\"month-04\" form=\"short\">apr.</term>\n    <term name=\"month-05\" form=\"short\">ma\195\173</term>\n    <term name=\"month-06\" form=\"short\">j\195\186n.</term>\n    <term name=\"month-07\" form=\"short\">j\195\186l.</term>\n    <term name=\"month-08\" form=\"short\">\195\161g\195\186.</term>\n    <term name=\"month-09\" form=\"short\">sep.</term>\n    <term name=\"month-10\" form=\"short\">okt.</term>\n    <term name=\"month-11\" form=\"short\">n\195\179v.</term>\n    <term name=\"month-12\" form=\"short\">des.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">vor</term>\n    <term name=\"season-02\">sumar</term>\n    <term name=\"season-03\">haust</term>\n    <term name=\"season-04\">vetur</term>\n  </terms>\n</locale>\n"),("locales-it-IT.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"it-IT\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\" \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">consultato</term>\n    <term name=\"and\">e</term>\n    <term name=\"and others\">e altri</term>\n    <term name=\"anonymous\">anonimo</term>\n    <term name=\"anonymous\" form=\"short\">anon.</term>\n    <term name=\"at\">a</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">di</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">citato</term>\n    <term name=\"edition\">\n      <single>edizione</single>\n      <multiple>edizioni</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">ed.</term>\n    <term name=\"et-al\">et al.</term>\n    <term name=\"forthcoming\">futuro</term>\n    <term name=\"from\">da</term>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\">in</term>\n    <term name=\"in press\">in stampa</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">intervista</term>\n    <term name=\"letter\">lettera</term>\n    <term name=\"no date\">senza data</term>\n    <term name=\"no date\" form=\"short\">s.d.</term>\n    <term name=\"online\">in linea</term>\n    <term name=\"presented at\">presentato al</term>\n    <term name=\"reference\">\n      <single>reference</single>\n      <multiple>references</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">recuperato</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">d.C.</term>\n    <term name=\"bc\">a.C.</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\194\171</term>\n    <term name=\"close-quote\">\194\187</term>\n    <term name=\"open-inner-quote\">\226\128\156</term>\n    <term name=\"close-inner-quote\">\226\128\157</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">\194\176</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">prima</term>\n    <term name=\"long-ordinal-02\">seconda</term>\n    <term name=\"long-ordinal-03\">terza</term>\n    <term name=\"long-ordinal-04\">quarta</term>\n    <term name=\"long-ordinal-05\">quinta</term>\n    <term name=\"long-ordinal-06\">sesta</term>\n    <term name=\"long-ordinal-07\">settima</term>\n    <term name=\"long-ordinal-08\">ottava</term>\n    <term name=\"long-ordinal-09\">nona</term>\n    <term name=\"long-ordinal-10\">decima</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>libro</single>\n      <multiple>libri</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>capitolo</single>\n      <multiple>capitoli</multiple>\n    </term>\n    <term name=\"column\">\n      <single>colonna</single>\n      <multiple>colonne</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>figura</single>\n      <multiple>figure</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>foglio</single>\n      <multiple>fogli</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>numero</single>\n      <multiple>numeri</multiple>\n    </term>\n    <term name=\"line\">\n      <single>riga</single>\n      <multiple>righe</multiple>\n    </term>\n    <term name=\"note\">\n      <single>nota</single>\n      <multiple>note</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opera</single>\n      <multiple>opere</multiple>\n    </term>\n    <term name=\"page\">\n      <single>pagina</single>\n      <multiple>pagine</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>capoverso</single>\n      <multiple>capoversi</multiple>\n    </term>\n    <term name=\"part\">\n      <single>parte</single>\n      <multiple>parti</multiple>\n    </term>\n    <term name=\"section\">\n      <single>paragrafo</single>\n      <multiple>paragrafi</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>verso</single>\n      <multiple>versi</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>volume</single>\n      <multiple>volumi</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">lib.</term>\n    <term name=\"chapter\" form=\"short\">cap.</term>\n    <term name=\"column\" form=\"short\">col.</term>\n    <term name=\"figure\" form=\"short\">fig.</term>\n    <term name=\"folio\" form=\"short\">fgl.</term>\n    <term name=\"issue\" form=\"short\">n.</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op.</term>\n    <term name=\"page\" form=\"short\">\n      <single>pag.</single>\n      <multiple>pagg.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">cpv.</term>\n    <term name=\"part\" form=\"short\">pt.</term>\n    <term name=\"section\" form=\"short\">par.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v.</single>\n      <multiple>vv.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>vol.</single>\n      <multiple>vol.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>curatore</single>\n      <multiple>curatori</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>traduttore</single>\n      <multiple>traduttori</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>curatore e traduttore</single>\n      <multiple>curatori e tradutori</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>a c. di</single>\n      <multiple>a c. di</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ed.</single>\n      <multiple>eds.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>trad.</single>\n      <multiple>trad.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>a c. di e trad. da</single>\n      <multiple>a c. di e trad. da</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">a cura di</term>\n    <term name=\"editorial-director\" form=\"verb\">edited by</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">intervista di</term>\n    <term name=\"recipient\" form=\"verb\">a</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">tradotto da</term>\n    <term name=\"editortranslator\" form=\"verb\">a cura di e tradotto da</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">di</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">a c. di</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">trad. da</term>\n    <term name=\"editortranslator\" form=\"verb-short\">a c. di e trad. da</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">gennaio</term>\n    <term name=\"month-02\">febbraio</term>\n    <term name=\"month-03\">marzo</term>\n    <term name=\"month-04\">aprile</term>\n    <term name=\"month-05\">maggio</term>\n    <term name=\"month-06\">giugno</term>\n    <term name=\"month-07\">luglio</term>\n    <term name=\"month-08\">agosto</term>\n    <term name=\"month-09\">settembre</term>\n    <term name=\"month-10\">ottobre</term>\n    <term name=\"month-11\">novembre</term>\n    <term name=\"month-12\">dicembre</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">gen.</term>\n    <term name=\"month-02\" form=\"short\">feb.</term>\n    <term name=\"month-03\" form=\"short\">mar.</term>\n    <term name=\"month-04\" form=\"short\">apr.</term>\n    <term name=\"month-05\" form=\"short\">mag.</term>\n    <term name=\"month-06\" form=\"short\">giu.</term>\n    <term name=\"month-07\" form=\"short\">lug.</term>\n    <term name=\"month-08\" form=\"short\">ago.</term>\n    <term name=\"month-09\" form=\"short\">set.</term>\n    <term name=\"month-10\" form=\"short\">ott.</term>\n    <term name=\"month-11\" form=\"short\">nov.</term>\n    <term name=\"month-12\" form=\"short\">dic.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">primavera</term>\n    <term name=\"season-02\">estate</term>\n    <term name=\"season-03\">autunno</term>\n    <term name=\"season-04\">inverno</term>\n  </terms>\n</locale>\n"),("locales-ja-JP.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"ja-JP\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"year\" suffix=\"\229\185\180\"/>\n    <date-part name=\"month\" form=\"numeric\" suffix=\"\230\156\136\"/>\n    <date-part name=\"day\" suffix=\"\230\151\165\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"year\" suffix=\"\229\185\180\"/>\n    <date-part name=\"month\" form=\"numeric\" suffix=\"\230\156\136\"/>\n    <date-part name=\"day\" suffix=\"\230\151\165\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">\227\130\162\227\130\175\227\130\187\227\130\185</term>\n    <term name=\"and\">\227\129\168</term>\n    <term name=\"and others\">and others</term>\n    <term name=\"anonymous\">anonymous</term>\n    <term name=\"anonymous\" form=\"short\">anon</term>\n    <term name=\"at\">at</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">by</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">cited</term>\n    <term name=\"edition\">\n      <single>edition</single>\n      <multiple>editions</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">ed</term>\n    <term name=\"et-al\">\228\187\150</term>\n    <term name=\"forthcoming\">\232\191\145\229\136\138</term>\n    <term name=\"from\">\227\129\139\227\130\137</term>\n    <term name=\"ibid\">\229\137\141\230\142\178</term>\n    <term name=\"in\"/>\n    <term name=\"in press\">in press</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">interview</term>\n    <term name=\"letter\">letter</term>\n    <term name=\"no date\">no date</term>\n    <term name=\"no date\" form=\"short\">\230\151\165\228\187\152\227\129\170\227\129\151</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">presented at the</term>\n    <term name=\"reference\">\n      <single>reference</single>\n      <multiple>references</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">\232\170\173\227\129\191\232\190\188\227\129\191</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">AD</term>\n    <term name=\"bc\">BC</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\227\128\140</term>\n    <term name=\"close-quote\">\227\128\141</term>\n    <term name=\"open-inner-quote\">\227\128\142</term>\n    <term name=\"close-inner-quote\">\227\128\143</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">th</term>\n    <term name=\"ordinal-01\">st</term>\n    <term name=\"ordinal-02\">nd</term>\n    <term name=\"ordinal-03\">rd</term>\n    <term name=\"ordinal-11\">th</term>\n    <term name=\"ordinal-12\">th</term>\n    <term name=\"ordinal-13\">th</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">first</term>\n    <term name=\"long-ordinal-02\">second</term>\n    <term name=\"long-ordinal-03\">third</term>\n    <term name=\"long-ordinal-04\">fourth</term>\n    <term name=\"long-ordinal-05\">fifth</term>\n    <term name=\"long-ordinal-06\">sixth</term>\n    <term name=\"long-ordinal-07\">seventh</term>\n    <term name=\"long-ordinal-08\">eighth</term>\n    <term name=\"long-ordinal-09\">ninth</term>\n    <term name=\"long-ordinal-10\">tenth</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>book</single>\n      <multiple>books</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>chapter</single>\n      <multiple>chapters</multiple>\n    </term>\n    <term name=\"column\">\n      <single>column</single>\n      <multiple>columns</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>figure</single>\n      <multiple>figures</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folio</single>\n      <multiple>folios</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>number</single>\n      <multiple>numbers</multiple>\n    </term>\n    <term name=\"line\">\n      <single>\232\161\140</single>\n      <multiple>\232\161\140</multiple>\n    </term>\n    <term name=\"note\">\n      <single>note</single>\n      <multiple>notes</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>\227\131\154\227\131\188\227\130\184</single>\n      <multiple>\227\131\154\227\131\188\227\130\184</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>\230\174\181\232\144\189</single>\n      <multiple>\230\174\181\232\144\189</multiple>\n    </term>\n    <term name=\"part\">\n      <single>part</single>\n      <multiple>parts</multiple>\n    </term>\n    <term name=\"section\">\n      <single>section</single>\n      <multiple>sections</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>verse</single>\n      <multiple>verses</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>volume</single>\n      <multiple>volumes</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">bk</term>\n    <term name=\"chapter\" form=\"short\">chap</term>\n    <term name=\"column\" form=\"short\">col</term>\n    <term name=\"figure\" form=\"short\">fig</term>\n    <term name=\"folio\" form=\"short\">f</term>\n    <term name=\"issue\" form=\"short\">\229\143\183</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op</term>\n    <term name=\"page\" form=\"short\">\n      <single>p</single>\n      <multiple>p</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">para</term>\n    <term name=\"part\" form=\"short\">pt</term>\n    <term name=\"section\" form=\"short\">sec</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v</single>\n      <multiple>vv</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>vol</single>\n      <multiple>vols</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>\231\183\168\233\155\134\232\128\133</single>\n      <multiple>\231\183\168\233\155\134\232\128\133</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>\231\191\187\232\168\179\232\128\133</single>\n      <multiple>\231\191\187\232\168\179\232\128\133</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>editor &amp; translator</single>\n      <multiple>editors &amp; translators</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>\231\183\168\233\155\134\232\128\133</single>\n      <multiple>\231\183\168\233\155\134\232\128\133</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ed.</single>\n      <multiple>eds.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>\231\191\187\232\168\179\232\128\133</single>\n      <multiple>\231\191\187\232\168\179\232\128\133</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ed. &amp; tran.</single>\n      <multiple>eds. &amp; trans.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">\231\183\168\233\155\134\232\128\133\239\188\154</term>\n    <term name=\"editorial-director\" form=\"verb\">edited by</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">interview by</term>\n    <term name=\"recipient\" form=\"verb\">to</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">\231\191\187\232\168\179\232\128\133\239\188\154</term>\n    <term name=\"editortranslator\" form=\"verb\">edited &amp; translated by</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">by</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">ed</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">trans</term>\n    <term name=\"editortranslator\" form=\"verb-short\">ed. &amp; trans. by</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">1\230\156\136</term>\n    <term name=\"month-02\">2\230\156\136</term>\n    <term name=\"month-03\">3\230\156\136</term>\n    <term name=\"month-04\">4\230\156\136</term>\n    <term name=\"month-05\">5\230\156\136</term>\n    <term name=\"month-06\">6\230\156\136</term>\n    <term name=\"month-07\">7\230\156\136</term>\n    <term name=\"month-08\">8\230\156\136</term>\n    <term name=\"month-09\">9\230\156\136</term>\n    <term name=\"month-10\">10\230\156\136</term>\n    <term name=\"month-11\">11\230\156\136</term>\n    <term name=\"month-12\">12\230\156\136</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">1\230\156\136</term>\n    <term name=\"month-02\" form=\"short\">2\230\156\136</term>\n    <term name=\"month-03\" form=\"short\">3\230\156\136</term>\n    <term name=\"month-04\" form=\"short\">4\230\156\136</term>\n    <term name=\"month-05\" form=\"short\">5\230\156\136</term>\n    <term name=\"month-06\" form=\"short\">6\230\156\136</term>\n    <term name=\"month-07\" form=\"short\">7\230\156\136</term>\n    <term name=\"month-08\" form=\"short\">8\230\156\136</term>\n    <term name=\"month-09\" form=\"short\">9\230\156\136</term>\n    <term name=\"month-10\" form=\"short\">10\230\156\136</term>\n    <term name=\"month-11\" form=\"short\">11\230\156\136</term>\n    <term name=\"month-12\" form=\"short\">12\230\156\136</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">Spring</term>\n    <term name=\"season-02\">Summer</term>\n    <term name=\"season-03\">Autumn</term>\n    <term name=\"season-04\">Winter</term>\n  </terms>\n</locale>\n"),("locales-km-KH.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"km-KH\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" form=\"numeric\" suffix=\"\226\128\139\"/>\n    <date-part name=\"month\" suffix=\"\226\128\139\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">accessed</term>\n    <term name=\"and\">and</term>\n    <term name=\"and others\">and others</term>\n    <term name=\"anonymous\">anonymous</term>\n    <term name=\"anonymous\" form=\"short\">anon.</term>\n    <term name=\"at\">at</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">by</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">cited</term>\n    <term name=\"edition\">\n      <single>edition</single>\n      <multiple>editions</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">ed.</term>\n    <term name=\"et-al\">et al.</term>\n    <term name=\"forthcoming\">forthcoming</term>\n    <term name=\"from\">from</term>\n    <term name=\"ibid\">ibid</term>\n    <term name=\"in\">in</term>\n    <term name=\"in press\">in press</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">interview</term>\n    <term name=\"letter\">letter</term>\n    <term name=\"no date\">no date</term>\n    <term name=\"no date\" form=\"short\">n.d.</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">presented at the</term>\n    <term name=\"reference\">\n      <single>reference</single>\n      <multiple>references</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">retrieved</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">AD</term>\n    <term name=\"bc\">BC</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\156</term>\n    <term name=\"close-quote\">\226\128\157</term>\n    <term name=\"open-inner-quote\">\226\128\152</term>\n    <term name=\"close-inner-quote\">\226\128\153</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">th</term>\n    <term name=\"ordinal-01\">st</term>\n    <term name=\"ordinal-02\">nd</term>\n    <term name=\"ordinal-03\">rd</term>\n    <term name=\"ordinal-11\">th</term>\n    <term name=\"ordinal-12\">th</term>\n    <term name=\"ordinal-13\">th</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">\225\158\145\225\158\184\225\158\152\225\158\189\225\158\153</term>\n    <term name=\"long-ordinal-02\">\225\158\145\225\158\184\225\158\150\225\158\184\225\158\154</term>\n    <term name=\"long-ordinal-03\">\225\158\145\225\158\184\225\158\148\225\158\184</term>\n    <term name=\"long-ordinal-04\">\225\158\145\225\158\184\225\158\148\225\158\189\225\158\147</term>\n    <term name=\"long-ordinal-05\">\225\158\145\225\158\184\225\158\148\225\159\146\225\158\154\225\158\182\225\159\134</term>\n    <term name=\"long-ordinal-06\">\225\158\145\225\158\184\225\158\148\225\159\146\225\158\154\225\158\182\225\159\134\225\158\152\225\158\189\225\158\153</term>\n    <term name=\"long-ordinal-07\">\225\158\145\225\158\184\225\158\148\225\159\146\225\158\154\225\158\182\225\159\134\225\158\150\225\158\184\225\158\154</term>\n    <term name=\"long-ordinal-08\">\225\158\145\225\158\184\225\158\148\225\159\146\225\158\154\225\158\182\225\159\134\225\158\148\225\158\184</term>\n    <term name=\"long-ordinal-09\">\225\158\145\225\158\184\225\158\148\225\159\146\225\158\154\225\158\182\225\159\134\225\158\148\225\158\189\225\158\147</term>\n    <term name=\"long-ordinal-10\">\225\158\145\225\158\184\225\158\138\225\158\148\225\159\139\225\158\152\225\158\189\225\158\153</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>\225\158\159\225\159\128\225\158\156\225\158\151\225\159\133</single>\n      <multiple>\225\158\159\225\159\128\225\158\156\225\158\151\225\159\133</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>\225\158\135\225\159\134\225\158\150\225\158\188\225\158\128</single>\n      <multiple>\225\158\135\225\159\134\225\158\150\225\158\188\225\158\128</multiple>\n    </term>\n    <term name=\"column\">\n      <single>\225\158\128\225\158\182\225\158\161\225\159\132\225\158\147</single>\n      <multiple>\225\158\128\225\158\182\225\158\161\225\159\132\225\158\147</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>\225\158\143\225\158\189\225\158\155\225\159\129\225\158\129</single>\n      <multiple>\225\158\143\225\158\189\225\158\155\225\159\129\225\158\129</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folio</single>\n      <multiple>folios</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>\225\158\133\225\159\134\225\158\147\225\158\189\225\158\147</single>\n      <multiple>\225\158\133\225\159\134\225\158\147\225\158\189\225\158\147</multiple>\n    </term>\n    <term name=\"line\">\n      <single>\225\158\148\225\158\147\225\159\146\225\158\145\225\158\182\225\158\143\225\159\139</single>\n      <multiple>\225\158\148\225\158\147\225\159\146\225\158\145\225\158\182\225\158\143\225\159\139</multiple>\n    </term>\n    <term name=\"note\">\n      <single>\225\158\128\225\159\134\225\158\142\225\158\143\225\159\139\225\158\133\225\159\134\225\158\142\225\158\182\225\159\134</single>\n      <multiple>\225\158\128\225\159\134\225\158\142\225\158\143\225\159\139\225\158\133\225\159\134\225\158\142\225\158\182\225\159\134</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>\225\158\145\225\159\134\225\158\150\225\159\144\225\158\154</single>\n      <multiple>\225\158\145\225\159\134\225\158\150\225\159\144\225\158\154</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>\225\158\128\225\158\144\225\158\182\225\158\129\225\158\142\225\159\146\225\158\140</single>\n      <multiple>\225\158\128\225\158\144\225\158\182\225\158\129\225\158\142\225\159\146\225\158\140</multiple>\n    </term>\n    <term name=\"part\">\n      <single>\225\158\135\225\159\134\225\158\150\225\158\188\225\158\128</single>\n      <multiple>\225\158\135\225\159\134\225\158\150\225\158\188\225\158\128</multiple>\n    </term>\n    <term name=\"section\">\n      <single>\225\158\149\225\159\146\225\158\147\225\159\130\225\158\128</single>\n      <multiple>\225\158\149\225\159\146\225\158\147\225\159\130\225\158\128</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>verse</single>\n      <multiple>verses</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>\225\158\156\225\159\137\225\158\187\225\158\155</single>\n      <multiple>\225\158\156\225\159\137\225\158\187\225\158\155</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">bk.</term>\n    <term name=\"chapter\" form=\"short\">chap.</term>\n    <term name=\"column\" form=\"short\">col.</term>\n    <term name=\"figure\" form=\"short\">fig.</term>\n    <term name=\"folio\" form=\"short\">f.</term>\n    <term name=\"issue\" form=\"short\">no.</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op.</term>\n    <term name=\"page\" form=\"short\">\n      <single>p.</single>\n      <multiple>pp.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">para.</term>\n    <term name=\"part\" form=\"short\">pt.</term>\n    <term name=\"section\" form=\"short\">sec.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v.</single>\n      <multiple>vv.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>vol.</single>\n      <multiple>vols.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single/>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>translator</single>\n      <multiple>translator</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>editor &amp; translator</single>\n      <multiple>editors &amp; translators</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>ed.</single>\n      <multiple>eds.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ed.</single>\n      <multiple>eds.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>tran.</single>\n      <multiple>trans.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ed. &amp; tran.</single>\n      <multiple>eds. &amp; trans.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">edited by</term>\n    <term name=\"editorial-director\" form=\"verb\">edited by</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">interview by</term>\n    <term name=\"recipient\" form=\"verb\">to</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">translated by</term>\n    <term name=\"editortranslator\" form=\"verb\">edited &amp; translated by</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">by</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">ed.</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">trans.</term>\n    <term name=\"editortranslator\" form=\"verb-short\">ed. &amp; trans. by</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">\225\158\152\225\158\128\225\158\154\225\158\182</term>\n    <term name=\"month-02\">\225\158\128\225\158\187\225\158\152\225\159\146\225\158\151\225\159\136</term>\n    <term name=\"month-03\">\225\158\152\225\158\184\225\158\147\225\158\182</term>\n    <term name=\"month-04\">\225\158\152\225\159\129\225\158\159\225\158\182</term>\n    <term name=\"month-05\">\225\158\167\225\158\159\225\158\151\225\158\182</term>\n    <term name=\"month-06\">\225\158\152\225\158\183\225\158\144\225\158\187\225\158\147\225\158\182</term>\n    <term name=\"month-07\">\225\158\128\225\158\128\225\159\146\225\158\128\225\158\138\225\158\182</term>\n    <term name=\"month-08\">\225\158\159\225\158\184\225\158\160\225\158\182</term>\n    <term name=\"month-09\">\225\158\128\225\158\137\225\159\146\225\158\137\225\158\182</term>\n    <term name=\"month-10\">\225\158\143\225\158\187\225\158\155\225\158\182</term>\n    <term name=\"month-11\">\225\158\156\225\158\183\225\158\133\225\159\146\225\158\134\225\158\183\225\158\128\225\158\182</term>\n    <term name=\"month-12\">\225\158\146\225\159\146\225\158\147\225\158\188</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">Jan.</term>\n    <term name=\"month-02\" form=\"short\">Feb.</term>\n    <term name=\"month-03\" form=\"short\">Mar.</term>\n    <term name=\"month-04\" form=\"short\">Apr.</term>\n    <term name=\"month-05\" form=\"short\">May</term>\n    <term name=\"month-06\" form=\"short\">Jun.</term>\n    <term name=\"month-07\" form=\"short\">Jul.</term>\n    <term name=\"month-08\" form=\"short\">Aug.</term>\n    <term name=\"month-09\" form=\"short\">Sep.</term>\n    <term name=\"month-10\" form=\"short\">Oct.</term>\n    <term name=\"month-11\" form=\"short\">Nov.</term>\n    <term name=\"month-12\" form=\"short\">Dec.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">Spring</term>\n    <term name=\"season-02\">Summer</term>\n    <term name=\"season-03\">Autumn</term>\n    <term name=\"season-04\">Winter</term>\n  </terms>\n</locale>\n"),("locales-ko-KR.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"ko-KR\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"year\" suffix=\"\235\133\132\"/>\n    <date-part name=\"month\" form=\"numeric\" prefix=\" \" suffix=\"\236\155\148\"/>\n    <date-part name=\"day\" prefix=\" \" suffix=\"\236\157\188\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"year\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" prefix=\"/\"/>\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" prefix=\"/\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">\236\160\145\234\183\188\235\144\156</term>\n    <term name=\"and\">\236\153\128/\234\179\188</term>\n    <term name=\"and others\">and others</term>\n    <term name=\"anonymous\">anonymous</term>\n    <term name=\"anonymous\" form=\"short\">anon</term>\n    <term name=\"at\">at</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">by</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">cited</term>\n    <term name=\"edition\">\n      <single>edition</single>\n      <multiple>editions</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">ed</term>\n    <term name=\"et-al\">\234\184\176\237\131\128</term>\n    <term name=\"forthcoming\">\234\183\188\234\176\132</term>\n    <term name=\"from\">(\236\156\188)\235\161\156\235\182\128\237\132\176</term>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\">in</term>\n    <term name=\"in press\">in press</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">interview</term>\n    <term name=\"letter\">letter</term>\n    <term name=\"no date\">no date</term>\n    <term name=\"no date\" form=\"short\">\236\157\188\236\158\144 \236\151\134\236\157\140</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">presented at the</term>\n    <term name=\"reference\">\n      <single>reference</single>\n      <multiple>references</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">retrieved</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">AD</term>\n    <term name=\"bc\">BC</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\156</term>\n    <term name=\"close-quote\">\226\128\157</term>\n    <term name=\"open-inner-quote\">\226\128\152</term>\n    <term name=\"close-inner-quote\">\226\128\153</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">th</term>\n    <term name=\"ordinal-01\">st</term>\n    <term name=\"ordinal-02\">nd</term>\n    <term name=\"ordinal-03\">rd</term>\n    <term name=\"ordinal-11\">th</term>\n    <term name=\"ordinal-12\">th</term>\n    <term name=\"ordinal-13\">th</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">first</term>\n    <term name=\"long-ordinal-02\">second</term>\n    <term name=\"long-ordinal-03\">third</term>\n    <term name=\"long-ordinal-04\">fourth</term>\n    <term name=\"long-ordinal-05\">fifth</term>\n    <term name=\"long-ordinal-06\">sixth</term>\n    <term name=\"long-ordinal-07\">seventh</term>\n    <term name=\"long-ordinal-08\">eighth</term>\n    <term name=\"long-ordinal-09\">ninth</term>\n    <term name=\"long-ordinal-10\">tenth</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>book</single>\n      <multiple>books</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>chapter</single>\n      <multiple>chapters</multiple>\n    </term>\n    <term name=\"column\">\n      <single>column</single>\n      <multiple>columns</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>figure</single>\n      <multiple>figures</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folio</single>\n      <multiple>folios</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>number</single>\n      <multiple>numbers</multiple>\n    </term>\n    <term name=\"line\">\n      <single>\237\150\137</single>\n      <multiple>\237\150\137</multiple>\n    </term>\n    <term name=\"note\">\n      <single>note</single>\n      <multiple>notes</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>\237\142\152\236\157\180\236\167\128</single>\n      <multiple>\237\142\152\236\157\180\236\167\128</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>\235\139\168\235\157\189</single>\n      <multiple>\235\139\168\235\157\189</multiple>\n    </term>\n    <term name=\"part\">\n      <single>part</single>\n      <multiple>parts</multiple>\n    </term>\n    <term name=\"section\">\n      <single>section</single>\n      <multiple>sections</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>verse</single>\n      <multiple>verses</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>volume</single>\n      <multiple>volumes</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">bk</term>\n    <term name=\"chapter\" form=\"short\">chap</term>\n    <term name=\"column\" form=\"short\">col</term>\n    <term name=\"figure\" form=\"short\">fig</term>\n    <term name=\"folio\" form=\"short\">f</term>\n    <term name=\"issue\" form=\"short\">\237\152\184</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op</term>\n    <term name=\"page\" form=\"short\">\n      <single>p</single>\n      <multiple>pp</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">para</term>\n    <term name=\"part\" form=\"short\">pt</term>\n    <term name=\"section\" form=\"short\">sec</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v</single>\n      <multiple>vv</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>vol</single>\n      <multiple>vols</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>\237\142\184\236\167\145\236\158\144</single>\n      <multiple>\237\142\184\236\167\145\236\158\144</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>\235\178\136\236\151\173\236\158\144</single>\n      <multiple>\235\178\136\236\151\173\236\158\144</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>editor &amp; translator</single>\n      <multiple>editors &amp; translators</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>\237\142\184\236\167\145\236\158\144</single>\n      <multiple>\237\142\184\236\167\145\236\158\144</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ed.</single>\n      <multiple>eds.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>\235\178\136\236\151\173\236\158\144</single>\n      <multiple>\235\178\136\236\151\173\236\158\144</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ed. &amp; tran.</single>\n      <multiple>eds. &amp; trans.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">\237\142\184\236\167\145\236\158\144\239\188\154</term>\n    <term name=\"editorial-director\" form=\"verb\">edited by</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">interview by</term>\n    <term name=\"recipient\" form=\"verb\">to</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">\235\178\136\236\151\173\236\158\144\239\188\154</term>\n    <term name=\"editortranslator\" form=\"verb\">edited &amp; translated by</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">by</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">ed</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">trans</term>\n    <term name=\"editortranslator\" form=\"verb-short\">ed. &amp; trans. by</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">1\236\155\148</term>\n    <term name=\"month-02\">2\236\155\148</term>\n    <term name=\"month-03\">3\236\155\148</term>\n    <term name=\"month-04\">4\236\155\148</term>\n    <term name=\"month-05\">5\236\155\148</term>\n    <term name=\"month-06\">6\236\155\148</term>\n    <term name=\"month-07\">7\236\155\148</term>\n    <term name=\"month-08\">8\236\155\148</term>\n    <term name=\"month-09\">9\236\155\148</term>\n    <term name=\"month-10\">10\236\155\148</term>\n    <term name=\"month-11\">11\236\155\148</term>\n    <term name=\"month-12\">12\236\155\148</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">1</term>\n    <term name=\"month-02\" form=\"short\">2</term>\n    <term name=\"month-03\" form=\"short\">3</term>\n    <term name=\"month-04\" form=\"short\">4</term>\n    <term name=\"month-05\" form=\"short\">5</term>\n    <term name=\"month-06\" form=\"short\">6</term>\n    <term name=\"month-07\" form=\"short\">7</term>\n    <term name=\"month-08\" form=\"short\">8</term>\n    <term name=\"month-09\" form=\"short\">9</term>\n    <term name=\"month-10\" form=\"short\">10</term>\n    <term name=\"month-11\" form=\"short\">11</term>\n    <term name=\"month-12\" form=\"short\">12</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">Spring</term>\n    <term name=\"season-02\">Summer</term>\n    <term name=\"season-03\">Autumn</term>\n    <term name=\"season-04\">Winter</term>\n  </terms>\n</locale>\n"),("locales-lt-LT.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"lt-LT\">\n  <info>\n    <translator>\n      <name>Valdemaras Klumbys</name>\n    </translator>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\" delimiter=\" \">\n\n    <!-- \"2011 m. lapkri\196\141io 1 d.\" -->\n    <date-part name=\"year\" suffix=\" m.\"/>\n    <date-part name=\"month\"/>\n    <date-part name=\"day\" form=\"numeric\" suffix=\" d.\"/>\n  </date>\n  <date form=\"numeric\" delimiter=\"-\">\n\n    <!-- \"2011-11-01\" -->\n    <date-part name=\"year\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\"/>\n    <date-part name=\"day\" form=\"numeric-leading-zeros\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">\197\190i\197\171r\196\151ta</term>\n    <term name=\"and\">ir</term>\n    <term name=\"and others\">ir kt.</term>\n    <term name=\"anonymous\">anonimas</term>\n    <term name=\"anonymous\" form=\"short\">anon.</term>\n    <term name=\"at\"/>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\"/>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">ca.</term>\n    <term name=\"cited\">cituojama pagal</term>\n    <term name=\"edition\">\n      <single>leidimas</single>\n      <multiple>leidimai</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">leid.</term>\n    <term name=\"et-al\">et al.</term>\n    <term name=\"forthcoming\">ruo\197\161iamas</term>\n    <term name=\"from\"/>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\"/>\n    <term name=\"in press\">spaudoje</term>\n    <term name=\"internet\">prieiga per internet\196\133</term>\n    <term name=\"interview\">interviu</term>\n    <term name=\"letter\">lai\197\161kas</term>\n    <term name=\"no date\">sine anno</term>\n    <term name=\"no date\" form=\"short\">s.a.</term>\n    <term name=\"online\">interaktyvus</term>\n    <term name=\"presented at\">pristatytas</term>\n    <term name=\"reference\">\n      <single>nuoroda</single>\n      <multiple>nuorodos</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>nuor.</single>\n      <multiple>nuor.</multiple>\n    </term>\n    <term name=\"retrieved\">gauta</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">po Kr.</term>\n    <term name=\"bc\">pr. Kr.</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\158</term>\n    <term name=\"close-quote\">\226\128\156</term>\n    <term name=\"open-inner-quote\">,</term>\n    <term name=\"close-inner-quote\">\226\128\152</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">-asis</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">pirmasis</term>\n    <term name=\"long-ordinal-02\">antrasis</term>\n    <term name=\"long-ordinal-03\">tre\196\141iasis</term>\n    <term name=\"long-ordinal-04\">ketvirtasis</term>\n    <term name=\"long-ordinal-05\">penktasis</term>\n    <term name=\"long-ordinal-06\">\197\161e\197\161tasis</term>\n    <term name=\"long-ordinal-07\">septintasis</term>\n    <term name=\"long-ordinal-08\">a\197\161tuntasis</term>\n    <term name=\"long-ordinal-09\">devintasis</term>\n    <term name=\"long-ordinal-10\">de\197\161imtasis</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>knyga</single>\n      <multiple>knygos</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>skyrius</single>\n      <multiple>skyriai</multiple>\n    </term>\n    <term name=\"column\">\n      <single>skiltis</single>\n      <multiple>skiltys</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>iliustracija</single>\n      <multiple>iliustracijos</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>lapas</single>\n      <multiple>lapai</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>numeris</single>\n      <multiple>numeriai</multiple>\n    </term>\n    <term name=\"line\">\n      <single>eilut\196\151</single>\n      <multiple>eilut\196\151s</multiple>\n    </term>\n    <term name=\"note\">\n      <single>pastaba</single>\n      <multiple>pastabos</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>puslapis</single>\n      <multiple>puslapiai</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>pastraipa</single>\n      <multiple>pastraipos</multiple>\n    </term>\n    <term name=\"part\">\n      <single>dalis</single>\n      <multiple>dalys</multiple>\n    </term>\n    <term name=\"section\">\n      <single>poskyris</single>\n      <multiple>poskyriai</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>\197\190i\197\171r\196\151k</single>\n      <multiple>\197\190i\197\171r\196\151k</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>eil\196\151ra\197\161tis</single>\n      <multiple>eil\196\151ra\197\161\196\141iai</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>tomas</single>\n      <multiple>tomai</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">kn.</term>\n    <term name=\"chapter\" form=\"short\">sk.</term>\n    <term name=\"column\" form=\"short\">skilt.</term>\n    <term name=\"figure\" form=\"short\">il.</term>\n    <term name=\"folio\" form=\"short\">l.</term>\n    <term name=\"issue\" form=\"short\">nr.</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op.</term>\n    <term name=\"page\" form=\"short\">\n      <single>p.</single>\n      <multiple>p.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">pastr.</term>\n    <term name=\"part\" form=\"short\">d.</term>\n    <term name=\"section\" form=\"short\">posk.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>\197\190r.</single>\n      <multiple>\197\190r.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>eil\196\151r.</single>\n      <multiple>eil\196\151r.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>t.</single>\n      <multiple>t.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>sudarytojas</single>\n      <multiple>sudarytojai</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>atsakingasis redaktorius</single>\n      <multiple>atsakingieji redaktoriai</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>vert\196\151jas</single>\n      <multiple>vert\196\151jai</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>sudarytojas ir vert\196\151jas</single>\n      <multiple>sudarytojai ir vert\196\151jai</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>sud.</single>\n      <multiple>sud.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ats. red.</single>\n      <multiple>ats. red.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>vert.</single>\n      <multiple>vert.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>sud. ir vert.</single>\n      <multiple>sud. ir vert.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">sudar\196\151</term>\n    <term name=\"editorial-director\" form=\"verb\">pareng\196\151</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">interviu \196\151m\196\151</term>\n    <term name=\"recipient\" form=\"verb\">gavo</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">vert\196\151</term>\n    <term name=\"editortranslator\" form=\"verb\">sudar\196\151 ir vert\196\151</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\"/>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">sud.</term>\n    <term name=\"editorial-director\" form=\"verb-short\">pareng.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">vert.</term>\n    <term name=\"editortranslator\" form=\"verb-short\">sud. ir vert.</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">sausio</term>\n    <term name=\"month-02\">vasario</term>\n    <term name=\"month-03\">kovo</term>\n    <term name=\"month-04\">baland\197\190io</term>\n    <term name=\"month-05\">gegu\197\190\196\151s</term>\n    <term name=\"month-06\">bir\197\190elio</term>\n    <term name=\"month-07\">liepos</term>\n    <term name=\"month-08\">rugpj\197\171\196\141io</term>\n    <term name=\"month-09\">rugs\196\151jo</term>\n    <term name=\"month-10\">spalio</term>\n    <term name=\"month-11\">lapkri\196\141io</term>\n    <term name=\"month-12\">gruod\197\190io</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">saus.</term>\n    <term name=\"month-02\" form=\"short\">vas.</term>\n    <term name=\"month-03\" form=\"short\">kovo</term>\n    <term name=\"month-04\" form=\"short\">bal.</term>\n    <term name=\"month-05\" form=\"short\">geg.</term>\n    <term name=\"month-06\" form=\"short\">bir\197\190.</term>\n    <term name=\"month-07\" form=\"short\">liep.</term>\n    <term name=\"month-08\" form=\"short\">rugpj.</term>\n    <term name=\"month-09\" form=\"short\">rugs.</term>\n    <term name=\"month-10\" form=\"short\">spal.</term>\n    <term name=\"month-11\" form=\"short\">lapkr.</term>\n    <term name=\"month-12\" form=\"short\">gruod\197\190.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">pavasaris</term>\n    <term name=\"season-02\">vasara</term>\n    <term name=\"season-03\">ruduo</term>\n    <term name=\"season-04\">\197\190iema</term>\n  </terms>\n</locale>\n"),("locales-lv-LV.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"lv-LV\">\n  <info>\n    <translator>\n      <name>Andris Lupgins</name>\n    </translator>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-12-27T11:40:58+02:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\" delimiter=\" \">\n    <!-- \"2012. gada 28. mart\196\129\" -->\n    <date-part name=\"year\" suffix=\". gada\"/>\n    <date-part name=\"day\" form=\"numeric\" suffix=\".\"/>\n    <date-part name=\"month\"/>\n  </date>\n  <date form=\"numeric\" delimiter=\".\">\n    <!-- \"28.03.2012.\" -->\n    <date-part name=\"day\" form=\"numeric\"/>\n    <date-part name=\"month\" form=\"numeric\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">skat\196\171ts</term>\n    <term name=\"ad\">m.\196\147.</term>\n    <term name=\"and\">un</term>\n    <term name=\"and others\">un citi</term>\n    <term name=\"anonymous\">anon\196\171ms</term>\n    <term name=\"anonymous\" form=\"short\">anon.</term>\n    <term name=\"at\"/>\n    <term name=\"available at\">pieejams</term>\n    <term name=\"bc\">p.m.\196\147.</term>\n    <term name=\"by\"/>\n    <term name=\"circa\">apm\196\147ram</term>\n    <term name=\"circa\" form=\"short\">apm.</term>\n    <term name=\"cited\">cit\196\147ts</term>\n    <term name=\"edition\" gender=\"feminine\">\n      <single>redakcija</single>\n      <multiple>redakcijas</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">red.</term>\n    <term name=\"et-al\">u.c.</term>\n    <term name=\"forthcoming\">gaid\196\129ms</term>\n    <term name=\"from\">no</term>\n    <term name=\"ibid\">turpat</term>\n    <term name=\"in\">no</term>\n    <term name=\"in press\">pres\196\147</term>\n    <term name=\"internet\">internets</term>\n    <term name=\"interview\">intervija</term>\n    <term name=\"letter\">v\196\147stule</term>\n    <term name=\"no date\">bez datuma</term>\n    <term name=\"no date\" form=\"short\">b.g.</term>\n    <term name=\"online\">tie\197\161saiste</term>\n    <term name=\"presented at\">iesniegts</term>\n    <term name=\"reference\">\n      <single>atsauce</single>\n      <multiple>atsauces</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ats.</single>\n      <multiple>ats.</multiple>\n    </term>\n    <term name=\"retrieved\">ieg\197\171ts</term>\n    <term name=\"scale\">m\196\147rogs</term>\n    <term name=\"version\">versija</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\"</term>\n    <term name=\"close-quote\">\"</term>\n    <term name=\"open-inner-quote\">\"</term>\n    <term name=\"close-inner-quote\">\"</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">-ais</term>\n    <term name=\"ordinal\" gender-form=\"feminine\">-\196\129</term>\n    \n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">pirmais</term>\n    <term name=\"long-ordinal-02\">otrais</term>\n    <term name=\"long-ordinal-03\">tre\197\161ais</term>\n    <term name=\"long-ordinal-04\">ceturtais</term>\n    <term name=\"long-ordinal-05\">piektais</term>\n    <term name=\"long-ordinal-06\">sestais</term>\n    <term name=\"long-ordinal-07\">sept\196\171tais</term>\n    <term name=\"long-ordinal-08\">astotais</term>\n    <term name=\"long-ordinal-09\">dev\196\171tais</term>\n    <term name=\"long-ordinal-10\">desmitais</term>\n\n    <term name=\"long-ordinal-01\" gender-form=\"feminine\">pirm\196\129</term>\n    <term name=\"long-ordinal-02\" gender-form=\"feminine\">otr\196\129</term>\n    <term name=\"long-ordinal-03\" gender-form=\"feminine\">tre\197\161\196\129</term>\n    <term name=\"long-ordinal-04\" gender-form=\"feminine\">ceturt\196\129</term>\n    <term name=\"long-ordinal-05\" gender-form=\"feminine\">piekt\196\129</term>\n    <term name=\"long-ordinal-06\" gender-form=\"feminine\">sest\196\129</term>\n    <term name=\"long-ordinal-07\" gender-form=\"feminine\">sept\196\171t\196\129</term>\n    <term name=\"long-ordinal-08\" gender-form=\"feminine\">astot\196\129</term>\n    <term name=\"long-ordinal-09\" gender-form=\"feminine\">dev\196\171t\196\129</term>\n    <term name=\"long-ordinal-10\" gender-form=\"feminine\">desmit\196\129</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>gr\196\129mata</single>\n      <multiple>gr\196\129matas</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>noda\196\188a</single>\n      <multiple>noda\196\188as</multiple>\n    </term>\n    <term name=\"column\">\n      <single>sleja</single>\n      <multiple>slejas</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>ilustr\196\129cija</single>\n      <multiple>ilustr\196\129cijas</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folio</single>\n      <multiple>folio</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>numurs</single>\n      <multiple>numuri</multiple>\n    </term>\n    <term name=\"line\">\n      <single>rinda</single>\n      <multiple>rindas</multiple>\n    </term>\n    <term name=\"note\">\n      <single>piez\196\171me</single>\n      <multiple>piez\196\171mes</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opuss</single>\n      <multiple>opusi</multiple>\n    </term>\n    <term name=\"page\">\n      <single>lappuse</single>\n      <multiple>lappuses</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>rindkopa</single>\n      <multiple>rindkopas</multiple>\n    </term>\n    <term name=\"part\">\n      <single>da\196\188a</single>\n      <multiple>da\196\188as</multiple>\n    </term>\n    <term name=\"section\">\n      <single>apak\197\161noda\196\188a</single>\n      <multiple>apak\197\161noda\196\188as</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>skat\196\171t</single>\n      <multiple>skat\196\171t</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>pants</single>\n      <multiple>panti</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>s\196\147jums</single>\n      <multiple>s\196\147jumi</multiple>\n    </term>\n    \n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">gr\196\129m.</term>\n    <term name=\"chapter\" form=\"short\">nod.</term>\n    <term name=\"column\" form=\"short\">sl.</term>\n    <term name=\"figure\" form=\"short\">il.</term>\n    <term name=\"folio\" form=\"short\">fo.</term>\n    <term name=\"issue\" form=\"short\">nr.</term>\n    <term name=\"line\" form=\"short\">r.</term>\n    <term name=\"note\" form=\"short\">piez.</term>\n    <term name=\"opus\" form=\"short\">op.</term>\n    <term name=\"page\" form=\"short\">\n      <single>lpp.</single>\n      <multiple>lpp.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">rindk.</term>\n    <term name=\"part\" form=\"short\">d.</term>\n    <term name=\"section\" form=\"short\">apak\197\161nod.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>sk.</single>\n      <multiple>sk.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>p.</single>\n      <multiple>p.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>s\196\147j.</single>\n      <multiple>s\196\147j.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"collection-editor\">\n      <single>kr\196\129juma redaktors</single>\n      <multiple>kr\196\129juma redaktori</multiple>\n    </term>\n    <term name=\"composer\">\n      <single>sast\196\129d\196\171t\196\129js</single>\n      <multiple>sast\196\129d\196\171t\196\129ji</multiple>\n    </term>\n    <term name=\"container-author\">\n      <single>pamatmateri\196\129la autors</single>\n      <multiple>pamatmateri\196\129la autori</multiple>\n    </term>\n    <term name=\"director\">\n      <single>vad\196\171t\196\129js</single>\n      <multiple>vad\196\171t\196\129ji</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>redaktors</single>\n      <multiple>redaktors</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>galvenais redaktors</single>\n      <multiple>galvenie redaktori</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>redaktors un tulkot\196\129js</single>\n      <multiple>redaktors un tulkot\196\129js</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>ilustrators</single>\n      <multiple>ilustratori</multiple>\n    </term>\n    <term name=\"interviewer\">\n      <single>interv\196\147t\196\129js</single>\n      <multiple>interv\196\147t\196\129ji</multiple>\n    </term>\n    <term name=\"recipient\">\n      <single>sa\197\134\196\147m\196\147js</single>\n      <multiple>sa\197\134\196\147m\196\147ji</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>tulkot\196\129js</single>\n      <multiple>tulkot\196\129ji</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"collection-editor\" form=\"short\">\n      <single>kr. red.</single>\n      <multiple>kr. red.</multiple>\n    </term>\n    <term name=\"composer\" form=\"short\">\n      <single>sast.</single>\n      <multiple>sast.</multiple>\n    </term>\n    <term name=\"container-author\" form=\"short\">\n      <single>pamatmat. aut.</single>\n      <multiple>pamatmat. aut.</multiple>\n    </term>\n    <term name=\"director\" form=\"short\">\n      <single>vad.</single>\n      <multiple>vad.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>red.</single>\n      <multiple>red.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>galv. red.</single>\n      <multiple>galv. red.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>red. un tulk.</single>\n      <multiple>red. un tulk.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ilustr.</single>\n      <multiple>ilustr.</multiple>\n    </term>\n    <term name=\"interviewer\" form=\"short\">\n      <single>interv.</single>\n      <multiple>interv.</multiple>\n    </term>\n    <term name=\"recipient\" form=\"short\">\n      <single>sa\197\134.</single>\n      <multiple>sa\197\134.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>tulk.</single>\n      <multiple>tulk.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"composer\" form=\"verb\">sast\196\129d\196\171ja</term>\n    <term name=\"director\" form=\"verb\">vad\196\171ja</term>\n    <term name=\"editor\" form=\"verb\">sagatavoja</term>\n    <term name=\"editorial-director\" form=\"verb\">sagatavoja</term>\n    <term name=\"editortranslator\" form=\"verb\">sagatavoja un tulkoja</term>\n    <term name=\"illustrator\" form=\"verb\">ilustr\196\147ja</term>\n    <term name=\"interviewer\" form=\"verb\">interv\196\147ja</term>\n    <term name=\"recipient\" form=\"verb\">sa\197\134\196\147ma</term>\n    <term name=\"translator\" form=\"verb\">tulkoja</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\"/>\n    <term name=\"director\" form=\"verb-short\">sast.</term>\n    <term name=\"editor\" form=\"verb-short\">sag.</term>\n    <term name=\"editorial-director\" form=\"verb-short\">sag.</term>\n    <term name=\"illustrator\" form=\"verb-short\">ilustr.</term>\n    <term name=\"translator\" form=\"verb-short\">tulk.</term>\n    <term name=\"editortranslator\" form=\"verb-short\">sag. un tulk.</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">janv\196\129r\196\171</term>\n    <term name=\"month-02\">febru\196\129r\196\171</term>\n    <term name=\"month-03\">mart\196\129</term>\n    <term name=\"month-04\">apr\196\171l\196\171</term>\n    <term name=\"month-05\">maij\196\129</term>\n    <term name=\"month-06\">j\197\171nij\196\129</term>\n    <term name=\"month-07\">j\197\171lij\196\129</term>\n    <term name=\"month-08\">august\196\129</term>\n    <term name=\"month-09\">septembr\196\171</term>\n    <term name=\"month-10\">oktobr\196\171</term>\n    <term name=\"month-11\">novembr\196\171</term>\n    <term name=\"month-12\">decembr\196\171</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">janv.</term>\n    <term name=\"month-02\" form=\"short\">febr.</term>\n    <term name=\"month-03\" form=\"short\">mar.</term>\n    <term name=\"month-04\" form=\"short\">apr.</term>\n    <term name=\"month-05\" form=\"short\">mai.</term>\n    <term name=\"month-06\" form=\"short\">j\197\171n.</term>\n    <term name=\"month-07\" form=\"short\">j\197\171l.</term>\n    <term name=\"month-08\" form=\"short\">aug.</term>\n    <term name=\"month-09\" form=\"short\">sept.</term>\n    <term name=\"month-10\" form=\"short\">okt.</term>\n    <term name=\"month-11\" form=\"short\">nov.</term>\n    <term name=\"month-12\" form=\"short\">dec.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">pavasaris</term>\n    <term name=\"season-02\">vasara</term>\n    <term name=\"season-03\">rudens</term>\n    <term name=\"season-04\">ziema</term>\n  </terms>\n</locale>\n"),("locales-mn-MN.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"mn-MN\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\" \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"year\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" prefix=\".\"/>\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" prefix=\".\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">accessed</term>\n    <term name=\"and\">and</term>\n    <term name=\"and others\">and others</term>\n    <term name=\"anonymous\">anonymous</term>\n    <term name=\"anonymous\" form=\"short\">anon</term>\n    <term name=\"at\">at</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">by</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">cited</term>\n    <term name=\"edition\">\n      <single>edition</single>\n      <multiple>editions</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">ed</term>\n    <term name=\"et-al\">et al.</term>\n    <term name=\"forthcoming\">forthcoming</term>\n    <term name=\"from\">from</term>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\">in</term>\n    <term name=\"in press\">in press</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">interview</term>\n    <term name=\"letter\">letter</term>\n    <term name=\"no date\">no date</term>\n    <term name=\"no date\" form=\"short\">n.d.</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">presented at the</term>\n    <term name=\"reference\">\n      <single>reference</single>\n      <multiple>references</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">retrieved</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">AD</term>\n    <term name=\"bc\">BC</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\194\171</term>\n    <term name=\"close-quote\">\194\187</term>\n    <term name=\"open-inner-quote\">\226\128\158</term>\n    <term name=\"close-inner-quote\">\226\128\156</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">th</term>\n    <term name=\"ordinal-01\">st</term>\n    <term name=\"ordinal-02\">nd</term>\n    <term name=\"ordinal-03\">rd</term>\n    <term name=\"ordinal-11\">th</term>\n    <term name=\"ordinal-12\">th</term>\n    <term name=\"ordinal-13\">th</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">first</term>\n    <term name=\"long-ordinal-02\">second</term>\n    <term name=\"long-ordinal-03\">third</term>\n    <term name=\"long-ordinal-04\">fourth</term>\n    <term name=\"long-ordinal-05\">fifth</term>\n    <term name=\"long-ordinal-06\">sixth</term>\n    <term name=\"long-ordinal-07\">seventh</term>\n    <term name=\"long-ordinal-08\">eighth</term>\n    <term name=\"long-ordinal-09\">ninth</term>\n    <term name=\"long-ordinal-10\">tenth</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>book</single>\n      <multiple>books</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>chapter</single>\n      <multiple>chapters</multiple>\n    </term>\n    <term name=\"column\">\n      <single>column</single>\n      <multiple>columns</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>figure</single>\n      <multiple>figures</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folio</single>\n      <multiple>folios</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>number</single>\n      <multiple>numbers</multiple>\n    </term>\n    <term name=\"line\">\n      <single>line</single>\n      <multiple>lines</multiple>\n    </term>\n    <term name=\"note\">\n      <single>note</single>\n      <multiple>notes</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>page</single>\n      <multiple>pages</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>paragraph</single>\n      <multiple>paragraph</multiple>\n    </term>\n    <term name=\"part\">\n      <single>part</single>\n      <multiple>parts</multiple>\n    </term>\n    <term name=\"section\">\n      <single>section</single>\n      <multiple>sections</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>verse</single>\n      <multiple>verses</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>volume</single>\n      <multiple>volumes</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">bk</term>\n    <term name=\"chapter\" form=\"short\">chap</term>\n    <term name=\"column\" form=\"short\">col</term>\n    <term name=\"figure\" form=\"short\">fig</term>\n    <term name=\"folio\" form=\"short\">f</term>\n    <term name=\"issue\" form=\"short\">no</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op</term>\n    <term name=\"page\" form=\"short\">\n      <single>p</single>\n      <multiple>pp</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">para</term>\n    <term name=\"part\" form=\"short\">pt</term>\n    <term name=\"section\" form=\"short\">sec</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v</single>\n      <multiple>vv</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>vol</single>\n      <multiple>vols</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>translator</single>\n      <multiple>translators</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>editor &amp; translator</single>\n      <multiple>editors &amp; translators</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>ed</single>\n      <multiple>eds</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ed.</single>\n      <multiple>eds.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>tran</single>\n      <multiple>trans</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ed. &amp; tran.</single>\n      <multiple>eds. &amp; trans.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">edited by</term>\n    <term name=\"editorial-director\" form=\"verb\">edited by</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">interview by</term>\n    <term name=\"recipient\" form=\"verb\">to</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">translated by</term>\n    <term name=\"editortranslator\" form=\"verb\">edited &amp; translated by</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">by</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">ed</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">trans</term>\n    <term name=\"editortranslator\" form=\"verb-short\">ed. &amp; trans. by</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">January</term>\n    <term name=\"month-02\">February</term>\n    <term name=\"month-03\">March</term>\n    <term name=\"month-04\">April</term>\n    <term name=\"month-05\">May</term>\n    <term name=\"month-06\">June</term>\n    <term name=\"month-07\">July</term>\n    <term name=\"month-08\">August</term>\n    <term name=\"month-09\">September</term>\n    <term name=\"month-10\">October</term>\n    <term name=\"month-11\">November</term>\n    <term name=\"month-12\">December</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">Jan</term>\n    <term name=\"month-02\" form=\"short\">Feb</term>\n    <term name=\"month-03\" form=\"short\">Mar</term>\n    <term name=\"month-04\" form=\"short\">Apr</term>\n    <term name=\"month-05\" form=\"short\">May</term>\n    <term name=\"month-06\" form=\"short\">Jun</term>\n    <term name=\"month-07\" form=\"short\">Jul</term>\n    <term name=\"month-08\" form=\"short\">Aug</term>\n    <term name=\"month-09\" form=\"short\">Sep</term>\n    <term name=\"month-10\" form=\"short\">Oct</term>\n    <term name=\"month-11\" form=\"short\">Nov</term>\n    <term name=\"month-12\" form=\"short\">Dec</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">Spring</term>\n    <term name=\"season-02\">Summer</term>\n    <term name=\"season-03\">Autumn</term>\n    <term name=\"season-04\">Winter</term>\n  </terms>\n</locale>\n"),("locales-nb-NO.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"nb-NO\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2013-03-01T12:20:00+01:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\". \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"year\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" prefix=\"-\" range-delimiter=\"/\"/>\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" prefix=\"-\" range-delimiter=\"/\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">\195\165pnet</term>\n    <term name=\"and\">og</term>\n    <term name=\"and others\">med flere</term>\n    <term name=\"anonymous\">anonym</term>\n    <term name=\"anonymous\" form=\"short\">anon.</term>\n    <term name=\"at\">p\195\165</term>\n    <term name=\"available at\">tilgjengelig p\195\165</term>\n    <term name=\"by\">av</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">ca.</term>\n    <term name=\"cited\">sitert</term>\n    <term name=\"edition\">\n      <single>utgave</single>\n      <multiple>utgaver</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">utg.</term>\n    <term name=\"et-al\">mfl.</term>\n    <term name=\"forthcoming\">kommende</term>\n    <term name=\"from\">fra</term>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\">i</term>\n    <term name=\"in press\">i trykk</term>\n    <term name=\"internet\">Internett</term>\n    <term name=\"interview\">intervju</term>\n    <term name=\"letter\">brev</term>\n    <term name=\"no date\">ingen dato</term>\n    <term name=\"no date\" form=\"short\">udatert</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">presentert p\195\165</term>\n    <term name=\"reference\">\n      <single>referanse</single>\n      <multiple>referanser</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refr.</multiple>\n    </term>\n    <term name=\"retrieved\">hentet</term>\n    <term name=\"scale\">m\195\165lestokk</term>\n    <term name=\"version\">versjon</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">fvt.</term>\n    <term name=\"bc\">evt.</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\194\171</term>\n    <term name=\"close-quote\">\194\187</term>\n    <term name=\"open-inner-quote\">\226\128\152</term>\n    <term name=\"close-inner-quote\">\226\128\153</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">.</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">f\195\184rste</term>\n    <term name=\"long-ordinal-02\">andre</term>\n    <term name=\"long-ordinal-03\">tredje</term>\n    <term name=\"long-ordinal-04\">fjerde</term>\n    <term name=\"long-ordinal-05\">femte</term>\n    <term name=\"long-ordinal-06\">sjette</term>\n    <term name=\"long-ordinal-07\">sjuende</term>\n    <term name=\"long-ordinal-08\">\195\165ttende</term>\n    <term name=\"long-ordinal-09\">niende</term>\n    <term name=\"long-ordinal-10\">tiende</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>bok</single>\n      <multiple>b\195\184ker</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>kapittel</single>\n      <multiple>kapitler</multiple>\n    </term>\n    <term name=\"column\">\n      <single>kolonne</single>\n      <multiple>kolonner</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>figur</single>\n      <multiple>figurer</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folio</single>\n      <multiple>folioer</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>nummer</single>\n      <multiple>numre</multiple>\n    </term>\n    <term name=\"line\">\n      <single>linje</single>\n      <multiple>linjer</multiple>\n    </term>\n    <term name=\"note\">\n      <single>note</single>\n      <multiple>noter</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opus</multiple>\n    </term>\n    <term name=\"page\">\n      <single>side</single>\n      <multiple>sider</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>avsnitt</single>\n      <multiple>avsnitt</multiple>\n    </term>\n    <term name=\"part\">\n      <single>del</single>\n      <multiple>deler</multiple>\n    </term>\n    <term name=\"section\">\n      <single>paragraf</single>\n      <multiple>paragrafer</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>vers</single>\n      <multiple>vers</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>bind</single>\n      <multiple>bind</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">b.</term>\n    <term name=\"chapter\" form=\"short\">kap.</term>\n    <term name=\"column\" form=\"short\">kol.</term>\n    <term name=\"figure\" form=\"short\">fig.</term>\n    <term name=\"folio\" form=\"short\">fol.</term>\n    <term name=\"issue\" form=\"short\">nr.</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op.</term>\n    <term name=\"page\" form=\"short\">\n      <single>s.</single>\n      <multiple>s.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">avsn.</term>\n    <term name=\"part\" form=\"short\">d.</term>\n    <term name=\"section\" form=\"short\">pargr.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v.</single>\n      <multiple>v.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>bd.</single>\n      <multiple>bd.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>regiss\195\184r</single>\n      <multiple>regiss\195\184rer</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>redakt\195\184r</single>\n      <multiple>redakt\195\184rer</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>redakt\195\184r</single>\n      <multiple>redakt\195\184rer</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrat\195\184r</single>\n      <multiple>illustrat\195\184rer</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>oversetter</single>\n      <multiple>oversettere</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>redakt\195\184r &amp; oversetter</single>\n      <multiple>redakt\195\184rer &amp; oversettere</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>regi</single>\n      <multiple>regi</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>red.</single>\n      <multiple>red.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>red.</single>\n      <multiple>red.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>overs.</single>\n      <multiple>overs.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>red. &amp; overs.</single>\n      <multiple>red. &amp; overs.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">regissert av</term>\n    <term name=\"editor\" form=\"verb\">redigert av</term>\n    <term name=\"editorial-director\" form=\"verb\">redigert av</term>\n    <term name=\"illustrator\" form=\"verb\">illustrert av</term>\n    <term name=\"interviewer\" form=\"verb\">intervjuet av</term>\n    <term name=\"recipient\" form=\"verb\">til</term>\n    <term name=\"reviewed-author\" form=\"verb\">av</term>\n    <term name=\"translator\" form=\"verb\">oversatt av</term>\n    <term name=\"editortranslator\" form=\"verb\">redigert &amp; oversatt av</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">av</term>\n    <term name=\"director\" form=\"verb-short\">regi</term>\n    <term name=\"editor\" form=\"verb-short\">red.</term>\n    <term name=\"editorial-director\" form=\"verb-short\">red.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">overs.</term>\n    <term name=\"editortranslator\" form=\"verb-short\">red. &amp; overs. av</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">januar</term>\n    <term name=\"month-02\">februar</term>\n    <term name=\"month-03\">mars</term>\n    <term name=\"month-04\">april</term>\n    <term name=\"month-05\">mai</term>\n    <term name=\"month-06\">juni</term>\n    <term name=\"month-07\">juli</term>\n    <term name=\"month-08\">august</term>\n    <term name=\"month-09\">september</term>\n    <term name=\"month-10\">oktober</term>\n    <term name=\"month-11\">november</term>\n    <term name=\"month-12\">desember</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">jan.</term>\n    <term name=\"month-02\" form=\"short\">feb.</term>\n    <term name=\"month-03\" form=\"short\">mar.</term>\n    <term name=\"month-04\" form=\"short\">apr.</term>\n    <term name=\"month-05\" form=\"short\">mai</term>\n    <term name=\"month-06\" form=\"short\">jun.</term>\n    <term name=\"month-07\" form=\"short\">jul.</term>\n    <term name=\"month-08\" form=\"short\">aug.</term>\n    <term name=\"month-09\" form=\"short\">sep.</term>\n    <term name=\"month-10\" form=\"short\">okt.</term>\n    <term name=\"month-11\" form=\"short\">nov.</term>\n    <term name=\"month-12\" form=\"short\">des.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">v\195\165r</term>\n    <term name=\"season-02\">sommer</term>\n    <term name=\"season-03\">h\195\184st</term>\n    <term name=\"season-04\">vinter</term>\n  </terms>\n</locale>\n"),("locales-nl-NL.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"nl-NL\">\n  <info>\n    <translator>\n      <name>Rintze Zelle</name>\n      <uri>http://twitter.com/rintzezelle</uri>\n    </translator>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\" \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" suffix=\"-\" range-delimiter=\"/\"/>\n    <date-part name=\"month\" form=\"numeric\" suffix=\"-\" range-delimiter=\"/\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">bezocht</term>\n    <term name=\"and\">en</term>\n    <term name=\"and others\">en anderen</term>\n    <term name=\"anonymous\">anoniem</term>\n    <term name=\"anonymous\" form=\"short\">anon.</term>\n    <term name=\"at\">bij</term>\n    <term name=\"available at\">beschikbaar op</term>\n    <term name=\"by\">door</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">geciteerd</term>\n    <term name=\"edition\">\n      <single>editie</single>\n      <multiple>edities</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">ed.</term>\n    <term name=\"et-al\">e.a.</term>\n    <term name=\"forthcoming\">in voorbereiding</term>\n    <term name=\"from\">van</term>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\">in</term>\n    <term name=\"in press\">in druk</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">interview</term>\n    <term name=\"letter\">brief</term>\n    <term name=\"no date\">zonder datum</term>\n    <term name=\"no date\" form=\"short\">z.d.</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">gepresenteerd bij</term>\n    <term name=\"reference\">\n      <single>referentie</single>\n      <multiple>referenties</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">geraadpleegd</term>\n    <term name=\"scale\">schaal</term>\n    <term name=\"version\">versie</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">AD</term>\n    <term name=\"bc\">BC</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\156</term>\n    <term name=\"close-quote\">\226\128\157</term>\n    <term name=\"open-inner-quote\">\226\128\152</term>\n    <term name=\"close-inner-quote\">\226\128\153</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">ste</term>\n    <term name=\"ordinal-00\" match=\"whole-number\">de</term>\n    <term name=\"ordinal-02\" match=\"last-two-digits\">de</term>\n    <term name=\"ordinal-03\" match=\"last-two-digits\">de</term>\n    <term name=\"ordinal-04\" match=\"last-two-digits\">de</term>\n    <term name=\"ordinal-05\" match=\"last-two-digits\">de</term>\n    <term name=\"ordinal-06\" match=\"last-two-digits\">de</term>\n    <term name=\"ordinal-07\" match=\"last-two-digits\">de</term>\n    <term name=\"ordinal-09\" match=\"last-two-digits\">de</term>\n    <term name=\"ordinal-10\">de</term>\n    <term name=\"ordinal-11\">de</term>\n    <term name=\"ordinal-12\">de</term>\n    <term name=\"ordinal-13\">de</term>\n    <term name=\"ordinal-14\">de</term>\n    <term name=\"ordinal-15\">de</term>\n    <term name=\"ordinal-16\">de</term>\n    <term name=\"ordinal-17\">de</term>\n    <term name=\"ordinal-18\">de</term>\n    <term name=\"ordinal-19\">de</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">eerste</term>\n    <term name=\"long-ordinal-02\">tweede</term>\n    <term name=\"long-ordinal-03\">derde</term>\n    <term name=\"long-ordinal-04\">vierde</term>\n    <term name=\"long-ordinal-05\">vijfde</term>\n    <term name=\"long-ordinal-06\">zesde</term>\n    <term name=\"long-ordinal-07\">zevende</term>\n    <term name=\"long-ordinal-08\">achtste</term>\n    <term name=\"long-ordinal-09\">negende</term>\n    <term name=\"long-ordinal-10\">tiende</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>boek</single>\n      <multiple>boeken</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>hoofdstuk</single>\n      <multiple>hoofdstukken</multiple>\n    </term>\n    <term name=\"column\">\n      <single>column</single>\n      <multiple>columns</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>figuur</single>\n      <multiple>figuren</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folio</single>\n      <multiple>folio's</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>nummer</single>\n      <multiple>nummers</multiple>\n    </term>\n    <term name=\"line\">\n      <single>regel</single>\n      <multiple>regels</multiple>\n    </term>\n    <term name=\"note\">\n      <single>aantekening</single>\n      <multiple>aantekeningen</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>pagina</single>\n      <multiple>pagina's</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>paragraaf</single>\n      <multiple>paragrafen</multiple>\n    </term>\n    <term name=\"part\">\n      <single>deel</single>\n      <multiple>delen</multiple>\n    </term>\n    <term name=\"section\">\n      <single>sectie</single>\n      <multiple>secties</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>vers</single>\n      <multiple>versen</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>volume</single>\n      <multiple>volumes</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">bk.</term>\n    <term name=\"chapter\" form=\"short\">hfdst.</term>\n    <term name=\"column\" form=\"short\">col.</term>\n    <term name=\"figure\" form=\"short\">fig.</term>\n    <term name=\"folio\" form=\"short\">f.</term>\n    <term name=\"issue\" form=\"short\">nr.</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op.</term>\n    <term name=\"page\" form=\"short\">\n      <single>p.</single>\n      <multiple>pp.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">par.</term>\n    <term name=\"part\" form=\"short\">deel</term>\n    <term name=\"section\" form=\"short\">sec.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v.</single>\n      <multiple>vv.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>vol.</single>\n      <multiple>vols.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>regisseur</single>\n      <multiple>regisseurs</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>redacteur</single>\n      <multiple>redacteuren</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>redacteur</single>\n      <multiple>redacteuren</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>vertaler</single>\n      <multiple>vertalers</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>redacteur &amp; vertaler</single>\n      <multiple>redacteuren &amp; vertalers</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>reg.</single>\n      <multiple>reg.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>red.</single>\n      <multiple>red.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>red.</single>\n      <multiple>red.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ill.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>vert.</single>\n      <multiple>vert.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>red. &amp; vert.</single>\n      <multiple>red. &amp; vert.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">geregisseerd door</term>\n    <term name=\"editor\" form=\"verb\">bewerkt door</term>\n    <term name=\"editorial-director\" form=\"verb\">bewerkt door</term>\n    <term name=\"illustrator\" form=\"verb\">ge\195\175llustreerd door</term>\n    <term name=\"interviewer\" form=\"verb\">ge\195\175nterviewd door</term>\n    <term name=\"recipient\" form=\"verb\">ontvangen door</term>\n    <term name=\"reviewed-author\" form=\"verb\">door</term>\n    <term name=\"translator\" form=\"verb\">vertaald door</term>\n    <term name=\"editortranslator\" form=\"verb\">bewerkt &amp; vertaald door</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">door</term>\n    <term name=\"director\" form=\"verb-short\">geregisseerd door</term>\n    <term name=\"editor\" form=\"verb-short\">bewerkt door</term>\n    <term name=\"editorial-director\" form=\"verb-short\">bewerkt door</term>\n    <term name=\"illustrator\" form=\"verb-short\">ge\195\175llustreerd door</term>\n    <term name=\"translator\" form=\"verb-short\">vertaald door</term>\n    <term name=\"editortranslator\" form=\"verb-short\">bewerkt &amp; vertaald door</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">januari</term>\n    <term name=\"month-02\">februari</term>\n    <term name=\"month-03\">maart</term>\n    <term name=\"month-04\">april</term>\n    <term name=\"month-05\">mei</term>\n    <term name=\"month-06\">juni</term>\n    <term name=\"month-07\">juli</term>\n    <term name=\"month-08\">augustus</term>\n    <term name=\"month-09\">september</term>\n    <term name=\"month-10\">oktober</term>\n    <term name=\"month-11\">november</term>\n    <term name=\"month-12\">december</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">jan.</term>\n    <term name=\"month-02\" form=\"short\">feb.</term>\n    <term name=\"month-03\" form=\"short\">mrt.</term>\n    <term name=\"month-04\" form=\"short\">apr.</term>\n    <term name=\"month-05\" form=\"short\">mei</term>\n    <term name=\"month-06\" form=\"short\">jun.</term>\n    <term name=\"month-07\" form=\"short\">jul.</term>\n    <term name=\"month-08\" form=\"short\">aug.</term>\n    <term name=\"month-09\" form=\"short\">sep.</term>\n    <term name=\"month-10\" form=\"short\">okt.</term>\n    <term name=\"month-11\" form=\"short\">nov.</term>\n    <term name=\"month-12\" form=\"short\">dec.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">lente</term>\n    <term name=\"season-02\">zomer</term>\n    <term name=\"season-03\">herst</term>\n    <term name=\"season-04\">winter</term>\n  </terms>\n</locale>\n"),("locales-nn-NO.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"nn-NO\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2013-03-01T12:20:00+01:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\". \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"year\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" prefix=\"-\" range-delimiter=\"/\"/>\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" prefix=\"-\" range-delimiter=\"/\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">vitja</term>\n    <term name=\"and\">og</term>\n    <term name=\"and others\">med fleire</term>\n    <term name=\"anonymous\">anonym</term>\n    <term name=\"anonymous\" form=\"short\">anon.</term>\n    <term name=\"at\">p\195\165</term>\n    <term name=\"available at\">tilgjengeleg p\195\165</term>\n    <term name=\"by\">av</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">ca.</term>\n    <term name=\"cited\">sitert</term>\n    <term name=\"edition\">\n      <single>utg\195\165ve</single>\n      <multiple>utg\195\165ver</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">utg.</term>\n    <term name=\"et-al\">mfl.</term>\n    <term name=\"forthcoming\">kommande</term>\n    <term name=\"from\">fr\195\165</term>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\">i</term>\n    <term name=\"in press\">i trykk</term>\n    <term name=\"internet\">Internett</term>\n    <term name=\"interview\">intervju</term>\n    <term name=\"letter\">brev</term>\n    <term name=\"no date\">ingen dato</term>\n    <term name=\"no date\" form=\"short\">udatert</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">presentert p\195\165</term>\n    <term name=\"reference\">\n      <single>referanse</single>\n      <multiple>referansar</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refr.</multiple>\n    </term>\n    <term name=\"retrieved\">henta</term>\n    <term name=\"scale\">m\195\165lestokk</term>\n    <term name=\"version\">versjon</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">fvt.</term>\n    <term name=\"bc\">evt.</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\194\171</term>\n    <term name=\"close-quote\">\194\187</term>\n    <term name=\"open-inner-quote\">\226\128\152</term>\n    <term name=\"close-inner-quote\">\226\128\153</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">.</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">f\195\184rste</term>\n    <term name=\"long-ordinal-02\">andre</term>\n    <term name=\"long-ordinal-03\">tredje</term>\n    <term name=\"long-ordinal-04\">fjerde</term>\n    <term name=\"long-ordinal-05\">femte</term>\n    <term name=\"long-ordinal-06\">sjette</term>\n    <term name=\"long-ordinal-07\">sjuande</term>\n    <term name=\"long-ordinal-08\">\195\165ttande</term>\n    <term name=\"long-ordinal-09\">niande</term>\n    <term name=\"long-ordinal-10\">tiande</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>bok</single>\n      <multiple>b\195\184ker</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>kapittel</single>\n      <multiple>kapittel</multiple>\n    </term>\n    <term name=\"column\">\n      <single>kolonne</single>\n      <multiple>kolonner</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>figur</single>\n      <multiple>figurar</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folio</single>\n      <multiple>folioar</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>nummer</single>\n      <multiple>nummer</multiple>\n    </term>\n    <term name=\"line\">\n      <single>linje</single>\n      <multiple>linjer</multiple>\n    </term>\n    <term name=\"note\">\n      <single>note</single>\n      <multiple>notar</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opus</multiple>\n    </term>\n    <term name=\"page\">\n      <single>side</single>\n      <multiple>sider</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>avsnitt</single>\n      <multiple>avsnitt</multiple>\n    </term>\n    <term name=\"part\">\n      <single>del</single>\n      <multiple>deler</multiple>\n    </term>\n    <term name=\"section\">\n      <single>paragraf</single>\n      <multiple>paragrafar</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>vers</single>\n      <multiple>vers</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>bind</single>\n      <multiple>bind</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">b.</term>\n    <term name=\"chapter\" form=\"short\">kap.</term>\n    <term name=\"column\" form=\"short\">kol.</term>\n    <term name=\"figure\" form=\"short\">fig.</term>\n    <term name=\"folio\" form=\"short\">fol.</term>\n    <term name=\"issue\" form=\"short\">nr.</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op.</term>\n    <term name=\"page\" form=\"short\">\n      <single>s.</single>\n      <multiple>s.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">avsn.</term>\n    <term name=\"part\" form=\"short\">d.</term>\n    <term name=\"section\" form=\"short\">par.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v.</single>\n      <multiple>v.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>bd.</single>\n      <multiple>bd.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>regiss\195\184r</single>\n      <multiple>regiss\195\184rar</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>redakt\195\184r</single>\n      <multiple>redakt\195\184rar</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>redakt\195\184r</single>\n      <multiple>redakt\195\184rar</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrat\195\184r</single>\n      <multiple>illustrat\195\184rar</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>omsetjar</single>\n      <multiple>omsetjarar</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>redakt\195\184r &amp; omsetjar</single>\n      <multiple>redakt\195\184rar &amp; omsetjarar</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>regi</single>\n      <multiple>regi</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>red.</single>\n      <multiple>red.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>red.</single>\n      <multiple>red.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>oms.</single>\n      <multiple>oms.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>red. &amp; oms.</single>\n      <multiple>red. &amp; oms.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">regissert av</term>\n    <term name=\"editor\" form=\"verb\">redigert av</term>\n    <term name=\"editorial-director\" form=\"verb\">redigert av</term>\n    <term name=\"illustrator\" form=\"verb\">illustrert av</term>\n    <term name=\"interviewer\" form=\"verb\">intervjua av</term>\n    <term name=\"recipient\" form=\"verb\">til</term>\n    <term name=\"reviewed-author\" form=\"verb\">av</term>\n    <term name=\"translator\" form=\"verb\">omsett av</term>\n    <term name=\"editortranslator\" form=\"verb\">redigert &amp; omsett av</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">av</term>\n    <term name=\"director\" form=\"verb-short\">regi</term>\n    <term name=\"editor\" form=\"verb-short\">red.</term>\n    <term name=\"editorial-director\" form=\"verb-short\">red.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">oms.</term>\n    <term name=\"editortranslator\" form=\"verb-short\">red. &amp; oms. av</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">januar</term>\n    <term name=\"month-02\">februar</term>\n    <term name=\"month-03\">mars</term>\n    <term name=\"month-04\">april</term>\n    <term name=\"month-05\">mai</term>\n    <term name=\"month-06\">juni</term>\n    <term name=\"month-07\">juli</term>\n    <term name=\"month-08\">august</term>\n    <term name=\"month-09\">september</term>\n    <term name=\"month-10\">oktober</term>\n    <term name=\"month-11\">november</term>\n    <term name=\"month-12\">desember</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">jan.</term>\n    <term name=\"month-02\" form=\"short\">feb.</term>\n    <term name=\"month-03\" form=\"short\">mar.</term>\n    <term name=\"month-04\" form=\"short\">apr.</term>\n    <term name=\"month-05\" form=\"short\">mai</term>\n    <term name=\"month-06\" form=\"short\">jun.</term>\n    <term name=\"month-07\" form=\"short\">jul.</term>\n    <term name=\"month-08\" form=\"short\">aug.</term>\n    <term name=\"month-09\" form=\"short\">sep.</term>\n    <term name=\"month-10\" form=\"short\">okt.</term>\n    <term name=\"month-11\" form=\"short\">nov.</term>\n    <term name=\"month-12\" form=\"short\">des.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">v\195\165r</term>\n    <term name=\"season-02\">sommar</term>\n    <term name=\"season-03\">haust</term>\n    <term name=\"season-04\">vinter</term>\n  </terms>\n</locale>\n"),("locales-pl-PL.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"pl-PL\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\" \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\".\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\".\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">udost\196\153pniono</term>\n    <term name=\"and\">i</term>\n    <term name=\"and others\">i inni</term>\n    <term name=\"anonymous\">anonim</term>\n    <term name=\"anonymous\" form=\"short\">anon.</term>\n    <term name=\"at\">na</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">przez</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">ca</term>\n    <term name=\"cited\">cytowane</term>\n    <term name=\"edition\">\n      <single>wydanie</single>\n      <multiple>wydania</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">wyd.</term>\n    <term name=\"et-al\">et al.</term>\n    <term name=\"forthcoming\">w przygotowaniu</term>\n    <term name=\"from\">z</term>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\">w</term>\n    <term name=\"in press\">w druku</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">wywiad</term>\n    <term name=\"letter\">list</term>\n    <term name=\"no date\">brak daty</term>\n    <term name=\"no date\" form=\"short\">b.d.</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">zaprezentowano na</term>\n    <term name=\"reference\">\n      <single>referencja</single>\n      <multiple>referencje</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>ref.</multiple>\n    </term>\n    <term name=\"retrieved\">pobrano</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">n.e.</term>\n    <term name=\"bc\">p.n.e.</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\158</term>\n    <term name=\"close-quote\">\226\128\157</term>\n    <term name=\"open-inner-quote\">\194\171</term>\n    <term name=\"close-inner-quote\">\194\187</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">.</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">pierwszy</term>\n    <term name=\"long-ordinal-02\">drugi</term>\n    <term name=\"long-ordinal-03\">trzeci</term>\n    <term name=\"long-ordinal-04\">czwarty</term>\n    <term name=\"long-ordinal-05\">pi\196\133ty</term>\n    <term name=\"long-ordinal-06\">sz\195\179sty</term>\n    <term name=\"long-ordinal-07\">si\195\179dmy</term>\n    <term name=\"long-ordinal-08\">\195\179smy</term>\n    <term name=\"long-ordinal-09\">dziewi\196\133ty</term>\n    <term name=\"long-ordinal-10\">dziesi\196\133ty</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>ksi\196\133\197\188ka</single>\n      <multiple>ksi\196\133\197\188ki</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>rozdzia\197\130</single>\n      <multiple>rozdzia\197\130y</multiple>\n    </term>\n    <term name=\"column\">\n      <single>kolumna</single>\n      <multiple>kolumny</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>rycina</single>\n      <multiple>ryciny</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folio</single>\n      <multiple>folio</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>numer</single>\n      <multiple>numery</multiple>\n    </term>\n    <term name=\"line\">\n      <single>wers</single>\n      <multiple>wersy</multiple>\n    </term>\n    <term name=\"note\">\n      <single>notatka</single>\n      <multiple>notatki</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>strona</single>\n      <multiple>strony</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>akapit</single>\n      <multiple>akapity</multiple>\n    </term>\n    <term name=\"part\">\n      <single>cz\196\153\197\155\196\135</single>\n      <multiple>cz\196\153\197\155ci</multiple>\n    </term>\n    <term name=\"section\">\n      <single>sekcja</single>\n      <multiple>sekcje</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>wers</single>\n      <multiple>wersy</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>tom</single>\n      <multiple>tomy</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">ksi\196\133\197\188ka</term>\n    <term name=\"chapter\" form=\"short\">rozdz.</term>\n    <term name=\"column\" form=\"short\">kol.</term>\n    <term name=\"figure\" form=\"short\">ryc.</term>\n    <term name=\"folio\" form=\"short\">fol.</term>\n    <term name=\"issue\" form=\"short\">nr</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op.</term>\n    <term name=\"page\" form=\"short\">\n      <single>s.</single>\n      <multiple>ss.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">akap.</term>\n    <term name=\"part\" form=\"short\">cz.</term>\n    <term name=\"section\" form=\"short\">sekc.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>w.</single>\n      <multiple>w.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>t.</single>\n      <multiple>t.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>redaktor</single>\n      <multiple>redaktorzy</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>edytor</single>\n      <multiple>edytorzy</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>t\197\130umacz</single>\n      <multiple>t\197\130umacze</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>redaktor &amp; t\197\130umacz</single>\n      <multiple>redaktorzy &amp; t\197\130umacze</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>red.</single>\n      <multiple>red.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>red.</single>\n      <multiple>red.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>t\197\130um.</single>\n      <multiple>t\197\130um.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>red. &amp; t\197\130um.</single>\n      <multiple>red. &amp; t\197\130um.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">zredagowane przez</term>\n    <term name=\"editorial-director\" form=\"verb\">zredagowane przez</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">przeprowadzony przez</term>\n    <term name=\"recipient\" form=\"verb\">dla</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">przet\197\130umaczone przez</term>\n    <term name=\"editortranslator\" form=\"verb\">zredagowane &amp; przet\197\130umaczone przez</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">przez</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">red.</term>\n    <term name=\"editorial-director\" form=\"verb-short\">red.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">t\197\130um.</term>\n    <term name=\"editortranslator\" form=\"verb-short\">red. &amp; t\197\130um.</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">stycze\197\132</term>\n    <term name=\"month-02\">luty</term>\n    <term name=\"month-03\">marzec</term>\n    <term name=\"month-04\">kwiecie\197\132</term>\n    <term name=\"month-05\">maj</term>\n    <term name=\"month-06\">czerwiec</term>\n    <term name=\"month-07\">lipiec</term>\n    <term name=\"month-08\">sierpie\197\132</term>\n    <term name=\"month-09\">wrzesie\197\132</term>\n    <term name=\"month-10\">pa\197\186dziernik</term>\n    <term name=\"month-11\">listopad</term>\n    <term name=\"month-12\">grudzie\197\132</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">sty.</term>\n    <term name=\"month-02\" form=\"short\">luty</term>\n    <term name=\"month-03\" form=\"short\">mar.</term>\n    <term name=\"month-04\" form=\"short\">kwi.</term>\n    <term name=\"month-05\" form=\"short\">maj</term>\n    <term name=\"month-06\" form=\"short\">cze.</term>\n    <term name=\"month-07\" form=\"short\">lip.</term>\n    <term name=\"month-08\" form=\"short\">sie.</term>\n    <term name=\"month-09\" form=\"short\">wrz.</term>\n    <term name=\"month-10\" form=\"short\">pa\197\186.</term>\n    <term name=\"month-11\" form=\"short\">lis.</term>\n    <term name=\"month-12\" form=\"short\">grudz.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">wiosna</term>\n    <term name=\"season-02\">lato</term>\n    <term name=\"season-03\">jesie\197\132</term>\n    <term name=\"season-04\">zima</term>\n  </terms>\n</locale>\n"),("locales-pt-BR.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"pt-BR\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\" de \"/>\n    <date-part name=\"month\" suffix=\" de \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">acessado</term>\n    <term name=\"and\">e</term>\n    <term name=\"and others\">e outros</term>\n    <term name=\"anonymous\">an\195\180nimo</term>\n    <term name=\"anonymous\" form=\"short\">anon</term>\n    <term name=\"at\">em</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">por</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">citado</term>\n    <term name=\"edition\">\n      <single>edi\195\167\195\163o</single>\n      <multiple>edi\195\167\195\181es</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">ed</term>\n    <term name=\"et-al\">et al.</term>\n    <term name=\"forthcoming\">a ser publicado</term>\n    <term name=\"from\">de</term>\n    <term name=\"ibid\">ibidem</term>\n    <term name=\"in\">in</term>\n    <term name=\"in press\">no prelo</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">entrevista</term>\n    <term name=\"letter\">carta</term>\n    <term name=\"no date\">sem data</term>\n    <term name=\"no date\" form=\"short\">[s.d.]</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">apresentado em</term>\n    <term name=\"reference\">\n      <single>refer\195\170ncia</single>\n      <multiple>refer\195\170ncias</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">recuperado</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">AD</term>\n    <term name=\"bc\">BC</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\156</term>\n    <term name=\"close-quote\">\226\128\157</term>\n    <term name=\"open-inner-quote\">\226\128\152</term>\n    <term name=\"close-inner-quote\">\226\128\153</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">\194\186</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">primeiro</term>\n    <term name=\"long-ordinal-02\">segundo</term>\n    <term name=\"long-ordinal-03\">terceiro</term>\n    <term name=\"long-ordinal-04\">quarto</term>\n    <term name=\"long-ordinal-05\">quinto</term>\n    <term name=\"long-ordinal-06\">sexto</term>\n    <term name=\"long-ordinal-07\">s\195\169timo</term>\n    <term name=\"long-ordinal-08\">oitavo</term>\n    <term name=\"long-ordinal-09\">nono</term>\n    <term name=\"long-ordinal-10\">d\195\169cimo</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>livro</single>\n      <multiple>livros</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>cap\195\173tulo</single>\n      <multiple>cap\195\173tulos</multiple>\n    </term>\n    <term name=\"column\">\n      <single>coluna</single>\n      <multiple>colunas</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>figura</single>\n      <multiple>figuras</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folio</single>\n      <multiple>folios</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>n\195\186mero</single>\n      <multiple>n\195\186meros</multiple>\n    </term>\n    <term name=\"line\">\n      <single>linha</single>\n      <multiple>linhas</multiple>\n    </term>\n    <term name=\"note\">\n      <single>nota</single>\n      <multiple>notas</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>p\195\161gina</single>\n      <multiple>p\195\161ginas</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>par\195\161grafo</single>\n      <multiple>par\195\161grafos</multiple>\n    </term>\n    <term name=\"part\">\n      <single>parte</single>\n      <multiple>partes</multiple>\n    </term>\n    <term name=\"section\">\n      <single>se\195\167\195\163o</single>\n      <multiple>se\195\167\195\181es</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>verso</single>\n      <multiple>versos</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>volume</single>\n      <multiple>volumes</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">liv.</term>\n    <term name=\"chapter\" form=\"short\">cap.</term>\n    <term name=\"column\" form=\"short\">col.</term>\n    <term name=\"figure\" form=\"short\">fig.</term>\n    <term name=\"folio\" form=\"short\">f.</term>\n    <term name=\"issue\" form=\"short\">n\194\186</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op.</term>\n    <term name=\"page\" form=\"short\">\n      <single>p.</single>\n      <multiple>p.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">parag.</term>\n    <term name=\"part\" form=\"short\">pt.</term>\n    <term name=\"section\" form=\"short\">se\195\167.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v.</single>\n      <multiple>vv.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>vol.</single>\n      <multiple>vols.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>organizador</single>\n      <multiple>organizadores</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>tradutor</single>\n      <multiple>tradutores</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>editor e tradutor</single>\n      <multiple>editores e tradutores</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>org.</single>\n      <multiple>orgs.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ed.</single>\n      <multiple>eds.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>trad.</single>\n      <multiple>trads.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ed. e trad.</single>\n      <multiple>eds. e trads.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">organizado por</term>\n    <term name=\"editorial-director\" form=\"verb\">editado por</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">entrevista de</term>\n    <term name=\"recipient\" form=\"verb\">para</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">traduzido por</term>\n    <term name=\"editortranslator\" form=\"verb\">editado &amp; traduzido por</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">por</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">org.</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">trad.</term>\n    <term name=\"editortranslator\" form=\"verb-short\">ed. e trad. por</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">janeiro</term>\n    <term name=\"month-02\">fevereiro</term>\n    <term name=\"month-03\">mar\195\167o</term>\n    <term name=\"month-04\">abril</term>\n    <term name=\"month-05\">maio</term>\n    <term name=\"month-06\">junho</term>\n    <term name=\"month-07\">julho</term>\n    <term name=\"month-08\">agosto</term>\n    <term name=\"month-09\">setembro</term>\n    <term name=\"month-10\">outubro</term>\n    <term name=\"month-11\">novembro</term>\n    <term name=\"month-12\">dezembro</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">jan.</term>\n    <term name=\"month-02\" form=\"short\">fev.</term>\n    <term name=\"month-03\" form=\"short\">mar.</term>\n    <term name=\"month-04\" form=\"short\">abr.</term>\n    <term name=\"month-05\" form=\"short\">maio</term>\n    <term name=\"month-06\" form=\"short\">jun.</term>\n    <term name=\"month-07\" form=\"short\">jul.</term>\n    <term name=\"month-08\" form=\"short\">ago.</term>\n    <term name=\"month-09\" form=\"short\">set.</term>\n    <term name=\"month-10\" form=\"short\">out.</term>\n    <term name=\"month-11\" form=\"short\">nov.</term>\n    <term name=\"month-12\" form=\"short\">dez.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">Primavera</term>\n    <term name=\"season-02\">Ver\195\163o</term>\n    <term name=\"season-03\">Outono</term>\n    <term name=\"season-04\">Inverno</term>\n  </terms>\n</locale>\n"),("locales-pt-PT.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"pt-PT\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\" de \"/>\n    <date-part name=\"month\" suffix=\" de \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">acedido</term>\n    <term name=\"and\">e</term>\n    <term name=\"and others\">e outros</term>\n    <term name=\"anonymous\">an\195\179nimo</term>\n    <term name=\"anonymous\" form=\"short\">an\195\179n</term>\n    <term name=\"at\">em</term>\n    <term name=\"available at\">dispon\195\173vel em</term>\n    <term name=\"by\">por</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">citado</term>\n    <term name=\"edition\">\n      <single>edi\195\167\195\163o</single>\n      <multiple>edi\195\167\195\181es</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">ed</term>\n    <term name=\"et-al\">et al.</term>\n    <term name=\"forthcoming\">a publicar</term>\n    <term name=\"from\">de</term>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\">em</term>\n    <term name=\"in press\">no prelo</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">entrevista</term>\n    <term name=\"letter\">carta</term>\n    <term name=\"no date\">sem data</term>\n    <term name=\"no date\" form=\"short\">sem data</term>\n    <term name=\"online\">em linha</term>\n    <term name=\"presented at\">apresentado na</term>\n    <term name=\"reference\">\n      <single>reference</single>\n      <multiple>references</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">obtido</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">vers\195\163o</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">AD</term>\n    <term name=\"bc\">BC</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\194\171</term>\n    <term name=\"close-quote\">\194\187</term>\n    <term name=\"open-inner-quote\">\226\128\156</term>\n    <term name=\"close-inner-quote\">\226\128\157</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">th</term>\n    <term name=\"ordinal-01\">st</term>\n    <term name=\"ordinal-02\">nd</term>\n    <term name=\"ordinal-03\">rd</term>\n    <term name=\"ordinal-11\">th</term>\n    <term name=\"ordinal-12\">th</term>\n    <term name=\"ordinal-13\">th</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">primeiro</term>\n    <term name=\"long-ordinal-02\">segundo</term>\n    <term name=\"long-ordinal-03\">terceiro</term>\n    <term name=\"long-ordinal-04\">quarto</term>\n    <term name=\"long-ordinal-05\">quinto</term>\n    <term name=\"long-ordinal-06\">sexto</term>\n    <term name=\"long-ordinal-07\">s\195\169timo</term>\n    <term name=\"long-ordinal-08\">oitavo</term>\n    <term name=\"long-ordinal-09\">nono</term>\n    <term name=\"long-ordinal-10\">d\195\169cimo</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>livro</single>\n      <multiple>livros</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>cap\195\173tulo</single>\n      <multiple>cap\195\173tulos</multiple>\n    </term>\n    <term name=\"column\">\n      <single>coluna</single>\n      <multiple>colunas</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>figura</single>\n      <multiple>figuras</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>f\195\179lio</single>\n      <multiple>f\195\179lios</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>n\195\186mero</single>\n      <multiple>n\195\186mero</multiple>\n    </term>\n    <term name=\"line\">\n      <single>linha</single>\n      <multiple>linhas</multiple>\n    </term>\n    <term name=\"note\">\n      <single>nota</single>\n      <multiple>notas</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>p\195\161gina</single>\n      <multiple>p\195\161ginas</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>par\195\161grafo</single>\n      <multiple>par\195\161grafos</multiple>\n    </term>\n    <term name=\"part\">\n      <single>parte</single>\n      <multiple>partes</multiple>\n    </term>\n    <term name=\"section\">\n      <single>sec\195\167\195\163o</single>\n      <multiple>sec\195\167\195\181es</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>vers\195\173culo</single>\n      <multiple>vers\195\173culos</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>volume</single>\n      <multiple>volumes</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">liv</term>\n    <term name=\"chapter\" form=\"short\">cap</term>\n    <term name=\"column\" form=\"short\">col</term>\n    <term name=\"figure\" form=\"short\">fig</term>\n    <term name=\"folio\" form=\"short\">f</term>\n    <term name=\"issue\" form=\"short\">n</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op</term>\n    <term name=\"page\" form=\"short\">\n      <single>p</single>\n      <multiple>pp</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">par</term>\n    <term name=\"part\" form=\"short\">pt</term>\n    <term name=\"section\" form=\"short\">sec</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v</single>\n      <multiple>vv</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>vol</single>\n      <multiple>vols</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>editor</single>\n      <multiple>editores</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>tradutor</single>\n      <multiple>tradutores</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>editor &amp; translator</single>\n      <multiple>editors &amp; translators</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>ed</single>\n      <multiple>eds</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ed.</single>\n      <multiple>eds.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>trad</single>\n      <multiple>trads</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ed. &amp; tran.</single>\n      <multiple>eds. &amp; trans.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">editado por</term>\n    <term name=\"editorial-director\" form=\"verb\">edited by</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">entrevistado por</term>\n    <term name=\"recipient\" form=\"verb\">para</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">traduzido por</term>\n    <term name=\"editortranslator\" form=\"verb\">edited &amp; translated by</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">by</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">ed</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">trad</term>\n    <term name=\"editortranslator\" form=\"verb-short\">ed. &amp; trans. by</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">Janeiro</term>\n    <term name=\"month-02\">Fevereiro</term>\n    <term name=\"month-03\">Mar\195\167o</term>\n    <term name=\"month-04\">Abril</term>\n    <term name=\"month-05\">Maio</term>\n    <term name=\"month-06\">Junho</term>\n    <term name=\"month-07\">Julho</term>\n    <term name=\"month-08\">Agosto</term>\n    <term name=\"month-09\">Setembro</term>\n    <term name=\"month-10\">Outubro</term>\n    <term name=\"month-11\">Novembro</term>\n    <term name=\"month-12\">Dezembro</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">Jan</term>\n    <term name=\"month-02\" form=\"short\">Fev</term>\n    <term name=\"month-03\" form=\"short\">Mar</term>\n    <term name=\"month-04\" form=\"short\">Abr</term>\n    <term name=\"month-05\" form=\"short\">Mai</term>\n    <term name=\"month-06\" form=\"short\">Jun</term>\n    <term name=\"month-07\" form=\"short\">Jul</term>\n    <term name=\"month-08\" form=\"short\">Ago</term>\n    <term name=\"month-09\" form=\"short\">Set</term>\n    <term name=\"month-10\" form=\"short\">Out</term>\n    <term name=\"month-11\" form=\"short\">Nov</term>\n    <term name=\"month-12\" form=\"short\">Dez</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">Primavera</term>\n    <term name=\"season-02\">Ver\195\163o</term>\n    <term name=\"season-03\">Outono</term>\n    <term name=\"season-04\">Inverno</term>\n  </terms>\n</locale>\n"),("locales-ro-RO.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"ro-RO\">\n  <info>\n    <translator>\n      <name>Nicolae Turcan</name>\n      <email>nturcan@gmail.com</email>\n    </translator>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\" \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" suffix=\".\"/>\n    <date-part name=\"month\" form=\"numeric\" suffix=\".\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">data acces\196\131rii</term>\n    <term name=\"and\">\200\153i</term>\n    <term name=\"and others\">\200\153i al\200\155ii</term>\n    <term name=\"anonymous\">anonim</term>\n    <term name=\"anonymous\" form=\"short\">anon.</term>\n    <term name=\"at\">la</term>\n    <term name=\"available at\">valabil la</term>\n    <term name=\"by\">de</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">cca.</term>\n    <term name=\"cited\">citat</term>\n    <term name=\"edition\">\n      <single>edi\200\155ia</single>\n      <multiple>edi\200\155iile</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">ed</term>\n    <term name=\"et-al\">et al.</term>\n    <term name=\"forthcoming\">\195\174n curs de apari\200\155ie</term>\n    <term name=\"from\">din</term>\n    <term name=\"ibid\">ibidem</term>\n    <term name=\"in\">\195\174n</term>\n    <term name=\"in press\">sub tipar</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">interviu</term>\n    <term name=\"letter\">scrisoare</term>\n    <term name=\"no date\">f\196\131r\196\131 dat\196\131</term>\n    <term name=\"no date\" form=\"short\">f.a.</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">prezentat la</term>\n    <term name=\"reference\">\n      <single>referin\200\155\196\131</single>\n      <multiple>referin\200\155e</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>ref.</multiple>\n    </term>\n    <term name=\"retrieved\">preluat \195\174n</term>\n    <term name=\"scale\">scal\196\131</term>\n    <term name=\"version\">versiunea</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">d.Hr.</term>\n    <term name=\"bc\">\195\174.Hr.</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\158</term>\n    <term name=\"close-quote\">\226\128\157</term>\n    <term name=\"open-inner-quote\">\194\171</term>\n    <term name=\"close-inner-quote\">\194\187</term>\n    <term name=\"page-range-delimiter\">-</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">-lea</term>\n    <term name=\"ordinal-01\" match=\"whole-number\"/>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">primul</term>\n    <term name=\"long-ordinal-02\">al doilea</term>\n    <term name=\"long-ordinal-03\">al treilea</term>\n    <term name=\"long-ordinal-04\">al patrulea</term>\n    <term name=\"long-ordinal-05\">al cincilea</term>\n    <term name=\"long-ordinal-06\">al \200\153aselea</term>\n    <term name=\"long-ordinal-07\">al \200\153aptelea</term>\n    <term name=\"long-ordinal-08\">al optulea</term>\n    <term name=\"long-ordinal-09\">al nou\196\131lea</term>\n    <term name=\"long-ordinal-10\">al zecelea</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>cartea</single>\n      <multiple>c\196\131r\200\155ile</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>capitolul</single>\n      <multiple>capitolele</multiple>\n    </term>\n    <term name=\"column\">\n      <single>coloana</single>\n      <multiple>coloanele</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>figura</single>\n      <multiple>figurile</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folio</single>\n      <multiple>folio</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>num\196\131rul</single>\n      <multiple>numerele</multiple>\n    </term>\n    <term name=\"line\">\n      <single>linia</single>\n      <multiple>liniile</multiple>\n    </term>\n    <term name=\"note\">\n      <single>nota</single>\n      <multiple>notele</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opusul</single>\n      <multiple>opusurile</multiple>\n    </term>\n    <term name=\"page\">\n      <single>pagina</single>\n      <multiple>paginile</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>paragraful</single>\n      <multiple>paragrafele</multiple>\n    </term>\n    <term name=\"part\">\n      <single>partea</single>\n      <multiple>p\196\131r\200\155ile</multiple>\n    </term>\n    <term name=\"section\">\n      <single>sec\200\155iunea</single>\n      <multiple>sec\200\155iunile</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>versetul</single>\n      <multiple>versetele</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>volumul</single>\n      <multiple>volumele</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">cart.</term>\n    <term name=\"chapter\" form=\"short\">cap.</term>\n    <term name=\"column\" form=\"short\">col.</term>\n    <term name=\"figure\" form=\"short\">fig.</term>\n    <term name=\"folio\" form=\"short\">fol.</term>\n    <term name=\"issue\" form=\"short\">nr.</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op.</term>\n    <term name=\"page\" form=\"short\">\n      <single>p.</single>\n      <multiple>pp.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">par.</term>\n    <term name=\"part\" form=\"short\">part.</term>\n    <term name=\"section\" form=\"short\">sec.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v.</single>\n      <multiple>vv.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>vol.</single>\n      <multiple>vol.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directori</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>editor</single>\n      <multiple>editori</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>editor</single>\n      <multiple>editori</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>ilustrator</single>\n      <multiple>ilustratori</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>traduc\196\131tor</single>\n      <multiple>traduc\196\131tori</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>editor &amp; traduc\196\131tor</single>\n      <multiple>editori &amp; traduc\196\131tori</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dir.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>ed.</single>\n      <multiple>ed.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ed.</single>\n      <multiple>ed.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ilustr.</single>\n      <multiple>ilustr.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>trad.</single>\n      <multiple>trad.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ed. &amp; trad.</single>\n      <multiple>ed. &amp; trad.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">coordonat de</term>\n    <term name=\"editor\" form=\"verb\">edi\200\155ie de</term>\n    <term name=\"editorial-director\" form=\"verb\">edi\200\155ie de</term>\n    <term name=\"illustrator\" form=\"verb\">ilustra\200\155ii de</term>\n    <term name=\"interviewer\" form=\"verb\">interviu de</term>\n    <term name=\"recipient\" form=\"verb\">\195\174n</term>\n    <term name=\"reviewed-author\" form=\"verb\">de</term>\n    <term name=\"translator\" form=\"verb\">traducere de</term>\n    <term name=\"editortranslator\" form=\"verb\">edi\200\155ie &amp; traducere de</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">de</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">ed.</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed.</term>\n    <term name=\"illustrator\" form=\"verb-short\">ilustr.</term>\n    <term name=\"translator\" form=\"verb-short\">trad.</term>\n    <term name=\"editortranslator\" form=\"verb-short\">ed. &amp; trad. de</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">ianuarie</term>\n    <term name=\"month-02\">februarie</term>\n    <term name=\"month-03\">martie</term>\n    <term name=\"month-04\">aprilie</term>\n    <term name=\"month-05\">mai</term>\n    <term name=\"month-06\">iunie</term>\n    <term name=\"month-07\">iulie</term>\n    <term name=\"month-08\">august</term>\n    <term name=\"month-09\">septembrie</term>\n    <term name=\"month-10\">octombrie</term>\n    <term name=\"month-11\">noiembrie</term>\n    <term name=\"month-12\">decembrie</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">ian.</term>\n    <term name=\"month-02\" form=\"short\">feb.</term>\n    <term name=\"month-03\" form=\"short\">mar.</term>\n    <term name=\"month-04\" form=\"short\">apr.</term>\n    <term name=\"month-05\" form=\"short\">mai</term>\n    <term name=\"month-06\" form=\"short\">iun.</term>\n    <term name=\"month-07\" form=\"short\">iul.</term>\n    <term name=\"month-08\" form=\"short\">aug.</term>\n    <term name=\"month-09\" form=\"short\">sep.</term>\n    <term name=\"month-10\" form=\"short\">oct.</term>\n    <term name=\"month-11\" form=\"short\">nov.</term>\n    <term name=\"month-12\" form=\"short\">dec.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">prim\196\131vara</term>\n    <term name=\"season-02\">vara</term>\n    <term name=\"season-03\">toamna</term>\n    <term name=\"season-04\">iarna</term>\n  </terms>\n</locale>\n"),("locales-ru-RU.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"ru-RU\">\n  <info>\n    <translator>\n      <name>Alexei Kouprianov</name>\n      <email>alexei.kouprianov@gmail.com</email>\n    </translator>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\" \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\" suffix=\" \208\179.\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\".\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\".\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">\208\191\209\128\208\190\209\129\208\188\208\190\209\130\209\128\208\181\208\189\208\190</term>\n    <term name=\"and\">\208\184</term>\n    <term name=\"and others\">\208\184 \208\180\209\128.</term>\n    <term name=\"anonymous\">\208\176\208\189\208\190\208\189\208\184\208\188</term>\n    <term name=\"anonymous\" form=\"short\">\208\176\208\189\208\190\208\189.</term>\n    <term name=\"at\">\208\189\208\176</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\"/>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">ca.</term>\n    <term name=\"cited\">\209\134\208\184\209\130\208\184\209\128\209\131\208\181\209\130\209\129\209\143 \208\191\208\190</term>\n    <term name=\"cited\" form=\"short\">\209\134\208\184\209\130. \208\191\208\190</term>\n    <term name=\"edition\">\n      <single>\208\184\208\183\208\180\208\176\208\189\208\184\208\181</single>\n      <multiple>\208\184\208\183\208\180\208\176\208\189\208\184\209\143</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">\208\184\208\183\208\180.</term>\n    <term name=\"et-al\">\208\184 \208\180\209\128.</term>\n    <term name=\"forthcoming\">\208\190\208\182\208\184\208\180\208\176\208\181\209\130\209\129\209\143</term>\n    <term name=\"from\">\208\190\209\130</term>\n    <term name=\"ibid\">\209\130\208\176\208\188 \208\182\208\181</term>\n    <term name=\"in\">\208\178</term>\n    <term name=\"in press\">\208\178 \208\191\208\181\209\135\208\176\209\130\208\184</term>\n    <term name=\"internet\">\208\152\208\189\209\130\208\181\209\128\208\189\208\181\209\130</term>\n    <term name=\"interview\">\208\184\208\189\209\130\208\181\209\128\208\178\209\140\209\142</term>\n    <term name=\"letter\">\208\191\208\184\209\129\209\140\208\188\208\190</term>\n    <term name=\"no date\">\208\177\208\181\208\183 \208\180\208\176\209\130\209\139</term>\n    <term name=\"no date\" form=\"short\">\208\177. \208\180.</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">\208\191\209\128\208\181\208\180\209\129\209\130\208\176\208\178\208\187\208\181\208\189\208\190 \208\189\208\176</term>\n    <term name=\"reference\">\n      <single>reference</single>\n      <multiple>references</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">\208\184\208\183\208\178\208\187\208\181\209\135\208\181\208\189\208\190</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">\208\189. \209\141.</term>\n    <term name=\"bc\">\208\180\208\190 \208\189. \209\141.</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\194\171</term>\n    <term name=\"close-quote\">\194\187</term>\n    <term name=\"open-inner-quote\">\226\128\158</term>\n    <term name=\"close-inner-quote\">\226\128\156</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">\208\185</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">\208\191\208\181\209\128\208\178\209\139\208\185</term>\n    <term name=\"long-ordinal-02\">\208\178\209\130\208\190\209\128\208\190\208\185</term>\n    <term name=\"long-ordinal-03\">\209\130\209\128\208\181\209\130\208\184\208\185</term>\n    <term name=\"long-ordinal-04\">\209\135\208\181\209\130\208\178\208\181\209\128\209\130\209\139\208\185</term>\n    <term name=\"long-ordinal-05\">\208\191\209\143\209\130\209\139\208\185</term>\n    <term name=\"long-ordinal-06\">\209\136\208\181\209\129\209\130\208\190\208\185</term>\n    <term name=\"long-ordinal-07\">\209\129\208\181\208\180\209\140\208\188\208\190\208\185</term>\n    <term name=\"long-ordinal-08\">\208\178\208\190\209\129\209\140\208\188\208\190\208\185</term>\n    <term name=\"long-ordinal-09\">\208\180\208\181\208\178\209\143\209\130\209\139\208\185</term>\n    <term name=\"long-ordinal-10\">\208\180\208\181\209\129\209\143\209\130\209\139\208\185</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>\208\186\208\189\208\184\208\179\208\176</single>\n      <multiple>\208\186\208\189\208\184\208\179\208\184</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>\208\179\208\187\208\176\208\178\208\176</single>\n      <multiple>\208\179\208\187\208\176\208\178\209\139</multiple>\n    </term>\n    <term name=\"column\">\n      <single>\209\129\209\130\208\190\208\187\208\177\208\181\209\134</single>\n      <multiple>\209\129\209\130\208\190\208\187\208\177\209\134\209\139</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>\209\128\208\184\209\129\209\131\208\189\208\190\208\186</single>\n      <multiple>\209\128\208\184\209\129\209\131\208\189\208\186\208\184</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>\208\187\208\184\209\129\209\130</single>\n      <multiple>\208\187\208\184\209\129\209\130\209\139</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>\208\178\209\139\208\191\209\131\209\129\208\186</single>\n      <multiple>\208\178\209\139\208\191\209\131\209\129\208\186\208\184</multiple>\n    </term>\n    <term name=\"line\">\n      <single>\209\129\209\130\209\128\208\190\208\186\208\176</single>\n      <multiple>\209\129\209\130\209\128\208\190\208\186\208\184</multiple>\n    </term>\n    <term name=\"note\">\n      <single>\208\191\209\128\208\184\208\188\208\181\209\135\208\176\208\189\208\184\208\181</single>\n      <multiple>\208\191\209\128\208\184\208\188\208\181\209\135\208\176\208\189\208\184\209\143</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>\209\129\208\190\209\135\208\184\208\189\208\181\208\189\208\184\208\181</single>\n      <multiple>\209\129\208\190\209\135\208\184\208\189\208\181\208\189\208\184\209\143</multiple>\n    </term>\n    <term name=\"page\">\n      <single>\209\129\209\130\209\128\208\176\208\189\208\184\209\134\208\176</single>\n      <multiple>\209\129\209\130\209\128\208\176\208\189\208\184\209\134\209\139</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>\208\191\208\176\209\128\208\176\208\179\209\128\208\176\209\132</single>\n      <multiple>\208\191\208\176\209\128\208\176\208\179\209\128\208\176\209\132\209\139</multiple>\n    </term>\n    <term name=\"part\">\n      <single>\209\135\208\176\209\129\209\130\209\140</single>\n      <multiple>\209\135\208\176\209\129\209\130\208\184</multiple>\n    </term>\n    <term name=\"section\">\n      <single>\209\128\208\176\208\183\208\180\208\181\208\187</single>\n      <multiple>\209\128\208\176\208\183\208\180\208\181\208\187\209\139</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>\209\129\208\188\208\190\209\130\209\128\208\184</single>\n      <multiple>\209\129\208\188\208\190\209\130\209\128\208\184</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>\209\129\209\130\208\184\209\133</single>\n      <multiple>\209\129\209\130\208\184\209\133\208\184</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>\209\130\208\190\208\188</single>\n      <multiple>\209\130\208\190\208\188\208\176</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">\208\186\208\189.</term>\n    <term name=\"chapter\" form=\"short\">\208\179\208\187.</term>\n    <term name=\"column\" form=\"short\">\209\129\209\130\208\177.</term>\n    <term name=\"figure\" form=\"short\">\209\128\208\184\209\129.</term>\n    <term name=\"folio\" form=\"short\">\208\187.</term>\n    <term name=\"issue\" form=\"short\">\226\132\150</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">\209\129\208\190\209\135.</term>\n    <term name=\"page\" form=\"short\">\n      <single>\209\129.</single>\n      <multiple>\209\129.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">\208\191\208\176\209\128\208\176.</term>\n    <term name=\"part\" form=\"short\">\209\135.</term>\n    <term name=\"section\" form=\"short\">\209\128\208\176\208\183\208\180.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>\209\129\208\188.</single>\n      <multiple>\209\129\208\188.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>\209\129\209\130.</single>\n      <multiple>\209\129\209\130.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>\209\130.</single>\n      <multiple>\209\130\209\130.</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>\209\128\208\181\208\180\208\176\208\186\209\130\208\190\209\128</single>\n      <multiple>\209\128\208\181\208\180\208\176\208\186\209\130\208\190\209\128\209\139</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>\208\190\209\130\208\178\208\181\209\130\209\129\209\130\208\178\208\181\208\189\208\189\209\139\208\185 \209\128\208\181\208\180\208\176\208\186\209\130\208\190\209\128</single>\n      <multiple>\208\190\209\130\208\178\208\181\209\130\209\129\209\130\208\178\208\181\208\189\208\189\209\139\208\181 \209\128\208\181\208\180\208\176\208\186\209\130\208\190\209\128\209\139</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>\208\191\208\181\209\128\208\181\208\178\208\190\208\180\209\135\208\184\208\186</single>\n      <multiple>\208\191\208\181\209\128\208\181\208\178\208\190\208\180\209\135\208\184\208\186\208\184</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>\209\128\208\181\208\180\208\176\208\186\209\130\208\190\209\128 \208\184 \208\191\208\181\209\128\208\181\208\178\208\190\208\180\209\135\208\184\208\186</single>\n      <multiple>\209\128\208\181\208\180\208\176\208\186\209\130\208\190\209\128\209\139 \208\184 \208\191\208\181\209\128\208\181\208\178\208\190\208\180\209\135\208\184\208\186\208\184</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>\209\128\208\181\208\180.</single>\n      <multiple>\209\128\208\181\208\180.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>\208\190\209\130\208\178. \209\128\208\181\208\180.</single>\n      <multiple>\208\190\209\130\208\178. \209\128\208\181\208\180.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>\208\191\208\181\209\128\208\181\208\178.</single>\n      <multiple>\208\191\208\181\209\128\208\181\208\178.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>\209\128\208\181\208\180. \208\184 \208\191\208\181\209\128\208\181\208\178.</single>\n      <multiple>\209\128\208\181\208\180. \208\184 \208\191\208\181\209\128\208\181\208\178.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">\208\190\209\130\209\128\208\181\208\180\208\176\208\186\209\130\208\184\209\128\208\190\208\178\208\176\208\189\208\190</term>\n    <term name=\"editorial-director\" form=\"verb\">\208\190\209\130\209\128\208\181\208\180\208\176\208\186\209\130\208\184\209\128\208\190\208\178\208\176\208\189\208\190</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">\208\184\208\189\209\130\208\181\209\128\208\178\209\140\209\142</term>\n    <term name=\"recipient\" form=\"verb\">\208\186</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">\208\191\208\181\209\128\208\181\208\178\208\181\208\180\208\181\208\189\208\190</term>\n    <term name=\"editortranslator\" form=\"verb\">\208\190\209\130\209\128\208\181\208\180\208\176\208\186\209\130\208\184\209\128\208\190\208\178\208\176\208\189\208\190 \208\184 \208\191\208\181\209\128\208\181\208\178\208\181\208\180\208\181\208\189\208\190</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\"/>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">\209\128\208\181\208\180.</term>\n    <term name=\"editorial-director\" form=\"verb-short\">\208\190\209\130\208\178. \209\128\208\181\208\180.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">\208\191\208\181\209\128\208\181\208\178.</term>\n    <term name=\"editortranslator\" form=\"verb-short\">\209\128\208\181\208\180. \208\184 \208\191\208\181\209\128\208\181\208\178.</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">\209\143\208\189\208\178\208\176\209\128\209\140</term>\n    <term name=\"month-02\">\209\132\208\181\208\178\209\128\208\176\208\187\209\140</term>\n    <term name=\"month-03\">\208\188\208\176\209\128\209\130</term>\n    <term name=\"month-04\">\208\176\208\191\209\128\208\181\208\187\209\140</term>\n    <term name=\"month-05\">\208\188\208\176\208\185</term>\n    <term name=\"month-06\">\208\184\209\142\208\189\209\140</term>\n    <term name=\"month-07\">\208\184\209\142\208\187\209\140</term>\n    <term name=\"month-08\">\208\176\208\178\208\179\209\131\209\129\209\130</term>\n    <term name=\"month-09\">\209\129\208\181\208\189\209\130\209\143\208\177\209\128\209\140</term>\n    <term name=\"month-10\">\208\190\208\186\209\130\209\143\208\177\209\128\209\140</term>\n    <term name=\"month-11\">\208\189\208\190\209\143\208\177\209\128\209\140</term>\n    <term name=\"month-12\">\208\180\208\181\208\186\208\176\208\177\209\128\209\140</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">\209\143\208\189\208\178.</term>\n    <term name=\"month-02\" form=\"short\">\209\132\208\181\208\178.</term>\n    <term name=\"month-03\" form=\"short\">\208\188\208\176\209\128.</term>\n    <term name=\"month-04\" form=\"short\">\208\176\208\191\209\128.</term>\n    <term name=\"month-05\" form=\"short\">\208\188\208\176\208\185</term>\n    <term name=\"month-06\" form=\"short\">\208\184\209\142\208\189.</term>\n    <term name=\"month-07\" form=\"short\">\208\184\209\142\208\187.</term>\n    <term name=\"month-08\" form=\"short\">\208\176\208\178\208\179.</term>\n    <term name=\"month-09\" form=\"short\">\209\129\208\181\208\189.</term>\n    <term name=\"month-10\" form=\"short\">\208\190\208\186\209\130.</term>\n    <term name=\"month-11\" form=\"short\">\208\189\208\190\209\143.</term>\n    <term name=\"month-12\" form=\"short\">\208\180\208\181\208\186.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">\208\178\208\181\209\129\208\189\208\176</term>\n    <term name=\"season-02\">\208\187\208\181\209\130\208\176</term>\n    <term name=\"season-03\">\208\190\209\129\208\181\208\189\209\140</term>\n    <term name=\"season-04\">\208\183\208\184\208\188\208\176</term>\n  </terms>\n</locale>\n"),("locales-sk-SK.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"sk-SK\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\". \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" suffix=\".\"/>\n    <date-part name=\"month\" form=\"numeric\" suffix=\".\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">cit</term>\n    <term name=\"and\">a</term>\n    <term name=\"and others\">a \196\143al\197\161\195\173</term>\n    <term name=\"anonymous\">anonym</term>\n    <term name=\"anonymous\" form=\"short\">anon</term>\n    <term name=\"at\">v</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">by</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">cca.</term>\n    <term name=\"cited\">cit</term>\n    <term name=\"edition\">\n      <single>vydanie</single>\n      <multiple>vydania</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">vyd</term>\n    <term name=\"et-al\">et al</term>\n    <term name=\"forthcoming\">nadch\195\161dzaj\195\186ci</term>\n    <term name=\"from\">z</term>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\">v</term>\n    <term name=\"in press\">v tla\196\141i</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">osobn\195\161 komunik\195\161cia</term>\n    <term name=\"letter\">list</term>\n    <term name=\"no date\">no date</term>\n    <term name=\"no date\" form=\"short\">n.d.</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">prezentovan\195\169 na</term>\n    <term name=\"reference\">\n      <single>reference</single>\n      <multiple>references</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">cit</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">po Kr.</term>\n    <term name=\"bc\">pred Kr.</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\156</term>\n    <term name=\"close-quote\">\226\128\157</term>\n    <term name=\"open-inner-quote\">\226\128\152</term>\n    <term name=\"close-inner-quote\">\226\128\153</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">th</term>\n    <term name=\"ordinal-01\">st</term>\n    <term name=\"ordinal-02\">nd</term>\n    <term name=\"ordinal-03\">rd</term>\n    <term name=\"ordinal-11\">th</term>\n    <term name=\"ordinal-12\">th</term>\n    <term name=\"ordinal-13\">th</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">first</term>\n    <term name=\"long-ordinal-02\">second</term>\n    <term name=\"long-ordinal-03\">third</term>\n    <term name=\"long-ordinal-04\">fourth</term>\n    <term name=\"long-ordinal-05\">fifth</term>\n    <term name=\"long-ordinal-06\">sixth</term>\n    <term name=\"long-ordinal-07\">seventh</term>\n    <term name=\"long-ordinal-08\">eighth</term>\n    <term name=\"long-ordinal-09\">ninth</term>\n    <term name=\"long-ordinal-10\">tenth</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>kniha</single>\n      <multiple>knihy</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>kapitola</single>\n      <multiple>kapitoly</multiple>\n    </term>\n    <term name=\"column\">\n      <single>st\196\186pec</single>\n      <multiple>st\196\186pce</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>obr\195\161zok</single>\n      <multiple>obr\195\161zky</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>list</single>\n      <multiple>listy</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>\196\141\195\173slo</single>\n      <multiple>\196\141\195\173sla</multiple>\n    </term>\n    <term name=\"line\">\n      <single>riadok</single>\n      <multiple>riadky</multiple>\n    </term>\n    <term name=\"note\">\n      <single>pozn\195\161mka</single>\n      <multiple>pozn\195\161mky</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>strana</single>\n      <multiple>strany</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>odstavec</single>\n      <multiple>odstavce</multiple>\n    </term>\n    <term name=\"part\">\n      <single>\196\141as\197\165</single>\n      <multiple>\196\141asti</multiple>\n    </term>\n    <term name=\"section\">\n      <single>sekcia</single>\n      <multiple>sekcie</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>ver\197\161</single>\n      <multiple>ver\197\161e</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>ro\196\141n\195\173k</single>\n      <multiple>ro\196\141n\195\173ky</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">k</term>\n    <term name=\"chapter\" form=\"short\">kap</term>\n    <term name=\"column\" form=\"short\">st\196\186p</term>\n    <term name=\"figure\" form=\"short\">obr</term>\n    <term name=\"folio\" form=\"short\">l</term>\n    <term name=\"issue\" form=\"short\">\196\141</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op</term>\n    <term name=\"page\" form=\"short\">\n      <single>s</single>\n      <multiple>s</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">par</term>\n    <term name=\"part\" form=\"short\">\196\141</term>\n    <term name=\"section\" form=\"short\">sek</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v</single>\n      <multiple>v</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>ro\196\141</single>\n      <multiple>ro\196\141</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>editor</single>\n      <multiple>editori</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>zostavovate\196\190</single>\n      <multiple>zostavovatelia</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>prekladate\196\190</single>\n      <multiple>prekladatelia</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>zostavovate\196\190 &amp; prekladate\196\190</single>\n      <multiple>zostavovatelia &amp; prekladatelia</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>ed</single>\n      <multiple>ed</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>zost.</single>\n      <multiple>zost.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>prel</single>\n      <multiple>prel</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ed. &amp; tran.</single>\n      <multiple>eds. &amp; trans.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">zostavil</term>\n    <term name=\"editorial-director\" form=\"verb\">zostavil</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">rozhovor urobil</term>\n    <term name=\"recipient\" form=\"verb\">adres\195\161t</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">prelo\197\190il</term>\n    <term name=\"editortranslator\" form=\"verb\">zostavil &amp; prelo\197\190il</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">by</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">ed</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">prel</term>\n    <term name=\"editortranslator\" form=\"verb-short\">zost. &amp; prel.</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">janu\195\161r</term>\n    <term name=\"month-02\">febru\195\161r</term>\n    <term name=\"month-03\">marec</term>\n    <term name=\"month-04\">apr\195\173l</term>\n    <term name=\"month-05\">m\195\161j</term>\n    <term name=\"month-06\">j\195\186n</term>\n    <term name=\"month-07\">j\195\186l</term>\n    <term name=\"month-08\">august</term>\n    <term name=\"month-09\">september</term>\n    <term name=\"month-10\">okt\195\179ber</term>\n    <term name=\"month-11\">november</term>\n    <term name=\"month-12\">december</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">jan</term>\n    <term name=\"month-02\" form=\"short\">feb</term>\n    <term name=\"month-03\" form=\"short\">mar</term>\n    <term name=\"month-04\" form=\"short\">apr</term>\n    <term name=\"month-05\" form=\"short\">m\195\161j</term>\n    <term name=\"month-06\" form=\"short\">j\195\186n</term>\n    <term name=\"month-07\" form=\"short\">j\195\186l</term>\n    <term name=\"month-08\" form=\"short\">aug</term>\n    <term name=\"month-09\" form=\"short\">sep</term>\n    <term name=\"month-10\" form=\"short\">okt</term>\n    <term name=\"month-11\" form=\"short\">nov</term>\n    <term name=\"month-12\" form=\"short\">dec</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">Jar</term>\n    <term name=\"season-02\">Leto</term>\n    <term name=\"season-03\">Jese\197\136</term>\n    <term name=\"season-04\">Zima</term>\n  </terms>\n</locale>\n"),("locales-sl-SI.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"sl-SI\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\". \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\" suffix=\".\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"year\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" prefix=\"-\" range-delimiter=\"/\"/>\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" prefix=\"-\" range-delimiter=\"/\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">dostopano</term>\n    <term name=\"and\">in</term>\n    <term name=\"and others\">in drugi</term>\n    <term name=\"anonymous\">anonimni</term>\n    <term name=\"anonymous\" form=\"short\">anon</term>\n    <term name=\"at\">pri</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">by</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">citirano</term>\n    <term name=\"edition\">\n      <single>izdaja</single>\n      <multiple>izdaje</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">iz</term>\n    <term name=\"et-al\">idr.</term>\n    <term name=\"forthcoming\">pred izidom</term>\n    <term name=\"from\">od</term>\n    <term name=\"ibid\">isto</term>\n    <term name=\"in\">v</term>\n    <term name=\"in press\">v tisku</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">intervju</term>\n    <term name=\"letter\">pismo</term>\n    <term name=\"no date\">no date</term>\n    <term name=\"no date\" form=\"short\">b.d.</term>\n    <term name=\"online\">na spletu</term>\n    <term name=\"presented at\">predstavljeno na</term>\n    <term name=\"reference\">\n      <single>reference</single>\n      <multiple>references</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">pridobljeno</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">AD</term>\n    <term name=\"bc\">BC</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\158</term>\n    <term name=\"close-quote\">\226\128\156</term>\n    <term name=\"open-inner-quote\">\226\128\154</term>\n    <term name=\"close-inner-quote\">\226\128\152</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">th</term>\n    <term name=\"ordinal-01\">st</term>\n    <term name=\"ordinal-02\">nd</term>\n    <term name=\"ordinal-03\">rd</term>\n    <term name=\"ordinal-11\">th</term>\n    <term name=\"ordinal-12\">th</term>\n    <term name=\"ordinal-13\">th</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">first</term>\n    <term name=\"long-ordinal-02\">second</term>\n    <term name=\"long-ordinal-03\">third</term>\n    <term name=\"long-ordinal-04\">fourth</term>\n    <term name=\"long-ordinal-05\">fifth</term>\n    <term name=\"long-ordinal-06\">sixth</term>\n    <term name=\"long-ordinal-07\">seventh</term>\n    <term name=\"long-ordinal-08\">eighth</term>\n    <term name=\"long-ordinal-09\">ninth</term>\n    <term name=\"long-ordinal-10\">tenth</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>knjiga</single>\n      <multiple>knjige</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>poglavje</single>\n      <multiple>poglavja</multiple>\n    </term>\n    <term name=\"column\">\n      <single>stolpec</single>\n      <multiple>stolpci</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>slika</single>\n      <multiple>slike</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folio</single>\n      <multiple>folii</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>\197\161tevilka</single>\n      <multiple>\197\161tevilke</multiple>\n    </term>\n    <term name=\"line\">\n      <single>vrstica</single>\n      <multiple>vrstice</multiple>\n    </term>\n    <term name=\"note\">\n      <single>opomba</single>\n      <multiple>opombe</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>stran</single>\n      <multiple>strani</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>odstavek</single>\n      <multiple>odstavki</multiple>\n    </term>\n    <term name=\"part\">\n      <single>del</single>\n      <multiple>deli</multiple>\n    </term>\n    <term name=\"section\">\n      <single>odsek</single>\n      <multiple>odseki</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>verz</single>\n      <multiple>verzi</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>letnik</single>\n      <multiple>letniki</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">knj</term>\n    <term name=\"chapter\" form=\"short\">pogl</term>\n    <term name=\"column\" form=\"short\">sto</term>\n    <term name=\"figure\" form=\"short\">sl</term>\n    <term name=\"folio\" form=\"short\">f</term>\n    <term name=\"issue\" form=\"short\">\197\161t</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op</term>\n    <term name=\"page\" form=\"short\">\n      <single>str</single>\n      <multiple>str</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">odst</term>\n    <term name=\"part\" form=\"short\">del</term>\n    <term name=\"section\" form=\"short\">odsk</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v</single>\n      <multiple>v</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>let</single>\n      <multiple>let</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>urednik</single>\n      <multiple>uredniki</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>prevajalec</single>\n      <multiple>prevajalci</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>editor &amp; translator</single>\n      <multiple>editors &amp; translators</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>ur</single>\n      <multiple>ur</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ed.</single>\n      <multiple>eds.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>prev</single>\n      <multiple>prev</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ed. &amp; tran.</single>\n      <multiple>eds. &amp; trans.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">uredil</term>\n    <term name=\"editorial-director\" form=\"verb\">edited by</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">intervjuval</term>\n    <term name=\"recipient\" form=\"verb\">za</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">prevedel</term>\n    <term name=\"editortranslator\" form=\"verb\">edited &amp; translated by</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">by</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">ur</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">prev</term>\n    <term name=\"editortranslator\" form=\"verb-short\">ed. &amp; trans. by</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">januar</term>\n    <term name=\"month-02\">februar</term>\n    <term name=\"month-03\">marec</term>\n    <term name=\"month-04\">april</term>\n    <term name=\"month-05\">maj</term>\n    <term name=\"month-06\">junij</term>\n    <term name=\"month-07\">julij</term>\n    <term name=\"month-08\">avgust</term>\n    <term name=\"month-09\">september</term>\n    <term name=\"month-10\">oktober</term>\n    <term name=\"month-11\">november</term>\n    <term name=\"month-12\">december</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">jan</term>\n    <term name=\"month-02\" form=\"short\">feb</term>\n    <term name=\"month-03\" form=\"short\">mar</term>\n    <term name=\"month-04\" form=\"short\">apr</term>\n    <term name=\"month-05\" form=\"short\">maj</term>\n    <term name=\"month-06\" form=\"short\">jun</term>\n    <term name=\"month-07\" form=\"short\">jul</term>\n    <term name=\"month-08\" form=\"short\">avg</term>\n    <term name=\"month-09\" form=\"short\">sep</term>\n    <term name=\"month-10\" form=\"short\">okt</term>\n    <term name=\"month-11\" form=\"short\">nov</term>\n    <term name=\"month-12\" form=\"short\">dec</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">Spring</term>\n    <term name=\"season-02\">Summer</term>\n    <term name=\"season-03\">Autumn</term>\n    <term name=\"season-04\">Winter</term>\n  </terms>\n</locale>\n"),("locales-sr-RS.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"sr-RS\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\". \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\" suffix=\".\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"year\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" prefix=\"-\" range-delimiter=\"/\"/>\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" prefix=\"-\" range-delimiter=\"/\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">\208\191\209\128\208\184\209\129\209\130\209\131\208\191\209\153\208\181\208\189\208\190</term>\n    <term name=\"and\">\208\184</term>\n    <term name=\"and others\">\208\184 \208\190\209\129\209\130\208\176\208\187\208\184</term>\n    <term name=\"anonymous\">\208\176\208\189\208\190\208\189\208\184\208\188\208\189\208\176</term>\n    <term name=\"anonymous\" form=\"short\">\208\176\208\189\208\190\208\189.</term>\n    <term name=\"at\">\208\189\208\176</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">by</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">\209\134\208\184\209\130\208\184\209\128\208\176\208\189\208\190</term>\n    <term name=\"edition\">\n      <single>\208\184\208\183\208\180\208\176\209\154\208\181</single>\n      <multiple>\208\184\208\183\208\180\208\176\209\154\208\176</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">\208\184\208\183\208\180.</term>\n    <term name=\"et-al\">\208\184 \208\190\209\129\209\130\208\176\208\187\208\184</term>\n    <term name=\"forthcoming\">\208\180\208\190\208\187\208\176\208\183\208\181\209\155\208\184</term>\n    <term name=\"from\">\208\190\208\180</term>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\">\209\131</term>\n    <term name=\"in press\">\209\131 \209\136\209\130\208\176\208\188\208\191\208\184</term>\n    <term name=\"internet\">\208\152\208\189\209\130\208\181\209\128\208\189\208\181\209\130</term>\n    <term name=\"interview\">\208\184\208\189\209\130\208\181\209\128\208\178\209\152\209\131</term>\n    <term name=\"letter\">\208\191\208\184\209\129\208\188\208\190</term>\n    <term name=\"no date\">no date</term>\n    <term name=\"no date\" form=\"short\">\208\177\208\181\208\183 \208\180\208\176\209\130\209\131\208\188\208\176</term>\n    <term name=\"online\">\208\189\208\176 \208\152\208\189\209\130\208\181\209\128\208\189\208\181\209\130\209\131</term>\n    <term name=\"presented at\">\208\191\209\128\208\181\208\180\209\129\209\130\208\176\208\178\209\153\208\181\208\189\208\190 \208\189\208\176</term>\n    <term name=\"reference\">\n      <single>reference</single>\n      <multiple>references</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">\208\191\209\128\208\181\209\131\208\183\208\181\209\130\208\190</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">AD</term>\n    <term name=\"bc\">BC</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\158</term>\n    <term name=\"close-quote\">\226\128\156</term>\n    <term name=\"open-inner-quote\">\226\128\154</term>\n    <term name=\"close-inner-quote\">\226\128\152</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">th</term>\n    <term name=\"ordinal-01\">st</term>\n    <term name=\"ordinal-02\">nd</term>\n    <term name=\"ordinal-03\">rd</term>\n    <term name=\"ordinal-11\">th</term>\n    <term name=\"ordinal-12\">th</term>\n    <term name=\"ordinal-13\">th</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">first</term>\n    <term name=\"long-ordinal-02\">second</term>\n    <term name=\"long-ordinal-03\">third</term>\n    <term name=\"long-ordinal-04\">fourth</term>\n    <term name=\"long-ordinal-05\">fifth</term>\n    <term name=\"long-ordinal-06\">sixth</term>\n    <term name=\"long-ordinal-07\">seventh</term>\n    <term name=\"long-ordinal-08\">eighth</term>\n    <term name=\"long-ordinal-09\">ninth</term>\n    <term name=\"long-ordinal-10\">tenth</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>\208\186\209\154\208\184\208\179\208\176</single>\n      <multiple>\208\186\209\154\208\184\208\179\208\181</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>\208\191\208\190\208\179\208\187\208\176\208\178\209\153\208\181</single>\n      <multiple>\208\191\208\190\208\179\208\187\208\176\208\178\209\153\208\176</multiple>\n    </term>\n    <term name=\"column\">\n      <single>\208\186\208\190\208\187\208\190\208\189\208\176</single>\n      <multiple>\208\186\208\190\208\187\208\190\208\189\208\181</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>\209\134\209\128\209\130\208\181\208\182</single>\n      <multiple>\209\134\209\128\209\130\208\181\208\182\208\184</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>\209\132\208\190\208\187\208\184\208\190</single>\n      <multiple>\209\132\208\190\208\187\208\184\209\152\208\184</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>\208\177\209\128\208\190\209\152</single>\n      <multiple>\208\177\209\128\208\190\209\152\208\181\208\178\208\184</multiple>\n    </term>\n    <term name=\"line\">\n      <single>\208\187\208\184\208\189\208\184\209\152\208\176</single>\n      <multiple>\208\187\208\184\208\189\208\184\209\152\208\181</multiple>\n    </term>\n    <term name=\"note\">\n      <single>\208\177\208\181\208\187\208\181\209\136\208\186\208\176</single>\n      <multiple>\208\177\208\181\208\187\208\181\209\136\208\186\208\181</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>\208\190\208\191\209\131\209\129</single>\n      <multiple>\208\190\208\191\208\181\209\128\208\176</multiple>\n    </term>\n    <term name=\"page\">\n      <single>\209\129\209\130\209\128\208\176\208\189\208\184\209\134\208\176</single>\n      <multiple>\209\129\209\130\209\128\208\176\208\189\208\184\209\134\208\181</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>\208\191\208\176\209\128\208\176\208\179\209\128\208\176\209\132</single>\n      <multiple>\208\191\208\176\209\128\208\176\208\179\209\128\208\176\209\132\208\184</multiple>\n    </term>\n    <term name=\"part\">\n      <single>\208\180\208\181\208\190</single>\n      <multiple>\208\180\208\181\208\187\208\190\208\178\208\176</multiple>\n    </term>\n    <term name=\"section\">\n      <single>\208\190\208\180\208\181\209\153\208\176\208\186</single>\n      <multiple>\208\190\208\180\208\181\209\153\208\176\208\186\208\176</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>\209\129\209\130\209\128\208\190\209\132\208\176</single>\n      <multiple>\209\129\209\130\209\128\208\190\209\132\208\181</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>\209\130\208\190\208\188</single>\n      <multiple>\209\130\208\190\208\188\208\190\208\178\208\176</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">\208\186\209\154\208\184\208\179\208\176</term>\n    <term name=\"chapter\" form=\"short\">\208\159\208\190\208\179.</term>\n    <term name=\"column\" form=\"short\">\208\186\208\190\208\187.</term>\n    <term name=\"figure\" form=\"short\">\209\134\209\128\209\130.</term>\n    <term name=\"folio\" form=\"short\">\209\132\208\190\208\187\208\184\208\190</term>\n    <term name=\"issue\" form=\"short\">\208\184\208\183\208\180.</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">\208\190\208\191.</term>\n    <term name=\"page\" form=\"short\">\n      <single>\209\129\209\130\209\128.</single>\n      <multiple>\209\129\209\130\209\128.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">\208\191\208\176\209\128.</term>\n    <term name=\"part\" form=\"short\">\208\180\208\181\208\190</term>\n    <term name=\"section\" form=\"short\">\208\190\208\180.</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>\209\129\209\130\209\128.</single>\n      <multiple>\209\129\209\130\209\128.</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>\209\130\208\190\208\188</single>\n      <multiple>\209\130\208\190\208\188\208\190\208\178\208\184</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>\209\131\209\128\208\181\208\180\208\189\208\184\208\186</single>\n      <multiple>\209\131\209\128\208\181\208\180\208\184\208\189\208\184\209\134\208\184</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>\208\191\209\128\208\181\208\178\208\190\208\180\208\184\208\187\208\176\209\134</single>\n      <multiple>\208\191\209\128\208\181\208\178\208\190\208\180\208\184\208\190\209\134\208\184</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>editor &amp; translator</single>\n      <multiple>editors &amp; translators</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>\209\131\209\128.</single>\n      <multiple>\209\131\209\128.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ed.</single>\n      <multiple>eds.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>\208\191\209\128\208\181\208\178.</single>\n      <multiple>\208\191\209\128\208\181\208\178.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ed. &amp; tran.</single>\n      <multiple>eds. &amp; trans.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">\209\131\209\128\208\181\208\180\208\184\208\190</term>\n    <term name=\"editorial-director\" form=\"verb\">edited by</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">\208\184\208\189\209\130\208\181\209\128\208\178\209\152\209\131\208\184\209\129\208\176\208\190</term>\n    <term name=\"recipient\" form=\"verb\">\208\191\209\128\208\184\208\188\208\176</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">\208\191\209\128\208\181\208\178\208\181\208\190</term>\n    <term name=\"editortranslator\" form=\"verb\">edited &amp; translated by</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">by</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">\209\131\209\128.</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">\208\191\209\128\208\181\208\178.</term>\n    <term name=\"editortranslator\" form=\"verb-short\">ed. &amp; trans. by</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">\208\136\208\176\208\189\209\131\208\176\209\128</term>\n    <term name=\"month-02\">\208\164\208\181\208\177\209\128\209\131\208\176\209\128</term>\n    <term name=\"month-03\">\208\156\208\176\209\128\209\130</term>\n    <term name=\"month-04\">\208\144\208\191\209\128\208\184\208\187</term>\n    <term name=\"month-05\">\208\156\208\176\209\152</term>\n    <term name=\"month-06\">\208\136\209\131\208\189\208\184</term>\n    <term name=\"month-07\">\208\136\209\131\208\187\208\184</term>\n    <term name=\"month-08\">\208\144\208\178\208\179\209\131\209\129\209\130</term>\n    <term name=\"month-09\">\208\161\208\181\208\191\209\130\208\181\208\188\208\177\208\176\209\128</term>\n    <term name=\"month-10\">\208\158\208\186\209\130\208\190\208\177\208\176\209\128</term>\n    <term name=\"month-11\">\208\157\208\190\208\178\208\181\208\188\208\177\208\176\209\128</term>\n    <term name=\"month-12\">\208\148\208\181\209\134\208\181\208\188\208\177\208\176\209\128</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">\208\136\208\176\208\189.</term>\n    <term name=\"month-02\" form=\"short\">\208\164\208\181\208\177.</term>\n    <term name=\"month-03\" form=\"short\">\208\156\208\176\209\128\209\130</term>\n    <term name=\"month-04\" form=\"short\">\208\144\208\191\209\128.</term>\n    <term name=\"month-05\" form=\"short\">\208\156\208\176\209\152</term>\n    <term name=\"month-06\" form=\"short\">\208\136\209\131\208\189\208\184</term>\n    <term name=\"month-07\" form=\"short\">\208\136\209\131\208\187\208\184</term>\n    <term name=\"month-08\" form=\"short\">\208\144\208\178\208\179.</term>\n    <term name=\"month-09\" form=\"short\">\208\161\208\181\208\191.</term>\n    <term name=\"month-10\" form=\"short\">\208\158\208\186\209\130.</term>\n    <term name=\"month-11\" form=\"short\">\208\157\208\190\208\178.</term>\n    <term name=\"month-12\" form=\"short\">\208\148\208\181\209\134.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">Spring</term>\n    <term name=\"season-02\">Summer</term>\n    <term name=\"season-03\">Autumn</term>\n    <term name=\"season-04\">Winter</term>\n  </terms>\n</locale>\n"),("locales-sv-SE.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"sv-SE\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\" \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"year\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" prefix=\"-\" range-delimiter=\"/\"/>\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" prefix=\"-\" range-delimiter=\"/\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">\195\165tkomstdatum</term>\n    <term name=\"and\">och</term>\n    <term name=\"and others\">och andra</term>\n    <term name=\"anonymous\">anonym</term>\n    <term name=\"anonymous\" form=\"short\">anon</term>\n    <term name=\"at\">vid</term>\n    <term name=\"available at\">tillg\195\164nglig vid</term>\n    <term name=\"by\">av</term>\n    <term name=\"circa\">cirka</term>\n    <term name=\"circa\" form=\"short\">ca</term>\n    <term name=\"cited\">citerad</term>\n    <term name=\"edition\">\n      <single>upplaga</single>\n      <multiple>upplagor</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">uppl</term>\n    <term name=\"et-al\">m.fl.</term>\n    <term name=\"forthcoming\">kommande</term>\n    <term name=\"from\">fr\195\165n</term>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\">i</term>\n    <term name=\"in press\">i tryck</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">intervju</term>\n    <term name=\"letter\">brev</term>\n    <term name=\"no date\">inget datum</term>\n    <term name=\"no date\" form=\"short\">nd</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">presenterad vid</term>\n    <term name=\"reference\">\n      <single>referens</single>\n      <multiple>referenser</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">h\195\164mtad</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">e. Kr.</term>\n    <term name=\"bc\">f. Kr.</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\157</term>\n    <term name=\"close-quote\">\226\128\157</term>\n    <term name=\"open-inner-quote\">\226\128\153</term>\n    <term name=\"close-inner-quote\">\226\128\153</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">e</term>\n    <term name=\"ordinal-01\">a</term>\n    <term name=\"ordinal-02\">a</term>\n    <term name=\"ordinal-11\">e</term>\n    <term name=\"ordinal-12\">e</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">f\195\182rsta</term>\n    <term name=\"long-ordinal-02\">andra</term>\n    <term name=\"long-ordinal-03\">tredje</term>\n    <term name=\"long-ordinal-04\">fj\195\164rde</term>\n    <term name=\"long-ordinal-05\">femte</term>\n    <term name=\"long-ordinal-06\">sj\195\164tte</term>\n    <term name=\"long-ordinal-07\">sjunde</term>\n    <term name=\"long-ordinal-08\">\195\165ttonde</term>\n    <term name=\"long-ordinal-09\">nionde</term>\n    <term name=\"long-ordinal-10\">tionde</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>bok</single>\n      <multiple>b\195\182cker</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>kapitel</single>\n      <multiple>kapitel</multiple>\n    </term>\n    <term name=\"column\">\n      <single>kolumn</single>\n      <multiple>kolumner</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>figur</single>\n      <multiple>figurer</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folio</single>\n      <multiple>folios</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>nummer</single>\n      <multiple>nummer</multiple>\n    </term>\n    <term name=\"line\">\n      <single>rad</single>\n      <multiple>rader</multiple>\n    </term>\n    <term name=\"note\">\n      <single>not</single>\n      <multiple>noter</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>sida</single>\n      <multiple>sidor</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>stycke</single>\n      <multiple>stycken</multiple>\n    </term>\n    <term name=\"part\">\n      <single>del</single>\n      <multiple>delar</multiple>\n    </term>\n    <term name=\"section\">\n      <single>avsnitt</single>\n      <multiple>avsnitt</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>vers</single>\n      <multiple>verser</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>volym</single>\n      <multiple>volumer</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">bok</term>\n    <term name=\"chapter\" form=\"short\">kap</term>\n    <term name=\"column\" form=\"short\">kol</term>\n    <term name=\"figure\" form=\"short\">fig</term>\n    <term name=\"folio\" form=\"short\">f</term>\n    <term name=\"issue\" form=\"short\">num</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op</term>\n    <term name=\"page\" form=\"short\">\n      <single>s</single>\n      <multiple>ss</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">st</term>\n    <term name=\"part\" form=\"short\">del</term>\n    <term name=\"section\" form=\"short\">avs</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>vers</single>\n      <multiple>verser</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>vol</single>\n      <multiple>vols</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>redakt\195\182r</single>\n      <multiple>redakt\195\182rer</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrat\195\182r</single>\n      <multiple>illustrat\195\182rer</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>\195\182vers\195\164ttare</single>\n      <multiple>\195\182vers\195\164ttare</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>redakt\195\182r &amp; \195\182vers\195\164ttare</single>\n      <multiple>redakt\195\182rer &amp; \195\182vers\195\164ttare</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>red</single>\n      <multiple>reds</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ed.</single>\n      <multiple>eds.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>\195\182vers</single>\n      <multiple>\195\182vers</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ed. &amp; tran.</single>\n      <multiple>eds. &amp; trans.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">redigerad av</term>\n    <term name=\"editorial-director\" form=\"verb\">edited by</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">intervju av</term>\n    <term name=\"recipient\" form=\"verb\">till</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">\195\182versatt av</term>\n    <term name=\"editortranslator\" form=\"verb\">edited &amp; translated by</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">by</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">red</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">\195\182vers</term>\n    <term name=\"editortranslator\" form=\"verb-short\">ed. &amp; trans. by</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">Januari</term>\n    <term name=\"month-02\">Februari</term>\n    <term name=\"month-03\">Mars</term>\n    <term name=\"month-04\">April</term>\n    <term name=\"month-05\">Maj</term>\n    <term name=\"month-06\">Juni</term>\n    <term name=\"month-07\">Juli</term>\n    <term name=\"month-08\">Augusti</term>\n    <term name=\"month-09\">September</term>\n    <term name=\"month-10\">Oktober</term>\n    <term name=\"month-11\">November</term>\n    <term name=\"month-12\">December</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">Jan</term>\n    <term name=\"month-02\" form=\"short\">Feb</term>\n    <term name=\"month-03\" form=\"short\">Mar</term>\n    <term name=\"month-04\" form=\"short\">Apr</term>\n    <term name=\"month-05\" form=\"short\">Maj</term>\n    <term name=\"month-06\" form=\"short\">Jun</term>\n    <term name=\"month-07\" form=\"short\">Jul</term>\n    <term name=\"month-08\" form=\"short\">Aug</term>\n    <term name=\"month-09\" form=\"short\">Sep</term>\n    <term name=\"month-10\" form=\"short\">Okt</term>\n    <term name=\"month-11\" form=\"short\">Nov</term>\n    <term name=\"month-12\" form=\"short\">Dec</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">V\195\165r</term>\n    <term name=\"season-02\">Sommar</term>\n    <term name=\"season-03\">H\195\182st</term>\n    <term name=\"season-04\">Vinter</term>\n  </terms>\n</locale>\n"),("locales-th-TH.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"th-TH\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\" \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">\224\184\170\224\184\183\224\184\154\224\184\132\224\185\137\224\184\153</term>\n    <term name=\"and\">\224\185\129\224\184\165\224\184\176</term>\n    <term name=\"and others\">\224\185\129\224\184\165\224\184\176\224\184\132\224\184\147\224\184\176</term>\n    <term name=\"anonymous\">\224\184\153\224\184\180\224\184\163\224\184\153\224\184\178\224\184\161</term>\n    <term name=\"anonymous\" form=\"short\">\224\184\153\224\184\180\224\184\163\224\184\153\224\184\178\224\184\161</term>\n    <term name=\"at\">\224\184\151\224\184\181\224\185\136</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">\224\185\130\224\184\148\224\184\162</term>\n    <term name=\"circa\">\224\185\130\224\184\148\224\184\162\224\184\155\224\184\163\224\184\176\224\184\161\224\184\178\224\184\147</term>\n    <term name=\"circa\" form=\"short\">\224\184\155\224\184\163\224\184\176\224\184\161\224\184\178\224\184\147</term>\n    <term name=\"cited\">\224\184\173\224\185\137\224\184\178\224\184\135\224\184\150\224\184\182\224\184\135</term>\n    <term name=\"edition\">\n      <single>\224\184\158\224\184\180\224\184\161\224\184\158\224\185\140\224\184\132\224\184\163\224\184\177\224\185\137\224\184\135\224\184\151\224\184\181\224\185\136</single>\n      <multiple>\224\184\158\224\184\180\224\184\161\224\184\158\224\185\140\224\184\132\224\184\163\224\184\177\224\185\137\224\184\135\224\184\151\224\184\181\224\185\136</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">\224\184\158\224\184\180\224\184\161\224\184\158\224\185\140\224\184\132\224\184\163\224\184\177\224\185\137\224\184\135\224\184\151\224\184\181\224\185\136</term>\n    <term name=\"et-al\">\224\185\129\224\184\165\224\184\176\224\184\132\224\184\147\224\184\176</term>\n    <term name=\"forthcoming\">\224\185\128\224\184\149\224\185\135\224\184\161\224\185\131\224\184\136\224\185\131\224\184\171\224\185\137\224\184\130\224\185\137\224\184\173\224\184\161\224\184\185\224\184\165</term>\n    <term name=\"from\">\224\184\136\224\184\178\224\184\129</term>\n    <term name=\"ibid\"> \224\185\131\224\184\153\224\184\151\224\184\181\224\185\136\224\185\128\224\184\148\224\184\181\224\184\162\224\184\167\224\184\129\224\184\177\224\184\153</term>\n    <term name=\"in\">\224\185\131\224\184\153</term>\n    <term name=\"in press\">\224\184\129\224\184\179\224\184\165\224\184\177\224\184\135\224\184\163\224\184\173\224\184\149\224\184\181\224\184\158\224\184\180\224\184\161\224\184\158\224\185\140</term>\n    <term name=\"internet\">\224\184\173\224\184\180\224\184\153\224\185\128\224\184\151\224\184\173\224\184\163\224\185\140\224\185\128\224\184\153\224\185\135\224\184\149</term>\n    <term name=\"interview\">\224\184\129\224\184\178\224\184\163\224\184\170\224\184\177\224\184\161\224\184\160\224\184\178\224\184\169\224\184\147\224\185\140</term>\n    <term name=\"letter\">\224\184\136\224\184\148\224\184\171\224\184\161\224\184\178\224\184\162</term>\n    <term name=\"no date\">\224\185\132\224\184\161\224\185\136\224\184\155\224\184\163\224\184\178\224\184\129\224\184\143\224\184\155\224\184\181\224\184\151\224\184\181\224\185\136\224\184\158\224\184\180\224\184\161\224\184\158\224\185\140</term>\n    <term name=\"no date\" form=\"short\">\224\184\161.\224\184\155.\224\184\155.</term>\n    <term name=\"online\">\224\184\173\224\184\173\224\184\153\224\185\132\224\184\165\224\184\153\224\185\140</term>\n    <term name=\"presented at\">\224\184\153\224\184\179\224\185\128\224\184\170\224\184\153\224\184\173\224\184\151\224\184\181\224\185\136</term>\n    <term name=\"reference\">\n      <single>\224\185\128\224\184\173\224\184\129\224\184\170\224\184\178\224\184\163\224\184\173\224\185\137\224\184\178\224\184\135\224\184\173\224\184\180\224\184\135</single>\n      <multiple>\224\185\128\224\184\173\224\184\129\224\184\170\224\184\178\224\184\163\224\184\173\224\185\137\224\184\178\224\184\135\224\184\173\224\184\180\224\184\135</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>\224\184\173\224\185\137\224\184\178\224\184\135\224\184\173\224\184\180\224\184\135</single>\n      <multiple>\224\184\173\224\185\137\224\184\178\224\184\135\224\184\173\224\184\180\224\184\135</multiple>\n    </term>\n    <term name=\"retrieved\">\224\184\170\224\184\183\224\184\154\224\184\132\224\185\137\224\184\153</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">\224\184\132.\224\184\168.</term>\n    <term name=\"bc\">\224\184\158.\224\184\168.</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\156</term>\n    <term name=\"close-quote\">\226\128\157</term>\n    <term name=\"open-inner-quote\">\226\128\152</term>\n    <term name=\"close-inner-quote\">\226\128\153</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\"/>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">\224\184\171\224\184\153\224\184\182\224\185\136\224\184\135</term>\n    <term name=\"long-ordinal-02\">\224\184\170\224\184\173\224\184\135</term>\n    <term name=\"long-ordinal-03\">\224\184\170\224\184\178\224\184\161</term>\n    <term name=\"long-ordinal-04\">\224\184\170\224\184\181\224\185\136</term>\n    <term name=\"long-ordinal-05\">\224\184\171\224\185\137\224\184\178</term>\n    <term name=\"long-ordinal-06\">\224\184\171\224\184\129</term>\n    <term name=\"long-ordinal-07\">\224\185\128\224\184\136\224\185\135\224\184\148</term>\n    <term name=\"long-ordinal-08\">\224\185\129\224\184\155\224\184\148</term>\n    <term name=\"long-ordinal-09\">\224\185\128\224\184\129\224\185\137\224\184\178</term>\n    <term name=\"long-ordinal-10\">\224\184\170\224\184\180\224\184\154</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>\224\184\171\224\184\153\224\184\177\224\184\135\224\184\170\224\184\183\224\184\173</single>\n      <multiple>\224\184\171\224\184\153\224\184\177\224\184\135\224\184\170\224\184\183\224\184\173</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>\224\184\154\224\184\151\224\184\151\224\184\181\224\185\136</single>\n      <multiple>\224\184\154\224\184\151\224\184\151\224\184\181\224\185\136</multiple>\n    </term>\n    <term name=\"column\">\n      <single>\224\184\170\224\184\148\224\184\161\224\184\160\224\185\140</single>\n      <multiple>\224\184\170\224\184\148\224\184\161\224\184\160\224\185\140</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>\224\184\163\224\184\185\224\184\155\224\184\160\224\184\178\224\184\158</single>\n      <multiple>\224\184\163\224\184\185\224\184\155\224\184\160\224\184\178\224\184\158</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>\224\184\171\224\184\153\224\185\137\224\184\178</single>\n      <multiple>\224\184\171\224\184\153\224\185\137\224\184\178</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>\224\184\137\224\184\154\224\184\177\224\184\154\224\184\151\224\184\181\224\185\136</single>\n      <multiple>\224\184\137\224\184\154\224\184\177\224\184\154\224\184\151\224\184\181\224\185\136</multiple>\n    </term>\n    <term name=\"line\">\n      <single>\224\184\154\224\184\163\224\184\163\224\184\151\224\184\177\224\184\148\224\184\151\224\184\181\224\185\136</single>\n      <multiple>\224\184\154\224\184\163\224\184\163\224\184\151\224\184\177\224\184\148\224\184\151\224\184\181\224\185\136</multiple>\n    </term>\n    <term name=\"note\">\n      <single>\224\184\154\224\184\177\224\184\153\224\184\151\224\184\182\224\184\129</single>\n      <multiple>\224\184\154\224\184\177\224\184\153\224\184\151\224\184\182\224\184\129</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>\224\184\154\224\184\151\224\184\155\224\184\163\224\184\176\224\184\158\224\184\177\224\184\153\224\184\152\224\185\140</single>\n      <multiple>\224\184\154\224\184\151\224\184\155\224\184\163\224\184\176\224\184\158\224\184\177\224\184\153\224\184\152\224\185\140</multiple>\n    </term>\n    <term name=\"page\">\n      <single>\224\184\171\224\184\153\224\185\137\224\184\178</single>\n      <multiple>\224\184\171\224\184\153\224\185\137\224\184\178</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>\224\184\162\224\185\136\224\184\173\224\184\171\224\184\153\224\185\137\224\184\178</single>\n      <multiple>\224\184\162\224\185\136\224\184\173\224\184\171\224\184\153\224\185\137\224\184\178</multiple>\n    </term>\n    <term name=\"part\">\n      <single>\224\184\170\224\185\136\224\184\167\224\184\153\224\184\162\224\185\136\224\184\173\224\184\162</single>\n      <multiple>\224\184\170\224\185\136\224\184\167\224\184\153\224\184\162\224\185\136\224\184\173\224\184\162</multiple>\n    </term>\n    <term name=\"section\">\n      <single>\224\184\171\224\184\161\224\184\167\224\184\148</single>\n      <multiple>\224\184\171\224\184\161\224\184\167\224\184\148</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>\224\185\131\224\184\149\224\185\137\224\184\132\224\184\179</single>\n      <multiple>\224\185\131\224\184\149\224\185\137\224\184\132\224\184\179</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>\224\184\163\224\185\137\224\184\173\224\184\162\224\184\129\224\184\163\224\184\173\224\184\135</single>\n      <multiple>\224\184\163\224\185\137\224\184\173\224\184\162\224\184\129\224\184\163\224\184\173\224\184\135</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>\224\184\155\224\184\181\224\184\151\224\184\181\224\185\136</single>\n      <multiple>\224\184\155\224\184\181\224\184\151\224\184\181\224\185\136</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">\224\184\171\224\184\153\224\184\177\224\184\135\224\184\170\224\184\183\224\184\173</term>\n    <term name=\"chapter\" form=\"short\">\224\184\154\224\184\151\224\184\151\224\184\181\224\185\136</term>\n    <term name=\"column\" form=\"short\">\224\184\170\224\184\148\224\184\161\224\184\160\224\185\140</term>\n    <term name=\"figure\" form=\"short\">\224\184\163\224\184\185\224\184\155\224\184\160\224\184\178\224\184\158</term>\n    <term name=\"folio\" form=\"short\">\224\184\171\224\184\153\224\185\137\224\184\178</term>\n    <term name=\"issue\" form=\"short\">\224\184\137\224\184\154\224\184\177\224\184\154\224\184\151\224\184\181\224\185\136</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">\224\184\154\224\184\151\224\184\155\224\184\163\224\184\176\224\184\158\224\184\177\224\184\153\224\184\152\224\185\140</term>\n    <term name=\"page\" form=\"short\">\n      <single>\224\184\153.</single>\n      <multiple>\224\184\153.</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">\224\184\162\224\185\136\224\184\173\224\184\171\224\184\153\224\185\137\224\184\178</term>\n    <term name=\"part\" form=\"short\">\224\184\170\224\185\136\224\184\167\224\184\153\224\184\162\224\185\136\224\184\173\224\184\162</term>\n    <term name=\"section\" form=\"short\">\224\184\171\224\184\161\224\184\167\224\184\148</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>\224\185\131\224\184\149\224\185\137\224\184\132\224\184\179</single>\n      <multiple>\224\185\131\224\184\149\224\185\137\224\184\132\224\184\179</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>\224\184\163\224\185\137\224\184\173\224\184\162\224\184\129\224\184\163\224\184\173\224\184\135</single>\n      <multiple>\224\184\163\224\185\137\224\184\173\224\184\162\224\184\129\224\184\163\224\184\173\224\184\135</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>\224\184\155\224\184\181</single>\n      <multiple>\224\184\155\224\184\181</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>\224\184\154\224\184\163\224\184\163\224\184\147\224\184\178\224\184\152\224\184\180\224\184\129\224\184\178\224\184\163</single>\n      <multiple>\224\184\154\224\184\163\224\184\163\224\184\147\224\184\178\224\184\152\224\184\180\224\184\129\224\184\178\224\184\163</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>\224\184\156\224\184\185\224\185\137\224\184\173\224\184\179\224\184\153\224\184\167\224\184\162\224\184\129\224\184\178\224\184\163\224\184\154\224\184\151\224\184\154\224\184\163\224\184\163\224\184\147\224\184\178\224\184\152\224\184\180\224\184\129\224\184\178\224\184\163</single>\n      <multiple>\224\184\156\224\184\185\224\185\137\224\184\173\224\184\179\224\184\153\224\184\167\224\184\162\224\184\129\224\184\178\224\184\163\224\184\154\224\184\151\224\184\154\224\184\163\224\184\163\224\184\147\224\184\178\224\184\152\224\184\180\224\184\129\224\184\178\224\184\163</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>\224\184\156\224\184\185\224\185\137\224\185\129\224\184\155\224\184\165</single>\n      <multiple>\224\184\156\224\184\185\224\185\137\224\185\129\224\184\155\224\184\165</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>\224\184\154\224\184\163\224\184\163\224\184\147\224\184\178\224\184\152\224\184\180\224\184\129\224\184\178\224\184\163\224\185\129\224\184\165\224\184\176\224\184\156\224\184\185\224\185\137\224\185\129\224\184\155\224\184\165</single>\n      <multiple>\224\184\154\224\184\163\224\184\163\224\184\147\224\184\178\224\184\152\224\184\180\224\184\129\224\184\178\224\184\163\224\185\129\224\184\165\224\184\176\224\184\156\224\184\185\224\185\137\224\185\129\224\184\155\224\184\165</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>\224\184\154.\224\184\129.</single>\n      <multiple>\224\184\154.\224\184\129.</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>\224\184\156\224\184\173.\224\184\154\224\184\151\224\184\154\224\184\163\224\184\163\224\184\147\224\184\178\224\184\152\224\184\180\224\184\129\224\184\178\224\184\163</single>\n      <multiple>\224\184\156\224\184\173.\224\184\154\224\184\151\224\184\154\224\184\163\224\184\163\224\184\147\224\184\178\224\184\152\224\184\180\224\184\129\224\184\178\224\184\163</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>\224\184\156\224\184\185\224\185\137\224\185\129\224\184\155\224\184\165</single>\n      <multiple>\224\184\156\224\184\185\224\185\137\224\185\129\224\184\155\224\184\165</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>\224\184\154.\224\184\129.</single>\n      <multiple>\224\184\154.\224\184\129.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">\224\185\128\224\184\163\224\184\181\224\184\162\224\184\154\224\185\128\224\184\163\224\184\181\224\184\162\224\184\135\224\185\130\224\184\148\224\184\162</term>\n    <term name=\"editorial-director\" form=\"verb\">\224\185\128\224\184\163\224\184\181\224\184\162\224\184\154\224\185\128\224\184\163\224\184\181\224\184\162\224\184\135\224\185\130\224\184\148\224\184\162</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">\224\184\170\224\184\177\224\184\161\224\184\160\224\184\178\224\184\169\224\184\147\224\185\140\224\185\130\224\184\148\224\184\162</term>\n    <term name=\"recipient\" form=\"verb\">\224\184\150\224\184\182\224\184\135</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">\224\185\129\224\184\155\224\184\165\224\185\130\224\184\148\224\184\162</term>\n    <term name=\"editortranslator\" form=\"verb\">\224\185\129\224\184\155\224\184\165\224\185\129\224\184\165\224\184\176\224\185\128\224\184\163\224\184\181\224\184\162\224\184\154\224\185\128\224\184\163\224\184\181\224\184\162\224\184\135\224\185\130\224\184\148\224\184\162</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">\224\185\130\224\184\148\224\184\162</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">\224\185\130\224\184\148\224\184\162</term>\n    <term name=\"editorial-director\" form=\"verb-short\">\224\185\130\224\184\148\224\184\162</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">\224\185\129\224\184\155\224\184\165</term>\n    <term name=\"editortranslator\" form=\"verb-short\">\224\185\129\224\184\155\224\184\165\224\185\129\224\184\165\224\184\176\224\185\128\224\184\163\224\184\181\224\184\162\224\184\154\224\185\128\224\184\163\224\184\181\224\184\162\224\184\135\224\185\130\224\184\148\224\184\162</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">\224\184\161\224\184\129\224\184\163\224\184\178\224\184\132\224\184\161</term>\n    <term name=\"month-02\">\224\184\129\224\184\184\224\184\161\224\184\160\224\184\178\224\184\158\224\184\177\224\184\153\224\184\152\224\185\140</term>\n    <term name=\"month-03\">\224\184\161\224\184\181\224\184\153\224\184\178\224\184\132\224\184\161</term>\n    <term name=\"month-04\">\224\185\128\224\184\161\224\184\169\224\184\178\224\184\162\224\184\153</term>\n    <term name=\"month-05\">\224\184\158\224\184\164\224\184\169\224\184\160\224\184\178\224\184\132\224\184\161</term>\n    <term name=\"month-06\">\224\184\161\224\184\180\224\184\150\224\184\184\224\184\153\224\184\178\224\184\162\224\184\153</term>\n    <term name=\"month-07\">\224\184\129\224\184\163\224\184\129\224\184\142\224\184\178\224\184\132\224\184\161</term>\n    <term name=\"month-08\">\224\184\170\224\184\180\224\184\135\224\184\171\224\184\178\224\184\132\224\184\161</term>\n    <term name=\"month-09\">\224\184\129\224\184\177\224\184\153\224\184\162\224\184\178\224\184\162\224\184\153</term>\n    <term name=\"month-10\">\224\184\149\224\184\184\224\184\165\224\184\178\224\184\132\224\184\178\224\184\161</term>\n    <term name=\"month-11\">\224\184\158\224\184\164\224\184\168\224\184\136\224\184\180\224\184\129\224\184\178\224\184\162\224\184\153</term>\n    <term name=\"month-12\">\224\184\152\224\184\177\224\184\153\224\184\167\224\184\178\224\184\132\224\184\161</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">\224\184\161.\224\184\132.</term>\n    <term name=\"month-02\" form=\"short\">\224\184\129.\224\184\158.</term>\n    <term name=\"month-03\" form=\"short\">\224\184\161\224\184\181.\224\184\132.</term>\n    <term name=\"month-04\" form=\"short\">\224\185\128\224\184\161.\224\184\162.</term>\n    <term name=\"month-05\" form=\"short\">\224\184\158.\224\184\132.</term>\n    <term name=\"month-06\" form=\"short\">\224\184\161\224\184\180.\224\184\162.</term>\n    <term name=\"month-07\" form=\"short\">\224\184\129.\224\184\132.</term>\n    <term name=\"month-08\" form=\"short\">\224\184\170.\224\184\132.</term>\n    <term name=\"month-09\" form=\"short\">\224\184\129.\224\184\162.</term>\n    <term name=\"month-10\" form=\"short\">\224\184\149.\224\184\132.</term>\n    <term name=\"month-11\" form=\"short\">\224\184\158.\224\184\162.</term>\n    <term name=\"month-12\" form=\"short\">\224\184\152.\224\184\132.</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">\224\184\164\224\184\148\224\184\185\224\185\131\224\184\154\224\185\132\224\184\161\224\185\137\224\184\156\224\184\165\224\184\180</term>\n    <term name=\"season-02\">\224\184\164\224\184\148\224\184\185\224\184\163\224\185\137\224\184\173\224\184\153</term>\n    <term name=\"season-03\">\224\184\164\224\184\148\224\184\185\224\185\131\224\184\154\224\185\132\224\184\161\224\185\137\224\184\163\224\185\136\224\184\167\224\184\135</term>\n    <term name=\"season-04\">\224\184\164\224\184\148\224\184\185\224\184\171\224\184\153\224\184\178\224\184\167</term>\n  </terms>\n</locale>\n"),("locales-tr-TR.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"tr-TR\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\" \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">eri\197\159ildi</term>\n    <term name=\"and\">ve</term>\n    <term name=\"and others\">ve di\196\159erleri</term>\n    <term name=\"anonymous\">anonim</term>\n    <term name=\"anonymous\" form=\"short\">anonim</term>\n    <term name=\"at\">de</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">by</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">kaynak</term>\n    <term name=\"edition\">\n      <single>bask\196\177</single>\n      <multiple>bask\196\177</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">ed</term>\n    <term name=\"et-al\">ve di\196\159erleri</term>\n    <term name=\"forthcoming\">gelecek</term>\n    <term name=\"from\">adresinden eri\197\159ildi</term>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\">i\195\167inde</term>\n    <term name=\"in press\">bas\196\177mda</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">ki\197\159isel ileti\197\159im</term>\n    <term name=\"letter\">mektup</term>\n    <term name=\"no date\">tarih yok</term>\n    <term name=\"no date\" form=\"short\">y.y.</term>\n    <term name=\"online\">\195\167evrimi\195\167i</term>\n    <term name=\"presented at\">sunulan</term>\n    <term name=\"reference\">\n      <single>reference</single>\n      <multiple>references</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">tarihinde</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">M.S</term>\n    <term name=\"bc\">M.\195\150.</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\194\171</term>\n    <term name=\"close-quote\">\194\187</term>\n    <term name=\"open-inner-quote\">\226\128\185</term>\n    <term name=\"close-inner-quote\">\226\128\186</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">.</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">birinci</term>\n    <term name=\"long-ordinal-02\">ikinci</term>\n    <term name=\"long-ordinal-03\">\195\188\195\167\195\188nc\195\188</term>\n    <term name=\"long-ordinal-04\">d\195\182rd\195\188nc\195\188</term>\n    <term name=\"long-ordinal-05\">be\197\159inci</term>\n    <term name=\"long-ordinal-06\">alt\196\177nc\196\177</term>\n    <term name=\"long-ordinal-07\">yedinci</term>\n    <term name=\"long-ordinal-08\">sekizinci</term>\n    <term name=\"long-ordinal-09\">dokuzuncu</term>\n    <term name=\"long-ordinal-10\">onuncu</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>kitap</single>\n      <multiple>kitaplar</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>b\195\182l\195\188m</single>\n      <multiple>b\195\182l\195\188mler</multiple>\n    </term>\n    <term name=\"column\">\n      <single>s\195\188tun</single>\n      <multiple>s\195\188tunlar</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>\197\159ekil</single>\n      <multiple>\197\159ekiller</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folyo</single>\n      <multiple>folyo</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>say\196\177</single>\n      <multiple>say\196\177lar</multiple>\n    </term>\n    <term name=\"line\">\n      <single>sat\196\177r</single>\n      <multiple>sat\196\177rlar</multiple>\n    </term>\n    <term name=\"note\">\n      <single>not</single>\n      <multiple>notlar</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>sayfa</single>\n      <multiple>sayfalar</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>paragraf</single>\n      <multiple>paragraflar</multiple>\n    </term>\n    <term name=\"part\">\n      <single>k\196\177s\196\177m</single>\n      <multiple>k\196\177s\196\177mlar</multiple>\n    </term>\n    <term name=\"section\">\n      <single>b\195\182l\195\188m</single>\n      <multiple>b\195\182l\195\188mler</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>dize</single>\n      <multiple>dizeler</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>cilt</single>\n      <multiple>ciltler</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">kit</term>\n    <term name=\"chapter\" form=\"short\">b\195\182l</term>\n    <term name=\"column\" form=\"short\">s\195\188t</term>\n    <term name=\"figure\" form=\"short\">\197\159ek</term>\n    <term name=\"folio\" form=\"short\">f</term>\n    <term name=\"issue\" form=\"short\">say\196\177</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op</term>\n    <term name=\"page\" form=\"short\">\n      <single>s</single>\n      <multiple>ss</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">par</term>\n    <term name=\"part\" form=\"short\">k\196\177s</term>\n    <term name=\"section\" form=\"short\">b\195\182l</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v</single>\n      <multiple>vv</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>c</single>\n      <multiple>c</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>edit\195\182r</single>\n      <multiple>edit\195\182rler</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>edit\195\182r</single>\n      <multiple>edit\195\182r</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>\195\167eviren</single>\n      <multiple>\195\167evirenler</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>edit\195\182r &amp; \195\167eviren</single>\n      <multiple>edit\195\182rler &amp; \195\167evirenler</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>ed</single>\n      <multiple>ed</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ed.</single>\n      <multiple>ed.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>\195\167ev.</single>\n      <multiple>\195\167ev.</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ed. &amp; \195\167ev.</single>\n      <multiple>ed. &amp; \195\167ev.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">edit\195\182r</term>\n    <term name=\"editorial-director\" form=\"verb\">d\195\188zenleyen</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">R\195\182portaj yapan</term>\n    <term name=\"recipient\" form=\"verb\">to</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">\195\167eviren</term>\n    <term name=\"editortranslator\" form=\"verb\">d\195\188zenleyen &amp; \195\167eviren by</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\"/>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">ed.</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">\195\167ev.</term>\n    <term name=\"editortranslator\" form=\"verb-short\">ed. &amp; \195\167ev.</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">Ocak</term>\n    <term name=\"month-02\">\197\158ubat</term>\n    <term name=\"month-03\">Mart</term>\n    <term name=\"month-04\">Nisan</term>\n    <term name=\"month-05\">May\196\177s</term>\n    <term name=\"month-06\">Haziran</term>\n    <term name=\"month-07\">Temmuz</term>\n    <term name=\"month-08\">A\196\159ustos</term>\n    <term name=\"month-09\">Eyl\195\188l</term>\n    <term name=\"month-10\">Ekim</term>\n    <term name=\"month-11\">Kas\196\177m</term>\n    <term name=\"month-12\">Aral\196\177k</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">Oca</term>\n    <term name=\"month-02\" form=\"short\">\197\158ub</term>\n    <term name=\"month-03\" form=\"short\">Mar</term>\n    <term name=\"month-04\" form=\"short\">Nis</term>\n    <term name=\"month-05\" form=\"short\">May</term>\n    <term name=\"month-06\" form=\"short\">Haz</term>\n    <term name=\"month-07\" form=\"short\">Tem</term>\n    <term name=\"month-08\" form=\"short\">A\196\159u</term>\n    <term name=\"month-09\" form=\"short\">Eyl</term>\n    <term name=\"month-10\" form=\"short\">Eki</term>\n    <term name=\"month-11\" form=\"short\">Kas</term>\n    <term name=\"month-12\" form=\"short\">Ara</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">Bahar</term>\n    <term name=\"season-02\">Yaz</term>\n    <term name=\"season-03\">Sonbahar</term>\n    <term name=\"season-04\">K\196\177\197\159</term>\n  </terms>\n</locale>\n"),("locales-uk-UA.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"uk-UA\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\", \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">accessed</term>\n    <term name=\"and\">\209\150</term>\n    <term name=\"and others\">\209\130\208\176 \209\150\208\189\209\136\209\150</term>\n    <term name=\"anonymous\">\208\176\208\189\208\190\208\189\209\150\208\188\208\189\208\184\208\185</term>\n    <term name=\"anonymous\" form=\"short\">\208\176\208\189\208\190\208\189.</term>\n    <term name=\"at\">\208\189\208\176</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">by</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">cited</term>\n    <term name=\"edition\">\n      <single>edition</single>\n      <multiple>editions</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">ed</term>\n    <term name=\"et-al\">et al.</term>\n    <term name=\"forthcoming\">forthcoming</term>\n    <term name=\"from\">\209\150\208\183</term>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\">\208\178</term>\n    <term name=\"in press\">\209\131 \208\191\209\128\208\181\209\129\209\150</term>\n    <term name=\"internet\">\209\150\208\189\209\130\208\181\209\128\208\189\208\181\209\130</term>\n    <term name=\"interview\">\209\150\208\189\209\130\208\181\209\128\208\178\209\142</term>\n    <term name=\"letter\">\208\187\208\184\209\129\209\130</term>\n    <term name=\"no date\">no date</term>\n    <term name=\"no date\" form=\"short\">n.d.</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">presented at the</term>\n    <term name=\"reference\">\n      <single>reference</single>\n      <multiple>references</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">retrieved</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">AD</term>\n    <term name=\"bc\">BC</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\194\171</term>\n    <term name=\"close-quote\">\194\187</term>\n    <term name=\"open-inner-quote\">\226\128\152</term>\n    <term name=\"close-inner-quote\">\226\128\153</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">th</term>\n    <term name=\"ordinal-01\">st</term>\n    <term name=\"ordinal-02\">nd</term>\n    <term name=\"ordinal-03\">rd</term>\n    <term name=\"ordinal-11\">th</term>\n    <term name=\"ordinal-12\">th</term>\n    <term name=\"ordinal-13\">th</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">first</term>\n    <term name=\"long-ordinal-02\">second</term>\n    <term name=\"long-ordinal-03\">third</term>\n    <term name=\"long-ordinal-04\">fourth</term>\n    <term name=\"long-ordinal-05\">fifth</term>\n    <term name=\"long-ordinal-06\">sixth</term>\n    <term name=\"long-ordinal-07\">seventh</term>\n    <term name=\"long-ordinal-08\">eighth</term>\n    <term name=\"long-ordinal-09\">ninth</term>\n    <term name=\"long-ordinal-10\">tenth</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>book</single>\n      <multiple>books</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>chapter</single>\n      <multiple>chapters</multiple>\n    </term>\n    <term name=\"column\">\n      <single>column</single>\n      <multiple>columns</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>figure</single>\n      <multiple>figures</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folio</single>\n      <multiple>folios</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>number</single>\n      <multiple>numbers</multiple>\n    </term>\n    <term name=\"line\">\n      <single>line</single>\n      <multiple>lines</multiple>\n    </term>\n    <term name=\"note\">\n      <single>note</single>\n      <multiple>notes</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>page</single>\n      <multiple>pages</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>paragraph</single>\n      <multiple>paragraph</multiple>\n    </term>\n    <term name=\"part\">\n      <single>part</single>\n      <multiple>parts</multiple>\n    </term>\n    <term name=\"section\">\n      <single>section</single>\n      <multiple>sections</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>verse</single>\n      <multiple>verses</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>volume</single>\n      <multiple>volumes</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">bk</term>\n    <term name=\"chapter\" form=\"short\">chap</term>\n    <term name=\"column\" form=\"short\">col</term>\n    <term name=\"figure\" form=\"short\">fig</term>\n    <term name=\"folio\" form=\"short\">f</term>\n    <term name=\"issue\" form=\"short\">no</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op</term>\n    <term name=\"page\" form=\"short\">\n      <single>p</single>\n      <multiple>pp</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">para</term>\n    <term name=\"part\" form=\"short\">pt</term>\n    <term name=\"section\" form=\"short\">sec</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v</single>\n      <multiple>vv</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>vol</single>\n      <multiple>vols</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>translator</single>\n      <multiple>translators</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>editor &amp; translator</single>\n      <multiple>editors &amp; translators</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>ed</single>\n      <multiple>eds</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ed.</single>\n      <multiple>eds.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>tran</single>\n      <multiple>trans</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ed. &amp; tran.</single>\n      <multiple>eds. &amp; trans.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">edited by</term>\n    <term name=\"editorial-director\" form=\"verb\">edited by</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">interview by</term>\n    <term name=\"recipient\" form=\"verb\">to</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">translated by</term>\n    <term name=\"editortranslator\" form=\"verb\">edited &amp; translated by</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">by</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">ed</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">trans</term>\n    <term name=\"editortranslator\" form=\"verb-short\">ed. &amp; trans. by</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">\208\161\209\150\209\135\208\181\208\189\209\140</term>\n    <term name=\"month-02\">\208\155\209\142\209\130\208\184\208\185</term>\n    <term name=\"month-03\">\208\145\208\181\209\128\208\181\208\183\208\181\208\189\209\140</term>\n    <term name=\"month-04\">\208\154\208\178\209\150\209\130\208\181\208\189\209\140</term>\n    <term name=\"month-05\">\208\162\209\128\208\176\208\178\208\181\208\189\209\140</term>\n    <term name=\"month-06\">\208\167\208\181\209\128\208\178\208\181\208\189\209\140</term>\n    <term name=\"month-07\">\208\155\208\184\208\191\208\181\208\189\209\140</term>\n    <term name=\"month-08\">\208\161\208\181\209\128\208\191\208\181\208\189\209\140</term>\n    <term name=\"month-09\">\208\146\208\181\209\128\208\181\209\129\208\181\208\189\209\140</term>\n    <term name=\"month-10\">\208\150\208\190\208\178\209\130\208\181\208\189\209\140</term>\n    <term name=\"month-11\">\208\155\208\184\209\129\209\130\208\190\208\191\208\176\208\180</term>\n    <term name=\"month-12\">\208\147\209\128\209\131\208\180\208\181\208\189\209\140</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">\208\161\209\150\209\135</term>\n    <term name=\"month-02\" form=\"short\">\208\155\209\142\209\130</term>\n    <term name=\"month-03\" form=\"short\">\208\145\208\181\209\128</term>\n    <term name=\"month-04\" form=\"short\">\208\154\208\178\209\150\209\130</term>\n    <term name=\"month-05\" form=\"short\">\208\162\209\128\208\176\208\178</term>\n    <term name=\"month-06\" form=\"short\">\208\167\208\181\209\128</term>\n    <term name=\"month-07\" form=\"short\">\208\155\208\184\208\191</term>\n    <term name=\"month-08\" form=\"short\">\208\161\208\181\209\128</term>\n    <term name=\"month-09\" form=\"short\">\208\146\208\181\209\128</term>\n    <term name=\"month-10\" form=\"short\">\208\150\208\190\208\178</term>\n    <term name=\"month-11\" form=\"short\">\208\155\208\184\209\129</term>\n    <term name=\"month-12\" form=\"short\">\208\147\209\128\209\131\208\180</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">Spring</term>\n    <term name=\"season-02\">Summer</term>\n    <term name=\"season-03\">Autumn</term>\n    <term name=\"season-04\">Winter</term>\n  </terms>\n</locale>\n"),("locales-vi-VN.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"vi-VN\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"day\" suffix=\" \"/>\n    <date-part name=\"month\" suffix=\" \"/>\n    <date-part name=\"year\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" suffix=\"/\"/>\n    <date-part name=\"year\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">truy c\225\186\173p</term>\n    <term name=\"and\">v\195\160</term>\n    <term name=\"and others\">and others</term>\n    <term name=\"anonymous\">anonymous</term>\n    <term name=\"anonymous\" form=\"short\">anon</term>\n    <term name=\"at\">at</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">by</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">cited</term>\n    <term name=\"edition\">\n      <single>edition</single>\n      <multiple>editions</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">ed</term>\n    <term name=\"et-al\">v\195\160 c.s.</term>\n    <term name=\"forthcoming\">s\225\186\175p t\225\187\155i</term>\n    <term name=\"from\">t\225\187\171</term>\n    <term name=\"ibid\">n.t.</term>\n    <term name=\"in\">trong</term>\n    <term name=\"in press\">in press</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">interview</term>\n    <term name=\"letter\">letter</term>\n    <term name=\"no date\">no date</term>\n    <term name=\"no date\" form=\"short\">kh\195\180ng ng\195\160y</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">presented at the</term>\n    <term name=\"reference\">\n      <single>reference</single>\n      <multiple>references</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">truy v\225\186\165n</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">AD</term>\n    <term name=\"bc\">BC</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\194\171</term>\n    <term name=\"close-quote\">\194\187</term>\n    <term name=\"open-inner-quote\">\226\128\185</term>\n    <term name=\"close-inner-quote\">\226\128\186</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">th</term>\n    <term name=\"ordinal-01\">st</term>\n    <term name=\"ordinal-02\">nd</term>\n    <term name=\"ordinal-03\">rd</term>\n    <term name=\"ordinal-11\">th</term>\n    <term name=\"ordinal-12\">th</term>\n    <term name=\"ordinal-13\">th</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">first</term>\n    <term name=\"long-ordinal-02\">second</term>\n    <term name=\"long-ordinal-03\">third</term>\n    <term name=\"long-ordinal-04\">fourth</term>\n    <term name=\"long-ordinal-05\">fifth</term>\n    <term name=\"long-ordinal-06\">sixth</term>\n    <term name=\"long-ordinal-07\">seventh</term>\n    <term name=\"long-ordinal-08\">eighth</term>\n    <term name=\"long-ordinal-09\">ninth</term>\n    <term name=\"long-ordinal-10\">tenth</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>book</single>\n      <multiple>books</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>chapter</single>\n      <multiple>chapters</multiple>\n    </term>\n    <term name=\"column\">\n      <single>column</single>\n      <multiple>columns</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>figure</single>\n      <multiple>figures</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folio</single>\n      <multiple>folios</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>number</single>\n      <multiple>numbers</multiple>\n    </term>\n    <term name=\"line\">\n      <single>d\195\178ng</single>\n      <multiple>d\195\178ng</multiple>\n    </term>\n    <term name=\"note\">\n      <single>note</single>\n      <multiple>notes</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>trang</single>\n      <multiple>trang</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>\196\145o\225\186\161n v\196\131n</single>\n      <multiple>\196\145o\225\186\161n v\196\131n</multiple>\n    </term>\n    <term name=\"part\">\n      <single>part</single>\n      <multiple>parts</multiple>\n    </term>\n    <term name=\"section\">\n      <single>section</single>\n      <multiple>sections</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>verse</single>\n      <multiple>verses</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>volume</single>\n      <multiple>volumes</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">bk</term>\n    <term name=\"chapter\" form=\"short\">chap</term>\n    <term name=\"column\" form=\"short\">col</term>\n    <term name=\"figure\" form=\"short\">fig</term>\n    <term name=\"folio\" form=\"short\">f</term>\n    <term name=\"issue\" form=\"short\">s\225\187\145 p.h</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op</term>\n    <term name=\"page\" form=\"short\">\n      <single>tr</single>\n      <multiple>tr</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">para</term>\n    <term name=\"part\" form=\"short\">pt</term>\n    <term name=\"section\" form=\"short\">sec</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v</single>\n      <multiple>vv</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>vol</single>\n      <multiple>vols</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>bi\195\170n t\225\186\173p vi\195\170n</single>\n      <multiple>bi\195\170n t\225\186\173p vi\195\170n</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>bi\195\170n d\225\187\139ch vi\195\170n</single>\n      <multiple>bi\195\170n d\225\187\139ch vi\195\170n</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>editor &amp; translator</single>\n      <multiple>editors &amp; translators</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>b.t.v</single>\n      <multiple>b.t.v</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ed.</single>\n      <multiple>eds.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>b.d.v</single>\n      <multiple>b.d.v</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ed. &amp; tran.</single>\n      <multiple>eds. &amp; trans.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">bi\195\170n t\225\186\173p b\225\187\159i</term>\n    <term name=\"editorial-director\" form=\"verb\">edited by</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">interview by</term>\n    <term name=\"recipient\" form=\"verb\">to</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">bi\195\170n d\225\187\139ch b\225\187\159i</term>\n    <term name=\"editortranslator\" form=\"verb\">edited &amp; translated by</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">by</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">b.t</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">b.d</term>\n    <term name=\"editortranslator\" form=\"verb-short\">ed. &amp; trans. by</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">Th\195\161ng Gi\195\170ng</term>\n    <term name=\"month-02\">Th\195\161ng Hai</term>\n    <term name=\"month-03\">Th\195\161ng Ba</term>\n    <term name=\"month-04\">Th\195\161ng T\198\176</term>\n    <term name=\"month-05\">Th\195\161ng N\196\131m</term>\n    <term name=\"month-06\">Th\195\161ng S\195\161u</term>\n    <term name=\"month-07\">Th\195\161ng B\225\186\163y</term>\n    <term name=\"month-08\">Th\195\161ng T\195\161m</term>\n    <term name=\"month-09\">Th\195\161ng Ch\195\173n</term>\n    <term name=\"month-10\">Th\195\161ng M\198\176\225\187\157i</term>\n    <term name=\"month-11\">Th\195\161ng M\198\176\225\187\157i-M\225\187\153t</term>\n    <term name=\"month-12\">Th\195\161ng Ch\225\186\161p</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">th\195\161ng 1</term>\n    <term name=\"month-02\" form=\"short\">th\195\161ng 2</term>\n    <term name=\"month-03\" form=\"short\">th\195\161ng 3</term>\n    <term name=\"month-04\" form=\"short\">th\195\161ng 4</term>\n    <term name=\"month-05\" form=\"short\">th\195\161ng 5</term>\n    <term name=\"month-06\" form=\"short\">th\195\161ng 6</term>\n    <term name=\"month-07\" form=\"short\">th\195\161ng 7</term>\n    <term name=\"month-08\" form=\"short\">th\195\161ng 8</term>\n    <term name=\"month-09\" form=\"short\">th\195\161ng 9</term>\n    <term name=\"month-10\" form=\"short\">th\195\161ng 10</term>\n    <term name=\"month-11\" form=\"short\">th\195\161ng 11</term>\n    <term name=\"month-12\" form=\"short\">th\195\161ng 12</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">Spring</term>\n    <term name=\"season-02\">Summer</term>\n    <term name=\"season-03\">Autumn</term>\n    <term name=\"season-04\">Winter</term>\n  </terms>\n</locale>\n"),("locales-zh-CN.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"zh-CN\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"year\" suffix=\"\229\185\180\"/>\n    <date-part name=\"month\" form=\"numeric\" suffix=\"\230\156\136\"/>\n    <date-part name=\"day\" suffix=\"\230\151\165\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"year\"/>\n    <date-part name=\"month\" form=\"numeric\" prefix=\"-\" range-delimiter=\"/\"/>\n    <date-part name=\"day\" prefix=\"-\" range-delimiter=\"/\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">accessed</term>\n    <term name=\"and\">and</term>\n    <term name=\"and others\">and others</term>\n    <term name=\"anonymous\">anonymous</term>\n    <term name=\"anonymous\" form=\"short\">anon</term>\n    <term name=\"at\">at</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">by</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">cited</term>\n    <term name=\"edition\">\n      <single>edition</single>\n      <multiple>editions</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">ed</term>\n    <term name=\"et-al\">et al.</term>\n    <term name=\"forthcoming\">forthcoming</term>\n    <term name=\"from\">from</term>\n    <term name=\"ibid\">ibid.</term>\n    <term name=\"in\">in</term>\n    <term name=\"in press\">in press</term>\n    <term name=\"internet\">internet</term>\n    <term name=\"interview\">interview</term>\n    <term name=\"letter\">letter</term>\n    <term name=\"no date\">no date</term>\n    <term name=\"no date\" form=\"short\">nd</term>\n    <term name=\"online\">online</term>\n    <term name=\"presented at\">presented at the</term>\n    <term name=\"reference\">\n      <single>reference</single>\n      <multiple>references</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">retrieved</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">AD</term>\n    <term name=\"bc\">BC</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\226\128\156</term>\n    <term name=\"close-quote\">\226\128\157</term>\n    <term name=\"open-inner-quote\">\226\128\152</term>\n    <term name=\"close-inner-quote\">\226\128\153</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">th</term>\n    <term name=\"ordinal-01\">st</term>\n    <term name=\"ordinal-02\">nd</term>\n    <term name=\"ordinal-03\">rd</term>\n    <term name=\"ordinal-11\">th</term>\n    <term name=\"ordinal-12\">th</term>\n    <term name=\"ordinal-13\">th</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">first</term>\n    <term name=\"long-ordinal-02\">second</term>\n    <term name=\"long-ordinal-03\">third</term>\n    <term name=\"long-ordinal-04\">fourth</term>\n    <term name=\"long-ordinal-05\">fifth</term>\n    <term name=\"long-ordinal-06\">sixth</term>\n    <term name=\"long-ordinal-07\">seventh</term>\n    <term name=\"long-ordinal-08\">eighth</term>\n    <term name=\"long-ordinal-09\">ninth</term>\n    <term name=\"long-ordinal-10\">tenth</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>book</single>\n      <multiple>books</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>chapter</single>\n      <multiple>chapters</multiple>\n    </term>\n    <term name=\"column\">\n      <single>column</single>\n      <multiple>columns</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>figure</single>\n      <multiple>figures</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>folio</single>\n      <multiple>folios</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>number</single>\n      <multiple>numbers</multiple>\n    </term>\n    <term name=\"line\">\n      <single>line</single>\n      <multiple>line</multiple>\n    </term>\n    <term name=\"note\">\n      <single>note</single>\n      <multiple>notes</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>opus</single>\n      <multiple>opera</multiple>\n    </term>\n    <term name=\"page\">\n      <single>page</single>\n      <multiple>pages</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>paragraph</single>\n      <multiple>paragraph</multiple>\n    </term>\n    <term name=\"part\">\n      <single>part</single>\n      <multiple>parts</multiple>\n    </term>\n    <term name=\"section\">\n      <single>section</single>\n      <multiple>sections</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>verse</single>\n      <multiple>verses</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>volume</single>\n      <multiple>volumes</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">bk</term>\n    <term name=\"chapter\" form=\"short\">chap</term>\n    <term name=\"column\" form=\"short\">col</term>\n    <term name=\"figure\" form=\"short\">fig</term>\n    <term name=\"folio\" form=\"short\">f</term>\n    <term name=\"issue\" form=\"short\">no</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">op</term>\n    <term name=\"page\" form=\"short\">\n      <single>p</single>\n      <multiple>pp</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">para</term>\n    <term name=\"part\" form=\"short\">pt</term>\n    <term name=\"section\" form=\"short\">sec</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>v</single>\n      <multiple>vv</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>vol</single>\n      <multiple>vols</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>translator</single>\n      <multiple>translators</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>editor &amp; translator</single>\n      <multiple>editors &amp; translators</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>ed</single>\n      <multiple>eds</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ed.</single>\n      <multiple>eds.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>tran</single>\n      <multiple>trans</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ed. &amp; tran.</single>\n      <multiple>eds. &amp; trans.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">edited by</term>\n    <term name=\"editorial-director\" form=\"verb\">edited by</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">interview by</term>\n    <term name=\"recipient\" form=\"verb\">to</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">translated by</term>\n    <term name=\"editortranslator\" form=\"verb\">edited &amp; translated by</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">by</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">ed</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">trans</term>\n    <term name=\"editortranslator\" form=\"verb-short\">ed. &amp; trans. by</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">January</term>\n    <term name=\"month-02\">February</term>\n    <term name=\"month-03\">March</term>\n    <term name=\"month-04\">April</term>\n    <term name=\"month-05\">May</term>\n    <term name=\"month-06\">June</term>\n    <term name=\"month-07\">July</term>\n    <term name=\"month-08\">August</term>\n    <term name=\"month-09\">September</term>\n    <term name=\"month-10\">October</term>\n    <term name=\"month-11\">November</term>\n    <term name=\"month-12\">December</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">Jan</term>\n    <term name=\"month-02\" form=\"short\">Feb</term>\n    <term name=\"month-03\" form=\"short\">Mar</term>\n    <term name=\"month-04\" form=\"short\">Apr</term>\n    <term name=\"month-05\" form=\"short\">May</term>\n    <term name=\"month-06\" form=\"short\">Jun</term>\n    <term name=\"month-07\" form=\"short\">Jul</term>\n    <term name=\"month-08\" form=\"short\">Aug</term>\n    <term name=\"month-09\" form=\"short\">Sep</term>\n    <term name=\"month-10\" form=\"short\">Oct</term>\n    <term name=\"month-11\" form=\"short\">Nov</term>\n    <term name=\"month-12\" form=\"short\">Dec</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">Spring</term>\n    <term name=\"season-02\">Summer</term>\n    <term name=\"season-03\">Autumn</term>\n    <term name=\"season-04\">Winter</term>\n  </terms>\n</locale>\n"),("locales-zh-TW.xml","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<locale xmlns=\"http://purl.org/net/xbiblio/csl\" version=\"1.0\" xml:lang=\"zh-TW\">\n  <info>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n    <updated>2012-07-04T23:31:02+00:00</updated>\n  </info>\n  <style-options punctuation-in-quote=\"false\"/>\n  <date form=\"text\">\n    <date-part name=\"year\" suffix=\"\229\185\180\"/>\n    <date-part name=\"month\" form=\"numeric\" suffix=\"\230\156\136\"/>\n    <date-part name=\"day\" suffix=\"\230\151\165\"/>\n  </date>\n  <date form=\"numeric\">\n    <date-part name=\"year\"/>\n    <date-part name=\"month\" form=\"numeric-leading-zeros\" prefix=\"/\"/>\n    <date-part name=\"day\" form=\"numeric-leading-zeros\" prefix=\"/\"/>\n  </date>\n  <terms>\n    <term name=\"accessed\">\232\162\171\229\143\150\231\148\168</term>\n    <term name=\"and\">\229\143\138</term>\n    <term name=\"and others\">\229\143\138\229\133\182\228\187\150</term>\n    <term name=\"anonymous\">\228\184\141\229\133\183\229\144\141\231\154\132</term>\n    <term name=\"anonymous\" form=\"short\">\231\132\161\229\144\141</term>\n    <term name=\"at\">\229\156\168</term>\n    <term name=\"available at\">available at</term>\n    <term name=\"by\">by</term>\n    <term name=\"circa\">circa</term>\n    <term name=\"circa\" form=\"short\">c.</term>\n    <term name=\"cited\">\232\162\171\229\188\149\231\148\168</term>\n    <term name=\"edition\">\n      <single>\231\137\136\230\156\172</single>\n      <multiple>\231\137\136\230\156\172</multiple>\n    </term>\n    <term name=\"edition\" form=\"short\">\231\137\136</term>\n    <term name=\"et-al\">\231\173\137\228\186\186</term>\n    <term name=\"forthcoming\">\229\176\135\228\190\134\231\154\132</term>\n    <term name=\"from\">\229\190\158</term>\n    <term name=\"ibid\">\229\144\140\228\184\138\229\135\186\232\153\149</term>\n    <term name=\"in\">\229\156\168</term>\n    <term name=\"in press\">\229\141\176\232\161\140\228\184\173</term>\n    <term name=\"internet\">\231\182\178\233\154\155\231\182\178\232\183\175</term>\n    <term name=\"interview\">\232\168\170\229\149\143</term>\n    <term name=\"letter\">\228\191\161\228\187\182</term>\n    <term name=\"no date\">no date</term>\n    <term name=\"no date\" form=\"short\">\231\132\161\230\151\165\230\156\159</term>\n    <term name=\"online\">\229\156\168\231\183\154\228\184\138</term>\n    <term name=\"presented at\">\231\176\161\229\160\177\230\150\188</term>\n    <term name=\"reference\">\n      <single>reference</single>\n      <multiple>references</multiple>\n    </term>\n    <term name=\"reference\" form=\"short\">\n      <single>ref.</single>\n      <multiple>refs.</multiple>\n    </term>\n    <term name=\"retrieved\">\232\162\171\229\143\150\229\155\158</term>\n    <term name=\"scale\">scale</term>\n    <term name=\"version\">version</term>\n\n    <!-- ANNO DOMINI; BEFORE CHRIST -->\n    <term name=\"ad\">AD</term>\n    <term name=\"bc\">BC</term>\n\n    <!-- PUNCTUATION -->\n    <term name=\"open-quote\">\227\128\140</term>\n    <term name=\"close-quote\">\227\128\141</term>\n    <term name=\"open-inner-quote\">\227\128\142</term>\n    <term name=\"close-inner-quote\">\227\128\143</term>\n    <term name=\"page-range-delimiter\">\226\128\147</term>\n\n    <!-- ORDINALS -->\n    <term name=\"ordinal\">th</term>\n    <term name=\"ordinal-01\">st</term>\n    <term name=\"ordinal-02\">nd</term>\n    <term name=\"ordinal-03\">rd</term>\n    <term name=\"ordinal-11\">th</term>\n    <term name=\"ordinal-12\">th</term>\n    <term name=\"ordinal-13\">th</term>\n\n    <!-- LONG ORDINALS -->\n    <term name=\"long-ordinal-01\">first</term>\n    <term name=\"long-ordinal-02\">second</term>\n    <term name=\"long-ordinal-03\">third</term>\n    <term name=\"long-ordinal-04\">fourth</term>\n    <term name=\"long-ordinal-05\">fifth</term>\n    <term name=\"long-ordinal-06\">sixth</term>\n    <term name=\"long-ordinal-07\">seventh</term>\n    <term name=\"long-ordinal-08\">eighth</term>\n    <term name=\"long-ordinal-09\">ninth</term>\n    <term name=\"long-ordinal-10\">tenth</term>\n\n    <!-- LONG LOCATOR FORMS -->\n    <term name=\"book\">\n      <single>\230\155\184</single>\n      <multiple>\230\155\184</multiple>\n    </term>\n    <term name=\"chapter\">\n      <single>\231\171\160</single>\n      <multiple>\231\171\160</multiple>\n    </term>\n    <term name=\"column\">\n      <single>\230\172\132</single>\n      <multiple>\230\172\132</multiple>\n    </term>\n    <term name=\"figure\">\n      <single>\229\156\150</single>\n      <multiple>\229\156\150</multiple>\n    </term>\n    <term name=\"folio\">\n      <single>\229\176\141\233\150\139\231\180\153</single>\n      <multiple>\229\176\141\233\150\139\231\180\153</multiple>\n    </term>\n    <term name=\"issue\">\n      <single>\230\156\159\230\149\184</single>\n      <multiple>\230\156\159\230\149\184</multiple>\n    </term>\n    <term name=\"line\">\n      <single>\232\161\140</single>\n      <multiple>\232\161\140</multiple>\n    </term>\n    <term name=\"note\">\n      <single>\231\173\134\232\168\152</single>\n      <multiple>\231\173\134\232\168\152</multiple>\n    </term>\n    <term name=\"opus\">\n      <single>\228\189\156\229\147\129</single>\n      <multiple>\228\189\156\229\147\129</multiple>\n    </term>\n    <term name=\"page\">\n      <single>\233\160\129</single>\n      <multiple>\233\160\129</multiple>\n    </term>\n    <term name=\"paragraph\">\n      <single>\230\174\181\232\144\189</single>\n      <multiple>\230\174\181\232\144\189</multiple>\n    </term>\n    <term name=\"part\">\n      <single>\233\131\168</single>\n      <multiple>\233\131\168</multiple>\n    </term>\n    <term name=\"section\">\n      <single>\231\175\128</single>\n      <multiple>\231\175\128</multiple>\n    </term>\n    <term name=\"sub verbo\">\n      <single>sub verbo</single>\n      <multiple>sub verbis</multiple>\n    </term>\n    <term name=\"verse\">\n      <single>\232\169\169\229\143\165</single>\n      <multiple>\232\169\169\229\143\165</multiple>\n    </term>\n    <term name=\"volume\">\n      <single>\229\134\138</single>\n      <multiple>\229\134\138</multiple>\n    </term>\n\n    <!-- SHORT LOCATOR FORMS -->\n    <term name=\"book\" form=\"short\">\230\155\184</term>\n    <term name=\"chapter\" form=\"short\">\231\171\160</term>\n    <term name=\"column\" form=\"short\">\230\172\132</term>\n    <term name=\"figure\" form=\"short\">\229\156\150</term>\n    <term name=\"folio\" form=\"short\">\233\150\139</term>\n    <term name=\"issue\" form=\"short\">\230\156\159</term>\n    <term name=\"line\" form=\"short\">l.</term>\n    <term name=\"note\" form=\"short\">n.</term>\n    <term name=\"opus\" form=\"short\">\228\189\156</term>\n    <term name=\"page\" form=\"short\">\n      <single>\233\160\129</single>\n      <multiple>\233\160\129</multiple>\n    </term>\n    <term name=\"paragraph\" form=\"short\">\230\174\181</term>\n    <term name=\"part\" form=\"short\">\233\131\168</term>\n    <term name=\"section\" form=\"short\">\231\175\128</term>\n    <term name=\"sub verbo\" form=\"short\">\n      <single>s.v.</single>\n      <multiple>s.vv.</multiple>\n    </term>\n    <term name=\"verse\" form=\"short\">\n      <single>\229\143\165</single>\n      <multiple>\229\143\165</multiple>\n    </term>\n    <term name=\"volume\" form=\"short\">\n      <single>\229\134\138</single>\n      <multiple>\229\134\138</multiple>\n    </term>\n\n    <!-- SYMBOL LOCATOR FORMS -->\n    <term name=\"paragraph\" form=\"symbol\">\n      <single>\194\182</single>\n      <multiple>\194\182\194\182</multiple>\n    </term>\n    <term name=\"section\" form=\"symbol\">\n      <single>\194\167</single>\n      <multiple>\194\167\194\167</multiple>\n    </term>\n\n    <!-- LONG ROLE FORMS -->\n    <term name=\"director\">\n      <single>director</single>\n      <multiple>directors</multiple>\n    </term>\n    <term name=\"editor\">\n      <single>\231\183\168\232\188\175</single>\n      <multiple>\231\183\168\232\188\175</multiple>\n    </term>\n    <term name=\"editorial-director\">\n      <single>editor</single>\n      <multiple>editors</multiple>\n    </term>\n    <term name=\"illustrator\">\n      <single>illustrator</single>\n      <multiple>illustrators</multiple>\n    </term>\n    <term name=\"translator\">\n      <single>\231\191\187\232\173\175</single>\n      <multiple>\231\191\187\232\173\175</multiple>\n    </term>\n    <term name=\"editortranslator\">\n      <single>editor &amp; translator</single>\n      <multiple>editors &amp; translators</multiple>\n    </term>\n\n    <!-- SHORT ROLE FORMS -->\n    <term name=\"director\" form=\"short\">\n      <single>dir.</single>\n      <multiple>dirs.</multiple>\n    </term>\n    <term name=\"editor\" form=\"short\">\n      <single>\231\183\168</single>\n      <multiple>\231\183\168</multiple>\n    </term>\n    <term name=\"editorial-director\" form=\"short\">\n      <single>ed.</single>\n      <multiple>eds.</multiple>\n    </term>\n    <term name=\"illustrator\" form=\"short\">\n      <single>ill.</single>\n      <multiple>ills.</multiple>\n    </term>\n    <term name=\"translator\" form=\"short\">\n      <single>\232\173\175</single>\n      <multiple>\232\173\175</multiple>\n    </term>\n    <term name=\"editortranslator\" form=\"short\">\n      <single>ed. &amp; tran.</single>\n      <multiple>eds. &amp; trans.</multiple>\n    </term>\n\n    <!-- VERB ROLE FORMS -->\n    <term name=\"director\" form=\"verb\">directed by</term>\n    <term name=\"editor\" form=\"verb\">\231\183\168\232\128\133\230\152\175</term>\n    <term name=\"editorial-director\" form=\"verb\">edited by</term>\n    <term name=\"illustrator\" form=\"verb\">illustrated by</term>\n    <term name=\"interviewer\" form=\"verb\">\232\168\170\229\149\143\232\128\133\230\152\175</term>\n    <term name=\"recipient\" form=\"verb\">\230\142\136\232\136\135</term>\n    <term name=\"reviewed-author\" form=\"verb\">by</term>\n    <term name=\"translator\" form=\"verb\">\232\173\175\232\128\133\230\152\175</term>\n    <term name=\"editortranslator\" form=\"verb\">edited &amp; translated by</term>\n\n    <!-- SHORT VERB ROLE FORMS -->\n    <term name=\"container-author\" form=\"verb-short\">by</term>\n    <term name=\"director\" form=\"verb-short\">dir.</term>\n    <term name=\"editor\" form=\"verb-short\">\231\183\168</term>\n    <term name=\"editorial-director\" form=\"verb-short\">ed.</term>\n    <term name=\"illustrator\" form=\"verb-short\">illus.</term>\n    <term name=\"translator\" form=\"verb-short\">\232\173\175</term>\n    <term name=\"editortranslator\" form=\"verb-short\">ed. &amp; trans. by</term>\n\n    <!-- LONG MONTH FORMS -->\n    <term name=\"month-01\">\228\184\128\230\156\136</term>\n    <term name=\"month-02\">\228\186\140\230\156\136</term>\n    <term name=\"month-03\">\228\184\137\230\156\136</term>\n    <term name=\"month-04\">\229\155\155\230\156\136</term>\n    <term name=\"month-05\">\228\186\148\230\156\136</term>\n    <term name=\"month-06\">\229\133\173\230\156\136</term>\n    <term name=\"month-07\">\228\184\131\230\156\136</term>\n    <term name=\"month-08\">\229\133\171\230\156\136</term>\n    <term name=\"month-09\">\228\185\157\230\156\136</term>\n    <term name=\"month-10\">\229\141\129\230\156\136</term>\n    <term name=\"month-11\">\229\141\129\228\184\128\230\156\136</term>\n    <term name=\"month-12\">\229\141\129\228\186\140\230\156\136</term>\n\n    <!-- SHORT MONTH FORMS -->\n    <term name=\"month-01\" form=\"short\">1\230\156\136</term>\n    <term name=\"month-02\" form=\"short\">2\230\156\136</term>\n    <term name=\"month-03\" form=\"short\">3\230\156\136</term>\n    <term name=\"month-04\" form=\"short\">4\230\156\136</term>\n    <term name=\"month-05\" form=\"short\">5\230\156\136</term>\n    <term name=\"month-06\" form=\"short\">6\230\156\136</term>\n    <term name=\"month-07\" form=\"short\">7\230\156\136</term>\n    <term name=\"month-08\" form=\"short\">8\230\156\136</term>\n    <term name=\"month-09\" form=\"short\">9\230\156\136</term>\n    <term name=\"month-10\" form=\"short\">10\230\156\136</term>\n    <term name=\"month-11\" form=\"short\">11\230\156\136</term>\n    <term name=\"month-12\" form=\"short\">12\230\156\136</term>\n\n    <!-- SEASONS -->\n    <term name=\"season-01\">Spring</term>\n    <term name=\"season-02\">Summer</term>\n    <term name=\"season-03\">Autumn</term>\n    <term name=\"season-04\">Winter</term>\n  </terms>\n</locale>\n")]

defaultCSL :: S.ByteString
defaultCSL = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<style xmlns=\"http://purl.org/net/xbiblio/csl\" class=\"in-text\" version=\"1.0\" demote-non-dropping-particle=\"never\">\n  <info>\n    <title>Chicago Manual of Style (author-date)</title>\n    <id>http://www.zotero.org/styles/chicago-author-date</id>\n    <link href=\"http://www.zotero.org/styles/chicago-author-date\" rel=\"self\"/>\n    <link href=\"http://www.chicagomanualofstyle.org/tools_citationguide.html\" rel=\"documentation\"/>\n    <author>\n      <name>Julian Onions</name>\n      <email>julian.onions@gmail.com</email>\n    </author>\n    <contributor>\n      <name>Sebastian Karcher</name>\n    </contributor>\n    <contributor>\n      <name>Richard Karnesky</name>\n      <email>karnesky+zotero@gmail.com</email>\n      <uri>http://arc.nucapt.northwestern.edu/Richard_Karnesky</uri>\n    </contributor>\n    <category citation-format=\"author-date\"/>\n    <category field=\"generic-base\"/>\n    <summary>The author-date variant of the Chicago style</summary>\n    <updated>2013-03-28T05:37:10+00:00</updated>\n    <rights license=\"http://creativecommons.org/licenses/by-sa/3.0/\">This work is licensed under a Creative Commons Attribution-ShareAlike 3.0 License</rights>\n  </info>\n  <locale>\n    <terms>\n      <term name=\"editor\" form=\"verb-short\">ed.</term>\n      <term name=\"container-author\" form=\"verb\">by</term>\n      <term name=\"translator\" form=\"verb-short\">trans.</term>\n      <term name=\"translator\" form=\"short\">trans.</term>\n    </terms>\n  </locale>\n  <macro name=\"secondary-contributors\">\n    <choose>\n      <if type=\"chapter paper-conference\" match=\"none\">\n        <group delimiter=\". \">\n          <names variable=\"editor translator\">\n            <label form=\"verb\" text-case=\"capitalize-first\" suffix=\" \" plural=\"never\"/>\n            <name and=\"text\" delimiter=\", \"/>\n          </names>\n        </group>\n      </if>\n    </choose>\n  </macro>\n  <macro name=\"container-contributors\">\n    <choose>\n      <if type=\"chapter paper-conference\" match=\"any\">\n        <group prefix=\", \" delimiter=\", \">\n          <names variable=\"container-author editor\" delimiter=\", \">\n            <label form=\"verb\" suffix=\" \" plural=\"never\"/>\n            <name and=\"text\" delimiter=\", \"/>\n          </names>\n        </group>\n      </if>\n    </choose>\n  </macro>\n  <macro name=\"editor\">\n    <names variable=\"editor\">\n      <name name-as-sort-order=\"first\" and=\"text\" sort-separator=\", \" delimiter=\", \" delimiter-precedes-last=\"always\"/>\n      <label form=\"short\" prefix=\", \"/>\n    </names>\n  </macro>\n  <macro name=\"translator\">\n    <names variable=\"translator\">\n      <name name-as-sort-order=\"first\" and=\"text\" sort-separator=\", \" delimiter=\", \" delimiter-precedes-last=\"always\"/>\n      <label form=\"short\" prefix=\", \" plural=\"never\"/>\n    </names>\n  </macro>\n  <macro name=\"recipient\">\n    <choose>\n      <if type=\"personal_communication\">\n        <choose>\n          <if variable=\"genre\">\n            <text variable=\"genre\" text-case=\"capitalize-first\"/>\n          </if>\n          <else>\n            <text term=\"letter\" text-case=\"capitalize-first\"/>\n          </else>\n        </choose>\n      </if>\n    </choose>\n    <names variable=\"recipient\" delimiter=\", \">\n      <label form=\"verb\" prefix=\" \" text-case=\"lowercase\" suffix=\" \"/>\n      <name and=\"text\" delimiter=\", \"/>\n    </names>\n  </macro>\n  <macro name=\"contributors\">\n    <names variable=\"author\">\n      <name and=\"text\" name-as-sort-order=\"first\" sort-separator=\", \" delimiter=\", \" delimiter-precedes-last=\"always\"/>\n      <label form=\"short\" plural=\"never\" prefix=\", \"/>\n      <substitute>\n        <names variable=\"editor\"/>\n        <names variable=\"translator\"/>\n        <text macro=\"title\"/>\n      </substitute>\n    </names>\n    <text macro=\"recipient\"/>\n  </macro>\n  <macro name=\"contributors-short\">\n    <names variable=\"author\">\n      <name form=\"short\" and=\"text\" delimiter=\", \" initialize-with=\". \"/>\n      <substitute>\n        <names variable=\"editor\"/>\n        <names variable=\"translator\"/>\n        <text macro=\"title\"/>\n      </substitute>\n    </names>\n  </macro>\n  <macro name=\"interviewer\">\n    <names variable=\"interviewer\" delimiter=\", \">\n      <label form=\"verb\" prefix=\" \" text-case=\"capitalize-first\" suffix=\" \"/>\n      <name and=\"text\" delimiter=\", \"/>\n    </names>\n  </macro>\n  <macro name=\"archive\">\n    <group delimiter=\". \">\n      <text variable=\"archive_location\" text-case=\"capitalize-first\"/>\n      <text variable=\"archive\"/>\n      <text variable=\"archive-place\"/>\n    </group>\n  </macro>\n  <macro name=\"access\">\n    <group delimiter=\". \">\n      <choose>\n        <if type=\"graphic report\" match=\"any\">\n          <text macro=\"archive\"/>\n        </if>\n        <else-if type=\"article-magazine article-newspaper bill book chapter graphic legal_case legislation motion_picture paper-conference report song thesis\" match=\"none\">\n          <text macro=\"archive\"/>\n        </else-if>\n      </choose>\n      <text variable=\"DOI\" prefix=\"doi:\"/>\n      <choose>\n        <if variable=\"DOI issued\" match=\"none\">\n          <choose>\n            <if variable=\"URL accessed\" match=\"all\">\n              <group delimiter=\" \">\n                <text term=\"accessed\" text-case=\"capitalize-first\"/>\n                <date variable=\"accessed\" delimiter=\" \">\n                  <date-part name=\"month\"/>\n                  <date-part name=\"day\"/>\n                </date>\n              </group>\n            </if>\n          </choose>\n        </if>\n        <else-if type=\"webpage\">\n          <date variable=\"issued\" delimiter=\" \">\n            <date-part name=\"month\"/>\n            <date-part name=\"day\"/>\n          </date>\n        </else-if>\n      </choose>\n      <choose>\n        <if type=\"legal_case\" match=\"none\">\n          <text variable=\"URL\"/>\n        </if>\n      </choose>\n    </group>\n  </macro>\n  <macro name=\"title\">\n    <choose>\n      <if variable=\"title\" match=\"none\">\n        <choose>\n          <if type=\"personal_communication\" match=\"none\">\n            <text variable=\"genre\" text-case=\"capitalize-first\"/>\n          </if>\n        </choose>\n      </if>\n      <else-if type=\"bill book graphic legal_case legislation motion_picture song\" match=\"any\">\n        <text variable=\"title\" text-case=\"title\" font-style=\"italic\"/>\n      </else-if>\n      <else>\n        <text variable=\"title\" text-case=\"title\" quotes=\"true\"/>\n      </else>\n    </choose>\n  </macro>\n  <macro name=\"edition\">\n    <choose>\n      <if type=\"bill book graphic legal_case legislation motion_picture report song\" match=\"any\">\n        <choose>\n          <if is-numeric=\"edition\">\n            <group delimiter=\" \" prefix=\". \">\n              <number variable=\"edition\" form=\"ordinal\"/>\n              <text term=\"edition\" form=\"short\" strip-periods=\"true\"/>\n            </group>\n          </if>\n          <else>\n            <text variable=\"edition\" prefix=\". \"/>\n          </else>\n        </choose>\n      </if>\n      <else-if type=\"chapter  paper-conference\" match=\"any\">\n        <choose>\n          <if is-numeric=\"edition\">\n            <group delimiter=\" \" prefix=\", \">\n              <number variable=\"edition\" form=\"ordinal\"/>\n              <text term=\"edition\" form=\"short\"/>\n            </group>\n          </if>\n          <else>\n            <text variable=\"edition\" prefix=\", \"/>\n          </else>\n        </choose>\n      </else-if>\n    </choose>\n  </macro>\n  <macro name=\"locators\">\n    <choose>\n      <if type=\"article-journal\">\n        <text variable=\"volume\" prefix=\" \"/>\n        <text variable=\"issue\" prefix=\" (\" suffix=\")\"/>\n      </if>\n      <else-if type=\"legal_case\">\n        <text variable=\"volume\" prefix=\", \"/>\n        <text variable=\"container-title\" prefix=\" \"/>\n        <text variable=\"page\" prefix=\" \"/>\n      </else-if>\n      <else-if type=\"bill book graphic legal_case legislation motion_picture report song\" match=\"any\">\n        <group prefix=\". \" delimiter=\". \">\n          <group>\n            <text term=\"volume\" form=\"short\" text-case=\"capitalize-first\" suffix=\" \"/>\n            <number variable=\"volume\" form=\"numeric\"/>\n          </group>\n          <group>\n            <number variable=\"number-of-volumes\" form=\"numeric\"/>\n            <text term=\"volume\" form=\"short\" prefix=\" \" plural=\"true\"/>\n          </group>\n        </group>\n      </else-if>\n      <else-if type=\"chapter paper-conference\" match=\"any\">\n        <choose>\n          <if variable=\"page\" match=\"none\">\n            <group prefix=\". \">\n              <text term=\"volume\" form=\"short\" text-case=\"capitalize-first\" suffix=\" \"/>\n              <number variable=\"volume\" form=\"numeric\"/>\n            </group>\n          </if>\n        </choose>\n      </else-if>\n    </choose>\n  </macro>\n  <macro name=\"locators-chapter\">\n    <choose>\n      <if type=\"chapter paper-conference\" match=\"any\">\n        <choose>\n          <if variable=\"page\">\n            <group prefix=\", \">\n              <text variable=\"volume\" suffix=\":\"/>\n              <text variable=\"page\"/>\n            </group>\n          </if>\n        </choose>\n      </if>\n    </choose>\n  </macro>\n  <macro name=\"locators-article\">\n    <choose>\n      <if type=\"article-newspaper\">\n        <group prefix=\", \" delimiter=\", \">\n          <group>\n            <text variable=\"edition\" suffix=\" \"/>\n            <text term=\"edition\" prefix=\" \"/>\n          </group>\n          <group>\n            <text term=\"section\" form=\"short\" suffix=\" \"/>\n            <text variable=\"section\"/>\n          </group>\n        </group>\n      </if>\n      <else-if type=\"article-journal\">\n        <text variable=\"page\" prefix=\": \"/>\n      </else-if>\n    </choose>\n  </macro>\n  <macro name=\"point-locators\">\n    <choose>\n      <if variable=\"locator\">\n        <choose>\n          <if locator=\"page\" match=\"none\">\n            <choose>\n              <if type=\"bill book graphic legal_case legislation motion_picture report song\" match=\"any\">\n                <choose>\n                  <if variable=\"volume\">\n                    <group>\n                      <text term=\"volume\" form=\"short\" suffix=\" \"/>\n                      <number variable=\"volume\" form=\"numeric\"/>\n                      <label variable=\"locator\" form=\"short\" prefix=\", \" suffix=\" \"/>\n                    </group>\n                  </if>\n                  <else>\n                    <label variable=\"locator\" form=\"short\" suffix=\" \"/>\n                  </else>\n                </choose>\n              </if>\n              <else>\n                <label variable=\"locator\" form=\"short\" suffix=\" \"/>\n              </else>\n            </choose>\n          </if>\n          <else-if type=\"bill book graphic legal_case legislation motion_picture report song\" match=\"any\">\n            <number variable=\"volume\" form=\"numeric\" suffix=\":\"/>\n          </else-if>\n        </choose>\n        <text variable=\"locator\"/>\n      </if>\n    </choose>\n  </macro>\n  <macro name=\"container-prefix\">\n    <text term=\"in\" text-case=\"capitalize-first\"/>\n  </macro>\n  <macro name=\"container-title\">\n    <choose>\n      <if type=\"chapter paper-conference\" match=\"any\">\n        <text macro=\"container-prefix\" suffix=\" \"/>\n      </if>\n    </choose>\n    <choose>\n      <if type=\"legal_case\" match=\"none\">\n        <text variable=\"container-title\" text-case=\"title\" font-style=\"italic\"/>\n      </if>\n    </choose>\n  </macro>\n  <macro name=\"publisher\">\n    <group delimiter=\": \">\n      <text variable=\"publisher-place\"/>\n      <text variable=\"publisher\"/>\n    </group>\n  </macro>\n  <macro name=\"date\">\n    <choose>\n      <if variable=\"issued\">\n        <date variable=\"issued\">\n          <date-part name=\"year\"/>\n        </date>\n      </if>\n      <else-if variable=\"accessed\">\n        <date variable=\"accessed\">\n          <date-part name=\"year\"/>\n        </date>\n      </else-if>\n    </choose>\n  </macro>\n  <macro name=\"day-month\">\n    <date variable=\"issued\">\n      <date-part name=\"month\"/>\n      <date-part name=\"day\" prefix=\" \"/>\n    </date>\n  </macro>\n  <macro name=\"collection-title\">\n    <text variable=\"collection-title\" text-case=\"title\"/>\n    <text variable=\"collection-number\" prefix=\" \"/>\n  </macro>\n  <macro name=\"event\">\n    <group>\n      <text term=\"presented at\" suffix=\" \"/>\n      <text variable=\"event\"/>\n    </group>\n  </macro>\n  <macro name=\"description\">\n    <choose>\n      <if type=\"interview\">\n        <group delimiter=\". \">\n          <text macro=\"interviewer\"/>\n          <text variable=\"medium\" text-case=\"capitalize-first\"/>\n        </group>\n      </if>\n      <else>\n        <text variable=\"medium\" text-case=\"capitalize-first\" prefix=\". \"/>\n      </else>\n    </choose>\n    <choose>\n      <if variable=\"title\" match=\"none\"/>\n      <else-if type=\"thesis\"/>\n      <else>\n        <group delimiter=\" \" prefix=\". \">\n          <text variable=\"genre\" text-case=\"capitalize-first\"/>\n          <choose>\n            <if type=\"report\">\n              <text variable=\"number\"/>\n            </if>\n          </choose>\n        </group>\n      </else>\n    </choose>\n    <!--This is for computer programs only. Localization new to 1.0.1, so may be missing in many locales-->\n    <group delimiter=\" \" prefix=\" (\" suffix=\")\">\n      <text term=\"version\"/>\n      <text variable=\"version\"/>\n    </group>\n  </macro>\n  <macro name=\"issue\">\n    <choose>\n      <if type=\"article-journal\">\n        <text macro=\"day-month\" prefix=\" (\" suffix=\")\"/>\n      </if>\n      <else-if type=\"legal_case\">\n        <text variable=\"authority\" prefix=\". \"/>\n      </else-if>\n      <else-if type=\"speech\">\n        <group prefix=\" \" delimiter=\", \">\n          <text macro=\"event\"/>\n          <text macro=\"day-month\"/>\n          <text variable=\"event-place\"/>\n        </group>\n      </else-if>\n      <else-if type=\"article-newspaper article-magazine\" match=\"any\">\n        <text macro=\"day-month\" prefix=\", \"/>\n      </else-if>\n      <else>\n        <group prefix=\". \" delimiter=\", \">\n          <choose>\n            <if type=\"thesis\">\n              <text variable=\"genre\" text-case=\"capitalize-first\"/>\n            </if>\n          </choose>\n          <text macro=\"publisher\"/>\n        </group>\n      </else>\n    </choose>\n  </macro>\n  <citation et-al-min=\"4\" et-al-use-first=\"1\" disambiguate-add-year-suffix=\"true\" disambiguate-add-names=\"true\" disambiguate-add-givenname=\"true\" givenname-disambiguation-rule=\"primary-name\">\n    <layout prefix=\"(\" suffix=\")\" delimiter=\"; \">\n      <group delimiter=\", \">\n        <group delimiter=\" \">\n          <text macro=\"contributors-short\"/>\n          <text macro=\"date\"/>\n        </group>\n        <text macro=\"point-locators\"/>\n      </group>\n    </layout>\n  </citation>\n  <bibliography hanging-indent=\"true\" et-al-min=\"11\" et-al-use-first=\"7\" subsequent-author-substitute=\"&#8212;&#8212;&#8212;\" entry-spacing=\"0\">\n    <sort>\n      <key macro=\"contributors\"/>\n      <key variable=\"issued\"/>\n    </sort>\n    <layout suffix=\".\">\n      <group delimiter=\". \">\n        <text macro=\"contributors\"/>\n        <text macro=\"date\"/>\n        <text macro=\"title\"/>\n      </group>\n      <text macro=\"description\"/>\n      <text macro=\"secondary-contributors\" prefix=\". \"/>\n      <text macro=\"container-title\" prefix=\". \"/>\n      <text macro=\"container-contributors\"/>\n      <text macro=\"edition\"/>\n      <text macro=\"locators-chapter\"/>\n      <text macro=\"locators\"/>\n      <text macro=\"collection-title\" prefix=\". \"/>\n      <text macro=\"issue\"/>\n      <text macro=\"locators-article\"/>\n      <text macro=\"access\" prefix=\". \"/>\n    </layout>\n  </bibliography>\n</style>\n"
