# Changelog for pantry

## v0.11.0

* Update `defaultHackageSecurityConfig` for changes in Hackage's `root.json`
  file of the keys of the Hackage root key holders.

## v0.10.1

* Expose new `parseRawPackageLocationImmutables`.
* Add errors S-925 (`RawPackageLocationImmutableParseFail`) and S-775
  (`RawPackageLocationImmutableParseWarnings`).

## v0.10.0

* Name of tar file of local cache of package index is not hard coded.
* `withPantryConfig` and `withPantryConfig'` require the location of global
  hints to be specified.
* `GlobalHintsLocation`, `defaultGlobalHintsLocation`, `globalHintsLocation` and
  `parseGlobalHintsLocation` added.
* `withPantryConfig'` now requires the specification of whether or not Hpack's
  `--force` flag is to be applied.
* Expose `hpackForceL`, a lens to view or modify the `Force` (Hpack) of a
  `PantryConfig`.

## v0.9.3.2

* Support `ansi-terminal-1.0.2`.
* Bug fix: On Windows, `loadPackageRaw` supports repositories with submodules,
  as intended.

## v0.9.3.1

* Depend on `aeson-warning-parser-0.1.1`.

## v0.9.3

* Add error S-628 (`LocalNoArchiveFileFound`).
* Depend on `rio-prettyprint-0.1.7.0`.

## v0.9.2

* `defaultCasaRepoPrefix` references https://casa.stackage.org, instead of
  https://casa.fpcomplete.com.
* Depend on `crypton` instead of `cryptonite`.
* Depend on `tar-conduit-0.4.0`, which will tolerate long filenames and
  directory names in archives created by `git archive`.

## v0.9.1

* Expose module `Pantry.SQLite`.

## v0.9.0

* Remove module `Pantry.Internal.AesonExtended` and depend on
  `aeson-warning-parser` package.
* Remove module `Pantry.Internal.Companion` and depend on `companion` package.
* Remove module `Pantry.Internal.StaticBytes` and depend on `static-bytes`
  package.
* Remove module `Pantry.Internal`, previously exposed only for testing.
* Update `defaultHackageSecurityConfig` for changes in Hackage's `root.json`
  file of the keys of the Hackage root key holders.

## v0.8.3

* Expose `withPantryConfig'`, which allows for optional use of Casa.
  `NoCasaConfig` is now a data constructor of `PantryException`.
* `withRepo`, in the case of Git, will now, if necessary, fetch the specific
  commit. (For example, GitHub repositories include the commits of unmerged pull
  requests but these are not fetched when the repository is cloned.)

## v0.8.2.2

* Add error S-395 (`NoLocalPackageDirFound`).

## v0.8.2.1

* On Windows, avoid fatal `tar: Cannot connect to C: resolve failed` bug when
  archiving repository submodules.

## v0.8.2

* `PantryException` is now an instance of the
  `Text.PrettyPrint.Leijen.Extended.Pretty` class (provided by the
  `rio-prettyprint` package).
* Module `Pantry` now exports `FuzzyResults`, `Mismatch` and `SafeFilePath` (and
  `mkSafeFilePath`), used in data constructors of `PantryException`.

## v0.8.1

* Support `hpack-0.35.1`, and prettier `HpackLibraryException` error messages.

## v0.8.0

* `findOrGenerateCabalFile`, `loadCabalFilePath`, `loadCabalFile` and
  `loadCabalFileRaw` no longer assume that the program name used by Hpack (the
  library) is "stack", and take a new initial argument of type `Maybe Text` to
  specify the desired program name. The default is "hpack".

## v0.7.1

* To support the Haskell Foundation's
  [Haskell Error Index](https://errors.haskell.org/) initiative, all Pantry
  error messages generated by Pantry itself begin with an unique code in the
  form `[S-nnn]`, where `nnn` is a three-digit number.

## v0.7.0

* Change `defaultHackageSecurityConfig` such that field
  `hscIgnoreExpiry = True`, to be consistent with the defaults of the
  `WithJSONWarnings HackageSecurityConfig` instance of `FromJSON`.

## v0.6.0

* Rename `HackageSecurityConfig` as `PackageIndexConfig`,
  `defaultHackageSecurityConfig` as `defaultPackageIndexConfig`, and
  `pcHackageSecurity` field of `PantryConfig` as `pcPackageIndex`.
* Expose new `HackageSecurityConfig` and `defaultHackageSecurityConfig`. The
  former represents Hackage Security configurations (only - no download prefix).
* Change the data constructor of `PackageIndexConfig` to have fields for a
  download prefix (type `Text`) and of type `HackageSecurityConfig`.
* The `WithJSONWarnings PackageIndexConfig` instance of `FromJSON` now assigns
  default value `defaultHackageSecurityConfig` if the `hackage-security` key is
  absent from the JSON object.
* Expose `defaultDownloadPrefix`, for the official Hackage server.

## v0.5.7

* Expose `loadAndCompleteSnapshotRaw'` and `loadAndCompleteSnapshot'`, which
  allow the toggling of the debug output of the raw snapshot layer. See
  [#55](https://github.com/commercialhaskell/pantry/pull/55).
* Support GHC 9.4.

## v0.5.6

* Remove operational and mirror keys from bootstrap key set. See
  [#53](https://github.com/commercialhaskell/pantry/pull/53).

## v0.5.5

* Support `Cabal-3.6.0.0`.

## v0.5.4

* Support `aeson-2.0.0.0`.

## v0.5.3

* improve and expose `fetchRepos`/`fetchReposRaw`.

## v0.5.2.3

* Support for GHC 9.0. See
  [#39](https://github.com/commercialhaskell/pantry/pull/39).

## v0.5.2.2

* Support for `Cabal-3.4.0.0`. See
  [#38](https://github.com/commercialhaskell/pantry/pull/38).

## v0.5.2.1

* Support `persistent-2.13.0.0`. See
  [#35](https://github.com/commercialhaskell/pantry/issues/35).

## v0.5.2

* Fall back to BSD tar when type cannot be detected. See
  [#33](https://github.com/commercialhaskell/pantry/issues/33).

## v0.5.1.5
* Switch back to `hackage.haskell.org`. See
  [#30](https://github.com/commercialhaskell/pantry/pull/30).
* Pass through basic auth credentials specified in URLs. See
  [#32](https://github.com/commercialhaskell/pantry/pull/32).

## v0.5.1.4

* Allow building with `persistent-2.11.0.0`. See
  [#28](https://github.com/commercialhaskell/pantry/pull/28).

## v0.5.1.3

* Handle case where tree exists in cache by blobs are missing. See
  [#27](https://github.com/commercialhaskell/pantry/issues/27).

## v0.5.1.2

* Skip a test for issue
  [#26](https://github.com/commercialhaskell/pantry/issues/26).

## v0.5.1.1

* Fix to allow multiple relative path of symlink.

## v0.5.1.0

* Catch all exceptions from Casa calls and recover.

## v0.5.0.0

* Make the location of LTS/Nightly snapshots configurable.

## v0.4.0.1

* Removed errant log message.

## v0.4.0.0

* Add a deprecation warning when using a repo/archive without a Cabal file, see
  Stack issue [#5210](https://github.com/commercialhaskell/stack/issues/5210).
* Do not include repo/archive dependencies which do not include Cabal files in
  lock files.
* Remove some no longer used functions.

## v0.3.0.0

* Upgrade to `Cabal-3.0.0.0`.

## v0.2.0.0

Bug fixes:

* Don't compare the hashes of Cabal files. Addresses bugs such as Stack issue
  [#5045](https://github.com/commercialhaskell/stack/issues/5045). Data type
  changes: removed the `pmCabal` and `rpmCabal` fields.

## v0.1.1.2

Bug fixes:

* Module mapping insertions into the database are now atomic. Previously, if
  you SIGTERMed at the wrong time while running a script, you could end up with
  an inconsistent database state.

## v0.1.1.1

Other changes:

* Support building with `persistent-template-2.7.0`.

## v0.1.1.0

**Changes since 0.1.0.0**

Bug fixes:

* Fix to allow dependencies on specific versions of local git repositories. See
  Stack pull request
  [#4862](https://github.com/commercialhaskell/stack/pull/4862).

Behavior changes:

* By default, do not perform expiry checks in Hackage Security. See Stack issue
  [#4928](https://github.com/commercialhaskell/stack/issues/4928).

Other changes:

* Rename `pantry-tmp` package back to `pantry`, now that we have gained
  maintainership (which had been used by someone else for a candidate-only test
  that made it look like the name was free but prevented uploading a real
  package).


## 0.1.0.0

* Initial release.
