module Patrol.Type.DeviceContext where

import qualified Data.Aeson as Aeson
import qualified Data.Text as Text
import qualified Data.Time as Time
import qualified Patrol.Extra.Aeson as Aeson

-- | <https://develop.sentry.dev/sdk/event-payloads/types/#devicecontext>
data DeviceContext = DeviceContext
  { arch :: Text.Text,
    batteryLevel :: Maybe Double,
    batteryStatus :: Text.Text,
    bootTime :: Maybe Time.UTCTime,
    brand :: Text.Text,
    charging :: Maybe Bool,
    cpuDescription :: Text.Text,
    deviceType :: Text.Text,
    deviceUniqueIdentifier :: Text.Text,
    externalFreeStorage :: Maybe Int,
    externalStorageSize :: Maybe Int,
    family :: Text.Text,
    freeMemory :: Maybe Int,
    freeStorage :: Maybe Int,
    lowMemory :: Maybe Bool,
    manufacturer :: Text.Text,
    memorySize :: Maybe Int,
    model :: Text.Text,
    modelId :: Text.Text,
    name :: Text.Text,
    online :: Maybe Bool,
    orientation :: Text.Text,
    processorCount :: Maybe Int,
    processorFrequency :: Maybe Double,
    screenDensity :: Maybe Double,
    screenDpi :: Maybe Double,
    screenResolution :: Text.Text,
    simulator :: Maybe Bool,
    storageSize :: Maybe Int,
    supportsAccelerometer :: Maybe Bool,
    supportsAudio :: Maybe Bool,
    supportsGyroscope :: Maybe Bool,
    supportsLocationService :: Maybe Bool,
    supportsVibration :: Maybe Bool,
    timezone :: Text.Text,
    usableMemory :: Maybe Int
  }
  deriving (Eq, Show)

instance Aeson.ToJSON DeviceContext where
  toJSON deviceContext =
    Aeson.intoObject
      [ Aeson.pair "arch" $ arch deviceContext,
        Aeson.pair "battery_level" $ batteryLevel deviceContext,
        Aeson.pair "battery_status" $ batteryStatus deviceContext,
        Aeson.pair "boot_time" $ bootTime deviceContext,
        Aeson.pair "brand" $ brand deviceContext,
        Aeson.pair "charging" $ charging deviceContext,
        Aeson.pair "cpu_description" $ cpuDescription deviceContext,
        Aeson.pair "device_type" $ deviceType deviceContext,
        Aeson.pair "device_unique_identifier" $ deviceUniqueIdentifier deviceContext,
        Aeson.pair "external_free_storage" $ externalFreeStorage deviceContext,
        Aeson.pair "external_storage_size" $ externalStorageSize deviceContext,
        Aeson.pair "family" $ family deviceContext,
        Aeson.pair "free_memory" $ freeMemory deviceContext,
        Aeson.pair "free_storage" $ freeStorage deviceContext,
        Aeson.pair "low_memory" $ lowMemory deviceContext,
        Aeson.pair "manufacturer" $ manufacturer deviceContext,
        Aeson.pair "memory_size" $ memorySize deviceContext,
        Aeson.pair "model" $ model deviceContext,
        Aeson.pair "model_id" $ modelId deviceContext,
        Aeson.pair "name" $ name deviceContext,
        Aeson.pair "online" $ online deviceContext,
        Aeson.pair "orientation" $ orientation deviceContext,
        Aeson.pair "processor_count" $ processorCount deviceContext,
        Aeson.pair "processor_frequency" $ processorFrequency deviceContext,
        Aeson.pair "screen_density" $ screenDensity deviceContext,
        Aeson.pair "screen_dpi" $ screenDpi deviceContext,
        Aeson.pair "screen_resolution" $ screenResolution deviceContext,
        Aeson.pair "simulator" $ simulator deviceContext,
        Aeson.pair "storage_size" $ storageSize deviceContext,
        Aeson.pair "supports_accelerometer" $ supportsAccelerometer deviceContext,
        Aeson.pair "supports_audio" $ supportsAudio deviceContext,
        Aeson.pair "supports_gyroscope" $ supportsGyroscope deviceContext,
        Aeson.pair "supports_location_service" $ supportsLocationService deviceContext,
        Aeson.pair "supports_vibration" $ supportsVibration deviceContext,
        Aeson.pair "timezone" $ timezone deviceContext,
        Aeson.pair "usable_memory" $ usableMemory deviceContext
      ]

empty :: DeviceContext
empty =
  DeviceContext
    { arch = Text.empty,
      batteryLevel = Nothing,
      batteryStatus = Text.empty,
      bootTime = Nothing,
      brand = Text.empty,
      charging = Nothing,
      cpuDescription = Text.empty,
      deviceType = Text.empty,
      deviceUniqueIdentifier = Text.empty,
      externalFreeStorage = Nothing,
      externalStorageSize = Nothing,
      family = Text.empty,
      freeMemory = Nothing,
      freeStorage = Nothing,
      lowMemory = Nothing,
      manufacturer = Text.empty,
      memorySize = Nothing,
      model = Text.empty,
      modelId = Text.empty,
      name = Text.empty,
      online = Nothing,
      orientation = Text.empty,
      processorCount = Nothing,
      processorFrequency = Nothing,
      screenDensity = Nothing,
      screenDpi = Nothing,
      screenResolution = Text.empty,
      simulator = Nothing,
      storageSize = Nothing,
      supportsAccelerometer = Nothing,
      supportsAudio = Nothing,
      supportsGyroscope = Nothing,
      supportsLocationService = Nothing,
      supportsVibration = Nothing,
      timezone = Text.empty,
      usableMemory = Nothing
    }
