{-# LANGUAGE DuplicateRecordFields #-}

module Photoname.Common
  ( Artist (..)
  , ConfigPath (..)
  , CopySwitch (..)
  , DestPath (..)
  , Extension (..)
  , Links(..)
  , MoveSwitch (..)
  , NoActionSwitch (..)
  , NoDirsSwitch (..)
  , ParentDir (..)
  , Options (..)
  , Prefix (..)
  , Severity (..)
  , SrcPath (..)
  , Suffix (..)
  , Verbosity (..)
  , defaultDateTimeFormat
  , readVerbosity
  )
  where

import Colog.Simple (Severity (Debug, Info, Notice))
import Data.Time.LocalTime (LocalTime)
import System.Posix (CNlink)


defaultDateTimeFormat :: String
defaultDateTimeFormat = "%Y%m%d-%H%M%S"


data Verbosity
  = Quiet
  | Verbose Severity

instance Show Verbosity where
  show Quiet = "0"
  show (Verbose Notice) = "1"
  show (Verbose Info) = "2"
  show (Verbose Debug) = "3"
  show _ = "Should never see this, invalid verbosity level being shown"


readVerbosity :: String -> Either String Verbosity
readVerbosity "0" = Right   Quiet
readVerbosity "1" = Right $ Verbose Notice
readVerbosity "2" = Right $ Verbose Info
readVerbosity "3" = Right $ Verbose Debug
readVerbosity _   = Left    "Invalid verbosity level, expecting 0-3"


newtype Artist = Artist String

newtype ConfigPath = ConfigPath FilePath

newtype CopySwitch = CopySwitch { v :: Bool }

type DateFormatter = LocalTime -> String

newtype NoDirsSwitch = NoDirsSwitch { v :: Bool }

data Extension = Extension FilePath | UseExistingExtension

data Links = Exactly CNlink | NoLimit

newtype MoveSwitch = MoveSwitch { v :: Bool }

newtype NoActionSwitch = NoActionSwitch { v :: Bool }

newtype ParentDir = ParentDir { v :: FilePath }

newtype Prefix = Prefix { v :: String }

newtype Suffix = Suffix { v :: String }

data Options = Options
  { artist     :: Maybe Artist
  , config     :: Maybe ConfigPath
  , copy       :: CopySwitch
  , noDirs     :: NoDirsSwitch
  , extension  :: Extension
  , formatter  :: DateFormatter
  , links      :: Links
  , move       :: MoveSwitch
  , noAction   :: NoActionSwitch
  , parentDir  :: ParentDir
  , prefix     :: Prefix
  , suffix     :: Suffix
  , verbosity  :: Verbosity
  , paths      :: [FilePath]
  }


newtype SrcPath = SrcPath { v :: FilePath }

newtype DestPath = DestPath FilePath
