module Photoname.Links
  ( describeHardLinkPolicy
  , linksTest
  )
  where

import Colog.Simple (logNotice)
import Formatting ((%+), sformat, int)
import System.Posix (FileStatus, linkCount)

import Photoname.Common (Links (Exactly, NoLimit))
import Photoname.Monad (Ph)


linksTest :: Links -> FileStatus -> Bool
linksTest (Exactly linkCountWanted) fileStatus = linkCountWanted == linkCount fileStatus
linksTest NoLimit                   _          = True


describeHardLinkPolicy :: Links -> Ph ()
describeHardLinkPolicy l = case l of
  Exactly 1 -> logNotice "Only processing files with 1 hard link"
  Exactly n -> logNotice $ sformat
    ("Only processing files with" %+ int %+ "hard links") (toInteger n)
  NoLimit   -> pure ()
