module Photoname.Log
  ( logger
  )
  where

import Colog.Simple (LogAction, Message, Severity(Debug), (%), (%+), msg, msgc,
  sevc, stack, logTextStdout)
import Colog.Simple qualified
import Control.Monad.Trans (MonadIO)

import Photoname.Common (Verbosity (..))


-- Wrapper to set up logging based on desired verbosity
logger :: MonadIO m => Verbosity -> LogAction m Message
logger  Quiet          = mempty
logger (Verbose Debug) = Colog.Simple.logger (sevc % stack %+ msg) logTextStdout Debug
logger (Verbose sev)   = Colog.Simple.logger msgc logTextStdout sev
