module Database.PostgreSQL.Query
       ( -- * Common usage modules
         module Database.PostgreSQL.Query.Entity
       , module Database.PostgreSQL.Query.Functions
       , module Database.PostgreSQL.Query.SqlBuilder
       , module Database.PostgreSQL.Query.TH
       , module Database.PostgreSQL.Query.Types

           -- * Some re-exports from postgresql-simple
       , Connection, connect, defaultConnectInfo, connectPostgreSQL
       , ConnectInfo(..) , ToField(..), ToRow(..), FromField(..)
       , FromRow(..), Query(..), Only(..), In(..), Oid(..), Values(..)
       , (:.)(..), PGArray(..), HStoreList(..), HStoreMap(..)
       , ToHStore(..), HStoreBuilder , hstore, parseHStoreList
       , ToHStoreText(..), HStoreText , sqlQQ
       ) where


import Database.PostgreSQL.Simple
    ( ToRow, Connection, FromRow, defaultConnectInfo,
      connectPostgreSQL, connect, ConnectInfo(..) )
import Database.PostgreSQL.Simple.FromField ( FromField(..) )
import Database.PostgreSQL.Simple.FromRow ( FromRow(..) )
import Database.PostgreSQL.Simple.HStore hiding
    ( toBuilder, toLazyByteString ) -- to prevent conflicts
import Database.PostgreSQL.Simple.SqlQQ
import Database.PostgreSQL.Simple.ToField ( ToField(..) )
import Database.PostgreSQL.Simple.ToRow ( ToRow(..) )
import Database.PostgreSQL.Simple.Types
import Language.Haskell.TH.Quote ( QuasiQuoter )

import Database.PostgreSQL.Query.Entity
import Database.PostgreSQL.Query.Functions
import Database.PostgreSQL.Query.SqlBuilder
import Database.PostgreSQL.Query.TH
import Database.PostgreSQL.Query.Types

sqlQQ :: QuasiQuoter
sqlQQ = sql

{-# DEPRECATED sqlQQ "Use 'sqlExp' instead" #-}
