module Main (main) where

import Main.Scopes
import Main.Scripts
import qualified PostgresqlTypes as PostgresqlTypes
import Test.Hspec
import Test.QuickCheck.Instances ()
import Prelude

main :: IO ()
main =
  hspec do
    parallel do
      withContainer "postgres:18" do
        withConnection Nothing do
          withType @(PostgresqlTypes.Bit 0) [mappingSpec]
          withType @(PostgresqlTypes.Bit 1) [mappingSpec]
          withType @(PostgresqlTypes.Bit 64) [mappingSpec]
          withType @PostgresqlTypes.Bool [mappingSpec]
          withType @PostgresqlTypes.Box [mappingSpec]
          withType @PostgresqlTypes.Bytea [mappingSpec]
          withType @PostgresqlTypes.Char [mappingSpec]
          withType @(PostgresqlTypes.Bpchar 0) [mappingSpec]
          withType @(PostgresqlTypes.Bpchar 1) [mappingSpec]
          withType @(PostgresqlTypes.Bpchar 64) [mappingSpec]
          withType @PostgresqlTypes.Cidr [mappingSpec]
          withType @PostgresqlTypes.Circle [mappingSpec]
          withType @PostgresqlTypes.Date [mappingSpec]
          withType @PostgresqlTypes.Float4 [mappingSpec]
          withType @PostgresqlTypes.Float8 [mappingSpec]
          withType @PostgresqlTypes.Inet [mappingSpec]
          withType @PostgresqlTypes.Int2 [mappingSpec]
          withType @PostgresqlTypes.Int4 [mappingSpec]
          withType @PostgresqlTypes.Int8 [mappingSpec]
          withType @PostgresqlTypes.Interval [mappingSpec]
          withType @PostgresqlTypes.Json [mappingSpec]
          withType @PostgresqlTypes.Jsonb [mappingSpec]
          withType @PostgresqlTypes.Line [mappingSpec]
          withType @PostgresqlTypes.Lseg [mappingSpec]
          withType @PostgresqlTypes.Macaddr [mappingSpec]
          withType @PostgresqlTypes.Macaddr8 [mappingSpec]
          withType @PostgresqlTypes.Money [mappingSpec]
          withType @(PostgresqlTypes.Numeric 0 0) [mappingSpec]
          withType @(PostgresqlTypes.Numeric 7 0) [mappingSpec]
          withType @(PostgresqlTypes.Numeric 7 2) [mappingSpec]
          withType @(PostgresqlTypes.Numeric 7 7) [mappingSpec]
          withType @PostgresqlTypes.Oid [mappingSpec]
          withType @PostgresqlTypes.Path [mappingSpec]
          withType @PostgresqlTypes.Point [mappingSpec]
          withType @PostgresqlTypes.Polygon [mappingSpec]
          withType @(PostgresqlTypes.Range PostgresqlTypes.Int4) [mappingSpec]
          withType @(PostgresqlTypes.Range PostgresqlTypes.Int8) [mappingSpec]
          withType @(PostgresqlTypes.Range (PostgresqlTypes.Numeric 0 0)) [mappingSpec]
          withType @(PostgresqlTypes.Range (PostgresqlTypes.Numeric 3 3)) [mappingSpec]
          withType @(PostgresqlTypes.Range (PostgresqlTypes.Numeric 7 3)) [mappingSpec]
          withType @(PostgresqlTypes.Range (PostgresqlTypes.Numeric 7 0)) [mappingSpec]
          withType @(PostgresqlTypes.Range PostgresqlTypes.Timestamp) [mappingSpec]
          withType @(PostgresqlTypes.Range PostgresqlTypes.Timestamptz) [mappingSpec]
          withType @(PostgresqlTypes.Range PostgresqlTypes.Date) [mappingSpec]
          withType @(PostgresqlTypes.Multirange PostgresqlTypes.Int4) [mappingSpec]
          withType @(PostgresqlTypes.Multirange PostgresqlTypes.Int8) [mappingSpec]
          withType @(PostgresqlTypes.Multirange (PostgresqlTypes.Numeric 0 0)) [mappingSpec]
          withType @(PostgresqlTypes.Multirange (PostgresqlTypes.Numeric 3 3)) [mappingSpec]
          withType @(PostgresqlTypes.Multirange (PostgresqlTypes.Numeric 7 3)) [mappingSpec]
          withType @(PostgresqlTypes.Multirange (PostgresqlTypes.Numeric 7 0)) [mappingSpec]
          withType @(PostgresqlTypes.Multirange PostgresqlTypes.Timestamp) [mappingSpec]
          withType @(PostgresqlTypes.Multirange PostgresqlTypes.Timestamptz) [mappingSpec]
          withType @(PostgresqlTypes.Multirange PostgresqlTypes.Date) [mappingSpec]
          withType @PostgresqlTypes.Text [mappingSpec]
          withType @PostgresqlTypes.Time [mappingSpec]
          withType @PostgresqlTypes.Timestamp [mappingSpec]
          withType @PostgresqlTypes.Timestamptz [mappingSpec]
          withType @PostgresqlTypes.Timetz [mappingSpec]
          withType @PostgresqlTypes.Uuid [mappingSpec]
          withType @(PostgresqlTypes.Varbit 0) [mappingSpec]
          withType @(PostgresqlTypes.Varbit 128) [mappingSpec]
          withType @(PostgresqlTypes.Varchar 0) [mappingSpec]
          withType @(PostgresqlTypes.Varchar 255) [mappingSpec]

      withContainer "postgres:14" do
        withConnection (Just 3) do
          withType @(PostgresqlTypes.Bit 1) [mappingSpec]
          withType @(PostgresqlTypes.Bit 64) [mappingSpec]
          withType @PostgresqlTypes.Bool [mappingSpec]
          withType @PostgresqlTypes.Box [mappingSpec]
          withType @PostgresqlTypes.Bytea [mappingSpec]
          withType @PostgresqlTypes.Char [mappingSpec]
          withType @(PostgresqlTypes.Bpchar 1) [mappingSpec]
          withType @(PostgresqlTypes.Bpchar 64) [mappingSpec]
          withType @PostgresqlTypes.Cidr [mappingSpec]
          withType @PostgresqlTypes.Circle [mappingSpec]
          withType @PostgresqlTypes.Date [mappingSpec]
          withType @PostgresqlTypes.Float4 [mappingSpec]
          withType @PostgresqlTypes.Float8 [mappingSpec]
          withType @PostgresqlTypes.Inet [mappingSpec]
          withType @PostgresqlTypes.Int2 [mappingSpec]
          withType @PostgresqlTypes.Int4 [mappingSpec]
          withType @PostgresqlTypes.Int8 [mappingSpec]
          withType @PostgresqlTypes.Interval [mappingSpec]
          withType @PostgresqlTypes.Json [mappingSpec]
          withType @PostgresqlTypes.Jsonb [mappingSpec]
          withType @PostgresqlTypes.Line [mappingSpec]
          withType @PostgresqlTypes.Lseg [mappingSpec]
          withType @PostgresqlTypes.Macaddr [mappingSpec]
          withType @PostgresqlTypes.Money [mappingSpec]
          withType @(PostgresqlTypes.Numeric 0 0) [mappingSpec]
          withType @(PostgresqlTypes.Numeric 7 0) [mappingSpec]
          withType @(PostgresqlTypes.Numeric 7 2) [mappingSpec]
          withType @(PostgresqlTypes.Numeric 7 7) [mappingSpec]
          withType @PostgresqlTypes.Oid [mappingSpec]
          withType @PostgresqlTypes.Path [mappingSpec]
          withType @PostgresqlTypes.Point [mappingSpec]
          withType @PostgresqlTypes.Polygon [mappingSpec]
          withType @(PostgresqlTypes.Range PostgresqlTypes.Int4) [mappingSpec]
          withType @(PostgresqlTypes.Range PostgresqlTypes.Int8) [mappingSpec]
          withType @(PostgresqlTypes.Range (PostgresqlTypes.Numeric 0 0)) [mappingSpec]
          withType @(PostgresqlTypes.Range (PostgresqlTypes.Numeric 3 3)) [mappingSpec]
          withType @(PostgresqlTypes.Range (PostgresqlTypes.Numeric 7 3)) [mappingSpec]
          withType @(PostgresqlTypes.Range (PostgresqlTypes.Numeric 7 0)) [mappingSpec]
          withType @(PostgresqlTypes.Range PostgresqlTypes.Timestamp) [mappingSpec]
          withType @(PostgresqlTypes.Range PostgresqlTypes.Timestamptz) [mappingSpec]
          withType @(PostgresqlTypes.Range PostgresqlTypes.Date) [mappingSpec]
          withType @PostgresqlTypes.Text [mappingSpec]
          withType @PostgresqlTypes.Time [mappingSpec]
          withType @PostgresqlTypes.Timestamp [mappingSpec]
          withType @PostgresqlTypes.Timestamptz [mappingSpec]
          withType @PostgresqlTypes.Timetz [mappingSpec]
          withType @PostgresqlTypes.Uuid [mappingSpec]
          withType @(PostgresqlTypes.Varbit 0) [mappingSpec]
          withType @(PostgresqlTypes.Varbit 128) [mappingSpec]
          withType @(PostgresqlTypes.Varchar 0) [mappingSpec]
          withType @(PostgresqlTypes.Varchar 255) [mappingSpec]

      withContainer "postgres:9" do
        withConnection (Just 3) do
          withType @(PostgresqlTypes.Bit 0) [mappingSpec]
          withType @(PostgresqlTypes.Bit 1) [mappingSpec]
          withType @(PostgresqlTypes.Bit 64) [mappingSpec]
          withType @PostgresqlTypes.Bool [mappingSpec]
          withType @PostgresqlTypes.Box [mappingSpec]
          withType @PostgresqlTypes.Bytea [mappingSpec]
          withType @PostgresqlTypes.Char [mappingSpec]
          withType @(PostgresqlTypes.Bpchar 0) [mappingSpec]
          withType @(PostgresqlTypes.Bpchar 1) [mappingSpec]
          withType @(PostgresqlTypes.Bpchar 64) [mappingSpec]
          withType @PostgresqlTypes.Cidr [mappingSpec]
          withType @PostgresqlTypes.Circle [mappingSpec]
          withType @PostgresqlTypes.Date [mappingSpec]
          withType @PostgresqlTypes.Float4 [mappingSpec]
          withType @PostgresqlTypes.Float8 [mappingSpec]
          withType @PostgresqlTypes.Inet [mappingSpec]
          withType @PostgresqlTypes.Int2 [mappingSpec]
          withType @PostgresqlTypes.Int4 [mappingSpec]
          withType @PostgresqlTypes.Int8 [mappingSpec]
          withType @PostgresqlTypes.Interval [mappingSpec]
          withType @PostgresqlTypes.Json [mappingSpec]
          withType @PostgresqlTypes.Jsonb [mappingSpec]
          withType @PostgresqlTypes.Line [mappingSpec]
          withType @PostgresqlTypes.Lseg [mappingSpec]
          withType @PostgresqlTypes.Macaddr [mappingSpec]
          withType @PostgresqlTypes.Money [mappingSpec]
          withType @(PostgresqlTypes.Numeric 10 0) [mappingSpec]
          withType @(PostgresqlTypes.Numeric 10 2) [mappingSpec]
          withType @(PostgresqlTypes.Numeric 10 7) [mappingSpec]
          withType @PostgresqlTypes.Oid [mappingSpec]
          withType @PostgresqlTypes.Path [mappingSpec]
          withType @PostgresqlTypes.Point [mappingSpec]
          withType @PostgresqlTypes.Polygon [mappingSpec]
          withType @(PostgresqlTypes.Range PostgresqlTypes.Int4) [mappingSpec]
          withType @(PostgresqlTypes.Range PostgresqlTypes.Int8) [mappingSpec]
          withType @(PostgresqlTypes.Range (PostgresqlTypes.Numeric 3 3)) [mappingSpec]
          withType @(PostgresqlTypes.Range (PostgresqlTypes.Numeric 7 3)) [mappingSpec]
          withType @(PostgresqlTypes.Range (PostgresqlTypes.Numeric 7 0)) [mappingSpec]
          withType @(PostgresqlTypes.Range PostgresqlTypes.Timestamp) [mappingSpec]
          withType @(PostgresqlTypes.Range PostgresqlTypes.Timestamptz) [mappingSpec]
          withType @(PostgresqlTypes.Range PostgresqlTypes.Date) [mappingSpec]
          withType @PostgresqlTypes.Text [mappingSpec]
          withType @PostgresqlTypes.Time [mappingSpec]
          withType @PostgresqlTypes.Timestamp [mappingSpec]
          withType @PostgresqlTypes.Timestamptz [mappingSpec]
          withType @PostgresqlTypes.Timetz [mappingSpec]
          withType @PostgresqlTypes.Uuid [mappingSpec]
          withType @(PostgresqlTypes.Varbit 0) [mappingSpec]
          withType @(PostgresqlTypes.Varbit 128) [mappingSpec]
          withType @(PostgresqlTypes.Varchar 0) [mappingSpec]
          withType @(PostgresqlTypes.Varchar 255) [mappingSpec]
