-- |
-- Module      :  Data.Print.Info
-- Copyright   :  (c) OleksandrZhabenko 2020
-- License     :  MIT
-- Stability   :  Experimental
-- Maintainer  :  olexandr543@yahoo.com
--
-- Can be used to coordinate the printing output.

module Data.Print.Info where

-- | Is used to define what information is printed. The greater values correspond to more verbose output.
data Info = A | B | C | D | E | F deriving (Eq, Ord)

-- | The same as 'Info' but is used for cases of printing to the file specified as a 'String' parameter with the corresponding first capital letter 
-- analogue of 'Info' data type.
data InfoFile = Af String | Bf String | Cf String | Df String | Ef String | Ff String deriving (Eq, Ord)

data InfoG a b = I1 a | I2 b deriving Eq

-- | Type synonym used to coordinate the printing output in general case. 
type Info2 = InfoG Info InfoFile
