{-
 -      ``Data/Queue.hs''
 -      (c) 2008 Cook, J. MR  SSD, Inc.
 -
 -}
{-# LANGUAGE 
        MultiParamTypeClasses,
        FlexibleInstances,
        UndecidableInstances
  #-}

module Data.Queue
        ( NewFifo (..)
        , DefaultFifo
        
        , Enqueue (..)
        , Dequeue (..)
        , DequeueWhere (..)
        , PeekQueue (..)
        , QueueSize (..)
        
        , module Data.Queue.Instances
        
        , RQueue, mkRQueue
        , WQueue, mkWQueue
        
        ) where

import Data.Queue.Classes
import Data.Queue.Instances

-- |Construct a new FIFO of a type suitable for carrying the supplied thing.
--  Does not actually do anything with the thing supplied.
newDefaultFifoFor :: (DefaultFifo q m a, NewFifo q m) => a -> m q
newDefaultFifoFor _thing = newFifo


-- |'RQueue' : read-only newtype wrapper for arbitrary queues
newtype RQueue q = RQ q
mkRQueue :: q -> RQueue q
mkRQueue = RQ
instance Dequeue q m a => Dequeue (RQueue q) m a where
        dequeue (RQ q) = dequeue q

-- |'WQueue' : write-only newtype wrapper for arbitrary queues
newtype WQueue q = WQ q
mkWQueue :: q -> WQueue q
mkWQueue = WQ
instance Enqueue q m a => Enqueue (WQueue q) m a where
        enqueue (WQ q) = enqueue q
