# quic-simple

A set of wrappers for getting started with QUIC easier.

- `QUIC.runServer [("127.0.0.1", 14443)] \conn stream ->` -- start a generic server with random TLS credentials and auto-accept the first stream.
- `QUIC.runClient "127.0.0.1" "14443" \conn stream ->` -- start a generic client and request an initial stream.
- `(writeQ, readQ) <- QUIC.streamCodec encode decodeIncremental stream` -- convert a stream to a pair of queues.
- `(writeQ, readQ) <- QUIC.streamSerialise stream` -- run a CBOR codec over a stream.

An extra-simple pair of wrappers for QUIC and dirty RPC:

- `QUIC.runServerSimple "127.0.0.1" 14443 handleCall` -- start a CBOR server running `streamSerialise`.
- `(stop, call) <- QUIC.startClientSimple "127.0.0.1" "14443"` -- spawn a CBOR client running `streamSerialise`.

See [tests](./test/Spec.hs) for copypastable examples of different wrapping levels.
