{-|
Create wreq options with a custom HTTP manager that has increased limits to handle captive portals and proxies.

This sets:
- managerResponseTimeout to 30 seconds (prevents hanging on slow proxies)

Note: The underlying http-client library has a hardcoded 8KB limit per header line that cannot
be configured in this version. Some sites (e.g., slashdot.org with its extensive Content-Security-Policy
header listing hundreds of domains) may exceed this limit. These sites will fail with an OverlongHeaders
exception. This is a known limitation of the http-client library version in use.
-}
{-# language OverloadedStrings #-}
module HTTP.Client
    ( -- * HTTP.Client helpers
      UseDefaultHeaders(..)
    , knownMethods
    , Method
    , robustSettings
      -- * wreq re-exports
    , customMethodWith
    , customPayloadMethodWith
    , defaults
    , headers
    , responseBody
    , responseHeader
      -- * http-types re-exports
    , Header
    ) where

-- http-client
import qualified Network.HTTP.Client as HC
-- http-client-tls
import qualified Network.HTTP.Client.TLS as HCT
-- http-types
import Network.HTTP.Types.Header (Header)
-- wreq
import Network.Wreq
  ( customMethodWith
  , customPayloadMethodWith
  , defaults
  , headers
  , responseBody
  , responseHeader
  )

-- | Helper type for clarity of intention.
type Method = String

-- | Bool-ish (for now) with more descriptive names.
data UseDefaultHeaders
  = ReplaceDefaultHeaders
  | AppendCustomToDefaultHeaders
  deriving (Eq, Ord, Enum, Bounded, Show, Read)

robustSettings :: HC.ManagerSettings
robustSettings = HCT.tlsManagerSettings
        { HC.managerResponseTimeout = HC.responseTimeoutMicro 30000000  -- 30 seconds
        -- Note: managerRawConnection can be used to customize the connection,
        -- but header size limits are hardcoded in the http-client parser.
        -- The default limit is 8KB per header line. Sites like slashdot.org
        -- may exceed this with long cookie headers.
        }

{-|
Lifted from
https://en.wikipedia.org/w/index.php?title=Hypertext_Transfer_Protocol&oldid=954964381#Request_methods
-}
knownMethods :: [Method]
knownMethods =
  [ "GET"
  , "HEAD"
  , "POST"
  , "PUT"
  , "DELETE"
  , "TRACE"
  , "OPTIONS"
  , "CONNECT"
  , "PATCH"
  ]
