--------------------------------------------------------------------
-- |
-- Module    : Selenium.HUnit
-- Copyright : (c) Galois, Inc. 2007
-- License   : BSD3
--
-- Maintainer: atomb@galois.com
-- Stability : provisional
-- Portability: non-portable (multi-parameter type classes)
--
-- Integration of Selenium and HUnit. Since all HUnit tests must have
-- type IO (), this handles threading the Selenium session information
-- between tests.
--
--------------------------------------------------------------------

module Selenium.HUnit (
    runSeleniumTestsTT,
    runSeleniumTestsBare
  ) where

import Control.Monad.Reader
import Test.HUnit

import Selenium.Server

mkSeleniumTest :: Selenium () -> SeleniumRCSession -> Test
mkSeleniumTest body sel = TestCase $ do
  result <- runSelenium sel body
  either (\msg -> assertFailure msg) (\_ -> return ()) result

runSeleniumTestsTT :: [(String, Selenium ())] -> Selenium Counts
runSeleniumTestsTT tests = do
  sel <- ask
  liftIO $ runTestTT $ TestList $
    map (\(name, tst) -> name ~: mkSeleniumTest tst sel) tests

runSeleniumTestsBare :: [(String, Selenium ())] -> Selenium ()
runSeleniumTestsBare tests = mapM_ runTestBare tests
  where runTestBare (name, body) = do liftIO $ putStr (name ++ "...")
                                      body
                                      liftIO $ putStrLn "OK"
                                      
