--------------------------------------------------------------------
-- |
-- Module    : Selenium.Pretty
-- Copyright : (c) Galois, Inc. 2007
-- License   : BSD3
--
-- Maintainer: Don Stewart <dons@galois.com>
-- Stability : provisional
-- Portability:
--
-- Nice combinators for joining up flat strings into URIs.
--
--------------------------------------------------------------------

module Selenium.Pretty (
    module Text.PrettyPrint,
    (<:>), (<?>), (<=>), (<&>)
  ) where

import Text.PrettyPrint

infixl 6 <:>, <=>, <?>, <&>

join :: String -> String -> String -> String
join _ x [] = x
join s x y = x ++ s ++ y

-- | Join two strings with :
(<:>) :: String -> String -> String
(<:>) = join ":"

-- | Join two strings with =
(<=>) :: String -> String -> String
(<=>) = join "="

-- | Join two strings with ?
(<?>) :: String -> String -> String
(<?>) = join "?"

-- | Join two strings with <&>
(<&>) :: String -> String -> String
(<&>) = join "&"
