module Development.Shake.FileDetect
    ( getAts
    , getSats
    , getHats
    , getYml
    , getToml
    , getHs
    , getHappy
    , getAlex
    , getShell
    ) where

import           Control.Composition
import           Data.Semigroup      ((<>))
import           Development.Shake

getYml :: Action [FilePath]
getYml = getAll ["yaml", "yml", "yamllint"]

getToml :: Action [FilePath]
getToml = getAll ["toml"]

getHs :: [FilePath] -> Action [FilePath]
getHs files = join <$> mapM (`getAllDir` ["hs", "hs-boot", "hsig", "lhs"]) files

getHappy :: Action [FilePath]
getHappy = getAll ["y", "yl"]

getAlex :: Action [FilePath]
getAlex = getAll ["x"]

getShell :: Action [FilePath]
getShell = getAll ["sh"]

get :: String -> Action [FilePath]
get = getAll . pure

getAll :: [String] -> Action [FilePath]
getAll = getAllDir ""

getAllDir :: FilePath -> [String] -> Action [FilePath]
getAllDir dir ss = getDirectoryFiles "" (((dir ++ "//*.") ++) <$> ss)

getSats :: Action [FilePath]
getSats = get "sats"

getDats :: Action [FilePath]
getDats = get "dats"

getHats :: Action [FilePath]
getHats = get "hats"

getAts :: Action [FilePath]
getAts = (<>) <$> getDats <*> getSats
