{-# LANGUAGE BangPatterns #-}
{-# LANGUAGE OverloadedStrings #-}
{-# LANGUAGE Strict #-}
{-# LANGUAGE StrictData #-}
{-# LANGUAGE ViewPatterns #-}

module Backend.Prolog where

import Control.Monad.Except
import Control.Parallel
import Environment
import Primitives as Primitives
import Backend.Utils
import Types as Types
import Utils
import Wrap
import Backend.Toplevel
import Backend.Core
import Backend.Sys
import Backend.Sequent
import Backend.Yacc
import Backend.Reader

{-
Copyright (c) 2015, Mark Tarver
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of Mark Tarver may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY Mark Tarver ''AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Mark Tarver BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
-}

kl_shen_LBdefprologRB :: Types.KLValue ->
                         Types.KLContext Types.Env Types.KLValue
kl_shen_LBdefprologRB (!kl_V1616) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBpredicateMultRB) -> do !appl_1 <- kl_fail
                                                                                                                              !appl_2 <- appl_1 `pseq` (kl_Parse_shen_LBpredicateMultRB `pseq` eq appl_1 kl_Parse_shen_LBpredicateMultRB)
                                                                                                                              !kl_if_3 <- appl_2 `pseq` kl_not appl_2
                                                                                                                              case kl_if_3 of
                                                                                                                                  Atom (B (True)) -> do let !appl_4 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBclausesMultRB) -> do !appl_5 <- kl_fail
                                                                                                                                                                                                                                             !appl_6 <- appl_5 `pseq` (kl_Parse_shen_LBclausesMultRB `pseq` eq appl_5 kl_Parse_shen_LBclausesMultRB)
                                                                                                                                                                                                                                             !kl_if_7 <- appl_6 `pseq` kl_not appl_6
                                                                                                                                                                                                                                             case kl_if_7 of
                                                                                                                                                                                                                                                 Atom (B (True)) -> do !appl_8 <- kl_Parse_shen_LBclausesMultRB `pseq` hd kl_Parse_shen_LBclausesMultRB
                                                                                                                                                                                                                                                                       let !appl_9 = ApplC (Func "lambda" (Context (\(!kl_Parse_X) -> do !appl_10 <- kl_Parse_shen_LBpredicateMultRB `pseq` kl_shen_hdtl kl_Parse_shen_LBpredicateMultRB
                                                                                                                                                                                                                                                                                                                                         appl_10 `pseq` (kl_Parse_X `pseq` kl_shen_insert_predicate appl_10 kl_Parse_X))))
                                                                                                                                                                                                                                                                       !appl_11 <- kl_Parse_shen_LBclausesMultRB `pseq` kl_shen_hdtl kl_Parse_shen_LBclausesMultRB
                                                                                                                                                                                                                                                                       !appl_12 <- appl_9 `pseq` (appl_11 `pseq` kl_map appl_9 appl_11)
                                                                                                                                                                                                                                                                       !appl_13 <- appl_12 `pseq` kl_shen_prolog_RBshen appl_12
                                                                                                                                                                                                                                                                       !appl_14 <- appl_13 `pseq` hd appl_13
                                                                                                                                                                                                                                                                       appl_8 `pseq` (appl_14 `pseq` kl_shen_pair appl_8 appl_14)
                                                                                                                                                                                                                                                 Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                 _ -> throwError "if: expected boolean")))
                                                                                                                                                        !appl_15 <- kl_Parse_shen_LBpredicateMultRB `pseq` kl_shen_LBclausesMultRB kl_Parse_shen_LBpredicateMultRB
                                                                                                                                                        appl_15 `pseq` applyWrapper appl_4 [appl_15]
                                                                                                                                  Atom (B (False)) -> do do kl_fail
                                                                                                                                  _ -> throwError "if: expected boolean")))
                                       !appl_16 <- kl_V1616 `pseq` kl_shen_LBpredicateMultRB kl_V1616
                                       appl_16 `pseq` applyWrapper appl_0 [appl_16]

kl_shen_prolog_error :: Types.KLValue ->
                        Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_prolog_error (!kl_V1625) (!kl_V1626) = do let pat_cond_0 kl_V1626 kl_V1626h kl_V1626t kl_V1626th = do !appl_1 <- kl_V1626h `pseq` kl_shen_next_50 (Types.Atom (Types.N (Types.KI 50))) kl_V1626h
                                                                                                              let !aw_2 = Types.Atom (Types.UnboundSym "shen.app")
                                                                                                              !appl_3 <- appl_1 `pseq` applyWrapper aw_2 [appl_1,
                                                                                                                                                          Types.Atom (Types.Str "\n"),
                                                                                                                                                          Types.Atom (Types.UnboundSym "shen.a")]
                                                                                                              !appl_4 <- appl_3 `pseq` cn (Types.Atom (Types.Str " here:\n\n ")) appl_3
                                                                                                              let !aw_5 = Types.Atom (Types.UnboundSym "shen.app")
                                                                                                              !appl_6 <- kl_V1625 `pseq` (appl_4 `pseq` applyWrapper aw_5 [kl_V1625,
                                                                                                                                                                           appl_4,
                                                                                                                                                                           Types.Atom (Types.UnboundSym "shen.a")])
                                                                                                              !appl_7 <- appl_6 `pseq` cn (Types.Atom (Types.Str "prolog syntax error in ")) appl_6
                                                                                                              appl_7 `pseq` simpleError appl_7
                                                      pat_cond_8 = do do let !aw_9 = Types.Atom (Types.UnboundSym "shen.app")
                                                                         !appl_10 <- kl_V1625 `pseq` applyWrapper aw_9 [kl_V1625,
                                                                                                                        Types.Atom (Types.Str "\n"),
                                                                                                                        Types.Atom (Types.UnboundSym "shen.a")]
                                                                         !appl_11 <- appl_10 `pseq` cn (Types.Atom (Types.Str "prolog syntax error in ")) appl_10
                                                                         appl_11 `pseq` simpleError appl_11
                                                   in case kl_V1626 of
                                                          !(kl_V1626@(Cons (!kl_V1626h)
                                                                           (!(kl_V1626t@(Cons (!kl_V1626th)
                                                                                              (Atom (Nil))))))) -> pat_cond_0 kl_V1626 kl_V1626h kl_V1626t kl_V1626th
                                                          _ -> pat_cond_8

kl_shen_next_50 :: Types.KLValue ->
                   Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_next_50 (!kl_V1633) (!kl_V1634) = do let pat_cond_0 = do return (Types.Atom (Types.Str ""))
                                                 pat_cond_1 = do let pat_cond_2 = do return (Types.Atom (Types.Str ""))
                                                                     pat_cond_3 = do let pat_cond_4 kl_V1634 kl_V1634h kl_V1634t = do !appl_5 <- kl_V1634h `pseq` kl_shen_decons_string kl_V1634h
                                                                                                                                      !appl_6 <- kl_V1633 `pseq` Primitives.subtract kl_V1633 (Types.Atom (Types.N (Types.KI 1)))
                                                                                                                                      !appl_7 <- appl_6 `pseq` (kl_V1634t `pseq` kl_shen_next_50 appl_6 kl_V1634t)
                                                                                                                                      appl_5 `pseq` (appl_7 `pseq` cn appl_5 appl_7)
                                                                                         pat_cond_8 = do do let !aw_9 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                                                            applyWrapper aw_9 [ApplC (wrapNamed "shen.next-50" kl_shen_next_50)]
                                                                                      in case kl_V1634 of
                                                                                             !(kl_V1634@(Cons (!kl_V1634h)
                                                                                                              (!kl_V1634t))) -> pat_cond_4 kl_V1634 kl_V1634h kl_V1634t
                                                                                             _ -> pat_cond_8
                                                                  in case kl_V1633 of
                                                                         kl_V1633@(Atom (N (KI 0))) -> pat_cond_2
                                                                         _ -> pat_cond_3
                                              in case kl_V1634 of
                                                     kl_V1634@(Atom (Nil)) -> pat_cond_0
                                                     _ -> pat_cond_1

kl_shen_decons_string :: Types.KLValue ->
                         Types.KLContext Types.Env Types.KLValue
kl_shen_decons_string (!kl_V1636) = do let pat_cond_0 kl_V1636 kl_V1636t kl_V1636th kl_V1636tt kl_V1636tth = do !appl_1 <- kl_V1636 `pseq` kl_shen_eval_cons kl_V1636
                                                                                                                let !aw_2 = Types.Atom (Types.UnboundSym "shen.app")
                                                                                                                appl_1 `pseq` applyWrapper aw_2 [appl_1,
                                                                                                                                                 Types.Atom (Types.Str " "),
                                                                                                                                                 Types.Atom (Types.UnboundSym "shen.s")]
                                           pat_cond_3 = do do let !aw_4 = Types.Atom (Types.UnboundSym "shen.app")
                                                              kl_V1636 `pseq` applyWrapper aw_4 [kl_V1636,
                                                                                                 Types.Atom (Types.Str " "),
                                                                                                 Types.Atom (Types.UnboundSym "shen.r")]
                                        in case kl_V1636 of
                                               !(kl_V1636@(Cons (Atom (UnboundSym "cons"))
                                                                (!(kl_V1636t@(Cons (!kl_V1636th)
                                                                                   (!(kl_V1636tt@(Cons (!kl_V1636tth)
                                                                                                       (Atom (Nil)))))))))) -> pat_cond_0 kl_V1636 kl_V1636t kl_V1636th kl_V1636tt kl_V1636tth
                                               !(kl_V1636@(Cons (ApplC (PL "cons" _))
                                                                (!(kl_V1636t@(Cons (!kl_V1636th)
                                                                                   (!(kl_V1636tt@(Cons (!kl_V1636tth)
                                                                                                       (Atom (Nil)))))))))) -> pat_cond_0 kl_V1636 kl_V1636t kl_V1636th kl_V1636tt kl_V1636tth
                                               !(kl_V1636@(Cons (ApplC (Func "cons" _))
                                                                (!(kl_V1636t@(Cons (!kl_V1636th)
                                                                                   (!(kl_V1636tt@(Cons (!kl_V1636tth)
                                                                                                       (Atom (Nil)))))))))) -> pat_cond_0 kl_V1636 kl_V1636t kl_V1636th kl_V1636tt kl_V1636tth
                                               _ -> pat_cond_3

kl_shen_insert_predicate :: Types.KLValue ->
                            Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_insert_predicate (!kl_V1639) (!kl_V1640) = do let pat_cond_0 kl_V1640 kl_V1640h kl_V1640t kl_V1640th = do !appl_1 <- kl_V1639 `pseq` (kl_V1640h `pseq` klCons kl_V1639 kl_V1640h)
                                                                                                                  !appl_2 <- kl_V1640t `pseq` klCons (Types.Atom (Types.UnboundSym ":-")) kl_V1640t
                                                                                                                  appl_1 `pseq` (appl_2 `pseq` klCons appl_1 appl_2)
                                                          pat_cond_3 = do do let !aw_4 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                             applyWrapper aw_4 [ApplC (wrapNamed "shen.insert-predicate" kl_shen_insert_predicate)]
                                                       in case kl_V1640 of
                                                              !(kl_V1640@(Cons (!kl_V1640h)
                                                                               (!(kl_V1640t@(Cons (!kl_V1640th)
                                                                                                  (Atom (Nil))))))) -> pat_cond_0 kl_V1640 kl_V1640h kl_V1640t kl_V1640th
                                                              _ -> pat_cond_3

kl_shen_LBpredicateMultRB :: Types.KLValue ->
                             Types.KLContext Types.Env Types.KLValue
kl_shen_LBpredicateMultRB (!kl_V1642) = do !appl_0 <- kl_V1642 `pseq` hd kl_V1642
                                           !kl_if_1 <- appl_0 `pseq` consP appl_0
                                           case kl_if_1 of
                                               Atom (B (True)) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Parse_X) -> do !appl_3 <- kl_V1642 `pseq` hd kl_V1642
                                                                                                                                       !appl_4 <- appl_3 `pseq` tl appl_3
                                                                                                                                       !appl_5 <- kl_V1642 `pseq` kl_shen_hdtl kl_V1642
                                                                                                                                       !appl_6 <- appl_4 `pseq` (appl_5 `pseq` kl_shen_pair appl_4 appl_5)
                                                                                                                                       !appl_7 <- appl_6 `pseq` hd appl_6
                                                                                                                                       appl_7 `pseq` (kl_Parse_X `pseq` kl_shen_pair appl_7 kl_Parse_X))))
                                                                     !appl_8 <- kl_V1642 `pseq` hd kl_V1642
                                                                     !appl_9 <- appl_8 `pseq` hd appl_8
                                                                     appl_9 `pseq` applyWrapper appl_2 [appl_9]
                                               Atom (B (False)) -> do do kl_fail
                                               _ -> throwError "if: expected boolean"

kl_shen_LBclausesMultRB :: Types.KLValue ->
                           Types.KLContext Types.Env Types.KLValue
kl_shen_LBclausesMultRB (!kl_V1644) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_1 <- kl_fail
                                                                                                             !kl_if_2 <- kl_YaccParse `pseq` (appl_1 `pseq` eq kl_YaccParse appl_1)
                                                                                                             case kl_if_2 of
                                                                                                                 Atom (B (True)) -> do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_Parse_LBeRB) -> do !appl_4 <- kl_fail
                                                                                                                                                                                                             !appl_5 <- appl_4 `pseq` (kl_Parse_LBeRB `pseq` eq appl_4 kl_Parse_LBeRB)
                                                                                                                                                                                                             !kl_if_6 <- appl_5 `pseq` kl_not appl_5
                                                                                                                                                                                                             case kl_if_6 of
                                                                                                                                                                                                                 Atom (B (True)) -> do !appl_7 <- kl_Parse_LBeRB `pseq` hd kl_Parse_LBeRB
                                                                                                                                                                                                                                       appl_7 `pseq` kl_shen_pair appl_7 (Types.Atom Types.Nil)
                                                                                                                                                                                                                 Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                 _ -> throwError "if: expected boolean")))
                                                                                                                                       !appl_8 <- kl_V1644 `pseq` kl_LBeRB kl_V1644
                                                                                                                                       appl_8 `pseq` applyWrapper appl_3 [appl_8]
                                                                                                                 Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                 _ -> throwError "if: expected boolean")))
                                         let !appl_9 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBclauseMultRB) -> do !appl_10 <- kl_fail
                                                                                                                             !appl_11 <- appl_10 `pseq` (kl_Parse_shen_LBclauseMultRB `pseq` eq appl_10 kl_Parse_shen_LBclauseMultRB)
                                                                                                                             !kl_if_12 <- appl_11 `pseq` kl_not appl_11
                                                                                                                             case kl_if_12 of
                                                                                                                                 Atom (B (True)) -> do let !appl_13 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBclausesMultRB) -> do !appl_14 <- kl_fail
                                                                                                                                                                                                                                             !appl_15 <- appl_14 `pseq` (kl_Parse_shen_LBclausesMultRB `pseq` eq appl_14 kl_Parse_shen_LBclausesMultRB)
                                                                                                                                                                                                                                             !kl_if_16 <- appl_15 `pseq` kl_not appl_15
                                                                                                                                                                                                                                             case kl_if_16 of
                                                                                                                                                                                                                                                 Atom (B (True)) -> do !appl_17 <- kl_Parse_shen_LBclausesMultRB `pseq` hd kl_Parse_shen_LBclausesMultRB
                                                                                                                                                                                                                                                                       !appl_18 <- kl_Parse_shen_LBclauseMultRB `pseq` kl_shen_hdtl kl_Parse_shen_LBclauseMultRB
                                                                                                                                                                                                                                                                       !appl_19 <- kl_Parse_shen_LBclausesMultRB `pseq` kl_shen_hdtl kl_Parse_shen_LBclausesMultRB
                                                                                                                                                                                                                                                                       !appl_20 <- appl_18 `pseq` (appl_19 `pseq` klCons appl_18 appl_19)
                                                                                                                                                                                                                                                                       appl_17 `pseq` (appl_20 `pseq` kl_shen_pair appl_17 appl_20)
                                                                                                                                                                                                                                                 Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                 _ -> throwError "if: expected boolean")))
                                                                                                                                                       !appl_21 <- kl_Parse_shen_LBclauseMultRB `pseq` kl_shen_LBclausesMultRB kl_Parse_shen_LBclauseMultRB
                                                                                                                                                       appl_21 `pseq` applyWrapper appl_13 [appl_21]
                                                                                                                                 Atom (B (False)) -> do do kl_fail
                                                                                                                                 _ -> throwError "if: expected boolean")))
                                         !appl_22 <- kl_V1644 `pseq` kl_shen_LBclauseMultRB kl_V1644
                                         !appl_23 <- appl_22 `pseq` applyWrapper appl_9 [appl_22]
                                         appl_23 `pseq` applyWrapper appl_0 [appl_23]

kl_shen_LBclauseMultRB :: Types.KLValue ->
                          Types.KLContext Types.Env Types.KLValue
kl_shen_LBclauseMultRB (!kl_V1646) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBheadMultRB) -> do !appl_1 <- kl_fail
                                                                                                                          !appl_2 <- appl_1 `pseq` (kl_Parse_shen_LBheadMultRB `pseq` eq appl_1 kl_Parse_shen_LBheadMultRB)
                                                                                                                          !kl_if_3 <- appl_2 `pseq` kl_not appl_2
                                                                                                                          case kl_if_3 of
                                                                                                                              Atom (B (True)) -> do !appl_4 <- kl_Parse_shen_LBheadMultRB `pseq` hd kl_Parse_shen_LBheadMultRB
                                                                                                                                                    !kl_if_5 <- appl_4 `pseq` consP appl_4
                                                                                                                                                    !kl_if_6 <- case kl_if_5 of
                                                                                                                                                                    Atom (B (True)) -> do !appl_7 <- kl_Parse_shen_LBheadMultRB `pseq` hd kl_Parse_shen_LBheadMultRB
                                                                                                                                                                                          !appl_8 <- appl_7 `pseq` hd appl_7
                                                                                                                                                                                          !kl_if_9 <- appl_8 `pseq` eq (Types.Atom (Types.UnboundSym "<--")) appl_8
                                                                                                                                                                                          case kl_if_9 of
                                                                                                                                                                                              Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                              Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                              _ -> throwError "if: expected boolean"
                                                                                                                                                                    Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                    _ -> throwError "if: expected boolean"
                                                                                                                                                    case kl_if_6 of
                                                                                                                                                        Atom (B (True)) -> do let !appl_10 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBbodyMultRB) -> do !appl_11 <- kl_fail
                                                                                                                                                                                                                                                                 !appl_12 <- appl_11 `pseq` (kl_Parse_shen_LBbodyMultRB `pseq` eq appl_11 kl_Parse_shen_LBbodyMultRB)
                                                                                                                                                                                                                                                                 !kl_if_13 <- appl_12 `pseq` kl_not appl_12
                                                                                                                                                                                                                                                                 case kl_if_13 of
                                                                                                                                                                                                                                                                     Atom (B (True)) -> do let !appl_14 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBendMultRB) -> do !appl_15 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                             !appl_16 <- appl_15 `pseq` (kl_Parse_shen_LBendMultRB `pseq` eq appl_15 kl_Parse_shen_LBendMultRB)
                                                                                                                                                                                                                                                                                                                                                                             !kl_if_17 <- appl_16 `pseq` kl_not appl_16
                                                                                                                                                                                                                                                                                                                                                                             case kl_if_17 of
                                                                                                                                                                                                                                                                                                                                                                                 Atom (B (True)) -> do !appl_18 <- kl_Parse_shen_LBendMultRB `pseq` hd kl_Parse_shen_LBendMultRB
                                                                                                                                                                                                                                                                                                                                                                                                       !appl_19 <- kl_Parse_shen_LBheadMultRB `pseq` kl_shen_hdtl kl_Parse_shen_LBheadMultRB
                                                                                                                                                                                                                                                                                                                                                                                                       !appl_20 <- kl_Parse_shen_LBbodyMultRB `pseq` kl_shen_hdtl kl_Parse_shen_LBbodyMultRB
                                                                                                                                                                                                                                                                                                                                                                                                       !appl_21 <- appl_20 `pseq` klCons appl_20 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                                                                                                                       !appl_22 <- appl_19 `pseq` (appl_21 `pseq` klCons appl_19 appl_21)
                                                                                                                                                                                                                                                                                                                                                                                                       appl_18 `pseq` (appl_22 `pseq` kl_shen_pair appl_18 appl_22)
                                                                                                                                                                                                                                                                                                                                                                                 Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                 _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                           !appl_23 <- kl_Parse_shen_LBbodyMultRB `pseq` kl_shen_LBendMultRB kl_Parse_shen_LBbodyMultRB
                                                                                                                                                                                                                                                                                           appl_23 `pseq` applyWrapper appl_14 [appl_23]
                                                                                                                                                                                                                                                                     Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                     _ -> throwError "if: expected boolean")))
                                                                                                                                                                              !appl_24 <- kl_Parse_shen_LBheadMultRB `pseq` hd kl_Parse_shen_LBheadMultRB
                                                                                                                                                                              !appl_25 <- appl_24 `pseq` tl appl_24
                                                                                                                                                                              !appl_26 <- kl_Parse_shen_LBheadMultRB `pseq` kl_shen_hdtl kl_Parse_shen_LBheadMultRB
                                                                                                                                                                              !appl_27 <- appl_25 `pseq` (appl_26 `pseq` kl_shen_pair appl_25 appl_26)
                                                                                                                                                                              !appl_28 <- appl_27 `pseq` kl_shen_LBbodyMultRB appl_27
                                                                                                                                                                              appl_28 `pseq` applyWrapper appl_10 [appl_28]
                                                                                                                                                        Atom (B (False)) -> do do kl_fail
                                                                                                                                                        _ -> throwError "if: expected boolean"
                                                                                                                              Atom (B (False)) -> do do kl_fail
                                                                                                                              _ -> throwError "if: expected boolean")))
                                        !appl_29 <- kl_V1646 `pseq` kl_shen_LBheadMultRB kl_V1646
                                        appl_29 `pseq` applyWrapper appl_0 [appl_29]

kl_shen_LBheadMultRB :: Types.KLValue ->
                        Types.KLContext Types.Env Types.KLValue
kl_shen_LBheadMultRB (!kl_V1648) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_1 <- kl_fail
                                                                                                          !kl_if_2 <- kl_YaccParse `pseq` (appl_1 `pseq` eq kl_YaccParse appl_1)
                                                                                                          case kl_if_2 of
                                                                                                              Atom (B (True)) -> do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_Parse_LBeRB) -> do !appl_4 <- kl_fail
                                                                                                                                                                                                          !appl_5 <- appl_4 `pseq` (kl_Parse_LBeRB `pseq` eq appl_4 kl_Parse_LBeRB)
                                                                                                                                                                                                          !kl_if_6 <- appl_5 `pseq` kl_not appl_5
                                                                                                                                                                                                          case kl_if_6 of
                                                                                                                                                                                                              Atom (B (True)) -> do !appl_7 <- kl_Parse_LBeRB `pseq` hd kl_Parse_LBeRB
                                                                                                                                                                                                                                    appl_7 `pseq` kl_shen_pair appl_7 (Types.Atom Types.Nil)
                                                                                                                                                                                                              Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                              _ -> throwError "if: expected boolean")))
                                                                                                                                    !appl_8 <- kl_V1648 `pseq` kl_LBeRB kl_V1648
                                                                                                                                    appl_8 `pseq` applyWrapper appl_3 [appl_8]
                                                                                                              Atom (B (False)) -> do do return kl_YaccParse
                                                                                                              _ -> throwError "if: expected boolean")))
                                      let !appl_9 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBtermMultRB) -> do !appl_10 <- kl_fail
                                                                                                                        !appl_11 <- appl_10 `pseq` (kl_Parse_shen_LBtermMultRB `pseq` eq appl_10 kl_Parse_shen_LBtermMultRB)
                                                                                                                        !kl_if_12 <- appl_11 `pseq` kl_not appl_11
                                                                                                                        case kl_if_12 of
                                                                                                                            Atom (B (True)) -> do let !appl_13 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBheadMultRB) -> do !appl_14 <- kl_fail
                                                                                                                                                                                                                                     !appl_15 <- appl_14 `pseq` (kl_Parse_shen_LBheadMultRB `pseq` eq appl_14 kl_Parse_shen_LBheadMultRB)
                                                                                                                                                                                                                                     !kl_if_16 <- appl_15 `pseq` kl_not appl_15
                                                                                                                                                                                                                                     case kl_if_16 of
                                                                                                                                                                                                                                         Atom (B (True)) -> do !appl_17 <- kl_Parse_shen_LBheadMultRB `pseq` hd kl_Parse_shen_LBheadMultRB
                                                                                                                                                                                                                                                               !appl_18 <- kl_Parse_shen_LBtermMultRB `pseq` kl_shen_hdtl kl_Parse_shen_LBtermMultRB
                                                                                                                                                                                                                                                               !appl_19 <- kl_Parse_shen_LBheadMultRB `pseq` kl_shen_hdtl kl_Parse_shen_LBheadMultRB
                                                                                                                                                                                                                                                               !appl_20 <- appl_18 `pseq` (appl_19 `pseq` klCons appl_18 appl_19)
                                                                                                                                                                                                                                                               appl_17 `pseq` (appl_20 `pseq` kl_shen_pair appl_17 appl_20)
                                                                                                                                                                                                                                         Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                         _ -> throwError "if: expected boolean")))
                                                                                                                                                  !appl_21 <- kl_Parse_shen_LBtermMultRB `pseq` kl_shen_LBheadMultRB kl_Parse_shen_LBtermMultRB
                                                                                                                                                  appl_21 `pseq` applyWrapper appl_13 [appl_21]
                                                                                                                            Atom (B (False)) -> do do kl_fail
                                                                                                                            _ -> throwError "if: expected boolean")))
                                      !appl_22 <- kl_V1648 `pseq` kl_shen_LBtermMultRB kl_V1648
                                      !appl_23 <- appl_22 `pseq` applyWrapper appl_9 [appl_22]
                                      appl_23 `pseq` applyWrapper appl_0 [appl_23]

kl_shen_LBtermMultRB :: Types.KLValue ->
                        Types.KLContext Types.Env Types.KLValue
kl_shen_LBtermMultRB (!kl_V1650) = do !appl_0 <- kl_V1650 `pseq` hd kl_V1650
                                      !kl_if_1 <- appl_0 `pseq` consP appl_0
                                      case kl_if_1 of
                                          Atom (B (True)) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Parse_X) -> do !appl_3 <- kl_Parse_X `pseq` eq (Types.Atom (Types.UnboundSym "<--")) kl_Parse_X
                                                                                                                                  !kl_if_4 <- appl_3 `pseq` kl_not appl_3
                                                                                                                                  !kl_if_5 <- case kl_if_4 of
                                                                                                                                                  Atom (B (True)) -> do !kl_if_6 <- kl_Parse_X `pseq` kl_shen_legitimate_termP kl_Parse_X
                                                                                                                                                                        case kl_if_6 of
                                                                                                                                                                            Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                            Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                            _ -> throwError "if: expected boolean"
                                                                                                                                                  Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                  _ -> throwError "if: expected boolean"
                                                                                                                                  case kl_if_5 of
                                                                                                                                      Atom (B (True)) -> do !appl_7 <- kl_V1650 `pseq` hd kl_V1650
                                                                                                                                                            !appl_8 <- appl_7 `pseq` tl appl_7
                                                                                                                                                            !appl_9 <- kl_V1650 `pseq` kl_shen_hdtl kl_V1650
                                                                                                                                                            !appl_10 <- appl_8 `pseq` (appl_9 `pseq` kl_shen_pair appl_8 appl_9)
                                                                                                                                                            !appl_11 <- appl_10 `pseq` hd appl_10
                                                                                                                                                            !appl_12 <- kl_Parse_X `pseq` kl_shen_eval_cons kl_Parse_X
                                                                                                                                                            appl_11 `pseq` (appl_12 `pseq` kl_shen_pair appl_11 appl_12)
                                                                                                                                      Atom (B (False)) -> do do kl_fail
                                                                                                                                      _ -> throwError "if: expected boolean")))
                                                                !appl_13 <- kl_V1650 `pseq` hd kl_V1650
                                                                !appl_14 <- appl_13 `pseq` hd appl_13
                                                                appl_14 `pseq` applyWrapper appl_2 [appl_14]
                                          Atom (B (False)) -> do do kl_fail
                                          _ -> throwError "if: expected boolean"

kl_shen_legitimate_termP :: Types.KLValue ->
                            Types.KLContext Types.Env Types.KLValue
kl_shen_legitimate_termP (!kl_V1656) = do let pat_cond_0 kl_V1656 kl_V1656t kl_V1656th kl_V1656tt kl_V1656tth = do !kl_if_1 <- kl_V1656th `pseq` kl_shen_legitimate_termP kl_V1656th
                                                                                                                   case kl_if_1 of
                                                                                                                       Atom (B (True)) -> do !kl_if_2 <- kl_V1656tth `pseq` kl_shen_legitimate_termP kl_V1656tth
                                                                                                                                             case kl_if_2 of
                                                                                                                                                 Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                 Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                 _ -> throwError "if: expected boolean"
                                                                                                                       Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                       _ -> throwError "if: expected boolean"
                                              pat_cond_3 kl_V1656 kl_V1656t kl_V1656th kl_V1656tt = do kl_V1656th `pseq` kl_shen_legitimate_termP kl_V1656th
                                              pat_cond_4 kl_V1656 kl_V1656t kl_V1656th kl_V1656tt = do kl_V1656th `pseq` kl_shen_legitimate_termP kl_V1656th
                                              pat_cond_5 kl_V1656 kl_V1656h kl_V1656t = do return (Atom (B False))
                                              pat_cond_6 = do do return (Atom (B True))
                                           in case kl_V1656 of
                                                  !(kl_V1656@(Cons (Atom (UnboundSym "cons"))
                                                                   (!(kl_V1656t@(Cons (!kl_V1656th)
                                                                                      (!(kl_V1656tt@(Cons (!kl_V1656tth)
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_0 kl_V1656 kl_V1656t kl_V1656th kl_V1656tt kl_V1656tth
                                                  !(kl_V1656@(Cons (ApplC (PL "cons" _))
                                                                   (!(kl_V1656t@(Cons (!kl_V1656th)
                                                                                      (!(kl_V1656tt@(Cons (!kl_V1656tth)
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_0 kl_V1656 kl_V1656t kl_V1656th kl_V1656tt kl_V1656tth
                                                  !(kl_V1656@(Cons (ApplC (Func "cons" _))
                                                                   (!(kl_V1656t@(Cons (!kl_V1656th)
                                                                                      (!(kl_V1656tt@(Cons (!kl_V1656tth)
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_0 kl_V1656 kl_V1656t kl_V1656th kl_V1656tt kl_V1656tth
                                                  !(kl_V1656@(Cons (Atom (UnboundSym "mode"))
                                                                   (!(kl_V1656t@(Cons (!kl_V1656th)
                                                                                      (!(kl_V1656tt@(Cons (Atom (UnboundSym "+"))
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_3 kl_V1656 kl_V1656t kl_V1656th kl_V1656tt
                                                  !(kl_V1656@(Cons (Atom (UnboundSym "mode"))
                                                                   (!(kl_V1656t@(Cons (!kl_V1656th)
                                                                                      (!(kl_V1656tt@(Cons (ApplC (PL "+"
                                                                                                                     _))
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_3 kl_V1656 kl_V1656t kl_V1656th kl_V1656tt
                                                  !(kl_V1656@(Cons (Atom (UnboundSym "mode"))
                                                                   (!(kl_V1656t@(Cons (!kl_V1656th)
                                                                                      (!(kl_V1656tt@(Cons (ApplC (Func "+"
                                                                                                                       _))
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_3 kl_V1656 kl_V1656t kl_V1656th kl_V1656tt
                                                  !(kl_V1656@(Cons (ApplC (PL "mode" _))
                                                                   (!(kl_V1656t@(Cons (!kl_V1656th)
                                                                                      (!(kl_V1656tt@(Cons (Atom (UnboundSym "+"))
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_3 kl_V1656 kl_V1656t kl_V1656th kl_V1656tt
                                                  !(kl_V1656@(Cons (ApplC (PL "mode" _))
                                                                   (!(kl_V1656t@(Cons (!kl_V1656th)
                                                                                      (!(kl_V1656tt@(Cons (ApplC (PL "+"
                                                                                                                     _))
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_3 kl_V1656 kl_V1656t kl_V1656th kl_V1656tt
                                                  !(kl_V1656@(Cons (ApplC (PL "mode" _))
                                                                   (!(kl_V1656t@(Cons (!kl_V1656th)
                                                                                      (!(kl_V1656tt@(Cons (ApplC (Func "+"
                                                                                                                       _))
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_3 kl_V1656 kl_V1656t kl_V1656th kl_V1656tt
                                                  !(kl_V1656@(Cons (ApplC (Func "mode" _))
                                                                   (!(kl_V1656t@(Cons (!kl_V1656th)
                                                                                      (!(kl_V1656tt@(Cons (Atom (UnboundSym "+"))
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_3 kl_V1656 kl_V1656t kl_V1656th kl_V1656tt
                                                  !(kl_V1656@(Cons (ApplC (Func "mode" _))
                                                                   (!(kl_V1656t@(Cons (!kl_V1656th)
                                                                                      (!(kl_V1656tt@(Cons (ApplC (PL "+"
                                                                                                                     _))
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_3 kl_V1656 kl_V1656t kl_V1656th kl_V1656tt
                                                  !(kl_V1656@(Cons (ApplC (Func "mode" _))
                                                                   (!(kl_V1656t@(Cons (!kl_V1656th)
                                                                                      (!(kl_V1656tt@(Cons (ApplC (Func "+"
                                                                                                                       _))
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_3 kl_V1656 kl_V1656t kl_V1656th kl_V1656tt
                                                  !(kl_V1656@(Cons (Atom (UnboundSym "mode"))
                                                                   (!(kl_V1656t@(Cons (!kl_V1656th)
                                                                                      (!(kl_V1656tt@(Cons (Atom (UnboundSym "-"))
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_4 kl_V1656 kl_V1656t kl_V1656th kl_V1656tt
                                                  !(kl_V1656@(Cons (Atom (UnboundSym "mode"))
                                                                   (!(kl_V1656t@(Cons (!kl_V1656th)
                                                                                      (!(kl_V1656tt@(Cons (ApplC (PL "-"
                                                                                                                     _))
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_4 kl_V1656 kl_V1656t kl_V1656th kl_V1656tt
                                                  !(kl_V1656@(Cons (Atom (UnboundSym "mode"))
                                                                   (!(kl_V1656t@(Cons (!kl_V1656th)
                                                                                      (!(kl_V1656tt@(Cons (ApplC (Func "-"
                                                                                                                       _))
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_4 kl_V1656 kl_V1656t kl_V1656th kl_V1656tt
                                                  !(kl_V1656@(Cons (ApplC (PL "mode" _))
                                                                   (!(kl_V1656t@(Cons (!kl_V1656th)
                                                                                      (!(kl_V1656tt@(Cons (Atom (UnboundSym "-"))
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_4 kl_V1656 kl_V1656t kl_V1656th kl_V1656tt
                                                  !(kl_V1656@(Cons (ApplC (PL "mode" _))
                                                                   (!(kl_V1656t@(Cons (!kl_V1656th)
                                                                                      (!(kl_V1656tt@(Cons (ApplC (PL "-"
                                                                                                                     _))
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_4 kl_V1656 kl_V1656t kl_V1656th kl_V1656tt
                                                  !(kl_V1656@(Cons (ApplC (PL "mode" _))
                                                                   (!(kl_V1656t@(Cons (!kl_V1656th)
                                                                                      (!(kl_V1656tt@(Cons (ApplC (Func "-"
                                                                                                                       _))
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_4 kl_V1656 kl_V1656t kl_V1656th kl_V1656tt
                                                  !(kl_V1656@(Cons (ApplC (Func "mode" _))
                                                                   (!(kl_V1656t@(Cons (!kl_V1656th)
                                                                                      (!(kl_V1656tt@(Cons (Atom (UnboundSym "-"))
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_4 kl_V1656 kl_V1656t kl_V1656th kl_V1656tt
                                                  !(kl_V1656@(Cons (ApplC (Func "mode" _))
                                                                   (!(kl_V1656t@(Cons (!kl_V1656th)
                                                                                      (!(kl_V1656tt@(Cons (ApplC (PL "-"
                                                                                                                     _))
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_4 kl_V1656 kl_V1656t kl_V1656th kl_V1656tt
                                                  !(kl_V1656@(Cons (ApplC (Func "mode" _))
                                                                   (!(kl_V1656t@(Cons (!kl_V1656th)
                                                                                      (!(kl_V1656tt@(Cons (ApplC (Func "-"
                                                                                                                       _))
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_4 kl_V1656 kl_V1656t kl_V1656th kl_V1656tt
                                                  !(kl_V1656@(Cons (!kl_V1656h)
                                                                   (!kl_V1656t))) -> pat_cond_5 kl_V1656 kl_V1656h kl_V1656t
                                                  _ -> pat_cond_6

kl_shen_eval_cons :: Types.KLValue ->
                     Types.KLContext Types.Env Types.KLValue
kl_shen_eval_cons (!kl_V1658) = do let pat_cond_0 kl_V1658 kl_V1658t kl_V1658th kl_V1658tt kl_V1658tth = do !appl_1 <- kl_V1658th `pseq` kl_shen_eval_cons kl_V1658th
                                                                                                            !appl_2 <- kl_V1658tth `pseq` kl_shen_eval_cons kl_V1658tth
                                                                                                            appl_1 `pseq` (appl_2 `pseq` klCons appl_1 appl_2)
                                       pat_cond_3 kl_V1658 kl_V1658t kl_V1658th kl_V1658tt kl_V1658tth = do !appl_4 <- kl_V1658th `pseq` kl_shen_eval_cons kl_V1658th
                                                                                                            !appl_5 <- appl_4 `pseq` (kl_V1658tt `pseq` klCons appl_4 kl_V1658tt)
                                                                                                            appl_5 `pseq` klCons (Types.Atom (Types.UnboundSym "mode")) appl_5
                                       pat_cond_6 = do do return kl_V1658
                                    in case kl_V1658 of
                                           !(kl_V1658@(Cons (Atom (UnboundSym "cons"))
                                                            (!(kl_V1658t@(Cons (!kl_V1658th)
                                                                               (!(kl_V1658tt@(Cons (!kl_V1658tth)
                                                                                                   (Atom (Nil)))))))))) -> pat_cond_0 kl_V1658 kl_V1658t kl_V1658th kl_V1658tt kl_V1658tth
                                           !(kl_V1658@(Cons (ApplC (PL "cons" _))
                                                            (!(kl_V1658t@(Cons (!kl_V1658th)
                                                                               (!(kl_V1658tt@(Cons (!kl_V1658tth)
                                                                                                   (Atom (Nil)))))))))) -> pat_cond_0 kl_V1658 kl_V1658t kl_V1658th kl_V1658tt kl_V1658tth
                                           !(kl_V1658@(Cons (ApplC (Func "cons" _))
                                                            (!(kl_V1658t@(Cons (!kl_V1658th)
                                                                               (!(kl_V1658tt@(Cons (!kl_V1658tth)
                                                                                                   (Atom (Nil)))))))))) -> pat_cond_0 kl_V1658 kl_V1658t kl_V1658th kl_V1658tt kl_V1658tth
                                           !(kl_V1658@(Cons (Atom (UnboundSym "mode"))
                                                            (!(kl_V1658t@(Cons (!kl_V1658th)
                                                                               (!(kl_V1658tt@(Cons (!kl_V1658tth)
                                                                                                   (Atom (Nil)))))))))) -> pat_cond_3 kl_V1658 kl_V1658t kl_V1658th kl_V1658tt kl_V1658tth
                                           !(kl_V1658@(Cons (ApplC (PL "mode" _))
                                                            (!(kl_V1658t@(Cons (!kl_V1658th)
                                                                               (!(kl_V1658tt@(Cons (!kl_V1658tth)
                                                                                                   (Atom (Nil)))))))))) -> pat_cond_3 kl_V1658 kl_V1658t kl_V1658th kl_V1658tt kl_V1658tth
                                           !(kl_V1658@(Cons (ApplC (Func "mode" _))
                                                            (!(kl_V1658t@(Cons (!kl_V1658th)
                                                                               (!(kl_V1658tt@(Cons (!kl_V1658tth)
                                                                                                   (Atom (Nil)))))))))) -> pat_cond_3 kl_V1658 kl_V1658t kl_V1658th kl_V1658tt kl_V1658tth
                                           _ -> pat_cond_6

kl_shen_LBbodyMultRB :: Types.KLValue ->
                        Types.KLContext Types.Env Types.KLValue
kl_shen_LBbodyMultRB (!kl_V1660) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_1 <- kl_fail
                                                                                                          !kl_if_2 <- kl_YaccParse `pseq` (appl_1 `pseq` eq kl_YaccParse appl_1)
                                                                                                          case kl_if_2 of
                                                                                                              Atom (B (True)) -> do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_Parse_LBeRB) -> do !appl_4 <- kl_fail
                                                                                                                                                                                                          !appl_5 <- appl_4 `pseq` (kl_Parse_LBeRB `pseq` eq appl_4 kl_Parse_LBeRB)
                                                                                                                                                                                                          !kl_if_6 <- appl_5 `pseq` kl_not appl_5
                                                                                                                                                                                                          case kl_if_6 of
                                                                                                                                                                                                              Atom (B (True)) -> do !appl_7 <- kl_Parse_LBeRB `pseq` hd kl_Parse_LBeRB
                                                                                                                                                                                                                                    appl_7 `pseq` kl_shen_pair appl_7 (Types.Atom Types.Nil)
                                                                                                                                                                                                              Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                              _ -> throwError "if: expected boolean")))
                                                                                                                                    !appl_8 <- kl_V1660 `pseq` kl_LBeRB kl_V1660
                                                                                                                                    appl_8 `pseq` applyWrapper appl_3 [appl_8]
                                                                                                              Atom (B (False)) -> do do return kl_YaccParse
                                                                                                              _ -> throwError "if: expected boolean")))
                                      let !appl_9 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBliteralMultRB) -> do !appl_10 <- kl_fail
                                                                                                                           !appl_11 <- appl_10 `pseq` (kl_Parse_shen_LBliteralMultRB `pseq` eq appl_10 kl_Parse_shen_LBliteralMultRB)
                                                                                                                           !kl_if_12 <- appl_11 `pseq` kl_not appl_11
                                                                                                                           case kl_if_12 of
                                                                                                                               Atom (B (True)) -> do let !appl_13 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBbodyMultRB) -> do !appl_14 <- kl_fail
                                                                                                                                                                                                                                        !appl_15 <- appl_14 `pseq` (kl_Parse_shen_LBbodyMultRB `pseq` eq appl_14 kl_Parse_shen_LBbodyMultRB)
                                                                                                                                                                                                                                        !kl_if_16 <- appl_15 `pseq` kl_not appl_15
                                                                                                                                                                                                                                        case kl_if_16 of
                                                                                                                                                                                                                                            Atom (B (True)) -> do !appl_17 <- kl_Parse_shen_LBbodyMultRB `pseq` hd kl_Parse_shen_LBbodyMultRB
                                                                                                                                                                                                                                                                  !appl_18 <- kl_Parse_shen_LBliteralMultRB `pseq` kl_shen_hdtl kl_Parse_shen_LBliteralMultRB
                                                                                                                                                                                                                                                                  !appl_19 <- kl_Parse_shen_LBbodyMultRB `pseq` kl_shen_hdtl kl_Parse_shen_LBbodyMultRB
                                                                                                                                                                                                                                                                  !appl_20 <- appl_18 `pseq` (appl_19 `pseq` klCons appl_18 appl_19)
                                                                                                                                                                                                                                                                  appl_17 `pseq` (appl_20 `pseq` kl_shen_pair appl_17 appl_20)
                                                                                                                                                                                                                                            Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                            _ -> throwError "if: expected boolean")))
                                                                                                                                                     !appl_21 <- kl_Parse_shen_LBliteralMultRB `pseq` kl_shen_LBbodyMultRB kl_Parse_shen_LBliteralMultRB
                                                                                                                                                     appl_21 `pseq` applyWrapper appl_13 [appl_21]
                                                                                                                               Atom (B (False)) -> do do kl_fail
                                                                                                                               _ -> throwError "if: expected boolean")))
                                      !appl_22 <- kl_V1660 `pseq` kl_shen_LBliteralMultRB kl_V1660
                                      !appl_23 <- appl_22 `pseq` applyWrapper appl_9 [appl_22]
                                      appl_23 `pseq` applyWrapper appl_0 [appl_23]

kl_shen_LBliteralMultRB :: Types.KLValue ->
                           Types.KLContext Types.Env Types.KLValue
kl_shen_LBliteralMultRB (!kl_V1662) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_1 <- kl_fail
                                                                                                             !kl_if_2 <- kl_YaccParse `pseq` (appl_1 `pseq` eq kl_YaccParse appl_1)
                                                                                                             case kl_if_2 of
                                                                                                                 Atom (B (True)) -> do !appl_3 <- kl_V1662 `pseq` hd kl_V1662
                                                                                                                                       !kl_if_4 <- appl_3 `pseq` consP appl_3
                                                                                                                                       case kl_if_4 of
                                                                                                                                           Atom (B (True)) -> do let !appl_5 = ApplC (Func "lambda" (Context (\(!kl_Parse_X) -> do let pat_cond_6 kl_Parse_X kl_Parse_Xh kl_Parse_Xt = do !appl_7 <- kl_V1662 `pseq` hd kl_V1662
                                                                                                                                                                                                                                                                                          !appl_8 <- appl_7 `pseq` tl appl_7
                                                                                                                                                                                                                                                                                          !appl_9 <- kl_V1662 `pseq` kl_shen_hdtl kl_V1662
                                                                                                                                                                                                                                                                                          !appl_10 <- appl_8 `pseq` (appl_9 `pseq` kl_shen_pair appl_8 appl_9)
                                                                                                                                                                                                                                                                                          !appl_11 <- appl_10 `pseq` hd appl_10
                                                                                                                                                                                                                                                                                          appl_11 `pseq` (kl_Parse_X `pseq` kl_shen_pair appl_11 kl_Parse_X)
                                                                                                                                                                                                                                       pat_cond_12 = do do kl_fail
                                                                                                                                                                                                                                    in case kl_Parse_X of
                                                                                                                                                                                                                                           !(kl_Parse_X@(Cons (!kl_Parse_Xh)
                                                                                                                                                                                                                                                              (!kl_Parse_Xt))) -> pat_cond_6 kl_Parse_X kl_Parse_Xh kl_Parse_Xt
                                                                                                                                                                                                                                           _ -> pat_cond_12)))
                                                                                                                                                                 !appl_13 <- kl_V1662 `pseq` hd kl_V1662
                                                                                                                                                                 !appl_14 <- appl_13 `pseq` hd appl_13
                                                                                                                                                                 appl_14 `pseq` applyWrapper appl_5 [appl_14]
                                                                                                                                           Atom (B (False)) -> do do kl_fail
                                                                                                                                           _ -> throwError "if: expected boolean"
                                                                                                                 Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                 _ -> throwError "if: expected boolean")))
                                         !appl_15 <- kl_V1662 `pseq` hd kl_V1662
                                         !kl_if_16 <- appl_15 `pseq` consP appl_15
                                         !kl_if_17 <- case kl_if_16 of
                                                          Atom (B (True)) -> do !appl_18 <- kl_V1662 `pseq` hd kl_V1662
                                                                                !appl_19 <- appl_18 `pseq` hd appl_18
                                                                                !kl_if_20 <- appl_19 `pseq` eq (Types.Atom (Types.UnboundSym "!")) appl_19
                                                                                case kl_if_20 of
                                                                                    Atom (B (True)) -> do return (Atom (B True))
                                                                                    Atom (B (False)) -> do do return (Atom (B False))
                                                                                    _ -> throwError "if: expected boolean"
                                                          Atom (B (False)) -> do do return (Atom (B False))
                                                          _ -> throwError "if: expected boolean"
                                         !appl_21 <- case kl_if_17 of
                                                         Atom (B (True)) -> do !appl_22 <- kl_V1662 `pseq` hd kl_V1662
                                                                               !appl_23 <- appl_22 `pseq` tl appl_22
                                                                               !appl_24 <- kl_V1662 `pseq` kl_shen_hdtl kl_V1662
                                                                               !appl_25 <- appl_23 `pseq` (appl_24 `pseq` kl_shen_pair appl_23 appl_24)
                                                                               !appl_26 <- appl_25 `pseq` hd appl_25
                                                                               !appl_27 <- intern (Types.Atom (Types.Str "Throwcontrol"))
                                                                               !appl_28 <- appl_27 `pseq` klCons appl_27 (Types.Atom Types.Nil)
                                                                               !appl_29 <- appl_28 `pseq` klCons (ApplC (wrapNamed "cut" kl_cut)) appl_28
                                                                               appl_26 `pseq` (appl_29 `pseq` kl_shen_pair appl_26 appl_29)
                                                         Atom (B (False)) -> do do kl_fail
                                                         _ -> throwError "if: expected boolean"
                                         appl_21 `pseq` applyWrapper appl_0 [appl_21]

kl_shen_LBendMultRB :: Types.KLValue ->
                       Types.KLContext Types.Env Types.KLValue
kl_shen_LBendMultRB (!kl_V1664) = do !appl_0 <- kl_V1664 `pseq` hd kl_V1664
                                     !kl_if_1 <- appl_0 `pseq` consP appl_0
                                     case kl_if_1 of
                                         Atom (B (True)) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Parse_X) -> do let pat_cond_3 = do !appl_4 <- kl_V1664 `pseq` hd kl_V1664
                                                                                                                                                     !appl_5 <- appl_4 `pseq` tl appl_4
                                                                                                                                                     !appl_6 <- kl_V1664 `pseq` kl_shen_hdtl kl_V1664
                                                                                                                                                     !appl_7 <- appl_5 `pseq` (appl_6 `pseq` kl_shen_pair appl_5 appl_6)
                                                                                                                                                     !appl_8 <- appl_7 `pseq` hd appl_7
                                                                                                                                                     appl_8 `pseq` (kl_Parse_X `pseq` kl_shen_pair appl_8 kl_Parse_X)
                                                                                                                                     pat_cond_9 = do do kl_fail
                                                                                                                                  in case kl_Parse_X of
                                                                                                                                         kl_Parse_X@(Atom (UnboundSym ";")) -> pat_cond_3
                                                                                                                                         kl_Parse_X@(ApplC (PL ";"
                                                                                                                                                               _)) -> pat_cond_3
                                                                                                                                         kl_Parse_X@(ApplC (Func ";"
                                                                                                                                                                 _)) -> pat_cond_3
                                                                                                                                         _ -> pat_cond_9)))
                                                               !appl_10 <- kl_V1664 `pseq` hd kl_V1664
                                                               !appl_11 <- appl_10 `pseq` hd appl_10
                                                               appl_11 `pseq` applyWrapper appl_2 [appl_11]
                                         Atom (B (False)) -> do do kl_fail
                                         _ -> throwError "if: expected boolean"

kl_cut :: Types.KLValue ->
          Types.KLValue ->
          Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_cut (!kl_V1668) (!kl_V1669) (!kl_V1670) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_Result) -> do let pat_cond_1 = do return kl_V1668
                                                                                                                     pat_cond_2 = do do return kl_Result
                                                                                                                  in case kl_Result of
                                                                                                                         kl_Result@(Atom (UnboundSym "false")) -> pat_cond_1
                                                                                                                         kl_Result@(Atom (B (False))) -> pat_cond_1
                                                                                                                         _ -> pat_cond_2)))
                                                !appl_3 <- kl_V1670 `pseq` kl_thaw kl_V1670
                                                appl_3 `pseq` applyWrapper appl_0 [appl_3]

kl_shen_insert_modes :: Types.KLValue ->
                        Types.KLContext Types.Env Types.KLValue
kl_shen_insert_modes (!kl_V1672) = do let pat_cond_0 kl_V1672 kl_V1672t kl_V1672th kl_V1672tt kl_V1672tth = do return kl_V1672
                                          pat_cond_1 = do return (Types.Atom Types.Nil)
                                          pat_cond_2 kl_V1672 kl_V1672h kl_V1672t = do !appl_3 <- klCons (ApplC (wrapNamed "+" add)) (Types.Atom Types.Nil)
                                                                                       !appl_4 <- kl_V1672h `pseq` (appl_3 `pseq` klCons kl_V1672h appl_3)
                                                                                       !appl_5 <- appl_4 `pseq` klCons (Types.Atom (Types.UnboundSym "mode")) appl_4
                                                                                       !appl_6 <- kl_V1672t `pseq` kl_shen_insert_modes kl_V1672t
                                                                                       !appl_7 <- klCons (ApplC (wrapNamed "-" Primitives.subtract)) (Types.Atom Types.Nil)
                                                                                       !appl_8 <- appl_6 `pseq` (appl_7 `pseq` klCons appl_6 appl_7)
                                                                                       !appl_9 <- appl_8 `pseq` klCons (Types.Atom (Types.UnboundSym "mode")) appl_8
                                                                                       appl_5 `pseq` (appl_9 `pseq` klCons appl_5 appl_9)
                                          pat_cond_10 = do do return kl_V1672
                                       in case kl_V1672 of
                                              !(kl_V1672@(Cons (Atom (UnboundSym "mode"))
                                                               (!(kl_V1672t@(Cons (!kl_V1672th)
                                                                                  (!(kl_V1672tt@(Cons (!kl_V1672tth)
                                                                                                      (Atom (Nil)))))))))) -> pat_cond_0 kl_V1672 kl_V1672t kl_V1672th kl_V1672tt kl_V1672tth
                                              !(kl_V1672@(Cons (ApplC (PL "mode" _))
                                                               (!(kl_V1672t@(Cons (!kl_V1672th)
                                                                                  (!(kl_V1672tt@(Cons (!kl_V1672tth)
                                                                                                      (Atom (Nil)))))))))) -> pat_cond_0 kl_V1672 kl_V1672t kl_V1672th kl_V1672tt kl_V1672tth
                                              !(kl_V1672@(Cons (ApplC (Func "mode" _))
                                                               (!(kl_V1672t@(Cons (!kl_V1672th)
                                                                                  (!(kl_V1672tt@(Cons (!kl_V1672tth)
                                                                                                      (Atom (Nil)))))))))) -> pat_cond_0 kl_V1672 kl_V1672t kl_V1672th kl_V1672tt kl_V1672tth
                                              kl_V1672@(Atom (Nil)) -> pat_cond_1
                                              !(kl_V1672@(Cons (!kl_V1672h)
                                                               (!kl_V1672t))) -> pat_cond_2 kl_V1672 kl_V1672h kl_V1672t
                                              _ -> pat_cond_10

kl_shen_s_prolog :: Types.KLValue ->
                    Types.KLContext Types.Env Types.KLValue
kl_shen_s_prolog (!kl_V1674) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_X `pseq` kl_eval kl_X)))
                                  !appl_1 <- kl_V1674 `pseq` kl_shen_prolog_RBshen kl_V1674
                                  appl_0 `pseq` (appl_1 `pseq` kl_map appl_0 appl_1)

kl_shen_prolog_RBshen :: Types.KLValue ->
                         Types.KLContext Types.Env Types.KLValue
kl_shen_prolog_RBshen (!kl_V1676) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_X `pseq` kl_shen_compile_prolog_procedure kl_X)))
                                       let !appl_1 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_X `pseq` kl_shen_s_prolog_clause kl_X)))
                                       let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_X `pseq` kl_shen_head_abstraction kl_X)))
                                       !appl_3 <- appl_2 `pseq` (kl_V1676 `pseq` kl_mapcan appl_2 kl_V1676)
                                       !appl_4 <- appl_1 `pseq` (appl_3 `pseq` kl_map appl_1 appl_3)
                                       !appl_5 <- appl_4 `pseq` kl_shen_group_clauses appl_4
                                       appl_0 `pseq` (appl_5 `pseq` kl_map appl_0 appl_5)

kl_shen_s_prolog_clause :: Types.KLValue ->
                           Types.KLContext Types.Env Types.KLValue
kl_shen_s_prolog_clause (!kl_V1678) = do let pat_cond_0 kl_V1678 kl_V1678h kl_V1678t kl_V1678tt kl_V1678tth = do let !appl_1 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_X `pseq` kl_shen_s_prolog_literal kl_X)))
                                                                                                                 !appl_2 <- appl_1 `pseq` (kl_V1678tth `pseq` kl_map appl_1 kl_V1678tth)
                                                                                                                 !appl_3 <- appl_2 `pseq` klCons appl_2 (Types.Atom Types.Nil)
                                                                                                                 !appl_4 <- appl_3 `pseq` klCons (Types.Atom (Types.UnboundSym ":-")) appl_3
                                                                                                                 kl_V1678h `pseq` (appl_4 `pseq` klCons kl_V1678h appl_4)
                                             pat_cond_5 = do do let !aw_6 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                applyWrapper aw_6 [ApplC (wrapNamed "shen.s-prolog_clause" kl_shen_s_prolog_clause)]
                                          in case kl_V1678 of
                                                 !(kl_V1678@(Cons (!kl_V1678h)
                                                                  (!(kl_V1678t@(Cons (Atom (UnboundSym ":-"))
                                                                                     (!(kl_V1678tt@(Cons (!kl_V1678tth)
                                                                                                         (Atom (Nil)))))))))) -> pat_cond_0 kl_V1678 kl_V1678h kl_V1678t kl_V1678tt kl_V1678tth
                                                 !(kl_V1678@(Cons (!kl_V1678h)
                                                                  (!(kl_V1678t@(Cons (ApplC (PL ":-"
                                                                                                _))
                                                                                     (!(kl_V1678tt@(Cons (!kl_V1678tth)
                                                                                                         (Atom (Nil)))))))))) -> pat_cond_0 kl_V1678 kl_V1678h kl_V1678t kl_V1678tt kl_V1678tth
                                                 !(kl_V1678@(Cons (!kl_V1678h)
                                                                  (!(kl_V1678t@(Cons (ApplC (Func ":-"
                                                                                                  _))
                                                                                     (!(kl_V1678tt@(Cons (!kl_V1678tth)
                                                                                                         (Atom (Nil)))))))))) -> pat_cond_0 kl_V1678 kl_V1678h kl_V1678t kl_V1678tt kl_V1678tth
                                                 _ -> pat_cond_5

kl_shen_head_abstraction :: Types.KLValue ->
                            Types.KLContext Types.Env Types.KLValue
kl_shen_head_abstraction (!kl_V1680) = do !kl_if_0 <- let pat_cond_1 kl_V1680 kl_V1680h kl_V1680t = do !kl_if_2 <- let pat_cond_3 kl_V1680t kl_V1680th kl_V1680tt = do !kl_if_4 <- let pat_cond_5 = do !kl_if_6 <- let pat_cond_7 kl_V1680tt kl_V1680tth kl_V1680ttt = do !kl_if_8 <- let pat_cond_9 = do !appl_10 <- kl_V1680h `pseq` kl_shen_complexity_head kl_V1680h
                                                                                                                                                                                                                                                                                                          !appl_11 <- value (Types.Atom (Types.UnboundSym "shen.*maxcomplexity*"))
                                                                                                                                                                                                                                                                                                          !kl_if_12 <- appl_10 `pseq` (appl_11 `pseq` lessThan appl_10 appl_11)
                                                                                                                                                                                                                                                                                                          case kl_if_12 of
                                                                                                                                                                                                                                                                                                              Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                              Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                              _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                          pat_cond_13 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                       in case kl_V1680ttt of
                                                                                                                                                                                                                                                                                              kl_V1680ttt@(Atom (Nil)) -> pat_cond_9
                                                                                                                                                                                                                                                                                              _ -> pat_cond_13
                                                                                                                                                                                                                                                                          case kl_if_8 of
                                                                                                                                                                                                                                                                              Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                              Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                              _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                       pat_cond_14 = do do return (Atom (B False))
                                                                                                                                                                                                                    in case kl_V1680tt of
                                                                                                                                                                                                                           !(kl_V1680tt@(Cons (!kl_V1680tth)
                                                                                                                                                                                                                                              (!kl_V1680ttt))) -> pat_cond_7 kl_V1680tt kl_V1680tth kl_V1680ttt
                                                                                                                                                                                                                           _ -> pat_cond_14
                                                                                                                                                                                                       case kl_if_6 of
                                                                                                                                                                                                           Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                           Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                           _ -> throwError "if: expected boolean"
                                                                                                                                                                                       pat_cond_15 = do do return (Atom (B False))
                                                                                                                                                                                    in case kl_V1680th of
                                                                                                                                                                                           kl_V1680th@(Atom (UnboundSym ":-")) -> pat_cond_5
                                                                                                                                                                                           kl_V1680th@(ApplC (PL ":-"
                                                                                                                                                                                                                 _)) -> pat_cond_5
                                                                                                                                                                                           kl_V1680th@(ApplC (Func ":-"
                                                                                                                                                                                                                   _)) -> pat_cond_5
                                                                                                                                                                                           _ -> pat_cond_15
                                                                                                                                                                       case kl_if_4 of
                                                                                                                                                                           Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                           Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                           _ -> throwError "if: expected boolean"
                                                                                                                       pat_cond_16 = do do return (Atom (B False))
                                                                                                                    in case kl_V1680t of
                                                                                                                           !(kl_V1680t@(Cons (!kl_V1680th)
                                                                                                                                             (!kl_V1680tt))) -> pat_cond_3 kl_V1680t kl_V1680th kl_V1680tt
                                                                                                                           _ -> pat_cond_16
                                                                                                       case kl_if_2 of
                                                                                                           Atom (B (True)) -> do return (Atom (B True))
                                                                                                           Atom (B (False)) -> do do return (Atom (B False))
                                                                                                           _ -> throwError "if: expected boolean"
                                                          pat_cond_17 = do do return (Atom (B False))
                                                       in case kl_V1680 of
                                                              !(kl_V1680@(Cons (!kl_V1680h)
                                                                               (!kl_V1680t))) -> pat_cond_1 kl_V1680 kl_V1680h kl_V1680t
                                                              _ -> pat_cond_17
                                          case kl_if_0 of
                                              Atom (B (True)) -> do kl_V1680 `pseq` klCons kl_V1680 (Types.Atom Types.Nil)
                                              Atom (B (False)) -> do let pat_cond_18 kl_V1680 kl_V1680h kl_V1680hh kl_V1680ht kl_V1680t kl_V1680tt kl_V1680tth = do let !appl_19 = ApplC (Func "lambda" (Context (\(!kl_Terms) -> do let !appl_20 = ApplC (Func "lambda" (Context (\(!kl_XTerms) -> do let !appl_21 = ApplC (Func "lambda" (Context (\(!kl_Literal) -> do let !appl_22 = ApplC (Func "lambda" (Context (\(!kl_Clause) -> do kl_Clause `pseq` klCons kl_Clause (Types.Atom Types.Nil))))
                                                                                                                                                                                                                                                                                                                                                                          !appl_23 <- kl_V1680hh `pseq` (kl_Terms `pseq` klCons kl_V1680hh kl_Terms)
                                                                                                                                                                                                                                                                                                                                                                          !appl_24 <- kl_Literal `pseq` (kl_V1680tth `pseq` klCons kl_Literal kl_V1680tth)
                                                                                                                                                                                                                                                                                                                                                                          !appl_25 <- appl_24 `pseq` klCons appl_24 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                                                                                          !appl_26 <- appl_25 `pseq` klCons (Types.Atom (Types.UnboundSym ":-")) appl_25
                                                                                                                                                                                                                                                                                                                                                                          !appl_27 <- appl_23 `pseq` (appl_26 `pseq` klCons appl_23 appl_26)
                                                                                                                                                                                                                                                                                                                                                                          appl_27 `pseq` applyWrapper appl_22 [appl_27])))
                                                                                                                                                                                                                                                                                                       !appl_28 <- kl_Terms `pseq` kl_shen_cons_form kl_Terms
                                                                                                                                                                                                                                                                                                       !appl_29 <- kl_XTerms `pseq` klCons kl_XTerms (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                       !appl_30 <- appl_28 `pseq` (appl_29 `pseq` klCons appl_28 appl_29)
                                                                                                                                                                                                                                                                                                       !appl_31 <- appl_30 `pseq` klCons (ApplC (wrapNamed "unify" kl_unify)) appl_30
                                                                                                                                                                                                                                                                                                       appl_31 `pseq` applyWrapper appl_21 [appl_31])))
                                                                                                                                                                                                                                     !appl_32 <- kl_V1680ht `pseq` kl_shen_remove_modes kl_V1680ht
                                                                                                                                                                                                                                     !appl_33 <- appl_32 `pseq` kl_shen_rcons_form appl_32
                                                                                                                                                                                                                                     appl_33 `pseq` applyWrapper appl_20 [appl_33])))
                                                                                                                                                                    let !appl_34 = ApplC (Func "lambda" (Context (\(!kl_Y) -> do kl_gensym (Types.Atom (Types.UnboundSym "V")))))
                                                                                                                                                                    !appl_35 <- appl_34 `pseq` (kl_V1680ht `pseq` kl_map appl_34 kl_V1680ht)
                                                                                                                                                                    appl_35 `pseq` applyWrapper appl_19 [appl_35]
                                                                         pat_cond_36 = do do let !aw_37 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                                             applyWrapper aw_37 [ApplC (wrapNamed "shen.head_abstraction" kl_shen_head_abstraction)]
                                                                      in case kl_V1680 of
                                                                             !(kl_V1680@(Cons (!(kl_V1680h@(Cons (!kl_V1680hh)
                                                                                                                 (!kl_V1680ht))))
                                                                                              (!(kl_V1680t@(Cons (Atom (UnboundSym ":-"))
                                                                                                                 (!(kl_V1680tt@(Cons (!kl_V1680tth)
                                                                                                                                     (Atom (Nil)))))))))) -> pat_cond_18 kl_V1680 kl_V1680h kl_V1680hh kl_V1680ht kl_V1680t kl_V1680tt kl_V1680tth
                                                                             !(kl_V1680@(Cons (!(kl_V1680h@(Cons (!kl_V1680hh)
                                                                                                                 (!kl_V1680ht))))
                                                                                              (!(kl_V1680t@(Cons (ApplC (PL ":-"
                                                                                                                            _))
                                                                                                                 (!(kl_V1680tt@(Cons (!kl_V1680tth)
                                                                                                                                     (Atom (Nil)))))))))) -> pat_cond_18 kl_V1680 kl_V1680h kl_V1680hh kl_V1680ht kl_V1680t kl_V1680tt kl_V1680tth
                                                                             !(kl_V1680@(Cons (!(kl_V1680h@(Cons (!kl_V1680hh)
                                                                                                                 (!kl_V1680ht))))
                                                                                              (!(kl_V1680t@(Cons (ApplC (Func ":-"
                                                                                                                              _))
                                                                                                                 (!(kl_V1680tt@(Cons (!kl_V1680tth)
                                                                                                                                     (Atom (Nil)))))))))) -> pat_cond_18 kl_V1680 kl_V1680h kl_V1680hh kl_V1680ht kl_V1680t kl_V1680tt kl_V1680tth
                                                                             _ -> pat_cond_36
                                              _ -> throwError "if: expected boolean"

kl_shen_complexity_head :: Types.KLValue ->
                           Types.KLContext Types.Env Types.KLValue
kl_shen_complexity_head (!kl_V1686) = do let pat_cond_0 kl_V1686 kl_V1686h kl_V1686t = do let !appl_1 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_X `pseq` kl_shen_complexity kl_X)))
                                                                                          !appl_2 <- appl_1 `pseq` (kl_V1686t `pseq` kl_map appl_1 kl_V1686t)
                                                                                          appl_2 `pseq` kl_shen_product appl_2
                                             pat_cond_3 = do do let !aw_4 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                applyWrapper aw_4 [ApplC (wrapNamed "shen.complexity_head" kl_shen_complexity_head)]
                                          in case kl_V1686 of
                                                 !(kl_V1686@(Cons (!kl_V1686h)
                                                                  (!kl_V1686t))) -> pat_cond_0 kl_V1686 kl_V1686h kl_V1686t
                                                 _ -> pat_cond_3

kl_shen_complexity :: Types.KLValue ->
                      Types.KLContext Types.Env Types.KLValue
kl_shen_complexity (!kl_V1695) = do let pat_cond_0 kl_V1695 kl_V1695t kl_V1695th kl_V1695tht kl_V1695thth kl_V1695thtt kl_V1695thtth kl_V1695tt kl_V1695tth = do kl_V1695th `pseq` kl_shen_complexity kl_V1695th
                                        pat_cond_1 kl_V1695 kl_V1695t kl_V1695th kl_V1695thh kl_V1695tht kl_V1695tt = do !appl_2 <- kl_V1695thh `pseq` (kl_V1695tt `pseq` klCons kl_V1695thh kl_V1695tt)
                                                                                                                         !appl_3 <- appl_2 `pseq` klCons (Types.Atom (Types.UnboundSym "mode")) appl_2
                                                                                                                         !appl_4 <- appl_3 `pseq` kl_shen_complexity appl_3
                                                                                                                         !appl_5 <- kl_V1695tht `pseq` (kl_V1695tt `pseq` klCons kl_V1695tht kl_V1695tt)
                                                                                                                         !appl_6 <- appl_5 `pseq` klCons (Types.Atom (Types.UnboundSym "mode")) appl_5
                                                                                                                         !appl_7 <- appl_6 `pseq` kl_shen_complexity appl_6
                                                                                                                         !appl_8 <- appl_4 `pseq` (appl_7 `pseq` multiply appl_4 appl_7)
                                                                                                                         appl_8 `pseq` multiply (Types.Atom (Types.N (Types.KI 2))) appl_8
                                        pat_cond_9 kl_V1695 kl_V1695t kl_V1695th kl_V1695thh kl_V1695tht kl_V1695tt = do !appl_10 <- kl_V1695thh `pseq` (kl_V1695tt `pseq` klCons kl_V1695thh kl_V1695tt)
                                                                                                                         !appl_11 <- appl_10 `pseq` klCons (Types.Atom (Types.UnboundSym "mode")) appl_10
                                                                                                                         !appl_12 <- appl_11 `pseq` kl_shen_complexity appl_11
                                                                                                                         !appl_13 <- kl_V1695tht `pseq` (kl_V1695tt `pseq` klCons kl_V1695tht kl_V1695tt)
                                                                                                                         !appl_14 <- appl_13 `pseq` klCons (Types.Atom (Types.UnboundSym "mode")) appl_13
                                                                                                                         !appl_15 <- appl_14 `pseq` kl_shen_complexity appl_14
                                                                                                                         appl_12 `pseq` (appl_15 `pseq` multiply appl_12 appl_15)
                                        pat_cond_16 = do !kl_if_17 <- let pat_cond_18 kl_V1695 kl_V1695h kl_V1695t = do !kl_if_19 <- let pat_cond_20 = do !kl_if_21 <- let pat_cond_22 kl_V1695t kl_V1695th kl_V1695tt = do !kl_if_23 <- let pat_cond_24 kl_V1695tt kl_V1695tth kl_V1695ttt = do !kl_if_25 <- let pat_cond_26 = do !kl_if_27 <- kl_V1695th `pseq` kl_variableP kl_V1695th
                                                                                                                                                                                                                                                                                                                                   case kl_if_27 of
                                                                                                                                                                                                                                                                                                                                       Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                       Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                       _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                  pat_cond_28 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                               in case kl_V1695ttt of
                                                                                                                                                                                                                                                                                                                      kl_V1695ttt@(Atom (Nil)) -> pat_cond_26
                                                                                                                                                                                                                                                                                                                      _ -> pat_cond_28
                                                                                                                                                                                                                                                                                                 case kl_if_25 of
                                                                                                                                                                                                                                                                                                     Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                     Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                     _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                             pat_cond_29 = do do return (Atom (B False))
                                                                                                                                                                                                                                          in case kl_V1695tt of
                                                                                                                                                                                                                                                 !(kl_V1695tt@(Cons (!kl_V1695tth)
                                                                                                                                                                                                                                                                    (!kl_V1695ttt))) -> pat_cond_24 kl_V1695tt kl_V1695tth kl_V1695ttt
                                                                                                                                                                                                                                                 _ -> pat_cond_29
                                                                                                                                                                                                                            case kl_if_23 of
                                                                                                                                                                                                                                Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                _ -> throwError "if: expected boolean"
                                                                                                                                                                           pat_cond_30 = do do return (Atom (B False))
                                                                                                                                                                        in case kl_V1695t of
                                                                                                                                                                               !(kl_V1695t@(Cons (!kl_V1695th)
                                                                                                                                                                                                 (!kl_V1695tt))) -> pat_cond_22 kl_V1695t kl_V1695th kl_V1695tt
                                                                                                                                                                               _ -> pat_cond_30
                                                                                                                                                          case kl_if_21 of
                                                                                                                                                              Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                              Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                              _ -> throwError "if: expected boolean"
                                                                                                                                         pat_cond_31 = do do return (Atom (B False))
                                                                                                                                      in case kl_V1695h of
                                                                                                                                             kl_V1695h@(Atom (UnboundSym "mode")) -> pat_cond_20
                                                                                                                                             kl_V1695h@(ApplC (PL "mode"
                                                                                                                                                                  _)) -> pat_cond_20
                                                                                                                                             kl_V1695h@(ApplC (Func "mode"
                                                                                                                                                                    _)) -> pat_cond_20
                                                                                                                                             _ -> pat_cond_31
                                                                                                                        case kl_if_19 of
                                                                                                                            Atom (B (True)) -> do return (Atom (B True))
                                                                                                                            Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                            _ -> throwError "if: expected boolean"
                                                                          pat_cond_32 = do do return (Atom (B False))
                                                                       in case kl_V1695 of
                                                                              !(kl_V1695@(Cons (!kl_V1695h)
                                                                                               (!kl_V1695t))) -> pat_cond_18 kl_V1695 kl_V1695h kl_V1695t
                                                                              _ -> pat_cond_32
                                                         case kl_if_17 of
                                                             Atom (B (True)) -> do return (Types.Atom (Types.N (Types.KI 1)))
                                                             Atom (B (False)) -> do let pat_cond_33 kl_V1695 kl_V1695t kl_V1695th kl_V1695tt = do return (Types.Atom (Types.N (Types.KI 2)))
                                                                                        pat_cond_34 kl_V1695 kl_V1695t kl_V1695th kl_V1695tt = do return (Types.Atom (Types.N (Types.KI 1)))
                                                                                        pat_cond_35 = do do !appl_36 <- klCons (ApplC (wrapNamed "+" add)) (Types.Atom Types.Nil)
                                                                                                            !appl_37 <- kl_V1695 `pseq` (appl_36 `pseq` klCons kl_V1695 appl_36)
                                                                                                            !appl_38 <- appl_37 `pseq` klCons (Types.Atom (Types.UnboundSym "mode")) appl_37
                                                                                                            appl_38 `pseq` kl_shen_complexity appl_38
                                                                                     in case kl_V1695 of
                                                                                            !(kl_V1695@(Cons (Atom (UnboundSym "mode"))
                                                                                                             (!(kl_V1695t@(Cons (!kl_V1695th)
                                                                                                                                (!(kl_V1695tt@(Cons (Atom (UnboundSym "+"))
                                                                                                                                                    (Atom (Nil)))))))))) -> pat_cond_33 kl_V1695 kl_V1695t kl_V1695th kl_V1695tt
                                                                                            !(kl_V1695@(Cons (Atom (UnboundSym "mode"))
                                                                                                             (!(kl_V1695t@(Cons (!kl_V1695th)
                                                                                                                                (!(kl_V1695tt@(Cons (ApplC (PL "+"
                                                                                                                                                               _))
                                                                                                                                                    (Atom (Nil)))))))))) -> pat_cond_33 kl_V1695 kl_V1695t kl_V1695th kl_V1695tt
                                                                                            !(kl_V1695@(Cons (Atom (UnboundSym "mode"))
                                                                                                             (!(kl_V1695t@(Cons (!kl_V1695th)
                                                                                                                                (!(kl_V1695tt@(Cons (ApplC (Func "+"
                                                                                                                                                                 _))
                                                                                                                                                    (Atom (Nil)))))))))) -> pat_cond_33 kl_V1695 kl_V1695t kl_V1695th kl_V1695tt
                                                                                            !(kl_V1695@(Cons (ApplC (PL "mode"
                                                                                                                        _))
                                                                                                             (!(kl_V1695t@(Cons (!kl_V1695th)
                                                                                                                                (!(kl_V1695tt@(Cons (Atom (UnboundSym "+"))
                                                                                                                                                    (Atom (Nil)))))))))) -> pat_cond_33 kl_V1695 kl_V1695t kl_V1695th kl_V1695tt
                                                                                            !(kl_V1695@(Cons (ApplC (PL "mode"
                                                                                                                        _))
                                                                                                             (!(kl_V1695t@(Cons (!kl_V1695th)
                                                                                                                                (!(kl_V1695tt@(Cons (ApplC (PL "+"
                                                                                                                                                               _))
                                                                                                                                                    (Atom (Nil)))))))))) -> pat_cond_33 kl_V1695 kl_V1695t kl_V1695th kl_V1695tt
                                                                                            !(kl_V1695@(Cons (ApplC (PL "mode"
                                                                                                                        _))
                                                                                                             (!(kl_V1695t@(Cons (!kl_V1695th)
                                                                                                                                (!(kl_V1695tt@(Cons (ApplC (Func "+"
                                                                                                                                                                 _))
                                                                                                                                                    (Atom (Nil)))))))))) -> pat_cond_33 kl_V1695 kl_V1695t kl_V1695th kl_V1695tt
                                                                                            !(kl_V1695@(Cons (ApplC (Func "mode"
                                                                                                                          _))
                                                                                                             (!(kl_V1695t@(Cons (!kl_V1695th)
                                                                                                                                (!(kl_V1695tt@(Cons (Atom (UnboundSym "+"))
                                                                                                                                                    (Atom (Nil)))))))))) -> pat_cond_33 kl_V1695 kl_V1695t kl_V1695th kl_V1695tt
                                                                                            !(kl_V1695@(Cons (ApplC (Func "mode"
                                                                                                                          _))
                                                                                                             (!(kl_V1695t@(Cons (!kl_V1695th)
                                                                                                                                (!(kl_V1695tt@(Cons (ApplC (PL "+"
                                                                                                                                                               _))
                                                                                                                                                    (Atom (Nil)))))))))) -> pat_cond_33 kl_V1695 kl_V1695t kl_V1695th kl_V1695tt
                                                                                            !(kl_V1695@(Cons (ApplC (Func "mode"
                                                                                                                          _))
                                                                                                             (!(kl_V1695t@(Cons (!kl_V1695th)
                                                                                                                                (!(kl_V1695tt@(Cons (ApplC (Func "+"
                                                                                                                                                                 _))
                                                                                                                                                    (Atom (Nil)))))))))) -> pat_cond_33 kl_V1695 kl_V1695t kl_V1695th kl_V1695tt
                                                                                            !(kl_V1695@(Cons (Atom (UnboundSym "mode"))
                                                                                                             (!(kl_V1695t@(Cons (!kl_V1695th)
                                                                                                                                (!(kl_V1695tt@(Cons (Atom (UnboundSym "-"))
                                                                                                                                                    (Atom (Nil)))))))))) -> pat_cond_34 kl_V1695 kl_V1695t kl_V1695th kl_V1695tt
                                                                                            !(kl_V1695@(Cons (Atom (UnboundSym "mode"))
                                                                                                             (!(kl_V1695t@(Cons (!kl_V1695th)
                                                                                                                                (!(kl_V1695tt@(Cons (ApplC (PL "-"
                                                                                                                                                               _))
                                                                                                                                                    (Atom (Nil)))))))))) -> pat_cond_34 kl_V1695 kl_V1695t kl_V1695th kl_V1695tt
                                                                                            !(kl_V1695@(Cons (Atom (UnboundSym "mode"))
                                                                                                             (!(kl_V1695t@(Cons (!kl_V1695th)
                                                                                                                                (!(kl_V1695tt@(Cons (ApplC (Func "-"
                                                                                                                                                                 _))
                                                                                                                                                    (Atom (Nil)))))))))) -> pat_cond_34 kl_V1695 kl_V1695t kl_V1695th kl_V1695tt
                                                                                            !(kl_V1695@(Cons (ApplC (PL "mode"
                                                                                                                        _))
                                                                                                             (!(kl_V1695t@(Cons (!kl_V1695th)
                                                                                                                                (!(kl_V1695tt@(Cons (Atom (UnboundSym "-"))
                                                                                                                                                    (Atom (Nil)))))))))) -> pat_cond_34 kl_V1695 kl_V1695t kl_V1695th kl_V1695tt
                                                                                            !(kl_V1695@(Cons (ApplC (PL "mode"
                                                                                                                        _))
                                                                                                             (!(kl_V1695t@(Cons (!kl_V1695th)
                                                                                                                                (!(kl_V1695tt@(Cons (ApplC (PL "-"
                                                                                                                                                               _))
                                                                                                                                                    (Atom (Nil)))))))))) -> pat_cond_34 kl_V1695 kl_V1695t kl_V1695th kl_V1695tt
                                                                                            !(kl_V1695@(Cons (ApplC (PL "mode"
                                                                                                                        _))
                                                                                                             (!(kl_V1695t@(Cons (!kl_V1695th)
                                                                                                                                (!(kl_V1695tt@(Cons (ApplC (Func "-"
                                                                                                                                                                 _))
                                                                                                                                                    (Atom (Nil)))))))))) -> pat_cond_34 kl_V1695 kl_V1695t kl_V1695th kl_V1695tt
                                                                                            !(kl_V1695@(Cons (ApplC (Func "mode"
                                                                                                                          _))
                                                                                                             (!(kl_V1695t@(Cons (!kl_V1695th)
                                                                                                                                (!(kl_V1695tt@(Cons (Atom (UnboundSym "-"))
                                                                                                                                                    (Atom (Nil)))))))))) -> pat_cond_34 kl_V1695 kl_V1695t kl_V1695th kl_V1695tt
                                                                                            !(kl_V1695@(Cons (ApplC (Func "mode"
                                                                                                                          _))
                                                                                                             (!(kl_V1695t@(Cons (!kl_V1695th)
                                                                                                                                (!(kl_V1695tt@(Cons (ApplC (PL "-"
                                                                                                                                                               _))
                                                                                                                                                    (Atom (Nil)))))))))) -> pat_cond_34 kl_V1695 kl_V1695t kl_V1695th kl_V1695tt
                                                                                            !(kl_V1695@(Cons (ApplC (Func "mode"
                                                                                                                          _))
                                                                                                             (!(kl_V1695t@(Cons (!kl_V1695th)
                                                                                                                                (!(kl_V1695tt@(Cons (ApplC (Func "-"
                                                                                                                                                                 _))
                                                                                                                                                    (Atom (Nil)))))))))) -> pat_cond_34 kl_V1695 kl_V1695t kl_V1695th kl_V1695tt
                                                                                            _ -> pat_cond_35
                                                             _ -> throwError "if: expected boolean"
                                     in case kl_V1695 of
                                            !(kl_V1695@(Cons (Atom (UnboundSym "mode"))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (Atom (UnboundSym "mode"))
                                                                                                    (!(kl_V1695tht@(Cons (!kl_V1695thth)
                                                                                                                         (!(kl_V1695thtt@(Cons (!kl_V1695thtth)
                                                                                                                                               (Atom (Nil)))))))))))
                                                                                (!(kl_V1695tt@(Cons (!kl_V1695tth)
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_0 kl_V1695 kl_V1695t kl_V1695th kl_V1695tht kl_V1695thth kl_V1695thtt kl_V1695thtth kl_V1695tt kl_V1695tth
                                            !(kl_V1695@(Cons (Atom (UnboundSym "mode"))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (ApplC (PL "mode"
                                                                                                               _))
                                                                                                    (!(kl_V1695tht@(Cons (!kl_V1695thth)
                                                                                                                         (!(kl_V1695thtt@(Cons (!kl_V1695thtth)
                                                                                                                                               (Atom (Nil)))))))))))
                                                                                (!(kl_V1695tt@(Cons (!kl_V1695tth)
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_0 kl_V1695 kl_V1695t kl_V1695th kl_V1695tht kl_V1695thth kl_V1695thtt kl_V1695thtth kl_V1695tt kl_V1695tth
                                            !(kl_V1695@(Cons (Atom (UnboundSym "mode"))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (ApplC (Func "mode"
                                                                                                                 _))
                                                                                                    (!(kl_V1695tht@(Cons (!kl_V1695thth)
                                                                                                                         (!(kl_V1695thtt@(Cons (!kl_V1695thtth)
                                                                                                                                               (Atom (Nil)))))))))))
                                                                                (!(kl_V1695tt@(Cons (!kl_V1695tth)
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_0 kl_V1695 kl_V1695t kl_V1695th kl_V1695tht kl_V1695thth kl_V1695thtt kl_V1695thtth kl_V1695tt kl_V1695tth
                                            !(kl_V1695@(Cons (ApplC (PL "mode" _))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (Atom (UnboundSym "mode"))
                                                                                                    (!(kl_V1695tht@(Cons (!kl_V1695thth)
                                                                                                                         (!(kl_V1695thtt@(Cons (!kl_V1695thtth)
                                                                                                                                               (Atom (Nil)))))))))))
                                                                                (!(kl_V1695tt@(Cons (!kl_V1695tth)
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_0 kl_V1695 kl_V1695t kl_V1695th kl_V1695tht kl_V1695thth kl_V1695thtt kl_V1695thtth kl_V1695tt kl_V1695tth
                                            !(kl_V1695@(Cons (ApplC (PL "mode" _))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (ApplC (PL "mode"
                                                                                                               _))
                                                                                                    (!(kl_V1695tht@(Cons (!kl_V1695thth)
                                                                                                                         (!(kl_V1695thtt@(Cons (!kl_V1695thtth)
                                                                                                                                               (Atom (Nil)))))))))))
                                                                                (!(kl_V1695tt@(Cons (!kl_V1695tth)
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_0 kl_V1695 kl_V1695t kl_V1695th kl_V1695tht kl_V1695thth kl_V1695thtt kl_V1695thtth kl_V1695tt kl_V1695tth
                                            !(kl_V1695@(Cons (ApplC (PL "mode" _))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (ApplC (Func "mode"
                                                                                                                 _))
                                                                                                    (!(kl_V1695tht@(Cons (!kl_V1695thth)
                                                                                                                         (!(kl_V1695thtt@(Cons (!kl_V1695thtth)
                                                                                                                                               (Atom (Nil)))))))))))
                                                                                (!(kl_V1695tt@(Cons (!kl_V1695tth)
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_0 kl_V1695 kl_V1695t kl_V1695th kl_V1695tht kl_V1695thth kl_V1695thtt kl_V1695thtth kl_V1695tt kl_V1695tth
                                            !(kl_V1695@(Cons (ApplC (Func "mode" _))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (Atom (UnboundSym "mode"))
                                                                                                    (!(kl_V1695tht@(Cons (!kl_V1695thth)
                                                                                                                         (!(kl_V1695thtt@(Cons (!kl_V1695thtth)
                                                                                                                                               (Atom (Nil)))))))))))
                                                                                (!(kl_V1695tt@(Cons (!kl_V1695tth)
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_0 kl_V1695 kl_V1695t kl_V1695th kl_V1695tht kl_V1695thth kl_V1695thtt kl_V1695thtth kl_V1695tt kl_V1695tth
                                            !(kl_V1695@(Cons (ApplC (Func "mode" _))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (ApplC (PL "mode"
                                                                                                               _))
                                                                                                    (!(kl_V1695tht@(Cons (!kl_V1695thth)
                                                                                                                         (!(kl_V1695thtt@(Cons (!kl_V1695thtth)
                                                                                                                                               (Atom (Nil)))))))))))
                                                                                (!(kl_V1695tt@(Cons (!kl_V1695tth)
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_0 kl_V1695 kl_V1695t kl_V1695th kl_V1695tht kl_V1695thth kl_V1695thtt kl_V1695thtth kl_V1695tt kl_V1695tth
                                            !(kl_V1695@(Cons (ApplC (Func "mode" _))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (ApplC (Func "mode"
                                                                                                                 _))
                                                                                                    (!(kl_V1695tht@(Cons (!kl_V1695thth)
                                                                                                                         (!(kl_V1695thtt@(Cons (!kl_V1695thtth)
                                                                                                                                               (Atom (Nil)))))))))))
                                                                                (!(kl_V1695tt@(Cons (!kl_V1695tth)
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_0 kl_V1695 kl_V1695t kl_V1695th kl_V1695tht kl_V1695thth kl_V1695thtt kl_V1695thtth kl_V1695tt kl_V1695tth
                                            !(kl_V1695@(Cons (Atom (UnboundSym "mode"))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (!kl_V1695thh)
                                                                                                    (!kl_V1695tht))))
                                                                                (!(kl_V1695tt@(Cons (Atom (UnboundSym "+"))
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_1 kl_V1695 kl_V1695t kl_V1695th kl_V1695thh kl_V1695tht kl_V1695tt
                                            !(kl_V1695@(Cons (Atom (UnboundSym "mode"))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (!kl_V1695thh)
                                                                                                    (!kl_V1695tht))))
                                                                                (!(kl_V1695tt@(Cons (ApplC (PL "+"
                                                                                                               _))
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_1 kl_V1695 kl_V1695t kl_V1695th kl_V1695thh kl_V1695tht kl_V1695tt
                                            !(kl_V1695@(Cons (Atom (UnboundSym "mode"))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (!kl_V1695thh)
                                                                                                    (!kl_V1695tht))))
                                                                                (!(kl_V1695tt@(Cons (ApplC (Func "+"
                                                                                                                 _))
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_1 kl_V1695 kl_V1695t kl_V1695th kl_V1695thh kl_V1695tht kl_V1695tt
                                            !(kl_V1695@(Cons (ApplC (PL "mode" _))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (!kl_V1695thh)
                                                                                                    (!kl_V1695tht))))
                                                                                (!(kl_V1695tt@(Cons (Atom (UnboundSym "+"))
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_1 kl_V1695 kl_V1695t kl_V1695th kl_V1695thh kl_V1695tht kl_V1695tt
                                            !(kl_V1695@(Cons (ApplC (PL "mode" _))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (!kl_V1695thh)
                                                                                                    (!kl_V1695tht))))
                                                                                (!(kl_V1695tt@(Cons (ApplC (PL "+"
                                                                                                               _))
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_1 kl_V1695 kl_V1695t kl_V1695th kl_V1695thh kl_V1695tht kl_V1695tt
                                            !(kl_V1695@(Cons (ApplC (PL "mode" _))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (!kl_V1695thh)
                                                                                                    (!kl_V1695tht))))
                                                                                (!(kl_V1695tt@(Cons (ApplC (Func "+"
                                                                                                                 _))
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_1 kl_V1695 kl_V1695t kl_V1695th kl_V1695thh kl_V1695tht kl_V1695tt
                                            !(kl_V1695@(Cons (ApplC (Func "mode" _))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (!kl_V1695thh)
                                                                                                    (!kl_V1695tht))))
                                                                                (!(kl_V1695tt@(Cons (Atom (UnboundSym "+"))
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_1 kl_V1695 kl_V1695t kl_V1695th kl_V1695thh kl_V1695tht kl_V1695tt
                                            !(kl_V1695@(Cons (ApplC (Func "mode" _))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (!kl_V1695thh)
                                                                                                    (!kl_V1695tht))))
                                                                                (!(kl_V1695tt@(Cons (ApplC (PL "+"
                                                                                                               _))
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_1 kl_V1695 kl_V1695t kl_V1695th kl_V1695thh kl_V1695tht kl_V1695tt
                                            !(kl_V1695@(Cons (ApplC (Func "mode" _))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (!kl_V1695thh)
                                                                                                    (!kl_V1695tht))))
                                                                                (!(kl_V1695tt@(Cons (ApplC (Func "+"
                                                                                                                 _))
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_1 kl_V1695 kl_V1695t kl_V1695th kl_V1695thh kl_V1695tht kl_V1695tt
                                            !(kl_V1695@(Cons (Atom (UnboundSym "mode"))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (!kl_V1695thh)
                                                                                                    (!kl_V1695tht))))
                                                                                (!(kl_V1695tt@(Cons (Atom (UnboundSym "-"))
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_9 kl_V1695 kl_V1695t kl_V1695th kl_V1695thh kl_V1695tht kl_V1695tt
                                            !(kl_V1695@(Cons (Atom (UnboundSym "mode"))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (!kl_V1695thh)
                                                                                                    (!kl_V1695tht))))
                                                                                (!(kl_V1695tt@(Cons (ApplC (PL "-"
                                                                                                               _))
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_9 kl_V1695 kl_V1695t kl_V1695th kl_V1695thh kl_V1695tht kl_V1695tt
                                            !(kl_V1695@(Cons (Atom (UnboundSym "mode"))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (!kl_V1695thh)
                                                                                                    (!kl_V1695tht))))
                                                                                (!(kl_V1695tt@(Cons (ApplC (Func "-"
                                                                                                                 _))
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_9 kl_V1695 kl_V1695t kl_V1695th kl_V1695thh kl_V1695tht kl_V1695tt
                                            !(kl_V1695@(Cons (ApplC (PL "mode" _))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (!kl_V1695thh)
                                                                                                    (!kl_V1695tht))))
                                                                                (!(kl_V1695tt@(Cons (Atom (UnboundSym "-"))
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_9 kl_V1695 kl_V1695t kl_V1695th kl_V1695thh kl_V1695tht kl_V1695tt
                                            !(kl_V1695@(Cons (ApplC (PL "mode" _))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (!kl_V1695thh)
                                                                                                    (!kl_V1695tht))))
                                                                                (!(kl_V1695tt@(Cons (ApplC (PL "-"
                                                                                                               _))
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_9 kl_V1695 kl_V1695t kl_V1695th kl_V1695thh kl_V1695tht kl_V1695tt
                                            !(kl_V1695@(Cons (ApplC (PL "mode" _))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (!kl_V1695thh)
                                                                                                    (!kl_V1695tht))))
                                                                                (!(kl_V1695tt@(Cons (ApplC (Func "-"
                                                                                                                 _))
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_9 kl_V1695 kl_V1695t kl_V1695th kl_V1695thh kl_V1695tht kl_V1695tt
                                            !(kl_V1695@(Cons (ApplC (Func "mode" _))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (!kl_V1695thh)
                                                                                                    (!kl_V1695tht))))
                                                                                (!(kl_V1695tt@(Cons (Atom (UnboundSym "-"))
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_9 kl_V1695 kl_V1695t kl_V1695th kl_V1695thh kl_V1695tht kl_V1695tt
                                            !(kl_V1695@(Cons (ApplC (Func "mode" _))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (!kl_V1695thh)
                                                                                                    (!kl_V1695tht))))
                                                                                (!(kl_V1695tt@(Cons (ApplC (PL "-"
                                                                                                               _))
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_9 kl_V1695 kl_V1695t kl_V1695th kl_V1695thh kl_V1695tht kl_V1695tt
                                            !(kl_V1695@(Cons (ApplC (Func "mode" _))
                                                             (!(kl_V1695t@(Cons (!(kl_V1695th@(Cons (!kl_V1695thh)
                                                                                                    (!kl_V1695tht))))
                                                                                (!(kl_V1695tt@(Cons (ApplC (Func "-"
                                                                                                                 _))
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_9 kl_V1695 kl_V1695t kl_V1695th kl_V1695thh kl_V1695tht kl_V1695tt
                                            _ -> pat_cond_16

kl_shen_product :: Types.KLValue ->
                   Types.KLContext Types.Env Types.KLValue
kl_shen_product (!kl_V1697) = do let pat_cond_0 = do return (Types.Atom (Types.N (Types.KI 1)))
                                     pat_cond_1 kl_V1697 kl_V1697h kl_V1697t = do !appl_2 <- kl_V1697t `pseq` kl_shen_product kl_V1697t
                                                                                  kl_V1697h `pseq` (appl_2 `pseq` multiply kl_V1697h appl_2)
                                     pat_cond_3 = do do let !aw_4 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                        applyWrapper aw_4 [ApplC (wrapNamed "shen.product" kl_shen_product)]
                                  in case kl_V1697 of
                                         kl_V1697@(Atom (Nil)) -> pat_cond_0
                                         !(kl_V1697@(Cons (!kl_V1697h)
                                                          (!kl_V1697t))) -> pat_cond_1 kl_V1697 kl_V1697h kl_V1697t
                                         _ -> pat_cond_3

kl_shen_s_prolog_literal :: Types.KLValue ->
                            Types.KLContext Types.Env Types.KLValue
kl_shen_s_prolog_literal (!kl_V1699) = do let pat_cond_0 kl_V1699 kl_V1699t kl_V1699th kl_V1699tt kl_V1699tth = do !appl_1 <- kl_V1699tth `pseq` kl_shen_insert_deref kl_V1699tth
                                                                                                                   !appl_2 <- appl_1 `pseq` klCons appl_1 (Types.Atom Types.Nil)
                                                                                                                   !appl_3 <- kl_V1699th `pseq` (appl_2 `pseq` klCons kl_V1699th appl_2)
                                                                                                                   appl_3 `pseq` klCons (ApplC (wrapNamed "bind" kl_bind)) appl_3
                                              pat_cond_4 kl_V1699 kl_V1699t kl_V1699th = do !appl_5 <- kl_V1699th `pseq` kl_shen_insert_deref kl_V1699th
                                                                                            !appl_6 <- appl_5 `pseq` klCons appl_5 (Types.Atom Types.Nil)
                                                                                            appl_6 `pseq` klCons (ApplC (wrapNamed "fwhen" kl_fwhen)) appl_6
                                              pat_cond_7 kl_V1699 kl_V1699t kl_V1699th kl_V1699tt kl_V1699tth = do !appl_8 <- kl_V1699tth `pseq` kl_shen_insert_lazyderef kl_V1699tth
                                                                                                                   !appl_9 <- appl_8 `pseq` klCons appl_8 (Types.Atom Types.Nil)
                                                                                                                   !appl_10 <- kl_V1699th `pseq` (appl_9 `pseq` klCons kl_V1699th appl_9)
                                                                                                                   appl_10 `pseq` klCons (ApplC (wrapNamed "bind" kl_bind)) appl_10
                                              pat_cond_11 kl_V1699 kl_V1699t kl_V1699th = do !appl_12 <- kl_V1699th `pseq` kl_shen_insert_lazyderef kl_V1699th
                                                                                             !appl_13 <- appl_12 `pseq` klCons appl_12 (Types.Atom Types.Nil)
                                                                                             appl_13 `pseq` klCons (ApplC (wrapNamed "fwhen" kl_fwhen)) appl_13
                                              pat_cond_14 kl_V1699 kl_V1699h kl_V1699t = do return kl_V1699
                                              pat_cond_15 = do do let !aw_16 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                  applyWrapper aw_16 [ApplC (wrapNamed "shen.s-prolog_literal" kl_shen_s_prolog_literal)]
                                           in case kl_V1699 of
                                                  !(kl_V1699@(Cons (Atom (UnboundSym "is"))
                                                                   (!(kl_V1699t@(Cons (!kl_V1699th)
                                                                                      (!(kl_V1699tt@(Cons (!kl_V1699tth)
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_0 kl_V1699 kl_V1699t kl_V1699th kl_V1699tt kl_V1699tth
                                                  !(kl_V1699@(Cons (ApplC (PL "is" _))
                                                                   (!(kl_V1699t@(Cons (!kl_V1699th)
                                                                                      (!(kl_V1699tt@(Cons (!kl_V1699tth)
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_0 kl_V1699 kl_V1699t kl_V1699th kl_V1699tt kl_V1699tth
                                                  !(kl_V1699@(Cons (ApplC (Func "is" _))
                                                                   (!(kl_V1699t@(Cons (!kl_V1699th)
                                                                                      (!(kl_V1699tt@(Cons (!kl_V1699tth)
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_0 kl_V1699 kl_V1699t kl_V1699th kl_V1699tt kl_V1699tth
                                                  !(kl_V1699@(Cons (Atom (UnboundSym "when"))
                                                                   (!(kl_V1699t@(Cons (!kl_V1699th)
                                                                                      (Atom (Nil))))))) -> pat_cond_4 kl_V1699 kl_V1699t kl_V1699th
                                                  !(kl_V1699@(Cons (ApplC (PL "when" _))
                                                                   (!(kl_V1699t@(Cons (!kl_V1699th)
                                                                                      (Atom (Nil))))))) -> pat_cond_4 kl_V1699 kl_V1699t kl_V1699th
                                                  !(kl_V1699@(Cons (ApplC (Func "when" _))
                                                                   (!(kl_V1699t@(Cons (!kl_V1699th)
                                                                                      (Atom (Nil))))))) -> pat_cond_4 kl_V1699 kl_V1699t kl_V1699th
                                                  !(kl_V1699@(Cons (Atom (UnboundSym "bind"))
                                                                   (!(kl_V1699t@(Cons (!kl_V1699th)
                                                                                      (!(kl_V1699tt@(Cons (!kl_V1699tth)
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_7 kl_V1699 kl_V1699t kl_V1699th kl_V1699tt kl_V1699tth
                                                  !(kl_V1699@(Cons (ApplC (PL "bind" _))
                                                                   (!(kl_V1699t@(Cons (!kl_V1699th)
                                                                                      (!(kl_V1699tt@(Cons (!kl_V1699tth)
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_7 kl_V1699 kl_V1699t kl_V1699th kl_V1699tt kl_V1699tth
                                                  !(kl_V1699@(Cons (ApplC (Func "bind" _))
                                                                   (!(kl_V1699t@(Cons (!kl_V1699th)
                                                                                      (!(kl_V1699tt@(Cons (!kl_V1699tth)
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_7 kl_V1699 kl_V1699t kl_V1699th kl_V1699tt kl_V1699tth
                                                  !(kl_V1699@(Cons (Atom (UnboundSym "fwhen"))
                                                                   (!(kl_V1699t@(Cons (!kl_V1699th)
                                                                                      (Atom (Nil))))))) -> pat_cond_11 kl_V1699 kl_V1699t kl_V1699th
                                                  !(kl_V1699@(Cons (ApplC (PL "fwhen" _))
                                                                   (!(kl_V1699t@(Cons (!kl_V1699th)
                                                                                      (Atom (Nil))))))) -> pat_cond_11 kl_V1699 kl_V1699t kl_V1699th
                                                  !(kl_V1699@(Cons (ApplC (Func "fwhen" _))
                                                                   (!(kl_V1699t@(Cons (!kl_V1699th)
                                                                                      (Atom (Nil))))))) -> pat_cond_11 kl_V1699 kl_V1699t kl_V1699th
                                                  !(kl_V1699@(Cons (!kl_V1699h)
                                                                   (!kl_V1699t))) -> pat_cond_14 kl_V1699 kl_V1699h kl_V1699t
                                                  _ -> pat_cond_15

kl_shen_insert_deref :: Types.KLValue ->
                        Types.KLContext Types.Env Types.KLValue
kl_shen_insert_deref (!kl_V1701) = do !kl_if_0 <- kl_V1701 `pseq` kl_variableP kl_V1701
                                      case kl_if_0 of
                                          Atom (B (True)) -> do !appl_1 <- klCons (Types.Atom (Types.UnboundSym "ProcessN")) (Types.Atom Types.Nil)
                                                                !appl_2 <- kl_V1701 `pseq` (appl_1 `pseq` klCons kl_V1701 appl_1)
                                                                appl_2 `pseq` klCons (ApplC (wrapNamed "shen.deref" kl_shen_deref)) appl_2
                                          Atom (B (False)) -> do let pat_cond_3 kl_V1701 kl_V1701h kl_V1701t = do !appl_4 <- kl_V1701h `pseq` kl_shen_insert_deref kl_V1701h
                                                                                                                  !appl_5 <- kl_V1701t `pseq` kl_shen_insert_deref kl_V1701t
                                                                                                                  appl_4 `pseq` (appl_5 `pseq` klCons appl_4 appl_5)
                                                                     pat_cond_6 = do do return kl_V1701
                                                                  in case kl_V1701 of
                                                                         !(kl_V1701@(Cons (!kl_V1701h)
                                                                                          (!kl_V1701t))) -> pat_cond_3 kl_V1701 kl_V1701h kl_V1701t
                                                                         _ -> pat_cond_6
                                          _ -> throwError "if: expected boolean"

kl_shen_insert_lazyderef :: Types.KLValue ->
                            Types.KLContext Types.Env Types.KLValue
kl_shen_insert_lazyderef (!kl_V1703) = do !kl_if_0 <- kl_V1703 `pseq` kl_variableP kl_V1703
                                          case kl_if_0 of
                                              Atom (B (True)) -> do !appl_1 <- klCons (Types.Atom (Types.UnboundSym "ProcessN")) (Types.Atom Types.Nil)
                                                                    !appl_2 <- kl_V1703 `pseq` (appl_1 `pseq` klCons kl_V1703 appl_1)
                                                                    appl_2 `pseq` klCons (ApplC (wrapNamed "shen.lazyderef" kl_shen_lazyderef)) appl_2
                                              Atom (B (False)) -> do let pat_cond_3 kl_V1703 kl_V1703h kl_V1703t = do !appl_4 <- kl_V1703h `pseq` kl_shen_insert_lazyderef kl_V1703h
                                                                                                                      !appl_5 <- kl_V1703t `pseq` kl_shen_insert_lazyderef kl_V1703t
                                                                                                                      appl_4 `pseq` (appl_5 `pseq` klCons appl_4 appl_5)
                                                                         pat_cond_6 = do do return kl_V1703
                                                                      in case kl_V1703 of
                                                                             !(kl_V1703@(Cons (!kl_V1703h)
                                                                                              (!kl_V1703t))) -> pat_cond_3 kl_V1703 kl_V1703h kl_V1703t
                                                                             _ -> pat_cond_6
                                              _ -> throwError "if: expected boolean"

kl_shen_group_clauses :: Types.KLValue ->
                         Types.KLContext Types.Env Types.KLValue
kl_shen_group_clauses (!kl_V1705) = do let pat_cond_0 = do return (Types.Atom Types.Nil)
                                           pat_cond_1 kl_V1705 kl_V1705h kl_V1705t = do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Group) -> do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_Rest) -> do !appl_4 <- kl_Rest `pseq` kl_shen_group_clauses kl_Rest
                                                                                                                                                                                                                       kl_Group `pseq` (appl_4 `pseq` klCons kl_Group appl_4))))
                                                                                                                                                        !appl_5 <- kl_V1705 `pseq` (kl_Group `pseq` kl_difference kl_V1705 kl_Group)
                                                                                                                                                        appl_5 `pseq` applyWrapper appl_3 [appl_5])))
                                                                                        let !appl_6 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_V1705h `pseq` (kl_X `pseq` kl_shen_same_predicateP kl_V1705h kl_X))))
                                                                                        !appl_7 <- appl_6 `pseq` (kl_V1705 `pseq` kl_shen_collect appl_6 kl_V1705)
                                                                                        appl_7 `pseq` applyWrapper appl_2 [appl_7]
                                           pat_cond_8 = do do let !aw_9 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                              applyWrapper aw_9 [ApplC (wrapNamed "shen.group_clauses" kl_shen_group_clauses)]
                                        in case kl_V1705 of
                                               kl_V1705@(Atom (Nil)) -> pat_cond_0
                                               !(kl_V1705@(Cons (!kl_V1705h)
                                                                (!kl_V1705t))) -> pat_cond_1 kl_V1705 kl_V1705h kl_V1705t
                                               _ -> pat_cond_8

kl_shen_collect :: Types.KLValue ->
                   Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_collect (!kl_V1710) (!kl_V1711) = do let pat_cond_0 = do return (Types.Atom Types.Nil)
                                                 pat_cond_1 kl_V1711 kl_V1711h kl_V1711t = do !kl_if_2 <- kl_V1711h `pseq` applyWrapper kl_V1710 [kl_V1711h]
                                                                                              case kl_if_2 of
                                                                                                  Atom (B (True)) -> do !appl_3 <- kl_V1710 `pseq` (kl_V1711t `pseq` kl_shen_collect kl_V1710 kl_V1711t)
                                                                                                                        kl_V1711h `pseq` (appl_3 `pseq` klCons kl_V1711h appl_3)
                                                                                                  Atom (B (False)) -> do do kl_V1710 `pseq` (kl_V1711t `pseq` kl_shen_collect kl_V1710 kl_V1711t)
                                                                                                  _ -> throwError "if: expected boolean"
                                                 pat_cond_4 = do do let !aw_5 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                    applyWrapper aw_5 [ApplC (wrapNamed "shen.collect" kl_shen_collect)]
                                              in case kl_V1711 of
                                                     kl_V1711@(Atom (Nil)) -> pat_cond_0
                                                     !(kl_V1711@(Cons (!kl_V1711h)
                                                                      (!kl_V1711t))) -> pat_cond_1 kl_V1711 kl_V1711h kl_V1711t
                                                     _ -> pat_cond_4

kl_shen_same_predicateP :: Types.KLValue ->
                           Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_same_predicateP (!kl_V1730) (!kl_V1731) = do !kl_if_0 <- let pat_cond_1 kl_V1730 kl_V1730h kl_V1730t = do !kl_if_2 <- let pat_cond_3 kl_V1730h kl_V1730hh kl_V1730ht = do let pat_cond_4 kl_V1731 kl_V1731h kl_V1731hh kl_V1731ht kl_V1731t = do return (Atom (B True))
                                                                                                                                                                                      pat_cond_5 = do do return (Atom (B False))
                                                                                                                                                                                   in case kl_V1731 of
                                                                                                                                                                                          !(kl_V1731@(Cons (!(kl_V1731h@(Cons (!kl_V1731hh)
                                                                                                                                                                                                                              (!kl_V1731ht))))
                                                                                                                                                                                                           (!kl_V1731t))) -> pat_cond_4 kl_V1731 kl_V1731h kl_V1731hh kl_V1731ht kl_V1731t
                                                                                                                                                                                          _ -> pat_cond_5
                                                                                                                                  pat_cond_6 = do do return (Atom (B False))
                                                                                                                               in case kl_V1730h of
                                                                                                                                      !(kl_V1730h@(Cons (!kl_V1730hh)
                                                                                                                                                        (!kl_V1730ht))) -> pat_cond_3 kl_V1730h kl_V1730hh kl_V1730ht
                                                                                                                                      _ -> pat_cond_6
                                                                                                                  case kl_if_2 of
                                                                                                                      Atom (B (True)) -> do return (Atom (B True))
                                                                                                                      Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                      _ -> throwError "if: expected boolean"
                                                                     pat_cond_7 = do do return (Atom (B False))
                                                                  in case kl_V1730 of
                                                                         !(kl_V1730@(Cons (!kl_V1730h)
                                                                                          (!kl_V1730t))) -> pat_cond_1 kl_V1730 kl_V1730h kl_V1730t
                                                                         _ -> pat_cond_7
                                                     case kl_if_0 of
                                                         Atom (B (True)) -> do !appl_8 <- kl_V1730 `pseq` hd kl_V1730
                                                                               !appl_9 <- appl_8 `pseq` hd appl_8
                                                                               !appl_10 <- kl_V1731 `pseq` hd kl_V1731
                                                                               !appl_11 <- appl_10 `pseq` hd appl_10
                                                                               appl_9 `pseq` (appl_11 `pseq` eq appl_9 appl_11)
                                                         Atom (B (False)) -> do do let !aw_12 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                                   applyWrapper aw_12 [ApplC (wrapNamed "shen.same_predicate?" kl_shen_same_predicateP)]
                                                         _ -> throwError "if: expected boolean"

kl_shen_compile_prolog_procedure :: Types.KLValue ->
                                    Types.KLContext Types.Env Types.KLValue
kl_shen_compile_prolog_procedure (!kl_V1733) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_F) -> do let !appl_1 = ApplC (Func "lambda" (Context (\(!kl_Shen) -> do return kl_Shen)))
                                                                                                              !appl_2 <- kl_F `pseq` (kl_V1733 `pseq` kl_shen_clauses_to_shen kl_F kl_V1733)
                                                                                                              appl_2 `pseq` applyWrapper appl_1 [appl_2])))
                                                  !appl_3 <- kl_V1733 `pseq` kl_shen_procedure_name kl_V1733
                                                  appl_3 `pseq` applyWrapper appl_0 [appl_3]

kl_shen_procedure_name :: Types.KLValue ->
                          Types.KLContext Types.Env Types.KLValue
kl_shen_procedure_name (!kl_V1747) = do let pat_cond_0 kl_V1747 kl_V1747h kl_V1747hh kl_V1747hhh kl_V1747hht kl_V1747ht kl_V1747t = do return kl_V1747hhh
                                            pat_cond_1 = do do let !aw_2 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                               applyWrapper aw_2 [ApplC (wrapNamed "shen.procedure_name" kl_shen_procedure_name)]
                                         in case kl_V1747 of
                                                !(kl_V1747@(Cons (!(kl_V1747h@(Cons (!(kl_V1747hh@(Cons (!kl_V1747hhh)
                                                                                                        (!kl_V1747hht))))
                                                                                    (!kl_V1747ht))))
                                                                 (!kl_V1747t))) -> pat_cond_0 kl_V1747 kl_V1747h kl_V1747hh kl_V1747hhh kl_V1747hht kl_V1747ht kl_V1747t
                                                _ -> pat_cond_1

kl_shen_clauses_to_shen :: Types.KLValue ->
                           Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_clauses_to_shen (!kl_V1750) (!kl_V1751) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_Linear) -> do let !appl_1 = ApplC (Func "lambda" (Context (\(!kl_Arity) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Parameters) -> do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_AUM_instructions) -> do let !appl_4 = ApplC (Func "lambda" (Context (\(!kl_Code) -> do let !appl_5 = ApplC (Func "lambda" (Context (\(!kl_ShenDef) -> do return kl_ShenDef)))
                                                                                                                                                                                                                                                                                                                                                                                                     !appl_6 <- klCons (Types.Atom (Types.UnboundSym "Continuation")) (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                                                                                                                     !appl_7 <- appl_6 `pseq` klCons (Types.Atom (Types.UnboundSym "ProcessN")) appl_6
                                                                                                                                                                                                                                                                                                                                                                                                     !appl_8 <- kl_Code `pseq` klCons kl_Code (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                                                                                                                     !appl_9 <- appl_8 `pseq` klCons (Types.Atom (Types.UnboundSym "->")) appl_8
                                                                                                                                                                                                                                                                                                                                                                                                     !appl_10 <- appl_7 `pseq` (appl_9 `pseq` kl_append appl_7 appl_9)
                                                                                                                                                                                                                                                                                                                                                                                                     !appl_11 <- kl_Parameters `pseq` (appl_10 `pseq` kl_append kl_Parameters appl_10)
                                                                                                                                                                                                                                                                                                                                                                                                     !appl_12 <- kl_V1750 `pseq` (appl_11 `pseq` klCons kl_V1750 appl_11)
                                                                                                                                                                                                                                                                                                                                                                                                     !appl_13 <- appl_12 `pseq` klCons (Types.Atom (Types.UnboundSym "define")) appl_12
                                                                                                                                                                                                                                                                                                                                                                                                     appl_13 `pseq` applyWrapper appl_5 [appl_13])))
                                                                                                                                                                                                                                                                                                                                      let !appl_14 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_X `pseq` kl_shen_aum_to_shen kl_X)))
                                                                                                                                                                                                                                                                                                                                      !appl_15 <- appl_14 `pseq` (kl_AUM_instructions `pseq` kl_map appl_14 kl_AUM_instructions)
                                                                                                                                                                                                                                                                                                                                      !appl_16 <- appl_15 `pseq` kl_shen_nest_disjunct appl_15
                                                                                                                                                                                                                                                                                                                                      !appl_17 <- appl_16 `pseq` kl_shen_catch_cut appl_16
                                                                                                                                                                                                                                                                                                                                      appl_17 `pseq` applyWrapper appl_4 [appl_17])))
                                                                                                                                                                                                                                                           let !appl_18 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_X `pseq` (kl_Parameters `pseq` kl_shen_aum kl_X kl_Parameters))))
                                                                                                                                                                                                                                                           !appl_19 <- appl_18 `pseq` (kl_Linear `pseq` kl_map appl_18 kl_Linear)
                                                                                                                                                                                                                                                           appl_19 `pseq` applyWrapper appl_3 [appl_19])))
                                                                                                                                                                                      !appl_20 <- kl_Arity `pseq` kl_shen_parameters kl_Arity
                                                                                                                                                                                      appl_20 `pseq` applyWrapper appl_2 [appl_20])))
                                                                                                                      let !appl_21 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_X `pseq` kl_head kl_X)))
                                                                                                                      !appl_22 <- appl_21 `pseq` (kl_V1751 `pseq` kl_map appl_21 kl_V1751)
                                                                                                                      !appl_23 <- kl_V1750 `pseq` (appl_22 `pseq` kl_shen_prolog_aritycheck kl_V1750 appl_22)
                                                                                                                      appl_23 `pseq` applyWrapper appl_1 [appl_23])))
                                                     let !appl_24 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_X `pseq` kl_shen_linearise_clause kl_X)))
                                                     !appl_25 <- appl_24 `pseq` (kl_V1751 `pseq` kl_map appl_24 kl_V1751)
                                                     appl_25 `pseq` applyWrapper appl_0 [appl_25]

kl_shen_catch_cut :: Types.KLValue ->
                     Types.KLContext Types.Env Types.KLValue
kl_shen_catch_cut (!kl_V1753) = do !appl_0 <- kl_V1753 `pseq` kl_shen_occursP (ApplC (wrapNamed "cut" kl_cut)) kl_V1753
                                   !kl_if_1 <- appl_0 `pseq` kl_not appl_0
                                   case kl_if_1 of
                                       Atom (B (True)) -> do return kl_V1753
                                       Atom (B (False)) -> do do !appl_2 <- klCons (ApplC (PL "shen.catchpoint" kl_shen_catchpoint)) (Types.Atom Types.Nil)
                                                                 !appl_3 <- kl_V1753 `pseq` klCons kl_V1753 (Types.Atom Types.Nil)
                                                                 !appl_4 <- appl_3 `pseq` klCons (Types.Atom (Types.UnboundSym "Throwcontrol")) appl_3
                                                                 !appl_5 <- appl_4 `pseq` klCons (ApplC (wrapNamed "shen.cutpoint" kl_shen_cutpoint)) appl_4
                                                                 !appl_6 <- appl_5 `pseq` klCons appl_5 (Types.Atom Types.Nil)
                                                                 !appl_7 <- appl_2 `pseq` (appl_6 `pseq` klCons appl_2 appl_6)
                                                                 !appl_8 <- appl_7 `pseq` klCons (Types.Atom (Types.UnboundSym "Throwcontrol")) appl_7
                                                                 appl_8 `pseq` klCons (Types.Atom (Types.UnboundSym "let")) appl_8
                                       _ -> throwError "if: expected boolean"

kl_shen_catchpoint :: Types.KLContext Types.Env Types.KLValue
kl_shen_catchpoint = do !appl_0 <- value (Types.Atom (Types.UnboundSym "shen.*catch*"))
                        !appl_1 <- appl_0 `pseq` add (Types.Atom (Types.N (Types.KI 1))) appl_0
                        appl_1 `pseq` klSet (Types.Atom (Types.UnboundSym "shen.*catch*")) appl_1

kl_shen_cutpoint :: Types.KLValue ->
                    Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_cutpoint (!kl_V1761) (!kl_V1762) = do !kl_if_0 <- kl_V1762 `pseq` (kl_V1761 `pseq` eq kl_V1762 kl_V1761)
                                              case kl_if_0 of
                                                  Atom (B (True)) -> do return (Atom (B False))
                                                  Atom (B (False)) -> do do return kl_V1762
                                                  _ -> throwError "if: expected boolean"

kl_shen_nest_disjunct :: Types.KLValue ->
                         Types.KLContext Types.Env Types.KLValue
kl_shen_nest_disjunct (!kl_V1764) = do let pat_cond_0 kl_V1764 kl_V1764h = do return kl_V1764h
                                           pat_cond_1 kl_V1764 kl_V1764h kl_V1764t = do !appl_2 <- kl_V1764t `pseq` kl_shen_nest_disjunct kl_V1764t
                                                                                        kl_V1764h `pseq` (appl_2 `pseq` kl_shen_lisp_or kl_V1764h appl_2)
                                           pat_cond_3 = do do let !aw_4 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                              applyWrapper aw_4 [ApplC (wrapNamed "shen.nest-disjunct" kl_shen_nest_disjunct)]
                                        in case kl_V1764 of
                                               !(kl_V1764@(Cons (!kl_V1764h)
                                                                (Atom (Nil)))) -> pat_cond_0 kl_V1764 kl_V1764h
                                               !(kl_V1764@(Cons (!kl_V1764h)
                                                                (!kl_V1764t))) -> pat_cond_1 kl_V1764 kl_V1764h kl_V1764t
                                               _ -> pat_cond_3

kl_shen_lisp_or :: Types.KLValue ->
                   Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_lisp_or (!kl_V1767) (!kl_V1768) = do !appl_0 <- klCons (Atom (B False)) (Types.Atom Types.Nil)
                                             !appl_1 <- appl_0 `pseq` klCons (Types.Atom (Types.UnboundSym "Case")) appl_0
                                             !appl_2 <- appl_1 `pseq` klCons (ApplC (wrapNamed "=" eq)) appl_1
                                             !appl_3 <- klCons (Types.Atom (Types.UnboundSym "Case")) (Types.Atom Types.Nil)
                                             !appl_4 <- kl_V1768 `pseq` (appl_3 `pseq` klCons kl_V1768 appl_3)
                                             !appl_5 <- appl_2 `pseq` (appl_4 `pseq` klCons appl_2 appl_4)
                                             !appl_6 <- appl_5 `pseq` klCons (Types.Atom (Types.UnboundSym "if")) appl_5
                                             !appl_7 <- appl_6 `pseq` klCons appl_6 (Types.Atom Types.Nil)
                                             !appl_8 <- kl_V1767 `pseq` (appl_7 `pseq` klCons kl_V1767 appl_7)
                                             !appl_9 <- appl_8 `pseq` klCons (Types.Atom (Types.UnboundSym "Case")) appl_8
                                             appl_9 `pseq` klCons (Types.Atom (Types.UnboundSym "let")) appl_9

kl_shen_prolog_aritycheck :: Types.KLValue ->
                             Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_prolog_aritycheck (!kl_V1773) (!kl_V1774) = do let pat_cond_0 kl_V1774 kl_V1774h = do !appl_1 <- kl_V1774h `pseq` kl_length kl_V1774h
                                                                                              appl_1 `pseq` Primitives.subtract appl_1 (Types.Atom (Types.N (Types.KI 1)))
                                                           pat_cond_2 kl_V1774 kl_V1774h kl_V1774t kl_V1774th kl_V1774tt = do !appl_3 <- kl_V1774h `pseq` kl_length kl_V1774h
                                                                                                                              !appl_4 <- kl_V1774th `pseq` kl_length kl_V1774th
                                                                                                                              !kl_if_5 <- appl_3 `pseq` (appl_4 `pseq` eq appl_3 appl_4)
                                                                                                                              case kl_if_5 of
                                                                                                                                  Atom (B (True)) -> do kl_V1773 `pseq` (kl_V1774t `pseq` kl_shen_prolog_aritycheck kl_V1773 kl_V1774t)
                                                                                                                                  Atom (B (False)) -> do do !appl_6 <- kl_V1773 `pseq` klCons kl_V1773 (Types.Atom Types.Nil)
                                                                                                                                                            let !aw_7 = Types.Atom (Types.UnboundSym "shen.app")
                                                                                                                                                            !appl_8 <- appl_6 `pseq` applyWrapper aw_7 [appl_6,
                                                                                                                                                                                                        Types.Atom (Types.Str "\n"),
                                                                                                                                                                                                        Types.Atom (Types.UnboundSym "shen.a")]
                                                                                                                                                            !appl_9 <- appl_8 `pseq` cn (Types.Atom (Types.Str "arity error in prolog procedure ")) appl_8
                                                                                                                                                            appl_9 `pseq` simpleError appl_9
                                                                                                                                  _ -> throwError "if: expected boolean"
                                                           pat_cond_10 = do do let !aw_11 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                               applyWrapper aw_11 [ApplC (wrapNamed "shen.prolog-aritycheck" kl_shen_prolog_aritycheck)]
                                                        in case kl_V1774 of
                                                               !(kl_V1774@(Cons (!kl_V1774h)
                                                                                (Atom (Nil)))) -> pat_cond_0 kl_V1774 kl_V1774h
                                                               !(kl_V1774@(Cons (!kl_V1774h)
                                                                                (!(kl_V1774t@(Cons (!kl_V1774th)
                                                                                                   (!kl_V1774tt)))))) -> pat_cond_2 kl_V1774 kl_V1774h kl_V1774t kl_V1774th kl_V1774tt
                                                               _ -> pat_cond_10

kl_shen_linearise_clause :: Types.KLValue ->
                            Types.KLContext Types.Env Types.KLValue
kl_shen_linearise_clause (!kl_V1776) = do let pat_cond_0 kl_V1776 kl_V1776h kl_V1776t kl_V1776tt kl_V1776tth = do let !appl_1 = ApplC (Func "lambda" (Context (\(!kl_Linear) -> do kl_Linear `pseq` kl_shen_clause_form kl_Linear)))
                                                                                                                  !appl_2 <- kl_V1776h `pseq` (kl_V1776tt `pseq` klCons kl_V1776h kl_V1776tt)
                                                                                                                  !appl_3 <- appl_2 `pseq` kl_shen_linearise appl_2
                                                                                                                  appl_3 `pseq` applyWrapper appl_1 [appl_3]
                                              pat_cond_4 = do do let !aw_5 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                 applyWrapper aw_5 [ApplC (wrapNamed "shen.linearise-clause" kl_shen_linearise_clause)]
                                           in case kl_V1776 of
                                                  !(kl_V1776@(Cons (!kl_V1776h)
                                                                   (!(kl_V1776t@(Cons (Atom (UnboundSym ":-"))
                                                                                      (!(kl_V1776tt@(Cons (!kl_V1776tth)
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_0 kl_V1776 kl_V1776h kl_V1776t kl_V1776tt kl_V1776tth
                                                  !(kl_V1776@(Cons (!kl_V1776h)
                                                                   (!(kl_V1776t@(Cons (ApplC (PL ":-"
                                                                                                 _))
                                                                                      (!(kl_V1776tt@(Cons (!kl_V1776tth)
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_0 kl_V1776 kl_V1776h kl_V1776t kl_V1776tt kl_V1776tth
                                                  !(kl_V1776@(Cons (!kl_V1776h)
                                                                   (!(kl_V1776t@(Cons (ApplC (Func ":-"
                                                                                                   _))
                                                                                      (!(kl_V1776tt@(Cons (!kl_V1776tth)
                                                                                                          (Atom (Nil)))))))))) -> pat_cond_0 kl_V1776 kl_V1776h kl_V1776t kl_V1776tt kl_V1776tth
                                                  _ -> pat_cond_4

kl_shen_clause_form :: Types.KLValue ->
                       Types.KLContext Types.Env Types.KLValue
kl_shen_clause_form (!kl_V1778) = do let pat_cond_0 kl_V1778 kl_V1778h kl_V1778t kl_V1778th = do !appl_1 <- kl_V1778h `pseq` kl_shen_explicit_modes kl_V1778h
                                                                                                 !appl_2 <- kl_V1778th `pseq` kl_shen_cf_help kl_V1778th
                                                                                                 !appl_3 <- appl_2 `pseq` klCons appl_2 (Types.Atom Types.Nil)
                                                                                                 !appl_4 <- appl_3 `pseq` klCons (Types.Atom (Types.UnboundSym ":-")) appl_3
                                                                                                 appl_1 `pseq` (appl_4 `pseq` klCons appl_1 appl_4)
                                         pat_cond_5 = do do let !aw_6 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                            applyWrapper aw_6 [ApplC (wrapNamed "shen.clause_form" kl_shen_clause_form)]
                                      in case kl_V1778 of
                                             !(kl_V1778@(Cons (!kl_V1778h)
                                                              (!(kl_V1778t@(Cons (!kl_V1778th)
                                                                                 (Atom (Nil))))))) -> pat_cond_0 kl_V1778 kl_V1778h kl_V1778t kl_V1778th
                                             _ -> pat_cond_5

kl_shen_explicit_modes :: Types.KLValue ->
                          Types.KLContext Types.Env Types.KLValue
kl_shen_explicit_modes (!kl_V1780) = do let pat_cond_0 kl_V1780 kl_V1780h kl_V1780t = do let !appl_1 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_X `pseq` kl_shen_em_help kl_X)))
                                                                                         !appl_2 <- appl_1 `pseq` (kl_V1780t `pseq` kl_map appl_1 kl_V1780t)
                                                                                         kl_V1780h `pseq` (appl_2 `pseq` klCons kl_V1780h appl_2)
                                            pat_cond_3 = do do let !aw_4 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                               applyWrapper aw_4 [ApplC (wrapNamed "shen.explicit_modes" kl_shen_explicit_modes)]
                                         in case kl_V1780 of
                                                !(kl_V1780@(Cons (!kl_V1780h)
                                                                 (!kl_V1780t))) -> pat_cond_0 kl_V1780 kl_V1780h kl_V1780t
                                                _ -> pat_cond_3

kl_shen_em_help :: Types.KLValue ->
                   Types.KLContext Types.Env Types.KLValue
kl_shen_em_help (!kl_V1782) = do let pat_cond_0 kl_V1782 kl_V1782t kl_V1782th kl_V1782tt kl_V1782tth = do return kl_V1782
                                     pat_cond_1 = do do !appl_2 <- klCons (ApplC (wrapNamed "+" add)) (Types.Atom Types.Nil)
                                                        !appl_3 <- kl_V1782 `pseq` (appl_2 `pseq` klCons kl_V1782 appl_2)
                                                        appl_3 `pseq` klCons (Types.Atom (Types.UnboundSym "mode")) appl_3
                                  in case kl_V1782 of
                                         !(kl_V1782@(Cons (Atom (UnboundSym "mode"))
                                                          (!(kl_V1782t@(Cons (!kl_V1782th)
                                                                             (!(kl_V1782tt@(Cons (!kl_V1782tth)
                                                                                                 (Atom (Nil)))))))))) -> pat_cond_0 kl_V1782 kl_V1782t kl_V1782th kl_V1782tt kl_V1782tth
                                         !(kl_V1782@(Cons (ApplC (PL "mode" _))
                                                          (!(kl_V1782t@(Cons (!kl_V1782th)
                                                                             (!(kl_V1782tt@(Cons (!kl_V1782tth)
                                                                                                 (Atom (Nil)))))))))) -> pat_cond_0 kl_V1782 kl_V1782t kl_V1782th kl_V1782tt kl_V1782tth
                                         !(kl_V1782@(Cons (ApplC (Func "mode" _))
                                                          (!(kl_V1782t@(Cons (!kl_V1782th)
                                                                             (!(kl_V1782tt@(Cons (!kl_V1782tth)
                                                                                                 (Atom (Nil)))))))))) -> pat_cond_0 kl_V1782 kl_V1782t kl_V1782th kl_V1782tt kl_V1782tth
                                         _ -> pat_cond_1

kl_shen_cf_help :: Types.KLValue ->
                   Types.KLContext Types.Env Types.KLValue
kl_shen_cf_help (!kl_V1784) = do let pat_cond_0 kl_V1784 kl_V1784t kl_V1784th kl_V1784tht kl_V1784thth kl_V1784thtt kl_V1784thtth kl_V1784tt kl_V1784tth = do !kl_if_1 <- value (Types.Atom (Types.UnboundSym "shen.*occurs*"))
                                                                                                                                                              !appl_2 <- case kl_if_1 of
                                                                                                                                                                             Atom (B (True)) -> do return (ApplC (wrapNamed "unify!" kl_unifyExcl))
                                                                                                                                                                             Atom (B (False)) -> do do return (ApplC (wrapNamed "unify" kl_unify))
                                                                                                                                                                             _ -> throwError "if: expected boolean"
                                                                                                                                                              !appl_3 <- appl_2 `pseq` (kl_V1784tht `pseq` klCons appl_2 kl_V1784tht)
                                                                                                                                                              !appl_4 <- kl_V1784tth `pseq` kl_shen_cf_help kl_V1784tth
                                                                                                                                                              appl_3 `pseq` (appl_4 `pseq` klCons appl_3 appl_4)
                                     pat_cond_5 = do do return kl_V1784
                                  in case kl_V1784 of
                                         !(kl_V1784@(Cons (Atom (UnboundSym "where"))
                                                          (!(kl_V1784t@(Cons (!(kl_V1784th@(Cons (Atom (UnboundSym "="))
                                                                                                 (!(kl_V1784tht@(Cons (!kl_V1784thth)
                                                                                                                      (!(kl_V1784thtt@(Cons (!kl_V1784thtth)
                                                                                                                                            (Atom (Nil)))))))))))
                                                                             (!(kl_V1784tt@(Cons (!kl_V1784tth)
                                                                                                 (Atom (Nil)))))))))) -> pat_cond_0 kl_V1784 kl_V1784t kl_V1784th kl_V1784tht kl_V1784thth kl_V1784thtt kl_V1784thtth kl_V1784tt kl_V1784tth
                                         !(kl_V1784@(Cons (Atom (UnboundSym "where"))
                                                          (!(kl_V1784t@(Cons (!(kl_V1784th@(Cons (ApplC (PL "="
                                                                                                            _))
                                                                                                 (!(kl_V1784tht@(Cons (!kl_V1784thth)
                                                                                                                      (!(kl_V1784thtt@(Cons (!kl_V1784thtth)
                                                                                                                                            (Atom (Nil)))))))))))
                                                                             (!(kl_V1784tt@(Cons (!kl_V1784tth)
                                                                                                 (Atom (Nil)))))))))) -> pat_cond_0 kl_V1784 kl_V1784t kl_V1784th kl_V1784tht kl_V1784thth kl_V1784thtt kl_V1784thtth kl_V1784tt kl_V1784tth
                                         !(kl_V1784@(Cons (Atom (UnboundSym "where"))
                                                          (!(kl_V1784t@(Cons (!(kl_V1784th@(Cons (ApplC (Func "="
                                                                                                              _))
                                                                                                 (!(kl_V1784tht@(Cons (!kl_V1784thth)
                                                                                                                      (!(kl_V1784thtt@(Cons (!kl_V1784thtth)
                                                                                                                                            (Atom (Nil)))))))))))
                                                                             (!(kl_V1784tt@(Cons (!kl_V1784tth)
                                                                                                 (Atom (Nil)))))))))) -> pat_cond_0 kl_V1784 kl_V1784t kl_V1784th kl_V1784tht kl_V1784thth kl_V1784thtt kl_V1784thtth kl_V1784tt kl_V1784tth
                                         !(kl_V1784@(Cons (ApplC (PL "where" _))
                                                          (!(kl_V1784t@(Cons (!(kl_V1784th@(Cons (Atom (UnboundSym "="))
                                                                                                 (!(kl_V1784tht@(Cons (!kl_V1784thth)
                                                                                                                      (!(kl_V1784thtt@(Cons (!kl_V1784thtth)
                                                                                                                                            (Atom (Nil)))))))))))
                                                                             (!(kl_V1784tt@(Cons (!kl_V1784tth)
                                                                                                 (Atom (Nil)))))))))) -> pat_cond_0 kl_V1784 kl_V1784t kl_V1784th kl_V1784tht kl_V1784thth kl_V1784thtt kl_V1784thtth kl_V1784tt kl_V1784tth
                                         !(kl_V1784@(Cons (ApplC (PL "where" _))
                                                          (!(kl_V1784t@(Cons (!(kl_V1784th@(Cons (ApplC (PL "="
                                                                                                            _))
                                                                                                 (!(kl_V1784tht@(Cons (!kl_V1784thth)
                                                                                                                      (!(kl_V1784thtt@(Cons (!kl_V1784thtth)
                                                                                                                                            (Atom (Nil)))))))))))
                                                                             (!(kl_V1784tt@(Cons (!kl_V1784tth)
                                                                                                 (Atom (Nil)))))))))) -> pat_cond_0 kl_V1784 kl_V1784t kl_V1784th kl_V1784tht kl_V1784thth kl_V1784thtt kl_V1784thtth kl_V1784tt kl_V1784tth
                                         !(kl_V1784@(Cons (ApplC (PL "where" _))
                                                          (!(kl_V1784t@(Cons (!(kl_V1784th@(Cons (ApplC (Func "="
                                                                                                              _))
                                                                                                 (!(kl_V1784tht@(Cons (!kl_V1784thth)
                                                                                                                      (!(kl_V1784thtt@(Cons (!kl_V1784thtth)
                                                                                                                                            (Atom (Nil)))))))))))
                                                                             (!(kl_V1784tt@(Cons (!kl_V1784tth)
                                                                                                 (Atom (Nil)))))))))) -> pat_cond_0 kl_V1784 kl_V1784t kl_V1784th kl_V1784tht kl_V1784thth kl_V1784thtt kl_V1784thtth kl_V1784tt kl_V1784tth
                                         !(kl_V1784@(Cons (ApplC (Func "where" _))
                                                          (!(kl_V1784t@(Cons (!(kl_V1784th@(Cons (Atom (UnboundSym "="))
                                                                                                 (!(kl_V1784tht@(Cons (!kl_V1784thth)
                                                                                                                      (!(kl_V1784thtt@(Cons (!kl_V1784thtth)
                                                                                                                                            (Atom (Nil)))))))))))
                                                                             (!(kl_V1784tt@(Cons (!kl_V1784tth)
                                                                                                 (Atom (Nil)))))))))) -> pat_cond_0 kl_V1784 kl_V1784t kl_V1784th kl_V1784tht kl_V1784thth kl_V1784thtt kl_V1784thtth kl_V1784tt kl_V1784tth
                                         !(kl_V1784@(Cons (ApplC (Func "where" _))
                                                          (!(kl_V1784t@(Cons (!(kl_V1784th@(Cons (ApplC (PL "="
                                                                                                            _))
                                                                                                 (!(kl_V1784tht@(Cons (!kl_V1784thth)
                                                                                                                      (!(kl_V1784thtt@(Cons (!kl_V1784thtth)
                                                                                                                                            (Atom (Nil)))))))))))
                                                                             (!(kl_V1784tt@(Cons (!kl_V1784tth)
                                                                                                 (Atom (Nil)))))))))) -> pat_cond_0 kl_V1784 kl_V1784t kl_V1784th kl_V1784tht kl_V1784thth kl_V1784thtt kl_V1784thtth kl_V1784tt kl_V1784tth
                                         !(kl_V1784@(Cons (ApplC (Func "where" _))
                                                          (!(kl_V1784t@(Cons (!(kl_V1784th@(Cons (ApplC (Func "="
                                                                                                              _))
                                                                                                 (!(kl_V1784tht@(Cons (!kl_V1784thth)
                                                                                                                      (!(kl_V1784thtt@(Cons (!kl_V1784thtth)
                                                                                                                                            (Atom (Nil)))))))))))
                                                                             (!(kl_V1784tt@(Cons (!kl_V1784tth)
                                                                                                 (Atom (Nil)))))))))) -> pat_cond_0 kl_V1784 kl_V1784t kl_V1784th kl_V1784tht kl_V1784thth kl_V1784thtt kl_V1784thtth kl_V1784tt kl_V1784tth
                                         _ -> pat_cond_5

kl_occurs_check :: Types.KLValue ->
                   Types.KLContext Types.Env Types.KLValue
kl_occurs_check (!kl_V1790) = do let pat_cond_0 = do klSet (Types.Atom (Types.UnboundSym "shen.*occurs*")) (Atom (B True))
                                     pat_cond_1 = do klSet (Types.Atom (Types.UnboundSym "shen.*occurs*")) (Atom (B False))
                                     pat_cond_2 = do do simpleError (Types.Atom (Types.Str "occurs-check expects + or -\n"))
                                  in case kl_V1790 of
                                         kl_V1790@(Atom (UnboundSym "+")) -> pat_cond_0
                                         kl_V1790@(ApplC (PL "+" _)) -> pat_cond_0
                                         kl_V1790@(ApplC (Func "+" _)) -> pat_cond_0
                                         kl_V1790@(Atom (UnboundSym "-")) -> pat_cond_1
                                         kl_V1790@(ApplC (PL "-" _)) -> pat_cond_1
                                         kl_V1790@(ApplC (Func "-" _)) -> pat_cond_1
                                         _ -> pat_cond_2

kl_shen_aum :: Types.KLValue ->
               Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_aum (!kl_V1793) (!kl_V1794) = do let pat_cond_0 kl_V1793 kl_V1793h kl_V1793hh kl_V1793ht kl_V1793t kl_V1793tt kl_V1793tth = do let !appl_1 = ApplC (Func "lambda" (Context (\(!kl_MuApplication) -> do kl_MuApplication `pseq` kl_shen_mu_reduction kl_MuApplication (ApplC (wrapNamed "+" add)))))
                                                                                                                                       !appl_2 <- kl_V1793ht `pseq` (kl_V1793tth `pseq` kl_shen_continuation_call kl_V1793ht kl_V1793tth)
                                                                                                                                       !appl_3 <- appl_2 `pseq` klCons appl_2 (Types.Atom Types.Nil)
                                                                                                                                       !appl_4 <- kl_V1793ht `pseq` (appl_3 `pseq` klCons kl_V1793ht appl_3)
                                                                                                                                       !appl_5 <- appl_4 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.mu")) appl_4
                                                                                                                                       !appl_6 <- appl_5 `pseq` (kl_V1794 `pseq` kl_shen_make_mu_application appl_5 kl_V1794)
                                                                                                                                       appl_6 `pseq` applyWrapper appl_1 [appl_6]
                                             pat_cond_7 = do do let !aw_8 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                applyWrapper aw_8 [ApplC (wrapNamed "shen.aum" kl_shen_aum)]
                                          in case kl_V1793 of
                                                 !(kl_V1793@(Cons (!(kl_V1793h@(Cons (!kl_V1793hh)
                                                                                     (!kl_V1793ht))))
                                                                  (!(kl_V1793t@(Cons (Atom (UnboundSym ":-"))
                                                                                     (!(kl_V1793tt@(Cons (!kl_V1793tth)
                                                                                                         (Atom (Nil)))))))))) -> pat_cond_0 kl_V1793 kl_V1793h kl_V1793hh kl_V1793ht kl_V1793t kl_V1793tt kl_V1793tth
                                                 !(kl_V1793@(Cons (!(kl_V1793h@(Cons (!kl_V1793hh)
                                                                                     (!kl_V1793ht))))
                                                                  (!(kl_V1793t@(Cons (ApplC (PL ":-"
                                                                                                _))
                                                                                     (!(kl_V1793tt@(Cons (!kl_V1793tth)
                                                                                                         (Atom (Nil)))))))))) -> pat_cond_0 kl_V1793 kl_V1793h kl_V1793hh kl_V1793ht kl_V1793t kl_V1793tt kl_V1793tth
                                                 !(kl_V1793@(Cons (!(kl_V1793h@(Cons (!kl_V1793hh)
                                                                                     (!kl_V1793ht))))
                                                                  (!(kl_V1793t@(Cons (ApplC (Func ":-"
                                                                                                  _))
                                                                                     (!(kl_V1793tt@(Cons (!kl_V1793tth)
                                                                                                         (Atom (Nil)))))))))) -> pat_cond_0 kl_V1793 kl_V1793h kl_V1793hh kl_V1793ht kl_V1793t kl_V1793tt kl_V1793tth
                                                 _ -> pat_cond_7

kl_shen_continuation_call :: Types.KLValue ->
                             Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_continuation_call (!kl_V1797) (!kl_V1798) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_VTerms) -> do let !appl_1 = ApplC (Func "lambda" (Context (\(!kl_VBody) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Free) -> do kl_Free `pseq` (kl_V1798 `pseq` kl_shen_cc_help kl_Free kl_V1798))))
                                                                                                                                                                                        !appl_3 <- kl_VBody `pseq` (kl_VTerms `pseq` kl_difference kl_VBody kl_VTerms)
                                                                                                                                                                                        !appl_4 <- appl_3 `pseq` kl_remove (Types.Atom (Types.UnboundSym "Throwcontrol")) appl_3
                                                                                                                                                                                        appl_4 `pseq` applyWrapper appl_2 [appl_4])))
                                                                                                                        !appl_5 <- kl_V1798 `pseq` kl_shen_extract_vars kl_V1798
                                                                                                                        appl_5 `pseq` applyWrapper appl_1 [appl_5])))
                                                       !appl_6 <- kl_V1797 `pseq` kl_shen_extract_vars kl_V1797
                                                       !appl_7 <- appl_6 `pseq` klCons (Types.Atom (Types.UnboundSym "ProcessN")) appl_6
                                                       appl_7 `pseq` applyWrapper appl_0 [appl_7]

kl_remove :: Types.KLValue ->
             Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_remove (!kl_V1801) (!kl_V1802) = do kl_V1801 `pseq` (kl_V1802 `pseq` kl_shen_remove_h kl_V1801 kl_V1802 (Types.Atom Types.Nil))

kl_shen_remove_h :: Types.KLValue ->
                    Types.KLValue ->
                    Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_remove_h (!kl_V1809) (!kl_V1810) (!kl_V1811) = do let pat_cond_0 = do kl_V1811 `pseq` kl_reverse kl_V1811
                                                              pat_cond_1 kl_V1810 kl_V1810h kl_V1810t = do kl_V1810h `pseq` (kl_V1810t `pseq` (kl_V1811 `pseq` kl_shen_remove_h kl_V1810h kl_V1810t kl_V1811))
                                                              pat_cond_2 kl_V1810 kl_V1810h kl_V1810t = do !appl_3 <- kl_V1810h `pseq` (kl_V1811 `pseq` klCons kl_V1810h kl_V1811)
                                                                                                           kl_V1809 `pseq` (kl_V1810t `pseq` (appl_3 `pseq` kl_shen_remove_h kl_V1809 kl_V1810t appl_3))
                                                              pat_cond_4 = do do let !aw_5 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                                 applyWrapper aw_5 [ApplC (wrapNamed "shen.remove-h" kl_shen_remove_h)]
                                                           in case kl_V1810 of
                                                                  kl_V1810@(Atom (Nil)) -> pat_cond_0
                                                                  !(kl_V1810@(Cons (!kl_V1810h)
                                                                                   (!kl_V1810t))) | eqCore kl_V1810h kl_V1809 -> pat_cond_1 kl_V1810 kl_V1810h kl_V1810t
                                                                  !(kl_V1810@(Cons (!kl_V1810h)
                                                                                   (!kl_V1810t))) -> pat_cond_2 kl_V1810 kl_V1810h kl_V1810t
                                                                  _ -> pat_cond_4

kl_shen_cc_help :: Types.KLValue ->
                   Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_cc_help (!kl_V1814) (!kl_V1815) = do !kl_if_0 <- let pat_cond_1 = do let pat_cond_2 = do return (Atom (B True))
                                                                                 pat_cond_3 = do do return (Atom (B False))
                                                                              in case kl_V1815 of
                                                                                     kl_V1815@(Atom (Nil)) -> pat_cond_2
                                                                                     _ -> pat_cond_3
                                                             pat_cond_4 = do do return (Atom (B False))
                                                          in case kl_V1814 of
                                                                 kl_V1814@(Atom (Nil)) -> pat_cond_1
                                                                 _ -> pat_cond_4
                                             case kl_if_0 of
                                                 Atom (B (True)) -> do !appl_5 <- klCons (Types.Atom (Types.UnboundSym "shen.stack")) (Types.Atom Types.Nil)
                                                                       !appl_6 <- appl_5 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.the")) appl_5
                                                                       appl_6 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.pop")) appl_6
                                                 Atom (B (False)) -> do let pat_cond_7 = do !appl_8 <- klCons (Types.Atom (Types.UnboundSym "shen.stack")) (Types.Atom Types.Nil)
                                                                                            !appl_9 <- appl_8 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.the")) appl_8
                                                                                            !appl_10 <- appl_9 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.pop")) appl_9
                                                                                            !appl_11 <- appl_10 `pseq` klCons appl_10 (Types.Atom Types.Nil)
                                                                                            !appl_12 <- appl_11 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.then")) appl_11
                                                                                            !appl_13 <- appl_12 `pseq` klCons (Types.Atom (Types.UnboundSym "and")) appl_12
                                                                                            !appl_14 <- kl_V1814 `pseq` (appl_13 `pseq` klCons kl_V1814 appl_13)
                                                                                            !appl_15 <- appl_14 `pseq` klCons (Types.Atom (Types.UnboundSym "in")) appl_14
                                                                                            !appl_16 <- appl_15 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.variables")) appl_15
                                                                                            !appl_17 <- appl_16 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.the")) appl_16
                                                                                            appl_17 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.rename")) appl_17
                                                                            pat_cond_18 = do let pat_cond_19 = do !appl_20 <- kl_V1815 `pseq` klCons kl_V1815 (Types.Atom Types.Nil)
                                                                                                                  !appl_21 <- appl_20 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.continuation")) appl_20
                                                                                                                  !appl_22 <- appl_21 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.the")) appl_21
                                                                                                                  appl_22 `pseq` klCons (ApplC (wrapNamed "call" kl_call)) appl_22
                                                                                                 pat_cond_23 = do do !appl_24 <- kl_V1815 `pseq` klCons kl_V1815 (Types.Atom Types.Nil)
                                                                                                                     !appl_25 <- appl_24 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.continuation")) appl_24
                                                                                                                     !appl_26 <- appl_25 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.the")) appl_25
                                                                                                                     !appl_27 <- appl_26 `pseq` klCons (ApplC (wrapNamed "call" kl_call)) appl_26
                                                                                                                     !appl_28 <- appl_27 `pseq` klCons appl_27 (Types.Atom Types.Nil)
                                                                                                                     !appl_29 <- appl_28 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.then")) appl_28
                                                                                                                     !appl_30 <- appl_29 `pseq` klCons (Types.Atom (Types.UnboundSym "and")) appl_29
                                                                                                                     !appl_31 <- kl_V1814 `pseq` (appl_30 `pseq` klCons kl_V1814 appl_30)
                                                                                                                     !appl_32 <- appl_31 `pseq` klCons (Types.Atom (Types.UnboundSym "in")) appl_31
                                                                                                                     !appl_33 <- appl_32 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.variables")) appl_32
                                                                                                                     !appl_34 <- appl_33 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.the")) appl_33
                                                                                                                     appl_34 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.rename")) appl_34
                                                                                              in case kl_V1814 of
                                                                                                     kl_V1814@(Atom (Nil)) -> pat_cond_19
                                                                                                     _ -> pat_cond_23
                                                                         in case kl_V1815 of
                                                                                kl_V1815@(Atom (Nil)) -> pat_cond_7
                                                                                _ -> pat_cond_18
                                                 _ -> throwError "if: expected boolean"

kl_shen_make_mu_application :: Types.KLValue ->
                               Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_make_mu_application (!kl_V1818) (!kl_V1819) = do !kl_if_0 <- let pat_cond_1 kl_V1818 kl_V1818h kl_V1818t = do !kl_if_2 <- let pat_cond_3 = do !kl_if_4 <- let pat_cond_5 kl_V1818t kl_V1818th kl_V1818tt = do !kl_if_6 <- let pat_cond_7 = do !kl_if_8 <- let pat_cond_9 kl_V1818tt kl_V1818tth kl_V1818ttt = do !kl_if_10 <- let pat_cond_11 = do let pat_cond_12 = do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                               pat_cond_13 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                            in case kl_V1819 of
                                                                                                                                                                                                                                                                                                                                                                   kl_V1819@(Atom (Nil)) -> pat_cond_12
                                                                                                                                                                                                                                                                                                                                                                   _ -> pat_cond_13
                                                                                                                                                                                                                                                                                                                                          pat_cond_14 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                       in case kl_V1818ttt of
                                                                                                                                                                                                                                                                                                                                              kl_V1818ttt@(Atom (Nil)) -> pat_cond_11
                                                                                                                                                                                                                                                                                                                                              _ -> pat_cond_14
                                                                                                                                                                                                                                                                                                                         case kl_if_10 of
                                                                                                                                                                                                                                                                                                                             Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                             Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                             _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                      pat_cond_15 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                   in case kl_V1818tt of
                                                                                                                                                                                                                                                                          !(kl_V1818tt@(Cons (!kl_V1818tth)
                                                                                                                                                                                                                                                                                             (!kl_V1818ttt))) -> pat_cond_9 kl_V1818tt kl_V1818tth kl_V1818ttt
                                                                                                                                                                                                                                                                          _ -> pat_cond_15
                                                                                                                                                                                                                                                      case kl_if_8 of
                                                                                                                                                                                                                                                          Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                          Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                          _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                      pat_cond_16 = do do return (Atom (B False))
                                                                                                                                                                                                                                   in case kl_V1818th of
                                                                                                                                                                                                                                          kl_V1818th@(Atom (Nil)) -> pat_cond_7
                                                                                                                                                                                                                                          _ -> pat_cond_16
                                                                                                                                                                                                                      case kl_if_6 of
                                                                                                                                                                                                                          Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                          Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                          _ -> throwError "if: expected boolean"
                                                                                                                                                                      pat_cond_17 = do do return (Atom (B False))
                                                                                                                                                                   in case kl_V1818t of
                                                                                                                                                                          !(kl_V1818t@(Cons (!kl_V1818th)
                                                                                                                                                                                            (!kl_V1818tt))) -> pat_cond_5 kl_V1818t kl_V1818th kl_V1818tt
                                                                                                                                                                          _ -> pat_cond_17
                                                                                                                                                      case kl_if_4 of
                                                                                                                                                          Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                          Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                          _ -> throwError "if: expected boolean"
                                                                                                                                      pat_cond_18 = do do return (Atom (B False))
                                                                                                                                   in case kl_V1818h of
                                                                                                                                          kl_V1818h@(Atom (UnboundSym "shen.mu")) -> pat_cond_3
                                                                                                                                          kl_V1818h@(ApplC (PL "shen.mu"
                                                                                                                                                               _)) -> pat_cond_3
                                                                                                                                          kl_V1818h@(ApplC (Func "shen.mu"
                                                                                                                                                                 _)) -> pat_cond_3
                                                                                                                                          _ -> pat_cond_18
                                                                                                                      case kl_if_2 of
                                                                                                                          Atom (B (True)) -> do return (Atom (B True))
                                                                                                                          Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                          _ -> throwError "if: expected boolean"
                                                                         pat_cond_19 = do do return (Atom (B False))
                                                                      in case kl_V1818 of
                                                                             !(kl_V1818@(Cons (!kl_V1818h)
                                                                                              (!kl_V1818t))) -> pat_cond_1 kl_V1818 kl_V1818h kl_V1818t
                                                                             _ -> pat_cond_19
                                                         case kl_if_0 of
                                                             Atom (B (True)) -> do !appl_20 <- kl_V1818 `pseq` tl kl_V1818
                                                                                   !appl_21 <- appl_20 `pseq` tl appl_20
                                                                                   appl_21 `pseq` hd appl_21
                                                             Atom (B (False)) -> do !kl_if_22 <- let pat_cond_23 kl_V1818 kl_V1818h kl_V1818t = do !kl_if_24 <- let pat_cond_25 = do !kl_if_26 <- let pat_cond_27 kl_V1818t kl_V1818th kl_V1818tt = do !kl_if_28 <- let pat_cond_29 kl_V1818th kl_V1818thh kl_V1818tht = do !kl_if_30 <- let pat_cond_31 kl_V1818tt kl_V1818tth kl_V1818ttt = do !kl_if_32 <- let pat_cond_33 = do let pat_cond_34 kl_V1819 kl_V1819h kl_V1819t = do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                       pat_cond_35 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                    in case kl_V1819 of
                                                                                                                                                                                                                                                                                                                                                                                                                                           !(kl_V1819@(Cons (!kl_V1819h)
                                                                                                                                                                                                                                                                                                                                                                                                                                                            (!kl_V1819t))) -> pat_cond_34 kl_V1819 kl_V1819h kl_V1819t
                                                                                                                                                                                                                                                                                                                                                                                                                                           _ -> pat_cond_35
                                                                                                                                                                                                                                                                                                                                                                                                                  pat_cond_36 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                               in case kl_V1818ttt of
                                                                                                                                                                                                                                                                                                                                                                                                                      kl_V1818ttt@(Atom (Nil)) -> pat_cond_33
                                                                                                                                                                                                                                                                                                                                                                                                                      _ -> pat_cond_36
                                                                                                                                                                                                                                                                                                                                                                                                 case kl_if_32 of
                                                                                                                                                                                                                                                                                                                                                                                                     Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                     Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                     _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                             pat_cond_37 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                          in case kl_V1818tt of
                                                                                                                                                                                                                                                                                                                                                 !(kl_V1818tt@(Cons (!kl_V1818tth)
                                                                                                                                                                                                                                                                                                                                                                    (!kl_V1818ttt))) -> pat_cond_31 kl_V1818tt kl_V1818tth kl_V1818ttt
                                                                                                                                                                                                                                                                                                                                                 _ -> pat_cond_37
                                                                                                                                                                                                                                                                                                                            case kl_if_30 of
                                                                                                                                                                                                                                                                                                                                Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                        pat_cond_38 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                     in case kl_V1818th of
                                                                                                                                                                                                                                                                            !(kl_V1818th@(Cons (!kl_V1818thh)
                                                                                                                                                                                                                                                                                               (!kl_V1818tht))) -> pat_cond_29 kl_V1818th kl_V1818thh kl_V1818tht
                                                                                                                                                                                                                                                                            _ -> pat_cond_38
                                                                                                                                                                                                                                                       case kl_if_28 of
                                                                                                                                                                                                                                                           Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                           Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                           _ -> throwError "if: expected boolean"
                                                                                                                                                                                                      pat_cond_39 = do do return (Atom (B False))
                                                                                                                                                                                                   in case kl_V1818t of
                                                                                                                                                                                                          !(kl_V1818t@(Cons (!kl_V1818th)
                                                                                                                                                                                                                            (!kl_V1818tt))) -> pat_cond_27 kl_V1818t kl_V1818th kl_V1818tt
                                                                                                                                                                                                          _ -> pat_cond_39
                                                                                                                                                                                     case kl_if_26 of
                                                                                                                                                                                         Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                         Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                         _ -> throwError "if: expected boolean"
                                                                                                                                                                    pat_cond_40 = do do return (Atom (B False))
                                                                                                                                                                 in case kl_V1818h of
                                                                                                                                                                        kl_V1818h@(Atom (UnboundSym "shen.mu")) -> pat_cond_25
                                                                                                                                                                        kl_V1818h@(ApplC (PL "shen.mu"
                                                                                                                                                                                             _)) -> pat_cond_25
                                                                                                                                                                        kl_V1818h@(ApplC (Func "shen.mu"
                                                                                                                                                                                               _)) -> pat_cond_25
                                                                                                                                                                        _ -> pat_cond_40
                                                                                                                                                   case kl_if_24 of
                                                                                                                                                       Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                       Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                       _ -> throwError "if: expected boolean"
                                                                                                     pat_cond_41 = do do return (Atom (B False))
                                                                                                  in case kl_V1818 of
                                                                                                         !(kl_V1818@(Cons (!kl_V1818h)
                                                                                                                          (!kl_V1818t))) -> pat_cond_23 kl_V1818 kl_V1818h kl_V1818t
                                                                                                         _ -> pat_cond_41
                                                                                    case kl_if_22 of
                                                                                        Atom (B (True)) -> do !appl_42 <- kl_V1818 `pseq` tl kl_V1818
                                                                                                              !appl_43 <- appl_42 `pseq` hd appl_42
                                                                                                              !appl_44 <- appl_43 `pseq` hd appl_43
                                                                                                              !appl_45 <- kl_V1818 `pseq` tl kl_V1818
                                                                                                              !appl_46 <- appl_45 `pseq` hd appl_45
                                                                                                              !appl_47 <- appl_46 `pseq` tl appl_46
                                                                                                              !appl_48 <- kl_V1818 `pseq` tl kl_V1818
                                                                                                              !appl_49 <- appl_48 `pseq` tl appl_48
                                                                                                              !appl_50 <- appl_47 `pseq` (appl_49 `pseq` klCons appl_47 appl_49)
                                                                                                              !appl_51 <- appl_50 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.mu")) appl_50
                                                                                                              !appl_52 <- kl_V1819 `pseq` tl kl_V1819
                                                                                                              !appl_53 <- appl_51 `pseq` (appl_52 `pseq` kl_shen_make_mu_application appl_51 appl_52)
                                                                                                              !appl_54 <- appl_53 `pseq` klCons appl_53 (Types.Atom Types.Nil)
                                                                                                              !appl_55 <- appl_44 `pseq` (appl_54 `pseq` klCons appl_44 appl_54)
                                                                                                              !appl_56 <- appl_55 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.mu")) appl_55
                                                                                                              !appl_57 <- kl_V1819 `pseq` hd kl_V1819
                                                                                                              !appl_58 <- appl_57 `pseq` klCons appl_57 (Types.Atom Types.Nil)
                                                                                                              appl_56 `pseq` (appl_58 `pseq` klCons appl_56 appl_58)
                                                                                        Atom (B (False)) -> do do let !aw_59 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                                                                  applyWrapper aw_59 [ApplC (wrapNamed "shen.make_mu_application" kl_shen_make_mu_application)]
                                                                                        _ -> throwError "if: expected boolean"
                                                             _ -> throwError "if: expected boolean"

kl_shen_mu_reduction :: Types.KLValue ->
                        Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_mu_reduction (!kl_V1828) (!kl_V1829) = do let pat_cond_0 kl_V1828 kl_V1828h kl_V1828ht kl_V1828hth kl_V1828htht kl_V1828hthth kl_V1828hthtt kl_V1828hthtth kl_V1828htt kl_V1828htth kl_V1828t kl_V1828th = do !appl_1 <- kl_V1828hthth `pseq` (kl_V1828htt `pseq` klCons kl_V1828hthth kl_V1828htt)
                                                                                                                                                                                                                      !appl_2 <- appl_1 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.mu")) appl_1
                                                                                                                                                                                                                      !appl_3 <- appl_2 `pseq` (kl_V1828t `pseq` klCons appl_2 kl_V1828t)
                                                                                                                                                                                                                      appl_3 `pseq` (kl_V1828hthtth `pseq` kl_shen_mu_reduction appl_3 kl_V1828hthtth)
                                                      pat_cond_4 kl_V1828 kl_V1828h kl_V1828ht kl_V1828htt kl_V1828htth kl_V1828t kl_V1828th = do kl_V1828htth `pseq` (kl_V1829 `pseq` kl_shen_mu_reduction kl_V1828htth kl_V1829)
                                                      pat_cond_5 = do !kl_if_6 <- let pat_cond_7 kl_V1828 kl_V1828h kl_V1828t = do !kl_if_8 <- let pat_cond_9 kl_V1828h kl_V1828hh kl_V1828ht = do !kl_if_10 <- let pat_cond_11 = do !kl_if_12 <- let pat_cond_13 kl_V1828ht kl_V1828hth kl_V1828htt = do !kl_if_14 <- let pat_cond_15 kl_V1828htt kl_V1828htth kl_V1828httt = do !kl_if_16 <- let pat_cond_17 = do !kl_if_18 <- let pat_cond_19 kl_V1828t kl_V1828th kl_V1828tt = do !kl_if_20 <- let pat_cond_21 = do !kl_if_22 <- kl_V1828hth `pseq` (kl_V1828th `pseq` kl_shen_ephemeral_variableP kl_V1828hth kl_V1828th)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        case kl_if_22 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       pat_cond_23 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    in case kl_V1828tt of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           kl_V1828tt@(Atom (Nil)) -> pat_cond_21
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           _ -> pat_cond_23
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      case kl_if_20 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                     pat_cond_24 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                  in case kl_V1828t of
                                                                                                                                                                                                                                                                                                                                                                                                                                         !(kl_V1828t@(Cons (!kl_V1828th)
                                                                                                                                                                                                                                                                                                                                                                                                                                                           (!kl_V1828tt))) -> pat_cond_19 kl_V1828t kl_V1828th kl_V1828tt
                                                                                                                                                                                                                                                                                                                                                                                                                                         _ -> pat_cond_24
                                                                                                                                                                                                                                                                                                                                                                                                                    case kl_if_18 of
                                                                                                                                                                                                                                                                                                                                                                                                                        Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                        Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                        _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                   pat_cond_25 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                in case kl_V1828httt of
                                                                                                                                                                                                                                                                                                                                                                                                       kl_V1828httt@(Atom (Nil)) -> pat_cond_17
                                                                                                                                                                                                                                                                                                                                                                                                       _ -> pat_cond_25
                                                                                                                                                                                                                                                                                                                                                                                  case kl_if_16 of
                                                                                                                                                                                                                                                                                                                                                                                      Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                      Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                      _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                           pat_cond_26 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                        in case kl_V1828htt of
                                                                                                                                                                                                                                                                                                                               !(kl_V1828htt@(Cons (!kl_V1828htth)
                                                                                                                                                                                                                                                                                                                                                   (!kl_V1828httt))) -> pat_cond_15 kl_V1828htt kl_V1828htth kl_V1828httt
                                                                                                                                                                                                                                                                                                                               _ -> pat_cond_26
                                                                                                                                                                                                                                                                                                          case kl_if_14 of
                                                                                                                                                                                                                                                                                                              Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                              Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                              _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                      pat_cond_27 = do do return (Atom (B False))
                                                                                                                                                                                                                                                   in case kl_V1828ht of
                                                                                                                                                                                                                                                          !(kl_V1828ht@(Cons (!kl_V1828hth)
                                                                                                                                                                                                                                                                             (!kl_V1828htt))) -> pat_cond_13 kl_V1828ht kl_V1828hth kl_V1828htt
                                                                                                                                                                                                                                                          _ -> pat_cond_27
                                                                                                                                                                                                                                     case kl_if_12 of
                                                                                                                                                                                                                                         Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                         Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                         _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                    pat_cond_28 = do do return (Atom (B False))
                                                                                                                                                                                                                 in case kl_V1828hh of
                                                                                                                                                                                                                        kl_V1828hh@(Atom (UnboundSym "shen.mu")) -> pat_cond_11
                                                                                                                                                                                                                        kl_V1828hh@(ApplC (PL "shen.mu"
                                                                                                                                                                                                                                              _)) -> pat_cond_11
                                                                                                                                                                                                                        kl_V1828hh@(ApplC (Func "shen.mu"
                                                                                                                                                                                                                                                _)) -> pat_cond_11
                                                                                                                                                                                                                        _ -> pat_cond_28
                                                                                                                                                                                                   case kl_if_10 of
                                                                                                                                                                                                       Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                       Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                       _ -> throwError "if: expected boolean"
                                                                                                                                                   pat_cond_29 = do do return (Atom (B False))
                                                                                                                                                in case kl_V1828h of
                                                                                                                                                       !(kl_V1828h@(Cons (!kl_V1828hh)
                                                                                                                                                                         (!kl_V1828ht))) -> pat_cond_9 kl_V1828h kl_V1828hh kl_V1828ht
                                                                                                                                                       _ -> pat_cond_29
                                                                                                                                   case kl_if_8 of
                                                                                                                                       Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                       Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                       _ -> throwError "if: expected boolean"
                                                                                      pat_cond_30 = do do return (Atom (B False))
                                                                                   in case kl_V1828 of
                                                                                          !(kl_V1828@(Cons (!kl_V1828h)
                                                                                                           (!kl_V1828t))) -> pat_cond_7 kl_V1828 kl_V1828h kl_V1828t
                                                                                          _ -> pat_cond_30
                                                                      case kl_if_6 of
                                                                          Atom (B (True)) -> do !appl_31 <- kl_V1828 `pseq` tl kl_V1828
                                                                                                !appl_32 <- appl_31 `pseq` hd appl_31
                                                                                                !appl_33 <- kl_V1828 `pseq` hd kl_V1828
                                                                                                !appl_34 <- appl_33 `pseq` tl appl_33
                                                                                                !appl_35 <- appl_34 `pseq` hd appl_34
                                                                                                !appl_36 <- kl_V1828 `pseq` hd kl_V1828
                                                                                                !appl_37 <- appl_36 `pseq` tl appl_36
                                                                                                !appl_38 <- appl_37 `pseq` tl appl_37
                                                                                                !appl_39 <- appl_38 `pseq` hd appl_38
                                                                                                !appl_40 <- appl_39 `pseq` (kl_V1829 `pseq` kl_shen_mu_reduction appl_39 kl_V1829)
                                                                                                appl_32 `pseq` (appl_35 `pseq` (appl_40 `pseq` kl_subst appl_32 appl_35 appl_40))
                                                                          Atom (B (False)) -> do !kl_if_41 <- let pat_cond_42 kl_V1828 kl_V1828h kl_V1828t = do !kl_if_43 <- let pat_cond_44 kl_V1828h kl_V1828hh kl_V1828ht = do !kl_if_45 <- let pat_cond_46 = do !kl_if_47 <- let pat_cond_48 kl_V1828ht kl_V1828hth kl_V1828htt = do !kl_if_49 <- let pat_cond_50 kl_V1828htt kl_V1828htth kl_V1828httt = do !kl_if_51 <- let pat_cond_52 = do !kl_if_53 <- let pat_cond_54 kl_V1828t kl_V1828th kl_V1828tt = do !kl_if_55 <- let pat_cond_56 = do !kl_if_57 <- kl_V1828hth `pseq` kl_variableP kl_V1828hth
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       case kl_if_57 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      pat_cond_58 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   in case kl_V1828tt of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          kl_V1828tt@(Atom (Nil)) -> pat_cond_56
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          _ -> pat_cond_58
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     case kl_if_55 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    pat_cond_59 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                 in case kl_V1828t of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        !(kl_V1828t@(Cons (!kl_V1828th)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          (!kl_V1828tt))) -> pat_cond_54 kl_V1828t kl_V1828th kl_V1828tt
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        _ -> pat_cond_59
                                                                                                                                                                                                                                                                                                                                                                                                                                                   case kl_if_53 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                       Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                       Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                       _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                  pat_cond_60 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                               in case kl_V1828httt of
                                                                                                                                                                                                                                                                                                                                                                                                                                      kl_V1828httt@(Atom (Nil)) -> pat_cond_52
                                                                                                                                                                                                                                                                                                                                                                                                                                      _ -> pat_cond_60
                                                                                                                                                                                                                                                                                                                                                                                                                 case kl_if_51 of
                                                                                                                                                                                                                                                                                                                                                                                                                     Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                     Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                     _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                          pat_cond_61 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                       in case kl_V1828htt of
                                                                                                                                                                                                                                                                                                                                                              !(kl_V1828htt@(Cons (!kl_V1828htth)
                                                                                                                                                                                                                                                                                                                                                                                  (!kl_V1828httt))) -> pat_cond_50 kl_V1828htt kl_V1828htth kl_V1828httt
                                                                                                                                                                                                                                                                                                                                                              _ -> pat_cond_61
                                                                                                                                                                                                                                                                                                                                         case kl_if_49 of
                                                                                                                                                                                                                                                                                                                                             Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                             Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                             _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                     pat_cond_62 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                  in case kl_V1828ht of
                                                                                                                                                                                                                                                                                         !(kl_V1828ht@(Cons (!kl_V1828hth)
                                                                                                                                                                                                                                                                                                            (!kl_V1828htt))) -> pat_cond_48 kl_V1828ht kl_V1828hth kl_V1828htt
                                                                                                                                                                                                                                                                                         _ -> pat_cond_62
                                                                                                                                                                                                                                                                    case kl_if_47 of
                                                                                                                                                                                                                                                                        Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                        Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                        _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                   pat_cond_63 = do do return (Atom (B False))
                                                                                                                                                                                                                                                in case kl_V1828hh of
                                                                                                                                                                                                                                                       kl_V1828hh@(Atom (UnboundSym "shen.mu")) -> pat_cond_46
                                                                                                                                                                                                                                                       kl_V1828hh@(ApplC (PL "shen.mu"
                                                                                                                                                                                                                                                                             _)) -> pat_cond_46
                                                                                                                                                                                                                                                       kl_V1828hh@(ApplC (Func "shen.mu"
                                                                                                                                                                                                                                                                               _)) -> pat_cond_46
                                                                                                                                                                                                                                                       _ -> pat_cond_63
                                                                                                                                                                                                                                  case kl_if_45 of
                                                                                                                                                                                                                                      Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                      Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                      _ -> throwError "if: expected boolean"
                                                                                                                                                                                 pat_cond_64 = do do return (Atom (B False))
                                                                                                                                                                              in case kl_V1828h of
                                                                                                                                                                                     !(kl_V1828h@(Cons (!kl_V1828hh)
                                                                                                                                                                                                       (!kl_V1828ht))) -> pat_cond_44 kl_V1828h kl_V1828hh kl_V1828ht
                                                                                                                                                                                     _ -> pat_cond_64
                                                                                                                                                                case kl_if_43 of
                                                                                                                                                                    Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                    Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                    _ -> throwError "if: expected boolean"
                                                                                                                  pat_cond_65 = do do return (Atom (B False))
                                                                                                               in case kl_V1828 of
                                                                                                                      !(kl_V1828@(Cons (!kl_V1828h)
                                                                                                                                       (!kl_V1828t))) -> pat_cond_42 kl_V1828 kl_V1828h kl_V1828t
                                                                                                                      _ -> pat_cond_65
                                                                                                 case kl_if_41 of
                                                                                                     Atom (B (True)) -> do !appl_66 <- kl_V1828 `pseq` hd kl_V1828
                                                                                                                           !appl_67 <- appl_66 `pseq` tl appl_66
                                                                                                                           !appl_68 <- appl_67 `pseq` hd appl_67
                                                                                                                           !appl_69 <- kl_V1828 `pseq` tl kl_V1828
                                                                                                                           !appl_70 <- appl_69 `pseq` hd appl_69
                                                                                                                           !appl_71 <- kl_V1828 `pseq` hd kl_V1828
                                                                                                                           !appl_72 <- appl_71 `pseq` tl appl_71
                                                                                                                           !appl_73 <- appl_72 `pseq` tl appl_72
                                                                                                                           !appl_74 <- appl_73 `pseq` hd appl_73
                                                                                                                           !appl_75 <- appl_74 `pseq` (kl_V1829 `pseq` kl_shen_mu_reduction appl_74 kl_V1829)
                                                                                                                           !appl_76 <- appl_75 `pseq` klCons appl_75 (Types.Atom Types.Nil)
                                                                                                                           !appl_77 <- appl_76 `pseq` klCons (Types.Atom (Types.UnboundSym "in")) appl_76
                                                                                                                           !appl_78 <- appl_70 `pseq` (appl_77 `pseq` klCons appl_70 appl_77)
                                                                                                                           !appl_79 <- appl_78 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.be")) appl_78
                                                                                                                           !appl_80 <- appl_68 `pseq` (appl_79 `pseq` klCons appl_68 appl_79)
                                                                                                                           appl_80 `pseq` klCons (Types.Atom (Types.UnboundSym "let")) appl_80
                                                                                                     Atom (B (False)) -> do !kl_if_81 <- let pat_cond_82 kl_V1828 kl_V1828h kl_V1828t = do !kl_if_83 <- let pat_cond_84 kl_V1828h kl_V1828hh kl_V1828ht = do !kl_if_85 <- let pat_cond_86 = do !kl_if_87 <- let pat_cond_88 kl_V1828ht kl_V1828hth kl_V1828htt = do !kl_if_89 <- let pat_cond_90 kl_V1828htt kl_V1828htth kl_V1828httt = do !kl_if_91 <- let pat_cond_92 = do !kl_if_93 <- let pat_cond_94 kl_V1828t kl_V1828th kl_V1828tt = do !kl_if_95 <- let pat_cond_96 = do !kl_if_97 <- let pat_cond_98 = do !kl_if_99 <- kl_V1828hth `pseq` kl_shen_prolog_constantP kl_V1828hth
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    case kl_if_99 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   pat_cond_100 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                in case kl_V1829 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       kl_V1829@(Atom (UnboundSym "-")) -> pat_cond_98
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       kl_V1829@(ApplC (PL "-"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           _)) -> pat_cond_98
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       kl_V1829@(ApplC (Func "-"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             _)) -> pat_cond_98
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       _ -> pat_cond_100
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  case kl_if_97 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 pat_cond_101 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              in case kl_V1828tt of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     kl_V1828tt@(Atom (Nil)) -> pat_cond_96
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     _ -> pat_cond_101
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                case kl_if_95 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               pat_cond_102 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            in case kl_V1828t of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   !(kl_V1828t@(Cons (!kl_V1828th)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     (!kl_V1828tt))) -> pat_cond_94 kl_V1828t kl_V1828th kl_V1828tt
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   _ -> pat_cond_102
                                                                                                                                                                                                                                                                                                                                                                                                                                                                              case kl_if_93 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                                             pat_cond_103 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                          in case kl_V1828httt of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                 kl_V1828httt@(Atom (Nil)) -> pat_cond_92
                                                                                                                                                                                                                                                                                                                                                                                                                                                                 _ -> pat_cond_103
                                                                                                                                                                                                                                                                                                                                                                                                                                            case kl_if_91 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                     pat_cond_104 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                  in case kl_V1828htt of
                                                                                                                                                                                                                                                                                                                                                                                         !(kl_V1828htt@(Cons (!kl_V1828htth)
                                                                                                                                                                                                                                                                                                                                                                                                             (!kl_V1828httt))) -> pat_cond_90 kl_V1828htt kl_V1828htth kl_V1828httt
                                                                                                                                                                                                                                                                                                                                                                                         _ -> pat_cond_104
                                                                                                                                                                                                                                                                                                                                                                    case kl_if_89 of
                                                                                                                                                                                                                                                                                                                                                                        Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                        Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                        _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                pat_cond_105 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                             in case kl_V1828ht of
                                                                                                                                                                                                                                                                                                                    !(kl_V1828ht@(Cons (!kl_V1828hth)
                                                                                                                                                                                                                                                                                                                                       (!kl_V1828htt))) -> pat_cond_88 kl_V1828ht kl_V1828hth kl_V1828htt
                                                                                                                                                                                                                                                                                                                    _ -> pat_cond_105
                                                                                                                                                                                                                                                                                               case kl_if_87 of
                                                                                                                                                                                                                                                                                                   Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                   Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                   _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                              pat_cond_106 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                           in case kl_V1828hh of
                                                                                                                                                                                                                                                                                  kl_V1828hh@(Atom (UnboundSym "shen.mu")) -> pat_cond_86
                                                                                                                                                                                                                                                                                  kl_V1828hh@(ApplC (PL "shen.mu"
                                                                                                                                                                                                                                                                                                        _)) -> pat_cond_86
                                                                                                                                                                                                                                                                                  kl_V1828hh@(ApplC (Func "shen.mu"
                                                                                                                                                                                                                                                                                                          _)) -> pat_cond_86
                                                                                                                                                                                                                                                                                  _ -> pat_cond_106
                                                                                                                                                                                                                                                             case kl_if_85 of
                                                                                                                                                                                                                                                                 Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                 Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                 _ -> throwError "if: expected boolean"
                                                                                                                                                                                                            pat_cond_107 = do do return (Atom (B False))
                                                                                                                                                                                                         in case kl_V1828h of
                                                                                                                                                                                                                !(kl_V1828h@(Cons (!kl_V1828hh)
                                                                                                                                                                                                                                  (!kl_V1828ht))) -> pat_cond_84 kl_V1828h kl_V1828hh kl_V1828ht
                                                                                                                                                                                                                _ -> pat_cond_107
                                                                                                                                                                                           case kl_if_83 of
                                                                                                                                                                                               Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                               Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                               _ -> throwError "if: expected boolean"
                                                                                                                                             pat_cond_108 = do do return (Atom (B False))
                                                                                                                                          in case kl_V1828 of
                                                                                                                                                 !(kl_V1828@(Cons (!kl_V1828h)
                                                                                                                                                                  (!kl_V1828t))) -> pat_cond_82 kl_V1828 kl_V1828h kl_V1828t
                                                                                                                                                 _ -> pat_cond_108
                                                                                                                            case kl_if_81 of
                                                                                                                                Atom (B (True)) -> do let !appl_109 = ApplC (Func "lambda" (Context (\(!kl_Z) -> do !appl_110 <- kl_V1828 `pseq` tl kl_V1828
                                                                                                                                                                                                                    !appl_111 <- appl_110 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.dereferencing")) appl_110
                                                                                                                                                                                                                    !appl_112 <- appl_111 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.of")) appl_111
                                                                                                                                                                                                                    !appl_113 <- appl_112 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.result")) appl_112
                                                                                                                                                                                                                    !appl_114 <- appl_113 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.the")) appl_113
                                                                                                                                                                                                                    !appl_115 <- kl_V1828 `pseq` hd kl_V1828
                                                                                                                                                                                                                    !appl_116 <- appl_115 `pseq` tl appl_115
                                                                                                                                                                                                                    !appl_117 <- appl_116 `pseq` hd appl_116
                                                                                                                                                                                                                    !appl_118 <- appl_117 `pseq` klCons appl_117 (Types.Atom Types.Nil)
                                                                                                                                                                                                                    !appl_119 <- appl_118 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.to")) appl_118
                                                                                                                                                                                                                    !appl_120 <- appl_119 `pseq` klCons (ApplC (wrapNamed "identical" kl_identical)) appl_119
                                                                                                                                                                                                                    !appl_121 <- appl_120 `pseq` klCons (Types.Atom (Types.UnboundSym "is")) appl_120
                                                                                                                                                                                                                    !appl_122 <- kl_Z `pseq` (appl_121 `pseq` klCons kl_Z appl_121)
                                                                                                                                                                                                                    !appl_123 <- kl_V1828 `pseq` hd kl_V1828
                                                                                                                                                                                                                    !appl_124 <- appl_123 `pseq` tl appl_123
                                                                                                                                                                                                                    !appl_125 <- appl_124 `pseq` tl appl_124
                                                                                                                                                                                                                    !appl_126 <- appl_125 `pseq` hd appl_125
                                                                                                                                                                                                                    !appl_127 <- appl_126 `pseq` kl_shen_mu_reduction appl_126 (ApplC (wrapNamed "-" Primitives.subtract))
                                                                                                                                                                                                                    !appl_128 <- klCons (Types.Atom (Types.UnboundSym "shen.failed!")) (Types.Atom Types.Nil)
                                                                                                                                                                                                                    !appl_129 <- appl_128 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.else")) appl_128
                                                                                                                                                                                                                    !appl_130 <- appl_127 `pseq` (appl_129 `pseq` klCons appl_127 appl_129)
                                                                                                                                                                                                                    !appl_131 <- appl_130 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.then")) appl_130
                                                                                                                                                                                                                    !appl_132 <- appl_122 `pseq` (appl_131 `pseq` klCons appl_122 appl_131)
                                                                                                                                                                                                                    !appl_133 <- appl_132 `pseq` klCons (Types.Atom (Types.UnboundSym "if")) appl_132
                                                                                                                                                                                                                    !appl_134 <- appl_133 `pseq` klCons appl_133 (Types.Atom Types.Nil)
                                                                                                                                                                                                                    !appl_135 <- appl_134 `pseq` klCons (Types.Atom (Types.UnboundSym "in")) appl_134
                                                                                                                                                                                                                    !appl_136 <- appl_114 `pseq` (appl_135 `pseq` klCons appl_114 appl_135)
                                                                                                                                                                                                                    !appl_137 <- appl_136 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.be")) appl_136
                                                                                                                                                                                                                    !appl_138 <- kl_Z `pseq` (appl_137 `pseq` klCons kl_Z appl_137)
                                                                                                                                                                                                                    appl_138 `pseq` klCons (Types.Atom (Types.UnboundSym "let")) appl_138)))
                                                                                                                                                      !appl_139 <- kl_gensym (Types.Atom (Types.UnboundSym "V"))
                                                                                                                                                      appl_139 `pseq` applyWrapper appl_109 [appl_139]
                                                                                                                                Atom (B (False)) -> do !kl_if_140 <- let pat_cond_141 kl_V1828 kl_V1828h kl_V1828t = do !kl_if_142 <- let pat_cond_143 kl_V1828h kl_V1828hh kl_V1828ht = do !kl_if_144 <- let pat_cond_145 = do !kl_if_146 <- let pat_cond_147 kl_V1828ht kl_V1828hth kl_V1828htt = do !kl_if_148 <- let pat_cond_149 kl_V1828htt kl_V1828htth kl_V1828httt = do !kl_if_150 <- let pat_cond_151 = do !kl_if_152 <- let pat_cond_153 kl_V1828t kl_V1828th kl_V1828tt = do !kl_if_154 <- let pat_cond_155 = do !kl_if_156 <- let pat_cond_157 = do !kl_if_158 <- kl_V1828hth `pseq` kl_shen_prolog_constantP kl_V1828hth
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 case kl_if_158 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               pat_cond_159 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            in case kl_V1829 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   kl_V1829@(Atom (UnboundSym "+")) -> pat_cond_157
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   kl_V1829@(ApplC (PL "+"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       _)) -> pat_cond_157
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   kl_V1829@(ApplC (Func "+"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         _)) -> pat_cond_157
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   _ -> pat_cond_159
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             case kl_if_156 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           pat_cond_160 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        in case kl_V1828tt of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               kl_V1828tt@(Atom (Nil)) -> pat_cond_155
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               _ -> pat_cond_160
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         case kl_if_154 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       pat_cond_161 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    in case kl_V1828t of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           !(kl_V1828t@(Cons (!kl_V1828th)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             (!kl_V1828tt))) -> pat_cond_153 kl_V1828t kl_V1828th kl_V1828tt
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           _ -> pat_cond_161
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     case kl_if_152 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   pat_cond_162 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                in case kl_V1828httt of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       kl_V1828httt@(Atom (Nil)) -> pat_cond_151
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       _ -> pat_cond_162
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 case kl_if_150 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                         pat_cond_163 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                      in case kl_V1828htt of
                                                                                                                                                                                                                                                                                                                                                                                                                             !(kl_V1828htt@(Cons (!kl_V1828htth)
                                                                                                                                                                                                                                                                                                                                                                                                                                                 (!kl_V1828httt))) -> pat_cond_149 kl_V1828htt kl_V1828htth kl_V1828httt
                                                                                                                                                                                                                                                                                                                                                                                                                             _ -> pat_cond_163
                                                                                                                                                                                                                                                                                                                                                                                                       case kl_if_148 of
                                                                                                                                                                                                                                                                                                                                                                                                           Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                           Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                           _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                  pat_cond_164 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                               in case kl_V1828ht of
                                                                                                                                                                                                                                                                                                                                                      !(kl_V1828ht@(Cons (!kl_V1828hth)
                                                                                                                                                                                                                                                                                                                                                                         (!kl_V1828htt))) -> pat_cond_147 kl_V1828ht kl_V1828hth kl_V1828htt
                                                                                                                                                                                                                                                                                                                                                      _ -> pat_cond_164
                                                                                                                                                                                                                                                                                                                                case kl_if_146 of
                                                                                                                                                                                                                                                                                                                                    Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                    Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                    _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                              pat_cond_165 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                           in case kl_V1828hh of
                                                                                                                                                                                                                                                                                                                  kl_V1828hh@(Atom (UnboundSym "shen.mu")) -> pat_cond_145
                                                                                                                                                                                                                                                                                                                  kl_V1828hh@(ApplC (PL "shen.mu"
                                                                                                                                                                                                                                                                                                                                        _)) -> pat_cond_145
                                                                                                                                                                                                                                                                                                                  kl_V1828hh@(ApplC (Func "shen.mu"
                                                                                                                                                                                                                                                                                                                                          _)) -> pat_cond_145
                                                                                                                                                                                                                                                                                                                  _ -> pat_cond_165
                                                                                                                                                                                                                                                                                            case kl_if_144 of
                                                                                                                                                                                                                                                                                                Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                          pat_cond_166 = do do return (Atom (B False))
                                                                                                                                                                                                                                       in case kl_V1828h of
                                                                                                                                                                                                                                              !(kl_V1828h@(Cons (!kl_V1828hh)
                                                                                                                                                                                                                                                                (!kl_V1828ht))) -> pat_cond_143 kl_V1828h kl_V1828hh kl_V1828ht
                                                                                                                                                                                                                                              _ -> pat_cond_166
                                                                                                                                                                                                                        case kl_if_142 of
                                                                                                                                                                                                                            Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                            Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                            _ -> throwError "if: expected boolean"
                                                                                                                                                                         pat_cond_167 = do do return (Atom (B False))
                                                                                                                                                                      in case kl_V1828 of
                                                                                                                                                                             !(kl_V1828@(Cons (!kl_V1828h)
                                                                                                                                                                                              (!kl_V1828t))) -> pat_cond_141 kl_V1828 kl_V1828h kl_V1828t
                                                                                                                                                                             _ -> pat_cond_167
                                                                                                                                                       case kl_if_140 of
                                                                                                                                                           Atom (B (True)) -> do let !appl_168 = ApplC (Func "lambda" (Context (\(!kl_Z) -> do !appl_169 <- kl_V1828 `pseq` tl kl_V1828
                                                                                                                                                                                                                                               !appl_170 <- appl_169 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.dereferencing")) appl_169
                                                                                                                                                                                                                                               !appl_171 <- appl_170 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.of")) appl_170
                                                                                                                                                                                                                                               !appl_172 <- appl_171 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.result")) appl_171
                                                                                                                                                                                                                                               !appl_173 <- appl_172 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.the")) appl_172
                                                                                                                                                                                                                                               !appl_174 <- kl_V1828 `pseq` hd kl_V1828
                                                                                                                                                                                                                                               !appl_175 <- appl_174 `pseq` tl appl_174
                                                                                                                                                                                                                                               !appl_176 <- appl_175 `pseq` hd appl_175
                                                                                                                                                                                                                                               !appl_177 <- appl_176 `pseq` klCons appl_176 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                               !appl_178 <- appl_177 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.to")) appl_177
                                                                                                                                                                                                                                               !appl_179 <- appl_178 `pseq` klCons (ApplC (wrapNamed "identical" kl_identical)) appl_178
                                                                                                                                                                                                                                               !appl_180 <- appl_179 `pseq` klCons (Types.Atom (Types.UnboundSym "is")) appl_179
                                                                                                                                                                                                                                               !appl_181 <- kl_Z `pseq` (appl_180 `pseq` klCons kl_Z appl_180)
                                                                                                                                                                                                                                               !appl_182 <- kl_V1828 `pseq` hd kl_V1828
                                                                                                                                                                                                                                               !appl_183 <- appl_182 `pseq` tl appl_182
                                                                                                                                                                                                                                               !appl_184 <- appl_183 `pseq` tl appl_183
                                                                                                                                                                                                                                               !appl_185 <- appl_184 `pseq` hd appl_184
                                                                                                                                                                                                                                               !appl_186 <- appl_185 `pseq` kl_shen_mu_reduction appl_185 (ApplC (wrapNamed "+" add))
                                                                                                                                                                                                                                               !appl_187 <- klCons (Types.Atom (Types.UnboundSym "shen.variable")) (Types.Atom Types.Nil)
                                                                                                                                                                                                                                               !appl_188 <- appl_187 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.a")) appl_187
                                                                                                                                                                                                                                               !appl_189 <- appl_188 `pseq` klCons (Types.Atom (Types.UnboundSym "is")) appl_188
                                                                                                                                                                                                                                               !appl_190 <- kl_Z `pseq` (appl_189 `pseq` klCons kl_Z appl_189)
                                                                                                                                                                                                                                               !appl_191 <- kl_V1828 `pseq` hd kl_V1828
                                                                                                                                                                                                                                               !appl_192 <- appl_191 `pseq` tl appl_191
                                                                                                                                                                                                                                               !appl_193 <- appl_192 `pseq` hd appl_192
                                                                                                                                                                                                                                               !appl_194 <- kl_V1828 `pseq` hd kl_V1828
                                                                                                                                                                                                                                               !appl_195 <- appl_194 `pseq` tl appl_194
                                                                                                                                                                                                                                               !appl_196 <- appl_195 `pseq` tl appl_195
                                                                                                                                                                                                                                               !appl_197 <- appl_196 `pseq` hd appl_196
                                                                                                                                                                                                                                               !appl_198 <- appl_197 `pseq` kl_shen_mu_reduction appl_197 (ApplC (wrapNamed "+" add))
                                                                                                                                                                                                                                               !appl_199 <- appl_198 `pseq` klCons appl_198 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                               !appl_200 <- appl_199 `pseq` klCons (Types.Atom (Types.UnboundSym "in")) appl_199
                                                                                                                                                                                                                                               !appl_201 <- appl_193 `pseq` (appl_200 `pseq` klCons appl_193 appl_200)
                                                                                                                                                                                                                                               !appl_202 <- appl_201 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.to")) appl_201
                                                                                                                                                                                                                                               !appl_203 <- kl_Z `pseq` (appl_202 `pseq` klCons kl_Z appl_202)
                                                                                                                                                                                                                                               !appl_204 <- appl_203 `pseq` klCons (ApplC (wrapNamed "bind" kl_bind)) appl_203
                                                                                                                                                                                                                                               !appl_205 <- klCons (Types.Atom (Types.UnboundSym "shen.failed!")) (Types.Atom Types.Nil)
                                                                                                                                                                                                                                               !appl_206 <- appl_205 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.else")) appl_205
                                                                                                                                                                                                                                               !appl_207 <- appl_204 `pseq` (appl_206 `pseq` klCons appl_204 appl_206)
                                                                                                                                                                                                                                               !appl_208 <- appl_207 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.then")) appl_207
                                                                                                                                                                                                                                               !appl_209 <- appl_190 `pseq` (appl_208 `pseq` klCons appl_190 appl_208)
                                                                                                                                                                                                                                               !appl_210 <- appl_209 `pseq` klCons (Types.Atom (Types.UnboundSym "if")) appl_209
                                                                                                                                                                                                                                               !appl_211 <- appl_210 `pseq` klCons appl_210 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                               !appl_212 <- appl_211 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.else")) appl_211
                                                                                                                                                                                                                                               !appl_213 <- appl_186 `pseq` (appl_212 `pseq` klCons appl_186 appl_212)
                                                                                                                                                                                                                                               !appl_214 <- appl_213 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.then")) appl_213
                                                                                                                                                                                                                                               !appl_215 <- appl_181 `pseq` (appl_214 `pseq` klCons appl_181 appl_214)
                                                                                                                                                                                                                                               !appl_216 <- appl_215 `pseq` klCons (Types.Atom (Types.UnboundSym "if")) appl_215
                                                                                                                                                                                                                                               !appl_217 <- appl_216 `pseq` klCons appl_216 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                               !appl_218 <- appl_217 `pseq` klCons (Types.Atom (Types.UnboundSym "in")) appl_217
                                                                                                                                                                                                                                               !appl_219 <- appl_173 `pseq` (appl_218 `pseq` klCons appl_173 appl_218)
                                                                                                                                                                                                                                               !appl_220 <- appl_219 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.be")) appl_219
                                                                                                                                                                                                                                               !appl_221 <- kl_Z `pseq` (appl_220 `pseq` klCons kl_Z appl_220)
                                                                                                                                                                                                                                               appl_221 `pseq` klCons (Types.Atom (Types.UnboundSym "let")) appl_221)))
                                                                                                                                                                                 !appl_222 <- kl_gensym (Types.Atom (Types.UnboundSym "V"))
                                                                                                                                                                                 appl_222 `pseq` applyWrapper appl_168 [appl_222]
                                                                                                                                                           Atom (B (False)) -> do !kl_if_223 <- let pat_cond_224 kl_V1828 kl_V1828h kl_V1828t = do !kl_if_225 <- let pat_cond_226 kl_V1828h kl_V1828hh kl_V1828ht = do !kl_if_227 <- let pat_cond_228 = do !kl_if_229 <- let pat_cond_230 kl_V1828ht kl_V1828hth kl_V1828htt = do !kl_if_231 <- let pat_cond_232 kl_V1828hth kl_V1828hthh kl_V1828htht = do !kl_if_233 <- let pat_cond_234 kl_V1828htt kl_V1828htth kl_V1828httt = do !kl_if_235 <- let pat_cond_236 = do !kl_if_237 <- let pat_cond_238 kl_V1828t kl_V1828th kl_V1828tt = do !kl_if_239 <- let pat_cond_240 = do let pat_cond_241 = do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      pat_cond_242 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   in case kl_V1829 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          kl_V1829@(Atom (UnboundSym "-")) -> pat_cond_241
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          kl_V1829@(ApplC (PL "-"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              _)) -> pat_cond_241
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          kl_V1829@(ApplC (Func "-"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                _)) -> pat_cond_241
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          _ -> pat_cond_242
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                pat_cond_243 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             in case kl_V1828tt of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    kl_V1828tt@(Atom (Nil)) -> pat_cond_240
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    _ -> pat_cond_243
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              case kl_if_239 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            pat_cond_244 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         in case kl_V1828t of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !(kl_V1828t@(Cons (!kl_V1828th)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  (!kl_V1828tt))) -> pat_cond_238 kl_V1828t kl_V1828th kl_V1828tt
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                _ -> pat_cond_244
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          case kl_if_237 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        pat_cond_245 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     in case kl_V1828httt of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            kl_V1828httt@(Atom (Nil)) -> pat_cond_236
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            _ -> pat_cond_245
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      case kl_if_235 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              pat_cond_246 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           in case kl_V1828htt of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !(kl_V1828htt@(Cons (!kl_V1828htth)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      (!kl_V1828httt))) -> pat_cond_234 kl_V1828htt kl_V1828htth kl_V1828httt
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  _ -> pat_cond_246
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            case kl_if_233 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                                    pat_cond_247 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                 in case kl_V1828hth of
                                                                                                                                                                                                                                                                                                                                                                                                                                                        !(kl_V1828hth@(Cons (!kl_V1828hthh)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            (!kl_V1828htht))) -> pat_cond_232 kl_V1828hth kl_V1828hthh kl_V1828htht
                                                                                                                                                                                                                                                                                                                                                                                                                                                        _ -> pat_cond_247
                                                                                                                                                                                                                                                                                                                                                                                                                                  case kl_if_231 of
                                                                                                                                                                                                                                                                                                                                                                                                                                      Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                      Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                      _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                             pat_cond_248 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                          in case kl_V1828ht of
                                                                                                                                                                                                                                                                                                                                                                                 !(kl_V1828ht@(Cons (!kl_V1828hth)
                                                                                                                                                                                                                                                                                                                                                                                                    (!kl_V1828htt))) -> pat_cond_230 kl_V1828ht kl_V1828hth kl_V1828htt
                                                                                                                                                                                                                                                                                                                                                                                 _ -> pat_cond_248
                                                                                                                                                                                                                                                                                                                                                           case kl_if_229 of
                                                                                                                                                                                                                                                                                                                                                               Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                               Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                               _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                         pat_cond_249 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                      in case kl_V1828hh of
                                                                                                                                                                                                                                                                                                                                             kl_V1828hh@(Atom (UnboundSym "shen.mu")) -> pat_cond_228
                                                                                                                                                                                                                                                                                                                                             kl_V1828hh@(ApplC (PL "shen.mu"
                                                                                                                                                                                                                                                                                                                                                                   _)) -> pat_cond_228
                                                                                                                                                                                                                                                                                                                                             kl_V1828hh@(ApplC (Func "shen.mu"
                                                                                                                                                                                                                                                                                                                                                                     _)) -> pat_cond_228
                                                                                                                                                                                                                                                                                                                                             _ -> pat_cond_249
                                                                                                                                                                                                                                                                                                                       case kl_if_227 of
                                                                                                                                                                                                                                                                                                                           Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                           Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                           _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                     pat_cond_250 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                  in case kl_V1828h of
                                                                                                                                                                                                                                                                         !(kl_V1828h@(Cons (!kl_V1828hh)
                                                                                                                                                                                                                                                                                           (!kl_V1828ht))) -> pat_cond_226 kl_V1828h kl_V1828hh kl_V1828ht
                                                                                                                                                                                                                                                                         _ -> pat_cond_250
                                                                                                                                                                                                                                                   case kl_if_225 of
                                                                                                                                                                                                                                                       Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                       Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                       _ -> throwError "if: expected boolean"
                                                                                                                                                                                                    pat_cond_251 = do do return (Atom (B False))
                                                                                                                                                                                                 in case kl_V1828 of
                                                                                                                                                                                                        !(kl_V1828@(Cons (!kl_V1828h)
                                                                                                                                                                                                                         (!kl_V1828t))) -> pat_cond_224 kl_V1828 kl_V1828h kl_V1828t
                                                                                                                                                                                                        _ -> pat_cond_251
                                                                                                                                                                                  case kl_if_223 of
                                                                                                                                                                                      Atom (B (True)) -> do let !appl_252 = ApplC (Func "lambda" (Context (\(!kl_Z) -> do !appl_253 <- kl_V1828 `pseq` tl kl_V1828
                                                                                                                                                                                                                                                                          !appl_254 <- appl_253 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.dereferencing")) appl_253
                                                                                                                                                                                                                                                                          !appl_255 <- appl_254 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.of")) appl_254
                                                                                                                                                                                                                                                                          !appl_256 <- appl_255 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.result")) appl_255
                                                                                                                                                                                                                                                                          !appl_257 <- appl_256 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.the")) appl_256
                                                                                                                                                                                                                                                                          !appl_258 <- klCons (Types.Atom (Types.UnboundSym "list")) (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                          !appl_259 <- appl_258 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.non-empty")) appl_258
                                                                                                                                                                                                                                                                          !appl_260 <- appl_259 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.a")) appl_259
                                                                                                                                                                                                                                                                          !appl_261 <- appl_260 `pseq` klCons (Types.Atom (Types.UnboundSym "is")) appl_260
                                                                                                                                                                                                                                                                          !appl_262 <- kl_Z `pseq` (appl_261 `pseq` klCons kl_Z appl_261)
                                                                                                                                                                                                                                                                          !appl_263 <- kl_V1828 `pseq` hd kl_V1828
                                                                                                                                                                                                                                                                          !appl_264 <- appl_263 `pseq` tl appl_263
                                                                                                                                                                                                                                                                          !appl_265 <- appl_264 `pseq` hd appl_264
                                                                                                                                                                                                                                                                          !appl_266 <- appl_265 `pseq` hd appl_265
                                                                                                                                                                                                                                                                          !appl_267 <- kl_V1828 `pseq` hd kl_V1828
                                                                                                                                                                                                                                                                          !appl_268 <- appl_267 `pseq` tl appl_267
                                                                                                                                                                                                                                                                          !appl_269 <- appl_268 `pseq` hd appl_268
                                                                                                                                                                                                                                                                          !appl_270 <- appl_269 `pseq` tl appl_269
                                                                                                                                                                                                                                                                          !appl_271 <- kl_V1828 `pseq` hd kl_V1828
                                                                                                                                                                                                                                                                          !appl_272 <- appl_271 `pseq` tl appl_271
                                                                                                                                                                                                                                                                          !appl_273 <- appl_272 `pseq` tl appl_272
                                                                                                                                                                                                                                                                          !appl_274 <- appl_270 `pseq` (appl_273 `pseq` klCons appl_270 appl_273)
                                                                                                                                                                                                                                                                          !appl_275 <- appl_274 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.mu")) appl_274
                                                                                                                                                                                                                                                                          !appl_276 <- kl_Z `pseq` klCons kl_Z (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                          !appl_277 <- appl_276 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.of")) appl_276
                                                                                                                                                                                                                                                                          !appl_278 <- appl_277 `pseq` klCons (ApplC (wrapNamed "tail" kl_tail)) appl_277
                                                                                                                                                                                                                                                                          !appl_279 <- appl_278 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.the")) appl_278
                                                                                                                                                                                                                                                                          !appl_280 <- appl_279 `pseq` klCons appl_279 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                          !appl_281 <- appl_275 `pseq` (appl_280 `pseq` klCons appl_275 appl_280)
                                                                                                                                                                                                                                                                          !appl_282 <- appl_281 `pseq` klCons appl_281 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                          !appl_283 <- appl_266 `pseq` (appl_282 `pseq` klCons appl_266 appl_282)
                                                                                                                                                                                                                                                                          !appl_284 <- appl_283 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.mu")) appl_283
                                                                                                                                                                                                                                                                          !appl_285 <- kl_Z `pseq` klCons kl_Z (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                          !appl_286 <- appl_285 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.of")) appl_285
                                                                                                                                                                                                                                                                          !appl_287 <- appl_286 `pseq` klCons (ApplC (wrapNamed "head" kl_head)) appl_286
                                                                                                                                                                                                                                                                          !appl_288 <- appl_287 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.the")) appl_287
                                                                                                                                                                                                                                                                          !appl_289 <- appl_288 `pseq` klCons appl_288 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                          !appl_290 <- appl_284 `pseq` (appl_289 `pseq` klCons appl_284 appl_289)
                                                                                                                                                                                                                                                                          !appl_291 <- appl_290 `pseq` kl_shen_mu_reduction appl_290 (ApplC (wrapNamed "-" Primitives.subtract))
                                                                                                                                                                                                                                                                          !appl_292 <- klCons (Types.Atom (Types.UnboundSym "shen.failed!")) (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                          !appl_293 <- appl_292 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.else")) appl_292
                                                                                                                                                                                                                                                                          !appl_294 <- appl_291 `pseq` (appl_293 `pseq` klCons appl_291 appl_293)
                                                                                                                                                                                                                                                                          !appl_295 <- appl_294 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.then")) appl_294
                                                                                                                                                                                                                                                                          !appl_296 <- appl_262 `pseq` (appl_295 `pseq` klCons appl_262 appl_295)
                                                                                                                                                                                                                                                                          !appl_297 <- appl_296 `pseq` klCons (Types.Atom (Types.UnboundSym "if")) appl_296
                                                                                                                                                                                                                                                                          !appl_298 <- appl_297 `pseq` klCons appl_297 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                          !appl_299 <- appl_298 `pseq` klCons (Types.Atom (Types.UnboundSym "in")) appl_298
                                                                                                                                                                                                                                                                          !appl_300 <- appl_257 `pseq` (appl_299 `pseq` klCons appl_257 appl_299)
                                                                                                                                                                                                                                                                          !appl_301 <- appl_300 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.be")) appl_300
                                                                                                                                                                                                                                                                          !appl_302 <- kl_Z `pseq` (appl_301 `pseq` klCons kl_Z appl_301)
                                                                                                                                                                                                                                                                          appl_302 `pseq` klCons (Types.Atom (Types.UnboundSym "let")) appl_302)))
                                                                                                                                                                                                            !appl_303 <- kl_gensym (Types.Atom (Types.UnboundSym "V"))
                                                                                                                                                                                                            appl_303 `pseq` applyWrapper appl_252 [appl_303]
                                                                                                                                                                                      Atom (B (False)) -> do !kl_if_304 <- let pat_cond_305 kl_V1828 kl_V1828h kl_V1828t = do !kl_if_306 <- let pat_cond_307 kl_V1828h kl_V1828hh kl_V1828ht = do !kl_if_308 <- let pat_cond_309 = do !kl_if_310 <- let pat_cond_311 kl_V1828ht kl_V1828hth kl_V1828htt = do !kl_if_312 <- let pat_cond_313 kl_V1828hth kl_V1828hthh kl_V1828htht = do !kl_if_314 <- let pat_cond_315 kl_V1828htt kl_V1828htth kl_V1828httt = do !kl_if_316 <- let pat_cond_317 = do !kl_if_318 <- let pat_cond_319 kl_V1828t kl_V1828th kl_V1828tt = do !kl_if_320 <- let pat_cond_321 = do let pat_cond_322 = do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 pat_cond_323 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              in case kl_V1829 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     kl_V1829@(Atom (UnboundSym "+")) -> pat_cond_322
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     kl_V1829@(ApplC (PL "+"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         _)) -> pat_cond_322
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     kl_V1829@(ApplC (Func "+"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           _)) -> pat_cond_322
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     _ -> pat_cond_323
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           pat_cond_324 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        in case kl_V1828tt of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               kl_V1828tt@(Atom (Nil)) -> pat_cond_321
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               _ -> pat_cond_324
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         case kl_if_320 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       pat_cond_325 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    in case kl_V1828t of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           !(kl_V1828t@(Cons (!kl_V1828th)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             (!kl_V1828tt))) -> pat_cond_319 kl_V1828t kl_V1828th kl_V1828tt
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           _ -> pat_cond_325
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     case kl_if_318 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   pat_cond_326 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                in case kl_V1828httt of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       kl_V1828httt@(Atom (Nil)) -> pat_cond_317
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       _ -> pat_cond_326
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 case kl_if_316 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         pat_cond_327 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      in case kl_V1828htt of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             !(kl_V1828htt@(Cons (!kl_V1828htth)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 (!kl_V1828httt))) -> pat_cond_315 kl_V1828htt kl_V1828htth kl_V1828httt
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             _ -> pat_cond_327
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       case kl_if_314 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                               pat_cond_328 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            in case kl_V1828hth of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   !(kl_V1828hth@(Cons (!kl_V1828hthh)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       (!kl_V1828htht))) -> pat_cond_313 kl_V1828hth kl_V1828hthh kl_V1828htht
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   _ -> pat_cond_328
                                                                                                                                                                                                                                                                                                                                                                                                                                                             case kl_if_312 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                 Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                 Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                 _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                        pat_cond_329 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                     in case kl_V1828ht of
                                                                                                                                                                                                                                                                                                                                                                                                            !(kl_V1828ht@(Cons (!kl_V1828hth)
                                                                                                                                                                                                                                                                                                                                                                                                                               (!kl_V1828htt))) -> pat_cond_311 kl_V1828ht kl_V1828hth kl_V1828htt
                                                                                                                                                                                                                                                                                                                                                                                                            _ -> pat_cond_329
                                                                                                                                                                                                                                                                                                                                                                                      case kl_if_310 of
                                                                                                                                                                                                                                                                                                                                                                                          Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                                                          Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                          _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                    pat_cond_330 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                 in case kl_V1828hh of
                                                                                                                                                                                                                                                                                                                                                                        kl_V1828hh@(Atom (UnboundSym "shen.mu")) -> pat_cond_309
                                                                                                                                                                                                                                                                                                                                                                        kl_V1828hh@(ApplC (PL "shen.mu"
                                                                                                                                                                                                                                                                                                                                                                                              _)) -> pat_cond_309
                                                                                                                                                                                                                                                                                                                                                                        kl_V1828hh@(ApplC (Func "shen.mu"
                                                                                                                                                                                                                                                                                                                                                                                                _)) -> pat_cond_309
                                                                                                                                                                                                                                                                                                                                                                        _ -> pat_cond_330
                                                                                                                                                                                                                                                                                                                                                  case kl_if_308 of
                                                                                                                                                                                                                                                                                                                                                      Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                      Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                      _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                pat_cond_331 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                             in case kl_V1828h of
                                                                                                                                                                                                                                                                                                    !(kl_V1828h@(Cons (!kl_V1828hh)
                                                                                                                                                                                                                                                                                                                      (!kl_V1828ht))) -> pat_cond_307 kl_V1828h kl_V1828hh kl_V1828ht
                                                                                                                                                                                                                                                                                                    _ -> pat_cond_331
                                                                                                                                                                                                                                                                              case kl_if_306 of
                                                                                                                                                                                                                                                                                  Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                  Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                  _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                               pat_cond_332 = do do return (Atom (B False))
                                                                                                                                                                                                                            in case kl_V1828 of
                                                                                                                                                                                                                                   !(kl_V1828@(Cons (!kl_V1828h)
                                                                                                                                                                                                                                                    (!kl_V1828t))) -> pat_cond_305 kl_V1828 kl_V1828h kl_V1828t
                                                                                                                                                                                                                                   _ -> pat_cond_332
                                                                                                                                                                                                             case kl_if_304 of
                                                                                                                                                                                                                 Atom (B (True)) -> do let !appl_333 = ApplC (Func "lambda" (Context (\(!kl_Z) -> do !appl_334 <- kl_V1828 `pseq` tl kl_V1828
                                                                                                                                                                                                                                                                                                     !appl_335 <- appl_334 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.dereferencing")) appl_334
                                                                                                                                                                                                                                                                                                     !appl_336 <- appl_335 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.of")) appl_335
                                                                                                                                                                                                                                                                                                     !appl_337 <- appl_336 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.result")) appl_336
                                                                                                                                                                                                                                                                                                     !appl_338 <- appl_337 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.the")) appl_337
                                                                                                                                                                                                                                                                                                     !appl_339 <- klCons (Types.Atom (Types.UnboundSym "list")) (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                     !appl_340 <- appl_339 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.non-empty")) appl_339
                                                                                                                                                                                                                                                                                                     !appl_341 <- appl_340 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.a")) appl_340
                                                                                                                                                                                                                                                                                                     !appl_342 <- appl_341 `pseq` klCons (Types.Atom (Types.UnboundSym "is")) appl_341
                                                                                                                                                                                                                                                                                                     !appl_343 <- kl_Z `pseq` (appl_342 `pseq` klCons kl_Z appl_342)
                                                                                                                                                                                                                                                                                                     !appl_344 <- kl_V1828 `pseq` hd kl_V1828
                                                                                                                                                                                                                                                                                                     !appl_345 <- appl_344 `pseq` tl appl_344
                                                                                                                                                                                                                                                                                                     !appl_346 <- appl_345 `pseq` hd appl_345
                                                                                                                                                                                                                                                                                                     !appl_347 <- appl_346 `pseq` hd appl_346
                                                                                                                                                                                                                                                                                                     !appl_348 <- kl_V1828 `pseq` hd kl_V1828
                                                                                                                                                                                                                                                                                                     !appl_349 <- appl_348 `pseq` tl appl_348
                                                                                                                                                                                                                                                                                                     !appl_350 <- appl_349 `pseq` hd appl_349
                                                                                                                                                                                                                                                                                                     !appl_351 <- appl_350 `pseq` tl appl_350
                                                                                                                                                                                                                                                                                                     !appl_352 <- kl_V1828 `pseq` hd kl_V1828
                                                                                                                                                                                                                                                                                                     !appl_353 <- appl_352 `pseq` tl appl_352
                                                                                                                                                                                                                                                                                                     !appl_354 <- appl_353 `pseq` tl appl_353
                                                                                                                                                                                                                                                                                                     !appl_355 <- appl_351 `pseq` (appl_354 `pseq` klCons appl_351 appl_354)
                                                                                                                                                                                                                                                                                                     !appl_356 <- appl_355 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.mu")) appl_355
                                                                                                                                                                                                                                                                                                     !appl_357 <- kl_Z `pseq` klCons kl_Z (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                     !appl_358 <- appl_357 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.of")) appl_357
                                                                                                                                                                                                                                                                                                     !appl_359 <- appl_358 `pseq` klCons (ApplC (wrapNamed "tail" kl_tail)) appl_358
                                                                                                                                                                                                                                                                                                     !appl_360 <- appl_359 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.the")) appl_359
                                                                                                                                                                                                                                                                                                     !appl_361 <- appl_360 `pseq` klCons appl_360 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                     !appl_362 <- appl_356 `pseq` (appl_361 `pseq` klCons appl_356 appl_361)
                                                                                                                                                                                                                                                                                                     !appl_363 <- appl_362 `pseq` klCons appl_362 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                     !appl_364 <- appl_347 `pseq` (appl_363 `pseq` klCons appl_347 appl_363)
                                                                                                                                                                                                                                                                                                     !appl_365 <- appl_364 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.mu")) appl_364
                                                                                                                                                                                                                                                                                                     !appl_366 <- kl_Z `pseq` klCons kl_Z (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                     !appl_367 <- appl_366 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.of")) appl_366
                                                                                                                                                                                                                                                                                                     !appl_368 <- appl_367 `pseq` klCons (ApplC (wrapNamed "head" kl_head)) appl_367
                                                                                                                                                                                                                                                                                                     !appl_369 <- appl_368 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.the")) appl_368
                                                                                                                                                                                                                                                                                                     !appl_370 <- appl_369 `pseq` klCons appl_369 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                     !appl_371 <- appl_365 `pseq` (appl_370 `pseq` klCons appl_365 appl_370)
                                                                                                                                                                                                                                                                                                     !appl_372 <- appl_371 `pseq` kl_shen_mu_reduction appl_371 (ApplC (wrapNamed "+" add))
                                                                                                                                                                                                                                                                                                     !appl_373 <- klCons (Types.Atom (Types.UnboundSym "shen.variable")) (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                     !appl_374 <- appl_373 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.a")) appl_373
                                                                                                                                                                                                                                                                                                     !appl_375 <- appl_374 `pseq` klCons (Types.Atom (Types.UnboundSym "is")) appl_374
                                                                                                                                                                                                                                                                                                     !appl_376 <- kl_Z `pseq` (appl_375 `pseq` klCons kl_Z appl_375)
                                                                                                                                                                                                                                                                                                     !appl_377 <- kl_V1828 `pseq` hd kl_V1828
                                                                                                                                                                                                                                                                                                     !appl_378 <- appl_377 `pseq` tl appl_377
                                                                                                                                                                                                                                                                                                     !appl_379 <- appl_378 `pseq` hd appl_378
                                                                                                                                                                                                                                                                                                     !appl_380 <- appl_379 `pseq` kl_shen_extract_vars appl_379
                                                                                                                                                                                                                                                                                                     !appl_381 <- kl_V1828 `pseq` hd kl_V1828
                                                                                                                                                                                                                                                                                                     !appl_382 <- appl_381 `pseq` tl appl_381
                                                                                                                                                                                                                                                                                                     !appl_383 <- appl_382 `pseq` hd appl_382
                                                                                                                                                                                                                                                                                                     !appl_384 <- appl_383 `pseq` kl_shen_remove_modes appl_383
                                                                                                                                                                                                                                                                                                     !appl_385 <- appl_384 `pseq` kl_shen_rcons_form appl_384
                                                                                                                                                                                                                                                                                                     !appl_386 <- kl_V1828 `pseq` hd kl_V1828
                                                                                                                                                                                                                                                                                                     !appl_387 <- appl_386 `pseq` tl appl_386
                                                                                                                                                                                                                                                                                                     !appl_388 <- appl_387 `pseq` tl appl_387
                                                                                                                                                                                                                                                                                                     !appl_389 <- appl_388 `pseq` hd appl_388
                                                                                                                                                                                                                                                                                                     !appl_390 <- appl_389 `pseq` kl_shen_mu_reduction appl_389 (ApplC (wrapNamed "+" add))
                                                                                                                                                                                                                                                                                                     !appl_391 <- appl_390 `pseq` klCons appl_390 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                     !appl_392 <- appl_391 `pseq` klCons (Types.Atom (Types.UnboundSym "in")) appl_391
                                                                                                                                                                                                                                                                                                     !appl_393 <- appl_385 `pseq` (appl_392 `pseq` klCons appl_385 appl_392)
                                                                                                                                                                                                                                                                                                     !appl_394 <- appl_393 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.to")) appl_393
                                                                                                                                                                                                                                                                                                     !appl_395 <- kl_Z `pseq` (appl_394 `pseq` klCons kl_Z appl_394)
                                                                                                                                                                                                                                                                                                     !appl_396 <- appl_395 `pseq` klCons (ApplC (wrapNamed "bind" kl_bind)) appl_395
                                                                                                                                                                                                                                                                                                     !appl_397 <- appl_396 `pseq` klCons appl_396 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                     !appl_398 <- appl_397 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.then")) appl_397
                                                                                                                                                                                                                                                                                                     !appl_399 <- appl_398 `pseq` klCons (Types.Atom (Types.UnboundSym "and")) appl_398
                                                                                                                                                                                                                                                                                                     !appl_400 <- appl_380 `pseq` (appl_399 `pseq` klCons appl_380 appl_399)
                                                                                                                                                                                                                                                                                                     !appl_401 <- appl_400 `pseq` klCons (Types.Atom (Types.UnboundSym "in")) appl_400
                                                                                                                                                                                                                                                                                                     !appl_402 <- appl_401 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.variables")) appl_401
                                                                                                                                                                                                                                                                                                     !appl_403 <- appl_402 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.the")) appl_402
                                                                                                                                                                                                                                                                                                     !appl_404 <- appl_403 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.rename")) appl_403
                                                                                                                                                                                                                                                                                                     !appl_405 <- klCons (Types.Atom (Types.UnboundSym "shen.failed!")) (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                     !appl_406 <- appl_405 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.else")) appl_405
                                                                                                                                                                                                                                                                                                     !appl_407 <- appl_404 `pseq` (appl_406 `pseq` klCons appl_404 appl_406)
                                                                                                                                                                                                                                                                                                     !appl_408 <- appl_407 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.then")) appl_407
                                                                                                                                                                                                                                                                                                     !appl_409 <- appl_376 `pseq` (appl_408 `pseq` klCons appl_376 appl_408)
                                                                                                                                                                                                                                                                                                     !appl_410 <- appl_409 `pseq` klCons (Types.Atom (Types.UnboundSym "if")) appl_409
                                                                                                                                                                                                                                                                                                     !appl_411 <- appl_410 `pseq` klCons appl_410 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                     !appl_412 <- appl_411 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.else")) appl_411
                                                                                                                                                                                                                                                                                                     !appl_413 <- appl_372 `pseq` (appl_412 `pseq` klCons appl_372 appl_412)
                                                                                                                                                                                                                                                                                                     !appl_414 <- appl_413 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.then")) appl_413
                                                                                                                                                                                                                                                                                                     !appl_415 <- appl_343 `pseq` (appl_414 `pseq` klCons appl_343 appl_414)
                                                                                                                                                                                                                                                                                                     !appl_416 <- appl_415 `pseq` klCons (Types.Atom (Types.UnboundSym "if")) appl_415
                                                                                                                                                                                                                                                                                                     !appl_417 <- appl_416 `pseq` klCons appl_416 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                     !appl_418 <- appl_417 `pseq` klCons (Types.Atom (Types.UnboundSym "in")) appl_417
                                                                                                                                                                                                                                                                                                     !appl_419 <- appl_338 `pseq` (appl_418 `pseq` klCons appl_338 appl_418)
                                                                                                                                                                                                                                                                                                     !appl_420 <- appl_419 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.be")) appl_419
                                                                                                                                                                                                                                                                                                     !appl_421 <- kl_Z `pseq` (appl_420 `pseq` klCons kl_Z appl_420)
                                                                                                                                                                                                                                                                                                     appl_421 `pseq` klCons (Types.Atom (Types.UnboundSym "let")) appl_421)))
                                                                                                                                                                                                                                       !appl_422 <- kl_gensym (Types.Atom (Types.UnboundSym "V"))
                                                                                                                                                                                                                                       appl_422 `pseq` applyWrapper appl_333 [appl_422]
                                                                                                                                                                                                                 Atom (B (False)) -> do do return kl_V1828
                                                                                                                                                                                                                 _ -> throwError "if: expected boolean"
                                                                                                                                                                                      _ -> throwError "if: expected boolean"
                                                                                                                                                           _ -> throwError "if: expected boolean"
                                                                                                                                _ -> throwError "if: expected boolean"
                                                                                                     _ -> throwError "if: expected boolean"
                                                                          _ -> throwError "if: expected boolean"
                                                   in case kl_V1828 of
                                                          !(kl_V1828@(Cons (!(kl_V1828h@(Cons (Atom (UnboundSym "shen.mu"))
                                                                                              (!(kl_V1828ht@(Cons (!(kl_V1828hth@(Cons (Atom (UnboundSym "mode"))
                                                                                                                                       (!(kl_V1828htht@(Cons (!kl_V1828hthth)
                                                                                                                                                             (!(kl_V1828hthtt@(Cons (!kl_V1828hthtth)
                                                                                                                                                                                    (Atom (Nil)))))))))))
                                                                                                                  (!(kl_V1828htt@(Cons (!kl_V1828htth)
                                                                                                                                       (Atom (Nil)))))))))))
                                                                           (!(kl_V1828t@(Cons (!kl_V1828th)
                                                                                              (Atom (Nil))))))) -> pat_cond_0 kl_V1828 kl_V1828h kl_V1828ht kl_V1828hth kl_V1828htht kl_V1828hthth kl_V1828hthtt kl_V1828hthtth kl_V1828htt kl_V1828htth kl_V1828t kl_V1828th
                                                          !(kl_V1828@(Cons (!(kl_V1828h@(Cons (Atom (UnboundSym "shen.mu"))
                                                                                              (!(kl_V1828ht@(Cons (!(kl_V1828hth@(Cons (ApplC (PL "mode"
                                                                                                                                                  _))
                                                                                                                                       (!(kl_V1828htht@(Cons (!kl_V1828hthth)
                                                                                                                                                             (!(kl_V1828hthtt@(Cons (!kl_V1828hthtth)
                                                                                                                                                                                    (Atom (Nil)))))))))))
                                                                                                                  (!(kl_V1828htt@(Cons (!kl_V1828htth)
                                                                                                                                       (Atom (Nil)))))))))))
                                                                           (!(kl_V1828t@(Cons (!kl_V1828th)
                                                                                              (Atom (Nil))))))) -> pat_cond_0 kl_V1828 kl_V1828h kl_V1828ht kl_V1828hth kl_V1828htht kl_V1828hthth kl_V1828hthtt kl_V1828hthtth kl_V1828htt kl_V1828htth kl_V1828t kl_V1828th
                                                          !(kl_V1828@(Cons (!(kl_V1828h@(Cons (Atom (UnboundSym "shen.mu"))
                                                                                              (!(kl_V1828ht@(Cons (!(kl_V1828hth@(Cons (ApplC (Func "mode"
                                                                                                                                                    _))
                                                                                                                                       (!(kl_V1828htht@(Cons (!kl_V1828hthth)
                                                                                                                                                             (!(kl_V1828hthtt@(Cons (!kl_V1828hthtth)
                                                                                                                                                                                    (Atom (Nil)))))))))))
                                                                                                                  (!(kl_V1828htt@(Cons (!kl_V1828htth)
                                                                                                                                       (Atom (Nil)))))))))))
                                                                           (!(kl_V1828t@(Cons (!kl_V1828th)
                                                                                              (Atom (Nil))))))) -> pat_cond_0 kl_V1828 kl_V1828h kl_V1828ht kl_V1828hth kl_V1828htht kl_V1828hthth kl_V1828hthtt kl_V1828hthtth kl_V1828htt kl_V1828htth kl_V1828t kl_V1828th
                                                          !(kl_V1828@(Cons (!(kl_V1828h@(Cons (ApplC (PL "shen.mu"
                                                                                                         _))
                                                                                              (!(kl_V1828ht@(Cons (!(kl_V1828hth@(Cons (Atom (UnboundSym "mode"))
                                                                                                                                       (!(kl_V1828htht@(Cons (!kl_V1828hthth)
                                                                                                                                                             (!(kl_V1828hthtt@(Cons (!kl_V1828hthtth)
                                                                                                                                                                                    (Atom (Nil)))))))))))
                                                                                                                  (!(kl_V1828htt@(Cons (!kl_V1828htth)
                                                                                                                                       (Atom (Nil)))))))))))
                                                                           (!(kl_V1828t@(Cons (!kl_V1828th)
                                                                                              (Atom (Nil))))))) -> pat_cond_0 kl_V1828 kl_V1828h kl_V1828ht kl_V1828hth kl_V1828htht kl_V1828hthth kl_V1828hthtt kl_V1828hthtth kl_V1828htt kl_V1828htth kl_V1828t kl_V1828th
                                                          !(kl_V1828@(Cons (!(kl_V1828h@(Cons (ApplC (PL "shen.mu"
                                                                                                         _))
                                                                                              (!(kl_V1828ht@(Cons (!(kl_V1828hth@(Cons (ApplC (PL "mode"
                                                                                                                                                  _))
                                                                                                                                       (!(kl_V1828htht@(Cons (!kl_V1828hthth)
                                                                                                                                                             (!(kl_V1828hthtt@(Cons (!kl_V1828hthtth)
                                                                                                                                                                                    (Atom (Nil)))))))))))
                                                                                                                  (!(kl_V1828htt@(Cons (!kl_V1828htth)
                                                                                                                                       (Atom (Nil)))))))))))
                                                                           (!(kl_V1828t@(Cons (!kl_V1828th)
                                                                                              (Atom (Nil))))))) -> pat_cond_0 kl_V1828 kl_V1828h kl_V1828ht kl_V1828hth kl_V1828htht kl_V1828hthth kl_V1828hthtt kl_V1828hthtth kl_V1828htt kl_V1828htth kl_V1828t kl_V1828th
                                                          !(kl_V1828@(Cons (!(kl_V1828h@(Cons (ApplC (PL "shen.mu"
                                                                                                         _))
                                                                                              (!(kl_V1828ht@(Cons (!(kl_V1828hth@(Cons (ApplC (Func "mode"
                                                                                                                                                    _))
                                                                                                                                       (!(kl_V1828htht@(Cons (!kl_V1828hthth)
                                                                                                                                                             (!(kl_V1828hthtt@(Cons (!kl_V1828hthtth)
                                                                                                                                                                                    (Atom (Nil)))))))))))
                                                                                                                  (!(kl_V1828htt@(Cons (!kl_V1828htth)
                                                                                                                                       (Atom (Nil)))))))))))
                                                                           (!(kl_V1828t@(Cons (!kl_V1828th)
                                                                                              (Atom (Nil))))))) -> pat_cond_0 kl_V1828 kl_V1828h kl_V1828ht kl_V1828hth kl_V1828htht kl_V1828hthth kl_V1828hthtt kl_V1828hthtth kl_V1828htt kl_V1828htth kl_V1828t kl_V1828th
                                                          !(kl_V1828@(Cons (!(kl_V1828h@(Cons (ApplC (Func "shen.mu"
                                                                                                           _))
                                                                                              (!(kl_V1828ht@(Cons (!(kl_V1828hth@(Cons (Atom (UnboundSym "mode"))
                                                                                                                                       (!(kl_V1828htht@(Cons (!kl_V1828hthth)
                                                                                                                                                             (!(kl_V1828hthtt@(Cons (!kl_V1828hthtth)
                                                                                                                                                                                    (Atom (Nil)))))))))))
                                                                                                                  (!(kl_V1828htt@(Cons (!kl_V1828htth)
                                                                                                                                       (Atom (Nil)))))))))))
                                                                           (!(kl_V1828t@(Cons (!kl_V1828th)
                                                                                              (Atom (Nil))))))) -> pat_cond_0 kl_V1828 kl_V1828h kl_V1828ht kl_V1828hth kl_V1828htht kl_V1828hthth kl_V1828hthtt kl_V1828hthtth kl_V1828htt kl_V1828htth kl_V1828t kl_V1828th
                                                          !(kl_V1828@(Cons (!(kl_V1828h@(Cons (ApplC (Func "shen.mu"
                                                                                                           _))
                                                                                              (!(kl_V1828ht@(Cons (!(kl_V1828hth@(Cons (ApplC (PL "mode"
                                                                                                                                                  _))
                                                                                                                                       (!(kl_V1828htht@(Cons (!kl_V1828hthth)
                                                                                                                                                             (!(kl_V1828hthtt@(Cons (!kl_V1828hthtth)
                                                                                                                                                                                    (Atom (Nil)))))))))))
                                                                                                                  (!(kl_V1828htt@(Cons (!kl_V1828htth)
                                                                                                                                       (Atom (Nil)))))))))))
                                                                           (!(kl_V1828t@(Cons (!kl_V1828th)
                                                                                              (Atom (Nil))))))) -> pat_cond_0 kl_V1828 kl_V1828h kl_V1828ht kl_V1828hth kl_V1828htht kl_V1828hthth kl_V1828hthtt kl_V1828hthtth kl_V1828htt kl_V1828htth kl_V1828t kl_V1828th
                                                          !(kl_V1828@(Cons (!(kl_V1828h@(Cons (ApplC (Func "shen.mu"
                                                                                                           _))
                                                                                              (!(kl_V1828ht@(Cons (!(kl_V1828hth@(Cons (ApplC (Func "mode"
                                                                                                                                                    _))
                                                                                                                                       (!(kl_V1828htht@(Cons (!kl_V1828hthth)
                                                                                                                                                             (!(kl_V1828hthtt@(Cons (!kl_V1828hthtth)
                                                                                                                                                                                    (Atom (Nil)))))))))))
                                                                                                                  (!(kl_V1828htt@(Cons (!kl_V1828htth)
                                                                                                                                       (Atom (Nil)))))))))))
                                                                           (!(kl_V1828t@(Cons (!kl_V1828th)
                                                                                              (Atom (Nil))))))) -> pat_cond_0 kl_V1828 kl_V1828h kl_V1828ht kl_V1828hth kl_V1828htht kl_V1828hthth kl_V1828hthtt kl_V1828hthtth kl_V1828htt kl_V1828htth kl_V1828t kl_V1828th
                                                          !(kl_V1828@(Cons (!(kl_V1828h@(Cons (Atom (UnboundSym "shen.mu"))
                                                                                              (!(kl_V1828ht@(Cons (Atom (UnboundSym "_"))
                                                                                                                  (!(kl_V1828htt@(Cons (!kl_V1828htth)
                                                                                                                                       (Atom (Nil)))))))))))
                                                                           (!(kl_V1828t@(Cons (!kl_V1828th)
                                                                                              (Atom (Nil))))))) -> pat_cond_4 kl_V1828 kl_V1828h kl_V1828ht kl_V1828htt kl_V1828htth kl_V1828t kl_V1828th
                                                          !(kl_V1828@(Cons (!(kl_V1828h@(Cons (Atom (UnboundSym "shen.mu"))
                                                                                              (!(kl_V1828ht@(Cons (ApplC (PL "_"
                                                                                                                             _))
                                                                                                                  (!(kl_V1828htt@(Cons (!kl_V1828htth)
                                                                                                                                       (Atom (Nil)))))))))))
                                                                           (!(kl_V1828t@(Cons (!kl_V1828th)
                                                                                              (Atom (Nil))))))) -> pat_cond_4 kl_V1828 kl_V1828h kl_V1828ht kl_V1828htt kl_V1828htth kl_V1828t kl_V1828th
                                                          !(kl_V1828@(Cons (!(kl_V1828h@(Cons (Atom (UnboundSym "shen.mu"))
                                                                                              (!(kl_V1828ht@(Cons (ApplC (Func "_"
                                                                                                                               _))
                                                                                                                  (!(kl_V1828htt@(Cons (!kl_V1828htth)
                                                                                                                                       (Atom (Nil)))))))))))
                                                                           (!(kl_V1828t@(Cons (!kl_V1828th)
                                                                                              (Atom (Nil))))))) -> pat_cond_4 kl_V1828 kl_V1828h kl_V1828ht kl_V1828htt kl_V1828htth kl_V1828t kl_V1828th
                                                          !(kl_V1828@(Cons (!(kl_V1828h@(Cons (ApplC (PL "shen.mu"
                                                                                                         _))
                                                                                              (!(kl_V1828ht@(Cons (Atom (UnboundSym "_"))
                                                                                                                  (!(kl_V1828htt@(Cons (!kl_V1828htth)
                                                                                                                                       (Atom (Nil)))))))))))
                                                                           (!(kl_V1828t@(Cons (!kl_V1828th)
                                                                                              (Atom (Nil))))))) -> pat_cond_4 kl_V1828 kl_V1828h kl_V1828ht kl_V1828htt kl_V1828htth kl_V1828t kl_V1828th
                                                          !(kl_V1828@(Cons (!(kl_V1828h@(Cons (ApplC (PL "shen.mu"
                                                                                                         _))
                                                                                              (!(kl_V1828ht@(Cons (ApplC (PL "_"
                                                                                                                             _))
                                                                                                                  (!(kl_V1828htt@(Cons (!kl_V1828htth)
                                                                                                                                       (Atom (Nil)))))))))))
                                                                           (!(kl_V1828t@(Cons (!kl_V1828th)
                                                                                              (Atom (Nil))))))) -> pat_cond_4 kl_V1828 kl_V1828h kl_V1828ht kl_V1828htt kl_V1828htth kl_V1828t kl_V1828th
                                                          !(kl_V1828@(Cons (!(kl_V1828h@(Cons (ApplC (PL "shen.mu"
                                                                                                         _))
                                                                                              (!(kl_V1828ht@(Cons (ApplC (Func "_"
                                                                                                                               _))
                                                                                                                  (!(kl_V1828htt@(Cons (!kl_V1828htth)
                                                                                                                                       (Atom (Nil)))))))))))
                                                                           (!(kl_V1828t@(Cons (!kl_V1828th)
                                                                                              (Atom (Nil))))))) -> pat_cond_4 kl_V1828 kl_V1828h kl_V1828ht kl_V1828htt kl_V1828htth kl_V1828t kl_V1828th
                                                          !(kl_V1828@(Cons (!(kl_V1828h@(Cons (ApplC (Func "shen.mu"
                                                                                                           _))
                                                                                              (!(kl_V1828ht@(Cons (Atom (UnboundSym "_"))
                                                                                                                  (!(kl_V1828htt@(Cons (!kl_V1828htth)
                                                                                                                                       (Atom (Nil)))))))))))
                                                                           (!(kl_V1828t@(Cons (!kl_V1828th)
                                                                                              (Atom (Nil))))))) -> pat_cond_4 kl_V1828 kl_V1828h kl_V1828ht kl_V1828htt kl_V1828htth kl_V1828t kl_V1828th
                                                          !(kl_V1828@(Cons (!(kl_V1828h@(Cons (ApplC (Func "shen.mu"
                                                                                                           _))
                                                                                              (!(kl_V1828ht@(Cons (ApplC (PL "_"
                                                                                                                             _))
                                                                                                                  (!(kl_V1828htt@(Cons (!kl_V1828htth)
                                                                                                                                       (Atom (Nil)))))))))))
                                                                           (!(kl_V1828t@(Cons (!kl_V1828th)
                                                                                              (Atom (Nil))))))) -> pat_cond_4 kl_V1828 kl_V1828h kl_V1828ht kl_V1828htt kl_V1828htth kl_V1828t kl_V1828th
                                                          !(kl_V1828@(Cons (!(kl_V1828h@(Cons (ApplC (Func "shen.mu"
                                                                                                           _))
                                                                                              (!(kl_V1828ht@(Cons (ApplC (Func "_"
                                                                                                                               _))
                                                                                                                  (!(kl_V1828htt@(Cons (!kl_V1828htth)
                                                                                                                                       (Atom (Nil)))))))))))
                                                                           (!(kl_V1828t@(Cons (!kl_V1828th)
                                                                                              (Atom (Nil))))))) -> pat_cond_4 kl_V1828 kl_V1828h kl_V1828ht kl_V1828htt kl_V1828htth kl_V1828t kl_V1828th
                                                          _ -> pat_cond_5

kl_shen_rcons_form :: Types.KLValue ->
                      Types.KLContext Types.Env Types.KLValue
kl_shen_rcons_form (!kl_V1831) = do let pat_cond_0 kl_V1831 kl_V1831h kl_V1831t = do !appl_1 <- kl_V1831h `pseq` kl_shen_rcons_form kl_V1831h
                                                                                     !appl_2 <- kl_V1831t `pseq` kl_shen_rcons_form kl_V1831t
                                                                                     !appl_3 <- appl_2 `pseq` klCons appl_2 (Types.Atom Types.Nil)
                                                                                     !appl_4 <- appl_1 `pseq` (appl_3 `pseq` klCons appl_1 appl_3)
                                                                                     appl_4 `pseq` klCons (ApplC (wrapNamed "cons" klCons)) appl_4
                                        pat_cond_5 = do do return kl_V1831
                                     in case kl_V1831 of
                                            !(kl_V1831@(Cons (!kl_V1831h)
                                                             (!kl_V1831t))) -> pat_cond_0 kl_V1831 kl_V1831h kl_V1831t
                                            _ -> pat_cond_5

kl_shen_remove_modes :: Types.KLValue ->
                        Types.KLContext Types.Env Types.KLValue
kl_shen_remove_modes (!kl_V1833) = do let pat_cond_0 kl_V1833 kl_V1833t kl_V1833th kl_V1833tt = do kl_V1833th `pseq` kl_shen_remove_modes kl_V1833th
                                          pat_cond_1 kl_V1833 kl_V1833t kl_V1833th kl_V1833tt = do kl_V1833th `pseq` kl_shen_remove_modes kl_V1833th
                                          pat_cond_2 kl_V1833 kl_V1833h kl_V1833t = do !appl_3 <- kl_V1833h `pseq` kl_shen_remove_modes kl_V1833h
                                                                                       !appl_4 <- kl_V1833t `pseq` kl_shen_remove_modes kl_V1833t
                                                                                       appl_3 `pseq` (appl_4 `pseq` klCons appl_3 appl_4)
                                          pat_cond_5 = do do return kl_V1833
                                       in case kl_V1833 of
                                              !(kl_V1833@(Cons (Atom (UnboundSym "mode"))
                                                               (!(kl_V1833t@(Cons (!kl_V1833th)
                                                                                  (!(kl_V1833tt@(Cons (Atom (UnboundSym "+"))
                                                                                                      (Atom (Nil)))))))))) -> pat_cond_0 kl_V1833 kl_V1833t kl_V1833th kl_V1833tt
                                              !(kl_V1833@(Cons (Atom (UnboundSym "mode"))
                                                               (!(kl_V1833t@(Cons (!kl_V1833th)
                                                                                  (!(kl_V1833tt@(Cons (ApplC (PL "+"
                                                                                                                 _))
                                                                                                      (Atom (Nil)))))))))) -> pat_cond_0 kl_V1833 kl_V1833t kl_V1833th kl_V1833tt
                                              !(kl_V1833@(Cons (Atom (UnboundSym "mode"))
                                                               (!(kl_V1833t@(Cons (!kl_V1833th)
                                                                                  (!(kl_V1833tt@(Cons (ApplC (Func "+"
                                                                                                                   _))
                                                                                                      (Atom (Nil)))))))))) -> pat_cond_0 kl_V1833 kl_V1833t kl_V1833th kl_V1833tt
                                              !(kl_V1833@(Cons (ApplC (PL "mode" _))
                                                               (!(kl_V1833t@(Cons (!kl_V1833th)
                                                                                  (!(kl_V1833tt@(Cons (Atom (UnboundSym "+"))
                                                                                                      (Atom (Nil)))))))))) -> pat_cond_0 kl_V1833 kl_V1833t kl_V1833th kl_V1833tt
                                              !(kl_V1833@(Cons (ApplC (PL "mode" _))
                                                               (!(kl_V1833t@(Cons (!kl_V1833th)
                                                                                  (!(kl_V1833tt@(Cons (ApplC (PL "+"
                                                                                                                 _))
                                                                                                      (Atom (Nil)))))))))) -> pat_cond_0 kl_V1833 kl_V1833t kl_V1833th kl_V1833tt
                                              !(kl_V1833@(Cons (ApplC (PL "mode" _))
                                                               (!(kl_V1833t@(Cons (!kl_V1833th)
                                                                                  (!(kl_V1833tt@(Cons (ApplC (Func "+"
                                                                                                                   _))
                                                                                                      (Atom (Nil)))))))))) -> pat_cond_0 kl_V1833 kl_V1833t kl_V1833th kl_V1833tt
                                              !(kl_V1833@(Cons (ApplC (Func "mode" _))
                                                               (!(kl_V1833t@(Cons (!kl_V1833th)
                                                                                  (!(kl_V1833tt@(Cons (Atom (UnboundSym "+"))
                                                                                                      (Atom (Nil)))))))))) -> pat_cond_0 kl_V1833 kl_V1833t kl_V1833th kl_V1833tt
                                              !(kl_V1833@(Cons (ApplC (Func "mode" _))
                                                               (!(kl_V1833t@(Cons (!kl_V1833th)
                                                                                  (!(kl_V1833tt@(Cons (ApplC (PL "+"
                                                                                                                 _))
                                                                                                      (Atom (Nil)))))))))) -> pat_cond_0 kl_V1833 kl_V1833t kl_V1833th kl_V1833tt
                                              !(kl_V1833@(Cons (ApplC (Func "mode" _))
                                                               (!(kl_V1833t@(Cons (!kl_V1833th)
                                                                                  (!(kl_V1833tt@(Cons (ApplC (Func "+"
                                                                                                                   _))
                                                                                                      (Atom (Nil)))))))))) -> pat_cond_0 kl_V1833 kl_V1833t kl_V1833th kl_V1833tt
                                              !(kl_V1833@(Cons (Atom (UnboundSym "mode"))
                                                               (!(kl_V1833t@(Cons (!kl_V1833th)
                                                                                  (!(kl_V1833tt@(Cons (Atom (UnboundSym "-"))
                                                                                                      (Atom (Nil)))))))))) -> pat_cond_1 kl_V1833 kl_V1833t kl_V1833th kl_V1833tt
                                              !(kl_V1833@(Cons (Atom (UnboundSym "mode"))
                                                               (!(kl_V1833t@(Cons (!kl_V1833th)
                                                                                  (!(kl_V1833tt@(Cons (ApplC (PL "-"
                                                                                                                 _))
                                                                                                      (Atom (Nil)))))))))) -> pat_cond_1 kl_V1833 kl_V1833t kl_V1833th kl_V1833tt
                                              !(kl_V1833@(Cons (Atom (UnboundSym "mode"))
                                                               (!(kl_V1833t@(Cons (!kl_V1833th)
                                                                                  (!(kl_V1833tt@(Cons (ApplC (Func "-"
                                                                                                                   _))
                                                                                                      (Atom (Nil)))))))))) -> pat_cond_1 kl_V1833 kl_V1833t kl_V1833th kl_V1833tt
                                              !(kl_V1833@(Cons (ApplC (PL "mode" _))
                                                               (!(kl_V1833t@(Cons (!kl_V1833th)
                                                                                  (!(kl_V1833tt@(Cons (Atom (UnboundSym "-"))
                                                                                                      (Atom (Nil)))))))))) -> pat_cond_1 kl_V1833 kl_V1833t kl_V1833th kl_V1833tt
                                              !(kl_V1833@(Cons (ApplC (PL "mode" _))
                                                               (!(kl_V1833t@(Cons (!kl_V1833th)
                                                                                  (!(kl_V1833tt@(Cons (ApplC (PL "-"
                                                                                                                 _))
                                                                                                      (Atom (Nil)))))))))) -> pat_cond_1 kl_V1833 kl_V1833t kl_V1833th kl_V1833tt
                                              !(kl_V1833@(Cons (ApplC (PL "mode" _))
                                                               (!(kl_V1833t@(Cons (!kl_V1833th)
                                                                                  (!(kl_V1833tt@(Cons (ApplC (Func "-"
                                                                                                                   _))
                                                                                                      (Atom (Nil)))))))))) -> pat_cond_1 kl_V1833 kl_V1833t kl_V1833th kl_V1833tt
                                              !(kl_V1833@(Cons (ApplC (Func "mode" _))
                                                               (!(kl_V1833t@(Cons (!kl_V1833th)
                                                                                  (!(kl_V1833tt@(Cons (Atom (UnboundSym "-"))
                                                                                                      (Atom (Nil)))))))))) -> pat_cond_1 kl_V1833 kl_V1833t kl_V1833th kl_V1833tt
                                              !(kl_V1833@(Cons (ApplC (Func "mode" _))
                                                               (!(kl_V1833t@(Cons (!kl_V1833th)
                                                                                  (!(kl_V1833tt@(Cons (ApplC (PL "-"
                                                                                                                 _))
                                                                                                      (Atom (Nil)))))))))) -> pat_cond_1 kl_V1833 kl_V1833t kl_V1833th kl_V1833tt
                                              !(kl_V1833@(Cons (ApplC (Func "mode" _))
                                                               (!(kl_V1833t@(Cons (!kl_V1833th)
                                                                                  (!(kl_V1833tt@(Cons (ApplC (Func "-"
                                                                                                                   _))
                                                                                                      (Atom (Nil)))))))))) -> pat_cond_1 kl_V1833 kl_V1833t kl_V1833th kl_V1833tt
                                              !(kl_V1833@(Cons (!kl_V1833h)
                                                               (!kl_V1833t))) -> pat_cond_2 kl_V1833 kl_V1833h kl_V1833t
                                              _ -> pat_cond_5

kl_shen_ephemeral_variableP :: Types.KLValue ->
                               Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_ephemeral_variableP (!kl_V1836) (!kl_V1837) = do !kl_if_0 <- kl_V1836 `pseq` kl_variableP kl_V1836
                                                         case kl_if_0 of
                                                             Atom (B (True)) -> do !kl_if_1 <- kl_V1837 `pseq` kl_variableP kl_V1837
                                                                                   case kl_if_1 of
                                                                                       Atom (B (True)) -> do return (Atom (B True))
                                                                                       Atom (B (False)) -> do do return (Atom (B False))
                                                                                       _ -> throwError "if: expected boolean"
                                                             Atom (B (False)) -> do do return (Atom (B False))
                                                             _ -> throwError "if: expected boolean"

kl_shen_prolog_constantP :: Types.KLValue ->
                            Types.KLContext Types.Env Types.KLValue
kl_shen_prolog_constantP (!kl_V1847) = do let pat_cond_0 kl_V1847 kl_V1847h kl_V1847t = do return (Atom (B False))
                                              pat_cond_1 = do do return (Atom (B True))
                                           in case kl_V1847 of
                                                  !(kl_V1847@(Cons (!kl_V1847h)
                                                                   (!kl_V1847t))) -> pat_cond_0 kl_V1847 kl_V1847h kl_V1847t
                                                  _ -> pat_cond_1

kl_shen_aum_to_shen :: Types.KLValue ->
                       Types.KLContext Types.Env Types.KLValue
kl_shen_aum_to_shen (!kl_V1849) = do let pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth = do !appl_1 <- kl_V1849ttth `pseq` kl_shen_aum_to_shen kl_V1849ttth
                                                                                                                                                                     !appl_2 <- kl_V1849ttttth `pseq` kl_shen_aum_to_shen kl_V1849ttttth
                                                                                                                                                                     !appl_3 <- appl_2 `pseq` klCons appl_2 (Types.Atom Types.Nil)
                                                                                                                                                                     !appl_4 <- appl_1 `pseq` (appl_3 `pseq` klCons appl_1 appl_3)
                                                                                                                                                                     !appl_5 <- kl_V1849th `pseq` (appl_4 `pseq` klCons kl_V1849th appl_4)
                                                                                                                                                                     appl_5 `pseq` klCons (Types.Atom (Types.UnboundSym "let")) appl_5
                                         pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth = do !appl_7 <- kl_V1849tttth `pseq` kl_shen_aum_to_shen kl_V1849tttth
                                                                                                                              !appl_8 <- klCons (Types.Atom (Types.UnboundSym "ProcessN")) (Types.Atom Types.Nil)
                                                                                                                              !appl_9 <- appl_7 `pseq` (appl_8 `pseq` klCons appl_7 appl_8)
                                                                                                                              appl_9 `pseq` klCons (ApplC (wrapNamed "shen.lazyderef" kl_shen_lazyderef)) appl_9
                                         pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth = do !appl_11 <- kl_V1849th `pseq` kl_shen_aum_to_shen kl_V1849th
                                                                                                                                                                      !appl_12 <- kl_V1849ttth `pseq` kl_shen_aum_to_shen kl_V1849ttth
                                                                                                                                                                      !appl_13 <- kl_V1849ttttth `pseq` kl_shen_aum_to_shen kl_V1849ttttth
                                                                                                                                                                      !appl_14 <- appl_13 `pseq` klCons appl_13 (Types.Atom Types.Nil)
                                                                                                                                                                      !appl_15 <- appl_12 `pseq` (appl_14 `pseq` klCons appl_12 appl_14)
                                                                                                                                                                      !appl_16 <- appl_11 `pseq` (appl_15 `pseq` klCons appl_11 appl_15)
                                                                                                                                                                      appl_16 `pseq` klCons (Types.Atom (Types.UnboundSym "if")) appl_16
                                         pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt = do !appl_18 <- kl_V1849h `pseq` klCons kl_V1849h (Types.Atom Types.Nil)
                                                                                                              appl_18 `pseq` klCons (ApplC (wrapNamed "shen.pvar?" kl_shen_pvarP)) appl_18
                                         pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt = do !appl_20 <- kl_V1849h `pseq` klCons kl_V1849h (Types.Atom Types.Nil)
                                                                                                                           appl_20 `pseq` klCons (ApplC (wrapNamed "cons?" consP)) appl_20
                                         pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth = do kl_V1849ttttttth `pseq` kl_shen_aum_to_shen kl_V1849ttttttth
                                         pat_cond_22 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth kl_V1849tttthh kl_V1849ttttht kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth = do !appl_23 <- klCons (Types.Atom (Types.UnboundSym "ProcessN")) (Types.Atom Types.Nil)
                                                                                                                                                                                                                           !appl_24 <- appl_23 `pseq` klCons (ApplC (wrapNamed "shen.newpv" kl_shen_newpv)) appl_23
                                                                                                                                                                                                                           !appl_25 <- kl_V1849ttttht `pseq` (kl_V1849ttttt `pseq` klCons kl_V1849ttttht kl_V1849ttttt)
                                                                                                                                                                                                                           !appl_26 <- appl_25 `pseq` klCons (Types.Atom (Types.UnboundSym "in")) appl_25
                                                                                                                                                                                                                           !appl_27 <- appl_26 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.variables")) appl_26
                                                                                                                                                                                                                           !appl_28 <- appl_27 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.the")) appl_27
                                                                                                                                                                                                                           !appl_29 <- appl_28 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.rename")) appl_28
                                                                                                                                                                                                                           !appl_30 <- appl_29 `pseq` kl_shen_aum_to_shen appl_29
                                                                                                                                                                                                                           !appl_31 <- appl_30 `pseq` klCons appl_30 (Types.Atom Types.Nil)
                                                                                                                                                                                                                           !appl_32 <- appl_24 `pseq` (appl_31 `pseq` klCons appl_24 appl_31)
                                                                                                                                                                                                                           !appl_33 <- kl_V1849tttthh `pseq` (appl_32 `pseq` klCons kl_V1849tttthh appl_32)
                                                                                                                                                                                                                           appl_33 `pseq` klCons (Types.Atom (Types.UnboundSym "let")) appl_33
                                         pat_cond_34 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth = do !appl_35 <- kl_V1849ttth `pseq` kl_shen_chwild kl_V1849ttth
                                                                                                                                                                      !appl_36 <- klCons (Types.Atom (Types.UnboundSym "ProcessN")) (Types.Atom Types.Nil)
                                                                                                                                                                      !appl_37 <- appl_35 `pseq` (appl_36 `pseq` klCons appl_35 appl_36)
                                                                                                                                                                      !appl_38 <- kl_V1849th `pseq` (appl_37 `pseq` klCons kl_V1849th appl_37)
                                                                                                                                                                      !appl_39 <- appl_38 `pseq` klCons (ApplC (wrapNamed "shen.bindv" kl_shen_bindv)) appl_38
                                                                                                                                                                      !appl_40 <- kl_V1849ttttth `pseq` kl_shen_aum_to_shen kl_V1849ttttth
                                                                                                                                                                      !appl_41 <- klCons (Types.Atom (Types.UnboundSym "ProcessN")) (Types.Atom Types.Nil)
                                                                                                                                                                      !appl_42 <- kl_V1849th `pseq` (appl_41 `pseq` klCons kl_V1849th appl_41)
                                                                                                                                                                      !appl_43 <- appl_42 `pseq` klCons (ApplC (wrapNamed "shen.unbindv" kl_shen_unbindv)) appl_42
                                                                                                                                                                      !appl_44 <- klCons (Types.Atom (Types.UnboundSym "Result")) (Types.Atom Types.Nil)
                                                                                                                                                                      !appl_45 <- appl_43 `pseq` (appl_44 `pseq` klCons appl_43 appl_44)
                                                                                                                                                                      !appl_46 <- appl_45 `pseq` klCons (ApplC (wrapNamed "do" kl_do)) appl_45
                                                                                                                                                                      !appl_47 <- appl_46 `pseq` klCons appl_46 (Types.Atom Types.Nil)
                                                                                                                                                                      !appl_48 <- appl_40 `pseq` (appl_47 `pseq` klCons appl_40 appl_47)
                                                                                                                                                                      !appl_49 <- appl_48 `pseq` klCons (Types.Atom (Types.UnboundSym "Result")) appl_48
                                                                                                                                                                      !appl_50 <- appl_49 `pseq` klCons (Types.Atom (Types.UnboundSym "let")) appl_49
                                                                                                                                                                      !appl_51 <- appl_50 `pseq` klCons appl_50 (Types.Atom Types.Nil)
                                                                                                                                                                      !appl_52 <- appl_39 `pseq` (appl_51 `pseq` klCons appl_39 appl_51)
                                                                                                                                                                      appl_52 `pseq` klCons (ApplC (wrapNamed "do" kl_do)) appl_52
                                         pat_cond_53 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth = do !appl_54 <- kl_V1849h `pseq` klCons kl_V1849h (Types.Atom Types.Nil)
                                                                                                                                         !appl_55 <- kl_V1849tttth `pseq` (appl_54 `pseq` klCons kl_V1849tttth appl_54)
                                                                                                                                         appl_55 `pseq` klCons (ApplC (wrapNamed "=" eq)) appl_55
                                         pat_cond_56 = do return (Atom (B False))
                                         pat_cond_57 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849ttth = do kl_V1849ttt `pseq` klCons (ApplC (wrapNamed "hd" hd)) kl_V1849ttt
                                         pat_cond_58 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849ttth = do kl_V1849ttt `pseq` klCons (ApplC (wrapNamed "tl" tl)) kl_V1849ttt
                                         pat_cond_59 kl_V1849 kl_V1849t kl_V1849tt = do !appl_60 <- klCons (ApplC (PL "shen.incinfs" kl_shen_incinfs)) (Types.Atom Types.Nil)
                                                                                        !appl_61 <- klCons (Types.Atom (Types.UnboundSym "Continuation")) (Types.Atom Types.Nil)
                                                                                        !appl_62 <- appl_61 `pseq` klCons (ApplC (wrapNamed "thaw" kl_thaw)) appl_61
                                                                                        !appl_63 <- appl_62 `pseq` klCons appl_62 (Types.Atom Types.Nil)
                                                                                        !appl_64 <- appl_60 `pseq` (appl_63 `pseq` klCons appl_60 appl_63)
                                                                                        appl_64 `pseq` klCons (ApplC (wrapNamed "do" kl_do)) appl_64
                                         pat_cond_65 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849ttth = do !appl_66 <- klCons (ApplC (PL "shen.incinfs" kl_shen_incinfs)) (Types.Atom Types.Nil)
                                                                                                                 !appl_67 <- kl_V1849ttth `pseq` kl_shen_chwild kl_V1849ttth
                                                                                                                 !appl_68 <- appl_67 `pseq` kl_shen_call_the_continuation appl_67 (Types.Atom (Types.UnboundSym "ProcessN")) (Types.Atom (Types.UnboundSym "Continuation"))
                                                                                                                 !appl_69 <- appl_68 `pseq` klCons appl_68 (Types.Atom Types.Nil)
                                                                                                                 !appl_70 <- appl_66 `pseq` (appl_69 `pseq` klCons appl_66 appl_69)
                                                                                                                 appl_70 `pseq` klCons (ApplC (wrapNamed "do" kl_do)) appl_70
                                         pat_cond_71 = do do return kl_V1849
                                      in case kl_V1849 of
                                             !(kl_V1849@(Cons (Atom (UnboundSym "let"))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.be"))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "in"))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "let"))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.be"))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "in"
                                                                                                                                                           _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "let"))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.be"))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "in"
                                                                                                                                                             _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "let"))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.be"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "in"))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "let"))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.be"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "in"
                                                                                                                                                           _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "let"))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.be"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "in"
                                                                                                                                                             _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "let"))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.be"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "in"))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "let"))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.be"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "in"
                                                                                                                                                           _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "let"))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.be"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "in"
                                                                                                                                                             _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (PL "let" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.be"))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "in"))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (PL "let" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.be"))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "in"
                                                                                                                                                           _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (PL "let" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.be"))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "in"
                                                                                                                                                             _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (PL "let" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.be"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "in"))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (PL "let" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.be"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "in"
                                                                                                                                                           _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (PL "let" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.be"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "in"
                                                                                                                                                             _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (PL "let" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.be"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "in"))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (PL "let" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.be"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "in"
                                                                                                                                                           _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (PL "let" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.be"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "in"
                                                                                                                                                             _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (Func "let" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.be"))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "in"))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (Func "let" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.be"))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "in"
                                                                                                                                                           _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (Func "let" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.be"))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "in"
                                                                                                                                                             _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (Func "let" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.be"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "in"))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (Func "let" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.be"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "in"
                                                                                                                                                           _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (Func "let" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.be"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "in"
                                                                                                                                                             _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (Func "let" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.be"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "in"))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (Func "let" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.be"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "in"
                                                                                                                                                           _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (Func "let" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.be"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "in"
                                                                                                                                                             _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_0 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.the"))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (PL "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.result"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (PL "shen.result"
                                                                                            _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.of"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.of"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.dereferencing"))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.dereferencing"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (ApplC (Func "shen.the" _))
                                                              (!(kl_V1849t@(Cons (ApplC (Func "shen.result"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.of"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.dereferencing"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (!kl_V1849tttth)
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_6 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849tttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "if"))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.then"))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "shen.else"))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "if"))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.then"))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "shen.else"
                                                                                                                                                           _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "if"))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.then"))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "shen.else"
                                                                                                                                                             _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "if"))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.then"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "shen.else"))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "if"))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.then"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "shen.else"
                                                                                                                                                           _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "if"))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.then"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "shen.else"
                                                                                                                                                             _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "if"))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.then"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "shen.else"))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "if"))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.then"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "shen.else"
                                                                                                                                                           _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "if"))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.then"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "shen.else"
                                                                                                                                                             _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (PL "if" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.then"))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "shen.else"))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (PL "if" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.then"))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "shen.else"
                                                                                                                                                           _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (PL "if" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.then"))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "shen.else"
                                                                                                                                                             _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (PL "if" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.then"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "shen.else"))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (PL "if" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.then"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "shen.else"
                                                                                                                                                           _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (PL "if" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.then"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "shen.else"
                                                                                                                                                             _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (PL "if" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.then"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "shen.else"))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (PL "if" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.then"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "shen.else"
                                                                                                                                                           _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (PL "if" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.then"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "shen.else"
                                                                                                                                                             _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (Func "if" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.then"))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "shen.else"))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (Func "if" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.then"))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "shen.else"
                                                                                                                                                           _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (Func "if" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.then"))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "shen.else"
                                                                                                                                                             _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (Func "if" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.then"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "shen.else"))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (Func "if" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.then"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "shen.else"
                                                                                                                                                           _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (Func "if" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.then"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "shen.else"
                                                                                                                                                             _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (Func "if" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.then"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "shen.else"))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (Func "if" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.then"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "shen.else"
                                                                                                                                                           _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (ApplC (Func "if" _))
                                                              (!(kl_V1849t@(Cons (!kl_V1849th)
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.then"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (!kl_V1849ttth)
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "shen.else"
                                                                                                                                                             _))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (!kl_V1849ttttth)
                                                                                                                                                                       (Atom (Nil))))))))))))))))))) -> pat_cond_10 kl_V1849 kl_V1849t kl_V1849th kl_V1849tt kl_V1849ttt kl_V1849ttth kl_V1849tttt kl_V1849ttttt kl_V1849ttttth
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.variable"))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.variable"
                                                                                                                                     _))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.variable"
                                                                                                                                       _))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.variable"))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.variable"
                                                                                                                                     _))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.variable"
                                                                                                                                       _))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.variable"))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.variable"
                                                                                                                                     _))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.variable"
                                                                                                                                       _))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.variable"))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.variable"
                                                                                                                                     _))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.variable"
                                                                                                                                       _))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.variable"))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.variable"
                                                                                                                                     _))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.variable"
                                                                                                                                       _))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.variable"))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.variable"
                                                                                                                                     _))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.variable"
                                                                                                                                       _))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.variable"))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.variable"
                                                                                                                                     _))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.variable"
                                                                                                                                       _))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.variable"))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.variable"
                                                                                                                                     _))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.variable"
                                                                                                                                       _))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.variable"))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.variable"
                                                                                                                                     _))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.variable"
                                                                                                                                       _))
                                                                                                                          (Atom (Nil))))))))))))) -> pat_cond_17 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "is"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (PL "is" _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.a"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.a"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "shen.non-empty"))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "shen.non-empty"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (UnboundSym "list"))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (PL "list"
                                                                                                                                                           _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (!kl_V1849h)
                                                              (!(kl_V1849t@(Cons (ApplC (Func "is"
                                                                                              _))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (Func "shen.a"
                                                                                                                  _))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "shen.non-empty"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (ApplC (Func "list"
                                                                                                                                                             _))
                                                                                                                                                (Atom (Nil)))))))))))))))) -> pat_cond_19 kl_V1849 kl_V1849h kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "in"))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (Atom (UnboundSym "and"))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (Atom (UnboundSym "shen.then"))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "in"))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (Atom (UnboundSym "and"))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (ApplC (PL "shen.then"
                                                                                                                                                                                                          _))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "in"))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (Atom (UnboundSym "and"))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (ApplC (Func "shen.then"
                                                                                                                                                                                                            _))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "in"))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (ApplC (PL "and"
                                                                                                                                                                                  _))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (Atom (UnboundSym "shen.then"))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "in"))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (ApplC (PL "and"
                                                                                                                                                                                  _))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (ApplC (PL "shen.then"
                                                                                                                                                                                                          _))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "in"))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (ApplC (PL "and"
                                                                                                                                                                                  _))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (ApplC (Func "shen.then"
                                                                                                                                                                                                            _))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "in"))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (ApplC (Func "and"
                                                                                                                                                                                    _))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (Atom (UnboundSym "shen.then"))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "in"))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (ApplC (Func "and"
                                                                                                                                                                                    _))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (ApplC (PL "shen.then"
                                                                                                                                                                                                          _))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "in"))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (ApplC (Func "and"
                                                                                                                                                                                    _))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (ApplC (Func "shen.then"
                                                                                                                                                                                                            _))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "in"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (Atom (UnboundSym "and"))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (Atom (UnboundSym "shen.then"))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "in"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (Atom (UnboundSym "and"))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (ApplC (PL "shen.then"
                                                                                                                                                                                                          _))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "in"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (Atom (UnboundSym "and"))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (ApplC (Func "shen.then"
                                                                                                                                                                                                            _))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "in"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (ApplC (PL "and"
                                                                                                                                                                                  _))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (Atom (UnboundSym "shen.then"))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "in"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (ApplC (PL "and"
                                                                                                                                                                                  _))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (ApplC (PL "shen.then"
                                                                                                                                                                                                          _))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "in"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (ApplC (PL "and"
                                                                                                                                                                                  _))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (ApplC (Func "shen.then"
                                                                                                                                                                                                            _))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "in"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (ApplC (Func "and"
                                                                                                                                                                                    _))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (Atom (UnboundSym "shen.then"))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "in"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (ApplC (Func "and"
                                                                                                                                                                                    _))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (ApplC (PL "shen.then"
                                                                                                                                                                                                          _))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (PL "in"
                                                                                                                                     _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (ApplC (Func "and"
                                                                                                                                                                                    _))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (ApplC (Func "shen.then"
                                                                                                                                                                                                            _))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "in"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (Atom (UnboundSym "and"))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (Atom (UnboundSym "shen.then"))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "in"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (Atom (UnboundSym "and"))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (ApplC (PL "shen.then"
                                                                                                                                                                                                          _))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "in"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (Atom (UnboundSym "and"))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (ApplC (Func "shen.then"
                                                                                                                                                                                                            _))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "in"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (ApplC (PL "and"
                                                                                                                                                                                  _))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (Atom (UnboundSym "shen.then"))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "in"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (ApplC (PL "and"
                                                                                                                                                                                  _))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (ApplC (PL "shen.then"
                                                                                                                                                                                                          _))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "in"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (ApplC (PL "and"
                                                                                                                                                                                  _))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (ApplC (Func "shen.then"
                                                                                                                                                                                                            _))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "in"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (ApplC (Func "and"
                                                                                                                                                                                    _))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (Atom (UnboundSym "shen.then"))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "in"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (ApplC (Func "and"
                                                                                                                                                                                    _))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (ApplC (PL "shen.then"
                                                                                                                                                                                                          _))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (Atom (UnboundSym "shen.variables"))
                                                                                                     (!(kl_V1849ttt@(Cons (ApplC (Func "in"
                                                                                                                                       _))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (ApplC (Func "and"
                                                                                                                                                                                    _))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (ApplC (Func "shen.then"
                                                                                                                                                                                                            _))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.variables"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "in"))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (Atom (UnboundSym "and"))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (Atom (UnboundSym "shen.then"))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.variables"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "in"))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (Atom (UnboundSym "and"))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (ApplC (PL "shen.then"
                                                                                                                                                                                                          _))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.variables"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "in"))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (Atom (UnboundSym "and"))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (ApplC (Func "shen.then"
                                                                                                                                                                                                            _))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.variables"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "in"))
                                                                                                                          (!(kl_V1849tttt@(Cons (Atom (Nil))
                                                                                                                                                (!(kl_V1849ttttt@(Cons (ApplC (PL "and"
                                                                                                                                                                                  _))
                                                                                                                                                                       (!(kl_V1849tttttt@(Cons (Atom (UnboundSym "shen.then"))
                                                                                                                                                                                               (!(kl_V1849ttttttt@(Cons (!kl_V1849ttttttth)
                                                                                                                                                                                                                        (Atom (Nil))))))))))))))))))))))))) -> pat_cond_21 kl_V1849 kl_V1849t kl_V1849tt kl_V1849ttt kl_V1849tttt kl_V1849ttttt kl_V1849tttttt kl_V1849ttttttt kl_V1849ttttttth
                                             !(kl_V1849@(Cons (Atom (UnboundSym "shen.rename"))
                                                              (!(kl_V1849t@(Cons (Atom (UnboundSym "shen.the"))
                                                                                 (!(kl_V1849tt@(Cons (ApplC (PL "shen.variables"
                                                                                                                _))
                                                                                                     (!(kl_V1849ttt@(Cons (Atom (UnboundSym "in"))
                                                                                                                