{-# LANGUAGE BangPatterns #-}
{-# LANGUAGE OverloadedStrings #-}
{-# LANGUAGE Strict #-}
{-# LANGUAGE StrictData #-}
{-# LANGUAGE ViewPatterns #-}

module Backend.Reader where

import Control.Monad.Except
import Control.Parallel
import Environment
import Primitives as Primitives
import Backend.Utils
import Types as Types
import Utils
import Wrap
import Backend.Toplevel
import Backend.Core
import Backend.Sys
import Backend.Sequent
import Backend.Yacc

{-
Copyright (c) 2015, Mark Tarver
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of Mark Tarver may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY Mark Tarver ''AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Mark Tarver BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
-}

kl_read_file_as_bytelist :: Types.KLValue ->
                            Types.KLContext Types.Env Types.KLValue
kl_read_file_as_bytelist (!kl_V2161) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_Stream) -> do let !appl_1 = ApplC (Func "lambda" (Context (\(!kl_Byte) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Bytes) -> do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_Close) -> do kl_Bytes `pseq` kl_reverse kl_Bytes)))
                                                                                                                                                                                                                                          !appl_4 <- kl_Stream `pseq` closeStream kl_Stream
                                                                                                                                                                                                                                          appl_4 `pseq` applyWrapper appl_3 [appl_4])))
                                                                                                                                                                          !appl_5 <- kl_Stream `pseq` (kl_Byte `pseq` kl_shen_read_file_as_bytelist_help kl_Stream kl_Byte (Types.Atom Types.Nil))
                                                                                                                                                                          appl_5 `pseq` applyWrapper appl_2 [appl_5])))
                                                                                                           !appl_6 <- kl_Stream `pseq` readByte kl_Stream
                                                                                                           appl_6 `pseq` applyWrapper appl_1 [appl_6])))
                                          !appl_7 <- kl_V2161 `pseq` openStream kl_V2161 (Types.Atom (Types.UnboundSym "in"))
                                          appl_7 `pseq` applyWrapper appl_0 [appl_7]

kl_shen_read_file_as_bytelist_help :: Types.KLValue ->
                                      Types.KLValue ->
                                      Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_read_file_as_bytelist_help (!kl_V2165) (!kl_V2166) (!kl_V2167) = do let pat_cond_0 = do return kl_V2167
                                                                                pat_cond_1 = do do !appl_2 <- kl_V2165 `pseq` readByte kl_V2165
                                                                                                   !appl_3 <- kl_V2166 `pseq` (kl_V2167 `pseq` klCons kl_V2166 kl_V2167)
                                                                                                   kl_V2165 `pseq` (appl_2 `pseq` (appl_3 `pseq` kl_shen_read_file_as_bytelist_help kl_V2165 appl_2 appl_3))
                                                                             in case kl_V2166 of
                                                                                    kl_V2166@(Atom (N (KI (-1)))) -> pat_cond_0
                                                                                    _ -> pat_cond_1

kl_read_file_as_string :: Types.KLValue ->
                          Types.KLContext Types.Env Types.KLValue
kl_read_file_as_string (!kl_V2169) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_Stream) -> do !appl_1 <- kl_Stream `pseq` readByte kl_Stream
                                                                                                         kl_Stream `pseq` (appl_1 `pseq` kl_shen_rfas_h kl_Stream appl_1 (Types.Atom (Types.Str ""))))))
                                        !appl_2 <- kl_V2169 `pseq` openStream kl_V2169 (Types.Atom (Types.UnboundSym "in"))
                                        appl_2 `pseq` applyWrapper appl_0 [appl_2]

kl_shen_rfas_h :: Types.KLValue ->
                  Types.KLValue ->
                  Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_rfas_h (!kl_V2173) (!kl_V2174) (!kl_V2175) = do let pat_cond_0 = do !appl_1 <- kl_V2173 `pseq` closeStream kl_V2173
                                                                            appl_1 `pseq` (kl_V2175 `pseq` kl_do appl_1 kl_V2175)
                                                            pat_cond_2 = do do !appl_3 <- kl_V2173 `pseq` readByte kl_V2173
                                                                               !appl_4 <- kl_V2174 `pseq` nToString kl_V2174
                                                                               !appl_5 <- kl_V2175 `pseq` (appl_4 `pseq` cn kl_V2175 appl_4)
                                                                               kl_V2173 `pseq` (appl_3 `pseq` (appl_5 `pseq` kl_shen_rfas_h kl_V2173 appl_3 appl_5))
                                                         in case kl_V2174 of
                                                                kl_V2174@(Atom (N (KI (-1)))) -> pat_cond_0
                                                                _ -> pat_cond_2

kl_input :: Types.KLValue ->
            Types.KLContext Types.Env Types.KLValue
kl_input (!kl_V2177) = do !appl_0 <- kl_V2177 `pseq` kl_read kl_V2177
                          appl_0 `pseq` evalKL appl_0

kl_inputPlus :: Types.KLValue ->
                Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_inputPlus (!kl_V2180) (!kl_V2181) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_MonoP) -> do let !appl_1 = ApplC (Func "lambda" (Context (\(!kl_Input) -> do let !aw_2 = Types.Atom (Types.UnboundSym "shen.demodulate")
                                                                                                                                                                          !appl_3 <- kl_V2180 `pseq` applyWrapper aw_2 [kl_V2180]
                                                                                                                                                                          let !aw_4 = Types.Atom (Types.UnboundSym "shen.typecheck")
                                                                                                                                                                          !appl_5 <- kl_Input `pseq` (appl_3 `pseq` applyWrapper aw_4 [kl_Input,
                                                                                                                                                                                                                                       appl_3])
                                                                                                                                                                          !kl_if_6 <- appl_5 `pseq` eq (Atom (B False)) appl_5
                                                                                                                                                                          case kl_if_6 of
                                                                                                                                                                              Atom (B (True)) -> do let !aw_7 = Types.Atom (Types.UnboundSym "shen.app")
                                                                                                                                                                                                    !appl_8 <- kl_V2180 `pseq` applyWrapper aw_7 [kl_V2180,
                                                                                                                                                                                                                                                  Types.Atom (Types.Str "\n"),
                                                                                                                                                                                                                                                  Types.Atom (Types.UnboundSym "shen.r")]
                                                                                                                                                                                                    !appl_9 <- appl_8 `pseq` cn (Types.Atom (Types.Str " is not of type ")) appl_8
                                                                                                                                                                                                    let !aw_10 = Types.Atom (Types.UnboundSym "shen.app")
                                                                                                                                                                                                    !appl_11 <- kl_Input `pseq` (appl_9 `pseq` applyWrapper aw_10 [kl_Input,
                                                                                                                                                                                                                                                                   appl_9,
                                                                                                                                                                                                                                                                   Types.Atom (Types.UnboundSym "shen.r")])
                                                                                                                                                                                                    !appl_12 <- appl_11 `pseq` cn (Types.Atom (Types.Str "type error: ")) appl_11
                                                                                                                                                                                                    appl_12 `pseq` simpleError appl_12
                                                                                                                                                                              Atom (B (False)) -> do do kl_Input `pseq` evalKL kl_Input
                                                                                                                                                                              _ -> throwError "if: expected boolean")))
                                                                                                          !appl_13 <- kl_V2181 `pseq` kl_read kl_V2181
                                                                                                          appl_13 `pseq` applyWrapper appl_1 [appl_13])))
                                          !appl_14 <- kl_V2180 `pseq` kl_shen_monotype kl_V2180
                                          appl_14 `pseq` applyWrapper appl_0 [appl_14]

kl_shen_monotype :: Types.KLValue ->
                    Types.KLContext Types.Env Types.KLValue
kl_shen_monotype (!kl_V2183) = do let pat_cond_0 kl_V2183 kl_V2183h kl_V2183t = do let !appl_1 = ApplC (Func "lambda" (Context (\(!kl_Z) -> do kl_Z `pseq` kl_shen_monotype kl_Z)))
                                                                                   appl_1 `pseq` (kl_V2183 `pseq` kl_map appl_1 kl_V2183)
                                      pat_cond_2 = do do !kl_if_3 <- kl_V2183 `pseq` kl_variableP kl_V2183
                                                         case kl_if_3 of
                                                             Atom (B (True)) -> do let !aw_4 = Types.Atom (Types.UnboundSym "shen.app")
                                                                                   !appl_5 <- kl_V2183 `pseq` applyWrapper aw_4 [kl_V2183,
                                                                                                                                 Types.Atom (Types.Str "\n"),
                                                                                                                                 Types.Atom (Types.UnboundSym "shen.a")]
                                                                                   !appl_6 <- appl_5 `pseq` cn (Types.Atom (Types.Str "input+ expects a monotype: not ")) appl_5
                                                                                   appl_6 `pseq` simpleError appl_6
                                                             Atom (B (False)) -> do do return kl_V2183
                                                             _ -> throwError "if: expected boolean"
                                   in case kl_V2183 of
                                          !(kl_V2183@(Cons (!kl_V2183h)
                                                           (!kl_V2183t))) -> pat_cond_0 kl_V2183 kl_V2183h kl_V2183t
                                          _ -> pat_cond_2

kl_read :: Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_read (!kl_V2185) = do !appl_0 <- kl_V2185 `pseq` readByte kl_V2185
                         !appl_1 <- kl_V2185 `pseq` (appl_0 `pseq` kl_shen_read_loop kl_V2185 appl_0 (Types.Atom Types.Nil))
                         appl_1 `pseq` hd appl_1

kl_it :: Types.KLContext Types.Env Types.KLValue
kl_it = do value (Types.Atom (Types.UnboundSym "shen.*it*"))

kl_shen_read_loop :: Types.KLValue ->
                     Types.KLValue ->
                     Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_read_loop (!kl_V2193) (!kl_V2194) (!kl_V2195) = do let pat_cond_0 = do simpleError (Types.Atom (Types.Str "read aborted"))
                                                               pat_cond_1 = do !kl_if_2 <- kl_V2195 `pseq` kl_emptyP kl_V2195
                                                                               case kl_if_2 of
                                                                                   Atom (B (True)) -> do simpleError (Types.Atom (Types.Str "error: empty stream"))
                                                                                   Atom (B (False)) -> do do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_X `pseq` kl_shen_LBst_inputRB kl_X)))
                                                                                                             let !appl_4 = ApplC (Func "lambda" (Context (\(!kl_E) -> do return kl_E)))
                                                                                                             appl_3 `pseq` (kl_V2195 `pseq` (appl_4 `pseq` kl_compile appl_3 kl_V2195 appl_4))
                                                                                   _ -> throwError "if: expected boolean"
                                                               pat_cond_5 = do !kl_if_6 <- kl_V2194 `pseq` kl_shen_terminatorP kl_V2194
                                                                               case kl_if_6 of
                                                                                   Atom (B (True)) -> do let !appl_7 = ApplC (Func "lambda" (Context (\(!kl_AllBytes) -> do let !appl_8 = ApplC (Func "lambda" (Context (\(!kl_It) -> do let !appl_9 = ApplC (Func "lambda" (Context (\(!kl_Read) -> do !kl_if_10 <- let pat_cond_11 = do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                         pat_cond_12 = do do !kl_if_13 <- kl_Read `pseq` kl_emptyP kl_Read
                                                                                                                                                                                                                                                                                                                                             case kl_if_13 of
                                                                                                                                                                                                                                                                                                                                                 Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                                                 Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                 _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                      in case kl_Read of
                                                                                                                                                                                                                                                                                                                             kl_Read@(Atom (UnboundSym "shen.nextbyte")) -> pat_cond_11
                                                                                                                                                                                                                                                                                                                             kl_Read@(ApplC (PL "shen.nextbyte"
                                                                                                                                                                                                                                                                                                                                                _)) -> pat_cond_11
                                                                                                                                                                                                                                                                                                                             kl_Read@(ApplC (Func "shen.nextbyte"
                                                                                                                                                                                                                                                                                                                                                  _)) -> pat_cond_11
                                                                                                                                                                                                                                                                                                                             _ -> pat_cond_12
                                                                                                                                                                                                                                                                                                        case kl_if_10 of
                                                                                                                                                                                                                                                                                                            Atom (B (True)) -> do !appl_14 <- kl_V2193 `pseq` readByte kl_V2193
                                                                                                                                                                                                                                                                                                                                  kl_V2193 `pseq` (appl_14 `pseq` (kl_AllBytes `pseq` kl_shen_read_loop kl_V2193 appl_14 kl_AllBytes))
                                                                                                                                                                                                                                                                                                            Atom (B (False)) -> do do return kl_Read
                                                                                                                                                                                                                                                                                                            _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                         let !appl_15 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_X `pseq` kl_shen_LBst_inputRB kl_X)))
                                                                                                                                                                                                                                         let !appl_16 = ApplC (Func "lambda" (Context (\(!kl_E) -> do return (Types.Atom (Types.UnboundSym "shen.nextbyte")))))
                                                                                                                                                                                                                                         !appl_17 <- appl_15 `pseq` (kl_AllBytes `pseq` (appl_16 `pseq` kl_compile appl_15 kl_AllBytes appl_16))
                                                                                                                                                                                                                                         appl_17 `pseq` applyWrapper appl_9 [appl_17])))
                                                                                                                                                                            !appl_18 <- kl_AllBytes `pseq` kl_shen_record_it kl_AllBytes
                                                                                                                                                                            appl_18 `pseq` applyWrapper appl_8 [appl_18])))
                                                                                                         !appl_19 <- kl_V2194 `pseq` klCons kl_V2194 (Types.Atom Types.Nil)
                                                                                                         !appl_20 <- kl_V2195 `pseq` (appl_19 `pseq` kl_append kl_V2195 appl_19)
                                                                                                         appl_20 `pseq` applyWrapper appl_7 [appl_20]
                                                                                   Atom (B (False)) -> do do !appl_21 <- kl_V2193 `pseq` readByte kl_V2193
                                                                                                             !appl_22 <- kl_V2194 `pseq` klCons kl_V2194 (Types.Atom Types.Nil)
                                                                                                             !appl_23 <- kl_V2195 `pseq` (appl_22 `pseq` kl_append kl_V2195 appl_22)
                                                                                                             kl_V2193 `pseq` (appl_21 `pseq` (appl_23 `pseq` kl_shen_read_loop kl_V2193 appl_21 appl_23))
                                                                                   _ -> throwError "if: expected boolean"
                                                            in case kl_V2194 of
                                                                   kl_V2194@(Atom (N (KI 94))) -> pat_cond_0
                                                                   kl_V2194@(Atom (N (KI (-1)))) -> pat_cond_1
                                                                   _ -> pat_cond_5

kl_shen_terminatorP :: Types.KLValue ->
                       Types.KLContext Types.Env Types.KLValue
kl_shen_terminatorP (!kl_V2197) = do !appl_0 <- klCons (Types.Atom (Types.N (Types.KI 93))) (Types.Atom Types.Nil)
                                     !appl_1 <- appl_0 `pseq` klCons (Types.Atom (Types.N (Types.KI 41))) appl_0
                                     !appl_2 <- appl_1 `pseq` klCons (Types.Atom (Types.N (Types.KI 34))) appl_1
                                     !appl_3 <- appl_2 `pseq` klCons (Types.Atom (Types.N (Types.KI 32))) appl_2
                                     !appl_4 <- appl_3 `pseq` klCons (Types.Atom (Types.N (Types.KI 13))) appl_3
                                     !appl_5 <- appl_4 `pseq` klCons (Types.Atom (Types.N (Types.KI 10))) appl_4
                                     !appl_6 <- appl_5 `pseq` klCons (Types.Atom (Types.N (Types.KI 9))) appl_5
                                     kl_V2197 `pseq` (appl_6 `pseq` kl_elementP kl_V2197 appl_6)

kl_lineread :: Types.KLValue ->
               Types.KLContext Types.Env Types.KLValue
kl_lineread (!kl_V2199) = do !appl_0 <- kl_V2199 `pseq` readByte kl_V2199
                             appl_0 `pseq` (kl_V2199 `pseq` kl_shen_lineread_loop appl_0 (Types.Atom Types.Nil) kl_V2199)

kl_shen_lineread_loop :: Types.KLValue ->
                         Types.KLValue ->
                         Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_lineread_loop (!kl_V2204) (!kl_V2205) (!kl_V2206) = do let pat_cond_0 = do !kl_if_1 <- kl_V2205 `pseq` kl_emptyP kl_V2205
                                                                                   case kl_if_1 of
                                                                                       Atom (B (True)) -> do simpleError (Types.Atom (Types.Str "empty stream"))
                                                                                       Atom (B (False)) -> do do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_X `pseq` kl_shen_LBst_inputRB kl_X)))
                                                                                                                 let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_E) -> do return kl_E)))
                                                                                                                 appl_2 `pseq` (kl_V2205 `pseq` (appl_3 `pseq` kl_compile appl_2 kl_V2205 appl_3))
                                                                                       _ -> throwError "if: expected boolean"
                                                                   pat_cond_4 = do !appl_5 <- kl_shen_hat
                                                                                   !kl_if_6 <- kl_V2204 `pseq` (appl_5 `pseq` eq kl_V2204 appl_5)
                                                                                   case kl_if_6 of
                                                                                       Atom (B (True)) -> do simpleError (Types.Atom (Types.Str "line read aborted"))
                                                                                       Atom (B (False)) -> do !appl_7 <- kl_shen_newline
                                                                                                              !appl_8 <- kl_shen_carriage_return
                                                                                                              !appl_9 <- appl_8 `pseq` klCons appl_8 (Types.Atom Types.Nil)
                                                                                                              !appl_10 <- appl_7 `pseq` (appl_9 `pseq` klCons appl_7 appl_9)
                                                                                                              !kl_if_11 <- kl_V2204 `pseq` (appl_10 `pseq` kl_elementP kl_V2204 appl_10)
                                                                                                              case kl_if_11 of
                                                                                                                  Atom (B (True)) -> do let !appl_12 = ApplC (Func "lambda" (Context (\(!kl_Line) -> do let !appl_13 = ApplC (Func "lambda" (Context (\(!kl_It) -> do !kl_if_14 <- let pat_cond_15 = do return (Atom (B True))
                                                                                                                                                                                                                                                                                       pat_cond_16 = do do !kl_if_17 <- kl_Line `pseq` kl_emptyP kl_Line
                                                                                                                                                                                                                                                                                                           case kl_if_17 of
                                                                                                                                                                                                                                                                                                               Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                                               Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                               _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                    in case kl_Line of
                                                                                                                                                                                                                                                                                           kl_Line@(Atom (UnboundSym "shen.nextline")) -> pat_cond_15
                                                                                                                                                                                                                                                                                           kl_Line@(ApplC (PL "shen.nextline"
                                                                                                                                                                                                                                                                                                              _)) -> pat_cond_15
                                                                                                                                                                                                                                                                                           kl_Line@(ApplC (Func "shen.nextline"
                                                                                                                                                                                                                                                                                                                _)) -> pat_cond_15
                                                                                                                                                                                                                                                                                           _ -> pat_cond_16
                                                                                                                                                                                                                                                                      case kl_if_14 of
                                                                                                                                                                                                                                                                          Atom (B (True)) -> do !appl_18 <- kl_V2206 `pseq` readByte kl_V2206
                                                                                                                                                                                                                                                                                                !appl_19 <- kl_V2204 `pseq` klCons kl_V2204 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                !appl_20 <- kl_V2205 `pseq` (appl_19 `pseq` kl_append kl_V2205 appl_19)
                                                                                                                                                                                                                                                                                                appl_18 `pseq` (appl_20 `pseq` (kl_V2206 `pseq` kl_shen_lineread_loop appl_18 appl_20 kl_V2206))
                                                                                                                                                                                                                                                                          Atom (B (False)) -> do do return kl_Line
                                                                                                                                                                                                                                                                          _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                        !appl_21 <- kl_V2205 `pseq` kl_shen_record_it kl_V2205
                                                                                                                                                                                                        appl_21 `pseq` applyWrapper appl_13 [appl_21])))
                                                                                                                                        let !appl_22 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_X `pseq` kl_shen_LBst_inputRB kl_X)))
                                                                                                                                        let !appl_23 = ApplC (Func "lambda" (Context (\(!kl_E) -> do return (Types.Atom (Types.UnboundSym "shen.nextline")))))
                                                                                                                                        !appl_24 <- appl_22 `pseq` (kl_V2205 `pseq` (appl_23 `pseq` kl_compile appl_22 kl_V2205 appl_23))
                                                                                                                                        appl_24 `pseq` applyWrapper appl_12 [appl_24]
                                                                                                                  Atom (B (False)) -> do do !appl_25 <- kl_V2206 `pseq` readByte kl_V2206
                                                                                                                                            !appl_26 <- kl_V2204 `pseq` klCons kl_V2204 (Types.Atom Types.Nil)
                                                                                                                                            !appl_27 <- kl_V2205 `pseq` (appl_26 `pseq` kl_append kl_V2205 appl_26)
                                                                                                                                            appl_25 `pseq` (appl_27 `pseq` (kl_V2206 `pseq` kl_shen_lineread_loop appl_25 appl_27 kl_V2206))
                                                                                                                  _ -> throwError "if: expected boolean"
                                                                                       _ -> throwError "if: expected boolean"
                                                                in case kl_V2204 of
                                                                       kl_V2204@(Atom (N (KI (-1)))) -> pat_cond_0
                                                                       _ -> pat_cond_4

kl_shen_record_it :: Types.KLValue ->
                     Types.KLContext Types.Env Types.KLValue
kl_shen_record_it (!kl_V2208) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_TrimLeft) -> do let !appl_1 = ApplC (Func "lambda" (Context (\(!kl_TrimRight) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Trimmed) -> do kl_Trimmed `pseq` kl_shen_record_it_h kl_Trimmed)))
                                                                                                                                                                          !appl_3 <- kl_TrimRight `pseq` kl_reverse kl_TrimRight
                                                                                                                                                                          appl_3 `pseq` applyWrapper appl_2 [appl_3])))
                                                                                                      !appl_4 <- kl_TrimLeft `pseq` kl_reverse kl_TrimLeft
                                                                                                      !appl_5 <- appl_4 `pseq` kl_shen_trim_whitespace appl_4
                                                                                                      appl_5 `pseq` applyWrapper appl_1 [appl_5])))
                                   !appl_6 <- kl_V2208 `pseq` kl_shen_trim_whitespace kl_V2208
                                   appl_6 `pseq` applyWrapper appl_0 [appl_6]

kl_shen_trim_whitespace :: Types.KLValue ->
                           Types.KLContext Types.Env Types.KLValue
kl_shen_trim_whitespace (!kl_V2210) = do !kl_if_0 <- let pat_cond_1 kl_V2210 kl_V2210h kl_V2210t = do !appl_2 <- klCons (Types.Atom (Types.N (Types.KI 32))) (Types.Atom Types.Nil)
                                                                                                      !appl_3 <- appl_2 `pseq` klCons (Types.Atom (Types.N (Types.KI 13))) appl_2
                                                                                                      !appl_4 <- appl_3 `pseq` klCons (Types.Atom (Types.N (Types.KI 10))) appl_3
                                                                                                      !appl_5 <- appl_4 `pseq` klCons (Types.Atom (Types.N (Types.KI 9))) appl_4
                                                                                                      !kl_if_6 <- kl_V2210h `pseq` (appl_5 `pseq` kl_elementP kl_V2210h appl_5)
                                                                                                      case kl_if_6 of
                                                                                                          Atom (B (True)) -> do return (Atom (B True))
                                                                                                          Atom (B (False)) -> do do return (Atom (B False))
                                                                                                          _ -> throwError "if: expected boolean"
                                                         pat_cond_7 = do do return (Atom (B False))
                                                      in case kl_V2210 of
                                                             !(kl_V2210@(Cons (!kl_V2210h)
                                                                              (!kl_V2210t))) -> pat_cond_1 kl_V2210 kl_V2210h kl_V2210t
                                                             _ -> pat_cond_7
                                         case kl_if_0 of
                                             Atom (B (True)) -> do !appl_8 <- kl_V2210 `pseq` tl kl_V2210
                                                                   appl_8 `pseq` kl_shen_trim_whitespace appl_8
                                             Atom (B (False)) -> do do return kl_V2210
                                             _ -> throwError "if: expected boolean"

kl_shen_record_it_h :: Types.KLValue ->
                       Types.KLContext Types.Env Types.KLValue
kl_shen_record_it_h (!kl_V2212) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_X `pseq` nToString kl_X)))
                                     !appl_1 <- appl_0 `pseq` (kl_V2212 `pseq` kl_map appl_0 kl_V2212)
                                     !appl_2 <- appl_1 `pseq` kl_shen_cn_all appl_1
                                     !appl_3 <- appl_2 `pseq` klSet (Types.Atom (Types.UnboundSym "shen.*it*")) appl_2
                                     appl_3 `pseq` (kl_V2212 `pseq` kl_do appl_3 kl_V2212)

kl_shen_cn_all :: Types.KLValue ->
                  Types.KLContext Types.Env Types.KLValue
kl_shen_cn_all (!kl_V2214) = do let pat_cond_0 = do return (Types.Atom (Types.Str ""))
                                    pat_cond_1 kl_V2214 kl_V2214h kl_V2214t = do !appl_2 <- kl_V2214t `pseq` kl_shen_cn_all kl_V2214t
                                                                                 kl_V2214h `pseq` (appl_2 `pseq` cn kl_V2214h appl_2)
                                    pat_cond_3 = do do let !aw_4 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                       applyWrapper aw_4 [ApplC (wrapNamed "shen.cn-all" kl_shen_cn_all)]
                                 in case kl_V2214 of
                                        kl_V2214@(Atom (Nil)) -> pat_cond_0
                                        !(kl_V2214@(Cons (!kl_V2214h)
                                                         (!kl_V2214t))) -> pat_cond_1 kl_V2214 kl_V2214h kl_V2214t
                                        _ -> pat_cond_3

kl_read_file :: Types.KLValue ->
                Types.KLContext Types.Env Types.KLValue
kl_read_file (!kl_V2216) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_Bytelist) -> do let !appl_1 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_X `pseq` kl_shen_LBst_inputRB kl_X)))
                                                                                                 let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_X `pseq` kl_shen_read_error kl_X)))
                                                                                                 appl_1 `pseq` (kl_Bytelist `pseq` (appl_2 `pseq` kl_compile appl_1 kl_Bytelist appl_2)))))
                              !appl_3 <- kl_V2216 `pseq` kl_read_file_as_bytelist kl_V2216
                              appl_3 `pseq` applyWrapper appl_0 [appl_3]

kl_read_from_string :: Types.KLValue ->
                       Types.KLContext Types.Env Types.KLValue
kl_read_from_string (!kl_V2218) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_Ns) -> do let !appl_1 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_X `pseq` kl_shen_LBst_inputRB kl_X)))
                                                                                                  let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_X `pseq` kl_shen_read_error kl_X)))
                                                                                                  appl_1 `pseq` (kl_Ns `pseq` (appl_2 `pseq` kl_compile appl_1 kl_Ns appl_2)))))
                                     let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_X `pseq` stringToN kl_X)))
                                     !appl_4 <- kl_V2218 `pseq` kl_explode kl_V2218
                                     !appl_5 <- appl_3 `pseq` (appl_4 `pseq` kl_map appl_3 appl_4)
                                     appl_5 `pseq` applyWrapper appl_0 [appl_5]

kl_shen_read_error :: Types.KLValue ->
                      Types.KLContext Types.Env Types.KLValue
kl_shen_read_error (!kl_V2226) = do let pat_cond_0 kl_V2226 kl_V2226h kl_V2226hh kl_V2226ht kl_V2226t kl_V2226th = do !appl_1 <- kl_V2226h `pseq` kl_shen_compress_50 (Types.Atom (Types.N (Types.KI 50))) kl_V2226h
                                                                                                                      let !aw_2 = Types.Atom (Types.UnboundSym "shen.app")
                                                                                                                      !appl_3 <- appl_1 `pseq` applyWrapper aw_2 [appl_1,
                                                                                                                                                                  Types.Atom (Types.Str "\n"),
                                                                                                                                                                  Types.Atom (Types.UnboundSym "shen.a")]
                                                                                                                      !appl_4 <- appl_3 `pseq` cn (Types.Atom (Types.Str "read error here:\n\n ")) appl_3
                                                                                                                      appl_4 `pseq` simpleError appl_4
                                        pat_cond_5 = do do simpleError (Types.Atom (Types.Str "read error\n"))
                                     in case kl_V2226 of
                                            !(kl_V2226@(Cons (!(kl_V2226h@(Cons (!kl_V2226hh)
                                                                                (!kl_V2226ht))))
                                                             (!(kl_V2226t@(Cons (!kl_V2226th)
                                                                                (Atom (Nil))))))) -> pat_cond_0 kl_V2226 kl_V2226h kl_V2226hh kl_V2226ht kl_V2226t kl_V2226th
                                            _ -> pat_cond_5

kl_shen_compress_50 :: Types.KLValue ->
                       Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_compress_50 (!kl_V2233) (!kl_V2234) = do let pat_cond_0 = do return (Types.Atom (Types.Str ""))
                                                     pat_cond_1 = do let pat_cond_2 = do return (Types.Atom (Types.Str ""))
                                                                         pat_cond_3 = do let pat_cond_4 kl_V2234 kl_V2234h kl_V2234t = do !appl_5 <- kl_V2234h `pseq` nToString kl_V2234h
                                                                                                                                          !appl_6 <- kl_V2233 `pseq` Primitives.subtract kl_V2233 (Types.Atom (Types.N (Types.KI 1)))
                                                                                                                                          !appl_7 <- appl_6 `pseq` (kl_V2234t `pseq` kl_shen_compress_50 appl_6 kl_V2234t)
                                                                                                                                          appl_5 `pseq` (appl_7 `pseq` cn appl_5 appl_7)
                                                                                             pat_cond_8 = do do let !aw_9 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                                                                applyWrapper aw_9 [ApplC (wrapNamed "shen.compress-50" kl_shen_compress_50)]
                                                                                          in case kl_V2234 of
                                                                                                 !(kl_V2234@(Cons (!kl_V2234h)
                                                                                                                  (!kl_V2234t))) -> pat_cond_4 kl_V2234 kl_V2234h kl_V2234t
                                                                                                 _ -> pat_cond_8
                                                                      in case kl_V2233 of
                                                                             kl_V2233@(Atom (N (KI 0))) -> pat_cond_2
                                                                             _ -> pat_cond_3
                                                  in case kl_V2234 of
                                                         kl_V2234@(Atom (Nil)) -> pat_cond_0
                                                         _ -> pat_cond_1

kl_shen_LBst_inputRB :: Types.KLValue ->
                        Types.KLContext Types.Env Types.KLValue
kl_shen_LBst_inputRB (!kl_V2236) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_1 <- kl_fail
                                                                                                          !kl_if_2 <- kl_YaccParse `pseq` (appl_1 `pseq` eq kl_YaccParse appl_1)
                                                                                                          case kl_if_2 of
                                                                                                              Atom (B (True)) -> do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_4 <- kl_fail
                                                                                                                                                                                                        !kl_if_5 <- kl_YaccParse `pseq` (appl_4 `pseq` eq kl_YaccParse appl_4)
                                                                                                                                                                                                        case kl_if_5 of
                                                                                                                                                                                                            Atom (B (True)) -> do let !appl_6 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_7 <- kl_fail
                                                                                                                                                                                                                                                                                                      !kl_if_8 <- kl_YaccParse `pseq` (appl_7 `pseq` eq kl_YaccParse appl_7)
                                                                                                                                                                                                                                                                                                      case kl_if_8 of
                                                                                                                                                                                                                                                                                                          Atom (B (True)) -> do let !appl_9 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_10 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                    !kl_if_11 <- kl_YaccParse `pseq` (appl_10 `pseq` eq kl_YaccParse appl_10)
                                                                                                                                                                                                                                                                                                                                                                                                    case kl_if_11 of
                                                                                                                                                                                                                                                                                                                                                                                                        Atom (B (True)) -> do let !appl_12 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_13 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   !kl_if_14 <- kl_YaccParse `pseq` (appl_13 `pseq` eq kl_YaccParse appl_13)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   case kl_if_14 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       Atom (B (True)) -> do let !appl_15 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_16 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !kl_if_17 <- kl_YaccParse `pseq` (appl_16 `pseq` eq kl_YaccParse appl_16)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  case kl_if_17 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      Atom (B (True)) -> do let !appl_18 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_19 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 !kl_if_20 <- kl_YaccParse `pseq` (appl_19 `pseq` eq kl_YaccParse appl_19)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 case kl_if_20 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     Atom (B (True)) -> do let !appl_21 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_22 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !kl_if_23 <- kl_YaccParse `pseq` (appl_22 `pseq` eq kl_YaccParse appl_22)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                case kl_if_23 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Atom (B (True)) -> do let !appl_24 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_25 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               !kl_if_26 <- kl_YaccParse `pseq` (appl_25 `pseq` eq kl_YaccParse appl_25)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               case kl_if_26 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   Atom (B (True)) -> do let !appl_27 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_28 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              !kl_if_29 <- kl_YaccParse `pseq` (appl_28 `pseq` eq kl_YaccParse appl_28)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              case kl_if_29 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  Atom (B (True)) -> do let !appl_30 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_31 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             !kl_if_32 <- kl_YaccParse `pseq` (appl_31 `pseq` eq kl_YaccParse appl_31)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             case kl_if_32 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 Atom (B (True)) -> do let !appl_33 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_34 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !kl_if_35 <- kl_YaccParse `pseq` (appl_34 `pseq` eq kl_YaccParse appl_34)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            case kl_if_35 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Atom (B (True)) -> do let !appl_36 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_37 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           !kl_if_38 <- kl_YaccParse `pseq` (appl_37 `pseq` eq kl_YaccParse appl_37)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           case kl_if_38 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               Atom (B (True)) -> do let !appl_39 = ApplC (Func "lambda" (Context (\(!kl_Parse_LBeRB) -> do !appl_40 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !appl_41 <- appl_40 `pseq` (kl_Parse_LBeRB `pseq` eq appl_40 kl_Parse_LBeRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !kl_if_42 <- appl_41 `pseq` kl_not appl_41
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            case kl_if_42 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Atom (B (True)) -> do !appl_43 <- kl_Parse_LBeRB `pseq` hd kl_Parse_LBeRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      appl_43 `pseq` kl_shen_pair appl_43 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     !appl_44 <- kl_V2236 `pseq` kl_LBeRB kl_V2236
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     appl_44 `pseq` applyWrapper appl_39 [appl_44]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      let !appl_45 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBwhitespacesRB) -> do !appl_46 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !appl_47 <- appl_46 `pseq` (kl_Parse_shen_LBwhitespacesRB `pseq` eq appl_46 kl_Parse_shen_LBwhitespacesRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !kl_if_48 <- appl_47 `pseq` kl_not appl_47
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            case kl_if_48 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Atom (B (True)) -> do let !appl_49 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBst_inputRB) -> do !appl_50 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !appl_51 <- appl_50 `pseq` (kl_Parse_shen_LBst_inputRB `pseq` eq appl_50 kl_Parse_shen_LBst_inputRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !kl_if_52 <- appl_51 `pseq` kl_not appl_51
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         case kl_if_52 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             Atom (B (True)) -> do !appl_53 <- kl_Parse_shen_LBst_inputRB `pseq` hd kl_Parse_shen_LBst_inputRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   !appl_54 <- kl_Parse_shen_LBst_inputRB `pseq` kl_shen_hdtl kl_Parse_shen_LBst_inputRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   appl_53 `pseq` (appl_54 `pseq` kl_shen_pair appl_53 appl_54)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_55 <- kl_Parse_shen_LBwhitespacesRB `pseq` kl_shen_LBst_inputRB kl_Parse_shen_LBwhitespacesRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      appl_55 `pseq` applyWrapper appl_49 [appl_55]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_56 <- kl_V2236 `pseq` kl_shen_LBwhitespacesRB kl_V2236
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_57 <- appl_56 `pseq` applyWrapper appl_45 [appl_56]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      appl_57 `pseq` applyWrapper appl_36 [appl_57]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       let !appl_58 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBatomRB) -> do !appl_59 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_60 <- appl_59 `pseq` (kl_Parse_shen_LBatomRB `pseq` eq appl_59 kl_Parse_shen_LBatomRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !kl_if_61 <- appl_60 `pseq` kl_not appl_60
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      case kl_if_61 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          Atom (B (True)) -> do let !appl_62 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBst_inputRB) -> do !appl_63 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   !appl_64 <- appl_63 `pseq` (kl_Parse_shen_LBst_inputRB `pseq` eq appl_63 kl_Parse_shen_LBst_inputRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   !kl_if_65 <- appl_64 `pseq` kl_not appl_64
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   case kl_if_65 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       Atom (B (True)) -> do !appl_66 <- kl_Parse_shen_LBst_inputRB `pseq` hd kl_Parse_shen_LBst_inputRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             !appl_67 <- kl_Parse_shen_LBatomRB `pseq` kl_shen_hdtl kl_Parse_shen_LBatomRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             let !aw_68 = Types.Atom (Types.UnboundSym "macroexpand")
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             !appl_69 <- appl_67 `pseq` applyWrapper aw_68 [appl_67]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             !appl_70 <- kl_Parse_shen_LBst_inputRB `pseq` kl_shen_hdtl kl_Parse_shen_LBst_inputRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             !appl_71 <- appl_69 `pseq` (appl_70 `pseq` klCons appl_69 appl_70)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             appl_66 `pseq` (appl_71 `pseq` kl_shen_pair appl_66 appl_71)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !appl_72 <- kl_Parse_shen_LBatomRB `pseq` kl_shen_LBst_inputRB kl_Parse_shen_LBatomRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                appl_72 `pseq` applyWrapper appl_62 [appl_72]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       !appl_73 <- kl_V2236 `pseq` kl_shen_LBatomRB kl_V2236
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       !appl_74 <- appl_73 `pseq` applyWrapper appl_58 [appl_73]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       appl_74 `pseq` applyWrapper appl_33 [appl_74]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        let !appl_75 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBcommentRB) -> do !appl_76 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          !appl_77 <- appl_76 `pseq` (kl_Parse_shen_LBcommentRB `pseq` eq appl_76 kl_Parse_shen_LBcommentRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          !kl_if_78 <- appl_77 `pseq` kl_not appl_77
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          case kl_if_78 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              Atom (B (True)) -> do let !appl_79 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBst_inputRB) -> do !appl_80 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       !appl_81 <- appl_80 `pseq` (kl_Parse_shen_LBst_inputRB `pseq` eq appl_80 kl_Parse_shen_LBst_inputRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       !kl_if_82 <- appl_81 `pseq` kl_not appl_81
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       case kl_if_82 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           Atom (B (True)) -> do !appl_83 <- kl_Parse_shen_LBst_inputRB `pseq` hd kl_Parse_shen_LBst_inputRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 !appl_84 <- kl_Parse_shen_LBst_inputRB `pseq` kl_shen_hdtl kl_Parse_shen_LBst_inputRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 appl_83 `pseq` (appl_84 `pseq` kl_shen_pair appl_83 appl_84)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    !appl_85 <- kl_Parse_shen_LBcommentRB `pseq` kl_shen_LBst_inputRB kl_Parse_shen_LBcommentRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    appl_85 `pseq` applyWrapper appl_79 [appl_85]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        !appl_86 <- kl_V2236 `pseq` kl_shen_LBcommentRB kl_V2236
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        !appl_87 <- appl_86 `pseq` applyWrapper appl_75 [appl_86]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        appl_87 `pseq` applyWrapper appl_30 [appl_87]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         let !appl_88 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBcommaRB) -> do !appl_89 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !appl_90 <- appl_89 `pseq` (kl_Parse_shen_LBcommaRB `pseq` eq appl_89 kl_Parse_shen_LBcommaRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !kl_if_91 <- appl_90 `pseq` kl_not appl_90
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         case kl_if_91 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             Atom (B (True)) -> do let !appl_92 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBst_inputRB) -> do !appl_93 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_94 <- appl_93 `pseq` (kl_Parse_shen_LBst_inputRB `pseq` eq appl_93 kl_Parse_shen_LBst_inputRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !kl_if_95 <- appl_94 `pseq` kl_not appl_94
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      case kl_if_95 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          Atom (B (True)) -> do !appl_96 <- kl_Parse_shen_LBst_inputRB `pseq` hd kl_Parse_shen_LBst_inputRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !appl_97 <- intern (Types.Atom (Types.Str ","))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !appl_98 <- kl_Parse_shen_LBst_inputRB `pseq` kl_shen_hdtl kl_Parse_shen_LBst_inputRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !appl_99 <- appl_97 `pseq` (appl_98 `pseq` klCons appl_97 appl_98)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                appl_96 `pseq` (appl_99 `pseq` kl_shen_pair appl_96 appl_99)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   !appl_100 <- kl_Parse_shen_LBcommaRB `pseq` kl_shen_LBst_inputRB kl_Parse_shen_LBcommaRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   appl_100 `pseq` applyWrapper appl_92 [appl_100]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !appl_101 <- kl_V2236 `pseq` kl_shen_LBcommaRB kl_V2236
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !appl_102 <- appl_101 `pseq` applyWrapper appl_88 [appl_101]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         appl_102 `pseq` applyWrapper appl_27 [appl_102]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          let !appl_103 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBcolonRB) -> do !appl_104 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           !appl_105 <- appl_104 `pseq` (kl_Parse_shen_LBcolonRB `pseq` eq appl_104 kl_Parse_shen_LBcolonRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           !kl_if_106 <- appl_105 `pseq` kl_not appl_105
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           case kl_if_106 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               Atom (B (True)) -> do let !appl_107 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBst_inputRB) -> do !appl_108 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !appl_109 <- appl_108 `pseq` (kl_Parse_shen_LBst_inputRB `pseq` eq appl_108 kl_Parse_shen_LBst_inputRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !kl_if_110 <- appl_109 `pseq` kl_not appl_109
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         case kl_if_110 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             Atom (B (True)) -> do !appl_111 <- kl_Parse_shen_LBst_inputRB `pseq` hd kl_Parse_shen_LBst_inputRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   !appl_112 <- kl_Parse_shen_LBst_inputRB `pseq` kl_shen_hdtl kl_Parse_shen_LBst_inputRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   !appl_113 <- appl_112 `pseq` klCons (Types.Atom (Types.UnboundSym ":")) appl_112
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   appl_111 `pseq` (appl_113 `pseq` kl_shen_pair appl_111 appl_113)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     !appl_114 <- kl_Parse_shen_LBcolonRB `pseq` kl_shen_LBst_inputRB kl_Parse_shen_LBcolonRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     appl_114 `pseq` applyWrapper appl_107 [appl_114]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          !appl_115 <- kl_V2236 `pseq` kl_shen_LBcolonRB kl_V2236
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          !appl_116 <- appl_115 `pseq` applyWrapper appl_103 [appl_115]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          appl_116 `pseq` applyWrapper appl_24 [appl_116]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           let !appl_117 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBcolonRB) -> do !appl_118 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !appl_119 <- appl_118 `pseq` (kl_Parse_shen_LBcolonRB `pseq` eq appl_118 kl_Parse_shen_LBcolonRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !kl_if_120 <- appl_119 `pseq` kl_not appl_119
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            case kl_if_120 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Atom (B (True)) -> do let !appl_121 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBminusRB) -> do !appl_122 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       !appl_123 <- appl_122 `pseq` (kl_Parse_shen_LBminusRB `pseq` eq appl_122 kl_Parse_shen_LBminusRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       !kl_if_124 <- appl_123 `pseq` kl_not appl_123
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       case kl_if_124 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           Atom (B (True)) -> do let !appl_125 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBst_inputRB) -> do !appl_126 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     !appl_127 <- appl_126 `pseq` (kl_Parse_shen_LBst_inputRB `pseq` eq appl_126 kl_Parse_shen_LBst_inputRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     !kl_if_128 <- appl_127 `pseq` kl_not appl_127
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     case kl_if_128 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         Atom (B (True)) -> do !appl_129 <- kl_Parse_shen_LBst_inputRB `pseq` hd kl_Parse_shen_LBst_inputRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               !appl_130 <- kl_Parse_shen_LBst_inputRB `pseq` kl_shen_hdtl kl_Parse_shen_LBst_inputRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               !appl_131 <- appl_130 `pseq` klCons (Types.Atom (Types.UnboundSym ":-")) appl_130
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               appl_129 `pseq` (appl_131 `pseq` kl_shen_pair appl_129 appl_131)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 !appl_132 <- kl_Parse_shen_LBminusRB `pseq` kl_shen_LBst_inputRB kl_Parse_shen_LBminusRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 appl_132 `pseq` applyWrapper appl_125 [appl_132]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_133 <- kl_Parse_shen_LBcolonRB `pseq` kl_shen_LBminusRB kl_Parse_shen_LBcolonRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      appl_133 `pseq` applyWrapper appl_121 [appl_133]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           !appl_134 <- kl_V2236 `pseq` kl_shen_LBcolonRB kl_V2236
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           !appl_135 <- appl_134 `pseq` applyWrapper appl_117 [appl_134]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           appl_135 `pseq` applyWrapper appl_21 [appl_135]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            let !appl_136 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBcolonRB) -> do !appl_137 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             !appl_138 <- appl_137 `pseq` (kl_Parse_shen_LBcolonRB `pseq` eq appl_137 kl_Parse_shen_LBcolonRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             !kl_if_139 <- appl_138 `pseq` kl_not appl_138
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             case kl_if_139 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 Atom (B (True)) -> do let !appl_140 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBequalRB) -> do !appl_141 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        !appl_142 <- appl_141 `pseq` (kl_Parse_shen_LBequalRB `pseq` eq appl_141 kl_Parse_shen_LBequalRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        !kl_if_143 <- appl_142 `pseq` kl_not appl_142
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        case kl_if_143 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            Atom (B (True)) -> do let !appl_144 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBst_inputRB) -> do !appl_145 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_146 <- appl_145 `pseq` (kl_Parse_shen_LBst_inputRB `pseq` eq appl_145 kl_Parse_shen_LBst_inputRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !kl_if_147 <- appl_146 `pseq` kl_not appl_146
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      case kl_if_147 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          Atom (B (True)) -> do !appl_148 <- kl_Parse_shen_LBst_inputRB `pseq` hd kl_Parse_shen_LBst_inputRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !appl_149 <- kl_Parse_shen_LBst_inputRB `pseq` kl_shen_hdtl kl_Parse_shen_LBst_inputRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !appl_150 <- appl_149 `pseq` klCons (Types.Atom (Types.UnboundSym ":=")) appl_149
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                appl_148 `pseq` (appl_150 `pseq` kl_shen_pair appl_148 appl_150)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !appl_151 <- kl_Parse_shen_LBequalRB `pseq` kl_shen_LBst_inputRB kl_Parse_shen_LBequalRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  appl_151 `pseq` applyWrapper appl_144 [appl_151]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       !appl_152 <- kl_Parse_shen_LBcolonRB `pseq` kl_shen_LBequalRB kl_Parse_shen_LBcolonRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       appl_152 `pseq` applyWrapper appl_140 [appl_152]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !appl_153 <- kl_V2236 `pseq` kl_shen_LBcolonRB kl_V2236
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !appl_154 <- appl_153 `pseq` applyWrapper appl_136 [appl_153]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            appl_154 `pseq` applyWrapper appl_18 [appl_154]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             let !appl_155 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBsemicolonRB) -> do !appl_156 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !appl_157 <- appl_156 `pseq` (kl_Parse_shen_LBsemicolonRB `pseq` eq appl_156 kl_Parse_shen_LBsemicolonRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !kl_if_158 <- appl_157 `pseq` kl_not appl_157
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  case kl_if_158 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      Atom (B (True)) -> do let !appl_159 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBst_inputRB) -> do !appl_160 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !appl_161 <- appl_160 `pseq` (kl_Parse_shen_LBst_inputRB `pseq` eq appl_160 kl_Parse_shen_LBst_inputRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !kl_if_162 <- appl_161 `pseq` kl_not appl_161
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                case kl_if_162 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Atom (B (True)) -> do !appl_163 <- kl_Parse_shen_LBst_inputRB `pseq` hd kl_Parse_shen_LBst_inputRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          !appl_164 <- kl_Parse_shen_LBst_inputRB `pseq` kl_shen_hdtl kl_Parse_shen_LBst_inputRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          !appl_165 <- appl_164 `pseq` klCons (Types.Atom (Types.UnboundSym ";")) appl_164
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          appl_163 `pseq` (appl_165 `pseq` kl_shen_pair appl_163 appl_165)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !appl_166 <- kl_Parse_shen_LBsemicolonRB `pseq` kl_shen_LBst_inputRB kl_Parse_shen_LBsemicolonRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            appl_166 `pseq` applyWrapper appl_159 [appl_166]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             !appl_167 <- kl_V2236 `pseq` kl_shen_LBsemicolonRB kl_V2236
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             !appl_168 <- appl_167 `pseq` applyWrapper appl_155 [appl_167]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             appl_168 `pseq` applyWrapper appl_15 [appl_168]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                              let !appl_169 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBbarRB) -> do !appl_170 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             !appl_171 <- appl_170 `pseq` (kl_Parse_shen_LBbarRB `pseq` eq appl_170 kl_Parse_shen_LBbarRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             !kl_if_172 <- appl_171 `pseq` kl_not appl_171
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             case kl_if_172 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 Atom (B (True)) -> do let !appl_173 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBst_inputRB) -> do !appl_174 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           !appl_175 <- appl_174 `pseq` (kl_Parse_shen_LBst_inputRB `pseq` eq appl_174 kl_Parse_shen_LBst_inputRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           !kl_if_176 <- appl_175 `pseq` kl_not appl_175
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           case kl_if_176 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               Atom (B (True)) -> do !appl_177 <- kl_Parse_shen_LBst_inputRB `pseq` hd kl_Parse_shen_LBst_inputRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     !appl_178 <- kl_Parse_shen_LBst_inputRB `pseq` kl_shen_hdtl kl_Parse_shen_LBst_inputRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     !appl_179 <- appl_178 `pseq` klCons (Types.Atom (Types.UnboundSym "bar!")) appl_178
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     appl_177 `pseq` (appl_179 `pseq` kl_shen_pair appl_177 appl_179)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       !appl_180 <- kl_Parse_shen_LBbarRB `pseq` kl_shen_LBst_inputRB kl_Parse_shen_LBbarRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       appl_180 `pseq` applyWrapper appl_173 [appl_180]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                              !appl_181 <- kl_V2236 `pseq` kl_shen_LBbarRB kl_V2236
                                                                                                                                                                                                                                                                                                                                                                                                                              !appl_182 <- appl_181 `pseq` applyWrapper appl_169 [appl_181]
                                                                                                                                                                                                                                                                                                                                                                                                                              appl_182 `pseq` applyWrapper appl_12 [appl_182]
                                                                                                                                                                                                                                                                                                                                                                                                        Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                                                                                                                                                                                                                                                                                                        _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                let !appl_183 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBrcurlyRB) -> do !appl_184 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                  !appl_185 <- appl_184 `pseq` (kl_Parse_shen_LBrcurlyRB `pseq` eq appl_184 kl_Parse_shen_LBrcurlyRB)
                                                                                                                                                                                                                                                                                                                                                                                                                  !kl_if_186 <- appl_185 `pseq` kl_not appl_185
                                                                                                                                                                                                                                                                                                                                                                                                                  case kl_if_186 of
                                                                                                                                                                                                                                                                                                                                                                                                                      Atom (B (True)) -> do let !appl_187 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBst_inputRB) -> do !appl_188 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !appl_189 <- appl_188 `pseq` (kl_Parse_shen_LBst_inputRB `pseq` eq appl_188 kl_Parse_shen_LBst_inputRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !kl_if_190 <- appl_189 `pseq` kl_not appl_189
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                case kl_if_190 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Atom (B (True)) -> do !appl_191 <- kl_Parse_shen_LBst_inputRB `pseq` hd kl_Parse_shen_LBst_inputRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          !appl_192 <- kl_Parse_shen_LBst_inputRB `pseq` kl_shen_hdtl kl_Parse_shen_LBst_inputRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          !appl_193 <- appl_192 `pseq` klCons (Types.Atom (Types.UnboundSym "}")) appl_192
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          appl_191 `pseq` (appl_193 `pseq` kl_shen_pair appl_191 appl_193)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                            !appl_194 <- kl_Parse_shen_LBrcurlyRB `pseq` kl_shen_LBst_inputRB kl_Parse_shen_LBrcurlyRB
                                                                                                                                                                                                                                                                                                                                                                                                                                            appl_194 `pseq` applyWrapper appl_187 [appl_194]
                                                                                                                                                                                                                                                                                                                                                                                                                      Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                      _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                !appl_195 <- kl_V2236 `pseq` kl_shen_LBrcurlyRB kl_V2236
                                                                                                                                                                                                                                                                                                                                !appl_196 <- appl_195 `pseq` applyWrapper appl_183 [appl_195]
                                                                                                                                                                                                                                                                                                                                appl_196 `pseq` applyWrapper appl_9 [appl_196]
                                                                                                                                                                                                                                                                                                          Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                                                                                                                                                                                                          _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                  let !appl_197 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBlcurlyRB) -> do !appl_198 <- kl_fail
                                                                                                                                                                                                                                                                                                                    !appl_199 <- appl_198 `pseq` (kl_Parse_shen_LBlcurlyRB `pseq` eq appl_198 kl_Parse_shen_LBlcurlyRB)
                                                                                                                                                                                                                                                                                                                    !kl_if_200 <- appl_199 `pseq` kl_not appl_199
                                                                                                                                                                                                                                                                                                                    case kl_if_200 of
                                                                                                                                                                                                                                                                                                                        Atom (B (True)) -> do let !appl_201 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBst_inputRB) -> do !appl_202 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                  !appl_203 <- appl_202 `pseq` (kl_Parse_shen_LBst_inputRB `pseq` eq appl_202 kl_Parse_shen_LBst_inputRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                  !kl_if_204 <- appl_203 `pseq` kl_not appl_203
                                                                                                                                                                                                                                                                                                                                                                                                                                  case kl_if_204 of
                                                                                                                                                                                                                                                                                                                                                                                                                                      Atom (B (True)) -> do !appl_205 <- kl_Parse_shen_LBst_inputRB `pseq` hd kl_Parse_shen_LBst_inputRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                            !appl_206 <- kl_Parse_shen_LBst_inputRB `pseq` kl_shen_hdtl kl_Parse_shen_LBst_inputRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                            !appl_207 <- appl_206 `pseq` klCons (Types.Atom (Types.UnboundSym "{")) appl_206
                                                                                                                                                                                                                                                                                                                                                                                                                                                            appl_205 `pseq` (appl_207 `pseq` kl_shen_pair appl_205 appl_207)
                                                                                                                                                                                                                                                                                                                                                                                                                                      Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                      _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                              !appl_208 <- kl_Parse_shen_LBlcurlyRB `pseq` kl_shen_LBst_inputRB kl_Parse_shen_LBlcurlyRB
                                                                                                                                                                                                                                                                                                                                              appl_208 `pseq` applyWrapper appl_201 [appl_208]
                                                                                                                                                                                                                                                                                                                        Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                        _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                  !appl_209 <- kl_V2236 `pseq` kl_shen_LBlcurlyRB kl_V2236
                                                                                                                                                                                                                                  !appl_210 <- appl_209 `pseq` applyWrapper appl_197 [appl_209]
                                                                                                                                                                                                                                  appl_210 `pseq` applyWrapper appl_6 [appl_210]
                                                                                                                                                                                                            Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                                                                                                            _ -> throwError "if: expected boolean")))
                                                                                                                                    let !appl_211 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBlrbRB) -> do !appl_212 <- kl_fail
                                                                                                                                                                                                                   !appl_213 <- appl_212 `pseq` (kl_Parse_shen_LBlrbRB `pseq` eq appl_212 kl_Parse_shen_LBlrbRB)
                                                                                                                                                                                                                   !kl_if_214 <- appl_213 `pseq` kl_not appl_213
                                                                                                                                                                                                                   case kl_if_214 of
                                                                                                                                                                                                                       Atom (B (True)) -> do let !appl_215 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBst_input1RB) -> do !appl_216 <- kl_fail
                                                                                                                                                                                                                                                                                                                                  !appl_217 <- appl_216 `pseq` (kl_Parse_shen_LBst_input1RB `pseq` eq appl_216 kl_Parse_shen_LBst_input1RB)
                                                                                                                                                                                                                                                                                                                                  !kl_if_218 <- appl_217 `pseq` kl_not appl_217
                                                                                                                                                                                                                                                                                                                                  case kl_if_218 of
                                                                                                                                                                                                                                                                                                                                      Atom (B (True)) -> do let !appl_219 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBrrbRB) -> do !appl_220 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                           !appl_221 <- appl_220 `pseq` (kl_Parse_shen_LBrrbRB `pseq` eq appl_220 kl_Parse_shen_LBrrbRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                           !kl_if_222 <- appl_221 `pseq` kl_not appl_221
                                                                                                                                                                                                                                                                                                                                                                                                                                           case kl_if_222 of
                                                                                                                                                                                                                                                                                                                                                                                                                                               Atom (B (True)) -> do let !appl_223 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBst_input2RB) -> do !appl_224 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          !appl_225 <- appl_224 `pseq` (kl_Parse_shen_LBst_input2RB `pseq` eq appl_224 kl_Parse_shen_LBst_input2RB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          !kl_if_226 <- appl_225 `pseq` kl_not appl_225
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          case kl_if_226 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              Atom (B (True)) -> do !appl_227 <- kl_Parse_shen_LBst_input2RB `pseq` hd kl_Parse_shen_LBst_input2RB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    !appl_228 <- kl_Parse_shen_LBst_input1RB `pseq` kl_shen_hdtl kl_Parse_shen_LBst_input1RB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    let !aw_229 = Types.Atom (Types.UnboundSym "macroexpand")
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    !appl_230 <- appl_228 `pseq` applyWrapper aw_229 [appl_228]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    !appl_231 <- kl_Parse_shen_LBst_input2RB `pseq` kl_shen_hdtl kl_Parse_shen_LBst_input2RB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    !appl_232 <- appl_230 `pseq` (appl_231 `pseq` kl_shen_package_macro appl_230 appl_231)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    appl_227 `pseq` (appl_232 `pseq` kl_shen_pair appl_227 appl_232)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                     !appl_233 <- kl_Parse_shen_LBrrbRB `pseq` kl_shen_LBst_input2RB kl_Parse_shen_LBrrbRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                     appl_233 `pseq` applyWrapper appl_223 [appl_233]
                                                                                                                                                                                                                                                                                                                                                                                                                                               Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                               _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                            !appl_234 <- kl_Parse_shen_LBst_input1RB `pseq` kl_shen_LBrrbRB kl_Parse_shen_LBst_input1RB
                                                                                                                                                                                                                                                                                                                                                            appl_234 `pseq` applyWrapper appl_219 [appl_234]
                                                                                                                                                                                                                                                                                                                                      Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                      _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                             !appl_235 <- kl_Parse_shen_LBlrbRB `pseq` kl_shen_LBst_input1RB kl_Parse_shen_LBlrbRB
                                                                                                                                                                                                                                             appl_235 `pseq` applyWrapper appl_215 [appl_235]
                                                                                                                                                                                                                       Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                       _ -> throwError "if: expected boolean")))
                                                                                                                                    !appl_236 <- kl_V2236 `pseq` kl_shen_LBlrbRB kl_V2236
                                                                                                                                    !appl_237 <- appl_236 `pseq` applyWrapper appl_211 [appl_236]
                                                                                                                                    appl_237 `pseq` applyWrapper appl_3 [appl_237]
                                                                                                              Atom (B (False)) -> do do return kl_YaccParse
                                                                                                              _ -> throwError "if: expected boolean")))
                                      let !appl_238 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBlsbRB) -> do !appl_239 <- kl_fail
                                                                                                                     !appl_240 <- appl_239 `pseq` (kl_Parse_shen_LBlsbRB `pseq` eq appl_239 kl_Parse_shen_LBlsbRB)
                                                                                                                     !kl_if_241 <- appl_240 `pseq` kl_not appl_240
                                                                                                                     case kl_if_241 of
                                                                                                                         Atom (B (True)) -> do let !appl_242 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBst_input1RB) -> do !appl_243 <- kl_fail
                                                                                                                                                                                                                                    !appl_244 <- appl_243 `pseq` (kl_Parse_shen_LBst_input1RB `pseq` eq appl_243 kl_Parse_shen_LBst_input1RB)
                                                                                                                                                                                                                                    !kl_if_245 <- appl_244 `pseq` kl_not appl_244
                                                                                                                                                                                                                                    case kl_if_245 of
                                                                                                                                                                                                                                        Atom (B (True)) -> do let !appl_246 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBrsbRB) -> do !appl_247 <- kl_fail
                                                                                                                                                                                                                                                                                                                                             !appl_248 <- appl_247 `pseq` (kl_Parse_shen_LBrsbRB `pseq` eq appl_247 kl_Parse_shen_LBrsbRB)
                                                                                                                                                                                                                                                                                                                                             !kl_if_249 <- appl_248 `pseq` kl_not appl_248
                                                                                                                                                                                                                                                                                                                                             case kl_if_249 of
                                                                                                                                                                                                                                                                                                                                                 Atom (B (True)) -> do let !appl_250 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBst_input2RB) -> do !appl_251 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                            !appl_252 <- appl_251 `pseq` (kl_Parse_shen_LBst_input2RB `pseq` eq appl_251 kl_Parse_shen_LBst_input2RB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                            !kl_if_253 <- appl_252 `pseq` kl_not appl_252
                                                                                                                                                                                                                                                                                                                                                                                                                                                            case kl_if_253 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                Atom (B (True)) -> do !appl_254 <- kl_Parse_shen_LBst_input2RB `pseq` hd kl_Parse_shen_LBst_input2RB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_255 <- kl_Parse_shen_LBst_input1RB `pseq` kl_shen_hdtl kl_Parse_shen_LBst_input1RB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_256 <- appl_255 `pseq` kl_shen_cons_form appl_255
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      let !aw_257 = Types.Atom (Types.UnboundSym "macroexpand")
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_258 <- appl_256 `pseq` applyWrapper aw_257 [appl_256]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_259 <- kl_Parse_shen_LBst_input2RB `pseq` kl_shen_hdtl kl_Parse_shen_LBst_input2RB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_260 <- appl_258 `pseq` (appl_259 `pseq` klCons appl_258 appl_259)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      appl_254 `pseq` (appl_260 `pseq` kl_shen_pair appl_254 appl_260)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                       !appl_261 <- kl_Parse_shen_LBrsbRB `pseq` kl_shen_LBst_input2RB kl_Parse_shen_LBrsbRB
                                                                                                                                                                                                                                                                                                                                                                       appl_261 `pseq` applyWrapper appl_250 [appl_261]
                                                                                                                                                                                                                                                                                                                                                 Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                 _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                              !appl_262 <- kl_Parse_shen_LBst_input1RB `pseq` kl_shen_LBrsbRB kl_Parse_shen_LBst_input1RB
                                                                                                                                                                                                                                                              appl_262 `pseq` applyWrapper appl_246 [appl_262]
                                                                                                                                                                                                                                        Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                        _ -> throwError "if: expected boolean")))
                                                                                                                                               !appl_263 <- kl_Parse_shen_LBlsbRB `pseq` kl_shen_LBst_input1RB kl_Parse_shen_LBlsbRB
                                                                                                                                               appl_263 `pseq` applyWrapper appl_242 [appl_263]
                                                                                                                         Atom (B (False)) -> do do kl_fail
                                                                                                                         _ -> throwError "if: expected boolean")))
                                      !appl_264 <- kl_V2236 `pseq` kl_shen_LBlsbRB kl_V2236
                                      !appl_265 <- appl_264 `pseq` applyWrapper appl_238 [appl_264]
                                      appl_265 `pseq` applyWrapper appl_0 [appl_265]

kl_shen_LBlsbRB :: Types.KLValue ->
                   Types.KLContext Types.Env Types.KLValue
kl_shen_LBlsbRB (!kl_V2238) = do !appl_0 <- kl_V2238 `pseq` hd kl_V2238
                                 !kl_if_1 <- appl_0 `pseq` consP appl_0
                                 !kl_if_2 <- case kl_if_1 of
                                                 Atom (B (True)) -> do !appl_3 <- kl_V2238 `pseq` hd kl_V2238
                                                                       !appl_4 <- appl_3 `pseq` hd appl_3
                                                                       !kl_if_5 <- appl_4 `pseq` eq (Types.Atom (Types.N (Types.KI 91))) appl_4
                                                                       case kl_if_5 of
                                                                           Atom (B (True)) -> do return (Atom (B True))
                                                                           Atom (B (False)) -> do do return (Atom (B False))
                                                                           _ -> throwError "if: expected boolean"
                                                 Atom (B (False)) -> do do return (Atom (B False))
                                                 _ -> throwError "if: expected boolean"
                                 case kl_if_2 of
                                     Atom (B (True)) -> do !appl_6 <- kl_V2238 `pseq` hd kl_V2238
                                                           !appl_7 <- appl_6 `pseq` tl appl_6
                                                           !appl_8 <- kl_V2238 `pseq` kl_shen_hdtl kl_V2238
                                                           !appl_9 <- appl_7 `pseq` (appl_8 `pseq` kl_shen_pair appl_7 appl_8)
                                                           !appl_10 <- appl_9 `pseq` hd appl_9
                                                           appl_10 `pseq` kl_shen_pair appl_10 (Types.Atom (Types.UnboundSym "shen.skip"))
                                     Atom (B (False)) -> do do kl_fail
                                     _ -> throwError "if: expected boolean"

kl_shen_LBrsbRB :: Types.KLValue ->
                   Types.KLContext Types.Env Types.KLValue
kl_shen_LBrsbRB (!kl_V2240) = do !appl_0 <- kl_V2240 `pseq` hd kl_V2240
                                 !kl_if_1 <- appl_0 `pseq` consP appl_0
                                 !kl_if_2 <- case kl_if_1 of
                                                 Atom (B (True)) -> do !appl_3 <- kl_V2240 `pseq` hd kl_V2240
                                                                       !appl_4 <- appl_3 `pseq` hd appl_3
                                                                       !kl_if_5 <- appl_4 `pseq` eq (Types.Atom (Types.N (Types.KI 93))) appl_4
                                                                       case kl_if_5 of
                                                                           Atom (B (True)) -> do return (Atom (B True))
                                                                           Atom (B (False)) -> do do return (Atom (B False))
                                                                           _ -> throwError "if: expected boolean"
                                                 Atom (B (False)) -> do do return (Atom (B False))
                                                 _ -> throwError "if: expected boolean"
                                 case kl_if_2 of
                                     Atom (B (True)) -> do !appl_6 <- kl_V2240 `pseq` hd kl_V2240
                                                           !appl_7 <- appl_6 `pseq` tl appl_6
                                                           !appl_8 <- kl_V2240 `pseq` kl_shen_hdtl kl_V2240
                                                           !appl_9 <- appl_7 `pseq` (appl_8 `pseq` kl_shen_pair appl_7 appl_8)
                                                           !appl_10 <- appl_9 `pseq` hd appl_9
                                                           appl_10 `pseq` kl_shen_pair appl_10 (Types.Atom (Types.UnboundSym "shen.skip"))
                                     Atom (B (False)) -> do do kl_fail
                                     _ -> throwError "if: expected boolean"

kl_shen_LBlcurlyRB :: Types.KLValue ->
                      Types.KLContext Types.Env Types.KLValue
kl_shen_LBlcurlyRB (!kl_V2242) = do !appl_0 <- kl_V2242 `pseq` hd kl_V2242
                                    !kl_if_1 <- appl_0 `pseq` consP appl_0
                                    !kl_if_2 <- case kl_if_1 of
                                                    Atom (B (True)) -> do !appl_3 <- kl_V2242 `pseq` hd kl_V2242
                                                                          !appl_4 <- appl_3 `pseq` hd appl_3
                                                                          !kl_if_5 <- appl_4 `pseq` eq (Types.Atom (Types.N (Types.KI 123))) appl_4
                                                                          case kl_if_5 of
                                                                              Atom (B (True)) -> do return (Atom (B True))
                                                                              Atom (B (False)) -> do do return (Atom (B False))
                                                                              _ -> throwError "if: expected boolean"
                                                    Atom (B (False)) -> do do return (Atom (B False))
                                                    _ -> throwError "if: expected boolean"
                                    case kl_if_2 of
                                        Atom (B (True)) -> do !appl_6 <- kl_V2242 `pseq` hd kl_V2242
                                                              !appl_7 <- appl_6 `pseq` tl appl_6
                                                              !appl_8 <- kl_V2242 `pseq` kl_shen_hdtl kl_V2242
                                                              !appl_9 <- appl_7 `pseq` (appl_8 `pseq` kl_shen_pair appl_7 appl_8)
                                                              !appl_10 <- appl_9 `pseq` hd appl_9
                                                              appl_10 `pseq` kl_shen_pair appl_10 (Types.Atom (Types.UnboundSym "shen.skip"))
                                        Atom (B (False)) -> do do kl_fail
                                        _ -> throwError "if: expected boolean"

kl_shen_LBrcurlyRB :: Types.KLValue ->
                      Types.KLContext Types.Env Types.KLValue
kl_shen_LBrcurlyRB (!kl_V2244) = do !appl_0 <- kl_V2244 `pseq` hd kl_V2244
                                    !kl_if_1 <- appl_0 `pseq` consP appl_0
                                    !kl_if_2 <- case kl_if_1 of
                                                    Atom (B (True)) -> do !appl_3 <- kl_V2244 `pseq` hd kl_V2244
                                                                          !appl_4 <- appl_3 `pseq` hd appl_3
                                                                          !kl_if_5 <- appl_4 `pseq` eq (Types.Atom (Types.N (Types.KI 125))) appl_4
                                                                          case kl_if_5 of
                                                                              Atom (B (True)) -> do return (Atom (B True))
                                                                              Atom (B (False)) -> do do return (Atom (B False))
                                                                              _ -> throwError "if: expected boolean"
                                                    Atom (B (False)) -> do do return (Atom (B False))
                                                    _ -> throwError "if: expected boolean"
                                    case kl_if_2 of
                                        Atom (B (True)) -> do !appl_6 <- kl_V2244 `pseq` hd kl_V2244
                                                              !appl_7 <- appl_6 `pseq` tl appl_6
                                                              !appl_8 <- kl_V2244 `pseq` kl_shen_hdtl kl_V2244
                                                              !appl_9 <- appl_7 `pseq` (appl_8 `pseq` kl_shen_pair appl_7 appl_8)
                                                              !appl_10 <- appl_9 `pseq` hd appl_9
                                                              appl_10 `pseq` kl_shen_pair appl_10 (Types.Atom (Types.UnboundSym "shen.skip"))
                                        Atom (B (False)) -> do do kl_fail
                                        _ -> throwError "if: expected boolean"

kl_shen_LBbarRB :: Types.KLValue ->
                   Types.KLContext Types.Env Types.KLValue
kl_shen_LBbarRB (!kl_V2246) = do !appl_0 <- kl_V2246 `pseq` hd kl_V2246
                                 !kl_if_1 <- appl_0 `pseq` consP appl_0
                                 !kl_if_2 <- case kl_if_1 of
                                                 Atom (B (True)) -> do !appl_3 <- kl_V2246 `pseq` hd kl_V2246
                                                                       !appl_4 <- appl_3 `pseq` hd appl_3
                                                                       !kl_if_5 <- appl_4 `pseq` eq (Types.Atom (Types.N (Types.KI 124))) appl_4
                                                                       case kl_if_5 of
                                                                           Atom (B (True)) -> do return (Atom (B True))
                                                                           Atom (B (False)) -> do do return (Atom (B False))
                                                                           _ -> throwError "if: expected boolean"
                                                 Atom (B (False)) -> do do return (Atom (B False))
                                                 _ -> throwError "if: expected boolean"
                                 case kl_if_2 of
                                     Atom (B (True)) -> do !appl_6 <- kl_V2246 `pseq` hd kl_V2246
                                                           !appl_7 <- appl_6 `pseq` tl appl_6
                                                           !appl_8 <- kl_V2246 `pseq` kl_shen_hdtl kl_V2246
                                                           !appl_9 <- appl_7 `pseq` (appl_8 `pseq` kl_shen_pair appl_7 appl_8)
                                                           !appl_10 <- appl_9 `pseq` hd appl_9
                                                           appl_10 `pseq` kl_shen_pair appl_10 (Types.Atom (Types.UnboundSym "shen.skip"))
                                     Atom (B (False)) -> do do kl_fail
                                     _ -> throwError "if: expected boolean"

kl_shen_LBsemicolonRB :: Types.KLValue ->
                         Types.KLContext Types.Env Types.KLValue
kl_shen_LBsemicolonRB (!kl_V2248) = do !appl_0 <- kl_V2248 `pseq` hd kl_V2248
                                       !kl_if_1 <- appl_0 `pseq` consP appl_0
                                       !kl_if_2 <- case kl_if_1 of
                                                       Atom (B (True)) -> do !appl_3 <- kl_V2248 `pseq` hd kl_V2248
                                                                             !appl_4 <- appl_3 `pseq` hd appl_3
                                                                             !kl_if_5 <- appl_4 `pseq` eq (Types.Atom (Types.N (Types.KI 59))) appl_4
                                                                             case kl_if_5 of
                                                                                 Atom (B (True)) -> do return (Atom (B True))
                                                                                 Atom (B (False)) -> do do return (Atom (B False))
                                                                                 _ -> throwError "if: expected boolean"
                                                       Atom (B (False)) -> do do return (Atom (B False))
                                                       _ -> throwError "if: expected boolean"
                                       case kl_if_2 of
                                           Atom (B (True)) -> do !appl_6 <- kl_V2248 `pseq` hd kl_V2248
                                                                 !appl_7 <- appl_6 `pseq` tl appl_6
                                                                 !appl_8 <- kl_V2248 `pseq` kl_shen_hdtl kl_V2248
                                                                 !appl_9 <- appl_7 `pseq` (appl_8 `pseq` kl_shen_pair appl_7 appl_8)
                                                                 !appl_10 <- appl_9 `pseq` hd appl_9
                                                                 appl_10 `pseq` kl_shen_pair appl_10 (Types.Atom (Types.UnboundSym "shen.skip"))
                                           Atom (B (False)) -> do do kl_fail
                                           _ -> throwError "if: expected boolean"

kl_shen_LBcolonRB :: Types.KLValue ->
                     Types.KLContext Types.Env Types.KLValue
kl_shen_LBcolonRB (!kl_V2250) = do !appl_0 <- kl_V2250 `pseq` hd kl_V2250
                                   !kl_if_1 <- appl_0 `pseq` consP appl_0
                                   !kl_if_2 <- case kl_if_1 of
                                                   Atom (B (True)) -> do !appl_3 <- kl_V2250 `pseq` hd kl_V2250
                                                                         !appl_4 <- appl_3 `pseq` hd appl_3
                                                                         !kl_if_5 <- appl_4 `pseq` eq (Types.Atom (Types.N (Types.KI 58))) appl_4
                                                                         case kl_if_5 of
                                                                             Atom (B (True)) -> do return (Atom (B True))
                                                                             Atom (B (False)) -> do do return (Atom (B False))
                                                                             _ -> throwError "if: expected boolean"
                                                   Atom (B (False)) -> do do return (Atom (B False))
                                                   _ -> throwError "if: expected boolean"
                                   case kl_if_2 of
                                       Atom (B (True)) -> do !appl_6 <- kl_V2250 `pseq` hd kl_V2250
                                                             !appl_7 <- appl_6 `pseq` tl appl_6
                                                             !appl_8 <- kl_V2250 `pseq` kl_shen_hdtl kl_V2250
                                                             !appl_9 <- appl_7 `pseq` (appl_8 `pseq` kl_shen_pair appl_7 appl_8)
                                                             !appl_10 <- appl_9 `pseq` hd appl_9
                                                             appl_10 `pseq` kl_shen_pair appl_10 (Types.Atom (Types.UnboundSym "shen.skip"))
                                       Atom (B (False)) -> do do kl_fail
                                       _ -> throwError "if: expected boolean"

kl_shen_LBcommaRB :: Types.KLValue ->
                     Types.KLContext Types.Env Types.KLValue
kl_shen_LBcommaRB (!kl_V2252) = do !appl_0 <- kl_V2252 `pseq` hd kl_V2252
                                   !kl_if_1 <- appl_0 `pseq` consP appl_0
                                   !kl_if_2 <- case kl_if_1 of
                                                   Atom (B (True)) -> do !appl_3 <- kl_V2252 `pseq` hd kl_V2252
                                                                         !appl_4 <- appl_3 `pseq` hd appl_3
                                                                         !kl_if_5 <- appl_4 `pseq` eq (Types.Atom (Types.N (Types.KI 44))) appl_4
                                                                         case kl_if_5 of
                                                                             Atom (B (True)) -> do return (Atom (B True))
                                                                             Atom (B (False)) -> do do return (Atom (B False))
                                                                             _ -> throwError "if: expected boolean"
                                                   Atom (B (False)) -> do do return (Atom (B False))
                                                   _ -> throwError "if: expected boolean"
                                   case kl_if_2 of
                                       Atom (B (True)) -> do !appl_6 <- kl_V2252 `pseq` hd kl_V2252
                                                             !appl_7 <- appl_6 `pseq` tl appl_6
                                                             !appl_8 <- kl_V2252 `pseq` kl_shen_hdtl kl_V2252
                                                             !appl_9 <- appl_7 `pseq` (appl_8 `pseq` kl_shen_pair appl_7 appl_8)
                                                             !appl_10 <- appl_9 `pseq` hd appl_9
                                                             appl_10 `pseq` kl_shen_pair appl_10 (Types.Atom (Types.UnboundSym "shen.skip"))
                                       Atom (B (False)) -> do do kl_fail
                                       _ -> throwError "if: expected boolean"

kl_shen_LBequalRB :: Types.KLValue ->
                     Types.KLContext Types.Env Types.KLValue
kl_shen_LBequalRB (!kl_V2254) = do !appl_0 <- kl_V2254 `pseq` hd kl_V2254
                                   !kl_if_1 <- appl_0 `pseq` consP appl_0
                                   !kl_if_2 <- case kl_if_1 of
                                                   Atom (B (True)) -> do !appl_3 <- kl_V2254 `pseq` hd kl_V2254
                                                                         !appl_4 <- appl_3 `pseq` hd appl_3
                                                                         !kl_if_5 <- appl_4 `pseq` eq (Types.Atom (Types.N (Types.KI 61))) appl_4
                                                                         case kl_if_5 of
                                                                             Atom (B (True)) -> do return (Atom (B True))
                                                                             Atom (B (False)) -> do do return (Atom (B False))
                                                                             _ -> throwError "if: expected boolean"
                                                   Atom (B (False)) -> do do return (Atom (B False))
                                                   _ -> throwError "if: expected boolean"
                                   case kl_if_2 of
                                       Atom (B (True)) -> do !appl_6 <- kl_V2254 `pseq` hd kl_V2254
                                                             !appl_7 <- appl_6 `pseq` tl appl_6
                                                             !appl_8 <- kl_V2254 `pseq` kl_shen_hdtl kl_V2254
                                                             !appl_9 <- appl_7 `pseq` (appl_8 `pseq` kl_shen_pair appl_7 appl_8)
                                                             !appl_10 <- appl_9 `pseq` hd appl_9
                                                             appl_10 `pseq` kl_shen_pair appl_10 (Types.Atom (Types.UnboundSym "shen.skip"))
                                       Atom (B (False)) -> do do kl_fail
                                       _ -> throwError "if: expected boolean"

kl_shen_LBminusRB :: Types.KLValue ->
                     Types.KLContext Types.Env Types.KLValue
kl_shen_LBminusRB (!kl_V2256) = do !appl_0 <- kl_V2256 `pseq` hd kl_V2256
                                   !kl_if_1 <- appl_0 `pseq` consP appl_0
                                   !kl_if_2 <- case kl_if_1 of
                                                   Atom (B (True)) -> do !appl_3 <- kl_V2256 `pseq` hd kl_V2256
                                                                         !appl_4 <- appl_3 `pseq` hd appl_3
                                                                         !kl_if_5 <- appl_4 `pseq` eq (Types.Atom (Types.N (Types.KI 45))) appl_4
                                                                         case kl_if_5 of
                                                                             Atom (B (True)) -> do return (Atom (B True))
                                                                             Atom (B (False)) -> do do return (Atom (B False))
                                                                             _ -> throwError "if: expected boolean"
                                                   Atom (B (False)) -> do do return (Atom (B False))
                                                   _ -> throwError "if: expected boolean"
                                   case kl_if_2 of
                                       Atom (B (True)) -> do !appl_6 <- kl_V2256 `pseq` hd kl_V2256
                                                             !appl_7 <- appl_6 `pseq` tl appl_6
                                                             !appl_8 <- kl_V2256 `pseq` kl_shen_hdtl kl_V2256
                                                             !appl_9 <- appl_7 `pseq` (appl_8 `pseq` kl_shen_pair appl_7 appl_8)
                                                             !appl_10 <- appl_9 `pseq` hd appl_9
                                                             appl_10 `pseq` kl_shen_pair appl_10 (Types.Atom (Types.UnboundSym "shen.skip"))
                                       Atom (B (False)) -> do do kl_fail
                                       _ -> throwError "if: expected boolean"

kl_shen_LBlrbRB :: Types.KLValue ->
                   Types.KLContext Types.Env Types.KLValue
kl_shen_LBlrbRB (!kl_V2258) = do !appl_0 <- kl_V2258 `pseq` hd kl_V2258
                                 !kl_if_1 <- appl_0 `pseq` consP appl_0
                                 !kl_if_2 <- case kl_if_1 of
                                                 Atom (B (True)) -> do !appl_3 <- kl_V2258 `pseq` hd kl_V2258
                                                                       !appl_4 <- appl_3 `pseq` hd appl_3
                                                                       !kl_if_5 <- appl_4 `pseq` eq (Types.Atom (Types.N (Types.KI 40))) appl_4
                                                                       case kl_if_5 of
                                                                           Atom (B (True)) -> do return (Atom (B True))
                                                                           Atom (B (False)) -> do do return (Atom (B False))
                                                                           _ -> throwError "if: expected boolean"
                                                 Atom (B (False)) -> do do return (Atom (B False))
                                                 _ -> throwError "if: expected boolean"
                                 case kl_if_2 of
                                     Atom (B (True)) -> do !appl_6 <- kl_V2258 `pseq` hd kl_V2258
                                                           !appl_7 <- appl_6 `pseq` tl appl_6
                                                           !appl_8 <- kl_V2258 `pseq` kl_shen_hdtl kl_V2258
                                                           !appl_9 <- appl_7 `pseq` (appl_8 `pseq` kl_shen_pair appl_7 appl_8)
                                                           !appl_10 <- appl_9 `pseq` hd appl_9
                                                           appl_10 `pseq` kl_shen_pair appl_10 (Types.Atom (Types.UnboundSym "shen.skip"))
                                     Atom (B (False)) -> do do kl_fail
                                     _ -> throwError "if: expected boolean"

kl_shen_LBrrbRB :: Types.KLValue ->
                   Types.KLContext Types.Env Types.KLValue
kl_shen_LBrrbRB (!kl_V2260) = do !appl_0 <- kl_V2260 `pseq` hd kl_V2260
                                 !kl_if_1 <- appl_0 `pseq` consP appl_0
                                 !kl_if_2 <- case kl_if_1 of
                                                 Atom (B (True)) -> do !appl_3 <- kl_V2260 `pseq` hd kl_V2260
                                                                       !appl_4 <- appl_3 `pseq` hd appl_3
                                                                       !kl_if_5 <- appl_4 `pseq` eq (Types.Atom (Types.N (Types.KI 41))) appl_4
                                                                       case kl_if_5 of
                                                                           Atom (B (True)) -> do return (Atom (B True))
                                                                           Atom (B (False)) -> do do return (Atom (B False))
                                                                           _ -> throwError "if: expected boolean"
                                                 Atom (B (False)) -> do do return (Atom (B False))
                                                 _ -> throwError "if: expected boolean"
                                 case kl_if_2 of
                                     Atom (B (True)) -> do !appl_6 <- kl_V2260 `pseq` hd kl_V2260
                                                           !appl_7 <- appl_6 `pseq` tl appl_6
                                                           !appl_8 <- kl_V2260 `pseq` kl_shen_hdtl kl_V2260
                                                           !appl_9 <- appl_7 `pseq` (appl_8 `pseq` kl_shen_pair appl_7 appl_8)
                                                           !appl_10 <- appl_9 `pseq` hd appl_9
                                                           appl_10 `pseq` kl_shen_pair appl_10 (Types.Atom (Types.UnboundSym "shen.skip"))
                                     Atom (B (False)) -> do do kl_fail
                                     _ -> throwError "if: expected boolean"

kl_shen_LBatomRB :: Types.KLValue ->
                    Types.KLContext Types.Env Types.KLValue
kl_shen_LBatomRB (!kl_V2262) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_1 <- kl_fail
                                                                                                      !kl_if_2 <- kl_YaccParse `pseq` (appl_1 `pseq` eq kl_YaccParse appl_1)
                                                                                                      case kl_if_2 of
                                                                                                          Atom (B (True)) -> do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_4 <- kl_fail
                                                                                                                                                                                                    !kl_if_5 <- kl_YaccParse `pseq` (appl_4 `pseq` eq kl_YaccParse appl_4)
                                                                                                                                                                                                    case kl_if_5 of
                                                                                                                                                                                                        Atom (B (True)) -> do let !appl_6 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBsymRB) -> do !appl_7 <- kl_fail
                                                                                                                                                                                                                                                                                                           !appl_8 <- appl_7 `pseq` (kl_Parse_shen_LBsymRB `pseq` eq appl_7 kl_Parse_shen_LBsymRB)
                                                                                                                                                                                                                                                                                                           !kl_if_9 <- appl_8 `pseq` kl_not appl_8
                                                                                                                                                                                                                                                                                                           case kl_if_9 of
                                                                                                                                                                                                                                                                                                               Atom (B (True)) -> do !appl_10 <- kl_Parse_shen_LBsymRB `pseq` hd kl_Parse_shen_LBsymRB
                                                                                                                                                                                                                                                                                                                                     !appl_11 <- kl_Parse_shen_LBsymRB `pseq` kl_shen_hdtl kl_Parse_shen_LBsymRB
                                                                                                                                                                                                                                                                                                                                     !kl_if_12 <- appl_11 `pseq` eq appl_11 (Types.Atom (Types.Str "<>"))
                                                                                                                                                                                                                                                                                                                                     !appl_13 <- case kl_if_12 of
                                                                                                                                                                                                                                                                                                                                                     Atom (B (True)) -> do !appl_14 <- klCons (Types.Atom (Types.N (Types.KI 0))) (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                                                                                           appl_14 `pseq` klCons (ApplC (wrapNamed "vector" kl_vector)) appl_14
                                                                                                                                                                                                                                                                                                                                                     Atom (B (False)) -> do do !appl_15 <- kl_Parse_shen_LBsymRB `pseq` kl_shen_hdtl kl_Parse_shen_LBsymRB
                                                                                                                                                                                                                                                                                                                                                                               appl_15 `pseq` intern appl_15
                                                                                                                                                                                                                                                                                                                                                     _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                     appl_10 `pseq` (appl_13 `pseq` kl_shen_pair appl_10 appl_13)
                                                                                                                                                                                                                                                                                                               Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                               _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                              !appl_16 <- kl_V2262 `pseq` kl_shen_LBsymRB kl_V2262
                                                                                                                                                                                                                              appl_16 `pseq` applyWrapper appl_6 [appl_16]
                                                                                                                                                                                                        Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                                                                                                        _ -> throwError "if: expected boolean")))
                                                                                                                                let !appl_17 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBnumberRB) -> do !appl_18 <- kl_fail
                                                                                                                                                                                                                 !appl_19 <- appl_18 `pseq` (kl_Parse_shen_LBnumberRB `pseq` eq appl_18 kl_Parse_shen_LBnumberRB)
                                                                                                                                                                                                                 !kl_if_20 <- appl_19 `pseq` kl_not appl_19
                                                                                                                                                                                                                 case kl_if_20 of
                                                                                                                                                                                                                     Atom (B (True)) -> do !appl_21 <- kl_Parse_shen_LBnumberRB `pseq` hd kl_Parse_shen_LBnumberRB
                                                                                                                                                                                                                                           !appl_22 <- kl_Parse_shen_LBnumberRB `pseq` kl_shen_hdtl kl_Parse_shen_LBnumberRB
                                                                                                                                                                                                                                           appl_21 `pseq` (appl_22 `pseq` kl_shen_pair appl_21 appl_22)
                                                                                                                                                                                                                     Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                     _ -> throwError "if: expected boolean")))
                                                                                                                                !appl_23 <- kl_V2262 `pseq` kl_shen_LBnumberRB kl_V2262
                                                                                                                                !appl_24 <- appl_23 `pseq` applyWrapper appl_17 [appl_23]
                                                                                                                                appl_24 `pseq` applyWrapper appl_3 [appl_24]
                                                                                                          Atom (B (False)) -> do do return kl_YaccParse
                                                                                                          _ -> throwError "if: expected boolean")))
                                  let !appl_25 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBstrRB) -> do !appl_26 <- kl_fail
                                                                                                                !appl_27 <- appl_26 `pseq` (kl_Parse_shen_LBstrRB `pseq` eq appl_26 kl_Parse_shen_LBstrRB)
                                                                                                                !kl_if_28 <- appl_27 `pseq` kl_not appl_27
                                                                                                                case kl_if_28 of
                                                                                                                    Atom (B (True)) -> do !appl_29 <- kl_Parse_shen_LBstrRB `pseq` hd kl_Parse_shen_LBstrRB
                                                                                                                                          !appl_30 <- kl_Parse_shen_LBstrRB `pseq` kl_shen_hdtl kl_Parse_shen_LBstrRB
                                                                                                                                          !appl_31 <- appl_30 `pseq` kl_shen_control_chars appl_30
                                                                                                                                          appl_29 `pseq` (appl_31 `pseq` kl_shen_pair appl_29 appl_31)
                                                                                                                    Atom (B (False)) -> do do kl_fail
                                                                                                                    _ -> throwError "if: expected boolean")))
                                  !appl_32 <- kl_V2262 `pseq` kl_shen_LBstrRB kl_V2262
                                  !appl_33 <- appl_32 `pseq` applyWrapper appl_25 [appl_32]
                                  appl_33 `pseq` applyWrapper appl_0 [appl_33]

kl_shen_control_chars :: Types.KLValue ->
                         Types.KLContext Types.Env Types.KLValue
kl_shen_control_chars (!kl_V2264) = do let pat_cond_0 = do return (Types.Atom (Types.Str ""))
                                           pat_cond_1 kl_V2264 kl_V2264t kl_V2264tt = do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_CodePoint) -> do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_AfterCodePoint) -> do !appl_4 <- kl_CodePoint `pseq` kl_shen_decimalise kl_CodePoint
                                                                                                                                                                                                                                      !appl_5 <- appl_4 `pseq` nToString appl_4
                                                                                                                                                                                                                                      !appl_6 <- kl_AfterCodePoint `pseq` kl_shen_control_chars kl_AfterCodePoint
                                                                                                                                                                                                                                      appl_5 `pseq` (appl_6 `pseq` kl_Ats appl_5 appl_6))))
                                                                                                                                                             !appl_7 <- kl_V2264tt `pseq` kl_shen_after_codepoint kl_V2264tt
                                                                                                                                                             appl_7 `pseq` applyWrapper appl_3 [appl_7])))
                                                                                         !appl_8 <- kl_V2264tt `pseq` kl_shen_code_point kl_V2264tt
                                                                                         appl_8 `pseq` applyWrapper appl_2 [appl_8]
                                           pat_cond_9 kl_V2264 kl_V2264h kl_V2264t = do !appl_10 <- kl_V2264t `pseq` kl_shen_control_chars kl_V2264t
                                                                                        kl_V2264h `pseq` (appl_10 `pseq` kl_Ats kl_V2264h appl_10)
                                           pat_cond_11 = do do let !aw_12 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                               applyWrapper aw_12 [ApplC (wrapNamed "shen.control-chars" kl_shen_control_chars)]
                                        in case kl_V2264 of
                                               kl_V2264@(Atom (Nil)) -> pat_cond_0
                                               !(kl_V2264@(Cons (Atom (Str "c"))
                                                                (!(kl_V2264t@(Cons (Atom (Str "#"))
                                                                                   (!kl_V2264tt)))))) -> pat_cond_1 kl_V2264 kl_V2264t kl_V2264tt
                                               !(kl_V2264@(Cons (!kl_V2264h)
                                                                (!kl_V2264t))) -> pat_cond_9 kl_V2264 kl_V2264h kl_V2264t
                                               _ -> pat_cond_11

kl_shen_code_point :: Types.KLValue ->
                      Types.KLContext Types.Env Types.KLValue
kl_shen_code_point (!kl_V2268) = do let pat_cond_0 kl_V2268 kl_V2268t = do return (Types.Atom (Types.Str ""))
                                        pat_cond_1 = do !kl_if_2 <- let pat_cond_3 kl_V2268 kl_V2268h kl_V2268t = do !appl_4 <- klCons (Types.Atom (Types.Str "0")) (Types.Atom Types.Nil)
                                                                                                                     !appl_5 <- appl_4 `pseq` klCons (Types.Atom (Types.Str "9")) appl_4
                                                                                                                     !appl_6 <- appl_5 `pseq` klCons (Types.Atom (Types.Str "8")) appl_5
                                                                                                                     !appl_7 <- appl_6 `pseq` klCons (Types.Atom (Types.Str "7")) appl_6
                                                                                                                     !appl_8 <- appl_7 `pseq` klCons (Types.Atom (Types.Str "6")) appl_7
                                                                                                                     !appl_9 <- appl_8 `pseq` klCons (Types.Atom (Types.Str "5")) appl_8
                                                                                                                     !appl_10 <- appl_9 `pseq` klCons (Types.Atom (Types.Str "4")) appl_9
                                                                                                                     !appl_11 <- appl_10 `pseq` klCons (Types.Atom (Types.Str "3")) appl_10
                                                                                                                     !appl_12 <- appl_11 `pseq` klCons (Types.Atom (Types.Str "2")) appl_11
                                                                                                                     !appl_13 <- appl_12 `pseq` klCons (Types.Atom (Types.Str "1")) appl_12
                                                                                                                     !appl_14 <- appl_13 `pseq` klCons (Types.Atom (Types.Str "0")) appl_13
                                                                                                                     !kl_if_15 <- kl_V2268h `pseq` (appl_14 `pseq` kl_elementP kl_V2268h appl_14)
                                                                                                                     case kl_if_15 of
                                                                                                                         Atom (B (True)) -> do return (Atom (B True))
                                                                                                                         Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                         _ -> throwError "if: expected boolean"
                                                                        pat_cond_16 = do do return (Atom (B False))
                                                                     in case kl_V2268 of
                                                                            !(kl_V2268@(Cons (!kl_V2268h)
                                                                                             (!kl_V2268t))) -> pat_cond_3 kl_V2268 kl_V2268h kl_V2268t
                                                                            _ -> pat_cond_16
                                                        case kl_if_2 of
                                                            Atom (B (True)) -> do !appl_17 <- kl_V2268 `pseq` hd kl_V2268
                                                                                  !appl_18 <- kl_V2268 `pseq` tl kl_V2268
                                                                                  !appl_19 <- appl_18 `pseq` kl_shen_code_point appl_18
                                                                                  appl_17 `pseq` (appl_19 `pseq` klCons appl_17 appl_19)
                                                            Atom (B (False)) -> do do let !aw_20 = Types.Atom (Types.UnboundSym "shen.app")
                                                                                      !appl_21 <- kl_V2268 `pseq` applyWrapper aw_20 [kl_V2268,
                                                                                                                                      Types.Atom (Types.Str "\n"),
                                                                                                                                      Types.Atom (Types.UnboundSym "shen.a")]
                                                                                      !appl_22 <- appl_21 `pseq` cn (Types.Atom (Types.Str "code point parse error ")) appl_21
                                                                                      appl_22 `pseq` simpleError appl_22
                                                            _ -> throwError "if: expected boolean"
                                     in case kl_V2268 of
                                            !(kl_V2268@(Cons (Atom (Str ";"))
                                                             (!kl_V2268t))) -> pat_cond_0 kl_V2268 kl_V2268t
                                            _ -> pat_cond_1

kl_shen_after_codepoint :: Types.KLValue ->
                           Types.KLContext Types.Env Types.KLValue
kl_shen_after_codepoint (!kl_V2274) = do let pat_cond_0 = do return (Types.Atom Types.Nil)
                                             pat_cond_1 kl_V2274 kl_V2274t = do return kl_V2274t
                                             pat_cond_2 kl_V2274 kl_V2274h kl_V2274t = do kl_V2274t `pseq` kl_shen_after_codepoint kl_V2274t
                                             pat_cond_3 = do do let !aw_4 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                applyWrapper aw_4 [ApplC (wrapNamed "shen.after-codepoint" kl_shen_after_codepoint)]
                                          in case kl_V2274 of
                                                 kl_V2274@(Atom (Nil)) -> pat_cond_0
                                                 !(kl_V2274@(Cons (Atom (Str ";"))
                                                                  (!kl_V2274t))) -> pat_cond_1 kl_V2274 kl_V2274t
                                                 !(kl_V2274@(Cons (!kl_V2274h)
                                                                  (!kl_V2274t))) -> pat_cond_2 kl_V2274 kl_V2274h kl_V2274t
                                                 _ -> pat_cond_3

kl_shen_decimalise :: Types.KLValue ->
                      Types.KLContext Types.Env Types.KLValue
kl_shen_decimalise (!kl_V2276) = do !appl_0 <- kl_V2276 `pseq` kl_shen_digits_RBintegers kl_V2276
                                    !appl_1 <- appl_0 `pseq` kl_reverse appl_0
                                    appl_1 `pseq` kl_shen_pre appl_1 (Types.Atom (Types.N (Types.KI 0)))

kl_shen_digits_RBintegers :: Types.KLValue ->
                             Types.KLContext Types.Env Types.KLValue
kl_shen_digits_RBintegers (!kl_V2282) = do let pat_cond_0 kl_V2282 kl_V2282t = do !appl_1 <- kl_V2282t `pseq` kl_shen_digits_RBintegers kl_V2282t
                                                                                  appl_1 `pseq` klCons (Types.Atom (Types.N (Types.KI 0))) appl_1
                                               pat_cond_2 kl_V2282 kl_V2282t = do !appl_3 <- kl_V2282t `pseq` kl_shen_digits_RBintegers kl_V2282t
                                                                                  appl_3 `pseq` klCons (Types.Atom (Types.N (Types.KI 1))) appl_3
                                               pat_cond_4 kl_V2282 kl_V2282t = do !appl_5 <- kl_V2282t `pseq` kl_shen_digits_RBintegers kl_V2282t
                                                                                  appl_5 `pseq` klCons (Types.Atom (Types.N (Types.KI 2))) appl_5
                                               pat_cond_6 kl_V2282 kl_V2282t = do !appl_7 <- kl_V2282t `pseq` kl_shen_digits_RBintegers kl_V2282t
                                                                                  appl_7 `pseq` klCons (Types.Atom (Types.N (Types.KI 3))) appl_7
                                               pat_cond_8 kl_V2282 kl_V2282t = do !appl_9 <- kl_V2282t `pseq` kl_shen_digits_RBintegers kl_V2282t
                                                                                  appl_9 `pseq` klCons (Types.Atom (Types.N (Types.KI 4))) appl_9
                                               pat_cond_10 kl_V2282 kl_V2282t = do !appl_11 <- kl_V2282t `pseq` kl_shen_digits_RBintegers kl_V2282t
                                                                                   appl_11 `pseq` klCons (Types.Atom (Types.N (Types.KI 5))) appl_11
                                               pat_cond_12 kl_V2282 kl_V2282t = do !appl_13 <- kl_V2282t `pseq` kl_shen_digits_RBintegers kl_V2282t
                                                                                   appl_13 `pseq` klCons (Types.Atom (Types.N (Types.KI 6))) appl_13
                                               pat_cond_14 kl_V2282 kl_V2282t = do !appl_15 <- kl_V2282t `pseq` kl_shen_digits_RBintegers kl_V2282t
                                                                                   appl_15 `pseq` klCons (Types.Atom (Types.N (Types.KI 7))) appl_15
                                               pat_cond_16 kl_V2282 kl_V2282t = do !appl_17 <- kl_V2282t `pseq` kl_shen_digits_RBintegers kl_V2282t
                                                                                   appl_17 `pseq` klCons (Types.Atom (Types.N (Types.KI 8))) appl_17
                                               pat_cond_18 kl_V2282 kl_V2282t = do !appl_19 <- kl_V2282t `pseq` kl_shen_digits_RBintegers kl_V2282t
                                                                                   appl_19 `pseq` klCons (Types.Atom (Types.N (Types.KI 9))) appl_19
                                               pat_cond_20 = do do return (Types.Atom Types.Nil)
                                            in case kl_V2282 of
                                                   !(kl_V2282@(Cons (Atom (Str "0"))
                                                                    (!kl_V2282t))) -> pat_cond_0 kl_V2282 kl_V2282t
                                                   !(kl_V2282@(Cons (Atom (Str "1"))
                                                                    (!kl_V2282t))) -> pat_cond_2 kl_V2282 kl_V2282t
                                                   !(kl_V2282@(Cons (Atom (Str "2"))
                                                                    (!kl_V2282t))) -> pat_cond_4 kl_V2282 kl_V2282t
                                                   !(kl_V2282@(Cons (Atom (Str "3"))
                                                                    (!kl_V2282t))) -> pat_cond_6 kl_V2282 kl_V2282t
                                                   !(kl_V2282@(Cons (Atom (Str "4"))
                                                                    (!kl_V2282t))) -> pat_cond_8 kl_V2282 kl_V2282t
                                                   !(kl_V2282@(Cons (Atom (Str "5"))
                                                                    (!kl_V2282t))) -> pat_cond_10 kl_V2282 kl_V2282t
                                                   !(kl_V2282@(Cons (Atom (Str "6"))
                                                                    (!kl_V2282t))) -> pat_cond_12 kl_V2282 kl_V2282t
                                                   !(kl_V2282@(Cons (Atom (Str "7"))
                                                                    (!kl_V2282t))) -> pat_cond_14 kl_V2282 kl_V2282t
                                                   !(kl_V2282@(Cons (Atom (Str "8"))
                                                                    (!kl_V2282t))) -> pat_cond_16 kl_V2282 kl_V2282t
                                                   !(kl_V2282@(Cons (Atom (Str "9"))
                                                                    (!kl_V2282t))) -> pat_cond_18 kl_V2282 kl_V2282t
                                                   _ -> pat_cond_20

kl_shen_LBsymRB :: Types.KLValue ->
                   Types.KLContext Types.Env Types.KLValue
kl_shen_LBsymRB (!kl_V2284) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBalphaRB) -> do !appl_1 <- kl_fail
                                                                                                                !appl_2 <- appl_1 `pseq` (kl_Parse_shen_LBalphaRB `pseq` eq appl_1 kl_Parse_shen_LBalphaRB)
                                                                                                                !kl_if_3 <- appl_2 `pseq` kl_not appl_2
                                                                                                                case kl_if_3 of
                                                                                                                    Atom (B (True)) -> do let !appl_4 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBalphanumsRB) -> do !appl_5 <- kl_fail
                                                                                                                                                                                                                             !appl_6 <- appl_5 `pseq` (kl_Parse_shen_LBalphanumsRB `pseq` eq appl_5 kl_Parse_shen_LBalphanumsRB)
                                                                                                                                                                                                                             !kl_if_7 <- appl_6 `pseq` kl_not appl_6
                                                                                                                                                                                                                             case kl_if_7 of
                                                                                                                                                                                                                                 Atom (B (True)) -> do !appl_8 <- kl_Parse_shen_LBalphanumsRB `pseq` hd kl_Parse_shen_LBalphanumsRB
                                                                                                                                                                                                                                                       !appl_9 <- kl_Parse_shen_LBalphaRB `pseq` kl_shen_hdtl kl_Parse_shen_LBalphaRB
                                                                                                                                                                                                                                                       !appl_10 <- kl_Parse_shen_LBalphanumsRB `pseq` kl_shen_hdtl kl_Parse_shen_LBalphanumsRB
                                                                                                                                                                                                                                                       !appl_11 <- appl_9 `pseq` (appl_10 `pseq` kl_Ats appl_9 appl_10)
                                                                                                                                                                                                                                                       appl_8 `pseq` (appl_11 `pseq` kl_shen_pair appl_8 appl_11)
                                                                                                                                                                                                                                 Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                 _ -> throwError "if: expected boolean")))
                                                                                                                                          !appl_12 <- kl_Parse_shen_LBalphaRB `pseq` kl_shen_LBalphanumsRB kl_Parse_shen_LBalphaRB
                                                                                                                                          appl_12 `pseq` applyWrapper appl_4 [appl_12]
                                                                                                                    Atom (B (False)) -> do do kl_fail
                                                                                                                    _ -> throwError "if: expected boolean")))
                                 !appl_13 <- kl_V2284 `pseq` kl_shen_LBalphaRB kl_V2284
                                 appl_13 `pseq` applyWrapper appl_0 [appl_13]

kl_shen_LBalphanumsRB :: Types.KLValue ->
                         Types.KLContext Types.Env Types.KLValue
kl_shen_LBalphanumsRB (!kl_V2286) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_1 <- kl_fail
                                                                                                           !kl_if_2 <- kl_YaccParse `pseq` (appl_1 `pseq` eq kl_YaccParse appl_1)
                                                                                                           case kl_if_2 of
                                                                                                               Atom (B (True)) -> do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_Parse_LBeRB) -> do !appl_4 <- kl_fail
                                                                                                                                                                                                           !appl_5 <- appl_4 `pseq` (kl_Parse_LBeRB `pseq` eq appl_4 kl_Parse_LBeRB)
                                                                                                                                                                                                           !kl_if_6 <- appl_5 `pseq` kl_not appl_5
                                                                                                                                                                                                           case kl_if_6 of
                                                                                                                                                                                                               Atom (B (True)) -> do !appl_7 <- kl_Parse_LBeRB `pseq` hd kl_Parse_LBeRB
                                                                                                                                                                                                                                     appl_7 `pseq` kl_shen_pair appl_7 (Types.Atom (Types.Str ""))
                                                                                                                                                                                                               Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                               _ -> throwError "if: expected boolean")))
                                                                                                                                     !appl_8 <- kl_V2286 `pseq` kl_LBeRB kl_V2286
                                                                                                                                     appl_8 `pseq` applyWrapper appl_3 [appl_8]
                                                                                                               Atom (B (False)) -> do do return kl_YaccParse
                                                                                                               _ -> throwError "if: expected boolean")))
                                       let !appl_9 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBalphanumRB) -> do !appl_10 <- kl_fail
                                                                                                                         !appl_11 <- appl_10 `pseq` (kl_Parse_shen_LBalphanumRB `pseq` eq appl_10 kl_Parse_shen_LBalphanumRB)
                                                                                                                         !kl_if_12 <- appl_11 `pseq` kl_not appl_11
                                                                                                                         case kl_if_12 of
                                                                                                                             Atom (B (True)) -> do let !appl_13 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBalphanumsRB) -> do !appl_14 <- kl_fail
                                                                                                                                                                                                                                       !appl_15 <- appl_14 `pseq` (kl_Parse_shen_LBalphanumsRB `pseq` eq appl_14 kl_Parse_shen_LBalphanumsRB)
                                                                                                                                                                                                                                       !kl_if_16 <- appl_15 `pseq` kl_not appl_15
                                                                                                                                                                                                                                       case kl_if_16 of
                                                                                                                                                                                                                                           Atom (B (True)) -> do !appl_17 <- kl_Parse_shen_LBalphanumsRB `pseq` hd kl_Parse_shen_LBalphanumsRB
                                                                                                                                                                                                                                                                 !appl_18 <- kl_Parse_shen_LBalphanumRB `pseq` kl_shen_hdtl kl_Parse_shen_LBalphanumRB
                                                                                                                                                                                                                                                                 !appl_19 <- kl_Parse_shen_LBalphanumsRB `pseq` kl_shen_hdtl kl_Parse_shen_LBalphanumsRB
                                                                                                                                                                                                                                                                 !appl_20 <- appl_18 `pseq` (appl_19 `pseq` kl_Ats appl_18 appl_19)
                                                                                                                                                                                                                                                                 appl_17 `pseq` (appl_20 `pseq` kl_shen_pair appl_17 appl_20)
                                                                                                                                                                                                                                           Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                           _ -> throwError "if: expected boolean")))
                                                                                                                                                   !appl_21 <- kl_Parse_shen_LBalphanumRB `pseq` kl_shen_LBalphanumsRB kl_Parse_shen_LBalphanumRB
                                                                                                                                                   appl_21 `pseq` applyWrapper appl_13 [appl_21]
                                                                                                                             Atom (B (False)) -> do do kl_fail
                                                                                                                             _ -> throwError "if: expected boolean")))
                                       !appl_22 <- kl_V2286 `pseq` kl_shen_LBalphanumRB kl_V2286
                                       !appl_23 <- appl_22 `pseq` applyWrapper appl_9 [appl_22]
                                       appl_23 `pseq` applyWrapper appl_0 [appl_23]

kl_shen_LBalphanumRB :: Types.KLValue ->
                        Types.KLContext Types.Env Types.KLValue
kl_shen_LBalphanumRB (!kl_V2288) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_1 <- kl_fail
                                                                                                          !kl_if_2 <- kl_YaccParse `pseq` (appl_1 `pseq` eq kl_YaccParse appl_1)
                                                                                                          case kl_if_2 of
                                                                                                              Atom (B (True)) -> do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBnumRB) -> do !appl_4 <- kl_fail
                                                                                                                                                                                                                 !appl_5 <- appl_4 `pseq` (kl_Parse_shen_LBnumRB `pseq` eq appl_4 kl_Parse_shen_LBnumRB)
                                                                                                                                                                                                                 !kl_if_6 <- appl_5 `pseq` kl_not appl_5
                                                                                                                                                                                                                 case kl_if_6 of
                                                                                                                                                                                                                     Atom (B (True)) -> do !appl_7 <- kl_Parse_shen_LBnumRB `pseq` hd kl_Parse_shen_LBnumRB
                                                                                                                                                                                                                                           !appl_8 <- kl_Parse_shen_LBnumRB `pseq` kl_shen_hdtl kl_Parse_shen_LBnumRB
                                                                                                                                                                                                                                           appl_7 `pseq` (appl_8 `pseq` kl_shen_pair appl_7 appl_8)
                                                                                                                                                                                                                     Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                     _ -> throwError "if: expected boolean")))
                                                                                                                                    !appl_9 <- kl_V2288 `pseq` kl_shen_LBnumRB kl_V2288
                                                                                                                                    appl_9 `pseq` applyWrapper appl_3 [appl_9]
                                                                                                              Atom (B (False)) -> do do return kl_YaccParse
                                                                                                              _ -> throwError "if: expected boolean")))
                                      let !appl_10 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBalphaRB) -> do !appl_11 <- kl_fail
                                                                                                                      !appl_12 <- appl_11 `pseq` (kl_Parse_shen_LBalphaRB `pseq` eq appl_11 kl_Parse_shen_LBalphaRB)
                                                                                                                      !kl_if_13 <- appl_12 `pseq` kl_not appl_12
                                                                                                                      case kl_if_13 of
                                                                                                                          Atom (B (True)) -> do !appl_14 <- kl_Parse_shen_LBalphaRB `pseq` hd kl_Parse_shen_LBalphaRB
                                                                                                                                                !appl_15 <- kl_Parse_shen_LBalphaRB `pseq` kl_shen_hdtl kl_Parse_shen_LBalphaRB
                                                                                                                                                appl_14 `pseq` (appl_15 `pseq` kl_shen_pair appl_14 appl_15)
                                                                                                                          Atom (B (False)) -> do do kl_fail
                                                                                                                          _ -> throwError "if: expected boolean")))
                                      !appl_16 <- kl_V2288 `pseq` kl_shen_LBalphaRB kl_V2288
                                      !appl_17 <- appl_16 `pseq` applyWrapper appl_10 [appl_16]
                                      appl_17 `pseq` applyWrapper appl_0 [appl_17]

kl_shen_LBnumRB :: Types.KLValue ->
                   Types.KLContext Types.Env Types.KLValue
kl_shen_LBnumRB (!kl_V2290) = do !appl_0 <- kl_V2290 `pseq` hd kl_V2290
                                 !kl_if_1 <- appl_0 `pseq` consP appl_0
                                 case kl_if_1 of
                                     Atom (B (True)) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Parse_Byte) -> do !kl_if_3 <- kl_Parse_Byte `pseq` kl_shen_numbyteP kl_Parse_Byte
                                                                                                                                case kl_if_3 of
                                                                                                                                    Atom (B (True)) -> do !appl_4 <- kl_V2290 `pseq` hd kl_V2290
                                                                                                                                                          !appl_5 <- appl_4 `pseq` tl appl_4
                                                                                                                                                          !appl_6 <- kl_V2290 `pseq` kl_shen_hdtl kl_V2290
                                                                                                                                                          !appl_7 <- appl_5 `pseq` (appl_6 `pseq` kl_shen_pair appl_5 appl_6)
                                                                                                                                                          !appl_8 <- appl_7 `pseq` hd appl_7
                                                                                                                                                          !appl_9 <- kl_Parse_Byte `pseq` nToString kl_Parse_Byte
                                                                                                                                                          appl_8 `pseq` (appl_9 `pseq` kl_shen_pair appl_8 appl_9)
                                                                                                                                    Atom (B (False)) -> do do kl_fail
                                                                                                                                    _ -> throwError "if: expected boolean")))
                                                           !appl_10 <- kl_V2290 `pseq` hd kl_V2290
                                                           !appl_11 <- appl_10 `pseq` hd appl_10
                                                           appl_11 `pseq` applyWrapper appl_2 [appl_11]
                                     Atom (B (False)) -> do do kl_fail
                                     _ -> throwError "if: expected boolean"

kl_shen_numbyteP :: Types.KLValue ->
                    Types.KLContext Types.Env Types.KLValue
kl_shen_numbyteP (!kl_V2296) = do let pat_cond_0 = do return (Atom (B True))
                                      pat_cond_1 = do return (Atom (B True))
                                      pat_cond_2 = do return (Atom (B True))
                                      pat_cond_3 = do return (Atom (B True))
                                      pat_cond_4 = do return (Atom (B True))
                                      pat_cond_5 = do return (Atom (B True))
                                      pat_cond_6 = do return (Atom (B True))
                                      pat_cond_7 = do return (Atom (B True))
                                      pat_cond_8 = do return (Atom (B True))
                                      pat_cond_9 = do return (Atom (B True))
                                      pat_cond_10 = do do return (Atom (B False))
                                   in case kl_V2296 of
                                          kl_V2296@(Atom (N (KI 48))) -> pat_cond_0
                                          kl_V2296@(Atom (N (KI 49))) -> pat_cond_1
                                          kl_V2296@(Atom (N (KI 50))) -> pat_cond_2
                                          kl_V2296@(Atom (N (KI 51))) -> pat_cond_3
                                          kl_V2296@(Atom (N (KI 52))) -> pat_cond_4
                                          kl_V2296@(Atom (N (KI 53))) -> pat_cond_5
                                          kl_V2296@(Atom (N (KI 54))) -> pat_cond_6
                                          kl_V2296@(Atom (N (KI 55))) -> pat_cond_7
                                          kl_V2296@(Atom (N (KI 56))) -> pat_cond_8
                                          kl_V2296@(Atom (N (KI 57))) -> pat_cond_9
                                          _ -> pat_cond_10

kl_shen_LBalphaRB :: Types.KLValue ->
                     Types.KLContext Types.Env Types.KLValue
kl_shen_LBalphaRB (!kl_V2298) = do !appl_0 <- kl_V2298 `pseq` hd kl_V2298
                                   !kl_if_1 <- appl_0 `pseq` consP appl_0
                                   case kl_if_1 of
                                       Atom (B (True)) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Parse_Byte) -> do !kl_if_3 <- kl_Parse_Byte `pseq` kl_shen_symbol_codeP kl_Parse_Byte
                                                                                                                                  case kl_if_3 of
                                                                                                                                      Atom (B (True)) -> do !appl_4 <- kl_V2298 `pseq` hd kl_V2298
                                                                                                                                                            !appl_5 <- appl_4 `pseq` tl appl_4
                                                                                                                                                            !appl_6 <- kl_V2298 `pseq` kl_shen_hdtl kl_V2298
                                                                                                                                                            !appl_7 <- appl_5 `pseq` (appl_6 `pseq` kl_shen_pair appl_5 appl_6)
                                                                                                                                                            !appl_8 <- appl_7 `pseq` hd appl_7
                                                                                                                                                            !appl_9 <- kl_Parse_Byte `pseq` nToString kl_Parse_Byte
                                                                                                                                                            appl_8 `pseq` (appl_9 `pseq` kl_shen_pair appl_8 appl_9)
                                                                                                                                      Atom (B (False)) -> do do kl_fail
                                                                                                                                      _ -> throwError "if: expected boolean")))
                                                             !appl_10 <- kl_V2298 `pseq` hd kl_V2298
                                                             !appl_11 <- appl_10 `pseq` hd appl_10
                                                             appl_11 `pseq` applyWrapper appl_2 [appl_11]
                                       Atom (B (False)) -> do do kl_fail
                                       _ -> throwError "if: expected boolean"

kl_shen_symbol_codeP :: Types.KLValue ->
                        Types.KLContext Types.Env Types.KLValue
kl_shen_symbol_codeP (!kl_V2300) = do let pat_cond_0 = do return (Atom (B True))
                                          pat_cond_1 = do do !kl_if_2 <- kl_V2300 `pseq` greaterThan kl_V2300 (Types.Atom (Types.N (Types.KI 94)))
                                                             !kl_if_3 <- case kl_if_2 of
                                                                             Atom (B (True)) -> do !kl_if_4 <- kl_V2300 `pseq` lessThan kl_V2300 (Types.Atom (Types.N (Types.KI 123)))
                                                                                                   case kl_if_4 of
                                                                                                       Atom (B (True)) -> do return (Atom (B True))
                                                                                                       Atom (B (False)) -> do do return (Atom (B False))
                                                                                                       _ -> throwError "if: expected boolean"
                                                                             Atom (B (False)) -> do do return (Atom (B False))
                                                                             _ -> throwError "if: expected boolean"
                                                             !kl_if_5 <- case kl_if_3 of
                                                                             Atom (B (True)) -> do return (Atom (B True))
                                                                             Atom (B (False)) -> do do !kl_if_6 <- kl_V2300 `pseq` greaterThan kl_V2300 (Types.Atom (Types.N (Types.KI 59)))
                                                                                                       !kl_if_7 <- case kl_if_6 of
                                                                                                                       Atom (B (True)) -> do !kl_if_8 <- kl_V2300 `pseq` lessThan kl_V2300 (Types.Atom (Types.N (Types.KI 91)))
                                                                                                                                             case kl_if_8 of
                                                                                                                                                 Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                 Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                 _ -> throwError "if: expected boolean"
                                                                                                                       Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                       _ -> throwError "if: expected boolean"
                                                                                                       !kl_if_9 <- case kl_if_7 of
                                                                                                                       Atom (B (True)) -> do return (Atom (B True))
                                                                                                                       Atom (B (False)) -> do do !kl_if_10 <- kl_V2300 `pseq` greaterThan kl_V2300 (Types.Atom (Types.N (Types.KI 41)))
                                                                                                                                                 !kl_if_11 <- case kl_if_10 of
                                                                                                                                                                  Atom (B (True)) -> do !kl_if_12 <- kl_V2300 `pseq` lessThan kl_V2300 (Types.Atom (Types.N (Types.KI 58)))
                                                                                                                                                                                        !kl_if_13 <- case kl_if_12 of
                                                                                                                                                                                                         Atom (B (True)) -> do !appl_14 <- kl_V2300 `pseq` eq kl_V2300 (Types.Atom (Types.N (Types.KI 44)))
                                                                                                                                                                                                                               !kl_if_15 <- appl_14 `pseq` kl_not appl_14
                                                                                                                                                                                                                               case kl_if_15 of
                                                                                                                                                                                                                                   Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                   Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                   _ -> throwError "if: expected boolean"
                                                                                                                                                                                                         Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                         _ -> throwError "if: expected boolean"
                                                                                                                                                                                        case kl_if_13 of
                                                                                                                                                                                            Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                            Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                            _ -> throwError "if: expected boolean"
                                                                                                                                                                  Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                  _ -> throwError "if: expected boolean"
                                                                                                                                                 !kl_if_16 <- case kl_if_11 of
                                                                                                                                                                  Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                  Atom (B (False)) -> do do !kl_if_17 <- kl_V2300 `pseq` greaterThan kl_V2300 (Types.Atom (Types.N (Types.KI 34)))
                                                                                                                                                                                            !kl_if_18 <- case kl_if_17 of
                                                                                                                                                                                                             Atom (B (True)) -> do !kl_if_19 <- kl_V2300 `pseq` lessThan kl_V2300 (Types.Atom (Types.N (Types.KI 40)))
                                                                                                                                                                                                                                   case kl_if_19 of
                                                                                                                                                                                                                                       Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                       Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                       _ -> throwError "if: expected boolean"
                                                                                                                                                                                                             Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                             _ -> throwError "if: expected boolean"
                                                                                                                                                                                            !kl_if_20 <- case kl_if_18 of
                                                                                                                                                                                                             Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                             Atom (B (False)) -> do do let pat_cond_21 = do return (Atom (B True))
                                                                                                                                                                                                                                           pat_cond_22 = do do return (Atom (B False))
                                                                                                                                                                                                                                        in case kl_V2300 of
                                                                                                                                                                                                                                               kl_V2300@(Atom (N (KI 33))) -> pat_cond_21
                                                                                                                                                                                                                                               _ -> pat_cond_22
                                                                                                                                                                                                             _ -> throwError "if: expected boolean"
                                                                                                                                                                                            case kl_if_20 of
                                                                                                                                                                                                Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                _ -> throwError "if: expected boolean"
                                                                                                                                                                  _ -> throwError "if: expected boolean"
                                                                                                                                                 case kl_if_16 of
                                                                                                                                                     Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                     Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                     _ -> throwError "if: expected boolean"
                                                                                                                       _ -> throwError "if: expected boolean"
                                                                                                       case kl_if_9 of
                                                                                                           Atom (B (True)) -> do return (Atom (B True))
                                                                                                           Atom (B (False)) -> do do return (Atom (B False))
                                                                                                           _ -> throwError "if: expected boolean"
                                                                             _ -> throwError "if: expected boolean"
                                                             case kl_if_5 of
                                                                 Atom (B (True)) -> do return (Atom (B True))
                                                                 Atom (B (False)) -> do do return (Atom (B False))
                                                                 _ -> throwError "if: expected boolean"
                                       in case kl_V2300 of
                                              kl_V2300@(Atom (N (KI 126))) -> pat_cond_0
                                              _ -> pat_cond_1

kl_shen_LBstrRB :: Types.KLValue ->
                   Types.KLContext Types.Env Types.KLValue
kl_shen_LBstrRB (!kl_V2302) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBdbqRB) -> do !appl_1 <- kl_fail
                                                                                                              !appl_2 <- appl_1 `pseq` (kl_Parse_shen_LBdbqRB `pseq` eq appl_1 kl_Parse_shen_LBdbqRB)
                                                                                                              !kl_if_3 <- appl_2 `pseq` kl_not appl_2
                                                                                                              case kl_if_3 of
                                                                                                                  Atom (B (True)) -> do let !appl_4 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBstrcontentsRB) -> do !appl_5 <- kl_fail
                                                                                                                                                                                                                             !appl_6 <- appl_5 `pseq` (kl_Parse_shen_LBstrcontentsRB `pseq` eq appl_5 kl_Parse_shen_LBstrcontentsRB)
                                                                                                                                                                                                                             !kl_if_7 <- appl_6 `pseq` kl_not appl_6
                                                                                                                                                                                                                             case kl_if_7 of
                                                                                                                                                                                                                                 Atom (B (True)) -> do let !appl_8 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBdbqRB) -> do !appl_9 <- kl_fail
                                                                                                                                                                                                                                                                                                                                    !appl_10 <- appl_9 `pseq` (kl_Parse_shen_LBdbqRB `pseq` eq appl_9 kl_Parse_shen_LBdbqRB)
                                                                                                                                                                                                                                                                                                                                    !kl_if_11 <- appl_10 `pseq` kl_not appl_10
                                                                                                                                                                                                                                                                                                                                    case kl_if_11 of
                                                                                                                                                                                                                                                                                                                                        Atom (B (True)) -> do !appl_12 <- kl_Parse_shen_LBdbqRB `pseq` hd kl_Parse_shen_LBdbqRB
                                                                                                                                                                                                                                                                                                                                                              !appl_13 <- kl_Parse_shen_LBstrcontentsRB `pseq` kl_shen_hdtl kl_Parse_shen_LBstrcontentsRB
                                                                                                                                                                                                                                                                                                                                                              appl_12 `pseq` (appl_13 `pseq` kl_shen_pair appl_12 appl_13)
                                                                                                                                                                                                                                                                                                                                        Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                        _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                       !appl_14 <- kl_Parse_shen_LBstrcontentsRB `pseq` kl_shen_LBdbqRB kl_Parse_shen_LBstrcontentsRB
                                                                                                                                                                                                                                                       appl_14 `pseq` applyWrapper appl_8 [appl_14]
                                                                                                                                                                                                                                 Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                 _ -> throwError "if: expected boolean")))
                                                                                                                                        !appl_15 <- kl_Parse_shen_LBdbqRB `pseq` kl_shen_LBstrcontentsRB kl_Parse_shen_LBdbqRB
                                                                                                                                        appl_15 `pseq` applyWrapper appl_4 [appl_15]
                                                                                                                  Atom (B (False)) -> do do kl_fail
                                                                                                                  _ -> throwError "if: expected boolean")))
                                 !appl_16 <- kl_V2302 `pseq` kl_shen_LBdbqRB kl_V2302
                                 appl_16 `pseq` applyWrapper appl_0 [appl_16]

kl_shen_LBdbqRB :: Types.KLValue ->
                   Types.KLContext Types.Env Types.KLValue
kl_shen_LBdbqRB (!kl_V2304) = do !appl_0 <- kl_V2304 `pseq` hd kl_V2304
                                 !kl_if_1 <- appl_0 `pseq` consP appl_0
                                 case kl_if_1 of
                                     Atom (B (True)) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Parse_Byte) -> do let pat_cond_3 = do !appl_4 <- kl_V2304 `pseq` hd kl_V2304
                                                                                                                                                    !appl_5 <- appl_4 `pseq` tl appl_4
                                                                                                                                                    !appl_6 <- kl_V2304 `pseq` kl_shen_hdtl kl_V2304
                                                                                                                                                    !appl_7 <- appl_5 `pseq` (appl_6 `pseq` kl_shen_pair appl_5 appl_6)
                                                                                                                                                    !appl_8 <- appl_7 `pseq` hd appl_7
                                                                                                                                                    appl_8 `pseq` (kl_Parse_Byte `pseq` kl_shen_pair appl_8 kl_Parse_Byte)
                                                                                                                                    pat_cond_9 = do do kl_fail
                                                                                                                                 in case kl_Parse_Byte of
                                                                                                                                        kl_Parse_Byte@(Atom (N (KI 34))) -> pat_cond_3
                                                                                                                                        _ -> pat_cond_9)))
                                                           !appl_10 <- kl_V2304 `pseq` hd kl_V2304
                                                           !appl_11 <- appl_10 `pseq` hd appl_10
                                                           appl_11 `pseq` applyWrapper appl_2 [appl_11]
                                     Atom (B (False)) -> do do kl_fail
                                     _ -> throwError "if: expected boolean"

kl_shen_LBstrcontentsRB :: Types.KLValue ->
                           Types.KLContext Types.Env Types.KLValue
kl_shen_LBstrcontentsRB (!kl_V2306) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_1 <- kl_fail
                                                                                                             !kl_if_2 <- kl_YaccParse `pseq` (appl_1 `pseq` eq kl_YaccParse appl_1)
                                                                                                             case kl_if_2 of
                                                                                                                 Atom (B (True)) -> do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_Parse_LBeRB) -> do !appl_4 <- kl_fail
                                                                                                                                                                                                             !appl_5 <- appl_4 `pseq` (kl_Parse_LBeRB `pseq` eq appl_4 kl_Parse_LBeRB)
                                                                                                                                                                                                             !kl_if_6 <- appl_5 `pseq` kl_not appl_5
                                                                                                                                                                                                             case kl_if_6 of
                                                                                                                                                                                                                 Atom (B (True)) -> do !appl_7 <- kl_Parse_LBeRB `pseq` hd kl_Parse_LBeRB
                                                                                                                                                                                                                                       appl_7 `pseq` kl_shen_pair appl_7 (Types.Atom Types.Nil)
                                                                                                                                                                                                                 Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                 _ -> throwError "if: expected boolean")))
                                                                                                                                       !appl_8 <- kl_V2306 `pseq` kl_LBeRB kl_V2306
                                                                                                                                       appl_8 `pseq` applyWrapper appl_3 [appl_8]
                                                                                                                 Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                 _ -> throwError "if: expected boolean")))
                                         let !appl_9 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBstrcRB) -> do !appl_10 <- kl_fail
                                                                                                                       !appl_11 <- appl_10 `pseq` (kl_Parse_shen_LBstrcRB `pseq` eq appl_10 kl_Parse_shen_LBstrcRB)
                                                                                                                       !kl_if_12 <- appl_11 `pseq` kl_not appl_11
                                                                                                                       case kl_if_12 of
                                                                                                                           Atom (B (True)) -> do let !appl_13 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBstrcontentsRB) -> do !appl_14 <- kl_fail
                                                                                                                                                                                                                                       !appl_15 <- appl_14 `pseq` (kl_Parse_shen_LBstrcontentsRB `pseq` eq appl_14 kl_Parse_shen_LBstrcontentsRB)
                                                                                                                                                                                                                                       !kl_if_16 <- appl_15 `pseq` kl_not appl_15
                                                                                                                                                                                                                                       case kl_if_16 of
                                                                                                                                                                                                                                           Atom (B (True)) -> do !appl_17 <- kl_Parse_shen_LBstrcontentsRB `pseq` hd kl_Parse_shen_LBstrcontentsRB
                                                                                                                                                                                                                                                                 !appl_18 <- kl_Parse_shen_LBstrcRB `pseq` kl_shen_hdtl kl_Parse_shen_LBstrcRB
                                                                                                                                                                                                                                                                 !appl_19 <- kl_Parse_shen_LBstrcontentsRB `pseq` kl_shen_hdtl kl_Parse_shen_LBstrcontentsRB
                                                                                                                                                                                                                                                                 !appl_20 <- appl_18 `pseq` (appl_19 `pseq` klCons appl_18 appl_19)
                                                                                                                                                                                                                                                                 appl_17 `pseq` (appl_20 `pseq` kl_shen_pair appl_17 appl_20)
                                                                                                                                                                                                                                           Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                           _ -> throwError "if: expected boolean")))
                                                                                                                                                 !appl_21 <- kl_Parse_shen_LBstrcRB `pseq` kl_shen_LBstrcontentsRB kl_Parse_shen_LBstrcRB
                                                                                                                                                 appl_21 `pseq` applyWrapper appl_13 [appl_21]
                                                                                                                           Atom (B (False)) -> do do kl_fail
                                                                                                                           _ -> throwError "if: expected boolean")))
                                         !appl_22 <- kl_V2306 `pseq` kl_shen_LBstrcRB kl_V2306
                                         !appl_23 <- appl_22 `pseq` applyWrapper appl_9 [appl_22]
                                         appl_23 `pseq` applyWrapper appl_0 [appl_23]

kl_shen_LBbyteRB :: Types.KLValue ->
                    Types.KLContext Types.Env Types.KLValue
kl_shen_LBbyteRB (!kl_V2308) = do !appl_0 <- kl_V2308 `pseq` hd kl_V2308
                                  !kl_if_1 <- appl_0 `pseq` consP appl_0
                                  case kl_if_1 of
                                      Atom (B (True)) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Parse_Byte) -> do !appl_3 <- kl_V2308 `pseq` hd kl_V2308
                                                                                                                                 !appl_4 <- appl_3 `pseq` tl appl_3
                                                                                                                                 !appl_5 <- kl_V2308 `pseq` kl_shen_hdtl kl_V2308
                                                                                                                                 !appl_6 <- appl_4 `pseq` (appl_5 `pseq` kl_shen_pair appl_4 appl_5)
                                                                                                                                 !appl_7 <- appl_6 `pseq` hd appl_6
                                                                                                                                 !appl_8 <- kl_Parse_Byte `pseq` nToString kl_Parse_Byte
                                                                                                                                 appl_7 `pseq` (appl_8 `pseq` kl_shen_pair appl_7 appl_8))))
                                                            !appl_9 <- kl_V2308 `pseq` hd kl_V2308
                                                            !appl_10 <- appl_9 `pseq` hd appl_9
                                                            appl_10 `pseq` applyWrapper appl_2 [appl_10]
                                      Atom (B (False)) -> do do kl_fail
                                      _ -> throwError "if: expected boolean"

kl_shen_LBstrcRB :: Types.KLValue ->
                    Types.KLContext Types.Env Types.KLValue
kl_shen_LBstrcRB (!kl_V2310) = do !appl_0 <- kl_V2310 `pseq` hd kl_V2310
                                  !kl_if_1 <- appl_0 `pseq` consP appl_0
                                  case kl_if_1 of
                                      Atom (B (True)) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Parse_Byte) -> do !appl_3 <- kl_Parse_Byte `pseq` eq kl_Parse_Byte (Types.Atom (Types.N (Types.KI 34)))
                                                                                                                                 !kl_if_4 <- appl_3 `pseq` kl_not appl_3
                                                                                                                                 case kl_if_4 of
                                                                                                                                     Atom (B (True)) -> do !appl_5 <- kl_V2310 `pseq` hd kl_V2310
                                                                                                                                                           !appl_6 <- appl_5 `pseq` tl appl_5
                                                                                                                                                           !appl_7 <- kl_V2310 `pseq` kl_shen_hdtl kl_V2310
                                                                                                                                                           !appl_8 <- appl_6 `pseq` (appl_7 `pseq` kl_shen_pair appl_6 appl_7)
                                                                                                                                                           !appl_9 <- appl_8 `pseq` hd appl_8
                                                                                                                                                           !appl_10 <- kl_Parse_Byte `pseq` nToString kl_Parse_Byte
                                                                                                                                                           appl_9 `pseq` (appl_10 `pseq` kl_shen_pair appl_9 appl_10)
                                                                                                                                     Atom (B (False)) -> do do kl_fail
                                                                                                                                     _ -> throwError "if: expected boolean")))
                                                            !appl_11 <- kl_V2310 `pseq` hd kl_V2310
                                                            !appl_12 <- appl_11 `pseq` hd appl_11
                                                            appl_12 `pseq` applyWrapper appl_2 [appl_12]
                                      Atom (B (False)) -> do do kl_fail
                                      _ -> throwError "if: expected boolean"

kl_shen_LBnumberRB :: Types.KLValue ->
                      Types.KLContext Types.Env Types.KLValue
kl_shen_LBnumberRB (!kl_V2312) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_1 <- kl_fail
                                                                                                        !kl_if_2 <- kl_YaccParse `pseq` (appl_1 `pseq` eq kl_YaccParse appl_1)
                                                                                                        case kl_if_2 of
                                                                                                            Atom (B (True)) -> do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_4 <- kl_fail
                                                                                                                                                                                                      !kl_if_5 <- kl_YaccParse `pseq` (appl_4 `pseq` eq kl_YaccParse appl_4)
                                                                                                                                                                                                      case kl_if_5 of
                                                                                                                                                                                                          Atom (B (True)) -> do let !appl_6 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_7 <- kl_fail
                                                                                                                                                                                                                                                                                                    !kl_if_8 <- kl_YaccParse `pseq` (appl_7 `pseq` eq kl_YaccParse appl_7)
                                                                                                                                                                                                                                                                                                    case kl_if_8 of
                                                                                                                                                                                                                                                                                                        Atom (B (True)) -> do let !appl_9 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_10 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                  !kl_if_11 <- kl_YaccParse `pseq` (appl_10 `pseq` eq kl_YaccParse appl_10)
                                                                                                                                                                                                                                                                                                                                                                                                  case kl_if_11 of
                                                                                                                                                                                                                                                                                                                                                                                                      Atom (B (True)) -> do let !appl_12 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_13 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 !kl_if_14 <- kl_YaccParse `pseq` (appl_13 `pseq` eq kl_YaccParse appl_13)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 case kl_if_14 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     Atom (B (True)) -> do let !appl_15 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBdigitsRB) -> do !appl_16 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !appl_17 <- appl_16 `pseq` (kl_Parse_shen_LBdigitsRB `pseq` eq appl_16 kl_Parse_shen_LBdigitsRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !kl_if_18 <- appl_17 `pseq` kl_not appl_17
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            case kl_if_18 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Atom (B (True)) -> do !appl_19 <- kl_Parse_shen_LBdigitsRB `pseq` hd kl_Parse_shen_LBdigitsRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_20 <- kl_Parse_shen_LBdigitsRB `pseq` kl_shen_hdtl kl_Parse_shen_LBdigitsRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_21 <- appl_20 `pseq` kl_reverse appl_20
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_22 <- appl_21 `pseq` kl_shen_pre appl_21 (Types.Atom (Types.N (Types.KI 0)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      appl_19 `pseq` (appl_22 `pseq` kl_shen_pair appl_19 appl_22)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           !appl_23 <- kl_V2312 `pseq` kl_shen_LBdigitsRB kl_V2312
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           appl_23 `pseq` applyWrapper appl_15 [appl_23]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                            let !appl_24 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBpredigitsRB) -> do !appl_25 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !appl_26 <- appl_25 `pseq` (kl_Parse_shen_LBpredigitsRB `pseq` eq appl_25 kl_Parse_shen_LBpredigitsRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !kl_if_27 <- appl_26 `pseq` kl_not appl_26
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                case kl_if_27 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Atom (B (True)) -> do let !appl_28 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBstopRB) -> do !appl_29 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !appl_30 <- appl_29 `pseq` (kl_Parse_shen_LBstopRB `pseq` eq appl_29 kl_Parse_shen_LBstopRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !kl_if_31 <- appl_30 `pseq` kl_not appl_30
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         case kl_if_31 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             Atom (B (True)) -> do let !appl_32 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBpostdigitsRB) -> do !appl_33 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        !appl_34 <- appl_33 `pseq` (kl_Parse_shen_LBpostdigitsRB `pseq` eq appl_33 kl_Parse_shen_LBpostdigitsRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        !kl_if_35 <- appl_34 `pseq` kl_not appl_34
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        case kl_if_35 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            Atom (B (True)) -> do !appl_36 <- kl_Parse_shen_LBpostdigitsRB `pseq` hd kl_Parse_shen_LBpostdigitsRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !appl_37 <- kl_Parse_shen_LBpredigitsRB `pseq` kl_shen_hdtl kl_Parse_shen_LBpredigitsRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !appl_38 <- appl_37 `pseq` kl_reverse appl_37
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !appl_39 <- appl_38 `pseq` kl_shen_pre appl_38 (Types.Atom (Types.N (Types.KI 0)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !appl_40 <- kl_Parse_shen_LBpostdigitsRB `pseq` kl_shen_hdtl kl_Parse_shen_LBpostdigitsRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !appl_41 <- appl_40 `pseq` kl_shen_post appl_40 (Types.Atom (Types.N (Types.KI 1)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !appl_42 <- appl_39 `pseq` (appl_41 `pseq` add appl_39 appl_41)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  appl_36 `pseq` (appl_42 `pseq` kl_shen_pair appl_36 appl_42)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   !appl_43 <- kl_Parse_shen_LBstopRB `pseq` kl_shen_LBpostdigitsRB kl_Parse_shen_LBstopRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   appl_43 `pseq` applyWrapper appl_32 [appl_43]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          !appl_44 <- kl_Parse_shen_LBpredigitsRB `pseq` kl_shen_LBstopRB kl_Parse_shen_LBpredigitsRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          appl_44 `pseq` applyWrapper appl_28 [appl_44]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                            !appl_45 <- kl_V2312 `pseq` kl_shen_LBpredigitsRB kl_V2312
                                                                                                                                                                                                                                                                                                                                                                                                                            !appl_46 <- appl_45 `pseq` applyWrapper appl_24 [appl_45]
                                                                                                                                                                                                                                                                                                                                                                                                                            appl_46 `pseq` applyWrapper appl_12 [appl_46]
                                                                                                                                                                                                                                                                                                                                                                                                      Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                                                                                                                                                                                                                                                                                                      _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                              let !appl_47 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBdigitsRB) -> do !appl_48 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                               !appl_49 <- appl_48 `pseq` (kl_Parse_shen_LBdigitsRB `pseq` eq appl_48 kl_Parse_shen_LBdigitsRB)
                                                                                                                                                                                                                                                                                                                                                                                                               !kl_if_50 <- appl_49 `pseq` kl_not appl_49
                                                                                                                                                                                                                                                                                                                                                                                                               case kl_if_50 of
                                                                                                                                                                                                                                                                                                                                                                                                                   Atom (B (True)) -> do let !appl_51 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBERB) -> do !appl_52 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     !appl_53 <- appl_52 `pseq` (kl_Parse_shen_LBERB `pseq` eq appl_52 kl_Parse_shen_LBERB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     !kl_if_54 <- appl_53 `pseq` kl_not appl_53
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     case kl_if_54 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         Atom (B (True)) -> do let !appl_55 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBlog10RB) -> do !appl_56 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               !appl_57 <- appl_56 `pseq` (kl_Parse_shen_LBlog10RB `pseq` eq appl_56 kl_Parse_shen_LBlog10RB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               !kl_if_58 <- appl_57 `pseq` kl_not appl_57
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               case kl_if_58 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   Atom (B (True)) -> do !appl_59 <- kl_Parse_shen_LBlog10RB `pseq` hd kl_Parse_shen_LBlog10RB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !appl_60 <- kl_Parse_shen_LBlog10RB `pseq` kl_shen_hdtl kl_Parse_shen_LBlog10RB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !appl_61 <- appl_60 `pseq` kl_shen_expt (Types.Atom (Types.N (Types.KI 10))) appl_60
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !appl_62 <- kl_Parse_shen_LBdigitsRB `pseq` kl_shen_hdtl kl_Parse_shen_LBdigitsRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !appl_63 <- appl_62 `pseq` kl_reverse appl_62
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !appl_64 <- appl_63 `pseq` kl_shen_pre appl_63 (Types.Atom (Types.N (Types.KI 0)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !appl_65 <- appl_61 `pseq` (appl_64 `pseq` multiply appl_61 appl_64)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         appl_59 `pseq` (appl_65 `pseq` kl_shen_pair appl_59 appl_65)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               !appl_66 <- kl_Parse_shen_LBERB `pseq` kl_shen_LBlog10RB kl_Parse_shen_LBERB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               appl_66 `pseq` applyWrapper appl_55 [appl_66]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                         !appl_67 <- kl_Parse_shen_LBdigitsRB `pseq` kl_shen_LBERB kl_Parse_shen_LBdigitsRB
                                                                                                                                                                                                                                                                                                                                                                                                                                         appl_67 `pseq` applyWrapper appl_51 [appl_67]
                                                                                                                                                                                                                                                                                                                                                                                                                   Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                   _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                              !appl_68 <- kl_V2312 `pseq` kl_shen_LBdigitsRB kl_V2312
                                                                                                                                                                                                                                                                                                                              !appl_69 <- appl_68 `pseq` applyWrapper appl_47 [appl_68]
                                                                                                                                                                                                                                                                                                                              appl_69 `pseq` applyWrapper appl_9 [appl_69]
                                                                                                                                                                                                                                                                                                        Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                                                                                                                                                                                                        _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                let !appl_70 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBpredigitsRB) -> do !appl_71 <- kl_fail
                                                                                                                                                                                                                                                                                                                    !appl_72 <- appl_71 `pseq` (kl_Parse_shen_LBpredigitsRB `pseq` eq appl_71 kl_Parse_shen_LBpredigitsRB)
                                                                                                                                                                                                                                                                                                                    !kl_if_73 <- appl_72 `pseq` kl_not appl_72
                                                                                                                                                                                                                                                                                                                    case kl_if_73 of
                                                                                                                                                                                                                                                                                                                        Atom (B (True)) -> do let !appl_74 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBstopRB) -> do !appl_75 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                             !appl_76 <- appl_75 `pseq` (kl_Parse_shen_LBstopRB `pseq` eq appl_75 kl_Parse_shen_LBstopRB)
                                                                                                                                                                                                                                                                                                                                                                                                                             !kl_if_77 <- appl_76 `pseq` kl_not appl_76
                                                                                                                                                                                                                                                                                                                                                                                                                             case kl_if_77 of
                                                                                                                                                                                                                                                                                                                                                                                                                                 Atom (B (True)) -> do let !appl_78 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBpostdigitsRB) -> do !appl_79 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !appl_80 <- appl_79 `pseq` (kl_Parse_shen_LBpostdigitsRB `pseq` eq appl_79 kl_Parse_shen_LBpostdigitsRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !kl_if_81 <- appl_80 `pseq` kl_not appl_80
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            case kl_if_81 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Atom (B (True)) -> do let !appl_82 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBERB) -> do !appl_83 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !appl_84 <- appl_83 `pseq` (kl_Parse_shen_LBERB `pseq` eq appl_83 kl_Parse_shen_LBERB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !kl_if_85 <- appl_84 `pseq` kl_not appl_84
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  case kl_if_85 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      Atom (B (True)) -> do let !appl_86 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBlog10RB) -> do !appl_87 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !appl_88 <- appl_87 `pseq` (kl_Parse_shen_LBlog10RB `pseq` eq appl_87 kl_Parse_shen_LBlog10RB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !kl_if_89 <- appl_88 `pseq` kl_not appl_88
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            case kl_if_89 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Atom (B (True)) -> do !appl_90 <- kl_Parse_shen_LBlog10RB `pseq` hd kl_Parse_shen_LBlog10RB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_91 <- kl_Parse_shen_LBlog10RB `pseq` kl_shen_hdtl kl_Parse_shen_LBlog10RB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_92 <- appl_91 `pseq` kl_shen_expt (Types.Atom (Types.N (Types.KI 10))) appl_91
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_93 <- kl_Parse_shen_LBpredigitsRB `pseq` kl_shen_hdtl kl_Parse_shen_LBpredigitsRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_94 <- appl_93 `pseq` kl_reverse appl_93
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_95 <- appl_94 `pseq` kl_shen_pre appl_94 (Types.Atom (Types.N (Types.KI 0)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_96 <- kl_Parse_shen_LBpostdigitsRB `pseq` kl_shen_hdtl kl_Parse_shen_LBpostdigitsRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_97 <- appl_96 `pseq` kl_shen_post appl_96 (Types.Atom (Types.N (Types.KI 1)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_98 <- appl_95 `pseq` (appl_97 `pseq` add appl_95 appl_97)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_99 <- appl_92 `pseq` (appl_98 `pseq` multiply appl_92 appl_98)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      appl_90 `pseq` (appl_99 `pseq` kl_shen_pair appl_90 appl_99)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !appl_100 <- kl_Parse_shen_LBERB `pseq` kl_shen_LBlog10RB kl_Parse_shen_LBERB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            appl_100 `pseq` applyWrapper appl_86 [appl_100]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_101 <- kl_Parse_shen_LBpostdigitsRB `pseq` kl_shen_LBERB kl_Parse_shen_LBpostdigitsRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      appl_101 `pseq` applyWrapper appl_82 [appl_101]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                       !appl_102 <- kl_Parse_shen_LBstopRB `pseq` kl_shen_LBpostdigitsRB kl_Parse_shen_LBstopRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                       appl_102 `pseq` applyWrapper appl_78 [appl_102]
                                                                                                                                                                                                                                                                                                                                                                                                                                 Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                 _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                              !appl_103 <- kl_Parse_shen_LBpredigitsRB `pseq` kl_shen_LBstopRB kl_Parse_shen_LBpredigitsRB
                                                                                                                                                                                                                                                                                                                                              appl_103 `pseq` applyWrapper appl_74 [appl_103]
                                                                                                                                                                                                                                                                                                                        Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                        _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                !appl_104 <- kl_V2312 `pseq` kl_shen_LBpredigitsRB kl_V2312
                                                                                                                                                                                                                                !appl_105 <- appl_104 `pseq` applyWrapper appl_70 [appl_104]
                                                                                                                                                                                                                                appl_105 `pseq` applyWrapper appl_6 [appl_105]
                                                                                                                                                                                                          Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                                                                                                          _ -> throwError "if: expected boolean")))
                                                                                                                                  let !appl_106 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBplusRB) -> do !appl_107 <- kl_fail
                                                                                                                                                                                                                  !appl_108 <- appl_107 `pseq` (kl_Parse_shen_LBplusRB `pseq` eq appl_107 kl_Parse_shen_LBplusRB)
                                                                                                                                                                                                                  !kl_if_109 <- appl_108 `pseq` kl_not appl_108
                                                                                                                                                                                                                  case kl_if_109 of
                                                                                                                                                                                                                      Atom (B (True)) -> do let !appl_110 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBnumberRB) -> do !appl_111 <- kl_fail
                                                                                                                                                                                                                                                                                                                              !appl_112 <- appl_111 `pseq` (kl_Parse_shen_LBnumberRB `pseq` eq appl_111 kl_Parse_shen_LBnumberRB)
                                                                                                                                                                                                                                                                                                                              !kl_if_113 <- appl_112 `pseq` kl_not appl_112
                                                                                                                                                                                                                                                                                                                              case kl_if_113 of
                                                                                                                                                                                                                                                                                                                                  Atom (B (True)) -> do !appl_114 <- kl_Parse_shen_LBnumberRB `pseq` hd kl_Parse_shen_LBnumberRB
                                                                                                                                                                                                                                                                                                                                                        !appl_115 <- kl_Parse_shen_LBnumberRB `pseq` kl_shen_hdtl kl_Parse_shen_LBnumberRB
                                                                                                                                                                                                                                                                                                                                                        appl_114 `pseq` (appl_115 `pseq` kl_shen_pair appl_114 appl_115)
                                                                                                                                                                                                                                                                                                                                  Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                  _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                            !appl_116 <- kl_Parse_shen_LBplusRB `pseq` kl_shen_LBnumberRB kl_Parse_shen_LBplusRB
                                                                                                                                                                                                                                            appl_116 `pseq` applyWrapper appl_110 [appl_116]
                                                                                                                                                                                                                      Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                      _ -> throwError "if: expected boolean")))
                                                                                                                                  !appl_117 <- kl_V2312 `pseq` kl_shen_LBplusRB kl_V2312
                                                                                                                                  !appl_118 <- appl_117 `pseq` applyWrapper appl_106 [appl_117]
                                                                                                                                  appl_118 `pseq` applyWrapper appl_3 [appl_118]
                                                                                                            Atom (B (False)) -> do do return kl_YaccParse
                                                                                                            _ -> throwError "if: expected boolean")))
                                    let !appl_119 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBminusRB) -> do !appl_120 <- kl_fail
                                                                                                                     !appl_121 <- appl_120 `pseq` (kl_Parse_shen_LBminusRB `pseq` eq appl_120 kl_Parse_shen_LBminusRB)
                                                                                                                     !kl_if_122 <- appl_121 `pseq` kl_not appl_121
                                                                                                                     case kl_if_122 of
                                                                                                                         Atom (B (True)) -> do let !appl_123 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBnumberRB) -> do !appl_124 <- kl_fail
                                                                                                                                                                                                                                 !appl_125 <- appl_124 `pseq` (kl_Parse_shen_LBnumberRB `pseq` eq appl_124 kl_Parse_shen_LBnumberRB)
                                                                                                                                                                                                                                 !kl_if_126 <- appl_125 `pseq` kl_not appl_125
                                                                                                                                                                                                                                 case kl_if_126 of
                                                                                                                                                                                                                                     Atom (B (True)) -> do !appl_127 <- kl_Parse_shen_LBnumberRB `pseq` hd kl_Parse_shen_LBnumberRB
                                                                                                                                                                                                                                                           !appl_128 <- kl_Parse_shen_LBnumberRB `pseq` kl_shen_hdtl kl_Parse_shen_LBnumberRB
                                                                                                                                                                                                                                                           !appl_129 <- appl_128 `pseq` Primitives.subtract (Types.Atom (Types.N (Types.KI 0))) appl_128
                                                                                                                                                                                                                                                           appl_127 `pseq` (appl_129 `pseq` kl_shen_pair appl_127 appl_129)
                                                                                                                                                                                                                                     Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                     _ -> throwError "if: expected boolean")))
                                                                                                                                               !appl_130 <- kl_Parse_shen_LBminusRB `pseq` kl_shen_LBnumberRB kl_Parse_shen_LBminusRB
                                                                                                                                               appl_130 `pseq` applyWrapper appl_123 [appl_130]
                                                                                                                         Atom (B (False)) -> do do kl_fail
                                                                                                                         _ -> throwError "if: expected boolean")))
                                    !appl_131 <- kl_V2312 `pseq` kl_shen_LBminusRB kl_V2312
                                    !appl_132 <- appl_131 `pseq` applyWrapper appl_119 [appl_131]
                                    appl_132 `pseq` applyWrapper appl_0 [appl_132]

kl_shen_LBERB :: Types.KLValue ->
                 Types.KLContext Types.Env Types.KLValue
kl_shen_LBERB (!kl_V2314) = do !appl_0 <- kl_V2314 `pseq` hd kl_V2314
                               !kl_if_1 <- appl_0 `pseq` consP appl_0
                               !kl_if_2 <- case kl_if_1 of
                                               Atom (B (True)) -> do !appl_3 <- kl_V2314 `pseq` hd kl_V2314
                                                                     !appl_4 <- appl_3 `pseq` hd appl_3
                                                                     !kl_if_5 <- appl_4 `pseq` eq (Types.Atom (Types.N (Types.KI 101))) appl_4
                                                                     case kl_if_5 of
                                                                         Atom (B (True)) -> do return (Atom (B True))
                                                                         Atom (B (False)) -> do do return (Atom (B False))
                                                                         _ -> throwError "if: expected boolean"
                                               Atom (B (False)) -> do do return (Atom (B False))
                                               _ -> throwError "if: expected boolean"
                               case kl_if_2 of
                                   Atom (B (True)) -> do !appl_6 <- kl_V2314 `pseq` hd kl_V2314
                                                         !appl_7 <- appl_6 `pseq` tl appl_6
                                                         !appl_8 <- kl_V2314 `pseq` kl_shen_hdtl kl_V2314
                                                         !appl_9 <- appl_7 `pseq` (appl_8 `pseq` kl_shen_pair appl_7 appl_8)
                                                         !appl_10 <- appl_9 `pseq` hd appl_9
                                                         appl_10 `pseq` kl_shen_pair appl_10 (Types.Atom (Types.UnboundSym "shen.skip"))
                                   Atom (B (False)) -> do do kl_fail
                                   _ -> throwError "if: expected boolean"

kl_shen_LBlog10RB :: Types.KLValue ->
                     Types.KLContext Types.Env Types.KLValue
kl_shen_LBlog10RB (!kl_V2316) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_1 <- kl_fail
                                                                                                       !kl_if_2 <- kl_YaccParse `pseq` (appl_1 `pseq` eq kl_YaccParse appl_1)
                                                                                                       case kl_if_2 of
                                                                                                           Atom (B (True)) -> do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBdigitsRB) -> do !appl_4 <- kl_fail
                                                                                                                                                                                                                 !appl_5 <- appl_4 `pseq` (kl_Parse_shen_LBdigitsRB `pseq` eq appl_4 kl_Parse_shen_LBdigitsRB)
                                                                                                                                                                                                                 !kl_if_6 <- appl_5 `pseq` kl_not appl_5
                                                                                                                                                                                                                 case kl_if_6 of
                                                                                                                                                                                                                     Atom (B (True)) -> do !appl_7 <- kl_Parse_shen_LBdigitsRB `pseq` hd kl_Parse_shen_LBdigitsRB
                                                                                                                                                                                                                                           !appl_8 <- kl_Parse_shen_LBdigitsRB `pseq` kl_shen_hdtl kl_Parse_shen_LBdigitsRB
                                                                                                                                                                                                                                           !appl_9 <- appl_8 `pseq` kl_reverse appl_8
                                                                                                                                                                                                                                           !appl_10 <- appl_9 `pseq` kl_shen_pre appl_9 (Types.Atom (Types.N (Types.KI 0)))
                                                                                                                                                                                                                                           appl_7 `pseq` (appl_10 `pseq` kl_shen_pair appl_7 appl_10)
                                                                                                                                                                                                                     Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                     _ -> throwError "if: expected boolean")))
                                                                                                                                 !appl_11 <- kl_V2316 `pseq` kl_shen_LBdigitsRB kl_V2316
                                                                                                                                 appl_11 `pseq` applyWrapper appl_3 [appl_11]
                                                                                                           Atom (B (False)) -> do do return kl_YaccParse
                                                                                                           _ -> throwError "if: expected boolean")))
                                   let !appl_12 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBminusRB) -> do !appl_13 <- kl_fail
                                                                                                                   !appl_14 <- appl_13 `pseq` (kl_Parse_shen_LBminusRB `pseq` eq appl_13 kl_Parse_shen_LBminusRB)
                                                                                                                   !kl_if_15 <- appl_14 `pseq` kl_not appl_14
                                                                                                                   case kl_if_15 of
                                                                                                                       Atom (B (True)) -> do let !appl_16 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBdigitsRB) -> do !appl_17 <- kl_fail
                                                                                                                                                                                                                              !appl_18 <- appl_17 `pseq` (kl_Parse_shen_LBdigitsRB `pseq` eq appl_17 kl_Parse_shen_LBdigitsRB)
                                                                                                                                                                                                                              !kl_if_19 <- appl_18 `pseq` kl_not appl_18
                                                                                                                                                                                                                              case kl_if_19 of
                                                                                                                                                                                                                                  Atom (B (True)) -> do !appl_20 <- kl_Parse_shen_LBdigitsRB `pseq` hd kl_Parse_shen_LBdigitsRB
                                                                                                                                                                                                                                                        !appl_21 <- kl_Parse_shen_LBdigitsRB `pseq` kl_shen_hdtl kl_Parse_shen_LBdigitsRB
                                                                                                                                                                                                                                                        !appl_22 <- appl_21 `pseq` kl_reverse appl_21
                                                                                                                                                                                                                                                        !appl_23 <- appl_22 `pseq` kl_shen_pre appl_22 (Types.Atom (Types.N (Types.KI 0)))
                                                                                                                                                                                                                                                        !appl_24 <- appl_23 `pseq` Primitives.subtract (Types.Atom (Types.N (Types.KI 0))) appl_23
                                                                                                                                                                                                                                                        appl_20 `pseq` (appl_24 `pseq` kl_shen_pair appl_20 appl_24)
                                                                                                                                                                                                                                  Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                  _ -> throwError "if: expected boolean")))
                                                                                                                                             !appl_25 <- kl_Parse_shen_LBminusRB `pseq` kl_shen_LBdigitsRB kl_Parse_shen_LBminusRB
                                                                                                                                             appl_25 `pseq` applyWrapper appl_16 [appl_25]
                                                                                                                       Atom (B (False)) -> do do kl_fail
                                                                                                                       _ -> throwError "if: expected boolean")))
                                   !appl_26 <- kl_V2316 `pseq` kl_shen_LBminusRB kl_V2316
                                   !appl_27 <- appl_26 `pseq` applyWrapper appl_12 [appl_26]
                                   appl_27 `pseq` applyWrapper appl_0 [appl_27]

kl_shen_LBplusRB :: Types.KLValue ->
                    Types.KLContext Types.Env Types.KLValue
kl_shen_LBplusRB (!kl_V2318) = do !appl_0 <- kl_V2318 `pseq` hd kl_V2318
                                  !kl_if_1 <- appl_0 `pseq` consP appl_0
                                  case kl_if_1 of
                                      Atom (B (True)) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Parse_Byte) -> do let pat_cond_3 = do !appl_4 <- kl_V2318 `pseq` hd kl_V2318
                                                                                                                                                     !appl_5 <- appl_4 `pseq` tl appl_4
                                                                                                                                                     !appl_6 <- kl_V2318 `pseq` kl_shen_hdtl kl_V2318
                                                                                                                                                     !appl_7 <- appl_5 `pseq` (appl_6 `pseq` kl_shen_pair appl_5 appl_6)
                                                                                                                                                     !appl_8 <- appl_7 `pseq` hd appl_7
                                                                                                                                                     appl_8 `pseq` (kl_Parse_Byte `pseq` kl_shen_pair appl_8 kl_Parse_Byte)
                                                                                                                                     pat_cond_9 = do do kl_fail
                                                                                                                                  in case kl_Parse_Byte of
                                                                                                                                         kl_Parse_Byte@(Atom (N (KI 43))) -> pat_cond_3
                                                                                                                                         _ -> pat_cond_9)))
                                                            !appl_10 <- kl_V2318 `pseq` hd kl_V2318
                                                            !appl_11 <- appl_10 `pseq` hd appl_10
                                                            appl_11 `pseq` applyWrapper appl_2 [appl_11]
                                      Atom (B (False)) -> do do kl_fail
                                      _ -> throwError "if: expected boolean"

kl_shen_LBstopRB :: Types.KLValue ->
                    Types.KLContext Types.Env Types.KLValue
kl_shen_LBstopRB (!kl_V2320) = do !appl_0 <- kl_V2320 `pseq` hd kl_V2320
                                  !kl_if_1 <- appl_0 `pseq` consP appl_0
                                  case kl_if_1 of
                                      Atom (B (True)) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Parse_Byte) -> do let pat_cond_3 = do !appl_4 <- kl_V2320 `pseq` hd kl_V2320
                                                                                                                                                     !appl_5 <- appl_4 `pseq` tl appl_4
                                                                                                                                                     !appl_6 <- kl_V2320 `pseq` kl_shen_hdtl kl_V2320
                                                                                                                                                     !appl_7 <- appl_5 `pseq` (appl_6 `pseq` kl_shen_pair appl_5 appl_6)
                                                                                                                                                     !appl_8 <- appl_7 `pseq` hd appl_7
                                                                                                                                                     appl_8 `pseq` (kl_Parse_Byte `pseq` kl_shen_pair appl_8 kl_Parse_Byte)
                                                                                                                                     pat_cond_9 = do do kl_fail
                                                                                                                                  in case kl_Parse_Byte of
                                                                                                                                         kl_Parse_Byte@(Atom (N (KI 46))) -> pat_cond_3
                                                                                                                                         _ -> pat_cond_9)))
                                                            !appl_10 <- kl_V2320 `pseq` hd kl_V2320
                                                            !appl_11 <- appl_10 `pseq` hd appl_10
                                                            appl_11 `pseq` applyWrapper appl_2 [appl_11]
                                      Atom (B (False)) -> do do kl_fail
                                      _ -> throwError "if: expected boolean"

kl_shen_LBpredigitsRB :: Types.KLValue ->
                         Types.KLContext Types.Env Types.KLValue
kl_shen_LBpredigitsRB (!kl_V2322) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_1 <- kl_fail
                                                                                                           !kl_if_2 <- kl_YaccParse `pseq` (appl_1 `pseq` eq kl_YaccParse appl_1)
                                                                                                           case kl_if_2 of
                                                                                                               Atom (B (True)) -> do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_Parse_LBeRB) -> do !appl_4 <- kl_fail
                                                                                                                                                                                                           !appl_5 <- appl_4 `pseq` (kl_Parse_LBeRB `pseq` eq appl_4 kl_Parse_LBeRB)
                                                                                                                                                                                                           !kl_if_6 <- appl_5 `pseq` kl_not appl_5
                                                                                                                                                                                                           case kl_if_6 of
                                                                                                                                                                                                               Atom (B (True)) -> do !appl_7 <- kl_Parse_LBeRB `pseq` hd kl_Parse_LBeRB
                                                                                                                                                                                                                                     appl_7 `pseq` kl_shen_pair appl_7 (Types.Atom Types.Nil)
                                                                                                                                                                                                               Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                               _ -> throwError "if: expected boolean")))
                                                                                                                                     !appl_8 <- kl_V2322 `pseq` kl_LBeRB kl_V2322
                                                                                                                                     appl_8 `pseq` applyWrapper appl_3 [appl_8]
                                                                                                               Atom (B (False)) -> do do return kl_YaccParse
                                                                                                               _ -> throwError "if: expected boolean")))
                                       let !appl_9 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBdigitsRB) -> do !appl_10 <- kl_fail
                                                                                                                       !appl_11 <- appl_10 `pseq` (kl_Parse_shen_LBdigitsRB `pseq` eq appl_10 kl_Parse_shen_LBdigitsRB)
                                                                                                                       !kl_if_12 <- appl_11 `pseq` kl_not appl_11
                                                                                                                       case kl_if_12 of
                                                                                                                           Atom (B (True)) -> do !appl_13 <- kl_Parse_shen_LBdigitsRB `pseq` hd kl_Parse_shen_LBdigitsRB
                                                                                                                                                 !appl_14 <- kl_Parse_shen_LBdigitsRB `pseq` kl_shen_hdtl kl_Parse_shen_LBdigitsRB
                                                                                                                                                 appl_13 `pseq` (appl_14 `pseq` kl_shen_pair appl_13 appl_14)
                                                                                                                           Atom (B (False)) -> do do kl_fail
                                                                                                                           _ -> throwError "if: expected boolean")))
                                       !appl_15 <- kl_V2322 `pseq` kl_shen_LBdigitsRB kl_V2322
                                       !appl_16 <- appl_15 `pseq` applyWrapper appl_9 [appl_15]
                                       appl_16 `pseq` applyWrapper appl_0 [appl_16]

kl_shen_LBpostdigitsRB :: Types.KLValue ->
                          Types.KLContext Types.Env Types.KLValue
kl_shen_LBpostdigitsRB (!kl_V2324) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBdigitsRB) -> do !appl_1 <- kl_fail
                                                                                                                        !appl_2 <- appl_1 `pseq` (kl_Parse_shen_LBdigitsRB `pseq` eq appl_1 kl_Parse_shen_LBdigitsRB)
                                                                                                                        !kl_if_3 <- appl_2 `pseq` kl_not appl_2
                                                                                                                        case kl_if_3 of
                                                                                                                            Atom (B (True)) -> do !appl_4 <- kl_Parse_shen_LBdigitsRB `pseq` hd kl_Parse_shen_LBdigitsRB
                                                                                                                                                  !appl_5 <- kl_Parse_shen_LBdigitsRB `pseq` kl_shen_hdtl kl_Parse_shen_LBdigitsRB
                                                                                                                                                  appl_4 `pseq` (appl_5 `pseq` kl_shen_pair appl_4 appl_5)
                                                                                                                            Atom (B (False)) -> do do kl_fail
                                                                                                                            _ -> throwError "if: expected boolean")))
                                        !appl_6 <- kl_V2324 `pseq` kl_shen_LBdigitsRB kl_V2324
                                        appl_6 `pseq` applyWrapper appl_0 [appl_6]

kl_shen_LBdigitsRB :: Types.KLValue ->
                      Types.KLContext Types.Env Types.KLValue
kl_shen_LBdigitsRB (!kl_V2326) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_1 <- kl_fail
                                                                                                        !kl_if_2 <- kl_YaccParse `pseq` (appl_1 `pseq` eq kl_YaccParse appl_1)
                                                                                                        case kl_if_2 of
                                                                                                            Atom (B (True)) -> do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBdigitRB) -> do !appl_4 <- kl_fail
                                                                                                                                                                                                                 !appl_5 <- appl_4 `pseq` (kl_Parse_shen_LBdigitRB `pseq` eq appl_4 kl_Parse_shen_LBdigitRB)
                                                                                                                                                                                                                 !kl_if_6 <- appl_5 `pseq` kl_not appl_5
                                                                                                                                                                                                                 case kl_if_6 of
                                                                                                                                                                                                                     Atom (B (True)) -> do !appl_7 <- kl_Parse_shen_LBdigitRB `pseq` hd kl_Parse_shen_LBdigitRB
                                                                                                                                                                                                                                           !appl_8 <- kl_Parse_shen_LBdigitRB `pseq` kl_shen_hdtl kl_Parse_shen_LBdigitRB
                                                                                                                                                                                                                                           !appl_9 <- appl_8 `pseq` klCons appl_8 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                           appl_7 `pseq` (appl_9 `pseq` kl_shen_pair appl_7 appl_9)
                                                                                                                                                                                                                     Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                     _ -> throwError "if: expected boolean")))
                                                                                                                                  !appl_10 <- kl_V2326 `pseq` kl_shen_LBdigitRB kl_V2326
                                                                                                                                  appl_10 `pseq` applyWrapper appl_3 [appl_10]
                                                                                                            Atom (B (False)) -> do do return kl_YaccParse
                                                                                                            _ -> throwError "if: expected boolean")))
                                    let !appl_11 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBdigitRB) -> do !appl_12 <- kl_fail
                                                                                                                    !appl_13 <- appl_12 `pseq` (kl_Parse_shen_LBdigitRB `pseq` eq appl_12 kl_Parse_shen_LBdigitRB)
                                                                                                                    !kl_if_14 <- appl_13 `pseq` kl_not appl_13
                                                                                                                    case kl_if_14 of
                                                                                                                        Atom (B (True)) -> do let !appl_15 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBdigitsRB) -> do !appl_16 <- kl_fail
                                                                                                                                                                                                                               !appl_17 <- appl_16 `pseq` (kl_Parse_shen_LBdigitsRB `pseq` eq appl_16 kl_Parse_shen_LBdigitsRB)
                                                                                                                                                                                                                               !kl_if_18 <- appl_17 `pseq` kl_not appl_17
                                                                                                                                                                                                                               case kl_if_18 of
                                                                                                                                                                                                                                   Atom (B (True)) -> do !appl_19 <- kl_Parse_shen_LBdigitsRB `pseq` hd kl_Parse_shen_LBdigitsRB
                                                                                                                                                                                                                                                         !appl_20 <- kl_Parse_shen_LBdigitRB `pseq` kl_shen_hdtl kl_Parse_shen_LBdigitRB
                                                                                                                                                                                                                                                         !appl_21 <- kl_Parse_shen_LBdigitsRB `pseq` kl_shen_hdtl kl_Parse_shen_LBdigitsRB
                                                                                                                                                                                                                                                         !appl_22 <- appl_20 `pseq` (appl_21 `pseq` klCons appl_20 appl_21)
                                                                                                                                                                                                                                                         appl_19 `pseq` (appl_22 `pseq` kl_shen_pair appl_19 appl_22)
                                                                                                                                                                                                                                   Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                   _ -> throwError "if: expected boolean")))
                                                                                                                                              !appl_23 <- kl_Parse_shen_LBdigitRB `pseq` kl_shen_LBdigitsRB kl_Parse_shen_LBdigitRB
                                                                                                                                              appl_23 `pseq` applyWrapper appl_15 [appl_23]
                                                                                                                        Atom (B (False)) -> do do kl_fail
                                                                                                                        _ -> throwError "if: expected boolean")))
                                    !appl_24 <- kl_V2326 `pseq` kl_shen_LBdigitRB kl_V2326
                                    !appl_25 <- appl_24 `pseq` applyWrapper appl_11 [appl_24]
                                    appl_25 `pseq` applyWrapper appl_0 [appl_25]

kl_shen_LBdigitRB :: Types.KLValue ->
                     Types.KLContext Types.Env Types.KLValue
kl_shen_LBdigitRB (!kl_V2328) = do !appl_0 <- kl_V2328 `pseq` hd kl_V2328
                                   !kl_if_1 <- appl_0 `pseq` consP appl_0
                                   case kl_if_1 of
                                       Atom (B (True)) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Parse_X) -> do !kl_if_3 <- kl_Parse_X `pseq` kl_shen_numbyteP kl_Parse_X
                                                                                                                               case kl_if_3 of
                                                                                                                                   Atom (B (True)) -> do !appl_4 <- kl_V2328 `pseq` hd kl_V2328
                                                                                                                                                         !appl_5 <- appl_4 `pseq` tl appl_4
                                                                                                                                                         !appl_6 <- kl_V2328 `pseq` kl_shen_hdtl kl_V2328
                                                                                                                                                         !appl_7 <- appl_5 `pseq` (appl_6 `pseq` kl_shen_pair appl_5 appl_6)
                                                                                                                                                         !appl_8 <- appl_7 `pseq` hd appl_7
                                                                                                                                                         !appl_9 <- kl_Parse_X `pseq` kl_shen_byte_RBdigit kl_Parse_X
                                                                                                                                                         appl_8 `pseq` (appl_9 `pseq` kl_shen_pair appl_8 appl_9)
                                                                                                                                   Atom (B (False)) -> do do kl_fail
                                                                                                                                   _ -> throwError "if: expected boolean")))
                                                             !appl_10 <- kl_V2328 `pseq` hd kl_V2328
                                                             !appl_11 <- appl_10 `pseq` hd appl_10
                                                             appl_11 `pseq` applyWrapper appl_2 [appl_11]
                                       Atom (B (False)) -> do do kl_fail
                                       _ -> throwError "if: expected boolean"

kl_shen_byte_RBdigit :: Types.KLValue ->
                        Types.KLContext Types.Env Types.KLValue
kl_shen_byte_RBdigit (!kl_V2330) = do let pat_cond_0 = do return (Types.Atom (Types.N (Types.KI 0)))
                                          pat_cond_1 = do return (Types.Atom (Types.N (Types.KI 1)))
                                          pat_cond_2 = do return (Types.Atom (Types.N (Types.KI 2)))
                                          pat_cond_3 = do return (Types.Atom (Types.N (Types.KI 3)))
                                          pat_cond_4 = do return (Types.Atom (Types.N (Types.KI 4)))
                                          pat_cond_5 = do return (Types.Atom (Types.N (Types.KI 5)))
                                          pat_cond_6 = do return (Types.Atom (Types.N (Types.KI 6)))
                                          pat_cond_7 = do return (Types.Atom (Types.N (Types.KI 7)))
                                          pat_cond_8 = do return (Types.Atom (Types.N (Types.KI 8)))
                                          pat_cond_9 = do return (Types.Atom (Types.N (Types.KI 9)))
                                          pat_cond_10 = do do let !aw_11 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                              applyWrapper aw_11 [ApplC (wrapNamed "shen.byte->digit" kl_shen_byte_RBdigit)]
                                       in case kl_V2330 of
                                              kl_V2330@(Atom (N (KI 48))) -> pat_cond_0
                                              kl_V2330@(Atom (N (KI 49))) -> pat_cond_1
                                              kl_V2330@(Atom (N (KI 50))) -> pat_cond_2
                                              kl_V2330@(Atom (N (KI 51))) -> pat_cond_3
                                              kl_V2330@(Atom (N (KI 52))) -> pat_cond_4
                                              kl_V2330@(Atom (N (KI 53))) -> pat_cond_5
                                              kl_V2330@(Atom (N (KI 54))) -> pat_cond_6
                                              kl_V2330@(Atom (N (KI 55))) -> pat_cond_7
                                              kl_V2330@(Atom (N (KI 56))) -> pat_cond_8
                                              kl_V2330@(Atom (N (KI 57))) -> pat_cond_9
                                              _ -> pat_cond_10

kl_shen_pre :: Types.KLValue ->
               Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_pre (!kl_V2335) (!kl_V2336) = do let pat_cond_0 = do return (Types.Atom (Types.N (Types.KI 0)))
                                             pat_cond_1 kl_V2335 kl_V2335h kl_V2335t = do !appl_2 <- kl_V2336 `pseq` kl_shen_expt (Types.Atom (Types.N (Types.KI 10))) kl_V2336
                                                                                          !appl_3 <- appl_2 `pseq` (kl_V2335h `pseq` multiply appl_2 kl_V2335h)
                                                                                          !appl_4 <- kl_V2336 `pseq` add kl_V2336 (Types.Atom (Types.N (Types.KI 1)))
                                                                                          !appl_5 <- kl_V2335t `pseq` (appl_4 `pseq` kl_shen_pre kl_V2335t appl_4)
                                                                                          appl_3 `pseq` (appl_5 `pseq` add appl_3 appl_5)
                                             pat_cond_6 = do do let !aw_7 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                applyWrapper aw_7 [ApplC (wrapNamed "shen.pre" kl_shen_pre)]
                                          in case kl_V2335 of
                                                 kl_V2335@(Atom (Nil)) -> pat_cond_0
                                                 !(kl_V2335@(Cons (!kl_V2335h)
                                                                  (!kl_V2335t))) -> pat_cond_1 kl_V2335 kl_V2335h kl_V2335t
                                                 _ -> pat_cond_6

kl_shen_post :: Types.KLValue ->
                Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_post (!kl_V2341) (!kl_V2342) = do let pat_cond_0 = do return (Types.Atom (Types.N (Types.KI 0)))
                                              pat_cond_1 kl_V2341 kl_V2341h kl_V2341t = do !appl_2 <- kl_V2342 `pseq` Primitives.subtract (Types.Atom (Types.N (Types.KI 0))) kl_V2342
                                                                                           !appl_3 <- appl_2 `pseq` kl_shen_expt (Types.Atom (Types.N (Types.KI 10))) appl_2
                                                                                           !appl_4 <- appl_3 `pseq` (kl_V2341h `pseq` multiply appl_3 kl_V2341h)
                                                                                           !appl_5 <- kl_V2342 `pseq` add kl_V2342 (Types.Atom (Types.N (Types.KI 1)))
                                                                                           !appl_6 <- kl_V2341t `pseq` (appl_5 `pseq` kl_shen_post kl_V2341t appl_5)
                                                                                           appl_4 `pseq` (appl_6 `pseq` add appl_4 appl_6)
                                              pat_cond_7 = do do let !aw_8 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                 applyWrapper aw_8 [ApplC (wrapNamed "shen.post" kl_shen_post)]
                                           in case kl_V2341 of
                                                  kl_V2341@(Atom (Nil)) -> pat_cond_0
                                                  !(kl_V2341@(Cons (!kl_V2341h)
                                                                   (!kl_V2341t))) -> pat_cond_1 kl_V2341 kl_V2341h kl_V2341t
                                                  _ -> pat_cond_7

kl_shen_expt :: Types.KLValue ->
                Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_expt (!kl_V2347) (!kl_V2348) = do let pat_cond_0 = do return (Types.Atom (Types.N (Types.KI 1)))
                                              pat_cond_1 = do !kl_if_2 <- kl_V2348 `pseq` greaterThan kl_V2348 (Types.Atom (Types.N (Types.KI 0)))
                                                              case kl_if_2 of
                                                                  Atom (B (True)) -> do !appl_3 <- kl_V2348 `pseq` Primitives.subtract kl_V2348 (Types.Atom (Types.N (Types.KI 1)))
                                                                                        !appl_4 <- kl_V2347 `pseq` (appl_3 `pseq` kl_shen_expt kl_V2347 appl_3)
                                                                                        kl_V2347 `pseq` (appl_4 `pseq` multiply kl_V2347 appl_4)
                                                                  Atom (B (False)) -> do do !appl_5 <- kl_V2348 `pseq` add kl_V2348 (Types.Atom (Types.N (Types.KI 1)))
                                                                                            !appl_6 <- kl_V2347 `pseq` (appl_5 `pseq` kl_shen_expt kl_V2347 appl_5)
                                                                                            !appl_7 <- appl_6 `pseq` (kl_V2347 `pseq` divide appl_6 kl_V2347)
                                                                                            appl_7 `pseq` multiply (Types.Atom (Types.N (Types.KI 1))) appl_7
                                                                  _ -> throwError "if: expected boolean"
                                           in case kl_V2348 of
                                                  kl_V2348@(Atom (N (KI 0))) -> pat_cond_0
                                                  _ -> pat_cond_1

kl_shen_LBst_input1RB :: Types.KLValue ->
                         Types.KLContext Types.Env Types.KLValue
kl_shen_LBst_input1RB (!kl_V2350) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBst_inputRB) -> do !appl_1 <- kl_fail
                                                                                                                         !appl_2 <- appl_1 `pseq` (kl_Parse_shen_LBst_inputRB `pseq` eq appl_1 kl_Parse_shen_LBst_inputRB)
                                                                                                                         !kl_if_3 <- appl_2 `pseq` kl_not appl_2
                                                                                                                         case kl_if_3 of
                                                                                                                             Atom (B (True)) -> do !appl_4 <- kl_Parse_shen_LBst_inputRB `pseq` hd kl_Parse_shen_LBst_inputRB
                                                                                                                                                   !appl_5 <- kl_Parse_shen_LBst_inputRB `pseq` kl_shen_hdtl kl_Parse_shen_LBst_inputRB
                                                                                                                                                   appl_4 `pseq` (appl_5 `pseq` kl_shen_pair appl_4 appl_5)
                                                                                                                             Atom (B (False)) -> do do kl_fail
                                                                                                                             _ -> throwError "if: expected boolean")))
                                       !appl_6 <- kl_V2350 `pseq` kl_shen_LBst_inputRB kl_V2350
                                       appl_6 `pseq` applyWrapper appl_0 [appl_6]

kl_shen_LBst_input2RB :: Types.KLValue ->
                         Types.KLContext Types.Env Types.KLValue
kl_shen_LBst_input2RB (!kl_V2352) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBst_inputRB) -> do !appl_1 <- kl_fail
                                                                                                                         !appl_2 <- appl_1 `pseq` (kl_Parse_shen_LBst_inputRB `pseq` eq appl_1 kl_Parse_shen_LBst_inputRB)
                                                                                                                         !kl_if_3 <- appl_2 `pseq` kl_not appl_2
                                                                                                                         case kl_if_3 of
                                                                                                                             Atom (B (True)) -> do !appl_4 <- kl_Parse_shen_LBst_inputRB `pseq` hd kl_Parse_shen_LBst_inputRB
                                                                                                                                                   !appl_5 <- kl_Parse_shen_LBst_inputRB `pseq` kl_shen_hdtl kl_Parse_shen_LBst_inputRB
                                                                                                                                                   appl_4 `pseq` (appl_5 `pseq` kl_shen_pair appl_4 appl_5)
                                                                                                                             Atom (B (False)) -> do do kl_fail
                                                                                                                             _ -> throwError "if: expected boolean")))
                                       !appl_6 <- kl_V2352 `pseq` kl_shen_LBst_inputRB kl_V2352
                                       appl_6 `pseq` applyWrapper appl_0 [appl_6]

kl_shen_LBcommentRB :: Types.KLValue ->
                       Types.KLContext Types.Env Types.KLValue
kl_shen_LBcommentRB (!kl_V2354) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_1 <- kl_fail
                                                                                                         !kl_if_2 <- kl_YaccParse `pseq` (appl_1 `pseq` eq kl_YaccParse appl_1)
                                                                                                         case kl_if_2 of
                                                                                                             Atom (B (True)) -> do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBmultilineRB) -> do !appl_4 <- kl_fail
                                                                                                                                                                                                                      !appl_5 <- appl_4 `pseq` (kl_Parse_shen_LBmultilineRB `pseq` eq appl_4 kl_Parse_shen_LBmultilineRB)
                                                                                                                                                                                                                      !kl_if_6 <- appl_5 `pseq` kl_not appl_5
                                                                                                                                                                                                                      case kl_if_6 of
                                                                                                                                                                                                                          Atom (B (True)) -> do !appl_7 <- kl_Parse_shen_LBmultilineRB `pseq` hd kl_Parse_shen_LBmultilineRB
                                                                                                                                                                                                                                                appl_7 `pseq` kl_shen_pair appl_7 (Types.Atom (Types.UnboundSym "shen.skip"))
                                                                                                                                                                                                                          Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                          _ -> throwError "if: expected boolean")))
                                                                                                                                   !appl_8 <- kl_V2354 `pseq` kl_shen_LBmultilineRB kl_V2354
                                                                                                                                   appl_8 `pseq` applyWrapper appl_3 [appl_8]
                                                                                                             Atom (B (False)) -> do do return kl_YaccParse
                                                                                                             _ -> throwError "if: expected boolean")))
                                     let !appl_9 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBsinglelineRB) -> do !appl_10 <- kl_fail
                                                                                                                         !appl_11 <- appl_10 `pseq` (kl_Parse_shen_LBsinglelineRB `pseq` eq appl_10 kl_Parse_shen_LBsinglelineRB)
                                                                                                                         !kl_if_12 <- appl_11 `pseq` kl_not appl_11
                                                                                                                         case kl_if_12 of
                                                                                                                             Atom (B (True)) -> do !appl_13 <- kl_Parse_shen_LBsinglelineRB `pseq` hd kl_Parse_shen_LBsinglelineRB
                                                                                                                                                   appl_13 `pseq` kl_shen_pair appl_13 (Types.Atom (Types.UnboundSym "shen.skip"))
                                                                                                                             Atom (B (False)) -> do do kl_fail
                                                                                                                             _ -> throwError "if: expected boolean")))
                                     !appl_14 <- kl_V2354 `pseq` kl_shen_LBsinglelineRB kl_V2354
                                     !appl_15 <- appl_14 `pseq` applyWrapper appl_9 [appl_14]
                                     appl_15 `pseq` applyWrapper appl_0 [appl_15]

kl_shen_LBsinglelineRB :: Types.KLValue ->
                          Types.KLContext Types.Env Types.KLValue
kl_shen_LBsinglelineRB (!kl_V2356) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBbackslashRB) -> do !appl_1 <- kl_fail
                                                                                                                           !appl_2 <- appl_1 `pseq` (kl_Parse_shen_LBbackslashRB `pseq` eq appl_1 kl_Parse_shen_LBbackslashRB)
                                                                                                                           !kl_if_3 <- appl_2 `pseq` kl_not appl_2
                                                                                                                           case kl_if_3 of
                                                                                                                               Atom (B (True)) -> do let !appl_4 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBbackslashRB) -> do !appl_5 <- kl_fail
                                                                                                                                                                                                                                        !appl_6 <- appl_5 `pseq` (kl_Parse_shen_LBbackslashRB `pseq` eq appl_5 kl_Parse_shen_LBbackslashRB)
                                                                                                                                                                                                                                        !kl_if_7 <- appl_6 `pseq` kl_not appl_6
                                                                                                                                                                                                                                        case kl_if_7 of
                                                                                                                                                                                                                                            Atom (B (True)) -> do let !appl_8 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBanysingleRB) -> do !appl_9 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                     !appl_10 <- appl_9 `pseq` (kl_Parse_shen_LBanysingleRB `pseq` eq appl_9 kl_Parse_shen_LBanysingleRB)
                                                                                                                                                                                                                                                                                                                                                     !kl_if_11 <- appl_10 `pseq` kl_not appl_10
                                                                                                                                                                                                                                                                                                                                                     case kl_if_11 of
                                                                                                                                                                                                                                                                                                                                                         Atom (B (True)) -> do let !appl_12 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBreturnRB) -> do !appl_13 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                !appl_14 <- appl_13 `pseq` (kl_Parse_shen_LBreturnRB `pseq` eq appl_13 kl_Parse_shen_LBreturnRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                !kl_if_15 <- appl_14 `pseq` kl_not appl_14
                                                                                                                                                                                                                                                                                                                                                                                                                                                                case kl_if_15 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Atom (B (True)) -> do !appl_16 <- kl_Parse_shen_LBreturnRB `pseq` hd kl_Parse_shen_LBreturnRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          appl_16 `pseq` kl_shen_pair appl_16 (Types.Atom (Types.UnboundSym "shen.skip"))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                               !appl_17 <- kl_Parse_shen_LBanysingleRB `pseq` kl_shen_LBreturnRB kl_Parse_shen_LBanysingleRB
                                                                                                                                                                                                                                                                                                                                                                               appl_17 `pseq` applyWrapper appl_12 [appl_17]
                                                                                                                                                                                                                                                                                                                                                         Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                         _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                  !appl_18 <- kl_Parse_shen_LBbackslashRB `pseq` kl_shen_LBanysingleRB kl_Parse_shen_LBbackslashRB
                                                                                                                                                                                                                                                                  appl_18 `pseq` applyWrapper appl_8 [appl_18]
                                                                                                                                                                                                                                            Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                            _ -> throwError "if: expected boolean")))
                                                                                                                                                     !appl_19 <- kl_Parse_shen_LBbackslashRB `pseq` kl_shen_LBbackslashRB kl_Parse_shen_LBbackslashRB
                                                                                                                                                     appl_19 `pseq` applyWrapper appl_4 [appl_19]
                                                                                                                               Atom (B (False)) -> do do kl_fail
                                                                                                                               _ -> throwError "if: expected boolean")))
                                        !appl_20 <- kl_V2356 `pseq` kl_shen_LBbackslashRB kl_V2356
                                        appl_20 `pseq` applyWrapper appl_0 [appl_20]

kl_shen_LBbackslashRB :: Types.KLValue ->
                         Types.KLContext Types.Env Types.KLValue
kl_shen_LBbackslashRB (!kl_V2358) = do !appl_0 <- kl_V2358 `pseq` hd kl_V2358
                                       !kl_if_1 <- appl_0 `pseq` consP appl_0
                                       !kl_if_2 <- case kl_if_1 of
                                                       Atom (B (True)) -> do !appl_3 <- kl_V2358 `pseq` hd kl_V2358
                                                                             !appl_4 <- appl_3 `pseq` hd appl_3
                                                                             !kl_if_5 <- appl_4 `pseq` eq (Types.Atom (Types.N (Types.KI 92))) appl_4
                                                                             case kl_if_5 of
                                                                                 Atom (B (True)) -> do return (Atom (B True))
                                                                                 Atom (B (False)) -> do do return (Atom (B False))
                                                                                 _ -> throwError "if: expected boolean"
                                                       Atom (B (False)) -> do do return (Atom (B False))
                                                       _ -> throwError "if: expected boolean"
                                       case kl_if_2 of
                                           Atom (B (True)) -> do !appl_6 <- kl_V2358 `pseq` hd kl_V2358
                                                                 !appl_7 <- appl_6 `pseq` tl appl_6
                                                                 !appl_8 <- kl_V2358 `pseq` kl_shen_hdtl kl_V2358
                                                                 !appl_9 <- appl_7 `pseq` (appl_8 `pseq` kl_shen_pair appl_7 appl_8)
                                                                 !appl_10 <- appl_9 `pseq` hd appl_9
                                                                 appl_10 `pseq` kl_shen_pair appl_10 (Types.Atom (Types.UnboundSym "shen.skip"))
                                           Atom (B (False)) -> do do kl_fail
                                           _ -> throwError "if: expected boolean"

kl_shen_LBanysingleRB :: Types.KLValue ->
                         Types.KLContext Types.Env Types.KLValue
kl_shen_LBanysingleRB (!kl_V2360) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_1 <- kl_fail
                                                                                                           !kl_if_2 <- kl_YaccParse `pseq` (appl_1 `pseq` eq kl_YaccParse appl_1)
                                                                                                           case kl_if_2 of
                                                                                                               Atom (B (True)) -> do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_Parse_LBeRB) -> do !appl_4 <- kl_fail
                                                                                                                                                                                                           !appl_5 <- appl_4 `pseq` (kl_Parse_LBeRB `pseq` eq appl_4 kl_Parse_LBeRB)
                                                                                                                                                                                                           !kl_if_6 <- appl_5 `pseq` kl_not appl_5
                                                                                                                                                                                                           case kl_if_6 of
                                                                                                                                                                                                               Atom (B (True)) -> do !appl_7 <- kl_Parse_LBeRB `pseq` hd kl_Parse_LBeRB
                                                                                                                                                                                                                                     appl_7 `pseq` kl_shen_pair appl_7 (Types.Atom (Types.UnboundSym "shen.skip"))
                                                                                                                                                                                                               Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                               _ -> throwError "if: expected boolean")))
                                                                                                                                     !appl_8 <- kl_V2360 `pseq` kl_LBeRB kl_V2360
                                                                                                                                     appl_8 `pseq` applyWrapper appl_3 [appl_8]
                                                                                                               Atom (B (False)) -> do do return kl_YaccParse
                                                                                                               _ -> throwError "if: expected boolean")))
                                       let !appl_9 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBnon_returnRB) -> do !appl_10 <- kl_fail
                                                                                                                           !appl_11 <- appl_10 `pseq` (kl_Parse_shen_LBnon_returnRB `pseq` eq appl_10 kl_Parse_shen_LBnon_returnRB)
                                                                                                                           !kl_if_12 <- appl_11 `pseq` kl_not appl_11
                                                                                                                           case kl_if_12 of
                                                                                                                               Atom (B (True)) -> do let !appl_13 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBanysingleRB) -> do !appl_14 <- kl_fail
                                                                                                                                                                                                                                         !appl_15 <- appl_14 `pseq` (kl_Parse_shen_LBanysingleRB `pseq` eq appl_14 kl_Parse_shen_LBanysingleRB)
                                                                                                                                                                                                                                         !kl_if_16 <- appl_15 `pseq` kl_not appl_15
                                                                                                                                                                                                                                         case kl_if_16 of
                                                                                                                                                                                                                                             Atom (B (True)) -> do !appl_17 <- kl_Parse_shen_LBanysingleRB `pseq` hd kl_Parse_shen_LBanysingleRB
                                                                                                                                                                                                                                                                   appl_17 `pseq` kl_shen_pair appl_17 (Types.Atom (Types.UnboundSym "shen.skip"))
                                                                                                                                                                                                                                             Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                             _ -> throwError "if: expected boolean")))
                                                                                                                                                     !appl_18 <- kl_Parse_shen_LBnon_returnRB `pseq` kl_shen_LBanysingleRB kl_Parse_shen_LBnon_returnRB
                                                                                                                                                     appl_18 `pseq` applyWrapper appl_13 [appl_18]
                                                                                                                               Atom (B (False)) -> do do kl_fail
                                                                                                                               _ -> throwError "if: expected boolean")))
                                       !appl_19 <- kl_V2360 `pseq` kl_shen_LBnon_returnRB kl_V2360
                                       !appl_20 <- appl_19 `pseq` applyWrapper appl_9 [appl_19]
                                       appl_20 `pseq` applyWrapper appl_0 [appl_20]

kl_shen_LBnon_returnRB :: Types.KLValue ->
                          Types.KLContext Types.Env Types.KLValue
kl_shen_LBnon_returnRB (!kl_V2362) = do !appl_0 <- kl_V2362 `pseq` hd kl_V2362
                                        !kl_if_1 <- appl_0 `pseq` consP appl_0
                                        case kl_if_1 of
                                            Atom (B (True)) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Parse_X) -> do !appl_3 <- klCons (Types.Atom (Types.N (Types.KI 13))) (Types.Atom Types.Nil)
                                                                                                                                    !appl_4 <- appl_3 `pseq` klCons (Types.Atom (Types.N (Types.KI 10))) appl_3
                                                                                                                                    !appl_5 <- kl_Parse_X `pseq` (appl_4 `pseq` kl_elementP kl_Parse_X appl_4)
                                                                                                                                    !kl_if_6 <- appl_5 `pseq` kl_not appl_5
                                                                                                                                    case kl_if_6 of
                                                                                                                                        Atom (B (True)) -> do !appl_7 <- kl_V2362 `pseq` hd kl_V2362
                                                                                                                                                              !appl_8 <- appl_7 `pseq` tl appl_7
                                                                                                                                                              !appl_9 <- kl_V2362 `pseq` kl_shen_hdtl kl_V2362
                                                                                                                                                              !appl_10 <- appl_8 `pseq` (appl_9 `pseq` kl_shen_pair appl_8 appl_9)
                                                                                                                                                              !appl_11 <- appl_10 `pseq` hd appl_10
                                                                                                                                                              appl_11 `pseq` kl_shen_pair appl_11 (Types.Atom (Types.UnboundSym "shen.skip"))
                                                                                                                                        Atom (B (False)) -> do do kl_fail
                                                                                                                                        _ -> throwError "if: expected boolean")))
                                                                  !appl_12 <- kl_V2362 `pseq` hd kl_V2362
                                                                  !appl_13 <- appl_12 `pseq` hd appl_12
                                                                  appl_13 `pseq` applyWrapper appl_2 [appl_13]
                                            Atom (B (False)) -> do do kl_fail
                                            _ -> throwError "if: expected boolean"

kl_shen_LBreturnRB :: Types.KLValue ->
                      Types.KLContext Types.Env Types.KLValue
kl_shen_LBreturnRB (!kl_V2364) = do !appl_0 <- kl_V2364 `pseq` hd kl_V2364
                                    !kl_if_1 <- appl_0 `pseq` consP appl_0
                                    case kl_if_1 of
                                        Atom (B (True)) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Parse_X) -> do !appl_3 <- klCons (Types.Atom (Types.N (Types.KI 13))) (Types.Atom Types.Nil)
                                                                                                                                !appl_4 <- appl_3 `pseq` klCons (Types.Atom (Types.N (Types.KI 10))) appl_3
                                                                                                                                !kl_if_5 <- kl_Parse_X `pseq` (appl_4 `pseq` kl_elementP kl_Parse_X appl_4)
                                                                                                                                case kl_if_5 of
                                                                                                                                    Atom (B (True)) -> do !appl_6 <- kl_V2364 `pseq` hd kl_V2364
                                                                                                                                                          !appl_7 <- appl_6 `pseq` tl appl_6
                                                                                                                                                          !appl_8 <- kl_V2364 `pseq` kl_shen_hdtl kl_V2364
                                                                                                                                                          !appl_9 <- appl_7 `pseq` (appl_8 `pseq` kl_shen_pair appl_7 appl_8)
                                                                                                                                                          !appl_10 <- appl_9 `pseq` hd appl_9
                                                                                                                                                          appl_10 `pseq` kl_shen_pair appl_10 (Types.Atom (Types.UnboundSym "shen.skip"))
                                                                                                                                    Atom (B (False)) -> do do kl_fail
                                                                                                                                    _ -> throwError "if: expected boolean")))
                                                              !appl_11 <- kl_V2364 `pseq` hd kl_V2364
                                                              !appl_12 <- appl_11 `pseq` hd appl_11
                                                              appl_12 `pseq` applyWrapper appl_2 [appl_12]
                                        Atom (B (False)) -> do do kl_fail
                                        _ -> throwError "if: expected boolean"

kl_shen_LBmultilineRB :: Types.KLValue ->
                         Types.KLContext Types.Env Types.KLValue
kl_shen_LBmultilineRB (!kl_V2366) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBbackslashRB) -> do !appl_1 <- kl_fail
                                                                                                                          !appl_2 <- appl_1 `pseq` (kl_Parse_shen_LBbackslashRB `pseq` eq appl_1 kl_Parse_shen_LBbackslashRB)
                                                                                                                          !kl_if_3 <- appl_2 `pseq` kl_not appl_2
                                                                                                                          case kl_if_3 of
                                                                                                                              Atom (B (True)) -> do let !appl_4 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBtimesRB) -> do !appl_5 <- kl_fail
                                                                                                                                                                                                                                   !appl_6 <- appl_5 `pseq` (kl_Parse_shen_LBtimesRB `pseq` eq appl_5 kl_Parse_shen_LBtimesRB)
                                                                                                                                                                                                                                   !kl_if_7 <- appl_6 `pseq` kl_not appl_6
                                                                                                                                                                                                                                   case kl_if_7 of
                                                                                                                                                                                                                                       Atom (B (True)) -> do let !appl_8 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBanymultiRB) -> do !appl_9 <- kl_fail
                                                                                                                                                                                                                                                                                                                                               !appl_10 <- appl_9 `pseq` (kl_Parse_shen_LBanymultiRB `pseq` eq appl_9 kl_Parse_shen_LBanymultiRB)
                                                                                                                                                                                                                                                                                                                                               !kl_if_11 <- appl_10 `pseq` kl_not appl_10
                                                                                                                                                                                                                                                                                                                                               case kl_if_11 of
                                                                                                                                                                                                                                                                                                                                                   Atom (B (True)) -> do !appl_12 <- kl_Parse_shen_LBanymultiRB `pseq` hd kl_Parse_shen_LBanymultiRB
                                                                                                                                                                                                                                                                                                                                                                         appl_12 `pseq` kl_shen_pair appl_12 (Types.Atom (Types.UnboundSym "shen.skip"))
                                                                                                                                                                                                                                                                                                                                                   Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                   _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                             !appl_13 <- kl_Parse_shen_LBtimesRB `pseq` kl_shen_LBanymultiRB kl_Parse_shen_LBtimesRB
                                                                                                                                                                                                                                                             appl_13 `pseq` applyWrapper appl_8 [appl_13]
                                                                                                                                                                                                                                       Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                       _ -> throwError "if: expected boolean")))
                                                                                                                                                    !appl_14 <- kl_Parse_shen_LBbackslashRB `pseq` kl_shen_LBtimesRB kl_Parse_shen_LBbackslashRB
                                                                                                                                                    appl_14 `pseq` applyWrapper appl_4 [appl_14]
                                                                                                                              Atom (B (False)) -> do do kl_fail
                                                                                                                              _ -> throwError "if: expected boolean")))
                                       !appl_15 <- kl_V2366 `pseq` kl_shen_LBbackslashRB kl_V2366
                                       appl_15 `pseq` applyWrapper appl_0 [appl_15]

kl_shen_LBtimesRB :: Types.KLValue ->
                     Types.KLContext Types.Env Types.KLValue
kl_shen_LBtimesRB (!kl_V2368) = do !appl_0 <- kl_V2368 `pseq` hd kl_V2368
                                   !kl_if_1 <- appl_0 `pseq` consP appl_0
                                   !kl_if_2 <- case kl_if_1 of
                                                   Atom (B (True)) -> do !appl_3 <- kl_V2368 `pseq` hd kl_V2368
                                                                         !appl_4 <- appl_3 `pseq` hd appl_3
                                                                         !kl_if_5 <- appl_4 `pseq` eq (Types.Atom (Types.N (Types.KI 42))) appl_4
                                                                         case kl_if_5 of
                                                                             Atom (B (True)) -> do return (Atom (B True))
                                                                             Atom (B (False)) -> do do return (Atom (B False))
                                                                             _ -> throwError "if: expected boolean"
                                                   Atom (B (False)) -> do do return (Atom (B False))
                                                   _ -> throwError "if: expected boolean"
                                   case kl_if_2 of
                                       Atom (B (True)) -> do !appl_6 <- kl_V2368 `pseq` hd kl_V2368
                                                             !appl_7 <- appl_6 `pseq` tl appl_6
                                                             !appl_8 <- kl_V2368 `pseq` kl_shen_hdtl kl_V2368
                                                             !appl_9 <- appl_7 `pseq` (appl_8 `pseq` kl_shen_pair appl_7 appl_8)
                                                             !appl_10 <- appl_9 `pseq` hd appl_9
                                                             appl_10 `pseq` kl_shen_pair appl_10 (Types.Atom (Types.UnboundSym "shen.skip"))
                                       Atom (B (False)) -> do do kl_fail
                                       _ -> throwError "if: expected boolean"

kl_shen_LBanymultiRB :: Types.KLValue ->
                        Types.KLContext Types.Env Types.KLValue
kl_shen_LBanymultiRB (!kl_V2370) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_1 <- kl_fail
                                                                                                          !kl_if_2 <- kl_YaccParse `pseq` (appl_1 `pseq` eq kl_YaccParse appl_1)
                                                                                                          case kl_if_2 of
                                                                                                              Atom (B (True)) -> do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_4 <- kl_fail
                                                                                                                                                                                                        !kl_if_5 <- kl_YaccParse `pseq` (appl_4 `pseq` eq kl_YaccParse appl_4)
                                                                                                                                                                                                        case kl_if_5 of
                                                                                                                                                                                                            Atom (B (True)) -> do !appl_6 <- kl_V2370 `pseq` hd kl_V2370
                                                                                                                                                                                                                                  !kl_if_7 <- appl_6 `pseq` consP appl_6
                                                                                                                                                                                                                                  case kl_if_7 of
                                                                                                                                                                                                                                      Atom (B (True)) -> do let !appl_8 = ApplC (Func "lambda" (Context (\(!kl_Parse_X) -> do let !appl_9 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBanymultiRB) -> do !appl_10 <- kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                !appl_11 <- appl_10 `pseq` (kl_Parse_shen_LBanymultiRB `pseq` eq appl_10 kl_Parse_shen_LBanymultiRB)
                                                                                                                                                                                                                                                                                                                                                                                                                !kl_if_12 <- appl_11 `pseq` kl_not appl_11
                                                                                                                                                                                                                                                                                                                                                                                                                case kl_if_12 of
                                                                                                                                                                                                                                                                                                                                                                                                                    Atom (B (True)) -> do !appl_13 <- kl_Parse_shen_LBanymultiRB `pseq` hd kl_Parse_shen_LBanymultiRB
                                                                                                                                                                                                                                                                                                                                                                                                                                          appl_13 `pseq` kl_shen_pair appl_13 (Types.Atom (Types.UnboundSym "shen.skip"))
                                                                                                                                                                                                                                                                                                                                                                                                                    Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                                                                                                    _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                              !appl_14 <- kl_V2370 `pseq` hd kl_V2370
                                                                                                                                                                                                                                                                                                                              !appl_15 <- appl_14 `pseq` tl appl_14
                                                                                                                                                                                                                                                                                                                              !appl_16 <- kl_V2370 `pseq` kl_shen_hdtl kl_V2370
                                                                                                                                                                                                                                                                                                                              !appl_17 <- appl_15 `pseq` (appl_16 `pseq` kl_shen_pair appl_15 appl_16)
                                                                                                                                                                                                                                                                                                                              !appl_18 <- appl_17 `pseq` kl_shen_LBanymultiRB appl_17
                                                                                                                                                                                                                                                                                                                              appl_18 `pseq` applyWrapper appl_9 [appl_18])))
                                                                                                                                                                                                                                                            !appl_19 <- kl_V2370 `pseq` hd kl_V2370
                                                                                                                                                                                                                                                            !appl_20 <- appl_19 `pseq` hd appl_19
                                                                                                                                                                                                                                                            appl_20 `pseq` applyWrapper appl_8 [appl_20]
                                                                                                                                                                                                                                      Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                      _ -> throwError "if: expected boolean"
                                                                                                                                                                                                            Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                                                                                                            _ -> throwError "if: expected boolean")))
                                                                                                                                    let !appl_21 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBtimesRB) -> do !appl_22 <- kl_fail
                                                                                                                                                                                                                    !appl_23 <- appl_22 `pseq` (kl_Parse_shen_LBtimesRB `pseq` eq appl_22 kl_Parse_shen_LBtimesRB)
                                                                                                                                                                                                                    !kl_if_24 <- appl_23 `pseq` kl_not appl_23
                                                                                                                                                                                                                    case kl_if_24 of
                                                                                                                                                                                                                        Atom (B (True)) -> do let !appl_25 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBbackslashRB) -> do !appl_26 <- kl_fail
                                                                                                                                                                                                                                                                                                                                  !appl_27 <- appl_26 `pseq` (kl_Parse_shen_LBbackslashRB `pseq` eq appl_26 kl_Parse_shen_LBbackslashRB)
                                                                                                                                                                                                                                                                                                                                  !kl_if_28 <- appl_27 `pseq` kl_not appl_27
                                                                                                                                                                                                                                                                                                                                  case kl_if_28 of
                                                                                                                                                                                                                                                                                                                                      Atom (B (True)) -> do !appl_29 <- kl_Parse_shen_LBbackslashRB `pseq` hd kl_Parse_shen_LBbackslashRB
                                                                                                                                                                                                                                                                                                                                                            appl_29 `pseq` kl_shen_pair appl_29 (Types.Atom (Types.UnboundSym "shen.skip"))
                                                                                                                                                                                                                                                                                                                                      Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                                                                                                      _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                              !appl_30 <- kl_Parse_shen_LBtimesRB `pseq` kl_shen_LBbackslashRB kl_Parse_shen_LBtimesRB
                                                                                                                                                                                                                                              appl_30 `pseq` applyWrapper appl_25 [appl_30]
                                                                                                                                                                                                                        Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                        _ -> throwError "if: expected boolean")))
                                                                                                                                    !appl_31 <- kl_V2370 `pseq` kl_shen_LBtimesRB kl_V2370
                                                                                                                                    !appl_32 <- appl_31 `pseq` applyWrapper appl_21 [appl_31]
                                                                                                                                    appl_32 `pseq` applyWrapper appl_3 [appl_32]
                                                                                                              Atom (B (False)) -> do do return kl_YaccParse
                                                                                                              _ -> throwError "if: expected boolean")))
                                      let !appl_33 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBcommentRB) -> do !appl_34 <- kl_fail
                                                                                                                        !appl_35 <- appl_34 `pseq` (kl_Parse_shen_LBcommentRB `pseq` eq appl_34 kl_Parse_shen_LBcommentRB)
                                                                                                                        !kl_if_36 <- appl_35 `pseq` kl_not appl_35
                                                                                                                        case kl_if_36 of
                                                                                                                            Atom (B (True)) -> do let !appl_37 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBanymultiRB) -> do !appl_38 <- kl_fail
                                                                                                                                                                                                                                     !appl_39 <- appl_38 `pseq` (kl_Parse_shen_LBanymultiRB `pseq` eq appl_38 kl_Parse_shen_LBanymultiRB)
                                                                                                                                                                                                                                     !kl_if_40 <- appl_39 `pseq` kl_not appl_39
                                                                                                                                                                                                                                     case kl_if_40 of
                                                                                                                                                                                                                                         Atom (B (True)) -> do !appl_41 <- kl_Parse_shen_LBanymultiRB `pseq` hd kl_Parse_shen_LBanymultiRB
                                                                                                                                                                                                                                                               appl_41 `pseq` kl_shen_pair appl_41 (Types.Atom (Types.UnboundSym "shen.skip"))
                                                                                                                                                                                                                                         Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                         _ -> throwError "if: expected boolean")))
                                                                                                                                                  !appl_42 <- kl_Parse_shen_LBcommentRB `pseq` kl_shen_LBanymultiRB kl_Parse_shen_LBcommentRB
                                                                                                                                                  appl_42 `pseq` applyWrapper appl_37 [appl_42]
                                                                                                                            Atom (B (False)) -> do do kl_fail
                                                                                                                            _ -> throwError "if: expected boolean")))
                                      !appl_43 <- kl_V2370 `pseq` kl_shen_LBcommentRB kl_V2370
                                      !appl_44 <- appl_43 `pseq` applyWrapper appl_33 [appl_43]
                                      appl_44 `pseq` applyWrapper appl_0 [appl_44]

kl_shen_LBwhitespacesRB :: Types.KLValue ->
                           Types.KLContext Types.Env Types.KLValue
kl_shen_LBwhitespacesRB (!kl_V2372) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do !appl_1 <- kl_fail
                                                                                                             !kl_if_2 <- kl_YaccParse `pseq` (appl_1 `pseq` eq kl_YaccParse appl_1)
                                                                                                             case kl_if_2 of
                                                                                                                 Atom (B (True)) -> do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBwhitespaceRB) -> do !appl_4 <- kl_fail
                                                                                                                                                                                                                           !appl_5 <- appl_4 `pseq` (kl_Parse_shen_LBwhitespaceRB `pseq` eq appl_4 kl_Parse_shen_LBwhitespaceRB)
                                                                                                                                                                                                                           !kl_if_6 <- appl_5 `pseq` kl_not appl_5
                                                                                                                                                                                                                           case kl_if_6 of
                                                                                                                                                                                                                               Atom (B (True)) -> do !appl_7 <- kl_Parse_shen_LBwhitespaceRB `pseq` hd kl_Parse_shen_LBwhitespaceRB
                                                                                                                                                                                                                                                     appl_7 `pseq` kl_shen_pair appl_7 (Types.Atom (Types.UnboundSym "shen.skip"))
                                                                                                                                                                                                                               Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                               _ -> throwError "if: expected boolean")))
                                                                                                                                       !appl_8 <- kl_V2372 `pseq` kl_shen_LBwhitespaceRB kl_V2372
                                                                                                                                       appl_8 `pseq` applyWrapper appl_3 [appl_8]
                                                                                                                 Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                 _ -> throwError "if: expected boolean")))
                                         let !appl_9 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBwhitespaceRB) -> do !appl_10 <- kl_fail
                                                                                                                             !appl_11 <- appl_10 `pseq` (kl_Parse_shen_LBwhitespaceRB `pseq` eq appl_10 kl_Parse_shen_LBwhitespaceRB)
                                                                                                                             !kl_if_12 <- appl_11 `pseq` kl_not appl_11
                                                                                                                             case kl_if_12 of
                                                                                                                                 Atom (B (True)) -> do let !appl_13 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBwhitespacesRB) -> do !appl_14 <- kl_fail
                                                                                                                                                                                                                                             !appl_15 <- appl_14 `pseq` (kl_Parse_shen_LBwhitespacesRB `pseq` eq appl_14 kl_Parse_shen_LBwhitespacesRB)
                                                                                                                                                                                                                                             !kl_if_16 <- appl_15 `pseq` kl_not appl_15
                                                                                                                                                                                                                                             case kl_if_16 of
                                                                                                                                                                                                                                                 Atom (B (True)) -> do !appl_17 <- kl_Parse_shen_LBwhitespacesRB `pseq` hd kl_Parse_shen_LBwhitespacesRB
                                                                                                                                                                                                                                                                       appl_17 `pseq` kl_shen_pair appl_17 (Types.Atom (Types.UnboundSym "shen.skip"))
                                                                                                                                                                                                                                                 Atom (B (False)) -> do do kl_fail
                                                                                                                                                                                                                                                 _ -> throwError "if: expected boolean")))
                                                                                                                                                       !appl_18 <- kl_Parse_shen_LBwhitespaceRB `pseq` kl_shen_LBwhitespacesRB kl_Parse_shen_LBwhitespaceRB
                                                                                                                                                       appl_18 `pseq` applyWrapper appl_13 [appl_18]
                                                                                                                                 Atom (B (False)) -> do do kl_fail
                                                                                                                                 _ -> throwError "if: expected boolean")))
                                         !appl_19 <- kl_V2372 `pseq` kl_shen_LBwhitespaceRB kl_V2372
                                         !appl_20 <- appl_19 `pseq` applyWrapper appl_9 [appl_19]
                                         appl_20 `pseq` applyWrapper appl_0 [appl_20]

kl_shen_LBwhitespaceRB :: Types.KLValue ->
                          Types.KLContext Types.Env Types.KLValue
kl_shen_LBwhitespaceRB (!kl_V2374) = do !appl_0 <- kl_V2374 `pseq` hd kl_V2374
                                        !kl_if_1 <- appl_0 `pseq` consP appl_0
                                        case kl_if_1 of
                                            Atom (B (True)) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Parse_X) -> do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_Parse_Case) -> do let pat_cond_4 = do return (Atom (B True))
                                                                                                                                                                                                             pat_cond_5 = do do !kl_if_6 <- let pat_cond_7 = do return (Atom (B True))
                                                                                                                                                                                                                                                pat_cond_8 = do do !kl_if_9 <- let pat_cond_10 = do return (Atom (B True))
                                                                                                                                                                                                                                                                                   pat_cond_11 = do do let pat_cond_12 = do return (Atom (B True))
                                                                                                                                                                                                                                                                                                           pat_cond_13 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                        in case kl_Parse_Case of
                                                                                                                                                                                                                                                                                                               kl_Parse_Case@(Atom (N (KI 9))) -> pat_cond_12
                                                                                                                                                                                                                                                                                                               _ -> pat_cond_13
                                                                                                                                                                                                                                                                                in case kl_Parse_Case of
                                                                                                                                                                                                                                                                                       kl_Parse_Case@(Atom (N (KI 10))) -> pat_cond_10
                                                                                                                                                                                                                                                                                       _ -> pat_cond_11
                                                                                                                                                                                                                                                                   case kl_if_9 of
                                                                                                                                                                                                                                                                       Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                       Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                       _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                             in case kl_Parse_Case of
                                                                                                                                                                                                                                                    kl_Parse_Case@(Atom (N (KI 13))) -> pat_cond_7
                                                                                                                                                                                                                                                    _ -> pat_cond_8
                                                                                                                                                                                                                                case kl_if_6 of
                                                                                                                                                                                                                                    Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                    Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                    _ -> throwError "if: expected boolean"
                                                                                                                                                                                                          in case kl_Parse_Case of
                                                                                                                                                                                                                 kl_Parse_Case@(Atom (N (KI 32))) -> pat_cond_4
                                                                                                                                                                                                                 _ -> pat_cond_5)))
                                                                                                                                    !kl_if_14 <- kl_Parse_X `pseq` applyWrapper appl_3 [kl_Parse_X]
                                                                                                                                    case kl_if_14 of
                                                                                                                                        Atom (B (True)) -> do !appl_15 <- kl_V2374 `pseq` hd kl_V2374
                                                                                                                                                              !appl_16 <- appl_15 `pseq` tl appl_15
                                                                                                                                                              !appl_17 <- kl_V2374 `pseq` kl_shen_hdtl kl_V2374
                                                                                                                                                              !appl_18 <- appl_16 `pseq` (appl_17 `pseq` kl_shen_pair appl_16 appl_17)
                                                                                                                                                              !appl_19 <- appl_18 `pseq` hd appl_18
                                                                                                                                                              appl_19 `pseq` kl_shen_pair appl_19 (Types.Atom (Types.UnboundSym "shen.skip"))
                                                                                                                                        Atom (B (False)) -> do do kl_fail
                                                                                                                                        _ -> throwError "if: expected boolean")))
                                                                  !appl_20 <- kl_V2374 `pseq` hd kl_V2374
                                                                  !appl_21 <- appl_20 `pseq` hd appl_20
                                                                  appl_21 `pseq` applyWrapper appl_2 [appl_21]
                                            Atom (B (False)) -> do do kl_fail
                                            _ -> throwError "if: expected boolean"

kl_shen_cons_form :: Types.KLValue ->
                     Types.KLContext Types.Env Types.KLValue
kl_shen_cons_form (!kl_V2376) = do let pat_cond_0 = do return (Types.Atom Types.Nil)
                                       pat_cond_1 kl_V2376 kl_V2376h kl_V2376t kl_V2376tt kl_V2376tth = do !appl_2 <- kl_V2376h `pseq` (kl_V2376tt `pseq` klCons kl_V2376h kl_V2376tt)
                                                                                                           appl_2 `pseq` klCons (ApplC (wrapNamed "cons" klCons)) appl_2
                                       pat_cond_3 kl_V2376 kl_V2376h kl_V2376t = do !appl_4 <- kl_V2376t `pseq` kl_shen_cons_form kl_V2376t
                                                                                    !appl_5 <- appl_4 `pseq` klCons appl_4 (Types.Atom Types.Nil)
                                                                                    !appl_6 <- kl_V2376h `pseq` (appl_5 `pseq` klCons kl_V2376h appl_5)
                                                                                    appl_6 `pseq` klCons (ApplC (wrapNamed "cons" klCons)) appl_6
                                       pat_cond_7 = do do let !aw_8 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                          applyWrapper aw_8 [ApplC (wrapNamed "shen.cons_form" kl_shen_cons_form)]
                                    in case kl_V2376 of
                                           kl_V2376@(Atom (Nil)) -> pat_cond_0
                                           !(kl_V2376@(Cons (!kl_V2376h)
                                                            (!(kl_V2376t@(Cons (Atom (UnboundSym "bar!"))
                                                                               (!(kl_V2376tt@(Cons (!kl_V2376tth)
                                                                                                   (Atom (Nil)))))))))) -> pat_cond_1 kl_V2376 kl_V2376h kl_V2376t kl_V2376tt kl_V2376tth
                                           !(kl_V2376@(Cons (!kl_V2376h)
                                                            (!(kl_V2376t@(Cons (ApplC (PL "bar!" _))
                                                                               (!(kl_V2376tt@(Cons (!kl_V2376tth)
                                                                                                   (Atom (Nil)))))))))) -> pat_cond_1 kl_V2376 kl_V2376h kl_V2376t kl_V2376tt kl_V2376tth
                                           !(kl_V2376@(Cons (!kl_V2376h)
                                                            (!(kl_V2376t@(Cons (ApplC (Func "bar!"
                                                                                            _))
                                                                               (!(kl_V2376tt@(Cons (!kl_V2376tth)
                                                                                                   (Atom (Nil)))))))))) -> pat_cond_1 kl_V2376 kl_V2376h kl_V2376t kl_V2376tt kl_V2376tth
                                           !(kl_V2376@(Cons (!kl_V2376h)
                                                            (!kl_V2376t))) -> pat_cond_3 kl_V2376 kl_V2376h kl_V2376t
                                           _ -> pat_cond_7

kl_shen_package_macro :: Types.KLValue ->
                         Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_package_macro (!kl_V2381) (!kl_V2382) = do let pat_cond_0 kl_V2381 kl_V2381t kl_V2381th = do !appl_1 <- kl_V2381th `pseq` kl_explode kl_V2381th
                                                                                                     appl_1 `pseq` (kl_V2382 `pseq` kl_append appl_1 kl_V2382)
                                                       pat_cond_2 kl_V2381 kl_V2381t kl_V2381tt kl_V2381tth kl_V2381ttt = do kl_V2381ttt `pseq` (kl_V2382 `pseq` kl_append kl_V2381ttt kl_V2382)
                                                       pat_cond_3 kl_V2381 kl_V2381t kl_V2381th kl_V2381tt kl_V2381tth kl_V2381ttt = do let !appl_4 = ApplC (Func "lambda" (Context (\(!kl_ListofExceptions) -> do let !appl_5 = ApplC (Func "lambda" (Context (\(!kl_External) -> do let !appl_6 = ApplC (Func "lambda" (Context (\(!kl_PackageNameDot) -> do let !appl_7 = ApplC (Func "lambda" (Context (\(!kl_ExpPackageName) -> do let !appl_8 = ApplC (Func "lambda" (Context (\(!kl_Packaged) -> do let !appl_9 = ApplC (Func "lambda" (Context (\(!kl_Internal) -> do kl_Packaged `pseq` (kl_V2382 `pseq` kl_append kl_Packaged kl_V2382))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           !appl_10 <- kl_ExpPackageName `pseq` (kl_Packaged `pseq` kl_shen_internal_symbols kl_ExpPackageName kl_Packaged)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           !appl_11 <- kl_V2381th `pseq` (appl_10 `pseq` kl_shen_record_internal kl_V2381th appl_10)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           appl_11 `pseq` applyWrapper appl_9 [appl_11])))
                                                                                                                                                                                                                                                                                                                                                                                                                                        !appl_12 <- kl_PackageNameDot `pseq` (kl_ListofExceptions `pseq` (kl_V2381ttt `pseq` (kl_ExpPackageName `pseq` kl_shen_packageh kl_PackageNameDot kl_ListofExceptions kl_V2381ttt kl_ExpPackageName)))
                                                                                                                                                                                                                                                                                                                                                                                                                                        appl_12 `pseq` applyWrapper appl_8 [appl_12])))
                                                                                                                                                                                                                                                                                                                                                               !appl_13 <- kl_V2381th `pseq` kl_explode kl_V2381th
                                                                                                                                                                                                                                                                                                                                                               appl_13 `pseq` applyWrapper appl_7 [appl_13])))
                                                                                                                                                                                                                                                                                      !appl_14 <- kl_V2381th `pseq` str kl_V2381th
                                                                                                                                                                                                                                                                                      !appl_15 <- appl_14 `pseq` cn appl_14 (Types.Atom (Types.Str "."))
                                                                                                                                                                                                                                                                                      !appl_16 <- appl_15 `pseq` intern appl_15
                                                                                                                                                                                                                                                                                      appl_16 `pseq` applyWrapper appl_6 [appl_16])))
                                                                                                                                                                                                                   !appl_17 <- kl_ListofExceptions `pseq` (kl_V2381th `pseq` kl_shen_record_exceptions kl_ListofExceptions kl_V2381th)
                                                                                                                                                                                                                   appl_17 `pseq` applyWrapper appl_5 [appl_17])))
                                                                                                                                        !appl_18 <- kl_V2381tth `pseq` kl_shen_eval_without_macros kl_V2381tth
                                                                                                                                        appl_18 `pseq` applyWrapper appl_4 [appl_18]
                                                       pat_cond_19 = do do kl_V2381 `pseq` (kl_V2382 `pseq` klCons kl_V2381 kl_V2382)
                                                    in case kl_V2381 of
                                                           !(kl_V2381@(Cons (Atom (UnboundSym "$"))
                                                                            (!(kl_V2381t@(Cons (!kl_V2381th)
                                                                                               (Atom (Nil))))))) -> pat_cond_0 kl_V2381 kl_V2381t kl_V2381th
                                                           !(kl_V2381@(Cons (ApplC (PL "$" _))
                                                                            (!(kl_V2381t@(Cons (!kl_V2381th)
                                                                                               (Atom (Nil))))))) -> pat_cond_0 kl_V2381 kl_V2381t kl_V2381th
                                                           !(kl_V2381@(Cons (ApplC (Func "$" _))
                                                                            (!(kl_V2381t@(Cons (!kl_V2381th)
                                                                                               (Atom (Nil))))))) -> pat_cond_0 kl_V2381 kl_V2381t kl_V2381th
                                                           !(kl_V2381@(Cons (Atom (UnboundSym "package"))
                                                                            (!(kl_V2381t@(Cons (Atom (UnboundSym "null"))
                                                                                               (!(kl_V2381tt@(Cons (!kl_V2381tth)
                                                                                                                   (!kl_V2381ttt))))))))) -> pat_cond_2 kl_V2381 kl_V2381t kl_V2381tt kl_V2381tth kl_V2381ttt
                                                           !(kl_V2381@(Cons (Atom (UnboundSym "package"))
                                                                            (!(kl_V2381t@(Cons (ApplC (PL "null"
                                                                                                          _))
                                                                                               (!(kl_V2381tt@(Cons (!kl_V2381tth)
                                                                                                                   (!kl_V2381ttt))))))))) -> pat_cond_2 kl_V2381 kl_V2381t kl_V2381tt kl_V2381tth kl_V2381ttt
                                                           !(kl_V2381@(Cons (Atom (UnboundSym "package"))
                                                                            (!(kl_V2381t@(Cons (ApplC (Func "null"
                                                                                                            _))
                                                                                               (!(kl_V2381tt@(Cons (!kl_V2381tth)
                                                                                                                   (!kl_V2381ttt))))))))) -> pat_cond_2 kl_V2381 kl_V2381t kl_V2381tt kl_V2381tth kl_V2381ttt
                                                           !(kl_V2381@(Cons (ApplC (PL "package" _))
                                                                            (!(kl_V2381t@(Cons (Atom (UnboundSym "null"))
                                                                                               (!(kl_V2381tt@(Cons (!kl_V2381tth)
                                                                                                                   (!kl_V2381ttt))))))))) -> pat_cond_2 kl_V2381 kl_V2381t kl_V2381tt kl_V2381tth kl_V2381ttt
                                                           !(kl_V2381@(Cons (ApplC (PL "package" _))
                                                                            (!(kl_V2381t@(Cons (ApplC (PL "null"
                                                                                                          _))
                                                                                               (!(kl_V2381tt@(Cons (!kl_V2381tth)
                                                                                                                   (!kl_V2381ttt))))))))) -> pat_cond_2 kl_V2381 kl_V2381t kl_V2381tt kl_V2381tth kl_V2381ttt
                                                           !(kl_V2381@(Cons (ApplC (PL "package" _))
                                                                            (!(kl_V2381t@(Cons (ApplC (Func "null"
                                                                                                            _))
                                                                                               (!(kl_V2381tt@(Cons (!kl_V2381tth)
                                                                                                                   (!kl_V2381ttt))))))))) -> pat_cond_2 kl_V2381 kl_V2381t kl_V2381tt kl_V2381tth kl_V2381ttt
                                                           !(kl_V2381@(Cons (ApplC (Func "package"
                                                                                         _))
                                                                            (!(kl_V2381t@(Cons (Atom (UnboundSym "null"))
                                                                                               (!(kl_V2381tt@(Cons (!kl_V2381tth)
                                                                                                                   (!kl_V2381ttt))))))))) -> pat_cond_2 kl_V2381 kl_V2381t kl_V2381tt kl_V2381tth kl_V2381ttt
                                                           !(kl_V2381@(Cons (ApplC (Func "package"
                                                                                         _))
                                                                            (!(kl_V2381t@(Cons (ApplC (PL "null"
                                                                                                          _))
                                                                                               (!(kl_V2381tt@(Cons (!kl_V2381tth)
                                                                                                                   (!kl_V2381ttt))))))))) -> pat_cond_2 kl_V2381 kl_V2381t kl_V2381tt kl_V2381tth kl_V2381ttt
                                                           !(kl_V2381@(Cons (ApplC (Func "package"
                                                                                         _))
                                                                            (!(kl_V2381t@(Cons (ApplC (Func "null"
                                                                                                            _))
                                                                                               (!(kl_V2381tt@(Cons (!kl_V2381tth)
                                                                                                                   (!kl_V2381ttt))))))))) -> pat_cond_2 kl_V2381 kl_V2381t kl_V2381tt kl_V2381tth kl_V2381ttt
                                                           !(kl_V2381@(Cons (Atom (UnboundSym "package"))
                                                                            (!(kl_V2381t@(Cons (!kl_V2381th)
                                                                                               (!(kl_V2381tt@(Cons (!kl_V2381tth)
                                                                                                                   (!kl_V2381ttt))))))))) -> pat_cond_3 kl_V2381 kl_V2381t kl_V2381th kl_V2381tt kl_V2381tth kl_V2381ttt
                                                           !(kl_V2381@(Cons (ApplC (PL "package" _))
                                                                            (!(kl_V2381t@(Cons (!kl_V2381th)
                                                                                               (!(kl_V2381tt@(Cons (!kl_V2381tth)
                                                                                                                   (!kl_V2381ttt))))))))) -> pat_cond_3 kl_V2381 kl_V2381t kl_V2381th kl_V2381tt kl_V2381tth kl_V2381ttt
                                                           !(kl_V2381@(Cons (ApplC (Func "package"
                                                                                         _))
                                                                            (!(kl_V2381t@(Cons (!kl_V2381th)
                                                                                               (!(kl_V2381tt@(Cons (!kl_V2381tth)
                                                                                                                   (!kl_V2381ttt))))))))) -> pat_cond_3 kl_V2381 kl_V2381t kl_V2381th kl_V2381tt kl_V2381tth kl_V2381ttt
                                                           _ -> pat_cond_19

kl_shen_record_exceptions :: Types.KLValue ->
                             Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_record_exceptions (!kl_V2385) (!kl_V2386) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_CurrExceptions) -> do let !appl_1 = ApplC (Func "lambda" (Context (\(!kl_AllExceptions) -> do !appl_2 <- value (Types.Atom (Types.UnboundSym "*property-vector*"))
                                                                                                                                                                                                        kl_V2386 `pseq` (kl_AllExceptions `pseq` (appl_2 `pseq` kl_put kl_V2386 (Types.Atom (Types.UnboundSym "shen.external-symbols")) kl_AllExceptions appl_2)))))
                                                                                                                                !appl_3 <- kl_V2385 `pseq` (kl_CurrExceptions `pseq` kl_union kl_V2385 kl_CurrExceptions)
                                                                                                                                appl_3 `pseq` applyWrapper appl_1 [appl_3])))
                                                       !appl_4 <- (do !appl_5 <- value (Types.Atom (Types.UnboundSym "*property-vector*"))
                                                                      kl_V2386 `pseq` (appl_5 `pseq` kl_get kl_V2386 (Types.Atom (Types.UnboundSym "shen.external-symbols")) appl_5)) `catchError` (\(!kl_E) -> do return (Types.Atom Types.Nil))
                                                       appl_4 `pseq` applyWrapper appl_0 [appl_4]

kl_shen_record_internal :: Types.KLValue ->
                           Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_record_internal (!kl_V2389) (!kl_V2390) = do !appl_0 <- (do !appl_1 <- value (Types.Atom (Types.UnboundSym "*property-vector*"))
                                                                    kl_V2389 `pseq` (appl_1 `pseq` kl_get kl_V2389 (ApplC (wrapNamed "shen.internal-symbols" kl_shen_internal_symbols)) appl_1)) `catchError` (\(!kl_E) -> do return (Types.Atom Types.Nil))
                                                     !appl_2 <- kl_V2390 `pseq` (appl_0 `pseq` kl_union kl_V2390 appl_0)
                                                     !appl_3 <- value (Types.Atom (Types.UnboundSym "*property-vector*"))
                                                     kl_V2389 `pseq` (appl_2 `pseq` (appl_3 `pseq` kl_put kl_V2389 (ApplC (wrapNamed "shen.internal-symbols" kl_shen_internal_symbols)) appl_2 appl_3))

kl_shen_internal_symbols :: Types.KLValue ->
                            Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_internal_symbols (!kl_V2401) (!kl_V2402) = do !kl_if_0 <- kl_V2402 `pseq` kl_symbolP kl_V2402
                                                      !kl_if_1 <- case kl_if_0 of
                                                                      Atom (B (True)) -> do !appl_2 <- kl_V2402 `pseq` kl_explode kl_V2402
                                                                                            !kl_if_3 <- kl_V2401 `pseq` (appl_2 `pseq` kl_shen_prefixP kl_V2401 appl_2)
                                                                                            case kl_if_3 of
                                                                                                Atom (B (True)) -> do return (Atom (B True))
                                                                                                Atom (B (False)) -> do do return (Atom (B False))
                                                                                                _ -> throwError "if: expected boolean"
                                                                      Atom (B (False)) -> do do return (Atom (B False))
                                                                      _ -> throwError "if: expected boolean"
                                                      case kl_if_1 of
                                                          Atom (B (True)) -> do kl_V2402 `pseq` klCons kl_V2402 (Types.Atom Types.Nil)
                                                          Atom (B (False)) -> do let pat_cond_4 kl_V2402 kl_V2402h kl_V2402t = do !appl_5 <- kl_V2401 `pseq` (kl_V2402h `pseq` kl_shen_internal_symbols kl_V2401 kl_V2402h)
                                                                                                                                  !appl_6 <- kl_V2401 `pseq` (kl_V2402t `pseq` kl_shen_internal_symbols kl_V2401 kl_V2402t)
                                                                                                                                  appl_5 `pseq` (appl_6 `pseq` kl_union appl_5 appl_6)
                                                                                     pat_cond_7 = do do return (Types.Atom Types.Nil)
                                                                                  in case kl_V2402 of
                                                                                         !(kl_V2402@(Cons (!kl_V2402h)
                                                                                                          (!kl_V2402t))) -> pat_cond_4 kl_V2402 kl_V2402h kl_V2402t
                                                                                         _ -> pat_cond_7
                                                          _ -> throwError "if: expected boolean"

kl_shen_packageh :: Types.KLValue ->
                    Types.KLValue ->
                    Types.KLValue ->
                    Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_packageh (!kl_V2419) (!kl_V2420) (!kl_V2421) (!kl_V2422) = do let pat_cond_0 kl_V2421 kl_V2421h kl_V2421t = do !appl_1 <- kl_V2419 `pseq` (kl_V2420 `pseq` (kl_V2421h `pseq` (kl_V2422 `pseq` kl_shen_packageh kl_V2419 kl_V2420 kl_V2421h kl_V2422)))
                                                                                                                       !appl_2 <- kl_V2419 `pseq` (kl_V2420 `pseq` (kl_V2421t `pseq` (kl_V2422 `pseq` kl_shen_packageh kl_V2419 kl_V2420 kl_V2421t kl_V2422)))
                                                                                                                       appl_1 `pseq` (appl_2 `pseq` klCons appl_1 appl_2)
                                                                          pat_cond_3 = do !kl_if_4 <- kl_V2421 `pseq` kl_shen_sysfuncP kl_V2421
                                                                                          !kl_if_5 <- case kl_if_4 of
                                                                                                          Atom (B (True)) -> do return (Atom (B True))
                                                                                                          Atom (B (False)) -> do do !kl_if_6 <- kl_V2421 `pseq` kl_variableP kl_V2421
                                                                                                                                    !kl_if_7 <- case kl_if_6 of
                                                                                                                                                    Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                    Atom (B (False)) -> do do !kl_if_8 <- kl_V2421 `pseq` (kl_V2420 `pseq` kl_elementP kl_V2421 kl_V2420)
                                                                                                                                                                              !kl_if_9 <- case kl_if_8 of
                                                                                                                                                                                              Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                              Atom (B (False)) -> do do !kl_if_10 <- kl_V2421 `pseq` kl_shen_doubleunderlineP kl_V2421
                                                                                                                                                                                                                        !kl_if_11 <- case kl_if_10 of
                                                                                                                                                                                                                                         Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                         Atom (B (False)) -> do do !kl_if_12 <- kl_V2421 `pseq` kl_shen_singleunderlineP kl_V2421
                                                                                                                                                                                                                                                                   case kl_if_12 of
                                                                                                                                                                                                                                                                       Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                       Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                       _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                         _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                        case kl_if_11 of
                                                                                                                                                                                                                            Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                            Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                            _ -> throwError "if: expected boolean"
                                                                                                                                                                                              _ -> throwError "if: expected boolean"
                                                                                                                                                                              case kl_if_9 of
                                                                                                                                                                                  Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                  Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                  _ -> throwError "if: expected boolean"
                                                                                                                                                    _ -> throwError "if: expected boolean"
                                                                                                                                    case kl_if_7 of
                                                                                                                                        Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                        Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                        _ -> throwError "if: expected boolean"
                                                                                                          _ -> throwError "if: expected boolean"
                                                                                          case kl_if_5 of
                                                                                              Atom (B (True)) -> do return kl_V2421
                                                                                              Atom (B (False)) -> do !kl_if_13 <- kl_V2421 `pseq` kl_symbolP kl_V2421
                                                                                                                     !kl_if_14 <- case kl_if_13 of
                                                                                                                                      Atom (B (True)) -> do let !appl_15 = ApplC (Func "lambda" (Context (\(!kl_ExplodeX) -> do !appl_16 <- klCons (Types.Atom (Types.Str ".")) (Types.Atom Types.Nil)
                                                                                                                                                                                                                                !appl_17 <- appl_16 `pseq` klCons (Types.Atom (Types.Str "n")) appl_16
                                                                                                                                                                                                                                !appl_18 <- appl_17 `pseq` klCons (Types.Atom (Types.Str "e")) appl_17
                                                                                                                                                                                                                                !appl_19 <- appl_18 `pseq` klCons (Types.Atom (Types.Str "h")) appl_18
                                                                                                                                                                                                                                !appl_20 <- appl_19 `pseq` klCons (Types.Atom (Types.Str "s")) appl_19
                                                                                                                                                                                                                                !appl_21 <- appl_20 `pseq` (kl_ExplodeX `pseq` kl_shen_prefixP appl_20 kl_ExplodeX)
                                                                                                                                                                                                                                !kl_if_22 <- appl_21 `pseq` kl_not appl_21
                                                                                                                                                                                                                                case kl_if_22 of
                                                                                                                                                                                                                                    Atom (B (True)) -> do !appl_23 <- kl_V2422 `pseq` (kl_ExplodeX `pseq` kl_shen_prefixP kl_V2422 kl_ExplodeX)
                                                                                                                                                                                                                                                          !kl_if_24 <- appl_23 `pseq` kl_not appl_23
                                                                                                                                                                                                                                                          case kl_if_24 of
                                                                                                                                                                                                                                                              Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                              Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                              _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                    Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                    _ -> throwError "if: expected boolean")))
                                                                                                                                                            !appl_25 <- kl_V2421 `pseq` kl_explode kl_V2421
                                                                                                                                                            !kl_if_26 <- appl_25 `pseq` applyWrapper appl_15 [appl_25]
                                                                                                                                                            case kl_if_26 of
                                                                                                                                                                Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                _ -> throwError "if: expected boolean"
                                                                                                                                      Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                      _ -> throwError "if: expected boolean"
                                                                                                                     case kl_if_14 of
                                                                                                                         Atom (B (True)) -> do kl_V2419 `pseq` (kl_V2421 `pseq` kl_concat kl_V2419 kl_V2421)
                                                                                                                         Atom (B (False)) -> do do return kl_V2421
                                                                                                                         _ -> throwError "if: expected boolean"
                                                                                              _ -> throwError "if: expected boolean"
                                                                       in case kl_V2421 of
                                                                              !(kl_V2421@(Cons (!kl_V2421h)
                                                                                               (!kl_V2421t))) -> pat_cond_0 kl_V2421 kl_V2421h kl_V2421t
                                                                              _ -> pat_cond_3

expr5 :: Types.KLContext Types.Env Types.KLValue
expr5 = do (do return (Types.Atom (Types.Str "Copyright (c) 2015, Mark Tarver\n\nAll rights reserved.\n\nRedistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions are met:\n1. Redistributions of source code must retain the above copyright\n   notice, this list of conditions and the following disclaimer.\n2. Redistributions in binary form must reproduce the above copyright\n   notice, this list of conditions and the following disclaimer in the\n   documentation and/or other materials provided with the distribution.\n3. The name of Mark Tarver may not be used to endorse or promote products\n   derived from this software without specific prior written permission.\n\nTHIS SOFTWARE IS PROVIDED BY Mark Tarver ''AS IS'' AND ANY\nEXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\nWARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\nDISCLAIMED. IN NO EVENT SHALL Mark Tarver BE LIABLE FOR ANY\nDIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES\n(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;\nLOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND\nON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\nSOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."))) `catchError` (\(!kl_E) -> do return (Types.Atom (Types.Str "E")))
