{-# LANGUAGE BangPatterns #-}
{-# LANGUAGE OverloadedStrings #-}
{-# LANGUAGE Strict #-}
{-# LANGUAGE StrictData #-}
{-# LANGUAGE ViewPatterns #-}

module Backend.Sequent where

import Control.Monad.Except
import Control.Parallel
import Environment
import Primitives as Primitives
import Backend.Utils
import Types as Types
import Utils
import Wrap
import Backend.Toplevel
import Backend.Core
import Backend.Sys

{-
Copyright (c) 2015, Mark Tarver
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of Mark Tarver may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY Mark Tarver ''AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Mark Tarver BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
-}

kl_shen_datatype_error :: Types.KLValue ->
                          Types.KLContext Types.Env Types.KLValue
kl_shen_datatype_error (!kl_V2428) = do let pat_cond_0 kl_V2428 kl_V2428h kl_V2428t kl_V2428th = do let !aw_1 = Types.Atom (Types.UnboundSym "shen.next-50")
                                                                                                    !appl_2 <- kl_V2428h `pseq` applyWrapper aw_1 [Types.Atom (Types.N (Types.KI 50)),
                                                                                                                                                   kl_V2428h]
                                                                                                    let !aw_3 = Types.Atom (Types.UnboundSym "shen.app")
                                                                                                    !appl_4 <- appl_2 `pseq` applyWrapper aw_3 [appl_2,
                                                                                                                                                Types.Atom (Types.Str "\n"),
                                                                                                                                                Types.Atom (Types.UnboundSym "shen.a")]
                                                                                                    !appl_5 <- appl_4 `pseq` cn (Types.Atom (Types.Str "datatype syntax error here:\n\n ")) appl_4
                                                                                                    appl_5 `pseq` simpleError appl_5
                                            pat_cond_6 = do do let !aw_7 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                               applyWrapper aw_7 [ApplC (wrapNamed "shen.datatype-error" kl_shen_datatype_error)]
                                         in case kl_V2428 of
                                                !(kl_V2428@(Cons (!kl_V2428h)
                                                                 (!(kl_V2428t@(Cons (!kl_V2428th)
                                                                                    (Atom (Nil))))))) -> pat_cond_0 kl_V2428 kl_V2428h kl_V2428t kl_V2428th
                                                _ -> pat_cond_6

kl_shen_LBdatatype_rulesRB :: Types.KLValue ->
                              Types.KLContext Types.Env Types.KLValue
kl_shen_LBdatatype_rulesRB (!kl_V2430) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do let !aw_1 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                !appl_2 <- applyWrapper aw_1 []
                                                                                                                !kl_if_3 <- kl_YaccParse `pseq` (appl_2 `pseq` eq kl_YaccParse appl_2)
                                                                                                                case kl_if_3 of
                                                                                                                    Atom (B (True)) -> do let !appl_4 = ApplC (Func "lambda" (Context (\(!kl_Parse_LBeRB) -> do let !aw_5 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                !appl_6 <- applyWrapper aw_5 []
                                                                                                                                                                                                                !appl_7 <- appl_6 `pseq` (kl_Parse_LBeRB `pseq` eq appl_6 kl_Parse_LBeRB)
                                                                                                                                                                                                                !kl_if_8 <- appl_7 `pseq` kl_not appl_7
                                                                                                                                                                                                                case kl_if_8 of
                                                                                                                                                                                                                    Atom (B (True)) -> do !appl_9 <- kl_Parse_LBeRB `pseq` hd kl_Parse_LBeRB
                                                                                                                                                                                                                                          let !aw_10 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                                                                                          appl_9 `pseq` applyWrapper aw_10 [appl_9,
                                                                                                                                                                                                                                                                            Types.Atom Types.Nil]
                                                                                                                                                                                                                    Atom (B (False)) -> do do let !aw_11 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                              applyWrapper aw_11 []
                                                                                                                                                                                                                    _ -> throwError "if: expected boolean")))
                                                                                                                                          let !aw_12 = Types.Atom (Types.UnboundSym "<e>")
                                                                                                                                          !appl_13 <- kl_V2430 `pseq` applyWrapper aw_12 [kl_V2430]
                                                                                                                                          appl_13 `pseq` applyWrapper appl_4 [appl_13]
                                                                                                                    Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                    _ -> throwError "if: expected boolean")))
                                            let !appl_14 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBdatatype_ruleRB) -> do let !aw_15 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                    !appl_16 <- applyWrapper aw_15 []
                                                                                                                                    !appl_17 <- appl_16 `pseq` (kl_Parse_shen_LBdatatype_ruleRB `pseq` eq appl_16 kl_Parse_shen_LBdatatype_ruleRB)
                                                                                                                                    !kl_if_18 <- appl_17 `pseq` kl_not appl_17
                                                                                                                                    case kl_if_18 of
                                                                                                                                        Atom (B (True)) -> do let !appl_19 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBdatatype_rulesRB) -> do let !aw_20 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                       !appl_21 <- applyWrapper aw_20 []
                                                                                                                                                                                                                                                       !appl_22 <- appl_21 `pseq` (kl_Parse_shen_LBdatatype_rulesRB `pseq` eq appl_21 kl_Parse_shen_LBdatatype_rulesRB)
                                                                                                                                                                                                                                                       !kl_if_23 <- appl_22 `pseq` kl_not appl_22
                                                                                                                                                                                                                                                       case kl_if_23 of
                                                                                                                                                                                                                                                           Atom (B (True)) -> do !appl_24 <- kl_Parse_shen_LBdatatype_rulesRB `pseq` hd kl_Parse_shen_LBdatatype_rulesRB
                                                                                                                                                                                                                                                                                 let !aw_25 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                                                 !appl_26 <- kl_Parse_shen_LBdatatype_ruleRB `pseq` applyWrapper aw_25 [kl_Parse_shen_LBdatatype_ruleRB]
                                                                                                                                                                                                                                                                                 let !aw_27 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                                                 !appl_28 <- kl_Parse_shen_LBdatatype_rulesRB `pseq` applyWrapper aw_27 [kl_Parse_shen_LBdatatype_rulesRB]
                                                                                                                                                                                                                                                                                 !appl_29 <- appl_26 `pseq` (appl_28 `pseq` klCons appl_26 appl_28)
                                                                                                                                                                                                                                                                                 let !aw_30 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                                                                                                                                 appl_24 `pseq` (appl_29 `pseq` applyWrapper aw_30 [appl_24,
                                                                                                                                                                                                                                                                                                                                    appl_29])
                                                                                                                                                                                                                                                           Atom (B (False)) -> do do let !aw_31 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                     applyWrapper aw_31 []
                                                                                                                                                                                                                                                           _ -> throwError "if: expected boolean")))
                                                                                                                                                              !appl_32 <- kl_Parse_shen_LBdatatype_ruleRB `pseq` kl_shen_LBdatatype_rulesRB kl_Parse_shen_LBdatatype_ruleRB
                                                                                                                                                              appl_32 `pseq` applyWrapper appl_19 [appl_32]
                                                                                                                                        Atom (B (False)) -> do do let !aw_33 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                  applyWrapper aw_33 []
                                                                                                                                        _ -> throwError "if: expected boolean")))
                                            !appl_34 <- kl_V2430 `pseq` kl_shen_LBdatatype_ruleRB kl_V2430
                                            !appl_35 <- appl_34 `pseq` applyWrapper appl_14 [appl_34]
                                            appl_35 `pseq` applyWrapper appl_0 [appl_35]

kl_shen_LBdatatype_ruleRB :: Types.KLValue ->
                             Types.KLContext Types.Env Types.KLValue
kl_shen_LBdatatype_ruleRB (!kl_V2432) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do let !aw_1 = Types.Atom (Types.UnboundSym "fail")
                                                                                                               !appl_2 <- applyWrapper aw_1 []
                                                                                                               !kl_if_3 <- kl_YaccParse `pseq` (appl_2 `pseq` eq kl_YaccParse appl_2)
                                                                                                               case kl_if_3 of
                                                                                                                   Atom (B (True)) -> do let !appl_4 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBside_conditionsRB) -> do let !aw_5 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                  !appl_6 <- applyWrapper aw_5 []
                                                                                                                                                                                                                                  !appl_7 <- appl_6 `pseq` (kl_Parse_shen_LBside_conditionsRB `pseq` eq appl_6 kl_Parse_shen_LBside_conditionsRB)
                                                                                                                                                                                                                                  !kl_if_8 <- appl_7 `pseq` kl_not appl_7
                                                                                                                                                                                                                                  case kl_if_8 of
                                                                                                                                                                                                                                      Atom (B (True)) -> do let !appl_9 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBpremisesRB) -> do let !aw_10 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                                                              !appl_11 <- applyWrapper aw_10 []
                                                                                                                                                                                                                                                                                                                                              !appl_12 <- appl_11 `pseq` (kl_Parse_shen_LBpremisesRB `pseq` eq appl_11 kl_Parse_shen_LBpremisesRB)
                                                                                                                                                                                                                                                                                                                                              !kl_if_13 <- appl_12 `pseq` kl_not appl_12
                                                                                                                                                                                                                                                                                                                                              case kl_if_13 of
                                                                                                                                                                                                                                                                                                                                                  Atom (B (True)) -> do let !appl_14 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBdoubleunderlineRB) -> do let !aw_15 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !appl_16 <- applyWrapper aw_15 []
                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !appl_17 <- appl_16 `pseq` (kl_Parse_shen_LBdoubleunderlineRB `pseq` eq appl_16 kl_Parse_shen_LBdoubleunderlineRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !kl_if_18 <- appl_17 `pseq` kl_not appl_17
                                                                                                                                                                                                                                                                                                                                                                                                                                                                  case kl_if_18 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                      Atom (B (True)) -> do let !appl_19 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBconclusionRB) -> do let !aw_20 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 !appl_21 <- applyWrapper aw_20 []
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 !appl_22 <- appl_21 `pseq` (kl_Parse_shen_LBconclusionRB `pseq` eq appl_21 kl_Parse_shen_LBconclusionRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 !kl_if_23 <- appl_22 `pseq` kl_not appl_22
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 case kl_if_23 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     Atom (B (True)) -> do !appl_24 <- kl_Parse_shen_LBconclusionRB `pseq` hd kl_Parse_shen_LBconclusionRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           let !aw_25 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           !appl_26 <- kl_Parse_shen_LBside_conditionsRB `pseq` applyWrapper aw_25 [kl_Parse_shen_LBside_conditionsRB]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           let !aw_27 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           !appl_28 <- kl_Parse_shen_LBpremisesRB `pseq` applyWrapper aw_27 [kl_Parse_shen_LBpremisesRB]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           let !aw_29 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           !appl_30 <- kl_Parse_shen_LBconclusionRB `pseq` applyWrapper aw_29 [kl_Parse_shen_LBconclusionRB]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           !appl_31 <- appl_30 `pseq` klCons appl_30 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           !appl_32 <- appl_28 `pseq` (appl_31 `pseq` klCons appl_28 appl_31)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           !appl_33 <- appl_26 `pseq` (appl_32 `pseq` klCons appl_26 appl_32)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           !appl_34 <- appl_33 `pseq` kl_shen_sequent (Types.Atom (Types.UnboundSym "shen.double")) appl_33
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           let !aw_35 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           appl_24 `pseq` (appl_34 `pseq` applyWrapper aw_35 [appl_24,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              appl_34])
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     Atom (B (False)) -> do do let !aw_36 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               applyWrapper aw_36 []
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !appl_37 <- kl_Parse_shen_LBdoubleunderlineRB `pseq` kl_shen_LBconclusionRB kl_Parse_shen_LBdoubleunderlineRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            appl_37 `pseq` applyWrapper appl_19 [appl_37]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                      Atom (B (False)) -> do do let !aw_38 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                applyWrapper aw_38 []
                                                                                                                                                                                                                                                                                                                                                                                                                                                                      _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                        !appl_39 <- kl_Parse_shen_LBpremisesRB `pseq` kl_shen_LBdoubleunderlineRB kl_Parse_shen_LBpremisesRB
                                                                                                                                                                                                                                                                                                                                                                        appl_39 `pseq` applyWrapper appl_14 [appl_39]
                                                                                                                                                                                                                                                                                                                                                  Atom (B (False)) -> do do let !aw_40 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                                                                                            applyWrapper aw_40 []
                                                                                                                                                                                                                                                                                                                                                  _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                            !appl_41 <- kl_Parse_shen_LBside_conditionsRB `pseq` kl_shen_LBpremisesRB kl_Parse_shen_LBside_conditionsRB
                                                                                                                                                                                                                                                            appl_41 `pseq` applyWrapper appl_9 [appl_41]
                                                                                                                                                                                                                                      Atom (B (False)) -> do do let !aw_42 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                applyWrapper aw_42 []
                                                                                                                                                                                                                                      _ -> throwError "if: expected boolean")))
                                                                                                                                         !appl_43 <- kl_V2432 `pseq` kl_shen_LBside_conditionsRB kl_V2432
                                                                                                                                         appl_43 `pseq` applyWrapper appl_4 [appl_43]
                                                                                                                   Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                   _ -> throwError "if: expected boolean")))
                                           let !appl_44 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBside_conditionsRB) -> do let !aw_45 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                     !appl_46 <- applyWrapper aw_45 []
                                                                                                                                     !appl_47 <- appl_46 `pseq` (kl_Parse_shen_LBside_conditionsRB `pseq` eq appl_46 kl_Parse_shen_LBside_conditionsRB)
                                                                                                                                     !kl_if_48 <- appl_47 `pseq` kl_not appl_47
                                                                                                                                     case kl_if_48 of
                                                                                                                                         Atom (B (True)) -> do let !appl_49 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBpremisesRB) -> do let !aw_50 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                  !appl_51 <- applyWrapper aw_50 []
                                                                                                                                                                                                                                                  !appl_52 <- appl_51 `pseq` (kl_Parse_shen_LBpremisesRB `pseq` eq appl_51 kl_Parse_shen_LBpremisesRB)
                                                                                                                                                                                                                                                  !kl_if_53 <- appl_52 `pseq` kl_not appl_52
                                                                                                                                                                                                                                                  case kl_if_53 of
                                                                                                                                                                                                                                                      Atom (B (True)) -> do let !appl_54 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBsingleunderlineRB) -> do let !aw_55 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                                                                                      !appl_56 <- applyWrapper aw_55 []
                                                                                                                                                                                                                                                                                                                                                                      !appl_57 <- appl_56 `pseq` (kl_Parse_shen_LBsingleunderlineRB `pseq` eq appl_56 kl_Parse_shen_LBsingleunderlineRB)
                                                                                                                                                                                                                                                                                                                                                                      !kl_if_58 <- appl_57 `pseq` kl_not appl_57
                                                                                                                                                                                                                                                                                                                                                                      case kl_if_58 of
                                                                                                                                                                                                                                                                                                                                                                          Atom (B (True)) -> do let !appl_59 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBconclusionRB) -> do let !aw_60 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     !appl_61 <- applyWrapper aw_60 []
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     !appl_62 <- appl_61 `pseq` (kl_Parse_shen_LBconclusionRB `pseq` eq appl_61 kl_Parse_shen_LBconclusionRB)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     !kl_if_63 <- appl_62 `pseq` kl_not appl_62
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     case kl_if_63 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         Atom (B (True)) -> do !appl_64 <- kl_Parse_shen_LBconclusionRB `pseq` hd kl_Parse_shen_LBconclusionRB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               let !aw_65 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               !appl_66 <- kl_Parse_shen_LBside_conditionsRB `pseq` applyWrapper aw_65 [kl_Parse_shen_LBside_conditionsRB]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               let !aw_67 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               !appl_68 <- kl_Parse_shen_LBpremisesRB `pseq` applyWrapper aw_67 [kl_Parse_shen_LBpremisesRB]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               let !aw_69 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               !appl_70 <- kl_Parse_shen_LBconclusionRB `pseq` applyWrapper aw_69 [kl_Parse_shen_LBconclusionRB]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               !appl_71 <- appl_70 `pseq` klCons appl_70 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               !appl_72 <- appl_68 `pseq` (appl_71 `pseq` klCons appl_68 appl_71)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               !appl_73 <- appl_66 `pseq` (appl_72 `pseq` klCons appl_66 appl_72)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               !appl_74 <- appl_73 `pseq` kl_shen_sequent (Types.Atom (Types.UnboundSym "shen.single")) appl_73
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               let !aw_75 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               appl_64 `pseq` (appl_74 `pseq` applyWrapper aw_75 [appl_64,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  appl_74])
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         Atom (B (False)) -> do do let !aw_76 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   applyWrapper aw_76 []
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                                                                                                                                !appl_77 <- kl_Parse_shen_LBsingleunderlineRB `pseq` kl_shen_LBconclusionRB kl_Parse_shen_LBsingleunderlineRB
                                                                                                                                                                                                                                                                                                                                                                                                appl_77 `pseq` applyWrapper appl_59 [appl_77]
                                                                                                                                                                                                                                                                                                                                                                          Atom (B (False)) -> do do let !aw_78 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                                                                                                                    applyWrapper aw_78 []
                                                                                                                                                                                                                                                                                                                                                                          _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                            !appl_79 <- kl_Parse_shen_LBpremisesRB `pseq` kl_shen_LBsingleunderlineRB kl_Parse_shen_LBpremisesRB
                                                                                                                                                                                                                                                                            appl_79 `pseq` applyWrapper appl_54 [appl_79]
                                                                                                                                                                                                                                                      Atom (B (False)) -> do do let !aw_80 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                applyWrapper aw_80 []
                                                                                                                                                                                                                                                      _ -> throwError "if: expected boolean")))
                                                                                                                                                               !appl_81 <- kl_Parse_shen_LBside_conditionsRB `pseq` kl_shen_LBpremisesRB kl_Parse_shen_LBside_conditionsRB
                                                                                                                                                               appl_81 `pseq` applyWrapper appl_49 [appl_81]
                                                                                                                                         Atom (B (False)) -> do do let !aw_82 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                   applyWrapper aw_82 []
                                                                                                                                         _ -> throwError "if: expected boolean")))
                                           !appl_83 <- kl_V2432 `pseq` kl_shen_LBside_conditionsRB kl_V2432
                                           !appl_84 <- appl_83 `pseq` applyWrapper appl_44 [appl_83]
                                           appl_84 `pseq` applyWrapper appl_0 [appl_84]

kl_shen_LBside_conditionsRB :: Types.KLValue ->
                               Types.KLContext Types.Env Types.KLValue
kl_shen_LBside_conditionsRB (!kl_V2434) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do let !aw_1 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                 !appl_2 <- applyWrapper aw_1 []
                                                                                                                 !kl_if_3 <- kl_YaccParse `pseq` (appl_2 `pseq` eq kl_YaccParse appl_2)
                                                                                                                 case kl_if_3 of
                                                                                                                     Atom (B (True)) -> do let !appl_4 = ApplC (Func "lambda" (Context (\(!kl_Parse_LBeRB) -> do let !aw_5 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                 !appl_6 <- applyWrapper aw_5 []
                                                                                                                                                                                                                 !appl_7 <- appl_6 `pseq` (kl_Parse_LBeRB `pseq` eq appl_6 kl_Parse_LBeRB)
                                                                                                                                                                                                                 !kl_if_8 <- appl_7 `pseq` kl_not appl_7
                                                                                                                                                                                                                 case kl_if_8 of
                                                                                                                                                                                                                     Atom (B (True)) -> do !appl_9 <- kl_Parse_LBeRB `pseq` hd kl_Parse_LBeRB
                                                                                                                                                                                                                                           let !aw_10 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                                                                                           appl_9 `pseq` applyWrapper aw_10 [appl_9,
                                                                                                                                                                                                                                                                             Types.Atom Types.Nil]
                                                                                                                                                                                                                     Atom (B (False)) -> do do let !aw_11 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                               applyWrapper aw_11 []
                                                                                                                                                                                                                     _ -> throwError "if: expected boolean")))
                                                                                                                                           let !aw_12 = Types.Atom (Types.UnboundSym "<e>")
                                                                                                                                           !appl_13 <- kl_V2434 `pseq` applyWrapper aw_12 [kl_V2434]
                                                                                                                                           appl_13 `pseq` applyWrapper appl_4 [appl_13]
                                                                                                                     Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                     _ -> throwError "if: expected boolean")))
                                             let !appl_14 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBside_conditionRB) -> do let !aw_15 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                      !appl_16 <- applyWrapper aw_15 []
                                                                                                                                      !appl_17 <- appl_16 `pseq` (kl_Parse_shen_LBside_conditionRB `pseq` eq appl_16 kl_Parse_shen_LBside_conditionRB)
                                                                                                                                      !kl_if_18 <- appl_17 `pseq` kl_not appl_17
                                                                                                                                      case kl_if_18 of
                                                                                                                                          Atom (B (True)) -> do let !appl_19 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBside_conditionsRB) -> do let !aw_20 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                          !appl_21 <- applyWrapper aw_20 []
                                                                                                                                                                                                                                                          !appl_22 <- appl_21 `pseq` (kl_Parse_shen_LBside_conditionsRB `pseq` eq appl_21 kl_Parse_shen_LBside_conditionsRB)
                                                                                                                                                                                                                                                          !kl_if_23 <- appl_22 `pseq` kl_not appl_22
                                                                                                                                                                                                                                                          case kl_if_23 of
                                                                                                                                                                                                                                                              Atom (B (True)) -> do !appl_24 <- kl_Parse_shen_LBside_conditionsRB `pseq` hd kl_Parse_shen_LBside_conditionsRB
                                                                                                                                                                                                                                                                                    let !aw_25 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                                                    !appl_26 <- kl_Parse_shen_LBside_conditionRB `pseq` applyWrapper aw_25 [kl_Parse_shen_LBside_conditionRB]
                                                                                                                                                                                                                                                                                    let !aw_27 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                                                    !appl_28 <- kl_Parse_shen_LBside_conditionsRB `pseq` applyWrapper aw_27 [kl_Parse_shen_LBside_conditionsRB]
                                                                                                                                                                                                                                                                                    !appl_29 <- appl_26 `pseq` (appl_28 `pseq` klCons appl_26 appl_28)
                                                                                                                                                                                                                                                                                    let !aw_30 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                                                                                                                                    appl_24 `pseq` (appl_29 `pseq` applyWrapper aw_30 [appl_24,
                                                                                                                                                                                                                                                                                                                                       appl_29])
                                                                                                                                                                                                                                                              Atom (B (False)) -> do do let !aw_31 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                        applyWrapper aw_31 []
                                                                                                                                                                                                                                                              _ -> throwError "if: expected boolean")))
                                                                                                                                                                !appl_32 <- kl_Parse_shen_LBside_conditionRB `pseq` kl_shen_LBside_conditionsRB kl_Parse_shen_LBside_conditionRB
                                                                                                                                                                appl_32 `pseq` applyWrapper appl_19 [appl_32]
                                                                                                                                          Atom (B (False)) -> do do let !aw_33 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                    applyWrapper aw_33 []
                                                                                                                                          _ -> throwError "if: expected boolean")))
                                             !appl_34 <- kl_V2434 `pseq` kl_shen_LBside_conditionRB kl_V2434
                                             !appl_35 <- appl_34 `pseq` applyWrapper appl_14 [appl_34]
                                             appl_35 `pseq` applyWrapper appl_0 [appl_35]

kl_shen_LBside_conditionRB :: Types.KLValue ->
                              Types.KLContext Types.Env Types.KLValue
kl_shen_LBside_conditionRB (!kl_V2436) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do let !aw_1 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                !appl_2 <- applyWrapper aw_1 []
                                                                                                                !kl_if_3 <- kl_YaccParse `pseq` (appl_2 `pseq` eq kl_YaccParse appl_2)
                                                                                                                case kl_if_3 of
                                                                                                                    Atom (B (True)) -> do !appl_4 <- kl_V2436 `pseq` hd kl_V2436
                                                                                                                                          !kl_if_5 <- appl_4 `pseq` consP appl_4
                                                                                                                                          !kl_if_6 <- case kl_if_5 of
                                                                                                                                                          Atom (B (True)) -> do !appl_7 <- kl_V2436 `pseq` hd kl_V2436
                                                                                                                                                                                !appl_8 <- appl_7 `pseq` hd appl_7
                                                                                                                                                                                !kl_if_9 <- appl_8 `pseq` eq (Types.Atom (Types.UnboundSym "let")) appl_8
                                                                                                                                                                                case kl_if_9 of
                                                                                                                                                                                    Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                    Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                    _ -> throwError "if: expected boolean"
                                                                                                                                                          Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                          _ -> throwError "if: expected boolean"
                                                                                                                                          case kl_if_6 of
                                                                                                                                              Atom (B (True)) -> do let !appl_10 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBvariablePRB) -> do let !aw_11 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                        !appl_12 <- applyWrapper aw_11 []
                                                                                                                                                                                                                                                        !appl_13 <- appl_12 `pseq` (kl_Parse_shen_LBvariablePRB `pseq` eq appl_12 kl_Parse_shen_LBvariablePRB)
                                                                                                                                                                                                                                                        !kl_if_14 <- appl_13 `pseq` kl_not appl_13
                                                                                                                                                                                                                                                        case kl_if_14 of
                                                                                                                                                                                                                                                            Atom (B (True)) -> do let !appl_15 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBexprRB) -> do let !aw_16 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                                                                                 !appl_17 <- applyWrapper aw_16 []
                                                                                                                                                                                                                                                                                                                                                                 !appl_18 <- appl_17 `pseq` (kl_Parse_shen_LBexprRB `pseq` eq appl_17 kl_Parse_shen_LBexprRB)
                                                                                                                                                                                                                                                                                                                                                                 !kl_if_19 <- appl_18 `pseq` kl_not appl_18
                                                                                                                                                                                                                                                                                                                                                                 case kl_if_19 of
                                                                                                                                                                                                                                                                                                                                                                     Atom (B (True)) -> do !appl_20 <- kl_Parse_shen_LBexprRB `pseq` hd kl_Parse_shen_LBexprRB
                                                                                                                                                                                                                                                                                                                                                                                           let !aw_21 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                                                                                                                                                           !appl_22 <- kl_Parse_shen_LBvariablePRB `pseq` applyWrapper aw_21 [kl_Parse_shen_LBvariablePRB]
                                                                                                                                                                                                                                                                                                                                                                                           let !aw_23 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                                                                                                                                                           !appl_24 <- kl_Parse_shen_LBexprRB `pseq` applyWrapper aw_23 [kl_Parse_shen_LBexprRB]
                                                                                                                                                                                                                                                                                                                                                                                           !appl_25 <- appl_24 `pseq` klCons appl_24 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                                                                                                           !appl_26 <- appl_22 `pseq` (appl_25 `pseq` klCons appl_22 appl_25)
                                                                                                                                                                                                                                                                                                                                                                                           !appl_27 <- appl_26 `pseq` klCons (Types.Atom (Types.UnboundSym "let")) appl_26
                                                                                                                                                                                                                                                                                                                                                                                           let !aw_28 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                                                                                                                                                                                                                                           appl_20 `pseq` (appl_27 `pseq` applyWrapper aw_28 [appl_20,
                                                                                                                                                                                                                                                                                                                                                                                                                                              appl_27])
                                                                                                                                                                                                                                                                                                                                                                     Atom (B (False)) -> do do let !aw_29 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                                                                                                               applyWrapper aw_29 []
                                                                                                                                                                                                                                                                                                                                                                     _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                  !appl_30 <- kl_Parse_shen_LBvariablePRB `pseq` kl_shen_LBexprRB kl_Parse_shen_LBvariablePRB
                                                                                                                                                                                                                                                                                  appl_30 `pseq` applyWrapper appl_15 [appl_30]
                                                                                                                                                                                                                                                            Atom (B (False)) -> do do let !aw_31 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                      applyWrapper aw_31 []
                                                                                                                                                                                                                                                            _ -> throwError "if: expected boolean")))
                                                                                                                                                                    !appl_32 <- kl_V2436 `pseq` hd kl_V2436
                                                                                                                                                                    !appl_33 <- appl_32 `pseq` tl appl_32
                                                                                                                                                                    let !aw_34 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                    !appl_35 <- kl_V2436 `pseq` applyWrapper aw_34 [kl_V2436]
                                                                                                                                                                    let !aw_36 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                    !appl_37 <- appl_33 `pseq` (appl_35 `pseq` applyWrapper aw_36 [appl_33,
                                                                                                                                                                                                                                   appl_35])
                                                                                                                                                                    !appl_38 <- appl_37 `pseq` kl_shen_LBvariablePRB appl_37
                                                                                                                                                                    appl_38 `pseq` applyWrapper appl_10 [appl_38]
                                                                                                                                              Atom (B (False)) -> do do let !aw_39 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                        applyWrapper aw_39 []
                                                                                                                                              _ -> throwError "if: expected boolean"
                                                                                                                    Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                    _ -> throwError "if: expected boolean")))
                                            !appl_40 <- kl_V2436 `pseq` hd kl_V2436
                                            !kl_if_41 <- appl_40 `pseq` consP appl_40
                                            !kl_if_42 <- case kl_if_41 of
                                                             Atom (B (True)) -> do !appl_43 <- kl_V2436 `pseq` hd kl_V2436
                                                                                   !appl_44 <- appl_43 `pseq` hd appl_43
                                                                                   !kl_if_45 <- appl_44 `pseq` eq (Types.Atom (Types.UnboundSym "if")) appl_44
                                                                                   case kl_if_45 of
                                                                                       Atom (B (True)) -> do return (Atom (B True))
                                                                                       Atom (B (False)) -> do do return (Atom (B False))
                                                                                       _ -> throwError "if: expected boolean"
                                                             Atom (B (False)) -> do do return (Atom (B False))
                                                             _ -> throwError "if: expected boolean"
                                            !appl_46 <- case kl_if_42 of
                                                            Atom (B (True)) -> do let !appl_47 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBexprRB) -> do let !aw_48 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                 !appl_49 <- applyWrapper aw_48 []
                                                                                                                                                                 !appl_50 <- appl_49 `pseq` (kl_Parse_shen_LBexprRB `pseq` eq appl_49 kl_Parse_shen_LBexprRB)
                                                                                                                                                                 !kl_if_51 <- appl_50 `pseq` kl_not appl_50
                                                                                                                                                                 case kl_if_51 of
                                                                                                                                                                     Atom (B (True)) -> do !appl_52 <- kl_Parse_shen_LBexprRB `pseq` hd kl_Parse_shen_LBexprRB
                                                                                                                                                                                           let !aw_53 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                           !appl_54 <- kl_Parse_shen_LBexprRB `pseq` applyWrapper aw_53 [kl_Parse_shen_LBexprRB]
                                                                                                                                                                                           !appl_55 <- appl_54 `pseq` klCons appl_54 (Types.Atom Types.Nil)
                                                                                                                                                                                           !appl_56 <- appl_55 `pseq` klCons (Types.Atom (Types.UnboundSym "if")) appl_55
                                                                                                                                                                                           let !aw_57 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                                           appl_52 `pseq` (appl_56 `pseq` applyWrapper aw_57 [appl_52,
                                                                                                                                                                                                                                              appl_56])
                                                                                                                                                                     Atom (B (False)) -> do do let !aw_58 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                               applyWrapper aw_58 []
                                                                                                                                                                     _ -> throwError "if: expected boolean")))
                                                                                  !appl_59 <- kl_V2436 `pseq` hd kl_V2436
                                                                                  !appl_60 <- appl_59 `pseq` tl appl_59
                                                                                  let !aw_61 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                  !appl_62 <- kl_V2436 `pseq` applyWrapper aw_61 [kl_V2436]
                                                                                  let !aw_63 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                  !appl_64 <- appl_60 `pseq` (appl_62 `pseq` applyWrapper aw_63 [appl_60,
                                                                                                                                                 appl_62])
                                                                                  !appl_65 <- appl_64 `pseq` kl_shen_LBexprRB appl_64
                                                                                  appl_65 `pseq` applyWrapper appl_47 [appl_65]
                                                            Atom (B (False)) -> do do let !aw_66 = Types.Atom (Types.UnboundSym "fail")
                                                                                      applyWrapper aw_66 []
                                                            _ -> throwError "if: expected boolean"
                                            appl_46 `pseq` applyWrapper appl_0 [appl_46]

kl_shen_LBvariablePRB :: Types.KLValue ->
                         Types.KLContext Types.Env Types.KLValue
kl_shen_LBvariablePRB (!kl_V2438) = do !appl_0 <- kl_V2438 `pseq` hd kl_V2438
                                       !kl_if_1 <- appl_0 `pseq` consP appl_0
                                       case kl_if_1 of
                                           Atom (B (True)) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Parse_X) -> do !kl_if_3 <- kl_Parse_X `pseq` kl_variableP kl_Parse_X
                                                                                                                                   case kl_if_3 of
                                                                                                                                       Atom (B (True)) -> do !appl_4 <- kl_V2438 `pseq` hd kl_V2438
                                                                                                                                                             !appl_5 <- appl_4 `pseq` tl appl_4
                                                                                                                                                             let !aw_6 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                             !appl_7 <- kl_V2438 `pseq` applyWrapper aw_6 [kl_V2438]
                                                                                                                                                             let !aw_8 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                             !appl_9 <- appl_5 `pseq` (appl_7 `pseq` applyWrapper aw_8 [appl_5,
                                                                                                                                                                                                                        appl_7])
                                                                                                                                                             !appl_10 <- appl_9 `pseq` hd appl_9
                                                                                                                                                             let !aw_11 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                             appl_10 `pseq` (kl_Parse_X `pseq` applyWrapper aw_11 [appl_10,
                                                                                                                                                                                                                   kl_Parse_X])
                                                                                                                                       Atom (B (False)) -> do do let !aw_12 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                 applyWrapper aw_12 []
                                                                                                                                       _ -> throwError "if: expected boolean")))
                                                                 !appl_13 <- kl_V2438 `pseq` hd kl_V2438
                                                                 !appl_14 <- appl_13 `pseq` hd appl_13
                                                                 appl_14 `pseq` applyWrapper appl_2 [appl_14]
                                           Atom (B (False)) -> do do let !aw_15 = Types.Atom (Types.UnboundSym "fail")
                                                                     applyWrapper aw_15 []
                                           _ -> throwError "if: expected boolean"

kl_shen_LBexprRB :: Types.KLValue ->
                    Types.KLContext Types.Env Types.KLValue
kl_shen_LBexprRB (!kl_V2440) = do !appl_0 <- kl_V2440 `pseq` hd kl_V2440
                                  !kl_if_1 <- appl_0 `pseq` consP appl_0
                                  case kl_if_1 of
                                      Atom (B (True)) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Parse_X) -> do !appl_3 <- klCons (Types.Atom (Types.UnboundSym ";")) (Types.Atom Types.Nil)
                                                                                                                              !appl_4 <- appl_3 `pseq` klCons (Types.Atom (Types.UnboundSym ">>")) appl_3
                                                                                                                              !kl_if_5 <- kl_Parse_X `pseq` (appl_4 `pseq` kl_elementP kl_Parse_X appl_4)
                                                                                                                              !appl_6 <- case kl_if_5 of
                                                                                                                                             Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                             Atom (B (False)) -> do do !kl_if_7 <- kl_Parse_X `pseq` kl_shen_singleunderlineP kl_Parse_X
                                                                                                                                                                       !kl_if_8 <- case kl_if_7 of
                                                                                                                                                                                       Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                       Atom (B (False)) -> do do !kl_if_9 <- kl_Parse_X `pseq` kl_shen_doubleunderlineP kl_Parse_X
                                                                                                                                                                                                                 case kl_if_9 of
                                                                                                                                                                                                                     Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                     Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                     _ -> throwError "if: expected boolean"
                                                                                                                                                                                       _ -> throwError "if: expected boolean"
                                                                                                                                                                       case kl_if_8 of
                                                                                                                                                                           Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                           Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                           _ -> throwError "if: expected boolean"
                                                                                                                                             _ -> throwError "if: expected boolean"
                                                                                                                              !kl_if_10 <- appl_6 `pseq` kl_not appl_6
                                                                                                                              case kl_if_10 of
                                                                                                                                  Atom (B (True)) -> do !appl_11 <- kl_V2440 `pseq` hd kl_V2440
                                                                                                                                                        !appl_12 <- appl_11 `pseq` tl appl_11
                                                                                                                                                        let !aw_13 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                        !appl_14 <- kl_V2440 `pseq` applyWrapper aw_13 [kl_V2440]
                                                                                                                                                        let !aw_15 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                        !appl_16 <- appl_12 `pseq` (appl_14 `pseq` applyWrapper aw_15 [appl_12,
                                                                                                                                                                                                                       appl_14])
                                                                                                                                                        !appl_17 <- appl_16 `pseq` hd appl_16
                                                                                                                                                        !appl_18 <- kl_Parse_X `pseq` kl_shen_remove_bar kl_Parse_X
                                                                                                                                                        let !aw_19 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                        appl_17 `pseq` (appl_18 `pseq` applyWrapper aw_19 [appl_17,
                                                                                                                                                                                                           appl_18])
                                                                                                                                  Atom (B (False)) -> do do let !aw_20 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                            applyWrapper aw_20 []
                                                                                                                                  _ -> throwError "if: expected boolean")))
                                                            !appl_21 <- kl_V2440 `pseq` hd kl_V2440
                                                            !appl_22 <- appl_21 `pseq` hd appl_21
                                                            appl_22 `pseq` applyWrapper appl_2 [appl_22]
                                      Atom (B (False)) -> do do let !aw_23 = Types.Atom (Types.UnboundSym "fail")
                                                                applyWrapper aw_23 []
                                      _ -> throwError "if: expected boolean"

kl_shen_remove_bar :: Types.KLValue ->
                      Types.KLContext Types.Env Types.KLValue
kl_shen_remove_bar (!kl_V2442) = do let pat_cond_0 kl_V2442 kl_V2442h kl_V2442t kl_V2442tt kl_V2442tth = do kl_V2442h `pseq` (kl_V2442tth `pseq` klCons kl_V2442h kl_V2442tth)
                                        pat_cond_1 kl_V2442 kl_V2442h kl_V2442t = do !appl_2 <- kl_V2442h `pseq` kl_shen_remove_bar kl_V2442h
                                                                                     !appl_3 <- kl_V2442t `pseq` kl_shen_remove_bar kl_V2442t
                                                                                     appl_2 `pseq` (appl_3 `pseq` klCons appl_2 appl_3)
                                        pat_cond_4 = do do return kl_V2442
                                     in case kl_V2442 of
                                            !(kl_V2442@(Cons (!kl_V2442h)
                                                             (!(kl_V2442t@(Cons (Atom (UnboundSym "bar!"))
                                                                                (!(kl_V2442tt@(Cons (!kl_V2442tth)
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_0 kl_V2442 kl_V2442h kl_V2442t kl_V2442tt kl_V2442tth
                                            !(kl_V2442@(Cons (!kl_V2442h)
                                                             (!(kl_V2442t@(Cons (ApplC (PL "bar!"
                                                                                           _))
                                                                                (!(kl_V2442tt@(Cons (!kl_V2442tth)
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_0 kl_V2442 kl_V2442h kl_V2442t kl_V2442tt kl_V2442tth
                                            !(kl_V2442@(Cons (!kl_V2442h)
                                                             (!(kl_V2442t@(Cons (ApplC (Func "bar!"
                                                                                             _))
                                                                                (!(kl_V2442tt@(Cons (!kl_V2442tth)
                                                                                                    (Atom (Nil)))))))))) -> pat_cond_0 kl_V2442 kl_V2442h kl_V2442t kl_V2442tt kl_V2442tth
                                            !(kl_V2442@(Cons (!kl_V2442h)
                                                             (!kl_V2442t))) -> pat_cond_1 kl_V2442 kl_V2442h kl_V2442t
                                            _ -> pat_cond_4

kl_shen_LBpremisesRB :: Types.KLValue ->
                        Types.KLContext Types.Env Types.KLValue
kl_shen_LBpremisesRB (!kl_V2444) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do let !aw_1 = Types.Atom (Types.UnboundSym "fail")
                                                                                                          !appl_2 <- applyWrapper aw_1 []
                                                                                                          !kl_if_3 <- kl_YaccParse `pseq` (appl_2 `pseq` eq kl_YaccParse appl_2)
                                                                                                          case kl_if_3 of
                                                                                                              Atom (B (True)) -> do let !appl_4 = ApplC (Func "lambda" (Context (\(!kl_Parse_LBeRB) -> do let !aw_5 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                          !appl_6 <- applyWrapper aw_5 []
                                                                                                                                                                                                          !appl_7 <- appl_6 `pseq` (kl_Parse_LBeRB `pseq` eq appl_6 kl_Parse_LBeRB)
                                                                                                                                                                                                          !kl_if_8 <- appl_7 `pseq` kl_not appl_7
                                                                                                                                                                                                          case kl_if_8 of
                                                                                                                                                                                                              Atom (B (True)) -> do !appl_9 <- kl_Parse_LBeRB `pseq` hd kl_Parse_LBeRB
                                                                                                                                                                                                                                    let !aw_10 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                                                                                    appl_9 `pseq` applyWrapper aw_10 [appl_9,
                                                                                                                                                                                                                                                                      Types.Atom Types.Nil]
                                                                                                                                                                                                              Atom (B (False)) -> do do let !aw_11 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                        applyWrapper aw_11 []
                                                                                                                                                                                                              _ -> throwError "if: expected boolean")))
                                                                                                                                    let !aw_12 = Types.Atom (Types.UnboundSym "<e>")
                                                                                                                                    !appl_13 <- kl_V2444 `pseq` applyWrapper aw_12 [kl_V2444]
                                                                                                                                    appl_13 `pseq` applyWrapper appl_4 [appl_13]
                                                                                                              Atom (B (False)) -> do do return kl_YaccParse
                                                                                                              _ -> throwError "if: expected boolean")))
                                      let !appl_14 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBpremiseRB) -> do let !aw_15 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                        !appl_16 <- applyWrapper aw_15 []
                                                                                                                        !appl_17 <- appl_16 `pseq` (kl_Parse_shen_LBpremiseRB `pseq` eq appl_16 kl_Parse_shen_LBpremiseRB)
                                                                                                                        !kl_if_18 <- appl_17 `pseq` kl_not appl_17
                                                                                                                        case kl_if_18 of
                                                                                                                            Atom (B (True)) -> do let !appl_19 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBsemicolon_symbolRB) -> do let !aw_20 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                             !appl_21 <- applyWrapper aw_20 []
                                                                                                                                                                                                                                             !appl_22 <- appl_21 `pseq` (kl_Parse_shen_LBsemicolon_symbolRB `pseq` eq appl_21 kl_Parse_shen_LBsemicolon_symbolRB)
                                                                                                                                                                                                                                             !kl_if_23 <- appl_22 `pseq` kl_not appl_22
                                                                                                                                                                                                                                             case kl_if_23 of
                                                                                                                                                                                                                                                 Atom (B (True)) -> do let !appl_24 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBpremisesRB) -> do let !aw_25 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                                                                          !appl_26 <- applyWrapper aw_25 []
                                                                                                                                                                                                                                                                                                                                                          !appl_27 <- appl_26 `pseq` (kl_Parse_shen_LBpremisesRB `pseq` eq appl_26 kl_Parse_shen_LBpremisesRB)
                                                                                                                                                                                                                                                                                                                                                          !kl_if_28 <- appl_27 `pseq` kl_not appl_27
                                                                                                                                                                                                                                                                                                                                                          case kl_if_28 of
                                                                                                                                                                                                                                                                                                                                                              Atom (B (True)) -> do !appl_29 <- kl_Parse_shen_LBpremisesRB `pseq` hd kl_Parse_shen_LBpremisesRB
                                                                                                                                                                                                                                                                                                                                                                                    let !aw_30 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                                                                                                                                                    !appl_31 <- kl_Parse_shen_LBpremiseRB `pseq` applyWrapper aw_30 [kl_Parse_shen_LBpremiseRB]
                                                                                                                                                                                                                                                                                                                                                                                    let !aw_32 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                                                                                                                                                    !appl_33 <- kl_Parse_shen_LBpremisesRB `pseq` applyWrapper aw_32 [kl_Parse_shen_LBpremisesRB]
                                                                                                                                                                                                                                                                                                                                                                                    !appl_34 <- appl_31 `pseq` (appl_33 `pseq` klCons appl_31 appl_33)
                                                                                                                                                                                                                                                                                                                                                                                    let !aw_35 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                                                                                                                                                                                                                                    appl_29 `pseq` (appl_34 `pseq` applyWrapper aw_35 [appl_29,
                                                                                                                                                                                                                                                                                                                                                                                                                                       appl_34])
                                                                                                                                                                                                                                                                                                                                                              Atom (B (False)) -> do do let !aw_36 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                                                                                                        applyWrapper aw_36 []
                                                                                                                                                                                                                                                                                                                                                              _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                       !appl_37 <- kl_Parse_shen_LBsemicolon_symbolRB `pseq` kl_shen_LBpremisesRB kl_Parse_shen_LBsemicolon_symbolRB
                                                                                                                                                                                                                                                                       appl_37 `pseq` applyWrapper appl_24 [appl_37]
                                                                                                                                                                                                                                                 Atom (B (False)) -> do do let !aw_38 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                           applyWrapper aw_38 []
                                                                                                                                                                                                                                                 _ -> throwError "if: expected boolean")))
                                                                                                                                                  !appl_39 <- kl_Parse_shen_LBpremiseRB `pseq` kl_shen_LBsemicolon_symbolRB kl_Parse_shen_LBpremiseRB
                                                                                                                                                  appl_39 `pseq` applyWrapper appl_19 [appl_39]
                                                                                                                            Atom (B (False)) -> do do let !aw_40 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                      applyWrapper aw_40 []
                                                                                                                            _ -> throwError "if: expected boolean")))
                                      !appl_41 <- kl_V2444 `pseq` kl_shen_LBpremiseRB kl_V2444
                                      !appl_42 <- appl_41 `pseq` applyWrapper appl_14 [appl_41]
                                      appl_42 `pseq` applyWrapper appl_0 [appl_42]

kl_shen_LBsemicolon_symbolRB :: Types.KLValue ->
                                Types.KLContext Types.Env Types.KLValue
kl_shen_LBsemicolon_symbolRB (!kl_V2446) = do !appl_0 <- kl_V2446 `pseq` hd kl_V2446
                                              !kl_if_1 <- appl_0 `pseq` consP appl_0
                                              case kl_if_1 of
                                                  Atom (B (True)) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Parse_X) -> do let pat_cond_3 = do !appl_4 <- kl_V2446 `pseq` hd kl_V2446
                                                                                                                                                              !appl_5 <- appl_4 `pseq` tl appl_4
                                                                                                                                                              let !aw_6 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                              !appl_7 <- kl_V2446 `pseq` applyWrapper aw_6 [kl_V2446]
                                                                                                                                                              let !aw_8 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                              !appl_9 <- appl_5 `pseq` (appl_7 `pseq` applyWrapper aw_8 [appl_5,
                                                                                                                                                                                                                         appl_7])
                                                                                                                                                              !appl_10 <- appl_9 `pseq` hd appl_9
                                                                                                                                                              let !aw_11 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                              appl_10 `pseq` applyWrapper aw_11 [appl_10,
                                                                                                                                                                                                 Types.Atom (Types.UnboundSym "shen.skip")]
                                                                                                                                              pat_cond_12 = do do let !aw_13 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                  applyWrapper aw_13 []
                                                                                                                                           in case kl_Parse_X of
                                                                                                                                                  kl_Parse_X@(Atom (UnboundSym ";")) -> pat_cond_3
                                                                                                                                                  kl_Parse_X@(ApplC (PL ";"
                                                                                                                                                                        _)) -> pat_cond_3
                                                                                                                                                  kl_Parse_X@(ApplC (Func ";"
                                                                                                                                                                          _)) -> pat_cond_3
                                                                                                                                                  _ -> pat_cond_12)))
                                                                        !appl_14 <- kl_V2446 `pseq` hd kl_V2446
                                                                        !appl_15 <- appl_14 `pseq` hd appl_14
                                                                        appl_15 `pseq` applyWrapper appl_2 [appl_15]
                                                  Atom (B (False)) -> do do let !aw_16 = Types.Atom (Types.UnboundSym "fail")
                                                                            applyWrapper aw_16 []
                                                  _ -> throwError "if: expected boolean"

kl_shen_LBpremiseRB :: Types.KLValue ->
                       Types.KLContext Types.Env Types.KLValue
kl_shen_LBpremiseRB (!kl_V2448) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do let !aw_1 = Types.Atom (Types.UnboundSym "fail")
                                                                                                         !appl_2 <- applyWrapper aw_1 []
                                                                                                         !kl_if_3 <- kl_YaccParse `pseq` (appl_2 `pseq` eq kl_YaccParse appl_2)
                                                                                                         case kl_if_3 of
                                                                                                             Atom (B (True)) -> do let !appl_4 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do let !aw_5 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                       !appl_6 <- applyWrapper aw_5 []
                                                                                                                                                                                                       !kl_if_7 <- kl_YaccParse `pseq` (appl_6 `pseq` eq kl_YaccParse appl_6)
                                                                                                                                                                                                       case kl_if_7 of
                                                                                                                                                                                                           Atom (B (True)) -> do let !appl_8 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBformulaRB) -> do let !aw_9 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                                  !appl_10 <- applyWrapper aw_9 []
                                                                                                                                                                                                                                                                                                                  !appl_11 <- appl_10 `pseq` (kl_Parse_shen_LBformulaRB `pseq` eq appl_10 kl_Parse_shen_LBformulaRB)
                                                                                                                                                                                                                                                                                                                  !kl_if_12 <- appl_11 `pseq` kl_not appl_11
                                                                                                                                                                                                                                                                                                                  case kl_if_12 of
                                                                                                                                                                                                                                                                                                                      Atom (B (True)) -> do !appl_13 <- kl_Parse_shen_LBformulaRB `pseq` hd kl_Parse_shen_LBformulaRB
                                                                                                                                                                                                                                                                                                                                            let !aw_14 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                                                                                                            !appl_15 <- kl_Parse_shen_LBformulaRB `pseq` applyWrapper aw_14 [kl_Parse_shen_LBformulaRB]
                                                                                                                                                                                                                                                                                                                                            !appl_16 <- appl_15 `pseq` kl_shen_sequent (Types.Atom Types.Nil) appl_15
                                                                                                                                                                                                                                                                                                                                            let !aw_17 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                                                                                                                                                                                            appl_13 `pseq` (appl_16 `pseq` applyWrapper aw_17 [appl_13,
                                                                                                                                                                                                                                                                                                                                                                                               appl_16])
                                                                                                                                                                                                                                                                                                                      Atom (B (False)) -> do do let !aw_18 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                                                                applyWrapper aw_18 []
                                                                                                                                                                                                                                                                                                                      _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                 !appl_19 <- kl_V2448 `pseq` kl_shen_LBformulaRB kl_V2448
                                                                                                                                                                                                                                 appl_19 `pseq` applyWrapper appl_8 [appl_19]
                                                                                                                                                                                                           Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                                                                                                           _ -> throwError "if: expected boolean")))
                                                                                                                                   let !appl_20 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBformulaeRB) -> do let !aw_21 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                      !appl_22 <- applyWrapper aw_21 []
                                                                                                                                                                                                                      !appl_23 <- appl_22 `pseq` (kl_Parse_shen_LBformulaeRB `pseq` eq appl_22 kl_Parse_shen_LBformulaeRB)
                                                                                                                                                                                                                      !kl_if_24 <- appl_23 `pseq` kl_not appl_23
                                                                                                                                                                                                                      case kl_if_24 of
                                                                                                                                                                                                                          Atom (B (True)) -> do !appl_25 <- kl_Parse_shen_LBformulaeRB `pseq` hd kl_Parse_shen_LBformulaeRB
                                                                                                                                                                                                                                                !kl_if_26 <- appl_25 `pseq` consP appl_25
                                                                                                                                                                                                                                                !kl_if_27 <- case kl_if_26 of
                                                                                                                                                                                                                                                                 Atom (B (True)) -> do !appl_28 <- kl_Parse_shen_LBformulaeRB `pseq` hd kl_Parse_shen_LBformulaeRB
                                                                                                                                                                                                                                                                                       !appl_29 <- appl_28 `pseq` hd appl_28
                                                                                                                                                                                                                                                                                       !kl_if_30 <- appl_29 `pseq` eq (Types.Atom (Types.UnboundSym ">>")) appl_29
                                                                                                                                                                                                                                                                                       case kl_if_30 of
                                                                                                                                                                                                                                                                                           Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                                           Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                           _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                 Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                 _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                case kl_if_27 of
                                                                                                                                                                                                                                                    Atom (B (True)) -> do let !appl_31 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBformulaRB) -> do let !aw_32 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                                                                            !appl_33 <- applyWrapper aw_32 []
                                                                                                                                                                                                                                                                                                                                                            !appl_34 <- appl_33 `pseq` (kl_Parse_shen_LBformulaRB `pseq` eq appl_33 kl_Parse_shen_LBformulaRB)
                                                                                                                                                                                                                                                                                                                                                            !kl_if_35 <- appl_34 `pseq` kl_not appl_34
                                                                                                                                                                                                                                                                                                                                                            case kl_if_35 of
                                                                                                                                                                                                                                                                                                                                                                Atom (B (True)) -> do !appl_36 <- kl_Parse_shen_LBformulaRB `pseq` hd kl_Parse_shen_LBformulaRB
                                                                                                                                                                                                                                                                                                                                                                                      let !aw_37 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                                                                                                                                                      !appl_38 <- kl_Parse_shen_LBformulaeRB `pseq` applyWrapper aw_37 [kl_Parse_shen_LBformulaeRB]
                                                                                                                                                                                                                                                                                                                                                                                      let !aw_39 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                                                                                                                                                      !appl_40 <- kl_Parse_shen_LBformulaRB `pseq` applyWrapper aw_39 [kl_Parse_shen_LBformulaRB]
                                                                                                                                                                                                                                                                                                                                                                                      !appl_41 <- appl_38 `pseq` (appl_40 `pseq` kl_shen_sequent appl_38 appl_40)
                                                                                                                                                                                                                                                                                                                                                                                      let !aw_42 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                                                                                                                                                                                                                                      appl_36 `pseq` (appl_41 `pseq` applyWrapper aw_42 [appl_36,
                                                                                                                                                                                                                                                                                                                                                                                                                                         appl_41])
                                                                                                                                                                                                                                                                                                                                                                Atom (B (False)) -> do do let !aw_43 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                                                                                                          applyWrapper aw_43 []
                                                                                                                                                                                                                                                                                                                                                                _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                          !appl_44 <- kl_Parse_shen_LBformulaeRB `pseq` hd kl_Parse_shen_LBformulaeRB
                                                                                                                                                                                                                                                                          !appl_45 <- appl_44 `pseq` tl appl_44
                                                                                                                                                                                                                                                                          let !aw_46 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                                          !appl_47 <- kl_Parse_shen_LBformulaeRB `pseq` applyWrapper aw_46 [kl_Parse_shen_LBformulaeRB]
                                                                                                                                                                                                                                                                          let !aw_48 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                                                                                                                          !appl_49 <- appl_45 `pseq` (appl_47 `pseq` applyWrapper aw_48 [appl_45,
                                                                                                                                                                                                                                                                                                                                         appl_47])
                                                                                                                                                                                                                                                                          !appl_50 <- appl_49 `pseq` kl_shen_LBformulaRB appl_49
                                                                                                                                                                                                                                                                          appl_50 `pseq` applyWrapper appl_31 [appl_50]
                                                                                                                                                                                                                                                    Atom (B (False)) -> do do let !aw_51 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                              applyWrapper aw_51 []
                                                                                                                                                                                                                                                    _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                          Atom (B (False)) -> do do let !aw_52 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                    applyWrapper aw_52 []
                                                                                                                                                                                                                          _ -> throwError "if: expected boolean")))
                                                                                                                                   !appl_53 <- kl_V2448 `pseq` kl_shen_LBformulaeRB kl_V2448
                                                                                                                                   !appl_54 <- appl_53 `pseq` applyWrapper appl_20 [appl_53]
                                                                                                                                   appl_54 `pseq` applyWrapper appl_4 [appl_54]
                                                                                                             Atom (B (False)) -> do do return kl_YaccParse
                                                                                                             _ -> throwError "if: expected boolean")))
                                     !appl_55 <- kl_V2448 `pseq` hd kl_V2448
                                     !kl_if_56 <- appl_55 `pseq` consP appl_55
                                     !kl_if_57 <- case kl_if_56 of
                                                      Atom (B (True)) -> do !appl_58 <- kl_V2448 `pseq` hd kl_V2448
                                                                            !appl_59 <- appl_58 `pseq` hd appl_58
                                                                            !kl_if_60 <- appl_59 `pseq` eq (Types.Atom (Types.UnboundSym "!")) appl_59
                                                                            case kl_if_60 of
                                                                                Atom (B (True)) -> do return (Atom (B True))
                                                                                Atom (B (False)) -> do do return (Atom (B False))
                                                                                _ -> throwError "if: expected boolean"
                                                      Atom (B (False)) -> do do return (Atom (B False))
                                                      _ -> throwError "if: expected boolean"
                                     !appl_61 <- case kl_if_57 of
                                                     Atom (B (True)) -> do !appl_62 <- kl_V2448 `pseq` hd kl_V2448
                                                                           !appl_63 <- appl_62 `pseq` tl appl_62
                                                                           let !aw_64 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                           !appl_65 <- kl_V2448 `pseq` applyWrapper aw_64 [kl_V2448]
                                                                           let !aw_66 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                           !appl_67 <- appl_63 `pseq` (appl_65 `pseq` applyWrapper aw_66 [appl_63,
                                                                                                                                          appl_65])
                                                                           !appl_68 <- appl_67 `pseq` hd appl_67
                                                                           let !aw_69 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                           appl_68 `pseq` applyWrapper aw_69 [appl_68,
                                                                                                              Types.Atom (Types.UnboundSym "!")]
                                                     Atom (B (False)) -> do do let !aw_70 = Types.Atom (Types.UnboundSym "fail")
                                                                               applyWrapper aw_70 []
                                                     _ -> throwError "if: expected boolean"
                                     appl_61 `pseq` applyWrapper appl_0 [appl_61]

kl_shen_LBconclusionRB :: Types.KLValue ->
                          Types.KLContext Types.Env Types.KLValue
kl_shen_LBconclusionRB (!kl_V2450) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do let !aw_1 = Types.Atom (Types.UnboundSym "fail")
                                                                                                            !appl_2 <- applyWrapper aw_1 []
                                                                                                            !kl_if_3 <- kl_YaccParse `pseq` (appl_2 `pseq` eq kl_YaccParse appl_2)
                                                                                                            case kl_if_3 of
                                                                                                                Atom (B (True)) -> do let !appl_4 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBformulaRB) -> do let !aw_5 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                       !appl_6 <- applyWrapper aw_5 []
                                                                                                                                                                                                                       !appl_7 <- appl_6 `pseq` (kl_Parse_shen_LBformulaRB `pseq` eq appl_6 kl_Parse_shen_LBformulaRB)
                                                                                                                                                                                                                       !kl_if_8 <- appl_7 `pseq` kl_not appl_7
                                                                                                                                                                                                                       case kl_if_8 of
                                                                                                                                                                                                                           Atom (B (True)) -> do let !appl_9 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBsemicolon_symbolRB) -> do let !aw_10 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                                                           !appl_11 <- applyWrapper aw_10 []
                                                                                                                                                                                                                                                                                                                                           !appl_12 <- appl_11 `pseq` (kl_Parse_shen_LBsemicolon_symbolRB `pseq` eq appl_11 kl_Parse_shen_LBsemicolon_symbolRB)
                                                                                                                                                                                                                                                                                                                                           !kl_if_13 <- appl_12 `pseq` kl_not appl_12
                                                                                                                                                                                                                                                                                                                                           case kl_if_13 of
                                                                                                                                                                                                                                                                                                                                               Atom (B (True)) -> do !appl_14 <- kl_Parse_shen_LBsemicolon_symbolRB `pseq` hd kl_Parse_shen_LBsemicolon_symbolRB
                                                                                                                                                                                                                                                                                                                                                                     let !aw_15 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                                                                                                                                     !appl_16 <- kl_Parse_shen_LBformulaRB `pseq` applyWrapper aw_15 [kl_Parse_shen_LBformulaRB]
                                                                                                                                                                                                                                                                                                                                                                     !appl_17 <- appl_16 `pseq` kl_shen_sequent (Types.Atom Types.Nil) appl_16
                                                                                                                                                                                                                                                                                                                                                                     let !aw_18 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                                                                                                                                                                                                                     appl_14 `pseq` (appl_17 `pseq` applyWrapper aw_18 [appl_14,
                                                                                                                                                                                                                                                                                                                                                                                                                        appl_17])
                                                                                                                                                                                                                                                                                                                                               Atom (B (False)) -> do do let !aw_19 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                                                                                         applyWrapper aw_19 []
                                                                                                                                                                                                                                                                                                                                               _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                 !appl_20 <- kl_Parse_shen_LBformulaRB `pseq` kl_shen_LBsemicolon_symbolRB kl_Parse_shen_LBformulaRB
                                                                                                                                                                                                                                                 appl_20 `pseq` applyWrapper appl_9 [appl_20]
                                                                                                                                                                                                                           Atom (B (False)) -> do do let !aw_21 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                     applyWrapper aw_21 []
                                                                                                                                                                                                                           _ -> throwError "if: expected boolean")))
                                                                                                                                      !appl_22 <- kl_V2450 `pseq` kl_shen_LBformulaRB kl_V2450
                                                                                                                                      appl_22 `pseq` applyWrapper appl_4 [appl_22]
                                                                                                                Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                _ -> throwError "if: expected boolean")))
                                        let !appl_23 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBformulaeRB) -> do let !aw_24 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                           !appl_25 <- applyWrapper aw_24 []
                                                                                                                           !appl_26 <- appl_25 `pseq` (kl_Parse_shen_LBformulaeRB `pseq` eq appl_25 kl_Parse_shen_LBformulaeRB)
                                                                                                                           !kl_if_27 <- appl_26 `pseq` kl_not appl_26
                                                                                                                           case kl_if_27 of
                                                                                                                               Atom (B (True)) -> do !appl_28 <- kl_Parse_shen_LBformulaeRB `pseq` hd kl_Parse_shen_LBformulaeRB
                                                                                                                                                     !kl_if_29 <- appl_28 `pseq` consP appl_28
                                                                                                                                                     !kl_if_30 <- case kl_if_29 of
                                                                                                                                                                      Atom (B (True)) -> do !appl_31 <- kl_Parse_shen_LBformulaeRB `pseq` hd kl_Parse_shen_LBformulaeRB
                                                                                                                                                                                            !appl_32 <- appl_31 `pseq` hd appl_31
                                                                                                                                                                                            !kl_if_33 <- appl_32 `pseq` eq (Types.Atom (Types.UnboundSym ">>")) appl_32
                                                                                                                                                                                            case kl_if_33 of
                                                                                                                                                                                                Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                _ -> throwError "if: expected boolean"
                                                                                                                                                                      Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                      _ -> throwError "if: expected boolean"
                                                                                                                                                     case kl_if_30 of
                                                                                                                                                         Atom (B (True)) -> do let !appl_34 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBformulaRB) -> do let !aw_35 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                 !appl_36 <- applyWrapper aw_35 []
                                                                                                                                                                                                                                                                 !appl_37 <- appl_36 `pseq` (kl_Parse_shen_LBformulaRB `pseq` eq appl_36 kl_Parse_shen_LBformulaRB)
                                                                                                                                                                                                                                                                 !kl_if_38 <- appl_37 `pseq` kl_not appl_37
                                                                                                                                                                                                                                                                 case kl_if_38 of
                                                                                                                                                                                                                                                                     Atom (B (True)) -> do let !appl_39 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBsemicolon_symbolRB) -> do let !aw_40 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                                                                                                      !appl_41 <- applyWrapper aw_40 []
                                                                                                                                                                                                                                                                                                                                                                                      !appl_42 <- appl_41 `pseq` (kl_Parse_shen_LBsemicolon_symbolRB `pseq` eq appl_41 kl_Parse_shen_LBsemicolon_symbolRB)
                                                                                                                                                                                                                                                                                                                                                                                      !kl_if_43 <- appl_42 `pseq` kl_not appl_42
                                                                                                                                                                                                                                                                                                                                                                                      case kl_if_43 of
                                                                                                                                                                                                                                                                                                                                                                                          Atom (B (True)) -> do !appl_44 <- kl_Parse_shen_LBsemicolon_symbolRB `pseq` hd kl_Parse_shen_LBsemicolon_symbolRB
                                                                                                                                                                                                                                                                                                                                                                                                                let !aw_45 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                                                                                                                                                                                !appl_46 <- kl_Parse_shen_LBformulaeRB `pseq` applyWrapper aw_45 [kl_Parse_shen_LBformulaeRB]
                                                                                                                                                                                                                                                                                                                                                                                                                let !aw_47 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                                                                                                                                                                                !appl_48 <- kl_Parse_shen_LBformulaRB `pseq` applyWrapper aw_47 [kl_Parse_shen_LBformulaRB]
                                                                                                                                                                                                                                                                                                                                                                                                                !appl_49 <- appl_46 `pseq` (appl_48 `pseq` kl_shen_sequent appl_46 appl_48)
                                                                                                                                                                                                                                                                                                                                                                                                                let !aw_50 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                                                                                                                                                                                                                                                                appl_44 `pseq` (appl_49 `pseq` applyWrapper aw_50 [appl_44,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                   appl_49])
                                                                                                                                                                                                                                                                                                                                                                                          Atom (B (False)) -> do do let !aw_51 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                                                                                                                                    applyWrapper aw_51 []
                                                                                                                                                                                                                                                                                                                                                                                          _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                                           !appl_52 <- kl_Parse_shen_LBformulaRB `pseq` kl_shen_LBsemicolon_symbolRB kl_Parse_shen_LBformulaRB
                                                                                                                                                                                                                                                                                           appl_52 `pseq` applyWrapper appl_39 [appl_52]
                                                                                                                                                                                                                                                                     Atom (B (False)) -> do do let !aw_53 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                               applyWrapper aw_53 []
                                                                                                                                                                                                                                                                     _ -> throwError "if: expected boolean")))
                                                                                                                                                                               !appl_54 <- kl_Parse_shen_LBformulaeRB `pseq` hd kl_Parse_shen_LBformulaeRB
                                                                                                                                                                               !appl_55 <- appl_54 `pseq` tl appl_54
                                                                                                                                                                               let !aw_56 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                               !appl_57 <- kl_Parse_shen_LBformulaeRB `pseq` applyWrapper aw_56 [kl_Parse_shen_LBformulaeRB]
                                                                                                                                                                               let !aw_58 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                               !appl_59 <- appl_55 `pseq` (appl_57 `pseq` applyWrapper aw_58 [appl_55,
                                                                                                                                                                                                                                              appl_57])
                                                                                                                                                                               !appl_60 <- appl_59 `pseq` kl_shen_LBformulaRB appl_59
                                                                                                                                                                               appl_60 `pseq` applyWrapper appl_34 [appl_60]
                                                                                                                                                         Atom (B (False)) -> do do let !aw_61 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                   applyWrapper aw_61 []
                                                                                                                                                         _ -> throwError "if: expected boolean"
                                                                                                                               Atom (B (False)) -> do do let !aw_62 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                         applyWrapper aw_62 []
                                                                                                                               _ -> throwError "if: expected boolean")))
                                        !appl_63 <- kl_V2450 `pseq` kl_shen_LBformulaeRB kl_V2450
                                        !appl_64 <- appl_63 `pseq` applyWrapper appl_23 [appl_63]
                                        appl_64 `pseq` applyWrapper appl_0 [appl_64]

kl_shen_sequent :: Types.KLValue ->
                   Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_sequent (!kl_V2453) (!kl_V2454) = do kl_V2453 `pseq` (kl_V2454 `pseq` kl_Atp kl_V2453 kl_V2454)

kl_shen_LBformulaeRB :: Types.KLValue ->
                        Types.KLContext Types.Env Types.KLValue
kl_shen_LBformulaeRB (!kl_V2456) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do let !aw_1 = Types.Atom (Types.UnboundSym "fail")
                                                                                                          !appl_2 <- applyWrapper aw_1 []
                                                                                                          !kl_if_3 <- kl_YaccParse `pseq` (appl_2 `pseq` eq kl_YaccParse appl_2)
                                                                                                          case kl_if_3 of
                                                                                                              Atom (B (True)) -> do let !appl_4 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do let !aw_5 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                        !appl_6 <- applyWrapper aw_5 []
                                                                                                                                                                                                        !kl_if_7 <- kl_YaccParse `pseq` (appl_6 `pseq` eq kl_YaccParse appl_6)
                                                                                                                                                                                                        case kl_if_7 of
                                                                                                                                                                                                            Atom (B (True)) -> do let !appl_8 = ApplC (Func "lambda" (Context (\(!kl_Parse_LBeRB) -> do let !aw_9 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                        !appl_10 <- applyWrapper aw_9 []
                                                                                                                                                                                                                                                                                                        !appl_11 <- appl_10 `pseq` (kl_Parse_LBeRB `pseq` eq appl_10 kl_Parse_LBeRB)
                                                                                                                                                                                                                                                                                                        !kl_if_12 <- appl_11 `pseq` kl_not appl_11
                                                                                                                                                                                                                                                                                                        case kl_if_12 of
                                                                                                                                                                                                                                                                                                            Atom (B (True)) -> do !appl_13 <- kl_Parse_LBeRB `pseq` hd kl_Parse_LBeRB
                                                                                                                                                                                                                                                                                                                                  let !aw_14 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                                                                                                                                                                                  appl_13 `pseq` applyWrapper aw_14 [appl_13,
                                                                                                                                                                                                                                                                                                                                                                     Types.Atom Types.Nil]
                                                                                                                                                                                                                                                                                                            Atom (B (False)) -> do do let !aw_15 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                                                      applyWrapper aw_15 []
                                                                                                                                                                                                                                                                                                            _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                  let !aw_16 = Types.Atom (Types.UnboundSym "<e>")
                                                                                                                                                                                                                                  !appl_17 <- kl_V2456 `pseq` applyWrapper aw_16 [kl_V2456]
                                                                                                                                                                                                                                  appl_17 `pseq` applyWrapper appl_8 [appl_17]
                                                                                                                                                                                                            Atom (B (False)) -> do do return kl_YaccParse
                                                                                                                                                                                                            _ -> throwError "if: expected boolean")))
                                                                                                                                    let !appl_18 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBformulaRB) -> do let !aw_19 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                      !appl_20 <- applyWrapper aw_19 []
                                                                                                                                                                                                                      !appl_21 <- appl_20 `pseq` (kl_Parse_shen_LBformulaRB `pseq` eq appl_20 kl_Parse_shen_LBformulaRB)
                                                                                                                                                                                                                      !kl_if_22 <- appl_21 `pseq` kl_not appl_21
                                                                                                                                                                                                                      case kl_if_22 of
                                                                                                                                                                                                                          Atom (B (True)) -> do !appl_23 <- kl_Parse_shen_LBformulaRB `pseq` hd kl_Parse_shen_LBformulaRB
                                                                                                                                                                                                                                                let !aw_24 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                !appl_25 <- kl_Parse_shen_LBformulaRB `pseq` applyWrapper aw_24 [kl_Parse_shen_LBformulaRB]
                                                                                                                                                                                                                                                !appl_26 <- appl_25 `pseq` klCons appl_25 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                let !aw_27 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                                                                                                appl_23 `pseq` (appl_26 `pseq` applyWrapper aw_27 [appl_23,
                                                                                                                                                                                                                                                                                                   appl_26])
                                                                                                                                                                                                                          Atom (B (False)) -> do do let !aw_28 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                    applyWrapper aw_28 []
                                                                                                                                                                                                                          _ -> throwError "if: expected boolean")))
                                                                                                                                    !appl_29 <- kl_V2456 `pseq` kl_shen_LBformulaRB kl_V2456
                                                                                                                                    !appl_30 <- appl_29 `pseq` applyWrapper appl_18 [appl_29]
                                                                                                                                    appl_30 `pseq` applyWrapper appl_4 [appl_30]
                                                                                                              Atom (B (False)) -> do do return kl_YaccParse
                                                                                                              _ -> throwError "if: expected boolean")))
                                      let !appl_31 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBformulaRB) -> do let !aw_32 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                        !appl_33 <- applyWrapper aw_32 []
                                                                                                                        !appl_34 <- appl_33 `pseq` (kl_Parse_shen_LBformulaRB `pseq` eq appl_33 kl_Parse_shen_LBformulaRB)
                                                                                                                        !kl_if_35 <- appl_34 `pseq` kl_not appl_34
                                                                                                                        case kl_if_35 of
                                                                                                                            Atom (B (True)) -> do let !appl_36 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBcomma_symbolRB) -> do let !aw_37 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                         !appl_38 <- applyWrapper aw_37 []
                                                                                                                                                                                                                                         !appl_39 <- appl_38 `pseq` (kl_Parse_shen_LBcomma_symbolRB `pseq` eq appl_38 kl_Parse_shen_LBcomma_symbolRB)
                                                                                                                                                                                                                                         !kl_if_40 <- appl_39 `pseq` kl_not appl_39
                                                                                                                                                                                                                                         case kl_if_40 of
                                                                                                                                                                                                                                             Atom (B (True)) -> do let !appl_41 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBformulaeRB) -> do let !aw_42 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                                                                      !appl_43 <- applyWrapper aw_42 []
                                                                                                                                                                                                                                                                                                                                                      !appl_44 <- appl_43 `pseq` (kl_Parse_shen_LBformulaeRB `pseq` eq appl_43 kl_Parse_shen_LBformulaeRB)
                                                                                                                                                                                                                                                                                                                                                      !kl_if_45 <- appl_44 `pseq` kl_not appl_44
                                                                                                                                                                                                                                                                                                                                                      case kl_if_45 of
                                                                                                                                                                                                                                                                                                                                                          Atom (B (True)) -> do !appl_46 <- kl_Parse_shen_LBformulaeRB `pseq` hd kl_Parse_shen_LBformulaeRB
                                                                                                                                                                                                                                                                                                                                                                                let !aw_47 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                                                                                                                                                !appl_48 <- kl_Parse_shen_LBformulaRB `pseq` applyWrapper aw_47 [kl_Parse_shen_LBformulaRB]
                                                                                                                                                                                                                                                                                                                                                                                let !aw_49 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                                                                                                                                                !appl_50 <- kl_Parse_shen_LBformulaeRB `pseq` applyWrapper aw_49 [kl_Parse_shen_LBformulaeRB]
                                                                                                                                                                                                                                                                                                                                                                                !appl_51 <- appl_48 `pseq` (appl_50 `pseq` klCons appl_48 appl_50)
                                                                                                                                                                                                                                                                                                                                                                                let !aw_52 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                                                                                                                                                                                                                                appl_46 `pseq` (appl_51 `pseq` applyWrapper aw_52 [appl_46,
                                                                                                                                                                                                                                                                                                                                                                                                                                   appl_51])
                                                                                                                                                                                                                                                                                                                                                          Atom (B (False)) -> do do let !aw_53 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                                                                                                                    applyWrapper aw_53 []
                                                                                                                                                                                                                                                                                                                                                          _ -> throwError "if: expected boolean")))
                                                                                                                                                                                                                                                                   !appl_54 <- kl_Parse_shen_LBcomma_symbolRB `pseq` kl_shen_LBformulaeRB kl_Parse_shen_LBcomma_symbolRB
                                                                                                                                                                                                                                                                   appl_54 `pseq` applyWrapper appl_41 [appl_54]
                                                                                                                                                                                                                                             Atom (B (False)) -> do do let !aw_55 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                       applyWrapper aw_55 []
                                                                                                                                                                                                                                             _ -> throwError "if: expected boolean")))
                                                                                                                                                  !appl_56 <- kl_Parse_shen_LBformulaRB `pseq` kl_shen_LBcomma_symbolRB kl_Parse_shen_LBformulaRB
                                                                                                                                                  appl_56 `pseq` applyWrapper appl_36 [appl_56]
                                                                                                                            Atom (B (False)) -> do do let !aw_57 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                      applyWrapper aw_57 []
                                                                                                                            _ -> throwError "if: expected boolean")))
                                      !appl_58 <- kl_V2456 `pseq` kl_shen_LBformulaRB kl_V2456
                                      !appl_59 <- appl_58 `pseq` applyWrapper appl_31 [appl_58]
                                      appl_59 `pseq` applyWrapper appl_0 [appl_59]

kl_shen_LBcomma_symbolRB :: Types.KLValue ->
                            Types.KLContext Types.Env Types.KLValue
kl_shen_LBcomma_symbolRB (!kl_V2458) = do !appl_0 <- kl_V2458 `pseq` hd kl_V2458
                                          !kl_if_1 <- appl_0 `pseq` consP appl_0
                                          case kl_if_1 of
                                              Atom (B (True)) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Parse_X) -> do !appl_3 <- intern (Types.Atom (Types.Str ","))
                                                                                                                                      !kl_if_4 <- kl_Parse_X `pseq` (appl_3 `pseq` eq kl_Parse_X appl_3)
                                                                                                                                      case kl_if_4 of
                                                                                                                                          Atom (B (True)) -> do !appl_5 <- kl_V2458 `pseq` hd kl_V2458
                                                                                                                                                                !appl_6 <- appl_5 `pseq` tl appl_5
                                                                                                                                                                let !aw_7 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                !appl_8 <- kl_V2458 `pseq` applyWrapper aw_7 [kl_V2458]
                                                                                                                                                                let !aw_9 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                !appl_10 <- appl_6 `pseq` (appl_8 `pseq` applyWrapper aw_9 [appl_6,
                                                                                                                                                                                                                            appl_8])
                                                                                                                                                                !appl_11 <- appl_10 `pseq` hd appl_10
                                                                                                                                                                let !aw_12 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                appl_11 `pseq` applyWrapper aw_12 [appl_11,
                                                                                                                                                                                                   Types.Atom (Types.UnboundSym "shen.skip")]
                                                                                                                                          Atom (B (False)) -> do do let !aw_13 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                    applyWrapper aw_13 []
                                                                                                                                          _ -> throwError "if: expected boolean")))
                                                                    !appl_14 <- kl_V2458 `pseq` hd kl_V2458
                                                                    !appl_15 <- appl_14 `pseq` hd appl_14
                                                                    appl_15 `pseq` applyWrapper appl_2 [appl_15]
                                              Atom (B (False)) -> do do let !aw_16 = Types.Atom (Types.UnboundSym "fail")
                                                                        applyWrapper aw_16 []
                                              _ -> throwError "if: expected boolean"

kl_shen_LBformulaRB :: Types.KLValue ->
                       Types.KLContext Types.Env Types.KLValue
kl_shen_LBformulaRB (!kl_V2460) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_YaccParse) -> do let !aw_1 = Types.Atom (Types.UnboundSym "fail")
                                                                                                         !appl_2 <- applyWrapper aw_1 []
                                                                                                         !kl_if_3 <- kl_YaccParse `pseq` (appl_2 `pseq` eq kl_YaccParse appl_2)
                                                                                                         case kl_if_3 of
                                                                                                             Atom (B (True)) -> do let !appl_4 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBexprRB) -> do let !aw_5 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                 !appl_6 <- applyWrapper aw_5 []
                                                                                                                                                                                                                 !appl_7 <- appl_6 `pseq` (kl_Parse_shen_LBexprRB `pseq` eq appl_6 kl_Parse_shen_LBexprRB)
                                                                                                                                                                                                                 !kl_if_8 <- appl_7 `pseq` kl_not appl_7
                                                                                                                                                                                                                 case kl_if_8 of
                                                                                                                                                                                                                     Atom (B (True)) -> do !appl_9 <- kl_Parse_shen_LBexprRB `pseq` hd kl_Parse_shen_LBexprRB
                                                                                                                                                                                                                                           let !aw_10 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                           !appl_11 <- kl_Parse_shen_LBexprRB `pseq` applyWrapper aw_10 [kl_Parse_shen_LBexprRB]
                                                                                                                                                                                                                                           let !aw_12 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                                                                                           appl_9 `pseq` (appl_11 `pseq` applyWrapper aw_12 [appl_9,
                                                                                                                                                                                                                                                                                             appl_11])
                                                                                                                                                                                                                     Atom (B (False)) -> do do let !aw_13 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                               applyWrapper aw_13 []
                                                                                                                                                                                                                     _ -> throwError "if: expected boolean")))
                                                                                                                                   !appl_14 <- kl_V2460 `pseq` kl_shen_LBexprRB kl_V2460
                                                                                                                                   appl_14 `pseq` applyWrapper appl_4 [appl_14]
                                                                                                             Atom (B (False)) -> do do return kl_YaccParse
                                                                                                             _ -> throwError "if: expected boolean")))
                                     let !appl_15 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBexprRB) -> do let !aw_16 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                    !appl_17 <- applyWrapper aw_16 []
                                                                                                                    !appl_18 <- appl_17 `pseq` (kl_Parse_shen_LBexprRB `pseq` eq appl_17 kl_Parse_shen_LBexprRB)
                                                                                                                    !kl_if_19 <- appl_18 `pseq` kl_not appl_18
                                                                                                                    case kl_if_19 of
                                                                                                                        Atom (B (True)) -> do !appl_20 <- kl_Parse_shen_LBexprRB `pseq` hd kl_Parse_shen_LBexprRB
                                                                                                                                              !kl_if_21 <- appl_20 `pseq` consP appl_20
                                                                                                                                              !kl_if_22 <- case kl_if_21 of
                                                                                                                                                               Atom (B (True)) -> do !appl_23 <- kl_Parse_shen_LBexprRB `pseq` hd kl_Parse_shen_LBexprRB
                                                                                                                                                                                     !appl_24 <- appl_23 `pseq` hd appl_23
                                                                                                                                                                                     !kl_if_25 <- appl_24 `pseq` eq (Types.Atom (Types.UnboundSym ":")) appl_24
                                                                                                                                                                                     case kl_if_25 of
                                                                                                                                                                                         Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                         Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                         _ -> throwError "if: expected boolean"
                                                                                                                                                               Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                               _ -> throwError "if: expected boolean"
                                                                                                                                              case kl_if_22 of
                                                                                                                                                  Atom (B (True)) -> do let !appl_26 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBtypeRB) -> do let !aw_27 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                       !appl_28 <- applyWrapper aw_27 []
                                                                                                                                                                                                                                                       !appl_29 <- appl_28 `pseq` (kl_Parse_shen_LBtypeRB `pseq` eq appl_28 kl_Parse_shen_LBtypeRB)
                                                                                                                                                                                                                                                       !kl_if_30 <- appl_29 `pseq` kl_not appl_29
                                                                                                                                                                                                                                                       case kl_if_30 of
                                                                                                                                                                                                                                                           Atom (B (True)) -> do !appl_31 <- kl_Parse_shen_LBtypeRB `pseq` hd kl_Parse_shen_LBtypeRB
                                                                                                                                                                                                                                                                                 let !aw_32 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                                                 !appl_33 <- kl_Parse_shen_LBexprRB `pseq` applyWrapper aw_32 [kl_Parse_shen_LBexprRB]
                                                                                                                                                                                                                                                                                 let !aw_34 = Types.Atom (Types.UnboundSym "shen.curry")
                                                                                                                                                                                                                                                                                 !appl_35 <- appl_33 `pseq` applyWrapper aw_34 [appl_33]
                                                                                                                                                                                                                                                                                 let !aw_36 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                                                                                                                                 !appl_37 <- kl_Parse_shen_LBtypeRB `pseq` applyWrapper aw_36 [kl_Parse_shen_LBtypeRB]
                                                                                                                                                                                                                                                                                 let !aw_38 = Types.Atom (Types.UnboundSym "shen.demodulate")
                                                                                                                                                                                                                                                                                 !appl_39 <- appl_37 `pseq` applyWrapper aw_38 [appl_37]
                                                                                                                                                                                                                                                                                 !appl_40 <- appl_39 `pseq` klCons appl_39 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                 !appl_41 <- appl_40 `pseq` klCons (Types.Atom (Types.UnboundSym ":")) appl_40
                                                                                                                                                                                                                                                                                 !appl_42 <- appl_35 `pseq` (appl_41 `pseq` klCons appl_35 appl_41)
                                                                                                                                                                                                                                                                                 let !aw_43 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                                                                                                                                 appl_31 `pseq` (appl_42 `pseq` applyWrapper aw_43 [appl_31,
                                                                                                                                                                                                                                                                                                                                    appl_42])
                                                                                                                                                                                                                                                           Atom (B (False)) -> do do let !aw_44 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                                                                                                                                     applyWrapper aw_44 []
                                                                                                                                                                                                                                                           _ -> throwError "if: expected boolean")))
                                                                                                                                                                        !appl_45 <- kl_Parse_shen_LBexprRB `pseq` hd kl_Parse_shen_LBexprRB
                                                                                                                                                                        !appl_46 <- appl_45 `pseq` tl appl_45
                                                                                                                                                                        let !aw_47 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                        !appl_48 <- kl_Parse_shen_LBexprRB `pseq` applyWrapper aw_47 [kl_Parse_shen_LBexprRB]
                                                                                                                                                                        let !aw_49 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                        !appl_50 <- appl_46 `pseq` (appl_48 `pseq` applyWrapper aw_49 [appl_46,
                                                                                                                                                                                                                                       appl_48])
                                                                                                                                                                        !appl_51 <- appl_50 `pseq` kl_shen_LBtypeRB appl_50
                                                                                                                                                                        appl_51 `pseq` applyWrapper appl_26 [appl_51]
                                                                                                                                                  Atom (B (False)) -> do do let !aw_52 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                            applyWrapper aw_52 []
                                                                                                                                                  _ -> throwError "if: expected boolean"
                                                                                                                        Atom (B (False)) -> do do let !aw_53 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                  applyWrapper aw_53 []
                                                                                                                        _ -> throwError "if: expected boolean")))
                                     !appl_54 <- kl_V2460 `pseq` kl_shen_LBexprRB kl_V2460
                                     !appl_55 <- appl_54 `pseq` applyWrapper appl_15 [appl_54]
                                     appl_55 `pseq` applyWrapper appl_0 [appl_55]

kl_shen_LBtypeRB :: Types.KLValue ->
                    Types.KLContext Types.Env Types.KLValue
kl_shen_LBtypeRB (!kl_V2462) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_Parse_shen_LBexprRB) -> do let !aw_1 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                !appl_2 <- applyWrapper aw_1 []
                                                                                                                !appl_3 <- appl_2 `pseq` (kl_Parse_shen_LBexprRB `pseq` eq appl_2 kl_Parse_shen_LBexprRB)
                                                                                                                !kl_if_4 <- appl_3 `pseq` kl_not appl_3
                                                                                                                case kl_if_4 of
                                                                                                                    Atom (B (True)) -> do !appl_5 <- kl_Parse_shen_LBexprRB `pseq` hd kl_Parse_shen_LBexprRB
                                                                                                                                          let !aw_6 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                          !appl_7 <- kl_Parse_shen_LBexprRB `pseq` applyWrapper aw_6 [kl_Parse_shen_LBexprRB]
                                                                                                                                          !appl_8 <- appl_7 `pseq` kl_shen_curry_type appl_7
                                                                                                                                          let !aw_9 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                          appl_5 `pseq` (appl_8 `pseq` applyWrapper aw_9 [appl_5,
                                                                                                                                                                                          appl_8])
                                                                                                                    Atom (B (False)) -> do do let !aw_10 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                              applyWrapper aw_10 []
                                                                                                                    _ -> throwError "if: expected boolean")))
                                  !appl_11 <- kl_V2462 `pseq` kl_shen_LBexprRB kl_V2462
                                  appl_11 `pseq` applyWrapper appl_0 [appl_11]

kl_shen_LBdoubleunderlineRB :: Types.KLValue ->
                               Types.KLContext Types.Env Types.KLValue
kl_shen_LBdoubleunderlineRB (!kl_V2464) = do !appl_0 <- kl_V2464 `pseq` hd kl_V2464
                                             !kl_if_1 <- appl_0 `pseq` consP appl_0
                                             case kl_if_1 of
                                                 Atom (B (True)) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Parse_X) -> do !kl_if_3 <- kl_Parse_X `pseq` kl_shen_doubleunderlineP kl_Parse_X
                                                                                                                                         case kl_if_3 of
                                                                                                                                             Atom (B (True)) -> do !appl_4 <- kl_V2464 `pseq` hd kl_V2464
                                                                                                                                                                   !appl_5 <- appl_4 `pseq` tl appl_4
                                                                                                                                                                   let !aw_6 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                   !appl_7 <- kl_V2464 `pseq` applyWrapper aw_6 [kl_V2464]
                                                                                                                                                                   let !aw_8 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                   !appl_9 <- appl_5 `pseq` (appl_7 `pseq` applyWrapper aw_8 [appl_5,
                                                                                                                                                                                                                              appl_7])
                                                                                                                                                                   !appl_10 <- appl_9 `pseq` hd appl_9
                                                                                                                                                                   let !aw_11 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                   appl_10 `pseq` (kl_Parse_X `pseq` applyWrapper aw_11 [appl_10,
                                                                                                                                                                                                                         kl_Parse_X])
                                                                                                                                             Atom (B (False)) -> do do let !aw_12 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                       applyWrapper aw_12 []
                                                                                                                                             _ -> throwError "if: expected boolean")))
                                                                       !appl_13 <- kl_V2464 `pseq` hd kl_V2464
                                                                       !appl_14 <- appl_13 `pseq` hd appl_13
                                                                       appl_14 `pseq` applyWrapper appl_2 [appl_14]
                                                 Atom (B (False)) -> do do let !aw_15 = Types.Atom (Types.UnboundSym "fail")
                                                                           applyWrapper aw_15 []
                                                 _ -> throwError "if: expected boolean"

kl_shen_LBsingleunderlineRB :: Types.KLValue ->
                               Types.KLContext Types.Env Types.KLValue
kl_shen_LBsingleunderlineRB (!kl_V2466) = do !appl_0 <- kl_V2466 `pseq` hd kl_V2466
                                             !kl_if_1 <- appl_0 `pseq` consP appl_0
                                             case kl_if_1 of
                                                 Atom (B (True)) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Parse_X) -> do !kl_if_3 <- kl_Parse_X `pseq` kl_shen_singleunderlineP kl_Parse_X
                                                                                                                                         case kl_if_3 of
                                                                                                                                             Atom (B (True)) -> do !appl_4 <- kl_V2466 `pseq` hd kl_V2466
                                                                                                                                                                   !appl_5 <- appl_4 `pseq` tl appl_4
                                                                                                                                                                   let !aw_6 = Types.Atom (Types.UnboundSym "shen.hdtl")
                                                                                                                                                                   !appl_7 <- kl_V2466 `pseq` applyWrapper aw_6 [kl_V2466]
                                                                                                                                                                   let !aw_8 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                   !appl_9 <- appl_5 `pseq` (appl_7 `pseq` applyWrapper aw_8 [appl_5,
                                                                                                                                                                                                                              appl_7])
                                                                                                                                                                   !appl_10 <- appl_9 `pseq` hd appl_9
                                                                                                                                                                   let !aw_11 = Types.Atom (Types.UnboundSym "shen.pair")
                                                                                                                                                                   appl_10 `pseq` (kl_Parse_X `pseq` applyWrapper aw_11 [appl_10,
                                                                                                                                                                                                                         kl_Parse_X])
                                                                                                                                             Atom (B (False)) -> do do let !aw_12 = Types.Atom (Types.UnboundSym "fail")
                                                                                                                                                                       applyWrapper aw_12 []
                                                                                                                                             _ -> throwError "if: expected boolean")))
                                                                       !appl_13 <- kl_V2466 `pseq` hd kl_V2466
                                                                       !appl_14 <- appl_13 `pseq` hd appl_13
                                                                       appl_14 `pseq` applyWrapper appl_2 [appl_14]
                                                 Atom (B (False)) -> do do let !aw_15 = Types.Atom (Types.UnboundSym "fail")
                                                                           applyWrapper aw_15 []
                                                 _ -> throwError "if: expected boolean"

kl_shen_singleunderlineP :: Types.KLValue ->
                            Types.KLContext Types.Env Types.KLValue
kl_shen_singleunderlineP (!kl_V2468) = do !kl_if_0 <- kl_V2468 `pseq` kl_symbolP kl_V2468
                                          case kl_if_0 of
                                              Atom (B (True)) -> do !appl_1 <- kl_V2468 `pseq` str kl_V2468
                                                                    !kl_if_2 <- appl_1 `pseq` kl_shen_shP appl_1
                                                                    case kl_if_2 of
                                                                        Atom (B (True)) -> do return (Atom (B True))
                                                                        Atom (B (False)) -> do do return (Atom (B False))
                                                                        _ -> throwError "if: expected boolean"
                                              Atom (B (False)) -> do do return (Atom (B False))
                                              _ -> throwError "if: expected boolean"

kl_shen_shP :: Types.KLValue ->
               Types.KLContext Types.Env Types.KLValue
kl_shen_shP (!kl_V2470) = do let pat_cond_0 = do return (Atom (B True))
                                 pat_cond_1 = do do !appl_2 <- kl_V2470 `pseq` pos kl_V2470 (Types.Atom (Types.N (Types.KI 0)))
                                                    !kl_if_3 <- appl_2 `pseq` eq appl_2 (Types.Atom (Types.Str "_"))
                                                    case kl_if_3 of
                                                        Atom (B (True)) -> do !appl_4 <- kl_V2470 `pseq` tlstr kl_V2470
                                                                              !kl_if_5 <- appl_4 `pseq` kl_shen_shP appl_4
                                                                              case kl_if_5 of
                                                                                  Atom (B (True)) -> do return (Atom (B True))
                                                                                  Atom (B (False)) -> do do return (Atom (B False))
                                                                                  _ -> throwError "if: expected boolean"
                                                        Atom (B (False)) -> do do return (Atom (B False))
                                                        _ -> throwError "if: expected boolean"
                              in case kl_V2470 of
                                     kl_V2470@(Atom (Str "_")) -> pat_cond_0
                                     _ -> pat_cond_1

kl_shen_doubleunderlineP :: Types.KLValue ->
                            Types.KLContext Types.Env Types.KLValue
kl_shen_doubleunderlineP (!kl_V2472) = do !kl_if_0 <- kl_V2472 `pseq` kl_symbolP kl_V2472
                                          case kl_if_0 of
                                              Atom (B (True)) -> do !appl_1 <- kl_V2472 `pseq` str kl_V2472
                                                                    !kl_if_2 <- appl_1 `pseq` kl_shen_dhP appl_1
                                                                    case kl_if_2 of
                                                                        Atom (B (True)) -> do return (Atom (B True))
                                                                        Atom (B (False)) -> do do return (Atom (B False))
                                                                        _ -> throwError "if: expected boolean"
                                              Atom (B (False)) -> do do return (Atom (B False))
                                              _ -> throwError "if: expected boolean"

kl_shen_dhP :: Types.KLValue ->
               Types.KLContext Types.Env Types.KLValue
kl_shen_dhP (!kl_V2474) = do let pat_cond_0 = do return (Atom (B True))
                                 pat_cond_1 = do do !appl_2 <- kl_V2474 `pseq` pos kl_V2474 (Types.Atom (Types.N (Types.KI 0)))
                                                    !kl_if_3 <- appl_2 `pseq` eq appl_2 (Types.Atom (Types.Str "="))
                                                    case kl_if_3 of
                                                        Atom (B (True)) -> do !appl_4 <- kl_V2474 `pseq` tlstr kl_V2474
                                                                              !kl_if_5 <- appl_4 `pseq` kl_shen_dhP appl_4
                                                                              case kl_if_5 of
                                                                                  Atom (B (True)) -> do return (Atom (B True))
                                                                                  Atom (B (False)) -> do do return (Atom (B False))
                                                                                  _ -> throwError "if: expected boolean"
                                                        Atom (B (False)) -> do do return (Atom (B False))
                                                        _ -> throwError "if: expected boolean"
                              in case kl_V2474 of
                                     kl_V2474@(Atom (Str "=")) -> pat_cond_0
                                     _ -> pat_cond_1

kl_shen_process_datatype :: Types.KLValue ->
                            Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_process_datatype (!kl_V2477) (!kl_V2478) = do !appl_0 <- kl_V2477 `pseq` (kl_V2478 `pseq` kl_shen_rules_RBhorn_clauses kl_V2477 kl_V2478)
                                                      let !aw_1 = Types.Atom (Types.UnboundSym "shen.s-prolog")
                                                      !appl_2 <- appl_0 `pseq` applyWrapper aw_1 [appl_0]
                                                      appl_2 `pseq` kl_shen_remember_datatype appl_2

kl_shen_remember_datatype :: Types.KLValue ->
                             Types.KLContext Types.Env Types.KLValue
kl_shen_remember_datatype (!kl_V2484) = do let pat_cond_0 kl_V2484 kl_V2484h kl_V2484t = do !appl_1 <- value (Types.Atom (Types.UnboundSym "shen.*datatypes*"))
                                                                                            let !aw_2 = Types.Atom (Types.UnboundSym "adjoin")
                                                                                            !appl_3 <- kl_V2484h `pseq` (appl_1 `pseq` applyWrapper aw_2 [kl_V2484h,
                                                                                                                                                          appl_1])
                                                                                            !appl_4 <- appl_3 `pseq` klSet (Types.Atom (Types.UnboundSym "shen.*datatypes*")) appl_3
                                                                                            !appl_5 <- value (Types.Atom (Types.UnboundSym "shen.*alldatatypes*"))
                                                                                            let !aw_6 = Types.Atom (Types.UnboundSym "adjoin")
                                                                                            !appl_7 <- kl_V2484h `pseq` (appl_5 `pseq` applyWrapper aw_6 [kl_V2484h,
                                                                                                                                                          appl_5])
                                                                                            !appl_8 <- appl_7 `pseq` klSet (Types.Atom (Types.UnboundSym "shen.*alldatatypes*")) appl_7
                                                                                            !appl_9 <- appl_8 `pseq` (kl_V2484h `pseq` kl_do appl_8 kl_V2484h)
                                                                                            appl_4 `pseq` (appl_9 `pseq` kl_do appl_4 appl_9)
                                               pat_cond_10 = do do let !aw_11 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                   applyWrapper aw_11 [ApplC (wrapNamed "shen.remember-datatype" kl_shen_remember_datatype)]
                                            in case kl_V2484 of
                                                   !(kl_V2484@(Cons (!kl_V2484h)
                                                                    (!kl_V2484t))) -> pat_cond_0 kl_V2484 kl_V2484h kl_V2484t
                                                   _ -> pat_cond_10

kl_shen_rules_RBhorn_clauses :: Types.KLValue ->
                                Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_rules_RBhorn_clauses (!kl_V2489) (!kl_V2490) = do let pat_cond_0 = do return (Types.Atom Types.Nil)
                                                              pat_cond_1 = do !kl_if_2 <- let pat_cond_3 kl_V2490 kl_V2490h kl_V2490t = do !kl_if_4 <- kl_V2490h `pseq` kl_tupleP kl_V2490h
                                                                                                                                           !kl_if_5 <- case kl_if_4 of
                                                                                                                                                           Atom (B (True)) -> do !appl_6 <- kl_V2490h `pseq` kl_fst kl_V2490h
                                                                                                                                                                                 !kl_if_7 <- appl_6 `pseq` eq (Types.Atom (Types.UnboundSym "shen.single")) appl_6
                                                                                                                                                                                 case kl_if_7 of
                                                                                                                                                                                     Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                     Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                     _ -> throwError "if: expected boolean"
                                                                                                                                                           Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                           _ -> throwError "if: expected boolean"
                                                                                                                                           case kl_if_5 of
                                                                                                                                               Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                               Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                               _ -> throwError "if: expected boolean"
                                                                                              pat_cond_8 = do do return (Atom (B False))
                                                                                           in case kl_V2490 of
                                                                                                  !(kl_V2490@(Cons (!kl_V2490h)
                                                                                                                   (!kl_V2490t))) -> pat_cond_3 kl_V2490 kl_V2490h kl_V2490t
                                                                                                  _ -> pat_cond_8
                                                                              case kl_if_2 of
                                                                                  Atom (B (True)) -> do !appl_9 <- kl_V2490 `pseq` hd kl_V2490
                                                                                                        !appl_10 <- appl_9 `pseq` kl_snd appl_9
                                                                                                        !appl_11 <- kl_V2489 `pseq` (appl_10 `pseq` kl_shen_rule_RBhorn_clause kl_V2489 appl_10)
                                                                                                        !appl_12 <- kl_V2490 `pseq` tl kl_V2490
                                                                                                        !appl_13 <- kl_V2489 `pseq` (appl_12 `pseq` kl_shen_rules_RBhorn_clauses kl_V2489 appl_12)
                                                                                                        appl_11 `pseq` (appl_13 `pseq` klCons appl_11 appl_13)
                                                                                  Atom (B (False)) -> do !kl_if_14 <- let pat_cond_15 kl_V2490 kl_V2490h kl_V2490t = do !kl_if_16 <- kl_V2490h `pseq` kl_tupleP kl_V2490h
                                                                                                                                                                        !kl_if_17 <- case kl_if_16 of
                                                                                                                                                                                         Atom (B (True)) -> do !appl_18 <- kl_V2490h `pseq` kl_fst kl_V2490h
                                                                                                                                                                                                               !kl_if_19 <- appl_18 `pseq` eq (Types.Atom (Types.UnboundSym "shen.double")) appl_18
                                                                                                                                                                                                               case kl_if_19 of
                                                                                                                                                                                                                   Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                   Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                   _ -> throwError "if: expected boolean"
                                                                                                                                                                                         Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                         _ -> throwError "if: expected boolean"
                                                                                                                                                                        case kl_if_17 of
                                                                                                                                                                            Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                            Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                            _ -> throwError "if: expected boolean"
                                                                                                                          pat_cond_20 = do do return (Atom (B False))
                                                                                                                       in case kl_V2490 of
                                                                                                                              !(kl_V2490@(Cons (!kl_V2490h)
                                                                                                                                               (!kl_V2490t))) -> pat_cond_15 kl_V2490 kl_V2490h kl_V2490t
                                                                                                                              _ -> pat_cond_20
                                                                                                         case kl_if_14 of
                                                                                                             Atom (B (True)) -> do !appl_21 <- kl_V2490 `pseq` hd kl_V2490
                                                                                                                                   !appl_22 <- appl_21 `pseq` kl_snd appl_21
                                                                                                                                   !appl_23 <- appl_22 `pseq` kl_shen_double_RBsingles appl_22
                                                                                                                                   !appl_24 <- kl_V2490 `pseq` tl kl_V2490
                                                                                                                                   !appl_25 <- appl_23 `pseq` (appl_24 `pseq` kl_append appl_23 appl_24)
                                                                                                                                   kl_V2489 `pseq` (appl_25 `pseq` kl_shen_rules_RBhorn_clauses kl_V2489 appl_25)
                                                                                                             Atom (B (False)) -> do do let !aw_26 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                                                                                       applyWrapper aw_26 [ApplC (wrapNamed "shen.rules->horn-clauses" kl_shen_rules_RBhorn_clauses)]
                                                                                                             _ -> throwError "if: expected boolean"
                                                                                  _ -> throwError "if: expected boolean"
                                                           in case kl_V2490 of
                                                                  kl_V2490@(Atom (Nil)) -> pat_cond_0
                                                                  _ -> pat_cond_1

kl_shen_double_RBsingles :: Types.KLValue ->
                            Types.KLContext Types.Env Types.KLValue
kl_shen_double_RBsingles (!kl_V2492) = do !appl_0 <- kl_V2492 `pseq` kl_shen_right_rule kl_V2492
                                          !appl_1 <- kl_V2492 `pseq` kl_shen_left_rule kl_V2492
                                          !appl_2 <- appl_1 `pseq` klCons appl_1 (Types.Atom Types.Nil)
                                          appl_0 `pseq` (appl_2 `pseq` klCons appl_0 appl_2)

kl_shen_right_rule :: Types.KLValue ->
                      Types.KLContext Types.Env Types.KLValue
kl_shen_right_rule (!kl_V2494) = do kl_V2494 `pseq` kl_Atp (Types.Atom (Types.UnboundSym "shen.single")) kl_V2494

kl_shen_left_rule :: Types.KLValue ->
                     Types.KLContext Types.Env Types.KLValue
kl_shen_left_rule (!kl_V2496) = do !kl_if_0 <- let pat_cond_1 kl_V2496 kl_V2496h kl_V2496t = do !kl_if_2 <- let pat_cond_3 kl_V2496t kl_V2496th kl_V2496tt = do !kl_if_4 <- let pat_cond_5 kl_V2496tt kl_V2496tth kl_V2496ttt = do !kl_if_6 <- kl_V2496tth `pseq` kl_tupleP kl_V2496tth
                                                                                                                                                                                                                                   !kl_if_7 <- case kl_if_6 of
                                                                                                                                                                                                                                                   Atom (B (True)) -> do !appl_8 <- kl_V2496tth `pseq` kl_fst kl_V2496tth
                                                                                                                                                                                                                                                                         !kl_if_9 <- appl_8 `pseq` eq (Types.Atom Types.Nil) appl_8
                                                                                                                                                                                                                                                                         !kl_if_10 <- case kl_if_9 of
                                                                                                                                                                                                                                                                                          Atom (B (True)) -> do let pat_cond_11 = do return (Atom (B True))
                                                                                                                                                                                                                                                                                                                    pat_cond_12 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                 in case kl_V2496ttt of
                                                                                                                                                                                                                                                                                                                        kl_V2496ttt@(Atom (Nil)) -> pat_cond_11
                                                                                                                                                                                                                                                                                                                        _ -> pat_cond_12
                                                                                                                                                                                                                                                                                          Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                          _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                         case kl_if_10 of
                                                                                                                                                                                                                                                                             Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                                             Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                             _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                   Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                   _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                   case kl_if_7 of
                                                                                                                                                                                                                                       Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                       Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                       _ -> throwError "if: expected boolean"
                                                                                                                                                                                pat_cond_13 = do do return (Atom (B False))
                                                                                                                                                                             in case kl_V2496tt of
                                                                                                                                                                                    !(kl_V2496tt@(Cons (!kl_V2496tth)
                                                                                                                                                                                                       (!kl_V2496ttt))) -> pat_cond_5 kl_V2496tt kl_V2496tth kl_V2496ttt
                                                                                                                                                                                    _ -> pat_cond_13
                                                                                                                                                                case kl_if_4 of
                                                                                                                                                                    Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                    Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                    _ -> throwError "if: expected boolean"
                                                                                                                pat_cond_14 = do do return (Atom (B False))
                                                                                                             in case kl_V2496t of
                                                                                                                    !(kl_V2496t@(Cons (!kl_V2496th)
                                                                                                                                      (!kl_V2496tt))) -> pat_cond_3 kl_V2496t kl_V2496th kl_V2496tt
                                                                                                                    _ -> pat_cond_14
                                                                                                case kl_if_2 of
                                                                                                    Atom (B (True)) -> do return (Atom (B True))
                                                                                                    Atom (B (False)) -> do do return (Atom (B False))
                                                                                                    _ -> throwError "if: expected boolean"
                                                   pat_cond_15 = do do return (Atom (B False))
                                                in case kl_V2496 of
                                                       !(kl_V2496@(Cons (!kl_V2496h)
                                                                        (!kl_V2496t))) -> pat_cond_1 kl_V2496 kl_V2496h kl_V2496t
                                                       _ -> pat_cond_15
                                   case kl_if_0 of
                                       Atom (B (True)) -> do let !appl_16 = ApplC (Func "lambda" (Context (\(!kl_Q) -> do let !appl_17 = ApplC (Func "lambda" (Context (\(!kl_NewConclusion) -> do let !appl_18 = ApplC (Func "lambda" (Context (\(!kl_NewPremises) -> do !appl_19 <- kl_V2496 `pseq` hd kl_V2496
                                                                                                                                                                                                                                                                          !appl_20 <- kl_NewConclusion `pseq` klCons kl_NewConclusion (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                          !appl_21 <- kl_NewPremises `pseq` (appl_20 `pseq` klCons kl_NewPremises appl_20)
                                                                                                                                                                                                                                                                          !appl_22 <- appl_19 `pseq` (appl_21 `pseq` klCons appl_19 appl_21)
                                                                                                                                                                                                                                                                          appl_22 `pseq` kl_Atp (Types.Atom (Types.UnboundSym "shen.single")) appl_22)))
                                                                                                                                                                                                   let !appl_23 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_X `pseq` kl_shen_right_RBleft kl_X)))
                                                                                                                                                                                                   !appl_24 <- kl_V2496 `pseq` tl kl_V2496
                                                                                                                                                                                                   !appl_25 <- appl_24 `pseq` hd appl_24
                                                                                                                                                                                                   !appl_26 <- appl_23 `pseq` (appl_25 `pseq` kl_map appl_23 appl_25)
                                                                                                                                                                                                   !appl_27 <- appl_26 `pseq` (kl_Q `pseq` kl_Atp appl_26 kl_Q)
                                                                                                                                                                                                   !appl_28 <- appl_27 `pseq` klCons appl_27 (Types.Atom Types.Nil)
                                                                                                                                                                                                   appl_28 `pseq` applyWrapper appl_18 [appl_28])))
                                                                                                                          !appl_29 <- kl_V2496 `pseq` tl kl_V2496
                                                                                                                          !appl_30 <- appl_29 `pseq` tl appl_29
                                                                                                                          !appl_31 <- appl_30 `pseq` hd appl_30
                                                                                                                          !appl_32 <- appl_31 `pseq` kl_snd appl_31
                                                                                                                          !appl_33 <- appl_32 `pseq` klCons appl_32 (Types.Atom Types.Nil)
                                                                                                                          !appl_34 <- appl_33 `pseq` (kl_Q `pseq` kl_Atp appl_33 kl_Q)
                                                                                                                          appl_34 `pseq` applyWrapper appl_17 [appl_34])))
                                                             !appl_35 <- kl_gensym (Types.Atom (Types.UnboundSym "Qv"))
                                                             appl_35 `pseq` applyWrapper appl_16 [appl_35]
                                       Atom (B (False)) -> do do let !aw_36 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                 applyWrapper aw_36 [ApplC (wrapNamed "shen.left-rule" kl_shen_left_rule)]
                                       _ -> throwError "if: expected boolean"

kl_shen_right_RBleft :: Types.KLValue ->
                        Types.KLContext Types.Env Types.KLValue
kl_shen_right_RBleft (!kl_V2502) = do !kl_if_0 <- kl_V2502 `pseq` kl_tupleP kl_V2502
                                      !kl_if_1 <- case kl_if_0 of
                                                      Atom (B (True)) -> do !appl_2 <- kl_V2502 `pseq` kl_fst kl_V2502
                                                                            !kl_if_3 <- appl_2 `pseq` eq (Types.Atom Types.Nil) appl_2
                                                                            case kl_if_3 of
                                                                                Atom (B (True)) -> do return (Atom (B True))
                                                                                Atom (B (False)) -> do do return (Atom (B False))
                                                                                _ -> throwError "if: expected boolean"
                                                      Atom (B (False)) -> do do return (Atom (B False))
                                                      _ -> throwError "if: expected boolean"
                                      case kl_if_1 of
                                          Atom (B (True)) -> do kl_V2502 `pseq` kl_snd kl_V2502
                                          Atom (B (False)) -> do do simpleError (Types.Atom (Types.Str "syntax error with ==========\n"))
                                          _ -> throwError "if: expected boolean"

kl_shen_rule_RBhorn_clause :: Types.KLValue ->
                              Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_rule_RBhorn_clause (!kl_V2505) (!kl_V2506) = do !kl_if_0 <- let pat_cond_1 kl_V2506 kl_V2506h kl_V2506t = do !kl_if_2 <- let pat_cond_3 kl_V2506t kl_V2506th kl_V2506tt = do !kl_if_4 <- let pat_cond_5 kl_V2506tt kl_V2506tth kl_V2506ttt = do !kl_if_6 <- kl_V2506tth `pseq` kl_tupleP kl_V2506tth
                                                                                                                                                                                                                                                        !kl_if_7 <- case kl_if_6 of
                                                                                                                                                                                                                                                                        Atom (B (True)) -> do let pat_cond_8 = do return (Atom (B True))
                                                                                                                                                                                                                                                                                                  pat_cond_9 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                               in case kl_V2506ttt of
                                                                                                                                                                                                                                                                                                      kl_V2506ttt@(Atom (Nil)) -> pat_cond_8
                                                                                                                                                                                                                                                                                                      _ -> pat_cond_9
                                                                                                                                                                                                                                                                        Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                        _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                        case kl_if_7 of
                                                                                                                                                                                                                                                            Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                                                                                            Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                            _ -> throwError "if: expected boolean"
                                                                                                                                                                                                     pat_cond_10 = do do return (Atom (B False))
                                                                                                                                                                                                  in case kl_V2506tt of
                                                                                                                                                                                                         !(kl_V2506tt@(Cons (!kl_V2506tth)
                                                                                                                                                                                                                            (!kl_V2506ttt))) -> pat_cond_5 kl_V2506tt kl_V2506tth kl_V2506ttt
                                                                                                                                                                                                         _ -> pat_cond_10
                                                                                                                                                                                     case kl_if_4 of
                                                                                                                                                                                         Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                         Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                         _ -> throwError "if: expected boolean"
                                                                                                                                     pat_cond_11 = do do return (Atom (B False))
                                                                                                                                  in case kl_V2506t of
                                                                                                                                         !(kl_V2506t@(Cons (!kl_V2506th)
                                                                                                                                                           (!kl_V2506tt))) -> pat_cond_3 kl_V2506t kl_V2506th kl_V2506tt
                                                                                                                                         _ -> pat_cond_11
                                                                                                                     case kl_if_2 of
                                                                                                                         Atom (B (True)) -> do return (Atom (B True))
                                                                                                                         Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                         _ -> throwError "if: expected boolean"
                                                                        pat_cond_12 = do do return (Atom (B False))
                                                                     in case kl_V2506 of
                                                                            !(kl_V2506@(Cons (!kl_V2506h)
                                                                                             (!kl_V2506t))) -> pat_cond_1 kl_V2506 kl_V2506h kl_V2506t
                                                                            _ -> pat_cond_12
                                                        case kl_if_0 of
                                                            Atom (B (True)) -> do !appl_13 <- kl_V2506 `pseq` tl kl_V2506
                                                                                  !appl_14 <- appl_13 `pseq` tl appl_13
                                                                                  !appl_15 <- appl_14 `pseq` hd appl_14
                                                                                  !appl_16 <- appl_15 `pseq` kl_snd appl_15
                                                                                  !appl_17 <- kl_V2505 `pseq` (appl_16 `pseq` kl_shen_rule_RBhorn_clause_head kl_V2505 appl_16)
                                                                                  !appl_18 <- kl_V2506 `pseq` hd kl_V2506
                                                                                  !appl_19 <- kl_V2506 `pseq` tl kl_V2506
                                                                                  !appl_20 <- appl_19 `pseq` hd appl_19
                                                                                  !appl_21 <- kl_V2506 `pseq` tl kl_V2506
                                                                                  !appl_22 <- appl_21 `pseq` tl appl_21
                                                                                  !appl_23 <- appl_22 `pseq` hd appl_22
                                                                                  !appl_24 <- appl_23 `pseq` kl_fst appl_23
                                                                                  !appl_25 <- appl_18 `pseq` (appl_20 `pseq` (appl_24 `pseq` kl_shen_rule_RBhorn_clause_body appl_18 appl_20 appl_24))
                                                                                  !appl_26 <- appl_25 `pseq` klCons appl_25 (Types.Atom Types.Nil)
                                                                                  !appl_27 <- appl_26 `pseq` klCons (Types.Atom (Types.UnboundSym ":-")) appl_26
                                                                                  appl_17 `pseq` (appl_27 `pseq` klCons appl_17 appl_27)
                                                            Atom (B (False)) -> do do let !aw_28 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                                      applyWrapper aw_28 [ApplC (wrapNamed "shen.rule->horn-clause" kl_shen_rule_RBhorn_clause)]
                                                            _ -> throwError "if: expected boolean"

kl_shen_rule_RBhorn_clause_head :: Types.KLValue ->
                                   Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_rule_RBhorn_clause_head (!kl_V2509) (!kl_V2510) = do !appl_0 <- kl_V2510 `pseq` kl_shen_mode_ify kl_V2510
                                                             !appl_1 <- klCons (Types.Atom (Types.UnboundSym "Context_1957")) (Types.Atom Types.Nil)
                                                             !appl_2 <- appl_0 `pseq` (appl_1 `pseq` klCons appl_0 appl_1)
                                                             kl_V2509 `pseq` (appl_2 `pseq` klCons kl_V2509 appl_2)

kl_shen_mode_ify :: Types.KLValue ->
                    Types.KLContext Types.Env Types.KLValue
kl_shen_mode_ify (!kl_V2512) = do let pat_cond_0 kl_V2512 kl_V2512h kl_V2512t kl_V2512tt kl_V2512tth = do !appl_1 <- klCons (ApplC (wrapNamed "+" add)) (Types.Atom Types.Nil)
                                                                                                          !appl_2 <- kl_V2512tth `pseq` (appl_1 `pseq` klCons kl_V2512tth appl_1)
                                                                                                          !appl_3 <- appl_2 `pseq` klCons (Types.Atom (Types.UnboundSym "mode")) appl_2
                                                                                                          !appl_4 <- appl_3 `pseq` klCons appl_3 (Types.Atom Types.Nil)
                                                                                                          !appl_5 <- appl_4 `pseq` klCons (Types.Atom (Types.UnboundSym ":")) appl_4
                                                                                                          !appl_6 <- kl_V2512h `pseq` (appl_5 `pseq` klCons kl_V2512h appl_5)
                                                                                                          !appl_7 <- klCons (ApplC (wrapNamed "-" Primitives.subtract)) (Types.Atom Types.Nil)
                                                                                                          !appl_8 <- appl_6 `pseq` (appl_7 `pseq` klCons appl_6 appl_7)
                                                                                                          appl_8 `pseq` klCons (Types.Atom (Types.UnboundSym "mode")) appl_8
                                      pat_cond_9 = do do return kl_V2512
                                   in case kl_V2512 of
                                          !(kl_V2512@(Cons (!kl_V2512h)
                                                           (!(kl_V2512t@(Cons (Atom (UnboundSym ":"))
                                                                              (!(kl_V2512tt@(Cons (!kl_V2512tth)
                                                                                                  (Atom (Nil)))))))))) -> pat_cond_0 kl_V2512 kl_V2512h kl_V2512t kl_V2512tt kl_V2512tth
                                          !(kl_V2512@(Cons (!kl_V2512h)
                                                           (!(kl_V2512t@(Cons (ApplC (PL ":" _))
                                                                              (!(kl_V2512tt@(Cons (!kl_V2512tth)
                                                                                                  (Atom (Nil)))))))))) -> pat_cond_0 kl_V2512 kl_V2512h kl_V2512t kl_V2512tt kl_V2512tth
                                          !(kl_V2512@(Cons (!kl_V2512h)
                                                           (!(kl_V2512t@(Cons (ApplC (Func ":" _))
                                                                              (!(kl_V2512tt@(Cons (!kl_V2512tth)
                                                                                                  (Atom (Nil)))))))))) -> pat_cond_0 kl_V2512 kl_V2512h kl_V2512t kl_V2512tt kl_V2512tth
                                          _ -> pat_cond_9

kl_shen_rule_RBhorn_clause_body :: Types.KLValue ->
                                   Types.KLValue ->
                                   Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_rule_RBhorn_clause_body (!kl_V2516) (!kl_V2517) (!kl_V2518) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_Variables) -> do let !appl_1 = ApplC (Func "lambda" (Context (\(!kl_Predicates) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_SearchLiterals) -> do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_SearchClauses) -> do let !appl_4 = ApplC (Func "lambda" (Context (\(!kl_SideLiterals) -> do let !appl_5 = ApplC (Func "lambda" (Context (\(!kl_PremissLiterals) -> do !appl_6 <- kl_SideLiterals `pseq` (kl_PremissLiterals `pseq` kl_append kl_SideLiterals kl_PremissLiterals)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    kl_SearchLiterals `pseq` (appl_6 `pseq` kl_append kl_SearchLiterals appl_6))))
                                                                                                                                                                                                                                                                                                                                                                                                                                          let !appl_7 = ApplC (Func "lambda" (Context (\(!kl_X) -> do !appl_8 <- kl_V2518 `pseq` kl_emptyP kl_V2518
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      kl_X `pseq` (appl_8 `pseq` kl_shen_construct_premiss_literal kl_X appl_8))))
                                                                                                                                                                                                                                                                                                                                                                                                                                          !appl_9 <- appl_7 `pseq` (kl_V2517 `pseq` kl_map appl_7 kl_V2517)
                                                                                                                                                                                                                                                                                                                                                                                                                                          appl_9 `pseq` applyWrapper appl_5 [appl_9])))
                                                                                                                                                                                                                                                                                                                                                                   !appl_10 <- kl_V2516 `pseq` kl_shen_construct_side_literals kl_V2516
                                                                                                                                                                                                                                                                                                                                                                   appl_10 `pseq` applyWrapper appl_4 [appl_10])))
                                                                                                                                                                                                                                                                                           !appl_11 <- kl_Predicates `pseq` (kl_V2518 `pseq` (kl_Variables `pseq` kl_shen_construct_search_clauses kl_Predicates kl_V2518 kl_Variables))
                                                                                                                                                                                                                                                                                           appl_11 `pseq` applyWrapper appl_3 [appl_11])))
                                                                                                                                                                                                                  !appl_12 <- kl_Predicates `pseq` (kl_Variables `pseq` kl_shen_construct_search_literals kl_Predicates kl_Variables (Types.Atom (Types.UnboundSym "Context_1957")) (Types.Atom (Types.UnboundSym "Context1_1957")))
                                                                                                                                                                                                                  appl_12 `pseq` applyWrapper appl_2 [appl_12])))
                                                                                                                                             let !appl_13 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_gensym (Types.Atom (Types.UnboundSym "shen.cl")))))
                                                                                                                                             !appl_14 <- appl_13 `pseq` (kl_V2518 `pseq` kl_map appl_13 kl_V2518)
                                                                                                                                             appl_14 `pseq` applyWrapper appl_1 [appl_14])))
                                                                         let !appl_15 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_X `pseq` kl_shen_extract_vars kl_X)))
                                                                         !appl_16 <- appl_15 `pseq` (kl_V2518 `pseq` kl_map appl_15 kl_V2518)
                                                                         appl_16 `pseq` applyWrapper appl_0 [appl_16]

kl_shen_construct_search_literals :: Types.KLValue ->
                                     Types.KLValue ->
                                     Types.KLValue ->
                                     Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_construct_search_literals (!kl_V2527) (!kl_V2528) (!kl_V2529) (!kl_V2530) = do !kl_if_0 <- let pat_cond_1 = do let pat_cond_2 = do return (Atom (B True))
                                                                                                                           pat_cond_3 = do do return (Atom (B False))
                                                                                                                        in case kl_V2528 of
                                                                                                                               kl_V2528@(Atom (Nil)) -> pat_cond_2
                                                                                                                               _ -> pat_cond_3
                                                                                                       pat_cond_4 = do do return (Atom (B False))
                                                                                                    in case kl_V2527 of
                                                                                                           kl_V2527@(Atom (Nil)) -> pat_cond_1
                                                                                                           _ -> pat_cond_4
                                                                                       case kl_if_0 of
                                                                                           Atom (B (True)) -> do return (Types.Atom Types.Nil)
                                                                                           Atom (B (False)) -> do do kl_V2527 `pseq` (kl_V2528 `pseq` (kl_V2529 `pseq` (kl_V2530 `pseq` kl_shen_csl_help kl_V2527 kl_V2528 kl_V2529 kl_V2530)))
                                                                                           _ -> throwError "if: expected boolean"

kl_shen_csl_help :: Types.KLValue ->
                    Types.KLValue ->
                    Types.KLValue ->
                    Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_csl_help (!kl_V2537) (!kl_V2538) (!kl_V2539) (!kl_V2540) = do !kl_if_0 <- let pat_cond_1 = do let pat_cond_2 = do return (Atom (B True))
                                                                                                          pat_cond_3 = do do return (Atom (B False))
                                                                                                       in case kl_V2538 of
                                                                                                              kl_V2538@(Atom (Nil)) -> pat_cond_2
                                                                                                              _ -> pat_cond_3
                                                                                      pat_cond_4 = do do return (Atom (B False))
                                                                                   in case kl_V2537 of
                                                                                          kl_V2537@(Atom (Nil)) -> pat_cond_1
                                                                                          _ -> pat_cond_4
                                                                      case kl_if_0 of
                                                                          Atom (B (True)) -> do !appl_5 <- kl_V2539 `pseq` klCons kl_V2539 (Types.Atom Types.Nil)
                                                                                                !appl_6 <- appl_5 `pseq` klCons (Types.Atom (Types.UnboundSym "ContextOut_1957")) appl_5
                                                                                                !appl_7 <- appl_6 `pseq` klCons (Types.Atom (Types.UnboundSym "bind")) appl_6
                                                                                                appl_7 `pseq` klCons appl_7 (Types.Atom Types.Nil)
                                                                          Atom (B (False)) -> do !kl_if_8 <- let pat_cond_9 kl_V2537 kl_V2537h kl_V2537t = do let pat_cond_10 kl_V2538 kl_V2538h kl_V2538t = do return (Atom (B True))
                                                                                                                                                                  pat_cond_11 = do do return (Atom (B False))
                                                                                                                                                               in case kl_V2538 of
                                                                                                                                                                      !(kl_V2538@(Cons (!kl_V2538h)
                                                                                                                                                                                       (!kl_V2538t))) -> pat_cond_10 kl_V2538 kl_V2538h kl_V2538t
                                                                                                                                                                      _ -> pat_cond_11
                                                                                                                 pat_cond_12 = do do return (Atom (B False))
                                                                                                              in case kl_V2537 of
                                                                                                                     !(kl_V2537@(Cons (!kl_V2537h)
                                                                                                                                      (!kl_V2537t))) -> pat_cond_9 kl_V2537 kl_V2537h kl_V2537t
                                                                                                                     _ -> pat_cond_12
                                                                                                 case kl_if_8 of
                                                                                                     Atom (B (True)) -> do !appl_13 <- kl_V2537 `pseq` hd kl_V2537
                                                                                                                           !appl_14 <- kl_V2538 `pseq` hd kl_V2538
                                                                                                                           !appl_15 <- kl_V2540 `pseq` (appl_14 `pseq` klCons kl_V2540 appl_14)
                                                                                                                           !appl_16 <- kl_V2539 `pseq` (appl_15 `pseq` klCons kl_V2539 appl_15)
                                                                                                                           !appl_17 <- appl_13 `pseq` (appl_16 `pseq` klCons appl_13 appl_16)
                                                                                                                           !appl_18 <- kl_V2537 `pseq` tl kl_V2537
                                                                                                                           !appl_19 <- kl_V2538 `pseq` tl kl_V2538
                                                                                                                           !appl_20 <- kl_gensym (Types.Atom (Types.UnboundSym "Context"))
                                                                                                                           !appl_21 <- appl_18 `pseq` (appl_19 `pseq` (kl_V2540 `pseq` (appl_20 `pseq` kl_shen_csl_help appl_18 appl_19 kl_V2540 appl_20)))
                                                                                                                           appl_17 `pseq` (appl_21 `pseq` klCons appl_17 appl_21)
                                                                                                     Atom (B (False)) -> do do let !aw_22 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                                                                               applyWrapper aw_22 [ApplC (wrapNamed "shen.csl-help" kl_shen_csl_help)]
                                                                                                     _ -> throwError "if: expected boolean"
                                                                          _ -> throwError "if: expected boolean"

kl_shen_construct_search_clauses :: Types.KLValue ->
                                    Types.KLValue ->
                                    Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_construct_search_clauses (!kl_V2544) (!kl_V2545) (!kl_V2546) = do !kl_if_0 <- let pat_cond_1 = do !kl_if_2 <- let pat_cond_3 = do let pat_cond_4 = do return (Atom (B True))
                                                                                                                                              pat_cond_5 = do do return (Atom (B False))
                                                                                                                                           in case kl_V2546 of
                                                                                                                                                  kl_V2546@(Atom (Nil)) -> pat_cond_4
                                                                                                                                                  _ -> pat_cond_5
                                                                                                                          pat_cond_6 = do do return (Atom (B False))
                                                                                                                       in case kl_V2545 of
                                                                                                                              kl_V2545@(Atom (Nil)) -> pat_cond_3
                                                                                                                              _ -> pat_cond_6
                                                                                                          case kl_if_2 of
                                                                                                              Atom (B (True)) -> do return (Atom (B True))
                                                                                                              Atom (B (False)) -> do do return (Atom (B False))
                                                                                                              _ -> throwError "if: expected boolean"
                                                                                          pat_cond_7 = do do return (Atom (B False))
                                                                                       in case kl_V2544 of
                                                                                              kl_V2544@(Atom (Nil)) -> pat_cond_1
                                                                                              _ -> pat_cond_7
                                                                          case kl_if_0 of
                                                                              Atom (B (True)) -> do return (Types.Atom (Types.UnboundSym "shen.skip"))
                                                                              Atom (B (False)) -> do !kl_if_8 <- let pat_cond_9 kl_V2544 kl_V2544h kl_V2544t = do !kl_if_10 <- let pat_cond_11 kl_V2545 kl_V2545h kl_V2545t = do let pat_cond_12 kl_V2546 kl_V2546h kl_V2546t = do return (Atom (B True))
                                                                                                                                                                                                                                     pat_cond_13 = do do return (Atom (B False))
                                                                                                                                                                                                                                  in case kl_V2546 of
                                                                                                                                                                                                                                         !(kl_V2546@(Cons (!kl_V2546h)
                                                                                                                                                                                                                                                          (!kl_V2546t))) -> pat_cond_12 kl_V2546 kl_V2546h kl_V2546t
                                                                                                                                                                                                                                         _ -> pat_cond_13
                                                                                                                                                                                   pat_cond_14 = do do return (Atom (B False))
                                                                                                                                                                                in case kl_V2545 of
                                                                                                                                                                                       !(kl_V2545@(Cons (!kl_V2545h)
                                                                                                                                                                                                        (!kl_V2545t))) -> pat_cond_11 kl_V2545 kl_V2545h kl_V2545t
                                                                                                                                                                                       _ -> pat_cond_14
                                                                                                                                                                  case kl_if_10 of
                                                                                                                                                                      Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                      Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                      _ -> throwError "if: expected boolean"
                                                                                                                     pat_cond_15 = do do return (Atom (B False))
                                                                                                                  in case kl_V2544 of
                                                                                                                         !(kl_V2544@(Cons (!kl_V2544h)
                                                                                                                                          (!kl_V2544t))) -> pat_cond_9 kl_V2544 kl_V2544h kl_V2544t
                                                                                                                         _ -> pat_cond_15
                                                                                                     case kl_if_8 of
                                                                                                         Atom (B (True)) -> do !appl_16 <- kl_V2544 `pseq` hd kl_V2544
                                                                                                                               !appl_17 <- kl_V2545 `pseq` hd kl_V2545
                                                                                                                               !appl_18 <- kl_V2546 `pseq` hd kl_V2546
                                                                                                                               !appl_19 <- appl_16 `pseq` (appl_17 `pseq` (appl_18 `pseq` kl_shen_construct_search_clause appl_16 appl_17 appl_18))
                                                                                                                               !appl_20 <- kl_V2544 `pseq` tl kl_V2544
                                                                                                                               !appl_21 <- kl_V2545 `pseq` tl kl_V2545
                                                                                                                               !appl_22 <- kl_V2546 `pseq` tl kl_V2546
                                                                                                                               !appl_23 <- appl_20 `pseq` (appl_21 `pseq` (appl_22 `pseq` kl_shen_construct_search_clauses appl_20 appl_21 appl_22))
                                                                                                                               appl_19 `pseq` (appl_23 `pseq` kl_do appl_19 appl_23)
                                                                                                         Atom (B (False)) -> do do let !aw_24 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                                                                                   applyWrapper aw_24 [ApplC (wrapNamed "shen.construct-search-clauses" kl_shen_construct_search_clauses)]
                                                                                                         _ -> throwError "if: expected boolean"
                                                                              _ -> throwError "if: expected boolean"

kl_shen_construct_search_clause :: Types.KLValue ->
                                   Types.KLValue ->
                                   Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_construct_search_clause (!kl_V2550) (!kl_V2551) (!kl_V2552) = do !appl_0 <- kl_V2550 `pseq` (kl_V2551 `pseq` (kl_V2552 `pseq` kl_shen_construct_base_search_clause kl_V2550 kl_V2551 kl_V2552))
                                                                         !appl_1 <- kl_V2550 `pseq` (kl_V2551 `pseq` (kl_V2552 `pseq` kl_shen_construct_recursive_search_clause kl_V2550 kl_V2551 kl_V2552))
                                                                         !appl_2 <- appl_1 `pseq` klCons appl_1 (Types.Atom Types.Nil)
                                                                         !appl_3 <- appl_0 `pseq` (appl_2 `pseq` klCons appl_0 appl_2)
                                                                         let !aw_4 = Types.Atom (Types.UnboundSym "shen.s-prolog")
                                                                         appl_3 `pseq` applyWrapper aw_4 [appl_3]

kl_shen_construct_base_search_clause :: Types.KLValue ->
                                        Types.KLValue ->
                                        Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_construct_base_search_clause (!kl_V2556) (!kl_V2557) (!kl_V2558) = do !appl_0 <- kl_V2557 `pseq` kl_shen_mode_ify kl_V2557
                                                                              !appl_1 <- appl_0 `pseq` klCons appl_0 (Types.Atom (Types.UnboundSym "In_1957"))
                                                                              !appl_2 <- kl_V2558 `pseq` klCons (Types.Atom (Types.UnboundSym "In_1957")) kl_V2558
                                                                              !appl_3 <- appl_1 `pseq` (appl_2 `pseq` klCons appl_1 appl_2)
                                                                              !appl_4 <- kl_V2556 `pseq` (appl_3 `pseq` klCons kl_V2556 appl_3)
                                                                              !appl_5 <- klCons (Types.Atom Types.Nil) (Types.Atom Types.Nil)
                                                                              !appl_6 <- appl_5 `pseq` klCons (Types.Atom (Types.UnboundSym ":-")) appl_5
                                                                              appl_4 `pseq` (appl_6 `pseq` klCons appl_4 appl_6)

kl_shen_construct_recursive_search_clause :: Types.KLValue ->
                                             Types.KLValue ->
                                             Types.KLValue ->
                                             Types.KLContext Types.Env Types.KLValue
kl_shen_construct_recursive_search_clause (!kl_V2562) (!kl_V2563) (!kl_V2564) = do !appl_0 <- klCons (Types.Atom (Types.UnboundSym "Assumption_1957")) (Types.Atom (Types.UnboundSym "Assumptions_1957"))
                                                                                   !appl_1 <- klCons (Types.Atom (Types.UnboundSym "Assumption_1957")) (Types.Atom (Types.UnboundSym "Out_1957"))
                                                                                   !appl_2 <- appl_1 `pseq` (kl_V2564 `pseq` klCons appl_1 kl_V2564)
                                                                                   !appl_3 <- appl_0 `pseq` (appl_2 `pseq` klCons appl_0 appl_2)
                                                                                   !appl_4 <- kl_V2562 `pseq` (appl_3 `pseq` klCons kl_V2562 appl_3)
                                                                                   !appl_5 <- kl_V2564 `pseq` klCons (Types.Atom (Types.UnboundSym "Out_1957")) kl_V2564
                                                                                   !appl_6 <- appl_5 `pseq` klCons (Types.Atom (Types.UnboundSym "Assumptions_1957")) appl_5
                                                                                   !appl_7 <- kl_V2562 `pseq` (appl_6 `pseq` klCons kl_V2562 appl_6)
                                                                                   !appl_8 <- appl_7 `pseq` klCons appl_7 (Types.Atom Types.Nil)
                                                                                   !appl_9 <- appl_8 `pseq` klCons appl_8 (Types.Atom Types.Nil)
                                                                                   !appl_10 <- appl_9 `pseq` klCons (Types.Atom (Types.UnboundSym ":-")) appl_9
                                                                                   appl_4 `pseq` (appl_10 `pseq` klCons appl_4 appl_10)

kl_shen_construct_side_literals :: Types.KLValue ->
                                   Types.KLContext Types.Env Types.KLValue
kl_shen_construct_side_literals (!kl_V2570) = do let pat_cond_0 = do return (Types.Atom Types.Nil)
                                                     pat_cond_1 kl_V2570 kl_V2570h kl_V2570ht kl_V2570hth kl_V2570t = do !appl_2 <- kl_V2570ht `pseq` klCons (Types.Atom (Types.UnboundSym "when")) kl_V2570ht
                                                                                                                         !appl_3 <- kl_V2570t `pseq` kl_shen_construct_side_literals kl_V2570t
                                                                                                                         appl_2 `pseq` (appl_3 `pseq` klCons appl_2 appl_3)
                                                     pat_cond_4 kl_V2570 kl_V2570h kl_V2570ht kl_V2570hth kl_V2570htt kl_V2570htth kl_V2570t = do !appl_5 <- kl_V2570ht `pseq` klCons (Types.Atom (Types.UnboundSym "is")) kl_V2570ht
                                                                                                                                                  !appl_6 <- kl_V2570t `pseq` kl_shen_construct_side_literals kl_V2570t
                                                                                                                                                  appl_5 `pseq` (appl_6 `pseq` klCons appl_5 appl_6)
                                                     pat_cond_7 kl_V2570 kl_V2570h kl_V2570t = do kl_V2570t `pseq` kl_shen_construct_side_literals kl_V2570t
                                                     pat_cond_8 = do do let !aw_9 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                        applyWrapper aw_9 [ApplC (wrapNamed "shen.construct-side-literals" kl_shen_construct_side_literals)]
                                                  in case kl_V2570 of
                                                         kl_V2570@(Atom (Nil)) -> pat_cond_0
                                                         !(kl_V2570@(Cons (!(kl_V2570h@(Cons (Atom (UnboundSym "if"))
                                                                                             (!(kl_V2570ht@(Cons (!kl_V2570hth)
                                                                                                                 (Atom (Nil))))))))
                                                                          (!kl_V2570t))) -> pat_cond_1 kl_V2570 kl_V2570h kl_V2570ht kl_V2570hth kl_V2570t
                                                         !(kl_V2570@(Cons (!(kl_V2570h@(Cons (ApplC (PL "if"
                                                                                                        _))
                                                                                             (!(kl_V2570ht@(Cons (!kl_V2570hth)
                                                                                                                 (Atom (Nil))))))))
                                                                          (!kl_V2570t))) -> pat_cond_1 kl_V2570 kl_V2570h kl_V2570ht kl_V2570hth kl_V2570t
                                                         !(kl_V2570@(Cons (!(kl_V2570h@(Cons (ApplC (Func "if"
                                                                                                          _))
                                                                                             (!(kl_V2570ht@(Cons (!kl_V2570hth)
                                                                                                                 (Atom (Nil))))))))
                                                                          (!kl_V2570t))) -> pat_cond_1 kl_V2570 kl_V2570h kl_V2570ht kl_V2570hth kl_V2570t
                                                         !(kl_V2570@(Cons (!(kl_V2570h@(Cons (Atom (UnboundSym "let"))
                                                                                             (!(kl_V2570ht@(Cons (!kl_V2570hth)
                                                                                                                 (!(kl_V2570htt@(Cons (!kl_V2570htth)
                                                                                                                                      (Atom (Nil)))))))))))
                                                                          (!kl_V2570t))) -> pat_cond_4 kl_V2570 kl_V2570h kl_V2570ht kl_V2570hth kl_V2570htt kl_V2570htth kl_V2570t
                                                         !(kl_V2570@(Cons (!(kl_V2570h@(Cons (ApplC (PL "let"
                                                                                                        _))
                                                                                             (!(kl_V2570ht@(Cons (!kl_V2570hth)
                                                                                                                 (!(kl_V2570htt@(Cons (!kl_V2570htth)
                                                                                                                                      (Atom (Nil)))))))))))
                                                                          (!kl_V2570t))) -> pat_cond_4 kl_V2570 kl_V2570h kl_V2570ht kl_V2570hth kl_V2570htt kl_V2570htth kl_V2570t
                                                         !(kl_V2570@(Cons (!(kl_V2570h@(Cons (ApplC (Func "let"
                                                                                                          _))
                                                                                             (!(kl_V2570ht@(Cons (!kl_V2570hth)
                                                                                                                 (!(kl_V2570htt@(Cons (!kl_V2570htth)
                                                                                                                                      (Atom (Nil)))))))))))
                                                                          (!kl_V2570t))) -> pat_cond_4 kl_V2570 kl_V2570h kl_V2570ht kl_V2570hth kl_V2570htt kl_V2570htth kl_V2570t
                                                         !(kl_V2570@(Cons (!kl_V2570h)
                                                                          (!kl_V2570t))) -> pat_cond_7 kl_V2570 kl_V2570h kl_V2570t
                                                         _ -> pat_cond_8

kl_shen_construct_premiss_literal :: Types.KLValue ->
                                     Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_construct_premiss_literal (!kl_V2577) (!kl_V2578) = do !kl_if_0 <- kl_V2577 `pseq` kl_tupleP kl_V2577
                                                               case kl_if_0 of
                                                                   Atom (B (True)) -> do !appl_1 <- kl_V2577 `pseq` kl_snd kl_V2577
                                                                                         !appl_2 <- appl_1 `pseq` kl_shen_recursive_cons_form appl_1
                                                                                         !appl_3 <- kl_V2577 `pseq` kl_fst kl_V2577
                                                                                         !appl_4 <- kl_V2578 `pseq` (appl_3 `pseq` kl_shen_construct_context kl_V2578 appl_3)
                                                                                         !appl_5 <- appl_4 `pseq` klCons appl_4 (Types.Atom Types.Nil)
                                                                                         !appl_6 <- appl_2 `pseq` (appl_5 `pseq` klCons appl_2 appl_5)
                                                                                         appl_6 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.t*")) appl_6
                                                                   Atom (B (False)) -> do let pat_cond_7 = do !appl_8 <- klCons (Types.Atom (Types.UnboundSym "Throwcontrol")) (Types.Atom Types.Nil)
                                                                                                              appl_8 `pseq` klCons (Types.Atom (Types.UnboundSym "cut")) appl_8
                                                                                              pat_cond_9 = do do let !aw_10 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                                                                 applyWrapper aw_10 [ApplC (wrapNamed "shen.construct-premiss-literal" kl_shen_construct_premiss_literal)]
                                                                                           in case kl_V2577 of
                                                                                                  kl_V2577@(Atom (UnboundSym "!")) -> pat_cond_7
                                                                                                  kl_V2577@(ApplC (PL "!"
                                                                                                                      _)) -> pat_cond_7
                                                                                                  kl_V2577@(ApplC (Func "!"
                                                                                                                        _)) -> pat_cond_7
                                                                                                  _ -> pat_cond_9
                                                                   _ -> throwError "if: expected boolean"

kl_shen_construct_context :: Types.KLValue ->
                             Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_construct_context (!kl_V2581) (!kl_V2582) = do !kl_if_0 <- let pat_cond_1 = do let pat_cond_2 = do return (Atom (B True))
                                                                                           pat_cond_3 = do do return (Atom (B False))
                                                                                        in case kl_V2582 of
                                                                                               kl_V2582@(Atom (Nil)) -> pat_cond_2
                                                                                               _ -> pat_cond_3
                                                                       pat_cond_4 = do do return (Atom (B False))
                                                                    in case kl_V2581 of
                                                                           kl_V2581@(Atom (UnboundSym "true")) -> pat_cond_1
                                                                           kl_V2581@(Atom (B (True))) -> pat_cond_1
                                                                           _ -> pat_cond_4
                                                       case kl_if_0 of
                                                           Atom (B (True)) -> do return (Types.Atom (Types.UnboundSym "Context_1957"))
                                                           Atom (B (False)) -> do !kl_if_5 <- let pat_cond_6 = do let pat_cond_7 = do return (Atom (B True))
                                                                                                                      pat_cond_8 = do do return (Atom (B False))
                                                                                                                   in case kl_V2582 of
                                                                                                                          kl_V2582@(Atom (Nil)) -> pat_cond_7
                                                                                                                          _ -> pat_cond_8
                                                                                                  pat_cond_9 = do do return (Atom (B False))
                                                                                               in case kl_V2581 of
                                                                                                      kl_V2581@(Atom (UnboundSym "false")) -> pat_cond_6
                                                                                                      kl_V2581@(Atom (B (False))) -> pat_cond_6
                                                                                                      _ -> pat_cond_9
                                                                                  case kl_if_5 of
                                                                                      Atom (B (True)) -> do return (Types.Atom (Types.UnboundSym "ContextOut_1957"))
                                                                                      Atom (B (False)) -> do let pat_cond_10 kl_V2582 kl_V2582h kl_V2582t = do !appl_11 <- kl_V2582h `pseq` kl_shen_recursive_cons_form kl_V2582h
                                                                                                                                                               !appl_12 <- kl_V2581 `pseq` (kl_V2582t `pseq` kl_shen_construct_context kl_V2581 kl_V2582t)
                                                                                                                                                               !appl_13 <- appl_12 `pseq` klCons appl_12 (Types.Atom Types.Nil)
                                                                                                                                                               !appl_14 <- appl_11 `pseq` (appl_13 `pseq` klCons appl_11 appl_13)
                                                                                                                                                               appl_14 `pseq` klCons (ApplC (wrapNamed "cons" klCons)) appl_14
                                                                                                                 pat_cond_15 = do do let !aw_16 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                                                                                                     applyWrapper aw_16 [ApplC (wrapNamed "shen.construct-context" kl_shen_construct_context)]
                                                                                                              in case kl_V2582 of
                                                                                                                     !(kl_V2582@(Cons (!kl_V2582h)
                                                                                                                                      (!kl_V2582t))) -> pat_cond_10 kl_V2582 kl_V2582h kl_V2582t
                                                                                                                     _ -> pat_cond_15
                                                                                      _ -> throwError "if: expected boolean"
                                                           _ -> throwError "if: expected boolean"

kl_shen_recursive_cons_form :: Types.KLValue ->
                               Types.KLContext Types.Env Types.KLValue
kl_shen_recursive_cons_form (!kl_V2584) = do let pat_cond_0 kl_V2584 kl_V2584h kl_V2584t = do !appl_1 <- kl_V2584h `pseq` kl_shen_recursive_cons_form kl_V2584h
                                                                                              !appl_2 <- kl_V2584t `pseq` kl_shen_recursive_cons_form kl_V2584t
                                                                                              !appl_3 <- appl_2 `pseq` klCons appl_2 (Types.Atom Types.Nil)
                                                                                              !appl_4 <- appl_1 `pseq` (appl_3 `pseq` klCons appl_1 appl_3)
                                                                                              appl_4 `pseq` klCons (ApplC (wrapNamed "cons" klCons)) appl_4
                                                 pat_cond_5 = do do return kl_V2584
                                              in case kl_V2584 of
                                                     !(kl_V2584@(Cons (!kl_V2584h)
                                                                      (!kl_V2584t))) -> pat_cond_0 kl_V2584 kl_V2584h kl_V2584t
                                                     _ -> pat_cond_5

kl_preclude :: Types.KLValue ->
               Types.KLContext Types.Env Types.KLValue
kl_preclude (!kl_V2586) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_X) -> do let !aw_1 = Types.Atom (Types.UnboundSym "shen.intern-type")
                                                                                         kl_X `pseq` applyWrapper aw_1 [kl_X])))
                             !appl_2 <- appl_0 `pseq` (kl_V2586 `pseq` kl_map appl_0 kl_V2586)
                             appl_2 `pseq` kl_shen_preclude_h appl_2

kl_shen_preclude_h :: Types.KLValue ->
                      Types.KLContext Types.Env Types.KLValue
kl_shen_preclude_h (!kl_V2588) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_FilterDatatypes) -> do value (Types.Atom (Types.UnboundSym "shen.*datatypes*")))))
                                    !appl_1 <- value (Types.Atom (Types.UnboundSym "shen.*datatypes*"))
                                    !appl_2 <- appl_1 `pseq` (kl_V2588 `pseq` kl_difference appl_1 kl_V2588)
                                    !appl_3 <- appl_2 `pseq` klSet (Types.Atom (Types.UnboundSym "shen.*datatypes*")) appl_2
                                    appl_3 `pseq` applyWrapper appl_0 [appl_3]

kl_include :: Types.KLValue ->
              Types.KLContext Types.Env Types.KLValue
kl_include (!kl_V2590) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_X) -> do let !aw_1 = Types.Atom (Types.UnboundSym "shen.intern-type")
                                                                                        kl_X `pseq` applyWrapper aw_1 [kl_X])))
                            !appl_2 <- appl_0 `pseq` (kl_V2590 `pseq` kl_map appl_0 kl_V2590)
                            appl_2 `pseq` kl_shen_include_h appl_2

kl_shen_include_h :: Types.KLValue ->
                     Types.KLContext Types.Env Types.KLValue
kl_shen_include_h (!kl_V2592) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_ValidTypes) -> do let !appl_1 = ApplC (Func "lambda" (Context (\(!kl_NewDatatypes) -> do value (Types.Atom (Types.UnboundSym "shen.*datatypes*")))))
                                                                                                        !appl_2 <- value (Types.Atom (Types.UnboundSym "shen.*datatypes*"))
                                                                                                        !appl_3 <- kl_ValidTypes `pseq` (appl_2 `pseq` kl_union kl_ValidTypes appl_2)
                                                                                                        !appl_4 <- appl_3 `pseq` klSet (Types.Atom (Types.UnboundSym "shen.*datatypes*")) appl_3
                                                                                                        appl_4 `pseq` applyWrapper appl_1 [appl_4])))
                                   !appl_5 <- value (Types.Atom (Types.UnboundSym "shen.*alldatatypes*"))
                                   !appl_6 <- kl_V2592 `pseq` (appl_5 `pseq` kl_intersection kl_V2592 appl_5)
                                   appl_6 `pseq` applyWrapper appl_0 [appl_6]

kl_preclude_all_but :: Types.KLValue ->
                       Types.KLContext Types.Env Types.KLValue
kl_preclude_all_but (!kl_V2594) = do !appl_0 <- value (Types.Atom (Types.UnboundSym "shen.*alldatatypes*"))
                                     let !appl_1 = ApplC (Func "lambda" (Context (\(!kl_X) -> do let !aw_2 = Types.Atom (Types.UnboundSym "shen.intern-type")
                                                                                                 kl_X `pseq` applyWrapper aw_2 [kl_X])))
                                     !appl_3 <- appl_1 `pseq` (kl_V2594 `pseq` kl_map appl_1 kl_V2594)
                                     !appl_4 <- appl_0 `pseq` (appl_3 `pseq` kl_difference appl_0 appl_3)
                                     appl_4 `pseq` kl_shen_preclude_h appl_4

kl_include_all_but :: Types.KLValue ->
                      Types.KLContext Types.Env Types.KLValue
kl_include_all_but (!kl_V2596) = do !appl_0 <- value (Types.Atom (Types.UnboundSym "shen.*alldatatypes*"))
                                    let !appl_1 = ApplC (Func "lambda" (Context (\(!kl_X) -> do let !aw_2 = Types.Atom (Types.UnboundSym "shen.intern-type")
                                                                                                kl_X `pseq` applyWrapper aw_2 [kl_X])))
                                    !appl_3 <- appl_1 `pseq` (kl_V2596 `pseq` kl_map appl_1 kl_V2596)
                                    !appl_4 <- appl_0 `pseq` (appl_3 `pseq` kl_difference appl_0 appl_3)
                                    appl_4 `pseq` kl_shen_include_h appl_4

kl_shen_synonyms_help :: Types.KLValue ->
                         Types.KLContext Types.Env Types.KLValue
kl_shen_synonyms_help (!kl_V2602) = do let pat_cond_0 = do !appl_1 <- value (Types.Atom (Types.UnboundSym "shen.*tc*"))
                                                           let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_X) -> do kl_X `pseq` kl_shen_demod_rule kl_X)))
                                                           !appl_3 <- value (Types.Atom (Types.UnboundSym "shen.*synonyms*"))
                                                           !appl_4 <- appl_2 `pseq` (appl_3 `pseq` kl_mapcan appl_2 appl_3)
                                                           appl_1 `pseq` (appl_4 `pseq` kl_shen_demodulation_function appl_1 appl_4)
                                           pat_cond_5 kl_V2602 kl_V2602h kl_V2602t kl_V2602th kl_V2602tt = do let !appl_6 = ApplC (Func "lambda" (Context (\(!kl_Vs) -> do !kl_if_7 <- kl_Vs `pseq` kl_emptyP kl_Vs
                                                                                                                                                                           case kl_if_7 of
                                                                                                                                                                               Atom (B (True)) -> do !appl_8 <- kl_V2602th `pseq` klCons kl_V2602th (Types.Atom Types.Nil)
                                                                                                                                                                                                     !appl_9 <- kl_V2602h `pseq` (appl_8 `pseq` klCons kl_V2602h appl_8)
                                                                                                                                                                                                     !appl_10 <- appl_9 `pseq` kl_shen_pushnew appl_9 (Types.Atom (Types.UnboundSym "shen.*synonyms*"))
                                                                                                                                                                                                     !appl_11 <- kl_V2602tt `pseq` kl_shen_synonyms_help kl_V2602tt
                                                                                                                                                                                                     appl_10 `pseq` (appl_11 `pseq` kl_do appl_10 appl_11)
                                                                                                                                                                               Atom (B (False)) -> do do kl_V2602th `pseq` (kl_Vs `pseq` kl_shen_free_variable_warnings kl_V2602th kl_Vs)
                                                                                                                                                                               _ -> throwError "if: expected boolean")))
                                                                                                              !appl_12 <- kl_V2602th `pseq` kl_shen_extract_vars kl_V2602th
                                                                                                              !appl_13 <- kl_V2602h `pseq` kl_shen_extract_vars kl_V2602h
                                                                                                              !appl_14 <- appl_12 `pseq` (appl_13 `pseq` kl_difference appl_12 appl_13)
                                                                                                              appl_14 `pseq` applyWrapper appl_6 [appl_14]
                                           pat_cond_15 = do do simpleError (Types.Atom (Types.Str "odd number of synonyms\n"))
                                        in case kl_V2602 of
                                               kl_V2602@(Atom (Nil)) -> pat_cond_0
                                               !(kl_V2602@(Cons (!kl_V2602h)
                                                                (!(kl_V2602t@(Cons (!kl_V2602th)
                                                                                   (!kl_V2602tt)))))) -> pat_cond_5 kl_V2602 kl_V2602h kl_V2602t kl_V2602th kl_V2602tt
                                               _ -> pat_cond_15

kl_shen_pushnew :: Types.KLValue ->
                   Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_pushnew (!kl_V2605) (!kl_V2606) = do !appl_0 <- kl_V2606 `pseq` value kl_V2606
                                             !kl_if_1 <- kl_V2605 `pseq` (appl_0 `pseq` kl_elementP kl_V2605 appl_0)
                                             case kl_if_1 of
                                                 Atom (B (True)) -> do kl_V2606 `pseq` value kl_V2606
                                                 Atom (B (False)) -> do do !appl_2 <- kl_V2606 `pseq` value kl_V2606
                                                                           !appl_3 <- kl_V2605 `pseq` (appl_2 `pseq` klCons kl_V2605 appl_2)
                                                                           kl_V2606 `pseq` (appl_3 `pseq` klSet kl_V2606 appl_3)
                                                 _ -> throwError "if: expected boolean"

kl_shen_demod_rule :: Types.KLValue ->
                      Types.KLContext Types.Env Types.KLValue
kl_shen_demod_rule (!kl_V2608) = do let pat_cond_0 kl_V2608 kl_V2608h kl_V2608t kl_V2608th = do let !aw_1 = Types.Atom (Types.UnboundSym "shen.rcons_form")
                                                                                                !appl_2 <- kl_V2608h `pseq` applyWrapper aw_1 [kl_V2608h]
                                                                                                let !aw_3 = Types.Atom (Types.UnboundSym "shen.rcons_form")
                                                                                                !appl_4 <- kl_V2608th `pseq` applyWrapper aw_3 [kl_V2608th]
                                                                                                !appl_5 <- appl_4 `pseq` klCons appl_4 (Types.Atom Types.Nil)
                                                                                                !appl_6 <- appl_5 `pseq` klCons (Types.Atom (Types.UnboundSym "->")) appl_5
                                                                                                appl_2 `pseq` (appl_6 `pseq` klCons appl_2 appl_6)
                                        pat_cond_7 = do do let !aw_8 = Types.Atom (Types.UnboundSym "shen.f_error")
                                                           applyWrapper aw_8 [ApplC (wrapNamed "shen.demod-rule" kl_shen_demod_rule)]
                                     in case kl_V2608 of
                                            !(kl_V2608@(Cons (!kl_V2608h)
                                                             (!(kl_V2608t@(Cons (!kl_V2608th)
                                                                                (Atom (Nil))))))) -> pat_cond_0 kl_V2608 kl_V2608h kl_V2608t kl_V2608th
                                            _ -> pat_cond_7

kl_shen_demodulation_function :: Types.KLValue ->
                                 Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_demodulation_function (!kl_V2611) (!kl_V2612) = do !appl_0 <- kl_tc (ApplC (wrapNamed "-" Primitives.subtract))
                                                           !appl_1 <- kl_shen_default_rule
                                                           !appl_2 <- kl_V2612 `pseq` (appl_1 `pseq` kl_append kl_V2612 appl_1)
                                                           !appl_3 <- appl_2 `pseq` klCons (Types.Atom (Types.UnboundSym "shen.demod")) appl_2
                                                           !appl_4 <- appl_3 `pseq` klCons (Types.Atom (Types.UnboundSym "define")) appl_3
                                                           !appl_5 <- appl_4 `pseq` kl_eval appl_4
                                                           !appl_6 <- case kl_V2611 of
                                                                          Atom (B (True)) -> do kl_tc (ApplC (wrapNamed "+" add))
                                                                          Atom (B (False)) -> do do return (Types.Atom (Types.UnboundSym "shen.skip"))
                                                                          _ -> throwError "if: expected boolean"
                                                           !appl_7 <- appl_6 `pseq` kl_do appl_6 (Types.Atom (Types.UnboundSym "synonyms"))
                                                           !appl_8 <- appl_5 `pseq` (appl_7 `pseq` kl_do appl_5 appl_7)
                                                           appl_0 `pseq` (appl_8 `pseq` kl_do appl_0 appl_8)

kl_shen_default_rule :: Types.KLContext Types.Env Types.KLValue
kl_shen_default_rule = do !appl_0 <- klCons (Types.Atom (Types.UnboundSym "X")) (Types.Atom Types.Nil)
                          !appl_1 <- appl_0 `pseq` klCons (Types.Atom (Types.UnboundSym "->")) appl_0
                          appl_1 `pseq` klCons (Types.Atom (Types.UnboundSym "X")) appl_1

expr3 :: Types.KLContext Types.Env Types.KLValue
expr3 = do (do return (Types.Atom (Types.Str "Copyright (c) 2015, Mark Tarver\n\nAll rights reserved.\n\nRedistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions are met:\n1. Redistributions of source code must retain the above copyright\n   notice, this list of conditions and the following disclaimer.\n2. Redistributions in binary form must reproduce the above copyright\n   notice, this list of conditions and the following disclaimer in the\n   documentation and/or other materials provided with the distribution.\n3. The name of Mark Tarver may not be used to endorse or promote products\n   derived from this software without specific prior written permission.\n\nTHIS SOFTWARE IS PROVIDED BY Mark Tarver ''AS IS'' AND ANY\nEXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\nWARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\nDISCLAIMED. IN NO EVENT SHALL Mark Tarver BE LIABLE FOR ANY\nDIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES\n(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;\nLOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND\nON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\nSOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."))) `catchError` (\(!kl_E) -> do return (Types.Atom (Types.Str "E")))
