{-# LANGUAGE BangPatterns #-}
{-# LANGUAGE OverloadedStrings #-}
{-# LANGUAGE Strict #-}
{-# LANGUAGE StrictData #-}
{-# LANGUAGE ViewPatterns #-}

module Backend.TStar where

import Control.Monad.Except
import Control.Parallel
import Environment
import Primitives as Primitives
import Backend.Utils
import Types as Types
import Utils
import Wrap
import Backend.Toplevel
import Backend.Core
import Backend.Sys
import Backend.Sequent
import Backend.Yacc
import Backend.Reader
import Backend.Prolog
import Backend.Track
import Backend.Load
import Backend.Writer
import Backend.Macros
import Backend.Declarations
import Backend.Types

{-
Copyright (c) 2015, Mark Tarver
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of Mark Tarver may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY Mark Tarver ''AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Mark Tarver BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
-}

kl_shen_typecheck :: Types.KLValue ->
                     Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_typecheck (!kl_V3377) (!kl_V3378) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_Curry) -> do let !appl_1 = ApplC (Func "lambda" (Context (\(!kl_ProcessN) -> do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_Type) -> do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_Continuation) -> do !appl_4 <- kl_Type `pseq` klCons kl_Type (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                                        !appl_5 <- appl_4 `pseq` klCons (Types.Atom (Types.UnboundSym ":")) appl_4
                                                                                                                                                                                                                                                                                                                        !appl_6 <- kl_Curry `pseq` (appl_5 `pseq` klCons kl_Curry appl_5)
                                                                                                                                                                                                                                                                                                                        appl_6 `pseq` (kl_ProcessN `pseq` (kl_Continuation `pseq` kl_shen_tMult appl_6 (Types.Atom Types.Nil) kl_ProcessN kl_Continuation)))))
                                                                                                                                                                                                                                                 let !appl_7 = ApplC (PL "thunk" (do kl_Type `pseq` (kl_ProcessN `pseq` kl_return kl_Type kl_ProcessN (Types.Atom (Types.UnboundSym "shen.void")))))
                                                                                                                                                                                                                                                 appl_7 `pseq` applyWrapper appl_3 [appl_7])))
                                                                                                                                                                                  !appl_8 <- kl_V3378 `pseq` kl_shen_curry_type kl_V3378
                                                                                                                                                                                  !appl_9 <- appl_8 `pseq` kl_shen_demodulate appl_8
                                                                                                                                                                                  !appl_10 <- appl_9 `pseq` (kl_ProcessN `pseq` kl_shen_insert_prolog_variables appl_9 kl_ProcessN)
                                                                                                                                                                                  appl_10 `pseq` applyWrapper appl_2 [appl_10])))
                                                                                                               !appl_11 <- kl_shen_start_new_prolog_process
                                                                                                               appl_11 `pseq` applyWrapper appl_1 [appl_11])))
                                               !appl_12 <- kl_V3377 `pseq` kl_shen_curry kl_V3377
                                               appl_12 `pseq` applyWrapper appl_0 [appl_12]

kl_shen_curry :: Types.KLValue ->
                 Types.KLContext Types.Env Types.KLValue
kl_shen_curry (!kl_V3380) = do !kl_if_0 <- let pat_cond_1 kl_V3380 kl_V3380h kl_V3380t = do !kl_if_2 <- kl_V3380h `pseq` kl_shen_specialP kl_V3380h
                                                                                            case kl_if_2 of
                                                                                                Atom (B (True)) -> do return (Atom (B True))
                                                                                                Atom (B (False)) -> do do return (Atom (B False))
                                                                                                _ -> throwError "if: expected boolean"
                                               pat_cond_3 = do do return (Atom (B False))
                                            in case kl_V3380 of
                                                   !(kl_V3380@(Cons (!kl_V3380h)
                                                                    (!kl_V3380t))) -> pat_cond_1 kl_V3380 kl_V3380h kl_V3380t
                                                   _ -> pat_cond_3
                               case kl_if_0 of
                                   Atom (B (True)) -> do !appl_4 <- kl_V3380 `pseq` hd kl_V3380
                                                         let !appl_5 = ApplC (Func "lambda" (Context (\(!kl_Y) -> do kl_Y `pseq` kl_shen_curry kl_Y)))
                                                         !appl_6 <- kl_V3380 `pseq` tl kl_V3380
                                                         !appl_7 <- appl_5 `pseq` (appl_6 `pseq` kl_map appl_5 appl_6)
                                                         appl_4 `pseq` (appl_7 `pseq` klCons appl_4 appl_7)
                                   Atom (B (False)) -> do !kl_if_8 <- let pat_cond_9 kl_V3380 kl_V3380h kl_V3380t = do !kl_if_10 <- let pat_cond_11 kl_V3380t kl_V3380th kl_V3380tt = do !kl_if_12 <- kl_V3380h `pseq` kl_shen_extraspecialP kl_V3380h
                                                                                                                                                                                         case kl_if_12 of
                                                                                                                                                                                             Atom (B (True)) -> do return (Atom (B True))
                                                                                                                                                                                             Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                             _ -> throwError "if: expected boolean"
                                                                                                                                        pat_cond_13 = do do return (Atom (B False))
                                                                                                                                     in case kl_V3380t of
                                                                                                                                            !(kl_V3380t@(Cons (!kl_V3380th)
                                                                                                                                                              (!kl_V3380tt))) -> pat_cond_11 kl_V3380t kl_V3380th kl_V3380tt
                                                                                                                                            _ -> pat_cond_13
                                                                                                                       case kl_if_10 of
                                                                                                                           Atom (B (True)) -> do return (Atom (B True))
                                                                                                                           Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                           _ -> throwError "if: expected boolean"
                                                                          pat_cond_14 = do do return (Atom (B False))
                                                                       in case kl_V3380 of
                                                                              !(kl_V3380@(Cons (!kl_V3380h)
                                                                                               (!kl_V3380t))) -> pat_cond_9 kl_V3380 kl_V3380h kl_V3380t
                                                                              _ -> pat_cond_14
                                                          case kl_if_8 of
                                                              Atom (B (True)) -> do return kl_V3380
                                                              Atom (B (False)) -> do let pat_cond_15 kl_V3380 kl_V3380t kl_V3380th kl_V3380tt kl_V3380tth = do !appl_16 <- kl_V3380th `pseq` kl_shen_curry kl_V3380th
                                                                                                                                                               !appl_17 <- appl_16 `pseq` (kl_V3380tt `pseq` klCons appl_16 kl_V3380tt)
                                                                                                                                                               appl_17 `pseq` klCons (ApplC (wrapNamed "type" typeA)) appl_17
                                                                                         pat_cond_18 kl_V3380 kl_V3380h kl_V3380t kl_V3380th kl_V3380tt kl_V3380tth kl_V3380ttt = do !appl_19 <- kl_V3380th `pseq` klCons kl_V3380th (Types.Atom Types.Nil)
                                                                                                                                                                                     !appl_20 <- kl_V3380h `pseq` (appl_19 `pseq` klCons kl_V3380h appl_19)
                                                                                                                                                                                     !appl_21 <- appl_20 `pseq` (kl_V3380tt `pseq` klCons appl_20 kl_V3380tt)
                                                                                                                                                                                     appl_21 `pseq` kl_shen_curry appl_21
                                                                                         pat_cond_22 kl_V3380 kl_V3380h kl_V3380t kl_V3380th = do !appl_23 <- kl_V3380h `pseq` kl_shen_curry kl_V3380h
                                                                                                                                                  !appl_24 <- kl_V3380th `pseq` kl_shen_curry kl_V3380th
                                                                                                                                                  !appl_25 <- appl_24 `pseq` klCons appl_24 (Types.Atom Types.Nil)
                                                                                                                                                  appl_23 `pseq` (appl_25 `pseq` klCons appl_23 appl_25)
                                                                                         pat_cond_26 = do do return kl_V3380
                                                                                      in case kl_V3380 of
                                                                                             !(kl_V3380@(Cons (Atom (UnboundSym "type"))
                                                                                                              (!(kl_V3380t@(Cons (!kl_V3380th)
                                                                                                                                 (!(kl_V3380tt@(Cons (!kl_V3380tth)
                                                                                                                                                     (Atom (Nil)))))))))) -> pat_cond_15 kl_V3380 kl_V3380t kl_V3380th kl_V3380tt kl_V3380tth
                                                                                             !(kl_V3380@(Cons (ApplC (PL "type"
                                                                                                                         _))
                                                                                                              (!(kl_V3380t@(Cons (!kl_V3380th)
                                                                                                                                 (!(kl_V3380tt@(Cons (!kl_V3380tth)
                                                                                                                                                     (Atom (Nil)))))))))) -> pat_cond_15 kl_V3380 kl_V3380t kl_V3380th kl_V3380tt kl_V3380tth
                                                                                             !(kl_V3380@(Cons (ApplC (Func "type"
                                                                                                                           _))
                                                                                                              (!(kl_V3380t@(Cons (!kl_V3380th)
                                                                                                                                 (!(kl_V3380tt@(Cons (!kl_V3380tth)
                                                                                                                                                     (Atom (Nil)))))))))) -> pat_cond_15 kl_V3380 kl_V3380t kl_V3380th kl_V3380tt kl_V3380tth
                                                                                             !(kl_V3380@(Cons (!kl_V3380h)
                                                                                                              (!(kl_V3380t@(Cons (!kl_V3380th)
                                                                                                                                 (!(kl_V3380tt@(Cons (!kl_V3380tth)
                                                                                                                                                     (!kl_V3380ttt))))))))) -> pat_cond_18 kl_V3380 kl_V3380h kl_V3380t kl_V3380th kl_V3380tt kl_V3380tth kl_V3380ttt
                                                                                             !(kl_V3380@(Cons (!kl_V3380h)
                                                                                                              (!(kl_V3380t@(Cons (!kl_V3380th)
                                                                                                                                 (Atom (Nil))))))) -> pat_cond_22 kl_V3380 kl_V3380h kl_V3380t kl_V3380th
                                                                                             _ -> pat_cond_26
                                                              _ -> throwError "if: expected boolean"
                                   _ -> throwError "if: expected boolean"

kl_shen_specialP :: Types.KLValue ->
                    Types.KLContext Types.Env Types.KLValue
kl_shen_specialP (!kl_V3382) = do !appl_0 <- value (Types.Atom (Types.UnboundSym "shen.*special*"))
                                  kl_V3382 `pseq` (appl_0 `pseq` kl_elementP kl_V3382 appl_0)

kl_shen_extraspecialP :: Types.KLValue ->
                         Types.KLContext Types.Env Types.KLValue
kl_shen_extraspecialP (!kl_V3384) = do !appl_0 <- value (Types.Atom (Types.UnboundSym "shen.*extraspecial*"))
                                       kl_V3384 `pseq` (appl_0 `pseq` kl_elementP kl_V3384 appl_0)

kl_shen_tMult :: Types.KLValue ->
                 Types.KLValue ->
                 Types.KLValue ->
                 Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_tMult (!kl_V3389) (!kl_V3390) (!kl_V3391) (!kl_V3392) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_Throwcontrol) -> do let !appl_1 = ApplC (Func "lambda" (Context (\(!kl_Case) -> do let pat_cond_2 = do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_Case) -> do let pat_cond_4 = do let !appl_5 = ApplC (Func "lambda" (Context (\(!kl_Case) -> do let pat_cond_6 = do let !appl_7 = ApplC (Func "lambda" (Context (\(!kl_Datatypes) -> do !appl_8 <- kl_shen_incinfs
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       let !appl_9 = ApplC (PL "thunk" (do !appl_10 <- value (Types.Atom (Types.UnboundSym "shen.*datatypes*"))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           let !appl_11 = ApplC (PL "thunk" (do kl_V3389 `pseq` (kl_V3390 `pseq` (kl_Datatypes `pseq` (kl_V3391 `pseq` (kl_V3392 `pseq` kl_shen_udefsMult kl_V3389 kl_V3390 kl_Datatypes kl_V3391 kl_V3392))))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           kl_Datatypes `pseq` (appl_10 `pseq` (kl_V3391 `pseq` (appl_11 `pseq` kl_bind kl_Datatypes appl_10 kl_V3391 appl_11)))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       !appl_12 <- kl_V3389 `pseq` (kl_V3390 `pseq` (kl_V3391 `pseq` (appl_9 `pseq` kl_shen_show kl_V3389 kl_V3390 kl_V3391 appl_9)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       appl_8 `pseq` (appl_12 `pseq` kl_do appl_8 appl_12))))
                                                                                                                                                                                                                                                                                                                                                                                                   !appl_13 <- kl_V3391 `pseq` kl_shen_newpv kl_V3391
                                                                                                                                                                                                                                                                                                                                                                                                   appl_13 `pseq` applyWrapper appl_7 [appl_13]
                                                                                                                                                                                                                                                                                                                                                                                   pat_cond_14 = do do return kl_Case
                                                                                                                                                                                                                                                                                                                                                                                in case kl_Case of
                                                                                                                                                                                                                                                                                                                                                                                       kl_Case@(Atom (UnboundSym "false")) -> pat_cond_6
                                                                                                                                                                                                                                                                                                                                                                                       kl_Case@(Atom (B (False))) -> pat_cond_6
                                                                                                                                                                                                                                                                                                                                                                                       _ -> pat_cond_14)))
                                                                                                                                                                                                                                                                                                                let !appl_15 = ApplC (Func "lambda" (Context (\(!kl_V3370) -> do let pat_cond_16 kl_V3370 kl_V3370h kl_V3370t = do let !appl_17 = ApplC (Func "lambda" (Context (\(!kl_X) -> do let !appl_18 = ApplC (Func "lambda" (Context (\(!kl_V3371) -> do let pat_cond_19 kl_V3371 kl_V3371h kl_V3371t = do let !appl_20 = ApplC (Func "lambda" (Context (\(!kl_V3372) -> do let pat_cond_21 = do let !appl_22 = ApplC (Func "lambda" (Context (\(!kl_V3373) -> do let pat_cond_23 kl_V3373 kl_V3373h kl_V3373t = do let !appl_24 = ApplC (Func "lambda" (Context (\(!kl_A) -> do let !appl_25 = ApplC (Func "lambda" (Context (\(!kl_V3374) -> do let pat_cond_26 = do !appl_27 <- kl_shen_incinfs
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               !appl_28 <- kl_shen_type_theory_enabledP
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               let !appl_29 = ApplC (PL "thunk" (do let !appl_30 = ApplC (PL "thunk" (do kl_X `pseq` (kl_A `pseq` (kl_V3390 `pseq` (kl_V3391 `pseq` (kl_V3392 `pseq` kl_shen_thMult kl_X kl_A kl_V3390 kl_V3391 kl_V3392))))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    kl_Throwcontrol `pseq` (kl_V3391 `pseq` (appl_30 `pseq` kl_cut kl_Throwcontrol kl_V3391 appl_30))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               !appl_31 <- appl_28 `pseq` (kl_V3391 `pseq` (appl_29 `pseq` kl_fwhen appl_28 kl_V3391 appl_29))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               appl_27 `pseq` (appl_31 `pseq` kl_do appl_27 appl_31)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              pat_cond_32 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           in case kl_V3374 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  kl_V3374@(Atom (Nil)) -> pat_cond_26
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  _ -> pat_cond_32)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !appl_33 <- kl_V3373t `pseq` (kl_V3391 `pseq` kl_shen_lazyderef kl_V3373t kl_V3391)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         appl_33 `pseq` applyWrapper appl_25 [appl_33])))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            kl_V3373h `pseq` applyWrapper appl_24 [kl_V3373h]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              pat_cond_34 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           in case kl_V3373 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !(kl_V3373@(Cons (!kl_V3373h)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   (!kl_V3373t))) -> pat_cond_23 kl_V3373 kl_V3373h kl_V3373t
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  _ -> pat_cond_34)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !appl_35 <- kl_V3371t `pseq` (kl_V3391 `pseq` kl_shen_lazyderef kl_V3371t kl_V3391)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         appl_35 `pseq` applyWrapper appl_22 [appl_35]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        pat_cond_36 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     in case kl_V3372 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            kl_V3372@(Atom (UnboundSym ":")) -> pat_cond_21
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            kl_V3372@(ApplC (PL ":"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                _)) -> pat_cond_21
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            kl_V3372@(ApplC (Func ":"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  _)) -> pat_cond_21
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            _ -> pat_cond_36)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   !appl_37 <- kl_V3371h `pseq` (kl_V3391 `pseq` kl_shen_lazyderef kl_V3371h kl_V3391)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   appl_37 `pseq` applyWrapper appl_20 [appl_37]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     pat_cond_38 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  in case kl_V3371 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !(kl_V3371@(Cons (!kl_V3371h)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          (!kl_V3371t))) -> pat_cond_19 kl_V3371 kl_V3371h kl_V3371t
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         _ -> pat_cond_38)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !appl_39 <- kl_V3370t `pseq` (kl_V3391 `pseq` kl_shen_lazyderef kl_V3370t kl_V3391)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                appl_39 `pseq` applyWrapper appl_18 [appl_39])))
                                                                                                                                                                                                                                                                                                                                                                                                                                   kl_V3370h `pseq` applyWrapper appl_17 [kl_V3370h]
                                                                                                                                                                                                                                                                                                                                                                                     pat_cond_40 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                  in case kl_V3370 of
                                                                                                                                                                                                                                                                                                                                                                                         !(kl_V3370@(Cons (!kl_V3370h)
                                                                                                                                                                                                                                                                                                                                                                                                          (!kl_V3370t))) -> pat_cond_16 kl_V3370 kl_V3370h kl_V3370t
                                                                                                                                                                                                                                                                                                                                                                                         _ -> pat_cond_40)))
                                                                                                                                                                                                                                                                                                                !appl_41 <- kl_V3389 `pseq` (kl_V3391 `pseq` kl_shen_lazyderef kl_V3389 kl_V3391)
                                                                                                                                                                                                                                                                                                                !appl_42 <- appl_41 `pseq` applyWrapper appl_15 [appl_41]
                                                                                                                                                                                                                                                                                                                appl_42 `pseq` applyWrapper appl_5 [appl_42]
                                                                                                                                                                                                                                                                                                pat_cond_43 = do do return kl_Case
                                                                                                                                                                                                                                                                                             in case kl_Case of
                                                                                                                                                                                                                                                                                                    kl_Case@(Atom (UnboundSym "false")) -> pat_cond_4
                                                                                                                                                                                                                                                                                                    kl_Case@(Atom (B (False))) -> pat_cond_4
                                                                                                                                                                                                                                                                                                    _ -> pat_cond_43)))
                                                                                                                                                                                                                             let !appl_44 = ApplC (Func "lambda" (Context (\(!kl_V3369) -> do let pat_cond_45 = do !appl_46 <- kl_shen_incinfs
                                                                                                                                                                                                                                                                                                                   let !appl_47 = ApplC (PL "thunk" (do kl_V3391 `pseq` (kl_V3392 `pseq` kl_shen_prolog_failure kl_V3391 kl_V3392)))
                                                                                                                                                                                                                                                                                                                   !appl_48 <- kl_Throwcontrol `pseq` (kl_V3391 `pseq` (appl_47 `pseq` kl_cut kl_Throwcontrol kl_V3391 appl_47))
                                                                                                                                                                                                                                                                                                                   appl_46 `pseq` (appl_48 `pseq` kl_do appl_46 appl_48)
                                                                                                                                                                                                                                                                                                  pat_cond_49 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                               in case kl_V3369 of
                                                                                                                                                                                                                                                                                                      kl_V3369@(Atom (UnboundSym "fail")) -> pat_cond_45
                                                                                                                                                                                                                                                                                                      kl_V3369@(ApplC (PL "fail"
                                                                                                                                                                                                                                                                                                                          _)) -> pat_cond_45
                                                                                                                                                                                                                                                                                                      kl_V3369@(ApplC (Func "fail"
                                                                                                                                                                                                                                                                                                                            _)) -> pat_cond_45
                                                                                                                                                                                                                                                                                                      _ -> pat_cond_49)))
                                                                                                                                                                                                                             !appl_50 <- kl_V3389 `pseq` (kl_V3391 `pseq` kl_shen_lazyderef kl_V3389 kl_V3391)
                                                                                                                                                                                                                             !appl_51 <- appl_50 `pseq` applyWrapper appl_44 [appl_50]
                                                                                                                                                                                                                             appl_51 `pseq` applyWrapper appl_3 [appl_51]
                                                                                                                                                                                                             pat_cond_52 = do do return kl_Case
                                                                                                                                                                                                          in case kl_Case of
                                                                                                                                                                                                                 kl_Case@(Atom (UnboundSym "false")) -> pat_cond_2
                                                                                                                                                                                                                 kl_Case@(Atom (B (False))) -> pat_cond_2
                                                                                                                                                                                                                 _ -> pat_cond_52)))
                                                                                                                                          let !appl_53 = ApplC (Func "lambda" (Context (\(!kl_Error) -> do !appl_54 <- kl_shen_incinfs
                                                                                                                                                                                                           !appl_55 <- kl_shen_maxinfexceededP
                                                                                                                                                                                                           let !appl_56 = ApplC (PL "thunk" (do !appl_57 <- kl_shen_errormaxinfs
                                                                                                                                                                                                                                                kl_Error `pseq` (appl_57 `pseq` (kl_V3391 `pseq` (kl_V3392 `pseq` kl_bind kl_Error appl_57 kl_V3391 kl_V3392)))))
                                                                                                                                                                                                           !appl_58 <- appl_55 `pseq` (kl_V3391 `pseq` (appl_56 `pseq` kl_fwhen appl_55 kl_V3391 appl_56))
                                                                                                                                                                                                           appl_54 `pseq` (appl_58 `pseq` kl_do appl_54 appl_58))))
                                                                                                                                          !appl_59 <- kl_V3391 `pseq` kl_shen_newpv kl_V3391
                                                                                                                                          !appl_60 <- appl_59 `pseq` applyWrapper appl_53 [appl_59]
                                                                                                                                          !appl_61 <- appl_60 `pseq` applyWrapper appl_1 [appl_60]
                                                                                                                                          kl_Throwcontrol `pseq` (appl_61 `pseq` kl_shen_cutpoint kl_Throwcontrol appl_61))))
                                                                   !appl_62 <- kl_shen_catchpoint
                                                                   appl_62 `pseq` applyWrapper appl_0 [appl_62]

kl_shen_type_theory_enabledP :: Types.KLContext Types.Env
                                                Types.KLValue
kl_shen_type_theory_enabledP = do value (Types.Atom (Types.UnboundSym "shen.*shen-type-theory-enabled?*"))

kl_enable_type_theory :: Types.KLValue ->
                         Types.KLContext Types.Env Types.KLValue
kl_enable_type_theory (!kl_V3398) = do let pat_cond_0 = do klSet (Types.Atom (Types.UnboundSym "shen.*shen-type-theory-enabled?*")) (Atom (B True))
                                           pat_cond_1 = do klSet (Types.Atom (Types.UnboundSym "shen.*shen-type-theory-enabled?*")) (Atom (B False))
                                           pat_cond_2 = do do simpleError (Types.Atom (Types.Str "enable-type-theory expects a + or a -\n"))
                                        in case kl_V3398 of
                                               kl_V3398@(Atom (UnboundSym "+")) -> pat_cond_0
                                               kl_V3398@(ApplC (PL "+" _)) -> pat_cond_0
                                               kl_V3398@(ApplC (Func "+" _)) -> pat_cond_0
                                               kl_V3398@(Atom (UnboundSym "-")) -> pat_cond_1
                                               kl_V3398@(ApplC (PL "-" _)) -> pat_cond_1
                                               kl_V3398@(ApplC (Func "-" _)) -> pat_cond_1
                                               _ -> pat_cond_2

kl_shen_prolog_failure :: Types.KLValue ->
                          Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_prolog_failure (!kl_V3409) (!kl_V3410) = do return (Atom (B False))

kl_shen_maxinfexceededP :: Types.KLContext Types.Env Types.KLValue
kl_shen_maxinfexceededP = do !appl_0 <- kl_inferences
                             !appl_1 <- value (Types.Atom (Types.UnboundSym "shen.*maxinferences*"))
                             appl_0 `pseq` (appl_1 `pseq` greaterThan appl_0 appl_1)

kl_shen_errormaxinfs :: Types.KLContext Types.Env Types.KLValue
kl_shen_errormaxinfs = do simpleError (Types.Atom (Types.Str "maximum inferences exceeded~%"))

kl_shen_udefsMult :: Types.KLValue ->
                     Types.KLValue ->
                     Types.KLValue ->
                     Types.KLValue ->
                     Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_udefsMult (!kl_V3416) (!kl_V3417) (!kl_V3418) (!kl_V3419) (!kl_V3420) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_Case) -> do let pat_cond_1 = do let !appl_2 = ApplC (Func "lambda" (Context (\(!kl_V3366) -> do let pat_cond_3 kl_V3366 kl_V3366h kl_V3366t = do let !appl_4 = ApplC (Func "lambda" (Context (\(!kl_Ds) -> do !appl_5 <- kl_shen_incinfs
                                                                                                                                                                                                                                                                                                                                                    !appl_6 <- kl_V3416 `pseq` (kl_V3417 `pseq` (kl_Ds `pseq` (kl_V3419 `pseq` (kl_V3420 `pseq` kl_shen_udefsMult kl_V3416 kl_V3417 kl_Ds kl_V3419 kl_V3420))))
                                                                                                                                                                                                                                                                                                                                                    appl_5 `pseq` (appl_6 `pseq` kl_do appl_5 appl_6))))
                                                                                                                                                                                                                                                                                       kl_V3366t `pseq` applyWrapper appl_4 [kl_V3366t]
                                                                                                                                                                                                                                          pat_cond_7 = do do return (Atom (B False))
                                                                                                                                                                                                                                       in case kl_V3366 of
                                                                                                                                                                                                                                              !(kl_V3366@(Cons (!kl_V3366h)
                                                                                                                                                                                                                                                               (!kl_V3366t))) -> pat_cond_3 kl_V3366 kl_V3366h kl_V3366t
                                                                                                                                                                                                                                              _ -> pat_cond_7)))
                                                                                                                                                                      !appl_8 <- kl_V3418 `pseq` (kl_V3419 `pseq` kl_shen_lazyderef kl_V3418 kl_V3419)
                                                                                                                                                                      appl_8 `pseq` applyWrapper appl_2 [appl_8]
                                                                                                                                                      pat_cond_9 = do do return kl_Case
                                                                                                                                                   in case kl_Case of
                                                                                                                                                          kl_Case@(Atom (UnboundSym "false")) -> pat_cond_1
                                                                                                                                                          kl_Case@(Atom (B (False))) -> pat_cond_1
                                                                                                                                                          _ -> pat_cond_9)))
                                                                                   let !appl_10 = ApplC (Func "lambda" (Context (\(!kl_V3365) -> do let pat_cond_11 kl_V3365 kl_V3365h kl_V3365t = do let !appl_12 = ApplC (Func "lambda" (Context (\(!kl_D) -> do !appl_13 <- kl_shen_incinfs
                                                                                                                                                                                                                                                                   !appl_14 <- kl_V3417 `pseq` klCons kl_V3417 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                   !appl_15 <- kl_V3416 `pseq` (appl_14 `pseq` klCons kl_V3416 appl_14)
                                                                                                                                                                                                                                                                   !appl_16 <- kl_D `pseq` (appl_15 `pseq` klCons kl_D appl_15)
                                                                                                                                                                                                                                                                   !appl_17 <- appl_16 `pseq` (kl_V3419 `pseq` (kl_V3420 `pseq` kl_call appl_16 kl_V3419 kl_V3420))
                                                                                                                                                                                                                                                                   appl_13 `pseq` (appl_17 `pseq` kl_do appl_13 appl_17))))
                                                                                                                                                                                                      kl_V3365h `pseq` applyWrapper appl_12 [kl_V3365h]
                                                                                                                                                        pat_cond_18 = do do return (Atom (B False))
                                                                                                                                                     in case kl_V3365 of
                                                                                                                                                            !(kl_V3365@(Cons (!kl_V3365h)
                                                                                                                                                                             (!kl_V3365t))) -> pat_cond_11 kl_V3365 kl_V3365h kl_V3365t
                                                                                                                                                            _ -> pat_cond_18)))
                                                                                   !appl_19 <- kl_V3418 `pseq` (kl_V3419 `pseq` kl_shen_lazyderef kl_V3418 kl_V3419)
                                                                                   !appl_20 <- appl_19 `pseq` applyWrapper appl_10 [appl_19]
                                                                                   appl_20 `pseq` applyWrapper appl_0 [appl_20]

kl_shen_thMult :: Types.KLValue ->
                  Types.KLValue ->
                  Types.KLValue ->
                  Types.KLValue ->
                  Types.KLValue -> Types.KLContext Types.Env Types.KLValue
kl_shen_thMult (!kl_V3426) (!kl_V3427) (!kl_V3428) (!kl_V3429) (!kl_V3430) = do let !appl_0 = ApplC (Func "lambda" (Context (\(!kl_Throwcontrol) -> do let !appl_1 = ApplC (Func "lambda" (Context (\(!kl_Case) -> do let pat_cond_2 = do let !appl_3 = ApplC (Func "lambda" (Context (\(!kl_Case) -> do let pat_cond_4 = do let !appl_5 = ApplC (Func "lambda" (Context (\(!kl_Case) -> do let pat_cond_6 = do let !appl_7 = ApplC (Func "lambda" (Context (\(!kl_Case) -> do let pat_cond_8 = do let !appl_9 = ApplC (Func "lambda" (Context (\(!kl_Case) -> do let pat_cond_10 = do let !appl_11 = ApplC (Func "lambda" (Context (\(!kl_Case) -> do let pat_cond_12 = do let !appl_13 = ApplC (Func "lambda" (Context (\(!kl_Case) -> do let pat_cond_14 = do let !appl_15 = ApplC (Func "lambda" (Context (\(!kl_Case) -> do let pat_cond_16 = do let !appl_17 = ApplC (Func "lambda" (Context (\(!kl_Case) -> do let pat_cond_18 = do let !appl_19 = ApplC (Func "lambda" (Context (\(!kl_Case) -> do let pat_cond_20 = do let !appl_21 = ApplC (Func "lambda" (Context (\(!kl_Case) -> do let pat_cond_22 = do let !appl_23 = ApplC (Func "lambda" (Context (\(!kl_Case) -> do let pat_cond_24 = do let !appl_25 = ApplC (Func "lambda" (Context (\(!kl_Case) -> do let pat_cond_26 = do let !appl_27 = ApplC (Func "lambda" (Context (\(!kl_Case) -> do let pat_cond_28 = do let !appl_29 = ApplC (Func "lambda" (Context (\(!kl_Case) -> do let pat_cond_30 = do let !appl_31 = ApplC (Func "lambda" (Context (\(!kl_Case) -> do let pat_cond_32 = do let !appl_33 = ApplC (Func "lambda" (Context (\(!kl_Case) -> do let pat_cond_34 = do let !appl_35 = ApplC (Func "lambda" (Context (\(!kl_Case) -> do let pat_cond_36 = do let !appl_37 = ApplC (Func "lambda" (Context (\(!kl_Case) -> do let pat_cond_38 = do let !appl_39 = ApplC (Func "lambda" (Context (\(!kl_Case) -> do let pat_cond_40 = do let !appl_41 = ApplC (Func "lambda" (Context (\(!kl_Case) -> do let pat_cond_42 = do let !appl_43 = ApplC (Func "lambda" (Context (\(!kl_Datatypes) -> do !appl_44 <- kl_shen_incinfs
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !appl_45 <- value (Types.Atom (Types.UnboundSym "shen.*datatypes*"))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            let !appl_46 = ApplC (PL "thunk" (do !appl_47 <- kl_V3427 `pseq` klCons kl_V3427 (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 !appl_48 <- appl_47 `pseq` klCons (Types.Atom (Types.UnboundSym ":")) appl_47
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 !appl_49 <- kl_V3426 `pseq` (appl_48 `pseq` klCons kl_V3426 appl_48)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 appl_49 `pseq` (kl_V3428 `pseq` (kl_Datatypes `pseq` (kl_V3429 `pseq` (kl_V3430 `pseq` kl_shen_udefsMult appl_49 kl_V3428 kl_Datatypes kl_V3429 kl_V3430))))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !appl_50 <- kl_Datatypes `pseq` (appl_45 `pseq` (kl_V3429 `pseq` (appl_46 `pseq` kl_bind kl_Datatypes appl_45 kl_V3429 appl_46)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            appl_44 `pseq` (appl_50 `pseq` kl_do appl_44 appl_50))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       !appl_51 <- kl_V3429 `pseq` kl_shen_newpv kl_V3429
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       appl_51 `pseq` applyWrapper appl_43 [appl_51]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      pat_cond_52 = do do return kl_Case
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   in case kl_Case of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          kl_Case@(Atom (UnboundSym "false")) -> pat_cond_42
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          kl_Case@(Atom (B (False))) -> pat_cond_42
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          _ -> pat_cond_52)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  let !appl_53 = ApplC (Func "lambda" (Context (\(!kl_V3359) -> do let pat_cond_54 kl_V3359 kl_V3359h kl_V3359t = do let !appl_55 = ApplC (Func "lambda" (Context (\(!kl_V3360) -> do let pat_cond_56 = do let !appl_57 = ApplC (Func "lambda" (Context (\(!kl_V3361) -> do let pat_cond_58 = do !appl_59 <- kl_shen_incinfs
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 !appl_60 <- kl_V3430 `pseq` kl_thaw kl_V3430
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 appl_59 `pseq` (appl_60 `pseq` kl_do appl_59 appl_60)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                pat_cond_61 = do do !kl_if_62 <- kl_V3361 `pseq` kl_shen_pvarP kl_V3361
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    case kl_if_62 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Atom (B (True)) -> do !appl_63 <- kl_V3361 `pseq` (kl_V3429 `pseq` kl_shen_bindv kl_V3361 (Types.Atom (Types.UnboundSym "symbol")) kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              let !appl_64 = ApplC (Func "lambda" (Context (\(!kl_Result) -> do !appl_65 <- kl_V3361 `pseq` (kl_V3429 `pseq` kl_shen_unbindv kl_V3361 kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                appl_65 `pseq` (kl_Result `pseq` kl_do appl_65 kl_Result))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              !appl_66 <- kl_shen_incinfs
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              !appl_67 <- kl_V3430 `pseq` kl_thaw kl_V3430
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              !appl_68 <- appl_66 `pseq` (appl_67 `pseq` kl_do appl_66 appl_67)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              !appl_69 <- appl_68 `pseq` applyWrapper appl_64 [appl_68]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              appl_63 `pseq` (appl_69 `pseq` kl_do appl_63 appl_69)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             in case kl_V3361 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    kl_V3361@(Atom (UnboundSym "symbol")) -> pat_cond_58
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    kl_V3361@(ApplC (PL "symbol"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        _)) -> pat_cond_58
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    kl_V3361@(ApplC (Func "symbol"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          _)) -> pat_cond_58
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    _ -> pat_cond_61)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           !appl_70 <- kl_V3427 `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3427 kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           appl_70 `pseq` applyWrapper appl_57 [appl_70]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          pat_cond_71 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       in case kl_V3360 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              kl_V3360@(Atom (UnboundSym "shen.synonyms-help")) -> pat_cond_56
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              kl_V3360@(ApplC (PL "shen.synonyms-help"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  _)) -> pat_cond_56
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              kl_V3360@(ApplC (Func "shen.synonyms-help"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    _)) -> pat_cond_56
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              _ -> pat_cond_71)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     !appl_72 <- kl_V3359h `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3359h kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     appl_72 `pseq` applyWrapper appl_55 [appl_72]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       pat_cond_73 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    in case kl_V3359 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           !(kl_V3359@(Cons (!kl_V3359h)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            (!kl_V3359t))) -> pat_cond_54 kl_V3359 kl_V3359h kl_V3359t
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           _ -> pat_cond_73)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !appl_74 <- kl_V3426 `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3426 kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !appl_75 <- appl_74 `pseq` applyWrapper appl_53 [appl_74]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  appl_75 `pseq` applyWrapper appl_41 [appl_75]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 pat_cond_76 = do do return kl_Case
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              in case kl_Case of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     kl_Case@(Atom (UnboundSym "false")) -> pat_cond_40
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     kl_Case@(Atom (B (False))) -> pat_cond_40
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     _ -> pat_cond_76)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             let !appl_77 = ApplC (Func "lambda" (Context (\(!kl_V3356) -> do let pat_cond_78 kl_V3356 kl_V3356h kl_V3356t = do let !appl_79 = ApplC (Func "lambda" (Context (\(!kl_V3357) -> do let pat_cond_80 = do let !appl_81 = ApplC (Func "lambda" (Context (\(!kl_V3358) -> do let pat_cond_82 = do !appl_83 <- kl_shen_incinfs
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !appl_84 <- kl_V3430 `pseq` kl_thaw kl_V3430
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            appl_83 `pseq` (appl_84 `pseq` kl_do appl_83 appl_84)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           pat_cond_85 = do do !kl_if_86 <- kl_V3358 `pseq` kl_shen_pvarP kl_V3358
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               case kl_if_86 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   Atom (B (True)) -> do !appl_87 <- kl_V3358 `pseq` (kl_V3429 `pseq` kl_shen_bindv kl_V3358 (Types.Atom (Types.UnboundSym "symbol")) kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         let !appl_88 = ApplC (Func "lambda" (Context (\(!kl_Result) -> do !appl_89 <- kl_V3358 `pseq` (kl_V3429 `pseq` kl_shen_unbindv kl_V3358 kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           appl_89 `pseq` (kl_Result `pseq` kl_do appl_89 kl_Result))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !appl_90 <- kl_shen_incinfs
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !appl_91 <- kl_V3430 `pseq` kl_thaw kl_V3430
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !appl_92 <- appl_90 `pseq` (appl_91 `pseq` kl_do appl_90 appl_91)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !appl_93 <- appl_92 `pseq` applyWrapper appl_88 [appl_92]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         appl_87 `pseq` (appl_93 `pseq` kl_do appl_87 appl_93)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        in case kl_V3358 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               kl_V3358@(Atom (UnboundSym "symbol")) -> pat_cond_82
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               kl_V3358@(ApplC (PL "symbol"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   _)) -> pat_cond_82
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               kl_V3358@(ApplC (Func "symbol"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     _)) -> pat_cond_82
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               _ -> pat_cond_85)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_94 <- kl_V3427 `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3427 kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      appl_94 `pseq` applyWrapper appl_81 [appl_94]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     pat_cond_95 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  in case kl_V3357 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         kl_V3357@(Atom (UnboundSym "shen.process-datatype")) -> pat_cond_80
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         kl_V3357@(ApplC (PL "shen.process-datatype"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             _)) -> pat_cond_80
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         kl_V3357@(ApplC (Func "shen.process-datatype"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               _)) -> pat_cond_80
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         _ -> pat_cond_95)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !appl_96 <- kl_V3356h `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3356h kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                appl_96 `pseq` applyWrapper appl_79 [appl_96]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  pat_cond_97 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               in case kl_V3356 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !(kl_V3356@(Cons (!kl_V3356h)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       (!kl_V3356t))) -> pat_cond_78 kl_V3356 kl_V3356h kl_V3356t
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      _ -> pat_cond_97)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             !appl_98 <- kl_V3426 `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3426 kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             !appl_99 <- appl_98 `pseq` applyWrapper appl_77 [appl_98]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             appl_99 `pseq` applyWrapper appl_39 [appl_99]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            pat_cond_100 = do do return kl_Case
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         in case kl_Case of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                kl_Case@(Atom (UnboundSym "false")) -> pat_cond_38
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                kl_Case@(Atom (B (False))) -> pat_cond_38
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                _ -> pat_cond_100)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        let !appl_101 = ApplC (Func "lambda" (Context (\(!kl_V3353) -> do let pat_cond_102 kl_V3353 kl_V3353h kl_V3353t = do let !appl_103 = ApplC (Func "lambda" (Context (\(!kl_V3354) -> do let pat_cond_104 = do let !appl_105 = ApplC (Func "lambda" (Context (\(!kl_V3355) -> do let pat_cond_106 = do !appl_107 <- kl_shen_incinfs
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             !appl_108 <- kl_Throwcontrol `pseq` (kl_V3429 `pseq` (kl_V3430 `pseq` kl_cut kl_Throwcontrol kl_V3429 kl_V3430))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             appl_107 `pseq` (appl_108 `pseq` kl_do appl_107 appl_108)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           pat_cond_109 = do do !kl_if_110 <- kl_V3355 `pseq` kl_shen_pvarP kl_V3355
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                case kl_if_110 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Atom (B (True)) -> do !appl_111 <- kl_V3355 `pseq` (kl_V3429 `pseq` kl_shen_bindv kl_V3355 (Types.Atom (Types.UnboundSym "unit")) kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          let !appl_112 = ApplC (Func "lambda" (Context (\(!kl_Result) -> do !appl_113 <- kl_V3355 `pseq` (kl_V3429 `pseq` kl_shen_unbindv kl_V3355 kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             appl_113 `pseq` (kl_Result `pseq` kl_do appl_113 kl_Result))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          !appl_114 <- kl_shen_incinfs
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          !appl_115 <- kl_Throwcontrol `pseq` (kl_V3429 `pseq` (kl_V3430 `pseq` kl_cut kl_Throwcontrol kl_V3429 kl_V3430))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          !appl_116 <- appl_114 `pseq` (appl_115 `pseq` kl_do appl_114 appl_115)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          !appl_117 <- appl_116 `pseq` applyWrapper appl_112 [appl_116]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          appl_111 `pseq` (appl_117 `pseq` kl_do appl_111 appl_117)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        in case kl_V3355 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               kl_V3355@(Atom (UnboundSym "unit")) -> pat_cond_106
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               kl_V3355@(ApplC (PL "unit"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   _)) -> pat_cond_106
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               kl_V3355@(ApplC (Func "unit"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     _)) -> pat_cond_106
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               _ -> pat_cond_109)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     !appl_118 <- kl_V3427 `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3427 kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     appl_118 `pseq` applyWrapper appl_105 [appl_118]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   pat_cond_119 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                in case kl_V3354 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       kl_V3354@(Atom (UnboundSym "defmacro")) -> pat_cond_104
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       kl_V3354@(ApplC (PL "defmacro"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           _)) -> pat_cond_104
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       kl_V3354@(ApplC (Func "defmacro"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             _)) -> pat_cond_104
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       _ -> pat_cond_119)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             !appl_120 <- kl_V3353h `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3353h kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             appl_120 `pseq` applyWrapper appl_103 [appl_120]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              pat_cond_121 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           in case kl_V3353 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !(kl_V3353@(Cons (!kl_V3353h)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   (!kl_V3353t))) -> pat_cond_102 kl_V3353 kl_V3353h kl_V3353t
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  _ -> pat_cond_121)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        !appl_122 <- kl_V3426 `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3426 kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        !appl_123 <- appl_122 `pseq` applyWrapper appl_101 [appl_122]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        appl_123 `pseq` applyWrapper appl_37 [appl_123]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       pat_cond_124 = do do return kl_Case
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    in case kl_Case of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           kl_Case@(Atom (UnboundSym "false")) -> pat_cond_36
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           kl_Case@(Atom (B (False))) -> pat_cond_36
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           _ -> pat_cond_124)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   let !appl_125 = ApplC (Func "lambda" (Context (\(!kl_V3350) -> do let pat_cond_126 kl_V3350 kl_V3350h kl_V3350t = do let !appl_127 = ApplC (Func "lambda" (Context (\(!kl_V3351) -> do let pat_cond_128 = do let !appl_129 = ApplC (Func "lambda" (Context (\(!kl_V3352) -> do let pat_cond_130 kl_V3352 kl_V3352h kl_V3352t = do let !appl_131 = ApplC (Func "lambda" (Context (\(!kl_F) -> do let !appl_132 = ApplC (Func "lambda" (Context (\(!kl_X) -> do !appl_133 <- kl_shen_incinfs
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 let !appl_134 = ApplC (PL "thunk" (do !appl_135 <- kl_F `pseq` (kl_X `pseq` klCons kl_F kl_X)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       !appl_136 <- appl_135 `pseq` klCons (Types.Atom (Types.UnboundSym "define")) appl_135
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       appl_136 `pseq` (kl_V3427 `pseq` (kl_V3428 `pseq` (kl_V3429 `pseq` (kl_V3430 `pseq` kl_shen_tMult_def appl_136 kl_V3427 kl_V3428 kl_V3429 kl_V3430))))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 !appl_137 <- kl_Throwcontrol `pseq` (kl_V3429 `pseq` (appl_134 `pseq` kl_cut kl_Throwcontrol kl_V3429 appl_134))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 appl_133 `pseq` (appl_137 `pseq` kl_do appl_133 appl_137))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   kl_V3352t `pseq` applyWrapper appl_132 [kl_V3352t])))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     kl_V3352h `pseq` applyWrapper appl_131 [kl_V3352h]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      pat_cond_138 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   in case kl_V3352 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          !(kl_V3352@(Cons (!kl_V3352h)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           (!kl_V3352t))) -> pat_cond_130 kl_V3352 kl_V3352h kl_V3352t
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          _ -> pat_cond_138)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !appl_139 <- kl_V3350t `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3350t kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                appl_139 `pseq` applyWrapper appl_129 [appl_139]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              pat_cond_140 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           in case kl_V3351 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  kl_V3351@(Atom (UnboundSym "define")) -> pat_cond_128
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  kl_V3351@(ApplC (PL "define"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      _)) -> pat_cond_128
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  kl_V3351@(ApplC (Func "define"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        _)) -> pat_cond_128
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  _ -> pat_cond_140)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        !appl_141 <- kl_V3350h `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3350h kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        appl_141 `pseq` applyWrapper appl_127 [appl_141]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         pat_cond_142 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      in case kl_V3350 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             !(kl_V3350@(Cons (!kl_V3350h)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              (!kl_V3350t))) -> pat_cond_126 kl_V3350 kl_V3350h kl_V3350t
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             _ -> pat_cond_142)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   !appl_143 <- kl_V3426 `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3426 kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   !appl_144 <- appl_143 `pseq` applyWrapper appl_125 [appl_143]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   appl_144 `pseq` applyWrapper appl_35 [appl_144]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  pat_cond_145 = do do return kl_Case
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               in case kl_Case of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      kl_Case@(Atom (UnboundSym "false")) -> pat_cond_34
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      kl_Case@(Atom (B (False))) -> pat_cond_34
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      _ -> pat_cond_145)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              let !appl_146 = ApplC (Func "lambda" (Context (\(!kl_NewHyp) -> do !appl_147 <- kl_shen_incinfs
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 let !appl_148 = ApplC (PL "thunk" (do kl_V3426 `pseq` (kl_V3427 `pseq` (kl_NewHyp `pseq` (kl_V3429 `pseq` (kl_V3430 `pseq` kl_shen_thMult kl_V3426 kl_V3427 kl_NewHyp kl_V3429 kl_V3430))))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 !appl_149 <- kl_V3428 `pseq` (kl_NewHyp `pseq` (kl_V3429 `pseq` (appl_148 `pseq` kl_shen_tMult_hyps kl_V3428 kl_NewHyp kl_V3429 appl_148)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 appl_147 `pseq` (appl_149 `pseq` kl_do appl_147 appl_149))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              !appl_150 <- kl_V3429 `pseq` kl_shen_newpv kl_V3429
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              !appl_151 <- appl_150 `pseq` applyWrapper appl_146 [appl_150]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              appl_151 `pseq` applyWrapper appl_33 [appl_151]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             pat_cond_152 = do do return kl_Case
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          in case kl_Case of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 kl_Case@(Atom (UnboundSym "false")) -> pat_cond_32
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 kl_Case@(Atom (B (False))) -> pat_cond_32
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 _ -> pat_cond_152)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         let !appl_153 = ApplC (Func "lambda" (Context (\(!kl_V3345) -> do let pat_cond_154 kl_V3345 kl_V3345h kl_V3345t = do let !appl_155 = ApplC (Func "lambda" (Context (\(!kl_V3346) -> do let pat_cond_156 = do let !appl_157 = ApplC (Func "lambda" (Context (\(!kl_V3347) -> do let pat_cond_158 kl_V3347 kl_V3347h kl_V3347t = do let !appl_159 = ApplC (Func "lambda" (Context (\(!kl_Var) -> do let !appl_160 = ApplC (Func "lambda" (Context (\(!kl_V3348) -> do let pat_cond_161 kl_V3348 kl_V3348h kl_V3348t = do let !appl_162 = ApplC (Func "lambda" (Context (\(!kl_Val) -> do let !appl_163 = ApplC (Func "lambda" (Context (\(!kl_V3349) -> do let pat_cond_164 = do !appl_165 <- kl_shen_incinfs
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        let !appl_166 = ApplC (PL "thunk" (do let !appl_167 = ApplC (PL "thunk" (do let !appl_168 = ApplC (PL "thunk" (do !appl_169 <- kl_Var `pseq` klCons kl_Var (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          !appl_170 <- appl_169 `pseq` klCons (ApplC (wrapNamed "value" value)) appl_169
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          let !appl_171 = ApplC (PL "thunk" (do kl_Val `pseq` (kl_V3427 `pseq` (kl_V3428 `pseq` (kl_V3429 `pseq` (kl_V3430 `pseq` kl_shen_thMult kl_Val kl_V3427 kl_V3428 kl_V3429 kl_V3430))))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          appl_170 `pseq` (kl_V3427 `pseq` (kl_V3428 `pseq` (kl_V3429 `pseq` (appl_171 `pseq` kl_shen_thMult appl_170 kl_V3427 kl_V3428 kl_V3429 appl_171))))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    kl_Throwcontrol `pseq` (kl_V3429 `pseq` (appl_168 `pseq` kl_cut kl_Throwcontrol kl_V3429 appl_168))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              kl_Var `pseq` (kl_V3428 `pseq` (kl_V3429 `pseq` (appl_167 `pseq` kl_shen_thMult kl_Var (Types.Atom (Types.UnboundSym "symbol")) kl_V3428 kl_V3429 appl_167)))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        !appl_172 <- kl_Throwcontrol `pseq` (kl_V3429 `pseq` (appl_166 `pseq` kl_cut kl_Throwcontrol kl_V3429 appl_166))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        appl_165 `pseq` (appl_172 `pseq` kl_do appl_165 appl_172)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      pat_cond_173 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   in case kl_V3349 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          kl_V3349@(Atom (Nil)) -> pat_cond_164
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          _ -> pat_cond_173)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !appl_174 <- kl_V3348t `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3348t kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                appl_174 `pseq` applyWrapper appl_163 [appl_174])))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                kl_V3348h `pseq` applyWrapper appl_162 [kl_V3348h]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 pat_cond_175 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              in case kl_V3348 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     !(kl_V3348@(Cons (!kl_V3348h)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      (!kl_V3348t))) -> pat_cond_161 kl_V3348 kl_V3348h kl_V3348t
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     _ -> pat_cond_175)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           !appl_176 <- kl_V3347t `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3347t kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           appl_176 `pseq` applyWrapper appl_160 [appl_176])))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           kl_V3347h `pseq` applyWrapper appl_159 [kl_V3347h]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            pat_cond_177 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         in case kl_V3347 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !(kl_V3347@(Cons (!kl_V3347h)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 (!kl_V3347t))) -> pat_cond_158 kl_V3347 kl_V3347h kl_V3347t
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                _ -> pat_cond_177)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !appl_178 <- kl_V3345t `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3345t kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      appl_178 `pseq` applyWrapper appl_157 [appl_178]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    pat_cond_179 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 in case kl_V3346 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        kl_V3346@(Atom (UnboundSym "set")) -> pat_cond_156
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        kl_V3346@(ApplC (PL "set"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            _)) -> pat_cond_156
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        kl_V3346@(ApplC (Func "set"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              _)) -> pat_cond_156
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        _ -> pat_cond_179)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              !appl_180 <- kl_V3345h `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3345h kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              appl_180 `pseq` applyWrapper appl_155 [appl_180]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               pat_cond_181 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            in case kl_V3345 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   !(kl_V3345@(Cons (!kl_V3345h)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    (!kl_V3345t))) -> pat_cond_154 kl_V3345 kl_V3345h kl_V3345t
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   _ -> pat_cond_181)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !appl_182 <- kl_V3426 `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3426 kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !appl_183 <- appl_182 `pseq` applyWrapper appl_153 [appl_182]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         appl_183 `pseq` applyWrapper appl_31 [appl_183]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        pat_cond_184 = do do return kl_Case
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     in case kl_Case of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            kl_Case@(Atom (UnboundSym "false")) -> pat_cond_30
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            kl_Case@(Atom (B (False))) -> pat_cond_30
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            _ -> pat_cond_184)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    let !appl_185 = ApplC (Func "lambda" (Context (\(!kl_V3340) -> do let pat_cond_186 kl_V3340 kl_V3340h kl_V3340t = do let !appl_187 = ApplC (Func "lambda" (Context (\(!kl_V3341) -> do let pat_cond_188 = do let !appl_189 = ApplC (Func "lambda" (Context (\(!kl_V3342) -> do let pat_cond_190 kl_V3342 kl_V3342h kl_V3342t = do let !appl_191 = ApplC (Func "lambda" (Context (\(!kl_A) -> do let !appl_192 = ApplC (Func "lambda" (Context (\(!kl_V3343) -> do let pat_cond_193 kl_V3343 kl_V3343h kl_V3343t = do let !appl_194 = ApplC (Func "lambda" (Context (\(!kl_Stream) -> do let !appl_195 = ApplC (Func "lambda" (Context (\(!kl_V3344) -> do let pat_cond_196 = do let !appl_197 = ApplC (Func "lambda" (Context (\(!kl_C) -> do !appl_198 <- kl_shen_incinfs
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !appl_199 <- kl_A `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_A kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !appl_200 <- appl_199 `pseq` kl_shen_demodulate appl_199
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  let !appl_201 = ApplC (PL "thunk" (do let !appl_202 = ApplC (PL "thunk" (do !appl_203 <- klCons (Types.Atom (Types.UnboundSym "in")) (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              !appl_204 <- appl_203 `pseq` klCons (Types.Atom (Types.UnboundSym "stream")) appl_203
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              kl_Stream `pseq` (appl_204 `pseq` (kl_V3428 `pseq` (kl_V3429 `pseq` (kl_V3430 `pseq` kl_shen_thMult kl_Stream appl_204 kl_V3428 kl_V3429 kl_V3430))))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        kl_V3427 `pseq` (kl_C `pseq` (kl_V3429 `pseq` (appl_202 `pseq` kl_unify kl_V3427 kl_C kl_V3429 appl_202)))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !appl_205 <- kl_C `pseq` (appl_200 `pseq` (kl_V3429 `pseq` (appl_201 `pseq` kl_bind kl_C appl_200 kl_V3429 appl_201)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  appl_198 `pseq` (appl_205 `pseq` kl_do appl_198 appl_205))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    !appl_206 <- kl_V3429 `pseq` kl_shen_newpv kl_V3429
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    appl_206 `pseq` applyWrapper appl_197 [appl_206]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  pat_cond_207 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               in case kl_V3344 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      kl_V3344@(Atom (Nil)) -> pat_cond_196
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      _ -> pat_cond_207)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !appl_208 <- kl_V3343t `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3343t kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            appl_208 `pseq` applyWrapper appl_195 [appl_208])))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         kl_V3343h `pseq` applyWrapper appl_194 [kl_V3343h]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          pat_cond_209 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       in case kl_V3343 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              !(kl_V3343@(Cons (!kl_V3343h)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               (!kl_V3343t))) -> pat_cond_193 kl_V3343 kl_V3343h kl_V3343t
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              _ -> pat_cond_209)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    !appl_210 <- kl_V3342t `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3342t kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    appl_210 `pseq` applyWrapper appl_192 [appl_210])))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      kl_V3342h `pseq` applyWrapper appl_191 [kl_V3342h]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       pat_cond_211 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    in case kl_V3342 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           !(kl_V3342@(Cons (!kl_V3342h)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            (!kl_V3342t))) -> pat_cond_190 kl_V3342 kl_V3342h kl_V3342t
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           _ -> pat_cond_211)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 !appl_212 <- kl_V3340t `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3340t kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 appl_212 `pseq` applyWrapper appl_189 [appl_212]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               pat_cond_213 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            in case kl_V3341 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   kl_V3341@(Atom (UnboundSym "input+")) -> pat_cond_188
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   kl_V3341@(ApplC (PL "input+"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       _)) -> pat_cond_188
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   kl_V3341@(ApplC (Func "input+"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         _)) -> pat_cond_188
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   _ -> pat_cond_213)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !appl_214 <- kl_V3340h `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3340h kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         appl_214 `pseq` applyWrapper appl_187 [appl_214]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          pat_cond_215 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       in case kl_V3340 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              !(kl_V3340@(Cons (!kl_V3340h)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               (!kl_V3340t))) -> pat_cond_186 kl_V3340 kl_V3340h kl_V3340t
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              _ -> pat_cond_215)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    !appl_216 <- kl_V3426 `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3426 kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    !appl_217 <- appl_216 `pseq` applyWrapper appl_185 [appl_216]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    appl_217 `pseq` applyWrapper appl_29 [appl_217]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   pat_cond_218 = do do return kl_Case
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                in case kl_Case of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       kl_Case@(Atom (UnboundSym "false")) -> pat_cond_28
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       kl_Case@(Atom (B (False))) -> pat_cond_28
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       _ -> pat_cond_218)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               let !appl_219 = ApplC (Func "lambda" (Context (\(!kl_V3335) -> do let pat_cond_220 kl_V3335 kl_V3335h kl_V3335t = do let !appl_221 = ApplC (Func "lambda" (Context (\(!kl_V3336) -> do let pat_cond_222 = do let !appl_223 = ApplC (Func "lambda" (Context (\(!kl_V3337) -> do let pat_cond_224 kl_V3337 kl_V3337h kl_V3337t = do let !appl_225 = ApplC (Func "lambda" (Context (\(!kl_X) -> do let !appl_226 = ApplC (Func "lambda" (Context (\(!kl_V3338) -> do let pat_cond_227 kl_V3338 kl_V3338h kl_V3338t = do let !appl_228 = ApplC (Func "lambda" (Context (\(!kl_A) -> do let !appl_229 = ApplC (Func "lambda" (Context (\(!kl_V3339) -> do let pat_cond_230 = do !appl_231 <- kl_shen_incinfs
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          let !appl_232 = ApplC (PL "thunk" (do let !appl_233 = ApplC (PL "thunk" (do kl_X `pseq` (kl_A `pseq` (kl_V3428 `pseq` (kl_V3429 `pseq` (kl_V3430 `pseq` kl_shen_thMult kl_X kl_A kl_V3428 kl_V3429 kl_V3430))))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                kl_A `pseq` (kl_V3427 `pseq` (kl_V3429 `pseq` (appl_233 `pseq` kl_unify kl_A kl_V3427 kl_V3429 appl_233)))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          !appl_234 <- kl_Throwcontrol `pseq` (kl_V3429 `pseq` (appl_232 `pseq` kl_cut kl_Throwcontrol kl_V3429 appl_232))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          appl_231 `pseq` (appl_234 `pseq` kl_do appl_231 appl_234)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        pat_cond_235 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     in case kl_V3339 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            kl_V3339@(Atom (Nil)) -> pat_cond_230
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            _ -> pat_cond_235)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !appl_236 <- kl_V3338t `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3338t kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  appl_236 `pseq` applyWrapper appl_229 [appl_236])))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    kl_V3338h `pseq` applyWrapper appl_228 [kl_V3338h]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     pat_cond_237 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  in case kl_V3338 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !(kl_V3338@(Cons (!kl_V3338h)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          (!kl_V3338t))) -> pat_cond_227 kl_V3338 kl_V3338h kl_V3338t
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         _ -> pat_cond_237)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               !appl_238 <- kl_V3337t `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3337t kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               appl_238 `pseq` applyWrapper appl_226 [appl_238])))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 kl_V3337h `pseq` applyWrapper appl_225 [kl_V3337h]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  pat_cond_239 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               in case kl_V3337 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      !(kl_V3337@(Cons (!kl_V3337h)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       (!kl_V3337t))) -> pat_cond_224 kl_V3337 kl_V3337h kl_V3337t
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      _ -> pat_cond_239)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !appl_240 <- kl_V3335t `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3335t kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            appl_240 `pseq` applyWrapper appl_223 [appl_240]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          pat_cond_241 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       in case kl_V3336 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              kl_V3336@(Atom (UnboundSym "type")) -> pat_cond_222
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              kl_V3336@(ApplC (PL "type"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  _)) -> pat_cond_222
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              kl_V3336@(ApplC (Func "type"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    _)) -> pat_cond_222
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              _ -> pat_cond_241)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    !appl_242 <- kl_V3335h `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3335h kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    appl_242 `pseq` applyWrapper appl_221 [appl_242]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     pat_cond_243 = do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  in case kl_V3335 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !(kl_V3335@(Cons (!kl_V3335h)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          (!kl_V3335t))) -> pat_cond_220 kl_V3335 kl_V3335h kl_V3335t
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         _ -> pat_cond_243)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               !appl_244 <- kl_V3426 `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3426 kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               !appl_245 <- appl_244 `pseq` applyWrapper appl_219 [appl_244]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               appl_245 `pseq` applyWrapper appl_27 [appl_245]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              pat_cond_246 = do do return kl_Case
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           in case kl_Case of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  kl_Case@(Atom (UnboundSym "false")) -> pat_cond_26
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  kl_Case@(Atom (B (False))) -> pat_cond_26
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  _ -> pat_cond_246)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          let !appl_247 = ApplC (Func "lambda" (Context (\(!kl_V3324) -> do let pat_cond_248 kl_V3324 kl_V3324h kl_V3324t = do let !appl_249 = ApplC (Func "lambda" (Context (\(!kl_V3325) -> do let pat_cond_250 = do let !appl_251 = ApplC (Func "lambda" (Context (\(!kl_V3326) -> do let pat_cond_252 kl_V3326 kl_V3326h kl_V3326t = do let !appl_253 = ApplC (Func "lambda" (Context (\(!kl_FileName) -> do let !appl_254 = ApplC (Func "lambda" (Context (\(!kl_V3327) -> do let pat_cond_255 kl_V3327 kl_V3327h kl_V3327t = do let !appl_256 = ApplC (Func "lambda" (Context (\(!kl_Direction3257) -> do let !appl_257 = ApplC (Func "lambda" (Context (\(!kl_V3328) -> do let pat_cond_258 = do let !appl_259 = ApplC (Func "lambda" (Context (\(!kl_V3329) -> do let pat_cond_260 kl_V3329 kl_V3329h kl_V3329t = do let !appl_261 = ApplC (Func "lambda" (Context (\(!kl_V3330) -> do let pat_cond_262 = do let !appl_263 = ApplC (Func "lambda" (Context (\(!kl_V3331) -> do let pat_cond_264 kl_V3331 kl_V3331h kl_V3331t = do let !appl_265 = ApplC (Func "lambda" (Context (\(!kl_Direction) -> do let !appl_266 = ApplC (Func "lambda" (Context (\(!kl_V3332) -> do let pat_cond_267 = do !appl_268 <- kl_shen_incinfs
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        let !appl_269 = ApplC (PL "thunk" (do let !appl_270 = ApplC (PL "thunk" (do !appl_271 <- kl_Direction `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_Direction kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    !appl_272 <- klCons (Types.Atom (Types.UnboundSym "out")) (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    !appl_273 <- appl_272 `pseq` klCons (Types.Atom (Types.UnboundSym "in")) appl_272
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    !appl_274 <- appl_271 `pseq` (appl_273 `pseq` kl_elementP appl_271 appl_273)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    let !appl_275 = ApplC (PL "thunk" (do kl_FileName `pseq` (kl_V3428 `pseq` (kl_V3429 `pseq` (kl_V3430 `pseq` kl_shen_thMult kl_FileName (Types.Atom (Types.UnboundSym "string")) kl_V3428 kl_V3429 kl_V3430)))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    appl_274 `pseq` (kl_V3429 `pseq` (appl_275 `pseq` kl_fwhen appl_274 kl_V3429 appl_275))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              kl_Throwcontrol `pseq` (kl_V3429 `pseq` (appl_270 `pseq` kl_cut kl_Throwcontrol kl_V3429 appl_270))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        !appl_276 <- kl_Direction `pseq` (kl_Direction3257 `pseq` (kl_V3429 `pseq` (appl_269 `pseq` kl_unifyExcl kl_Direction kl_Direction3257 kl_V3429 appl_269)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        appl_268 `pseq` (appl_276 `pseq` kl_do appl_268 appl_276)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      pat_cond_277 = do do !kl_if_278 <- kl_V3332 `pseq` kl_shen_pvarP kl_V3332
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           case kl_if_278 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               Atom (B (True)) -> do !appl_279 <- kl_V3332 `pseq` (kl_V3429 `pseq` kl_shen_bindv kl_V3332 (Types.Atom Types.Nil) kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     let !appl_280 = ApplC (Func "lambda" (Context (\(!kl_Result) -> do !appl_281 <- kl_V3332 `pseq` (kl_V3429 `pseq` kl_shen_unbindv kl_V3332 kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        appl_281 `pseq` (kl_Result `pseq` kl_do appl_281 kl_Result))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     !appl_282 <- kl_shen_incinfs
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     let !appl_283 = ApplC (PL "thunk" (do let !appl_284 = ApplC (PL "thunk" (do !appl_285 <- kl_Direction `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_Direction kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 !appl_286 <- klCons (Types.Atom (Types.UnboundSym "out")) (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 !appl_287 <- appl_286 `pseq` klCons (Types.Atom (Types.UnboundSym "in")) appl_286
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 !appl_288 <- appl_285 `pseq` (appl_287 `pseq` kl_elementP appl_285 appl_287)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 let !appl_289 = ApplC (PL "thunk" (do kl_FileName `pseq` (kl_V3428 `pseq` (kl_V3429 `pseq` (kl_V3430 `pseq` kl_shen_thMult kl_FileName (Types.Atom (Types.UnboundSym "string")) kl_V3428 kl_V3429 kl_V3430)))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 appl_288 `pseq` (kl_V3429 `pseq` (appl_289 `pseq` kl_fwhen appl_288 kl_V3429 appl_289))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           kl_Throwcontrol `pseq` (kl_V3429 `pseq` (appl_284 `pseq` kl_cut kl_Throwcontrol kl_V3429 appl_284))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     !appl_290 <- kl_Direction `pseq` (kl_Direction3257 `pseq` (kl_V3429 `pseq` (appl_283 `pseq` kl_unifyExcl kl_Direction kl_Direction3257 kl_V3429 appl_283)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     !appl_291 <- appl_282 `pseq` (appl_290 `pseq` kl_do appl_282 appl_290)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     !appl_292 <- appl_291 `pseq` applyWrapper appl_280 [appl_291]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     appl_279 `pseq` (appl_292 `pseq` kl_do appl_279 appl_292)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   in case kl_V3332 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          kl_V3332@(Atom (Nil)) -> pat_cond_267
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          _ -> pat_cond_277)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !appl_293 <- kl_V3331t `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3331t kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                appl_293 `pseq` applyWrapper appl_266 [appl_293])))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          kl_V3331h `pseq` applyWrapper appl_265 [kl_V3331h]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           pat_cond_294 = do do !kl_if_295 <- kl_V3331 `pseq` kl_shen_pvarP kl_V3331
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                case kl_if_295 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Atom (B (True)) -> do let !appl_296 = ApplC (Func "lambda" (Context (\(!kl_Direction) -> do !appl_297 <- kl_Direction `pseq` klCons kl_Direction (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !appl_298 <- kl_V3331 `pseq` (appl_297 `pseq` (kl_V3429 `pseq` kl_shen_bindv kl_V3331 appl_297 kl_V3429))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                let !appl_299 = ApplC (Func "lambda" (Context (\(!kl_Result) -> do !appl_300 <- kl_V3331 `pseq` (kl_V3429 `pseq` kl_shen_unbindv kl_V3331 kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   appl_300 `pseq` (kl_Result `pseq` kl_do appl_300 kl_Result))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !appl_301 <- kl_shen_incinfs
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                let !appl_302 = ApplC (PL "thunk" (do let !appl_303 = ApplC (PL "thunk" (do !appl_304 <- kl_Direction `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_Direction kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !appl_305 <- klCons (Types.Atom (Types.UnboundSym "out")) (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !appl_306 <- appl_305 `pseq` klCons (Types.Atom (Types.UnboundSym "in")) appl_305
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !appl_307 <- appl_304 `pseq` (appl_306 `pseq` kl_elementP appl_304 appl_306)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            let !appl_308 = ApplC (PL "thunk" (do kl_FileName `pseq` (kl_V3428 `pseq` (kl_V3429 `pseq` (kl_V3430 `pseq` kl_shen_thMult kl_FileName (Types.Atom (Types.UnboundSym "string")) kl_V3428 kl_V3429 kl_V3430)))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            appl_307 `pseq` (kl_V3429 `pseq` (appl_308 `pseq` kl_fwhen appl_307 kl_V3429 appl_308))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      kl_Throwcontrol `pseq` (kl_V3429 `pseq` (appl_303 `pseq` kl_cut kl_Throwcontrol kl_V3429 appl_303))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !appl_309 <- kl_Direction `pseq` (kl_Direction3257 `pseq` (kl_V3429 `pseq` (appl_302 `pseq` kl_unifyExcl kl_Direction kl_Direction3257 kl_V3429 appl_302)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !appl_310 <- appl_301 `pseq` (appl_309 `pseq` kl_do appl_301 appl_309)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !appl_311 <- appl_310 `pseq` applyWrapper appl_299 [appl_310]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                appl_298 `pseq` (appl_311 `pseq` kl_do appl_298 appl_311))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          !appl_312 <- kl_V3429 `pseq` kl_shen_newpv kl_V3429
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          appl_312 `pseq` applyWrapper appl_296 [appl_312]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        in case kl_V3331 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               !(kl_V3331@(Cons (!kl_V3331h)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                (!kl_V3331t))) -> pat_cond_264 kl_V3331 kl_V3331h kl_V3331t
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               _ -> pat_cond_294)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     !appl_313 <- kl_V3329t `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3329t kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     appl_313 `pseq` applyWrapper appl_263 [appl_313]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   pat_cond_314 = do do !kl_if_315 <- kl_V3330 `pseq` kl_shen_pvarP kl_V3330
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        case kl_if_315 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            Atom (B (True)) -> do !appl_316 <- kl_V3330 `pseq` (kl_V3429 `pseq` kl_shen_bindv kl_V3330 (Types.Atom (Types.UnboundSym "stream")) kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  let !appl_317 = ApplC (Func "lambda" (Context (\(!kl_Result) -> do !appl_318 <- kl_V3330 `pseq` (kl_V3429 `pseq` kl_shen_unbindv kl_V3330 kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     appl_318 `pseq` (kl_Result `pseq` kl_do appl_318 kl_Result))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  let !appl_319 = ApplC (Func "lambda" (Context (\(!kl_V3333) -> do let pat_cond_320 kl_V3333 kl_V3333h kl_V3333t = do let !appl_321 = ApplC (Func "lambda" (Context (\(!kl_Direction) -> do let !appl_322 = ApplC (Func "lambda" (Context (\(!kl_V3334) -> do let pat_cond_323 = do !appl_324 <- kl_shen_incinfs
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     let !appl_325 = ApplC (PL "thunk" (do let !appl_326 = ApplC (PL "thunk" (do !appl_327 <- kl_Direction `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_Direction kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 !appl_328 <- klCons (Types.Atom (Types.UnboundSym "out")) (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 !appl_329 <- appl_328 `pseq` klCons (Types.Atom (Types.UnboundSym "in")) appl_328
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 !appl_330 <- appl_327 `pseq` (appl_329 `pseq` kl_elementP appl_327 appl_329)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 let !appl_331 = ApplC (PL "thunk" (do kl_FileName `pseq` (kl_V3428 `pseq` (kl_V3429 `pseq` (kl_V3430 `pseq` kl_shen_thMult kl_FileName (Types.Atom (Types.UnboundSym "string")) kl_V3428 kl_V3429 kl_V3430)))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 appl_330 `pseq` (kl_V3429 `pseq` (appl_331 `pseq` kl_fwhen appl_330 kl_V3429 appl_331))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           kl_Throwcontrol `pseq` (kl_V3429 `pseq` (appl_326 `pseq` kl_cut kl_Throwcontrol kl_V3429 appl_326))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     !appl_332 <- kl_Direction `pseq` (kl_Direction3257 `pseq` (kl_V3429 `pseq` (appl_325 `pseq` kl_unifyExcl kl_Direction kl_Direction3257 kl_V3429 appl_325)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     appl_324 `pseq` (appl_332 `pseq` kl_do appl_324 appl_332)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   pat_cond_333 = do do !kl_if_334 <- kl_V3334 `pseq` kl_shen_pvarP kl_V3334
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        case kl_if_334 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            Atom (B (True)) -> do !appl_335 <- kl_V3334 `pseq` (kl_V3429 `pseq` kl_shen_bindv kl_V3334 (Types.Atom Types.Nil) kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  let !appl_336 = ApplC (Func "lambda" (Context (\(!kl_Result) -> do !appl_337 <- kl_V3334 `pseq` (kl_V3429 `pseq` kl_shen_unbindv kl_V3334 kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     appl_337 `pseq` (kl_Result `pseq` kl_do appl_337 kl_Result))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !appl_338 <- kl_shen_incinfs
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  let !appl_339 = ApplC (PL "thunk" (do let !appl_340 = ApplC (PL "thunk" (do !appl_341 <- kl_Direction `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_Direction kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              !appl_342 <- klCons (Types.Atom (Types.UnboundSym "out")) (Types.Atom Types.Nil)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              !appl_343 <- appl_342 `pseq` klCons (Types.Atom (Types.UnboundSym "in")) appl_342
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              !appl_344 <- appl_341 `pseq` (appl_343 `pseq` kl_elementP appl_341 appl_343)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              let !appl_345 = ApplC (PL "thunk" (do kl_FileName `pseq` (kl_V3428 `pseq` (kl_V3429 `pseq` (kl_V3430 `pseq` kl_shen_thMult kl_FileName (Types.Atom (Types.UnboundSym "string")) kl_V3428 kl_V3429 kl_V3430)))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              appl_344 `pseq` (kl_V3429 `pseq` (appl_345 `pseq` kl_fwhen appl_344 kl_V3429 appl_345))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        kl_Throwcontrol `pseq` (kl_V3429 `pseq` (appl_340 `pseq` kl_cut kl_Throwcontrol kl_V3429 appl_340))))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !appl_346 <- kl_Direction `pseq` (kl_Direction3257 `pseq` (kl_V3429 `pseq` (appl_339 `pseq` kl_unifyExcl kl_Direction kl_Direction3257 kl_V3429 appl_339)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !appl_347 <- appl_338 `pseq` (appl_346 `pseq` kl_do appl_338 appl_346)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  !appl_348 <- appl_347 `pseq` applyWrapper appl_336 [appl_347]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  appl_335 `pseq` (appl_348 `pseq` kl_do appl_335 appl_348)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            Atom (B (False)) -> do do return (Atom (B False))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            _ -> throwError "if: expected boolean"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                in case kl_V3334 of
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       kl_V3334@(Atom (Nil)) -> pat_cond_323
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       _ -> pat_cond_333)))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             !appl_349 <- kl_V3333t `pseq` (kl_V3429 `pseq` kl_shen_lazyderef kl_V3333t kl_V3429)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             appl_349 `pseq` applyWrapper appl_322 [appl_349])))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       kl_V3333h `pseq` applyWrapper appl_321 [kl_V3333h]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        pat_cond_350 = do do !kl_if_351 <- kl_V3333 `pseq` kl_shen_pvarP kl_V3333
                                                                                                                                                                                                                                                                     