--------------------------------------------------------------------------------
-- |
-- Module      :  Data.SignedMultiset.Show
-- Copyright   :  (c) 2012 Stefan Holdermans
-- License     :  BSD-style
-- Maintainer  :  stefan@vectorfabrics.com
-- Stability   :  provisional
-- Portability :  portable
--
-- Pretty-print utilities for signed multisets.
--
--------------------------------------------------------------------------------

module Data.SignedMultiset.Show (

  showsMembers  -- :: Show a => [(a, Int)] -> ShowS

) where

showsMembers :: Show a => [(a, Int)] -> ShowS
showsMembers []       = ("{}" ++)
showsMembers (x : xs) = cons '{' . showsMember x . go xs
  where
    go []       = cons '}'
    go (y : ys) = cons ',' . showsMember y . go ys

showsMember :: Show a => (a, Int) -> ShowS
showsMember (x, n) = showsPrec 11 x . cons '(' . shows n . cons ')'

cons :: a -> [a] -> [a]
cons = (:)