#include <sqlite3.h>

module Database.SmplstSQLite3.Constants (
	sQLITE_INTEGER, sQLITE_FLOAT, sQLITE_TEXT, sQLITE_BLOB, sQLITE_NULL,

	sQLITE_OK, sQLITE_ROW, sQLITE_DONE,

	sQLITE_ERROR, sQLITE_INTERNAL, sQLITE_PERM,
	
	sQLITE_ABORT_PLAIN, sQLITE_ABORT_ROLLBACK,

	sQLITE_BUSY_PLAIN, sQLITE_BUSY_RECOVERY, sQLITE_BUSY_SNAPSHOT,
	
	sQLITE_LOCKED_PLAIN, sQLITE_LOCKED_SHAREDCACHE,
	
	sQLITE_NOMEM,
	
	sQLITE_READONLY_PLAIN, sQLITE_READONLY_RECOVERY,
	sQLITE_READONLY_CANTLOCK, sQLITE_READONLY_ROLLBACK,
	sQLITE_READONLY_DBMOVED,
	
	sQLITE_INTERRUPT,

	sQLITE_IOERR_PLAIN, sQLITE_IOERR_READ, sQLITE_IOERR_SHORT_READ,
	sQLITE_IOERR_WRITE, sQLITE_IOERR_FSYNC, sQLITE_IOERR_DIR_FSYNC,
	sQLITE_IOERR_TRUNCATE, sQLITE_IOERR_FSTAT, sQLITE_IOERR_UNLOCK,
	sQLITE_IOERR_RDLOCK,
	sQLITE_IOERR_DELETE, sQLITE_IOERR_BLOCKED, sQLITE_IOERR_NOMEM,
	sQLITE_IOERR_ACCESS, sQLITE_IOERR_CHECKRESERVEDLOCK, sQLITE_IOERR_LOCK,
	sQLITE_IOERR_CLOSE, sQLITE_IOERR_DIR_CLOSE,
	sQLITE_IOERR_SHMOPEN, sQLITE_IOERR_SHMSIZE, sQLITE_IOERR_SHMLOCK,
	sQLITE_IOERR_SHMMAP,
	sQLITE_IOERR_SEEK, sQLITE_IOERR_DELETE_NOENT, sQLITE_IOERR_MMAP,
	sQLITE_IOERR_GETTEMPPATH, sQLITE_IOERR_CONVPATH,
	
	sQLITE_CORRUPT_PLAIN, sQLITE_CORRUPT_VTAB,
	
	sQLITE_NOTFOUND,
	sQLITE_FULL,
	
	sQLITE_CANTOPEN_PLAIN, sQLITE_CANTOPEN_NOTEMPDIR, sQLITE_CANTOPEN_ISDIR,
	sQLITE_CANTOPEN_FULLPATH, sQLITE_CANTOPEN_CONVPATH,
	
	sQLITE_PROTOCOL, sQLITE_EMPTY, sQLITE_SCHEMA, sQLITE_TOOBIG,
	
	sQLITE_CONSTRAINT_PLAIN, sQLITE_CONSTRAINT_CHECK,
	sQLITE_CONSTRAINT_COMMITHOOK, sQLITE_CONSTRAINT_FOREIGNKEY,
	sQLITE_CONSTRAINT_FUNCTION, sQLITE_CONSTRAINT_NOTNULL,
	sQLITE_CONSTRAINT_PRIMARYKEY, sQLITE_CONSTRAINT_TRIGGER,
	sQLITE_CONSTRAINT_UNIQUE, sQLITE_CONSTRAINT_VTAB,
	sQLITE_CONSTRAINT_ROWID,
	
	sQLITE_MISMATCH, sQLITE_MISUSE, sQLITE_NOLFS,
	
	sQLITE_AUTH_PLAIN, sQLITE_AUTH_USER,
	
	sQLITE_FORMAT, sQLITE_RANGE, sQLITE_NOTADB,
	
	sQLITE_NOTICE_PLAIN, sQLITE_NOTICE_RECOVER_WAL,
	sQLITE_NOTICE_RECOVER_ROLLBACK,
	
	sQLITE_WARNING_PLAIN, sQLITE_WARNING_AUTOINDEX
	) where

import Foreign.C.Types
import Data.Bits

sQLITE_OK, sQLITE_ROW, sQLITE_DONE :: CInt
sQLITE_OK = #const SQLITE_OK
sQLITE_ROW = #const SQLITE_ROW
sQLITE_DONE = #const SQLITE_DONE

sQLITE_ERROR, sQLITE_INTERNAL, sQLITE_PERM :: CInt

sQLITE_ERROR = #const SQLITE_ERROR
sQLITE_INTERNAL = #const SQLITE_INTERNAL
sQLITE_PERM = #const SQLITE_PERM

sQLITE_ABORT_PLAIN, sQLITE_ABORT_ROLLBACK :: CInt
sQLITE_ABORT_PLAIN = #const SQLITE_ABORT
sQLITE_ABORT_ROLLBACK = #const SQLITE_ABORT_ROLLBACK

sQLITE_BUSY_PLAIN, sQLITE_BUSY_RECOVERY, sQLITE_BUSY_SNAPSHOT :: CInt
sQLITE_BUSY_PLAIN = #const SQLITE_BUSY
sQLITE_BUSY_RECOVERY = #const SQLITE_BUSY_RECOVERY
sQLITE_BUSY_SNAPSHOT = #const SQLITE_BUSY_SNAPSHOT
	
sQLITE_LOCKED_PLAIN, sQLITE_LOCKED_SHAREDCACHE :: CInt
sQLITE_LOCKED_PLAIN = #const SQLITE_LOCKED
sQLITE_LOCKED_SHAREDCACHE = #const SQLITE_LOCKED_SHAREDCACHE

sQLITE_NOMEM :: CInt
sQLITE_NOMEM = #const SQLITE_NOMEM

sQLITE_READONLY_PLAIN, sQLITE_READONLY_RECOVERY, sQLITE_READONLY_CANTLOCK,
	sQLITE_READONLY_ROLLBACK, sQLITE_READONLY_DBMOVED
	:: CInt
sQLITE_READONLY_PLAIN = #const SQLITE_READONLY
sQLITE_READONLY_RECOVERY = #const SQLITE_READONLY_RECOVERY
sQLITE_READONLY_CANTLOCK = #const SQLITE_READONLY_CANTLOCK
sQLITE_READONLY_ROLLBACK = #const SQLITE_READONLY_ROLLBACK
-- sQLITE_READONLY_DBMOVED = #const SQLITE_READONLY_DBMOVED
sQLITE_READONLY_DBMOVED = sQLITE_READONLY_PLAIN .|. 4 `shiftL` 8

sQLITE_INTERRUPT :: CInt
sQLITE_INTERRUPT = #const SQLITE_INTERRUPT
	
sQLITE_IOERR_PLAIN, sQLITE_IOERR_READ, sQLITE_IOERR_SHORT_READ,
	sQLITE_IOERR_WRITE, sQLITE_IOERR_FSYNC, sQLITE_IOERR_DIR_FSYNC,
	sQLITE_IOERR_TRUNCATE, sQLITE_IOERR_FSTAT, sQLITE_IOERR_UNLOCK,
	sQLITE_IOERR_RDLOCK, sQLITE_IOERR_DELETE, sQLITE_IOERR_BLOCKED,
	sQLITE_IOERR_NOMEM, sQLITE_IOERR_ACCESS, sQLITE_IOERR_CHECKRESERVEDLOCK,
	sQLITE_IOERR_LOCK, sQLITE_IOERR_CLOSE, sQLITE_IOERR_DIR_CLOSE,
	sQLITE_IOERR_SHMOPEN, sQLITE_IOERR_SHMSIZE, sQLITE_IOERR_SHMLOCK,
	sQLITE_IOERR_SHMMAP, sQLITE_IOERR_SEEK, sQLITE_IOERR_DELETE_NOENT,
	sQLITE_IOERR_MMAP, sQLITE_IOERR_GETTEMPPATH, sQLITE_IOERR_CONVPATH
	:: CInt
sQLITE_IOERR_PLAIN = #const SQLITE_IOERR
sQLITE_IOERR_READ = #const SQLITE_IOERR_READ
sQLITE_IOERR_SHORT_READ = #const SQLITE_IOERR_SHORT_READ
sQLITE_IOERR_WRITE = #const SQLITE_IOERR_WRITE
sQLITE_IOERR_FSYNC = #const SQLITE_IOERR_FSYNC
sQLITE_IOERR_DIR_FSYNC = #const SQLITE_IOERR_DIR_FSYNC
sQLITE_IOERR_TRUNCATE = #const SQLITE_IOERR_TRUNCATE
sQLITE_IOERR_FSTAT = #const SQLITE_IOERR_FSTAT
sQLITE_IOERR_UNLOCK = #const SQLITE_IOERR_UNLOCK
sQLITE_IOERR_RDLOCK = #const SQLITE_IOERR_RDLOCK
sQLITE_IOERR_DELETE = #const SQLITE_IOERR_DELETE
sQLITE_IOERR_BLOCKED = #const SQLITE_IOERR_BLOCKED
sQLITE_IOERR_NOMEM = #const SQLITE_IOERR_NOMEM
sQLITE_IOERR_ACCESS = #const SQLITE_IOERR_ACCESS
sQLITE_IOERR_CHECKRESERVEDLOCK = #const SQLITE_IOERR_CHECKRESERVEDLOCK
sQLITE_IOERR_LOCK = #const SQLITE_IOERR_LOCK
sQLITE_IOERR_CLOSE = #const SQLITE_IOERR_CLOSE
sQLITE_IOERR_DIR_CLOSE = #const SQLITE_IOERR_DIR_CLOSE
sQLITE_IOERR_SHMOPEN = #const SQLITE_IOERR_SHMOPEN
sQLITE_IOERR_SHMSIZE = #const SQLITE_IOERR_SHMSIZE
sQLITE_IOERR_SHMLOCK = #const SQLITE_IOERR_SHMLOCK
sQLITE_IOERR_SHMMAP = #const SQLITE_IOERR_SHMMAP
sQLITE_IOERR_SEEK = #const SQLITE_IOERR_SEEK
sQLITE_IOERR_DELETE_NOENT = #const SQLITE_IOERR_DELETE_NOENT
sQLITE_IOERR_MMAP = #const SQLITE_IOERR_MMAP
sQLITE_IOERR_GETTEMPPATH = #const SQLITE_IOERR_GETTEMPPATH
sQLITE_IOERR_CONVPATH = #const SQLITE_IOERR_CONVPATH
-- sQLITE_IOERR_VNODE = #const SQLITE_IOERR_VNODE

sQLITE_CORRUPT_PLAIN, sQLITE_CORRUPT_VTAB :: CInt
sQLITE_CORRUPT_PLAIN = #const SQLITE_CORRUPT
sQLITE_CORRUPT_VTAB = #const SQLITE_CORRUPT_VTAB

sQLITE_NOTFOUND, sQLITE_FULL :: CInt
sQLITE_NOTFOUND = #const SQLITE_NOTFOUND
sQLITE_FULL = #const SQLITE_FULL
	
sQLITE_CANTOPEN_PLAIN, sQLITE_CANTOPEN_NOTEMPDIR, sQLITE_CANTOPEN_ISDIR,
	sQLITE_CANTOPEN_FULLPATH, sQLITE_CANTOPEN_CONVPATH
	:: CInt
sQLITE_CANTOPEN_PLAIN = #const SQLITE_CANTOPEN
sQLITE_CANTOPEN_NOTEMPDIR = #const SQLITE_CANTOPEN_NOTEMPDIR
sQLITE_CANTOPEN_ISDIR = #const SQLITE_CANTOPEN_ISDIR
sQLITE_CANTOPEN_FULLPATH = #const SQLITE_CANTOPEN_FULLPATH
sQLITE_CANTOPEN_CONVPATH = #const SQLITE_CANTOPEN_CONVPATH
	
sQLITE_PROTOCOL, sQLITE_EMPTY, sQLITE_SCHEMA, sQLITE_TOOBIG :: CInt
sQLITE_PROTOCOL = #const SQLITE_PROTOCOL
sQLITE_EMPTY = #const SQLITE_EMPTY
sQLITE_SCHEMA = #const SQLITE_SCHEMA
sQLITE_TOOBIG = #const SQLITE_TOOBIG

sQLITE_CONSTRAINT_PLAIN, sQLITE_CONSTRAINT_CHECK,
	sQLITE_CONSTRAINT_COMMITHOOK, sQLITE_CONSTRAINT_FOREIGNKEY,
	sQLITE_CONSTRAINT_FUNCTION, sQLITE_CONSTRAINT_NOTNULL,
	sQLITE_CONSTRAINT_PRIMARYKEY, sQLITE_CONSTRAINT_TRIGGER,
	sQLITE_CONSTRAINT_UNIQUE, sQLITE_CONSTRAINT_VTAB,
	sQLITE_CONSTRAINT_ROWID
	:: CInt
sQLITE_CONSTRAINT_PLAIN = #const SQLITE_CONSTRAINT
sQLITE_CONSTRAINT_CHECK = #const SQLITE_CONSTRAINT_CHECK
sQLITE_CONSTRAINT_COMMITHOOK = #const SQLITE_CONSTRAINT_COMMITHOOK
sQLITE_CONSTRAINT_FOREIGNKEY = #const SQLITE_CONSTRAINT_FOREIGNKEY
sQLITE_CONSTRAINT_FUNCTION = #const SQLITE_CONSTRAINT_FUNCTION
sQLITE_CONSTRAINT_NOTNULL = #const SQLITE_CONSTRAINT_NOTNULL
sQLITE_CONSTRAINT_PRIMARYKEY = #const SQLITE_CONSTRAINT_PRIMARYKEY
sQLITE_CONSTRAINT_TRIGGER = #const SQLITE_CONSTRAINT_TRIGGER
sQLITE_CONSTRAINT_UNIQUE = #const SQLITE_CONSTRAINT_UNIQUE
sQLITE_CONSTRAINT_VTAB = #const SQLITE_CONSTRAINT_VTAB
sQLITE_CONSTRAINT_ROWID = #const SQLITE_CONSTRAINT_ROWID

sQLITE_MISMATCH, sQLITE_MISUSE, sQLITE_NOLFS :: CInt
sQLITE_MISMATCH = #const SQLITE_MISMATCH
sQLITE_MISUSE = #const SQLITE_MISUSE
sQLITE_NOLFS = #const SQLITE_NOLFS

sQLITE_AUTH_PLAIN, sQLITE_AUTH_USER :: CInt
sQLITE_AUTH_PLAIN = #const SQLITE_AUTH
-- sQLITE_AUTH_USER = #const SQLITE_AUTH_USER
sQLITE_AUTH_USER = sQLITE_AUTH_PLAIN .|. 1 `shiftL` 8

sQLITE_FORMAT, sQLITE_RANGE, sQLITE_NOTADB :: CInt
sQLITE_FORMAT = #const SQLITE_FORMAT
sQLITE_RANGE = #const SQLITE_RANGE
sQLITE_NOTADB = #const SQLITE_NOTADB

sQLITE_NOTICE_PLAIN, sQLITE_NOTICE_RECOVER_WAL, sQLITE_NOTICE_RECOVER_ROLLBACK
	:: CInt
sQLITE_NOTICE_PLAIN = #const SQLITE_NOTICE
sQLITE_NOTICE_RECOVER_WAL = #const SQLITE_NOTICE_RECOVER_WAL
sQLITE_NOTICE_RECOVER_ROLLBACK = #const SQLITE_NOTICE_RECOVER_ROLLBACK

sQLITE_WARNING_PLAIN, sQLITE_WARNING_AUTOINDEX :: CInt
sQLITE_WARNING_PLAIN = #const SQLITE_WARNING
sQLITE_WARNING_AUTOINDEX = #const SQLITE_WARNING_AUTOINDEX

sQLITE_INTEGER, sQLITE_FLOAT, sQLITE_TEXT, sQLITE_BLOB, sQLITE_NULL :: CInt
sQLITE_INTEGER = #const SQLITE_INTEGER
sQLITE_FLOAT = #const SQLITE_FLOAT
sQLITE_TEXT = #const SQLITE_TEXT
sQLITE_BLOB = #const SQLITE_BLOB
sQLITE_NULL = #const SQLITE_NULL
