`singletons-base` testsuite notes
=================================

The `singletons-base` testsuite is built using the
[`tasty`](http://hackage.haskell.org/package/tasty) testing framework. Aside
from the standard `HUnit` and `QuickCheck` tests, it contains a number of
compile-and-dump tests. These tests run GHC to compile a test file that uses
the `singletons-base` library and compare the generated Template Haskell splices
against expected output saved in a "golden" file. Below are some details about
these tests:

 * GHC uses the in-tree `singletons-base` library. This means there is no need to
   install the library in your system before running the tests. You can simply
   run the tests with:

      ```bash
      cabal test
      ```

 * Compile-and-dump tests are stored in the subdirectories of the
   `tests/compile-and-dump/` directory. Files with a `.golden` extension store
   the expected output. Running the testsuite produces files with an `.actual`
   extension which contain the actual output produced by GHC. These files are
   not deleted by the testsuite, which allows one to inspect them in case a
   test fails. To remove the `.actual` files, run:

      ```bash
      make clean-tests
      ```

 * Running the testsuite requires `diff`, as `diff` is used to compare golden
   and actual files.

 * Each compile-and-dump test requires a set of GHC options to be used for
   compilation. The testsuite defines a default set of options that enable all
   of the language extensions required by `singletons-base`. This makes writing
   tests easier since there is no need to put all the extensions into a source
   file. The default options also enable `-ddump-splices` (which dumps splices
   generated by Template Haskell), `-dsuppress-uniques` (which avoids test
   failures due to unique identifiers), `-v0` (which silences GHC's build
   output) and `-fforce-recomp` (which forces recompilation each time a
   testsuite is run). There is a convenience function (`compileAndDumpTest`)
   that creates a test with the standard GHC options defined by the testsuite.

 * Because `singletons-base` only supports one version of GHC, the `.golden` files
   should not be assumed to be portable across multiple versions of GHC. Beware
   of this should you try testing `singletons-base` against GHC HEAD.

 * You can run single tests or groups of tests whose name match a regexp using
   tasty's pattern feature. For example:

   ```bash
   cabal test --test-options="--pattern=Testsuite/Singletons/*"
   ```

   runs all tests in the `Testsuite/Singletons` branch of the test tree.
   The `SingletonsTestSuite` module defines the structure of the test tree.

 * If you modify `singletons`, `singletons-th`, or `singletons-base`, you may
   cause the actual output of some tests to change. If these changes are what
   you intended, you can accept the new output by running the following command:

   ```bash
   cabal test --test-options="--accept"
   ```
