{-# LANGUAGE OverloadedStrings #-}
{-# LANGUAGE TemplateHaskell #-}
module Main where

import Control.Applicative
import qualified Snap.Http.Server.Config as Snap
import qualified Snap.Snaplet as Snap
import qualified Snap
import qualified Snap.CORS as CORS
import qualified Snap.Util.FileServe as Snap

data App = App

initApp = Snap.makeSnaplet "app" "app" Nothing $ do
  Snap.addRoutes [ ("/foo", Snap.writeText "Foo")
                 , ("/", Snap.serveFile "example.html")
                 ]
  CORS.wrapCORS
  return App

main :: IO ()
main = Snap.serveSnaplet Snap.defaultConfig initApp
