# sqlcli

[NEWS](https://hub.darcs.net/mihaigiurgeanu/sqlcli/browse/NEWS)

A library wrapping X/Open's SQL/CLI specification for C bindings. This
project aims to become the de facto library for implementing
ODBC database access in Haskell.

The most available implementation of the SQL/CLI standard is
ODBC 3.0. You need the SQL/CLI documentation or
[ODBC Programmer's Refference](https://docs.microsoft.com/en-us/sql/odbc/reference/odbc-programmer-s-reference?view=sql-server-ver15)
in order to know how to use the functions in this package.

ODBC is a super set of the SQL/CLI specification. All calls in the
SQL/CLI are supported by the ODBC drivers. You can use this library
to connect to databases to support ODBC. The library is tested with
Oracle and Postgres ODBC drivers.

If you want to connect to ODBC, you should also use the calls and
definitios of the sqlcli-odbc package.

The `SQL.CLI` module contains all the foreign function calls, constants
and types defined by the SQL/CLI specificaition. You can this module,
but it is rather low level. A better choice would be to start working
with the calls in the `SQL.CLI.Utils` module.

`SQL.CLI.Utils` module contains wrappers to SQL/CLI function calls
that make easier to treat the error cases and deal with the SQL/CLI
diagnostic as well as other useful constructs in calling SQL/CLI API.

## Change Log

We are using the [GNU guides](https://www.gnu.org/prep/standards/html_node/Documentation.html#Documentation)
for documenting the changes in our project. You can see the summary of
changes in the [NEWS](https://hub.darcs.net/mihaigiurgeanu/sqlcli/browse/NEWS).
