# squeal-postgresql-qq

This library provides a Template Haskell quasiquoter
parsing SQL as the quoted language and producing corresponding
[`squeal-postgresql`](https://hackage.haskell.org/package/squeal-postgresql)
expressing. The goal is to provide an easier way to use the
[`squeal-postgresql`](https://hackage.haskell.org/package/squeal-postgresql)
library, by eliminating (or at least reducing) the need for the user to
learn the squeal "DSL" and allowing her to write regular SQL instead.

## Stability

I would give this package a 5 out of 10 for stability where 0 is
completely unstable and experimental and 10 is maybe like the `aeson`
package.

I think I've got a very large and usable segment of SQL supported but
of course there are unsupported features that are kind of important such
as common table expressions.

I don't foresee backwards incompatable changes being a problem because,
after all, the "interface" is mostly the SQL language, which is
stable. Most work will be about supporting new corners of SQL.

In terms of maintenance, I intend to be responsive to any bugs and to keep
up to date with the latest dependencies and GHC versions. In other words,
this is a maintained package, even if I experience a lull in adding new
supported SQL features.

## Production usage

I would feel relatively comfortable using this in production. The
risk regarding stability/maintenance is pretty low.

If you have queries that are supported, great! They'll continue to be
supported. If you have a query that is not supported, you can always
fall back to crafting squeal expressions manually. (File an issue! I'll
prioritize real-world usage.)

If you have a supported SQL statement that you find you have to
modify in a way that makes it unsupported, you can always tell GHC to
`-ddump-splices` and use the quasi-quoter generated squeal as a starting
point for your modifications.

## How to use this library.

See the haddocks.

## Most important features not currently implemented

* Prepared statement parameters
    * See the haddock documentation for how to get haskell values into
      your sql statements.
* `WITH` clauses (Common Table Expressions)
* `ON CONFLICT` clause

## Other features is not currently implemented

(Generated by an LLM. Maybe not complete.)

* `TABLESAMPLE` clause
* `ONLY` keyword for table inheritance
* `WINDOW` clause and window functions (`OVER`)
* `INTO` clause (`SELECT ... INTO ...`)
* `LIKE` with `ESCAPE`
* `IN` with a subquery
* `OPERATOR()` syntax
* Parameter indirection (e.g., `$1[i]`)
* Indirection on parenthesized expressions (e.g., `(expr)[i]`)
* Aggregate `FILTER` clause
* `WITHIN GROUP` clause
* `DISTINCT` in function arguments
* `ORDER BY` in function arguments
* Function name indirection (e.g., `schema.func`)
* `SETOF` type modifier
* `BIT` and `BIT VARYING` types
* `INTERVAL` with qualifiers
* Types with precision/scale (`TIMESTAMP`, `TIME`, `FLOAT`, `NUMERIC`, etc.)
* Qualified type names (e.g., `schema.my_type`)
* `CURRENT_TIMESTAMP` with precision
* Multidimensional arrays with explicit bounds
* `ORDER BY USING`
* `FOR READ ONLY` locking clause
* Advanced `GROUP BY` features (`GROUPING SETS`, `CUBE`, `ROLLUP`)
* Multi-row `VALUES` clause
* `OVERRIDING` clause for identity columns
* Column indirection in `INSERT` target lists
* `WHERE CURRENT OF` for cursors
* Complex relation expressions in `UPDATE` or `DELETE` targets
* Column indirection in `UPDATE SET` clauses
