## [_Unreleased_](https://github.com/freckle/stackctl/compare/v1.3.0.0...main)

## [v1.3.0.0](https://github.com/freckle/stackctl/compare/v1.2.0.1...v1.3.0.0)

- Fix it so commands like `version` don't need a valid AWS environment

  This changes the `Subcommand` interface and so is a major version update for
  the purposes of those using Stackctl as a library.

## [v1.2.0.0](https://github.com/freckle/stackctl/compare/v1.1.3.1...v1.2.0.0)

- Use more specific types in `Has{Directory,Filter,Color}Option`
- Add environment variable configuration for `STACKCTL_{DIRECTORY,FILTERS}`

## [v1.1.4.0](https://github.com/freckle/stackctl/compare/v1.1.3.1...v1.1.4.0)

- Support matching Stacks by glob in `capture`
- Add `--tag` to `changes` and `deploy`

## [v1.1.3.1](https://github.com/freckle/stackctl/compare/v1.1.3.0...v1.1.3.1)

- Fix JSON formatting bugs in generating specification

## [v1.1.3.0](https://github.com/freckle/stackctl/compare/v1.1.2.2...v1.1.3.0)

- Repository-local configuration

  See https://github.com/freckle/stackctl/commit/564678203fe70b5c4c46c655dd3daeaafb6de9e0

- Don't duplicate re-used templates in `stackctl-cat`
- Improve `--filter`

  - Match against stack name and template, in addition to spec path.
  - Automatically prepend `**/` (unless there is already a leading wildcard) and
    append `{/*,.yaml,.json}` (unless there is already a trailing wildcard or
    extension).

  In general, this aims to make `--filter` match more things more intuitively
  for operators, but still match exactly in programmatic use-cases.

- Various documentation improvements
- Support more natural `{Key}: {Value}` syntax in `Parameters` and `Tags`
- Fix bug where we may generate an `{}` element in `Parameters`

## [v1.1.2.2](https://github.com/freckle/stackctl/compare/v1.1.2.1...v1.1.2.2)

- Add support for Stack descriptions

## [v1.1.2.1](https://github.com/freckle/stackctl/compare/v1.1.2.0...v1.1.2.1)

- Build with LTS-20.4 / GHC 9.2

## [v1.1.2.0](https://github.com/freckle/stackctl/compare/v1.1.1.1...v1.1.2.0)

- Fix incorrect ordering of log-messages by setting `LOG_CONCURRENCY=1`
- Fix potential coloring of changes being redirected to a file
- Make `PATH` optional (again) in `stackctl changes`
- Add `--no-flip` to `stackctl capture`

## [v1.1.1.1](https://github.com/freckle/stackctl/compare/v1.1.1.0...v1.1.1.1)

- Trigger release

## [v1.1.1.0](https://github.com/freckle/stackctl/compare/v1.1.0.5...v1.1.1.0)

- Add `--parameter` to `changes` and `deploy`
- Sort changes by causing-before-caused

## [v1.1.0.5](https://github.com/freckle/stackctl/compare/v1.1.0.4...v1.1.0.5)

- Trigger release workflow

## [v1.1.0.4](https://github.com/freckle/stackctl/compare/v1.1.0.3...v1.1.0.4)

- Fix bug where only the last spec in a multi-spec case had its changes present
  in the output file generated by `changes`.

## [v1.1.0.3](https://github.com/freckle/stackctl/compare/v1.1.0.2...v1.1.0.3)

- Require Blammo-1.1.1.0

## [v1.1.0.2](https://github.com/freckle/stackctl/compare/v1.1.0.1...v1.1.0.2)

- Log responses from `awsLambdaInvoke` when running actions
- Clarify discovery logging
- Add install script

## [v1.1.0.1](https://github.com/freckle/stackctl/compare/v1.1.0.0...v1.1.0.1)

- Update to `cfn-flip-0.1.0.3`

## [v1.1.0.0](https://github.com/freckle/stackctl/compare/v1.0.2.0...v1.1.0.0)

- Fix interleaved or out-of-order output bugs by streaming deployment events
  through the Logger instead of directly to `stdout`
- Logging goes to `stdout` by default (`LOG_DESTINATION` can still be used)
- The `changes` subcommand now requires a `PATH` argument

## [v1.0.2.0](https://github.com/freckle/stackctl/compare/v1.0.1.2...v1.0.2.0)

- Add `Stackctl.Action`

  Support for taking actions during Stack management, currently we support
  invoking a lambda post-deployment. In the future, we can add more, such as
  running local pre-deploy validation or preparation scripts.

- Add `awsCloudFormationDescribeStackOutputs`

## [v1.0.1.2](https://github.com/freckle/stackctl/compare/v1.0.1.1...v1.0.1.2)

- Always flush log messages before our own output

## [v1.0.1.1](https://github.com/freckle/stackctl/compare/v1.0.1.0...v1.0.1.1)

- Respect `LOG_DESTINATION` (the default remains `stderr`)

## [v1.0.1.0](https://github.com/freckle/stackctl/compare/v1.0.0.2...v1.0.1.0)

- Support reading CloudGenesis specifications

  - Accept account paths like `id.name` or `name.id`
  - Read `Parameters` as `Parameter{Key,Value}` or `{Name,Value}`

  This allows us to work with specifications directories originally implemented
  for, and potentially still used with, the CloudGenesis tooling.

## [v1.0.0.2](https://github.com/freckle/stackctl/compare/v1.0.0.1...v1.0.0.2)

- Fix tailing all events to read most recent, causing Throttling errors

## [v1.0.0.1](https://github.com/freckle/stackctl/compare/v1.0.0.0...v1.0.0.1)

- Fix non-portable paths issue in OSX executable build

## [v1.0.0.0](https://github.com/freckle/stackctl/tree/v1.0.0.0)

First release
