{-# LANGUAGE OverloadedStrings #-}
{-# LANGUAGE RecordWildCards #-}
{-# LANGUAGE StrictData #-}
{-# LANGUAGE TupleSections #-}

-- | http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfigurationtype.html

module Stratosphere.ResourceProperties.CognitoUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationType where

import Stratosphere.ResourceImports
import Stratosphere.ResourceProperties.CognitoUserPoolRiskConfigurationAttachmentAccountTakeoverActionsType
import Stratosphere.ResourceProperties.CognitoUserPoolRiskConfigurationAttachmentNotifyConfigurationType

-- | Full data type definition for
-- CognitoUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationType.
-- See
-- 'cognitoUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationType'
-- for a more convenient constructor.
data CognitoUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationType =
  CognitoUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationType
  { _cognitoUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationTypeActions :: CognitoUserPoolRiskConfigurationAttachmentAccountTakeoverActionsType
  , _cognitoUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationTypeNotifyConfiguration :: Maybe CognitoUserPoolRiskConfigurationAttachmentNotifyConfigurationType
  } deriving (Show, Eq)

instance ToJSON CognitoUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationType where
  toJSON CognitoUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationType{..} =
    object $
    catMaybes
    [ (Just . ("Actions",) . toJSON) _cognitoUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationTypeActions
    , fmap (("NotifyConfiguration",) . toJSON) _cognitoUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationTypeNotifyConfiguration
    ]

-- | Constructor for
-- 'CognitoUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationType'
-- containing required fields as arguments.
cognitoUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationType
  :: CognitoUserPoolRiskConfigurationAttachmentAccountTakeoverActionsType -- ^ 'cuprcaatrctActions'
  -> CognitoUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationType
cognitoUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationType actionsarg =
  CognitoUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationType
  { _cognitoUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationTypeActions = actionsarg
  , _cognitoUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationTypeNotifyConfiguration = Nothing
  }

-- | http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfigurationtype-actions
cuprcaatrctActions :: Lens' CognitoUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationType CognitoUserPoolRiskConfigurationAttachmentAccountTakeoverActionsType
cuprcaatrctActions = lens _cognitoUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationTypeActions (\s a -> s { _cognitoUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationTypeActions = a })

-- | http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfigurationtype-notifyconfiguration
cuprcaatrctNotifyConfiguration :: Lens' CognitoUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationType (Maybe CognitoUserPoolRiskConfigurationAttachmentNotifyConfigurationType)
cuprcaatrctNotifyConfiguration = lens _cognitoUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationTypeNotifyConfiguration (\s a -> s { _cognitoUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationTypeNotifyConfiguration = a })
