{-# LANGUAGE CPP #-}
{-# LANGUAGE DeriveGeneric #-}
{-# LANGUAGE ExistentialQuantification #-}
{-# LANGUAGE FlexibleInstances #-}
{-# LANGUAGE FunctionalDependencies #-}
{-# LANGUAGE GeneralizedNewtypeDeriving #-}
{-# LANGUAGE MultiParamTypeClasses #-}
{-# LANGUAGE OverloadedStrings #-}
{-# LANGUAGE StrictData #-}
{-# LANGUAGE TemplateHaskell #-}
{-# LANGUAGE TypeFamilies #-}

-- | See:
-- http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resources-section-structure.html
--
-- The required Resources section declare the AWS resources that you want as
-- part of your stack, such as an Amazon EC2 instance or an Amazon S3 bucket.
-- You must declare each resource separately; however, you can specify multiple
-- resources of the same type. If you declare multiple resources, separate them
-- with commas.

module Stratosphere.Resources
  ( module X
  , Resource (..)
  , resource
  , resourceName
  , resourceProperties
  , resourceDeletionPolicy
  , resourceCreationPolicy
  , resourceUpdatePolicy
  , resourceDependsOn
  , resourceMetadata
  , resourceCondition
  , ResourceProperties (..)
  , DeletionPolicy (..)
  , Resources (..)
  ) where

import Control.Lens hiding ((.=))
import Data.Aeson
import Data.Maybe (catMaybes)
import Data.Semigroup (Semigroup)
import qualified Data.Text as T
import GHC.Exts (IsList(..))
import GHC.Generics (Generic)

import Stratosphere.Resources.AmazonMQBroker as X
import Stratosphere.Resources.AmazonMQConfiguration as X
import Stratosphere.Resources.AmazonMQConfigurationAssociation as X
import Stratosphere.Resources.AmplifyApp as X
import Stratosphere.Resources.AmplifyBranch as X
import Stratosphere.Resources.AmplifyDomain as X
import Stratosphere.Resources.ApiGatewayAccount as X
import Stratosphere.Resources.ApiGatewayApiKey as X
import Stratosphere.Resources.ApiGatewayAuthorizer as X
import Stratosphere.Resources.ApiGatewayBasePathMapping as X
import Stratosphere.Resources.ApiGatewayClientCertificate as X
import Stratosphere.Resources.ApiGatewayDeployment as X
import Stratosphere.Resources.ApiGatewayDocumentationPart as X
import Stratosphere.Resources.ApiGatewayDocumentationVersion as X
import Stratosphere.Resources.ApiGatewayDomainName as X
import Stratosphere.Resources.ApiGatewayGatewayResponse as X
import Stratosphere.Resources.ApiGatewayMethod as X
import Stratosphere.Resources.ApiGatewayModel as X
import Stratosphere.Resources.ApiGatewayRequestValidator as X
import Stratosphere.Resources.ApiGatewayResource as X
import Stratosphere.Resources.ApiGatewayRestApi as X
import Stratosphere.Resources.ApiGatewayStage as X
import Stratosphere.Resources.ApiGatewayUsagePlan as X
import Stratosphere.Resources.ApiGatewayUsagePlanKey as X
import Stratosphere.Resources.ApiGatewayVpcLink as X
import Stratosphere.Resources.ApiGatewayV2Api as X
import Stratosphere.Resources.ApiGatewayV2ApiMapping as X
import Stratosphere.Resources.ApiGatewayV2Authorizer as X
import Stratosphere.Resources.ApiGatewayV2Deployment as X
import Stratosphere.Resources.ApiGatewayV2DomainName as X
import Stratosphere.Resources.ApiGatewayV2Integration as X
import Stratosphere.Resources.ApiGatewayV2IntegrationResponse as X
import Stratosphere.Resources.ApiGatewayV2Model as X
import Stratosphere.Resources.ApiGatewayV2Route as X
import Stratosphere.Resources.ApiGatewayV2RouteResponse as X
import Stratosphere.Resources.ApiGatewayV2Stage as X
import Stratosphere.Resources.AppMeshMesh as X
import Stratosphere.Resources.AppMeshRoute as X
import Stratosphere.Resources.AppMeshVirtualNode as X
import Stratosphere.Resources.AppMeshVirtualRouter as X
import Stratosphere.Resources.AppMeshVirtualService as X
import Stratosphere.Resources.AppStreamDirectoryConfig as X
import Stratosphere.Resources.AppStreamFleet as X
import Stratosphere.Resources.AppStreamImageBuilder as X
import Stratosphere.Resources.AppStreamStack as X
import Stratosphere.Resources.AppStreamStackFleetAssociation as X
import Stratosphere.Resources.AppStreamStackUserAssociation as X
import Stratosphere.Resources.AppStreamUser as X
import Stratosphere.Resources.AppSyncApiKey as X
import Stratosphere.Resources.AppSyncDataSource as X
import Stratosphere.Resources.AppSyncFunctionConfiguration as X
import Stratosphere.Resources.AppSyncGraphQLApi as X
import Stratosphere.Resources.AppSyncGraphQLSchema as X
import Stratosphere.Resources.AppSyncResolver as X
import Stratosphere.Resources.ApplicationAutoScalingScalableTarget as X
import Stratosphere.Resources.ApplicationAutoScalingScalingPolicy as X
import Stratosphere.Resources.AthenaNamedQuery as X
import Stratosphere.Resources.AutoScalingAutoScalingGroup as X
import Stratosphere.Resources.AutoScalingLaunchConfiguration as X
import Stratosphere.Resources.AutoScalingLifecycleHook as X
import Stratosphere.Resources.AutoScalingScalingPolicy as X
import Stratosphere.Resources.AutoScalingScheduledAction as X
import Stratosphere.Resources.AutoScalingPlansScalingPlan as X
import Stratosphere.Resources.BackupBackupPlan as X
import Stratosphere.Resources.BackupBackupSelection as X
import Stratosphere.Resources.BackupBackupVault as X
import Stratosphere.Resources.BatchComputeEnvironment as X
import Stratosphere.Resources.BatchJobDefinition as X
import Stratosphere.Resources.BatchJobQueue as X
import Stratosphere.Resources.BudgetsBudget as X
import Stratosphere.Resources.CertificateManagerCertificate as X
import Stratosphere.Resources.Cloud9EnvironmentEC2 as X
import Stratosphere.Resources.CloudFormationCustomResource as X
import Stratosphere.Resources.CloudFormationMacro as X
import Stratosphere.Resources.CloudFormationStack as X
import Stratosphere.Resources.CloudFormationWaitCondition as X
import Stratosphere.Resources.CloudFormationWaitConditionHandle as X
import Stratosphere.Resources.CloudFrontCloudFrontOriginAccessIdentity as X
import Stratosphere.Resources.CloudFrontDistribution as X
import Stratosphere.Resources.CloudFrontStreamingDistribution as X
import Stratosphere.Resources.CloudTrailTrail as X
import Stratosphere.Resources.CloudWatchAlarm as X
import Stratosphere.Resources.CloudWatchAnomalyDetector as X
import Stratosphere.Resources.CloudWatchDashboard as X
import Stratosphere.Resources.CodeBuildProject as X
import Stratosphere.Resources.CodeBuildSourceCredential as X
import Stratosphere.Resources.CodeCommitRepository as X
import Stratosphere.Resources.CodeDeployApplication as X
import Stratosphere.Resources.CodeDeployDeploymentConfig as X
import Stratosphere.Resources.CodeDeployDeploymentGroup as X
import Stratosphere.Resources.CodePipelineCustomActionType as X
import Stratosphere.Resources.CodePipelinePipeline as X
import Stratosphere.Resources.CodePipelineWebhook as X
import Stratosphere.Resources.CodeStarGitHubRepository as X
import Stratosphere.Resources.CognitoIdentityPool as X
import Stratosphere.Resources.CognitoIdentityPoolRoleAttachment as X
import Stratosphere.Resources.CognitoUserPool as X
import Stratosphere.Resources.CognitoUserPoolClient as X
import Stratosphere.Resources.CognitoUserPoolDomain as X
import Stratosphere.Resources.CognitoUserPoolGroup as X
import Stratosphere.Resources.CognitoUserPoolIdentityProvider as X
import Stratosphere.Resources.CognitoUserPoolResourceServer as X
import Stratosphere.Resources.CognitoUserPoolRiskConfigurationAttachment as X
import Stratosphere.Resources.CognitoUserPoolUICustomizationAttachment as X
import Stratosphere.Resources.CognitoUserPoolUser as X
import Stratosphere.Resources.CognitoUserPoolUserToGroupAttachment as X
import Stratosphere.Resources.ConfigAggregationAuthorization as X
import Stratosphere.Resources.ConfigConfigRule as X
import Stratosphere.Resources.ConfigConfigurationAggregator as X
import Stratosphere.Resources.ConfigConfigurationRecorder as X
import Stratosphere.Resources.ConfigDeliveryChannel as X
import Stratosphere.Resources.ConfigOrganizationConfigRule as X
import Stratosphere.Resources.ConfigRemediationConfiguration as X
import Stratosphere.Resources.DAXCluster as X
import Stratosphere.Resources.DAXParameterGroup as X
import Stratosphere.Resources.DAXSubnetGroup as X
import Stratosphere.Resources.DLMLifecyclePolicy as X
import Stratosphere.Resources.DMSCertificate as X
import Stratosphere.Resources.DMSEndpoint as X
import Stratosphere.Resources.DMSEventSubscription as X
import Stratosphere.Resources.DMSReplicationInstance as X
import Stratosphere.Resources.DMSReplicationSubnetGroup as X
import Stratosphere.Resources.DMSReplicationTask as X
import Stratosphere.Resources.DataPipelinePipeline as X
import Stratosphere.Resources.DirectoryServiceMicrosoftAD as X
import Stratosphere.Resources.DirectoryServiceSimpleAD as X
import Stratosphere.Resources.DocDBDBCluster as X
import Stratosphere.Resources.DocDBDBClusterParameterGroup as X
import Stratosphere.Resources.DocDBDBInstance as X
import Stratosphere.Resources.DocDBDBSubnetGroup as X
import Stratosphere.Resources.DynamoDBTable as X
import Stratosphere.Resources.EC2CapacityReservation as X
import Stratosphere.Resources.EC2ClientVpnAuthorizationRule as X
import Stratosphere.Resources.EC2ClientVpnEndpoint as X
import Stratosphere.Resources.EC2ClientVpnRoute as X
import Stratosphere.Resources.EC2ClientVpnTargetNetworkAssociation as X
import Stratosphere.Resources.EC2CustomerGateway as X
import Stratosphere.Resources.EC2DHCPOptions as X
import Stratosphere.Resources.EC2EC2Fleet as X
import Stratosphere.Resources.EC2EIP as X
import Stratosphere.Resources.EC2EIPAssociation as X
import Stratosphere.Resources.EC2EgressOnlyInternetGateway as X
import Stratosphere.Resources.EC2FlowLog as X
import Stratosphere.Resources.EC2Host as X
import Stratosphere.Resources.EC2Instance as X
import Stratosphere.Resources.EC2InternetGateway as X
import Stratosphere.Resources.EC2LaunchTemplate as X
import Stratosphere.Resources.EC2NatGateway as X
import Stratosphere.Resources.EC2NetworkAcl as X
import Stratosphere.Resources.EC2NetworkAclEntry as X
import Stratosphere.Resources.EC2NetworkInterface as X
import Stratosphere.Resources.EC2NetworkInterfaceAttachment as X
import Stratosphere.Resources.EC2NetworkInterfacePermission as X
import Stratosphere.Resources.EC2PlacementGroup as X
import Stratosphere.Resources.EC2Route as X
import Stratosphere.Resources.EC2RouteTable as X
import Stratosphere.Resources.EC2SecurityGroup as X
import Stratosphere.Resources.EC2SecurityGroupEgress as X
import Stratosphere.Resources.EC2SecurityGroupIngress as X
import Stratosphere.Resources.EC2SpotFleet as X
import Stratosphere.Resources.EC2Subnet as X
import Stratosphere.Resources.EC2SubnetCidrBlock as X
import Stratosphere.Resources.EC2SubnetNetworkAclAssociation as X
import Stratosphere.Resources.EC2SubnetRouteTableAssociation as X
import Stratosphere.Resources.EC2TrafficMirrorFilter as X
import Stratosphere.Resources.EC2TrafficMirrorFilterRule as X
import Stratosphere.Resources.EC2TrafficMirrorSession as X
import Stratosphere.Resources.EC2TrafficMirrorTarget as X
import Stratosphere.Resources.EC2TransitGateway as X
import Stratosphere.Resources.EC2TransitGatewayAttachment as X
import Stratosphere.Resources.EC2TransitGatewayRoute as X
import Stratosphere.Resources.EC2TransitGatewayRouteTable as X
import Stratosphere.Resources.EC2TransitGatewayRouteTableAssociation as X
import Stratosphere.Resources.EC2TransitGatewayRouteTablePropagation as X
import Stratosphere.Resources.EC2VPC as X
import Stratosphere.Resources.EC2VPCCidrBlock as X
import Stratosphere.Resources.EC2VPCDHCPOptionsAssociation as X
import Stratosphere.Resources.EC2VPCEndpoint as X
import Stratosphere.Resources.EC2VPCEndpointConnectionNotification as X
import Stratosphere.Resources.EC2VPCEndpointService as X
import Stratosphere.Resources.EC2VPCEndpointServicePermissions as X
import Stratosphere.Resources.EC2VPCGatewayAttachment as X
import Stratosphere.Resources.EC2VPCPeeringConnection as X
import Stratosphere.Resources.EC2VPNConnection as X
import Stratosphere.Resources.EC2VPNConnectionRoute as X
import Stratosphere.Resources.EC2VPNGateway as X
import Stratosphere.Resources.EC2VPNGatewayRoutePropagation as X
import Stratosphere.Resources.EC2Volume as X
import Stratosphere.Resources.EC2VolumeAttachment as X
import Stratosphere.Resources.ECRRepository as X
import Stratosphere.Resources.ECSCluster as X
import Stratosphere.Resources.ECSService as X
import Stratosphere.Resources.ECSTaskDefinition as X
import Stratosphere.Resources.EFSFileSystem as X
import Stratosphere.Resources.EFSMountTarget as X
import Stratosphere.Resources.EKSCluster as X
import Stratosphere.Resources.EMRCluster as X
import Stratosphere.Resources.EMRInstanceFleetConfig as X
import Stratosphere.Resources.EMRInstanceGroupConfig as X
import Stratosphere.Resources.EMRSecurityConfiguration as X
import Stratosphere.Resources.EMRStep as X
import Stratosphere.Resources.ElastiCacheCacheCluster as X
import Stratosphere.Resources.ElastiCacheParameterGroup as X
import Stratosphere.Resources.ElastiCacheReplicationGroup as X
import Stratosphere.Resources.ElastiCacheSecurityGroup as X
import Stratosphere.Resources.ElastiCacheSecurityGroupIngress as X
import Stratosphere.Resources.ElastiCacheSubnetGroup as X
import Stratosphere.Resources.ElasticBeanstalkApplication as X
import Stratosphere.Resources.ElasticBeanstalkApplicationVersion as X
import Stratosphere.Resources.ElasticBeanstalkConfigurationTemplate as X
import Stratosphere.Resources.ElasticBeanstalkEnvironment as X
import Stratosphere.Resources.ElasticLoadBalancingLoadBalancer as X
import Stratosphere.Resources.ElasticLoadBalancingV2Listener as X
import Stratosphere.Resources.ElasticLoadBalancingV2ListenerCertificateResource as X
import Stratosphere.Resources.ElasticLoadBalancingV2ListenerRule as X
import Stratosphere.Resources.ElasticLoadBalancingV2LoadBalancer as X
import Stratosphere.Resources.ElasticLoadBalancingV2TargetGroup as X
import Stratosphere.Resources.ElasticsearchDomain as X
import Stratosphere.Resources.EventsEventBus as X
import Stratosphere.Resources.EventsEventBusPolicy as X
import Stratosphere.Resources.EventsRule as X
import Stratosphere.Resources.FSxFileSystem as X
import Stratosphere.Resources.GameLiftAlias as X
import Stratosphere.Resources.GameLiftBuild as X
import Stratosphere.Resources.GameLiftFleet as X
import Stratosphere.Resources.GlueClassifier as X
import Stratosphere.Resources.GlueConnection as X
import Stratosphere.Resources.GlueCrawler as X
import Stratosphere.Resources.GlueDataCatalogEncryptionSettings as X
import Stratosphere.Resources.GlueDatabase as X
import Stratosphere.Resources.GlueDevEndpoint as X
import Stratosphere.Resources.GlueJob as X
import Stratosphere.Resources.GlueMLTransform as X
import Stratosphere.Resources.GluePartition as X
import Stratosphere.Resources.GlueSecurityConfiguration as X
import Stratosphere.Resources.GlueTable as X
import Stratosphere.Resources.GlueTrigger as X
import Stratosphere.Resources.GlueWorkflow as X
import Stratosphere.Resources.GreengrassConnectorDefinition as X
import Stratosphere.Resources.GreengrassConnectorDefinitionVersion as X
import Stratosphere.Resources.GreengrassCoreDefinition as X
import Stratosphere.Resources.GreengrassCoreDefinitionVersion as X
import Stratosphere.Resources.GreengrassDeviceDefinition as X
import Stratosphere.Resources.GreengrassDeviceDefinitionVersion as X
import Stratosphere.Resources.GreengrassFunctionDefinition as X
import Stratosphere.Resources.GreengrassFunctionDefinitionVersion as X
import Stratosphere.Resources.GreengrassGroup as X
import Stratosphere.Resources.GreengrassGroupVersion as X
import Stratosphere.Resources.GreengrassLoggerDefinition as X
import Stratosphere.Resources.GreengrassLoggerDefinitionVersion as X
import Stratosphere.Resources.GreengrassResourceDefinition as X
import Stratosphere.Resources.GreengrassResourceDefinitionVersion as X
import Stratosphere.Resources.GreengrassSubscriptionDefinition as X
import Stratosphere.Resources.GreengrassSubscriptionDefinitionVersion as X
import Stratosphere.Resources.GuardDutyDetector as X
import Stratosphere.Resources.GuardDutyFilter as X
import Stratosphere.Resources.GuardDutyIPSet as X
import Stratosphere.Resources.GuardDutyMaster as X
import Stratosphere.Resources.GuardDutyMember as X
import Stratosphere.Resources.GuardDutyThreatIntelSet as X
import Stratosphere.Resources.IAMAccessKey as X
import Stratosphere.Resources.IAMGroup as X
import Stratosphere.Resources.IAMInstanceProfile as X
import Stratosphere.Resources.IAMManagedPolicy as X
import Stratosphere.Resources.IAMPolicy as X
import Stratosphere.Resources.IAMRole as X
import Stratosphere.Resources.IAMServiceLinkedRole as X
import Stratosphere.Resources.IAMUser as X
import Stratosphere.Resources.IAMUserToGroupAddition as X
import Stratosphere.Resources.InspectorAssessmentTarget as X
import Stratosphere.Resources.InspectorAssessmentTemplate as X
import Stratosphere.Resources.InspectorResourceGroup as X
import Stratosphere.Resources.IoT1ClickDevice as X
import Stratosphere.Resources.IoT1ClickPlacement as X
import Stratosphere.Resources.IoT1ClickProject as X
import Stratosphere.Resources.IoTCertificate as X
import Stratosphere.Resources.IoTPolicy as X
import Stratosphere.Resources.IoTPolicyPrincipalAttachment as X
import Stratosphere.Resources.IoTThing as X
import Stratosphere.Resources.IoTThingPrincipalAttachment as X
import Stratosphere.Resources.IoTTopicRule as X
import Stratosphere.Resources.IoTAnalyticsChannel as X
import Stratosphere.Resources.IoTAnalyticsDataset as X
import Stratosphere.Resources.IoTAnalyticsDatastore as X
import Stratosphere.Resources.IoTAnalyticsPipeline as X
import Stratosphere.Resources.IoTEventsDetectorModel as X
import Stratosphere.Resources.IoTEventsInput as X
import Stratosphere.Resources.IoTThingsGraphFlowTemplate as X
import Stratosphere.Resources.KMSAlias as X
import Stratosphere.Resources.KMSKey as X
import Stratosphere.Resources.KinesisStream as X
import Stratosphere.Resources.KinesisStreamConsumer as X
import Stratosphere.Resources.KinesisAnalyticsApplication as X
import Stratosphere.Resources.KinesisAnalyticsApplicationOutput as X
import Stratosphere.Resources.KinesisAnalyticsApplicationReferenceDataSource as X
import Stratosphere.Resources.KinesisAnalyticsV2Application as X
import Stratosphere.Resources.KinesisAnalyticsV2ApplicationCloudWatchLoggingOption as X
import Stratosphere.Resources.KinesisAnalyticsV2ApplicationOutput as X
import Stratosphere.Resources.KinesisAnalyticsV2ApplicationReferenceDataSource as X
import Stratosphere.Resources.KinesisFirehoseDeliveryStream as X
import Stratosphere.Resources.LakeFormationDataLakeSettings as X
import Stratosphere.Resources.LakeFormationPermissions as X
import Stratosphere.Resources.LakeFormationResource as X
import Stratosphere.Resources.LambdaAlias as X
import Stratosphere.Resources.LambdaEventSourceMapping as X
import Stratosphere.Resources.LambdaFunction as X
import Stratosphere.Resources.LambdaLayerVersion as X
import Stratosphere.Resources.LambdaLayerVersionPermission as X
import Stratosphere.Resources.LambdaPermission as X
import Stratosphere.Resources.LambdaVersion as X
import Stratosphere.Resources.LogsDestination as X
import Stratosphere.Resources.LogsLogGroup as X
import Stratosphere.Resources.LogsLogStream as X
import Stratosphere.Resources.LogsMetricFilter as X
import Stratosphere.Resources.LogsSubscriptionFilter as X
import Stratosphere.Resources.MSKCluster as X
import Stratosphere.Resources.ManagedBlockchainMember as X
import Stratosphere.Resources.ManagedBlockchainNode as X
import Stratosphere.Resources.MediaLiveChannel as X
import Stratosphere.Resources.MediaLiveInput as X
import Stratosphere.Resources.MediaLiveInputSecurityGroup as X
import Stratosphere.Resources.MediaStoreContainer as X
import Stratosphere.Resources.NeptuneDBCluster as X
import Stratosphere.Resources.NeptuneDBClusterParameterGroup as X
import Stratosphere.Resources.NeptuneDBInstance as X
import Stratosphere.Resources.NeptuneDBParameterGroup as X
import Stratosphere.Resources.NeptuneDBSubnetGroup as X
import Stratosphere.Resources.OpsWorksApp as X
import Stratosphere.Resources.OpsWorksElasticLoadBalancerAttachment as X
import Stratosphere.Resources.OpsWorksInstance as X
import Stratosphere.Resources.OpsWorksLayer as X
import Stratosphere.Resources.OpsWorksStack as X
import Stratosphere.Resources.OpsWorksUserProfile as X
import Stratosphere.Resources.OpsWorksVolume as X
import Stratosphere.Resources.OpsWorksCMServer as X
import Stratosphere.Resources.PinpointADMChannel as X
import Stratosphere.Resources.PinpointAPNSChannel as X
import Stratosphere.Resources.PinpointAPNSSandboxChannel as X
import Stratosphere.Resources.PinpointAPNSVoipChannel as X
import Stratosphere.Resources.PinpointAPNSVoipSandboxChannel as X
import Stratosphere.Resources.PinpointApp as X
import Stratosphere.Resources.PinpointApplicationSettings as X
import Stratosphere.Resources.PinpointBaiduChannel as X
import Stratosphere.Resources.PinpointCampaign as X
import Stratosphere.Resources.PinpointEmailChannel as X
import Stratosphere.Resources.PinpointEventStream as X
import Stratosphere.Resources.PinpointGCMChannel as X
import Stratosphere.Resources.PinpointSMSChannel as X
import Stratosphere.Resources.PinpointSegment as X
import Stratosphere.Resources.PinpointVoiceChannel as X
import Stratosphere.Resources.PinpointEmailConfigurationSet as X
import Stratosphere.Resources.PinpointEmailConfigurationSetEventDestination as X
import Stratosphere.Resources.PinpointEmailDedicatedIpPool as X
import Stratosphere.Resources.PinpointEmailIdentity as X
import Stratosphere.Resources.QLDBLedger as X
import Stratosphere.Resources.RAMResourceShare as X
import Stratosphere.Resources.RDSDBCluster as X
import Stratosphere.Resources.RDSDBClusterParameterGroup as X
import Stratosphere.Resources.RDSDBInstance as X
import Stratosphere.Resources.RDSDBParameterGroup as X
import Stratosphere.Resources.RDSDBSecurityGroup as X
import Stratosphere.Resources.RDSDBSecurityGroupIngress as X
import Stratosphere.Resources.RDSDBSubnetGroup as X
import Stratosphere.Resources.RDSEventSubscription as X
import Stratosphere.Resources.RDSOptionGroup as X
import Stratosphere.Resources.RedshiftCluster as X
import Stratosphere.Resources.RedshiftClusterParameterGroup as X
import Stratosphere.Resources.RedshiftClusterSecurityGroup as X
import Stratosphere.Resources.RedshiftClusterSecurityGroupIngress as X
import Stratosphere.Resources.RedshiftClusterSubnetGroup as X
import Stratosphere.Resources.RoboMakerFleet as X
import Stratosphere.Resources.RoboMakerRobot as X
import Stratosphere.Resources.RoboMakerRobotApplication as X
import Stratosphere.Resources.RoboMakerRobotApplicationVersion as X
import Stratosphere.Resources.RoboMakerSimulationApplication as X
import Stratosphere.Resources.RoboMakerSimulationApplicationVersion as X
import Stratosphere.Resources.Route53HealthCheck as X
import Stratosphere.Resources.Route53HostedZone as X
import Stratosphere.Resources.Route53RecordSet as X
import Stratosphere.Resources.Route53RecordSetGroup as X
import Stratosphere.Resources.Route53ResolverResolverEndpoint as X
import Stratosphere.Resources.Route53ResolverResolverRule as X
import Stratosphere.Resources.Route53ResolverResolverRuleAssociation as X
import Stratosphere.Resources.S3Bucket as X
import Stratosphere.Resources.S3BucketPolicy as X
import Stratosphere.Resources.SDBDomain as X
import Stratosphere.Resources.SESConfigurationSet as X
import Stratosphere.Resources.SESConfigurationSetEventDestination as X
import Stratosphere.Resources.SESReceiptFilter as X
import Stratosphere.Resources.SESReceiptRule as X
import Stratosphere.Resources.SESReceiptRuleSet as X
import Stratosphere.Resources.SESTemplate as X
import Stratosphere.Resources.SNSSubscription as X
import Stratosphere.Resources.SNSTopic as X
import Stratosphere.Resources.SNSTopicPolicy as X
import Stratosphere.Resources.SQSQueue as X
import Stratosphere.Resources.SQSQueuePolicy as X
import Stratosphere.Resources.SSMAssociation as X
import Stratosphere.Resources.SSMDocument as X
import Stratosphere.Resources.SSMMaintenanceWindow as X
import Stratosphere.Resources.SSMMaintenanceWindowTarget as X
import Stratosphere.Resources.SSMMaintenanceWindowTask as X
import Stratosphere.Resources.SSMParameter as X
import Stratosphere.Resources.SSMPatchBaseline as X
import Stratosphere.Resources.SSMResourceDataSync as X
import Stratosphere.Resources.SageMakerCodeRepository as X
import Stratosphere.Resources.SageMakerEndpoint as X
import Stratosphere.Resources.SageMakerEndpointConfig as X
import Stratosphere.Resources.SageMakerModel as X
import Stratosphere.Resources.SageMakerNotebookInstance as X
import Stratosphere.Resources.SageMakerNotebookInstanceLifecycleConfig as X
import Stratosphere.Resources.SageMakerWorkteam as X
import Stratosphere.Resources.SecretsManagerResourcePolicy as X
import Stratosphere.Resources.SecretsManagerRotationSchedule as X
import Stratosphere.Resources.SecretsManagerSecret as X
import Stratosphere.Resources.SecretsManagerSecretTargetAttachment as X
import Stratosphere.Resources.SecurityHubHub as X
import Stratosphere.Resources.ServiceCatalogAcceptedPortfolioShare as X
import Stratosphere.Resources.ServiceCatalogCloudFormationProduct as X
import Stratosphere.Resources.ServiceCatalogCloudFormationProvisionedProduct as X
import Stratosphere.Resources.ServiceCatalogLaunchNotificationConstraint as X
import Stratosphere.Resources.ServiceCatalogLaunchRoleConstraint as X
import Stratosphere.Resources.ServiceCatalogLaunchTemplateConstraint as X
import Stratosphere.Resources.ServiceCatalogPortfolio as X
import Stratosphere.Resources.ServiceCatalogPortfolioPrincipalAssociation as X
import Stratosphere.Resources.ServiceCatalogPortfolioProductAssociation as X
import Stratosphere.Resources.ServiceCatalogPortfolioShare as X
import Stratosphere.Resources.ServiceCatalogResourceUpdateConstraint as X
import Stratosphere.Resources.ServiceCatalogStackSetConstraint as X
import Stratosphere.Resources.ServiceCatalogTagOption as X
import Stratosphere.Resources.ServiceCatalogTagOptionAssociation as X
import Stratosphere.Resources.ServiceDiscoveryHttpNamespace as X
import Stratosphere.Resources.ServiceDiscoveryInstance as X
import Stratosphere.Resources.ServiceDiscoveryPrivateDnsNamespace as X
import Stratosphere.Resources.ServiceDiscoveryPublicDnsNamespace as X
import Stratosphere.Resources.ServiceDiscoveryService as X
import Stratosphere.Resources.StepFunctionsActivity as X
import Stratosphere.Resources.StepFunctionsStateMachine as X
import Stratosphere.Resources.TransferServer as X
import Stratosphere.Resources.TransferUser as X
import Stratosphere.Resources.WAFByteMatchSet as X
import Stratosphere.Resources.WAFIPSet as X
import Stratosphere.Resources.WAFRule as X
import Stratosphere.Resources.WAFSizeConstraintSet as X
import Stratosphere.Resources.WAFSqlInjectionMatchSet as X
import Stratosphere.Resources.WAFWebACL as X
import Stratosphere.Resources.WAFXssMatchSet as X
import Stratosphere.Resources.WAFRegionalByteMatchSet as X
import Stratosphere.Resources.WAFRegionalGeoMatchSet as X
import Stratosphere.Resources.WAFRegionalIPSet as X
import Stratosphere.Resources.WAFRegionalRateBasedRule as X
import Stratosphere.Resources.WAFRegionalRegexPatternSet as X
import Stratosphere.Resources.WAFRegionalRule as X
import Stratosphere.Resources.WAFRegionalSizeConstraintSet as X
import Stratosphere.Resources.WAFRegionalSqlInjectionMatchSet as X
import Stratosphere.Resources.WAFRegionalWebACL as X
import Stratosphere.Resources.WAFRegionalWebACLAssociation as X
import Stratosphere.Resources.WAFRegionalXssMatchSet as X
import Stratosphere.Resources.WorkSpacesWorkspace as X
import Stratosphere.Resources.ASKSkill as X
import Stratosphere.ResourceProperties.AmazonMQBrokerConfigurationId as X
import Stratosphere.ResourceProperties.AmazonMQBrokerEncryptionOptions as X
import Stratosphere.ResourceProperties.AmazonMQBrokerLogList as X
import Stratosphere.ResourceProperties.AmazonMQBrokerMaintenanceWindow as X
import Stratosphere.ResourceProperties.AmazonMQBrokerTagsEntry as X
import Stratosphere.ResourceProperties.AmazonMQBrokerUser as X
import Stratosphere.ResourceProperties.AmazonMQConfigurationTagsEntry as X
import Stratosphere.ResourceProperties.AmazonMQConfigurationAssociationConfigurationId as X
import Stratosphere.ResourceProperties.AmplifyAppAutoBranchCreationConfig as X
import Stratosphere.ResourceProperties.AmplifyAppBasicAuthConfig as X
import Stratosphere.ResourceProperties.AmplifyAppCustomRule as X
import Stratosphere.ResourceProperties.AmplifyAppEnvironmentVariable as X
import Stratosphere.ResourceProperties.AmplifyBranchBasicAuthConfig as X
import Stratosphere.ResourceProperties.AmplifyBranchEnvironmentVariable as X
import Stratosphere.ResourceProperties.AmplifyDomainSubDomainSetting as X
import Stratosphere.ResourceProperties.ApiGatewayApiKeyStageKey as X
import Stratosphere.ResourceProperties.ApiGatewayDeploymentAccessLogSetting as X
import Stratosphere.ResourceProperties.ApiGatewayDeploymentCanarySetting as X
import Stratosphere.ResourceProperties.ApiGatewayDeploymentDeploymentCanarySettings as X
import Stratosphere.ResourceProperties.ApiGatewayDeploymentMethodSetting as X
import Stratosphere.ResourceProperties.ApiGatewayDeploymentStageDescription as X
import Stratosphere.ResourceProperties.ApiGatewayDocumentationPartLocation as X
import Stratosphere.ResourceProperties.ApiGatewayDomainNameEndpointConfiguration as X
import Stratosphere.ResourceProperties.ApiGatewayMethodIntegration as X
import Stratosphere.ResourceProperties.ApiGatewayMethodIntegrationResponse as X
import Stratosphere.ResourceProperties.ApiGatewayMethodMethodResponse as X
import Stratosphere.ResourceProperties.ApiGatewayRestApiEndpointConfiguration as X
import Stratosphere.ResourceProperties.ApiGatewayRestApiS3Location as X
import Stratosphere.ResourceProperties.ApiGatewayStageAccessLogSetting as X
import Stratosphere.ResourceProperties.ApiGatewayStageCanarySetting as X
import Stratosphere.ResourceProperties.ApiGatewayStageMethodSetting as X
import Stratosphere.ResourceProperties.ApiGatewayUsagePlanApiStage as X
import Stratosphere.ResourceProperties.ApiGatewayUsagePlanQuotaSettings as X
import Stratosphere.ResourceProperties.ApiGatewayUsagePlanThrottleSettings as X
import Stratosphere.ResourceProperties.ApiGatewayV2DomainNameDomainNameConfiguration as X
import Stratosphere.ResourceProperties.ApiGatewayV2RouteParameterConstraints as X
import Stratosphere.ResourceProperties.ApiGatewayV2RouteResponseParameterConstraints as X
import Stratosphere.ResourceProperties.ApiGatewayV2StageAccessLogSettings as X
import Stratosphere.ResourceProperties.ApiGatewayV2StageRouteSettings as X
import Stratosphere.ResourceProperties.AppMeshMeshEgressFilter as X
import Stratosphere.ResourceProperties.AppMeshMeshMeshSpec as X
import Stratosphere.ResourceProperties.AppMeshRouteDuration as X
import Stratosphere.ResourceProperties.AppMeshRouteHeaderMatchMethod as X
import Stratosphere.ResourceProperties.AppMeshRouteHttpRetryPolicy as X
import Stratosphere.ResourceProperties.AppMeshRouteHttpRoute as X
import Stratosphere.ResourceProperties.AppMeshRouteHttpRouteAction as X
import Stratosphere.ResourceProperties.AppMeshRouteHttpRouteHeader as X
import Stratosphere.ResourceProperties.AppMeshRouteHttpRouteMatch as X
import Stratosphere.ResourceProperties.AppMeshRouteMatchRange as X
import Stratosphere.ResourceProperties.AppMeshRouteRouteSpec as X
import Stratosphere.ResourceProperties.AppMeshRouteTcpRoute as X
import Stratosphere.ResourceProperties.AppMeshRouteTcpRouteAction as X
import Stratosphere.ResourceProperties.AppMeshRouteWeightedTarget as X
import Stratosphere.ResourceProperties.AppMeshVirtualNodeAccessLog as X
import Stratosphere.ResourceProperties.AppMeshVirtualNodeAwsCloudMapInstanceAttribute as X
import Stratosphere.ResourceProperties.AppMeshVirtualNodeAwsCloudMapServiceDiscovery as X
import Stratosphere.ResourceProperties.AppMeshVirtualNodeBackend as X
import Stratosphere.ResourceProperties.AppMeshVirtualNodeDnsServiceDiscovery as X
import Stratosphere.ResourceProperties.AppMeshVirtualNodeFileAccessLog as X
import Stratosphere.ResourceProperties.AppMeshVirtualNodeHealthCheck as X
import Stratosphere.ResourceProperties.AppMeshVirtualNodeListener as X
import Stratosphere.ResourceProperties.AppMeshVirtualNodeLogging as X
import Stratosphere.ResourceProperties.AppMeshVirtualNodePortMapping as X
import Stratosphere.ResourceProperties.AppMeshVirtualNodeServiceDiscovery as X
import Stratosphere.ResourceProperties.AppMeshVirtualNodeVirtualNodeSpec as X
import Stratosphere.ResourceProperties.AppMeshVirtualNodeVirtualServiceBackend as X
import Stratosphere.ResourceProperties.AppMeshVirtualRouterPortMapping as X
import Stratosphere.ResourceProperties.AppMeshVirtualRouterVirtualRouterListener as X
import Stratosphere.ResourceProperties.AppMeshVirtualRouterVirtualRouterSpec as X
import Stratosphere.ResourceProperties.AppMeshVirtualServiceVirtualNodeServiceProvider as X
import Stratosphere.ResourceProperties.AppMeshVirtualServiceVirtualRouterServiceProvider as X
import Stratosphere.ResourceProperties.AppMeshVirtualServiceVirtualServiceProvider as X
import Stratosphere.ResourceProperties.AppMeshVirtualServiceVirtualServiceSpec as X
import Stratosphere.ResourceProperties.AppStreamDirectoryConfigServiceAccountCredentials as X
import Stratosphere.ResourceProperties.AppStreamFleetComputeCapacity as X
import Stratosphere.ResourceProperties.AppStreamFleetDomainJoinInfo as X
import Stratosphere.ResourceProperties.AppStreamFleetVpcConfig as X
import Stratosphere.ResourceProperties.AppStreamImageBuilderDomainJoinInfo as X
import Stratosphere.ResourceProperties.AppStreamImageBuilderVpcConfig as X
import Stratosphere.ResourceProperties.AppStreamStackApplicationSettings as X
import Stratosphere.ResourceProperties.AppStreamStackStorageConnector as X
import Stratosphere.ResourceProperties.AppStreamStackUserSetting as X
import Stratosphere.ResourceProperties.AppSyncDataSourceAuthorizationConfig as X
import Stratosphere.ResourceProperties.AppSyncDataSourceAwsIamConfig as X
import Stratosphere.ResourceProperties.AppSyncDataSourceDynamoDBConfig as X
import Stratosphere.ResourceProperties.AppSyncDataSourceElasticsearchConfig as X
import Stratosphere.ResourceProperties.AppSyncDataSourceHttpConfig as X
import Stratosphere.ResourceProperties.AppSyncDataSourceLambdaConfig as X
import Stratosphere.ResourceProperties.AppSyncDataSourceRdsHttpEndpointConfig as X
import Stratosphere.ResourceProperties.AppSyncDataSourceRelationalDatabaseConfig as X
import Stratosphere.ResourceProperties.AppSyncGraphQLApiAdditionalAuthenticationProvider as X
import Stratosphere.ResourceProperties.AppSyncGraphQLApiCognitoUserPoolConfig as X
import Stratosphere.ResourceProperties.AppSyncGraphQLApiLogConfig as X
import Stratosphere.ResourceProperties.AppSyncGraphQLApiOpenIDConnectConfig as X
import Stratosphere.ResourceProperties.AppSyncGraphQLApiUserPoolConfig as X
import Stratosphere.ResourceProperties.AppSyncResolverPipelineConfig as X
import Stratosphere.ResourceProperties.ApplicationAutoScalingScalableTargetScalableTargetAction as X
import Stratosphere.ResourceProperties.ApplicationAutoScalingScalableTargetScheduledAction as X
import Stratosphere.ResourceProperties.ApplicationAutoScalingScalableTargetSuspendedState as X
import Stratosphere.ResourceProperties.ApplicationAutoScalingScalingPolicyCustomizedMetricSpecification as X
import Stratosphere.ResourceProperties.ApplicationAutoScalingScalingPolicyMetricDimension as X
import Stratosphere.ResourceProperties.ApplicationAutoScalingScalingPolicyPredefinedMetricSpecification as X
import Stratosphere.ResourceProperties.ApplicationAutoScalingScalingPolicyStepAdjustment as X
import Stratosphere.ResourceProperties.ApplicationAutoScalingScalingPolicyStepScalingPolicyConfiguration as X
import Stratosphere.ResourceProperties.ApplicationAutoScalingScalingPolicyTargetTrackingScalingPolicyConfiguration as X
import Stratosphere.ResourceProperties.AutoScalingAutoScalingGroupInstancesDistribution as X
import Stratosphere.ResourceProperties.AutoScalingAutoScalingGroupLaunchTemplate as X
import Stratosphere.ResourceProperties.AutoScalingAutoScalingGroupLaunchTemplateOverrides as X
import Stratosphere.ResourceProperties.AutoScalingAutoScalingGroupLaunchTemplateSpecification as X
import Stratosphere.ResourceProperties.AutoScalingAutoScalingGroupLifecycleHookSpecification as X
import Stratosphere.ResourceProperties.AutoScalingAutoScalingGroupMetricsCollection as X
import Stratosphere.ResourceProperties.AutoScalingAutoScalingGroupMixedInstancesPolicy as X
import Stratosphere.ResourceProperties.AutoScalingAutoScalingGroupNotificationConfiguration as X
import Stratosphere.ResourceProperties.AutoScalingAutoScalingGroupTagProperty as X
import Stratosphere.ResourceProperties.AutoScalingLaunchConfigurationBlockDevice as X
import Stratosphere.ResourceProperties.AutoScalingLaunchConfigurationBlockDeviceMapping as X
import Stratosphere.ResourceProperties.AutoScalingScalingPolicyCustomizedMetricSpecification as X
import Stratosphere.ResourceProperties.AutoScalingScalingPolicyMetricDimension as X
import Stratosphere.ResourceProperties.AutoScalingScalingPolicyPredefinedMetricSpecification as X
import Stratosphere.ResourceProperties.AutoScalingScalingPolicyStepAdjustment as X
import Stratosphere.ResourceProperties.AutoScalingScalingPolicyTargetTrackingConfiguration as X
import Stratosphere.ResourceProperties.AutoScalingPlansScalingPlanApplicationSource as X
import Stratosphere.ResourceProperties.AutoScalingPlansScalingPlanCustomizedLoadMetricSpecification as X
import Stratosphere.ResourceProperties.AutoScalingPlansScalingPlanCustomizedScalingMetricSpecification as X
import Stratosphere.ResourceProperties.AutoScalingPlansScalingPlanMetricDimension as X
import Stratosphere.ResourceProperties.AutoScalingPlansScalingPlanPredefinedLoadMetricSpecification as X
import Stratosphere.ResourceProperties.AutoScalingPlansScalingPlanPredefinedScalingMetricSpecification as X
import Stratosphere.ResourceProperties.AutoScalingPlansScalingPlanScalingInstruction as X
import Stratosphere.ResourceProperties.AutoScalingPlansScalingPlanTagFilter as X
import Stratosphere.ResourceProperties.AutoScalingPlansScalingPlanTargetTrackingConfiguration as X
import Stratosphere.ResourceProperties.BackupBackupPlanBackupPlanResourceType as X
import Stratosphere.ResourceProperties.BackupBackupPlanBackupRuleResourceType as X
import Stratosphere.ResourceProperties.BackupBackupPlanLifecycleResourceType as X
import Stratosphere.ResourceProperties.BackupBackupSelectionBackupSelectionResourceType as X
import Stratosphere.ResourceProperties.BackupBackupSelectionConditionResourceType as X
import Stratosphere.ResourceProperties.BackupBackupVaultNotificationObjectType as X
import Stratosphere.ResourceProperties.BatchComputeEnvironmentComputeResources as X
import Stratosphere.ResourceProperties.BatchComputeEnvironmentLaunchTemplateSpecification as X
import Stratosphere.ResourceProperties.BatchJobDefinitionContainerProperties as X
import Stratosphere.ResourceProperties.BatchJobDefinitionDevice as X
import Stratosphere.ResourceProperties.BatchJobDefinitionEnvironment as X
import Stratosphere.ResourceProperties.BatchJobDefinitionLinuxParameters as X
import Stratosphere.ResourceProperties.BatchJobDefinitionMountPoints as X
import Stratosphere.ResourceProperties.BatchJobDefinitionNodeProperties as X
import Stratosphere.ResourceProperties.BatchJobDefinitionNodeRangeProperty as X
import Stratosphere.ResourceProperties.BatchJobDefinitionResourceRequirement as X
import Stratosphere.ResourceProperties.BatchJobDefinitionRetryStrategy as X
import Stratosphere.ResourceProperties.BatchJobDefinitionTimeout as X
import Stratosphere.ResourceProperties.BatchJobDefinitionUlimit as X
import Stratosphere.ResourceProperties.BatchJobDefinitionVolumes as X
import Stratosphere.ResourceProperties.BatchJobDefinitionVolumesHost as X
import Stratosphere.ResourceProperties.BatchJobQueueComputeEnvironmentOrder as X
import Stratosphere.ResourceProperties.BudgetsBudgetBudgetData as X
import Stratosphere.ResourceProperties.BudgetsBudgetCostTypes as X
import Stratosphere.ResourceProperties.BudgetsBudgetNotification as X
import Stratosphere.ResourceProperties.BudgetsBudgetNotificationWithSubscribers as X
import Stratosphere.ResourceProperties.BudgetsBudgetSpend as X
import Stratosphere.ResourceProperties.BudgetsBudgetSubscriber as X
import Stratosphere.ResourceProperties.BudgetsBudgetTimePeriod as X
import Stratosphere.ResourceProperties.CertificateManagerCertificateDomainValidationOption as X
import Stratosphere.ResourceProperties.Cloud9EnvironmentEC2Repository as X
import Stratosphere.ResourceProperties.CloudFrontCloudFrontOriginAccessIdentityCloudFrontOriginAccessIdentityConfig as X
import Stratosphere.ResourceProperties.CloudFrontDistributionCacheBehavior as X
import Stratosphere.ResourceProperties.CloudFrontDistributionCookies as X
import Stratosphere.ResourceProperties.CloudFrontDistributionCustomErrorResponse as X
import Stratosphere.ResourceProperties.CloudFrontDistributionCustomOriginConfig as X
import Stratosphere.ResourceProperties.CloudFrontDistributionDefaultCacheBehavior as X
import Stratosphere.ResourceProperties.CloudFrontDistributionDistributionConfig as X
import Stratosphere.ResourceProperties.CloudFrontDistributionForwardedValues as X
import Stratosphere.ResourceProperties.CloudFrontDistributionGeoRestriction as X
import Stratosphere.ResourceProperties.CloudFrontDistributionLambdaFunctionAssociation as X
import Stratosphere.ResourceProperties.CloudFrontDistributionLogging as X
import Stratosphere.ResourceProperties.CloudFrontDistributionOrigin as X
import Stratosphere.ResourceProperties.CloudFrontDistributionOriginCustomHeader as X
import Stratosphere.ResourceProperties.CloudFrontDistributionRestrictions as X
import Stratosphere.ResourceProperties.CloudFrontDistributionS3OriginConfig as X
import Stratosphere.ResourceProperties.CloudFrontDistributionViewerCertificate as X
import Stratosphere.ResourceProperties.CloudFrontStreamingDistributionLogging as X
import Stratosphere.ResourceProperties.CloudFrontStreamingDistributionS3Origin as X
import Stratosphere.ResourceProperties.CloudFrontStreamingDistributionStreamingDistributionConfig as X
import Stratosphere.ResourceProperties.CloudFrontStreamingDistributionTrustedSigners as X
import Stratosphere.ResourceProperties.CloudTrailTrailDataResource as X
import Stratosphere.ResourceProperties.CloudTrailTrailEventSelector as X
import Stratosphere.ResourceProperties.CloudWatchAlarmDimension as X
import Stratosphere.ResourceProperties.CloudWatchAlarmMetric as X
import Stratosphere.ResourceProperties.CloudWatchAlarmMetricDataQuery as X
import Stratosphere.ResourceProperties.CloudWatchAlarmMetricStat as X
import Stratosphere.ResourceProperties.CloudWatchAnomalyDetectorConfiguration as X
import Stratosphere.ResourceProperties.CloudWatchAnomalyDetectorDimension as X
import Stratosphere.ResourceProperties.CloudWatchAnomalyDetectorRange as X
import Stratosphere.ResourceProperties.CodeBuildProjectArtifacts as X
import Stratosphere.ResourceProperties.CodeBuildProjectCloudWatchLogsConfig as X
import Stratosphere.ResourceProperties.CodeBuildProjectEnvironment as X
import Stratosphere.ResourceProperties.CodeBuildProjectEnvironmentVariable as X
import Stratosphere.ResourceProperties.CodeBuildProjectGitSubmodulesConfig as X
import Stratosphere.ResourceProperties.CodeBuildProjectLogsConfig as X
import Stratosphere.ResourceProperties.CodeBuildProjectProjectCache as X
import Stratosphere.ResourceProperties.CodeBuildProjectProjectSourceVersion as X
import Stratosphere.ResourceProperties.CodeBuildProjectProjectTriggers as X
import Stratosphere.ResourceProperties.CodeBuildProjectRegistryCredential as X
import Stratosphere.ResourceProperties.CodeBuildProjectS3LogsConfig as X
import Stratosphere.ResourceProperties.CodeBuildProjectSource as X
import Stratosphere.ResourceProperties.CodeBuildProjectSourceAuth as X
import Stratosphere.ResourceProperties.CodeBuildProjectVpcConfig as X
import Stratosphere.ResourceProperties.CodeBuildProjectWebhookFilter as X
import Stratosphere.ResourceProperties.CodeCommitRepositoryCode as X
import Stratosphere.ResourceProperties.CodeCommitRepositoryRepositoryTrigger as X
import Stratosphere.ResourceProperties.CodeCommitRepositoryS3 as X
import Stratosphere.ResourceProperties.CodeDeployDeploymentConfigMinimumHealthyHosts as X
import Stratosphere.ResourceProperties.CodeDeployDeploymentGroupAlarm as X
import Stratosphere.ResourceProperties.CodeDeployDeploymentGroupAlarmConfiguration as X
import Stratosphere.ResourceProperties.CodeDeployDeploymentGroupAutoRollbackConfiguration as X
import Stratosphere.ResourceProperties.CodeDeployDeploymentGroupDeployment as X
import Stratosphere.ResourceProperties.CodeDeployDeploymentGroupDeploymentStyle as X
import Stratosphere.ResourceProperties.CodeDeployDeploymentGroupEC2TagFilter as X
import Stratosphere.ResourceProperties.CodeDeployDeploymentGroupEC2TagSet as X
import Stratosphere.ResourceProperties.CodeDeployDeploymentGroupEC2TagSetListObject as X
import Stratosphere.ResourceProperties.CodeDeployDeploymentGroupELBInfo as X
import Stratosphere.ResourceProperties.CodeDeployDeploymentGroupGitHubLocation as X
import Stratosphere.ResourceProperties.CodeDeployDeploymentGroupLoadBalancerInfo as X
import Stratosphere.ResourceProperties.CodeDeployDeploymentGroupOnPremisesTagSet as X
import Stratosphere.ResourceProperties.CodeDeployDeploymentGroupOnPremisesTagSetListObject as X
import Stratosphere.ResourceProperties.CodeDeployDeploymentGroupRevisionLocation as X
import Stratosphere.ResourceProperties.CodeDeployDeploymentGroupS3Location as X
import Stratosphere.ResourceProperties.CodeDeployDeploymentGroupTagFilter as X
import Stratosphere.ResourceProperties.CodeDeployDeploymentGroupTargetGroupInfo as X
import Stratosphere.ResourceProperties.CodeDeployDeploymentGroupTriggerConfig as X
import Stratosphere.ResourceProperties.CodePipelineCustomActionTypeArtifactDetails as X
import Stratosphere.ResourceProperties.CodePipelineCustomActionTypeConfigurationProperties as X
import Stratosphere.ResourceProperties.CodePipelineCustomActionTypeSettings as X
import Stratosphere.ResourceProperties.CodePipelinePipelineActionDeclaration as X
import Stratosphere.ResourceProperties.CodePipelinePipelineActionTypeId as X
import Stratosphere.ResourceProperties.CodePipelinePipelineArtifactStore as X
import Stratosphere.ResourceProperties.CodePipelinePipelineArtifactStoreMap as X
import Stratosphere.ResourceProperties.CodePipelinePipelineBlockerDeclaration as X
import Stratosphere.ResourceProperties.CodePipelinePipelineEncryptionKey as X
import Stratosphere.ResourceProperties.CodePipelinePipelineInputArtifact as X
import Stratosphere.ResourceProperties.CodePipelinePipelineOutputArtifact as X
import Stratosphere.ResourceProperties.CodePipelinePipelineStageDeclaration as X
import Stratosphere.ResourceProperties.CodePipelinePipelineStageTransition as X
import Stratosphere.ResourceProperties.CodePipelineWebhookWebhookAuthConfiguration as X
import Stratosphere.ResourceProperties.CodePipelineWebhookWebhookFilterRule as X
import Stratosphere.ResourceProperties.CodeStarGitHubRepositoryCode as X
import Stratosphere.ResourceProperties.CodeStarGitHubRepositoryS3 as X
import Stratosphere.ResourceProperties.CognitoIdentityPoolCognitoIdentityProvider as X
import Stratosphere.ResourceProperties.CognitoIdentityPoolCognitoStreams as X
import Stratosphere.ResourceProperties.CognitoIdentityPoolPushSync as X
import Stratosphere.ResourceProperties.CognitoIdentityPoolRoleAttachmentMappingRule as X
import Stratosphere.ResourceProperties.CognitoIdentityPoolRoleAttachmentRoleMapping as X
import Stratosphere.ResourceProperties.CognitoIdentityPoolRoleAttachmentRulesConfigurationType as X
import Stratosphere.ResourceProperties.CognitoUserPoolAdminCreateUserConfig as X
import Stratosphere.ResourceProperties.CognitoUserPoolDeviceConfiguration as X
import Stratosphere.ResourceProperties.CognitoUserPoolEmailConfiguration as X
import Stratosphere.ResourceProperties.CognitoUserPoolInviteMessageTemplate as X
import Stratosphere.ResourceProperties.CognitoUserPoolLambdaConfig as X
import Stratosphere.ResourceProperties.CognitoUserPoolNumberAttributeConstraints as X
import Stratosphere.ResourceProperties.CognitoUserPoolPasswordPolicy as X
import Stratosphere.ResourceProperties.CognitoUserPoolPolicies as X
import Stratosphere.ResourceProperties.CognitoUserPoolSchemaAttribute as X
import Stratosphere.ResourceProperties.CognitoUserPoolSmsConfiguration as X
import Stratosphere.ResourceProperties.CognitoUserPoolStringAttributeConstraints as X
import Stratosphere.ResourceProperties.CognitoUserPoolUserPoolAddOns as X
import Stratosphere.ResourceProperties.CognitoUserPoolVerificationMessageTemplate as X
import Stratosphere.ResourceProperties.CognitoUserPoolClientAnalyticsConfiguration as X
import Stratosphere.ResourceProperties.CognitoUserPoolDomainCustomDomainConfigType as X
import Stratosphere.ResourceProperties.CognitoUserPoolResourceServerResourceServerScopeType as X
import Stratosphere.ResourceProperties.CognitoUserPoolRiskConfigurationAttachmentAccountTakeoverActionType as X
import Stratosphere.ResourceProperties.CognitoUserPoolRiskConfigurationAttachmentAccountTakeoverActionsType as X
import Stratosphere.ResourceProperties.CognitoUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationType as X
import Stratosphere.ResourceProperties.CognitoUserPoolRiskConfigurationAttachmentCompromisedCredentialsActionsType as X
import Stratosphere.ResourceProperties.CognitoUserPoolRiskConfigurationAttachmentCompromisedCredentialsRiskConfigurationType as X
import Stratosphere.ResourceProperties.CognitoUserPoolRiskConfigurationAttachmentNotifyConfigurationType as X
import Stratosphere.ResourceProperties.CognitoUserPoolRiskConfigurationAttachmentNotifyEmailType as X
import Stratosphere.ResourceProperties.CognitoUserPoolRiskConfigurationAttachmentRiskExceptionConfigurationType as X
import Stratosphere.ResourceProperties.CognitoUserPoolUserAttributeType as X
import Stratosphere.ResourceProperties.ConfigConfigRuleScope as X
import Stratosphere.ResourceProperties.ConfigConfigRuleSource as X
import Stratosphere.ResourceProperties.ConfigConfigRuleSourceDetail as X
import Stratosphere.ResourceProperties.ConfigConfigurationAggregatorAccountAggregationSource as X
import Stratosphere.ResourceProperties.ConfigConfigurationAggregatorOrganizationAggregationSource as X
import Stratosphere.ResourceProperties.ConfigConfigurationRecorderRecordingGroup as X
import Stratosphere.ResourceProperties.ConfigDeliveryChannelConfigSnapshotDeliveryProperties as X
import Stratosphere.ResourceProperties.ConfigOrganizationConfigRuleOrganizationCustomRuleMetadata as X
import Stratosphere.ResourceProperties.ConfigOrganizationConfigRuleOrganizationManagedRuleMetadata as X
import Stratosphere.ResourceProperties.ConfigRemediationConfigurationExecutionControls as X
import Stratosphere.ResourceProperties.ConfigRemediationConfigurationRemediationParameterValue as X
import Stratosphere.ResourceProperties.ConfigRemediationConfigurationResourceValue as X
import Stratosphere.ResourceProperties.ConfigRemediationConfigurationSsmControls as X
import Stratosphere.ResourceProperties.ConfigRemediationConfigurationStaticValue as X
import Stratosphere.ResourceProperties.DAXClusterSSESpecification as X
import Stratosphere.ResourceProperties.DLMLifecyclePolicyCreateRule as X
import Stratosphere.ResourceProperties.DLMLifecyclePolicyParameters as X
import Stratosphere.ResourceProperties.DLMLifecyclePolicyPolicyDetails as X
import Stratosphere.ResourceProperties.DLMLifecyclePolicyRetainRule as X
import Stratosphere.ResourceProperties.DLMLifecyclePolicySchedule as X
import Stratosphere.ResourceProperties.DMSEndpointDynamoDbSettings as X
import Stratosphere.ResourceProperties.DMSEndpointElasticsearchSettings as X
import Stratosphere.ResourceProperties.DMSEndpointKinesisSettings as X
import Stratosphere.ResourceProperties.DMSEndpointMongoDbSettings as X
import Stratosphere.ResourceProperties.DMSEndpointS3Settings as X
import Stratosphere.ResourceProperties.DataPipelinePipelineField as X
import Stratosphere.ResourceProperties.DataPipelinePipelineParameterAttribute as X
import Stratosphere.ResourceProperties.DataPipelinePipelineParameterObject as X
import Stratosphere.ResourceProperties.DataPipelinePipelineParameterValue as X
import Stratosphere.ResourceProperties.DataPipelinePipelinePipelineObject as X
import Stratosphere.ResourceProperties.DataPipelinePipelinePipelineTag as X
import Stratosphere.ResourceProperties.DirectoryServiceMicrosoftADVpcSettings as X
import Stratosphere.ResourceProperties.DirectoryServiceSimpleADVpcSettings as X
import Stratosphere.ResourceProperties.DynamoDBTableAttributeDefinition as X
import Stratosphere.ResourceProperties.DynamoDBTableGlobalSecondaryIndex as X
import Stratosphere.ResourceProperties.DynamoDBTableKeySchema as X
import Stratosphere.ResourceProperties.DynamoDBTableLocalSecondaryIndex as X
import Stratosphere.ResourceProperties.DynamoDBTablePointInTimeRecoverySpecification as X
import Stratosphere.ResourceProperties.DynamoDBTableProjection as X
import Stratosphere.ResourceProperties.DynamoDBTableProvisionedThroughput as X
import Stratosphere.ResourceProperties.DynamoDBTableSSESpecification as X
import Stratosphere.ResourceProperties.DynamoDBTableStreamSpecification as X
import Stratosphere.ResourceProperties.DynamoDBTableTimeToLiveSpecification as X
import Stratosphere.ResourceProperties.EC2CapacityReservationTagSpecification as X
import Stratosphere.ResourceProperties.EC2ClientVpnEndpointCertificateAuthenticationRequest as X
import Stratosphere.ResourceProperties.EC2ClientVpnEndpointClientAuthenticationRequest as X
import Stratosphere.ResourceProperties.EC2ClientVpnEndpointConnectionLogOptions as X
import Stratosphere.ResourceProperties.EC2ClientVpnEndpointDirectoryServiceAuthenticationRequest as X
import Stratosphere.ResourceProperties.EC2ClientVpnEndpointTagSpecification as X
import Stratosphere.ResourceProperties.EC2EC2FleetFleetLaunchTemplateConfigRequest as X
import Stratosphere.ResourceProperties.EC2EC2FleetFleetLaunchTemplateOverridesRequest as X
import Stratosphere.ResourceProperties.EC2EC2FleetFleetLaunchTemplateSpecificationRequest as X
import Stratosphere.ResourceProperties.EC2EC2FleetOnDemandOptionsRequest as X
import Stratosphere.ResourceProperties.EC2EC2FleetSpotOptionsRequest as X
import Stratosphere.ResourceProperties.EC2EC2FleetTagRequest as X
import Stratosphere.ResourceProperties.EC2EC2FleetTagSpecification as X
import Stratosphere.ResourceProperties.EC2EC2FleetTargetCapacitySpecificationRequest as X
import Stratosphere.ResourceProperties.EC2InstanceAssociationParameter as X
import Stratosphere.ResourceProperties.EC2InstanceBlockDeviceMapping as X
import Stratosphere.ResourceProperties.EC2InstanceCpuOptions as X
import Stratosphere.ResourceProperties.EC2InstanceCreditSpecification as X
import Stratosphere.ResourceProperties.EC2InstanceEbs as X
import Stratosphere.ResourceProperties.EC2InstanceElasticGpuSpecification as X
import Stratosphere.ResourceProperties.EC2InstanceElasticInferenceAccelerator as X
import Stratosphere.ResourceProperties.EC2InstanceInstanceIpv6Address as X
import Stratosphere.ResourceProperties.EC2InstanceLaunchTemplateSpecification as X
import Stratosphere.ResourceProperties.EC2InstanceLicenseSpecification as X
import Stratosphere.ResourceProperties.EC2InstanceNetworkInterface as X
import Stratosphere.ResourceProperties.EC2InstanceNoDevice as X
import Stratosphere.ResourceProperties.EC2InstancePrivateIpAddressSpecification as X
import Stratosphere.ResourceProperties.EC2InstanceSsmAssociation as X
import Stratosphere.ResourceProperties.EC2InstanceVolume as X
import Stratosphere.ResourceProperties.EC2LaunchTemplateBlockDeviceMapping as X
import Stratosphere.ResourceProperties.EC2LaunchTemplateCapacityReservationSpecification as X
import Stratosphere.ResourceProperties.EC2LaunchTemplateCapacityReservationTarget as X
import Stratosphere.ResourceProperties.EC2LaunchTemplateCpuOptions as X
import Stratosphere.ResourceProperties.EC2LaunchTemplateCreditSpecification as X
import Stratosphere.ResourceProperties.EC2LaunchTemplateEbs as X
import Stratosphere.ResourceProperties.EC2LaunchTemplateElasticGpuSpecification as X
import Stratosphere.ResourceProperties.EC2LaunchTemplateHibernationOptions as X
import Stratosphere.ResourceProperties.EC2LaunchTemplateIamInstanceProfile as X
import Stratosphere.ResourceProperties.EC2LaunchTemplateInstanceMarketOptions as X
import Stratosphere.ResourceProperties.EC2LaunchTemplateIpv6Add as X
import Stratosphere.ResourceProperties.EC2LaunchTemplateLaunchTemplateData as X
import Stratosphere.ResourceProperties.EC2LaunchTemplateLaunchTemplateElasticInferenceAccelerator as X
import Stratosphere.ResourceProperties.EC2LaunchTemplateLicenseSpecification as X
import Stratosphere.ResourceProperties.EC2LaunchTemplateMonitoring as X
import Stratosphere.ResourceProperties.EC2LaunchTemplateNetworkInterface as X
import Stratosphere.ResourceProperties.EC2LaunchTemplatePlacement as X
import Stratosphere.ResourceProperties.EC2LaunchTemplatePrivateIpAdd as X
import Stratosphere.ResourceProperties.EC2LaunchTemplateSpotOptions as X
import Stratosphere.ResourceProperties.EC2LaunchTemplateTagSpecification as X
import Stratosphere.ResourceProperties.EC2NetworkAclEntryIcmp as X
import Stratosphere.ResourceProperties.EC2NetworkAclEntryPortRange as X
import Stratosphere.ResourceProperties.EC2NetworkInterfaceInstanceIpv6Address as X
import Stratosphere.ResourceProperties.EC2NetworkInterfacePrivateIpAddressSpecification as X
import Stratosphere.ResourceProperties.EC2SecurityGroupEgressProperty as X
import Stratosphere.ResourceProperties.EC2SecurityGroupIngressProperty as X
import Stratosphere.ResourceProperties.EC2SpotFleetBlockDeviceMapping as X
import Stratosphere.ResourceProperties.EC2SpotFleetClassicLoadBalancer as X
import Stratosphere.ResourceProperties.EC2SpotFleetClassicLoadBalancersConfig as X
import Stratosphere.ResourceProperties.EC2SpotFleetEbsBlockDevice as X
import Stratosphere.ResourceProperties.EC2SpotFleetFleetLaunchTemplateSpecification as X
import Stratosphere.ResourceProperties.EC2SpotFleetGroupIdentifier as X
import Stratosphere.ResourceProperties.EC2SpotFleetIamInstanceProfileSpecification as X
import Stratosphere.ResourceProperties.EC2SpotFleetInstanceIpv6Address as X
import Stratosphere.ResourceProperties.EC2SpotFleetInstanceNetworkInterfaceSpecification as X
import Stratosphere.ResourceProperties.EC2SpotFleetLaunchTemplateConfig as X
import Stratosphere.ResourceProperties.EC2SpotFleetLaunchTemplateOverrides as X
import Stratosphere.ResourceProperties.EC2SpotFleetLoadBalancersConfig as X
import Stratosphere.ResourceProperties.EC2SpotFleetPrivateIpAddressSpecification as X
import Stratosphere.ResourceProperties.EC2SpotFleetSpotFleetLaunchSpecification as X
import Stratosphere.ResourceProperties.EC2SpotFleetSpotFleetMonitoring as X
import Stratosphere.ResourceProperties.EC2SpotFleetSpotFleetRequestConfigData as X
import Stratosphere.ResourceProperties.EC2SpotFleetSpotFleetTagSpecification as X
import Stratosphere.ResourceProperties.EC2SpotFleetSpotPlacement as X
import Stratosphere.ResourceProperties.EC2SpotFleetTargetGroup as X
import Stratosphere.ResourceProperties.EC2SpotFleetTargetGroupsConfig as X
import Stratosphere.ResourceProperties.EC2TrafficMirrorFilterRuleTrafficMirrorPortRange as X
import Stratosphere.ResourceProperties.EC2VPNConnectionVpnTunnelOptionsSpecification as X
import Stratosphere.ResourceProperties.ECRRepositoryLifecyclePolicy as X
import Stratosphere.ResourceProperties.ECSServiceAwsVpcConfiguration as X
import Stratosphere.ResourceProperties.ECSServiceDeploymentConfiguration as X
import Stratosphere.ResourceProperties.ECSServiceLoadBalancer as X
import Stratosphere.ResourceProperties.ECSServiceNetworkConfiguration as X
import Stratosphere.ResourceProperties.ECSServicePlacementConstraint as X
import Stratosphere.ResourceProperties.ECSServicePlacementStrategy as X
import Stratosphere.ResourceProperties.ECSServiceServiceRegistry as X
import Stratosphere.ResourceProperties.ECSTaskDefinitionContainerDefinition as X
import Stratosphere.ResourceProperties.ECSTaskDefinitionContainerDependency as X
import Stratosphere.ResourceProperties.ECSTaskDefinitionDevice as X
import Stratosphere.ResourceProperties.ECSTaskDefinitionDockerVolumeConfiguration as X
import Stratosphere.ResourceProperties.ECSTaskDefinitionHealthCheck as X
import Stratosphere.ResourceProperties.ECSTaskDefinitionHostEntry as X
import Stratosphere.ResourceProperties.ECSTaskDefinitionHostVolumeProperties as X
import Stratosphere.ResourceProperties.ECSTaskDefinitionKernelCapabilities as X
import Stratosphere.ResourceProperties.ECSTaskDefinitionKeyValuePair as X
import Stratosphere.ResourceProperties.ECSTaskDefinitionLinuxParameters as X
import Stratosphere.ResourceProperties.ECSTaskDefinitionLogConfiguration as X
import Stratosphere.ResourceProperties.ECSTaskDefinitionMountPoint as X
import Stratosphere.ResourceProperties.ECSTaskDefinitionPortMapping as X
import Stratosphere.ResourceProperties.ECSTaskDefinitionProxyConfiguration as X
import Stratosphere.ResourceProperties.ECSTaskDefinitionRepositoryCredentials as X
import Stratosphere.ResourceProperties.ECSTaskDefinitionResourceRequirement as X
import Stratosphere.ResourceProperties.ECSTaskDefinitionSecret as X
import Stratosphere.ResourceProperties.ECSTaskDefinitionSystemControl as X
import Stratosphere.ResourceProperties.ECSTaskDefinitionTaskDefinitionPlacementConstraint as X
import Stratosphere.ResourceProperties.ECSTaskDefinitionTmpfs as X
import Stratosphere.ResourceProperties.ECSTaskDefinitionUlimit as X
import Stratosphere.ResourceProperties.ECSTaskDefinitionVolume as X
import Stratosphere.ResourceProperties.ECSTaskDefinitionVolumeFrom as X
import Stratosphere.ResourceProperties.EFSFileSystemElasticFileSystemTag as X
import Stratosphere.ResourceProperties.EFSFileSystemLifecyclePolicy as X
import Stratosphere.ResourceProperties.EKSClusterResourcesVpcConfig as X
import Stratosphere.ResourceProperties.EMRClusterApplication as X
import Stratosphere.ResourceProperties.EMRClusterAutoScalingPolicy as X
import Stratosphere.ResourceProperties.EMRClusterBootstrapActionConfig as X
import Stratosphere.ResourceProperties.EMRClusterCloudWatchAlarmDefinition as X
import Stratosphere.ResourceProperties.EMRClusterConfiguration as X
import Stratosphere.ResourceProperties.EMRClusterEbsBlockDeviceConfig as X
import Stratosphere.ResourceProperties.EMRClusterEbsConfiguration as X
import Stratosphere.ResourceProperties.EMRClusterHadoopJarStepConfig as X
import Stratosphere.ResourceProperties.EMRClusterInstanceFleetConfig as X
import Stratosphere.ResourceProperties.EMRClusterInstanceFleetProvisioningSpecifications as X
import Stratosphere.ResourceProperties.EMRClusterInstanceGroupConfig as X
import Stratosphere.ResourceProperties.EMRClusterInstanceTypeConfig as X
import Stratosphere.ResourceProperties.EMRClusterJobFlowInstancesConfig as X
import Stratosphere.ResourceProperties.EMRClusterKerberosAttributes as X
import Stratosphere.ResourceProperties.EMRClusterKeyValue as X
import Stratosphere.ResourceProperties.EMRClusterMetricDimension as X
import Stratosphere.ResourceProperties.EMRClusterPlacementType as X
import Stratosphere.ResourceProperties.EMRClusterScalingAction as X
import Stratosphere.ResourceProperties.EMRClusterScalingConstraints as X
import Stratosphere.ResourceProperties.EMRClusterScalingRule as X
import Stratosphere.ResourceProperties.EMRClusterScalingTrigger as X
import Stratosphere.ResourceProperties.EMRClusterScriptBootstrapActionConfig as X
import Stratosphere.ResourceProperties.EMRClusterSimpleScalingPolicyConfiguration as X
import Stratosphere.ResourceProperties.EMRClusterSpotProvisioningSpecification as X
import Stratosphere.ResourceProperties.EMRClusterStepConfig as X
import Stratosphere.ResourceProperties.EMRClusterVolumeSpecification as X
import Stratosphere.ResourceProperties.EMRInstanceFleetConfigConfiguration as X
import Stratosphere.ResourceProperties.EMRInstanceFleetConfigEbsBlockDeviceConfig as X
import Stratosphere.ResourceProperties.EMRInstanceFleetConfigEbsConfiguration as X
import Stratosphere.ResourceProperties.EMRInstanceFleetConfigInstanceFleetProvisioningSpecifications as X
import Stratosphere.ResourceProperties.EMRInstanceFleetConfigInstanceTypeConfig as X
import Stratosphere.ResourceProperties.EMRInstanceFleetConfigSpotProvisioningSpecification as X
import Stratosphere.ResourceProperties.EMRInstanceFleetConfigVolumeSpecification as X
import Stratosphere.ResourceProperties.EMRInstanceGroupConfigAutoScalingPolicy as X
import Stratosphere.ResourceProperties.EMRInstanceGroupConfigCloudWatchAlarmDefinition as X
import Stratosphere.ResourceProperties.EMRInstanceGroupConfigConfiguration as X
import Stratosphere.ResourceProperties.EMRInstanceGroupConfigEbsBlockDeviceConfig as X
import Stratosphere.ResourceProperties.EMRInstanceGroupConfigEbsConfiguration as X
import Stratosphere.ResourceProperties.EMRInstanceGroupConfigMetricDimension as X
import Stratosphere.ResourceProperties.EMRInstanceGroupConfigScalingAction as X
import Stratosphere.ResourceProperties.EMRInstanceGroupConfigScalingConstraints as X
import Stratosphere.ResourceProperties.EMRInstanceGroupConfigScalingRule as X
import Stratosphere.ResourceProperties.EMRInstanceGroupConfigScalingTrigger as X
import Stratosphere.ResourceProperties.EMRInstanceGroupConfigSimpleScalingPolicyConfiguration as X
import Stratosphere.ResourceProperties.EMRInstanceGroupConfigVolumeSpecification as X
import Stratosphere.ResourceProperties.EMRStepHadoopJarStepConfig as X
import Stratosphere.ResourceProperties.EMRStepKeyValue as X
import Stratosphere.ResourceProperties.ElastiCacheReplicationGroupNodeGroupConfiguration as X
import Stratosphere.ResourceProperties.ElasticBeanstalkApplicationApplicationResourceLifecycleConfig as X
import Stratosphere.ResourceProperties.ElasticBeanstalkApplicationApplicationVersionLifecycleConfig as X
import Stratosphere.ResourceProperties.ElasticBeanstalkApplicationMaxAgeRule as X
import Stratosphere.ResourceProperties.ElasticBeanstalkApplicationMaxCountRule as X
import Stratosphere.ResourceProperties.ElasticBeanstalkApplicationVersionSourceBundle as X
import Stratosphere.ResourceProperties.ElasticBeanstalkConfigurationTemplateConfigurationOptionSetting as X
import Stratosphere.ResourceProperties.ElasticBeanstalkConfigurationTemplateSourceConfiguration as X
import Stratosphere.ResourceProperties.ElasticBeanstalkEnvironmentOptionSetting as X
import Stratosphere.ResourceProperties.ElasticBeanstalkEnvironmentTier as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingLoadBalancerAccessLoggingPolicy as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingLoadBalancerAppCookieStickinessPolicy as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingLoadBalancerConnectionDrainingPolicy as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingLoadBalancerConnectionSettings as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingLoadBalancerHealthCheck as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingLoadBalancerLBCookieStickinessPolicy as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingLoadBalancerListeners as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingLoadBalancerPolicies as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingV2ListenerAction as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingV2ListenerAuthenticateCognitoConfig as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingV2ListenerAuthenticateOidcConfig as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingV2ListenerCertificate as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingV2ListenerFixedResponseConfig as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingV2ListenerRedirectConfig as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingV2ListenerCertificateCertificate as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingV2ListenerRuleAction as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingV2ListenerRuleAuthenticateCognitoConfig as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingV2ListenerRuleAuthenticateOidcConfig as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingV2ListenerRuleFixedResponseConfig as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingV2ListenerRuleHostHeaderConfig as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingV2ListenerRuleHttpHeaderConfig as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingV2ListenerRuleHttpRequestMethodConfig as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingV2ListenerRulePathPatternConfig as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingV2ListenerRuleQueryStringConfig as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingV2ListenerRuleQueryStringKeyValue as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingV2ListenerRuleRedirectConfig as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingV2ListenerRuleRuleCondition as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingV2ListenerRuleSourceIpConfig as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingV2LoadBalancerLoadBalancerAttribute as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingV2LoadBalancerSubnetMapping as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingV2TargetGroupMatcher as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingV2TargetGroupTargetDescription as X
import Stratosphere.ResourceProperties.ElasticLoadBalancingV2TargetGroupTargetGroupAttribute as X
import Stratosphere.ResourceProperties.ElasticsearchDomainEBSOptions as X
import Stratosphere.ResourceProperties.ElasticsearchDomainElasticsearchClusterConfig as X
import Stratosphere.ResourceProperties.ElasticsearchDomainEncryptionAtRestOptions as X
import Stratosphere.ResourceProperties.ElasticsearchDomainNodeToNodeEncryptionOptions as X
import Stratosphere.ResourceProperties.ElasticsearchDomainSnapshotOptions as X
import Stratosphere.ResourceProperties.ElasticsearchDomainVPCOptions as X
import Stratosphere.ResourceProperties.ElasticsearchDomainZoneAwarenessConfig as X
import Stratosphere.ResourceProperties.EventsEventBusPolicyCondition as X
import Stratosphere.ResourceProperties.EventsRuleAwsVpcConfiguration as X
import Stratosphere.ResourceProperties.EventsRuleEcsParameters as X
import Stratosphere.ResourceProperties.EventsRuleInputTransformer as X
import Stratosphere.ResourceProperties.EventsRuleKinesisParameters as X
import Stratosphere.ResourceProperties.EventsRuleNetworkConfiguration as X
import Stratosphere.ResourceProperties.EventsRuleRunCommandParameters as X
import Stratosphere.ResourceProperties.EventsRuleRunCommandTarget as X
import Stratosphere.ResourceProperties.EventsRuleSqsParameters as X
import Stratosphere.ResourceProperties.EventsRuleTarget as X
import Stratosphere.ResourceProperties.FSxFileSystemLustreConfiguration as X
import Stratosphere.ResourceProperties.FSxFileSystemSelfManagedActiveDirectoryConfiguration as X
import Stratosphere.ResourceProperties.FSxFileSystemWindowsConfiguration as X
import Stratosphere.ResourceProperties.GameLiftAliasRoutingStrategy as X
import Stratosphere.ResourceProperties.GameLiftBuildS3Location as X
import Stratosphere.ResourceProperties.GameLiftFleetIpPermission as X
import Stratosphere.ResourceProperties.GlueClassifierCsvClassifier as X
import Stratosphere.ResourceProperties.GlueClassifierGrokClassifier as X
import Stratosphere.ResourceProperties.GlueClassifierJsonClassifier as X
import Stratosphere.ResourceProperties.GlueClassifierXMLClassifier as X
import Stratosphere.ResourceProperties.GlueConnectionConnectionInput as X
import Stratosphere.ResourceProperties.GlueConnectionPhysicalConnectionRequirements as X
import Stratosphere.ResourceProperties.GlueCrawlerJdbcTarget as X
import Stratosphere.ResourceProperties.GlueCrawlerS3Target as X
import Stratosphere.ResourceProperties.GlueCrawlerSchedule as X
import Stratosphere.ResourceProperties.GlueCrawlerSchemaChangePolicy as X
import Stratosphere.ResourceProperties.GlueCrawlerTargets as X
import Stratosphere.ResourceProperties.GlueDataCatalogEncryptionSettingsConnectionPasswordEncryption as X
import Stratosphere.ResourceProperties.GlueDataCatalogEncryptionSettingsDataCatalogEncryptionSettings as X
import Stratosphere.ResourceProperties.GlueDataCatalogEncryptionSettingsEncryptionAtRest as X
import Stratosphere.ResourceProperties.GlueDatabaseDatabaseInput as X
import Stratosphere.ResourceProperties.GlueJobConnectionsList as X
import Stratosphere.ResourceProperties.GlueJobExecutionProperty as X
import Stratosphere.ResourceProperties.GlueJobJobCommand as X
import Stratosphere.ResourceProperties.GlueJobNotificationProperty as X
import Stratosphere.ResourceProperties.GlueMLTransformFindMatchesParameters as X
import Stratosphere.ResourceProperties.GlueMLTransformGlueTables as X
import Stratosphere.ResourceProperties.GlueMLTransformInputRecordTables as X
import Stratosphere.ResourceProperties.GlueMLTransformTransformParameters as X
import Stratosphere.ResourceProperties.GluePartitionColumn as X
import Stratosphere.ResourceProperties.GluePartitionOrder as X
import Stratosphere.ResourceProperties.GluePartitionPartitionInput as X
import Stratosphere.ResourceProperties.GluePartitionSerdeInfo as X
import Stratosphere.ResourceProperties.GluePartitionSkewedInfo as X
import Stratosphere.ResourceProperties.GluePartitionStorageDescriptor as X
import Stratosphere.ResourceProperties.GlueSecurityConfigurationCloudWatchEncryption as X
import Stratosphere.ResourceProperties.GlueSecurityConfigurationEncryptionConfiguration as X
import Stratosphere.ResourceProperties.GlueSecurityConfigurationJobBookmarksEncryption as X
import Stratosphere.ResourceProperties.GlueSecurityConfigurationS3Encryption as X
import Stratosphere.ResourceProperties.GlueTableColumn as X
import Stratosphere.ResourceProperties.GlueTableOrder as X
import Stratosphere.ResourceProperties.GlueTableSerdeInfo as X
import Stratosphere.ResourceProperties.GlueTableSkewedInfo as X
import Stratosphere.ResourceProperties.GlueTableStorageDescriptor as X
import Stratosphere.ResourceProperties.GlueTableTableInput as X
import Stratosphere.ResourceProperties.GlueTriggerAction as X
import Stratosphere.ResourceProperties.GlueTriggerCondition as X
import Stratosphere.ResourceProperties.GlueTriggerNotificationProperty as X
import Stratosphere.ResourceProperties.GlueTriggerPredicate as X
import Stratosphere.ResourceProperties.GreengrassConnectorDefinitionConnector as X
import Stratosphere.ResourceProperties.GreengrassConnectorDefinitionConnectorDefinitionVersion as X
import Stratosphere.ResourceProperties.GreengrassConnectorDefinitionVersionConnector as X
import Stratosphere.ResourceProperties.GreengrassCoreDefinitionCore as X
import Stratosphere.ResourceProperties.GreengrassCoreDefinitionCoreDefinitionVersion as X
import Stratosphere.ResourceProperties.GreengrassCoreDefinitionVersionCore as X
import Stratosphere.ResourceProperties.GreengrassDeviceDefinitionDevice as X
import Stratosphere.ResourceProperties.GreengrassDeviceDefinitionDeviceDefinitionVersion as X
import Stratosphere.ResourceProperties.GreengrassDeviceDefinitionVersionDevice as X
import Stratosphere.ResourceProperties.GreengrassFunctionDefinitionDefaultConfig as X
import Stratosphere.ResourceProperties.GreengrassFunctionDefinitionEnvironment as X
import Stratosphere.ResourceProperties.GreengrassFunctionDefinitionExecution as X
import Stratosphere.ResourceProperties.GreengrassFunctionDefinitionFunction as X
import Stratosphere.ResourceProperties.GreengrassFunctionDefinitionFunctionConfiguration as X
import Stratosphere.ResourceProperties.GreengrassFunctionDefinitionFunctionDefinitionVersion as X
import Stratosphere.ResourceProperties.GreengrassFunctionDefinitionResourceAccessPolicy as X
import Stratosphere.ResourceProperties.GreengrassFunctionDefinitionRunAs as X
import Stratosphere.ResourceProperties.GreengrassFunctionDefinitionVersionDefaultConfig as X
import Stratosphere.ResourceProperties.GreengrassFunctionDefinitionVersionEnvironment as X
import Stratosphere.ResourceProperties.GreengrassFunctionDefinitionVersionExecution as X
import Stratosphere.ResourceProperties.GreengrassFunctionDefinitionVersionFunction as X
import Stratosphere.ResourceProperties.GreengrassFunctionDefinitionVersionFunctionConfiguration as X
import Stratosphere.ResourceProperties.GreengrassFunctionDefinitionVersionResourceAccessPolicy as X
import Stratosphere.ResourceProperties.GreengrassFunctionDefinitionVersionRunAs as X
import Stratosphere.ResourceProperties.GreengrassGroupGroupVersion as X
import Stratosphere.ResourceProperties.GreengrassLoggerDefinitionLogger as X
import Stratosphere.ResourceProperties.GreengrassLoggerDefinitionLoggerDefinitionVersion as X
import Stratosphere.ResourceProperties.GreengrassLoggerDefinitionVersionLogger as X
import Stratosphere.ResourceProperties.GreengrassResourceDefinitionGroupOwnerSetting as X
import Stratosphere.ResourceProperties.GreengrassResourceDefinitionLocalDeviceResourceData as X
import Stratosphere.ResourceProperties.GreengrassResourceDefinitionLocalVolumeResourceData as X
import Stratosphere.ResourceProperties.GreengrassResourceDefinitionResourceDataContainer as X
import Stratosphere.ResourceProperties.GreengrassResourceDefinitionResourceDefinitionVersion as X
import Stratosphere.ResourceProperties.GreengrassResourceDefinitionResourceInstance as X
import Stratosphere.ResourceProperties.GreengrassResourceDefinitionS3MachineLearningModelResourceData as X
import Stratosphere.ResourceProperties.GreengrassResourceDefinitionSageMakerMachineLearningModelResourceData as X
import Stratosphere.ResourceProperties.GreengrassResourceDefinitionSecretsManagerSecretResourceData as X
import Stratosphere.ResourceProperties.GreengrassResourceDefinitionVersionGroupOwnerSetting as X
import Stratosphere.ResourceProperties.GreengrassResourceDefinitionVersionLocalDeviceResourceData as X
import Stratosphere.ResourceProperties.GreengrassResourceDefinitionVersionLocalVolumeResourceData as X
import Stratosphere.ResourceProperties.GreengrassResourceDefinitionVersionResourceDataContainer as X
import Stratosphere.ResourceProperties.GreengrassResourceDefinitionVersionResourceInstance as X
import Stratosphere.ResourceProperties.GreengrassResourceDefinitionVersionS3MachineLearningModelResourceData as X
import Stratosphere.ResourceProperties.GreengrassResourceDefinitionVersionSageMakerMachineLearningModelResourceData as X
import Stratosphere.ResourceProperties.GreengrassResourceDefinitionVersionSecretsManagerSecretResourceData as X
import Stratosphere.ResourceProperties.GreengrassSubscriptionDefinitionSubscription as X
import Stratosphere.ResourceProperties.GreengrassSubscriptionDefinitionSubscriptionDefinitionVersion as X
import Stratosphere.ResourceProperties.GreengrassSubscriptionDefinitionVersionSubscription as X
import Stratosphere.ResourceProperties.GuardDutyFilterCondition as X
import Stratosphere.ResourceProperties.GuardDutyFilterFindingCriteria as X
import Stratosphere.ResourceProperties.IAMGroupPolicy as X
import Stratosphere.ResourceProperties.IAMRolePolicy as X
import Stratosphere.ResourceProperties.IAMUserLoginProfile as X
import Stratosphere.ResourceProperties.IAMUserPolicy as X
import Stratosphere.ResourceProperties.IoT1ClickProjectDeviceTemplate as X
import Stratosphere.ResourceProperties.IoT1ClickProjectPlacementTemplate as X
import Stratosphere.ResourceProperties.IoTThingAttributePayload as X
import Stratosphere.ResourceProperties.IoTTopicRuleAction as X
import Stratosphere.ResourceProperties.IoTTopicRuleCloudwatchAlarmAction as X
import Stratosphere.ResourceProperties.IoTTopicRuleCloudwatchMetricAction as X
import Stratosphere.ResourceProperties.IoTTopicRuleDynamoDBAction as X
import Stratosphere.ResourceProperties.IoTTopicRuleDynamoDBV2Action as X
import Stratosphere.ResourceProperties.IoTTopicRuleElasticsearchAction as X
import Stratosphere.ResourceProperties.IoTTopicRuleFirehoseAction as X
import Stratosphere.ResourceProperties.IoTTopicRuleIotAnalyticsAction as X
import Stratosphere.ResourceProperties.IoTTopicRuleKinesisAction as X
import Stratosphere.ResourceProperties.IoTTopicRuleLambdaAction as X
import Stratosphere.ResourceProperties.IoTTopicRulePutItemInput as X
import Stratosphere.ResourceProperties.IoTTopicRuleRepublishAction as X
import Stratosphere.ResourceProperties.IoTTopicRuleS3Action as X
import Stratosphere.ResourceProperties.IoTTopicRuleSnsAction as X
import Stratosphere.ResourceProperties.IoTTopicRuleSqsAction as X
import Stratosphere.ResourceProperties.IoTTopicRuleStepFunctionsAction as X
import Stratosphere.ResourceProperties.IoTTopicRuleTopicRulePayload as X
import Stratosphere.ResourceProperties.IoTAnalyticsChannelChannelStorage as X
import Stratosphere.ResourceProperties.IoTAnalyticsChannelCustomerManagedS3 as X
import Stratosphere.ResourceProperties.IoTAnalyticsChannelRetentionPeriod as X
import Stratosphere.ResourceProperties.IoTAnalyticsChannelServiceManagedS3 as X
import Stratosphere.ResourceProperties.IoTAnalyticsDatasetAction as X
import Stratosphere.ResourceProperties.IoTAnalyticsDatasetContainerAction as X
import Stratosphere.ResourceProperties.IoTAnalyticsDatasetDatasetContentDeliveryRule as X
import Stratosphere.ResourceProperties.IoTAnalyticsDatasetDatasetContentDeliveryRuleDestination as X
import Stratosphere.ResourceProperties.IoTAnalyticsDatasetDatasetContentVersionValue as X
import Stratosphere.ResourceProperties.IoTAnalyticsDatasetDeltaTime as X
import Stratosphere.ResourceProperties.IoTAnalyticsDatasetFilter as X
import Stratosphere.ResourceProperties.IoTAnalyticsDatasetGlueConfiguration as X
import Stratosphere.ResourceProperties.IoTAnalyticsDatasetIotEventsDestinationConfiguration as X
import Stratosphere.ResourceProperties.IoTAnalyticsDatasetOutputFileUriValue as X
import Stratosphere.ResourceProperties.IoTAnalyticsDatasetQueryAction as X
import Stratosphere.ResourceProperties.IoTAnalyticsDatasetResourceConfiguration as X
import Stratosphere.ResourceProperties.IoTAnalyticsDatasetRetentionPeriod as X
import Stratosphere.ResourceProperties.IoTAnalyticsDatasetS3DestinationConfiguration as X
import Stratosphere.ResourceProperties.IoTAnalyticsDatasetSchedule as X
import Stratosphere.ResourceProperties.IoTAnalyticsDatasetTrigger as X
import Stratosphere.ResourceProperties.IoTAnalyticsDatasetTriggeringDataset as X
import Stratosphere.ResourceProperties.IoTAnalyticsDatasetVariable as X
import Stratosphere.ResourceProperties.IoTAnalyticsDatasetVersioningConfiguration as X
import Stratosphere.ResourceProperties.IoTAnalyticsDatastoreCustomerManagedS3 as X
import Stratosphere.ResourceProperties.IoTAnalyticsDatastoreDatastoreStorage as X
import Stratosphere.ResourceProperties.IoTAnalyticsDatastoreRetentionPeriod as X
import Stratosphere.ResourceProperties.IoTAnalyticsDatastoreServiceManagedS3 as X
import Stratosphere.ResourceProperties.IoTAnalyticsPipelineActivity as X
import Stratosphere.ResourceProperties.IoTAnalyticsPipelineAddAttributes as X
import Stratosphere.ResourceProperties.IoTAnalyticsPipelineChannel as X
import Stratosphere.ResourceProperties.IoTAnalyticsPipelineDatastore as X
import Stratosphere.ResourceProperties.IoTAnalyticsPipelineDeviceRegistryEnrich as X
import Stratosphere.ResourceProperties.IoTAnalyticsPipelineDeviceShadowEnrich as X
import Stratosphere.ResourceProperties.IoTAnalyticsPipelineFilter as X
import Stratosphere.ResourceProperties.IoTAnalyticsPipelineLambda as X
import Stratosphere.ResourceProperties.IoTAnalyticsPipelineMath as X
import Stratosphere.ResourceProperties.IoTAnalyticsPipelineRemoveAttributes as X
import Stratosphere.ResourceProperties.IoTAnalyticsPipelineSelectAttributes as X
import Stratosphere.ResourceProperties.IoTEventsDetectorModelAction as X
import Stratosphere.ResourceProperties.IoTEventsDetectorModelClearTimer as X
import Stratosphere.ResourceProperties.IoTEventsDetectorModelDetectorModelDefinition as X
import Stratosphere.ResourceProperties.IoTEventsDetectorModelEvent as X
import Stratosphere.ResourceProperties.IoTEventsDetectorModelFirehose as X
import Stratosphere.ResourceProperties.IoTEventsDetectorModelIotEvents as X
import Stratosphere.ResourceProperties.IoTEventsDetectorModelIotTopicPublish as X
import Stratosphere.ResourceProperties.IoTEventsDetectorModelLambda as X
import Stratosphere.ResourceProperties.IoTEventsDetectorModelOnEnter as X
import Stratosphere.ResourceProperties.IoTEventsDetectorModelOnExit as X
import Stratosphere.ResourceProperties.IoTEventsDetectorModelOnInput as X
import Stratosphere.ResourceProperties.IoTEventsDetectorModelResetTimer as X
import Stratosphere.ResourceProperties.IoTEventsDetectorModelSetTimer as X
import Stratosphere.ResourceProperties.IoTEventsDetectorModelSetVariable as X
import Stratosphere.ResourceProperties.IoTEventsDetectorModelSns as X
import Stratosphere.ResourceProperties.IoTEventsDetectorModelSqs as X
import Stratosphere.ResourceProperties.IoTEventsDetectorModelState as X
import Stratosphere.ResourceProperties.IoTEventsDetectorModelTransitionEvent as X
import Stratosphere.ResourceProperties.IoTEventsInputAttribute as X
import Stratosphere.ResourceProperties.IoTEventsInputInputDefinition as X
import Stratosphere.ResourceProperties.IoTThingsGraphFlowTemplateDefinitionDocument as X
import Stratosphere.ResourceProperties.KinesisStreamStreamEncryption as X
import Stratosphere.ResourceProperties.KinesisAnalyticsApplicationCSVMappingParameters as X
import Stratosphere.ResourceProperties.KinesisAnalyticsApplicationInput as X
import Stratosphere.ResourceProperties.KinesisAnalyticsApplicationInputLambdaProcessor as X
import Stratosphere.ResourceProperties.KinesisAnalyticsApplicationInputParallelism as X
import Stratosphere.ResourceProperties.KinesisAnalyticsApplicationInputProcessingConfiguration as X
import Stratosphere.ResourceProperties.KinesisAnalyticsApplicationInputSchema as X
import Stratosphere.ResourceProperties.KinesisAnalyticsApplicationJSONMappingParameters as X
import Stratosphere.ResourceProperties.KinesisAnalyticsApplicationKinesisFirehoseInput as X
import Stratosphere.ResourceProperties.KinesisAnalyticsApplicationKinesisStreamsInput as X
import Stratosphere.ResourceProperties.KinesisAnalyticsApplicationMappingParameters as X
import Stratosphere.ResourceProperties.KinesisAnalyticsApplicationRecordColumn as X
import Stratosphere.ResourceProperties.KinesisAnalyticsApplicationRecordFormat as X
import Stratosphere.ResourceProperties.KinesisAnalyticsApplicationOutputDestinationSchema as X
import Stratosphere.ResourceProperties.KinesisAnalyticsApplicationOutputKinesisFirehoseOutput as X
import Stratosphere.ResourceProperties.KinesisAnalyticsApplicationOutputKinesisStreamsOutput as X
import Stratosphere.ResourceProperties.KinesisAnalyticsApplicationOutputLambdaOutput as X
import Stratosphere.ResourceProperties.KinesisAnalyticsApplicationOutputOutput as X
import Stratosphere.ResourceProperties.KinesisAnalyticsApplicationReferenceDataSourceCSVMappingParameters as X
import Stratosphere.ResourceProperties.KinesisAnalyticsApplicationReferenceDataSourceJSONMappingParameters as X
import Stratosphere.ResourceProperties.KinesisAnalyticsApplicationReferenceDataSourceMappingParameters as X
import Stratosphere.ResourceProperties.KinesisAnalyticsApplicationReferenceDataSourceRecordColumn as X
import Stratosphere.ResourceProperties.KinesisAnalyticsApplicationReferenceDataSourceRecordFormat as X
import Stratosphere.ResourceProperties.KinesisAnalyticsApplicationReferenceDataSourceReferenceDataSource as X
import Stratosphere.ResourceProperties.KinesisAnalyticsApplicationReferenceDataSourceReferenceSchema as X
import Stratosphere.ResourceProperties.KinesisAnalyticsApplicationReferenceDataSourceS3ReferenceDataSource as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationApplicationCodeConfiguration as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationApplicationConfiguration as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationApplicationSnapshotConfiguration as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationCSVMappingParameters as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationCheckpointConfiguration as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationCodeContent as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationEnvironmentProperties as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationFlinkApplicationConfiguration as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationInput as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationInputLambdaProcessor as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationInputParallelism as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationInputProcessingConfiguration as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationInputSchema as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationJSONMappingParameters as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationKinesisFirehoseInput as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationKinesisStreamsInput as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationMappingParameters as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationMonitoringConfiguration as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationParallelismConfiguration as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationPropertyGroup as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationRecordColumn as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationRecordFormat as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationS3ContentLocation as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationSqlApplicationConfiguration as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationCloudWatchLoggingOptionCloudWatchLoggingOption as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationOutputDestinationSchema as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationOutputKinesisFirehoseOutput as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationOutputKinesisStreamsOutput as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationOutputLambdaOutput as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationOutputOutput as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationReferenceDataSourceCSVMappingParameters as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationReferenceDataSourceJSONMappingParameters as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationReferenceDataSourceMappingParameters as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationReferenceDataSourceRecordColumn as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationReferenceDataSourceRecordFormat as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationReferenceDataSourceReferenceDataSource as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationReferenceDataSourceReferenceSchema as X
import Stratosphere.ResourceProperties.KinesisAnalyticsV2ApplicationReferenceDataSourceS3ReferenceDataSource as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamBufferingHints as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamCloudWatchLoggingOptions as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamCopyCommand as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamDataFormatConversionConfiguration as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamDeserializer as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamElasticsearchBufferingHints as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamElasticsearchDestinationConfiguration as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamElasticsearchRetryOptions as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamEncryptionConfiguration as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamExtendedS3DestinationConfiguration as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamHiveJsonSerDe as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamInputFormatConfiguration as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamKMSEncryptionConfig as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamKinesisStreamSourceConfiguration as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamOpenXJsonSerDe as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamOrcSerDe as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamOutputFormatConfiguration as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamParquetSerDe as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamProcessingConfiguration as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamProcessor as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamProcessorParameter as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamRedshiftDestinationConfiguration as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamS3DestinationConfiguration as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamSchemaConfiguration as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamSerializer as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamSplunkDestinationConfiguration as X
import Stratosphere.ResourceProperties.KinesisFirehoseDeliveryStreamSplunkRetryOptions as X
import Stratosphere.ResourceProperties.LakeFormationDataLakeSettingsDataLakePrincipal as X
import Stratosphere.ResourceProperties.LakeFormationPermissionsDataLakePrincipal as X
import Stratosphere.ResourceProperties.LakeFormationPermissionsDatabaseResource as X
import Stratosphere.ResourceProperties.LakeFormationPermissionsResource as X
import Stratosphere.ResourceProperties.LakeFormationPermissionsTableResource as X
import Stratosphere.ResourceProperties.LambdaAliasAliasRoutingConfiguration as X
import Stratosphere.ResourceProperties.LambdaAliasVersionWeight as X
import Stratosphere.ResourceProperties.LambdaFunctionCode as X
import Stratosphere.ResourceProperties.LambdaFunctionDeadLetterConfig as X
import Stratosphere.ResourceProperties.LambdaFunctionEnvironment as X
import Stratosphere.ResourceProperties.LambdaFunctionTracingConfig as X
import Stratosphere.ResourceProperties.LambdaFunctionVpcConfig as X
import Stratosphere.ResourceProperties.LambdaLayerVersionContent as X
import Stratosphere.ResourceProperties.LogsMetricFilterMetricTransformation as X
import Stratosphere.ResourceProperties.MSKClusterBrokerNodeGroupInfo as X
import Stratosphere.ResourceProperties.MSKClusterClientAuthentication as X
import Stratosphere.ResourceProperties.MSKClusterConfigurationInfo as X
import Stratosphere.ResourceProperties.MSKClusterEBSStorageInfo as X
import Stratosphere.ResourceProperties.MSKClusterEncryptionAtRest as X
import Stratosphere.ResourceProperties.MSKClusterEncryptionInTransit as X
import Stratosphere.ResourceProperties.MSKClusterEncryptionInfo as X
import Stratosphere.ResourceProperties.MSKClusterStorageInfo as X
import Stratosphere.ResourceProperties.MSKClusterTls as X
import Stratosphere.ResourceProperties.ManagedBlockchainMemberApprovalThresholdPolicy as X
import Stratosphere.ResourceProperties.ManagedBlockchainMemberMemberConfiguration as X
import Stratosphere.ResourceProperties.ManagedBlockchainMemberMemberFabricConfiguration as X
import Stratosphere.ResourceProperties.ManagedBlockchainMemberMemberFrameworkConfiguration as X
import Stratosphere.ResourceProperties.ManagedBlockchainMemberNetworkConfiguration as X
import Stratosphere.ResourceProperties.ManagedBlockchainMemberNetworkFabricConfiguration as X
import Stratosphere.ResourceProperties.ManagedBlockchainMemberNetworkFrameworkConfiguration as X
import Stratosphere.ResourceProperties.ManagedBlockchainMemberVotingPolicy as X
import Stratosphere.ResourceProperties.ManagedBlockchainNodeNodeConfiguration as X
import Stratosphere.ResourceProperties.MediaLiveChannelAribSourceSettings as X
import Stratosphere.ResourceProperties.MediaLiveChannelAudioLanguageSelection as X
import Stratosphere.ResourceProperties.MediaLiveChannelAudioPidSelection as X
import Stratosphere.ResourceProperties.MediaLiveChannelAudioSelector as X
import Stratosphere.ResourceProperties.MediaLiveChannelAudioSelectorSettings as X
import Stratosphere.ResourceProperties.MediaLiveChannelCaptionSelector as X
import Stratosphere.ResourceProperties.MediaLiveChannelCaptionSelectorSettings as X
import Stratosphere.ResourceProperties.MediaLiveChannelDvbSubSourceSettings as X
import Stratosphere.ResourceProperties.MediaLiveChannelEmbeddedSourceSettings as X
import Stratosphere.ResourceProperties.MediaLiveChannelHlsInputSettings as X
import Stratosphere.ResourceProperties.MediaLiveChannelInputAttachment as X
import Stratosphere.ResourceProperties.MediaLiveChannelInputSettings as X
import Stratosphere.ResourceProperties.MediaLiveChannelInputSpecification as X
import Stratosphere.ResourceProperties.MediaLiveChannelMediaPackageOutputDestinationSettings as X
import Stratosphere.ResourceProperties.MediaLiveChannelNetworkInputSettings as X
import Stratosphere.ResourceProperties.MediaLiveChannelOutputDestination as X
import Stratosphere.ResourceProperties.MediaLiveChannelOutputDestinationSettings as X
import Stratosphere.ResourceProperties.MediaLiveChannelScte20SourceSettings as X
import Stratosphere.ResourceProperties.MediaLiveChannelScte27SourceSettings as X
import Stratosphere.ResourceProperties.MediaLiveChannelTeletextSourceSettings as X
import Stratosphere.ResourceProperties.MediaLiveChannelVideoSelector as X
import Stratosphere.ResourceProperties.MediaLiveChannelVideoSelectorPid as X
import Stratosphere.ResourceProperties.MediaLiveChannelVideoSelectorProgramId as X
import Stratosphere.ResourceProperties.MediaLiveChannelVideoSelectorSettings as X
import Stratosphere.ResourceProperties.MediaLiveInputInputDestinationRequest as X
import Stratosphere.ResourceProperties.MediaLiveInputInputSourceRequest as X
import Stratosphere.ResourceProperties.MediaLiveInputInputVpcRequest as X
import Stratosphere.ResourceProperties.MediaLiveInputMediaConnectFlowRequest as X
import Stratosphere.ResourceProperties.MediaLiveInputSecurityGroupInputWhitelistRuleCidr as X
import Stratosphere.ResourceProperties.MediaStoreContainerCorsRule as X
import Stratosphere.ResourceProperties.OpsWorksAppDataSource as X
import Stratosphere.ResourceProperties.OpsWorksAppEnvironmentVariable as X
import Stratosphere.ResourceProperties.OpsWorksAppSource as X
import Stratosphere.ResourceProperties.OpsWorksAppSslConfiguration as X
import Stratosphere.ResourceProperties.OpsWorksInstanceBlockDeviceMapping as X
import Stratosphere.ResourceProperties.OpsWorksInstanceEbsBlockDevice as X
import Stratosphere.ResourceProperties.OpsWorksInstanceTimeBasedAutoScaling as X
import Stratosphere.ResourceProperties.OpsWorksLayerAutoScalingThresholds as X
import Stratosphere.ResourceProperties.OpsWorksLayerLifecycleEventConfiguration as X
import Stratosphere.ResourceProperties.OpsWorksLayerLoadBasedAutoScaling as X
import Stratosphere.ResourceProperties.OpsWorksLayerRecipes as X
import Stratosphere.ResourceProperties.OpsWorksLayerShutdownEventConfiguration as X
import Stratosphere.ResourceProperties.OpsWorksLayerVolumeConfiguration as X
import Stratosphere.ResourceProperties.OpsWorksStackChefConfiguration as X
import Stratosphere.ResourceProperties.OpsWorksStackElasticIp as X
import Stratosphere.ResourceProperties.OpsWorksStackRdsDbInstance as X
import Stratosphere.ResourceProperties.OpsWorksStackSource as X
import Stratosphere.ResourceProperties.OpsWorksStackStackConfigurationManager as X
import Stratosphere.ResourceProperties.OpsWorksCMServerEngineAttribute as X
import Stratosphere.ResourceProperties.PinpointApplicationSettingsCampaignHook as X
import Stratosphere.ResourceProperties.PinpointApplicationSettingsLimits as X
import Stratosphere.ResourceProperties.PinpointApplicationSettingsQuietTime as X
import Stratosphere.ResourceProperties.PinpointCampaignAttributeDimension as X
import Stratosphere.ResourceProperties.PinpointCampaignCampaignEmailMessage as X
import Stratosphere.ResourceProperties.PinpointCampaignCampaignEventFilter as X
import Stratosphere.ResourceProperties.PinpointCampaignCampaignHook as X
import Stratosphere.ResourceProperties.PinpointCampaignCampaignSmsMessage as X
import Stratosphere.ResourceProperties.PinpointCampaignEventDimensions as X
import Stratosphere.ResourceProperties.PinpointCampaignLimits as X
import Stratosphere.ResourceProperties.PinpointCampaignMessage as X
import Stratosphere.ResourceProperties.PinpointCampaignMessageConfiguration as X
import Stratosphere.ResourceProperties.PinpointCampaignMetricDimension as X
import Stratosphere.ResourceProperties.PinpointCampaignQuietTime as X
import Stratosphere.ResourceProperties.PinpointCampaignSchedule as X
import Stratosphere.ResourceProperties.PinpointCampaignSetDimension as X
import Stratosphere.ResourceProperties.PinpointCampaignWriteTreatmentResource as X
import Stratosphere.ResourceProperties.PinpointSegmentAttributeDimension as X
import Stratosphere.ResourceProperties.PinpointSegmentBehavior as X
import Stratosphere.ResourceProperties.PinpointSegmentCoordinates as X
import Stratosphere.ResourceProperties.PinpointSegmentDemographic as X
import Stratosphere.ResourceProperties.PinpointSegmentGPSPoint as X
import Stratosphere.ResourceProperties.PinpointSegmentGroups as X
import Stratosphere.ResourceProperties.PinpointSegmentLocation as X
import Stratosphere.ResourceProperties.PinpointSegmentRecency as X
import Stratosphere.ResourceProperties.PinpointSegmentSegmentDimensions as X
import Stratosphere.ResourceProperties.PinpointSegmentSegmentGroups as X
import Stratosphere.ResourceProperties.PinpointSegmentSetDimension as X
import Stratosphere.ResourceProperties.PinpointSegmentSourceSegments as X
import Stratosphere.ResourceProperties.PinpointEmailConfigurationSetDeliveryOptions as X
import Stratosphere.ResourceProperties.PinpointEmailConfigurationSetReputationOptions as X
import Stratosphere.ResourceProperties.PinpointEmailConfigurationSetSendingOptions as X
import Stratosphere.ResourceProperties.PinpointEmailConfigurationSetTags as X
import Stratosphere.ResourceProperties.PinpointEmailConfigurationSetTrackingOptions as X
import Stratosphere.ResourceProperties.PinpointEmailConfigurationSetEventDestinationCloudWatchDestination as X
import Stratosphere.ResourceProperties.PinpointEmailConfigurationSetEventDestinationDimensionConfiguration as X
import Stratosphere.ResourceProperties.PinpointEmailConfigurationSetEventDestinationEventDestination as X
import Stratosphere.ResourceProperties.PinpointEmailConfigurationSetEventDestinationKinesisFirehoseDestination as X
import Stratosphere.ResourceProperties.PinpointEmailConfigurationSetEventDestinationPinpointDestination as X
import Stratosphere.ResourceProperties.PinpointEmailConfigurationSetEventDestinationSnsDestination as X
import Stratosphere.ResourceProperties.PinpointEmailDedicatedIpPoolTags as X
import Stratosphere.ResourceProperties.PinpointEmailIdentityMailFromAttributes as X
import Stratosphere.ResourceProperties.PinpointEmailIdentityTags as X
import Stratosphere.ResourceProperties.RDSDBClusterDBClusterRole as X
import Stratosphere.ResourceProperties.RDSDBClusterScalingConfiguration as X
import Stratosphere.ResourceProperties.RDSDBInstanceDBInstanceRole as X
import Stratosphere.ResourceProperties.RDSDBInstanceProcessorFeature as X
import Stratosphere.ResourceProperties.RDSDBSecurityGroupIngressProperty as X
import Stratosphere.ResourceProperties.RDSOptionGroupOptionConfiguration as X
import Stratosphere.ResourceProperties.RDSOptionGroupOptionSetting as X
import Stratosphere.ResourceProperties.RedshiftClusterLoggingProperties as X
import Stratosphere.ResourceProperties.RedshiftClusterParameterGroupParameter as X
import Stratosphere.ResourceProperties.RoboMakerRobotApplicationRobotSoftwareSuite as X
import Stratosphere.ResourceProperties.RoboMakerRobotApplicationSourceConfig as X
import Stratosphere.ResourceProperties.RoboMakerSimulationApplicationRenderingEngine as X
import Stratosphere.ResourceProperties.RoboMakerSimulationApplicationRobotSoftwareSuite as X
import Stratosphere.ResourceProperties.RoboMakerSimulationApplicationSimulationSoftwareSuite as X
import Stratosphere.ResourceProperties.RoboMakerSimulationApplicationSourceConfig as X
import Stratosphere.ResourceProperties.Route53HealthCheckAlarmIdentifier as X
import Stratosphere.ResourceProperties.Route53HealthCheckHealthCheckConfig as X
import Stratosphere.ResourceProperties.Route53HealthCheckHealthCheckTag as X
import Stratosphere.ResourceProperties.Route53HostedZoneHostedZoneConfig as X
import Stratosphere.ResourceProperties.Route53HostedZoneHostedZoneTag as X
import Stratosphere.ResourceProperties.Route53HostedZoneQueryLoggingConfig as X
import Stratosphere.ResourceProperties.Route53HostedZoneVPC as X
import Stratosphere.ResourceProperties.Route53RecordSetAliasTarget as X
import Stratosphere.ResourceProperties.Route53RecordSetGeoLocation as X
import Stratosphere.ResourceProperties.Route53RecordSetGroupAliasTarget as X
import Stratosphere.ResourceProperties.Route53RecordSetGroupGeoLocation as X
import Stratosphere.ResourceProperties.Route53RecordSetGroupRecordSet as X
import Stratosphere.ResourceProperties.Route53ResolverResolverEndpointIpAddressRequest as X
import Stratosphere.ResourceProperties.Route53ResolverResolverRuleTargetAddress as X
import Stratosphere.ResourceProperties.S3BucketAbortIncompleteMultipartUpload as X
import Stratosphere.ResourceProperties.S3BucketAccelerateConfiguration as X
import Stratosphere.ResourceProperties.S3BucketAccessControlTranslation as X
import Stratosphere.ResourceProperties.S3BucketAnalyticsConfiguration as X
import Stratosphere.ResourceProperties.S3BucketBucketEncryption as X
import Stratosphere.ResourceProperties.S3BucketCorsConfiguration as X
import Stratosphere.ResourceProperties.S3BucketCorsRule as X
import Stratosphere.ResourceProperties.S3BucketDataExport as X
import Stratosphere.ResourceProperties.S3BucketDefaultRetention as X
import Stratosphere.ResourceProperties.S3BucketDestination as X
import Stratosphere.ResourceProperties.S3BucketEncryptionConfiguration as X
import Stratosphere.ResourceProperties.S3BucketFilterRule as X
import Stratosphere.ResourceProperties.S3BucketInventoryConfiguration as X
import Stratosphere.ResourceProperties.S3BucketLambdaConfiguration as X
import Stratosphere.ResourceProperties.S3BucketLifecycleConfiguration as X
import Stratosphere.ResourceProperties.S3BucketLoggingConfiguration as X
import Stratosphere.ResourceProperties.S3BucketMetricsConfiguration as X
import Stratosphere.ResourceProperties.S3BucketNoncurrentVersionTransition as X
import Stratosphere.ResourceProperties.S3BucketNotificationConfiguration as X
import Stratosphere.ResourceProperties.S3BucketNotificationFilter as X
import Stratosphere.ResourceProperties.S3BucketObjectLockConfiguration as X
import Stratosphere.ResourceProperties.S3BucketObjectLockRule as X
import Stratosphere.ResourceProperties.S3BucketPublicAccessBlockConfiguration as X
import Stratosphere.ResourceProperties.S3BucketQueueConfiguration as X
import Stratosphere.ResourceProperties.S3BucketRedirectAllRequestsTo as X
import Stratosphere.ResourceProperties.S3BucketRedirectRule as X
import Stratosphere.ResourceProperties.S3BucketReplicationConfiguration as X
import Stratosphere.ResourceProperties.S3BucketReplicationDestination as X
import Stratosphere.ResourceProperties.S3BucketReplicationRule as X
import Stratosphere.ResourceProperties.S3BucketRoutingRule as X
import Stratosphere.ResourceProperties.S3BucketRoutingRuleCondition as X
import Stratosphere.ResourceProperties.S3BucketRule as X
import Stratosphere.ResourceProperties.S3BucketS3KeyFilter as X
import Stratosphere.ResourceProperties.S3BucketServerSideEncryptionByDefault as X
import Stratosphere.ResourceProperties.S3BucketServerSideEncryptionRule as X
import Stratosphere.ResourceProperties.S3BucketSourceSelectionCriteria as X
import Stratosphere.ResourceProperties.S3BucketSseKmsEncryptedObjects as X
import Stratosphere.ResourceProperties.S3BucketStorageClassAnalysis as X
import Stratosphere.ResourceProperties.S3BucketTagFilter as X
import Stratosphere.ResourceProperties.S3BucketTopicConfiguration as X
import Stratosphere.ResourceProperties.S3BucketTransition as X
import Stratosphere.ResourceProperties.S3BucketVersioningConfiguration as X
import Stratosphere.ResourceProperties.S3BucketWebsiteConfiguration as X
import Stratosphere.ResourceProperties.SESConfigurationSetEventDestinationCloudWatchDestination as X
import Stratosphere.ResourceProperties.SESConfigurationSetEventDestinationDimensionConfiguration as X
import Stratosphere.ResourceProperties.SESConfigurationSetEventDestinationEventDestination as X
import Stratosphere.ResourceProperties.SESConfigurationSetEventDestinationKinesisFirehoseDestination as X
import Stratosphere.ResourceProperties.SESReceiptFilterFilter as X
import Stratosphere.ResourceProperties.SESReceiptFilterIpFilter as X
import Stratosphere.ResourceProperties.SESReceiptRuleAction as X
import Stratosphere.ResourceProperties.SESReceiptRuleAddHeaderAction as X
import Stratosphere.ResourceProperties.SESReceiptRuleBounceAction as X
import Stratosphere.ResourceProperties.SESReceiptRuleLambdaAction as X
import Stratosphere.ResourceProperties.SESReceiptRuleRule as X
import Stratosphere.ResourceProperties.SESReceiptRuleS3Action as X
import Stratosphere.ResourceProperties.SESReceiptRuleSNSAction as X
import Stratosphere.ResourceProperties.SESReceiptRuleStopAction as X
import Stratosphere.ResourceProperties.SESReceiptRuleWorkmailAction as X
import Stratosphere.ResourceProperties.SESTemplateTemplate as X
import Stratosphere.ResourceProperties.SNSTopicSubscription as X
import Stratosphere.ResourceProperties.SSMAssociationInstanceAssociationOutputLocation as X
import Stratosphere.ResourceProperties.SSMAssociationParameterValues as X
import Stratosphere.ResourceProperties.SSMAssociationS3OutputLocation as X
import Stratosphere.ResourceProperties.SSMAssociationTarget as X
import Stratosphere.ResourceProperties.SSMMaintenanceWindowTargetTargets as X
import Stratosphere.ResourceProperties.SSMMaintenanceWindowTaskLoggingInfo as X
import Stratosphere.ResourceProperties.SSMMaintenanceWindowTaskMaintenanceWindowAutomationParameters as X
import Stratosphere.ResourceProperties.SSMMaintenanceWindowTaskMaintenanceWindowLambdaParameters as X
import Stratosphere.ResourceProperties.SSMMaintenanceWindowTaskMaintenanceWindowRunCommandParameters as X
import Stratosphere.ResourceProperties.SSMMaintenanceWindowTaskMaintenanceWindowStepFunctionsParameters as X
import Stratosphere.ResourceProperties.SSMMaintenanceWindowTaskNotificationConfig as X
import Stratosphere.ResourceProperties.SSMMaintenanceWindowTaskTarget as X
import Stratosphere.ResourceProperties.SSMMaintenanceWindowTaskTaskInvocationParameters as X
import Stratosphere.ResourceProperties.SSMPatchBaselinePatchFilter as X
import Stratosphere.ResourceProperties.SSMPatchBaselinePatchFilterGroup as X
import Stratosphere.ResourceProperties.SSMPatchBaselinePatchSource as X
import Stratosphere.ResourceProperties.SSMPatchBaselineRule as X
import Stratosphere.ResourceProperties.SSMPatchBaselineRuleGroup as X
import Stratosphere.ResourceProperties.SageMakerCodeRepositoryGitConfig as X
import Stratosphere.ResourceProperties.SageMakerEndpointConfigProductionVariant as X
import Stratosphere.ResourceProperties.SageMakerModelContainerDefinition as X
import Stratosphere.ResourceProperties.SageMakerModelVpcConfig as X
import Stratosphere.ResourceProperties.SageMakerNotebookInstanceLifecycleConfigNotebookInstanceLifecycleHook as X
import Stratosphere.ResourceProperties.SageMakerWorkteamCognitoMemberDefinition as X
import Stratosphere.ResourceProperties.SageMakerWorkteamMemberDefinition as X
import Stratosphere.ResourceProperties.SageMakerWorkteamNotificationConfiguration as X
import Stratosphere.ResourceProperties.SecretsManagerRotationScheduleRotationRules as X
import Stratosphere.ResourceProperties.SecretsManagerSecretGenerateSecretString as X
import Stratosphere.ResourceProperties.ServiceCatalogCloudFormationProductProvisioningArtifactProperties as X
import Stratosphere.ResourceProperties.ServiceCatalogCloudFormationProvisionedProductProvisioningParameter as X
import Stratosphere.ResourceProperties.ServiceCatalogCloudFormationProvisionedProductProvisioningPreferences as X
import Stratosphere.ResourceProperties.ServiceDiscoveryServiceDnsConfig as X
import Stratosphere.ResourceProperties.ServiceDiscoveryServiceDnsRecord as X
import Stratosphere.ResourceProperties.ServiceDiscoveryServiceHealthCheckConfig as X
import Stratosphere.ResourceProperties.ServiceDiscoveryServiceHealthCheckCustomConfig as X
import Stratosphere.ResourceProperties.StepFunctionsActivityTagsEntry as X
import Stratosphere.ResourceProperties.StepFunctionsStateMachineTagsEntry as X
import Stratosphere.ResourceProperties.TransferServerEndpointDetails as X
import Stratosphere.ResourceProperties.TransferServerIdentityProviderDetails as X
import Stratosphere.ResourceProperties.WAFByteMatchSetByteMatchTuple as X
import Stratosphere.ResourceProperties.WAFByteMatchSetFieldToMatch as X
import Stratosphere.ResourceProperties.WAFIPSetIPSetDescriptor as X
import Stratosphere.ResourceProperties.WAFRulePredicate as X
import Stratosphere.ResourceProperties.WAFSizeConstraintSetFieldToMatch as X
import Stratosphere.ResourceProperties.WAFSizeConstraintSetSizeConstraint as X
import Stratosphere.ResourceProperties.WAFSqlInjectionMatchSetFieldToMatch as X
import Stratosphere.ResourceProperties.WAFSqlInjectionMatchSetSqlInjectionMatchTuple as X
import Stratosphere.ResourceProperties.WAFWebACLActivatedRule as X
import Stratosphere.ResourceProperties.WAFWebACLWafAction as X
import Stratosphere.ResourceProperties.WAFXssMatchSetFieldToMatch as X
import Stratosphere.ResourceProperties.WAFXssMatchSetXssMatchTuple as X
import Stratosphere.ResourceProperties.WAFRegionalByteMatchSetByteMatchTuple as X
import Stratosphere.ResourceProperties.WAFRegionalByteMatchSetFieldToMatch as X
import Stratosphere.ResourceProperties.WAFRegionalGeoMatchSetGeoMatchConstraint as X
import Stratosphere.ResourceProperties.WAFRegionalIPSetIPSetDescriptor as X
import Stratosphere.ResourceProperties.WAFRegionalRateBasedRulePredicate as X
import Stratosphere.ResourceProperties.WAFRegionalRulePredicate as X
import Stratosphere.ResourceProperties.WAFRegionalSizeConstraintSetFieldToMatch as X
import Stratosphere.ResourceProperties.WAFRegionalSizeConstraintSetSizeConstraint as X
import Stratosphere.ResourceProperties.WAFRegionalSqlInjectionMatchSetFieldToMatch as X
import Stratosphere.ResourceProperties.WAFRegionalSqlInjectionMatchSetSqlInjectionMatchTuple as X
import Stratosphere.ResourceProperties.WAFRegionalWebACLAction as X
import Stratosphere.ResourceProperties.WAFRegionalWebACLRule as X
import Stratosphere.ResourceProperties.WAFRegionalXssMatchSetFieldToMatch as X
import Stratosphere.ResourceProperties.WAFRegionalXssMatchSetXssMatchTuple as X
import Stratosphere.ResourceProperties.WorkSpacesWorkspaceWorkspaceProperties as X
import Stratosphere.ResourceProperties.ASKSkillAuthenticationConfiguration as X
import Stratosphere.ResourceProperties.ASKSkillOverrides as X
import Stratosphere.ResourceProperties.ASKSkillSkillPackage as X
import Stratosphere.ResourceProperties.Tag as X

import Stratosphere.ResourceAttributes.AutoScalingReplacingUpdatePolicy as X
import Stratosphere.ResourceAttributes.AutoScalingRollingUpdatePolicy as X
import Stratosphere.ResourceAttributes.AutoScalingScheduledActionPolicy as X
import Stratosphere.ResourceAttributes.CreationPolicy as X
import Stratosphere.ResourceAttributes.ResourceSignal as X
import Stratosphere.ResourceAttributes.UpdatePolicy as X
import Stratosphere.Helpers
import Stratosphere.ResourceProperties
import Stratosphere.Values

data DeletionPolicy
  = Delete
  | Retain
  | Snapshot
  deriving (Show, Eq, Generic)

instance ToJSON DeletionPolicy where

data Resource =
  Resource
  { _resourceName :: T.Text
  , _resourceProperties :: ResourceProperties
  , _resourceDeletionPolicy :: Maybe DeletionPolicy
  , _resourceCreationPolicy :: Maybe CreationPolicy
  , _resourceUpdatePolicy :: Maybe UpdatePolicy
  , _resourceDependsOn :: Maybe [T.Text]
  , _resourceMetadata :: Maybe Object
  , _resourceCondition :: Maybe T.Text
  } deriving (Show, Eq)

instance ToRef Resource b where
  toRef r = Ref (_resourceName r)

-- | Convenient constructor for 'Resource' with required arguments.
resource
  :: (ToResourceProperties a)
  => T.Text -- ^ Logical name
  -> a
  -> Resource
resource rn rp =
  Resource
  { _resourceName = rn
  , _resourceProperties = toResourceProperties rp
  , _resourceDeletionPolicy = Nothing
  , _resourceCreationPolicy = Nothing
  , _resourceUpdatePolicy = Nothing
  , _resourceDependsOn = Nothing
  , _resourceMetadata = Nothing
  , _resourceCondition = Nothing
  }

$(makeLenses ''Resource)

resourceToJSON :: Resource -> Value
resourceToJSON (Resource _ props dp cp up deps meta cond) =
  object $
    resourcePropertiesJSON props ++
    catMaybes
    [ maybeField "DeletionPolicy" dp
    , maybeField "CreationPolicy" cp
    , maybeField "UpdatePolicy" up
    , maybeField "DependsOn" deps
    , maybeField "Metadata" meta
    , maybeField "Condition" cond
    ]

-- | Wrapper around a list of 'Resources's to we can modify the aeson
-- instances.
newtype Resources = Resources { unResources :: [Resource] }
  deriving (Show, Eq, Semigroup, Monoid)

instance IsList Resources where
  type Item Resources = Resource
  fromList = Resources
  toList = unResources

instance NamedItem Resource where
  itemName = _resourceName
  nameToJSON = resourceToJSON

instance ToJSON Resources where
  toJSON = namedItemToJSON . unResources
