module Stratosphere.AppConfig.Deployment (
        module Exports, Deployment(..), mkDeployment
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import {-# SOURCE #-} Stratosphere.AppConfig.Deployment.DynamicExtensionParametersProperty as Exports
import Stratosphere.ResourceProperties
import Stratosphere.Tag
import Stratosphere.Value
data Deployment
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html>
    Deployment {haddock_workaround_ :: (),
                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html#cfn-appconfig-deployment-applicationid>
                applicationId :: (Value Prelude.Text),
                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html#cfn-appconfig-deployment-configurationprofileid>
                configurationProfileId :: (Value Prelude.Text),
                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html#cfn-appconfig-deployment-configurationversion>
                configurationVersion :: (Value Prelude.Text),
                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html#cfn-appconfig-deployment-deploymentstrategyid>
                deploymentStrategyId :: (Value Prelude.Text),
                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html#cfn-appconfig-deployment-description>
                description :: (Prelude.Maybe (Value Prelude.Text)),
                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html#cfn-appconfig-deployment-dynamicextensionparameters>
                dynamicExtensionParameters :: (Prelude.Maybe [DynamicExtensionParametersProperty]),
                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html#cfn-appconfig-deployment-environmentid>
                environmentId :: (Value Prelude.Text),
                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html#cfn-appconfig-deployment-kmskeyidentifier>
                kmsKeyIdentifier :: (Prelude.Maybe (Value Prelude.Text)),
                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html#cfn-appconfig-deployment-tags>
                tags :: (Prelude.Maybe [Tag])}
  deriving stock (Prelude.Eq, Prelude.Show)
mkDeployment ::
  Value Prelude.Text
  -> Value Prelude.Text
     -> Value Prelude.Text
        -> Value Prelude.Text -> Value Prelude.Text -> Deployment
mkDeployment
  applicationId
  configurationProfileId
  configurationVersion
  deploymentStrategyId
  environmentId
  = Deployment
      {haddock_workaround_ = (), applicationId = applicationId,
       configurationProfileId = configurationProfileId,
       configurationVersion = configurationVersion,
       deploymentStrategyId = deploymentStrategyId,
       environmentId = environmentId, description = Prelude.Nothing,
       dynamicExtensionParameters = Prelude.Nothing,
       kmsKeyIdentifier = Prelude.Nothing, tags = Prelude.Nothing}
instance ToResourceProperties Deployment where
  toResourceProperties Deployment {..}
    = ResourceProperties
        {awsType = "AWS::AppConfig::Deployment",
         supportsTags = Prelude.True,
         properties = Prelude.fromList
                        ((Prelude.<>)
                           ["ApplicationId" JSON..= applicationId,
                            "ConfigurationProfileId" JSON..= configurationProfileId,
                            "ConfigurationVersion" JSON..= configurationVersion,
                            "DeploymentStrategyId" JSON..= deploymentStrategyId,
                            "EnvironmentId" JSON..= environmentId]
                           (Prelude.catMaybes
                              [(JSON..=) "Description" Prelude.<$> description,
                               (JSON..=) "DynamicExtensionParameters"
                                 Prelude.<$> dynamicExtensionParameters,
                               (JSON..=) "KmsKeyIdentifier" Prelude.<$> kmsKeyIdentifier,
                               (JSON..=) "Tags" Prelude.<$> tags]))}
instance JSON.ToJSON Deployment where
  toJSON Deployment {..}
    = JSON.object
        (Prelude.fromList
           ((Prelude.<>)
              ["ApplicationId" JSON..= applicationId,
               "ConfigurationProfileId" JSON..= configurationProfileId,
               "ConfigurationVersion" JSON..= configurationVersion,
               "DeploymentStrategyId" JSON..= deploymentStrategyId,
               "EnvironmentId" JSON..= environmentId]
              (Prelude.catMaybes
                 [(JSON..=) "Description" Prelude.<$> description,
                  (JSON..=) "DynamicExtensionParameters"
                    Prelude.<$> dynamicExtensionParameters,
                  (JSON..=) "KmsKeyIdentifier" Prelude.<$> kmsKeyIdentifier,
                  (JSON..=) "Tags" Prelude.<$> tags])))
instance Property "ApplicationId" Deployment where
  type PropertyType "ApplicationId" Deployment = Value Prelude.Text
  set newValue Deployment {..}
    = Deployment {applicationId = newValue, ..}
instance Property "ConfigurationProfileId" Deployment where
  type PropertyType "ConfigurationProfileId" Deployment = Value Prelude.Text
  set newValue Deployment {..}
    = Deployment {configurationProfileId = newValue, ..}
instance Property "ConfigurationVersion" Deployment where
  type PropertyType "ConfigurationVersion" Deployment = Value Prelude.Text
  set newValue Deployment {..}
    = Deployment {configurationVersion = newValue, ..}
instance Property "DeploymentStrategyId" Deployment where
  type PropertyType "DeploymentStrategyId" Deployment = Value Prelude.Text
  set newValue Deployment {..}
    = Deployment {deploymentStrategyId = newValue, ..}
instance Property "Description" Deployment where
  type PropertyType "Description" Deployment = Value Prelude.Text
  set newValue Deployment {..}
    = Deployment {description = Prelude.pure newValue, ..}
instance Property "DynamicExtensionParameters" Deployment where
  type PropertyType "DynamicExtensionParameters" Deployment = [DynamicExtensionParametersProperty]
  set newValue Deployment {..}
    = Deployment
        {dynamicExtensionParameters = Prelude.pure newValue, ..}
instance Property "EnvironmentId" Deployment where
  type PropertyType "EnvironmentId" Deployment = Value Prelude.Text
  set newValue Deployment {..}
    = Deployment {environmentId = newValue, ..}
instance Property "KmsKeyIdentifier" Deployment where
  type PropertyType "KmsKeyIdentifier" Deployment = Value Prelude.Text
  set newValue Deployment {..}
    = Deployment {kmsKeyIdentifier = Prelude.pure newValue, ..}
instance Property "Tags" Deployment where
  type PropertyType "Tags" Deployment = [Tag]
  set newValue Deployment {..}
    = Deployment {tags = Prelude.pure newValue, ..}