module Stratosphere.B2BI.Transformer.OutputConversionProperty (
        module Exports, OutputConversionProperty(..),
        mkOutputConversionProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import {-# SOURCE #-} Stratosphere.B2BI.Transformer.AdvancedOptionsProperty as Exports
import {-# SOURCE #-} Stratosphere.B2BI.Transformer.FormatOptionsProperty as Exports
import Stratosphere.ResourceProperties
import Stratosphere.Value
data OutputConversionProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-outputconversion.html>
    OutputConversionProperty {haddock_workaround_ :: (),
                              -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-outputconversion.html#cfn-b2bi-transformer-outputconversion-advancedoptions>
                              advancedOptions :: (Prelude.Maybe AdvancedOptionsProperty),
                              -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-outputconversion.html#cfn-b2bi-transformer-outputconversion-formatoptions>
                              formatOptions :: (Prelude.Maybe FormatOptionsProperty),
                              -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-outputconversion.html#cfn-b2bi-transformer-outputconversion-toformat>
                              toFormat :: (Value Prelude.Text)}
  deriving stock (Prelude.Eq, Prelude.Show)
mkOutputConversionProperty ::
  Value Prelude.Text -> OutputConversionProperty
mkOutputConversionProperty toFormat
  = OutputConversionProperty
      {haddock_workaround_ = (), toFormat = toFormat,
       advancedOptions = Prelude.Nothing, formatOptions = Prelude.Nothing}
instance ToResourceProperties OutputConversionProperty where
  toResourceProperties OutputConversionProperty {..}
    = ResourceProperties
        {awsType = "AWS::B2BI::Transformer.OutputConversion",
         supportsTags = Prelude.False,
         properties = Prelude.fromList
                        ((Prelude.<>)
                           ["ToFormat" JSON..= toFormat]
                           (Prelude.catMaybes
                              [(JSON..=) "AdvancedOptions" Prelude.<$> advancedOptions,
                               (JSON..=) "FormatOptions" Prelude.<$> formatOptions]))}
instance JSON.ToJSON OutputConversionProperty where
  toJSON OutputConversionProperty {..}
    = JSON.object
        (Prelude.fromList
           ((Prelude.<>)
              ["ToFormat" JSON..= toFormat]
              (Prelude.catMaybes
                 [(JSON..=) "AdvancedOptions" Prelude.<$> advancedOptions,
                  (JSON..=) "FormatOptions" Prelude.<$> formatOptions])))
instance Property "AdvancedOptions" OutputConversionProperty where
  type PropertyType "AdvancedOptions" OutputConversionProperty = AdvancedOptionsProperty
  set newValue OutputConversionProperty {..}
    = OutputConversionProperty
        {advancedOptions = Prelude.pure newValue, ..}
instance Property "FormatOptions" OutputConversionProperty where
  type PropertyType "FormatOptions" OutputConversionProperty = FormatOptionsProperty
  set newValue OutputConversionProperty {..}
    = OutputConversionProperty
        {formatOptions = Prelude.pure newValue, ..}
instance Property "ToFormat" OutputConversionProperty where
  type PropertyType "ToFormat" OutputConversionProperty = Value Prelude.Text
  set newValue OutputConversionProperty {..}
    = OutputConversionProperty {toFormat = newValue, ..}