module Stratosphere.CloudFront.Distribution.DistributionConfigProperty (
        module Exports, DistributionConfigProperty(..),
        mkDistributionConfigProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import {-# SOURCE #-} Stratosphere.CloudFront.Distribution.CacheBehaviorProperty as Exports
import {-# SOURCE #-} Stratosphere.CloudFront.Distribution.CustomErrorResponseProperty as Exports
import {-# SOURCE #-} Stratosphere.CloudFront.Distribution.DefaultCacheBehaviorProperty as Exports
import {-# SOURCE #-} Stratosphere.CloudFront.Distribution.LegacyCustomOriginProperty as Exports
import {-# SOURCE #-} Stratosphere.CloudFront.Distribution.LegacyS3OriginProperty as Exports
import {-# SOURCE #-} Stratosphere.CloudFront.Distribution.LoggingProperty as Exports
import {-# SOURCE #-} Stratosphere.CloudFront.Distribution.OriginProperty as Exports
import {-# SOURCE #-} Stratosphere.CloudFront.Distribution.OriginGroupsProperty as Exports
import {-# SOURCE #-} Stratosphere.CloudFront.Distribution.RestrictionsProperty as Exports
import {-# SOURCE #-} Stratosphere.CloudFront.Distribution.TenantConfigProperty as Exports
import {-# SOURCE #-} Stratosphere.CloudFront.Distribution.ViewerCertificateProperty as Exports
import Stratosphere.ResourceProperties
import Stratosphere.Value
data DistributionConfigProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html>
    DistributionConfigProperty {haddock_workaround_ :: (),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-aliases>
                                aliases :: (Prelude.Maybe (ValueList Prelude.Text)),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-anycastiplistid>
                                anycastIpListId :: (Prelude.Maybe (Value Prelude.Text)),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-cnames>
                                cNAMEs :: (Prelude.Maybe (ValueList Prelude.Text)),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-cachebehaviors>
                                cacheBehaviors :: (Prelude.Maybe [CacheBehaviorProperty]),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-comment>
                                comment :: (Prelude.Maybe (Value Prelude.Text)),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-connectionmode>
                                connectionMode :: (Prelude.Maybe (Value Prelude.Text)),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-continuousdeploymentpolicyid>
                                continuousDeploymentPolicyId :: (Prelude.Maybe (Value Prelude.Text)),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-customerrorresponses>
                                customErrorResponses :: (Prelude.Maybe [CustomErrorResponseProperty]),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-customorigin>
                                customOrigin :: (Prelude.Maybe LegacyCustomOriginProperty),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-defaultcachebehavior>
                                defaultCacheBehavior :: DefaultCacheBehaviorProperty,
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-defaultrootobject>
                                defaultRootObject :: (Prelude.Maybe (Value Prelude.Text)),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-enabled>
                                enabled :: (Value Prelude.Bool),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-httpversion>
                                httpVersion :: (Prelude.Maybe (Value Prelude.Text)),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-ipv6enabled>
                                iPV6Enabled :: (Prelude.Maybe (Value Prelude.Bool)),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-logging>
                                logging :: (Prelude.Maybe LoggingProperty),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-origingroups>
                                originGroups :: (Prelude.Maybe OriginGroupsProperty),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-origins>
                                origins :: (Prelude.Maybe [OriginProperty]),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-priceclass>
                                priceClass :: (Prelude.Maybe (Value Prelude.Text)),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-restrictions>
                                restrictions :: (Prelude.Maybe RestrictionsProperty),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-s3origin>
                                s3Origin :: (Prelude.Maybe LegacyS3OriginProperty),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-staging>
                                staging :: (Prelude.Maybe (Value Prelude.Bool)),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-tenantconfig>
                                tenantConfig :: (Prelude.Maybe TenantConfigProperty),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-viewercertificate>
                                viewerCertificate :: (Prelude.Maybe ViewerCertificateProperty),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-webaclid>
                                webACLId :: (Prelude.Maybe (Value Prelude.Text))}
  deriving stock (Prelude.Eq, Prelude.Show)
mkDistributionConfigProperty ::
  DefaultCacheBehaviorProperty
  -> Value Prelude.Bool -> DistributionConfigProperty
mkDistributionConfigProperty defaultCacheBehavior enabled
  = DistributionConfigProperty
      {haddock_workaround_ = (),
       defaultCacheBehavior = defaultCacheBehavior, enabled = enabled,
       aliases = Prelude.Nothing, anycastIpListId = Prelude.Nothing,
       cNAMEs = Prelude.Nothing, cacheBehaviors = Prelude.Nothing,
       comment = Prelude.Nothing, connectionMode = Prelude.Nothing,
       continuousDeploymentPolicyId = Prelude.Nothing,
       customErrorResponses = Prelude.Nothing,
       customOrigin = Prelude.Nothing,
       defaultRootObject = Prelude.Nothing, httpVersion = Prelude.Nothing,
       iPV6Enabled = Prelude.Nothing, logging = Prelude.Nothing,
       originGroups = Prelude.Nothing, origins = Prelude.Nothing,
       priceClass = Prelude.Nothing, restrictions = Prelude.Nothing,
       s3Origin = Prelude.Nothing, staging = Prelude.Nothing,
       tenantConfig = Prelude.Nothing,
       viewerCertificate = Prelude.Nothing, webACLId = Prelude.Nothing}
instance ToResourceProperties DistributionConfigProperty where
  toResourceProperties DistributionConfigProperty {..}
    = ResourceProperties
        {awsType = "AWS::CloudFront::Distribution.DistributionConfig",
         supportsTags = Prelude.False,
         properties = Prelude.fromList
                        ((Prelude.<>)
                           ["DefaultCacheBehavior" JSON..= defaultCacheBehavior,
                            "Enabled" JSON..= enabled]
                           (Prelude.catMaybes
                              [(JSON..=) "Aliases" Prelude.<$> aliases,
                               (JSON..=) "AnycastIpListId" Prelude.<$> anycastIpListId,
                               (JSON..=) "CNAMEs" Prelude.<$> cNAMEs,
                               (JSON..=) "CacheBehaviors" Prelude.<$> cacheBehaviors,
                               (JSON..=) "Comment" Prelude.<$> comment,
                               (JSON..=) "ConnectionMode" Prelude.<$> connectionMode,
                               (JSON..=) "ContinuousDeploymentPolicyId"
                                 Prelude.<$> continuousDeploymentPolicyId,
                               (JSON..=) "CustomErrorResponses" Prelude.<$> customErrorResponses,
                               (JSON..=) "CustomOrigin" Prelude.<$> customOrigin,
                               (JSON..=) "DefaultRootObject" Prelude.<$> defaultRootObject,
                               (JSON..=) "HttpVersion" Prelude.<$> httpVersion,
                               (JSON..=) "IPV6Enabled" Prelude.<$> iPV6Enabled,
                               (JSON..=) "Logging" Prelude.<$> logging,
                               (JSON..=) "OriginGroups" Prelude.<$> originGroups,
                               (JSON..=) "Origins" Prelude.<$> origins,
                               (JSON..=) "PriceClass" Prelude.<$> priceClass,
                               (JSON..=) "Restrictions" Prelude.<$> restrictions,
                               (JSON..=) "S3Origin" Prelude.<$> s3Origin,
                               (JSON..=) "Staging" Prelude.<$> staging,
                               (JSON..=) "TenantConfig" Prelude.<$> tenantConfig,
                               (JSON..=) "ViewerCertificate" Prelude.<$> viewerCertificate,
                               (JSON..=) "WebACLId" Prelude.<$> webACLId]))}
instance JSON.ToJSON DistributionConfigProperty where
  toJSON DistributionConfigProperty {..}
    = JSON.object
        (Prelude.fromList
           ((Prelude.<>)
              ["DefaultCacheBehavior" JSON..= defaultCacheBehavior,
               "Enabled" JSON..= enabled]
              (Prelude.catMaybes
                 [(JSON..=) "Aliases" Prelude.<$> aliases,
                  (JSON..=) "AnycastIpListId" Prelude.<$> anycastIpListId,
                  (JSON..=) "CNAMEs" Prelude.<$> cNAMEs,
                  (JSON..=) "CacheBehaviors" Prelude.<$> cacheBehaviors,
                  (JSON..=) "Comment" Prelude.<$> comment,
                  (JSON..=) "ConnectionMode" Prelude.<$> connectionMode,
                  (JSON..=) "ContinuousDeploymentPolicyId"
                    Prelude.<$> continuousDeploymentPolicyId,
                  (JSON..=) "CustomErrorResponses" Prelude.<$> customErrorResponses,
                  (JSON..=) "CustomOrigin" Prelude.<$> customOrigin,
                  (JSON..=) "DefaultRootObject" Prelude.<$> defaultRootObject,
                  (JSON..=) "HttpVersion" Prelude.<$> httpVersion,
                  (JSON..=) "IPV6Enabled" Prelude.<$> iPV6Enabled,
                  (JSON..=) "Logging" Prelude.<$> logging,
                  (JSON..=) "OriginGroups" Prelude.<$> originGroups,
                  (JSON..=) "Origins" Prelude.<$> origins,
                  (JSON..=) "PriceClass" Prelude.<$> priceClass,
                  (JSON..=) "Restrictions" Prelude.<$> restrictions,
                  (JSON..=) "S3Origin" Prelude.<$> s3Origin,
                  (JSON..=) "Staging" Prelude.<$> staging,
                  (JSON..=) "TenantConfig" Prelude.<$> tenantConfig,
                  (JSON..=) "ViewerCertificate" Prelude.<$> viewerCertificate,
                  (JSON..=) "WebACLId" Prelude.<$> webACLId])))
instance Property "Aliases" DistributionConfigProperty where
  type PropertyType "Aliases" DistributionConfigProperty = ValueList Prelude.Text
  set newValue DistributionConfigProperty {..}
    = DistributionConfigProperty {aliases = Prelude.pure newValue, ..}
instance Property "AnycastIpListId" DistributionConfigProperty where
  type PropertyType "AnycastIpListId" DistributionConfigProperty = Value Prelude.Text
  set newValue DistributionConfigProperty {..}
    = DistributionConfigProperty
        {anycastIpListId = Prelude.pure newValue, ..}
instance Property "CNAMEs" DistributionConfigProperty where
  type PropertyType "CNAMEs" DistributionConfigProperty = ValueList Prelude.Text
  set newValue DistributionConfigProperty {..}
    = DistributionConfigProperty {cNAMEs = Prelude.pure newValue, ..}
instance Property "CacheBehaviors" DistributionConfigProperty where
  type PropertyType "CacheBehaviors" DistributionConfigProperty = [CacheBehaviorProperty]
  set newValue DistributionConfigProperty {..}
    = DistributionConfigProperty
        {cacheBehaviors = Prelude.pure newValue, ..}
instance Property "Comment" DistributionConfigProperty where
  type PropertyType "Comment" DistributionConfigProperty = Value Prelude.Text
  set newValue DistributionConfigProperty {..}
    = DistributionConfigProperty {comment = Prelude.pure newValue, ..}
instance Property "ConnectionMode" DistributionConfigProperty where
  type PropertyType "ConnectionMode" DistributionConfigProperty = Value Prelude.Text
  set newValue DistributionConfigProperty {..}
    = DistributionConfigProperty
        {connectionMode = Prelude.pure newValue, ..}
instance Property "ContinuousDeploymentPolicyId" DistributionConfigProperty where
  type PropertyType "ContinuousDeploymentPolicyId" DistributionConfigProperty = Value Prelude.Text
  set newValue DistributionConfigProperty {..}
    = DistributionConfigProperty
        {continuousDeploymentPolicyId = Prelude.pure newValue, ..}
instance Property "CustomErrorResponses" DistributionConfigProperty where
  type PropertyType "CustomErrorResponses" DistributionConfigProperty = [CustomErrorResponseProperty]
  set newValue DistributionConfigProperty {..}
    = DistributionConfigProperty
        {customErrorResponses = Prelude.pure newValue, ..}
instance Property "CustomOrigin" DistributionConfigProperty where
  type PropertyType "CustomOrigin" DistributionConfigProperty = LegacyCustomOriginProperty
  set newValue DistributionConfigProperty {..}
    = DistributionConfigProperty
        {customOrigin = Prelude.pure newValue, ..}
instance Property "DefaultCacheBehavior" DistributionConfigProperty where
  type PropertyType "DefaultCacheBehavior" DistributionConfigProperty = DefaultCacheBehaviorProperty
  set newValue DistributionConfigProperty {..}
    = DistributionConfigProperty {defaultCacheBehavior = newValue, ..}
instance Property "DefaultRootObject" DistributionConfigProperty where
  type PropertyType "DefaultRootObject" DistributionConfigProperty = Value Prelude.Text
  set newValue DistributionConfigProperty {..}
    = DistributionConfigProperty
        {defaultRootObject = Prelude.pure newValue, ..}
instance Property "Enabled" DistributionConfigProperty where
  type PropertyType "Enabled" DistributionConfigProperty = Value Prelude.Bool
  set newValue DistributionConfigProperty {..}
    = DistributionConfigProperty {enabled = newValue, ..}
instance Property "HttpVersion" DistributionConfigProperty where
  type PropertyType "HttpVersion" DistributionConfigProperty = Value Prelude.Text
  set newValue DistributionConfigProperty {..}
    = DistributionConfigProperty
        {httpVersion = Prelude.pure newValue, ..}
instance Property "IPV6Enabled" DistributionConfigProperty where
  type PropertyType "IPV6Enabled" DistributionConfigProperty = Value Prelude.Bool
  set newValue DistributionConfigProperty {..}
    = DistributionConfigProperty
        {iPV6Enabled = Prelude.pure newValue, ..}
instance Property "Logging" DistributionConfigProperty where
  type PropertyType "Logging" DistributionConfigProperty = LoggingProperty
  set newValue DistributionConfigProperty {..}
    = DistributionConfigProperty {logging = Prelude.pure newValue, ..}
instance Property "OriginGroups" DistributionConfigProperty where
  type PropertyType "OriginGroups" DistributionConfigProperty = OriginGroupsProperty
  set newValue DistributionConfigProperty {..}
    = DistributionConfigProperty
        {originGroups = Prelude.pure newValue, ..}
instance Property "Origins" DistributionConfigProperty where
  type PropertyType "Origins" DistributionConfigProperty = [OriginProperty]
  set newValue DistributionConfigProperty {..}
    = DistributionConfigProperty {origins = Prelude.pure newValue, ..}
instance Property "PriceClass" DistributionConfigProperty where
  type PropertyType "PriceClass" DistributionConfigProperty = Value Prelude.Text
  set newValue DistributionConfigProperty {..}
    = DistributionConfigProperty
        {priceClass = Prelude.pure newValue, ..}
instance Property "Restrictions" DistributionConfigProperty where
  type PropertyType "Restrictions" DistributionConfigProperty = RestrictionsProperty
  set newValue DistributionConfigProperty {..}
    = DistributionConfigProperty
        {restrictions = Prelude.pure newValue, ..}
instance Property "S3Origin" DistributionConfigProperty where
  type PropertyType "S3Origin" DistributionConfigProperty = LegacyS3OriginProperty
  set newValue DistributionConfigProperty {..}
    = DistributionConfigProperty {s3Origin = Prelude.pure newValue, ..}
instance Property "Staging" DistributionConfigProperty where
  type PropertyType "Staging" DistributionConfigProperty = Value Prelude.Bool
  set newValue DistributionConfigProperty {..}
    = DistributionConfigProperty {staging = Prelude.pure newValue, ..}
instance Property "TenantConfig" DistributionConfigProperty where
  type PropertyType "TenantConfig" DistributionConfigProperty = TenantConfigProperty
  set newValue DistributionConfigProperty {..}
    = DistributionConfigProperty
        {tenantConfig = Prelude.pure newValue, ..}
instance Property "ViewerCertificate" DistributionConfigProperty where
  type PropertyType "ViewerCertificate" DistributionConfigProperty = ViewerCertificateProperty
  set newValue DistributionConfigProperty {..}
    = DistributionConfigProperty
        {viewerCertificate = Prelude.pure newValue, ..}
instance Property "WebACLId" DistributionConfigProperty where
  type PropertyType "WebACLId" DistributionConfigProperty = Value Prelude.Text
  set newValue DistributionConfigProperty {..}
    = DistributionConfigProperty {webACLId = Prelude.pure newValue, ..}