module Stratosphere.Connect.PhoneNumber (
        PhoneNumber(..), mkPhoneNumber
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import Stratosphere.ResourceProperties
import Stratosphere.Tag
import Stratosphere.Value
data PhoneNumber
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-phonenumber.html>
    PhoneNumber {haddock_workaround_ :: (),
                 -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-phonenumber.html#cfn-connect-phonenumber-countrycode>
                 countryCode :: (Prelude.Maybe (Value Prelude.Text)),
                 -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-phonenumber.html#cfn-connect-phonenumber-description>
                 description :: (Prelude.Maybe (Value Prelude.Text)),
                 -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-phonenumber.html#cfn-connect-phonenumber-prefix>
                 prefix :: (Prelude.Maybe (Value Prelude.Text)),
                 -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-phonenumber.html#cfn-connect-phonenumber-sourcephonenumberarn>
                 sourcePhoneNumberArn :: (Prelude.Maybe (Value Prelude.Text)),
                 -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-phonenumber.html#cfn-connect-phonenumber-tags>
                 tags :: (Prelude.Maybe [Tag]),
                 -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-phonenumber.html#cfn-connect-phonenumber-targetarn>
                 targetArn :: (Value Prelude.Text),
                 -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-phonenumber.html#cfn-connect-phonenumber-type>
                 type' :: (Prelude.Maybe (Value Prelude.Text))}
  deriving stock (Prelude.Eq, Prelude.Show)
mkPhoneNumber :: Value Prelude.Text -> PhoneNumber
mkPhoneNumber targetArn
  = PhoneNumber
      {haddock_workaround_ = (), targetArn = targetArn,
       countryCode = Prelude.Nothing, description = Prelude.Nothing,
       prefix = Prelude.Nothing, sourcePhoneNumberArn = Prelude.Nothing,
       tags = Prelude.Nothing, type' = Prelude.Nothing}
instance ToResourceProperties PhoneNumber where
  toResourceProperties PhoneNumber {..}
    = ResourceProperties
        {awsType = "AWS::Connect::PhoneNumber",
         supportsTags = Prelude.True,
         properties = Prelude.fromList
                        ((Prelude.<>)
                           ["TargetArn" JSON..= targetArn]
                           (Prelude.catMaybes
                              [(JSON..=) "CountryCode" Prelude.<$> countryCode,
                               (JSON..=) "Description" Prelude.<$> description,
                               (JSON..=) "Prefix" Prelude.<$> prefix,
                               (JSON..=) "SourcePhoneNumberArn" Prelude.<$> sourcePhoneNumberArn,
                               (JSON..=) "Tags" Prelude.<$> tags,
                               (JSON..=) "Type" Prelude.<$> type']))}
instance JSON.ToJSON PhoneNumber where
  toJSON PhoneNumber {..}
    = JSON.object
        (Prelude.fromList
           ((Prelude.<>)
              ["TargetArn" JSON..= targetArn]
              (Prelude.catMaybes
                 [(JSON..=) "CountryCode" Prelude.<$> countryCode,
                  (JSON..=) "Description" Prelude.<$> description,
                  (JSON..=) "Prefix" Prelude.<$> prefix,
                  (JSON..=) "SourcePhoneNumberArn" Prelude.<$> sourcePhoneNumberArn,
                  (JSON..=) "Tags" Prelude.<$> tags,
                  (JSON..=) "Type" Prelude.<$> type'])))
instance Property "CountryCode" PhoneNumber where
  type PropertyType "CountryCode" PhoneNumber = Value Prelude.Text
  set newValue PhoneNumber {..}
    = PhoneNumber {countryCode = Prelude.pure newValue, ..}
instance Property "Description" PhoneNumber where
  type PropertyType "Description" PhoneNumber = Value Prelude.Text
  set newValue PhoneNumber {..}
    = PhoneNumber {description = Prelude.pure newValue, ..}
instance Property "Prefix" PhoneNumber where
  type PropertyType "Prefix" PhoneNumber = Value Prelude.Text
  set newValue PhoneNumber {..}
    = PhoneNumber {prefix = Prelude.pure newValue, ..}
instance Property "SourcePhoneNumberArn" PhoneNumber where
  type PropertyType "SourcePhoneNumberArn" PhoneNumber = Value Prelude.Text
  set newValue PhoneNumber {..}
    = PhoneNumber {sourcePhoneNumberArn = Prelude.pure newValue, ..}
instance Property "Tags" PhoneNumber where
  type PropertyType "Tags" PhoneNumber = [Tag]
  set newValue PhoneNumber {..}
    = PhoneNumber {tags = Prelude.pure newValue, ..}
instance Property "TargetArn" PhoneNumber where
  type PropertyType "TargetArn" PhoneNumber = Value Prelude.Text
  set newValue PhoneNumber {..}
    = PhoneNumber {targetArn = newValue, ..}
instance Property "Type" PhoneNumber where
  type PropertyType "Type" PhoneNumber = Value Prelude.Text
  set newValue PhoneNumber {..}
    = PhoneNumber {type' = Prelude.pure newValue, ..}