module Stratosphere.GuardDuty.MalwareProtectionPlan.CFNTaggingProperty (
        CFNTaggingProperty(..), mkCFNTaggingProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import Stratosphere.ResourceProperties
import Stratosphere.Value
data CFNTaggingProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-malwareprotectionplan-cfntagging.html>
    CFNTaggingProperty {haddock_workaround_ :: (),
                        -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-malwareprotectionplan-cfntagging.html#cfn-guardduty-malwareprotectionplan-cfntagging-status>
                        status :: (Prelude.Maybe (Value Prelude.Text))}
  deriving stock (Prelude.Eq, Prelude.Show)
mkCFNTaggingProperty :: CFNTaggingProperty
mkCFNTaggingProperty
  = CFNTaggingProperty
      {haddock_workaround_ = (), status = Prelude.Nothing}
instance ToResourceProperties CFNTaggingProperty where
  toResourceProperties CFNTaggingProperty {..}
    = ResourceProperties
        {awsType = "AWS::GuardDuty::MalwareProtectionPlan.CFNTagging",
         supportsTags = Prelude.False,
         properties = Prelude.fromList
                        (Prelude.catMaybes [(JSON..=) "Status" Prelude.<$> status])}
instance JSON.ToJSON CFNTaggingProperty where
  toJSON CFNTaggingProperty {..}
    = JSON.object
        (Prelude.fromList
           (Prelude.catMaybes [(JSON..=) "Status" Prelude.<$> status]))
instance Property "Status" CFNTaggingProperty where
  type PropertyType "Status" CFNTaggingProperty = Value Prelude.Text
  set newValue CFNTaggingProperty {..}
    = CFNTaggingProperty {status = Prelude.pure newValue, ..}