module Stratosphere.GuardDuty.MalwareProtectionPlan (
        module Exports, MalwareProtectionPlan(..), mkMalwareProtectionPlan
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import {-# SOURCE #-} Stratosphere.GuardDuty.MalwareProtectionPlan.CFNActionsProperty as Exports
import {-# SOURCE #-} Stratosphere.GuardDuty.MalwareProtectionPlan.CFNProtectedResourceProperty as Exports
import {-# SOURCE #-} Stratosphere.GuardDuty.MalwareProtectionPlan.TagItemProperty as Exports
import Stratosphere.ResourceProperties
import Stratosphere.Value
data MalwareProtectionPlan
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-malwareprotectionplan.html>
    MalwareProtectionPlan {haddock_workaround_ :: (),
                           -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-malwareprotectionplan.html#cfn-guardduty-malwareprotectionplan-actions>
                           actions :: (Prelude.Maybe CFNActionsProperty),
                           -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-malwareprotectionplan.html#cfn-guardduty-malwareprotectionplan-protectedresource>
                           protectedResource :: CFNProtectedResourceProperty,
                           -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-malwareprotectionplan.html#cfn-guardduty-malwareprotectionplan-role>
                           role :: (Value Prelude.Text),
                           -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-malwareprotectionplan.html#cfn-guardduty-malwareprotectionplan-tags>
                           tags :: (Prelude.Maybe [TagItemProperty])}
  deriving stock (Prelude.Eq, Prelude.Show)
mkMalwareProtectionPlan ::
  CFNProtectedResourceProperty
  -> Value Prelude.Text -> MalwareProtectionPlan
mkMalwareProtectionPlan protectedResource role
  = MalwareProtectionPlan
      {haddock_workaround_ = (), protectedResource = protectedResource,
       role = role, actions = Prelude.Nothing, tags = Prelude.Nothing}
instance ToResourceProperties MalwareProtectionPlan where
  toResourceProperties MalwareProtectionPlan {..}
    = ResourceProperties
        {awsType = "AWS::GuardDuty::MalwareProtectionPlan",
         supportsTags = Prelude.True,
         properties = Prelude.fromList
                        ((Prelude.<>)
                           ["ProtectedResource" JSON..= protectedResource,
                            "Role" JSON..= role]
                           (Prelude.catMaybes
                              [(JSON..=) "Actions" Prelude.<$> actions,
                               (JSON..=) "Tags" Prelude.<$> tags]))}
instance JSON.ToJSON MalwareProtectionPlan where
  toJSON MalwareProtectionPlan {..}
    = JSON.object
        (Prelude.fromList
           ((Prelude.<>)
              ["ProtectedResource" JSON..= protectedResource,
               "Role" JSON..= role]
              (Prelude.catMaybes
                 [(JSON..=) "Actions" Prelude.<$> actions,
                  (JSON..=) "Tags" Prelude.<$> tags])))
instance Property "Actions" MalwareProtectionPlan where
  type PropertyType "Actions" MalwareProtectionPlan = CFNActionsProperty
  set newValue MalwareProtectionPlan {..}
    = MalwareProtectionPlan {actions = Prelude.pure newValue, ..}
instance Property "ProtectedResource" MalwareProtectionPlan where
  type PropertyType "ProtectedResource" MalwareProtectionPlan = CFNProtectedResourceProperty
  set newValue MalwareProtectionPlan {..}
    = MalwareProtectionPlan {protectedResource = newValue, ..}
instance Property "Role" MalwareProtectionPlan where
  type PropertyType "Role" MalwareProtectionPlan = Value Prelude.Text
  set newValue MalwareProtectionPlan {..}
    = MalwareProtectionPlan {role = newValue, ..}
instance Property "Tags" MalwareProtectionPlan where
  type PropertyType "Tags" MalwareProtectionPlan = [TagItemProperty]
  set newValue MalwareProtectionPlan {..}
    = MalwareProtectionPlan {tags = Prelude.pure newValue, ..}