module Stratosphere.MediaLive.Channel.AudioLanguageSelectionProperty (
        AudioLanguageSelectionProperty(..),
        mkAudioLanguageSelectionProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import Stratosphere.ResourceProperties
import Stratosphere.Value
data AudioLanguageSelectionProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiolanguageselection.html>
    AudioLanguageSelectionProperty {haddock_workaround_ :: (),
                                    -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiolanguageselection.html#cfn-medialive-channel-audiolanguageselection-languagecode>
                                    languageCode :: (Prelude.Maybe (Value Prelude.Text)),
                                    -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiolanguageselection.html#cfn-medialive-channel-audiolanguageselection-languageselectionpolicy>
                                    languageSelectionPolicy :: (Prelude.Maybe (Value Prelude.Text))}
  deriving stock (Prelude.Eq, Prelude.Show)
mkAudioLanguageSelectionProperty :: AudioLanguageSelectionProperty
mkAudioLanguageSelectionProperty
  = AudioLanguageSelectionProperty
      {haddock_workaround_ = (), languageCode = Prelude.Nothing,
       languageSelectionPolicy = Prelude.Nothing}
instance ToResourceProperties AudioLanguageSelectionProperty where
  toResourceProperties AudioLanguageSelectionProperty {..}
    = ResourceProperties
        {awsType = "AWS::MediaLive::Channel.AudioLanguageSelection",
         supportsTags = Prelude.False,
         properties = Prelude.fromList
                        (Prelude.catMaybes
                           [(JSON..=) "LanguageCode" Prelude.<$> languageCode,
                            (JSON..=) "LanguageSelectionPolicy"
                              Prelude.<$> languageSelectionPolicy])}
instance JSON.ToJSON AudioLanguageSelectionProperty where
  toJSON AudioLanguageSelectionProperty {..}
    = JSON.object
        (Prelude.fromList
           (Prelude.catMaybes
              [(JSON..=) "LanguageCode" Prelude.<$> languageCode,
               (JSON..=) "LanguageSelectionPolicy"
                 Prelude.<$> languageSelectionPolicy]))
instance Property "LanguageCode" AudioLanguageSelectionProperty where
  type PropertyType "LanguageCode" AudioLanguageSelectionProperty = Value Prelude.Text
  set newValue AudioLanguageSelectionProperty {..}
    = AudioLanguageSelectionProperty
        {languageCode = Prelude.pure newValue, ..}
instance Property "LanguageSelectionPolicy" AudioLanguageSelectionProperty where
  type PropertyType "LanguageSelectionPolicy" AudioLanguageSelectionProperty = Value Prelude.Text
  set newValue AudioLanguageSelectionProperty {..}
    = AudioLanguageSelectionProperty
        {languageSelectionPolicy = Prelude.pure newValue, ..}