module Stratosphere.QuickSight.Analysis.WordCloudChartConfigurationProperty (
        module Exports, WordCloudChartConfigurationProperty(..),
        mkWordCloudChartConfigurationProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import {-# SOURCE #-} Stratosphere.QuickSight.Analysis.ChartAxisLabelOptionsProperty as Exports
import {-# SOURCE #-} Stratosphere.QuickSight.Analysis.VisualInteractionOptionsProperty as Exports
import {-# SOURCE #-} Stratosphere.QuickSight.Analysis.WordCloudFieldWellsProperty as Exports
import {-# SOURCE #-} Stratosphere.QuickSight.Analysis.WordCloudOptionsProperty as Exports
import {-# SOURCE #-} Stratosphere.QuickSight.Analysis.WordCloudSortConfigurationProperty as Exports
import Stratosphere.ResourceProperties
data WordCloudChartConfigurationProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudchartconfiguration.html>
    WordCloudChartConfigurationProperty {haddock_workaround_ :: (),
                                         -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudchartconfiguration.html#cfn-quicksight-analysis-wordcloudchartconfiguration-categorylabeloptions>
                                         categoryLabelOptions :: (Prelude.Maybe ChartAxisLabelOptionsProperty),
                                         -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudchartconfiguration.html#cfn-quicksight-analysis-wordcloudchartconfiguration-fieldwells>
                                         fieldWells :: (Prelude.Maybe WordCloudFieldWellsProperty),
                                         -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudchartconfiguration.html#cfn-quicksight-analysis-wordcloudchartconfiguration-interactions>
                                         interactions :: (Prelude.Maybe VisualInteractionOptionsProperty),
                                         -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudchartconfiguration.html#cfn-quicksight-analysis-wordcloudchartconfiguration-sortconfiguration>
                                         sortConfiguration :: (Prelude.Maybe WordCloudSortConfigurationProperty),
                                         -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudchartconfiguration.html#cfn-quicksight-analysis-wordcloudchartconfiguration-wordcloudoptions>
                                         wordCloudOptions :: (Prelude.Maybe WordCloudOptionsProperty)}
  deriving stock (Prelude.Eq, Prelude.Show)
mkWordCloudChartConfigurationProperty ::
  WordCloudChartConfigurationProperty
mkWordCloudChartConfigurationProperty
  = WordCloudChartConfigurationProperty
      {haddock_workaround_ = (), categoryLabelOptions = Prelude.Nothing,
       fieldWells = Prelude.Nothing, interactions = Prelude.Nothing,
       sortConfiguration = Prelude.Nothing,
       wordCloudOptions = Prelude.Nothing}
instance ToResourceProperties WordCloudChartConfigurationProperty where
  toResourceProperties WordCloudChartConfigurationProperty {..}
    = ResourceProperties
        {awsType = "AWS::QuickSight::Analysis.WordCloudChartConfiguration",
         supportsTags = Prelude.False,
         properties = Prelude.fromList
                        (Prelude.catMaybes
                           [(JSON..=) "CategoryLabelOptions" Prelude.<$> categoryLabelOptions,
                            (JSON..=) "FieldWells" Prelude.<$> fieldWells,
                            (JSON..=) "Interactions" Prelude.<$> interactions,
                            (JSON..=) "SortConfiguration" Prelude.<$> sortConfiguration,
                            (JSON..=) "WordCloudOptions" Prelude.<$> wordCloudOptions])}
instance JSON.ToJSON WordCloudChartConfigurationProperty where
  toJSON WordCloudChartConfigurationProperty {..}
    = JSON.object
        (Prelude.fromList
           (Prelude.catMaybes
              [(JSON..=) "CategoryLabelOptions" Prelude.<$> categoryLabelOptions,
               (JSON..=) "FieldWells" Prelude.<$> fieldWells,
               (JSON..=) "Interactions" Prelude.<$> interactions,
               (JSON..=) "SortConfiguration" Prelude.<$> sortConfiguration,
               (JSON..=) "WordCloudOptions" Prelude.<$> wordCloudOptions]))
instance Property "CategoryLabelOptions" WordCloudChartConfigurationProperty where
  type PropertyType "CategoryLabelOptions" WordCloudChartConfigurationProperty = ChartAxisLabelOptionsProperty
  set newValue WordCloudChartConfigurationProperty {..}
    = WordCloudChartConfigurationProperty
        {categoryLabelOptions = Prelude.pure newValue, ..}
instance Property "FieldWells" WordCloudChartConfigurationProperty where
  type PropertyType "FieldWells" WordCloudChartConfigurationProperty = WordCloudFieldWellsProperty
  set newValue WordCloudChartConfigurationProperty {..}
    = WordCloudChartConfigurationProperty
        {fieldWells = Prelude.pure newValue, ..}
instance Property "Interactions" WordCloudChartConfigurationProperty where
  type PropertyType "Interactions" WordCloudChartConfigurationProperty = VisualInteractionOptionsProperty
  set newValue WordCloudChartConfigurationProperty {..}
    = WordCloudChartConfigurationProperty
        {interactions = Prelude.pure newValue, ..}
instance Property "SortConfiguration" WordCloudChartConfigurationProperty where
  type PropertyType "SortConfiguration" WordCloudChartConfigurationProperty = WordCloudSortConfigurationProperty
  set newValue WordCloudChartConfigurationProperty {..}
    = WordCloudChartConfigurationProperty
        {sortConfiguration = Prelude.pure newValue, ..}
instance Property "WordCloudOptions" WordCloudChartConfigurationProperty where
  type PropertyType "WordCloudOptions" WordCloudChartConfigurationProperty = WordCloudOptionsProperty
  set newValue WordCloudChartConfigurationProperty {..}
    = WordCloudChartConfigurationProperty
        {wordCloudOptions = Prelude.pure newValue, ..}