module Stratosphere.QuickSight.Dashboard.IntegerParameterDeclarationProperty (
        module Exports, IntegerParameterDeclarationProperty(..),
        mkIntegerParameterDeclarationProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import {-# SOURCE #-} Stratosphere.QuickSight.Dashboard.IntegerDefaultValuesProperty as Exports
import {-# SOURCE #-} Stratosphere.QuickSight.Dashboard.IntegerValueWhenUnsetConfigurationProperty as Exports
import {-# SOURCE #-} Stratosphere.QuickSight.Dashboard.MappedDataSetParameterProperty as Exports
import Stratosphere.ResourceProperties
import Stratosphere.Value
data IntegerParameterDeclarationProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-integerparameterdeclaration.html>
    IntegerParameterDeclarationProperty {haddock_workaround_ :: (),
                                         -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-integerparameterdeclaration.html#cfn-quicksight-dashboard-integerparameterdeclaration-defaultvalues>
                                         defaultValues :: (Prelude.Maybe IntegerDefaultValuesProperty),
                                         -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-integerparameterdeclaration.html#cfn-quicksight-dashboard-integerparameterdeclaration-mappeddatasetparameters>
                                         mappedDataSetParameters :: (Prelude.Maybe [MappedDataSetParameterProperty]),
                                         -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-integerparameterdeclaration.html#cfn-quicksight-dashboard-integerparameterdeclaration-name>
                                         name :: (Value Prelude.Text),
                                         -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-integerparameterdeclaration.html#cfn-quicksight-dashboard-integerparameterdeclaration-parametervaluetype>
                                         parameterValueType :: (Value Prelude.Text),
                                         -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-integerparameterdeclaration.html#cfn-quicksight-dashboard-integerparameterdeclaration-valuewhenunset>
                                         valueWhenUnset :: (Prelude.Maybe IntegerValueWhenUnsetConfigurationProperty)}
  deriving stock (Prelude.Eq, Prelude.Show)
mkIntegerParameterDeclarationProperty ::
  Value Prelude.Text
  -> Value Prelude.Text -> IntegerParameterDeclarationProperty
mkIntegerParameterDeclarationProperty name parameterValueType
  = IntegerParameterDeclarationProperty
      {haddock_workaround_ = (), name = name,
       parameterValueType = parameterValueType,
       defaultValues = Prelude.Nothing,
       mappedDataSetParameters = Prelude.Nothing,
       valueWhenUnset = Prelude.Nothing}
instance ToResourceProperties IntegerParameterDeclarationProperty where
  toResourceProperties IntegerParameterDeclarationProperty {..}
    = ResourceProperties
        {awsType = "AWS::QuickSight::Dashboard.IntegerParameterDeclaration",
         supportsTags = Prelude.False,
         properties = Prelude.fromList
                        ((Prelude.<>)
                           ["Name" JSON..= name,
                            "ParameterValueType" JSON..= parameterValueType]
                           (Prelude.catMaybes
                              [(JSON..=) "DefaultValues" Prelude.<$> defaultValues,
                               (JSON..=) "MappedDataSetParameters"
                                 Prelude.<$> mappedDataSetParameters,
                               (JSON..=) "ValueWhenUnset" Prelude.<$> valueWhenUnset]))}
instance JSON.ToJSON IntegerParameterDeclarationProperty where
  toJSON IntegerParameterDeclarationProperty {..}
    = JSON.object
        (Prelude.fromList
           ((Prelude.<>)
              ["Name" JSON..= name,
               "ParameterValueType" JSON..= parameterValueType]
              (Prelude.catMaybes
                 [(JSON..=) "DefaultValues" Prelude.<$> defaultValues,
                  (JSON..=) "MappedDataSetParameters"
                    Prelude.<$> mappedDataSetParameters,
                  (JSON..=) "ValueWhenUnset" Prelude.<$> valueWhenUnset])))
instance Property "DefaultValues" IntegerParameterDeclarationProperty where
  type PropertyType "DefaultValues" IntegerParameterDeclarationProperty = IntegerDefaultValuesProperty
  set newValue IntegerParameterDeclarationProperty {..}
    = IntegerParameterDeclarationProperty
        {defaultValues = Prelude.pure newValue, ..}
instance Property "MappedDataSetParameters" IntegerParameterDeclarationProperty where
  type PropertyType "MappedDataSetParameters" IntegerParameterDeclarationProperty = [MappedDataSetParameterProperty]
  set newValue IntegerParameterDeclarationProperty {..}
    = IntegerParameterDeclarationProperty
        {mappedDataSetParameters = Prelude.pure newValue, ..}
instance Property "Name" IntegerParameterDeclarationProperty where
  type PropertyType "Name" IntegerParameterDeclarationProperty = Value Prelude.Text
  set newValue IntegerParameterDeclarationProperty {..}
    = IntegerParameterDeclarationProperty {name = newValue, ..}
instance Property "ParameterValueType" IntegerParameterDeclarationProperty where
  type PropertyType "ParameterValueType" IntegerParameterDeclarationProperty = Value Prelude.Text
  set newValue IntegerParameterDeclarationProperty {..}
    = IntegerParameterDeclarationProperty
        {parameterValueType = newValue, ..}
instance Property "ValueWhenUnset" IntegerParameterDeclarationProperty where
  type PropertyType "ValueWhenUnset" IntegerParameterDeclarationProperty = IntegerValueWhenUnsetConfigurationProperty
  set newValue IntegerParameterDeclarationProperty {..}
    = IntegerParameterDeclarationProperty
        {valueWhenUnset = Prelude.pure newValue, ..}