module Stratosphere.QuickSight.Template.BoxPlotOptionsProperty (
        module Exports, BoxPlotOptionsProperty(..),
        mkBoxPlotOptionsProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import {-# SOURCE #-} Stratosphere.QuickSight.Template.BoxPlotStyleOptionsProperty as Exports
import Stratosphere.ResourceProperties
data BoxPlotOptionsProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-boxplotoptions.html>
    BoxPlotOptionsProperty {haddock_workaround_ :: (),
                            -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-boxplotoptions.html#cfn-quicksight-template-boxplotoptions-alldatapointsvisibility>
                            allDataPointsVisibility :: (Prelude.Maybe JSON.Object),
                            -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-boxplotoptions.html#cfn-quicksight-template-boxplotoptions-outliervisibility>
                            outlierVisibility :: (Prelude.Maybe JSON.Object),
                            -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-boxplotoptions.html#cfn-quicksight-template-boxplotoptions-styleoptions>
                            styleOptions :: (Prelude.Maybe BoxPlotStyleOptionsProperty)}
  deriving stock (Prelude.Eq, Prelude.Show)
mkBoxPlotOptionsProperty :: BoxPlotOptionsProperty
mkBoxPlotOptionsProperty
  = BoxPlotOptionsProperty
      {haddock_workaround_ = (),
       allDataPointsVisibility = Prelude.Nothing,
       outlierVisibility = Prelude.Nothing,
       styleOptions = Prelude.Nothing}
instance ToResourceProperties BoxPlotOptionsProperty where
  toResourceProperties BoxPlotOptionsProperty {..}
    = ResourceProperties
        {awsType = "AWS::QuickSight::Template.BoxPlotOptions",
         supportsTags = Prelude.False,
         properties = Prelude.fromList
                        (Prelude.catMaybes
                           [(JSON..=) "AllDataPointsVisibility"
                              Prelude.<$> allDataPointsVisibility,
                            (JSON..=) "OutlierVisibility" Prelude.<$> outlierVisibility,
                            (JSON..=) "StyleOptions" Prelude.<$> styleOptions])}
instance JSON.ToJSON BoxPlotOptionsProperty where
  toJSON BoxPlotOptionsProperty {..}
    = JSON.object
        (Prelude.fromList
           (Prelude.catMaybes
              [(JSON..=) "AllDataPointsVisibility"
                 Prelude.<$> allDataPointsVisibility,
               (JSON..=) "OutlierVisibility" Prelude.<$> outlierVisibility,
               (JSON..=) "StyleOptions" Prelude.<$> styleOptions]))
instance Property "AllDataPointsVisibility" BoxPlotOptionsProperty where
  type PropertyType "AllDataPointsVisibility" BoxPlotOptionsProperty = JSON.Object
  set newValue BoxPlotOptionsProperty {..}
    = BoxPlotOptionsProperty
        {allDataPointsVisibility = Prelude.pure newValue, ..}
instance Property "OutlierVisibility" BoxPlotOptionsProperty where
  type PropertyType "OutlierVisibility" BoxPlotOptionsProperty = JSON.Object
  set newValue BoxPlotOptionsProperty {..}
    = BoxPlotOptionsProperty
        {outlierVisibility = Prelude.pure newValue, ..}
instance Property "StyleOptions" BoxPlotOptionsProperty where
  type PropertyType "StyleOptions" BoxPlotOptionsProperty = BoxPlotStyleOptionsProperty
  set newValue BoxPlotOptionsProperty {..}
    = BoxPlotOptionsProperty {styleOptions = Prelude.pure newValue, ..}