module Stratosphere.QuickSight.Analysis.PivotTableRowsLabelOptionsProperty (
        PivotTableRowsLabelOptionsProperty(..),
        mkPivotTableRowsLabelOptionsProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import Stratosphere.ResourceProperties
import Stratosphere.Value
data PivotTableRowsLabelOptionsProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablerowslabeloptions.html>
    PivotTableRowsLabelOptionsProperty {haddock_workaround_ :: (),
                                        -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablerowslabeloptions.html#cfn-quicksight-analysis-pivottablerowslabeloptions-customlabel>
                                        customLabel :: (Prelude.Maybe (Value Prelude.Text)),
                                        -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablerowslabeloptions.html#cfn-quicksight-analysis-pivottablerowslabeloptions-visibility>
                                        visibility :: (Prelude.Maybe (Value Prelude.Text))}
  deriving stock (Prelude.Eq, Prelude.Show)
mkPivotTableRowsLabelOptionsProperty ::
  PivotTableRowsLabelOptionsProperty
mkPivotTableRowsLabelOptionsProperty
  = PivotTableRowsLabelOptionsProperty
      {haddock_workaround_ = (), customLabel = Prelude.Nothing,
       visibility = Prelude.Nothing}
instance ToResourceProperties PivotTableRowsLabelOptionsProperty where
  toResourceProperties PivotTableRowsLabelOptionsProperty {..}
    = ResourceProperties
        {awsType = "AWS::QuickSight::Analysis.PivotTableRowsLabelOptions",
         supportsTags = Prelude.False,
         properties = Prelude.fromList
                        (Prelude.catMaybes
                           [(JSON..=) "CustomLabel" Prelude.<$> customLabel,
                            (JSON..=) "Visibility" Prelude.<$> visibility])}
instance JSON.ToJSON PivotTableRowsLabelOptionsProperty where
  toJSON PivotTableRowsLabelOptionsProperty {..}
    = JSON.object
        (Prelude.fromList
           (Prelude.catMaybes
              [(JSON..=) "CustomLabel" Prelude.<$> customLabel,
               (JSON..=) "Visibility" Prelude.<$> visibility]))
instance Property "CustomLabel" PivotTableRowsLabelOptionsProperty where
  type PropertyType "CustomLabel" PivotTableRowsLabelOptionsProperty = Value Prelude.Text
  set newValue PivotTableRowsLabelOptionsProperty {..}
    = PivotTableRowsLabelOptionsProperty
        {customLabel = Prelude.pure newValue, ..}
instance Property "Visibility" PivotTableRowsLabelOptionsProperty where
  type PropertyType "Visibility" PivotTableRowsLabelOptionsProperty = Value Prelude.Text
  set newValue PivotTableRowsLabelOptionsProperty {..}
    = PivotTableRowsLabelOptionsProperty
        {visibility = Prelude.pure newValue, ..}