module Stratosphere.QuickSight.Analysis.ProgressBarOptionsProperty (
        ProgressBarOptionsProperty(..), mkProgressBarOptionsProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import Stratosphere.ResourceProperties
import Stratosphere.Value
data ProgressBarOptionsProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-progressbaroptions.html>
    ProgressBarOptionsProperty {haddock_workaround_ :: (),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-progressbaroptions.html#cfn-quicksight-analysis-progressbaroptions-visibility>
                                visibility :: (Prelude.Maybe (Value Prelude.Text))}
  deriving stock (Prelude.Eq, Prelude.Show)
mkProgressBarOptionsProperty :: ProgressBarOptionsProperty
mkProgressBarOptionsProperty
  = ProgressBarOptionsProperty
      {haddock_workaround_ = (), visibility = Prelude.Nothing}
instance ToResourceProperties ProgressBarOptionsProperty where
  toResourceProperties ProgressBarOptionsProperty {..}
    = ResourceProperties
        {awsType = "AWS::QuickSight::Analysis.ProgressBarOptions",
         supportsTags = Prelude.False,
         properties = Prelude.fromList
                        (Prelude.catMaybes
                           [(JSON..=) "Visibility" Prelude.<$> visibility])}
instance JSON.ToJSON ProgressBarOptionsProperty where
  toJSON ProgressBarOptionsProperty {..}
    = JSON.object
        (Prelude.fromList
           (Prelude.catMaybes
              [(JSON..=) "Visibility" Prelude.<$> visibility]))
instance Property "Visibility" ProgressBarOptionsProperty where
  type PropertyType "Visibility" ProgressBarOptionsProperty = Value Prelude.Text
  set newValue ProgressBarOptionsProperty {..}
    = ProgressBarOptionsProperty
        {visibility = Prelude.pure newValue, ..}