module Stratosphere.QuickSight.Template.GaugeChartArcConditionalFormattingProperty (
        module Exports, GaugeChartArcConditionalFormattingProperty(..),
        mkGaugeChartArcConditionalFormattingProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import {-# SOURCE #-} Stratosphere.QuickSight.Template.ConditionalFormattingColorProperty as Exports
import Stratosphere.ResourceProperties
data GaugeChartArcConditionalFormattingProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-gaugechartarcconditionalformatting.html>
    GaugeChartArcConditionalFormattingProperty {haddock_workaround_ :: (),
                                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-gaugechartarcconditionalformatting.html#cfn-quicksight-template-gaugechartarcconditionalformatting-foregroundcolor>
                                                foregroundColor :: (Prelude.Maybe ConditionalFormattingColorProperty)}
  deriving stock (Prelude.Eq, Prelude.Show)
mkGaugeChartArcConditionalFormattingProperty ::
  GaugeChartArcConditionalFormattingProperty
mkGaugeChartArcConditionalFormattingProperty
  = GaugeChartArcConditionalFormattingProperty
      {haddock_workaround_ = (), foregroundColor = Prelude.Nothing}
instance ToResourceProperties GaugeChartArcConditionalFormattingProperty where
  toResourceProperties
    GaugeChartArcConditionalFormattingProperty {..}
    = ResourceProperties
        {awsType = "AWS::QuickSight::Template.GaugeChartArcConditionalFormatting",
         supportsTags = Prelude.False,
         properties = Prelude.fromList
                        (Prelude.catMaybes
                           [(JSON..=) "ForegroundColor" Prelude.<$> foregroundColor])}
instance JSON.ToJSON GaugeChartArcConditionalFormattingProperty where
  toJSON GaugeChartArcConditionalFormattingProperty {..}
    = JSON.object
        (Prelude.fromList
           (Prelude.catMaybes
              [(JSON..=) "ForegroundColor" Prelude.<$> foregroundColor]))
instance Property "ForegroundColor" GaugeChartArcConditionalFormattingProperty where
  type PropertyType "ForegroundColor" GaugeChartArcConditionalFormattingProperty = ConditionalFormattingColorProperty
  set newValue GaugeChartArcConditionalFormattingProperty {..}
    = GaugeChartArcConditionalFormattingProperty
        {foregroundColor = Prelude.pure newValue, ..}