module Stratosphere.RDS.DBProxyEndpoint (
        module Exports, DBProxyEndpoint(..), mkDBProxyEndpoint
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import {-# SOURCE #-} Stratosphere.RDS.DBProxyEndpoint.TagFormatProperty as Exports
import Stratosphere.ResourceProperties
import Stratosphere.Value
data DBProxyEndpoint
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html>
    DBProxyEndpoint {haddock_workaround_ :: (),
                     -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html#cfn-rds-dbproxyendpoint-dbproxyendpointname>
                     dBProxyEndpointName :: (Value Prelude.Text),
                     -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html#cfn-rds-dbproxyendpoint-dbproxyname>
                     dBProxyName :: (Value Prelude.Text),
                     -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html#cfn-rds-dbproxyendpoint-endpointnetworktype>
                     endpointNetworkType :: (Prelude.Maybe (Value Prelude.Text)),
                     -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html#cfn-rds-dbproxyendpoint-tags>
                     tags :: (Prelude.Maybe [TagFormatProperty]),
                     -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html#cfn-rds-dbproxyendpoint-targetrole>
                     targetRole :: (Prelude.Maybe (Value Prelude.Text)),
                     -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html#cfn-rds-dbproxyendpoint-vpcsecuritygroupids>
                     vpcSecurityGroupIds :: (Prelude.Maybe (ValueList Prelude.Text)),
                     -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html#cfn-rds-dbproxyendpoint-vpcsubnetids>
                     vpcSubnetIds :: (ValueList Prelude.Text)}
  deriving stock (Prelude.Eq, Prelude.Show)
mkDBProxyEndpoint ::
  Value Prelude.Text
  -> Value Prelude.Text -> ValueList Prelude.Text -> DBProxyEndpoint
mkDBProxyEndpoint dBProxyEndpointName dBProxyName vpcSubnetIds
  = DBProxyEndpoint
      {haddock_workaround_ = (),
       dBProxyEndpointName = dBProxyEndpointName,
       dBProxyName = dBProxyName, vpcSubnetIds = vpcSubnetIds,
       endpointNetworkType = Prelude.Nothing, tags = Prelude.Nothing,
       targetRole = Prelude.Nothing,
       vpcSecurityGroupIds = Prelude.Nothing}
instance ToResourceProperties DBProxyEndpoint where
  toResourceProperties DBProxyEndpoint {..}
    = ResourceProperties
        {awsType = "AWS::RDS::DBProxyEndpoint",
         supportsTags = Prelude.True,
         properties = Prelude.fromList
                        ((Prelude.<>)
                           ["DBProxyEndpointName" JSON..= dBProxyEndpointName,
                            "DBProxyName" JSON..= dBProxyName,
                            "VpcSubnetIds" JSON..= vpcSubnetIds]
                           (Prelude.catMaybes
                              [(JSON..=) "EndpointNetworkType" Prelude.<$> endpointNetworkType,
                               (JSON..=) "Tags" Prelude.<$> tags,
                               (JSON..=) "TargetRole" Prelude.<$> targetRole,
                               (JSON..=) "VpcSecurityGroupIds" Prelude.<$> vpcSecurityGroupIds]))}
instance JSON.ToJSON DBProxyEndpoint where
  toJSON DBProxyEndpoint {..}
    = JSON.object
        (Prelude.fromList
           ((Prelude.<>)
              ["DBProxyEndpointName" JSON..= dBProxyEndpointName,
               "DBProxyName" JSON..= dBProxyName,
               "VpcSubnetIds" JSON..= vpcSubnetIds]
              (Prelude.catMaybes
                 [(JSON..=) "EndpointNetworkType" Prelude.<$> endpointNetworkType,
                  (JSON..=) "Tags" Prelude.<$> tags,
                  (JSON..=) "TargetRole" Prelude.<$> targetRole,
                  (JSON..=) "VpcSecurityGroupIds" Prelude.<$> vpcSecurityGroupIds])))
instance Property "DBProxyEndpointName" DBProxyEndpoint where
  type PropertyType "DBProxyEndpointName" DBProxyEndpoint = Value Prelude.Text
  set newValue DBProxyEndpoint {..}
    = DBProxyEndpoint {dBProxyEndpointName = newValue, ..}
instance Property "DBProxyName" DBProxyEndpoint where
  type PropertyType "DBProxyName" DBProxyEndpoint = Value Prelude.Text
  set newValue DBProxyEndpoint {..}
    = DBProxyEndpoint {dBProxyName = newValue, ..}
instance Property "EndpointNetworkType" DBProxyEndpoint where
  type PropertyType "EndpointNetworkType" DBProxyEndpoint = Value Prelude.Text
  set newValue DBProxyEndpoint {..}
    = DBProxyEndpoint {endpointNetworkType = Prelude.pure newValue, ..}
instance Property "Tags" DBProxyEndpoint where
  type PropertyType "Tags" DBProxyEndpoint = [TagFormatProperty]
  set newValue DBProxyEndpoint {..}
    = DBProxyEndpoint {tags = Prelude.pure newValue, ..}
instance Property "TargetRole" DBProxyEndpoint where
  type PropertyType "TargetRole" DBProxyEndpoint = Value Prelude.Text
  set newValue DBProxyEndpoint {..}
    = DBProxyEndpoint {targetRole = Prelude.pure newValue, ..}
instance Property "VpcSecurityGroupIds" DBProxyEndpoint where
  type PropertyType "VpcSecurityGroupIds" DBProxyEndpoint = ValueList Prelude.Text
  set newValue DBProxyEndpoint {..}
    = DBProxyEndpoint {vpcSecurityGroupIds = Prelude.pure newValue, ..}
instance Property "VpcSubnetIds" DBProxyEndpoint where
  type PropertyType "VpcSubnetIds" DBProxyEndpoint = ValueList Prelude.Text
  set newValue DBProxyEndpoint {..}
    = DBProxyEndpoint {vpcSubnetIds = newValue, ..}