module Stratosphere.Shield.Protection (
        module Exports, Protection(..), mkProtection
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import {-# SOURCE #-} Stratosphere.Shield.Protection.ApplicationLayerAutomaticResponseConfigurationProperty as Exports
import Stratosphere.ResourceProperties
import Stratosphere.Tag
import Stratosphere.Value
data Protection
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-protection.html>
    Protection {haddock_workaround_ :: (),
                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-protection.html#cfn-shield-protection-applicationlayerautomaticresponseconfiguration>
                applicationLayerAutomaticResponseConfiguration :: (Prelude.Maybe ApplicationLayerAutomaticResponseConfigurationProperty),
                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-protection.html#cfn-shield-protection-healthcheckarns>
                healthCheckArns :: (Prelude.Maybe (ValueList Prelude.Text)),
                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-protection.html#cfn-shield-protection-name>
                name :: (Value Prelude.Text),
                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-protection.html#cfn-shield-protection-resourcearn>
                resourceArn :: (Value Prelude.Text),
                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-protection.html#cfn-shield-protection-tags>
                tags :: (Prelude.Maybe [Tag])}
  deriving stock (Prelude.Eq, Prelude.Show)
mkProtection ::
  Value Prelude.Text -> Value Prelude.Text -> Protection
mkProtection name resourceArn
  = Protection
      {haddock_workaround_ = (), name = name, resourceArn = resourceArn,
       applicationLayerAutomaticResponseConfiguration = Prelude.Nothing,
       healthCheckArns = Prelude.Nothing, tags = Prelude.Nothing}
instance ToResourceProperties Protection where
  toResourceProperties Protection {..}
    = ResourceProperties
        {awsType = "AWS::Shield::Protection", supportsTags = Prelude.True,
         properties = Prelude.fromList
                        ((Prelude.<>)
                           ["Name" JSON..= name, "ResourceArn" JSON..= resourceArn]
                           (Prelude.catMaybes
                              [(JSON..=) "ApplicationLayerAutomaticResponseConfiguration"
                                 Prelude.<$> applicationLayerAutomaticResponseConfiguration,
                               (JSON..=) "HealthCheckArns" Prelude.<$> healthCheckArns,
                               (JSON..=) "Tags" Prelude.<$> tags]))}
instance JSON.ToJSON Protection where
  toJSON Protection {..}
    = JSON.object
        (Prelude.fromList
           ((Prelude.<>)
              ["Name" JSON..= name, "ResourceArn" JSON..= resourceArn]
              (Prelude.catMaybes
                 [(JSON..=) "ApplicationLayerAutomaticResponseConfiguration"
                    Prelude.<$> applicationLayerAutomaticResponseConfiguration,
                  (JSON..=) "HealthCheckArns" Prelude.<$> healthCheckArns,
                  (JSON..=) "Tags" Prelude.<$> tags])))
instance Property "ApplicationLayerAutomaticResponseConfiguration" Protection where
  type PropertyType "ApplicationLayerAutomaticResponseConfiguration" Protection = ApplicationLayerAutomaticResponseConfigurationProperty
  set newValue Protection {..}
    = Protection
        {applicationLayerAutomaticResponseConfiguration = Prelude.pure
                                                            newValue,
         ..}
instance Property "HealthCheckArns" Protection where
  type PropertyType "HealthCheckArns" Protection = ValueList Prelude.Text
  set newValue Protection {..}
    = Protection {healthCheckArns = Prelude.pure newValue, ..}
instance Property "Name" Protection where
  type PropertyType "Name" Protection = Value Prelude.Text
  set newValue Protection {..} = Protection {name = newValue, ..}
instance Property "ResourceArn" Protection where
  type PropertyType "ResourceArn" Protection = Value Prelude.Text
  set newValue Protection {..}
    = Protection {resourceArn = newValue, ..}
instance Property "Tags" Protection where
  type PropertyType "Tags" Protection = [Tag]
  set newValue Protection {..}
    = Protection {tags = Prelude.pure newValue, ..}