{-# LANGUAGE OverloadedStrings #-}
{-# LANGUAGE PackageImports    #-}
{-# LANGUAGE QuasiQuotes       #-}

import Criterion      ( bench, bgroup, whnf )
import Criterion.Main ( defaultMain )

import qualified Data.ByteString as B
import qualified Data.Text       as T

import qualified "string-interpolate" Data.String.Interpolate   as SI
import qualified "interpolate" Data.String.Interpolate.IsString as I
import           "formatting" Formatting                        ( (%) )
import qualified "formatting" Formatting                        as F
import qualified "formatting" Formatting.ShortFormatters        as F

--------------------------------------------------------------------------------
-- Interpolating short Strings
--------------------------------------------------------------------------------

shortStringSI :: String -> String
shortStringSI str = [SI.i|A fine day to die, #{str}.|]

shortStringI :: String -> String
shortStringI str = [I.i|A fine day to die, #{str}.|]

shortStringF :: String -> String
shortStringF = F.formatToString ("A fine day to die, " % F.s % ".")

--------------------------------------------------------------------------------
-- Interpolating short Text
--------------------------------------------------------------------------------

shortTextSI :: T.Text -> T.Text
shortTextSI t = [SI.i|A fine day to die, #{t}.|]

shortTextI :: T.Text -> T.Text
shortTextI t = [I.i|A fine day to die, #{t}.|]

shortTextF :: T.Text -> T.Text
shortTextF = F.sformat ("A fine day to die, " % F.st % ".")

--------------------------------------------------------------------------------
-- Interpolating short ByteString
--------------------------------------------------------------------------------

shortByteStringSI :: B.ByteString -> B.ByteString
shortByteStringSI b = [SI.i|A fine day to die, #{b}.|]

shortByteStringI :: B.ByteString -> B.ByteString
shortByteStringI b = [I.i|A fine day to die, #{b}.|]

main :: IO ()
main = defaultMain
  [ bgroup "Small Strings Bench" $
    [ bench "string-interpolate" $ whnf shortStringSI "William"
    , bench "interpolate"        $ whnf shortStringI "William"
    , bench "formatting"         $ whnf shortStringF "William"
    ]
  , bgroup "Small Text Bench" $
    [ bench "string-interpolate" $ whnf shortTextSI "William"
    , bench "interpolate"        $ whnf shortTextI "William"
    , bench "formatting"         $ whnf shortTextF "William"
    ]
  , bgroup "Small ByteString Bench" $
    [ bench "string-interpolate" $ whnf shortByteStringSI "William"
    , bench "interpolate"        $ whnf shortByteStringI "William"
    -- "formatting" doesn't support ByteStrings.
    ]
  ]
