{-# LANGUAGE OverloadedStrings #-}
{-# LANGUAGE Strict #-}
import Data.Monoid ((<>))
import qualified Data.Text as Text
import Data.Text.Encoding (encodeUtf8)
import qualified Test.QuickCheck as QC
import qualified Test.QuickCheck.Gen as QC
import qualified Test.QuickCheck.Random as QC
import qualified Text.StringRandom as StringRandom
import qualified Test.Tasty as Tasty
import qualified Test.Tasty.QuickCheck as TastyQC
import Text.Regex.PCRE.Heavy (compileM, (=~))

regexp :: QC.Gen Text.Text
regexp = QC.MkGen $ \g _ -> StringRandom.stringRandom g regregexp
  where regregexp = "((\\w|" <> classes <> "|\\(\\w+\\))(\\{[0-4],[5-9]\\}|\\*|\\+|))*"
        classes = "\\[^?(\\w|" <> escaped <> "|a-z)+-?\\]"
        escaped = "\\\\[dDwWsSnr\\[\\]|.(){}^$-]"

main :: IO ()
main = Tasty.defaultMain (TastyQC.testProperty
                           "by quickcheck" prop_stringRandom)

prop_stringRandom :: QC.Property
prop_stringRandom = QC.forAll regexp $ \pat -> QC.ioProperty $ do
  let pat' = "^" <> fixBS pat <> "$"
      (Right reg) = compileM pat' []
  randbs <- fixBS <$> StringRandom.stringRandomIO pat
  return $ randbs =~ reg

  where
    -- Seems that PCRE can't handle strings generated by encodeUtf8
    fixBS = (<> "") . encodeUtf8
