{-# LANGUAGE OverloadedStrings #-}

import           Test.Hspec

import           Text.Parser.Substring

import           Control.Applicative ((*>))
import           Data.Attoparsec.Text


main :: IO ()
main = hspec $
  describe "replaceWithParser" $ do
    it "replace first matching text by parser" $
      replaceOnceWithParser (string "abc" *> pure "def") "--abc-abc-"
        `shouldBe` "--def-abc-"

    it "returns the source text if parser doesn't match" $ do
      let src = "--abc-abc-"
      replaceOnceWithParser mempty src `shouldBe` src
