{-# LANGUAGE     OverloadedStrings       #-}


{- |
Coat of Arms for flags (or more generally, 
anything hard to draw which should be inside a flag)
-}
module SvgIcons.Images.CountryFlagsCoAs where

import           Text.Blaze.Svg11 ((!))
import           Text.Blaze.Svg11 as S
import           Text.Blaze.Svg11.Attributes as A

import SvgIcons.Core.Geometry
import SvgIcons.Core.Utils


--------------------------------------------------------------------------------

{- |
Flag of Andorra coat of arms.
Drawn for a @viewbox 0 0 1000 700@
-}
adCoA :: Svg
adCoA =
  S.g $ do
    S.path
      ! A.fill "#C6AA76"
      ! A.d "M469.3,188.4c12.0,0,16.9,10.3,29.0,10.3  c7.4,0,11.7-2.4,18.2-6.0c4.5-2.5,7.4-3.9,12.6-3.9  c5.3,0,8.5,1.6,11.3,6.1c1.5,2.5,2.8,7.6,2.1,10.5  c-0.9,4.4-2.3,8.8-4.2,12.9c-1.0,2.4-2.0,3.8-2.0,6.5  c0,6.3,8.7,8.5,14.6,8.6c1.2,0.0,12.1,0.1,18.8-6.5  c-3.6-0.1-7.6-2.9-7.6-6.5c0-4.0,2.8-6.8,6.7-8.0  c0.7-0.2,2.0,0.4,2.6,0.0c0.9-0.4,0.5-1.5,1.3-2.2  c1.9-1.5,3.2-2.5,5.6-2.5c1.3-0.0,2.7,0.3,3.8,1.1  c0.6,0.4,0.9,1.1,1.7,1.1c1.7,0,2.6-1.1,4.4-1.1  c1.2-0.0,2.5,0.2,3.6,0.8c1.0,0.5,1.0,2.3,2.2,2.3  c0.6,0,3.7-1.2,5.4-1.2c3.4,0,5.2,1.2,7.5,3.8  c0.5,0.7,0.9,2.1,1.5,2.1c2.1,0.1,4.2,1.0,5.8,2.5  c0.6,0.6,1.2,1.2,1.6,2.0c0.4,0.6,1.0,2.2,1.7,2.5  c0.9,0.1,1.8,0.5,2.6,0.9c2.6,1.6,4.2,4.5,4.3,7.6  c-0.1,1.1-0.3,2.2-0.7,3.3c-2.9,10.2-9.9,13.5-17.0,22.3  c-3.0,3.7-5.3,6.7-5.3,11.5c0,1.1,1.4,3.3,2.0,4.2  c-0.3-2.2,0.6-5.0,3.0-5.1c3.2-0.1,5.9,2.3,6.2,5.5  c0.0,0.9-0.1,1.9-0.5,2.8c1.8-1.1,4.0-1.9,6.2-2.2  c0.9-0.1,1.9-0.1,2.9-0.1c5.2,0.1,11.0,3.0,14.5,6.0  c10.7,9.1,12.0,22.4,11.4,26.2  c-1.3,8.2-0.4,23.1-21.5,29.1c3.8,1.6,6.5,4.5,6.5,8.1  c0.0,3.9-3.0,7.1-6.9,7.2c-2.0,0.1-3.9-0.6-5.3-2.1  c-4.3,4.3-5.2,8.8-5.2,15.0c-0.0,3.2,0.7,6.4,2.2,9.2  c1.6,3.5,2.8,5.6,5.7,8.2c1.5-2.3,3.2-4.1,6.0-4.1  c2.7,0,5.0,0.8,6.2,3.3c0.3,0.7,0.0,1.3,0.4,2.1  c0.4,0.9,1.3,1.1,1.8,2.1c0.7,1.4,0.0,2.7,0.7,4.2  c0.4,0.9,1.4,1.1,1.8,2.1c0.6,1.3,0.9,2.7,0.8,4.2  c0,4.7-4.2,8.0-8.9,8.0c-1.4,0-2.1-0.5-3.6-0.4  c2.6,2.6,4.7,3.8,6.7,7.0c2.9,4.6,3.7,7.9,4.3,13.4  c0.1,0.8,0.1,1.7,0.1,2.6c0,7.0-1.0,11.2-4.2,17.5  c-3.0,6.0-5.5,9.3-11.0,13.2c-8.5,6.1-14.7,7.8-25.0,9.8  c-5.6,1.1-11.3,1.9-17.1,2.2c-8.5,0.5-13.4,0.5-22.0,1.1  c-11.2,0.7-19.0,2.3-27,10.3c3.7,2.7,6.3,5.4,6.3,10.1  c0,4.7-2.9,8.1-7.4,9.6c-1.0,0.3-1.8,0.0-2.8,0.5  c-1.1,0.6-1.1,1.9-2.2,2.6c-1.7,1.1-3.8,1.6-5.9,1.5  c-4.2,0-7.0-0.9-10.0-3.9c-3.4,2.8-4.6,5.4-8.4,7.6  c-1.2,0.7-1.9,1.6-3.3,1.6c-2.3,0-3.3-1.4-5.2-2.8  c-2.5-1.8-4.9-3.9-6.9-6.3c-3.5,2.1-5.6,3.8-9.7,3.8  c-2.2,0.1-4.3-0.4-6.2-1.6c-1.1-0.6-1.2-1.7-2.4-2.4  c-1.1-0.7-2.1-0.4-3.3-0.9c-4.7-2.0-7.7-5.5-7.7-10.6  c0-4.5,2.8-7.3,6.9-9.2c-7.8-7.8-15.5-9.1-26.5-9.8  c-8.5-0.5-13.3-0.5-21.9-1.1c-5.7-0.4-11.5-1.1-17.2-2.2  c-5.0-0.8-8.0-1.0-12.7-3.2c-15.9-7.4-26.1-17.6-28.2-35.1  c-0.1-1.2-0.1-2.5-0.1-3.8c0-9.1,3.5-14.6,10.0-21.1  c-1.6-0.3-2.7,0.1-4.3-0.4c-4.0-1.4-6.9-4.2-6.9-8.5  c-0.1-1.3,0.1-2.7,0.8-4.0c0.5-0.9,1.5-1.1,1.8-2.2  c0.3-1.4-0.1-2.4,0.5-3.8c0.4-0.8,1.2-1.0,1.6-1.9  c1.3-2.8,3.1-5.2,6.3-5.2c2.7,0,4.5,1.4,5.9,3.8  c2.6-1.2,3.4-3.2,4.9-5.7c2.5-4.2,3.6-7.1,3.6-12.0  c0.0-2.9-0.4-5.9-1.4-8.6c-0.7-2.3-1.0-3.9-2.8-5.6  c-1.3,1.4-3.3,2.2-5.3,2.1c-4.4-0.1-8.0-3.8-7.9-8.3  c-0.1-3.1,1.7-6.0,4.6-7.2c-2.4-2.0-4.5-2.2-7.2-3.9  c-4.0-2.5-5.5-5.3-8.1-9.3c-1.7-2.6-2.2-4.4-3.1-7.4  c-1.0-3.0-1.6-6.3-1.6-9.6c-0.0-0.8,0.0-1.7,0.1-2.5  c1.0-7.6,2.3-12.4,7.2-18.5c2.8-3.5,4.8-5.7,9.0-7.6  c3.6-1.5,5.7-2.6,9.6-2.6c1.0-0.0,2.0,0.0,3.0,0.1  c1.5,0.0,3.1,0.5,4.5,1.2c0.6,0.3,1.6,1.3,1.6,0.6  c0-0.8-0.4-1.2-0.4-2.0c0-3.2,2.3-6.2,5.5-6.2  c2.3,0,3.3,2.0,4.4,4.1c0.7-1.0,1.1-2.2,1.1-3.5  c0-5.3-2.8-8.1-6.2-12.2c-7.2-9.1-16.3-13.3-16.3-25.0  c0-3.4,1.6-5.8,4.6-7.6c0.8-0.5,2.0,0,2.8-0.5  c0.7-0.4,0.6-1.3,1.1-2.1c0.6-0.9,1.4-1.8,2.3-2.5  c1.6-1.4,3.1-1.0,4.9-2.2c0.9-0.6,1.1-1.4,1.8-2.3  c2.0-2.4,3.8-3.6,7.1-3.6c1.3-0.1,2.7,0.1,4.0,0.6  c0.5,0.1,1.4,0.9,1.5,0.8c0.6-0.7,1.3-1.3,2.2-1.8  c1.0-0.6,2.2-0.9,3.4-0.9c1.7,0,2.8,0.9,4.5,0.9  c0.6,0,0.7-0.6,1.2-0.9c1.5-1.0,2.4-1.6,4.2-1.6  c1.5,0.0,3.0,0.5,4.3,1.5c1.4,0.9,1.6,2.1,3.1,2.9  c0.8,0.4,1.5,0.2,2.4,0.5c4.0,1.3,7.0,4.0,7.0,8.2  c0.1,2.0-0.6,4.0-2.2,5.4c-1.3,1.2-2.6,0.9-4.3,1.5  c5.6,4.4,10.5,5.6,17.6,5.6c6.5,0,14.6-2.6,14.6-9.2  c0-3.0-1.6-4.6-2.8-7.5c-2.1-5-3.3-7.9-3.3-13.3  c0-4.3,0.4-6.9,2.9-10.4c2.5-3.6,5.7-4.4,10.1-4.4  L469.3,188.4z"
    S.path
      ! A.fill "none"
      ! A.stroke "#713F2A"
      ! A.strokeWidth "1"
      ! A.strokeLinejoin "round"
      ! A.d "M425.5,223.4   c0.5,1.8,1.9,3.2,3.8,3.8c2.2,0.5,4.5-0.3,5.9-2.1   c1.2-1.8,1.5-4.1,0.8-6.2c-0.5-1.4-1.4-2.6-2.6-3.4   l-7.9,8.0l-0.0,0.0L425.5,223.4z M626.6,343.9   c-1.8-4.5-6.6-2.4-6.9,0c-0.6,5.7,4.3,7.4,7.9,6.5   c1.6-0.4,3.0-1.5,3.8-3.0c0.9-1.7,1.1-3.8,0.6-5.8   c-0.5-1.8-1.7-3.4-3.3-4.4c-1.3-0.8-2.8-0.9-5.2-0.9   c-8.7,0-16.3,10.2-18.8,20.9c-1.4,6.1-1.5,12.5-0.3,18.8   c1.2,6.6,4.4,12.7,9.1,17.5c2.6,2.5,5.7,4.7,8.9,6.4   c2.0,1.0,4.2,1.9,6.4,2.6c2.0,0.5,4.1,0.6,6.1,0.1   c5.1-1.1,7.5-5.9,4.9-10.8c-2.1-4.0-8.3-6.2-11.3-1.0   c-0.4,0.7-0.6,1.5-0.6,2.4c-0.0,1.3,0.5,2.7,1.5,3.6   c2.2,1.4,5.8,1.0,5.6-2 M603.7,421.4    c-0.4-1.7-0.0-3.3,1.3-5.2c1.8-2.4,5.6-3.3,9.1-1.3    c1.5,0.7,2.9,1.8,3.9,3.2c0.5,0.6,1.3,1.7,1.7,2.4    c0.7,1.2,1.2,2.5,1.7,3.8c3.8,10.9-2.2,22.7-10.2,27.5    c-6.2,3.6-13.6,5.3-22.4,6.3c-3.9,0.4-6.2,0.4-10.2,0.6    c-3.2,0.1-6.0,0.0-8.6,0.0c-2.1-0.0-4.2-0.0-6.2-0.0    c-3.7-0.1-7.5-0.0-11.2,0.1c-4.5,0.3-7.9,0.4-11.8,1.0    c-2.5,0.4-5.4,0.8-8.5,1.5c-0.9,0.2-1.8,0.3-2.8,0.6    c-0.6,0.1-1.2,0.3-1.8,0.5c-5.3,1.4-10.4,3.6-15.2,6.5    c-1.3,0.7-2.6,1.6-3.8,2.7c-0.6,0.6-1.4,1.2-2.1,1.8    c-2.9,2.9-6.0,6.1-6.7,10.4c-0.1,0.8-0.1,1.6-0.1,2.5    c0,2.7,2.2,6.6,8.4,7.8 M516.3,229.1    c1.2,2.3,1.9,3.7,1.2,6.1c-0.8,2.7-2.7,4.3-5.5,4.3    c-6.2,0-9.8-7.3-7.0-12.0c4.9-8.3,14.5-3.6,23.4,0.4    c-0.4-2.1-1.1-2.8-1.0-5.4c0.1-6.5,5.0-9.5,7.0-15.6    c1.1-3.6,1.6-6.7-1.0-9.3c-2.3-2.2-4.9-2.2-7.9-1.0    c-6.0,2.3-13.2,9.1-25.9,9.3c-12.7-0.1-20.0-6.9-26.0-9.3    c-3.0-1.1-5.6-1.2-7.9,1.0c-2.6,2.5-2.1,5.7-1.0,9.3    c1.9,6.0,6.8,9.0,7.0,15.6c0.0,2.6-0.6,3.3-1.0,5.4    c8.8-4.1,18.7-9.2,23.4-0.4c2.5,4.8-0.8,12.0-7.0,12.0    c-2.7,0-4.6-1.7-5.5-4.3c-0.6-2.1-0.1-4.4,1.2-6 M491.5,224.7    c2.4,1.8,4.1,4.1,3.8,7.7c-0.3,3.9-1.2,4.9-4.3,7.0 M494.6,233.6c0.0,2.2-1.3,4.2-3.5,4 M430.0,220.5   c-0.4-2.5-3.4-3.1-4.6-1.5c-1.7,2.3-0.4,6.2,3.1,7.4   c2.2,0.5,4.5-0.3,5.9-2.1c2.1-3.0,1.4-7.2-1.5-9.4   c-0.0-0.0-0.1-0.1-0.2-0.1c-4.2-3.2-11.1-2.4-13.3,2.9   c-2.9,7.0,3.4,12.2,9.2,16.2c7.3,4.9,15.7,5.8,22.0,5.8   c14.3-0.1,25.1-6.9,32.2-10.8c1.6-0.9,3.3-0.7,4.1,0.3   c1.0,1.3,0.8,3.1-0.3,4 M387.6,414.3l-3.1,1.1   l-3.2,2.4l-1.3,1.9l-1.7,3.1l-0.7,2.3l-0.6,2.8l-0.3,2.1    M405.9,414.6l-0.2,2.7L405.2,419.4l-1.3,3.3l-2.1,2.8   l-2.3,1.8l-1.7,0.8l-2.4,0 M499.6,489.2   c-0.5,2.5-3.0,5.5-8.2,6.6l-1.0,0 M631.5,406.5   c3.4,3.3,6.0,7.5,7.4,12.1c0.9,2.9,1.3,5.9,1.3,9.0   c-0.1,5.6-1.5,11.7-3.0,14.6c-1.3,2.5-4.8,13.9-23.9,21.8   c-11.1,4.5-28.2,5.6-40.1,6.1   c-16.0,0.6-30.8,1.2-39.5,11 M605.4,416.9   c1.1-1.6,5.5-3.6,9.0-1.7c1.4,0.7,2.7,1.8,3.7,3 M627.5,402.7   c0.7,0.2,1.5,0.5,2.2,0.7c1.9,0.6,4.1,0.6,6.1,0.1   c4.4-1.3,7.2-5.4,4.9-10.8c-0.6-1.3-1.5-2.4-2.7-3 M375.4,287.1   c-2.9,1.8-5.1,2.2-7.4,4.9c-1.8,3.3-3.2,6.9-4.1,10.6 M435.8,221.9c0,2.6-1.9,4.3-4.6,4 M620.4,275.0   c7.3-0.1,28.8,5.6,29.0,30.8   c0.1,24.9-15.3,28.9-21.6,30 M622.4,275.0   c12.7-0.5,25.8,8.8,26.4,32.2   c0.4,18.2-12.5,26.5-18.7,28 M615.3,363.1l0.1-2.5l0.8-3.9   l1.1-3.0l1.3-2.5l1.7-2.0 M632.7,343.6l-0.1,2.4l-0.7,1.6   l-1.0,1.5l-1.2,0.9l-1.9,0.7l-1.6,0.1l-1.2-0.1    M602.3,268.4l0.5-2.6l1.1-2.4l1.5-2.4l2.6-3.3l2.0-2.2   l3.3-3.3l2.8-2.9l1.8-2.0l2.4-2.9l2.1-3.2l1.2-2.6   l0.7-3.4l0.2-4.2l-0.3-1.2 M605.4,429.4l2.5-0.5l1.9-1.0   l1.0-1.0l0.7-1.2l0.5-1.9l0.0-1.3 M364.9,403.3l1.8,0.1   l2.4-0.1l2.4-0.8 M379.4,345.3l-0.3,2.1l-0.5,0.9l-0.7,0.9   l-1.0,0.7l-1.1,0.5l-1.4,0.2l-1.0,0.0 M388.7,326.6   l-0.5,3.3l-0.6,1.4l-1.3,1.8l-1.8,1.3l-1.8,0.9l-3.6,0.8    M402.7,274.4l-0.7,2.0l-0.8,1.4l-1.1,1.6l-1.6,1.4   l-1.9,0.9l-1.6,0.3l-1.0-0.0 M394.4,272.6l0.0,1 M397.3,325.0    c-0.9,0.8-2.0,1.5-3.2,2.0 M629.2,397.1    c0.1,0.1,0.5,0.2,0.7,0.3c2.2,1.3,6.5-0.3,5.2-3 M621.5,349.3    c1.5,2.0,4.5,2.5,6.8,1.9c1.6-0.4,3.0-1.5,3.8-3.0    c0.9-1.7,1.1-3.8,0.6-5.8c-0.2-0.9-0.7-1.8-1.3-2.5    c-0.5-0.8-1.3-1.5-2.1-2.2c-0.1-0.1-0.3-0.2-0.5-0.3     M638.9,390.4c0.3-2.1-0.3-4.2-1.9-5.7    c-0.4-0.4-0.8-0.8-1.3-1.2 M636.4,384.2    c-0.0-2.9-2.4-4.9-5.4-5.5 M624.5,383.1    c-0.7-0.5-1.3-1.0-2.0-1.6c-4.2-4.5-6.6-10.4-6.7-16.6    c-0.0-6.4,2.5-13.0,5.5-15.6 M533.0,481.4l2.7-2.5    l1.9-1.4l3.6-2.2l3.4-1.6l2.4-0.6l4.8-1.0l5.5-0.8     M511.6,501.2c-2.0,3.1-6.8,7.7-11.8,9.6    c-5.0-1.8-9.8-6.5-11.8-9 M491.2,494.7    c-0.6,2.3-1.8,4.6-3.4,6 M491.7,491.4l-0.7,3.4     M487.4,501.4l-1.4,1.4l-2.6,1.4l-3.0,0.9 M471.4,227.4    c0.5-1.2,0.7-2.6,0.7-4.0c-0.1-6.5-5.0-9.5-7.0-15.6    c-1.1-3.6-1.6-6.7,1.0-9.3c2.3-2.2,4.9-2.2,7.9-1.0    c6.0,2.3,13.3,9.1,26.0,9.3c-12.7-0.1-20.0-6.9-26.0-9.3    c-3.0-1.1-5.9-1.5-8.2,0.7c-2.6,2.5-1.9,6.0-0.7,9.6    c1.9,6.0,6.5,9.0,6.7,15.6c0.0,1.3-0.2,2.7-0.8,4.0     M500.1,206.3c12.5-0.6,23.2-9.0,26.7-9.7    c3.0-0.6,4.8-0.3,7.0,1.7c-2.2-2.0-4.8-1.9-7.7-0.8    c-6.0,2.3-13.2,9.1-25.9,9.3 M624.5,383.2    c-6.0-4.5-9.6-11.6-9.7-19.2c-0.0-6.4,2.5-13.0,5.5-15.6     M511.1,500.7c-2.0,3.1-6.8,7.7-11.8,9.6    c-5.0-1.8-9.8-6.5-11.8-9 M479.1,230.7    c1.3-0.7,2.5-1.4,3.6-2.0c1.6-0.9,3.6-0.7,4.4,0.3    c1.0,1.3,0.9,3.2-0.2,4 M460.4,239.4    c8.5-1.7,15.5-5.6,20.8-8.5 M531.7,487.4    c0.4,0.4,0.8,0.9,1.1,1.4c0.2,0.4,0.3,0.8,0.5,1.3    c0.4,1.8-0.7,3.6-2.5,4.0c-0.1,0.0-0.3,0.0-0.5,0.0    c-2.3,0.2-4.5-1.0-5.4-3.1 M460.0,239.0    c8.5-1.7,15.5-5.6,20.8-8.5 M633.3,397.4    c-1.6,0.6-2.5,0.5-4.5-0.3c-0.8-0.3-1.7-0.9-2.9-1.5    c-3.9-2.2-8.7-5.8-13.1-14.1c-1.1-2.2-2.0-4.5-2.6-6.9    c-0.4-1.7-0.6-3.4-0.7-5.2c-0.0-3.2,0.2-6.5,0.9-9.7    c0.9-5.1,3.1-10.0,6.3-14.1c1.7-2.4,3.3-3.9,6.6-4.0     M398.8,279.8c2.6,2.1,4.2,5.4,4.1,8.9    c0,4.8-4.0,12.7-14.0,15.5c-3.3,0.9-6.8,0.5-9.8-1 M400.4,296.2    c1.7,1.0,2.6,3.0,2.4,5.0c0,1.6-1.0,3.8-2.9,5.8    c-3.5,3.8-8.4,6.1-13.7,6.2c-3.3,0.0-6.6-0.8-9.4-2.7    c-2.9-1.9-5.1-4.9-5.9-8 M400.2,306.7    c2.0,1.8,2.6,4.1,2.6,7.1c0,4.2-1.7,7.6-5.7,11.1    c-0.9,0.8-1.9,1.5-3.0,2.1 M596.4,292.6v5.5 M595.9,291.2    v7.7 M596.4,274.4V284.6 M595.9,272.1v13.9 M592.9,414.1    c-1.5,3.3-3.8,6.3-6.5,8.8c-2.6,2.6-5.7,4.8-9.0,6.3    c-3.2,1.6-6.6,2.7-10.2,3.4c-3.5,0.8-7.1,1.2-10.7,1.3    c-3.3,0.1-6.6,0.0-9.9-0.2c-4.1-0.2-6.4-0.8-10.5-1.2    c-2.9-0.3-5.8-0.5-8.7-0.5c-3.0-0.0-6.0,0.1-8.9,0.6    c-2.7,0.4-5.4,1.1-8.0,2.2c-4.1,1.7-8.9,4.6-9.9,5.9    c-1.0-1.3-5.7-4.2-9.9-5.9c-2.5-1.0-5.3-1.8-8.0-2.2    c-2.9-0.5-5.9-0.7-8.9-0.6c-2.9,0.0-5.8,0.2-8.7,0.5    c-4.1,0.3-6.4,0.9-10.5,1.2c-3.2,0.3-6.6,0.3-9.9,0.2    c-3.6-0.0-7.2-0.5-10.7-1.3c-3.5-0.6-7.0-1.8-10.2-3.4    c-3.3-1.5-6.4-3.7-9.0-6.3c-0.3-0.3-0.6-0.6-0.9-0.9     M478.7,505.4l2.7-0.3 M528.9,501.4l2.8-0.2l2.6-1.0    l1.8-1.1l2.5-3.0l0.5-1.1l0.4-2.6l0.1-1.2 M613.2,277.3    c1.2-4.1-0.2-8.4-4.2-8.3 M402.7,341.7    c-0.9,3.0-2.9,5.6-5.6,7.2 M402.8,276.0    c-0.9,2.8-2.9,5.1-5.7,6.2c-2.8,1.3-6.2,0.0-8.0-1 M380.9,291.2    c2.3,1.2,4.8-0.5,4.3-3.6c-0.4-1.8-2.0-3.2-3.9-3 M390.8,422.8    c0.5,0.4,0.6,1.1,1.3,1.2c1.0,0.1,1.8,0.5,2.9-0.8    c1.2-1.7,0.5-4.4-0.7-6.0c-2.3-2.4-6.0-3.0-9.1-1.4    c-1.5,0.7-2.9,1.8-3.9,3.2c-0.5,0.6-1.3,1.7-1.7,2.4    c-0.7,1.2-1.2,2.5-1.7,3.8c-3.2,9.0,0.6,18.6,6.4,24 M531.5,487.2    c0.3,0.3,0.7,0.8,1.0,1.2c0.1,0.4,0.3,0.8,0.4,1.3    c0.4,1.8-0.7,3.6-2.5,4.0c-0.1,0.0-0.3,0.0-0.5,0.0    c-2.2,0.2-4.4-1.0-5.2-3"
    S.path
      ! A.fill "#C6AA76"
      ! A.d "M432.3,214.4l1.0,0.7l1.1,1.2l0.7,1.5   l0.3,1.3l0.0,1.7l-0.0,1.1l-0.3,1.3l-0.7,0.9l-0.9,1.0   l-1.3,0.6l-1.7,0.3l-1.4,0.2l-1.5-0.6l-1.3-1.0l-0.8-1.2   l-0.6-1.5v-0.6l7.6-7.2L432.3,214.4z"
    S.path
      ! A.fill "none"
      ! A.stroke "#713F2A"
      ! A.strokeWidth "1"
      ! A.d "M608.5,216.8    c5.4,0.8,9.5,5.4,9.7,10.9c0,6.9-2.3,9.4-5.9,14.4    c-3.8,5.2-16.6,15.0-16.6,26.0c0,6.6,1.8,10.9,6.6,13.1    c3.1,1.4,6.7-0.1,8.3-1.6c4.0-3.6,2.4-10.0-1.7-10.8    c-5.1-0.9-6.0,7.1-1.0,6.6 M635.7,383.5    c-0.4-3.1-3.3-5.2-6.4-4.8c-2.8,0.4-4.9,2.9-4.8,5.8    c-0.0,1.5,0.5,2.9,1.6,4.0 M599.7,279.8    c-2.6,2.1-4.2,5.4-4.1,8.9c0,4.8,4.0,12.7,14.0,15.5    c3.8,1.0,7.4,0.9,9.7-0.4 M375.6,287.7    c-3.0,0.9-5.6,2.8-7.5,5.3c-1.8,2.6-2.9,6.2-3.6,9.4    c-0.5,3.4-0.4,6.9,0.2,10.4c0.6,3.1,1.8,6.1,3.6,8.8    c0.4,0.6,1.0,1.3,1.6,1.9c0.5,0.4,1.1,0.9,1.7,1.3     M471.7,469.0c7.5,3.3,13.1,5.8,17.8,13.3    c1.2,2.3,1.9,4.9,1.8,7.6c0.0,4.5-1.8,8.8-5.2,11.8    c-2.8,2.5-6.6,3.7-10.4,3.1c-3.0-0.2-5.8-2.4-6.2-4.0     M396.8,325.2c4.2,3.3,6.0,6.5,6.0,11.7    c0.1,4.7-2.1,9.1-6.2,11.6 M392.9,344.4    c6.3,7.9,9.7,12.6,9.9,22.0c0.1,8.8-2.6,14.9-7.9,21.3 M515.2,239.5    c1.2-0.8,2.0-2.0,2.4-3.4c0.7-2.3,0.7-4.3-0.4-6.0    c1.5,2.0,1.6,3.7,1.2,6.1c-0.2,1.5-1.2,2.3-2.4,3.4     M596.4,374.2v25.2h0.0c-0.0,1.2-0.0,2.5-0.2,3.8    c-0.1,0.9-0.2,1.8-0.4,2.7 M595.9,371.8v27.2h0.0    c-0.0,1.2-0.0,2.5-0.2,3.8c-0.2,1.5-0.4,2.8-0.7,4.1     M595.9,339.9v22.7 M596.4,341.7v18.4 M596.4,318.2v13.8     M595.9,316.6v17.0 M596.4,304.0v5.3 M595.9,303.0v7.7     M593.0,412.6c-0.1,0.3-0.3,0.7-0.5,1.0    c-1.5,3.3-3.8,6.3-6.5,8.8c-2.6,2.6-5.7,4.8-9.0,6.3    c-3.2,1.6-6.6,2.7-10.2,3.4c-3.5,0.8-7.1,1.2-10.7,1.3    c-3.3,0.1-6.6,0.0-9.9-0.2c-4.1-0.2-6.4-0.8-10.5-1.2    c-2.9-0.3-5.8-0.5-8.7-0.5c-3.0-0.0-6.0,0.1-8.9,0.6    c-2.7,0.4-5.4,1.1-8.0,2.2c-4.1,1.7-8.9,4.6-9.9,5.9    c-1.0-1.3-5.7-4.2-9.9-5.9c-2.5-1.0-5.3-1.8-8.0-2.2    c-2.9-0.5-5.9-0.7-8.9-0.6c-2.9,0.0-5.8,0.2-8.7,0.5    c-4.1,0.3-6.4,0.9-10.5,1.2c-3.2,0.3-6.6,0.3-9.9,0.2    c-3.6-0.0-7.2-0.5-10.7-1.3c-3.5-0.6-7.0-1.8-10.2-3.4    c-3.3-1.5-6.4-3.7-9.0-6.3c-1.4-1.3-2.6-2.7-3.8-4.3     M406.4,413.2c0.5,4.3-0.7,8.6-3.5,12.0    c-1.3,1.3-4.2,4.0-7.7,4.1c-5.9,0.0-7.6-3.9-8.0-4.9 M399.3,410.7    c1.1,1.1,2.1,2.5,2.8,3.9c1.4,2.7,1.0,7.4-0.1,9.6    c-0.1,0.2-0.3,0.5-0.4,0.7 M370.0,453.2    c3.5,3.6,8.8,7.6,16.9,11.0c11.1,4.5,28.2,5.6,40.1,6.1    c15.7,0.6,30.1,1.2,39.0,10.9 M493.2,475.0    c2.5,2.5,5.2,5.2,6.3,8.7 M488.1,501.7    c-2.9,3.1-7.2,4.6-11.5,4.2c-2.6-0.3-5.1-1.8-6.6-4.0     M461.6,497.3c0.1,0.1,0.2,0.3,0.4,0.5    c2.0,2.2,4.9,3.6,7.9,3.8 M512.0,501.6    c-2.0,3.1-6.8,7.7-11.8,9.6c-5.0-1.8-9.8-6.5-11.8-9.6    l-0.4-0.7 M512.1,501.6c0.3,0.3,0.7,0.7,1.1,1.1    c2.8,2.5,6.6,3.7,10.4,3.1c2.6-0.2,4.9-1.7,6.3-4.0    c0.3-0.3,0.5-0.7,0.6-1.1 M529.7,500.9l-1.1,1.8l-1.7,1.4    l-2.6,1.1l-2.4,0.1 M536.0,483.2    c1.5,1.1,2.7,2.7,3.5,4.5c0.4,1.1,0.7,2.4,0.7,3.6    c0.1,2.3-0.6,4.6-2.2,6.4c-2.1,2.3-5.2,3.7-8.4,3.8    c-0.2,0.0-0.4,0.0-0.7,0 M529.3,501.3    c-3.0,0.0-6.0-1.1-8.0-3.3 M620.7,391.9    c-3.0-2.9-5.5-6.3-7.5-10.0c-1.1-2.2-2.0-4.5-2.6-6.9    c-0.4-1.7-0.6-3.4-0.7-5.2c-0.0-3.2,0.2-6.5,0.9-9.7    c0.9-5.1,3.1-10.0,6.3-14.1c0.9-1.3,2.0-2.4,3.2-3.4     M618.2,223.8c3.9,0.3,7.6,4.5,7.5,8.7    c-0.0,6.0-2.1,8.5-6.8,14.5    c-4.1,5.1-16.4,14.1-16.1,22.7c0.1,1.6,0.7,3.1,1.8,4.3     M599.5,279.7c0.9,0.9,2.0,1.6,3.2,2.1    c2.1,0.8,4.6,0.6,6.6-0.4 M576.3,213.8    c1.5,0.9,2.6,2.4,3.4,4.0c2.9,7.0-3.4,12.2-9.2,16.2    c-3.9,2.6-8.3,4.3-12.9,5.1 M569.6,227.4    c-1.9-0.0-3.6-0.8-4.9-2.3c-0.4-0.4-0.8-0.9-1.1-1.5     M540.4,231.1c-0.7-0.3-1.4-0.8-2.0-1.5    c-1.7-1.8-2.2-4.5-1.2-6.8c0.9-2.9,5.7-11.2,5.9-17.0    c0.3-8.7-3.0-13.9-8.3-16 M542.6,203.8    l-0.2,3.3l-0.8,3.3l-1.7,4.6l-1.3,2.9l-1.3,2.9    l-0.6,2.0l-0.2,1.5l0.2,1.4 M595.8,423.3    c0.2,0.4,0.5,0.9,0.9,1.3c1.0,1.6,4.9,4.6,8.5,4.7    c5.9,0.0,7.3-4.0,7.4-4.9c0.7-4.5-0.7-5.7-3.1-7.0    c-0.9-0.4-1.9-0.5-2.9-0.4 M370.2,403.6    c-1.8,0.5-3.8,0.5-5.7,0.0c-4.4-1.3-8.0-5.5-6.1-10.8     M379.2,343.1c0.3,0.4,0.6,1.0,0.6,1.6    c0.6,5.7-4.3,7.4-7.9,6.4c-1.9-0.6-3.5-1.8-4.7-3.5    c-0.6-1.0-0.9-2.3-0.9-3.6 M400.7,307.1    c0.8,0.7,1.5,1.7,1.9,2.7 M400.8,296.6    c0.7,0.5,1.3,1.2,1.8,2.0 M402.9,303.9    c-0.5,1.3-1.4,2.6-2.4,3.7c-3.5,3.8-8.4,6.1-13.7,6.2    c-3.3,0.0-6.6-0.8-9.4-2.7c-3.1-2.0-5.4-5.1-6.3-8.7 M399.1,280.1    c1.6,1.3,2.9,3.2,3.6,5.2 M402.8,292.5    c-2.0,6.1-7.1,10.8-13.4,12.2c-3.8,0.9-8.7-0.2-10.3-1.6 M375.0,291.4    c0.4,4.1,3.1,7.2,8.4,7.3c7.3,0.1,11.8-10.5,5.2-18.0 M358.5,327.3    c1.0,1.3,2.3,2.5,3.6,3.6c2.7,2.3,5.8,4.0,9.2,5.1     M379.6,336.9c6.5-0.7,10.2-5.6,9.5-11.4    c-0.5-4.3-4.5-7.7-7.2-7.9 M390.3,268.9    c2.4,0.0,4.4,2.0,4.4,4.4c-0.0,0.0-0.0,0.1-0.0,0.1 M389.7,229.8    c1.4,3.8,4.2,7.0,7.8,9.0 M622.8,287.2    c2.6,3.6,0.9,10.9-6.3,11.0c-2.8-0.0-5.4-1.4-6.9-3.9 M596.4,239.2v24.6 M380.8,291.1    c2.2,1.6,5.1-1.1,4.0-4.0c-0.7-1.9-3.5-4.1-7.4-1.4    c-4.2,2.9-3.1,12.1,5.1,12.2    c7.3,0.1,11.8-10.5,5.2-18.0    c-6.2-7.2-17.7-5.5-25.1,0.3    c-5.5,4.6-9.4,11.0-11.0,18.1c-0.6,2.5-0.9,5.2-0.9,7.9    c0.1,6.4,2.0,12.8,5.5,18.2c0.6,0.9,1.2,1.7,2.0,2.5    c0.9,1.0,1.9,2.0,2.9,3.0c4.2,3.5,9.6,6.2,16.3,5.9    c7.3-0.3,11.5-5.4,10.7-11.5c-0.7-5.8-6.6-8.8-10.5-6.0    c-2.6,1.8-3.5,7.6,1.0,9.0c2.6,0.7,4.9-2.5,3.1-4.5     M584.4,210.6c4.2-2.2,7.4-1.8,9.8,1.4    c2.2,3.3,3.0,7.3,2.4,11.2c-0.8,4.1-2.0,5.9-5.4,8.9 M594.5,212.5    c4.8-3.1,10.0-1.8,12.9,2.4c2.0,3.1,2.6,5.7,2.4,9.5    c-0.3,6.0-3.6,11.4-8.9,14.3 M617.2,223.6    c4.1,0.4,7.1,3.9,7.1,8.0c0,5.9-1.6,8.5-6.4,14.5    c-4.1,5.1-16.4,14.1-16.1,22.7c0.1,3.2,2.8,6.3,5.2,6.5 M617.7,291.1    c-2.2,1.6-5.1-1.0-3.8-3.8c0.8-1.9,3.4-4.3,7.3-1.7    c4.2,2.9,3.1,12.1-5.1,12.2    c-7.3,0.1-12.3-10.2-5.2-18.0    c6.4-7.1,18.3-5.7,25.7,0.2c3.1,2.5,9.5,9.4,10.9,18.5    c1.6,11.0,1.4,24.5-9.9,32.9c-4.8,3.3-10.6,4.9-16.5,4.6    c-7.3-0.3-11.5-5.4-10.7-11.5c0.7-5.8,6.4-8.3,10.5-6.0    c4.3,2.3,3.5,8.4-1.0,9.0c-2.7,0.3-4.9-2.5-3.1-4.5 M613.8,287.3    c1.2-5.4,5.8-5.9,9.6-5.9c10.2,0.1,17.4,12.3,17.5,24.1    c0.1,14.9-6.3,23.7-17.2,24.1c-2.8,0.1-7.6-1.2-7.7-4.6 M620.2,284.8    c10.8,2.4,14.6,12.1,14.6,21.5c0,7.6-0.7,18.0-15.5,21.6 M638.1,389.5    c0.6-3.3-1.5-6.5-4.8-7.1s-6.5,1.5-7.1,4.8    c-0.4,2.2,0.4,4.5,2.2,5.9 M616.3,380.3    c2.3,3.8,5.7,7.0,9.7,9.2 M624.1,406.0    c-5.1-3.3-14.8-7.7-23.6-3.4c-3.2,1.6-5.4,3.5-6.6,6.8    c-1.7,5.1-0.6,10.7,2.7,14.9c1.3,1.3,4.2,4.0,7.7,4.1    c5.9,0.0,7.3-4.0,7.4-4.9c0.7-4.2-1.7-5.9-3.1-6.4    c-1.0-0.3-4.3-0.2-5.0,2.0c-0.3,1.0-0.1,2.1,0.3,3.1 M531.9,488.1    c1.6,3.3-0.2,5.0-2.4,5.2c-3.3,0.3-5.1-2.2-5.3-4.6    c-0.2-3.7,2.5-7.0,6.3-7.3c0.1-0.0,0.3-0.0,0.5-0.0    c3.4,0.1,6.4,2.2,7.7,5.4c0.4,1.1,0.7,2.4,0.7,3.6    c0.1,2.3-0.6,4.6-2.2,6.4c-2.1,2.3-5.2,3.7-8.4,3.8    c-6.5,0.2-11.7-5.9-11.7-12.2c0-12.0,17.8-18.6,24.9-20.3    c8.7-2.0,14.0-2.8,27.9-3.6c5.5-0.3,9.6-0.1,15.8-0.7    c4.7-0.3,9.4-1.0,14.0-2.1c7.2-1.5,14.0-4.9,19.5-9.9    c4.5-4.1,7.1-7.0,9.2-12.7c1.8-4.8,2.6-14.5-1.9-21.7    c-3.5-5.7-9.4-9.6-16.1-10.5c-5.8-0.8-10.9,1.6-13.9,7.4    c-1.4,2.7-1.0,7.4,0.1,9.6c1.5,2.7,4.3,4.4,7.4,4.6    c5.9,0.0,7.3-4.0,7.4-4.9c0.7-4.2-1.7-5.9-3.1-6.4    c-1.0-0.3-4.3-0.2-5.0,2.0c-0.3,1.0-0.1,2.1,0.3,3.1 M526.9,469.0    c-7.5,3.3-13.1,5.8-17.8,13.3c-1.2,2.3-1.9,4.9-1.8,7.6    c-0.0,4.5,1.8,8.8,5.2,11.8c2.8,2.5,6.6,3.7,10.4,3.1    c3.0-0.2,5.8-2.4,6.2-4.0 M601.7,325.2    c-3.5,1.1-6.0,6.5-6.0,11.7c-0.1,4.7,2.1,9.1,6.2,11.6 M605.6,344.4    c-6.3,7.9-9.7,12.6-9.9,22.0c-0.1,8.8,2.6,14.9,7.9,21.3 M571.6,212.5l0.5-0.8    c2.6-3.8,7.3-4.9,10.7-2.3c4.1,3.1,5.1,8.4,4.0,13.9    c-0.8,3.5-3.1,6.6-6.3,8.5 M414.2,210.6    c-4.0-1.8-7.3-1.5-9.8,1.4c-2.8,3.4-2.9,8.4-2.4,11.2    c0.8,4.1,2.0,5.9,5.4,8.9 M404.0,212.5    c-4.8-3.1-10.0-1.8-12.9,2.4c-2.1,3.1-2.6,5.7-2.4,9.5    c0.3,6.0,3.6,11.4,8.9,14.3 M390.1,216.8    c-5.3,0.6-9.3,5.0-9.3,10.4c0,6.9,1.7,9.7,5.5,15.0    c3.8,5.2,16.6,15.0,16.6,26.0c0,6.6-1.8,10.9-6.6,13.1    c-3.1,1.4-6.7-0.1-8.3-1.6c-4.0-3.6-2.4-10.0,1.7-10.8    c5.1-0.9,6.0,7.1,1.0,6.6 M381.3,223.6    c-3.9,0.3-7.8,3.7-7.8,7.9c0,5.9,2.3,8.7,7.1,14.7    c4.1,5.1,15.7,13.9,15.4,22.6c-0.1,3.2-2.3,7.2-4.4,6.7 M372,343.9    c1.8-4.5,6.6-2.4,6.9,0c0.6,5.7-4.3,7.4-7.9,6.5    c-1.6-0.4-3.0-1.5-3.8-3.0c-0.9-1.7-1.1-3.8-0.6-5.8    c0.2-0.9,0.7-1.8,1.3-2.5c0.5-0.7,1.2-1.3,1.9-1.8    c1.3-0.8,2.8-0.9,5.2-0.9c8.7,0,16.3,10.2,18.8,20.9    c1.4,6.1,1.5,12.5,0.3,18.8c-1.2,6.6-4.4,12.7-9.1,17.5    c-2.6,2.5-5.7,4.7-8.9,6.4c-2.0,1.0-4.2,1.9-6.4,2.6    c-1.9,0.6-4.1,0.6-6.1,0.1c-4.4-1.3-7.2-5.4-4.9-10.8    c1.7-4.1,8.3-6.2,11.3-1.0c0.4,0.7,0.6,1.5,0.6,2.4    c0.0,1.3-0.5,2.7-1.5,3.6c-2.2,1.4-5.8,1.0-5.6-2.9 M365.2,397.4    c1.6,0.6,2.5,0.5,4.5-0.3c0.8-0.3,1.7-0.9,2.9-1.5    c3.9-2.2,8.7-5.8,13.1-14.1c1.1-2.2,2.0-4.5,2.6-6.9    c0.4-1.7,0.6-3.4,0.7-5.2c0.0-3.2-0.2-6.5-0.9-9.7    c-0.9-5.1-3.1-10.0-6.3-14.1c-1.7-2.4-3.3-3.9-6.6-4.0     M360.5,389.5c-0.6-3.3,1.5-6.5,4.8-7.1    c3.3-0.6,6.5,1.5,7.1,4.8c0.4,2.2-0.4,4.5-2.2,5.9 M362.8,383.5    c0.4-3.1,3.3-5.2,6.4-4.8c2.8,0.4,4.9,2.9,4.8,5.8    c0.0,1.5-0.5,2.9-1.6,4.0 M374.0,383.2    c6.0-4.5,9.6-11.6,9.7-19.2c0.0-6.4-2.5-13.0-5.5-15.6 M382.2,380.3    c-2.3,3.8-5.7,7.0-9.7,9.2 M397.8,402.6    c-1.4-3.4-4.3-4.9-9.0-5.4c-4.6-0.4-8.6,0.7-12.8,3.0    c-8.0,4.3-12.5,8.9-15.5,17.6c-0.9,2.9-1.3,5.9-1.3,9.0    c0.1,5.6,1.5,11.7,3.0,14.6c1.3,2.5,4.8,13.9,23.9,21.8    c11.1,4.5,28.2,5.6,40.1,6.1    c16.2,0.6,31.2,1.2,39.9,11.9 M374.5,406.0    c5.1-3.3,14.8-7.7,23.6-3.4c3.2,1.6,5.4,3.5,6.6,6.8    c1.7,5.1,0.6,10.7-2.7,14.9c-1.3,1.3-4.2,4.0-7.7,4.1    c-5.9,0.0-7.3-4.0-7.4-4.9c-0.7-4.2,1.7-5.9,3.1-6.4    c1.0-0.3,4.3-0.2,5.0,2.0c0.3,1.0,0.1,2.1-0.3,3.1"
    S.path
      ! A.fill "none"
      ! A.stroke "#713F2A"
      ! A.strokeWidth "1"
      ! A.d "M394.8,421.4    c0.5-1.8,0.0-3.8-1.3-5.2c-2.4-2.3-6.1-2.9-9.1-1.3    c-1.5,0.7-2.9,1.8-3.9,3.2c-0.5,0.6-1.3,1.7-1.7,2.4    c-0.7,1.2-1.2,2.5-1.7,3.8c-3.8,10.9,2.4,22.5,10.2,27.5    c6.8,4.3,13.8,5.5,22.4,6.3c3.9,0.3,6.2,0.4,10.2,0.6    c3.2,0.1,6.0,0.0,8.6,0.0c2.1-0.0,4.2-0.0,6.2-0.0    c3.7-0.1,7.5-0.0,11.2,0.1c4.5,0.3,7.9,0.4,11.8,1.0    c2.5,0.4,5.4,0.8,8.5,1.5c0.9,0.2,1.8,0.3,2.8,0.6    c0.6,0.1,1.2,0.3,1.8,0.5c5.3,1.4,10.4,3.6,15.2,6.5    c1.3,0.7,2.6,1.6,3.8,2.7c0.7,0.7,1.4,1.2,2.1,1.8    c2.9,2.9,6.0,6.1,6.7,10.4c0.1,0.8,0.1,1.6,0.1,2.5    c0,2.7-2.2,6.6-8.4,7.8 M466.6,488.1    c-1.6,3.3,0.2,5.0,2.4,5.2c3.3,0.3,5.1-2.2,5.3-4.6    c0.2-3.7-2.5-7.0-6.3-7.3c-0.1-0.0-0.3-0.0-0.5-0.0    c-3.4,0.1-6.4,2.2-7.7,5.4c-0.4,1.1-0.7,2.4-0.7,3.6    c-0.1,2.3,0.6,4.6,2.2,6.4c2.1,2.3,5.2,3.7,8.4,3.8    c6.6,0.2,11.7-5.9,11.7-12.2c0-12.0-17.8-18.6-24.9-20.3    c-8.7-2.0-14.0-2.8-27.9-3.6c-5.5-0.3-9.6-0.1-15.8-0.7    c-4.7-0.3-9.4-1.0-14.0-2.1c-7.2-1.5-14.0-4.9-19.5-9.9    c-4.5-4.1-7.1-7.0-9.2-12.7c-1.8-4.8-2.6-14.5,1.9-21.7    c3.5-5.7,9.4-9.6,16.1-10.5c5.8-0.8,10.9,1.6,13.9,7.4    c1.4,2.7,1.0,7.4-0.1,9.6c-1.5,2.7-4.3,4.4-7.4,4.6    c-5.9,0.0-7.3-4.0-7.4-4.9c-0.7-4.2,1.7-5.9,3.1-6.4    c1.0-0.3,4.3-0.2,5.0,2.0c0.3,1.0,0.1,2.1-0.3,3.1 M426.9,212.5    c-0.1-0.2-0.3-0.5-0.5-0.8c-2.6-3.8-7.3-4.9-10.7-2.3    c-4.1,3.1-5.1,8.4-4.0,13.9c0.8,3.5,3.1,6.6,6.3,8.5 M573.0,224.3    c-6.2,6.8-12.5,9.0-22.0,9.3c-2.9,0.0-8.5-0.9-11.8-3.2    c-2.0-1.4-4.4-4.0-2.9-8.4c0.9-2.9,5.7-11.2,5.9-17.0    c0.3-8.7-3.0-13.6-8.3-15.4c-9.7-3.4-20.2,6.2-26.5,8.3    c-2.5,0.9-5.2,1.3-8.0,1.2c-2.7,0.1-5.4-0.3-8.0-1.2    c-6.3-2.1-16.8-11.7-26.5-8.3c-5.2,1.8-8.6,6.6-8.3,15.4    c0.2,5.7,4.9,14.0,5.9,17.0c1.4,4.4-0.8,6.9-2.9,8.4    c-3.2,2.3-8.8,3.3-11.8,3.2c-9.4-0.3-15.7-2.4-22.0-9.3 M464.5,466.2    c1.2,0.4,0.3-0.2,8.1,3.2c7.5,3.3,12.9,6.2,17.6,13.7    c1.2,2.3,1.9,4.9,1.8,7.6c-0.0,1.2-0.1,2.5-0.4,3.8 M465.0,500.0    c1.5,0.7,3.3,1.2,5.0,1.2c6.6,0.2,11.7-5.9,11.7-12.2    c0-4.3-2.3-8.0-5.7-11 M466.5,488.1    c-1.5,3.5,0.6,5.4,2.9,5.7c2.6,0.3,5.1-1.6,5.4-4.3    c0.0-0.1,0.0-0.2,0.0-0.3c0.2-2.6-1.0-5.1-3.2-6.4 M609.5,216.8    c5.0,0,9.3,5.5,9.3,11.3c0,6.6-3.5,10.6-6.0,13.7    c-2.0,2.4-4.3,4.6-6.9,7.3 M603.5,211.5    c1.7,0.8,3.2,2.1,4.3,3.8c2.0,3.1,2.6,5.7,2.4,9.5    c-0.2,6.6-4.9,11.1-9.2,13.9 M593.7,211.5    c0.3,0.3,0.6,0.6,1,1.0c2.8,3.4,3.0,8.4,2.4,11.2    c-1.0,4.2-2.4,6.0-5.8,8.5 M583.3,209.8    c4.1,3.1,5.3,8.4,3.9,14.0c-0.9,3.9-3.4,6.3-6.5,8.2     M598.1,296.2c0.4,1.4,1.3,1.9,2.3,3.0    c2.6,2.6,5.9,4.5,9.6,5.5c3.3,0.9,6.9,0.4,9.8-1.3     M365.2,387.8c1.9-0.0,3.8,1.2,5.1,3.4    c0.4,0.7,0.6,1.5,0.6,2.4c0.0,1.3-0.5,2.6-1.5,3.4    c-2.2,1.4-6.2,0.8-6.0-3.1 M377.3,336.3    c7.7,1.4,15.1,10.7,17.5,20.8c1.4,6.1,1.5,12.5,0.3,18.8    c-1.2,6.6-4.4,12.7-9.1,17.5c-1.0,1.0-2.1,1.9-3.3,2.8    l-1.6,1.1 M368.7,378.6c3.1,0,5.9,3.0,5.9,6.2    c0.0,1.5-0.5,2.9-1.6,4.0 M366.6,382.3    c3.5,0.2,6.2,3.0,6.4,6.5c0.0,1.8-0.8,3.6-2.3,4.7 M396.8,349.2    c3.0,4.0,5.0,7.5,5.9,12.0 M402.6,374.5    c-0.4,2.1-1.2,4.3-2.2,6.3c-1.4,2.7-3.3,5.1-5.5,7.2 M397.3,325.5    c2.5,1.8,4.5,4.4,5.5,7.4 M402.8,317.9    c-0.7,2.6-2.5,4.6-5.2,7.1 M383.3,298.2l3.3-0.8l1.9-1.5    l1.2-1.8l1.1-2.8l0.4-2.3 M376.5,286.4    c-1.3,0.3-2.5,0.7-3.8,1.3c-2.2,1.0-4.0,2.5-5.5,4.5    c-1.8,2.6-2.9,6.2-3.6,9.4c-0.5,3.4-0.4,6.9,0.2,10.4    c0.6,3.1,1.8,6.1,3.6,8.8c0.4,0.7,1.0,1.4,1.6,2.0    c2.0,2.0,3.8,3.2,6.9,2.6 M395.3,271.5    c-0.5,2.0-1.6,4.4-4.7,4.2 M383.8,285.2    c-3.0-2.9-9.4-3.7-15.7,0.3c-0.8,0.5-1.6,1.1-2.4,1.8    c-0.8,0.7-1.6,1.5-2.2,2.4c-0.8,1.2-1.5,2.4-2.1,3.7    c-0.6,1.3-1.1,2.7-1.4,4.1c-0.8,3.1-1.1,6.4-1.0,9.7    c0.1,1.5,0.3,2.9,0.5,4.1c0.5,3.3,1.7,6.6,3.4,9.6    c1.4,2.3,4.9,7.6,12.0,8.3c2.8,0.2,7.6-1.0,7.7-4.6 M568.3,220.4    c0.4-2.5,3.5-3.0,4.7-1.5c1.7,2.3,0.6,6.3-3.0,7.5    c-2.2,0.5-4.5-0.3-5.9-2.1c-2.1-3.0-1.4-7.2,1.5-9.4    c0.0-0.0,0.1-0.1,0.2-0.1c4.2-3.2,11.1-2.4,13.3,2.9    c2.9,7.0-3.4,12.2-9.2,16.2c-7.3,4.9-15.7,5.8-22.0,5.8    c-14.3-0.1-25.1-6.9-32.2-10.8c-1.6-0.9-3.3-0.7-4.1,0.3    c-1.0,1.3-0.8,3.1,0.3,4.2 M571.2,218    c0.9-0.0,1.8,0.4,2.3,1.2c1.7,2.3,0.4,6.3-3.1,7.5     M598.3,307.3c-5.4,5.9-0.4,16.1,3.6,18.4    c1.4,1.0,2.0,0.5,3.1,1.1 M598.6,295.9    c-1.7,1.2-2.4,2.6-2.4,5.0c-0.1,2.3,0.6,4.5,2.2,6.2    c2.9,3.0,8.7,5.7,14.4,5.8c3.3,0.0,6.6-0.8,9.4-2.7    c2.9-1.9,5.1-4.9,5.9-8.3 M595.5,398.6    c-0.0,1.2-0.0,2.5-0.2,3.8c-0.9,7.4-4.3,14.4-9.7,19.6    c-2.6,2.6-5.7,4.8-9.0,6.3c-3.2,1.6-6.6,2.7-10.2,3.4    c-3.5,0.8-7.1,1.2-10.7,1.3c-3.3,0.1-6.6,0.0-9.9-0.2    c-4.1-0.2-6.4-0.8-10.5-1.2c-2.9-0.3-5.8-0.5-8.7-0.5    c-3.0-0.0-6.0,0.1-8.9,0.6c-2.7,0.4-5.4,1.1-8.0,2.2    c-4.1,1.7-8.9,4.6-9.9,5.9c-1.0-1.3-5.7-4.2-9.9-5.9    c-2.5-1.0-5.3-1.8-8.0-2.2c-2.9-0.5-5.9-0.7-8.9-0.6    c-2.9,0.0-5.8,0.2-8.7,0.5c-4.1,0.3-6.4,0.9-10.5,1.2    c-3.2,0.3-6.6,0.3-9.9,0.2c-3.6-0.0-7.2-0.5-10.7-1.3    c-3.5-0.6-7.0-1.8-10.2-3.4c-3.3-1.5-6.4-3.7-9.0-6.3    c-5.4-5.2-8.8-12.1-9.7-19.6c-0.1-1.2-0.2-2.5-0.2-3.8    V239.5h192.5v159.0h0.0H595.5z"
    S.path
      ! A.fill "#713F2A"
      ! A.stroke "#713F2A"
      ! A.strokeWidth "0.3"
      ! A.d "M520.7,211.9   c-0.0-2.6-2.6-2.9-3.6-2.9c-2.8,0-3.6,1.8-7.2,3.7   c-4.5,2.4-6.4,2.9-10.4,2.9c-4.0-0.0-6.0-0.5-10.5-2.9   c-3.6-1.9-4.2-3.6-7.0-3.6c-2.0,0.0-3.5,1.7-3.5,3.7   c0.0,0.0,0.0,0.0,0.0,0.0c-0.0,0.4,0.0,0.9,0.0,1.3   c0.0,0.2,0.2,0.1,0.3,0.3c-0.0-0.9,0.1-1.8,0.7-2.6   c0.6-0.7,1.5-1.2,2.5-1.3c2.8,0,3.9,1.8,7.5,3.7   c4.5,2.4,6.4,2.9,10.4,2.9c4.0-0.0,6.0-0.5,10.5-2.9   c3.5-1.9,4.6-3.9,7.5-3.9c0.9,0.0,1.8,0.7,2.0,1.6   c0.1,0.4,0.1,0.8,0.1,1.2c0.0,0.1,0.1,0.1,0.2,0.2   c0.2-0.5,0.3-1.1,0.2-1.7L520.7,211.9z"
    S.path
      ! A.fill "#713F2A"
      ! A.d "M413.1,434.4c0.8-0.8,1.4-0.5,1.5-0.9   c0.1-0.2-0.1-0.3-0.4-0.4c-0.4-0.1-0.9-0.2-1.3-0.4   c-0.4-0.1-0.8-0.4-1.3-0.5c-0.1-0.0-0.6-0.2-0.7,0.0   c-0.2,0.6,1.6,0.5,0.9,2.2c-0.2,0.7-0.7,1.3-1.2,1.8   l-4.1,4.5c-0.0,0.1-0.2,0.3-0.3,0.2   c-0.0-0.0-0.0-0.3-0.0-0.4l0.0-6.3   c-0.0-0.8,0.0-1.7,0.3-2.6c0.2-0.7,1.1-0.1,1.2-0.5   c0.1-0.2,0.0-0.3-0.4-0.4c-0.2-0.0-0.7-0.1-1.7-0.5   c-0.5-0.2-1.0-0.4-1.5-0.6c-0.2-0.0-0.6-0.4-0.8,0.0   c-0.0,0.1,0.1,0.3,0.1,0.3c0.5,0.2,0.8,0.8,0.7,1.4   l0.1,11.6c0.0,0.8,0.1,1.0,0.2,1.1   c0.1,0.0,0.2-0.0,0.6-0.3l8.2-8.9L413.1,434.4z M417.9500122,436.2200012c0.5329895-1.6900024,1.5320129-0.67099,1.7229919-1.276001   c0.0669861-0.2139893-0.0010071-0.2749939-0.4819946-0.4259949c-0.9129944-0.2879944-1.5119934-0.3980103-2.0880127-0.5799866   c-0.5599976-0.177002-1.1629944-0.4450073-1.7879944-0.6419983c-0.1440125-0.04599-0.5270081-0.2250061-0.6229858,0.0769958   c-0.1960144,0.6229858,1.769989,0.6950073,1.2600098,2.3139954l-2.6929932,8.5419922   c-0.5329895,1.6900024-1.5400085,0.8640137-1.7359924,1.4859924c-0.0280151,0.0899963-0.0360107,0.223999,0.1090088,0.269989   c0.4159851,0.131012,1.1270142,0.2770081,1.8160095,0.493988c1.2489929,0.3940125,1.8190002,0.6520081,2.4119873,0.8389893   c0.3680115,0.1159973,0.5339966,0.0899963,0.5960083-0.1059875c0.1799927-0.5700073-1.8720093-0.3160095-1.1820068-2.5050049   l2.6759949-8.4869995L417.9500122,436.2200012z M423.730011,437.9299927c0.3179932-1.072998,0.8169861-0.9259949,1.4129944-0.75   c1.6260071,0.4830017,2.1350098,2.072998,1.6159973,3.8269958c-0.3129883,1.0549927-0.7059937,2.0280151-3.1530151,1.303009   c-0.4830017-0.1430054-1.07901-0.3200073-0.9460144-0.7659912l1.0700073-3.6140137H423.730011z M419.2960205,445.6260071   c-0.6669922,2.2539978-1.7969971,1.2780151-1.9660034,1.8500061c-0.1059875,0.3580017,0.2479858,0.4039917,0.4249878,0.4570007   c0.8049927,0.2380066,1.631012,0.4049988,2.5,0.6629944c0.677002,0.2000122,1.0899963,0.3999939,1.3640137,0.4809875   c0.3699951,0.1099854,0.5299988,0.0400085,0.57901-0.1199951c0.1900024-0.6440125-1.6210022-0.3829956-1.0539856-2.2969971   l0.9169922-3.0950012c0.1849976-0.6260071,0.1260071-0.7799988,0.9790039-0.5270081   c0.8049927,0.2380066,1.0469971,0.4849854,1.1839905,1.3819885l0.5150146,3.2269897   c0.1919861,1.1860046,0.3739929,2.4649963,1.644989,2.8420105c0.6440125,0.1900024,1.8240051,0.1119995,1.9880066-0.4429932   c0.0461121-0.1284485-0.0206604-0.2699585-0.1491089-0.3160706c-0.0062256-0.0022278-0.0125122-0.0041809-0.0188904-0.0059204   c-0.1600037-0.0480042-0.3529968,0.0109863-0.5140076-0.0360107c-0.241272-0.0409241-0.4355164-0.2206421-0.4949951-0.4580078   c-0.4909973-2.5969849-1.0920105-5.5960083-1.0599976-5.70401c0.053009-0.1789856,0.5679932-0.2009888,1.1560059-0.4750061   c0.7975464-0.3823242,1.382782-1.1006775,1.5960083-1.9590149c0.243988-0.822998,0.6700134-3.4400024-2.8559875-4.4849854   c-1.0799866-0.3200073-2.1950073-0.571991-3.2739868-0.8919983c-1.0140076-0.2999878-1.1220093-0.4100037-1.8619995-0.6300049   c-0.1929932-0.0559998-0.381012-0.0150146-0.4339905,0.1640015c-0.1900024,0.6440125,1.7600098,0.5020142,1.1669922,2.5050049   l-2.3320007,7.8720093L419.2960205,445.6260071z M432.460022,449.480011   c-0.5180054,2.1589966-2.1539917,0.8450012-2.3240051,1.552002c-0.0960083,0.3999939,0.1860046,0.447998,0.480011,0.5190125   c0.6530151,0.1560059,1.2099915,0.2130127,2.303009,0.4760132c1.0939941,0.2630005,1.6149902,0.4649963,2.2690125,0.6220093   c0.4729919,0.1130066,0.7869873,0.2460022,0.8909912-0.1900024c0.1220093-0.5069885-2.0939941-0.4830017-1.5580139-2.7149963   l1.9679871-8.2000122c0.2099915-0.8699951,0.394989-0.9219971,1.0639954-0.7609863l1.3880005,0.3330078   c1.894989,0.3779907,0.8890076,2.2669983,1.5419922,2.4230042c0.4249878,0.1019897,0.4150085-0.6480103,0.4349976-0.8739929   l0.2200012-1.7120056c0.0280151-0.1849976,0.0889893-0.4400024-0.1560059-0.4979858   c-1.5180054-0.3649902-2.6300049-0.5549927-5.0140076-1.1270142c-2.3840027-0.572998-3.4599915-0.9079895-4.9779968-1.2720032   c-0.2449951-0.0599976-0.3059998,0.1950073-0.3659973,0.3720093l-0.8359985,2.3320007   c-0.0899963,0.2279968-0.2829895,0.6040039,0.0599976,0.6860046c0.7340088,0.1759949,0.8150024-2.3179932,2.6600037-1.875   l1.3720093,0.3299866c0.6690063,0.1600037,0.8099976,0.2900085,0.6010132,1.1610107l-2.019989,8.4179993L432.460022,449.480011z    M452.3000183,444.4200134c0.6459961-1,1.3059998-0.7820129,1.3850098-1.20401   c0.0570068-0.3120117-0.1839905-0.2999878-0.5299988-0.3640137c-0.4630127-0.0859985-0.9389954-0.0979919-1.401001-0.1839905   c-0.4790039-0.0889893-0.928009-0.2479858-1.4060059-0.3370056c-0.197998-0.0369873-0.6669922-0.1799927-0.7319946,0.1679993   c-0.118988,0.6430054,1.6749878,0.2730103,1.355011,1.9970093c-0.1698303,0.743866-0.4859619,1.4465027-0.9299927,2.0669861   l-3.2950134,5.1579895c-0.072998,0.118988-0.1870117,0.3640137-0.2860107,0.3450012   c-0.1000061-0.0180054-0.1340027-0.2900085-0.1600037-0.428009l-1.052002-6.3049927   c-0.1909485-0.8689575-0.2442627-1.7625122-0.1579895-2.6480103c0.1430054-0.769989,1.0830078-0.3110046,1.1749878-0.8070068   c0.0570068-0.3120117-0.0289917-0.3089905-0.5570068-0.4070129c-0.2640076-0.0490112-0.756012-0.0639954-1.8129883-0.2600098   c-0.5610046-0.1040039-1.1099854-0.2810059-1.6539917-0.3819885c-0.2479858-0.04599-0.7319946-0.2879944-0.8139954,0.1520081   c-0.0239868,0.1289978,0.1700134,0.2789917,0.2170105,0.3059998c0.5661011,0.1993103,0.9551086,0.7215576,0.9840088,1.3210144   l2.1319885,11.4400024c0.1549988,0.8250122,0.2860107,1.0390015,0.4509888,1.0700073   c0.1820068,0.0339966,0.2850037-0.0610046,0.5549927-0.5050049l6.5339661-10.1929626H452.3000183z M453.230011,454.9300232   c0.0090027,0.4559937-0.0320129,0.6000061,0.3630066,0.7799988c0.8484802,0.4964294,1.7563477,0.8835144,2.7019958,1.1520081   c2.1690063,0.3619995,3.9670105-1.019989,4.3699951-3.4299927c0.3909912-2.3380127-0.5700073-3.3120117-2.196991-4.4729919   c-2.0369873-1.4570007-2.9079895-1.8500061-2.7019958-3.0820007c0.0591125-0.9782715,0.9000854-1.7234192,1.8783875-1.6643066   c0.095459,0.0057678,0.1903076,0.0192566,0.2835999,0.0403137c2.848999,0.4760132,2.5239868,3.9400024,2.9049988,4.0039978   c0.3640137,0.0610046,0.4500122-0.151001,0.4859924-0.5620117l0.230011-2.4960022   c0.0379944-0.4289856,0.1340027-0.696991-0.1149902-0.7380066c-0.2149963-0.0360107-0.6789856,0.1900024-0.8940125,0.1530151   c-0.4960022-0.0830078-1.071991-0.9169922-2.4299927-1.1440125c-1.9379883-0.3250122-3.5209961,1-3.875,3.1159973   c-0.3240051,1.9320068,0.5329895,2.8129883,1.8399963,3.75c2.447998,1.7529907,3.4519958,2.1669922,3.1900024,3.7309875   c-0.1183777,1.228302-1.210083,2.1280823-2.4384155,2.0097046c-0.0811157-0.0078125-0.1617737-0.0200806-0.2415771-0.0367126   c-1.8380127-0.3080139-2.5849915-2.1539917-2.8200073-4.0100098c-0.0249939-0.25-0.0299988-0.4200134-0.29599-0.4649963   c-0.4140015-0.0690002-0.3370056,0.4920044-0.3299866,0.7579956l0.0910034,2.6069946L453.230011,454.9300232z    M477.9500122,447.960022c0.5379944-1.0620117,1.2170105-0.9150085,1.2510071-1.3429871   c0.0249939-0.3160095-0.2139893-0.2789917-0.5660095-0.3059998c-0.4679871-0.0369873-0.9429932,0-1.4119873-0.0360107   c-0.4849854-0.0379944-0.947998-0.1499939-1.4330139-0.1879883c-0.2009888-0.0159912-0.6820068-0.1099854-0.7099915,0.2430115   c-0.0509949,0.651001,1.6940002,0.0960083,1.5559998,1.8450012c-0.0914612,0.7570801-0.3320923,1.4885254-0.7080078,2.1520081   l-2.7390137,5.473999c-0.0599976,0.1260071-0.1480103,0.381012-0.2479858,0.3739929   c-0.1000061-0.0100098-0.1640015-0.2749939-0.20401-0.4100037l-1.70401-6.1600037   c-0.2816162-0.8440552-0.4284058-1.7272339-0.4349976-2.6170044c0.0620117-0.7799988,1.0440063-0.4230042,1.0840149-0.9249878   c0.0239868-0.3160095-0.0599976-0.3039856-0.5960083-0.3460083c-0.2680054-0.019989-0.7600098,0.0159912-1.8299866-0.0700073   c-0.5700073-0.0440063-1.1329956-0.1629944-1.6849976-0.2070007c-0.2510071-0.019989-0.7590027-0.2099915-0.7940063,0.2369995   c-0.0109863,0.1300049,0.1990051,0.2600098,0.2470093,0.2820129c0.584259,0.138092,1.0264282,0.6166687,1.1180115,1.2099915   l3.3160095,11.1539917c0.2399902,0.8049927,0.3930054,1.0039978,0.5599976,1.0169983   c0.1839905,0.0140076,0.2770081-0.0910034,0.4989929-0.5599976l5.4330139-10.8200073H477.9500122z"
    S.path
      ! A.fill "#713F2A"
      ! A.d "M480.6,457c-0.0,1.9-1.6,1.5-1.6,2.2 c-0.0,0.3,0.3,0.2,0.5,0.2c0.4,0,0.9-0.0,1.4-0.0 c0.5,0.0,1.1,0.0,1.9,0.0c0.2,0,0.6,0.0,0.6-0.2 c0.0-0.8-2.1,0.3-2.1-3.2l0.0-6.3 c0-0.1,0.0-0.2,0.1-0.2c0.0,0,0.1,0.0,0.2,0.2l7.9,9.7 c0.0,0.1,0.2,0.2,0.4,0.2c0.2,0,0.2-0.1,0.2-0.5 l0.0-10.4c0.0-1.9,1.4-1.4,1.4-2.0 c0-0.0,0.0-0.2-0.3-0.2c-0.1,0-0.7,0.0-1.7,0.0 c-1.1-0.0-1.6-0.0-1.9-0.0c-0.2,0-0.2,0.1-0.2,0.3 c-0.0,0.6,2.0,0.2,2.0,1.9l-0.0,6.2 c-0.0,0.4-0.0,0.6-0.1,0.6c-0.1-0.0-0.2-0.2-0.5-0.4 l-6.6-8.2c-0.2-0.3-0.0-0.4-0.6-0.4 c-0.8-0.0-1.3,0.0-1.7,0.0c-0.3,0-0.6-0.0-0.9-0.0 c-0.1-0.0-0.2,0.1-0.2,0.2c-0.0,0.0,0.0,0.0,0.0,0.0 c-0.0,0.8,1.8-0.3,1.8,3.2l-0.0,7.0V457z M496.8,448.6 c0.0-1.7,1.2-1.0,1.2-1.7c0.0-0.2-0.0-0.2-0.5-0.2 c-0.9-0.0-1.5,0.0-2.1,0.0c-0.5,0-1.2-0.0-1.8-0.0 c-0.1-0.0-0.5-0.0-0.5,0.2c-0.0,0.6,1.8,0.1,1.7,1.8 l0.0,8.9c-0.0,1.7-1.2,1.2-1.2,1.9 c-0.0,0.0,0.0,0.2,0.1,0.2c0.4,0.0,1.1-0.0,1.8-0.0 c1.3,0.0,1.9,0.0,2.5,0.0c0.3,0,0.5-0.0,0.5-0.2 c0.0-0.5-1.8,0.2-1.8-2.0L496.8,448.6z M503.9,457.2 c0.0,2.2-1.8,1.3-1.8,2.0c0.0,0.4,0.2,0.3,0.5,0.3 c0.6-0.0,1.2-0.0,2.3-0.0s1.6,0.0,2.3,0.0 c0.4,0,0.8,0.0,0.8-0.3c-0.0-0.5-2.1,0.0-2.1-2.2 l-0.0-8.4c-0.0-0.8,0.1-0.9,0.8-0.9l1.4-0.0 c1.9-0.0,1.4,1.9,2.0,1.9c0.4,0,0.2-0.7,0.2-0.9 l-0.2-1.7c-0.0-0.1-0.0-0.4-0.2-0.4 c-1.5,0.0-2.6,0.0-5.1,0.1c-2.4,0.0-3.5-0.0-5.1-0.0 c-0.2,0-0.2,0.2-0.2,0.4l-0.2,2.4 c-0.0,0.2-0.1,0.6,0.2,0.6c0.7-0.0,0.2-2.4,2.1-2.4 l1.4-0.0c0.6-0.0,0.8,0.0,0.8,0.9l0.0,8.6L503.9,457.2z  M513.6,453.7c-0.3,0.0-0.5,0.0-0.5-0.1 c-0.0-0.2,0.0-0.4,0.1-0.7l1.0-3.3 c0.0-0.2,0.1-0.2,0.1-0.2c0.0-0.0,0.0,0,0.1,0.1 l1.6,3.2c0.1,0.2,0.2,0.4,0.2,0.6 c0.0,0.1-0.2,0.1-0.5,0.2l-2.2,0.1V453.7z M516.5,454.5 c0.4-0.0,0.5,0.1,1.2,1.5c0.2,0.3,0.3,0.7,0.4,1.2 c0.0,1.1-1.1,1.0-1.0,1.5c0.0,0.2,0.2,0.2,0.5,0.1 c0.4-0.0,1.0-0.1,1.8-0.2c1.1-0.0,1.5-0.0,2.1-0.0 c0.4-0.0,0.6-0.0,0.5-0.3c-0.0-0.6-0.8,0.1-1.5-1.0 l-5.4-11.0c-0.2-0.5-0.2-0.5-0.4-0.5 c-0.2,0.0-0.2,0.3-0.3,0.6l-3.6,11.6 c-0.3,1.0-1.1,1.0-1.1,1.4c0.0,0.2,0.2,0.1,0.5,0.1 c0.4-0.0,0.9-0.1,1.4-0.1c0.5-0.0,1.0-0.0,1.5-0.0 c0.3-0.0,0.8,0.0,0.8-0.3c-0.0-0.5-1.8-0.0-1.9-1.4 c0.0-0.5,0.0-1.0,0.2-1.4c0.2-1.2,0.6-1.3,0.9-1.3 l3.2-0.2L516.5,454.5z M529.5,446.7 c-0.1-1.2-0.1-1.3,1.9-1.5c3.2-0.4,2.2,1.9,2.9,1.8 c0.3-0.0,0.2-0.6,0.1-0.8l-0.3-1.8 c-0.0-0.1-0.1-0.3-0.3-0.3c-0.0,0.0-0.0,0.0-0.0,0.0 c-1.4,0.1-2.6,0.4-3.7,0.5c-2.5,0.3-3.7,0.4-4.4,0.5 c-0.1,0.0-0.3,0.1-0.3,0.3c0.0,0.0,0.0,0.0,0.0,0.0 c0.0,0.7,1.9-0.1,2.1,1.5l1.1,8.6 c0.2,2.2-1.0,1.4-0.9,2.2c0.0,0.1,0.1,0.1,0.3,0.1 c0.9-0.1,1.6-0.2,2.1-0.3c0.7-0.0,1.3-0.1,1.9-0.1 c0.4-0.0,0.7-0.0,0.7-0.3c-0.0-0.5-1.8,0.2-2.1-1.8 l-0.3-2.7c-0.1-1.0-0.2-1.2,0.5-1.3l1.2-0.1 c1.7-0.2,1.5,1.7,2.0,1.7c0.4-0.0,0.2-0.7,0.1-0.9 l-0.5-3.2c-0.0-0.4-0.2-0.4-0.3-0.4 c-0.3,0.0-0.1,1.7-1.5,1.9l-1.0,0.1 c-0.7,0.0-0.7-0.0-0.8-0.8l-0.3-2.5H529.5z M535.6,451.0 c0.6,3.7,3.3,5.7,6.6,5.1c5.2-0.9,5.4-5.6,4.9-8.2 c-0.7-3.8-3.6-5.7-6.8-5.1c-3.9,0.7-5.5,4.2-4.8,8.2 H535.6z M537.5,449.6c-0.4-2.6-0.1-5.3,2.6-5.9 c2.1-0.4,4.5,1.3,5.2,5.3c0.5,3.0,0.0,5.6-2.7,6.2 C539.7,455.9,538.0,452.2,537.5,449.6z M550.5,443.1 c-0.2-1.0,0.2-1.2,0.8-1.3c1.6-0.3,2.8,0.7,3.3,2.5 c0.2,1.0,0.4,2.1-2.0,2.7c-0.4,0.1-1.0,0.2-1.2-0.1 l-0.8-3.6L550.5,443.1z M550.5,451.9 c0.5,2.2-0.9,2.0-0.7,2.5c0.0,0.3,0.4,0.2,0.5,0.1 c0.8-0.1,1.6-0.4,2.4-0.6c0.6-0.1,1.1-0.1,1.4-0.2 c0.3-0.0,0.4-0.2,0.4-0.3c-0.1-0.6-1.5,0.4-2.0-1.4 l-0.7-3.1c-0.1-0.6-0.2-0.7,0.5-0.9 c0.6-0.2,1.3-0.0,1.7,0.6l2.0,2.5 c0.7,0.9,1.5,1.9,2.8,1.6c0.6-0.1,1.6-0.8,1.5-1.3 c-0.0-0.1-0.1-0.2-0.2-0.1c-0.0,0.0-0.0,0.0-0.0,0.0 c-0.1,0.0-0.2,0.1-0.4,0.2c-0.2,0.0-0.4,0.0-0.6-0.1 c-1.7-2.0-3.7-4.2-3.7-4.4c-0.0-0.1,0.3-0.4,0.7-0.9 c0.5-0.7,0.6-1.6,0.4-2.4c-0.2-0.8-1.1-3.3-4.7-2.4 c-1.0,0.2-2.1,0.6-3.2,0.8c-1.0,0.2-1.1,0.2-1.9,0.3 c-0.1,0.0-0.3,0.1-0.2,0.3c0.1,0.6,1.7-0.4,2.2,1.5 l1.9,7.9L550.5,451.9z M564.0,448.9 c0.5,2.1-1.5,1.7-1.3,2.4c0.1,0.3,0.3,0.3,0.6,0.2 c0.6-0.1,1.1-0.3,2.2-0.6c1.0-0.2,1.6-0.3,2.2-0.5 c0.4-0.1,0.8-0.1,0.6-0.5c-0.1-0.5-2.0,0.5-2.6-1.6 l-2.1-8.1c-0.2-0.8-0.0-1,0.5-1.1l1.3-0.3 c1.8-0.5,1.8,1.5,2.5,1.4c0.4-0.1,0.0-0.7-0.0-0.9 l-0.6-1.6c-0.0-0.1-0.1-0.4-0.3-0.3 c-1.5,0.3-2.5,0.7-4.9,1.3c-2.3,0.6-3.4,0.8-4.9,1.2 c-0.2,0.0-0.1,0.3-0.1,0.5l0.3,2.4 c0.0,0.2,0.0,0.6,0.3,0.5c0.7-0.1-0.3-2.4,1.4-2.9 l1.3-0.3c0.6-0.1,0.8-0.1,1.0,0.7l2.1,8.3H564.0z  M572.6,437.5c-0.4-1.7,0.9-1.3,0.7-2.0 c-0.0-0.2-0.1-0.2-0.6-0.0c-0.9,0.2-1.4,0.4-2.0,0.6 c-0.5,0.1-1.2,0.2-1.8,0.4c-0.1,0.0-0.5,0.0-0.4,0.4 c0.1,0.6,1.8-0.3,2.3,1.2l2.3,8.6 c0.4,1.7-0.8,1.5-0.6,2.1c0.0,0.0,0.0,0.2,0.2,0.1 c0.4-0.1,1.0-0.3,1.7-0.5c1.2-0.3,1.8-0.4,2.4-0.6 c0.3-0.1,0.4-0.2,0.4-0.4c-0.1-0.5-1.7,0.7-2.3-1.4 l-2.3-8.5H572.6z M576.1,441.6c1.2,3.5,4.1,5.2,7.3,4.1 c5.0-1.7,4.5-6.3,3.7-8.8c-1.2-3.7-4.3-5.2-7.4-4.1 c-3.7,1.3-4.9,4.9-3.6,8.8V441.6z M577.8,440.0 c-0.8-2.5-0.8-5.2,1.7-6.2c2.0-0.7,4.6,0.6,5.9,4.5 c0.9,2.9,0.8,5.6-1.8,6.5 C580.9,445.9,578.6,442.6,577.8,440.0z M589.7,431.5 c-0.4-1.0,0.0-1.2,0.6-1.4c1.5-0.6,2.9,0.3,3.6,2.0 c0.4,1.0,0.6,2.0-1.6,2.9c-0.4,0.1-1.0,0.4-1.2-0.0 l-1.3-3.5V431.5z M590.9,440.3c0.8,2.1-0.6,2.1-0.4,2.6 c0.1,0.3,0.4,0.1,0.6,0.0c0.7-0.3,1.5-0.6,2.3-1.0 c0.6-0.2,1.1-0.3,1.3-0.4c0.3-0.1,0.4-0.2,0.3-0.4 c-0.2-0.6-1.5,0.6-2.2-1.1l-1.1-3.0 c-0.2-0.6-0.3-0.6,0.4-1.0c0.5-0.3,1.3-0.2,1.7,0.3 l2.3,2.2c0.8,0.8,1.8,1.7,3.0,1.2 c0.6-0.2,1.5-1.0,1.2-1.5c-0.0-0.1-0.1-0.2-0.3-0.1 c-0.0,0.0-0.0,0.0-0.0,0.0c-0.1,0.0-0.2,0.2-0.4,0.2 c-0.2,0.1-0.4,0.0-0.6-0.0c-1.9-1.7-4.3-3.7-4.3-3.8 c-0.0-0.1,0.3-0.5,0.6-1.0c0.3-0.7,0.4-1.7,0.0-2.5 c-0.3-0.7-1.5-3.1-5.0-1.7c-1.0,0.4-2.0,0.8-3.1,1.3 c-0.9,0.3-1.1,0.3-1.8,0.6c-0.1,0.0-0.3,0.2-0.2,0.3 c0.2,0.6,1.6-0.6,2.4,1.2l3.0,7.6H590.9z"
    S.g $ do
      S.path
        ! A.fill "#D52B1E"
        ! A.d "M412.6,249.2h82.1v82.0h-82.1V249.2z"
      S.path
        ! A.fill "#FFFFFF"
        ! A.d "M451.2,313.8c-0.0,1.7-0.3,3.5-0.8,5.2   c-0.9,2.7-0.9,2.7-1.7,4.0c-0.9,1.5-2.2,2.8-3.8,3.8   c-1.7,1.2-3.8,1.8-5.9,1.7c-5.4-0.4-8.0-6.4-9.2-11.2   c-1.3-5.1-5.0-7.9-7.4-6.0c-1.3,1.0-1.4,2.9-0.3,4.6   c1.0,1.2,2.4,2.2,4.0,2.7l-2.9,3.7   c-3.8-0.6-6.8-3.5-7.5-7.3c-0.4-2.4,0.7-7.1,4.8-8.5   c5.2-1.7,8.6,2.0,10.3,5.1c2.2,4.3,3.2,12.4,9.4,11.1   c3.3-0.6,4.9-5.5,4.9-7.8l2.4-2.6l3.6,1.1l0.0,0.0   L451.2,313.8z M456.3,313.8c0.0,1.7,0.3,3.5,0.8,5.2   c0.9,2.7,0.9,2.7,1.7,4.0c0.9,1.5,2.2,2.8,3.8,3.8   c1.7,1.2,3.8,1.8,5.9,1.7c5.4-0.4,8.0-6.4,9.2-11.2   c1.3-5.1,5.0-7.9,7.4-6.0c1.3,1.0,1.4,2.9,0.3,4.6   c-1.0,1.2-2.4,2.2-4.0,2.7l2.9,3.7   c3.8-0.6,6.8-3.5,7.5-7.3c0.4-2.4-0.7-7.1-4.8-8.5   c-5.2-1.7-8.6,2.0-10.3,5.1c-2.2,4.3-3.2,12.4-9.4,11.1   c-3.3-0.6-4.9-5.5-4.9-7.8l-2.4-2.6l-3.6,1.1l-0.0,0.0   L456.3,313.8z"
      S.path
        ! A.fill "#FEDD00"
        ! A.d "M461.1,278.9l10.7-11.6   c0.9-0.8,1.5-2.0,1.6-3.4l-2.2,0.3l-0.4-1.1l-0.1-1.1   l2.9-0.6c0.0-0.4,0.0-0.8,0.0-1.3   c0.0-0.4,0.1-0.7,0.3-1.2l-3.2,0.2   c0.1-0.5,0.1-0.8,0.3-1.4c0.1-0.3,0.2-0.7,0.5-1.1   c0.6-0.0,1.1-0.2,1.9-0.3c0.7-0.0,1.1-0.0,1.8-0.0   c1.7-3.3,9.1-6.3,14.4-0.9c3.8,3.9,2.9,11.2-1.9,13.1   c-2.3,1.0-5.0,0.5-6.8-1.1l1.9-3.8   c2.7,1.6,4.9-0.3,4.8-2.4c-0.0-2.4-1.9-4.3-4.3-4.5   c-2.2-0.1-3.8,1.0-4.8,3.1c-0.6,1.2-0.3,2.1-0.5,3.5   c-0.0,1.2-0.2,2.5-0.5,3.8c-0.4,1.3-1.2,2.6-2.3,3.5   l-11.0,11.9l-42.9,46.4l-3.2-2.9l43.2-46.7V278.9z"
      S.path
        ! A.fill "#FFFFFF"
        ! A.d "M429.5,283.0c0,0,2.7,13.3,11.8,33.4   c4.6-1.7,7.4-2.7,12.3-2.7c4.9,0,7.6,0.9,12.3,2.7   c9.1-20.0,11.8-33.4,11.8-33.4l-24.2-31.1L429.5,283.0z"
      S.path
        ! A.fill "#FEDD00"
        ! A.d "M456.1,262.4l16.8,21.6c0,0-2.2,10.5-9.0,26.3   c-2.5-0.6-5.1-1.0-7.7-1.3l-0.0-46.6V262.4z M451.3,262.4   l-16.8,21.6c0,0,2.2,10.5,9.0,26.3   c2.5-0.6,5.1-1.0,7.7-1.3l0.0-46.6V262.4z"
    S.g $ do
      S.path
        ! A.fill "#FEDD00"
        ! A.d "M503.6,249.2h82.1v82.0h-82.1V249.2z"
      S.path
        ! A.fill "#D52B1E"
        ! A.d "M515.1,249.2h12.2v82.0h-12.2V249.2z M538.5,249.2h12.2   v82.0h-12.2L538.5,249.2z M562.0,249.2h12.2v82.0h-12.2L562.0,249.2z"
    S.g $ do
      S.path
        ! A.fill "#FEDD00"
        ! A.d "M412.9,402.4c0.3,2.3,1.0,4.5,2.1,6.6   c1.4,2.3,0.9,2.2,4.2,6c1.8,1.8,3.9,3.3,6.2,4.4   c2.1,1.1,4.4,1.9,6.8,2.4c5.3,1.4,10.9,1.9,16.5,1.5   c3.4-0.1,6.8-0.5,10.2-1.0c3.6-0.5,7.3-0.8,11.1-1.0   c2.1-0.0,4.1-0.1,6.1,0c2.4,0.1,4.8,0.4,7.3,1.0   c3.7,0.7,7.3,1.8,10.9,3.1l0.0-85.6l-82.1-0.0v58.5   c0,0,0.1,2.8,0.3,3.8H412.9z"
      S.path
        ! A.fill "#D52B1E"
        ! A.d "M422.5,417.4l3.8,2.2   l5.2,1.8l-0.0-81.5h-9.1L422.5,417.4z M468.1,421.1l0.0-81.0   h-9.1v82.3c0,0,6.2-0.8,9.1-0.9L468.1,421.1z M486.4,340.0h-9.1   v81.3c3.0,0.3,6.1,0.8,9.1,1.6L486.4,340.0z M449.9,340.0   v83.3c-3.0,0.1-6.1,0.1-9.1-0.0l0.0-83.3L449.9,340.0z"
    S.path
          ! A.fill "#FEDD00"
          ! A.d "M585.4,402.3c-0.3,2.3-1.0,4.5-2.1,6.6  c-1.4,2.3-0.9,2.2-4.2,6.0c-1.8,1.8-3.9,3.3-6.2,4.4  c-2.1,1.1-4.4,1.9-6.8,2.4c-5.3,1.4-10.9,1.9-16.5,1.5  c-3.4-0.1-6.8-0.5-10.2-1.0c-3.6-0.5-7.3-0.8-11.1-1.0  c-2.1-0.0-4.1-0.1-6.1,0c-2.4,0.1-4.8,0.4-7.3,1.0  c-3.7,0.8-7.4,1.8-11.0,3.1l0.0-85.6l82.1-0.0v58.5  c0,0-0.1,2.8-0.3,3.8L585.4,402.3z"
    S.g 
      ! A.id_ "HaskellSvgIcons-adCoA-cow"
      $ do
        S.path
          ! A.fill "#D52B1E"
          ! A.d "M524.6,346.9c0,0-0.3,0.1-0.5,0.2   c-0.2,0.2-0.5,0.5-0.7,0.8c-0.3,0.3-0.8,0.5-1.2,0.8   c-0.2,0.1-0.4,0.2-0.5,0.4c-0.2,0.3-0.0,0.6-0.2,1   c-0.1,0.3-0.3,0.6-0.6,0.9c-0.3,0.3-0.6,0.6-1.0,1   c-0.3,0.3-0.6,0.7-1.0,1c-0.1,0.0-0.2,0.1-0.3,0.1   c-0.2,0.0-0.3-0.0-0.5,0.0c-0.3,0.1-0.5,0.5-0.7,0.7   c0.1,0.2,0.1,0.3,0.2,0.5c0.1,0.3,0.7,1.2,0.8,1.4   c0.2,0.3,0.2,0.7,0.5,0.7c0.4,0.1,0.8,0.1,1.3,0.1   c0.6,0.0,1.3,0.2,2.0,0.4c0.6,0.2,0.8,0.5,1.4,0.8   c0.4,0.2,0.8,0.3,1.2,0.4c0.3,0.0,0.6,0.1,1,0.0   c0.2-0.0,0.3-0.1,0.6-0.1c0.0-0.0,0.0-0.0,0.1,0l-0.0,0.3   c-0.0,0,0.0,0.0,0,0.0v0.0h0.0l2.0,0.9   c-0.2,0.3-0.3,0.7-0.2,1.2c0.6,1.8,1.1,3.0,1.4,3.1   c0.6,0.2,0.8,0.8,1.1,1.5c-0.1,0.1-0.2,0.2-0.3,0.3   c-0.6,0.5-1.1,1.1-1.6,1.8c-0.7,1.1-1.2,1.2-0.3,2.7   c0.5,0.9,0.8,1.1,1.5,2.4c0.3,0.6,0.6,1.2,0.7,1.9   c0.1,0.6,0.2,1.3,0.3,1.9l0.9,0.3l0.6-0.6l0.6-1.1   l0.0-0.9c-0.2-0.1-0.3-0.4-0.2-0.7   c0.0-0.3,0.5-0.2,0.7-0.6c0.2-0.4-0.3-0.7-0.6-1.0   c-0.6-0.6-1.4-0.8-1.6-1.8c-0.0-0.2,0.0-0.4,0.3-0.7   c0.8-0.8,1.1-0.9,1.9-1.8c0.2,0.1,0.6,0.1,0.9,0.1   c0.2-0.0,0.5,0.1,1.4,0.3c0.3,0.1,0.8,0.1,1.2,0.0   l0.3-0.0c0.0,0.2,0.1,0.4,0.1,0.6c0.0,1.0-0.1,2.9,0.1,3.5   c0.1,0.1,0.2,0.3,0.2,0.5c0.1,0.2,0.1,0.4,0.2,0.6   c0.0,0.6,0.0,1.1,0,1.8c-0.0,0.5-0.1,1.1-0.2,1.7   c-0.0,0.3-0.1,0.7-0.4,1.0c-0.2,0.3-0.5,0.4-0.9,0.6   l-0.0,1l1.1,0.4l1.2,0.3l0.6-0.2c-0.0-0.2,0.0-0.4,0.1-0.6   c0.1-0.2,0.2-0.4,0.4-0.5c0.3-0.1,0.7,0.1,0.9-0.0   c0.1-0.2,0.0-0.3,0.0-0.7c-0.0-0.6-0.1-0.9-0.2-1.6   c-0.1-0.9-0.2-1.8-0.1-2.7c0.0-0.5,0.0-1.0,0.1-1.5   c0.1-0.8,0.4-1.3,0.6-2.1c0.1-0.8,0.2-1.6,0.3-2.4   c3.1,0.4,6.2,0.3,9.3-0.3c0.1-0.0,0.7-0.2,0.7-0.2   c0.7,0.7,1.7,1.2,2.7,1.6c-0.0,0.1-0.0,0.8,0,0.9   c0.0,0.2-0.0,0.4,0.1,0.7c0.0,0.1,0.2,0.2,0.3,0.2   c0.2,0.0,0.4,0.0,0.6-0.1c0.2-0.2,0.1-0.4,0.2-0.7   c0.0-0.2,0.0-0.4,0-0.6c0.2,0.0,0.5,0.0,0.8,0.0   c0.2,0.0,0.5,0.0,0.8-0.0c0.0,0.0,0.0,0.3,0.0,0.4   c0.0,0.2-0.0,0.4,0.0,0.6c0.0,0.2,0.2,0.3,0.5,0.4   c0.1,0.0,0.3,0.0,0.5-0.0c0.2-0.1,0.2-0.4,0.3-0.8   c0.0-0.1,0.0-0.6,0-0.7c0.2-0.0,0.8-0.2,1.0-0.3   c-0.0,0.2-0.0,0.5-0.0,0.8c-0.0,0.3-0.1,0.6-0.2,0.9   c-0.1,0.4-0.4,0.9-0.7,1.3c-0.3,0.5-0.6,1.0-1.0,1.5   c-0.2,0.2-0.3,0.3-0.5,0.6c-0.2,0.3-0.3,0.5-0.5,0.9   c-0.2,0.3-0.5,0.7-0.9,1.0c-0.6,0.5-1.1,0.1-2.0,0.8   l-0.2,1.0l1.4,0.5l1.2,0.2l0.4-0.2   c-0.0-0.2,0.0-0.5,0.2-0.7c0.1-0.2,0.4-0.3,0.7-0.4   c0.3-0.0,0.7,0.0,1.0-0.2c0.3-0.3,0.3-0.9,0.6-1.4   c0.7-1.4,1.7-2.8,3-3.9c0.6-0.5,1.1-0.7,1.6-1.4   c0.2-0.3,0.5-0.4,0.5-0.8c0.0-0.2-0.1-0.4-0.2-0.6   c-0.0-0.3-0.1-0.6-0.1-1c1.5,0.7,0.9,0.6,1.2,1.4   c0.2,0.6-0.0,1.0,0.0,1.6c0.1,0.7,0.4,1.1,0.5,1.8   c0.0,0.7-0.0,1.5-0.3,2.3c-0.0,0.6-0.2,1.3-0.4,2   c-0.2,0.6-0.6,1.1-1.1,1.5c-0.2,0.1-0.3,0.2-0.5,0.4   l-0.1,1.0l1.1,0.3l1.6,0.4l0.3-0.3c0.1-0.6-0.0-1.6,0.4-1.6   c0.4-0.0,0.6,0,0.7-0.3c0.0-0.2,0.0-0.4,0.0-0.6   c0.2-1.8,0.4-3.6,0.6-4.5c0.2-0.9,0.2-1.1,0.4-1.9   c0.0-0.5,0.1-1.1,0.4-1.6c0.7-2.0-0.2-2.3-1.0-3.6   c-0.3-0.4-0.6-0.9-0.6-1.5c-0.0-0.8,0.1-1.4,0.1-2.7   c-0.0-0.9-0.0-1.9,0-2.8c0.1-0.0,0.2-0.1,0.3-0.1   c1.1-0.4,1.9-1.3,2.3-2.4c0.2-0.4,0.3-0.9,0.3-1.4   c-0.0-0.3-0.0-0.6-0.0-1.0c-0.0-0.3-0.1-0.6-0.3-0.9   c-0.1-0.3-0.3-0.5-0.5-0.8c-0.7-0.7-1.6-1.2-2.7-1.4   c-1.3-0.3-2.7-0.5-4.1-0.5c-1.4-0.1-2.8-0.1-4.2-0.0   c-2.0,0.1-3.1,0.5-5.1,0.7c-1.6,0.2-3.2,0.3-4.9,0.4   c-2.2,0.0-4.4-0.4-5.7-0.3c-2.4,0.2-2.4,0.7-6.1,1.0   c-1.2,0.0-2.5,0.1-3.8,0.1l-2.1-0.6   c0.6-0.1,1.1-0.5,1.4-1.0c0.2-0.3,0.2-0.6,0.5-1.0   c0.2-0.3,0.4-0.6,0.7-0.9c-0.2-0.2-0.5-0.3-0.9-0.4   c-0.3-0.0-0.6-0.0-0.9,0c-0.4,0.0-0.8,0.1-1.2,0.3   c-0.3,0.1-0.6,0.3-0.8,0.5c-0.7-0.4-1.4-0.8-2.1-1.2   c-0.9-0.4-1.9-0.7-3-0.9V346.9z M526.5,358.8h0.0   c-0.0,0.0-0.0,0.0-0.0,0.0L526.5,358.8z"
        S.path
          ! A.fill "none"
          ! A.stroke "#FEDF00"
          ! A.strokeWidth "0.9"
          ! A.strokeLinecap "round"
          ! A.d "M568.7,359.5l-0.7,0.2    c-0.8,0.3-1.7,0.5-2.5,0.4c-2.6,0.2-4.2-1.0-6.9-0.8    c-1.4,0.1-2.0,1.1-3.4,1.5c-0.5,0.1-1.1,0.2-1.7,0.2    l0.5-1.0c-0.6,0.1-1.4,0.2-2.1,0.2    c-0.5,0.0-1.0-0.0-1.5-0.1l1.0-0.9    c-0.4-0.0-0.8-0.1-1.2-0.3c-0.3-0.1-0.7-0.3-1.0-0.6    c0.5-0.0,1.1-0.2,1.6-0.3c1.5-0.3,2.0-1.1,3.8-1.3    c1.1-0.1,3.0-0.0,7.6,0.7c3.0,0.5,4.3,0.2,5.5-0.2    c0.6-0.3,1.1-1.0,1.1-1.7c0.0-0.7-0.3-1.3-0.8-1.8    c-0.3-0.2-0.7-0.3-1.1-0.3"
        S.path
          ! A.fill "#FCD900"
          ! A.stroke "#FEDF00"
          ! A.strokeWidth "0.5"
          ! A.d "M524.7,350.6    c-0.4-0.0-0.9,0.0-1.3,0.2c-0.4,0.2-0.5,0.6-0.8,1.1    c0.4,0.1,0.6,0.3,1.1,0.2c0.3-0.0,0.5-0.2,0.7-0.5    c0.2-0.3,0.4-0.7,0.4-1.1l-0.1-0.0H524.7z M517.7,354.5    c0.2,0.0,0.4,0.0,0.7,0.0c0.3-0.0,0.4-0.2,0.8-0.2    c0.2-0.0,0.4-0.0,0.6,0.1c0.1,0.0,0.2,0.2,0.2,0.3    c0.1,0.1,0.1,0.3,0.1,0.4c-0.0,0.2-0.3,0.4-0.6,0.4    c-0.2,0.0-0.4-0.0-0.5-0.2c-0.0-0.1-0.0-0.2-0.0-0.3    c-0.5,0.1-1.1-0.0-1.4-0.4H517.7z"
        S.path
          ! A.fill "none"
          ! A.stroke "#FEDF00"
          ! A.strokeWidth "1"
          ! A.strokeLinecap "round"
          ! A.d "M536.0,363.7    c0,0,0.2,0.4,0.4,0.7c0.2,0.4,0.3,0.9,0.5,1.4    c0.1,0.6,0.1,1.3,0.2,2.0c0.0,0.1,0.0,0.2,0.0,0.3    l-0.0,1.1 M544.0,362.7c0,0-0.2,0.8-0.3,1.3    c-0.3,1.3-0.6,2.0-0.9,3.4c-0.0,0.2-0.0,0.4-0.1,0.6     M531.7,364.1c0.7,0.1,0.5,3.3,1.7,4.0 M560.1,369.7l0.3-0.2    c1.0-0.4,1.9-1.0,2.6-1.7 M552.3,368.0h0.0    c3.5-0.8,5.8-2.6,7.5-2.8 M555.9,363.6    c0.2-0.0,0.5-0.0,0.8-0.0c1.4-0.2,1.7,0.6,2.7,1.2    c1.8,1.0,2.0,2.3,4.2,3.3c0.1,0.0,0.2,0.1,0.3,0.1    l0.8,0.4"
        S.path
          ! A.fill "#005EB8"
          ! A.d "M525.1,364.1c-0.6-0.2-1.3-0.5-1.9-0.8   c0.3-0.2,0.5-0.2,0.8-0.5c0.3-0.4,0.3-0.7,0.5-1.3   c0.2-0.5,0.1-0.9,0.6-1.3c0.3-0.2,0.7-0.2,1.1-0.1   c0.3,0.1,0.7,0.3,0.8,0.7c0.1,0.5-0.1,0.8-0.2,1.4   c-0.1,0.4-0.2,0.9-0.1,1.4c0.0,0.3,0.2,0.6,0.3,0.9   c-0.6-0.0-1.3-0.2-2.0-0.3L525.1,364.1z M524.1,365.1   c-0.0-0.3,0.2-0.6,0.6-0.6c0.3-0.0,0.6,0.2,0.6,0.6   s-0.2,0.6-0.6,0.6c-0.3,0.0-0.6-0.2-0.6-0.6L524.1,365.1   z M522.3,348.6c0,0-0.0-0.0-0.1-0.1   c-0.3-0.3-0.4-0.6-0.6-1.1c-0.1-0.3-0.2-0.7-0.3-1.1   c-0.0-0.3-0.0-0.6,0-1.0c0.0-0.3,0.0-0.6,0-0.9   c0.0-0.3-0.0-0.6-0.2-0.9c-0.0-0.1-0.3-0.3-0.3-0.4   c0.0-0.0,0.2-0.0,0.4,0c0.3,0.0,0.6,0.1,0.9,0.4   c0.3,0.2,0.5,0.6,0.6,1.0c0.1,0.5,0.2,0.8,0.4,1.4   c0.0,0.2,0.1,0.5,0.2,0.7c0.1,0.2,0.3,0.4,0.5,0.6   l-0.0,0.0c-0.2,0.2-0.5,0.5-0.7,0.8   c-0.2,0.2-0.5,0.4-0.8,0.5l-0.0-0.0L522.3,348.6z    M525.9,359.2l2.2,1.0c1.5-0.9,2.7-2.3,3.4-3.9   c0.6-1.3,1.1-2.8,1.3-4.3l-1.7-0.5l-0.3,0.0   c-0.3,1.4-0.8,2.8-1.6,4.1c-0.6,1.1-1.5,2.1-2.6,3.0   l-0.6,0.4H525.9z M530.9,377.3c0.2-0.4,0.5-0.8,0.9-1.2   c0.4-0.4,0.8-0.7,1.3-1.1c0.1-0.0,0.3,0.0,0.4,0.0   c-0.0,0.5-0.0,1.0-0.1,1.5c-0.0,0.4-0.2,0.8-0.3,1.2   c-0.0,0.3-0.2,0.6-0.3,0.9c-0.1,0.1-0.3,0.3-0.4,0.5   c-0.5-0.7-1.3-1.2-1.3-1.9L530.9,377.3z M563.9,379.2   c1.0,0.2,2.0,0.7,2.9,1.4c0.0,0.1,0.0,0.3,0.0,0.4   c-0.5,0.1-1.0,0.2-1.5,0.2c-0.4,0.0-0.8,0.0-1.2,0   c-0.3,0.0-0.7-0.0-1.0-0.1c-0.2-0.0-0.4-0.1-0.6-0.3   c0.5-0.6,0.8-1.6,1.4-1.7V379.2z M554.1,377.1   c1.0,0.2,2.0,0.7,2.9,1.4c0.0,0.1,0.0,0.3,0.0,0.4   c-0.5,0.1-1.0,0.2-1.5,0.2c-0.4,0.0-0.8,0.0-1.2,0   c-0.3,0.0-0.7-0.0-1.0-0.1c-0.2-0.0-0.4-0.1-0.6-0.3   C553.2,378.2,553.5,377.3,554.1,377.1z M536.8,379.3   c0.5,0.1,0.9,0.3,1.4,0.5c0.5,0.2,1.0,0.5,1.4,0.9   c0.0,0.1,0.0,0.3,0.0,0.4c-0.5,0.1-1.0,0.2-1.5,0.2   c-0.4,0.0-0.8,0.0-1.2,0c-0.3,0.0-0.7-0.0-1.0-0.1   c-0.2-0.0-0.4-0.1-0.6-0.3c0.5-0.6,0.8-1.6,1.4-1.7   L536.8,379.3z M527.8,349.5c-0.6-0.2-1.0-1.0-0.6-1.5   c0.1-0.2,0.4-0.1,0.5-0.3c0.1-0.2,0.1-0.5,0.1-0.8   c-0.0-0.3-0.1-0.6-0.2-0.9c-0.0-0.3-0.1-0.6-0.1-1.0   c-0.0-0.5,0.0-1.1,0.3-1.5c0.2-0.2,0.4-0.4,0.8-0.6   c0.1,0.1-0.0,0.5-0.0,0.8c0.0,0.3,0.1,0.7,0.2,1.1   c0.2,0.5,0.4,0.8,0.7,1.3c0.2,0.4,0.3,0.8,0.4,1.3   c0.0,0.3-0.0,0.7-0.2,1.1c-0.1,0.3-0.3,0.6-0.6,0.8   c-0.2,0.2-0.5,0.3-0.7,0.4c-0.2,0.0-0.4-0.0-0.6-0.1   L527.8,349.5z"
    S.use
      ! A.xlinkHref "#HaskellSvgIcons-adCoA-cow"
      ! A.transform (translate 0 36.5)
    S.path
      ! A.fill "none"
      ! A.stroke "#713F2A"
      ! A.strokeWidth "0.8"
      ! A.d "M412.6,249.2h82.1v82.0h-82.1V249.2z   M503.6,249.2h82.1v82.0h-82.1V249.2z M412.9,402.4  c0.3,2.3,1.0,4.5,2.1,6.6c1.4,2.3,0.9,2.2,4.2,6  c1.8,1.8,3.9,3.3,6.2,4.4c2.1,1.1,4.4,1.9,6.8,2.4  c5.3,1.4,10.9,1.9,16.5,1.5c3.4-0.1,6.8-0.5,10.2-1.0  c3.6-0.5,7.3-0.8,11.1-1.0c2.1-0.0,4.1-0.1,6.1,0  c2.4,0.1,4.8,0.4,7.3,1.0c3.7,0.7,7.3,1.8,10.9,3.1  l0.0-85.6l-82.1-0.0v58.5c0,0,0.1,2.8,0.3,3.8H412.9z   M585.4,402.3c-0.3,2.3-1.0,4.5-2.1,6.6  c-1.4,2.3-0.9,2.2-4.2,6.0c-1.8,1.8-3.9,3.3-6.2,4.4  c-2.1,1.1-4.4,1.9-6.8,2.4c-5.3,1.4-10.9,1.9-16.5,1.5  c-3.4-0.1-6.8-0.5-10.2-1.0c-3.6-0.5-7.3-0.8-11.1-1.0  c-2.1-0.0-4.1-0.1-6.1,0c-2.4,0.1-4.8,0.4-7.3,1.0  c-3.7,0.8-7.4,1.8-11.0,3.1l0.0-85.6l82.1-0.0v58.5  c0,0-0.1,2.8-0.3,3.8L585.4,402.3z"



{- |
Flag of Albania coat of arms.
Drawn for a @viewbox 0 0 980 700@
-}
alCoA :: Svg
alCoA =
    S.path
      ! A.stroke "none"
      ! A.strokeWidth "0"
      ! A.fillRule "evenodd"
      ! A.fill "#000000"
      ! A.d (S.toValue dirs)
  where
    dirs :: String
    dirs = "M516.51 528.944c-6.15-5.332-13.605-16.13-13.5-26.538.55-7.761 5.873-12.27 9.312-2.796 4.862 10.457 15.29 27.749 29.66 17.605 6.278-4.608 6.18-11.392-2.428-10.614-10.63-.728-17.16-6.577-21.917-21.636-.865-8.282 2.58-8.075 7.387-2.747 6.18 7.09 18.478 17.806 32.046 12.063 7.54-3.16 9.668-9.68-1.723-11.285-10.784.157-19.587-6.834-28.35-17.498-4.805-5.9 2.282-11.856 6.537-6.834 3.795 3.26 9.11 9.266 13.665 10.094 5.267 1.034 11.796.52 19.03-3.31 7.798-6.527 5.266-11.236-4.2-12.32-7.338.364-11.335 3.153-20.8-3.16-17.014-11.5-30.54-26.865-32.653-45.347-1.388-12.156 5.148-15.837 10.582-14.438 14.78 3.802 24.449 31.422 34.675 46.595 3.348 4.373 6.424 4.444 8.6 3.096 4.102-3.517 7.378-6.408 11.48-10.34 0 0 30.085 5.406 46.468 10.746l-18.242 6.483c-6.907-3.814-15.243.298-15.243 6.915-6.536 4.52-6.01 9.819-3.19 14.933.86-3.561 1.594-8.186 6.757-8.801 7.369 3.048 15.955-1.302 15.955-7.057l21.519-8.458 21.74 12.308c0 8.32 7.883 10.956 16.085 8.71 3.865 2.4 6.35 6.564 7.659 11.017 2.42-6.422 1.915-10.956-1.875-14.107 2.175-8.303-9.46-16.287-18.467-10.97l-15.64-8.98 26.77-.75c3.107 5.5 14.337 5.803 17.613 0 2.8-.767 5.166-1.255 10.625 2.803-1.72-6.566-5.068-9.373-10.09-9.373-3.816-6.761-17.626-6.73-19.62.882l-27.881.775 16.543-11.778c6.175 3.646 14.84-.407 16.575-7.03 2.462-2.927 5.498-4.302 11.474-2.316-3.08-5.455-7.42-7.083-15.258-3.38-7.15-5.418-16.574 1.153-15.144 6.608l-22.01 14.975c-15.976-4.767-44.91-12.19-44.91-12.19 3.445-3.624 6.94-6.991 10.379-10.665 1.242-2.152-.656-4.658-3.293-5.18-25.816-5.328-40.597-15.735-49.553-42.186-3.746-11.078 4.353-14.388 7.136-7.612 3.85 9.424 8.098 19.724 19.69 27.7 3.998 2.796 15.899.513 8.86-6.164-7.29-6.006-10.428-8.588-14.02-23.19 0-7.398 7.54-10.715 11.746-3.624 4.5 14.545 4.96 20.808 13.107 30.18 6.173 7.092 14.223 11.857 18.22 11.75 7.192-.1 14.432-7.87 4.813-13.511-14.125-5.642-19.287-13.353-21.366-20.708-2.274-12.833.21-19.046 7.952-12.733 10.98 12.476 31.94 35.717 42.92 46.538 12.305 9.424 26.423 9.73 37.66.157 6.432-7.404 4.15-15.372-5.921-13.667-22.726 1.918-39.935-9.367-58.817-39.862-3.697-6.884-4.71-16.771 3.445-9.416 9.41 12.733 23.13 23.554 35.89 28.212 12.806 4.602 23.38 2.06 27.481-1.968 4.943-4.942 3.643-17.392-4.91-14.39-7.038 2.484-16.957 3.104-27.28-.883-10.331-4.038-21.06-12.733-32.45-27.485-3.9-8.332-2.63-15.373 5.265-11.08 18.68 15.845 42.775 28.678 55.072 20.967 9.062-5.643 9.215-20.138-2.274-19.204-23.137 3.153-31.891-1.968-54.115-21.585-5.058-3.781-4.708-13.361 3.34-7.248 18.68 12.063 44.19 16.77 54.214 10.458 9.013-5.643 7.694-22.885-7.491-16.778-12.151 7.404-25.565 7.197-52.442-12.006-6.78-5.642-1.723-12.997 3.844-9.837 21.617 12.32 53.104 17.598 61.3-7.454 3.188-9.574-2.58-15.166-11.035-8.54-18.576 17.185-39.635 8.746-51.423.1-3.376-1.99-9.57-12.062 1.31-10.193 28.147 6.42 55.986.828 61.05-19.103 2.937-6.47-2.84-17.912-13.113-8.332-13.512 13.354-27.84 13.817-45.857 13.717-9.166-1.918-9.263-12.012-1.57-13.51 14.223.306 28.244-5.907 39.482-12.22 10.986-6.313 20.096-15.166 22.984-27.435 1.77-10.972-8.81-22.62-15.186-10.972-9.417 17.028-30.273 33.078-53.46 35.975-1.207-2.02-4.248-7.198-7.994-5.743-6.808 2.64-14.92 6.172-23.272 10.139-18.004 8.549-25.507 12.669-23.345 27.44 2.257 15.413-9.626 25.153-19.44 22.463-8.56-2.304-13.282-10.036-11.748-23.447 1.229-10.686 11.957-23.612 24.046-30.39 7.826-4.38 19.642-6.776 33.865-9.936 8.656-1.705 13.065-5.072 13.568-8.596 0 0-5.917 4.33-15.388 3.68-4.478-.32-7.478-2.29-8.608-4.3 3.293-.67 9.264.107 14.628.107 7.135-.057 23.702-1.655 28.097-11.7 1.367-6.626-2.987-7.817-7.038-3.573-4.353 4.587-6.146 8.71-14.88 10.25-5.314.935-10.63 2.02-17.466.365 3.85-4.573 9.968-9.252 15.186-8.39 1.716.286 3.997 1.87 5.824 4.716 1.116-7.248-.865-15.43-20.25-12.013.308-5.485-11.238-7.868-18.17-7.761-3.948.1-11.998 2.433-17.816 5.222-9.214 2.853-18.324 4.922-29.06 5.7 6.23 5.328 7.395 5.642 13.616 10.143-9.41 3.517-16.7 10.765-19.991 15.53 0 0 10.986-.307 13.77.934-11.496 3.36-16.659 5.379-22.733 11.592 2.127.364 5.314.984 6.682 1.505 1.423.514 1.053 1.448-.098 2.326-2.476 1.89-12.708 13.774-15.694 16.62-2.986-2.846-13.218-14.73-15.694-16.62-1.151-.878-1.521-1.812-.098-2.326 1.367-.52 4.555-1.141 6.682-1.505-6.075-6.213-11.237-8.232-22.733-11.592 2.784-1.241 13.77-.934 13.77-.934-3.293-4.765-10.582-12.013-19.992-15.53 6.222-4.501 7.387-4.815 13.616-10.144-10.735-.777-19.845-2.846-29.06-5.7-5.817-2.788-13.867-5.121-17.815-5.221-6.933-.107-18.478 2.276-18.17 7.76-19.385-3.416-21.366 4.766-20.25 12.014 1.827-2.846 4.108-4.43 5.824-4.715 5.218-.863 11.335 3.816 15.186 8.389-6.836 1.655-12.152.57-17.467-.364-8.733-1.54-10.526-5.664-14.88-10.25-4.051-4.245-8.404-3.054-7.037 3.573 4.395 10.044 20.96 11.642 28.097 11.699 5.364 0 11.335-.778 14.628-.107-1.13 2.012-4.13 3.98-8.608 4.3-9.472.65-15.388-3.68-15.388-3.68.503 3.524 4.91 6.89 13.568 8.596 14.223 3.16 26.039 5.557 33.865 9.937 12.089 6.777 22.817 19.703 24.045 30.389 1.534 13.41-3.188 21.143-11.747 23.447-9.814 2.69-21.697-7.05-19.44-22.463 2.162-14.771-5.341-18.891-23.345-27.44-8.352-3.967-16.464-7.5-23.272-10.14-3.746-1.454-6.787 3.725-7.994 5.744-23.187-2.897-44.043-18.947-53.46-35.975-6.376-11.648-16.957 0-15.186 10.972 2.888 12.27 11.998 21.122 22.984 27.435 11.238 6.313 25.259 12.526 39.482 12.22 7.693 1.498 7.596 11.592-1.57 13.51-18.018.1-32.345-.363-45.857-13.717-10.274-9.58-16.05 1.862-13.113 8.332 5.064 19.93 32.903 25.523 61.049 19.103 10.88-1.87 4.687 8.204 1.31 10.194-11.787 8.645-32.846 17.084-51.422-.1-8.454-6.627-14.224-1.035-11.035 8.539 8.196 25.052 39.683 19.774 61.3 7.454 5.567-3.16 10.624 4.195 3.844 9.837-26.877 19.203-40.29 19.41-52.442 12.006-15.185-6.107-16.504 11.135-7.491 16.778 10.023 6.313 35.533 1.605 54.213-10.458 8.05-6.113 8.398 3.467 3.34 7.248-22.223 19.617-30.977 24.738-54.114 21.585-11.49-.934-11.336 13.56-2.274 19.204 12.297 7.71 36.39-5.122 55.07-20.966 7.897-4.294 9.166 2.747 5.267 11.079-11.39 14.752-22.12 23.447-32.45 27.485-10.323 3.987-20.242 3.367-27.28.884-8.553-3.003-9.853 9.447-4.911 14.389 4.103 4.028 14.676 6.57 27.483 1.968 12.758-4.658 26.479-15.48 35.889-28.212 8.154-7.355 7.142 2.532 3.445 9.416-18.882 30.495-36.09 41.78-58.817 39.862-10.072-1.705-12.353 6.263-5.922 13.667 11.238 9.573 25.356 9.267 37.66-.157 10.98-10.821 31.94-34.062 42.92-46.538 7.743-6.313 10.227-.1 7.953 12.733-2.08 7.355-7.24 15.066-21.366 20.708-9.62 5.643-2.38 13.41 4.813 13.51 3.997.108 12.047-4.657 18.22-11.748 8.147-9.373 8.608-15.636 13.107-30.181 4.206-7.091 11.746-3.774 11.746 3.623-3.592 14.603-6.731 17.185-14.02 23.19-7.04 6.678 4.862 8.96 8.859 6.165 11.593-7.976 15.84-18.276 19.69-27.7 2.784-6.776 10.883-3.466 7.137 7.612-8.956 26.45-23.737 36.858-49.553 42.187-2.637.52-4.535 3.027-3.294 5.179 3.44 3.674 6.935 7.04 10.38 10.665 0 0-28.935 7.423-44.911 12.19l-22.01-14.975c1.43-5.455-7.993-12.026-15.144-6.61-7.839-3.701-12.178-2.073-15.258 3.382 5.976-1.986 9.012-.611 11.474 2.315 1.735 6.624 10.4 10.677 16.575 7.03l16.543 11.78-27.88-.776c-1.995-7.611-15.805-7.643-19.622-.882-5.02 0-8.37 2.807-10.09 9.373 5.46-4.058 7.827-3.57 10.626-2.803 3.276 5.803 14.506 5.5 17.612 0l26.771.75-15.64 8.98c-9.007-5.317-20.642 2.667-18.467 10.97-3.79 3.15-4.296 7.685-1.875 14.107 1.308-4.453 3.794-8.617 7.66-11.018 8.2 2.247 16.084-.388 16.084-8.71l21.74-12.307 21.52 8.458c0 5.755 8.585 10.105 15.954 7.057 5.163.615 5.897 5.24 6.757 8.8 2.82-5.113 3.346-10.412-3.19-14.932 0-6.617-8.336-10.73-15.243-6.915l-18.242-6.483c16.383-5.34 46.469-10.745 46.469-10.745 4.101 3.93 7.377 6.822 11.48 10.34 2.176 1.347 5.252 1.276 8.6-3.097 10.226-15.173 19.894-42.793 34.675-46.595 5.434-1.4 11.97 2.282 10.582 14.438-2.114 18.482-15.64 33.848-32.652 45.347-9.466 6.313-13.463 3.524-20.801 3.16-9.466 1.084-11.998 5.793-4.2 12.32 7.234 3.83 13.763 4.344 19.03 3.31 4.555-.828 9.87-6.834 13.665-10.094 4.255-5.022 11.342.934 6.536 6.834-8.762 10.664-17.565 17.655-28.35 17.498-11.39 1.605-9.262 8.125-1.722 11.285 13.568 5.743 25.865-4.972 32.046-12.063 4.806-5.328 8.252-5.535 7.387 2.747-4.758 15.059-11.287 20.908-21.917 21.636-8.608-.778-8.706 6.006-2.428 10.614 14.37 10.144 24.798-7.148 29.66-17.605 3.439-9.473 8.76-4.965 9.312 2.796.105 10.408-7.35 21.206-13.5 26.538C457.344 534.278 490 568.18 490 568.18s32.657-33.904 26.509-39.237zm43.763-383.94c-5.083 0-8.223 1.78-8.223 3.94 0 2.194 3.14 3.982 8.223 3.982 5.053 0 8.262-1.95 8.262-4.147 0-2.16-3.21-3.776-8.262-3.776zm-140.544 0c5.083 0 8.223 1.78 8.223 3.94 0 2.194-3.14 3.982-8.223 3.982-5.053 0-8.262-1.95-8.262-4.147 0-2.16 3.21-3.776 8.262-3.776z"



{- |
Flag of Cyprus coat of arms.
Drawn for a @viewbox 0 0 900 600@
-}
cyCoA :: Svg
cyCoA = 
  do
    defs $
      S.path
        ! A.id_ "HaskellSvgIcons-cyFlagBranch"
        ! A.stroke "none"
        ! A.strokeWidth "0"
        ! A.fill "#4E5B31"
        ! A.d (S.toValue branchDirs)
    S.path
      ! A.stroke "none"
      ! A.strokeWidth "0"
      ! A.fill "#D57800"
      ! A.d (S.toValue cyprusDirs)
    S.use
      ! A.xlinkHref "#HaskellSvgIcons-cyFlagBranch"
    S.use
      ! A.xlinkHref "#HaskellSvgIcons-cyFlagBranch"
      ! A.transform (matrix (-1) 0 0 1 900 0)
  where
    cyprusDirs :: String
    cyprusDirs = "M 727.13,103.96 l -2.35,0.93 l -0.92,0.36 L 721,105.11 l -2.67,1.28 l -4.74,3.23 l -0.20,0.15 l -1.76,0.46 l -1.64,-0.70 l -0.93,0.42 l -0.32,1.92 l -0.88,1.37 l -1.09,0.76 l -3.78,0.38 l -3.19,1.64 l -4.15,-1.11 l -1.92,0.75 l -4.1,3.69 l -2.09,0.99 l -0.73,-0.04 l -2.77,-0.14 l -1.17,0.38 l -1.75,1.69 l -3.31,0.25 l -1.03,0.71 l -1.61,3.26 l -1.75,1.80 l -1,0.21 l -1.08,-0.4 l -0.81,0.14 l -0.37,2.08 l -0.79,0.87 l -2.21,0.76 l -1.77,1.47 l -1.55,0.8 l -2.08,-0.05 h -0.47 l -2.07,1.14 l -3.9,0.34 l -1.62,1.54 l -0.35,0.33 l -0.75,0.45 l -1.24,0.74 l -0.3,0.18 l -1.5,-0.26 l -1.75,0.69 l -0.70,-1.08 l -1.21,0.72 l -1.6,0.06 l -2,-0.88 l -1.52,-0.67 l -1.11,0.16 l -0.38,1.94 l -0.03,0.20 l -1.17,1.55 l -2.18,1.32 l -0.3,0.38 l -2.48,3.20 l -4.72,4.96 l -3.99,2.02 l -4.13,1.25 l -2.9,2.38 l -7.6,3.76 L 597.58,166.7 l -2.45,0.78 l -3.52,0.56 l -6.27,2.31 l -5.53,1.67 l -0.30,0.09 l -1.1,0.33 l -7.81,2.36 l -3.63,-0.38 l -2.15,0.78 l -5.60,-0.62 l -3.9,0.07 l -2.46,0.51 l -4.63,2.22 l -7.82,3.76 l -2.58,2.36 l -4.02,2.1 l -4.71,1.49 l 0.01,-1.98 l -0.02,-0.08 l -1.63,0.51 l -1.18,0.37 l -3.82,0.59 h -2.12 l -1.32,-0.38 l -0.2,0.06 l -7.81,2.56 l -8.71,0.84 l -4.36,1.4 l -3.26,-0.05 l -2.03,0.60 l -4,0.48 l -1.42,-0.38 l -0.32,-0.08 l -11.75,0.51 l -5.37,-0.60 l -2.56,0.58 l -4.3,-1.44 l -6.26,-0.72 l -1.46,-0.43 l -3.3,-0.97 l -1.49,0.85 l -1.11,0.11 l -2.66,-0.96 l -0.96,-0.02 l -2.2,0.8 l -1.26,-0.32 l -1.17,-0.93 l -2.76,-0.41 l -1.68,-1.41 l -9.4,1.24 l -2.55,-0.75 l -8.55,-2.49 l -1.36,0.06 l -1.7,1.27 l -2.54,0.92 l -2.21,0.57 l -3.01,0.1 l -3.5,-0.91 l -3.60,-1.74 l -1.33,-0.31 l -2.97,0.3 l -0.91,0.08 l -5.46,-2.93 l -7.04,-4.4 l -4.77,-2.3 l -1.79,-0.29 l -0.24,0.85 l 0.89,2.8 l 0.3,2.77 l -0.09,2.56 l -0.04,1.58 l 0.44,1.42 l 1.72,1.91 l 0.71,1.92 l 0.52,5.28 l -0.00,5.36 l -0.83,8.55 l -0.28,1.3 l -1,4.43 l -0.91,4.06 l -3.54,10.83 l -0.97,1.34 l -2.39,1.63 l -5.41,3.68 l -3.99,2.3 l -1.26,0.52 l -3.23,0.24 l -2.01,-0.1 l -2.51,-1.36 l -2.46,-0.63 l -3.23,-2.32 l -3.6,-0.74 l -3.94,-2.27 l -1.02,-1.23 l -2.14,-0.2 l -2.97,-0.89 v -0.00 l -1.09,-0.32 l -0.75,-0.22 l 0,0 l -3.8,-0.1 l -3.54,-1.63 l -1.86,-0.45 l -2.54,-0.12 l -2.66,1.23 l 0,0 l -1.35,0.62 l -1.70,-0.67 l -1.23,0.07 l -1.4,2.11 L 308,231.1 l -0.96,0.51 l -1.2,-0.01 l -0.93,-0.02 l -1.01,0.44 l -1.36,0.59 l 0,0 l -1.20,0.52 l -0.59,0.25 l -0.01,-0.01 l -0.36,0.07 l -0.64,0.11 l -0.8,0.15 l -1.41,-0.82 l -0.75,-0.44 l -1.25,-0.25 l -0.67,0.48 l -0.13,2.3 l -0.61,1.37 l -1.96,1.73 l -1.99,1.75 l -1.38,2.04 l -3.67,8.39 l -2.3,3.38 l -0.71,0.78 l -2.41,2.66 l -2.13,1.65 l -4.92,3.81 l -4.65,1.74 l -4.01,0.82 l -1.95,0.00 l -3.7,-0.49 l -3.32,-1.02 l -3.65,-2.28 l -4,-3.21 l -5.79,-5.72 l -0.82,-0.49 l -0.17,-0.11 l -1.82,-1.16 l -1.35,0.03 l -0.53,0.87 l -0.29,1.26 l -0.24,1.12 l -0.66,6.36 l 0.04,0.36 l 0.34,2.62 l 4.4,6.15 l 1.35,3.26 l 0.22,0.37 l 0.90,1.52 l 0.69,1.16 l 0.06,0.11 l 1.5,4.48 l -1.05,2.53 l 0.53,1.7 l -1.33,1.03 l -0.24,1.46 l 3.95,4.95 l 0.86,2.18 l -0.96,3.02 l -1.53,1.67 l -0.42,0.45 l 0.21,1.28 l 1.81,1.63 l 3.08,2.75 l 1.64,4.08 l 1.25,1.1 l 1.45,-0.31 l 0.81,0.61 l 1.22,-0.02 l 1.20,1.20 l 0.78,0.37 l 1.23,0.61 l 0.97,1.27 l 0.21,3.91 l 1.82,4.86 l 0.02,2.63 l 0.01,0.37 l 1.13,1.94 l 0.35,1.53 l -0.6,4.06 l 1.44,1.30 l 1.56,-0.32 l 1.01,0.16 l 1.62,1.35 l 1.96,3 l 1.92,-0.28 l 1.22,0.58 l 5.9,5.33 l 1.33,0.67 l 0.07,0.04 l 0.96,0.48 l 1.2,1.20 l 1.85,-1.23 l 0.20,-0.02 l 2.01,-0.17 l 0.88,0.6 l 1.7,1.14 l 2.23,-0.02 l 4.84,1.48 l 2.11,0.54 l 4.26,2.64 l 1.81,1.12 l 1.07,0.87 l 1.42,1.16 l 2.84,1.22 l 2.44,0.58 l 1.32,0.31 l 1,0.38 l 0.02,-0.06 h 0.01 l -0.02,0.06 l 5.28,2.02 l 2.86,0.66 l 2.64,0.97 l 1.92,0.7 l 1.41,0.02 l 2,-1.68 l 1.93,-0.11 l 1.60,0.4 l 1.57,-0.26 l 2.48,-1.53 l 0.48,-0.71 l 1.76,-0.83 l 5.94,-0.73 l 1.73,0.56 l 4.46,-1.94 l 2.98,0.83 l 2.64,-0.93 l 5.77,1.28 l 1.53,1.08 l 1.71,1.96 l 0.21,0.00 l 1.91,0.03 l -0.8,1.33 l 2.52,2.64 l 2.27,3.44 l 0.15,0.45 l 1.65,4.86 l 1.23,1.72 l 0.86,2.40 l 0.04,1.56 l -1.34,1.02 l -0.22,0.58 l -0.07,0.21 l 0.27,0.65 l 0.50,-0.27 l 0.96,-0.53 L 380,379.26 l 2.06,0.22 l 1.36,0.14 l 2.15,-1.06 l 1.42,-0.71 l 2.29,0.98 l 2.52,-0.02 l 1.05,0.47 l 3,1.35 l 1.52,0.14 l 0.56,-0.37 l 0.36,-0.85 l -0.18,-1 L 397,377.23 l -2.53,-2.93 l -1.03,-1.51 l -0.78,-2.18 l -0.24,-2.79 l -0.17,-1.88 l 0.31,-2.47 l 0.68,-0.88 l 0.5,-1.96 h 0.00 l 0.12,-0.51 l 1.40,-1.86 l 3.72,-2.39 l 4,-3.58 l 3.16,-2.08 l 3.26,-1.41 l 0.08,-0.4 l 0.36,0.14 l 8.29,-2.81 l 0.13,-0.01 l 3.69,-0.64 l 24.92,1.75 l 0.92,-0.27 v -0.00 l 0.83,-2.33 l 0.44,-0.43 l 0.3,-0.28 l 2.74,-1.20 l 1.28,-0.18 l 3.55,0.87 l 1.45,0.35 l 2.33,-1.30 l 1.65,0.02 l 3.41,-1.86 l 2.11,0.05 l 0.8,-0.32 l 4.11,-2.95 l 3.96,-1.13 l 1.03,-0.54 l 0.36,-0.2 l 4.06,-2.14 l 2.57,-1.98 l 2.22,-1.18 l 2.43,-0.62 l 6.38,-0.44 l 1.28,-2.13 l 2.74,-0.36 l 1.65,-1.87 l 1.9,-0.77 l 1.35,-1.95 l 1.13,-1.64 l 1.59,-0.92 l 5.1,-0.32 l 6.04,0.74 l 0.8,-0.48 l 1.36,-4.87 l 1.43,-0.91 l 3.85,-5.61 l 0.01,-2.04 v -1.70 l 0.63,-2.43 l -0.43,-4.39 l 0.51,-4.44 l 2.39,-5.65 l 2.10,-2.27 l 3.4,-2.3 l 1.72,-0.75 l 2.44,-0.41 v 0.00 l 0.36,-0.06 l 0.62,-0.10 l 8.43,-0.11 c 0.11,-0.08 3.06,-0.04 3.06,-0.04 l 2.81,-0.03 L 561.38,282 l 0.50,0.08 l 2.4,0.77 l 2.77,2.15 L 570,287.89 l 0.55,0.53 l 1.9,0.8 l 0.57,0.25 l 1.57,-0.25 l 2.23,-1.16 l 1.68,-1.42 l 2.3,-1.25 l 0.05,-0.08 l 1.29,-1.94 l 0.03,-0.04 l 0.02,0.00 v -0.01 h -0.02 l 0.51,-0.77 l 4.44,-1.73 l 5.23,-0.3 l 0.58,-0.31 l 0.32,-0.17 l 1.38,-1.62 l 1.29,-0.01 l 3.13,1.13 l 2.2,-0.43 l 1.75,0.7 l 1.36,-0.16 l 2.56,-0.3 l 2.75,1.93 l 1.60,0.2 l 5.65,3.31 l 0.29,0.04 l 0.15,0.02 l 0.32,0.05 l 0.67,-0.2 l 1,-0.28 l 0.13,-0.03 l 0.12,0.17 l 0.64,0.90 l 0.88,0.12 l 1.04,-1.39 l -0.41,-0.63 l -0.15,-0.23 l -2.02,-0.41 l -1.81,-3.1 l 1.72,-1.86 l -2.71,-3.32 l -0.45,-0.55 l -0.15,-0.23 l -0.93,-1.42 l -4.74,-7.23 l -6.18,-4.93 l 0,0 l -2.16,-1.73 l -0.01,-0.01 l -0.75,-0.6 l -3.3,-3.35 l -2.35,-3.13 l -0.30,-0.67 l -0.48,-1.06 l -1.41,-3.07 l -2.46,-1.9 l -2.00,-2.19 l -0.1,-0.12 l -4.14,-5.62 l -0.68,-0.94 l -0.97,-0.56 l -2.06,-0.01 l -0.2,-0.2 l -0.11,-0.12 l 0.07,-0.07 l 0.99,-0.98 l 1.10,-0.27 l 0.47,-1.08 l -2.10,-6.1 l -0.01,-0.21 l -0.15,-1.95 l 1.71,-8.85 l 0.22,-1.07 l 2.92,-5.95 l 1.81,-1.48 l 1.98,-3.89 l 1.7,-2.48 l 1.62,-1.58 l 0.28,-0.16 l 2.93,-1.77 l 2.46,-0.34 l 2.34,-0.33 l 4.1,1.26 l 3.9,-0.07 l 0.76,-0.08 l 1.77,-0.2 l 2.91,-0.91 l 1.37,-0.84 l 0.71,-1.09 l 1.48,-4.98 l 0.47,-1.58 l 0.91,-1.72 l 5.30,-6.10 l 4.01,-3.71 l 9.01,-6.61 l 4.41,-2.63 l 2.25,-1.34 l 20.12,-8.94 l 5.23,-5.3 l 2.72,-2.75 l 4.82,-3.23 l 5.64,-2.31 l 4.85,-3.84 l 1.06,-1.33 l 1.33,-4.3 l 1.11,-0.26 l 1,-2.17 l 0.28,-0.61 l 3.96,-2.79 l 0.44,-0.22 l 15.38,-7.71 l 2.23,0.30 l 1.2,-1.79 l 4.47,-0.75 l 0.82,-0.14 l 1.1,-0.55 l 0.93,-1.6 v -0.31 l 0.12,-4.27 l 0.95,-1.15 l 0.52,-2.81 l 0.49,-0.65 l 0.51,-0.67 l 1.26,-0.89 l -0.22,-0.53 L 727.13,103.96 z"
    branchDirs :: String
    branchDirs = "M 463.1,506.74 c -0.13,-0.05 -0.25,-0.14 -0.34,-0.24 l -0.12,-0.11 c -0.55,-0.51 -1.08,-1.06 -1.58,-1.64 c -1.33,-1.51 -3.11,-3.72 -4.69,-5.68 c -3.11,-3.88 -5.68,-7.22 -6.17,-7.85 l -0.79,-1.03 l -7.76,-2.39 l -5.67,-2.64 l 3.03,-3.40 l 10.40,4.45 l 7.76,1.59 l 14.36,10.56 l -0.01,0.00 c -0.02,0.02 -2.08,1.73 -4.13,3.6 c -0.91,0.83 -2.06,1.9 -2.87,2.78 c -0.33,0.35 -0.64,0.74 -0.93,1.14 c -0.17,0.28 -0.32,0.57 -0.46,0.88 M 409.76,490.72 c -7.00,-0.06 -13.87,-1.98 -19.89,-5.56 h -0.00 v -0.00 c 0.73,-1.22 1.71,-2.27 2.87,-3.1 c 1.94,-1.42 5.44,-3.12 11.1,-3.15 h 0.11 c 6.7,0 14.9,2.27 24.37,6.77 C 422.71,489.00 416.29,490.75 409.76,490.72 l 0.01,0.01 L 409.76,490.72 z M 380.39,484.21 c -1.19,0.02 -2.34,-0.46 -3.17,-1.33 c -0.70,-0.82 -1.19,-1.81 -1.42,-2.87 c -0.32,-1.38 -0.43,-2.80 -0.35,-4.21 c 0.49,-0.21 1.02,-0.33 1.56,-0.35 h 0.11 c 2.51,0 4.49,2.17 5.33,4.33 c 0.46,0.95 0.56,2.04 0.27,3.06 c -0.42,0.89 -1.35,1.43 -2.34,1.37 L 380.39,484.21 z M 432.07,478.22 c -17.35,-2.47 -24.71,-8.75 -27.83,-13.58 c -1.97,-2.93 -2.90,-6.43 -2.63,-9.96 v -0.01 h 0.01 c 0.87,-0.2 1.76,-0.29 2.65,-0.29 c 4.61,0 16.43,2.32 27.8,23.84 l 0.00,0.01 l -0.02,-0.01 L 432.07,478.22 z M 396.49,474.78 c -7.41,0 -13.06,-1.28 -16.78,-3.8 c -1.58,-1.01 -2.85,-2.44 -3.68,-4.12 c -0.30,-0.63 -0.50,-1.32 -0.59,-2.02 c 2.47,-1.00 5.1,-1.56 7.76,-1.65 c 0.38,-0.01 0.76,-0.02 1.17,-0.03 c 5.73,0 14.44,1.87 23.64,10.78 l 0.00,0.00 h -0.01 c -3.82,0.52 -7.67,0.80 -11.53,0.84 L 396.49,474.78 z M 360.58,473.40 c -7.82,0 -18.56,-2.38 -25.26,-9.08 l -0.00,-0.00 h 0.02 c 5.09,-1.20 10.29,-1.89 15.52,-2.06 c 0.48,-0.01 0.98,-0.01 1.47,-0.01 c 7.33,0 12.94,1.42 16.68,4.22 c 1.04,0.62 1.82,1.61 2.17,2.78 c 0.08,0.85 -0.32,1.69 -1.05,2.15 c -1.68,1.27 -4.69,1.94 -8.94,2.01 l -0.6,0.02 L 360.58,473.40 z M 335.24,460.40 c -0.95,0.00 -1.86,-0.42 -2.47,-1.16 c -0.56,-0.74 -0.94,-1.60 -1.10,-2.52 c -0.25,-1.20 -0.35,-2.44 -0.29,-3.67 v -0.01 c 0.38,-0.17 0.79,-0.27 1.21,-0.27 l 0,0 c 0.98,0.03 1.90,0.45 2.58,1.15 c 0.75,0.74 1.33,1.64 1.68,2.64 c 0.35,0.83 0.41,1.76 0.18,2.63 c -0.29,0.73 -1.00,1.21 -1.8,1.21 L 335.24,460.40 z M 393.77,459.08 c -1.19,0.02 -2.34,-0.46 -3.17,-1.33 c -0.70,-0.82 -1.19,-1.81 -1.42,-2.87 c -0.32,-1.38 -0.43,-2.80 -0.35,-4.21 c 0.49,-0.21 1.02,-0.33 1.56,-0.35 h 0.11 c 2.51,0 4.49,2.17 5.33,4.33 c 0.46,0.95 0.56,2.04 0.27,3.06 c -0.42,0.89 -1.35,1.43 -2.34,1.37 L 393.77,459.08 z M 365.26,457.90 c -15.73,-0.55 -23.9,-5.02 -27.98,-8.68 c -1.74,-1.53 -3.18,-3.37 -4.24,-5.44 c -0.39,-0.77 -0.69,-1.59 -0.90,-2.43 l 0.02,-0.00 c 1.26,-0.38 2.56,-0.57 3.88,-0.57 h 0.36 c 5.30,0 16.11,2.22 28.85,17.15 v 0.01 L 365.26,457.90 z M 382.35,456.31 c -12.66,-1.92 -19.83,-7.36 -23.62,-11.58 c -2.33,-2.51 -4.11,-5.48 -5.21,-8.73 c 1.28,-0.29 2.58,-0.45 3.9,-0.46 c 0.16,0 0.34,-0.00 0.52,-0.00 s 0.36,0 0.55,0.00 c 6.36,0.13 17.93,3.02 23.85,20.78 h 0.01 L 382.35,456.31 z M 317.35,450.23 c -4.03,0.01 -8.04,-0.46 -11.96,-1.43 c -6.62,-1.65 -9.47,-4.18 -10.69,-6.02 c -0.52,-0.75 -0.87,-1.62 -1.03,-2.53 c -0.05,-0.35 -0.06,-0.71 -0.03,-1.07 l 0.03,-0.01 c 3.42,-0.84 6.93,-1.29 10.46,-1.32 c 0.23,0 0.48,-0.00 0.72,-0.00 c 2.87,-0.00 5.74,0.27 8.56,0.83 c 6.39,1.33 12.09,4.93 16.05,10.14 v 0.00 h -0.01 c -3.96,0.97 -8.03,1.44 -12.12,1.42 L 317.35,450.23 z M 346.74,439.55 c -1.19,0.03 -2.34,-0.44 -3.17,-1.3 c -0.71,-0.83 -1.2,-1.83 -1.42,-2.90 c -0.32,-1.37 -0.43,-2.78 -0.35,-4.18 c 0.49,-0.21 1.02,-0.33 1.56,-0.35 h 0.11 c 2.50,0 4.48,2.17 5.33,4.33 c 0.45,0.94 0.53,2.02 0.24,3.03 c -0.40,0.89 -1.32,1.44 -2.31,1.38 L 346.74,439.55 z M 324.64,436.52 c -4.20,-1.19 -8.23,-2.94 -11.96,-5.22 c -5.54,-3.41 -12.32,-9.45 -13.15,-18.83 l 0,0 h 0.01 c 0.42,-0.09 0.84,-0.14 1.27,-0.15 c 0.1,0 0.21,-0.00 0.33,-0.00 c 1.65,0 5.04,0.46 9.14,3.58 c 5.22,3.98 10.04,10.92 14.35,20.65 L 324.64,436.52 z M 339.07,435.99 c -3.43,-1.56 -6.62,-3.60 -9.46,-6.08 c -7.35,-6.33 -13.08,-14.33 -16.71,-23.33 c 0.90,-0.42 1.88,-0.66 2.88,-0.71 c 0.1,-0.00 0.2,-0.00 0.30,-0.00 c 0.15,0 0.30,0 0.46,0.00 c 2.41,0.06 6.08,1.07 10.15,5.46 c 4.67,5.04 8.85,13.34 12.4,24.65 l 0.01,0.03 l -0.03,-0.01 L 339.07,435.99 z M 301.68,434.90 c -4.82,0 -6.47,-2.61 -6.95,-3.74 c -0.48,-1.17 -0.67,-2.44 -0.55,-3.70 v -0.02 c 0.78,-0.19 1.59,-0.30 2.4,-0.31 h 0.16 c 3.15,-0.07 6.15,1.34 8.08,3.84 c 0.25,0.37 1.03,1.69 0.39,2.72 c -0.52,0.81 -1.7,1.22 -3.53,1.22 L 301.68,434.90 z M 291,421.43 c -3.73,0.00 -7.46,-0.31 -11.14,-0.95 c -4.29,-0.78 -6.72,-4.43 -8.01,-7.35 c -0.86,-1.99 -1.46,-4.10 -1.8,-6.25 h 0.01 c 13.28,0.39 19.55,4.27 22.47,7.45 c 1.81,1.88 2.94,4.32 3.20,6.92 h -0.00 c -0.02,0 -1.89,0.18 -4.74,0.18 L 291,421.43 z M 304.83,407.61 c -0.01,-0.02 -1.53,-1.9 -3.03,-4.22 c -1.57,-2.44 -3.02,-5 -3.02,-7.08 c 0,-2.01 -0.47,-6.26 -0.75,-8.61 c -0.35,-2.98 -0.72,-5.54 -0.75,-5.75 h 0.01 c 0.33,0.12 8.30,3.11 8.30,10.59 s -0.73,15.01 -0.74,15.08 v 0.01 H 304.82 L 304.83,407.61 z M 294.5,406.90 c -0.08,-0 -0.16,-0.00 -0.25,-0.02 c -2.35,-0.39 -6.5,-2.19 -11.07,-4.81 c -5.08,-2.91 -9.20,-6.03 -11.62,-8.79 c -2.2,-2.51 -3.5,-6.45 -3.88,-11.72 c -0.16,-2.38 -0.13,-4.78 0.08,-7.16 c 0.42,-0.13 0.86,-0.20 1.31,-0.2 c 1.76,0.02 3.64,0.82 6.18,2.57 c 2.31,1.64 4.48,3.49 6.49,5.51 c 2.54,2.52 4.94,5.18 7.2,7.97 l 0.03,0.04 c 0.26,0.47 2.53,4.57 4.30,8.55 c 0.88,1.83 1.56,3.76 2.02,5.74 c 0.17,0.58 0.17,1.2 0,1.78 c -0.07,0.18 -0.21,0.34 -0.38,0.44 c -0.13,0.06 -0.28,0.09 -0.44,0.09 L 294.5,406.90 z"



{- |
Flag of Egypt coat of arms.
Drawn for a @viewbox 0 0 900 600@
-}
egCoA :: Svg
egCoA = S.g $ do
  S.defs 
    $ do
      S.clippath
        ! A.id_ "HaskellSvgIcons-egCoA-shield"
        ! A.clippathunits "userSpaceOnUse"
        $ do
          S.path
            ! A.fill "#FFFFFF"
            ! A.stroke "#C09600"
            ! A.strokeWidth "0.242"
            ! A.d "m -109.44854,181.5283 c -0.0743,0.005 -0.14904,0.007 -0.22429,0.007 -1.64187,0 -5.45544,-0.84238 -6.92547,-2.10534 -1.53974,1.16668 -5.41628,2.10534 -7.03156,2.10534 -0.0758,0 -0.15062,-0.009 -0.22481,-0.0229 -0.004,0.36798 0.0154,0.74941 0.0382,1.09633 0.0855,1.29667 0.3129,2.59794 0.65818,3.85022 1.08693,3.94096 3.31152,7.29006 6.50134,9.83059 3.19246,-2.54265 5.41973,-5.89492 6.50902,-9.8388 0.34583,-1.25198 0.57398,-2.55315 0.66026,-3.84968 0.0202,-0.36299 0.0404,-0.80747 0.0391,-1.07276 z"
  S.g
    ! A.fill "#FFFFFF"
    ! A.stroke "#C09300"
    ! A.strokeLinejoin "round"
    ! A.transform 
        (  S.translate (-0.0051) 0.00275
        <> S.matrix 0.233 0 0 0.233 344.146 97.431
        )
    $ do
      S.path
        ! A.strokeWidth "5.45" 
        ! A.d "m 457.60208,879.34399 293.822,272.76201 -20.918,-495.38002 c -3.073,-75.078 -68.316,-57.853 -115.709,-30.77 -48.01,30.77 -102.783,30.77 -160.648,10.454 -57.852,20.315 -112.629,20.315 -160.64,-10.455 -47.388,-27.08 -112.624,-44.308 -115.704,30.77 l -20.931,495.38102 z"
      S.path
        ! A.id_ "HaskellSvgIcons-egCoA-wing"
        ! A.stroke "none"
        ! A.fill "#C09300"
        ! A.transform (translate (-225.928) 881.606 <> S.matrix 4.29 0 0 4.29 (-1250.5) (-1299.595))
        ! A.d "m 393.47,246.49 -4.734,112.32 -8.035,7.168 4.879,-115.47 c 2.294,-1.578 6.313,-4.017 7.89,-4.017 z m 9.62,8.04 -4.017,93.955 -8.032,8.22 4.877,-108.49 c 1.579,1.577 6.314,5.45 7.172,6.31 z m 8.75,7.17 -3.155,78.362 -6.455,6.31 4.018,-89.406 c 1.574,1.578 4.73,3.874 5.592,4.734 z m 9.47,4.02 -3.156,66.787 -6.313,5.12 3.156,-74.345 c 1.579,0.717 4.735,2.438 6.313,2.438 z m 8.75,0 -2.297,55.657 -6.455,6.313 2.44,-61.252 c 1.575,0 5.593,0 6.312,-0.718 z"
      S.use
        ! A.xlinkHref "#HaskellSvgIcons-egCoA-wing"
        ! A.transform (S.matrix (-1) 0 0 1 908.254 5.1265e-7)
      S.path
        ! A.fill "#c09300"
        ! A.strokeWidth "4.607"
        ! A.d "m 467.68408,933.65699 41.24,187.71501 -13.547,13.536 -14.154,-10.463 -23.39,-167.39201 9.849,167.39201 -13.544,17.228 -13.54,-17.228 9.85,-167.39201 -23.383,167.39201 -14.168,10.463 -13.533,-13.536 41.233,-187.71601 h 27.087 z"
      S.g 
        ! A.id_ "HaskellSvgIcons-egCoA-zigzag"
        ! A.fill "none"
        ! A.stroke "C09300"
        ! A.strokeWidth "1.27"
        ! A.transform (translate (-225.928) 881.606)
        $ do
          S.path
            ! A.fill "#FFFFFF"
            ! A.strokeWidth "5.101"
            ! A.d "m 587.732,-30.405 -81.856,290.463 112.637,17.236 47.998,-218.47 -78.78,-89.23 z"
          S.path
            ! A.strokeWidth "5.448"
            ! A.d "m 560.661,68.697 9.848,23.994 53.219,-50.83"
          S.path
            ! A.strokeWidth "5.448"
            ! A.d "M 597.513,8.55 608.649,112.997 642.5,68.688 m -13.54,17.212 18.49,63.816 m 7.25,-23.446 -37.4,56.806 m 11.665,56.698 -11.97,-56.62 -10.45,-57.587 -25.056,33.93 -10.989,-39.121 -35.07,35.971 17.836,65.429 24.615,-40.477 13.538,41.238 25.27,-39.307"
          S.path
            ! A.strokeWidth "5.448"
            ! A.d "m 529.858,253.301 22.736,-31.934 14.813,49.152 20.31,-34.46 13.547,41.244"
      S.use
        ! A.xlinkHref "#HaskellSvgIcons-egCoA-zigzag"
        ! A.transform (S.matrix (-1) 0 0 1 908.254 5.12656e-7)
      S.g
        ! A.strokeWidth "1.27"
        ! A.transform (S.matrix 4.29 0 0 4.29 (-1476.428) (-418))
        $ do
          S.path
            ! A.strokeWidth "1.218"
            ! A.d "m 462.31,253.09 c 0.667,0.04 -0.902,-3.568 -0.902,-3.568 1.765,1.804 8.43,2.235 8.43,2.235 -4,-1.766 -7.998,-15.096 -7.528,-25.721 0.432,-10.664 -1.528,-14.86 -3.097,-16.428 -2,-2 -8.43,-3.764 -12.664,-4 -2.392,-0.117 -2,1.804 -2,1.804 -4.43,-1.137 -8.86,-1.568 -10.86,-0.235 -1.883,1.255 -2.275,7.528 -0.902,6.43 3.332,-2.666 6.234,-0.235 8.233,2.666 1.764,2.549 1.647,9.763 -0.902,18.192 -2.666,8.861 -9.959,17.722 -9.959,17.722 3.96,0 9.528,-3.528 9.528,-3.528 l -1.333,5.528 c 4.195,-2 7.528,-5.097 7.528,-5.097 l 3.999,4.195 c 1.333,-1.764 4,-4.195 4,-4.195 0,0 3.332,3.529 8.429,4 z"
          S.path
            ! A.fill "none"
            ! A.d "m 446.12,227.57 c 0,0 -2.235,16.428 -6.43,21.094 m 9.96,-21.524 c 0,0 -0.863,16.623 -3.764,21.956 m 6.894,-21.286 c 0,0 0,18.192 1.098,21.289 m 2.862,-20.389 c 0,0 0.902,15.291 4.666,20.819"
          S.path
            ! A.fill "#C09300"
            ! A.strokeWidth "0.354"
            ! A.d "m 442.08,219.61 c -0.196,-1.45 -0.549,-2.588 -1.059,-3.333 -2,-2.901 -4.9,-5.332 -8.233,-2.666 0,0 1.137,-3.529 3.568,-3.646 1.882,-0.118 6.155,1.411 9.92,7.841 0,0 -2.784,-0.627 -3.45,-0.039 -1.256,1.098 -0.746,1.843 -0.746,1.843 z"
          S.path
            ! A.fill "#C09300"
            ! A.strokeWidth "0.354"
            ! A.d "m 432.44,209.26 c 0.274,-0.902 0.706,-1.725 1.255,-2.078 2,-1.333 6.43,-0.902 10.86,0.235 0,0 -0.392,-1.921 2,-1.803 4.234,0.235 10.664,2 12.663,3.999 0.47,0.51 1.02,1.255 1.49,2.391 h -0.078 c -0.98,-1.372 -3.764,-1.293 -4.431,-1.215 -1.059,0.118 -1.725,0.078 -3.137,0.431 -0.666,0.157 -1.686,0.353 -2.235,0.784 -0.43,0.353 -0.784,1.647 -1.45,1.647 -1.059,0 -0.98,-0.274 -1.255,-0.588 -0.353,-0.431 -0.549,-1.059 -0.902,-1.02 -1.097,0.197 -2.862,-0.666 -5.096,-2.43 -2.235,-1.765 -3.098,-2.196 -5.999,-2 -2.862,0.235 -3.764,1.843 -3.764,1.843 z"
          S.circle
            ! A.cx "448.824"
            ! A.cy "210.672"
            ! A.r  "1.176"
            ! A.stroke "none"
      S.path
        ! A.strokeWidth "1.15"
        ! A.transform (S.matrix 4.29 0 0 4.29 (-1476.436) (-418))
        ! A.d "m 449.98,327.23 c 32.642,-25.106 29.843,-61.883 29.843,-61.883 -0.8613,0.17223 -1.6795,0.25835 -2.5408,0.25835 -6.8471,0 -23.178,-3.9171 -26.988,-8.8926 -4.0812,4.5034 -20.77,8.8926 -27.574,8.8926 -0.86129,0 -1.7225,-0.0861 -2.5407,-0.25835 0,0 -2.8422,36.776 29.8,61.883 z"
      S.path
        ! A.fill "none"
        ! A.strokeWidth "0.916"
        ! A.transform (S.matrix 4.29 0 0 4.29 (-1476.436) (-418))
        ! A.d "m 477.22,268.04 c -0.28097,0.0176 -0.5633,0.0264 -0.8477,0.0264 -6.2055,0 -20.619,-3.1838 -26.175,-7.9572 -5.8195,4.4095 -20.471,7.9572 -26.576,7.9572 -0.28635,0 -0.56925,-0.035 -0.84965,-0.0865 -0.0142,1.3908 0.0581,2.8324 0.14448,4.1436 0.323,4.9008 1.1826,9.819 2.4876,14.552 4.1081,14.895 12.516,27.553 24.572,37.155 12.066,-9.61 20.484,-22.28 24.601,-37.186 1.3071,-4.7319 2.1694,-9.6497 2.4955,-14.55 0.0763,-1.3719 0.15265,-3.05185 0.14777,-4.0545 z"
      S.g
        ! A.stroke "none"
        ! A.fillRule "evenodd"
        ! A.clipPath "url(#HaskellSvgIcons-egCoA-shield)"
        ! A.transform (S.matrix 16.042 0 0 16.042 2325.464 (-2179.285))
        $ do
          S.path
            ! A.fill "#C09600"
            ! A.d "M-123.976 179.26H-119.093V196.458H-123.976z"
          S.path
            ! A.d "M-119.093 179.26H-114.21000000000001V196.458H-119.093z"
          S.path
            ! A.fill "#C09600"
            ! A.d "M-114.21 179.26H-109.327V196.458H-114.21z"
      S.g
        ! A.strokeWidth "1.27"
        ! A.strokeLinecap "round"
        ! A.strokeLinejoin "round"
        ! A.transform (translate (-225.928) 881.606)
        $ do
          S.path
            ! A.strokeWidth "10.202"
            ! A.d "m 680.055,389.899 c 85.558,0 167.418,-6.769 215.42,-20.31 20.316,-3.684 20.316,-14.147 20.316,-27.694 20.315,-6.768 9.845,-30.762 24,-30.762 -14.155,3.7 -17.228,-24 -34.462,-20.299 0,-24.01 -24.006,-27.083 -44.317,-20.325 -40.626,13.546 -112.637,16.625 -180.958,16.625 -68.316,-3.079 -139.716,-3.079 -180.953,-16.625 -20.31,-6.758 -44.304,-3.685 -44.304,20.325 -17.239,-3.7 -20.315,24 -34.467,20.3 14.152,0 3.687,23.993 24,30.761 0,13.547 0,24.01 20.926,27.694 47.385,13.541 129.253,20.31 214.798,20.31 z"
          S.path
            ! A.strokeWidth "5.448"
            ! A.d "m 563.75,260.036 c 27.69,3.695 58.466,6.769 82.478,3.695 13.528,0 23.378,23.383 -3.701,27.083 -23.995,3.068 -61.542,0 -81.856,-3.7 -17.233,-3.078 -54.776,-9.844 -78.783,-16.625 -24.003,-10.452 -6.762,-30.751 6.766,-27.68 20.931,6.765 48.015,13.54 75.099,17.228 z m 232.653,0 c -27.7,3.695 -58.466,6.769 -81.86,3.695 -14.16,0 -24.008,23.383 3.077,27.083 24.005,3.068 61.55,0 81.847,-3.7 17.242,-3.078 54.78,-9.844 78.784,-16.625 24.01,-10.452 6.78,-30.751 -6.767,-27.68 -20.926,6.765 -48.006,13.54 -75.081,17.228 z"
          S.path
            ! A.strokeWidth "5.448"
            ! A.d "m 478.805,246.523 c -20.923,-3.695 -30.77,20.299 -23.993,33.835 3.073,-6.768 17.23,-6.768 20.312,-13.536 3.681,-10.455 -3.082,-10.455 3.681,-20.3 z m 81.856,62.936 c 0,-13.526 13.533,-11.863 13.533,-25.404 0,-6.766 -3.685,-17.234 -10.454,-17.234 -6.772,0 -13.546,6.768 -13.546,13.536 -3.08,13.544 10.467,15.578 10.467,29.102 z m 97.429,-38.955 c 20.294,0 18.283,27.089 8.432,40.627 0,-9.846 -17.23,-13.538 -17.23,-20.299 0,-10.476 15.556,-10.476 8.798,-20.328 z m 223.215,-23.981 c 20.926,-3.695 30.778,20.299 24.004,33.835 -3.08,-6.768 -17.233,-6.768 -20.31,-13.536 -3.694,-10.455 3.08,-10.455 -3.694,-20.3 z m -81.855,62.936 c 0,-13.526 -13.528,-11.863 -13.528,-25.404 0,-6.766 3.687,-17.234 10.459,-17.234 6.766,0 13.54,6.768 13.54,13.536 3.08,13.544 -10.471,15.578 -10.471,29.102 z m -97.43,-38.955 c -20.302,0 -18.288,27.089 -8.44,40.627 0,-9.846 17.228,-13.538 17.228,-20.299 0.003,-10.476 -15.556,-10.476 -8.787,-20.328 z"
          S.path
            ! A.strokeWidth "3.822"
            ! A.d "m 485.584,253.301 c 6.778,0 17.236,3.079 20.315,6.766 l -20.335,-6.779 z m 33.806,10.468 c 3.697,0 17.239,3.073 24.007,6.758 l -24.025,-6.779 z m 123.127,13.514 c -6.769,0 -20.31,0 -23.994,3.068 l 23.982,-3.089 z m -37.539,0 c -3.684,-3.7 -17.231,-3.7 -23.997,0 h 23.982 z M 874.57,253.301 c -6.769,0 -16.623,3.079 -20.316,6.766 z m -33.85,10.468 c -3.69,0 -17.234,3.073 -24.004,6.758 l 24.024,-6.779 z m -123.126,13.514 c 6.776,0 20.314,0 24.004,3.068 l -24.024,-3.089 z m 37.538,0 c 3.69,-3.7 17.24,-3.7 24.005,0 h -24.025 z"
          S.g
            ! A.fill "#C09600"
            ! A.stroke "none"
            $ do
              S.path ! A.d "m 479.878,307.4 c -2.291,-0.438 -3.494,-2.251 -2.918,-4.396 0.703,-2.613 2.796,-4.108 4.773,-3.408 1.258,0.444 3.56,2.765 3.57,3.598 0.012,0.956 -1.205,3.229 -1.728,3.234 -0.226,0.002 -0.576,0.2 -0.778,0.437 -0.429,0.507 -1.773,0.753 -2.919,0.534 z m 235.656,16.817 c -0.852,-0.316 -2.21,-2.225 -2.208,-3.105 0.008,-1.661 2.463,-4.367 3.984,-4.382 0.752,-0.005 2.81,1.064 3.579,1.864 1.394,1.45 1.09,3.83 -0.662,5.182 -0.862,0.666 -3.433,0.907 -4.692,0.44 z m 1.545,10.639 c -1.803,-0.61 -2.462,-1.492 -2.609,-3.49 -0.152,-2.083 0.05,-2.407 2.25,-3.607 l 1.569,-0.855 1.486,0.663 c 2.06,0.918 2.975,1.908 3.048,3.292 0.078,1.492 -1.029,3.018 -2.747,3.788 -1.508,0.676 -1.598,0.682 -2.997,0.21 z"
              S.path ! A.d "m 498.797,288.137 c -1.485,-0.047 -3.523,1.318 -4.692,2.01 -2.785,0.654 -6.026,2.365 -8.714,0.537 -2.648,-0.818 -6.17,-0.173 -6.57,3.084 0.68,2.796 4.598,4.394 6.972,2.547 1.762,-2.306 6.57,-3.659 7.105,0.268 -1.96,2.97 -1.737,6.902 -3.351,10.055 -0.263,1.964 -1.08,3.829 -2.145,5.497 -1.983,0.199 -4.092,-0.035 -5.765,1.206 -2.686,0.147 -5.426,1.482 -6.972,3.754 -1.73,2.48 -3.383,5 -3.888,8.044 0.46,3.11 4.022,4.002 6.704,4.156 2.86,0.788 5.724,1.82 8.58,2.682 4.656,1.042 9.018,2.725 13.675,3.753 6.797,2.05 13.934,2.992 20.78,4.827 0.718,0.238 1.39,0.445 2.145,0.536 2.842,0.59 4.324,-2.5 4.558,-4.826 1.41,-4.975 2.486,-10.035 3.888,-15.016 0.965,-1.997 2.13,-6.509 -1.742,-5.496 -2.21,1.324 -4.084,3.318 -6.838,3.485 -3.75,0.219 -1.61,4.055 -0.134,5.631 0.326,2.52 -0.471,5.53 -2.145,7.508 -2.23,1.414 -5.026,-0.24 -7.374,-0.804 -2.465,0.042 -7.393,-1.216 -5.094,-4.559 0.816,-2.475 0.888,-5.183 1.877,-7.641 1.259,-2.637 1.439,-5.514 2.01,-8.312 -1.55,-3.335 -4.198,1.097 -6.3,1.474 -1.45,1.007 -6.888,1.434 -4.023,4.022 2.468,1.875 0.576,5.134 0.134,7.508 -0.158,3.304 -3.594,4.093 -6.301,3.352 -2.693,-0.13 -6.441,-2.135 -4.156,-5.095 0.52,-2.467 1.381,-4.891 1.877,-7.374 1.018,-2.993 1.876,-5.846 2.95,-8.848 0.465,-2.66 1.42,-5.182 2.68,-7.508 0.075,-2.94 2.05,-5.47 2.011,-8.446 -0.2,-1.454 -0.851,-1.983 -1.742,-2.011 z M 483.38,319.24 c 0.35,-0.06 0.6,-0.008 0.938,0.134 1.071,0.456 1.103,1.327 0,2.28 -0.482,0.415 -1.03,0.816 -1.207,0.804 -2.006,-0.173 -2.598,-0.471 -2.68,-1.207 -0.075,-0.649 0.13,-0.835 1.474,-1.475 0.667,-0.318 1.124,-0.475 1.475,-0.536 z m -4.446,21.537 c -2.128,-2 -1.785,-3.46 1.361,-5.806 1.347,-1.003 2.163,-0.89 3.703,0.515 2.37,2.162 2.465,3.53 0.373,5.383 -1.034,0.916 -1.486,1.104 -2.69,1.116 -1.259,0.013 -1.616,-0.144 -2.747,-1.208 z m 13.085,3.947 a 3.688,3.688 0 0 1 -2.67,-4.666 c 0.55,-1.865 0.87,-2.048 3.604,-2.076 3.067,-0.03 3.662,0.483 3.691,3.183 0.017,1.52 -0.1,1.872 -0.857,2.576 -0.888,0.826 -2.596,1.271 -3.768,0.982 z m 382.293,0.343 c -0.974,-0.81 -1.17,-1.177 -1.181,-2.209 -0.013,-1.761 1.002,-3.053 3.2,-4.049 2.926,-1.325 4.118,-1.143 5.22,0.797 1.465,2.58 1.395,3.633 -0.36,5.371 -0.969,0.96 -1.15,1.016 -3.368,1.038 -2.177,0.013 -2.426,-0.045 -3.511,-0.948 z M 509.394,350 c -1.561,-0.416 -2.37,-1.588 -2.39,-3.46 -0.018,-1.433 0.086,-1.661 1.087,-2.445 0.65,-0.508 1.674,-0.943 2.482,-1.053 1.145,-0.157 1.564,-0.057 2.485,0.59 2.362,1.66 2.864,3.303 1.496,4.897 -1.457,1.697 -2.837,2.091 -5.16,1.471 z m 94.04,4.205 c -0.347,-0.432 -1.112,-0.687 -1.191,-1.232 0.137,-2.38 0.251,-4.79 1.01,-7.07 0.412,-2.244 0.05,-4.588 0.833,-6.773 0.802,-3.977 0.801,-8.077 1.725,-12.028 0.043,-2.035 0.236,-4.071 0.826,-6.03 0.676,-3.096 0.058,-6.333 0.97,-9.392 -0.098,-1.15 1.225,-4.218 2.387,-2.4 1.687,2.473 3.91,4.483 6.096,6.5 1.878,1.084 0.154,2.68 -1.144,3.217 -1.781,0.702 -2.214,2.664 -2.088,4.385 -0.25,1.779 -0.963,3.462 -1.036,5.277 -0.377,2.67 -0.303,5.383 -0.65,8.05 -0.781,2.613 -0.482,5.405 -0.743,8.098 0.034,1.71 -0.778,3.263 -0.666,4.979 -0.208,1.74 -0.286,3.836 -1.747,5.03 -1.41,0.712 -3.45,0.589 -4.583,-0.611 z M 730.85,312.161 c -2.069,1.565 -3.919,3.412 -5.765,5.23 -2.542,1.925 2.088,3.045 2.681,4.692 0.675,2.515 0.635,5.193 0.805,7.776 0.769,2.365 1.108,4.884 0.938,7.374 -0.222,2.67 -3.704,2.107 -5.228,3.62 -2.11,0.888 -2.952,2.962 -4.559,4.423 -1.056,2.071 -1.339,4.618 -1.474,6.972 0.151,1.921 -1.298,4.072 0,5.765 0.167,0.239 0.365,0.566 0.536,0.804 0.434,0.623 1.47,0.126 2.145,0.268 2.16,-0.12 4.412,0.203 6.435,-0.67 5.191,-0.898 10.43,-0.97 15.686,-1.207 3.214,0.103 6.307,-1.016 9.519,-0.938 2.517,0.557 3.65,-2.172 3.62,-4.156 -1.426,-2.804 -0.194,-6.129 -1.341,-8.983 -1.008,-2.885 -0.611,-6.126 -1.073,-9.116 -0.063,-2.353 -3.049,-3.225 -4.558,-1.475 -1.465,1.48 -3.83,1.776 -4.96,3.62 -1.273,2.584 2.691,2.587 3.351,4.558 0.755,1.992 0.508,4.207 0.67,6.301 0.49,2.542 -2.27,2.687 -4.021,2.95 -2.303,0.863 -5.535,1.44 -6.838,-1.34 -0.819,-2.058 -0.707,-4.26 -0.938,-6.436 -0.057,-3.826 -0.977,-7.587 -1.207,-11.395 -0.22,-4.706 -1.033,-9.381 -1.34,-14.077 -0.044,-1.954 -0.304,-5.14 -3.084,-4.558 z m -2.681,35.394 1.34,0.134 0.134,1.609 0.134,1.608 -1.743,0.537 c -0.923,0.273 -1.73,0.404 -1.742,0.402 a 10.938,10.938 0 0 1 -0.805,-0.537 c -0.942,-0.68 -0.701,-1.651 0.536,-2.949 0.698,-0.73 1.025,-0.872 2.145,-0.804 z M 599.615,307.743 c -1.63,0.579 -3.7,2.973 -5.362,2.95 -3.776,0.266 -3.249,3.943 -0.537,5.228 0.358,1.115 0.022,2.522 0.134,3.754 0.527,3.387 -1.61,6.113 -1.206,9.519 -0.19,3.733 -1.317,7.369 -1.475,11.127 -1.06,3.876 -1.072,7.86 -1.743,11.798 -0.447,3.532 -3.001,2.286 -5.229,1.341 -0.017,-1.531 -0.116,-3.027 -0.134,-4.558 0.929,-3.506 -1.892,-4.529 -4.692,-4.96 -2.944,0.278 -4.388,-2.245 -3.754,-4.827 1.265,-1.506 4.445,-1.087 6.435,-1.34 4.21,0.872 4.04,-4.77 1.877,-6.704 -1.479,-2.727 -5.14,-3.9 -6.167,-6.703 0.41,-3.717 -2.058,-7.432 -5.094,-9.25 -4.67,-0.328 -8.196,3.702 -9.921,7.641 -1.942,0.561 -3.878,1.144 -5.765,1.877 -3.042,0.761 -7.378,6.036 -3.218,8.044 2.335,0.643 9.44,2.264 6.301,5.496 -1.768,3.034 -5.152,3.086 -8.178,2.28 -3.104,0.002 -6.56,-1.51 -6.435,-5.095 -0.633,-3.217 -0.529,-6.684 -2.01,-9.653 -0.638,-3.6 -4.723,-2.758 -4.961,0.536 -3.146,2.292 -2.727,5.997 -0.536,8.715 1.367,3.127 0.013,6.768 -1.34,9.652 -0.82,3.754 -4.96,3.882 -7.911,5.095 -1.448,0.562 -6.986,-0.334 -4.96,2.815 3.23,1.14 7.09,2.166 10.457,1.34 3.53,-0.437 6.596,-2.851 8.312,-5.898 2.371,-2.403 6.444,-1.145 9.519,-1.207 3.315,-0.008 6.704,2.328 9.92,0.805 0.933,-2.421 5.243,-6.417 6.57,-2.28 -0.226,3.702 3.043,5.688 6.435,5.23 3.706,-0.212 2.336,2.62 2.28,4.826 0.244,4.009 2.83,6.112 6.166,7.776 1.137,0.306 2.338,0.203 3.486,0 3.209,-1.009 6.665,-2.44 7.642,-6.033 1.302,-2.92 1.333,-6.224 2.279,-9.25 0.76,-4.848 1.741,-9.696 1.877,-14.613 1.184,-4.455 0.844,-9.164 1.742,-13.675 0.568,-3.354 0.99,-6.707 1.341,-10.055 -0.393,-1.79 -1.166,-2.09 -2.145,-1.743 z m -29.092,17.83 c 0.65,0.08 1.01,0.876 1.073,2.28 0.068,1.561 0.885,2.834 1.877,3.083 0.782,0.196 0.715,1.025 -0.134,1.609 -0.494,0.34 -1.377,0.545 -2.95,0.536 -2.48,-0.013 -4.017,-0.655 -5.362,-2.011 l -0.805,-0.804 1.207,-0.805 a 27.579,27.579 0 0 0 2.413,-2.145 c 1.222,-1.247 2.032,-1.822 2.681,-1.743 z m 283.282,-33.79 c -2.433,0.112 -4.879,0.506 -7.105,1.073 -4.463,-0.278 -6.703,4.406 -2.413,6.703 2.58,6.583 6.608,-1.359 10.725,-0.804 6.167,1.2 6.688,7.86 7.642,12.87 0.347,4.963 1.777,9.789 3.217,14.48 4.128,4.588 -3.092,7.465 -6.167,3.887 -2.622,-2.85 -8.239,-6.347 -11.395,-2.413 -3.877,1.642 -4.036,6.823 -7.24,8.312 -5.187,1.58 -5.84,-4.8 -8.58,-7.507 -2.52,-3.537 -7.338,-3.846 -11.262,-5.095 -1.84,-3.727 -0.881,-10.063 -4.692,-12.602 -3.2,1.305 -9.066,7.302 -4.156,10.055 4.795,4.121 -2.093,6.01 -4.29,8.848 -3.139,3.495 -3.64,8.306 -4.157,12.737 -5.402,2.984 -6.454,-3.38 -7.105,-7.374 -0.42,-4.768 -4.444,-3.369 -7.24,-1.609 -4.086,1.656 -6.126,5.536 -8.982,8.58 -0.343,2.779 0.16,5.82 0.134,8.715 0.928,3.48 5.158,1.846 7.776,1.608 4.199,-1.756 5.918,2.692 2.547,5.23 -2.282,2.9 -9.523,1.385 -8.848,6.032 2.333,0.273 4.764,0.185 7.105,0 4.678,-1.278 9.701,-4.579 10.189,-9.787 0.616,-4.54 7.154,-3.713 10.725,-4.692 4.465,-1.287 9.845,-1.618 10.86,4.022 3.043,3.196 9.646,6.795 13.004,2.413 3.408,-2.082 5.046,-5.739 4.826,-9.653 -0.695,-3.366 5.443,-3.488 6.971,-1.609 2.237,3.681 9.228,2.595 12.603,0.537 3.587,-2.648 4.365,-7.315 9.519,-7.374 7.646,-2.29 15.59,-3.61 23.059,-6.435 6.05,-1.319 -0.9,-5.139 -2.413,-7.374 -4.607,-2.278 -8.615,7.044 -13.81,2.413 -4.013,-3.072 -3.74,-8.909 -5.228,-13.407 -1.017,-5.823 -0.76,-12.538 -4.96,-17.16 -2.885,-3.067 -6.804,-3.806 -10.86,-3.62 z m -29.226,40.623 c 0.54,-0.013 1.148,0.254 2.145,0.804 1.88,1.038 3.22,2.758 3.217,4.156 -10e-4,0.912 -0.233,0.974 -1.608,1.609 -0.846,0.39 -1.808,0.809 -2.146,0.804 -0.776,-0.008 -2.678,-1.53 -2.68,-2.145 -0.004,-0.255 -0.25,-1.229 -0.537,-2.01 -0.505,-1.376 -0.427,-1.358 0.268,-2.28 0.444,-0.59 0.801,-0.924 1.34,-0.938 z m 28.02,1.474 c 1.597,-0.104 2.546,0.394 3.217,1.61 0.78,1.41 0.25,2.492 -1.743,3.35 -0.873,0.378 -1.746,0.684 -1.877,0.671 -0.131,-0.013 -0.851,-0.44 -1.609,-0.938 -1.158,-0.763 -1.327,-1.132 -1.34,-2.011 -0.013,-1.353 1.498,-2.56 3.351,-2.682 z m -38.344,0.402 c 0.468,-0.072 0.894,0.172 1.475,0.67 0.772,0.664 1.016,1.197 1.207,2.548 0.134,0.939 0.113,2.153 0,2.681 -0.209,0.97 -0.229,0.926 -2.413,0.939 -2.747,0.026 -3.002,-0.274 -2.95,-2.816 0.034,-1.616 0.05,-2.051 0.939,-2.949 0.688,-0.696 1.275,-1 1.742,-1.073 z m -23.595,6.168 c 0.856,0.2 1.664,0.847 1.877,1.876 0.281,1.363 0.034,1.983 -1.073,2.548 -0.953,0.485 -3.149,0.647 -3.754,0.268 -0.196,-0.123 -0.6,-0.442 -0.804,-0.805 -0.292,-0.52 -0.238,-0.77 0.134,-1.072 0.26,-0.211 0.538,-0.514 0.536,-0.67 -0.002,-0.157 0.289,-0.7 0.67,-1.207 0.627,-0.832 1.558,-1.14 2.413,-0.938 z m 39.683,5.094 c 0.764,-0.004 1.41,0.261 1.877,0.67 0.795,0.697 0.768,1.718 -0.134,2.414 -0.58,0.447 -3.74,0.406 -4.826,0 -0.484,-0.181 -0.668,-0.424 -0.67,-0.939 -0.009,-0.604 0.16,-0.977 1.206,-1.475 0.877,-0.418 1.784,-0.665 2.548,-0.67 z m -73.666,20.673 c -0.411,-0.268 -1.02,-0.502 -0.407,-0.95 0.741,-1.298 2.222,-1.747 3.537,-2.23 2.35,-1.018 4.379,-2.747 5.893,-4.798 0.214,-1.429 1.818,-2.204 1.811,-3.697 0.013,-2.038 0.134,-4.126 -0.363,-6.118 -0.55,-1.826 -1.937,-3.226 -3.546,-4.178 -1.1,-0.865 -2.891,-1.103 -3.298,-2.635 -0.225,-1.47 1.088,-2.59 1.547,-3.9 0.958,-1.81 1.764,-3.706 2.793,-5.47 1.111,-1.235 2.826,-0.068 3.401,1.125 0.812,1.191 1.531,2.47 1.934,3.85 1.297,1.424 2.447,3.093 2.913,4.985 0.637,1.332 1.644,2.584 1.585,4.144 0,1.787 1.008,3.378 0.945,5.175 0.057,2.405 0.056,4.912 -0.823,7.182 -0.6,1.26 -1.804,2.015 -2.602,3.143 -1.368,1.268 -2.876,2.484 -4.632,3.158 -1.24,0.395 -1.96,1.826 -3.515,1.479 -2.207,0.039 -4.447,0.339 -6.637,-0.017 0.138,0.232 -0.671,-0.393 -0.536,-0.246 z m -29.387,1.931 c -1.042,-1.071 -1.267,-1.525 -1.279,-2.576 -0.012,-1.062 0.192,-1.483 1.211,-2.513 1.88,-1.899 2.8,-1.945 6.045,-0.302 3.102,1.57 4.151,1.712 4.429,0.6 0.268,-1.073 2.054,-2.055 3.75,-2.062 1.073,-0.009 1.68,0.205 2.54,0.874 1.078,0.84 1.13,0.97 1.158,2.914 0.017,1.987 -0.009,2.062 -1.246,3.158 -1.19,1.047 -1.381,1.111 -2.855,0.964 -1.876,-0.189 -3.001,-1.047 -3.307,-2.525 -0.221,-1.072 -0.598,-1.328 -0.88,-0.6 -0.09,0.235 -0.552,0.524 -1.025,0.643 -0.873,0.22 -2.355,1.152 -3.407,2.145 -0.398,0.375 -1.095,0.552 -2.225,0.563 -1.526,0.013 -1.738,-0.078 -2.91,-1.283 z m -85.03,-38.182 c -2.852,0.03 -5.923,2.429 -6.302,5.228 0.652,3.228 3.333,6.39 1.609,9.787 1.19,4.346 -3.267,5.995 -6.302,3.486 -1.832,-4.167 -2.76,-8.734 -5.496,-12.468 -3.45,-0.977 -4.953,4.534 -7.374,6.435 1.2,3.24 4.701,6.145 5.094,10.189 0.838,3.925 -1.55,8.282 -4.96,10.323 -2.942,2.809 -6.973,1.805 -10.591,2.413 -4.394,2.568 3.225,3.507 5.229,3.62 4.494,0.457 9.16,-0.136 12.467,-3.486 3.3,-1.575 3.045,-7.281 6.972,-7.91 6.814,-0.304 13.568,1.045 20.378,1.207 3.644,0.872 9.282,-0.434 11.798,2.279 0.008,4.751 4.036,7.681 7.91,9.519 2.14,0.595 4.394,-2.057 6.569,-2.548 4.141,-1.32 2.882,-6.443 5.363,-8.446 7.08,-0.383 14.227,-0.302 21.316,-0.402 1.35,0.034 1.748,-1.887 2.682,-2.681 -0.156,-2.74 -0.255,-5.46 -0.67,-8.178 -1.366,-3.46 0.22,-7.914 -2.28,-10.86 -3.56,-0.97 -6.59,2.29 -10.189,2.548 -3.973,1.77 -7.32,5.439 -7.507,9.92 -2.353,3.847 -6.125,-0.684 -4.827,-3.887 -0.148,-1.396 0.302,-3.022 -0.134,-4.29 -2.175,-2.61 -5.983,-1.757 -8.982,-2.145 -4.37,0.174 -8.635,-0.77 -13.005,-0.67 -3.83,-0.29 -7.816,0.333 -11.53,-0.67 -4.425,-0.127 -3.816,-4.455 -4.558,-7.509 -0.785,-0.582 -1.73,-0.814 -2.68,-0.804 z m 8.58,15.82 c 1.471,0.03 2.859,0.222 4.29,0.401 1.848,0.305 3.817,-0.635 5.63,0 4.19,0.713 8.381,0.545 12.603,0.939 1.114,-0.017 1.912,0.792 2.68,1.475 0.01,2.932 0.004,5.915 0,8.848 -0.127,1.105 0.328,2.566 -0.67,3.352 -0.32,0.22 -0.679,0.46 -1.072,0.536 -1.161,-0.3 -2.39,-1.064 -2.95,-2.145 -0.177,-1.534 0.077,-3.02 0.134,-4.558 -0.03,-0.398 0.174,-1.017 0,-1.341 -0.912,-0.647 -1.947,-1.068 -3.083,-1.073 -3.644,-0.125 -7.216,-0.393 -10.86,-0.536 -3.032,-0.191 -6.148,0.26 -9.116,-0.536 -1.151,-0.419 -2.65,-0.275 -3.351,-1.475 -1.005,-1.168 0.444,-2.56 1.474,-3.083 1.366,-0.621 2.819,-0.833 4.29,-0.805 z m 48.396,1.072 c 0.681,-0.009 0.898,0.214 1.207,1.475 0.197,0.805 0.427,1.79 0.536,2.145 0.156,0.506 -0.093,0.67 -0.804,0.938 -2.12,0.8 -4.229,0.72 -4.96,-0.268 -0.333,-0.448 0.055,-1.864 0.67,-2.413 1.242,-1.11 2.616,-1.875 3.351,-1.877 z"



erCoA :: Svg
erCoA =
  S.path
    ! A.fill "#FBC724"
    ! A.d "m 215.42175,135.39237 c -2.17233,0.0318 -4.90004,0.38584 -8.03908,1.14648 -10.40324,2.52071 -20.20173,12.2582 -26.62895,23.82037 -1.97376,2.43357 -7.38726,4.61372 -9.90237,4.90626 -0.23951,-1.52256 0.61785,-5.82033 2.25,-9.07229 1.38294,-2.75555 7.1869,-8.41392 13.77152,-13.23244 l 6.50977,-4.76368 -8.46681,0.9375 c -16.46416,1.81854 -30.48576,11.1853 -37.21101,24.94927 -1.74529,3.57195 -3.58081,10.43856 -4.37697,16.27542 -0.73439,5.38406 -1.54229,8.9746 -2.4004,10.90823 -0.45939,1.03518 -0.75,1.2207 -0.75,1.2207 -0.0816,-0.002 -0.87845,-0.8032 -1.79296,-3.57423 -1.4142,-4.28516 -0.88138,-9.04165 2.38281,-18.36332 1.1994,-3.42467 2.40535,-7.51173 0.25195,-7.51173 -0.93891,0 -4.07997,1.88412 -7.22853,3.98829 -11.47404,7.66823 -18.42667,22.35734 -19.36918,40.43368 -0.45337,8.69477 -0.16892,12.40585 1.39844,16.15238 1.76681,4.22327 2.10678,8.45488 1.51758,9.56643 -3.79595,-1.62359 -8.18896,-20.29707 -6.21485,-30.28132 l 1.78711,-9.0469 -5.72853,5.48829 c -5.21115,4.9922 -10.088753,13.25512 -13.013693,21.94927 -2.17733,6.47183 -2.53724,9.80295 -2.0957,19.23247 0.47071,10.05282 1.07852,12.56814 5.04297,20.81059 2.45401,5.10209 6.568533,11.58211 9.169943,14.40433 4.09442,4.44192 4.97991,7.80834 3.79297,8.81642 -2.65551,-1.02423 -11.448963,-10.21249 -14.103533,-15.33988 -1.44565,-2.79201 -3.50034,-8.18683 -4.55861,-11.98635 l -2.79883,-10.0508 -3.16211,8.8047 c -1.34715,3.75341 -2.36581,11.00078 -2.74025,19.22856 -0.50648,11.12968 -0.20722,14.61368 1.89453,21.53325 4.32349,14.23413 15.543323,28.47382 28.906313,36.72273 5.35842,3.30771 7.44486,5.56748 7.59181,7.33791 -0.58527,-0.0418 -1.52577,-0.29343 -3.27931,-0.91211 -9.9932,-3.5258 -20.039493,-11.16668 -28.535203,-21.77543 l -5.64454,-7.04495 0.76562,9.52151 c 2.55801,31.79375 26.172103,59.86539 56.392693,66.98842 4.18733,0.98696 8.91665,1.81979 10.65823,1.83009 2.23859,0.0137 6.28794,3.11719 7.01173,4.74805 -0.18024,0.029 -0.27823,0.062 -0.55469,0.082 -4.33763,0.31429 -16.47919,-1.11986 -25.88092,-3.32814 -5.31111,-1.24747 -13.56051,-4.07593 -18.33792,-6.28321 -3.92162,-1.8119 -7.21313,-3.04235 -8.28517,-2.97658 -0.18082,0.0111 -0.62827,0.10718 -0.89258,0.42188 -0.46765,0.55678 -0.24356,1.05387 -0.0801,1.33398 12.12475,20.76752 34.10662,38.02586 59.11145,46.45909 15.66615,5.28361 26.72006,6.80647 52.58019,7.28713 13.86549,0.25768 25.716,0.46322 26.70514,0.45312 -0.64541,0.626 -1.71258,1.39116 -3.41212,2.36133 -2.47245,1.41135 -7.77876,5.04555 -11.81838,8.08205 l -8.12112,6.10353 3.11329,4.20899 c 1.33705,1.80843 2.30218,3.74405 4.84767,2.5879 1.92204,-0.873 4.98731,-3.61173 11.58401,-9.21291 3.78854,-3.2168 6.97147,-5.39157 7.47463,-5.62892 0.19492,1.51702 -0.66721,5.52729 -2.49416,9.18947 -0.87574,1.75517 -1.60013,3.47606 -1.59179,4.14063 0.002,0.15146 0.0122,0.55181 0.41601,0.86719 0.48053,0.3755 3.81995,0.78229 7.50587,1.19728 l 7.95315,0.89648 -0.72071,-6.83791 c -0.31607,-3.00397 -0.12041,-6.92042 0.39063,-8.6836 l 0.54687,-1.88868 9.60159,9.09767 0.28906,0.27735 h 0.0254 c 5.17985,4.89369 9.8572,9.06053 11.31448,9.959 0.16641,0.1026 0.47929,0.28516 0.82813,0.28516 1.02792,0 2.84565,-1.55057 4.30274,-3.10157 l 3.31446,-3.53126 -6.86134,-6.16993 c -3.39388,-3.05139 -9.65784,-7.63227 -13.918,-10.18361 -2.76702,-1.65716 -4.44585,-2.70085 -5.31642,-3.39454 0.0691,-0.0185 0.1329,-0.0392 0.21094,-0.0586 1.28786,-0.32117 14.51168,-0.85598 29.04498,-1.07422 23.592,-0.35411 27.95908,-0.74108 39.27547,-3.46876 15.59557,-3.75914 28.4679,-8.95166 39.27548,-15.87112 9.69904,-6.20975 20.40373,-16.7089 24.34576,-23.94537 l 4.30469,-7.89845 -8.58205,4.27931 c -7.15991,3.57076 -13.7139,5.14058 -25.29303,5.99415 -5.1739,0.38138 -11.9265,0.96167 -15.00979,1.28711 -4.34334,0.45848 -4.459,0.15131 -4.459,-0.17774 0,-1.5287 4.50697,-3.89584 11.83402,-4.83204 8.39475,-1.07263 20.10356,-5.40754 27.586,-10.209 17.10195,-10.97411 29.80709,-34.07246 29.86724,-54.29894 l 0.0273,-9.09768 -3.8672,5.58009 c -5.23941,7.56517 -23.29387,20.67778 -27.96295,20.67778 -1.21088,0 -1.24677,-0.29023 -0.63867,-1.31446 0.5806,-0.97791 1.75228,-2.21543 3.56641,-3.56641 13.50637,-10.05822 24.73835,-24.66496 29.54694,-38.48055 3.15892,-9.07592 3.08866,-29.66129 -0.0918,-40.46883 l -3.20704,-10.89456 -2.96484,9.98244 c -2.76684,9.32029 -12.63071,25.88367 -16.78911,29.06256 -0.43278,0.33085 -0.63179,0.39569 -0.6875,0.39845 -1.11608,0.0553 -0.3043,-4.53748 4.084,-10.32035 9.37077,-12.34875 12.74092,-23.33774 11.52346,-37.74031 -0.87278,-10.32502 -5.76936,-22.88815 -12.53909,-32.23834 l -6.1465,-8.48635 -0.90039,14.89065 c -0.69459,11.4866 -2.47223,19.88719 -4.27736,22.45709 -0.37804,0.5382 -0.60156,0.58789 -0.60156,0.58789 0,0 -0.0875,-0.0172 -0.24804,-0.17774 -1.03504,-1.03503 -1.10579,-4.8528 0.58593,-15.56839 3.23717,-20.50476 -4.38691,-40.19817 -20.51371,-52.97082 -2.36509,-1.87313 -4.64041,-3.42769 -5.51563,-3.5625 -0.18323,-0.0282 -0.65988,-0.0517 -1.01758,0.32617 -0.26648,0.28152 -0.31156,0.7238 -0.31446,0.85938 -0.0225,1.05613 0.79865,4.96623 1.92188,9.334 2.08747,8.11739 2.36414,15.34528 1.22461,17.64653 -0.21594,0.43608 -0.40234,0.46874 -0.40235,0.46874 0,0 0.1045,0.0572 -0.0371,-0.0859 -0.79884,-0.80735 -1.91995,-3.79526 -3.41798,-9.71877 -1.47877,-5.84734 -3.98853,-13.33466 -5.60158,-16.6602 -5.64901,-11.64625 -18.14513,-22.09892 -30.60943,-25.60552 -5.04755,-1.42004 -7.74824,-2.18342 -8.70705,-2.08594 -0.34313,0.0349 -1.03881,0.27203 -1.13672,1.01562 -0.13494,1.02493 1.34751,2.06103 3.06445,3.4336 9.07467,7.25481 16.34882,17.30137 15.42192,19.71684 -0.21984,0.57288 -0.74757,0.90181 -3.25392,0.42773 -1.48571,-0.28102 -2.55371,-0.64954 -3.50196,-1.11718 -0.11772,-0.4278 -0.28856,-0.85509 -0.51367,-1.2793 -6.37294,-12.00724 -17.16697,-21.25142 -27.84186,-23.83794 -12.55613,-3.04259 -18.55575,0.42565 -8.5801,4.9629 5.13432,2.33353 8.42971,5.82836 8.42971,8.93752 0,1.71437 -1.13614,1.20904 -4.48243,-2.00001 -9.89907,-9.48062 -32.04077,-12.25439 -26.0274,-3.25976 3.2564,4.87347 8.70355,7.38752 19.63481,9.05861 10.44514,1.59786 12.89236,2.67702 7.54493,3.32617 -7.60825,0.92208 -10.94758,0.66782 -14.25394,-1.08984 -6.45952,-3.43539 -6.79265,-1.33435 -0.77929,4.89063 7.87133,8.14577 15.31268,11.23198 25.29498,10.48635 8.30047,-0.6212 13.7887,-1.90729 17.17972,-3.54297 1.90583,0.0697 3.57072,0.70297 6.9883,2.26758 4.05779,1.85771 5.98243,3.55431 5.98243,4.02345 0,0.50257 -0.38281,0.86574 -10.40041,0.44531 -6.28866,-0.26397 -12.28269,-0.92962 -13.25394,-1.36523 -0.82873,-0.37172 -1.72685,-0.80284 -2.41016,-0.42969 -1.2888,0.7038 -0.30215,2.34441 0.72266,4.32618 2.89841,5.60487 10.3798,12.24997 17.68363,15.84769 5.88574,2.89921 8.19699,3.29496 19.49222,3.3418 11.56016,0.0481 12.43917,0.28392 14.87504,2.57227 1.55917,1.46479 2.65625,3.40896 2.65625,4.2129 0,0.86949 0.2811,1.06055 -5.63672,0.44726 -5.88549,-0.60998 -15.19115,-2.84553 -19.83989,-4.75586 -0.49523,-0.2035 -1.28869,-0.35353 -1.82227,0.29882 -0.36736,0.44914 -0.33208,1.09739 -0.25,1.48828 0.62542,2.97822 7.4375,12.67267 12.47073,17.31059 6.70693,6.18057 21.10203,13.83883 28.34186,15.0137 3.02131,0.49028 3.73833,1.0715 5.63087,5.34962 1.27815,2.88944 2.25001,5.7976 2.25001,6.4844 0,0.67806 -1.63873,0.87528 -2.15431,0.041 -0.63998,-1.03558 -3.83084,-1.87884 -6.91798,-2.3418 -6.15721,-0.92331 -12.08745,-3.68686 -17.33402,-8.10158 l -3.71876,-3.12696 -1.59375,1.14649 2.34765,5.95118 c 4.92034,12.48301 6.18737,14.96506 11.30081,22.13091 5.4306,7.61032 14.98997,16.94815 21.07231,20.54105 2.48391,1.46728 2.86865,2.14783 2.85352,5.85354 -0.009,2.29645 -0.25453,4.01704 -0.66211,5.17579 -0.50898,1.44705 -0.96096,1.58133 -1.64649,1.0918 -0.91078,-0.65039 -4.75854,-3.36687 -8.55665,-6.04103 -7.69479,-5.41767 -10.85033,-8.64812 -13.4473,-13.57425 l -1.85938,-3.5254 -1.9082,0.4668 -0.0371,7.63478 c -0.0778,15.59191 4.82935,34.75836 11.77736,45.89072 7.20736,11.54782 7.1853,11.8421 4.06446,18.89848 -1.15321,2.60762 -2.13886,4.21228 -2.99218,5.03908 -0.39553,0.38324 -0.63869,0.43359 -0.63869,0.43359 -0.0461,-0.009 -0.41981,-0.318 -0.71093,-1.82032 -0.29547,-1.52484 -2.13284,-4.85943 -4.06251,-7.66407 -5.2406,-7.61698 -7.98176,-14.76036 -8.90236,-23.12115 l -1.26563,-11.49221 -4.02735,8.93361 c -5.13123,11.38702 -6.71783,22.60009 -6.87306,47.67197 l -0.14453,23.07623 -4.18751,4.81446 c -3.17843,3.6538 -5.81098,6.02487 -7.68556,7.16018 -1.04145,0.63072 -1.51362,0.6298 -1.5547,0.63085 -0.0172,-0.0858 -0.0334,-0.20579 -0.0176,-0.41601 0.0466,-0.61906 0.29723,-1.54063 0.85157,-2.85548 0.99126,-2.35108 2.06005,-10.15413 2.54298,-17.61137 0.52505,-8.10821 1.82174,-16.36657 3.25586,-20.84965 1.20392,-3.76317 2.08749,-7.21801 2.04297,-8.23439 -0.007,-0.1577 -0.004,-0.51407 -0.33984,-0.84961 -0.61285,-0.61285 -1.43042,-0.2801 -1.8418,-0.0625 -3.17396,1.67907 -14.56505,13.72424 -21.01372,22.27544 -4.17662,5.53839 -10.76277,16.26663 -14.6387,23.84185 -7.66502,14.98069 -10.8973,19.34727 -16.5137,22.81841 -2.9633,1.83143 -21.00032,9.55536 -23.29498,10.15431 -0.23475,-2.6009 -0.6104,-9.5128 -0.94336,-17.77738 -0.6795,-16.86609 -1.47561,-24.10944 -3.70508,-33.54499 -0.30848,-1.3054 -0.21728,-1.57953 1.69922,-2.06056 1.98445,-0.49805 7.08452,-4.66111 11.49416,-9.13282 l 7.5547,-7.66018 5.11916,1.58984 c 12.31408,3.82341 28.86204,-0.11406 36.82039,-8.85353 3.16894,-3.48001 7.13469,-8.99561 7.79494,-10.71291 0.0801,-0.20822 0.19459,-0.66811 0.10742,-0.9961 -0.2674,-1.00596 -1.23495,-0.87467 -1.65235,-0.67578 -0.60143,0.28656 -4.02312,1.93803 -7.6172,3.67579 -6.31893,3.05526 -10.78902,4.1972 -12.45511,3.94727 -0.0398,-0.006 -0.0353,-0.0129 -0.0664,-0.0195 0.28914,-0.72133 1.64736,-2.13209 4.88282,-4.26954 6.04966,-3.99659 12.65095,-12.21354 14.75003,-18.43558 0.71303,-2.11387 1.81355,-5.15431 -0.0527,-5.15431 -0.52807,0 -2.66874,0.87181 -4.99024,1.8418 -2.20685,0.92208 -6.28301,1.68358 -9.07619,1.6836 -7.03347,0 -11.78346,1.75108 -15.16995,5.86133 -1.4207,1.72434 -2.82549,2.19815 -3.53322,2.06447 -0.45593,-0.0861 -0.99999,-0.57847 -0.54883,-2.26173 0.41401,-1.54476 0.74247,-4.61544 0.75196,-6.8379 0.0111,-2.72209 0.79251,-4.22536 4.06055,-7.21877 l 4.37697,-4.00586 -1.01758,-1.70118 -3.8711,1.34766 c -8.06362,2.81099 -15.11906,8.69639 -18.68754,15.65042 -3.03848,5.92122 -3.37877,7.79073 -2.92384,15.7891 0.33205,5.83806 -0.005,9.5021 -0.9336,11.32034 -1.93375,3.78794 -9.5592,10.6114 -15.25589,13.5176 -4.39312,2.2412 -3.828,1.94614 -4.53712,0.6211 -4.22517,-7.89474 -10.59603,-38.14823 -10.41212,-49.58019 0.17685,-10.99607 0.76697,-11.7725 6.66602,-13.27737 3.24258,-0.82719 8.23087,-3.17908 11.06839,-5.21681 5.38852,-3.86977 12.24919,-4.53283 17.04886,-1.78906 7.87693,4.50285 23.43236,0.5145 31.11921,-7.66799 1.9376,-2.06272 3.47709,-3.61692 2.75976,-4.70704 -0.78451,-1.19224 -2.77235,-0.0827 -5.22657,1.19726 -3.70379,1.93166 -9.77359,2.1465 -14.72073,0.42189 -2.10354,-0.7333 -2.87037,-1.45854 -2.92383,-1.65431 0,0 1.00188,-0.9312 4.60547,-1.41211 6.85021,-0.91418 14.53345,-5.70599 19.67193,-12.1719 1.98061,-2.49231 3.81835,-4.80349 3.81835,-5.44728 0,-1.25662 -0.76391,-1.02178 -1.00781,-1.03711 -0.64521,-0.0406 -2.50202,0.53822 -4.64063,1.27344 -3.36164,1.15567 -4.86475,1.1345 -9.91018,-0.30078 -6.07556,-1.72833 -6.96117,-1.68936 -11.74611,0.80469 -2.28092,1.18889 -3.61782,1.87266 -4.39259,2.13282 -0.004,10e-4 -0.008,5.7e-4 -0.0117,0.002 -0.006,-0.14526 -0.01,-0.29896 -0.01,-0.50195 0,-1.22321 1.19981,-2.91769 7.08595,-8.9883 l 4.23048,-4.35743 h -5.81446 c -5.54298,0 -13.84799,4.5578 -16.71293,9.19338 -1.3622,2.20407 -3.82519,7.64756 -5.50978,12.13283 -4.05694,10.80185 -7.55785,15.02355 -14.85354,18.25004 -3.47293,1.53592 -6.7716,2.7129 -7.06056,2.7129 -0.32343,0 -0.0974,-2.46589 5.57813,-12.99417 6.62211,-12.28404 11.8667,-24.57247 14.19535,-33.30867 1.78795,-6.70768 3.18902,-8.54467 10.67384,-13.60745 5.25025,-3.55128 5.72704,-3.67201 12.40433,-3.04883 11.37893,1.06258 17.57794,-0.25259 23.4688,-5.29494 2.03323,-1.74036 3.53727,-3.3057 4.36914,-4.48829 1.7751,-2.52343 0.52441,-4.24383 -2.62109,-2.93164 -3.64839,1.52194 -11.63677,2.70126 -13.04691,2.16016 -1.11219,-0.42665 -1.12157,-0.88301 -1.04687,-1.08203 0.161,-0.42889 0.94116,-1.14314 2.60157,-1.50782 5.6043,-1.23092 16.12503,-11.80521 16.12503,-16.6016 0,-1.23076 -0.68236,-2.26526 -2.14845,-1.75977 -0.51103,0.17619 -1.22413,0.61161 -2.05468,1.19336 -1.42321,0.99686 -4.62706,1.64455 -8.7676,1.64453 -6.50912,0 -7.51945,0.37242 -10.80666,4.4922 -1.21063,1.51729 -2.2332,2.5112 -2.97462,3.14454 -0.13487,-0.63682 -0.26563,-1.40467 -0.26563,-2.46484 0,-2.75826 0.87693,-4.57783 4.23829,-8.11135 l 6.14454,-6.45704 h -5.5293 c -4.78287,0 -11.30503,4.76751 -13.93363,9.95119 -1.22448,2.41474 -2.70735,8.28907 -3.35937,13.1094 -0.98335,7.2697 -1.66832,8.90322 -4.72853,12.06057 -2.97975,3.07432 -4.62914,3.74339 -4.78712,3.64455 0,0 -0.2845,-0.65468 0.125,-2.59962 3.65447,-17.35697 3.38518,-24.93855 -1.41212,-38.33602 -2.73466,-7.63727 -2.7001,-7.86871 -1.0625,-11.30276 1.09569,-2.29781 1.98183,-6.51599 1.97462,-9.34572 -0.0131,-5.49015 -4.34016,-16.22399 -7.8047,-19.08988 -1.1124,-0.92023 -2.70377,-1.56299 -3.26759,0.56054 -0.30839,1.16154 -0.33984,3.45643 -0.33985,7.56251 0,8.10164 -0.19822,7.93948 -1.33593,7.93948 -0.99081,0 -1.3779,-0.44895 -1.37891,-0.48438 -0.0375,-1.28253 -3.2012,-5.19034 -6.74221,-8.94728 l -7.53126,-7.99221 -1.81055,4.75587 c -1.78308,4.68958 -0.52113,9.07841 3.82227,14.53714 1.46231,1.83781 2.39407,3.22824 2.84767,4.20704 0.49709,1.07266 0.37719,0.97007 -0.0684,0.96876 -1.50803,-0.005 -8.56794,-4.2505 -10.44144,-6.52736 -0.552,-0.67085 -1.1178,-1.37144 -1.79101,-1.40821 -1.7557,-0.0959 -1.19587,1.98277 -0.80664,3.78712 1.89817,8.79956 11.31441,15.88095 21.89847,16.74613 9.11,0.74467 9.83195,1.73533 9.69924,22.47856 -0.0901,14.08936 -0.53055,17.41635 -4.2207,31.81062 -2.28331,8.90655 -4.49317,16.33499 -4.57423,16.41604 -0.92507,0.92507 -5.86887,-1.44858 -12.82229,-7.95314 l -7.29104,-6.82032 0.10352,-6.79884 c 0.0649,-4.28159 -0.6896,-9.37024 -1.83008,-12.0762 -1.65415,-3.92468 -11.13334,-15.12396 -14.46292,-17.38481 -0.38554,-0.26178 -0.96178,-0.54883 -1.38672,-0.54883 -2.22307,0 -0.81607,3.39268 0.39453,5.86329 1.15005,2.34706 2.42839,6.4398 2.8457,9.10745 0.61564,3.93532 0.3765,3.82422 -0.0508,3.82422 -0.47524,0 -1.29529,-0.63393 -1.61914,-1.65429 -1.25347,-3.9494 -7.34773,-6.56838 -13.7637,-6.56838 -4.19927,0 -5.3018,-0.47062 -8.19143,-3.50195 l -6.14649,-6.4512 1.5664,7.07424 c 1.73071,7.80778 5.92896,14.30824 11.80863,18.13871 4.04051,2.63231 4.99721,4.09457 4.92579,4.22072 -0.25376,0.44827 -2.73374,0.9353 -8.1719,0.70508 l -11.19923,-0.47266 4.57813,4.97071 c 5.67915,6.16249 11.56941,7.82889 26.43755,7.85743 l 12.99808,0.0254 7.30471,6.41213 c 9.82337,8.62444 10.14186,9.88585 6.85547,15.09183 -12.37868,19.60905 -18.16974,42.53586 -14.77346,59.05286 1.15897,5.63568 1.14118,8.1061 0.86523,8.28322 -0.15598,0.10011 -2.0704,-0.97564 -5.99806,-4.82423 -8.44219,-8.27258 -9.21886,-9.97646 -9.91994,-21.72857 -0.88397,-14.81853 -5.83274,-22.69352 -17.73832,-27.92387 -2.45927,-1.08043 -4.20493,-1.7759 -5.18751,-2.05861 -1.56946,-0.45158 -3.22927,0.30326 -1.64844,1.94337 0.32645,0.3387 0.94878,0.82278 1.77344,1.40039 1.2058,0.84459 2.6936,3.07137 3.29103,5.04298 2.15111,7.09928 2.08844,10.66397 1.61132,10.92385 -0.0765,0.0417 -1.28029,-0.40536 -3.48243,-3.15039 -3.36006,-4.18843 -4.47762,-4.67775 -10.29885,-4.67775 -7.62614,0 -12.90304,-1.58409 -16.11331,-4.59962 l -4.45509,-4.1836 v 4.93946 c 2e-5,7.51189 11.46483,20.62555 21.45317,25.06451 2.68701,1.19415 4.39259,2.77256 4.39259,2.87696 0,0 -0.008,-0.007 -0.24024,0.10742 -1.66391,0.82551 -6.77158,0.56145 -10.49416,-1.09376 -5.07482,-2.25659 -10.71078,-4.043 -12.44339,-3.87695 -0.2474,0.0237 -0.67658,0.12189 -0.96289,0.4082 -0.44019,0.44019 -0.40668,1.02427 -0.33398,1.3711 0.47994,2.28954 5.97797,8.76887 9.33596,11.13478 11.74626,8.27587 24.10145,10.33499 34.04108,5.38673 l 4.43751,-2.20898 5.24415,5.49805 c 2.52359,2.64582 4.6468,5.12072 5.35743,6.18361 0.0164,0.0246 0.0307,0.0502 0.0449,0.0723 0.0129,0.0198 0.0242,0.037 0.0351,0.0547 0.0101,0.0159 0.019,0.033 0.0274,0.0469 0.007,0.0125 0.0153,0.0245 0.0215,0.0352 0.005,0.0101 0.009,0.0174 0.0137,0.0254 0.004,0.007 0.009,0.0139 0.0117,0.0195 l -0.0312,-0.23243 c 0,1.11239 2.90196,3.57729 5.97854,5.92385 6.19091,4.72194 8.02383,7.5925 8.07813,11.77541 0.0263,2.03104 1.55488,7.1148 3.34571,11.52542 3.22869,7.95172 3.15379,7.56621 2.85744,33.89851 -0.14278,12.68755 -0.44015,23.05852 -0.67578,25.60356 -3.5382,-1.07793 -16.60086,-8.03603 -21.8067,-11.85744 -6.26304,-4.59749 -13.15221,-13.25825 -20.50785,-25.89654 -12.92955,-22.21523 -21.78655,-33.05963 -34.12117,-41.61142 -1.81135,-1.25585 -3.37173,-2.11163 -4.36133,-2.43945 -1.25041,-0.41422 -2.84144,-0.005 -2.27345,1.66601 0.16978,0.49936 0.66961,1.20536 1.33203,1.9336 1.44242,1.5859 3.60611,11.82005 4.65626,23.67974 0.5589,6.31162 1.82384,13.14443 2.98439,15.3887 1.66916,3.22783 1.288,4.40626 0.17578,4.40626 -0.0998,0 -3.25181,-2.34682 -6.62501,-5.53712 l -5.83596,-5.51954 -0.16992,-16.36722 c -0.21745,-20.93282 -4.85952,-46.67819 -10.29494,-56.48841 -0.35592,-0.64238 -0.68084,-1.20428 -0.96289,-1.54296 -0.95482,-1.14651 -2.09025,-0.68182 -2.51173,0.64648 -0.26379,0.83134 -0.48034,2.37048 -0.79883,4.77735 -0.88452,6.68431 -4.20729,15.1403 -7.11524,18.35356 -1.22064,1.34881 -2.75,4.9786 -3.54493,8.1094 -0.80276,3.16154 -1.94163,4.70479 -2.03711,4.76954 -0.027,-0.019 -0.0562,-0.0396 -0.0898,-0.0664 -0.93354,-0.74055 -2.57701,-3.03264 -4.03516,-5.86721 l -3.09181,-6.00977 4.0879,-6.39454 c 9.14225,-14.29167 13.68437,-30.91357 13.5723,-49.57043 l -0.0684,-10.91603 -1.94728,-0.37891 -1.98828,4.834 c -2.60595,6.32821 -4.11911,7.94893 -10.39065,11.12697 -3.09846,1.57013 -7.08275,4.54022 -8.83205,6.61916 -1.84564,2.19341 -3.09668,3.00757 -3.60352,3 -0.5191,-0.008 -1.29883,-1.70346 -1.29883,-6.91603 0,-3.54222 0.29943,-4.11844 5.42579,-7.70705 2.15063,-1.50554 3.77172,-3.11547 4.67775,-4.02149 13.80004,-13.80004 17.00561,-19.8923 22.11137,-31.89655 1.87831,-4.53749 3.13369,-7.94883 3.69922,-9.93947 0.33793,-1.18951 0.69859,-2.50649 -0.17187,-3.06642 -1.29554,-0.83335 -2.49096,1.2666 -3.91797,3.78712 -2.93922,5.19151 -6.30739,7.0944 -14.77934,7.96876 -3.56517,0.36797 -7.38229,1.39475 -8.39845,2.61915 -1.31778,1.58783 -3.94727,1.44383 -3.94727,0.40821 0,-0.82839 1.01742,-3.99239 2.3457,-7.0801 2.24067,-5.20855 2.05635,-5.0828 7.89651,-5.68556 9.14129,-0.94345 16.45924,-4.56415 24.23442,-11.90822 5.94012,-5.61081 13.63971,-16.42209 13.67386,-19.79106 0.005,-0.45214 -0.27129,-1.01398 -0.83789,-1.19337 -0.97046,-0.30727 -2.29793,0.67848 -3.49025,1.76955 -3.40672,3.11809 -5.64858,3.65137 -14.17971,2.69726 -6.39554,-0.71529 -6.90996,-1.13514 -7.09181,-2.40625 -0.12361,-0.86409 0.80536,-3.10924 2.29883,-4.72071 l 2.41602,-2.60353 4.91212,2.17189 c 4.5368,2.00679 7.42317,2.42524 13.03909,1.91601 9.85284,-0.89342 21.57992,-6.73805 26.31841,-13.27932 1.90428,-2.62878 3.64455,-5.35494 3.64455,-6.24611 0,-1.75994 -3.1842,-1.61682 -5.77346,-1.26953 -2.43557,0.32668 -7.88895,0.24091 -12.08987,-0.20898 -4.74801,-0.50846 -6.6569,-1.33722 -6.74611,-1.68556 -0.0513,-0.20028 1.1545,-1.49088 5.2676,-3.39648 3.82014,-1.76992 5.31357,-3.02641 10.47072,-2.9922 3.38667,1.13366 8.39277,2.75433 14.62308,3.32227 9.9823,0.74563 17.42365,-2.34058 25.29497,-10.48635 6.01336,-6.22498 5.68022,-8.32407 -0.7793,-4.88869 -3.30636,1.75767 -6.64567,2.00997 -14.25393,1.0879 -5.34742,-0.64915 -2.90021,-1.72832 7.54494,-3.32618 10.93126,-1.67108 16.37841,-4.18318 19.6348,-9.05666 6.01337,-8.99463 -16.12833,-6.2228 -26.0274,3.25782 -3.34628,3.20904 -4.48243,3.71634 -4.48243,2.00196 0,-3.10915 3.29734,-6.60594 8.43166,-8.93948 7.48174,-3.40293 5.976,-6.20472 -0.54102,-6.10938 z"



{- |
Flag of Croatia coat of arms.
Drawn for a @viewbox 0 0 1200 600@
-}
hrCoA :: Svg
hrCoA =
  S.g
    ! A.transform (S.scale 0.00296 0.00296)
    $ do
      S.path 
        ! A.fill "#FF0000"
        ! A.d "m202577,153674,0,0c21658,0,39377-17720,39377-39377v-46791h-78755v46791c0,21658,17720,39377,39377,39377z"
      S.path
        ! A.fill "#FFFFFF"
        ! A.d "m202577,153043,0,0c21245,0,38626-17382,38626-38626v-46153h-77253v46153c0,21245,17382,38626,38627,38626z"
      S.g 
        ! A.fill "#FF0000"
        $ do
          S.path ! A.d "m180254,69716-14865,0,0,16332,14865,0z"
          S.path ! A.d "m209985,69716-14865,0,0,16332,14865,0z"
          S.path ! A.d "m239701,86048,0-16332-14851,0,0,16332z"
          S.path ! A.d "m180254,102379,14865,0,0-16331-14865,0z"
          S.path ! A.d "m209985,102379,14865,0,0-16331-14865,0z"
          S.path ! A.d "m165389,114326c0,1483,92,2946,263,4385h14602v-16332h-14865v11947z"
          S.path ! A.d "m209985,102379-14866,0,0,16332,14866,0z"
          S.path ! A.d "m239437,118711c172-1444,264-2912,264-4400v-11931h-14852v16332h14588z"
          S.path ! A.d "m180255,135042,14865,0,0-16331-14865,0z"
          S.path ! A.d "m209985,135042,14865,0,0-16331-14865,0z"
          S.path ! A.d "m171754,135042c2321,3429,5199,6454,8501,8944v-8944h-8501z"
          S.path ! A.d "m205141,151374c1645-115,3262-337,4843-661v-15671h-14865v15673c1576,323,3189,544,4829,658,1731,107,3462,101,5192,0z"
          S.path ! A.d "m224850,143976c3296-2488,6169-5509,8487-8933h-8487v8933z"
      S.g $ do
        S.path 
          ! A.fill "#FFFFFF"
          ! A.d "m240533,67027,9217-20893-7022-11339-11634,4307-8168-9337-10763,6168-9597-7860-9597,7860-10763-6168-8169,9336-11634-4307-7024,11342,9205,20897c11599-5250,24460-8175,37983-8175,13517,0,26372,2923,37968,8169z"
        S.g $ do
          S.path
            ! A.fill "#0093DD"
            ! A.d "m174293,40024-17,20-11537-4272-6456,10424,2473,5623,6265,14222c4678-2068,9555-3764,14594-5048l-5321-20968z"
          S.path
            ! A.fill "#FFFFFF"
            ! A.stroke "#000000"
            ! A.strokeWidth "118"
            ! A.d "m173629,50332c413,783,647,1674,647,2617,0,3106-2533,5639-5639,5639-2737,0-5029-1968-5535-4561,974,1722,2823,2888,4935,2888,3121,0,5667-2545,5667-5667,0-312-26-618-75-917z"
          S.g
            ! A.id_ "HaskellSvgIcons-hrCoA-star" 
            $ do
              let c1 = 165500
              let c2 = 44500
              starRegular  6 3500 (c1 , c2)
                ! A.fill "#F7DB17"
                ! A.stroke "#000000"
                ! A.strokeWidth "118"
                ! A.transform (rotateAround (-19) c1 c2)
              asteriskStar 3 3500 (c1 , c2)
                ! A.stroke "#000000"
                ! A.strokeWidth "60"
                ! A.transform (rotateAround (-19) c1 c2)
        S.g $ do
          S.path
            ! A.fill "#0093DD"
            ! A.d "m240096,66034,8752-19837-6456-10424-11513,4263-5329,20965c5022,1281,9882,2973,14545,5034z"
          S.path
            ! A.fill "#FFFFFF"
            ! A.d "m228935,47685c5767,1471,11350,3414,16705,5782l-3377,7657c-4934-2181-10076-3971-15390-5326z"
          S.path
            ! A.fill "#FF0000"
            ! A.d "m242806,59894,2256-5113c-5283-2336-10790-4252-16479-5704l-1330,5231c5396,1377,10620,3195,15631,5410l-78,176z"
          S.path
            ! A.fill "#000000"
            ! A.d "m230207,53061c151-95,312-72,474-46,131-49,282-66,446-60,70-38,151-65,243-82,49-38,51-79,7-123-41-50-64-99-67-149-260-151-356-381-455-609-148-39-217-89-233-145-72-7-143-14-214-22-337,37-424-72-544-161-100-33-187-88-243-193-37-47-74-93-111-140-92-117-64-272,75-263,98,11,195,11,285-28,105-47,262-46,381-36,141-8,230-99,367-227-1-55-1-109-2-164-22-59,6-85,84-77,183,6,292,92,366,214,213,37,381,139,494,318,283,1,474,108,497,213,17,77-66,165-194,259,1,19,2,39,2,58,76,66,126,132,152,197,159,61,311,143,453,263,405-47,1088,247,2011,836,599,107,1180,273,1738,514,118,4,236,7,353,11,1001-148,1971-34,2871,654,340,41,645,148,940,270,219,90,442,125,667,146,364,35,733,125,1099,295,411,92,795,221,1033,509,169,204,128,392-87,470-130,274-389,286-777,151-267,49-561-165-828-366-371-119-712-333-1049-561-175-131-352-214-524-251-135-29-256-48-337,0-40,24-35,38,0,67,94,79,160,197,181,339,19,125-1,269,6,422,8,161,105,278,267,378,111,68,243,140,434,167,91,18,117,71,114,140,51,244,98,490,187,711,25,63,73,93,145,146,247,178,119,377-106,420-197,174-367,291-569,337-161,54-227-12-281-91-97-2-146-41-187-104-197-145-29-397,442-289,10-55,50-72,90-71-28-122-44-258,9-385-42-27-78-61-139-81-170-54-331-132-458-251-241-227-618-417-981-608-300-15-523-153-758-270-106-1-212-3-318-4-93-31-169,1-225,68-94,114-203,95-332,80-148-17-298-6-446-8-73,18-145,41-224,42-167-9-330-11-441,82-92,97-184,90-276,54-69-32-119-66-148-102-116-24-191-53-216-88-195-55-250-110-241-165-259-62-136-266,32-273,198-8,379,30,573,57,163,46,364,19,497-101,86-78,118-145,223-203-335-22-582-81-764-196-490-309-882-384-1194-122-83,47-148,66-237,32-75-29-171-29-246-12-177,40-352,18-529-46-259,65-517,79-776,26-219,115-379,128-481,40-96-54-187-109-273-168-139-21-199-56-205-102-178-20-200-85-199-156-74-85-46-150,28-205,132-55,269-75,421,3,91,43,158,85,213,128,101-12,188,0,264,28,56-88,215-92,389-82,87-58,191-99,324-111-4-21-8-42-11-62-175-46-265-173-352-301-269-5-462-118-654-236-158,13-285-39-408-113-100,8-211,12-316-15-208,57-405,53-591,0-131,12-236-1-344-11-123,141-261,166-412,94-83-105-201-174-350-213-113-37-148-86-168-139-138-85-110-169,23-233,100-48,225-57,415,37,62,23,131,39,209,45z"
          S.path
            ! A.fill "#FFFFFF"
            ! A.d "m236801,55071c-13-23-41-81-142-23-313-17-663-13-926-168-274-161-556-329-859-317,90-85,202-143,332-178,174-46,380-49,608-12,320,52,602,114,820,196,210,79,358,177,423,303,2,3,15,18,18,20,84,54,157,109,218,167,46,43,86,88,120,136-99,9-201,2-301-18-110-22-216-59-312-108z"
          S.use
            ! A.xlinkHref "#HaskellSvgIcons-hrCoA-star"
            ! A.transform (S.matrix (-1) 0 0 1 405000 0)
        S.g $ do
          S.path
            ! A.fill "#171796"
            ! A.d "m193069,36886-20,16-10673-6116-8083,9238,5321,20968c4938-1257,10031-2115,15242-2546l-1788-21560z"
          S.path
            ! A.fill "#FF0000"
            ! A.d "m178294,55788c5221-1329,10608-2237,16119-2692l-452-5450c-5816,481-11502,1439-17013,2841l1345,5301z"
          S.path
            ! A.fill "#FF0000"
            ! A.d "m175619,45250c5797-1476,11777-2483,17895-2989l-444-5350c-6418,530-12691,1588-18772,3135l1321,5204z"
        S.g $ do
          S.path
            ! A.fill "#171796"
            ! A.d "m230880,40035-25,9-8100-9258-10650,6104-1796,21560c5212,432,10304,1293,15241,2551l5329-20965z"
          S.path
            ! A.fill "#F7DB17"
            ! A.d "m214206,41363c370-90,735-109,1089,108,155,64,272,146,344,251,164-127,331-246,504-348,243-180,491-339,758-428,382-194,763-309,1145-344,404-69,810-73,1214-49,337,20,663,113,974,292,282,140,563,281,845,421,298,166,596,316,894,442,378,149,803,199,1256,216,222,8,440,8,654-49,173-46,281,64,90,181-1400,859-2497,95-3433-247,343,232,645,472,900,717,356,343,754,691,1458,1012,427,194,892,347,1489,352,202,2,420-6,656-45,119-19,170-8,172,54,2,42-9,126-80,173-361,242-701,306-1080,330-722,46-1494-191-2200-570-565-304-946-674-1396-1006-449-331-837-515-1254-603-411-88-856-78-1231,38,112,22,207,75,265,142,193,114,441,164,800,205,187,22,129,151-159,306-173,223-398,343-697,314-412,273-559,108-697-71-17,113-50,224-99,331,18,58,20,122-6,180,66,102,98,201,76,310,11,58,30,114,92,166,86,78,141,168,152,278,1,73,41,133,99,187,84,69,169,130,253,233,249,90,364,281,405,528,188,61,266,197,303,359,107,45,205,99,261,194,384,1,759,1,1110,38,329,35,597,240,837,506,162,25,326,33,494-5,173-76,356-134,555-151,329-28,659-45,973,30,213,51,379,164,515,318,196,223,498,193,756,83,350-149,641-144,999,13,153-59,306-87,459-71,131-142,270-177,413-181,233-8,402,28,358,327-12,81-60,159-121,187-107,231-311,299-570,277-28,159-93,277-197,353,119,367,5,514-267,509-57,106-142,172-287,151-106,129-231,195-368,217,16,96,57,141,125,244,185,280-93,393-347,397,65,185,73,370,50,555,259,157,294,322,55,485,175,306,107,531-221,695-5,171-22,343-136,439-78,66-190,78-116,202,133,220,104,498-93,506-42-4-80,2-83,69,0,23-20,46-59,69-236,127-457,272-660,439-30,20-60,34-90,7-148,322-424,649-729,978-47,242-184,406-411,491-16,75-64,119-135,138,127,141,175,277,52,411-151,165-350,326-549,377-423,108-688,88-858-74-150-143-91-251,4-296-261,21-314-117-307-301,15-92,46-80,138-77,142,4,270-73,404-117,52-88,120-164,204-228,47-296,234-460,488-557,205-78,401-276,591-532,117-202,235-403,352-605-82-107-104-214-107-321-108-60-183-134-235-218-184-13-260-96-287-211-42,1-88-3-138-18-90,58-181,109-294,104-149,153-303,278-460,384-55,152-164,213-297,232-378,45-604,516-812,708-84,62-136,172-173,304-18,248-61,442-197,446-122-5-141-18-145-31-53-5-106-5-159,7,102,112,118,253,24,377-94,122-229,160-359,169-269,18-487-6-689-88-193-79-216-194-210-306-139-66-167-132-152-197,19-84,96-127,193-100,84-40,168-67,252-83,244-263,495-489,771-594,81-98,174-186,287-259,32-236,187-422,377-595,17-85,45-171,93-256-11-51,3-75,4-123-77-143-123-315-66-458-23-69-30-159-21-228-454,270-594,178-646-41-166,139-321,204-432,4-161,48-323,102-484,38-105,41-211,78-332,86-49,97-115,194-204,291-5,204-76,408-207,612-76,218-170,435-294,653,2,70-8,140-45,211,35,251-49,373-187,435-37,101-92,203-176,304-4,33-7,67-11,100,55,148,64,295-86,443-121,76-250,156-378,219-151,74-291,39-418-7-223-80-206-158-177-234-70,28-150,31-220-3-54-34-88-69-142-104-48-87-65-166,52-228,147-65,247-113,363-232,40-90,91-158,163-176,70-164,156-275,273-305,86-203,178-427,287-621,38-59,66-120,48-187-2-55,2-107,48-138,26-22,72-42,14-73-53-181-20-354,69-487,118-178,250-608,125-819-23-118-46-253-31-364-43-2-75,4-118-26-96-59-176-3-249,104-53,134-106,252-159,252-50,346-220,615-397,684-41,159-67,318-45,477,18,173,0,291-80,311-88,22-170,73-221,214-14,39-30,86-31,142,122,126,85,283-32,399-264,260-592,222-939,120-251-99-312-204-287-311-356-30-285-303,10-385,317-89,574-292,785-582,19-344,98-578,283-615,18-211,84-401,173-581,93-163,150-342,117-560-197-123-205-250-24-380,60-35,53-71-21-107-120-12-105-127-97-235-5-56-34-85-87-86-266-39-200-148-86-266,48-54,80-134,30-166-41-26-69-117-78-197-163-123-93-249,0-370-92-78-135-192-148-325-303-13-416-167-252-391,69-95,158-186,266-273,70-113,137-226,104-339-87-221,191-388,429-560-33-58-50-115-52-173-134-129-100-249,48-363-33-59-49-118-55-176-333,66-331-133-176-453-193-111-139-308,211-608,5-69,18-122,38-159-166,4-303,53-422,128-133,87-265,76-398,21-41-66-104-122-176-173-91-80-112-170-93-266-392,22-467-268-232-439,131-104,227-213,263-332,106-269,331-452,550-640,0-77,17-154,41-232-97-65-199-112-311-121-40-100-115-208-242-269-73-44-97-85-52-184-208-186-156-299-103-406z"
          S.g 
            ! A.fill "#FF0000"
            $ do
              S.path ! A.d "m220904,54095c-44,46-81,97-117,157-171,57-322,142-506,134,0,119,39,171,158,172,227-114,278-135,298-119,28,24-32,187-220,319-29,18-28,29-11,59,159,249,576,160,800,101,160-42,449-232,529-392,31-73-39-169-109-247-177,27-238-55-210-112-187-66-395-80-612-72z"
              S.path ! A.d "m218719,53544c-16,2-33,4-49,7-87,94,152,59,279,137,58,35,83,104,60,200-117,279-770,189-987,74-101-53-105-114-101-201,45,0,91-3,137-10,78-11,155-34,231-77,21-12,43-25,19-67-24-43-46-31-67-19-64,36-130,56-196,65-68,10-138,10-205,7h-17c-38-22-67-48-51-71,16-22,79,2,91,6,101-47,189-77,298-98,15-15,29-31,44-46,199,17,389,47,515,93z"
              S.path ! A.d "m215700,53373c-40,24-54,58-83,121-114,115-223,184-369,250-121,55-4,108,81,166,77,57,178-67,241-161,69-104,139-73,94,8-50,89-86,217-91,284-26,72,248,127,295,129,167,8,377-155,508-238,109-111,92-208,44-343l1-9c-70,2-136-6-201-20-79-18-157-45-236-78-10-4-20-8-12-29,5-13,11-16,18-15l-288-66z"
              S.path ! A.d "m214511,52080c-130,106-275,190-444,246-64,21-219,59-234,140-2,29,104,92,172,55,188-180,282-80,66,104-17,35-3,74,34,107,195,175,678,232,898,93,163-102,248-214,106-369,1-35,5-69,11-104l-269-27-165-96-175-149z"
              S.path ! A.d "m216869,42243c46-2,92-4,137,1,85,10,166,47,251,57,284-107,519-166,722-157,237-69,483-98,729-92-3-2-6-5-9-8-29-29-15-44,0-58,133-135,164-259,121-371-44-116-164-225-331-325-178,20-349-28-538-7-118,13-234,39-348,77,95,34,178,90,246,170,84,99,144,234,176,404,4,20,7,40-33,48s-44-13-48-33c-29-155-83-277-158-366-79-113-260-157-317-180-189,19-375,40-537,82-122,31-229,74-311,138,122-26,249-21,359,34,105,52,194,150,250,309,7,19,13,39-26,52s-46-6-52-26c-47-137-121-219-208-262-173-86-530-11-681,101-88,66-176,151-263,250-9,11-19,21-31,22,324,22,650,39,902,140zm-961-183c-7-18,5-31,16-44,91-103,183-194,278-264,92-68,187-117,285-140,100-111,248-178,420-222,167-43,358-65,551-84-57-115-130-184-214-221-90-40-194-46-305-35-233,80-440,205-639,346,18,0,36,0,53,1,59,4,112-5,161,14,20,7,39,14,25,53-17,47-146,18-191,15-51-3-107,1-169,16-10,2-19,5-28,2-209,129-367,260-536,403,128,45,228,98,293,160z"
              S.path ! A.d "m224970,43966c26-4,186-46,103,15-588,385-1334,384-2037,203,109-49,198-108,243-182,34-55,40-118,24-187,224,73,451,125,685,155,1,36-9,72-37,107-37,46-100,91-203,136-19,8-38,16-21,54,16,38,35,29,54,21,116-51,191-105,235-160,39-49,55-98,55-149,289,31,588,27,900-14z"
              S.path ! A.d "m222974,44169c-304-83-598-199-867-330,154-11,290-29,388-68,111-44,175-112,171-221,178,90,356,168,537,232,32,71,34,129,4,178-36,60-115,110-213,153-19,8-38,17-21,54v1z"
              S.path ! A.d "m222016,43793c-90-46-176-94-259-143-199-118-386-253-569-394,112,9,206,3,282-18,65-18,117-48,154-89,38-42,61-94,68-158,3-28,3-58-1-90,179,153,367,295,570,419,106,65,213,126,319,183-1,7,0,14,1,22,13,82-33,134-117,167-98,39-244,55-411,65-19,1-37,2-39,34z"
              S.path ! A.d "m221119,43202c-260-203-514-415-787-598,151,12,286,0,388-61,99-61,164-167,175-340,163,126,320,259,469,402,75,71,150,141,227,210,0,1,1,2,1,4,18,64,24,119,19,165-5,45-21,82-47,111-27,30-66,52-115,65-73,21-168,25-285,12-19-2-39-4-44,31z"
              S.path ! A.d "m220263,42558c-77-49-155-97-236-141-389-214-835-346-1282-363,4-3,7-7,11-10,159-162,194-315,140-458-42-111-139-214-273-307,150-8,289,1,445,23,220,31,505,105,765,210,64,140,82,263,54,367-29,109-111,200-243,275-18,10-36,20-16,56s38,26,56,15c153-86,247-194,282-326,27-102,19-216-26-343,176,79,335,173,446,276,145,100,288,201,428,307,1,178-51,279-137,332-91,55-221,62-369,47-20-2-41-4-45,37v2z"
              S.path ! A.d "m217116,40966c287-125,578-205,875-254,136,54,226,120,277,198,49,77,61,167,44,271-126-12-251-11-373,2-137,15-271,46-403,93-66-139-155-223-259-269-51-23-105-36-161-42z"
              S.path ! A.d "m218139,40691c282-37,569-46,861-39,96,39,167,96,211,171,48,84,65,194,45,331-3,20-6,41,35,46,41,6,44-15,46-35,22-156,2-283-55-383-28-48-64-89-108-124,26,1,52,2,78,4,336,18,597,114,889,259,2,2,5,5,7,8,62,65,83,132,73,201-11,73-55,152-125,233-13,16-27,31,5,58,31,27,45,11,58-5,79-93,131-185,144-275,7-51,3-99-15-147,246,122,496,239,739,367,5,3,10,5,15,8,0,5,2,11,4,16,20,69,12,128-22,179-37,53-104,99-201,135-19,7-38,14-24,53,14,38,34,31,53,24,114-43,194-98,240-166,39-57,54-120,45-191,161,87,322,177,487,256l1,1c29,58,34,110,11,158-24,51-80,99-169,143-18,9-37,18-19,55s37,28,55,19c107-53,175-114,207-182,22-47,28-95,18-146,57,25,115,49,174,71,159,59,351,110,557,148,1,2,3,4,5,6,38,53,51,104,42,153-9,51-40,103-90,155-14,15-28,29,1,58,5,5,9,8,13,11-625-64-1181-363-1763-588-69-27-139-53-208-80-215-81-432-191-648-279-7-7-18-11-28-14-15-5-29-10-44-14-9-4-19-7-28-11,1,1,3,2,4,3-197-63-396-112-598-140-224-31-452-37-686-7-13-2-25-4-38-6,20-123,4-231-57-325-43-67-108-126-198-175z"
              S.path ! A.d "m222565,41963c163,27,332,46,499,57,2,4,5,7,7,11,27,37,35,73,23,108-14,40-52,82-114,125-17,12-34,24-10,57-111,14-224,20-339,18-58-1-115-4-173-9,6-3,12-9,17-14,61-64,100-130,111-199,8-51,2-102-21-153z"
              S.path ! A.d "m223164,42025c251,11,493,1,699-33-220,159-501,266-804,316,59-46,97-94,114-143,16-47,13-94-9-140z"
        S.g $ do
          S.path 
            ! A.fill "#0093DD"
            ! A.d "m212105,36890-23,13-9517-7794-9497,7778,1788,21560c2543-210,5113-322,7709-322,2608,0,5190,113,7744,325l1795-21560z"
          S.g 
            ! A.id_ "HaskellSvgIcons-hrCoA-lion"
            $ do
              S.path
                ! A.fill "#000000"
                ! A.d "m202545,46585c-18-2-44,10-69,45-186,250-359,469-545,720-195,61-242,180-167,348-261-26-291,193-302,432-250-379-522-482-814-307-11-230-187-338-439-392-180-10-319-65-436-145-60-42-110-64-170-106-126-88-226-5-172,74,267,434,535,868,802,1302-14,80,6,151,88,204,47,133,93,265,140,397-11,38-21,75-32,113-221-105-443-118-664-133-170-8-287-50-361-137-54-63-91-26-92,82-3,534,162,1014,599,1492-231,4-462,11-694,21-79,6-95,39-73,104,126,304,339,579,822,766-208,112-327,285-357,520-9,224-75,382-212,455-60,32-81,65-24,106,253,185,565,193,895,112-157,270-226,553-198,850,208,56,412,15,614-52-29,61-44,175-52,309-7,115-41,229-104,343-32,33-65,84,4,102,336,91,648,52,915-47,0,243,2,487,76,727,18,58,70,102,125,26,155-214,322-396,527-517,31,90,75,168,156,215,96,55,147,170,153,343,0,30-2,60,35,90,149,7,514-380,589-597,206,121,284,246,439,461,55,76,99,29,128-25,62-243,67-481,66-724,267,99,579,138,915,47,69-19,36-70,4-102-62-114-105-250-113-365-9-133-14-226-43-287,202,68,405,108,614,52,29-297-53-579-211-850,330,80,655,73,908-112,57-41,35-74-24-106-136-73-203-231-212-455-30-235-149-409-357-520,483-187,696-463,822-766,22-66,6-99-73-104-231-10-480-24-711-27,437-478,606-961,604-1495-1-108-38-146-92-82-74,87-179,137-348,146-222,15-435,24-656,128-11-38-21-75-32-113,46-132,106-260,153-393,82-53,102-123,88-204,267-434,513-868,781-1302,54-79-46-162-171-74-60,42-110,64-170,106-117,80-257,134-437,145-251,54-417,167-428,397-293-175-564-73-814,307-11-239-41-457-302-432,75-168,17-291-178-352-186-250-458-470-644-720-31-35-51-47-69-45z"
              S.g
                ! A.fill "#F7DB17"
                $ do
                  S.path ! A.d "m205075,47978c-51-26-124,17-162,95s-33,170,19,196c40,20,84-6,119-56l22-36c2-3,4-6,5-9,38-78,49-163-2-188z"
                  S.path ! A.d "m200067,47978c52-26,124,17,162,95s39,165-13,191-103-24-141-102-60-158-9-184z"
                  S.path ! A.d "m204606,48883c-32,0-59,27-59,59s26,59,59,59,59-26,59-59c0-32-26-59-59-59z"
                  S.path ! A.d "m200574,48883c-32,0-59,26-59,59,0,32,26,59,59,59s59-26,59-59-26-59-59-59z"
                  S.path ! A.d "m204868,48579c-754-91-1506-133-2260-133s-1509,41-2269,115c-26,8-21,90,14,86,756-73,1507-113,2256-113,743,0,1485,40,2228,129,39,4,54-80,32-84z"
                  S.path ! A.d "m200319,48495c768-75,1530-117,2289-116,754,0,1507,42,2261,133l111-184c-32,10-62,9-90-5-76-38-92-161-36-274,56-114,164-175,240-138,39,19,62,62,68,114l446-739c-204,130-328,214-581,252-281,41-409,139-368,307,38,156-57,133-201,54-314-171-541,71-652,353-73,186-159,181-168-13-4-70,0-131-7-200-21-223-89-286-216-224-161,78-175,25-137-58,28-60,86-128,66-221-9-67-66-92-151-98-182-244-467-483-649-727-182,244-374,483-556,727-86,5-142,30-152,98-20,93,52,157,80,217,38,82,23,135-137,57-127-61-186-3-207,220-7,69-10,139-13,209-9,194-95,199-168,13-111-282-352-524-667-353-145,79-203,102-182-54,23-172-107-266-388-307-253-37-377-122-581-252l419,682c12-25,29-45,53-57,76-38,184,24,240,138,56,113,40,237-36,274-10,5-21,8-32,10l100,163z"
                  S.path ! A.d "m204708,49406c-7,3-7,4-24,11-46,19-80,66-134,124-57,60-128,125-211,188-12,10-25,19-44-6s-7-35,6-44c80-62,149-124,204-182,30-32,56-63,77-92-95-11-190-21-284-30-79,24-157,55-222,95-59,35-107,77-137,125-8,14-16,27-44,11-27-16-19-30-11-44,35-58,91-107,158-147,33-20,69-38,106-54-107-9-214-18-321-25-22,13-42,29-61,47-20,19-39,42-56,67-9,13-18,26-44,8s-18-31-8-44c19-29,41-54,64-77,3-3,6-6,9-9-80-5-161-10-241-14-2,2-5,5-8,7-21,18-40,38-55,59s-28,43-38,67c-6,15-12,29-41,18-29-12-23-26-17-41,12-29,27-55,45-81,8-11,18-22,27-33-115-5-230-9-344-12-4,5-9,8-14,11-25,15-47,32-66,51s-35,40-48,63c-8,14-16,28-43,12-28-16-20-29-12-43,16-28,35-54,59-77,7-7,14-13,21-19-122-2-244-4-365-4-120,0-240,1-360,3,8,7,15,13,22,20,23,23,42,49,59,77,8,14,16,27-12,43s-35,2-44-12c-13-23-29-44-48-63s-41-36-66-51c-6-3-12-7-15-12-115,2-230,6-345,11,11,11,20,23,29,35,19,25,33,52,45,81,6,15,12,29-17,41s-35-3-41-18c-9-24-22-46-38-67-15-21-34-41-55-59-4-3-7-6-10-10-81,4-162,8-243,13,4,4,9,8,13,12,24,23,45,48,64,77,9,13,18,26-8,44s-35,5-44-8c-18-26-36-48-56-67s-41-35-64-49c-1-1-3-2-5-3-110,7-220,14-330,23,43,18,85,38,122,61,67,40,124,89,158,147,8,14,16,27-11,44-27,16-35,3-44-11-29-48-78-90-137-125-72-44-159-77-246-102h-2c-90,7-179,15-268,24,22,33,51,68,86,106,55,58,124,120,204,182,13,9,25,19,6,44s-32,15-44,6c-83-64-155-128-211-188-37-38-99-111-135-140-196-90-354-127-575-147-153-14-318-9-458-79,36,85,75,164,126,229,53,68,120,121,209,147,8,2,21,16,22,25,28,157,84,286,169,386,52,60,114,110,188,149-75-81-132-166-172-251-67-142-90-286-77-420,1-16,3-32,34-29,32,3,30,19,29,35-11,123,9,256,72,387,56,118,159,237,291,346,24,19,0,63-29,55-154-44-290-123-383-231-89-104-149-237-180-397-94-32-165-90-222-164-47-60-85-131-118-205,28,428,182,801,456,1137,61,75,165,182,255,216,92,35,95,100-20,101-34,1-69,1-105,1,84,31,164,66,233,105,127,73,217,162,224,273,1,16,2,32-29,34-32,2-33-14-34-29-6-86-82-160-192-223-113-65-259-117-402-160-154,0-312-1-459,3,39,28,80,57,131,84,82,44,188,86,343,122,89,21,166,52,233,91,71,42,130,93,177,150,10,12,20,25-5,45s-34,8-45-5c-42-52-95-98-159-135-61-36-133-64-216-84-161-38-272-81-358-128-75-40-131-82-184-123,180,393,450,573,835,689,23,7,43,13,61,19,3,1,6,1,9,2,86,21,175,40,266,55,92,15,166,28,261,37,16,1,32,3,29,34-3,32-19,30-34,29-99-9-174-22-266-38-58-10-115-21-171-33-26,6-64,9-107,12-232,14-420,225-435,494,0,5,0,11-1,16,88-80,179-157,273-212,117-68,239-103,364-69,15,4,31,8,22,39-8,31-23,27-39,22-106-28-212,3-316,63-108,63-213,158-315,253-24,147-82,285-205,377,61,34,104,65,163,45,86-39,172-78,261-108,91-31,184-52,282-57,16-1,32-1,33,31s-14,32-31,33c-91,4-179,24-264,53-75,26-149,58-222,91,221,47,460-1,667-79,60-22,105-42,133-41,51-30,112-53,172-79,66-28,132-51,182-57,16-2,32-4,35,28,4,32-12,33-28,35-112,13-127,21-222,79,0,21-66,57-126,96-36,24-70,52-87,67-95,86-144,181-188,287-29,70-52,145-68,224,55-108,121-211,201-303,94-108,208-201,345-265,14-7,29-13,42,15,13,29-1,35-15,42-129,60-236,147-324,250-90,103-161,222-219,345-31,64-8,1-42,86,110-122,212-224,323-307,132-100,283-157,418-133,15,3,31,6,26,37s-21,28-37,26c-116-21-250,32-369,121-121,92-244,223-366,361,184,26,366-26,542-85,91-30,183-135,239-152,19-24,38-46,57-67,33-37,67-71,102-100,12-10,24-20,45,4s8,34-4,45c-33,28-65,60-96,94-32,35-62,73-92,113-6,8-13,17-24,16-60,70-151,162-172,240-57,210-25,370-122,576,71-38,128-81,175-134,53-60,94-135,128-230,37-104,95-195,167-270,75-77,165-136,261-172,15-5,30-11,41,19s-4,35-19,41c-87,32-169,86-238,157-66,68-119,151-153,247-37,102-81,183-141,250-44,50-95,91-156,127,52-3,78-10,121-7,79-6,211-66,279-119,66-51,116-120,154-206,6-15,13-29,42-16s23,27,16,42c-42,96-99,174-173,231-56,43-121,75-196,93,161-5,311-42,467-100,65-24,87-168,127-208,32-58,66-112,105-158,47-56,101-101,164-127,15-6,29-12,41,18,12,29-3,35-17,41-52,21-98,60-139,108-36,42-68,93-98,147,10,73-51,228-53,305-7,205-2,409,53,612,53-71,107-134,162-192,0-5,0-10,1-15,18-106,33-219,40-332,7-112,7-223-6-329-2-16-4-32,27-35,32-4,34,12,35,28,14,111,14,226,7,340-6,90-16,180-30,269,54-51,53-51,77-103,37-80,59-159,67-237,9-80,5-157-13-230-4-15-7-31,24-38s35,8,38,24c19,80,25,165,14,252-8,65-24,132-49,199,56-42,114-82,178-122-4-75-5-153-3-227,2-68,7-134,18-190,4-20,7-40,47-33s37,27,33,48c-9,50-14,111-16,177-2,78,0,162,4,243,5,82,49,185,125,230,103,62,158,163,186,274,16-145,17-280,3-400-17-143-55-267-114-368-8-14-16-27,12-44,27-16,35-2,43,12,63,110,104,241,122,393,17,146,13,310-13,488,102-82,381-258,352-594-7-27-16-52-28-75-7-14-14-28,14-42s35,0,42,14c17,33,30,69,39,110,5,24,8,49,11,76,13-7,45-43,51-39,24,16,58,38,80,54-21-60-35-120-42-178-10-87-5-172,14-252,4-15,7-31,38-24s27,23,24,38c-18,73-22,151-13,230,9,77,31,157,67,237,4,8,8,16,5,25,24,21,47,42,70,65-13-84-22-170-28-255-8-115-7-230,7-341,2-16,4-32,35-28s29,20,27,35c-13,106-13,217-6,329,7,113,22,225,40,332,1,2,1,5,1,7,54,59,95,120,152,196,55-203,73-407,66-612-2-76-69-227-65-302-30-55-63-107-100-151-41-49-87-87-139-108-15-6-29-12-18-41,12-29,27-24,41-18,62,26,117,71,164,127,38,45,72,98,103,154,57,7,78,179,143,212,154,57,298,94,453,100-75-19-140-50-195-93-74-57-131-135-173-231-6-15-13-29,16-42s35,2,42,16c38,86,88,156,154,206,85,66,289,124,400,127-61-37-113-78-157-128-59-67-104-148-141-250-34-95-87-179-153-247-68-71-150-124-238-157-15-6-29-11-19-41,11-29,26-24,41-19,96,36,186,94,261,172,72,74,130,166,167,270,34,95,75,169,128,230,47,54,105,98,177,135-98-207-66-367-122-577-35-129-232-277-193-320,45-51,133,88,248,127,175,59,357,111,540,85-122-138-244-269-366-361-119-90-237-140-352-120-16,3-31,6-37-26-5-31,10-34,26-37,135-24,269,32,401,132,111,84,201,175,311,298-18-47,0-14-30-77-59-123-130-241-220-345-89-102-196-189-324-250-14-7-28-13-15-42,13-28,28-22,42-15,137,65,251,157,345,265,81,93,147,198,203,307-15-81-39-157-68-227-44-106-93-201-188-287-62-56-209-140-208-179-29-15-33-11-63-24-61-26-121-46-164-52-16-2-32-4-28-35,4-32,19-30,35-28,50,6,115,28,182,56,33,14,66,43,98,60,53,4,139,47,208,74,206,78,446,126,666,79-73-33-147-65-223-91-85-29-172-49-264-53-16-1-32-1-31-33s17-31,33-31c98,4,191,26,282,57,89,30,175,69,261,108,59,27,101-7,163-45-123-92-181-230-205-376l-2-2c-102-95-207-190-315-253-104-60-210-91-316-63-15,4-31,8-39-22-8-31,7-35,22-39,125-33,247,1,364,69,94,55,186,132,274,213,0-6-1-11-1-17-15-270-203-480-435-494-78-5-189,21-186-32,4-59,97-44,234-86,385-116,655-296,836-690-54,41-110,83-186,124-86,47-198,91-358,128-82,19-154,48-216,84-64,38-117,84-159,135-10,12-20,25-45,5s-14-32-5-45c47-57,106-108,177-150,67-39,145-70,233-91,155-36,261-78,343-122,51-27,92-55,131-84-148-4-305-3-459-3-143,44-289,96-402,160-110,63-186,136-192,223-1,16-2,32-34,29-32-2-31-18-29-34,8-111,97-200,224-273,69-39,149-74,233-105-35,0-70,0-104-1-116-2-112-66-20-101,90-34,190-141,251-216,271-334,412-714,456-1130-33,72-69,140-115,198-57,73-128,131-222,164-31,160-91,293-180,397-92,108-216,185-369,230-29,8-52-35-29-55,132-109,221-226,278-344,62-131,83-264,72-387-1-16-3-32,29-35,31-3,33,13,34,29,12,134-10,278-78,420-40,85-97,170-172,251,73-39,136-89,187-149,85-100,141-229,170-386,1-8,14-22,22-25,89-27,155-79,209-147,51-65,90-143,126-228-140,69-304,64-457,78-213,19-369,68-554,152z"
                  S.path ! A.d "m204649,49231c-680-88-1359-113-2041-114-684,0-1369,40-2058,112-20,6-15,33-14,46,2,28,37,35,121,27,643-60,1285-93,1932-93,674,0,1351,21,2038,102,33,9,77-85,22-81z"
                  S.path
                    ! A.fillRule "evenodd" 
                    ! A.d "m200570,49160c683-71,1362-110,2038-110,675,0,1349,40,2025,127l31-127c-17,9-37,15-58,15-67,0-123-55-123-123s55-123,123-123c51,0,94,31,113,75l60-170c-724-84-1446-122-2171-122-729,0-1459,38-2193,107l58,164c22-32,59-54,101-54,68,0,123,55,123,123s-55,123-123,123c-12,0-25-2-36-6l33,94-2,7zm3067-416c-68,0-123,55-123,123s55,123,123,123,123-55,123-123-55-123-123-123zm0,64c-33,0-59,27-59,59s26,59,59,59c32,0,59-27,59-59s-26-59-59-59zm-1082-91c-67,0-123,55-123,123s55,123,123,123,123-55,123-123-55-123-123-123zm0,64c-32,0-59,26-59,59s26,59,59,59,59-26,59-59c0-32-26-59-59-59zm-1064-40c-68,0-123,55-123,123s55,123,123,123c67,0,123-55,123-123s-55-123-123-123zm0,64c-33,0-59,26-59,59s26,59,59,59c32,0,59-26,59-59,0-32-26-59-59-59z"
              S.g
                ! A.fill "#000000"
                $ do
                  S.path ! A.d "m202601,47974c-14-68-49-129-100-175-51-47-116-78-187-88-33-4-39-58-7-68,60-20,114-67,157-133,45-69,79-157,95-256,5-34,64-35,69-1,15,84,51,153,97,208,55,66,125,112,193,138,31,12,25,63-8,68-59,9-105,42-141,87-50,62-81,145-100,221-8,33-62,31-69-2zm33-118c20-52,47-103,81-146,28-34,60-64,99-84-51-30-100-70-143-120-28-34-53-73-73-116-19,59-45,112-75,158-31,47-67,86-108,116,50,19,95,47,134,82,34,31,63,68,85,110z"
                  S.path ! A.d "m203433,52971-515,206c-17,7-35,14-48-21-14-34,4-41,21-48l515-206c17-7,35-14,48,21,14,34-4,41-21,48zm59-326-604,328c-16,9-33,18-51-15s-1-42,15-51l604-328c16-9,33-18,51,15s1,42-15,51zm-1826-65,604,328c16,9,33,18,15,51s-34,24-51,15l-604-328c-16-9-33-18-15-51s34-24,51-15zm51,322,515,206c18,7,35,14,21,48-14,35-31,28-49,21l-515-206c-17-7-34-14-21-48,14-35,31-28,48-21zm224,434c137,33,261,48,358,31,88-16,155-60,191-146v-493c-107-1-212-15-303-41-109-31-170-98-201-178-41-107-27-235-4-329,5-18,9-36,45-27s32,27,27,45c-20,82-33,194,1,284,23,60,69,110,152,133,91,25,198,38,307,38,107,0,214-13,304-40,82-24,148-69,192-123s65-117,57-176c-5-36-24-62-49-80-34-24-82-35-128-37-47-2-94,7-142,16-25,5-50,9-77,13-19,2-37,5-42-32s14-40,32-42c23-3,48-8,73-12,52-10,105-20,159-18,60,2,121,18,168,51,42,29,72,72,80,131,11,80-16,163-73,233-53,65-131,119-229,147-83,24-178,38-274,42v483c3,5,3,11,2,16,37,82,102,125,188,141,97,18,221,2,358-31,18-5,36-9,45,27,8,37-9,41-28,45-146,35-279,51-388,32-92-17-165-58-215-132-49,74-124,115-215,132-109,20-242,4-388-32-18-4-37-8-28-45,8-36,27-32,45-27zm356,210,402-9c19,0,38-1,38,37,1,38-18,38-37,38l-402,9c-19,0-37,1-38-37s18-38,37-38z"
                  S.path ! A.d "m202890,50464c151-125,293-227,423-297,133-72,254-111,359-106,19,1,37,1,36,39-1,37-20,37-39,36-92-4-200,32-322,97-125,67-263,166-410,289-14,12-29,24-53-5s-9-41,5-53zm-605,56c-141-130-298-240-445-314-139-71-268-108-363-100-19,2-37,4-40-34-4-37,15-39,34-40,110-10,252,31,404,107,152,77,315,191,461,325,14,13,28,25,2,53-25,27-39,15-53,2zm-213,1004c37-83,83-155,136-219,53-63,112-119,174-170,14-12,29-24,52,5,24,29,9,41-5,53-59,48-114,101-164,160-49,59-91,125-125,201-8,17-15,34-49,19s-27-32-19-49zm371-1734c49,66,88,139,114,223,26,82,40,175,39,279,5,80,6,165-7,249-13,86-42,170-97,246-43,60-101,97-165,113-53,13-109,10-164-7,29,100,51,208,6,308-8,18-33,27-51,18-43-22-86-43-128-62s-84-36-127-51l-1-1c-95-37-173-73-236-112-65-39-115-80-150-124l1,2c-44-49-72-106-88-170-14-55-20-114-22-174-72-39-138-78-194-116-64-43-118-87-161-131-13-14-26-27,1-53s40-12,53,1c39,40,89,80,150,121,60,40,128,81,204,121,124,13,247,51,370,109,106,50,211,115,317,192,13,7,19,16,27,20,8,6,16,13,25,19,51,22,104,28,152,16,47-11,90-39,122-84,48-66,72-139,84-214,12-77,11-157,6-234v-2c1-97-12-183-35-258-24-76-58-142-102-201-11-15-22-30,7-52s41-7,52,7zm-375,1047c-104-77-207-141-311-190-105-49-210-83-314-98,2,48,8,93,18,135,13,52,35,99,71,138l1,1c30,37,73,72,130,107,60,36,134,71,225,106l-1-1c45,16,89,34,133,54,31,14,61,28,93,44,19-83-10-179-37-267-2-8-5-15-9-29zm776-1003c-44,59-79,125-102,201-24,76-36,161-35,258v2c-5,77-6,158,6,234,12,75,37,148,84,214,32,45,75,72,122,84,48,12,101,6,152-16,8-6,17-13,25-19,6-4,13-12,27-20,105-77,211-143,317-192,123-58,246-95,370-109,75-40,144-80,204-121s111-81,149-121c13-13,26-27,53-1s14,39,0,53c-43,44-97,88-161,131-57,38-122,77-194,116-2,61-8,119-22,174-16,63-44,121-88,170l1-2c-35,44-85,85-150,124-63,38-141,75-237,112l-1,1c-43,15-85,32-127,51-43,19-85,40-128,62-18,9-43,0-51-18-45-100-23-208,6-308-55,18-111,20-164,7-64-15-122-53-165-113-55-76-84-160-97-246-13-85-12-169-7-249-1-104,13-196,39-279,26-84,65-158,114-223,11-15,22-30,52-7,30,22,19,37,7,52zm940,715c-105,15-209,49-314,98-104,49-207,113-311,190-4,13-6,21-8,29-27,88-56,184-37,267,31-15,62-30,93-44,44-20,87-38,133-54l-1,1c91-35,165-70,225-106,58-34,100-70,131-107,0,0,1-1,1-1,35-39,57-86,71-138,11-42,16-87,19-135z"
                  S.path ! A.d "m203459,50602c-119,0-216,97-216,216s97,217,216,217,216-97,216-217c0-119-97-216-216-216zm0,69c-81,0-147,66-147,147s66,147,147,147,147-66,147-147-66-147-147-147zm0,60c-48,0-87,39-87,87s39,87,87,87,87-39,87-87-39-87-87-87zm-1697-124c119,0,217,97,217,216s-97,217-217,217c-119,0-216-97-216-217,0-119,97-216,216-216zm0,69c81,0,147,66,147,147s-66,147-147,147-147-66-147-147,66-147,147-147zm0,60c48,0,87,39,87,87s-39,87-87,87-87-39-87-87,39-87,87-87z"
          S.use
            ! A.xlinkHref "#HaskellSvgIcons-hrCoA-lion"
            ! A.transform (S.matrix 1 (-0.038) ( 0.038) 1 (-5965) ( -1993))
          S.use
            ! A.xlinkHref "#HaskellSvgIcons-hrCoA-lion"
            ! A.transform (S.matrix 1 ( 0.038) (-0.038) 1 ( 6277) (-17381))



{- |
Flag of Liechtenstein coat of arms.
Drawn for a @viewbox 0 0 1000 600@
-}
liCoA :: Svg
liCoA =
  S.g
    ! A.fill "#FFD83D"
    ! A.stroke "#000000"
    ! A.strokeWidth "2"
    ! A.strokeLinecap  "round"
    ! A.strokeLinejoin "round"
    $ do
      S.g
        ! A.id_ "HaskellSvgIcons-liCoA-halfCrown"
        $ do
          S.path 
            ! A.stroke "none" 
            ! A.d "M 216.37706,122.2886 L 214.53882,184.7886 L 151.1197,184.7886 C 143.31716,169.62032 136.87338,156.73735 136.87338,139.29228 C 136.87338,124.69269 148.35647,113.09742 164.90647,113.09742 C 182.42619,113.09742 201.67512,119.001 216.37706,122.2886 z"
          S.g
            ! A.strokeWidth "1.5"
            $ do
              S.path ! A.d "M 144.45611,125.16084 V 161.23621"
              S.path ! A.d "M 149.54956,121.47933 V 169.51333"
              S.path ! A.d "M 154.64301,118.95176 V 176.17693"
              S.path ! A.d "M 159.73645,117.77081 V 162.65201"
              S.path ! A.d "M 164.82989,117.54815 V 162.87466"
              S.path ! A.d "M 169.92335,115.96463 V 162.84973"
              S.path ! A.d "M 175.01679,115.96463 V 162.84973"
              S.path ! A.d "M 180.11024,116.42419 V 163.30929"
              S.path ! A.d "M 185.20367,116.88375 V 163.76885"
              S.path ! A.d "M 190.29712,119.87088 V 166.75598"
              S.path ! A.d "M 195.39057,120.33044 V 173.1898"
              S.path ! A.d "M 200.48402,120.33044 V 167.21554"
              S.path ! A.d "M 205.57747,120.33044 V 167.21554"
              S.path ! A.fill "#000000" ! A.d "M 176.39544,117.92279 C 187.15891,119.69824 210.80151,130.75993 208.105,145.72611 C 204.28366,166.93537 191.89725,158.42373 175.47632,155.37684 L 163.06823,159.51287 C 158.62839,164.04466 152.09048,168.19641 147.67301,162.72978 L 140.32007,162.72978 L 140.32007,191.4522 L 221.66198,191.4522 L 221.66198,122.05882 z"
          S.circle ! A.r "4.94" ! A.cx "212.8" ! A.cy "112.9"
          S.circle ! A.r "4.94" ! A.cx "201.7" ! A.cy "110.3"
          S.circle ! A.r "4.94" ! A.cx "190.4" ! A.cy "107.4"
          S.circle ! A.r "4.94" ! A.cx "179.1" ! A.cy "105.5"
          S.circle ! A.r "4.94" ! A.cx "167.8" ! A.cy "104.4"
          S.circle ! A.r "4.94" ! A.cx "156.7" ! A.cy "105.1"
          S.circle ! A.r "4.94" ! A.cx "146.1" ! A.cy "108.7"
          S.circle ! A.r "4.94" ! A.cx "137.2" ! A.cy "115.2"
          S.circle ! A.r "4.94" ! A.cx "130.9" ! A.cy "124.4"
          S.circle ! A.r "4.94" ! A.cx "127.9" ! A.cy "135.1"
          S.circle ! A.r "4.94" ! A.cx "128.0" ! A.cy "146.3"
          S.circle ! A.r "4.94" ! A.cx "130.1" ! A.cy "157.2"
          S.path ! A.d "M 214.99838,119.53125 L 214.53882,125.96507 C 202.24782,124.08194 184.82391,117.23346 168.58294,117.23346 C 153.57656,117.23346 141.92853,123.23616 141.92853,138.37316 C 141.92853,153.29163 148.24631,166.85838 156.63441,180.65257 L 147.90279,184.7886 C 140.10025,169.62032 133.65647,156.73735 133.65647,139.29228 C 133.65647,124.69269 145.13956,110.34007 164.90647,110.34007 C 182.42619,110.34007 200.29644,116.24365 214.99838,119.53125 z"
      S.use
        ! A.xlinkHref "#HaskellSvgIcons-liCoA-halfCrown"
        ! A.transform (translate 444 0 <> S.scale (-1) 1)
      S.path 
        ! A.d "M 221.96875,53.125 L 216.8125,62.78125 L 221.96875,72.40625 L 227.125,62.78125 L 221.96875,53.125 z M 221.96875,77.5 L 216.8125,87.125 L 221.96875,96.78125 L 227.125,87.125 L 221.96875,77.5 z"
      S.path 
        ! A.d "M 203.58731,74.953125 L 211.71883,80.109375 L 219.82403,74.953125 L 211.71883,69.796875 L 203.58731,74.953125 z M 224.11347,74.953125 L 232.21867,80.109375 L 240.35019,74.953125 L 232.21867,69.796875 L 224.11347,74.953125 z"
      S.circle 
        ! A.cx "221.9"
        ! A.cy " 75.06"
        ! A.r  "  3.9"
      S.circle
        ! A.cx "221.9"
        ! A.cy "100"
        ! A.r  " 10.4"
      S.path
        ! A.fill "none"
        ! A.strokeWidth "1.5"
        ! A.d "M 219.34375,89.875 C 219.34375,92.989438 219.32163,94.799139 219.3125,96.5 C 216.79207,96.611865 214.30676,96.876712 211.875,97.28125 M 232.0625,97.28125 C 229.63074,96.876712 227.14543,96.611865 224.625,96.5 C 224.625,94.801655 224.625,92.997132 224.625,89.875 M 211.84375,102.5625 C 215.13846,102.01215 218.51788,101.71875 221.96875,101.71875 C 225.41962,101.71875 228.79904,102.01215 232.09375,102.5625"
      S.path
        ! A.d "M 211.75,117.6875 C 210.75812,134.76968 208.74143,152.16667 202.09375,164.8125 L 212.90625,160.4375 C 216.68272,146.10873 217.47609,127.59492 218.625,118.84375 L 211.75,117.6875 z M 232.1875,117.6875 L 225.3125,118.84375 C 226.4614,127.59492 227.25478,146.10873 231.03125,160.4375 L 241.84375,164.8125 C 235.19607,152.16667 233.17938,134.76968 232.1875,117.6875 z"
      S.path 
        ! A.d "M 221.95313,154.6875 C 209.03974,154.6875 199.55398,160.77412 198.98438,176.28125 C 195.82773,170.72636 182.4742,153.25552 170.01563,155.59375 C 162.60576,156.98444 156.05854,167.25962 157.17188,179.03125 C 151.037,161.40135 133.06509,158.51225 119.95313,168.9375 C 131.59529,178.51001 136.77421,206.77225 146.57813,219.03125 L 221.95313,219.03125 L 297.32813,219.03125 C 307.13204,206.77225 312.34222,178.51001 323.98438,168.9375 C 310.87241,158.51225 292.90051,161.40135 286.76563,179.03125 C 287.87896,167.25962 281.3005,156.98444 273.89063,155.59375 C 261.43205,153.25552 248.10978,170.72636 244.95313,176.28125 C 244.38354,160.77412 234.86652,154.6875 221.95313,154.6875 z"
      S.g 
        ! A.strokeWidth "1.5"
        $ do
          S.path 
            ! A.fill "#000000"
            ! A.d "M 297.10662,219.02573 C 297.10662,224.60663 263.44486,230.74447 221.96875,230.74447 C 180.49265,230.74447 146.83089,224.60663 146.83089,219.02573 C 146.83089,213.44487 180.49265,210.5239 221.96875,210.5239 C 263.44486,210.5239 297.10662,213.44487 297.10662,219.02573 z"
          S.circle ! A.cx "221.9" ! A.cy "114.4" ! A.r "3.5"
          S.circle ! A.cx "221.9" ! A.cy "122.0" ! A.r "3.7"
          S.circle ! A.cx "221.9" ! A.cy "130.1" ! A.r "4.0"
          S.circle ! A.cx "221.9" ! A.cy "139.2" ! A.r "4.6"
          S.circle ! A.cx "221.9" ! A.cy "149.3" ! A.r "5.1"
          S.path
            ! A.fill "#000000"
            ! A.stroke "none"
            ! A.d "M 219.93751,159.20588 C 219.38456,159.19901 218.86165,159.6649 219.00001,160.54963 C 219.16297,161.59315 219.36706,163.54482 219.56251,164.86213 C 219.78339,166.35532 220.65373,165.99233 220.87501,164.83088 C 221.09631,163.66986 221.00709,162.925 221.06251,160.76838 C 221.09024,159.69029 220.49047,159.21276 219.93751,159.20588 z M 224.00001,159.20588 C 223.44705,159.21276 222.8473,159.69029 222.87501,160.76838 C 222.93043,162.925 222.84123,163.66986 223.06251,164.83088 C 223.28379,165.99233 224.15415,166.35532 224.37501,164.86213 C 224.57046,163.54482 224.77457,161.59315 224.93751,160.54963 C 225.07587,159.6649 224.55298,159.19901 224.00001,159.20588 z M 216.31251,159.76838 C 215.80668,159.83874 215.2822,160.34892 215.31251,160.89338 C 215.36753,161.88856 215.64291,163.0823 215.75001,164.58088 C 215.86046,166.12907 216.95166,165.52771 217.06251,164.64338 C 217.17296,163.75866 217.29793,162.45118 217.18751,160.73713 C 217.1461,160.09422 216.8653,159.8115 216.53126,159.76838 C 216.46168,159.75941 216.38477,159.75833 216.31251,159.76838 z M 227.40626,159.76838 C 227.07222,159.8115 226.79144,160.09422 226.75001,160.73713 C 226.63959,162.45118 226.76458,163.75866 226.87501,164.64338 C 226.98586,165.52771 228.07708,166.12907 228.18751,164.58088 C 228.29461,163.0823 228.57001,161.88856 228.62501,160.89338 C 228.65532,160.34892 228.13086,159.83874 227.62501,159.76838 C 227.55275,159.75833 227.47586,159.75941 227.40626,159.76838 z M 211.96876,161.51838 C 211.50567,161.63805 211.0804,162.19494 211.21876,162.83088 C 211.49507,164.10277 211.75001,165.50899 211.75001,166.79963 C 211.75002,167.90566 212.69459,167.511 212.75001,166.73713 C 212.80503,165.96284 212.90626,164.32364 212.90626,162.83088 C 212.90627,161.71632 212.43186,161.39872 211.96876,161.51838 z M 231.65626,161.51838 C 231.32747,161.60947 231.03126,161.99496 231.03126,162.83088 C 231.03126,164.32364 231.13251,165.96284 231.18751,166.73713 C 231.24293,167.511 232.18752,167.90566 232.18751,166.79963 C 232.18751,165.50899 232.44247,164.10277 232.71876,162.83088 C 232.85712,162.19494 232.43187,161.63805 231.96876,161.51838 C 231.85299,161.48846 231.76586,161.48802 231.65626,161.51838 z M 172.56251,161.68934 C 172.00845,161.67094 171.61973,162.42254 172.00001,163.25184 C 172.60804,164.57916 173.25407,165.41659 173.87501,166.84559 C 174.42803,168.11748 175.2763,167.32448 175.00001,166.43934 C 174.7233,165.55461 174.42308,164.56923 173.59376,162.68934 C 173.28263,161.98423 172.89495,161.70039 172.56251,161.68934 z M 271.37501,161.68934 C 271.04257,161.70039 270.65489,161.98423 270.34376,162.68934 C 269.51444,164.56923 269.21422,165.55461 268.93751,166.43934 C 268.66122,167.32448 269.50949,168.11748 270.06251,166.84559 C 270.68345,165.41659 271.32948,164.57916 271.93751,163.25184 C 272.31779,162.42254 271.92907,161.67094 271.37501,161.68934 z M 176.56251,161.75184 C 176.15469,161.8763 175.90747,162.39361 176.15626,163.00184 C 176.65427,164.21831 177.37284,165.46536 177.87501,166.78309 C 178.31718,167.94413 179.3009,167.61494 178.96876,166.56434 C 178.63704,165.51375 178.53846,164.89884 177.87501,162.90809 C 177.54309,161.91293 176.97034,161.62739 176.56251,161.75184 z M 267.06251,161.75184 C 266.71381,161.82629 266.31145,162.16172 266.06251,162.90809 C 265.39906,164.89884 265.30048,165.51375 264.96876,166.56434 C 264.63662,167.61494 265.62034,167.94413 266.06251,166.78309 C 266.56468,165.46536 267.28325,164.21831 267.78126,163.00184 C 268.03005,162.39361 267.78283,161.8763 267.37501,161.75184 C 267.27305,161.72073 267.17874,161.72702 267.06251,161.75184 z M 181.56251,162.72059 C 181.04838,162.81843 180.65026,163.60277 181.00001,164.56434 C 181.4426,165.78081 182.072,166.93202 182.62501,168.31434 C 183.17803,169.69667 184.0963,169.41781 183.87501,168.53309 C 183.65374,167.64836 183.38263,166.18221 182.71876,163.97059 C 182.42851,163.00283 181.9624,162.6445 181.56251,162.72059 z M 262.37501,162.72059 C 261.97512,162.6445 261.50901,163.00283 261.21876,163.97059 C 260.55489,166.18221 260.28378,167.64836 260.06251,168.53309 C 259.84122,169.41781 260.75949,169.69667 261.31251,168.31434 C 261.86552,166.93202 262.49492,165.78081 262.93751,164.56434 C 263.28726,163.60277 262.88914,162.81843 262.37501,162.72059 z M 169.18751,163.40809 C 168.63064,163.46496 168.12339,164.37333 168.46876,165.06434 C 169.0222,166.17037 169.37242,166.54665 169.90626,167.72059 C 170.45928,168.93706 171.06504,167.99489 170.84376,167.22059 C 170.62248,166.4463 170.33882,165.54493 170.06251,164.43934 C 169.85999,163.62937 169.52164,163.37397 169.18751,163.40809 z M 274.75001,163.40809 C 274.41588,163.37397 274.07753,163.62937 273.87501,164.43934 C 273.5987,165.54493 273.31504,166.4463 273.09376,167.22059 C 272.87248,167.99489 273.47824,168.93706 274.03126,167.72059 C 274.5651,166.54665 274.91532,166.17037 275.46876,165.06434 C 275.81413,164.37333 275.30688,163.46496 274.75001,163.40809 z M 207.71876,166.20588 C 207.13501,166.20536 206.51143,166.98024 206.71876,167.70588 C 207.05049,168.86734 207.56328,169.89687 207.93751,171.39338 C 208.26924,172.72029 209.21168,172.05937 209.15626,171.17463 C 209.10085,170.28991 208.94926,169.0862 208.56251,167.20588 C 208.41734,166.50092 208.06902,166.2062 207.71876,166.20588 z M 236.21876,166.20588 C 235.8685,166.2062 235.5202,166.50092 235.37501,167.20588 C 234.98826,169.0862 234.83669,170.28991 234.78126,171.17463 C 234.72584,172.05937 235.6683,172.72029 236.00001,171.39338 C 236.37424,169.89687 236.88705,168.86734 237.21876,167.70588 C 237.42609,166.98024 236.80253,166.20536 236.21876,166.20588 z M 221.96876,167.39338 C 221.24958,167.39339 221.15023,168.35899 221.12501,169.14338 C 221.04236,171.71466 219.97517,174.21192 219.06251,175.45588 C 218.15028,176.70025 216.80689,176.36933 215.56251,175.70588 C 214.31815,175.04245 213.5769,174.54522 212.25001,173.54963 C 210.9227,172.55448 209.91641,173.13633 211.50001,175.39338 C 216.11747,181.97369 221.12501,187.5982 221.12501,198.33088 C 221.12502,199.71862 221.36747,200.14338 221.96876,200.14338 C 222.57005,200.14338 222.84374,199.71862 222.84376,198.33088 C 222.84376,187.5982 227.82007,181.97369 232.43751,175.39338 C 234.02111,173.13633 233.01484,172.55448 231.68751,173.54963 C 230.36062,174.54522 229.61939,175.04245 228.37501,175.70588 C 227.13063,176.36933 225.78726,176.70025 224.87501,175.45588 C 223.96235,174.21192 222.89518,171.71466 222.81251,169.14338 C 222.78729,168.35899 222.68796,167.39339 221.96876,167.39338 z M 186.68751,165.78309 C 186.62459,165.78137 186.55597,165.79672 186.50001,165.81434 C 186.23143,165.89895 186.05249,166.22315 186.15626,166.78309 C 186.34172,167.78535 187.03621,169.7496 187.31251,170.68934 C 187.58924,171.62952 188.74506,171.42956 188.46876,170.15809 C 188.19206,168.88621 188.20674,168.50208 187.87501,167.06434 C 187.69361,166.27808 187.12805,165.79517 186.68751,165.78309 z M 257.25001,165.78309 C 256.80947,165.79517 256.24393,166.27808 256.06251,167.06434 C 255.73078,168.50208 255.74548,168.88621 255.46876,170.15809 C 255.19246,171.42956 256.3483,171.62952 256.62501,170.68934 C 256.90131,169.7496 257.5958,167.78535 257.78126,166.78309 C 257.88503,166.22315 257.70609,165.89895 257.43751,165.81434 C 257.38155,165.79672 257.31295,165.78137 257.25001,165.78309 z M 165.71876,166.18934 C 165.13997,166.23465 164.72491,166.96181 165.31251,168.03309 C 165.94637,169.18996 167.03368,170.64128 167.53126,171.47059 C 168.02886,172.29991 168.88969,171.74036 168.28126,170.68934 C 167.67324,169.63877 167.46889,168.4321 166.75001,166.93934 C 166.48045,166.37941 166.06604,166.16216 165.71876,166.18934 z M 278.21876,166.18934 C 277.87148,166.16216 277.45707,166.37941 277.18751,166.93934 C 276.46863,168.4321 276.26428,169.63877 275.65626,170.68934 C 275.04783,171.74036 275.90866,172.29991 276.40626,171.47059 C 276.90384,170.64128 277.99115,169.18996 278.62501,168.03309 C 279.21261,166.96181 278.79755,166.23465 278.21876,166.18934 z M 134.03126,169.51838 C 133.36345,169.4829 133.15409,170.68863 133.78126,171.48713 C 134.69393,172.64817 135.32901,173.26405 136.37501,174.20588 C 137.20474,174.95227 137.44592,173.98351 137.03126,173.23713 C 136.61662,172.49076 136.01682,171.7315 135.18751,170.48713 C 134.73288,169.80512 134.33481,169.53451 134.03126,169.51838 z M 309.90626,169.51838 C 309.60271,169.53451 309.20464,169.80512 308.75001,170.48713 C 307.9207,171.7315 307.3209,172.49076 306.90626,173.23713 C 306.4916,173.98351 306.73278,174.95227 307.56251,174.20588 C 308.60851,173.26405 309.24359,172.64817 310.15626,171.48713 C 310.78343,170.68863 310.57407,169.4829 309.90626,169.51838 z M 139.06251,170.51838 C 138.53029,170.52532 138.17911,170.91843 138.59376,171.83088 C 139.18763,173.13695 139.97076,174.61654 140.46876,175.61213 C 140.96636,176.60732 142.48303,176.94156 141.87501,175.39338 C 141.26659,173.84521 141.14677,173.04988 140.59376,171.61213 C 140.31726,170.89327 139.59474,170.51145 139.06251,170.51838 z M 304.87501,170.51838 C 304.34278,170.51145 303.62026,170.89327 303.34376,171.61213 C 302.79075,173.04988 302.67093,173.84521 302.06251,175.39338 C 301.45449,176.94156 302.97116,176.60732 303.46876,175.61213 C 303.96676,174.61654 304.74989,173.13695 305.34376,171.83088 C 305.75841,170.91843 305.40723,170.52532 304.87501,170.51838 z M 129.31251,170.86213 C 128.53874,170.87003 128.47208,171.6458 129.15626,172.14338 C 130.06892,172.80684 131.15649,173.54322 132.21876,174.39338 C 133.46273,175.38856 133.9447,174.4731 133.28126,173.64338 C 132.61782,172.81408 131.97153,171.9731 130.31251,171.14338 C 129.89776,170.93606 129.57043,170.8595 129.31251,170.86213 z M 314.62501,170.86213 C 314.36709,170.8595 314.03976,170.93606 313.62501,171.14338 C 311.96599,171.9731 311.3197,172.81408 310.65626,173.64338 C 309.99282,174.4731 310.47479,175.38856 311.71876,174.39338 C 312.78103,173.54322 313.86859,172.80684 314.78126,172.14338 C 315.46544,171.6458 315.39877,170.87003 314.62501,170.86213 z M 204.96876,171.58088 C 204.5358,171.64145 204.16235,172.13322 204.34376,172.76838 C 204.67549,173.92942 205.05205,175.15983 205.28126,176.36213 C 205.50256,177.52359 206.8463,177.53773 206.62501,176.48713 C 206.40415,175.43655 206.29299,174.12199 205.90626,172.51838 C 205.76109,171.91704 205.45795,171.62817 205.15626,171.58088 C 205.09342,171.57104 205.03061,171.57223 204.96876,171.58088 z M 238.78126,171.58088 C 238.47957,171.62817 238.17645,171.91704 238.03126,172.51838 C 237.64453,174.12199 237.53339,175.43655 237.31251,176.48713 C 237.09122,177.53773 238.43498,177.52359 238.65626,176.36213 C 238.88547,175.15983 239.26205,173.92942 239.59376,172.76838 C 239.77517,172.13322 239.40174,171.64145 238.96876,171.58088 C 238.90691,171.57223 238.84412,171.57104 238.78126,171.58088 z M 174.87501,169.59559 C 174.53504,169.68956 174.33942,170.33955 174.59376,171.25184 C 176.004,176.31148 176.4363,178.97621 176.18751,180.22059 C 175.93873,181.46457 175.256,181.63524 174.34376,181.22059 C 173.43153,180.80594 172.36056,180.20736 171.53126,179.62684 C 170.70196,179.04592 169.83939,179.74084 171.03126,180.72059 C 177.08606,185.69729 181.28306,191.38482 182.90626,198.28309 C 183.238,199.69294 184.12381,199.85878 183.87501,198.28309 C 182.5027,189.59329 182.23882,182.44969 184.31251,177.97059 C 185.09182,176.28738 184.30689,174.67095 183.06251,177.40809 C 182.23321,179.23301 180.89102,179.95295 179.81251,178.37684 C 178.7344,176.80116 176.5072,172.59717 175.84376,170.68934 C 175.59482,169.97391 175.28778,169.64292 175.03126,169.59559 C 174.97783,169.58574 174.92358,169.58217 174.87501,169.59559 z M 268.90626,169.59559 C 268.64974,169.64292 268.3427,169.97391 268.09376,170.68934 C 267.43032,172.59717 265.20312,176.80116 264.12501,178.37684 C 263.0465,179.95295 261.70431,179.23301 260.87501,177.40809 C 259.63063,174.67095 258.8457,176.28738 259.62501,177.97059 C 261.6987,182.44969 261.43482,189.59329 260.06251,198.28309 C 259.81371,199.85878 260.69952,199.69294 261.03126,198.28309 C 262.65446,191.38482 266.85146,185.69729 272.90626,180.72059 C 274.09813,179.74084 273.23556,179.04592 272.40626,179.62684 C 271.57696,180.20736 270.50599,180.80594 269.59376,181.22059 C 268.68152,181.63524 267.99879,181.46457 267.75001,180.22059 C 267.50122,178.97621 267.93352,176.31148 269.34376,171.25184 C 269.5981,170.33955 269.40248,169.68956 269.06251,169.59559 C 269.01394,169.58217 268.95969,169.58574 268.90626,169.59559 z M 144.43751,172.01838 C 143.89144,172.02532 143.43872,172.40782 143.68751,173.23713 C 144.08634,174.5657 144.91121,176.00157 145.18751,176.83088 C 145.46423,177.66021 146.35337,177.27317 146.18751,176.11213 C 146.02167,174.95111 145.94005,174.25902 145.71876,172.98713 C 145.60813,172.35141 144.98359,172.01145 144.43751,172.01838 z M 299.50001,172.01838 C 298.95393,172.01145 298.32939,172.35141 298.21876,172.98713 C 297.99747,174.25902 297.91585,174.95111 297.75001,176.11213 C 297.58415,177.27317 298.47329,177.66021 298.75001,176.83088 C 299.02631,176.00157 299.85118,174.5657 300.25001,173.23713 C 300.4988,172.40782 300.04608,172.02532 299.50001,172.01838 z M 163.21876,170.28309 C 162.58372,170.16913 162.49242,171.80734 163.03126,172.47059 C 163.75015,173.35576 164.74859,174.42538 165.75001,175.62684 C 166.57933,176.62244 167.09175,175.73741 166.59376,174.90809 C 166.09619,174.07837 165.35814,173.19678 164.03126,171.09559 C 163.69944,170.5703 163.43044,170.32108 163.21876,170.28309 z M 280.71876,170.28309 C 280.50708,170.32108 280.23808,170.5703 279.90626,171.09559 C 278.57938,173.19678 277.84133,174.07837 277.34376,174.90809 C 276.84577,175.73741 277.35819,176.62244 278.18751,175.62684 C 279.18893,174.42538 280.18737,173.35576 280.90626,172.47059 C 281.4451,171.80734 281.3538,170.16913 280.71876,170.28309 z M 148.71876,174.23713 C 148.32474,174.20948 147.9904,174.52908 148.15626,175.33088 C 148.38756,176.44733 148.7233,177.37403 149.00001,178.42463 C 149.27633,179.47524 150.00001,179.29522 150.00001,178.29963 C 150.00002,177.30446 149.82212,176.19398 149.65626,175.14338 C 149.57334,174.61809 149.11279,174.26479 148.71876,174.23713 z M 295.21876,174.23713 C 294.82473,174.26479 294.36418,174.61809 294.28126,175.14338 C 294.1154,176.19398 293.9375,177.30446 293.93751,178.29963 C 293.93751,179.29522 294.66119,179.47524 294.93751,178.42463 C 295.21422,177.37403 295.54996,176.44733 295.78126,175.33088 C 295.94712,174.52908 295.61278,174.20948 295.21876,174.23713 z M 161.81251,175.65809 C 161.19365,175.75159 160.6491,176.34985 161.37501,177.28309 C 162.53607,178.77584 163.80743,179.82383 164.25001,180.37684 C 164.69218,180.92987 165.81263,180.72579 165.09376,179.56434 C 164.35906,178.37789 163.2476,176.94908 162.75001,176.06434 C 162.56343,175.73257 162.18383,175.602 161.81251,175.65809 z M 281.87501,175.65809 C 281.60285,175.6867 281.32745,175.81551 281.18751,176.06434 C 280.68992,176.94908 279.57846,178.37789 278.84376,179.56434 C 278.12489,180.72579 279.24534,180.92987 279.68751,180.37684 C 280.13009,179.82383 281.40145,178.77584 282.56251,177.28309 C 283.28842,176.34985 282.74387,175.75159 282.12501,175.65809 C 282.03218,175.64407 281.96573,175.64855 281.87501,175.65809 z M 141.15626,179.83088 C 140.668,179.78654 140.49938,180.18047 141.15626,181.08088 C 142.64903,183.12666 144.29582,186.22273 144.40626,187.54963 C 144.51713,188.87695 143.86095,188.86213 143.25001,188.86213 C 141.42512,188.86215 140.53363,187.53012 138.87501,187.14338 C 137.21599,186.75625 136.97522,187.62865 138.15626,188.48713 C 144.23856,192.91082 150.33501,197.84636 152.78126,202.33088 C 153.77645,204.15578 155.12181,204.82284 154.37501,203.08088 C 152.08795,197.74371 151.53367,193.22426 152.03126,190.48713 C 152.52926,187.75001 153.20794,185.90698 153.12501,184.33088 C 153.0421,182.7552 152.1484,182.86271 151.78126,184.33088 C 151.53247,185.32648 151.05048,186.64538 150.71876,187.14338 C 150.38705,187.64099 149.05314,187.91993 147.78126,186.20588 C 146.50937,184.49186 143.30061,181.19144 142.25001,180.36213 C 141.85605,180.05115 141.44922,179.85749 141.15626,179.83088 z M 302.78126,179.83088 C 302.4883,179.85749 302.08147,180.05115 301.68751,180.36213 C 300.63691,181.19144 297.42815,184.49186 296.15626,186.20588 C 294.88438,187.91993 293.55047,187.64099 293.21876,187.14338 C 292.88704,186.64538 292.40505,185.32648 292.15626,184.33088 C 291.78912,182.86271 290.89542,182.7552 290.81251,184.33088 C 290.72958,185.90698 291.40826,187.75001 291.90626,190.48713 C 292.40385,193.22426 291.84957,197.74371 289.56251,203.08088 C 288.81571,204.82284 290.16107,204.15578 291.15626,202.33088 C 293.60251,197.84636 299.69896,192.91082 305.78126,188.48713 C 306.9623,187.62865 306.72153,186.75625 305.06251,187.14338 C 303.40389,187.53012 302.5124,188.86215 300.68751,188.86213 C 300.07657,188.86213 299.42039,188.87695 299.53126,187.54963 C 299.6417,186.22273 301.28849,183.12666 302.78126,181.08088 C 303.43814,180.18047 303.26952,179.78654 302.78126,179.83088 z"
          S.path
            ! A.d "M 150.12687,212.65106 152.07661,218.82525 M 154.13742,211.48082 155.86506,217.72081 M 158.46968,210.7684 159.65672,217.1334 M 162.48993,209.96408 163.7604,216.31295 M 167.64553,209.45517 168.67848,215.84698 M 173.13007,209.46186 174.24249,215.84031 M 178.48383,207.65149 179.28735,214.07616 M 183.52067,207.97645 184.32419,214.40112 M 188.39503,207.32654 189.19855,213.75121 M 193.28767,206.82164 193.72967,213.28125 M 198.51623,206.81977 198.89973,213.28312 M 203.25656,206.49325 203.58317,212.95973 M 208.48353,206.16701 208.75481,212.63605 M 214.49524,206.00453 214.76652,212.47357 M 293.81064,212.65106 291.8609,218.82525 M 289.80009,211.48082 288.07245,217.72081 M 285.46783,210.7684 284.28079,217.1334 M 281.44758,209.96408 280.17711,216.31295 M 276.29198,209.45517 275.25903,215.84698 M 270.80744,209.46186 269.69502,215.84031 M 265.45368,207.65149 264.65016,214.07616 M 260.41684,207.97645 259.61332,214.40112 M 255.54248,207.32654 254.73896,213.75121 M 250.64984,206.82164 250.20784,213.28125 M 245.42128,206.81977 245.03778,213.28312 M 240.68095,206.49325 240.35434,212.95973 M 235.45398,206.16701 235.1827,212.63605 M 229.44227,206.00453 229.17099,212.47357 M 221.96876,205.58364 221.96876,212.7068"



{- |
Flag of Moldova coat of arms.
Drawn for a @viewbox 0 0 1800 900@
-}
mdCoA :: Svg
mdCoA = 
  S.g $ do
    S.g $ do
      S.path
        ! A.d "M851.4899902,183.2400055c-2.7169189-0.1228485-5.4036255,0.6118011-7.6799927,2.1000061    c2.6946411,0.7955017,4.5341797,3.2825317,4.5059814,6.0919952v7.4230042h-7.4219971    c-2.793396,0.0288849-5.2728271-1.7835846-6.0930176-4.4539948c-2.798645,4.7368469-2.798645,10.6211548,0,15.3580017    c0.7956543-2.6949615,3.2832031-4.5345917,6.0930176-4.5059967h7.4219971v35.6809998    c0.0216064,2.6874847-1.6643066,5.0926666-4.197998,5.9889984c3.5410156,0.4819946,6.5880127,5.2339935,7.4229736,7.8329926    c0.8369751-2.5930023,3.8839722-7.3509979,7.4240112-7.8330078c-2.5584106-0.8731689-4.270874-3.2857513-4.2509766-5.9889984    v-35.6829987h7.4240112c2.7940674-0.0291443,5.2739868,1.7844696,6.0930176,4.4559937    c2.7973633-4.7375488,2.7973633-10.6214447,0-15.3589935c-0.7964478,2.6941376-3.2837524,4.5327759-6.0930176,4.5039978    h-7.4240112v-7.4220123c-0.029541-2.7939148,1.7836914-5.27388,4.4550171-6.0930023    c-2.2766113-1.4867096-4.9627686-2.2205963-7.6790161-2.0980072V183.2400055z"
      S.path
        ! A.fill "#FFD200"
        ! A.d "M851.4899902,184.7799988c-1.4957886,0.0062866-2.9812622,0.2479095-4.4019775,0.7160034    c1.743042,1.4821777,2.7528076,3.651001,2.7650146,5.9389954v7.4230042    c-0.0066528,0.104187-0.0241089,0.2073975-0.052002,0.3079987v1.177002h-1.1779785    c-0.1003418,0.0274353-0.203186,0.0448608-0.3070068,0.052002h-7.4240112    c-2.2610474-0.0148468-4.4060059-1.0035248-5.8859863-2.7129974c-0.494873,1.4158325-0.7543335,2.9032288-0.7680054,4.4029999    c0.0062866,1.4958038,0.2479248,2.981308,0.7160034,4.4019928c1.4819946-1.7424622,3.6505737-2.7515106,5.9379883-2.7630005    h8.9589844c-0.0100098,0.154007-0.052002,0.3029938-0.052002,0.4589996v0.7680054    c0.0275269,0.1003418,0.0449219,0.2032013,0.052002,0.3070068v35.6809998    c-0.0739746,2.1716766-1.0818481,4.2057037-2.7650146,5.5800018c1.1054688,0.6892853,2.0911255,1.5543213,2.9180298,2.5610046    c0.6027222,0.8314362,1.1174927,1.7232208,1.5360107,2.6609955c0.4193726-0.9373474,0.934082-1.8290405,1.5360107-2.6609955    c0.8164063-0.9832306,1.7841797-1.8301697,2.8670044-2.5090027c-1.6924438-1.3889618-2.7008057-3.4425201-2.7650146-5.6309967    v-37.1680145h1.2290039c0.1004028-0.0268555,0.2032471-0.0436096,0.3070068-0.0500031h7.4229736    c2.2607422,0.0153503,4.4053955,1.0035095,5.8859863,2.7120056c0.4949341-1.4155121,0.7546997-2.9025269,0.7689819-4.4019928    c-0.0066528-1.4958496-0.2486572-2.9813385-0.71698-4.4019928c-1.4819946,1.7424622-3.6505737,2.7515106-5.9379883,2.7630005    h-7.4229736c-0.1038818-0.0066681-0.2067261-0.0240936-0.3070068-0.052002h-1.1779785v-1.177002    c-0.0276489-0.100647-0.045105-0.2038422-0.052002-0.3079987v-7.4219971    c0.015686-2.2611694,1.0042114-4.4060974,2.7130127-5.8869934c-1.4157104-0.4939423-2.9026489-0.7533569-4.4019775-0.7680054"
      S.path
        ! A.d "M944.4089966,313.9869995c-4.3369141-2.9418335-8.0438232-6.7187805-10.9039917-11.1099854    c-6.3720093-10.2229919-9.0609741-22.7730103-9.0609741-35.5270081c0-5.3909912,6.039978-11.4600067,6.039978-15.8200073    c0.0401001-3.5246582-0.1650391-7.0478363-0.6140137-10.5440063c2.1430054,0.2920074,5.8870239,4.0950012,5.8870239,4.0950012    s-0.1290283-10.9380035-3.585022-12.848999c0,0,1.3980103-1.4380035,6.4509888-1.5870056    c-1.4199829-3.595993-8.4459839-7.9859924-8.4459839-7.9859924c0.4523926-0.7044067,1.0895386-1.2710114,1.84198-1.6380005    c1.942688-0.9525909,4.0106201-1.6249542,6.1420288-1.996994c-2.3359375-0.5060272-4.6427002-1.1386414-6.9099731-1.8950043    c-6.5401001-2.1858521-12.9349365-4.7844086-19.1459961-7.7799988c-7.9417114-3.9832001-16.7115479-6.0353546-25.5960083-5.989502    c-3.5750122,0.0005035-8.8400269,0.0984955-11.927002,2.1515045c-2.8250122,1.875-2.5949707,4.3139954-3.5839844,5.1699982    c-2.3300171,2.0160065-6.3209839,1.9450073-8.242981,1.9450073c-12.4400024,0-12.901001,13.3110046-12.901001,13.3110046    s3.1810303-4.8130035,8.8049927-4.8130035c9.3510132,0,16.4329834,5.0939941,16.4329834,7.0130005    c0,0.7769928-0.9639893,0.9210052-1.0230103,0.9210052c-6.1079712,0-15.3259888-3.5160065-20.2230225-3.6860046v2.4060059    c10.9309692,3.8029938,22.0130005,9.1869965,22.0130005,32.9169922c0,14.9429932-1.7890015,30.1900024-9.2650146,42.1829834    c-2.8818359,4.390686-6.6052246,8.166748-10.9550171,11.1099854l44.3850098,7.9995117L944.4089966,313.9869995z"
      S.g
        ! A.id_ "HaskellSvgIcons-mdCoA-eagle"
        $ do
          S.path 
            ! A.d "M900.0219727,303.9880066l-44.3829956,10.0004883c-2.0189819-0.6099854-11.5130005-3.5599976-18.1740112-7.2690125     c-11.7260132-6.5320129-17.8060303-13.0310059-31.7399902-13.6690063v-10.5979919     c0-5.6619873,2.0490112-10.7630005,2.0490112-16.177002c-5.8740234-1.5750122-22.1779785-21.5099945-37.2180176-30.3580017     c-22.1300049,14.3339996-39.2650146,37.8649902-39.2650146,48.6860046c0,0,0.664978,232.5099792,0,313.5100403     c0,4.6680298-2.8150024,11.2630005-2.8150024,11.2630005c8.0789795-3.4180298,22.8880005-23.6799927,26.0059814-31.382019     v3.6870117c12.2009888-5.5640259,21.1350098-20.184021,25.1359863-27.7470093     c0.0709839,1.0930176,0.257019,3.8380127,0.257019,3.8380127c10.9000244-9.5549927,24.776001-66.0379944,24.776001-66.0379944     l23.1240845,22.7254944c0,0-8.3629761,16.9755249-11.6209717,20.0155029     c1.5462036,0.1781006,3.1016235,0.2636108,4.65802,0.2559814c-1.5219727,2.1879883-13.1469727,18.9249878-16.7910156,25.2379761     c-3.4099731,5.9060059-5.815979,3.2769775-11.0579834,3.2769775c-4.3469849,0-14.2000122,6.9249878-15.8179932,9.7269897     c-1.7503662,2.8661499-2.7695923,6.1185303-2.9680176,9.4710083c0,3.2399902,3.4299927,7.6790161,3.4299927,7.6790161     c0.1262817-0.7853394,0.4822388-1.515686,1.0230103-2.098999c0,0,9.0130005,11.2280273,10.3410034,12.6950073     c1.0339966,1.1430054,5.6450195,1.8859863,7.2700195,0.4110107c4.065979-3.6970215,8.0020142-6.2819824,11.6209717-11.6209717     c1.8629761-2.7509766,2.0050049-5.9039917,4.1459961-8.8579712c7.1619873-9.8800049,21.414978-28.7990112,24.6749878-33.1209717     c0.2180176,1.2030029,0.4050293,2.2050171,0.6119995,3.4299927c3.6939697-7.4569702,21.4509888-21.7059937,21.4509888-21.7059937     l18.5780029,8.5499878c0,0-34.6870117,79.7349854-65.4760132,91.9949951c0,0,13.3950195,5.690979,29.8449707,14.2319946     c2.4000244,1.2459717,4.8709717,2.5839844,7.3720093,3.9429932c2.0709839-2.4940186,4.2509766-5.2650146,6.3989868-8.1409912     c9.8359985-13.1599731,19.4550171-28.4119873,19.4550171-28.4119873     c0.6699829,3.9609985-4.5239868,16.1940308-13.3099976,31.2810059c-1.7280273,2.9639893-3.5300293,6.0640259-5.5289917,9.2130127     c2.2290039,1.2730103,4.440979,2.559021,6.6550293,3.8920288c16.2949829,9.8049927,31.5980225,21.0770264,37.2670288,31.4320068     l4-10.0089722l-4-10.0089722V317.264679l2-5L900.0219727,303.9880066z"
          S.g
            ! A.fill "#B07E5B"
            $ do
              S.path ! A.d "M900.0020142,667.2210083c-5.7490234-6.2360229-17.7689819-13.8549805-31.2780151-20.8859863      c16.3339844-29.315979,24.4279785-75.6549683,20.6300049-84.8800049c0,0-6.7050171,24.03302-14.8980103,37.7290039      c-7.5859985,12.684021-16.9249878,26.9500122-25.9539795,37.526001      c-6.7852783-2.9316406-13.7236938-5.4953613-20.7849731-7.6799927      c27.0579834-20.8430176,54.7260132-89.7420044,54.7260132-89.7420044l-28.6119995-13.2600098      c0,0-10.7039795,12.4790039-14.1799927,14.7960205c0,0-1.4849854-6.2059937-2.3549805-8.3959961      c0,0-4.1010132,3.1019897-6.3460083,3.1760254c0,0-0.6710205-4.2119751-1.1779785-6.9639893      c-2.8250122,1.8829956-7.5250244,1.4849854-7.5250244,1.4849854c4.1270142-1.9539795,9.0100098-13.9249878,9.0100098-13.9249878      l-27.3220215-36.3429871c0,0-9.5969849,46.1159973-20.5280151,55.5959778V336.8730469l8.6519775,8.0360107      l13.1049805-12.2349854v-9.3169861l-11.6209717,10.8519897v-28.105011      c1.7509766-2.6489868,2.9119873-4.6260071,3.7880249-6.1940002c1.8809814,3.2789917,7.960022,13.32901,15.1010132,19.5050049      c1.1749878-4.7779846,8.90802-9.3179932,8.90802-9.3179932s2.7709961,7.5079956,7.0120239,9.3680115      c1.4920044-2.6279907,10.3939819-8.4460144,10.3939819-8.4460144s-7.6160278,1.1570129-10.7000122,4.0450134      c-2.6489868-0.5929871-3.3280029-11.0580139-3.3280029-11.0580139s-11.2069702,5.4590149-13.1560059,9.3680115      c-2.1370239-0.5780029-5.4639893-8.9880066-6.7589722-12.4400024c2.770874-0.3088379,5.5568848-0.4624023,8.3449707-0.4599915      c3.1959839,0,7.2849731,1.5140076,11.5689697,3.5320129c4.7069702,2.2160034,9.6309814,5.0220032,14.0280151,7.0140076      c5.632019,2.5499878,14.1530151,3.0679932,16.6370239,3.1740112c-2.9820557,2.0708923-6.112915,3.9189148-9.3670044,5.5289917      c0,0,13.4110107-0.1239929,22.8319702-4.8129883c3.4247437-2.0662842,6.708313-4.3580017,9.8289795-6.8599854      c-1.4345093,4.1832886-3.6210938,8.069397-6.4520264,11.4670105c13.8359985-1.17099,20.7260132-9.071991,22.6790161-11.7229919      c1.2443237,3.3854065,2.9682007,6.5746155,5.1190186,9.4700012h5v340L900.0020142,667.2210083z"
              S.path ! A.d "M798.0469971,267.2980042l0.2550049,6.3479919v18.6870117      c-5.0189819-1.7269897-11.3259888-9.9729919-14.3839722-14.3339844v-2.5599976      c0.0674438-1.974762,0.9584351-3.8311157,2.4569702-5.118988l-3.0200195-1.0740051      c-1.4844971,1.5675049-2.3408203,3.6260986-2.4060059,5.7839966v1.4849854l-9.0089722,9.6759949l-8.8560181-13.4129944      v-3.276001c0-2.2080078,1.697998-4.6700134,3.1229858-6.3479919l-2.9699707-1.0750122      c-1.4990234,1.9419861-3.0720215,4.5589905-3.0720215,7.0130005v2.6610107      c-2.0830078,2.1560059-10.1870117,10.4960022-10.1870117,10.4960022s-4.065979-8.7369995-5.1699829-11.1090088      c6.2050171-8.5950012,16.2659912-18.2189941,25.7487793-25.1244965c0,0,20.564209,18.8805084,27.4901733,21.282486H798.0469971z"
              S.path ! A.d "M745.927002,285.42099v15.4110107l-7.1669922,6.6539917v-22.8829956      c0.2045898-2.7333374,1.0458374-5.3808899,2.4564819-7.7309875L745.927002,285.42099z"
              S.path ! A.d "M768.2470093,291.3590088v9.5220032l-8.2410278,7.7309875v-29.7940063L768.2470093,291.3590088z"
              S.path ! A.d "M757.0859985,308.5610046l-8.242981-7.6789856v-11.1590271l8.242981-8.6520081V308.5610046z"
              S.path ! A.d "M794.7130127,296.9909973c-1.9140015,2.7049866-6.927002,9.3210144-12.3369751,12.2359924      v-26.1604919C783.6170654,285.131012,789.3100586,294.3410034,794.7130127,296.9909973z"
              S.path ! A.d "M779.4559937,284.3970032v24.1629944l-8.242981-7.6789856v-8.5490112L779.4559937,284.3970032z"
              S.path ! A.d "M745.9260254,310.1470032v24.1130066l-7.1669922-6.7070007v-10.7000122L745.9260254,310.1470032z"
              S.path ! A.d "M757.0800171,317.8779907v8.651001l-8.2440186,7.678009v-24.0085144L757.0800171,317.8779907z"
              S.path ! A.d "M768.2379761,310.2000122v24.0100098l-8.2410278-7.7309875v-8.5490417L768.2379761,310.2000122z"
              S.path ! A.d "M779.4509888,317.9299927v8.5490112l-8.242981,7.730011v-24.009491L779.4509888,317.9299927z"
              S.path ! A.d "M790.6099854,334.2600098l-8.2440186-7.7309875v-8.0360107      c2.8430176-1.7349854,5.7020264-4.9240112,8.2434692-8.2934875L790.6099854,334.2600098z"
              S.path ! A.d "M769.7249756,344.9079895l8.7030029-8.0889893v198.6299744      c0,0,0.6069946,9.8560181,1.0239868,16.2789917c-3.8699951,3.9119873-18.4290161,18.6339722-18.4290161,18.6339722V336.7659302      L769.7249756,344.9079895z"
              S.path ! A.d "M756.0529785,562.9400024c0,6.3850098-11.6589966,21.2730103-17.3029785,24.6749878V336.875      l8.5999756,8.0360107l8.7030029-8.0895081V562.9400024z"
          S.g
            ! A.fill "#CC092F"
            $ do
              S.path ! A.d "M828.335022,541.3880005l6.3480225-4.3519897c0,0,0.4229736,2.0999756,0.9719849,4.96698      c-2.7180176,3.7160034-18.3309937,25.0239868-26.0570068,35.4249878      c-1.9210205,2.5839844-3.5339966,9.1630249-3.5339966,9.1630249S803.25,585.2600098,803.25,582.8549805      c0-2.3619995,0.3079834-5.1710205,0.3079834-5.1710205c-1.5112305,1.5392456-3.5778809,2.40625-5.7349854,2.4060059      c0-2.9030151,5.6140137-6.052002,5.8359985-10.1859741c-4.2810059,3.1740112-7.9990234,1.5449829-12.9509888,3.0720215      c-5.3930054,1.6610107-6.8950195,3.927002-8.5490112,3.8400269c-0.973999-0.0529785-1.8560181-1.7329712-1.4840088-2.7650146      c0.6439819-1.7869873,7.3140259-6.7329712,11.9769897-7.6270142c1.1170044-0.2139893,9.9030151,1.9119873,11.6729736-0.8189697      c7.2919922-11.2520142,19.1300049-29.5180054,20.2719727-31.2780151      c0.6992798-0.1315918,1.3729858-0.3743286,1.9954834-0.7189941c0,0-0.0675049,5.7509766,1.7424927,7.7800293      L828.335022,541.3880005z"
              S.path ! A.d "M787.5200195,576.4520264c0.350769,0.3825684,0.3270874,0.9765625-0.0529785,1.3300171      l-2.8660278,2.5079956c-0.4109497,0.3205566-1.0031738,0.2520142-1.3300171-0.1539917      c-0.3519897-0.3823242-0.3287354-0.9772949,0.052002-1.3309937l2.8660278-2.5079956      c0.1826172-0.159729,0.4247437-0.2339478,0.6655273-0.2039795c0.2583008,0.0341797,0.4951172,0.1619263,0.6655273,0.3590088      L787.5200195,576.4520264z"
              S.path ! A.d "M791.8709717,579.4719849c0.8486328,0.8947144,0.8112793,2.3079834-0.0834351,3.1566162      l-0.0195923,0.0183716l-6.9619751,6.0910034c-1.0568237,0.78479-2.5496826,0.56427-3.3344727-0.4925537      c-0.6992188-0.9415283-0.6094971-2.2518921,0.2114868-3.0894165l6.9619751-6.0410156      c0.3471069-0.293335,0.7763062-0.4723511,1.2290039-0.5125122      C790.6397095,578.5600586,791.3803711,578.8825073,791.8709717,579.4719849z"
              S.path ! A.d "M795.8610229,584.1820068c0.8483887,0.8933716,0.8119507,2.3053589-0.0814209,3.1538086      l-0.0216064,0.0202026l-7.0120239,6.09198c-0.9711304,0.7783813-2.3894043,0.6221313-3.1678467-0.348999l-0.0071411-0.0089722      c-0.8568726-0.9207764-0.8104248-2.3603516,0.1040039-3.223999l6.9609985-6.0410156      c0.3283691-0.2915039,0.7409058-0.4709473,1.1779785-0.5125122c0.7803955-0.0441284,1.5369263,0.2772217,2.0469971,0.8695068      H795.8610229z"
              S.path ! A.d "M798.2639771,587.9190063c0.7585449-0.0635376,1.5014648,0.2411499,1.9970093,0.8189697      c0.8563843,0.9209595,0.8109131,2.3599854-0.1019897,3.2249756l-6.9630127,6.0419922      c-1.0593872,0.7678833-2.5407104,0.5315552-3.3085938-0.527832c-0.6650391-0.9174805-0.5872192-2.1774292,0.1856079-3.0061646      l7.0139771-6.0910034c0.3312988-0.2783813,0.744751-0.4403687,1.177002-0.4609985V587.9190063z"
      S.use
        ! A.xlinkHref "#HaskellSvgIcons-mdCoA-eagle"
        ! A.transform (S.matrix (-1) 0 0 1 1800 0)
      S.path
        ! A.fill "#B07E5B"
        ! A.d "M889.7340088,206.6369934c11.4580078,0,19.5170288,5.223999,30.3590088,10.0330048    c2.8410034,1.2599945,5.4500122,2.2810059,7.7789917,3.0709991c-1.2639771,0.9673767-2.2669067,2.2345734-2.9180298,3.6869965    c0,0,4.8590088,0.8999939,7.0640259,4.9669952c0,0-4.6199951,0.5240021-5.375,3.223999    c2.5880127,0.1950073,5.1589966,3.4570007,5.1710205,6.6049957l-6.5529785-2.048996    c1.0084839,5.0583801,1.5397949,10.2002869,1.5869751,15.3580017c0,4.0859985-5.8859863,8.8940125-5.8859863,15.8190002    c0,21.7340088,5.4749756,30.0880127,9.3690186,36.8070068c1.5230103,2.6289978,2.7609863,5.6539917,5.3239746,7.9349976    c-11.2180176-5.9729919-19.5560303-13.4389954-19.5560303-20.3739929v-26.2619934h-2.9180298v26.2619934    c0,5.0289917,1.2280273,7.3720093,1.2280273,7.3720093c1.7609863,5.5639954,5.3209839,14.1520081,7.526001,17.6100159    c-10.3209839-5.5780029-15.5640259-12.5629883-15.5640259-15.1530151v-36.0920105h-2.9180298v36.6029968l0.5629883,2.5079956    c-1.2509766,1.8800049-2.8770142,4.1059875-3.992981,4.8630066c-1.1129761-0.756012-2.6900024-2.9859924-3.9429932-4.8630066    l0.5640259-2.5079956v-36.6029968h-2.9180298v36.0920105c0,2.5889893-5.242981,9.5750122-15.5629883,15.1530151    c2.2050171-3.4590149,5.7639771-12.04599,7.5239868-17.6099854c0,0,1.2290039-2.3420105,1.2290039-7.3720093v-26.2620239    h-2.9180298v26.2619934c0,6.927002-8.3070068,14.4049988-19.5050049,20.3739929    c2.5369873-2.2829895,3.757019-5.3210144,5.2719727-7.9349976c4.2579956-7.3479919,9.5219727-16.6830139,9.5219727-43.2579956    c0-9.973999-1.4749756-16.7550049-4.0440063-21.5010071c-0.7810059-1.5659943-1.8330078-5.7339935,4.1459961-5.7339935    c3.0969849,0,10.1879883,5.4779968,10.1879883,5.4779968c-0.2833252-2.7293091-1.6938477-5.2162018-3.8909912-6.8600006    c-0.9066162-0.7143097-1.4800415-1.7696686-1.5859985-2.9190063c0.411499-1.5388641,1.4013062-2.8593903,2.7630005-3.6860046    c0.8330078-0.378006-12.1829834-2.6459961-12.1829834-8.548996c0-1.2290039,0.7730103-2.0480042,3.4790039-2.0480042    c3.5449829,0,9.3120117,4.2489929,14.4379883,4.2489929c3.7890015,0,5.28302-0.9219971,9.1630249-0.9219971    c4.7420044,0,14.6350098,8.9790039,18.0189819,8.651001c-3.78302-2.375-9.8939819-11.3650055-19.1450195-11.3650055    c-3.2109985,0-6.1170044,0.7169952-9.1140137,0.7169952c-3.8410034,0-7.6229858-3.5330048-11.7739868-3.5330048    c-2.7819824,0-5.8889771,0.1549988-6.348999-0.5639954c-0.8049927-1.2550049-0.0800171-1.9830017,0.6660156-3.0200043    c1.4089966-1.9570007,5.3660278-2.5249939,9.2670288-2.6609955c1.1699829-0.0410004,2.3380127-0.0610046,3.4324951-0.0505066    c1.0905151,0.0115051,2.0994873,0.0534973,2.9714966,0.0534973L889.7340088,206.6369934z"
      S.path
        ! A.fill "#CC092F"
        ! A.d "M852.5300293,220.6900024c1.8221436-2.9417877,5.0752563-4.6880341,8.5339966-4.5809937    c2.5560303,0,10.9920044-0.177002,10.9920044-0.177002c1.1240234,2.9210052,6.2490234,7.802002,6.2490234,12.878006    c0,0-5.2020264-9.3769989-19.7230225-9.3769989c-2.0858765-0.0322571-4.1531372,0.3966217-6.0540161,1.2559967    L852.5300293,220.6900024z"
      S.path
        ! A.fill "#CC092F"
        ! A.d "M876.1400146,230.6000061c0,0-3.0930176,3.2579956-3.7650146,4.996994    c-3.0609741-1.1600037-8.3989868-6.6609955-8.3989868-6.6609955s4.5250244,2.6419983,12.1630249,1.6640015H876.1400146z"
      S.path
        ! A.d "M871.2399902,221.9700012c0,0-3.5679932-1.1439972-3.5679932-2.3419952    c0-1.526001,1.7329712-1.526001,2.7689819-0.3370056c0.493042,0.8094025,0.7679443,1.7327271,0.7979736,2.6799927    L871.2399902,221.9700012z"
      S.ellipse
        ! A.cx "887.8"
        ! A.cy "223.9"
        ! A.rx "  7.3"
        ! A.ry "  5.5"
      S.circle
        ! A.fill "#FFD200"
        ! A.cx "887.8"
        ! A.cy "223.9"
        ! A.r  "  5.1"
      S.circle
        ! A.cx "887.8"
        ! A.cy "223.9"
        ! A.r  "  2.3"
    S.g $ do
      S.polygon ! A.points "805.1519775,591.9520264 821.3540039,600.7910156 817.4229736,618.8189697 801.2219849,609.9799805"
      S.path ! A.d "M729.677002,418.730011l-5.8359985,2.6629944l65.9359741,144.4199829h7.0139771L729.677002,418.730011z      M807.4390259,589.0500488l-4.7600098,4.914978l2.9689941,6.5529785l5.7839966-2.6619873L807.4390259,589.0500488z"
      S.path ! A.d "M750.1669922,532.5999756c0,0,5.5540161,11.4719849,9.7750244,13.0449829     c-2.1829834-0.5949707-9.2709961,2.0059814-9.2709961,2.0059814s12.4990234,11.164978,23.0999756,11.8980103     c8.9899902,0.6190186,13.3549805-3.867981,13.3549805-3.867981l-1.8010254-9.5239868     c-3.8994141-4.3592529-8.8109741-7.692749-14.302002-9.7069702c-8.8939819-3.0980225-20.8569946-3.8480225-20.8569946-3.8480225     L750.1669922,532.5999756z"
      S.path ! A.d "M792.0369873,512.0499878c0,0-7.6690063,6.5650024-9.7680054,14.1690063     c-2.0999756,7.6049805,1.367981,16.2470093,1.367981,16.2470093l6.4439697,12.0209961     c0,0,8.9310303-4.7529907,12.7299805-11.8599854c3.7990112-7.1079712,2.4060059-16.697998,2.4060059-16.697998     s-7.0750122,2.6339722-7.9749756,3.7999878c1.492981-7.8839722-5.2059937-17.6790161-5.2059937-17.6790161H792.0369873z"
      S.path ! A.d "M767.3870239,508.980011c0,0-8.7219849,2.947998-17.1920166,2.4379883     c-8.0679932-0.4869995-14.7769775-7.2619934-14.7769775-7.2619934s6.6879883-4.526001,9.9890137-3.9230042     c-3.6309814-1.3269958-8.8959961-10.4230042-8.8959961-10.4230042s7.4819946-2.2609863,14.1160278,0.2399902     c6.6339722,2.5029907,12.4190063,9.769989,12.4190063,9.769989l4.34198,9.1600037L767.3870239,508.980011z"
      S.path ! A.d "M770.3870239,466.3800049c0,0,4.3619995,9.0320129,3.3280029,12.17099     c1.3530273-2.0899963,6.473999-5.3450012,6.473999-5.3450012s3.0960083,14.6239929,0.1350098,23.6560059     c-2.960022,9.0310059-11.973999,12.4700012-11.973999,12.4700012l-9.9429932-19.3370056     c0,0-1.4799805-7.1640015,1.6199951-12.8370056c3.1010132-5.6730042,10.3599854-10.7789917,10.3599854-10.7789917V466.3800049z"
      S.path ! A.d "M713.6370239,442.4700012c0,0,9.427002-0.9899902,18.0510254,2.5830078     c7.210022,2.9930115,9.4199829,8.4330139,9.4199829,8.4330139l3.5510254,9.519989c0,0-10.2609863,3.8479919-18.367981,0.9060059     c-8.1079712-2.9450073-14.0650024-12.6799927-14.0650024-12.6799927s5.6660156-2.1489868,7.822998-1.3429871     c-3.1420288-1.3900146-6.4099731-7.4190063-6.4099731-7.4190063v0.0010071L713.6370239,442.4700012z"
      S.path ! A.d "M743.2869873,424.7999878c0,0,4.1370239,5.3129883,4.2609863,11.4240112     c1.1030273-3.2489929,6.2680054-6.8399963,6.2680054-6.8399963s5.3120117,12.855011,4.1459961,21.9819946     c-1.1660156,9.1279907-8.809021,14.5270081-8.809021,14.5270081l-9.5310059-18.0920105     c0,0-3.1060181-7.4150085-2.190979-13.1669922c0.9160156-5.75,5.8560181-9.8359985,5.8560181-9.8359985V424.7999878z"
      S.path ! A.d "M710.6370239,390.2000122c0,0-1.7089844,9.8540039,1.1989746,15.5299988     c2.5980225,5.0650024,4.2520142,6.1759949,4.2520142,6.1759949c-4.9539795-3.2690125-12.4439697-3.5509949-12.4439697-3.5509949     s2.6660156,10.7210083,9.0369873,15.6119995s16.1950073,3.7479858,16.1950073,3.7479858s6.460022-8.6000061,6.0100098-17.8649902     c-0.4489746-9.2650146-7.8079834-19.196991-7.8079834-19.196991s-2.9019775,6.019989-3.15802,10.5140076     c-1.8779907-4.6329956-13.2849731-10.9660034-13.2849731-10.9660034L710.6370239,390.2000122z"
      S.path ! A.d "M787.6370239,555.2700195l0.2650146,3.5369873c5.875,0.0549927,6.75-0.5300293,8.2559814,1.3220215     c1.4530029,1.6316528,3.800415,2.1245117,5.7869873,1.2150269c2.4066772-1.1138916,3.4681396-3.9575806,2.3800049-6.3759766     c-1.0949707-2.3989868-3.3259888-2.9199829-5.4749756-2.4959717c-1.3189697,0.2600098-2.1870117,1.3129883-3.3060303,1.8909912     c-2.1279907,1.1019897-7.9089966,0.90802-7.9089966,0.90802L787.6370239,555.2700195z"
      S.path ! A.d "M787.1270142,552.5700073l2.8590088,2.0949707c-3.0670166,5.0139771-4.0239868,5.4459839-3.2509766,7.7050171     c0.6141968,2.0970459-0.2111816,4.3494263-2.0349731,5.5529785c-2.2196045,1.4508667-5.1934814,0.8453369-6.6690063-1.3579712     c-1.4539795-2.2000122-0.7150269-4.3660278,0.78302-5.9650269c0.9199829-0.9819946,2.2700195-1.1599731,3.3530273-1.8029785     c2.0620117-1.2230225,4.9589844-6.2280273,4.9589844-6.2280273L787.1270142,552.5700073z"
      S.path ! A.d "M767.2269897,510.5700073l0.2639771,3.5369873c5.8759766,0.0540161,6.75-0.5300293,8.2559814,1.3209839     c1.4532471,1.6312866,3.800415,2.1240845,5.7869873,1.2150269c2.4075317-1.1126099,3.4690552-3.9571533,2.3790283-6.375     c-1.0949707-2.3999939-3.3250122-2.9200134-5.473999-2.4960022c-1.3200073,0.2609863-2.1870117,1.3129883-3.3049927,1.8909912     c-2.1290283,1.1010132-7.9089966,0.9079895-7.9089966,0.9079895L767.2269897,510.5700073z"
      S.path ! A.d "M768.4169922,511.8200073l2.5,2.5170288c-3.809021,4.473999-4.8239746,4.7529907-4.4110107,7.1040039     c0.2817993,2.1676025-0.8842773,4.2651978-2.8740234,5.1699829c-2.4181519,1.0881348-5.2616577,0.0271606-6.3759766-2.3790283     c-1.0949707-2.3989868-0.0280151-4.4249878,1.7009888-5.7709961c1.0609741-0.8250122,2.4249878-0.7930298,3.5930176-1.2579956     c2.2269897-0.8870239,5.8670044-5.3819885,5.8670044-5.3819885V511.8200073z"
      S.path ! A.d "M747.4470215,468.7200012l0.2650146,3.5369873c5.8759766,0.0539856,6.75-0.5299988,8.257019,1.322998     c1.4545288,1.6299438,3.8014526,2.1217957,5.7880249,1.2130127c2.406189-1.1148682,3.4671021-3.9585571,2.3790283-6.3770142     c-1.0969849-2.3989868-3.3259888-2.9190063-5.4760132-2.4949951c-1.3200073,0.2609863-2.1870117,1.3129883-3.3060303,1.8909912     c-2.1279907,1.1019897-7.90802,0.9070129-7.90802,0.9070129L747.4470215,468.7200012z"
      S.path ! A.d "M749.0770264,467.980011l2.4990234,2.5159912c-3.809021,4.4750061-4.8220215,4.7539978-4.4110107,7.105011     c0.2814941,2.1669922-0.8840332,4.2639771-2.8729858,5.1690063c-2.4181519,1.0873108-5.2610474,0.0265808-6.3759766-2.3789978     c-1.0939941-2.3999939-0.0269775-4.4259949,1.7009888-5.7709961c1.0609741-0.8269958,2.4240112-0.7929993,3.5939941-1.2600098     c2.2269897-0.8869934,5.8660278-5.3800049,5.8660278-5.3800049H749.0770264z"
      S.path ! A.d "M726.3770142,424.5400085l0.2639771,3.5360107c5.8759766,0.0549927,6.7509766-0.5299988,8.2559814,1.3210144     c1.4535522,1.6312866,3.8005981,2.1247864,5.7880249,1.2170105c2.4066162-1.114502,3.4679565-3.9582825,2.3800049-6.3770142     c-1.0949707-2.3999939-3.3259888-2.92099-5.4760132-2.4960022c-1.3179932,0.2609863-2.1859741,1.3139954-3.3049927,1.8909912     c-2.1279907,1.1010132-7.9089966,0.9079895-7.9089966,0.9079895H726.3770142z"
      S.path ! A.d "M728.007019,423.7999878l2.4979858,2.5169983c-3.8079834,4.4750061-4.822998,4.7529907-4.4099731,7.105011     c0.2810059,2.1669006-0.8843384,4.2636108-2.8729858,5.1690063c-2.4178467,1.0887146-5.2614746,0.0275574-6.375-2.3789978     c-1.0960083-2.3989868-0.0280151-4.427002,1.6989746-5.7709961c1.0620117-0.8250122,2.4249878-0.7929993,3.5939941-1.2600098     c2.2260132-0.8859863,5.8660278-5.3800049,5.8660278-5.3800049L728.007019,423.7999878z"
      S.g
        ! A.fill "#FFD200"
        $ do
          S.polygon ! A.points "807.4860229,597.0620117 817.5349731,602.5440063 815.0969849,613.7269897      805.0479736,608.2449951"
          S.path ! A.d "M763.4970093,500.0899963c-2.1060181,0.8739929-5.2299805-8.2950134-7.5239868-13.3179932     c-2.3530273-5.1549988-7.1309814-13.1000061-5.7739868-13.7200012c1.4890137-0.6799927,3.4509888,3.4920044,5.8590088,8.7669983     c2.40802,5.2730103,9.4119873,17.4490051,7.4390259,18.2690125L763.4970093,500.0899963z"
          S.path ! A.d "M741.8670044,451.7999878c-2.1049805,0.8770142-4.4099731-5.1270142-6.7030029-10.151001     c-2.3530273-5.1539917-4.6450195-8.7950134-3.2880249-9.4150085c1.4899902-0.6799927,3.6900024,3.8370056,5.6160278,8.0549927     c1.8660278,4.0880127,6.3480225,10.6900024,4.3740234,11.5119934L741.8670044,451.7999878z"
          S.path ! A.d "M791.9069824,561.289978c-1.6530151,0.4420166-8.8690186-14.6619873-14.7030029-27.4420166     c-5.8330078-12.7789917-10.177002-23.118988-8.8200073-23.7359924     c1.4899902-0.6809998,6.2130127,11.3910217,12.0490112,24.1720276     c5.835022,12.7810059,12.7130127,26.6729736,11.4749756,27.0059814H791.9069824z"
          S.circle ! A.r "2.6" ! A.cx "799.9" ! A.cy "556.9"
          S.circle ! A.r "2.6" ! A.cx "782.0" ! A.cy "563.9"
          S.circle ! A.r "2.6" ! A.cx "779.5" ! A.cy "512.2"
          S.circle ! A.r "2.6" ! A.cx "761.6" ! A.cy "522.2"
          S.circle ! A.r "2.6" ! A.cx "759.7" ! A.cy "470.4"
          S.circle ! A.r "2.6" ! A.cx "742.2" ! A.cy "478.4"
          S.circle ! A.r "2.6" ! A.cx "738.7" ! A.cy "426.2"
          S.circle ! A.r "2.6" ! A.cx "721.2" ! A.cy "434.2"
      S.g
        ! A.fill "#007A50"
        $ do
          S.path ! A.d "M713.5369873,396.1900024c0,0-0.2550049,7.2009888,2.1270142,11.2850037     c2.3829956,4.0859985,7.7039795,5.7149963,7.7039795,5.7149963s0.2540283-7.1990051-2.1279907-11.2829895     C718.8569946,397.8210144,713.5369873,396.1900024,713.5369873,396.1900024z"
          S.path ! A.d "M708.5570068,412.480011c0,0,6.2550049,0.3680115,9.867981,3.1359863     c3.6099854,2.7680054,5.0089722,8.5350037,5.0089722,8.5350037c-2.7799072,0.1459351-5.5233765-0.6842346-7.7559814-2.3469849     C712.0670166,419.0350037,708.5570068,412.480011,708.5570068,412.480011z"
          S.path ! A.d "M728.1870117,397.9400024c-1.2766724,3.145752-1.9026489,6.5176086-1.8400269,9.9119873     c0.2390137,5.1430054,3.2399902,10.9370117,3.2399902,10.9370117s2.7130127-6.1740112,2.473999-11.3179932     c-0.2379761-5.1430054-3.1469727-8.0750122-3.8740234-9.5310059H728.1870117z"
          S.path ! A.d "M717.6569824,444.2999878c2.0876465,2.7488403,4.7490234,5.0099182,7.7990112,6.6260071     c4.7280273,2.3370056,11.7730103,2.4240112,11.7730103,2.4240112c-2.2648315-2.8227844-5.0672607-5.1680603-8.2449951-6.8999939     c-4.7280273-2.3370056-11.3270264-2.1520081-11.3270264-2.1520081V444.2999878z"
          S.path ! A.d "M719.177002,454.2600098c0,0,2.257019,4.42099,6.3839722,6.3160095     c4.1290283,1.8959961,12.5739746,1.7399902,12.5739746,1.7399902c-2.0184326-2.491272-4.526001-4.5424805-7.367981-6.0270081     c-4.1279907-1.8970032-11.5910034-2.0289917-11.5910034-2.0289917H719.177002z"
          S.path ! A.d "M742.9470215,430.6799927c-1.5037231,2.6387024-2.2804565,5.6290894-2.2509766,8.6660156     c0.2449951,4.5450134,3.2269897,9.5109863,3.2269897,9.5109863s2.0969849-5.6929932,1.8519897-10.2369995     c-0.2091675-2.8534851-1.1867065-5.5971375-2.8289795-7.9400024H742.9470215z"
          S.path ! A.d "M752.1370239,436.5100098c0,0-4.2689819,5.730011-4.882019,11.6210022     c-0.6129761,5.8900146,2.4279785,11.9419861,2.4279785,11.9419861s5.1569824-5.178009,5.7700195-11.0679932     c0.6129761-5.8919983-3.315979-12.4930115-3.315979-12.4930115V436.5100098z"
          S.path ! A.d "M740.3670044,490.9100037c0.4702759,1.592865,1.2509155,3.0769958,2.2969971,4.3670044     c1.4571533,1.697937,3.0769043,3.2492981,4.8359985,4.6319885c2.1609497-0.5793457,4.4292603-0.6324768,6.6149902-0.1549988     c3.664978,0.7950134,8.539978,4.0599976,8.539978,4.0599976s-5.2470093-7.8309937-10.6950073-10.8760071     c-3.5682373-1.836853-7.6109619-2.5445251-11.5910034-2.0289917L740.3670044,490.9100037z"
          S.path ! A.d "M739.8270264,504.3699951c0,0,6.7930298-2.9020081,12.3870239-2.1530151     c5.5949707,0.7489929,10.6389771,5.17099,10.6389771,5.17099s-7.5609741,2.6159973-13.1550293,1.8680115     c-3.6863403-0.6628113-7.109314-2.3569336-9.8720093-4.8859863H739.8270264z"
          S.path ! A.d "M768.5369873,472.7900085c0,0-6.007019,6.3640137-6.5109863,11.8869934     c-0.5029907,5.5220032,4.8709717,10.6690063,4.8709717,10.6690063c-0.1424561-1.9819946,0.081604-3.9732361,0.6610107-5.8739929     c0.765625-1.7185059,1.7370605-3.337677,2.8930054-4.821991c0.4758301-1.663269,0.6499023-3.3983459,0.5139771-5.1229858     c-0.4595337-2.3567505-1.2783813-4.6289368-2.4279785-6.7369995V472.7900085z"
          S.path ! A.d "M777.1569824,480.1600037c0,0-5.6619873,5.7290039-7.15802,11.8640137     c-1.4970093,6.1350098,1.1699829,12.6759949,1.1699829,12.6759949s5.1489868-4.0620117,6.6459961-10.1960144     c1.4970093-6.1350098-0.6589966-14.3439941-0.6589966-14.3439941H777.1569824z"
          S.path ! A.d "M791.3369751,517.1400146c1.4779663,3.1306152,2.5580444,6.43396,3.2150269,9.8330078     C795.2039795,531.4500122,794.5999756,533,794.5999756,533s-2.6519775,2.6069946-3.8410034,4.1400146     c-1.5280151,1.9699707-1.7520142,5.5759888-1.7520142,5.5759888s-5.3250122-7.9160156-4.5040283-13.7030029     c0.8200073-5.7860107,6.8339844-11.8740234,6.8339844-11.8740234L791.3369751,517.1400146z"
          S.path ! A.d "M802.5570068,529.5300293c0,0-6.8179932,4.5029907-9.5230103,9.1229858     c-1.6095581,2.8364868-2.0759277,6.1802979-1.3040161,9.348999c3.15625-0.4487915,5.9387817-2.3045654,7.565979-5.0460205     c2.7059937-4.617981,3.2600098-13.427002,3.2600098-13.427002L802.5570068,529.5300293z"
          S.path ! A.d "M757.757019,548.5499878c0,0,9.8259888-0.2680054,15.8319702,1.2089844     c6.0059814,1.4749756,8.1920166,4.6950073,8.1920166,4.6950073s-6.7529907,3.1619873-12.7589722,1.6859741     c-6.0059814-1.4749756-11.2659912-7.5910034-11.2659912-7.5910034L757.757019,548.5499878z"
          S.path ! A.d "M756.0969849,536.8900146c0,0,4.4329834,6.8729858,10.1640015,9.3670044     c7.8980103,3.4349976,17.0429688,1.7700195,17.0429688,1.7700195s-4.9680176-6.0889893-11.8040161-8.7769775     c-6.8380127-2.6870117-15.4030151-2.3590088-15.4030151-2.3590088L756.0969849,536.8900146z"
    S.g $ do
      S.path
        ! A.d "M1092.5169678,401.9440002l1.2810059,2.7120056c-1.2730713,0.4776611-2.3410645,1.3820496-3.0219727,2.5589905    c-0.9399414,1.8469849,0.6149902,4.4549866,0.6149902,4.4549866s-10.8039551-0.9429932-12.4909668,0.1539917    c-1.5279541,0.9899902,0.6469727,8.473999-0.3590088,14.7950134c-1.4019775,8.8099976-4.875,8.0700073-5.0169678,9.7770081    c-0.1379395,1.6589966,1.3310547,4.2489929,1.3310547,4.2489929s-2.026001,0.6380005-2.4580078,1.4849854    c-0.6949463,1.3619995,0.4840088,3.875-0.3580322,5.5279846c-4.6999512,9.2229919-11.6400146,22.8359985-16.2280273,31.8429871    c-0.6409912,1.2569885-2.3630371,1.7369995-3.2259521,3.4299927c-0.4542236,1.2315674-0.5078125,2.5751953-0.1529541,3.8389893    c0,0-3.0410156,0.1820068-4.0959473,2.2529907c-0.6641846,1.6391907-0.824707,3.4391479-0.4610596,5.1700134    c-1.2290039,0.2188721-2.2877197,0.9937439-2.868042,2.098999c-1.0090332,1.9809875,0.6999512,3.019989,0.2590332,3.8909912    c-6.1689453,12.1019897-13.43396,26.367981-17.8669434,35.0679932    c-1.6309814,3.1989746-7.3380127,3.8400269-10.6500244,10.3410034c-1.8952026,3.5778198-1.3424072,7.960022,1.382019,10.9550171    c0,0-4.7719727,0.4320068-6.039978,2.9190063c-1.2919922,2.5349731-0.2700195,6.3839722,3.1740112,8.1389771    c3.4439697,1.7540283,7.2069702,0.3339844,8.5-2.2009888c1.2670288-2.4869995-1.2810059-6.6040039-1.2810059-6.6040039    c4.0319214,0.4074097,7.8915405-1.7371826,9.6751099-5.3759766c3.3129883-6.5009766,0.5200195-11.440979,2.1500244-14.6409912    c4.43396-8.7000122,11.6999512-22.9650269,17.8669434-35.0679932c0.4449463-0.8710022,2.2669678-0.1170044,3.276001-2.0979919    c0.553833-1.1122131,0.553833-2.4197998,0-3.5320129c1.6247559-0.7284241,2.9970703-1.9224548,3.9429932-3.4309998    c1.0560303-2.0710144-0.5629883-4.6579895-0.5629883-4.6579895c1.232666-0.4412231,2.2912598-1.2663269,3.0200195-2.3540039    c0.8620605-1.6929932,0.2280273-3.3500061,0.8690186-4.6090088c4.5899658-9.006012,11.5310059-22.6199951,16.2290039-31.8410034    c0.8430176-1.6549988,3.5550537-2.2210083,4.2490234-3.5849915c0.4320068-0.8460083-0.2550049-2.8659973-0.2550049-2.8659973    s2.9880371-0.29599,4.2480469-1.3829956c1.2979736-1.1180115-1.3370361-3.5159912,4.967041-9.82901    c4.5219727-4.5279846,11.8170166-7.1919861,11.7220459-9.0100098c-0.1049805-2.0100098-7.2180176-10.1870117-7.2180176-10.1870117    s3.0009766-0.2529907,3.9420166-2.0979919c0.5534668-1.2576904,0.6619873-2.6663208,0.3079834-3.993988l2.9680176-0.5119934    l0.0004883-14.0780029L1092.5169678,401.9440002z M994.3809814,598.0180054c-0.4897461,0.982666-0.4897461,2.1383057,0,3.1209717    c0,0-3.5830078-1.1199951-4.8120117-0.5120239c-1.15802,0.572998,0,17.4580078,0,17.4580078    s14.2949829-9.0180054,14.0770264-10.289978c-0.2299805-1.3519897-3.2249756-3.6350098-3.2249756-3.6350098    c1.0731201-0.1651001,2.0042114-0.8297119,2.5089722-1.7910156c0.4699707-0.9249878,0.53302-3.5679932-2.7139893-5.2230225    c-0.9677124-0.5378418-2.0695801-0.786377-3.1744995-0.7160034c-1.0908813,0.0698853-2.0812378,0.6610107-2.6605225,1.5880127    V598.0180054z"
      S.g
        ! A.fill "#FFD200"
        $ do
          S.path ! A.d "M1095.1169434,402.5100098l6.756958,3.4309998l-0.1009521-8.1405029L1095.1169434,402.5100098z"
          S.path ! A.d "M1092.506958,407.4249878c-1.1911621,1.7985535-0.6988525,4.222229,1.0997314,5.4134216     c1.7984619,1.1911926,4.222168,0.6988525,5.4133301-1.0996704c1.1912842-1.7985535,0.6988525-4.222229-1.0996094-5.4134216     c-0.1275635-0.0844727-0.2598877-0.161377-0.3964844-0.2303162c-0.6782227-0.3511658-1.4393311-0.5107117-2.2015381-0.4614868     c-1.1901855,0.0545349-2.2619629,0.7365417-2.8155518,1.7915039L1092.506958,407.4249878z"
          S.path ! A.d "M1080.8869629,413.6199951c-0.7110596,0.4599915,0.2559814,6.5450134,0.0510254,11.7219849     c-0.1939697,4.8819885-1.7559814,6.2569885-2.6109619,7.9349976c-0.7889404,1.5490112-3.6340332,3.3789978-3.6340332,3.3789978     l2.3540039,2.355011c0,0,1.5319824-2.3859863,3.9420166-7.1180115c2.8430176-5.57901,2.7509766-15.6879883,3.5849609-16.2269897     c2.1818848-0.7675171,4.4034424-1.4171143,6.6550293-1.9460144c-0.0009766,0-5.4420166-0.2940063-8.4470215-0.2544861     C1082.1461182,413.426239,1081.5080566,413.4782715,1080.8869629,413.6199951z"
          S.path ! A.d "M1081.506958,441.7250061c1.0411377-2.5870972,2.220459-5.1164246,3.532959-7.5769958     c3.3110352-6.4989929,10.3790283-11.2130127,10.5439453-12.3890076c0.1719971-1.2120056-2.456543-6.9104919-2.456543-6.9104919     s-6.2354736,1.1954956-7.1175537,2.0484924c-0.8520508,0.822998-0.4759521,9.2669983-3.7879639,15.7669983     c-1.2303467,2.5295715-2.5970459,4.990509-4.0939941,7.3720093L1081.506958,441.7250061z"
          S.path ! A.d "M1097.427002,422.2200012c0.052002,0.9890137-8.1629639,6.8609924-11.006958,12.4389954     c-2.4100342,4.7309875-3.4300537,7.3729858-3.4300537,7.3729858l3.2769775,0.5119934     c0,0-0.2259521-3.3670044,0.5629883-4.9150085c0.8540039-1.677002,1.0789795-3.7309875,4.9150391-6.7569885     c4.0679932-3.2090149,9.5670166-6.0140076,9.5219727-6.8609924c-0.0410156-0.7820129-6.1435547-8.3439941-6.1435547-8.3439941     c0.881958,2.1425171,1.6508789,4.3298645,2.3034668,6.553009H1097.427002z"
          S.path ! A.d "M1073.3669434,458.7200012c4.9360352-9.6879883,6.4439697-10.3479919,7.0649414-11.5690002     c0.6689453-1.3120117,0.5090332-3.0780029-1.6889648-4.1990051c-0.6549072-0.3632507-1.4033203-0.5230713-2.1495361-0.4590149     c-0.9581299,0.1138916-1.7900391,0.7132263-2.2015381,1.5859985c-0.6219482,1.2219849-0.2850342,2.855011-5.2230225,12.5440063     l-11.2120361,21.9609985c-0.6446533,1.114624-0.2635498,2.5407715,0.8510742,3.1853638c0,0.0000305,0,0.0000305,0,0.0000305l0,0     c0.0563965,0.0325928,0.1140137,0.0627747,0.1729736,0.0905762c1.0786133,0.6039429,2.442749,0.2191162,3.0466309-0.8595276     c0.0483398-0.0862427,0.0908203-0.1755981,0.1273193-0.2674866L1073.3669434,458.7200012z"
          S.path ! A.d "M1053.5570068,483.9079895c-0.6109619,1.2009888,0.4360352,2.9639893,2.3549805,3.9429932     c1.9189453,0.9760132,3.9959717,0.7909851,4.6070557-0.4100037c0.6109619-1.2000122-0.4859619-2.9639893-2.4060059-3.9429932     c-0.8470459-0.4561157-1.8040771-0.668335-2.7645264-0.6130066     C1054.6136475,482.88974,1053.9345703,483.2775269,1053.5570068,483.9079895z"
          S.path ! A.d "M1049.4069824,490.1530151c-0.7919922,1.553009,0.4429932,3.7829895,2.7650146,4.9679871     c2.3220215,1.1830139,4.8399658,0.8859863,5.6309814-0.6669922c0.7919922-1.5539856-0.4439697-3.7820129-2.7650146-4.9670105     c-0.7927246-0.4174194-1.6651611-0.6614685-2.5594482-0.7160034c-1.2058105-0.1780396-2.4050293,0.3615417-3.0715332,1.3819885     V490.1530151z"
          S.path ! A.d "M1046.7969971,497.1170044c-0.6109619,1.1990051,0.4370117,2.9630127,2.3549805,3.9410095     c1.9189453,0.9779968,3.9949951,0.7909851,4.6080322-0.4089966c0.6109619-1.2000122-0.4370117-2.9639893-2.3549805-3.9419861     c-0.8651123-0.4572754-1.838623-0.6699219-2.8155518-0.6149902c-0.7353516,0.0056152-1.4146729,0.394043-1.7924805,1.0249939     V497.1170044z"
          S.path ! A.d "M1045.1070557,503.7720032c0,0-12.447998,24.4999695-16.8399658,33.1210022     c-1.4040527,2.7540283-7.3120117,4.4699707-9.625,9.0109863c-2.3300171,4.5679932-0.6859741,8.8439941,2.3540039,10.3920288     c3.0389404,1.5490112,7.5019531,0.4229736,9.8299561-4.1459961c2.3129883-4.539978,0.2349854-10.3530273,1.6369629-13.1060181     c4.3929443-8.6240234,16.8430176-33.1220093,16.8430176-33.1220093c0.6628418-1.0828247,0.3223877-2.4979553-0.760498-3.1607971     c-0.0687256-0.0420837-0.1396484-0.0805664-0.2125244-0.1152039c-0.4390869-0.2332458-0.9403076-0.3226013-1.4329834-0.2554932     C1046.1213379,502.5498962,1045.4597168,503.0596619,1045.1070557,503.7720032z"
          S.path ! A.d "M1013.6170044,560.6459961c-0.9329834,1.8300171,0.1339722,4.2689819,2.4050293,5.4260254     c2.2719727,1.15802,4.9039917,0.6010132,5.8369751-1.2280273c0.9329834-1.8300171-0.1859741-4.2700195-2.4569702-5.427002     c-0.7880249-0.4168091-1.6686401-0.6278687-2.5599976-0.6135254c-1.3318481-0.0250244-2.5701294,0.6824951-3.2249756,1.8425293     H1013.6170044z"
          S.path ! A.d "M997.0339966,598.0689697c-0.6033325-0.0541992-1.1893311,0.2195435-1.5349731,0.71698     c-0.4769897,0.9349976,0.5079956,2.4130249,2.2009888,3.276001c1.6929932,0.8619995,3.4639893,0.7819824,3.9420166-0.1539917     c0.4769897-0.9370117-0.5100098-2.4140015-2.2009888-3.276001c-0.7422485-0.387146-1.5700073-0.5811768-2.4069824-0.5640259     L997.0339966,598.0689697z"
          S.path ! A.d "M991.197998,602.6749878v12.0819702l9.8300171-7.0650024     c-2.1365356-3.3179932-5.8895874-5.2338257-9.8300171-5.0180054V602.6749878z"
    S.g $ do
      S.path
        ! A.fill "#FFD200"
        ! A.d "M997.4199829,333.5969849c0-6.6260071,8.7030029-13.1570129,8.7030029-13.1570129H793.8770142    c0,0,8.7030029,6.5299988,8.7030029,13.1570129v157.9860229c-0.0759888,3.471283,1.1060181,6.8529358,3.3280029,9.5209961    c2.0410156,2.8529968,6.3900146,6.7950134,10.9030151,9.7269897c13.9400024,9.0529785,37.2459717,18.598999,54.8800049,26.6209717    c14.6939697,6.684021,20.6710205,9.3809814,28.309021,18.8389893    c7.6389771-9.4580078,13.6669922-12.1539917,28.3610229-18.8389893    c17.6309814-8.0209961,40.9379883-17.5679932,54.8790283-26.6210022    c4.5150146-2.9320068,8.8640137-6.8729858,10.9039917-9.7269897c2.2055054-2.6741638,3.3690796-6.0559387,3.276001-9.5209961    L997.4199829,333.5969849z"
      S.path
        ! A.fill "#CC092F"
        ! A.d "M807.5969849,422.9809875v-89.3849792    c0.0477905-2.9183044-0.8504639-5.7736816-2.5604858-8.1390076h189.9279785    c-1.7095337,2.3655396-2.607605,5.2207947-2.5599976,8.1390076l0.0540161,89.3850098l-92.430481,28L807.5969849,422.9809875z"
      S.path
        ! A.fill "#0046AE"
        ! A.d "M992.4580078,422.9809875l-57.2340088-1.0750122h-70.3930054l-57.2340088,1.0750122v68.6009827    c0,3.447998,3.5780029,11.5249939,24.2150269,21.8070068c34.1110229,16.9979858,60.3300171,24.934021,68.1890259,34.6069946    c7.8579712-9.6729736,34.0770264-17.6099854,68.1890259-34.6069946    c20.6359863-10.2820129,24.2139893-18.3590088,24.2139893-21.8070068L992.4580078,422.9809875z"
      S.path
        ! A.d "M1001.9736938,322.0173645H798.0264282c2.7045898,2.7234802,6.1381226,7.0669861,6.1381226,11.5689087    v137.2012024h-0.0062866v20.7860107h0.0062866c-0.0306396,1.6276855,0.2312622,3.2476196,0.7731323,4.7827454    c0.5249634,1.3611145,1.2562866,2.6333313,2.1682129,3.7720032l0.0369263,0.0494995    c1.9884033,2.5337524,4.2980957,4.7980347,6.8707886,6.7357788c0.5814209,0.4555054,1.1763306,0.902771,1.7757568,1.3330078    c0.5822754,0.4176636,1.1915894,0.8343201,1.8180542,1.2411499l0.0144043,0.0098877    c10.8533936,7.0462646,27.5739746,14.4552612,42.7655029,21.1838379    c4.2355347,1.8764648,8.3666382,3.7062378,11.8956299,5.3118896l0.0062866,0.0063477v-0.0008545l0.3375244,0.1530151h0.0053711    c13.9053345,6.3253784,20.1056519,9.1478271,27.3670044,17.6512451    c7.2811279-8.5349121,13.4615479-11.3465576,27.494751-17.7295532l-0.0008545-0.0018311l0.1602173-0.072876    c3.5371094-1.6091919,7.6600952-3.4353638,11.8956299-5.3109741c15.1923828-6.7294922,31.9147949-14.1384888,42.770874-21.1856689    l0.0089722-0.0063171c3.0452271-1.9810791,5.8646851-4.2892761,8.40802-6.8833923    c0.4141235-0.4311218,0.8029175-0.8595276,1.1557007-1.2753296c0.3312378-0.3897095,0.637207-0.7793884,0.9081421-1.1583252    l0.024292-0.024292l0.0053711-0.0072021l0.0126343-0.0188904c0.918396-1.1444092,1.6598511-2.420166,2.199646-3.7846069    c0.5542603-1.5280457,0.822998-3.144928,0.7929077-4.7701111h0.0062866v-20.7860107h-0.0062866V333.5863647    c0-4.5019226,3.4335327-8.8454285,6.1381226-11.5689087L1001.9736938,322.0173645z M999.0106201,333.5862732v137.2012634    h-0.0062866v20.7860107h0.0062866c0.02948,2.0069885-0.3106689,4.0022888-1.00354,5.8861389    c-0.644165,1.6444397-1.5308838,3.183136-2.6307373,4.5649414l0.0036011,0.0026855    c-0.2997437,0.4185486-0.65979,0.8748779-1.0683594,1.3563538c-0.387085,0.4553833-0.8218384,0.9342346-1.2924805,1.4247437    c-2.7120361,2.7670898-5.7185669,5.229187-8.9660645,7.3424072l-0.0089722,0.0063477    c-11.0927734,7.2010498-27.9250488,14.6586914-43.2172852,21.432251    c-4.0024414,1.7721558-7.8986206,3.4983521-11.8596191,5.3002319l-0.1602173,0.072876h-0.0053711    c-14.3347168,6.5206299-20.1983032,9.187439-27.567688,18.3136597L900,558.8035278l-1.2338867-1.5273438    c-7.3378906-9.0848389-13.2348633-11.7677612-27.447998-18.2335205l0.0008545-0.0018311l-0.3330078-0.1512451    l-0.0116577-0.0062866l-0.0045166-0.0018311l-0.0008545,0.0026855c-3.9699707-1.8063965-7.8580933-3.5281372-11.8596191-5.3011475    c-15.2922363-6.7736206-32.1245117-14.2312012-43.2145996-21.432251l-0.0369263-0.0252075l-0.0116577-0.0080566    l0.0008545-0.0008545c-0.6246948-0.4058838-1.2645874-0.8424072-1.906311-1.3032227    c-0.6381226-0.4580994-1.2662964-0.9297485-1.8747559-1.4067383c-2.8126831-2.1264343-5.3349609-4.6117859-7.5026245-7.3927917    h0.0008545c-1.0966187-1.3799438-1.9747314-2.9201355-2.6036987-4.5666809    c-0.6734009-1.883728-1.0023804-3.873291-0.9711304-5.8735352h0.0062866v-20.7860107h-0.0062866V333.5863647    c0-5.8411865-8.041626-11.8739929-8.0641479-11.8911133v-2.8530884h214.1496582v2.8530884    c-0.0223999,0.0171204-8.0641479,6.0499878-8.0641479,11.8911133L999.0106201,333.5862732z M994.2073975,323.8651733    l0.0053711-0.0062866h0.7542114l3.2866821-0.0014648l-2.0536499,2.575592    c-1.4915771,2.0821533-2.2658081,4.592804-2.2059937,7.1533813v137.2012024h-0.0062256v20.7860107h0.0062866    c0,2.8108215-1.9675293,8.2388-11.2322998,15.004303l0.00177,0.0026855    c-1.7316284,1.2654419-3.7323608,2.589386-6.0337524,3.9628296c-2.3167114,1.3824463-4.9086914,2.8017273-7.7987061,4.2427063    l-0.0027466-0.0053711l-0.0296631,0.0153198v0.0063477c-12.3780518,6.1678467-23.8092651,11.1818237-33.678894,15.5100708    c-16.9501343,7.4332886-29.2282104,12.8181763-33.9866333,18.6691895l-0.024292,0.0314941l-0.0053711,0.0063477    l-1.2357788,1.4400024l-1.1953125-1.4715576c-4.7565308-5.8546143-17.038269-11.2421875-33.996521-18.6781616    c-9.8624878-4.324585-21.2838135-9.335022-33.651001-15.4956665v-0.0063477l-0.0206299-0.0108032l-0.0027466,0.0053711    c-8.7752686-4.3714294-14.5470581-8.381012-18.2965698-11.8245239c-0.7401733-0.6834106-1.4058228-1.3428345-1.9971313-1.978241    c-3.809021-4.0932922-4.7935791-7.3999939-4.7953491-9.4205322h-0.0062866V491.5737h0.0062866v-20.7860107h-0.0062866V333.5863953    c0.0597534-2.5605774-0.7144775-5.0711975-2.2059937-7.1533813l-2.053833-2.5677795h6.8203735v-0.0062256h182.8674927v0.0062866    h2.7730103L994.2073975,323.8651733z M991.4338989,327.0278931v0.0062866H808.5664063v-0.0062866h-0.7902832    c0.928772,2.061554,1.4077759,4.2973328,1.4050293,6.5584717v137.2012634h-0.0062866v20.7860107h0.0062866v0.0054016h-0.0062866    c0.0008545,1.4274292,0.8126831,3.8880005,3.9528809,7.2622375c0.539978,0.5795898,1.1466675,1.1835327,1.8225708,1.8054199    c3.5479126,3.2599182,9.0749512,7.0859375,17.5657349,11.3151245v0.0063171l0.0206299,0.0108337l0.0027466-0.0053711    c12.4401245,6.1975403,23.7417603,11.1548767,33.5015869,15.4344788    c16.1347046,7.0751343,28.1338501,12.3375854,33.9578247,18.2210083    c5.8250122-5.8825684,17.8250122-11.144104,33.9552002-18.2182617c9.7670898-4.2831421,21.0794678-9.2449951,33.52948-15.4488525    l0.0027466,0.0053711l0.0296631-0.0153198v-0.0063171c2.880127-1.4354858,5.3965454-2.8107605,7.5881348-4.1184998    c2.2068481-1.3167419,4.1266479-2.5875549,5.7871704-3.8008118h0.0053711    c8.1838989-5.9743347,9.921875-10.3016357,9.921875-12.4526978h0.0062866v-20.7860107h-0.0062866V333.5863953    c-0.0027466-2.2611389,0.4762573-4.4969177,1.4050293-6.5584717h-0.7893066L991.4338989,327.0278931z"
      S.g $ do
        S.path ! A.d "M933.8400269,419.401001c0,0,33.0189819-8.3259888,33.0189819-43.6170044     c0-27.5629883-33.1030273-41.2369995-34.0440063-47.8139954c-3.2349854,11.381012,11.0579834,27.1000061,11.0579834,45.7149963     c0,24.0859985-17.7639771,25.2390137-17.7639771,25.2390137c-4.1569824,0-5.8410034,2.9679871-7.4749756,2.9679871     c-3.4970093-0.3649902-5.1430054-4.8129883-8.6010132-4.8129883c-3.2470093,0-5.7399902,5.0169983-10.03302,5.0169983     c-4.2919922,0-6.7349854-5.0169983-9.9829712-5.0169983c-3.4559937,0-5.1030273,4.447998-8.5999756,4.8129883     c-1.6339722,0-3.3189697-2.9679871-7.4760132-2.9679871c0,0-17.7630005-1.1530151-17.7630005-25.2390137     c0-18.6149902,14.2949829-34.3359985,11.0579834-45.7149963c-0.9379883,6.5769958-34.0410156,20.25-34.0410156,47.8139954     c0,35.2910156,33.0189819,43.6170044,33.0189819,43.6170044l-9.4199829,17.1489868     c0,0,13.6450195,0.6830139,20.8870239,6.8609924c8.7329712,7.447998,7.8829956,23.2290039,7.8829956,34.7090149     c0,9.0450134-1.1430054,18.5899963-5.7839966,22.5239868c-6.2319946,5.2839966-10.4450073,5.6749878-10.4450073,11.8779907     c0,5.1740112,3.9769897,6.2109985,10.4450073,9.625c8.2869873,4.3729858,7.901001,10.2379761,20.2199707,10.2379761     c12.3209839,0,11.9849854-5.8640137,20.2730103-10.2379761c6.4680176-3.4140015,10.4440308-4.4509888,10.4440308-9.625     c0-6.2030029-4.2139893-6.5939941-10.4439697-11.8779907c-4.6409912-3.9360046-5.7839966-13.480011-5.7839966-22.5239868     c0-11.480011-0.848999-27.2609863,7.8829956-34.7089844c7.242981-6.177002,20.8859863-6.8609924,20.8870239-6.8609924     L933.8400269,419.401001z"
        S.path ! A.d "M899.9970093,330.4200134l-5.7349854,16.2810059l-15.6140137-7.4240112l7.4229736,15.6149902l-16.2789917,5.7839966     l16.2789917,5.7850037l-7.4229736,15.5629883l15.6140137-7.4230042l5.7349854,16.2789917l5.7849731-16.2789917     l15.6140137,7.4230042l-7.4219971-15.5629883l16.2789917-5.7850037l-16.2789917-5.7839966l7.4219971-15.6149902     l-15.6140137,7.4240112L899.9970093,330.4200134z"
        S.path ! A.d "M864.8270264,421.9100037c0,0-20.3870239-4.9840088-28.0020142-15.0509949     c-8.4763794,7.407196-18.4453735,12.9066467-29.2319946,16.1260071c0,0,16.6069946,7.4979858,29.2319946,17.0480042     c5.8170166-8.3359985,28.0020142-18.1229858,28.0020142-18.1229858V421.9100037z"
        S.path ! A.d "M935.21698,421.9100037c0,0,22.1859741,9.7860107,28.0040283,18.1229858     c12.6229858-9.5499878,29.2290039-17.0480042,29.2290039-17.0480042     c-10.7854614-3.2200317-20.7532959-8.7194214-29.2290039-16.1260071     c-7.6149902,10.0660095-28.0040283,15.0509949-28.0040283,15.0509949V421.9100037z"
        S.path ! A.d "M873.177002,443.6099854l-7.9349976,7.9339905l7.9349976,7.9349976l7.9349976-7.9349976L873.177002,443.6099854z"
        S.path ! A.d "M926.8770142,443.6099854l-7.934021,7.9339905l7.934021,7.9349976l7.9349976-7.9349976L926.8770142,443.6099854z"
        S.path ! A.d "M871.1799927,489.9400024c0.0931396,5.1203003-0.2319336,10.239624-0.9719849,15.3070068     c0,0,11.1859741-3.2929993,13.4140015-14.6409912c1.0440063-5.3200073,2.2069702-24.9179993-3.1749878-28.2590027     l-14.5894775-2.8670044c3.5289307,9.7673645,5.3300171,20.0746765,5.3225098,30.4599915H871.1799927z"
        S.path ! A.d "M919.6060181,462.3479919c-5.3809814,3.3399963-4.2180176,22.9379883-3.1740112,28.2590027     c2.2269897,11.3479919,13.4130249,14.6409912,13.4130249,14.6409912     c-0.7400513-5.0673828-1.0651245-10.1867065-0.9719849-15.3070068     c-0.0082397-10.3857422,1.7935181-20.6934509,5.3245239-30.4605103L919.6060181,462.3479919z"
        S.path ! A.d "M836.7819824,462.9150085c-4.9889526,1.1995544-8.0608521,6.2163086-6.8612671,11.2052612     c0.1984253,0.8254089,0.5090942,1.6197205,0.9232788,2.3607483c-0.7453003-0.250946-1.5195313-0.4058533-2.3040161-0.4609985     c-0.3237915-0.01651-0.6481934-0.01651-0.9719849,0c-5.1793213,0.2171326-9.2019653,4.5918274-8.9848022,9.7711487     c0.2171631,5.1792908,4.5918579,9.2019348,9.7711182,8.9848022c0.3883667-0.0162964,0.7753296-0.0566711,1.1586914-0.1209412     c-0.456543,0.6159668-0.8344727,1.2864685-1.125,1.9960022c-1.9616089,4.8105164,0.3479614,10.3003845,5.1584473,12.2619629     s10.300354-0.3479309,12.2619629-5.1584473l0.0355835-0.088501c0.2796631-0.707428,0.4691162-1.4472351,0.5640259-2.2019958     c0.4559937,0.6270752,0.9888306,1.1944885,1.5859985,1.6889954c3.9301147,3.3862915,9.8612671,2.9453735,13.2475586-0.9847717     s2.9453735-9.8612671-0.9847412-13.2475281c-0.6433105-0.5542603-1.3587646-1.0187378-2.1268311-1.3807373     c0.7369995-0.2356262,1.4417725-0.5621338,2.0980225-0.9719849c4.397522-2.7804871,5.7240601-8.5904541,2.9689941-13.0039978     c-1.8278809-2.9173889-5.114624-4.5901794-8.5490112-4.3510132c-1.5637817,0.1060486-3.0767212,0.5988159-4.4030151,1.4339905     c-0.6536865,0.4021606-1.255249,0.8834839-1.7910156,1.4330139c-0.0237427-5.2290344-4.2819824-9.448761-9.5110474-9.4249878     c-0.7279053,0.0032959-1.4530029,0.0905457-2.1608887,0.2599792H836.7819824z"
        S.path ! A.d "M936.6019897,490.25c1.0170288,9.5870056,8.8079834,17.618988,18.4290161,19.9140015     c-1.6694946-2.6869812-2.7189941-5.7123413-3.0720215-8.8559875     c-1.2050171-11.3699951,7.5880127-20.5809937,19.6069946-20.5809937     c1.8626099,0.0025024,3.7182617,0.2264099,5.5280151,0.6669922     c-4.4796143-7.2499695-12.3651123-11.6952209-20.8870239-11.7745056     C944.1890259,469.6199951,935.3939819,478.8819885,936.6019897,490.25z"
      S.g
        ! A.fill "#FFD200"
        $ do
          S.path ! A.d "M851.3690186,373.6839905c0,18.1279907,9.6669922,28.8210144,22.5759888,28.8210144     c2.4619751,0,5.1550293,3.3280029,7.4749756,3.3280029c3.7819824,0,6.2979736-4.197998,8.6010132-4.197998     c2.927002,0,4.9000244,4.6069946,9.9819946,4.6069946c5.0830078,0,7.1069946-4.6069946,10.0339966-4.6069946     c2.302002,0,4.8179932,4.197998,8.5999756,4.197998c2.3209839,0,5.0120239-3.3280029,7.4749756-3.3280029     c12.9089966,0,22.5770264-10.6929932,22.5770264-28.8209839c0-14.7839966-12.4160156-32.8099976-11.0579834-35.7340088     c0,0,24.2139893,17.368988,24.2139893,37.8320007c0,32.9630127-33.4290161,41.1090088-33.4290161,41.1090088     l7.5250244,16.9440002c0,0-10.3619995,1.5539856-16.6890259,6.6560059     c-8.4390259,6.8049927-8.5499878,25.1910095-8.5499878,37.6260071c0,14.6480103,0.5449829,20.855011,5.8369751,24.82901     c5.5800171,4.1929932,9.7769775,5.0960083,9.7769775,9.3690186c0,3.7230225-4.3449707,5.2459717-9.9829712,7.7299805     c-6.4130249,2.8270264-7.052002,7.7310181-16.3300171,7.7310181c-9.2789917,0-9.8670044-4.9039917-16.2800293-7.7310181     c-5.6370239-2.4840088-9.9829712-4.0059814-9.9829712-7.7299805c0-4.2730103,4.1970215-5.1759949,9.7769775-9.368988     c5.2919922-3.973999,5.8359985-10.1809998,5.8359985-24.82901c0-12.4349976-0.1099854-30.8209839-8.5490112-37.6260071     c-6.3280029-5.1040039-16.6890259-6.6560059-16.6890259-6.6560059l7.5239868-16.9440002     c0,0-33.4279785-8.144989-33.4279785-41.1090088c0-20.4630127,24.2150269-37.8320007,24.2150269-37.8320007     c1.3579712,2.9240112-11.0570068,20.9500122-11.0570068,35.7340088L851.3690186,373.6839905z M887.3569946,509.8099976     c-6.5670166,0-10.75,1.3859863-10.75,3.3790283c0,1.9940186,4.184021,3.3280029,10.75,3.3280029     c1.75,0,3.7369995-1.0189819,3.7369995-3.3280029c-0.0446777-1.9160156-1.6341553-3.433075-3.5501709-3.3883972     c-0.0623169,0.0014648-0.1245728,0.0045776-0.1868286,0.0093994V509.8099976z M912.6970215,509.8099976     c-1.9108887-0.1477966-3.5797729,1.2814941-3.7276001,3.1923828v0.000061     c-0.0048218,0.0620728-0.0079346,0.1242676-0.0093994,0.1865845c-0.0009766,2.309021,1.9869995,3.3280029,3.7369995,3.3280029     c6.5679932,0,10.75-1.3330078,10.75-3.3280029c0-1.993988-4.1829834-3.3789978-10.75-3.3789978V509.8099976z"
          S.path ! A.d "M900.0570068,341.3800049l3.6859741,10.3940125l9.9309692-4.7609863l-4.710022,9.9819946     l10.34198,3.6870117l-10.34198,3.6860046l4.710022,9.9309998l-9.9310303-4.7099915l-3.7369995,10.3410034l-3.6859741-10.3410034     l-9.9310303,4.7099915l4.710022-9.9309998l-10.3410034-3.6860046l10.3410034-3.6870117l-4.710022-9.9819946l9.9310303,4.7609863     l3.7369995-10.3940125H900.0570068z"
          S.path ! A.d "M817.3140259,423.2789917c0,0,12.6090088,6.2799988,18.9429932,11.8770142l0.3569946,0.3070068     l0.2039795-0.2550049c5.9860229-6.8710022,17.0980225-12.6960144,17.0980225-12.6960144     s-10.6760254-2.9450073-17.40448-10.6480103C829.4000244,419.1119995,817.3140259,423.2789917,817.3140259,423.2789917z"
          S.path ! A.d "M982.7249756,423.2950134c0,0-12.6090088,6.2799988-18.9429932,11.8770142l-0.3569946,0.3070068     l-0.2039795-0.2550049c-5.9860229-6.8710022-17.0980225-12.6960144-17.0980225-12.6960144     s10.6760254-2.9450073,17.40448-10.6480103C970.6389771,419.1279907,982.7249756,423.2950134,982.7249756,423.2950134z"
          S.path ! A.d "M873.177002,447.3999939l4.1469727,4.144989l-4.1469727,4.1990051l-4.197998-4.1990051     L873.177002,447.3999939z"
          S.path ! A.d "M926.8770142,447.3999939l4.1989746,4.144989l-4.1989746,4.1990051l-4.1459961-4.1990051     L926.8770142,447.3999939z"
          S.path ! A.d "M878.8099976,465.5190125c2.8969727,3.9979858,2.4050293,10.4620056,2.4050293,19.4549866     c0.1759644,5.1063538-2.4299927,9.9067993-6.8079834,12.5410156c0-21.7940063-2.2470093-27.0339966-3.4299927-33.634491     L878.8099976,465.5190125z"
          S.path ! A.d "M929.0770264,463.8800049c-1.1849976,6.6019897-3.4290161,11.8410034-3.4290161,33.6340027     c-4.378418-2.6339111-6.9848022-7.4344177-6.809021-12.5409851c0-8.9930115-0.4920044-15.4549866,2.4060059-19.45401     l7.8319702-1.6390076H929.0770264z"
          S.path ! A.d "M846.6090088,472.1279907c0.1877441,0.7877502,0.239502,1.6018066,0.1530151,2.4070129     c-0.0673828,0.6323242-0.222229,1.2522278-0.460022,1.8420105c-4.1018066-1.454071-8.6757202-0.2799683-11.5700073,2.9700012     c-0.5126953-0.4475708-0.9603882-0.9645691-1.3300171-1.5360107c-0.440918-0.657959-0.7697144-1.384491-0.9730225-2.1499939     c-0.972229-3.9165344,1.4146118-7.8796692,5.3311768-8.8518982c3.9117432-0.9710083,7.8710327,1.408844,8.8488159,5.3189087     L846.6090088,472.1279907z"
          S.path ! A.d "M857.5232544,485.7857361     c-0.6912231,0.4219971-1.4494019,0.7227783-2.2419434,0.8893433c-0.6221924,0.1312866-1.2595825,0.1756287-1.8939819,0.1317139     c0.1153564-4.3504028-2.4147339-8.3375854-6.4000244-10.0859375c0.2672729-0.6259155,0.6206055-1.2114258,1.0498657-1.7395935     c0.489502-0.6226807,1.0788574-1.1598816,1.7440796-1.5897827c3.4225464-2.1378784,7.9301758-1.0964355,10.0681152,2.3261414     c2.1378784,3.4225769,1.0963745,7.9302063-2.3261719,10.0680847L857.5232544,485.7857361z"
          S.path ! A.d "M847.9067383,500.386322     c-0.6149292-0.526947-1.1352539-1.1551208-1.5385742-1.8573608c-0.3171387-0.551178-0.5562134-1.1437073-0.7105103-1.7606201     c4.1731567-1.2346191,7.1833496-4.8729553,7.614624-9.2034607c0.6778564,0.06073,1.3438721,0.2158508,1.9788208,0.4608765     c0.7434692,0.2731323,1.4364624,0.6676331,2.0509033,1.16745c3.0841064,2.6024475,3.4746094,7.2123108,0.8721924,10.2964172     c-2.5928955,3.0728149-7.1811523,3.4734802-10.267395,0.8965759L847.9067383,500.386322z"
          S.path ! A.d "M831.0490112,495.7523193c0.3111572-0.7476501,0.7478027-1.436676,1.2910156-2.037262     c0.4262085-0.4719238,0.9158325-0.8824463,1.454895-1.2198181c2.4638062,3.5873718,6.854248,5.3259277,11.1060791,4.3978882     c0.1516724,0.6634521,0.2099609,1.3448486,0.1731567,2.0244141c-0.0300293,0.7914734-0.1911011,1.5725098-0.4765625,2.3113098     c-1.5146484,3.7403564-5.7747192,5.5446472-9.5150757,4.0299683c-3.7369995-1.5133057-5.5420532-5.7675781-4.0334473-9.5065002     H831.0490112z"
          S.path ! A.d "M830.2470093,478.2877502     c0.8071899,0.0648804,1.5974121,0.2672119,2.3364868,0.5982666c0.5805054,0.2595215,1.1222534,0.5983276,1.6096802,1.0067139     c-2.6504517,3.4517212-2.9472046,8.1645813-0.7506714,11.9215088c-0.5841064,0.3493042-1.2141113,0.6153259-1.8718262,0.7902832     c-0.7620239,0.2160034-1.5545654,0.3041992-2.345459,0.2609863c-4.0252686-0.285553-7.0569458-3.7801819-6.7714233-7.805481     c0.2852173-4.0204773,3.7722168-7.0506897,7.7932129-6.7722473V478.2877502z"
          S.circle ! A.cx "842.6" ! A.cy "486.4" ! A.r "7.0"
          S.path ! A.d "M966.7020264,476.9419861c-11.7290039,2.2680054-20.1699829,12.6279907-18.9420166,24.7269897     c-3.7379761-3.0960083-6.4730225-7.2659912-6.9619751-11.8770142     c-0.9509888-8.9790039,5.5709839-15.9219971,15.4094849-15.9219971c3.7150269,0.0334167,7.3479004,1.0968628,10.4945068,3.071991     V476.9419861z"



{- |
Flag of Montenegro coat of arms.
Drawn for a @viewbox 0 0 1200 600@
-}
meCoA :: Svg
meCoA =
  S.g
    ! A.transform (S.matrix 0.643 0 0 0.643 426.457 99.733)
    $ do
      S.path
        ! A.fill "#DE6F10"
        ! A.d "M314.9176 158.112c-6.506 3.595-10.22 2.794-9.953 5.457.267 2.664 6.1 4.66 6.1 4.66s-5.971 6.388-10.617 9.318c-4.64 2.928-10.089 4.789-10.089 4.789s-1.854.269-.793 3.196c1.064 2.928 2.921 4.922 4.378 5.723 1.461.797 2.26 1.065 2.26 1.065s-8.096 8.651-11.678 11.446c-3.585 2.795-5.575 3.724-8.493 4.925-2.921 1.198-1.457 5.987-.796 8.121.66 2.124 3.182 5.054 4.646 5.454 1.454.401 1.989 1.464.132 4.393-1.39 2.184-6.021 7.995-8.231 11.2l-.135.069c-2.193-3.183-6.888-9.068-8.284-11.269-1.858-2.929-1.327-3.992.133-4.393 1.461-.399 3.983-3.329 4.647-5.454.658-2.134 2.122-6.923-.802-8.121-2.917-1.201-4.908-2.13-8.49-4.925-3.584-2.797-11.679-11.446-11.679-11.446s.796-.268 2.255-1.065c1.463-.8 3.319-2.794 4.382-5.723 1.059-2.927-.798-3.196-.798-3.196s-5.439-1.861-10.085-4.789c-4.641-2.93-10.615-9.318-10.615-9.318s5.838-1.997 6.104-4.66c.266-2.663-3.451-1.862-9.953-5.457-6.502-3.593-8.626-8.118-8.626-8.118s7.564-2.529 11.281-10.115c1.315-2.686 1.631-5.14 1.491-7.191l.287.097c12.078 3.932 26.198 5.506 38.819 5.506 12.598 0 26.712-1.583 38.765-5.506l.285-.097c-.141 2.051.173 4.505 1.489 7.191 3.718 7.586 11.285 10.115 11.285 10.115s-2.122 4.526-8.622 8.118m-87.979-63.417c-1.893 1.58-5.278.635-7.879-.396-2.6-1.027-5.356-1.738-5.356-1.738s.63-.63 1.339-1.895c.709-1.262.709-3.399.157-6.953-.551-3.557-1.103-7.347-.551-9.401.551-2.058.474-4.268 4.175-8.458 3.704-4.186 9.926-7.106 9.926-7.106s-.79 1.338-2.285 4.182c-1.498 2.848-5.042 10.589-4.491 18.177.553 7.583 4.965 8.844 6.145 9.875 1.182 1.025.709 2.131-1.18 3.713m23.808-36.703c6.604-6.034 11.2-7.044 11.2-7.044-.303 6.683-1.508 11.995-2.424 18.197-1.084 7.378-.5 10.818.921 14.419 1.422 3.607 5.265 5.788 5.265 5.788s-1.252.167-3.177 1.173c-1.919 1.006-3.927 2.516-7.272 2.683-3.344.167-4.848-.755-7.02-2.266-2.175-1.508-4.599-2.511-4.599-2.511s1.087-2.601.835-5.534c-.249-2.934-1.837-6.626-1.837-9.643 0-3.022 1.505-9.227 8.108-15.262m32.19 25.571c1.419-3.601 2.004-7.041.917-14.419-.911-6.202-2.116-11.514-2.421-18.197 0 0 4.598 1.01 11.201 7.044 6.6 6.036 8.111 12.241 8.111 15.261 0 3.016-1.593 6.708-1.843 9.643-.25 2.933.835 5.534.835 5.534s-2.424 1.003-4.596 2.511c-2.172 1.511-3.676 2.433-7.02 2.266-3.348-.167-5.354-1.676-7.276-2.683-1.922-1.007-3.171-1.173-3.171-1.173s3.842-2.18 5.263-5.787m33.936-20.633c-1.493-2.843-2.283-4.182-2.283-4.182s6.224 2.92 9.926 7.106c3.702 4.19 3.62 6.4 4.173 8.458.552 2.054 0 5.844-.55 9.401-.553 3.553-.553 5.69.158 6.953.708 1.264 1.34 1.895 1.34 1.895s-2.762.711-5.36 1.738c-2.601 1.031-5.986 1.976-7.876.396-1.892-1.581-2.362-2.687-1.178-3.713 1.178-1.031 5.589-2.292 6.141-9.875.551-7.588-2.993-15.329-4.491-18.177m-133.248 357.363c-3.059 5.724-11.4 11.719-17.518 14.369-6.117 2.651-12.792 3.489-15.573 3.903-2.782.418-.417 3.767-.417 3.767l2.92 4.188s-.416 1.252-4.867 2.509c-4.45 1.252-9.871 2.229-14.46 3.486-4.59 1.252 1.252 5.019 3.892 6.418 2.643 1.39 1.947 2.927.556 4.32-1.39 1.396-6.533 4.323-9.174 5.16-2.643.838-2.228 2.237.414 3.351 2.642 1.11 9.872 2.506 9.872 2.506s-.139.279-4.587 3.63c-4.45 3.346-12.238 5.577-17.381 5.856-5.145.275-13.279.613-23.593.139-10.313-.471-11.499-.709-11.499-.709s-.355-3.442-1.068-8.539c-.711-5.096-3.79-12.328-6.162-15.646-2.374-3.321-7.35-9.959-7.35-9.959s.118-1.423.472-3.083c.354-1.66.116-3.438-1.088-6.57-1.206-3.136-7.23-7.712-7.23-7.712s-.242-3.373-.242-6.509c0-3.132-2.168-15.424-4.098-21.208-1.926-5.783-11.325-20.966-15.664-28.198-4.34-7.229-6.915-17.946-8.227-26.266-1.311-8.322-.786-11.037-.35-13.228.194-.961.603-1.834.987-2.611 1.782 2.301 4.061 4.482 6.975 6.265 12.622 7.712 37.714 8.428 37.714 8.428s-2.779.797-11.752.876c-8.97.079-20.959-2.865-20.959-2.865s-.319.638-.319 2.786c0 2.147.559 11.29 13.737 17.965 13.178 6.68 27.708 2.072 27.708 2.072s-1.192 1.031-4.923 2.384c-3.733 1.354-13.894 3.499-13.894 3.499-.001 8.104 7.073 12.533 12.543 14.393 9.369 3.177 20.007.952 25.489-.158 5.477-1.113 2.382.708-2.782 2.938-5.158 2.226-12.543 2.627-12.543 2.627 1.132 5.908 12.766 10.988 17.15 11.923 11.117 2.386 19.292.878 22.628-.394 3.336-1.273 2.7.234 1.666 1.272-1.984 1.989-5.347 2.492-5.347 5.663 0 .9-.084 4.138 16.436 5.216 16.519 1.079 21.99-8.089 24.864-10.79 2.872-2.7 2.693-1.261 1.975-.18-.718 1.076-3.59 4.315-6.104 7.911-2.515 3.597-1.259 7.017 9.696 6.657 8.067-.265 13.405-8.823 15.66-13.312l.152.209c.148.202.296.399.443.591-1.029 2.654-2.817 7.001-4.778 10.66m-153.994-90.156c-1.223.702-5.063 2.889-5.063 2.889s-2.011-4.117-2.535-5.342c-.525-1.23-.263-1.755.433-1.755.702 0 2.798-.61 4.458-.784.238-.027.454-.063.647-.109.554 1.581 1.281 3.291 2.239 5.01-.062.024-.12.056-.179.091m451.661-28.857c5.639-1.592 25.245-7.32 39.062-18.531 13.814-11.211 16.512-20.194 17.628-25.046 1.108-4.851 1.587-8.667-1.986-5.883-3.57 2.778-14.29 11.209-21.592 15.267-7.308 4.052-14.058 5.965-18.029 7.079-3.97 1.108-7.146 1.825-3.332.314 3.806-1.507 16.277-5.886 25.884-15.504 9.605-9.621 17.194-24.035 17.355-32.888.158-8.851-.473-8.221-3.318-6.005-2.848 2.211-12.962 14.701-18.651 19.442-5.69 4.745-14.86 11.068-19.442 13.75-4.587 2.689-11.063 5.692-2.055-.474 9.01-6.16 26.078-20.706 33.037-39.516 6.953-18.81 5.686-29.871 5.531-31.77-.156-1.896-1.74-5.691-3.319-2.21-1.581 3.472-12.965 26.236-22.129 36.034-9.172 9.801-6.956 7.905-9.013 9.486-2.051 1.579-5.533 4.427-1.103-1.109 4.426-5.529 13.592-18.334 18.337-30.978 4.738-12.646 6.003-25.293 6.159-32.563.16-7.269-3-17.383-4.424-20.385-1.419-3.009-2.845-5.219-3.322-1.744-.47 3.478-7.743 25.924-11.695 36.828-3.952 10.909-11.851 23.238-13.435 25.609-1.579 2.371-5.687 7.27-1.264-.948 4.425-8.22 12.959-32.404 14.069-55.323 1.106-22.922-2.055-35.566-5.219-41.887-3.158-6.325-5.898-8.568-5.898-8.568s.541 15.647-4.128 38.126c-4.672 22.479-11.493 34.349-11.493 34.349s-2.87 3.238-.901-2.157c1.334-3.628 4.073-11.616 5.328-25.151 1.322-14.199 1.478-30.357-2.668-44.11-4.514-14.979-12.349-22.638-12.349-22.638-2.184 21.491-1.751 49.183-9.627 71.627-1.475-1.316-3.424-3.755-4.202 1.207-1.438 7.376-4.311 21.223-14.005 38.847-9.7 17.624-13.646 19.963-13.646 19.963s-1.796-4.317-3.057-6.653c-1.255-2.339-1.975-3.598-3.594-.361-1.609 3.239-7 15.646-18.853 29.314-11.85 13.666-18.494 20.322-18.135 30.571.361 10.253 5.746 15.468 12.928 20.143 7.184 4.678 8.445 7.191 7.364 12.768-1.078 5.578-7.544 7.552-13.106 7.735-5.572.179-12.574-.362-15.087 1.078-2.515 1.44-2.692 5.034-5.209 7.549-2.51 2.521-3.588 3.955-5.924 4.32-.823.126-1.49.203-2.007.259-.518-27.038 9.959-39.093 9.959-39.093l-29.283-34.403c-1.514.742-3.024 1.439-4.539 2.095-.206-.398-.488-.83-.858-1.3-3.897-4.976-5.172-9.194-5.172-15.574 1.457.146 4.378 1.198 7.033.666 2.653-.529.66-3.193-.133-5.72-.797-2.533-1.596-11.313-1.064-14.644.531-3.328.793-4.66.793-4.66s4.252 4.66 6.903 4.66c2.659 0 2.389-2.661 2.789-5.59.599-4.414 2.673-9.988 6.103-13.046 0 0 4.643 3.198 9.956 3.198 5.304 0 12.469-1.465 18.175-6.922 5.709-5.455 5.575-6.789 5.575-6.789s10.614 3.725 18.709 4.128c8.096.398 16.721-.935 20.835-9.451 4.114-8.518-1.199-16.37-2.122-17.703-.932-1.333-3.585-2.399-3.585 0 0 2.398.136 8.783-4.778 11.98-4.911 3.193-8.756 3.057-13.403 1.596-4.643-1.463-11.145-3.328-18.577-2.263-6.665.954-7.567 1.479-7.681 1.58.347-.356 6.397-6.561 12.324-8.368 6.106-1.862 9.691.666 11.681 3.061 1.991 2.394 3.714 6.257 5.307.664 1.594-5.588.664-11.978-1.988-16.105-2.656-4.126-8.36-6.789-14.332-6.122-5.974.666-8.092 1.596-8.092 1.596s-3.057-8.648-10.753-10.245c-9.389-1.951-19.745 1.58-27.866 6.12 0 0-6.372 1.467-12.871-.398-4.258-1.22-8.516-3.812-10.949-5.449.74-2.489 2.197-7.082 2.197-7.082s1.86-.567 3.803-1.297c1.945-.728 1.54-1.378 1.783-2.996.241-1.618-3.653-4.439-3.653-4.439s-.562-4.866 5.839-8.203c6.397-3.337 5.701-2.781 5.701-2.781s3.752.695 5.284-.418c1.528-1.112 1.528-1.807 1.528-1.807s2.835-.929 3.875-2.639c1.038-1.706 1.232-4.175.471-6.166-.752-1.996-1.707-2.375-.658-3.326 1.037-.947 1.986-3.224 2.08-4.839.098-1.618.098-1.992.098-1.992s2.174-.765 2.077-4.084c-.097-3.325-1.893-4.655-2.936-4.94-1.037-.284-1.698-.284-1.698-.284s-.191-1.993-1.893-4.649c-1.71-2.659-2.842-3.798-2.842-3.798s1.229-.942.565-3.126c-.661-2.184-2.178-3.512-3.691-3.992-1.513-.473-3.12 0-3.12 0s-5.016-3.035-7.382-4.27c-2.368-1.232-2.936-1.517-2.936-1.517s-.094-2.09-.946-3.228c-.851-1.139-2.841-1.615-3.881-1.615-1.04 0-2.175.572-2.175.572s-8.522-2.187-12.021-2.756c-3.503-.569-3.695-.853-3.695-.853s-7.566-3.607-10.499-4.178c-2.936-.568-3.785-.851-3.785-.851s3.062-3.707 3.25-7.977c.194-4.274-2.645-8.303-5.671-10.105-1.71-1.015-2.627-1.183-3.183-1.531l-.062-2.939 5.686.573.471-9.154-5.537.701.85-5.509-11.61-.133.85 5.506-5.582-.382.473 9.02 5.87-.758-.569 3.413s-2.149.364-3.971 1.707c-3.028 1.804-5.588 5.319-5.398 9.593.187 4.27 2.741 8.071 2.741 8.071s-.756.189-3.689.756c-2.933.57-10.507 4.178-10.507 4.178s-.188.284-3.691.853c-3.5.569-12.017 2.756-12.017 2.756s-1.136-.572-2.179-.572c-1.042 0-3.028.476-3.879 1.615-.852 1.138-.946 3.228-.946 3.228s-.568.285-2.935 1.517c-2.367 1.234-7.38 4.27-7.38 4.27s-1.613-.473-3.127 0c-1.514.48-3.027 1.808-3.689 3.992-.661 2.184.567 3.126.567 3.126s-1.138 1.138-2.842 3.798c-1.701 2.656-1.891 4.649-1.891 4.649s-.664 0-1.704.284c-1.042.285-2.841 1.615-2.933 4.94-.095 3.319 2.082 4.084 2.082 4.084s0 .375.093 1.991c.097 1.616 1.043 3.893 2.083 4.84 1.04.951.095 1.33-.663 3.326-.756 1.991-.569 4.46.473 6.166 1.041 1.71 3.873 2.639 3.873 2.639s0 .695 1.53 1.807c1.527 1.113 5.284.418 5.284.418s-.693-.556 5.701 2.781c6.395 3.337 5.839 8.203 5.839 8.203s-3.894 2.821-3.651 4.439c.244 1.618-.163 2.268 1.781 2.995 1.943.731 3.805 1.298 3.805 1.298s1.455 4.592 2.193 7.082c-2.433 1.637-6.688 4.229-10.945 5.449-6.502 1.865-12.875.397-12.875.397-8.116-4.539-18.473-8.07-27.863-6.119-7.698 1.597-10.751 10.245-10.751 10.245s-2.121-.93-8.092-1.596c-5.971-.667-11.679 1.995-14.335 6.122-2.654 4.127-3.581 10.517-1.988 16.105 1.591 5.593 3.319 1.731 5.307-.664 1.991-2.396 5.576-4.924 11.679-3.061 5.927 1.808 11.98 8.012 12.326 8.368-.117-.101-1.015-.626-7.683-1.58-7.431-1.065-13.933.8-18.577 2.263-4.644 1.462-8.492 1.597-13.401-1.596-4.911-3.198-4.778-9.583-4.778-11.98 0-2.398-2.655-1.333-3.582 0-.928 1.333-6.237 9.185-2.124 17.703 4.112 8.516 12.738 9.849 20.833 9.451 8.095-.402 18.71-4.128 18.71-4.128s-.13 1.333 5.575 6.789c5.705 5.456 12.871 6.922 18.18 6.922 5.309 0 9.95-3.198 9.95-3.198 3.427 3.059 5.508 8.632 6.105 13.046.398 2.929.135 5.59 2.79 5.59 2.652 0 6.9-4.66 6.9-4.66s.265 1.333.794 4.66c.531 3.33-.266 12.11-1.062 14.644-.794 2.527-2.786 5.19-.13 5.72 2.653.532 5.571-.52 7.032-.666 0 6.38-1.28 10.598-5.175 15.574-.344.438-.614.847-.819 1.224-1.451-.636-2.901-1.306-4.35-2.019l-29.283 34.403s10.525 12.113 9.956 39.295l.001-.191c-.534-.049-1.242-.135-2.131-.27-2.338-.364-3.414-1.799-5.93-4.32-2.512-2.516-2.692-6.11-5.205-7.549-2.514-1.441-9.517-.899-15.084-1.078-5.568-.183-12.03-2.157-13.11-7.735-1.076-5.578.182-8.09 7.362-12.768 7.181-4.675 12.57-9.89 12.93-20.143.358-10.248-6.284-16.905-18.136-30.571-11.853-13.668-17.24-26.076-18.855-29.314-1.616-3.237-2.335-1.978-3.593.361-1.258 2.336-3.051 6.653-3.051 6.653s-3.951-2.339-13.646-19.963c-9.699-17.624-12.572-31.471-14.009-38.847-.778-4.962-2.731-2.523-4.2-1.207-7.883-22.444-7.447-50.136-9.628-71.627 0 0-7.836 7.659-12.349 22.638-4.145 13.753-3.986 29.911-2.667 44.11 1.254 13.535 3.992 21.523 5.322 25.151 1.973 5.395-.898 2.157-.898 2.157s-6.824-11.87-11.493-34.35c-4.669-22.479-4.13-38.125-4.13-38.125s-2.736 2.242-5.898 8.568c-3.161 6.321-6.319 18.965-5.216 41.887 1.108 22.919 9.643 47.103 14.07 55.323 4.425 8.218.316 3.319-1.267.948-1.581-2.371-9.483-14.7-13.436-25.609-3.951-10.905-11.222-33.35-11.695-36.828-.475-3.475-1.897-1.265-3.321 1.744-1.424 3.003-4.584 13.117-4.425 20.385.158 7.27 1.422 19.917 6.164 32.564 4.743 12.643 13.908 25.448 18.336 30.976 4.427 5.537.947 2.689-1.107 1.11-2.055-1.581.159.314-9.008-9.486-9.169-9.798-20.549-32.562-22.13-36.034-1.583-3.481-3.162.314-3.321 2.21-.158 1.899-1.422 12.96 5.534 31.77 6.954 18.81 24.026 33.356 33.036 39.516 9.009 6.165 2.527 3.162-2.055.474-4.583-2.683-13.751-9.005-19.442-13.75-5.69-4.741-15.807-17.231-18.652-19.442-2.845-2.216-3.477-2.846-3.319 6.005.157 8.853 7.75 23.267 17.357 32.888 9.606 9.618 22.069 13.997 25.883 15.504 3.811 1.511.635.794-3.337-.314-3.967-1.113-10.715-3.027-18.021-7.079-7.305-4.059-18.022-12.489-21.595-15.267-3.574-2.784-3.095 1.032-1.985 5.883 1.112 4.852 3.811 13.835 17.625 25.046 13.816 11.211 33.426 16.939 39.062 18.531 5.639 1.587 1.669 1.587 1.669 1.587s-2.223-.314-13.656-2.864c-11.433-2.542-28.742-11.604-33.428-14.547-4.684-2.945-5.396-4.055-4.763 2.146.637 6.197 7.228 19.48 17.785 25.682 10.56 6.202 29.617 9.386 34.538 9.621 4.924.242 3.653.956 1.43 1.111-2.225.159-7.703.159-16.674-.869-7.354-.85-18.277-4.42-21.983-5.684-.414-1.583-.796-3.117-.97-4.06-.437-2.363-1.66-2.014-2.446-1.485-.787.518-1.226.958-3.84 2.273-2.624 1.319-2.712-.259-2.798-1.046-.088-.794-.611-4.211-.698-5.957-.087-1.757-1.049-1.845-2.27-1.319-1.224.529-7.076 2.98-9.259 3.947-2.183.961-.175 2.712.961 4.811 1.135 2.11 2.882 5.171 2.882 5.171s-5.502 1.49-7.251 1.929c-1.745.439-1.22 1.666-.786 2.894.44 1.223 3.146 7.359 3.844 9.11.698 1.751 2.271.702 2.271.702l5.501-3.241 1.921 7.355c-.092.117-2.542.585-5.325 2.536-2.779 1.951-2.085 4.463 1.252 5.44 3.335.975 7.232 2.65 11.541 10.458 4.309 7.814 5.423 21.895 8.063 44.076 2.642 22.169 16.825 33.467 18.772 34.863 1.948 1.397.835 2.51.835 2.51s-1.947 2.794-1.111 7.117c.835 4.317 4.587 6.833 6.534 7.529 1.945.694 1.391 2.648 1.391 2.648s-.974 4.74 0 13.391c.973 8.646 8.064 18.409 10.011 20.082 1.945 1.669 2.085 2.51 1.808 3.209-.278.697-1.53.142-3.895 1.952-2.364 1.813-5.007 4.322-6.672 7.389-1.669 3.072-1.113 4.884-.559 9.069.557 4.184 6.674 7.949 6.674 7.949s-1.113.279-1.388 3.347c-.278 3.069 1.944 6.553 4.726 8.784 2.779 2.233 8.065 3.35 8.065 3.35s.418 2.648.695 4.46c.278 1.817 3.755 3.623 5.98 4.881 2.223 1.255 6.534.559 8.343-.278 1.805-.835 3.057.14 4.168 1.95 1.115 1.816.699 8.787.699 11.578 0 2.789-1.671 5.719-.699 7.115.976 1.393 3.617.414 6.258-1.117 2.642-1.536 3.338-.417 5.703 1.117 2.363 1.531 6.118 2.93 7.092 2.788.973-.141.555-2.651.555-4.743 0-2.093.376-6.824 1.35-7.522.459-.332 4.553-.636 7.689-1.964 1.461-.613 3.338-1.251 3.477-2.648.139-1.393-1.948-1.393-6.535-3.764-4.589-2.368-5.423-3.771-8.342-5.721-2.92-1.951-1.529-2.648-1.529-3.486 0-.831 1.388-1.811 1.945-2.927.555-1.116.278-3.623.278-3.623s2.364-2.371 3.476-3.629c1.112-1.252 2.503-3.212 4.033-4.463 1.528-1.252 3.892-7.25 5.422-9.204 1.529-1.951 5.007-4.043 7.09-6.694 2.086-2.652 7.648-6.974 10.848-9.066 3.197-2.092 11.818-6.138 11.818-6.138s-.139 5.16 2.086 7.669c2.223 2.515 5.144-1.948 15.017-8.924 9.872-6.973 17.381-9.483 17.381-9.483s2.085 3.205 4.725 6.553c2.644 3.35 5.008-.142 17.104-16.873 9.543-13.203 22.111-25.274 26.993-29.785.899.399 1.791.799 2.678 1.21-.23.644-.481 1.373-.734 2.169-1.109 3.468-2.909 5.686-5.266 10.532-2.355 4.849-5.956 5.956-10.115 12.472-4.155 6.511-4.71 10.94-5.126 17.592-.416 6.651 3.325 8.039 3.325 8.039s-6.097 5.953-7.898 10.389c-1.799 4.432-2.772 13.442-2.772 13.442s-.97.411-3.185 4.986c-2.219 4.576-6.237 5.264-12.055 11.085-5.821 5.818-12.331 8.313-15.379 10.108-3.049 1.808-2.219 3.607-1.385 5.962.828 2.355 4.987 4.711 9.836 6.512 4.849 1.799 6.511 1.107 9.838.971 3.325-.136.693 2.494-.693 3.875-1.384 1.39-3.187 6.236-2.911 11.639.278 5.407 4.298 4.156 9.287 3.326 4.984-.829 10.804-3.326 10.804-3.326l-.554 1.528c-.553 1.522-.831 2.627-.831 6.929 0 4.293.692 6.371 1.94 7.476 1.248 1.11 3.742-1.243 5.541-1.796 1.802-.562 4.85-2.357 9.285-3.326 4.431-.973 6.094-2.908 6.094-2.908s-1.107 1.38-1.384 4.43c-.279 3.051-.14 7.62.556 10.257.69 2.627 2.63 5.816 5.679 8.587 3.047 2.774 3.74 1.525 5.956-1.937 2.217-3.467 6.789-7.902 6.789-7.902s.278 1.11 3.327 10.946c3.049 9.838 13.023 18.013 13.023 18.013s9.976-8.175 13.024-18.013c3.046-9.836 3.32-10.946 3.32-10.946s4.577 4.435 6.792 7.902c2.219 3.461 2.912 4.71 5.959 1.937 3.047-2.771 4.987-5.959 5.68-8.587.693-2.637.832-7.206.559-10.257-.282-3.05-1.39-4.43-1.39-4.43s1.663 1.936 6.097 2.908c4.432.97 7.482 2.765 9.28 3.326 1.802.553 4.299 2.906 5.545 1.796 1.246-1.106 1.94-3.183 1.94-7.476 0-4.302-.276-5.408-.831-6.929l-.556-1.528s5.821 2.497 10.808 3.326c4.985.829 9.004 2.08 9.286-3.326.272-5.404-1.528-10.25-2.912-11.639-1.388-1.381-4.017-4.011-.693-3.875 3.323.137 4.987.828 9.835-.971 4.849-1.801 9.007-4.158 9.84-6.512.831-2.356 1.663-4.155-1.385-5.962-3.047-1.795-9.562-4.29-15.381-10.108-5.815-5.821-9.838-6.509-12.057-11.085-2.213-4.575-3.18-4.986-3.18-4.986s-.975-9.01-2.774-13.442c-1.802-4.437-7.899-10.389-7.899-10.389s3.743-1.388 3.326-8.039c-.414-6.652-.967-11.081-5.125-17.592-4.158-6.515-7.763-7.623-10.12-12.472-2.354-4.846-4.155-7.064-5.263-10.532-.221-.699-.461-1.397-.708-2.096 1.188-.528 2.383-1.055 3.576-1.568 4.848 4.469 17.47 16.579 27.044 29.823 12.098 16.739 14.463 20.226 17.105 16.876 2.639-3.344 4.726-6.55 4.726-6.55s7.507 2.507 17.381 9.48c9.871 6.976 12.792 11.437 15.014 8.927 1.176-1.322 1.437-3.514 1.581-5.196 0 0 5.671 1.657 12.169 3.933 3.896 1.366 8.224 3.088 11.436 4.443 8.551 3.62 9.48 5.483 16.283 10.857 6.802 5.374 16.49 4.858 25.665 2.064 9.169-2.785 33.603-10.849 43.391-15.087 9.792-4.246 16.803-7.963 17.834-9.929 1.029-1.963 2.16-7.443 2.16-9.403 0-1.966-2.16-4.858-2.885-5.378-.718-.52-.406-2.071-.206-3.306.206-1.243-.409-4.963-1.954-6.621-1.546-1.654-1.34-2.268-1.134-7.032.434-10.083-6.762-22.798-16.959-26.845 0 0-.273-1.172-1.103-1.865-.819-.688-2.197-1.308-2.197-1.308s.202-5.797.136-7.043c-.068-1.243.481-1.099 1.175-.758.685.343 1.784 1.727 3.435 2.142 1.651.411 2.684-.764 3.03-2.624.341-1.863 1.72-5.592 2.339-7.456.623-1.859-.14-2.139-.896-2.344-.755-.212-3.233-.482-4.406-.765-1.166-.273-1.166-.344-.893-.964.278-.617.687-1.584 2.2-3.935 1.517-2.348.142-2.415-1.308-2.894-1.445-.485-7.978-2.487-9.767-2.766-1.792-.276-2.207 1.242-2.207 2.001 0 .765.07 4.075.139 5.317.07 1.242-1.1.896-1.787.552-.693-.344-2.272-1.314-3.508-2.28-1.24-.964-2.134-.067-2.619 1.314-.481 1.378-1.992 7.044-2.474 8.698-.482 1.657-.347 2.969.345 3.241.687.279 3.919 0 5.85 0 1.922 0 .822 1.107.822 1.107s-2.063 3.382-2.753 4.691c-.685 1.313-1.858 1.522-3.438 1.522-1.584 0-4.238-.021-4.238-.021s-10.574.397-18.358 6.186c-7.781 5.787-9.976 10.573-11.173 13.365-1.198 2.797-2.591 2.194-3.793 3.194-1.196.999-4.587 4.593-4.587 6.789 0 2.192.796 3.388-2.592 5.582-3.397 2.198-6.189 11.775-1.599 16.766 4.59 4.983 6.386 9.969 7.785 12.368 1.39 2.395 0 3.391-1.202 3.391-1.195 0-3.694-2.033-5.783-3.594-2.09-1.555-12.631-9.788-17.158-13.164-4.534-3.383-1.199-2.994-1.199-2.994s1.152.105 3.796-1.009c2.64-1.116 3.06-2.506.412-3.347-2.639-.835-7.785-3.765-9.171-5.161-1.394-1.393-2.087-2.927.555-4.322 2.639-1.394 8.481-5.161 3.894-6.416-4.593-1.261-10.015-2.231-14.464-3.489-4.449-1.255-4.869-2.509-4.869-2.509l2.924-4.185s2.362-3.344-.417-3.765c-2.78-.42-9.454-1.255-15.572-3.907-12.218-5.292-19.876-14.27-22.713-25.224l.203-.265c2.283 4.517 7.599 12.956 15.613 13.218 10.952.361 12.207-3.06 9.694-6.657-2.512-3.596-5.386-6.835-6.103-7.911-.724-1.081-.903-2.521 1.971.18s8.346 11.869 24.867 10.791c16.518-1.078 16.435-4.317 16.435-5.216 0-3.171-3.364-3.673-5.347-5.663-1.035-1.037-1.664-2.545 1.668-1.273 3.333 1.272 11.508 2.779 22.627.394 4.388-.934 16.022-6.015 17.148-11.922 0 0-7.385-.402-12.542-2.627-5.163-2.231-8.26-4.052-2.779-2.939 5.48 1.11 16.121 3.336 25.486.159 5.475-1.86 12.548-6.289 12.545-14.393 0 0-10.162-2.146-13.895-3.5-3.732-1.353-4.922-2.383-4.922-2.383s14.524 4.607 27.708-2.072c13.18-6.676 13.735-15.819 13.735-17.966 0-2.148-.317-2.786-.317-2.786s-11.989 2.945-20.959 2.865c-8.973-.079-11.754-.876-11.754-.876s25.093-.717 37.714-8.427c12.624-7.714 13.341-22.903 13.341-22.903s-14.296 5.089-23.263 6.126c-8.972 1.028-14.453 1.028-16.674.87-2.225-.156-3.49-.87 1.428-1.111 4.928-.235 23.976-3.42 34.538-9.621 10.561-6.204 17.15-19.486 17.787-25.683.634-6.2-.079-5.089-4.767-2.145-4.685 2.942-21.989 12.004-33.423 14.546-11.43 2.55-13.655 2.864-13.655 2.864s-3.981-.001 1.662-1.588"
      S.path
        ! A.fill "#E30613"
        ! A.d "M181.4484 168.5227c-2.551-1.499-9.414-4.432-16.718-5.054-7.301-.616-12.944.481-19.006 2.119-4.343 1.173-7.859 1.353-11.338.42-5.229-1.394-9.282-6.11-10.658-11.892 0 0-4.82 6.18.109 12.887 2.368 3.225 5.451 5.241 8.593 5.876 10.229 2.06 20.261-4.183 28.781-4.729 8.18-.531 14.607 4.656 14.607 4.656s1.935 1.608 4.662.021c2.73-1.589 3.521-2.804.968-4.304"
      S.path
        ! A.fill "#E30613"
        ! A.d "M419.655 154.1159c-1.379 5.781-5.437 10.498-10.662 11.892-3.48.933-6.987.753-11.34-.42-6.06-1.639-11.704-2.737-19.004-2.119-7.299.622-14.167 3.554-16.718 5.054-2.549 1.5-1.762 2.715.965 4.303 2.73 1.587 4.663-.021 4.663-.021s6.426-5.186 14.61-4.655c8.516.545 18.546 6.789 28.783 4.729 3.139-.635 6.218-2.651 8.59-5.876 4.926-6.707.113-12.887.113-12.887"
      S.g
        ! A.fill "#E9B528"
        $ do
          S.path ! A.d "M354.406 304.6184c0-20.417 9.395-33.33 9.395-33.33l-25.557-29.278c-24.34 9.41-46.641 9.981-66.494-.121-19.854 10.102-42.156 9.531-66.49.121l-25.565 29.278s9.397 12.913 9.397 33.33c0 20.42-3.948 35.568-6.255 45.445-2.306 9.881-4.281 28.32.988 41.496 5.267 13.168 10.868 24.696 33.588 34.247 22.723 9.55 34.579 14.487 42.479 21.076 7.905 6.58 11.857 11.851 11.857 11.851s3.952-5.272 11.857-11.851c7.899-6.588 19.756-11.525 42.48-21.076 22.718-9.549 28.319-21.079 33.588-34.247 5.266-13.176 3.291-31.617.987-41.496-2.305-9.877-6.255-25.025-6.255-45.445"
          S.path ! A.d "M158.4074 467.6008s-8.25 3.941-10.867 4.644c-2.614.713-3.218.713-3.218.713s-5.636 5.143-9.761 7.561c-4.334 2.551-9.306 4.402-14.287 4.952-6.442.702-24.148.5-32.098.2-7.95-.299-12.877 1.613-16.3 5.449-3.422 3.837-4.223 9.385.101 13.626 4.327 4.241 9.155 2.122 10.767-.502 1.608-2.627.804-5.959.099-7.47-.703-1.517 1.41-2.023 3.621-2.122 2.216-.1 5.937.203 9.359.709 3.422.502 9.459 2.521 12.074 3.934 2.617 1.413 1.107 1.617-.704 1.311-1.81-.303-3.822-1.008-7.043-2.216-3.219-1.21-5.936-1.818-7.947-1.922-2.011-.099-1.311 1.012-.905 1.717.401.708 1.507 2.421 1.808 3.232.304.809-.602 3.83-.602 3.83l1.006 1.921s1.207-1.921 1.609-2.923c.402-1.015-.101-2.928.301-3.838.402-.909 2.112-.909 3.42.607 1.309 1.511 2.819 3.332 3.522 7.159.705 3.837-.604 6.562-.604 6.562s1.612 1.317 1.913 2.219c.303.911-.403 4.545-.403 4.545s1.108.706 2.115-1.416c1.004-2.116 2.212-5.85 2.513-7.165.301-1.31 1.208-3.732 2.817-1.916 1.61 1.814 2.718 4.037 3.021 5.149.298 1.107.298 2.019.298 2.019s3.623-3.535 4.831-5.553c1.207-2.02 3.723-5.045 7.145-7.87 3.42-2.827 9.357-8.478 12.274-10.397 2.917-1.916 10.364-5.954 12.678-7.367 2.314-1.413 2.716-1.511 3.119-5.451.404-3.939 2.316-7.464 3.221-10.192.907-2.724 1.107-3.739 1.107-3.739"
          S.path ! A.d "M151.967 464.5764s-1.006-.1-2.414-.303c-1.409-.202-4.428-1.21-5.334-1.615-.906-.399-2.314-.503-3.22.505-.905 1.012-8.25 5.349-8.25 5.349h12.176c4.226 0 7.042-3.936 7.042-3.936"
          S.path ! A.d "M186.261 462.4817v-1.217l-1.622-3.493s-1.893 1.188-3.738 3.097c-2.373 2.466-4.93 5.926-6.069 7.39-2.027 2.598-4.863 5.039-2.43.891 2.43-4.147 3.24-5.933 5.184-8.698 1.946-2.763 3.407-3.983 3.164-4.147-.243-.161-1.786-.402-6.893-1.052-5.104-.655-8.265-2.604-10.615-3.988-2.351-1.382-6.564-3.656-6.564-3.656s-8.674 3.656-11.916 4.47c-3.244.813-5.188 1.299-2.028 2.847 3.162 1.542 5.836 2.03 7.377 3.003 1.538.982 6.322 2.522 9.241 2.522 2.917 0 7.859.079 5.915 2.112-1.944 2.036-4.133 5.94-6.241 11.869-2.106 5.939-2.187 11.222-2.187 13.822 0 2.602.323 5.2.323 5.2s3.566-3.98 13.131-9.994c9.564-6.019 13.13-8.049 14.912-8.867 1.782-.808 2.677-.808 2.351-3.085-.323-2.276-1.295-7.885-1.295-9.026"
          S.path ! A.d "M222.7887 433.4367c-.579-.259-1.173-.525-1.775-.806-.161.041-.307.088-.441.156-1.121.561-6.956 4.491-9.312 8.307-2.355 3.812-4.712 4.153-2.134 0 2.582-4.159 4.491-6.511 6.509-8.307.78-.693 1.477-1.27 2.038-1.713-4.694-2.263-9.791-5.004-14.723-8.437-.638 1.273-1.862 3.529-3.249 4.993-2.019 2.13-6.508 3.929-6.508 3.929s3.591-3.705 4.827-6.512c.786-1.789 1.3-3.72 1.567-4.878-3.433-2.673-6.722-5.724-9.66-9.223-.597 2.428-2.54 8.339-8.29 14.774-7.516 8.42-22.555 12.681-22.555 12.681s-5.272.561-1.009 1.683c4.264 1.124 7.293 3.031 15.598 1.568 8.301-1.455 8.863-1.793 9.985-2.125 1.122-.341 4.153-.114 0 1.458-4.15 1.568-13.803 3.024-17.504 2.692-3.704-.336-8.752-1.123-3.479 1.684 5.275 2.806 7.518 3.926 10.771 3.926 3.255 0 4.602 1.01 7.745 1.01 3.141 0 4.036-.561 6.283-1.01 2.244-.447 3.701.335 3.701 1.233 0 .897-3.028 3.364-2.915 9.539.111 6.171.56 10.212 1.118 12.002.565 1.801 1.911 4.716 2.808 6.403.898 1.681 1.236 3.363 2.131-.226.898-3.595 2.917-8.755 3.705-12.231.784-3.479 1.233-3.591 1.571-5.385.335-1.796 2.243-3.142 1.345.111-.898 3.252-1.908 7.405-2.578 10.323-.676 2.917-2.245 8.301.446 4.037 2.692-4.261 12.792-15.595 14.474-17.614 1.682-2.02 3.03-3.93 4.264-5.61 1.234-1.685 4.713-3.929 6.397-6.398 1.524-2.233 5.981-6.58 7.896-8.137-2.859-1.205-5.871-2.475-9.047-3.897"
          S.path ! A.d "M26.466 319.7219c-.066-.67-1.409-3.026-1.742-4.237-.336-1.208-1.543-.474-1.543-.474s-2.617 1.482-4.562 2.02c-1.945.537-2.215-.201-2.415-1.208-.199-1.018-.67-4.173-1.005-6.395-.336-2.215-.806-2.08-1.61-1.751-.803.341-3.219 1.213-4.896 1.957-1.676.737-1.141 1.545-.603 2.486.536.946 2.481 4.912 3.353 6.325.872 1.41.067 2.018-.941 2.491-1.005.471-2.481.67-4.493 1.343-2.012.673-1.877 1.143-1.678 1.817.203.676 1.545 3.432 2.282 4.707.736 1.277 1.409.405 1.409.405s2.149-1.948 3.957-2.827c1.812-.869 1.945-.605 2.415.743.47 1.347 2.55 8.411 2.951 9.757.403 1.34 1.076 1.208 2.014.809.939-.403 2.212-.608 3.285-.947 1.074-.334 1.478-2.488 1.478-2.488s-3.958-7.128-5.032-8.948c-1.075-1.816 0-2.222.806-2.354.803-.132 3.151-.47 5.163-.941 2.013-.474 1.475-1.616 1.407-2.29"
          S.path ! A.d "M71.1725 513.426c-.301-1.72.001-3.436-1.308-4.745-1.308-1.315-2.918-3.936-3.522-6.054-.603-2.121.504-3.13.301-4.343-.2-1.211-1.811-1.211-3.419.105-1.612 1.311-3.724 2.522-3.724 6.356 0 3.832 1.41 8.379 6.742 9.989 5.332 1.618 5.234.405 4.93-1.308"
          S.path ! A.d "M76.6061 511.6067s-1.107-.705-1.609.303c-.504 1.008-.404 1.516 1.005 3.735 1.409 2.219 2.316 2.727 3.925 3.733 1.61 1.01.502-1.006.301-1.614-.2-.607 0-1.41-.399-1.919-.405-.505-.607-1.11-.607-2.72-.001-1.621-2.616-1.518-2.616-1.518"
          S.path ! A.d "M83.1457 529.7727c1.006-1.52 1.913-1.919 4.328-3.027 2.412-1.108 6.84-1.717 8.348-1.817 1.511-.103 4.932-3.027 4.428-6.059-.503-3.028-2.716-4.239-4.628-4.64-1.912-.402-3.622-.402-4.224.502-.606.911-1.713 2.121-3.825 2.826-2.111.706-2.415 1.414-3.721 1.818-1.308.404-.303 1.212-1.409 2.121-1.108.904-2.614 0-4.327-.506-1.71-.506-1.811-.806-3.723-.91-1.912-.101-6.942-.4-6.942-.4s-.203-.103-1.306-.103c-1.108 0-1.21.202-1.71 1.413-.504 1.211.1 4.241 1.307 5.754 1.207 1.509 5.131 2.218 7.745 3.026 2.617.803 3.928 1.11 6.14 1.511 2.211.407 2.514.001 3.519-1.509"
          S.path ! A.d "M107.596 532.1936c2.112-1.413.904-3.838.402-5.348-.504-1.516-3.423-1.817-4.931-1.817-1.509 0-2.313 0-3.119.706-.806.705-1.91 1.716-4.126 2.424-2.209.705-3.923 1.511-6.941 2.724-3.019 1.207-3.926 3.227-5.232 4.04-1.309.803-3.821 0-3.821 0s-1.814-.508-2.416 0c-.606.497 0 1.508 1.207 2.819 1.21 1.317 3.522 1.214 6.136 2.022 2.618.805 3.12.2 4.127-.506 1.005-.705 1.811-2.218 3.622-3.332 1.811-1.107 5.737-1.311 7.646-1.51 1.913-.205 5.335-.811 7.446-2.222"
          S.path ! A.d "M107.596 523.008c.904.812 1.912 1.922 2.716.605.805-1.307 2.112-4.034 1.207-5.648-.908-1.612-2.01-3.029-2.01-3.029s-1.511 4.642-2.216 5.856c-.703 1.207-.602 1.41.303 2.216"
          S.path ! A.d "M99.446 509.0842c0-2.627-1.812-5.856-1.812-5.856s-.603 2.421-1.709 4.543c-1.107 2.115-2.214 3.229-2.214 3.229s2.617.705 3.622.705 2.113.001 2.113-2.621"
          S.path ! A.d "M84.3532 514.633c2.817-.605 4.327-1.716 5.534-2.724 1.207-1.007 1.913-3.738 1.106-5.145-.802-1.42-2.816-2.927-3.619-2.927h-1.511s-.806 2.624-1.912 3.935c-1.107 1.313-2.414 2.218-2.314 3.934.101 1.72-.1 3.532 2.716 2.927"
          S.path ! A.d "M90.0895 501.8147c.102-1.311-.405-2.725-1.309-3.632-.904-.908-1.51-1.511-1.51-1.511s-.202 2.016-.402 3.126c-.201 1.111-.3 1.312-.3 1.312s.805.811 1.51 1.113c.702.3 1.91.905 2.011-.408"
          S.path ! A.d "M55.2995 430.2307s3.329 0 1.903-11.892c-1.429-11.89-7.612-23.144-12.524-30.917-4.916-7.766-9.989-19.973-12.211-26.475-2.219-6.503-3.709-15.404-3.709-20.063 0-4.663 1.99-7.06 1.99-7.06s.862-1.265.066-2.064c-.797-.797-2.056-.064-3.318 1.199-1.263 1.262-2.589 3.593-3.12 5.256-.534 1.669-.534 2.266-.534 2.266s-2.522-.597-6.57-.262c-4.05.329-5.974.664-6.108 1.529-.132.866.532 1.533 3.452 2.796 2.923 1.264 4.781 1.796 6.242 3.531 1.462 1.731 5.195 10.426 6.338 14.625 1.141 4.202 3.581 15.586 4.571 24.525.99 8.939 4.005 19.765 8.22 28.807 1.379 2.959 8.941 17.017 15.312 14.199"
          S.path ! A.d "M62.6515 451.177c-2.753 1.537-2.652 12.789-1.428 18.622 1.223 5.835 6.937 13.098 8.67 15.042 1.735 1.943 2.144 1.943 3.062 1.432.92-.509 1.325-.509 1.325-.509s2.45-.819 4.288-2.251c1.833-1.434 1.119-5.016.812-8.187-.306-3.176-2.753-9.52-7.241-16.881-4.488-7.371-6.733-8.801-9.488-7.268"
          S.path ! A.d "M65.714 442.0705c0-3.67-3.183-6.444-6.844-6.444-1.731 0-3.256.435-4.201 1.287-3.714 3.349-1.474 11.707 3.89 11.707 1.943 0 4.216-.326 5.62-1.669 1.243-1.179 1.535-3.158 1.535-4.881"
          S.path ! A.d "M118.9142 547.8127c-1.465-.259-2.329-.857-4.489-2.327-2.158-1.466-5.613-4.49-6.217-5.959-.607-1.469-.607-1.555-2.677-.86-2.074.688-5.009.602-7.252.688-2.244.088.256 2.589 1.812 4.925 1.554 2.33 1.036 10.184 1.036 10.184s0 .694-.345 1.819c-.345 1.119-.085 1.898.518 2.156.606.259.949-.259 2.504-2.077 1.556-1.811 4.405-6.556 4.405-6.556s.433.082 2.849.689c2.416.605 6.303.258 8.291-.348 1.985-.606 1.033-2.073-.435-2.334"
          S.path ! A.d "M109.675 553.8635c-1.034-.174-1.466-.262-1.986.423-.515.696-.948 1.995-1.208 2.681-.26.692-.173 1.298.433 1.816.606.52 1.467 1.122 1.467 1.122s.864.952 1.73 1.378c.862.435 1.032-.858 1.032-1.811 0-.948.519-2.676.519-3.798 0-1.124-.95-1.641-1.987-1.811"
          S.path ! A.d "M83.2682 174.3982c.268 6.185 7.114 18.015 11.006 24.335 3.894 6.321 4.966 8.869 4.298 9.274-.673.404-2.283-2.822-4.432-5.643-2.149-2.824-6.309-9.41-9.798-14.385-3.491-4.975-8.591-16.803-9.262-17.88-.671-1.074-.941-1.748-2.684-.405-1.745 1.344-5.102 14.388-1.072 23.26 4.026 8.872 10.064 15.32 12.615 18.413 2.552 3.093 5.907 7.933 5.369 8.338-.535.401-1.476-.808-4.561-4.036-3.088-3.225-8.19-8.739-11.544-12.77-2.726-3.274-6.426-9.925-7.722-12.302-.487-.899-1.116-.655-1.586-.185-1.105 1.109-2.874 3.689-2.102 10.739 1.074 9.817 6.173 15.46 10.737 20.435 4.565 4.975 9.129 9.139 8.458 9.812-.671.674-5.369-3.496-8.591-6.587-3.219-3.091-11.142-10.753-12.886-12.905-1.747-2.149-4.293-1.078-4.16 7.393.132 8.471 9.529 17.073 13.42 21.781 3.897 4.704 8.727 7.522 8.325 8.465-.404.941-4.296-1.475-6.847-3.224-2.549-1.749-12.08-7.933-13.959-9.277-1.877-1.341-2.818 1.209-.402 9.277 2.417 8.062 9.397 14.515 13.557 17.471 4.162 2.959 10.873 6.585 10.469 7.532-.401.937-3.221-.271-7.113-2.154-3.892-1.881-8.589-3.629-11.945-4.567-3.357-.943-3.356 1.476-3.356 1.476s-.673 6.856 4.295 12.368c4.968 5.513 10.604 7.664 15.972 8.601 5.37.943 6.174 1.214 6.041 2.022-.134.806-.671.938-1.878.938-1.208 0-6.176.538-10.74.538-4.565 0-6.979 1.072-6.979 3.091s-.135 4.707 6.711 9.274c6.844 4.573 14.496 5.245 17.719 5.918 3.221.67 3.353.943 2.684 1.884-.671.937-2.146.806-7.25 1.343-5.099.535-8.186 2.553-8.86 3.896-.67 1.347.405 5.381 4.567 8.199 4.16 2.827 9.527 3.768 17.582 3.23 8.054-.54 10.067-.673 10.335.674.271 1.343-2.414 1.748-6.442 2.421-4.026.667-7.115.667-9.396 2.55-2.283 1.884-.537 5.781 3.354 8.605 3.892 2.823 13.559 2.823 17.584 2.554 4.027-.269 10.201-1.749 10.604-.674.405 1.075-2.951 2.692-7.111 4.167-4.166 1.483-5.374 2.418-6.176 4.17-.808 1.745-.136 3.358 4.831 5.239 4.966 1.884 12.214 1.884 15.972.136 3.761-1.745 5.771-2.422 6.445-1.745.669.675 0 1.345-.807 2.286-.803.94-4.027 3.493-8.186 4.569-4.163 1.078-4.565 1.078-6.042 4.435-1.474 3.362 2.282 6.053 9.799 6.324 7.518.264 17.586-2.69 20.807-4.576 3.222-1.884 4.43-2.284 4.966-1.61.536.67.402 1.075-1.208 2.28-1.612 1.216-6.713 4.842-9.262 5.515-2.55.67-2.819 2.551-2.819 4.3 0 1.745-.672 5.242 6.04 6.858 6.713 1.614 14.631.406 21.88-4.707 2.335-1.643 3.691-3 4.458-4.175-.586-6.866-.276-11.581.547-15.934-1.422-.149-4.121-.559-6.885-1.669-4.027-1.609-5.635-5.374-6.576-7.393-.941-2.016-2.28-2.016-3.894-1.482-1.612.544-3.222 1.214-5.503 1.081-2.282-.132-7.115-1.346-10.604-5.515-3.491-4.167-2.822-8.196-2.955-10.218-.135-2.016-3.356-.534-4.966-.534-1.612 0-6.309-.673-10.602-3.629-4.298-2.959-4.298-6.992-4.7-8.608-.401-1.609-2.149-2.682-3.49-3.226-1.34-.535-3.49-1.073-6.445-3.494-2.951-2.418-4.023-7.124-4.159-8.736-.133-1.614-1.88-1.749-7.921-4.84-6.039-3.091-5.503-9.545-5.232-12.096.268-2.557 3.085-4.704 3.085-5.651 0-.943-2.014-1.208-4.027-2.418-2.013-1.208-7.112-3.227-7.247-10.753-.135-7.528 4.833-8.334 4.833-8.334s-.942-.405-2.955-1.613c-2.014-1.214-7.514-4.975-7.514-9.413 0-4.434 2.011-6.451 3.489-7.528 1.476-1.075 5.503-2.149 5.503-2.149s-2.551-1.614-3.625-5.11c-1.074-3.496-1.476-7.795 1.073-10.887 2.551-3.095 6.846-3.095 9.129-3.095 2.281 0 4.294 1.21 5.099.541.806-.673.939-1.209.133-2.959-.802-1.745-.938-6.05-.268-7.527.673-1.479.806-4.434 6.58-6.319 5.77-1.881 11.809 2.016 13.69 3.095 1.88 1.077 1.074-1.483 1.074-3.363s-3.892-6.588-8.322-13.309c-4.431-6.722-6.442-10.218-11.41-20.434-4.968-10.216-8.19-23.391-8.86-26.751-.671-3.36-2.014-1.75-2.014-1.75s-1.343.541-4.428 8.335c-3.088 7.8-3.623 14.925-3.355 21.106"
          S.path ! A.d "M184.5387 311.8733c-3.46-.173-7.953-2.074-11.412-7.096-3.455-5.023-8.644-6.239-17.636-6.066-8.99.174-13.142-4.152-15.388-10.385-2.248-6.239.346-13.338 9.509-17.84 9.164-4.502 13.315-9.524 13.658-17.312.348-7.793-9.16-17.49-18.671-28.4-9.511-10.907-16.945-26.322-16.945-26.322s-2.767 3.639-2.767 7.273c0 3.636 1.382 7.444 0 8.483-1.384 1.04-1.902-1.554-7.433-3.981-5.535-2.425-10.03-2.769-13.488 1.211-3.459 3.982 0 10.909 3.111 14.199 3.114 3.29 5.706 5.717 4.842 6.929-.863 1.212-5.534-1.906-7.089-2.945-1.556-1.039-5.187-5.02-10.547-4.501-5.359.517-7.264 2.077-7.782 6.581-.518 4.501 4.842 8.48 8.3 10.215 3.459 1.728 4.842 3.29 3.976 3.979-.863.697-1.729 0-3.287-.515-1.553-.521-5.876-1.039-8.641 0-2.768 1.039-7.264 4.846-3.114 9.524 4.15 4.675 12.796 6.406 14.525 6.749 1.728.347 2.592-.174 2.766 1.211.172 1.39-3.631 1.39-8.3 1.564-4.668.173-6.052 4.672-5.36 8.136.692 3.465 8.471 7.27 12.793 7.966 4.325.694 5.879 0 6.225 1.211.348 1.211-.518 1.731-2.939 2.424-2.42.69-7.089 1.214-7.956 5.022-.862 3.809-1.034 5.539 2.596 8.834 3.631 3.288 9.511 2.769 11.239 2.421 1.73-.343 3.806-2.253 5.535-.517 1.728 1.728-1.559 3.115-4.498 5.193-2.939 2.083-2.765 6.062 2.248 8.833 5.014 2.775 10.029 1.729 12.104 1.037 2.074-.689 4.842-3.981 6.223-1.903 1.385 2.077-4.32 2.771-6.744 5.715-2.42 2.939-1.555 7.788 3.287 10.731 4.842 2.946 12.795.867 14.179-.344 1.382-1.21 3.11-1.728 4.148-.687 1.036 1.03-.518 3.802-1.556 6.229-1.036 2.424-2.94 9.524 4.324 12.295 7.263 2.769 13.832-3.464 15.042-4.677 1.21-1.211 2.42-1.385 3.458-.865 1.036.524.521 1.559-.345 2.772-.864 1.211-2.766 6.403 2.42 10.045 3.541 2.483 7.406 2.298 9.499 1.936 1.081-4.054 2.487-8.389 3.919-14.458 0 0-3.024 2.564-3.925 3.19-.901.622-1.731 1.381-2.217 1.037-.483-.348 1.872-1.596 2.494-2.358.625-.764 1.871-1.939 1.941-2.768.069-.834.484-1.319 1.731-2.358.389-.322.693-.708.933-1.081.833-4.037 1.65-8.765 2.392-14.489.502-3.885.788-7.544.899-10.962z"
          S.path ! A.d "M36.7531 203.9499c7.726 15.626 18.632 24.424 18.632 24.424s-1.432-3.882-2.066-6.55c-.629-2.671-.139-5.693-.139-5.693s-2.739-3.513-7.798-11.309c-5.057-7.798-7.728-19.317-7.728-19.317s4.707 11.519 8.358 17.633c3.656 6.111 7.873 11.097 7.873 11.097s1.471-5.406 2.528-5.687c1.053-.281 1.826.562 2.738 1.755.914 1.195 1.69 1.084 1.69 1.084s-1.248-2.581-3.168-5.674c-.871-1.406-2.145-2.921-3.044-4.342-2.879-4.549-9.087-13.194-12.271-21.844-3.183-8.65-10.148-30.341-11.362-36.716-1.211-6.372-2.424-2.882-3.635 1.823-1.211 4.703-2.877 11.378-1.817 21.389 1.061 10.013 3.483 22.301 11.209 37.927"
          S.path ! A.d "M46.7516 246.1276c2.876 2.124 7.121 5.003 7.121 5.003s-.672-1.569-1.095-3.447c-.423-1.879-.606-5.753-.606-5.753s-3.388-2.974-5.746-5.031c-2.361-2.061-5.325-4.729-11.193-11.999-5.869-7.272-1.149-2.907 3.629 2.305 4.78 5.212 13.916 12.781 13.916 12.781s0-.119.059-1.695c.063-1.574.547-2.727 1.394-3.815.847-1.092.399-1.245-4.752-5.188-5.148-3.945-18.482-18.963-23.934-27.918-5.454-8.951-11.362-21.087-11.362-21.087s-2.876 17.904 8.031 37.626c10.903 19.721 21.659 26.093 24.538 28.218"
          S.path ! A.d "M103.9826 359.0549c5.977-2.315 4.339-8.21 4.339-8.307 0-.096-3.664 1.161-7.036 2.412-3.375 1.261-11.666 3.67-14.944 3.765-3.275.097-3.275-.382-3.373-.867-.097-.48 2.507 0 7.229-.866 4.726-.87 13.014-5.216 14.46-6.177 1.446-.97 1.252-1.163-.866-1.358-2.122-.189-3.953-1.158-4.726-1.831-.768-.675-2.986.291-8.383 1.549-5.402 1.252-16.582 3.183-25.163 3.183-8.578 0-16.579-1.448-17.929-1.739-1.35-.288-2.796.484 1.35 7.437 4.144 6.947 18.702 10.714 28.822 10.617 10.123-.098 20.243-5.502 26.22-7.818"
          S.path ! A.d "M77.068 344.715c10.443.088 14.334-3.016 14.334-3.016s0-.531-1.415-2.655c-1.416-2.125-1.149-5.76-1.149-5.76s-2.478.444-6.815 1.065c-4.337.619-9.378 1.239-14.954.264-5.576-.974-3.184-1.595 1.239-1.064 4.425.531 12.919-1.064 15.662-2.036 2.742-.976 1.591-1.86-.266-2.486-1.857-.615-6.901-3.809-6.901-3.809s-12.653 1.596-24.421.27c-11.768-1.336-19.204-4.345-21.592-4.699-2.389-.354-2.301.623-2.301.623s-.619 1.059 3.45 7.435c4.071 6.389 12.035 10.553 18.761 12.501 6.726 1.951 15.928 3.279 26.368 3.367"
          S.path ! A.d "M74.4152 320.258s-.442-.62-1.062-2.75c-.619-2.128 1.15-3.721 1.15-3.721s-2.39-.708-10.176-1.684c-7.788-.976-8.228-1.595-13.008-2.659-4.779-1.061-7.963-2.48-7.874-3.012.087-.531 1.591.268 4.425 1.328 2.829 1.064 14.776 2.304 19.821 3.015 5.044.709 7.873 1.243 8.759.709.886-.532 3.982-1.332 3.982-1.332s-2.123-.614-4.778-1.061c-2.656-.443-5.045-1.596-6.458-2.571-1.418-.976-1.86-1.245-8.231-1.948-6.373-.708-11.505-2.75-22.919-6.915-11.412-4.166-19.998-9.127-22.298-10.987-2.302-1.859-2.123-.528-1.504 1.86.62 2.395.53 5.404 6.284 12.14 5.749 6.738 8.582 9.659 23.093 14.981 14.511 5.312 30.794 4.607 30.794 4.607"
          S.path ! A.d "M31.4982 284.8977c12.831 9.04 27.869 12.359 31.058 12.76.715-.838-.777-3.841-.089-5.671.83-2.193 2.215-2.216 5.311-2.393 3.097-.182 1.062-.799.354-.799-.708 0-.885-.088-6.018-1.417-5.133-1.324-10.352-2.127-17.43-4.786-7.08-2.656-9.202-4.608-9.027-5.139.177-.529 3.274 1.687 9.823 4.166 6.547 2.481 14.158 3.456 18.317 4.346 4.159.879.531-.89-1.416-2.042-1.947-1.154-4.691-5.407-4.691-5.407s-4.602-.797-12.121-3.1c-7.523-2.305-13.804-4.878-20.087-8.42-2.159-1.223-4.245-2.794-6.498-4.41-4.306-3.089-8.633-6.245-10.314-7.464-2.569-1.86-1.77-.355-1.505.797.265 1.151 2.036 6.473 6.104 12.318 4.071 5.847 5.401 7.619 18.229 16.661"
          S.path ! A.d "M29.3756 259.4636c12.653 10.018 23.536 13.112 25.395 13.911 1.858.8 1.681-.265 1.328-1.328-.354-1.064-.622-4.516-.622-4.516s-4.513-2.574-9.558-5.498c-5.042-2.927-10.615-6.912-14.333-9.48-3.716-2.57-1.503-2.392-.354-1.422 1.149.976 6.284 3.991 11.415 7.179 5.133 3.192 12.918 7.799 12.918 7.799s.177-1.682 1.24-2.748c1.063-1.064 3.715-.793 3.715-.793s-1.328-1.332-2.124-2.571c-.794-1.246-4.956-2.571-9.644-4.79-4.69-2.212-13.098-8.414-19.292-13.642-6.192-5.226-18.228-18.343-19.022-19.408-.796-1.065-1.327-.884-1.416.443-.089 1.326-.531 2.216.796 8.24 1.33 6.025 6.903 18.61 19.558 28.624"
          S.path ! A.d "M74.1667 164.7639c1.434 2.978 3.006 5.229 4.138 7.172 1.711 2.93 2.674 4.83 2.674 4.83s.341-1.033.072-2.793c-.271-1.761-.541-4.201-.067-7.111.251-1.559.588-3.113.502-4.496-.1-1.574-.626-2.933-.84-3.831-.408-1.697-2.231-9.074-3.111-14.287-.879-5.216-1.825-12.663-1.758-19.233.067-6.568 1.015-3.252 1.015-.067 0 3.185.338 8.06 1.352 15.576 1.015 7.516 4.191 18.959 4.191 18.959s.203-1.76 1.15-4.267c.949-2.506 2.504-5.348 3.719-8.464 1.217-3.114.788-3.636.788-3.636s-4.442-21.264-5.608-31.312c-1.17-10.048-3.041-36.457-3.041-36.457-6.498 6.538-11.332 23.747-12.192 40.022-.644 12.262 1.337 23.612 1.911 28.214 1.137 9.112 2.718 16.226 5.105 21.181"
          S.path ! A.d "M59.7428 198.3205c.202-4.813 1.308-8.458 4.416-9.527 0 0-2.748-4.816-5.149-11.683-1.64-4.702-2.996-10.733-3.685-15.362-1.698-11.395-3.057-23.133.341-3.912 3.395 19.218 7.472 26.024 7.472 26.024l4.925 7.994c-.727-3.511-.843-5.98-.655-9.817.187-3.837.677-9.033 1.846-13.146 0 0-5.946-11.904-9.681-26.197-3.734-14.292-5.872-27.291-5.947-35.038-.339-7.485-.509-10.377-.509-10.377s-6.113 4.593-8.15 27.894c-2.039 23.305 4.078 45.591 7.132 54.097 3.057 8.502 7.644 19.05 7.644 19.05"
          S.path ! A.d "M126.444 376.0412s-.962-.674-3.856-2.51c-2.893-1.831-2.023-7.336-2.023-7.336s-.771.579-2.895 2.028c-2.12 1.448-4.53 3.086-7.421 4.246-2.892 1.16-4.341 1.93-6.17 2.51-1.832.582-1.349-.189.194-1.062 1.539-.866 2.025-1.352 5.881-2.895 3.853-1.545 11.565-8.303 11.565-8.303s-1.832-.195-5.012-.288c-3.18-.098-7.232-1.737-7.232-1.737s-3.177 2.895-16 8.396c-12.821 5.507-23.716 6.95-23.716 6.95s1.35 6.567 7.52 8.789c5.11 2.222 12.147 3.571 25.932.291 13.786-3.282 23.233-9.079 23.233-9.079"
          S.path ! A.d "M143.3127 389.1789c1.062-5.413-2.025-9.177-2.025-9.177s-.673.385-2.601 2.124c-1.929 1.74-4.726 5.023-10.122 7.723s-7.327 2.51-2.121-.291c5.206-2.801 12.821-10.715 12.821-10.715l-2.022-.773c-2.027-.773-5.498.579-19.958 9.265-14.457 8.69-22.943 8.984-22.943 8.984s6.458 7.819 24.004 7.24c17.548-.577 23.908-8.979 24.967-14.38"
          S.path ! A.d "M176.4762 382.8996s-1.929 2.7-4.533 4.437c-2.604 1.74-9.543 2.801-9.543 2.801s-.289.773-1.637 2.509c-1.35 1.739-4.34 5.893-7.423 8.114-3.082 2.222-7.905 3.664-8.194 3.085-.289-.579 2.797-1.736 5.785-3.57 2.987-1.831 5.686-5.216 7.711-7.529 2.025-2.32-.867-1.931-.867-1.931s-3.663.094-7.038-.193c-3.373-.294-2.699 0-3.663 1.642-.964 1.643-2.313 3.089-4.82 5.987-3.057 3.531-5.962 6.735-8.868 10.228-1.926 2.319-.482 2.994-.482 2.994s.869 1.451 8.675 2.317c4.819.537 10.041-.071 15.535-3.24 3.404-1.974 6.914-5.101 10.494-9.021 9.35-10.229 8.868-18.63 8.868-18.63"
          S.path ! A.d "M180.6217 404.0393c-1.929 2.513-2.99 3.576-2.99 3.576s1.35-4.152 2.508-6.085c.615-1.028 1.286-2.008 1.78-2.689-1.29-2.902-2.351-6.019-3.132-9.381-.857 2.777-3.527 10.927-6.844 16.225-4.046 6.464-7.615 8.783-5.301 10.516 2.314 1.739 6.843 2.128 11.954-.385 4.935-2.422 6.36-6.653 7.061-10.067-.865-1.344-1.679-2.736-2.431-4.194-.636.392-1.564 1.13-2.605 2.484"
          S.path ! A.d "M474.0427 263.7927c4.16-2.956 11.14-9.409 13.556-17.471 2.415-8.067 1.475-10.618-.403-9.277-1.878 1.344-11.41 7.529-13.961 9.277-2.55 1.751-6.444 4.166-6.843 3.225-.403-.945 4.424-3.761 8.325-8.465 3.888-4.708 13.285-13.311 13.421-21.782.134-8.47-2.416-9.541-4.159-7.393-1.748 2.153-9.668 9.815-12.889 12.905-3.221 3.091-7.92 7.261-8.589 6.587-.677-.673 3.891-4.836 8.454-9.812 4.561-4.975 9.665-10.618 10.74-20.435.768-7.049-.999-9.63-2.106-10.739-.468-.471-1.1-.714-1.587.186-1.29 2.377-4.993 9.027-7.723 12.302-3.35 4.03-8.455 9.545-11.54 12.769-3.082 3.228-4.026 4.438-4.563 4.037-.535-.406 2.818-5.245 5.369-8.338 2.551-3.094 8.589-9.542 12.621-18.413 4.021-8.873.667-21.916-1.075-23.261-1.745-1.343-2.017-.669-2.687.406-.673 1.077-5.771 12.904-9.261 17.879-3.486 4.976-7.656 11.561-9.798 14.385-2.149 2.823-3.759 6.048-4.432 5.643-.67-.405.402-2.953 4.296-9.274 3.895-6.319 10.741-18.149 11.006-24.335.272-6.179-.265-13.306-3.354-21.105-3.088-7.794-4.427-8.334-4.427-8.334s-1.344-1.61-2.017 1.75c-.667 3.36-3.894 16.535-8.856 26.75-4.97 10.217-6.98 13.712-11.412 20.435-4.431 6.72-8.325 11.428-8.325 13.309 0 1.88-.805 4.438 1.078 3.362 1.878-1.078 7.914-4.975 13.688-3.094 5.768 1.884 5.904 4.84 6.577 6.319.676 1.476.538 5.781-.268 7.526-.805 1.751-.672 2.287.132 2.959.812.67 2.823-.54 5.102-.54 2.283 0 6.58 0 9.128 3.094 2.553 3.093 2.151 7.393 1.078 10.887-1.078 3.496-3.626 5.111-3.626 5.111s4.026 1.074 5.501 2.148c1.478 1.078 3.49 3.095 3.49 7.529 0 4.437-5.5 8.199-7.519 9.413-2.01 1.207-2.951 1.612-2.951 1.612s4.97.806 4.834 8.335c-.135 7.526-5.234 9.545-7.25 10.752-2.012 1.211-4.026 1.476-4.026 2.419 0 .945 2.815 3.094 3.089 5.651.267 2.55.805 9.004-5.237 12.095-6.039 3.092-7.785 3.227-7.92 4.84-.136 1.613-1.208 6.318-4.16 8.736-2.954 2.422-5.099 2.959-6.446 3.494-1.34.544-3.085 1.616-3.488 3.227-.402 1.616-.402 5.648-4.696 8.607-4.296 2.956-8.998 3.629-10.609 3.629-1.609 0-4.83-1.481-4.966.534-.131 2.023.538 6.051-2.946 10.218-3.497 4.17-8.329 5.384-10.611 5.517-2.281.131-3.888-.539-5.498-1.083-1.616-.534-2.956-.534-3.9 1.482-.934 2.019-2.548 5.784-6.574 7.393-2.768 1.111-5.463 1.52-6.885 1.669.826 4.353 1.129 9.069.547 15.934.768 1.176 2.124 2.532 4.457 4.176 7.25 5.113 15.169 6.321 21.881 4.707 6.711-1.616 6.039-5.113 6.039-6.859 0-1.749-.267-3.628-2.815-4.299-2.554-.673-7.653-4.299-9.259-5.516-1.613-1.204-1.749-1.609-1.208-2.279.531-.673 1.742-.274 4.96 1.609 3.224 1.887 13.291 4.84 20.807 4.576 7.514-.27 11.276-2.962 9.795-6.324-1.472-3.356-1.875-3.356-6.036-4.435-4.158-1.075-7.384-3.628-8.189-4.569-.803-.941-1.476-1.61-.803-2.286.673-.676 2.683 0 6.442 1.745 3.758 1.748 11.004 1.748 15.971-.136 4.966-1.879 5.639-3.493 4.833-5.239-.804-1.752-2.012-2.686-6.174-4.17-4.16-1.475-7.516-3.092-7.114-4.167.402-1.075 6.574.405 10.6.674 4.032.271 13.696.271 17.59-2.554 3.89-2.824 5.635-6.72 3.353-8.604-2.28-1.884-5.366-1.884-9.397-2.551-4.024-.673-6.709-1.078-6.442-2.421.268-1.347 2.282-1.214 10.335-.674 8.055.538 13.424-.401 17.584-3.229 4.164-2.819 5.237-6.853 4.565-8.198-.671-1.344-3.756-3.363-8.858-3.898-5.104-.537-6.577-.405-7.25-1.343-.676-.941-.537-1.214 2.684-1.883 3.223-.673 10.873-1.347 17.72-5.918 6.849-4.567 6.71-7.255 6.71-9.274 0-2.019-2.412-3.092-6.979-3.092-4.566 0-9.529-.537-10.74-.537-1.208 0-1.742-.133-1.881-.938-.132-.809.673-1.078 6.042-2.022 5.371-.938 11.008-3.089 15.976-8.601 4.967-5.513 4.293-12.369 4.293-12.369s0-2.418-3.358-1.476c-3.354.938-8.049 2.687-11.945 4.567-3.891 1.884-6.709 3.092-7.112 2.154-.399-.948 6.312-4.574 10.474-7.533"
          S.path ! A.d "M456.6335 245.382c-2.766-1.039-7.091-.521-8.642 0-1.558.516-2.424 1.212-3.288.516-.861-.689.518-2.251 3.979-3.979 3.456-1.736 8.815-5.715 8.298-10.216-.521-4.504-2.421-6.064-7.782-6.581-5.357-.519-8.992 3.463-10.544 4.501-1.557 1.04-6.223 4.157-7.089 2.946-.868-1.212 1.727-3.64 4.839-6.93 3.111-3.29 6.571-10.217 3.112-14.198-3.458-3.981-7.951-3.637-13.488-1.212-5.531 2.427-6.046 5.022-7.431 3.982-1.384-1.039 0-4.848 0-8.484 0-3.634-2.766-7.273-2.766-7.273s-7.437 15.415-16.947 26.323c-9.512 10.909-19.022 20.606-18.671 28.4.344 7.788 4.49 12.809 13.658 17.311 9.159 4.502 11.755 11.601 9.507 17.84-2.248 6.233-6.397 10.558-15.384 10.386-8.995-.174-14.181 1.043-17.637 6.065-3.458 5.022-7.958 6.923-11.413 7.096l-2.279.117c.114 3.418.398 7.078.898 10.962.746 5.724 1.563 10.452 2.391 14.49.241.373.547.758.935 1.082 1.249 1.037 1.666 1.522 1.734 2.356.068.829 1.318 2.004 1.941 2.769.62.761 2.976 2.009 2.488 2.357-.482.344-1.311-.414-2.21-1.037-.901-.626-2.089-1.651-2.94-2.392l-.986-.797c1.429 6.069 2.836 10.403 3.917 14.457 2.096.362 5.956.547 9.501-1.936 5.184-3.641 3.285-8.834 2.418-10.044-.863-1.214-1.384-2.248-.349-2.772 1.042-.52 2.253-.347 3.46.864 1.211 1.214 7.78 7.446 15.046 4.677 7.261-2.77 5.361-9.87 4.324-12.294-1.04-2.427-2.592-5.199-1.561-6.23 1.04-1.04 2.768-.522 4.152.688 1.384 1.211 9.339 3.288 14.179.344 4.843-2.945 5.704-7.794 3.282-10.731-2.419-2.945-8.123-3.639-6.741-5.716 1.381-2.077 4.15 1.214 6.224 1.904 2.077.69 7.087 1.737 12.106-1.037 5.01-2.771 5.184-6.75 2.242-8.834-2.939-2.077-6.221-3.465-4.493-5.193 1.729-1.736 3.809.174 5.534.518 1.728.347 7.611.867 11.237-2.421 3.633-3.294 3.465-5.026 2.598-8.834-.867-3.809-5.539-4.331-7.958-5.022-2.419-.693-3.282-1.214-2.936-2.425.344-1.21 1.898-.517 6.223-1.21 4.324-.696 12.104-4.502 12.795-7.966.694-3.465-.689-7.964-5.363-8.137-4.666-.174-8.472-.174-8.301-1.564.174-1.384 1.04-.863 2.769-1.211 1.731-.343 10.376-2.074 14.524-6.749 4.153-4.68-.343-8.487-3.112-9.526"
          S.path ! A.d "M488.1003 228.3737s10.904-8.798 18.627-24.424c7.728-15.626 10.149-27.913 11.208-37.928 1.064-10.01-.606-16.687-1.814-21.389-1.216-4.704-2.424-8.194-3.634-1.823-1.214 6.375-8.181 28.066-11.361 36.716-3.182 8.65-9.394 17.295-12.268 21.844-.902 1.421-2.181 2.936-3.047 4.342-1.919 3.093-3.168 5.674-3.168 5.674s.778.111 1.687-1.084c.914-1.195 1.69-2.036 2.745-1.755 1.051.282 2.527 5.687 2.527 5.687s4.211-4.985 7.867-11.096c3.653-6.114 8.36-17.634 8.36-17.634s-2.67 11.519-7.725 19.317c-5.061 7.795-7.799 11.309-7.799 11.309s.49 3.022-.142 5.693c-.635 2.669-2.063 6.551-2.063 6.551"
          S.path ! A.d "M529.2966 180.2819s-5.904 12.137-11.36 21.087c-5.449 8.955-18.782 23.973-23.932 27.917-5.146 3.944-5.598 4.097-4.748 5.188.844 1.088 1.328 2.242 1.393 3.816.059 1.576.059 1.695.059 1.695s9.133-7.568 13.917-12.782c4.778-5.212 9.498-9.575 3.626-2.304-5.865 7.27-8.83 9.938-11.189 11.999-2.361 2.057-5.748 5.031-5.748 5.031s-.179 3.874-.606 5.752c-.426 1.878-1.097 3.448-1.097 3.448s4.242-2.879 7.122-5.004c2.876-2.124 13.631-8.496 24.542-28.219 10.904-19.721 8.021-37.624 8.021-37.624"
          S.path ! A.d "M476.3346 115.3684c-.861-16.277-5.695-33.485-12.192-40.023 0 0-1.869 26.411-3.041 36.458-1.167 10.048-5.608 31.311-5.608 31.311s-.431.523.785 3.636c1.216 3.117 2.771 5.958 3.723 8.465.943 2.507 1.144 4.267 1.144 4.267s3.176-11.443 4.196-18.96c1.012-7.515 1.349-12.39 1.349-15.576 0-3.183.953-6.499 1.017.068.067 6.568-.881 14.017-1.76 19.232-.876 5.213-2.706 12.591-3.106 14.288-.221.897-.743 2.257-.844 3.831-.085 1.384.253 2.936.506 4.495.474 2.911.202 5.349-.067 7.112-.271 1.76.07 2.793.07 2.793s.961-1.902 2.674-4.831c1.129-1.942 2.703-4.193 4.137-7.171 2.39-4.954 3.964-12.069 5.105-21.182.571-4.601 2.558-15.951 1.912-28.213"
          S.path ! A.d "M491.3825 179.2702c3.057-8.506 9.177-30.791 7.132-54.097-2.033-23.299-8.149-27.894-8.149-27.894s-.17 2.892-.511 10.378c-.076 7.746-2.207 20.745-5.946 35.037-3.735 14.293-9.675 26.197-9.675 26.197 1.16 4.113 1.653 9.31 1.842 13.146.186 3.837.07 6.306-.658 9.817l4.925-7.994s4.075-6.806 7.473-26.024c3.403-19.22 2.039-7.483.34 3.913-.688 4.628-2.042 10.659-3.688 15.361-2.398 6.868-5.14 11.683-5.14 11.683 3.104 1.069 4.211 4.714 4.414 9.527.001 0 4.585-10.548 7.641-19.05"
          S.path ! A.d "M495.8932 348.8176c-1.352.291-9.35 1.739-17.931 1.739-8.578 0-19.758-1.93-25.16-3.182-5.398-1.258-7.617-2.225-8.387-1.549-.77.673-2.6 1.642-4.725 1.83-2.121.194-2.313.389-.863 1.358 1.44.961 9.735 5.308 14.461 6.177 4.721.866 7.323.389 7.228.866-.101.486-.101.965-3.376.867-3.277-.094-11.569-2.503-14.942-3.764-3.37-1.252-7.038-2.51-7.038-2.412 0 .097-1.638 5.992 4.339 8.306 5.974 2.317 16.098 7.72 26.222 7.818 10.123.096 24.679-3.67 28.821-10.617 4.146-6.952 2.701-7.725 1.351-7.437"
          S.path ! A.d "M512.6901 320.7893c-2.389.354-9.82 3.362-21.586 4.699-11.768 1.325-24.426-.27-24.426-.27s-5.043 3.194-6.9 3.808c-1.859.626-3.012 1.511-.268 2.487 2.744.972 11.238 2.569 15.662 2.036 4.426-.532 6.812.089 1.241 1.064-5.578.976-10.62.355-14.958-.264-4.334-.621-6.815-1.065-6.815-1.065s.268 3.635-1.146 5.76c-1.414 2.124-1.413 2.655-1.413 2.655s3.89 3.104 14.331 3.016c10.438-.088 19.644-1.416 26.368-3.367 6.726-1.949 14.69-6.113 18.76-12.501 4.07-6.376 3.447-7.435 3.447-7.435s.09-.978-2.297-.623"
          S.path ! A.d "M527.736 286.6692c-2.301 1.86-10.885 6.821-22.298 10.987-11.42 4.164-16.547 6.207-22.921 6.915-6.372.702-6.815.973-8.228 1.948-1.419.976-3.806 2.128-6.458 2.571-2.652.446-4.779 1.061-4.779 1.061s3.094.8 3.982 1.331c.882.535 3.715 0 8.76-.708 5.039-.711 16.988-1.951 19.821-3.015 2.829-1.061 4.334-1.86 4.422-1.328.092.531-3.094 1.951-7.876 3.012-4.776 1.064-5.219 1.684-13.006 2.659-7.788.975-10.177 1.684-10.177 1.684s1.77 1.593 1.152 3.72c-.621 2.131-1.065 2.751-1.065 2.751s16.282.705 30.79-4.609c14.518-5.321 17.347-8.242 23.101-14.98 5.75-6.736 5.663-9.745 6.279-12.14.622-2.388.802-3.718-1.499-1.859"
          S.path ! A.d "M534.8151 255.1208c-1.684 1.22-6.009 4.375-10.32 7.463-2.254 1.616-4.334 3.189-6.497 4.411-6.275 3.541-12.56 6.115-20.082 8.419-7.52 2.304-12.122 3.101-12.122 3.101s-2.745 4.252-4.691 5.407c-1.947 1.152-5.574 2.921-1.419 2.042 4.161-.89 11.769-1.865 18.319-4.346 6.547-2.48 9.651-4.696 9.822-4.166.173.531-1.948 2.483-9.025 5.139-7.083 2.659-12.296 3.462-17.428 4.786-5.137 1.328-5.314 1.417-6.022 1.417-.705 0-2.744.617.356.799 3.093.177 4.481.2 5.309 2.392.691 1.831-.805 4.834-.091 5.672 3.195-.4 18.228-3.721 31.061-12.76 12.83-9.043 14.155-10.814 18.226-16.661 4.073-5.845 5.838-11.167 6.103-12.319.267-1.151 1.065-2.656-1.499-.796"
          S.path ! A.d "M486.6755 263.3606c1.062 1.066 1.24 2.748 1.24 2.748s7.784-4.608 12.915-7.799c5.133-3.189 10.27-6.204 11.419-7.179 1.15-.97 3.363-1.149-.354 1.422-3.715 2.569-9.286 6.553-14.332 9.48-5.045 2.924-9.559 5.498-9.559 5.498s-.267 3.452-.617 4.517c-.355 1.063-.534 2.127 1.325 1.327 1.859-.799 12.742-3.893 25.399-13.911 12.653-10.014 18.227-22.599 19.552-28.624 1.325-6.026.885-6.916.797-8.241-.089-1.326-.62-1.508-1.417-.443-.796 1.065-12.832 14.182-19.024 19.408-6.195 5.228-14.599 11.43-19.288 13.642-4.691 2.219-8.848 3.544-9.648 4.79-.793 1.24-2.121 2.571-2.121 2.571s2.651-.27 3.713.794"
          S.path ! A.d "M434.0036 360.6955s-4.049 1.64-7.226 1.736c-3.185.094-5.015.287-5.015.287s7.711 6.759 11.565 8.305c3.856 1.543 4.337 2.027 5.883 2.895 1.54.873 2.025 1.643.193 1.061-1.836-.579-3.281-1.349-6.17-2.51-2.895-1.16-5.301-2.797-7.422-4.246-2.122-1.448-2.892-2.027-2.892-2.027s.866 5.504-2.025 7.336c-2.892 1.836-3.859 2.51-3.859 2.51s9.45 5.797 23.23 9.08c13.787 3.28 20.826 1.93 25.932-.291 6.17-2.222 7.52-8.789 7.52-8.789s-10.887-1.443-23.715-6.951c-12.819-5.501-15.999-8.396-15.999-8.396"
          S.path ! A.d "m406.2428 378.0705-2.027.773s7.614 7.915 12.821 10.715c5.207 2.801 3.28 2.991-2.118.291-5.402-2.7-8.191-5.983-10.124-7.722-1.928-1.74-2.604-2.124-2.604-2.124s-3.08 3.763-2.027 9.176c1.064 5.402 7.429 13.803 24.972 14.381 17.543.579 24.003-7.24 24.003-7.24s-8.485-.294-22.943-8.983c-14.463-8.688-17.928-10.038-19.953-9.267"
          S.path ! A.d "M401.2272 398.2502c-2.504-2.897-3.854-4.344-4.82-5.986-.967-1.643-.287-1.937-3.661-1.643-3.376.287-7.039.193-7.039.193s-2.891-.388-.866 1.931c2.025 2.314 4.728 5.698 7.713 7.529 2.986 1.833 6.071 2.991 5.78 3.571-.287.579-5.107-.864-8.189-3.085-3.088-2.222-6.077-6.374-7.423-8.114-1.354-1.737-1.642-2.509-1.642-2.509s-6.945-1.062-9.542-2.801c-2.601-1.736-4.535-4.438-4.535-4.438s-.481 8.402 8.871 18.63c3.577 3.92 7.088 7.047 10.495 9.022 5.489 3.168 10.717 3.776 15.536 3.239 7.804-.864 8.672-2.316 8.672-2.316s1.445-.676-.482-2.994c-2.908-3.494-5.806-6.697-8.868-10.229"
          S.path ! A.d "M364.6911 389.461c-.775 3.362-1.84 6.479-3.126 9.381.493.682 1.16 1.66 1.777 2.688 1.158 1.935 2.506 6.086 2.506 6.086s-1.06-1.064-2.987-3.576c-1.037-1.354-1.97-2.092-2.605-2.483-.752 1.458-1.568 2.85-2.433 4.193.699 3.415 2.125 7.647 7.061 10.068 5.108 2.513 9.642 2.124 11.954.385 2.317-1.734-1.251-4.053-5.3-10.516-3.318-5.3-5.986-13.45-6.847-16.226"
          S.path ! A.d "M360.3131 145.88c0 1.813 1.609 3.287 3.588 3.287 1.98 0 3.582-1.474 3.582-3.287 0-1.821-1.603-3.294-3.582-3.294-1.978 0-3.588 1.473-3.588 3.294"
          S.path ! A.d "M320.2926 144.0686c1.866 1.053 3.803 2.121 5.753 2.683 6.976 2.001 14.221.762 19.704-1.717 7.018-3.727 12.795-6.212 17.062-6.626 3.609-.347 5.369 1.201 8.645 1.28 1.065.026 1.975-.227 2.362-1.001.685-1.38.271-4.831-4.678-7.597-4.952-2.755-12.383-2.621-18.99-.683-6.606 1.928-10.458 4.549-13.07 6.483-2.615 1.932-5.715 4.905-6.465 4.283-.755-.629 1.511-2.073 2.751-3.315 1.234-1.243 1.789-1.657 1.789-1.657-7.252.495-15.036-1.945-21.331-6.487 0 0-2.063 9.52 6.468 14.354"
          S.path ! A.d "M393.7692 139.652c-4.819-2.21-9.635-1.934-15.548.276-5.918 2.209-8.812 4.002-8.812 4.002s.831 5.104-2.745 7.45c-3.579 2.351-7.153.967-8.12-1.378-.966-2.348-1.236-3.59-1.236-3.59s-5.643 3.176-13.351 4.555c-4.367.782-12.451 1.653-17.608-.416 0 0-4.681 4.555-8.12 7.315-3.438 2.76-7.155 5.104-7.155 5.104s.411 1.107 2.063 1.66c1.654.55 2.2.827 1.105 2.62-1.105 1.794-9.083 8.973-12.521 11.452-3.441 2.487-8.531 4.42-8.531 4.42s1.646 3.037 3.989 4.001c2.339.967 2.753 2.484 1.789 4.143-.967 1.657-9.221 10.766-12.662 13.938-3.436 3.173-6.051 3.587-7.567 4.002-1.511.416-4.261 1.933-1.232 5.382 3.024 3.451 10.177 4.696 17.331 2.624 7.155-2.073 14.035-10.492 14.035-10.492s-1.517 12.147-1.517 17.806c0 5.658.69 12.144 1.654 15.457.964 3.312 1.922 4.966 1.922 4.966s4.817-2.755 8.123-11.176c3.303-8.42 4.128-13.114 4.128-15.596 0-2.483.136-3.866 2.339-2.621 2.201 1.242 3.853 2.206 4.679 2.345.822.138 1.375.138 1.375.138s-1.375-6.072-1.375-10.627c0-4.554 1.513-14.489 3.438-16.285 1.931-1.792 2.289.676 2.478 1.797.394 2.339 2.377 5.191 5.23 6.072.935-6.704 2.393-12.208 7.975-18.081 1.014-1.059 1.652-2.481 5.096-1.103 5.076 2.033 11.596 3.321 16.697 1.336 5.107-1.988 8.792-7.25 7.651-7.82-.27-.141-7.836 3.724-13.755 1.791-5.915-1.931-8.673-3.863-5.228-7.452 3.438-3.587 4.949-3.999 11.831-9.662 6.882-5.656 12.384-8.554 18.44-7.586 6.053.962 7.153 4.551 7.702 5.24.55.694 3.167 2.763 3.167-2.203 0-4.973-2.339-11.597-7.154-13.804"
          S.path ! A.d "M329.1496 237.5085c-1.19-1.712-3.362-6.517-3.362-6.517s-.197 1.183-1.446 4.608c-1.252 3.422-4.807 8.3-4.807 8.3s2.829-.592 5.992-1.58c3.159-.988 5.333-2.83 5.333-2.83s-.529-.268-1.71-1.981"
          S.path ! A.d "M304.6505 218.8698s-1.981 5.007-6.392 9.355c-4.413 4.347-7.705 3.818-7.705 3.818s.458-.132 3.752-2.437c3.294-2.306 6.585-9.021 6.585-9.021-3.616 2.175-11.939 4.238-16.329 3.357 0 0-.661 1.515-1.713 4.216-1.055 2.699-4.15 7.707-5.795 9.881-1.651 2.172-.399 2.5-.399 2.5s.79.921 11.196 3.822c10.408 2.896 19.762 1.251 19.762 1.251s-.398-.926-2.175-8.035c-1.78-7.112-.787-18.707-.787-18.707"
          S.path ! A.d "M175.8966 145.88c0 1.813 1.603 3.287 3.585 3.287 1.981 0 3.586-1.474 3.586-3.287 0-1.821-1.605-3.294-3.586-3.294-1.982 0-3.585 1.473-3.585 3.294"
          S.path ! A.d "M171.9245 139.6872c3.275-.079 5.035-1.627 8.648-1.28 4.263.414 10.042 2.901 17.059 6.626 5.484 2.481 12.73 3.719 19.705 1.717 1.953-.562 3.884-1.629 5.752-2.683 8.531-4.834 6.466-14.355 6.466-14.355-6.294 4.541-14.077 6.982-21.326 6.486 0 0 .55.415 1.788 1.657 1.239 1.242 3.505 2.686 2.753 3.315-.75.622-3.851-2.351-6.467-4.283-2.615-1.933-6.467-4.554-13.072-6.482-6.604-1.938-14.034-2.072-18.988.683-4.954 2.765-5.364 6.217-4.677 7.596.383.776 1.296 1.029 2.359 1.003"
          S.path ! A.d "M264.6403 209.2067c-1.514-.415-4.125-.829-7.565-4.001-3.441-3.173-11.695-12.282-12.661-13.938-.962-1.66-.55-3.176 1.789-4.144 2.339-.964 3.989-4.001 3.989-4.001s-5.088-1.934-8.528-4.419c-3.441-2.481-11.423-9.66-12.524-11.453-1.1-1.793-.549-2.069 1.101-2.62 1.654-.553 2.066-1.659 2.066-1.659s-3.716-2.345-7.154-5.104c-3.441-2.761-8.119-7.316-8.119-7.316-5.155 2.07-13.243 1.198-17.613.417-7.705-1.38-13.345-4.555-13.345-4.555s-.276 1.242-1.239 3.589c-.962 2.346-4.539 3.728-8.117 1.378-3.578-2.345-2.754-7.45-2.754-7.45s-2.889-1.792-8.805-4.002c-5.917-2.21-10.732-2.487-15.547-.276-4.817 2.207-7.157 8.831-7.157 13.803 0 4.966 2.617 2.898 3.166 2.204.551-.689 1.652-4.279 7.706-5.241 6.055-.968 11.559 1.931 18.437 7.586 6.878 5.663 8.393 6.075 11.832 9.662 3.44 3.59.689 5.52-5.228 7.453-5.914 1.934-13.483-1.932-13.761-1.792-1.137.57 2.552 5.832 7.655 7.82 5.105 1.986 11.626.698 16.702-1.336 3.439-1.377 4.08.044 5.088 1.103 5.588 5.873 7.043 11.378 7.982 18.081 2.854-.88 4.833-3.732 5.228-6.071.19-1.122.551-3.59 2.478-1.798 1.924 1.798 3.439 11.731 3.439 16.286 0 4.554-1.377 10.627-1.377 10.627s.55 0 1.377-.139c.827-.138 2.476-1.103 4.68-2.345 2.201-1.245 2.339.138 2.339 2.621s.825 7.176 4.127 15.596c3.303 8.421 8.117 11.176 8.117 11.176s.966-1.654 1.928-4.966c.961-3.313 1.651-9.798 1.651-15.457 0-5.66-1.514-17.806-1.514-17.806s6.881 8.421 14.033 10.492c7.156 2.071 14.311.828 17.338-2.624 3.025-3.447.274-4.965-1.24-5.381"
          S.path ! A.d "M217.592 230.9914s-2.174 4.805-3.357 6.517c-1.186 1.713-1.713 1.981-1.713 1.981s2.173 1.842 5.335 2.83c3.161.988 5.995 1.58 5.995 1.58s-3.559-4.878-4.809-8.3c-1.252-3.424-1.451-4.608-1.451-4.608"
          S.path ! A.d "M260.5348 228.1579c-1.055-2.7-1.713-4.216-1.713-4.216-4.391.88-12.719-1.182-16.336-3.357 0 0 3.294 6.715 6.587 9.021 3.296 2.304 3.754 2.437 3.754 2.437s-3.292.529-7.705-3.818c-4.412-4.347-6.387-9.355-6.387-9.355s.986 11.594-.792 18.705c-1.778 7.11-2.172 8.036-2.172 8.036s9.35 1.646 19.759-1.251c10.404-2.901 11.195-3.822 11.195-3.822s1.248-.328-.396-2.5c-1.647-2.173-4.741-7.181-5.794-9.88"
          S.path ! A.d "M224.0373 488.9582c2.194.731 6.291-.875 8.342-3.363 2.048-2.49 2.78-6.298 4.243-8.491 1.463-2.197 2.525-3.823 2.525-3.823s-.312 3.617-2.254 8.466c-1.85 4.621-2.174 10.942-1.734 13.652.879 5.413 4.39 6.291 6.438 5.557 1.556-.553 3.913-2.953 6.076-6.55.683-1.14 1.16-2.719 1.829-3.985 1.391-2.633 2.633-6.947 3.246-6.826 1.355.264.486 3.311-.025 5.362-1.025 4.097-3.073 10.1-3.221 13.759-.147 3.659.294 10.244 3.952 10.538 3.658.291 5.561-2.93 7.608-10.394 2.049-7.46 2.491-9.805 3.367-9.805.879 0 .879 5.122.879 7.317 0 .755.029 2.836.328 4.925.569 3.999 1.736 8.801 2.892 9.859 1.754 1.61 3.22 1.314 3.22 1.314s1.461.297 3.221-1.314c1.755-1.61 3.218-12.59 3.218-14.784 0-2.194 0-7.317.875-7.317.885 0 1.318 2.345 3.368 9.805 2.051 7.464 3.952 10.685 7.611 10.394 3.658-.294 4.102-6.879 3.955-10.538-.147-3.659-2.195-9.662-3.224-13.759-1.025-4.099.44-3.805 3.224 1.464.867 1.646 1.766 3.661 2.648 5.069 1.951 3.104 3.847 4.963 5.254 5.466 2.045.734 5.559-.144 6.438-5.557.879-5.419-3.22-20.931-3.22-20.931s.294.438 1.757 2.636c1.463 2.192 2.192 6 4.246 8.489 2.045 2.489 6.147 4.096 8.342 3.364 2.195-.731 2.489-4.833.876-12.15-1.61-7.318-8.196-11.413-12.881-17.271-4.308-5.38-7.627-14.851-8.128-16.335-5.895 2.918-11.063 6.233-15.736 11.111-9.685 10.105-11.789 12.629-11.789 12.629s-2.108-2.524-11.791-12.629c-4.704-4.909-9.903-8.228-15.842-11.162-.548 1.249-4.574 10.295-8.924 15.74-2.165 2.706-5.146 4.748-7.264 7.345-2.462 3.019-3.96 6.639-4.826 10.571-1.607 7.319-1.314 11.421.881 12.152"
          S.path ! A.d "M223.7814 513.758c2.835-2.495 4.293-3.87 4.293-3.87s2.061-1.716 1.546 1.549c-.518 3.261-1.634 9.962-.945 12.88.686 2.92 1.03 5.41 4.636 3.261 3.607-2.145 4.466-3.435 6.183-5.236 1.716-1.805 3.52-2.574 3.091.259-.432 2.832-1.719 7.125-1.117 12.88.602 5.75 3.436 6.608 7.126 1.715 3.694-4.892 5.924-9.356 7.041-11.763 1.117-2.404 3.351-4.463 3.351 0 0 9.606 2.202 23.576 12.793 27.305 10.593-3.729 12.797-17.699 12.797-27.305 0-4.463 2.228-2.404 3.341 0 1.12 2.406 3.35 6.871 7.044 11.763 3.691 4.893 6.527 4.035 7.125-1.715.6-5.754-.688-10.048-1.116-12.88-.426-2.833 1.375-2.064 3.094-.259 1.717 1.801 2.571 3.091 6.18 5.236 3.609 2.149 3.95-.341 4.637-3.261.685-2.918-.43-9.619-.943-12.88-.517-3.265 1.543-1.549 1.543-1.549s1.46 1.375 4.296 3.87c2.829 2.488 6.72 2.639 6.72 2.639s1.822-10.082-2.38-16.104c-4.202-6.021-5.746-7.981-5.746-7.981s-2.377-.139-4.196-.838c-1.819-.702-3.588-2.016-3.588-2.016v5.58s5.149 4.893 6.353 6.354c1.199 1.454 3.606 3.946.089 1.542-3.521-2.404-6.442-4.808-6.442-4.808s-.688 5.067-2.148 6.357c-1.458 1.284-3.521 1.454-4.376 1.113l-.857-.347-.259 1.981s3.173 5.924 3.603 8.328c.432 2.403-.259 2.142-1.716-.948-1.461-3.086-4.29-7.039-5.58-9.183-1.287-2.146-3.177-3.609-3.006-.858.173 2.748-.941 7.725-1.89 9.527-.941 1.805-1.543 2.403-1.543 2.403s1.972 6.959 2.231 8.246c.262 1.286.085 2.747-1.028 1.114-1.116-1.631-4.296-8.499-4.296-8.499s-4.208-.171-5.407-1.375c-1.202-1.206-3.092-5.833-3.092-5.833s-1.722 5.91-3.148 7.807c-1.422 1.897-4.74 3.788-4.74 3.788s-.238 10.279-.47 12.096c-.241 1.816-.317 2.606-1.087 2.606-.768 0-.85-.79-1.088-2.606-.232-1.816-.47-12.096-.47-12.096s-3.321-1.893-4.745-3.788c-1.419-1.898-3.144-7.807-3.144-7.807s-1.888 4.627-3.092 5.833c-1.2 1.204-5.408 1.375-5.408 1.375s-3.177 6.868-4.293 8.499c-1.115 1.633-1.289.172-1.03-1.114.259-1.287 2.232-8.246 2.232-8.246s-.603-.599-1.546-2.403c-.945-1.802-2.061-6.779-1.887-9.527.169-2.75-1.72-1.287-3.008.858-1.288 2.144-4.119 6.097-5.58 9.183-1.459 3.09-2.146 3.352-1.716.948.429-2.404 3.604-8.328 3.604-8.328l-.257-1.981-.857.347c-.86.341-2.92.171-4.38-1.113-1.46-1.29-2.147-6.357-2.147-6.357s-2.918 2.403-6.438 4.808c-3.522 2.403-1.116-.088.088-1.542 1.2-1.461 6.35-6.354 6.35-6.354v-5.58s-1.765 1.314-3.585 2.016c-1.821.699-4.201.838-4.201.838s-1.539 1.96-5.74 7.981c-4.202 6.022-2.38 16.104-2.38 16.104s3.888-.151 6.721-2.639"
          S.path ! A.d "M212.4171 548.0627c2.532-1.608 4.728-3.389 10.466-7.197 5.739-3.812 7.848-8.043 7.848-8.043h-2.025c-1.097 0-2.026-1.526-2.108-3.047-.086-1.526 0-4.655.42-8.297.42-3.638-.591-6.603-.591-6.603s-2.447 2.281-6.16 4.232c-3.713 1.948-5.235 1.015-5.235 1.015l-.929-3.721s-1.6 3.389-3.881 7.361c-2.28 3.98-8.441 8.384-12.828 11.682-4.391 3.303-9.203 6.776-12.831 8.045-3.628 1.267-1.517 2.965-1.517 2.965s3.629 3.635 12.997 5.328c9.369 1.693 13.842-2.114 16.374-3.72"
          S.path ! A.d "M245.1662 544.422c-3.347-.354-5.348-1.616-5.993-5.251-.424-2.368.17-11.429.17-11.429s-1.099.929-2.364 2.459c-1.268 1.52-4.137 1.861-4.137 1.861s-.422 1.269-1.687 3.297c-1.267 2.036-2.871 4.492-6.079 6.52-3.205 2.033-6.919 4.405-9.366 6.436-2.45 2.033-5.317 4.405-8.525 6.179-3.207 1.778-6.077 4.658-7.176 9.395-1.094 4.74-.25 6.264 3.462 6.012 3.714-.256 4.136.085 10.13-1.443 5.993-1.522 14.517-8.208 20.76-12.185 6.247-3.982 10.805-11.851 10.805-11.851"
          S.path ! A.d "M261.7926 549.922s-2.533-3.212-3.461-6.858c-.93-3.639-2.701-10.832-2.701-10.832s-.844 2.286-2.869 6.596c-2.028 4.321-5.485 5.34-5.485 5.34s-.171 1.859-3.04 5.5c-2.87 3.639-7.088 7.024-11.395 9.568-4.305 2.533-9.875 6.012-12.914 10.327-3.035 4.317-3.291 8.8-1.854 10.75 1.434 1.944 3.458-.256 6.327-1.694 2.871-1.437 11.057-2.709 22.367-8.803 11.311-6.097 15.025-19.894 15.025-19.894"
          S.path ! A.d "M266.6852 575.2326c3.123-4.655 3.631-15.994 3.631-15.994s-1.096-.762-2.618-2.036c-1.516-1.27-4.472-5.754-4.472-5.754s-1.856 3.891-3.881 7.532c-2.026 3.644-3.041 4.911-7.26 8.804-4.22 3.896-9.959 7.705-12.409 11.853-2.445 4.147-1.096 12.443.509 15.235 1.603 2.797 3.882 1.859 6.245-.42 2.364-2.283 3.122-2.877 7.258-6.433 4.135-3.556 9.877-8.13 12.997-12.787"
          S.path ! A.d "M358.9938 543.4895c-3.632-1.27-8.445-4.743-12.833-8.045-4.384-3.297-10.547-7.702-12.827-11.682-2.279-3.972-3.879-7.361-3.879-7.361l-.931 3.721s-1.52.934-5.231-1.015c-3.714-1.95-6.16-4.231-6.16-4.231s-1.017 2.965-.59 6.603c.417 3.641.505 6.77.417 8.296-.086 1.523-1.011 3.047-2.111 3.047h-2.025s2.111 4.231 7.849 8.043c5.739 3.809 7.934 5.59 10.465 7.197 2.536 1.608 7.008 5.412 16.377 3.721 9.365-1.693 12.994-5.328 12.994-5.328s2.114-1.698-1.515-2.966"
          S.path ! A.d "M336.3722 554.4953c-3.206-1.775-6.077-4.146-8.524-6.18-2.446-2.03-6.164-4.402-9.366-6.435-3.206-2.028-4.811-4.485-6.077-6.521-1.267-2.027-1.691-3.297-1.691-3.297s-2.87-.341-4.134-1.86c-1.264-1.53-2.362-2.459-2.362-2.459s.591 9.06.167 11.429c-.647 3.635-2.645 4.898-5.989 5.251 0 0 4.555 7.869 10.8 11.85 6.245 3.979 14.77 10.664 20.761 12.186 5.995 1.527 6.415 1.187 10.129 1.442 3.712.253 4.558-1.272 3.459-6.011-1.095-4.738-3.967-7.618-7.173-9.395"
          S.path ! A.d "M310.716 559.2375c-4.305-2.545-8.525-5.93-11.393-9.568-2.867-3.641-3.038-5.5-3.038-5.5s-3.458-1.021-5.489-5.34c-2.023-4.311-2.871-6.597-2.871-6.597s-1.77 7.193-2.697 10.832c-.929 3.647-3.459 6.859-3.459 6.859s3.711 13.796 15.02 19.894c11.31 6.095 19.5 7.367 22.368 8.804 2.871 1.437 4.893 3.637 6.332 1.693 1.432-1.948 1.179-6.432-1.859-10.75-3.038-4.315-8.609-7.794-12.914-10.327"
          S.path ! A.d "M291.4733 567.7834c-4.223-3.894-5.234-5.161-7.258-8.804-2.025-3.64-3.885-7.532-3.885-7.532s-2.953 4.485-4.472 5.754c-1.52 1.274-2.618 2.036-2.618 2.036s.508 11.341 3.629 15.994c3.126 4.658 8.866 9.231 13 12.786 4.141 3.556 4.893 4.15 7.255 6.433 2.366 2.279 4.646 3.218 6.248.42 1.605-2.791 2.95-11.088.506-15.234-2.448-4.148-8.185-7.957-12.405-11.853"
          S.path ! A.d "M275.4411 580.9045c-2.715-3.174-3.62-4.755-3.62-4.755s-.905 1.581-3.617 4.755c-2.721 3.167-9.056 8.148-9.056 8.148s.565 8.378 3.622 12.901c2.575 3.82 5.041 7.31 9.052 9.962 4.011-2.652 6.479-6.142 9.053-9.962 3.06-4.524 3.623-12.901 3.623-12.901s-6.339-4.981-9.057-8.148"
      S.g
        ! A.fill "#005D95"
        $ do
          S.path ! A.d "M502.2907 477.9504c-2.524-.6-3.597-1.558-3.597-1.558s-1.081-.12-1.927 1.441c-.832 1.554-4.076 3.596-4.076 3.596s-4.558 1.206-5.161 4.327c-.599 3.117 1.561 4.196 3.721 3.838 2.165-.362 7.443-1.441 9.717-4.198 2.28-2.761 2.642-4.323 3.121-5.407.479-1.078.723-1.436-1.798-2.039"
          S.path ! A.d "M509.3727 453.1115c-1.641-6.938-6.122-15.514-14.761-19.807 0 0-3.241 11.406-4.2 15.008-.964 3.597-.964 3.48 1.799 4.199 2.756.718 11.637 2.637 13.437 3.119 1.801.481 4.801 2.042 3.725-2.519"
          S.path ! A.d "M468.2087 446.6282c2.036.361 1.799-.481 2.519-3.24.719-2.757 4.317-16.439 4.317-16.439s-9.116-.361-17.038 3.476c-7.922 3.841-11.402 10.921-11.402 10.921s2.042.84 7.444 2.042c5.397 1.198 12.118 2.879 14.16 3.24"
          S.path ! A.d "M447.0837 465.4709c-3.235-.601-4.437-.961-4.437-.961s2.039 7.795 5.401 12.121c3.359 4.32 7.079 6.486 14.04 6.604 6.96.12 12.239-3.721 13.08-6.721.841-3.003 2.28-5.278 2.28-5.278s-12.601-1.687-17.763-2.886c-5.158-1.198-9.36-2.279-12.601-2.879"
      S.g
        ! A.fill "#DE6F10"
        $ do
          S.path ! A.d "M346.3805 313.0168c-3.206-19.503 8.038-36.679 8.038-36.679l-21.881-25.58c-16.856 9.47-40.317 8.196-60.704-1.182-20.385 9.378-43.853 10.652-60.704 1.182l-21.879 25.58s11.241 17.176 8.032 36.679c-3.211 19.5-10.121 50.361-8.393 62.947 1.729 12.59 10.616 27.156 19.75 34.808 9.132 7.652 22.71 14.073 32.333 17.529 9.63 3.455 19.012 10.121 23.456 13.576 4.442 3.455 7.404 6.421 7.404 6.421s2.965-2.966 7.408-6.421c4.443-3.455 13.823-10.121 23.447-13.576 9.63-3.455 23.209-9.877 32.339-17.529 9.135-7.652 18.022-22.218 19.75-34.808 1.728-12.586-5.183-43.447-8.396-62.947"
          S.path ! A.d "M301.7204 202.7229c-3.2 3.68-11.041 7.203-11.041 7.203l-.161.641s3.12-.562 6.239-2.321c3.124-1.761 7.681-5.759 8.645-7.358.955-1.606-.161-2.725-.161-2.725s-.321.879-3.521 4.56"
          S.path ! A.d "M315.2462 210.1633c0 2.16-.808 16.724-.808 16.724-.045.666-.271 5.091-1.414 5.687.579.104 1.711.297 2.046-1.995.399-2.721 3.132-21.295 3.132-21.295l-1.602-.721c.001 0-1.354-.56-1.354 1.6"
          S.path ! A.d "M339.7164 173.2356c-1.384.391-4.754 2.871-6.536 4.356-1.783 1.484-2.974 1.484-4.658 2.278-1.681.793-1.09-2.87-.097-5.841.987-2.974 4.355-6.542 6.932-9.412 2.574-2.868-.103-1.979-1.29-.793-1.187 1.191-3.958 4.162-7.226 9.412-3.268 5.248-5.051 17.132-5.051 17.132s1.981-1.186 3.958-2.577c1.984-1.385 4.158-2.571 7.925-5.347 3.764-2.771 5.942-4.852 7.92-7.033 1.985-2.175-.49-2.573-1.877-2.175"
          S.path ! A.d "M241.6637 202.7229c-3.203-3.68-3.522-4.561-3.522-4.561s-1.119 1.119-.161 2.725c.961 1.598 5.521 5.597 8.641 7.358 3.123 1.76 6.242 2.321 6.242 2.321l-.16-.641c-.001 0-7.843-3.522-11.04-7.202"
          S.path ! A.d "M228.9391 226.8874s-.799-14.564-.799-16.724c0-2.159-1.361-1.6-1.361-1.6l-1.598.72s2.73 18.576 3.129 21.296c.339 2.292 1.467 2.099 2.046 1.995-1.142-.597-1.37-5.022-1.417-5.687"
          S.path ! A.d "M209.3097 163.8234c-1.188-1.186-3.86-2.075-1.286.793 2.574 2.87 5.942 6.438 6.931 9.413.992 2.969 1.586 6.632-.095 5.84-1.685-.793-2.874-.793-4.656-2.277-1.784-1.486-5.15-3.967-6.537-4.357-1.387-.398-3.862 0-1.882 2.175 1.981 2.182 4.161 4.263 7.922 7.033 3.766 2.776 5.942 3.961 7.924 5.347 1.981 1.391 3.961 2.577 3.961 2.577s-1.783-11.884-5.051-17.132c-3.269-5.249-6.043-8.221-7.231-9.412"
          S.path ! A.d "M271.529 501.8235c.353.073.42-.834.491-2.513.067-1.672.281-5.717.696-8.089.417-2.375-.629-2.234-1.258-2.092-.626.138-.973 1.951-.973 3 0 1.043.276 7.044.276 8.298.002 1.257.422 1.326.768 1.396"
          S.path ! A.d "M313.9332 480.3078c1.657 3.391 2.022 2.962 1.305.145-.729-2.82-1.736-5.346-3.326-7.944-1.587-2.6-5.633-6.283-5.633-6.283s1.084 2.383 2.601 4.481c1.514 2.09 3.395 6.206 5.053 9.601"
          S.path ! A.d "M297.906 483.1994c.649 2.238 4.043 8.445 4.405 8.225.359-.218-1.375-5.557-2.53-9.243-1.154-3.678-2.961-6.494-3.32-6.352-.358.146.284 2.312.284 2.312s.509 2.815 1.161 5.058"
          S.path ! A.d "M285.2677 493.3723c.723 1.593 1.593 3.54 1.948 3.253.364-.291-.861-3.541-1.081-4.479-.215-.941-.285-3.03-1.372-5.199-1.082-2.162-1.517-1.151-1.517-.288 0 .867 1.302 5.055 1.302 5.055s0 .071.72 1.658"
          S.path ! A.d "M229.567 480.3078c1.66-3.395 3.538-7.511 5.054-9.601 1.515-2.098 2.598-4.481 2.598-4.481s-4.043 3.683-5.633 6.283c-1.587 2.598-2.596 5.124-3.321 7.944-.72 2.817-.36 3.246 1.302-.145"
          S.path ! A.d "M245.5944 483.1994c.649-2.242 1.014-3.732 1.014-3.732s.652-2.166.291-2.311c-.361-.145-2.026 1.347-3.18 5.025-1.158 3.686-2.89 9.025-2.529 9.243.36.22 3.755-5.987 4.404-8.225"
          S.path ! A.d "M258.2306 493.3723c.721-1.587.721-1.657.721-1.657s1.3-4.188 1.3-5.055c0-.863-.434-1.874-1.515.288-1.087 2.169-1.157 4.258-1.375 5.199-.214.938-1.442 4.188-1.083 4.479.362.287 1.229-1.661 1.952-3.254"
          S.path ! A.d "m219.0011 531.8918-1.69-1.018s-1.011 1.359-2.446 2.88c-1.435 1.52-3.041 2.116-4.137 3.556-1.097 1.437-2.786 3.218-5.402 4.57-2.616 1.355-3.629 1.778-3.121 2.203.505.424 2.279-.593 2.279-.593s.759-.088 3.882-1.948c3.122-1.86 3.882-2.877 5.907-4.655 2.027-1.778 4.728-4.995 4.728-4.995"
          S.path ! A.d "M232.6725 548.0627c1.183-1.27 2.445-2.118 1.773-2.798-.676-.673-1.521-.591-2.618.342-1.096.932-4.218 3.891-5.655 5.162-1.434 1.27-2.615 2.033-4.049 3.133-1.434 1.102-4.558 2.791-6.076 3.638-1.519.849-.084.937-.084.937s1.182-.6 2.447-1.022c1.263-.421 4.893-2.031 4.893-2.031s1.435-.675 3.377-2.03c1.942-1.355 4.81-4.065 5.992-5.331"
          S.path ! A.d "M248.4572 558.9797c1.012-2.027-.085-1.44-1.773-.758-1.687.676-5.487 4.825-7.681 6.347-2.194 1.519-4.052 2.115-5.907 3.051-1.858.928-1.858 1.433-1.771 1.859.082.423.84.423 1.6.085.762-.338 3.375-1.862 3.375-1.862s1.097-.335 2.112-.424c1.014-.085 2.447-1.191 4.726-3.132 2.279-1.948 4.304-3.13 5.319-5.166"
          S.path ! A.d "M255.7995 573.4572c-2.788 1.693-7.596 5.501-8.861 8.044-1.27 2.541-2.111 4.316-1.69 4.74.42.423 1.772-.424 2.364-1.442.591-1.015 1.858-2.539 1.858-2.539s4.808-4.738 6.581-5.839c1.773-1.102 4.644-4.232 5.319-6.094.674-1.866.168-2.877.168-2.877s-2.957 4.316-5.739 6.007"
          S.path ! A.d "M338.2321 541.88c-2.618-1.353-4.308-3.133-5.407-4.57-1.097-1.441-2.7-2.036-4.135-3.556-1.434-1.522-2.445-2.88-2.445-2.88l-1.69 1.018s2.7 3.218 4.728 4.995c2.025 1.777 2.785 2.794 5.907 4.655 3.126 1.859 3.878 1.947 3.878 1.947s1.778 1.018 2.28.594c.511-.426-.5-.849-3.116-2.203"
          S.path ! A.d "M327.5094 557.5393c-1.52-.847-4.643-2.535-6.077-3.638-1.432-1.099-2.612-1.863-4.049-3.133-1.435-1.272-4.558-4.231-5.655-5.162-1.099-.932-1.943-1.014-2.617-.341-.677.679.593 1.528 1.772 2.797 1.185 1.267 4.052 3.976 5.992 5.331 1.945 1.355 3.376 2.03 3.376 2.03s3.629 1.609 4.896 2.03c1.267.423 2.447 1.023 2.447 1.023s1.438-.087-.085-.937"
          S.path ! A.d "M310.463 567.6193c-1.86-.936-3.714-1.531-5.91-3.051-2.193-1.522-5.989-5.671-7.681-6.347-1.687-.682-2.78-1.27-1.773.758 1.017 2.036 3.042 3.218 5.32 5.166 2.279 1.943 3.714 3.047 4.728 3.132 1.008.089 2.11.424 2.11.424s2.615 1.525 3.373 1.862c.762.338 1.523.338 1.602-.085.087-.425.087-.93-1.769-1.859"
          S.path ! A.d "M287.756 573.4572c-2.782-1.692-5.736-6.009-5.736-6.009s-.509 1.011.171 2.877c.672 1.862 3.543 4.993 5.315 6.094 1.776 1.102 6.585 5.839 6.585 5.839s1.264 1.525 1.858 2.539c.588 1.019 1.937 1.865 2.362 1.442.424-.424-.426-2.198-1.693-4.74-1.263-2.541-6.073-6.349-8.862-8.042"
          S.path ! A.d "M270.4508 591.1516c.25 1.942.085 6.858 1.267 6.858 1.181 0 1.011-4.916 1.267-6.858.249-1.945.335-6.606.335-6.606h-3.212c-.001 0 .087 4.66.343 6.606"
      S.path
        ! A.fill "#005D95" 
        ! A.d "M344.2594 315.341c-3.168-21.058 6.332-38.019 6.332-38.019l-19.75-21.99c-16.691 8.572-36.979 6.36-59.08-1.304-22.1 7.664-42.384 9.876-59.077 1.304l-19.752 21.99s9.504 16.961 6.337 38.019c-3.168 21.058-8.013 44.907-7.083 58.89.065.961.167 1.936.303 2.923h17.988s1.042-1.213 3.044-2.066c1.998-.864 2.57-1.437 2.57-1.437s.382-3.632 2.574-4.397c2.19-.767 3.144-.767 4.002-.767.856 0 1.525-.191 2.572-1.243 1.05-1.049 3.904-3.629 5.143-7.26 1.24-3.633 2.004-5.067 2.004-7.456 0-2.387.857-6.209.857-6.209s-.48-1.147-2.288-.477c-1.812.667-2.099-1.147-2.285-2.965-.193-1.816-.098-5.539.952-7.261 1.046-1.722 1.429-2.295 1.429-2.295l-.765-2.863s-11.433 2.289-13.431-6.596c-2.001-8.886-2.384-13.191-2.67-14.141-.285-.961-.572-1.441-2.096-1.34-1.526.094-4.763-.955-7.05-5.545-2.286-4.587-2.477-6.497-1.81-8.31.667-1.819 1.906-1.146 2.288-.576.379.576 3.43 4.972 4.669 3.726 1.236-1.242.572-1.242-1.145-4.681-1.714-3.438-1.143-4.584-.953-6.309.189-1.719-.57-4.014-.57-4.969 0-.952 1.046-1.719 2.095-1.243 1.049.48 2.001 1.243 2.476 1.817.476.572.667 1.437 1.622.863.953-.575.379-3.732.379-4.778 0-1.052 1.238-1.817 2.765-.958 1.523.86 2.285 2.484 2.285 3.629 0 1.149.098 2.201.667 2.201.572 0 1.24-1.722 1.334-2.871.095-1.14.763-2.865 1.81-1.429 1.05 1.429 1.43 3.539 1.05 5.734-.384 2.195.38 1.052-.384 4.875-.759 3.824-1.141 5.541-1.046 8.41.096 2.865.19 4.491 1.619 8.029 1.429 3.534 2.571 7.64 5.24 7.737 2.67.094 3.431.094 3.431.094s2.953-5.733 5.24-7.07c2.286-1.337 5.525-1.531 7.813-1.817 2.286-.287 3.237-.957 3.237-1.53 0-.573-.762-.761-3.525-1.147-2.76-.379-5.047-1.052-5.14-3.153-.098-2.102.473-3.917-1.337-4.012-1.809-.097-6.287-1.536-7.906-4.492-1.619-2.965-1.239-3.635-1.047-5.254.188-1.625 2.284-4.878 3.619-1.819 1.334 3.06 2.192 3.439 3.335 4.109 1.143.673 2.665.864 1.906-1.243-.764-2.101-1.239-3.435-1.05-4.963.19-1.533 1.24-2.198 2.481-2.487 1.236-.287 4.952-1.437 6.858-1.818 1.903-.379 2.001-.57 2.001-.57s.189-1.34 2.667-2.104c2.478-.764 4.096-.858 5.908-.858 1.808 0 3.141.285 5.525-.863 2.382-1.144 4.286-1.334 5.811-1.24 1.523.097 2.668.67 3.811 1.431 1.144.768.762 1.819.762 2.868 0 1.052.19 1.625 1.807 1.625 1.625 0 3.053 0 4.576.573 1.527.576 3.623 1.431 2.286 3.056-1.331 1.628-1.423 3.441-2.286 3.347-.852-.097-.758.861-1.143 1.434-.38.57-.665 1.05.291 1.625.945.573 1.043 1.147 2.379 2.386 1.331 1.244 3.332 2.583 1.331 4.59-1.995 2.005-5.521 3.633-5.521 3.633s-2.004.951.282 2.295c2.285 1.334 3.338 4.108 4.194 4.584.855.479 1.715 1.242 2.285 1.527.57.288.477 2.198.477 2.198s-1.237.863-2.953 1.53c-1.716.67-3.527 1.435-5.143 1.435-1.621 0-2.48 0-1.81 1.527.664 1.526 1.81 3.156 2.095 4.011.285.861.667 2.393.667 2.393s2.662.569 5.049.569c2.379 0 3.429.098 8.669-.477 5.239-.569 6.767-.763 11.815-.193 5.052.573 5.807.386 7.144.861 1.334.479 2.665 1.152 2.665 1.152s7.147-.101 11.053-.958c3.906-.861 4.864-3.351 4.293-4.682-.573-1.34-.482-3.344-7.341-4.302-6.856-.961-9.621-.575-15.054-1.628-5.428-1.049-13.911-3.82-15.431-10.605-1.528-6.785 3.999-9.65 6.765-10.987 2.762-1.343 8.762-3.441 11.528-4.587 2.759-1.149 7.813-2.292 13.147-1.531 5.333.768 8.38 2.198 10.478.958 2.095-1.242 3.812-.288 3.429 1.623-.376 1.909-2.477 5.83-8.48 7.646-6 1.816-13.239 2.006-17.147.958-3.908-1.056-6.859-2.583-9.242-1.726-2.38.861-5.048 3.826-2.481 7.358 2.58 3.541 15.725 4.59 19.248 4.97 3.526.388 16.576-.573 20.293 5.923 3.715 6.503.758 13.762-3.62 15.39-4.381 1.622-8.099 2.677-11.431 3.153l-3.335.477s1.523 3.441 1.523 4.878c0 1.432-.191 4.108 1.432 5.154 1.618 1.056 3.907 1.819 6.669 1.531 2.763-.282 6.098 1.625 6.289 4.112.186 2.483.953 5.921 1.234 10.892.288 4.969 0 9.077 0 9.077s-.188 1.914-.855 3.727c-.668 1.816-4.1 8.857-4.1 8.857h19.183c.139-.987.241-1.963.306-2.924.931-13.981-3.913-37.831-7.08-58.889"
      S.path
        ! A.fill "#618D33"
        ! A.d "M194.7746 386.4963c3.76 10.747 11.512 21.626 23.314 28.733 16.401 9.877 23.483 8.572 38.951 18.636 15.468 10.062 14.537 11.743 14.722 11.743.186 0-.746-1.681 14.726-11.743 15.466-10.064 22.547-8.759 38.948-18.636 11.804-7.108 19.553-17.987 23.311-28.733z"
      S.g
        ! A.fill "#E9B528"
        $ do
          S.path ! A.d "M208.1823 303.4963c1.76 1.852 3.059 2.412 5.747 2.136 2.689-.284 3.336 1.669 3.799 3.8.464 2.133.464 7.137 2.411 11.771 1.945 4.635 8.434 4.913 8.434 4.913.179-2.235.96-5.242 1.948-7.693.173-.439 1.017-2.506-1.3-2.506-2.316 0-2.223-.927-3.615-3.151-1.388-2.225-4.078-8.155-4.726-11.958-.648-3.799.556-9.453 1.204-11.492.649-2.039.744-3.429 0-3.799-.742-.374-2.223 0-2.223 0s.556 1.76-.095 2.036c-.647.281-1.204-.926-1.665-2.222-.467-1.299-1.021-1.113-1.948-1.023-.927.094-.927.929-.278 1.857.648.923.278 2.592.278 2.592s-2.041-1.481-2.874-1.854c-.833-.367-2.781.373-2.967 1.486-.183 1.107.743 3.982 2.504 5.466 1.762 1.486 1.762 4.542 1.204 5.935-.554 1.388-3.151 1.202-3.708.556-.556-.649-1.666-.834-2.409 0-.74.834-1.482 1.298.279 3.15"
          S.path ! A.d "M207.1632 298.5852s-1.021-.832-1.391-1.293c-.369-.47-1.112-1.489-1.112-1.489s-.186.464-.186 1.577c0 1.114 1.205 2.319 1.205 2.319z"
          S.path ! A.d "M211.0548 285.7024c.835-.37 1.483-.559.835-1.483-.648-.926-1.206-1.949-1.855-2.134-.649-.183-1.204-.091-1.204-.091s.741 1.669.924 2.689c.188 1.019.466 1.389 1.3 1.019"
          S.path ! A.d "M215.8756 281.8083c-.092.834.094 1.208.833.834.744-.373 1.021-1.39.648-2.133-.37-.74-1.203-1.293-1.203-1.293l-.556-.376s.372 2.134.278 2.968"
          S.path ! A.d "M222.8288 282.9196c.091-.926-.279-1.945-.279-1.945s0 1.111-.464 1.764c-.463.647-.37.464.094 1.02.462.552.555.09.649-.839"
          S.path ! A.d "M233.7218 330.0344c1.362 3.158 4.825-1.789 7.975-5.791 3.146-3.999 3.041-.943 2.621 2.315-.418 3.265.841 6.742 2.101 8.952 1.258 2.204 2.307.943 2.83-.638.525-1.572.946-4.837 1.995-6.415 1.049-1.581 2.096-.212 2.204 1.154.104 1.366 1.782 4.422 3.356 6.209 1.571 1.792 2.308-.629 2.832-2.839.525-2.21 1.152-5.58 1.575-6.95.417-1.366 1.887-.209 1.887-.209s1.052 1.053 3.15 3.051c2.093 2.004 2.304-1.158 2.516-2.731.208-1.584-.317-5.054.314-5.586.629-.522 2.409.741 5.143 2.113 2.727 1.363 2.624-1.267 2.31-2.741-.321-1.47-1.887-4.84-4.094-6.733-2.204-1.895-2.516-4.105-1.78-5.054.731-.941 3.356-.106 5.031-.314 1.681-.212 2.521-.418 3.779-.626 1.258-.215 1.258-1.479 1.258-1.479s-.94-1.577-2.727-3.153c-1.787-1.584-2.83-2.842-5.034-3.37-2.207-.526-5.245 0-5.245 0l-.317-.632c-.314-.629-.943-.629-1.364 0-.42.632-1.469 1.475-2.309 2.21-.836.737-1.363 1.157-1.887.84-.526-.314.417-1.052.417-1.052s1.154-.838 2.206-2.945c1.047-2.107 1.363-4.108.525-5.051-.839-.952-3.148 0-4.407 0-1.261 0-1.994.208-2.098-.421-.108-.632 1.258-.314 2.831-.528 1.577-.209 2.519-2.105 3.044-3.682.524-1.581.945-1.369 1.89-.421.943.949 1.786.738 1.992.104.206-.632 1.049-2.207 2.099-3.788 1.049-1.577 1.678-3.784.522-5.257-1.154-1.475-3.988-1.27-5.141-.313-1.153.942-1.887 1.889-2.2 4.204-.316 2.316-.945 1.049-.945.314 0-.737-.946-1.896-.525-2.842.42-.943 0-2.001 0-2.001s-.209-1.995-2.413-2.418c-2.204-.423-4.721.105-6.925.632-2.203.527-1.783 2.424-1.783 2.424s-1.679.101-3.463.314c-1.783.209-3.882.943-5.56 1.363-1.677.424-2.309.632-2.309 1.473 0 .847.316 2.216.316 2.216s1.363 0 2.099.417c.733.423.314 1.157-.526 1.475-.837.32-1.153.421-1.153 1.473 0 1.055.42 1.267 1.259 1.267.838 0 2.623 0 4.721.942 2.101.946 2.624 2.839 2.414 3.891-.21 1.055-3.151 2.421-4.618 2.421-1.467 0-1.887.32-1.887 1.265 0 .948 1.784.846 1.784.846s1.782.103 5.244.52c3.463.424 3.988 1.161 5.563 2.528 1.572 1.369.418 1.684-.316 2.105-.735.423-1.89 1.369-3.042 1.792-1.154.417-1.889 1.264-2.939 1.469-1.049.212-3.672.109-8.498 2.004-4.826 1.893-6.505 8.211-6.505 8.211s.629-.215 2.832-1.375c2.202-1.154 4.931-2.418 7.45-3.996 2.517-1.575 2.517.74 1.258 2.947-1.258 2.209 1.155 1.786 1.89 1.158.734-.635 1.678-1.264 4.09-2.528 2.416-1.261 1.574.737 1.574.737s-.734 1.472-.942 4.949c-.21 3.473 3.461.209 5.139-2.001 1.68-2.21 2.415 0 1.154 2.527-1.258 2.528-3.672 4.524-5.035 4.524-1.366 0-2.412-1.473-2.519-2.314-.105-.844.42-3.37-.417-3.999-.842-.629-3.255.106-5.036 1.154-1.784 1.053-2.206.215-2.624-.734-.42-.948.63-1.264.209-1.893-.421-.634-1.363 0-2.099.315-.734.313-2.412 1.264-5.664 2.946-3.255 1.682-3.043 2.627-3.043 5.049 0 2.421.627 2.841 1.99 6"
          S.path ! A.d "M265.197 277.3542c.682-.433 1.922-.929 1.922-.929s1.549-.37 2.974-.559c1.422-.185 1.175-.993.863-1.669-.305-.688-.863-.931-2.718-.931-1.862 0-3.041.931-4.092 1.359-1.055.436-2.294.747-2.294.747s.249.309.928 1.302c.683.989 1.737 1.115 2.417.68"
          S.path ! A.d "M272.758 284.8537c.743 0 1.548-.436 1.548-.436s1.359-.681 2.604-1.113c1.237-.435 1.735-.622 2.475-2.11.743-1.487-.806-1.487-2.971-2.039-2.169-.565-3.224.179-3.468.987-.252.805-.188 1.734-1.055 3.285-.869 1.55.12 1.426.867 1.426"
          S.path ! A.d "M272.073 286.7727c-2.104 0-4.458 3.158-5.325 3.717-.87.556-.373 1.114-.373 1.114s.619 1.301.863 2.538c.253 1.243.314 3.35.314 3.35s.309.127 1.546.127c1.243 0 1.984-.623 3.162-1.49 1.177-.866 2.107-1.178 3.779-1.489 1.675-.306 2.477-.617 4.334-1.608 1.863-.99-.99-2.727-2.971-4.337-1.985-1.614-3.219-1.922-5.329-1.922"
          S.path ! A.d "M244.054 294.0427c1.668-.186 2.409-1.017 2.409-1.945 0-.928-.843-1.948-2.967-1.761-5.221.465-10.283-1.407-11.214-6.579 0 0-1.761 3.239 1.482 6.858 3.245 3.614 8.622 3.614 10.29 3.427"
          S.path ! A.d "M226.2692 376.2375c.265.461.588.746.919.917h7.998c1.362-.383 1.371-1.638 1.438-2.504.08-1.031.869-3.964 1.976-9.28 1.107-5.31 3.005-9.112 3.795-11.255.79-2.143-.79-2.854-1.343-4.205-.554-1.346-1.423-3.723-1.66-4.91-.237-1.192-2.135-1.032-3.162-.955-1.028.079-1.188 1.745-1.344 3.332-.158 1.581-.868 6.261-1.659 10.304-.792 4.044-5.376 9.436-6.64 10.623-1.267 1.192-2.292 1.667-3.164 1.667-.868 0-2.766 0-3.717.556-.946.556-1.894 2.063-1.975 3.246-.079 1.191 1.821 1.828 1.821 1.828s1.5-.873 2.054-1.587c.553-.715 1.817-.873 3.082-1.107 1.264-.238 1.422.234.948.866-.473.636-.316.798.633 2.464"
          S.path ! A.d "M214.0158 375.841c-.605.215-1.046.816-1.321 1.314h5.228c-.062-.426-.205-.935-.507-1.314-.633-.793-2.294-.397-3.4 0"
          S.path ! A.d "M221.1315 375.6818c-.639.347-1.407.91-1.798 1.473h5.626c.199-.523.261-1.226-.428-1.787-1.267-1.035-2.531-.162-3.4.314"
          S.path ! A.d "M269.9455 373.3518c-.614 0-1.158.547-2.042 1.157-.882.614-1.154 1.568-1.289 2.32-.025.131-.01.237.034.326h2.389c.095-.086.158-.195.158-.326 0-.686.271-1.299 1.293-2.184 1.015-.888.066-1.293-.543-1.293"
          S.path ! A.d "M274.6295 375.9377c0-.746-.273-1.429-.816-1.36-.544.068-1.426 1.023-2.172 1.566-.414.304-.726.708-.955 1.012h3.532c.205-.395.411-.856.411-1.218"
          S.path ! A.d "M296.3664 349.9865c1.695-1.229 1.425-1.568 1.489-2.862.068-1.296.068-1.704-.611-2.178-.678-.481-3.188-1.568-5.565-1.568-2.377 0-6.865.543-8.56 1.701-1.701 1.16-2.516 5.315-2.516 7.493s.341 2.521.952 2.521 1.631-1.568 1.631-1.568 2.239 2.93 3.6 4.979c1.36 2.042.746 2.859.142 4.421-.615 1.57-2.854 5.725-4.62 6.613-1.772.887-3.129.064-5.234-.271-2.104-.344-3.261.271-4.484 1.495-1.223 1.225-.064 2.184.679 2.184.749 0 1.766-.07 2.583.952.564.708.182 2.324-.104 3.256h10.409c1.775-.788 3-3.227 3.48-4.555.546-1.496 2.785-3.47 3.875-4.491 1.084-1.024 1.223-1.707 1.223-3.955 0-2.247-.611-3.54-1.432-5.107-.814-1.569-1.425-3.818-1.154-5.111.274-1.295 2.519-2.726 4.217-3.949"
          S.path ! A.d "M279.2282 324.01c1.041 1.69.523 2.014-.973 2.336-1.489.326-3.109.585-5.448.392-2.333-.197-2.272.129-2.333 1.298-.064 1.167-.265 3.635-1.625 5.449-1.363 1.817-3.052 1.105-4.09.391-1.039-.714-1.621-.522-2.01.776-.389 1.298-1.103 2.21-2.206 4.152-1.105 1.948-1.818 2.014-2.595 1.818-.779-.196-1.493-1.363-2.272-1.427-.78-.066-2.013-1.62-3.181-3.506-1.166-1.878-1.751.193-2.527 1.821-.782 1.619-1.556 2.792-3.052 2.592-1.491-.191-3.177-2.983-4.021-4.669-.844-1.691-1.363-3.309-2.661-3.247-1.297.067-3.439 2.792-4.868 3.503-1.428.717-1.816.458-2.465-.45-.648-.908-1.491.327-2.336 2.466-.842 2.142.066 3.954 1.234 4.539 1.166.585 3.502-1.105 5.061-2.142 1.555-1.034 2.27-.776 3.894-.776 1.62 0 1.491 2.663 2.205 6.55.712 3.895 2.984 4.414 2.984 4.414s.779.649 2.532-2.333c1.751-2.986 1.944-5.907 3.634-5.907 1.685 0 1.817.388 3.503 2.725 1.688 2.336 3.113 4.087 4.087 2.336.973-1.755 1.818-4.35 2.921-5.254 1.1-.911 2.139-1.17.973.517-1.17 1.687-1.687 3.502.712 2.791 2.402-.711 11.549-4.413 15.248-5.124 0 0 4.346-.715 9.344-.973 4.996-.265 6.227-.588 8.175-.588 1.945 0 2.01-.197 2.143-1.492.126-1.299-.908-1.038-4.543-1.038-3.632 0-6.165.456-8.695.847-2.53.388-3.694.323-3.247-.326.458-.648 1.169-1.106 4.093-1.555 2.915-.455 8.889-.781 12.005-.846 3.112-.064 2.139.908 1.877 2.986-.262 2.074.262 5.128.459 7.073.19 1.945.255 2.53 1.944 5.254 1.687 2.725 7.523 4.413 9.213 5.322 1.687.909 1.429 0 1.364-1.625-.068-1.619 1.295-1.554 2.788-.714 1.489.85 3.958 1.561 5.709 2.016 1.752.449 2.01.775 2.01 1.685 0 .908.197 2.921.394 4.804.191 1.88.127 2.462-.651 3.632-.779 1.169-4.088 4.536-4.088 4.536s-1.493 0-4.672.785c-3.179.779-4.155 2.272-4.479 3.568-.322 1.296.588 1.687.718 2.207.07.284.041.986.002 1.557h.735c.268-.455.647-1.049 1.14-1.69 1.108-1.425 3.9-1.751 5.712-.907 1.191.555 1.208 1.801 1.082 2.597h7.267c.982-1.892 3.306-6.417 3.917-7.791.775-1.748 1.231-2.853 1.295-5.253.068-2.402.324-11.678-.128-12.198-.456-.521.128-2.078 0-4.673-.133-2.594 0-4.542-4.802-4.995-4.805-.455-6.294-2.462-7.917-4.09-1.628-1.619-1.234-5.383-2.528-9.924-1.299-4.539-4.479-5.257-10.124-6.362-5.648-1.099-9.8-1.232-14.017-.84-4.217.39-9.47.975-12.391.71-2.918-.257-2.466.583-1.429 2.27"
          S.path ! A.d "M306.4992 376.1262c-.494.32-.823.699-1.041 1.028h4.906c.023-.421-.045-.894-.482-1.42-.747-.898-2.185-.387-3.383.392"
          S.path ! A.d "M315.2765 375.7942c-.796.402-1.311.92-1.628 1.36h4.975c.018-.191.012-.388-.026-.576-.147-.784-1.646-1.625-3.321-.784"
          S.path ! A.d "M192.7638 378.9026c.275 1.54.638 3.104 1.086 4.672h155.826c.449-1.568.811-3.132 1.084-4.672z"
          S.path ! A.d "M297.7623 304.465c4.922 3.277 20.552 3.453 27.891 4.922 7.34 1.466 6.826 7.079 4.577 10.015-2.244 2.938-12.568 3.291-14.419 3.537.999.693 2.503 2.85 2.503 2.85s1.126-.082 4.232-.346c3.107-.256 8.548-1.032 12.263-4.144 3.715-3.106 3.453-8.113.174-11.481-3.282-3.37-8.724-3.714-14.252-4.317-5.525-.606-9.844-1.037-16.06-2.074-6.215-1.034-9.239-3.538-9.239-7.168 0-3.626 3.371-5.524 5.787-6.218 2.415-.69 6.3-1.722 9.756-.432 3.455 1.296 7.514 1.466 14.334.608 6.824-.867 8.379-5.616 8.379-5.616s-.867.432-4.317.517c-3.456.086-5.962-1.466-12.26-1.557-6.309-.086-8.554 2.165-11.49 3.197-2.936 1.038-10.791 1.817-13.124 6.909-2.331 5.095.345 7.516 5.265 10.798"
      S.g
        ! A.fill "#DE6F10"
        $ do
          S.path ! A.d "M256.8024 278.045c-1.624 0-2.939 1.293-2.939 2.898 0 1.599 1.315 2.892 2.939 2.892 1.618 0 2.934-1.293 2.934-2.892.001-1.605-1.316-2.898-2.934-2.898"
          S.path ! A.d "M319.9606 285.8996c-3.891-.344-8.986.69-8.986.69s.949.779 2.245.693c1.293-.088 3.629-.173 7.425.515 3.8.696 6.562-1.123 6.562-1.123s-3.364-.429-7.246-.775"
      S.g
        ! A.fill "#E9B528"
        $ do
          S.path ! A.d "M444.9245 460.552c3.123.72 28.804 5.639 30.964 6.121 2.162.477 3.961.958 4.56.356.606-.597.961-.958 3.241-1.802 2.28-.834 2.163-3.117 2.163-3.117s.599-2.163.834-4.321c.244-2.156 1.445-2.88 3.964-.237 2.522 2.636 3.001 6.477 3.48 10.199.482 3.721 6.365 4.679 8.639 5.039 2.283.362 3.359-.36 4.681-2.518 1.322-2.159 2.042-6.483 2.401-9.244.358-2.757.124-2.52-2.759-3.24-2.88-.716-16.2-3.716-18.605-4.323-2.395-.6-1.916-2.156-1.557-3.838.358-1.678 5.639-18.603 5.639-18.603-3.758-2.325-9.04-3.709-15.36-4.438 0 0-3.841 17.279-4.563 19.923-.717 2.636-2.402 2.636-5.159 2.153-2.761-.476-22.685-5.151-22.685-5.151l-1.555 3.715c-1.56 3.72-2.279 8.163-2.279 10.44 0 2.277.837 2.165 3.956 2.886"
          S.path ! A.d "M513.0788 476.1614c-2.648-1.731-4.597-2.188-5.975 1.034-1.38 3.224-1.492 7.943-4.939 11.278-3.447 3.338-8.275 6.789-13.101 6.445-4.823-.348-7.582-1.499-6.435-7.021 1.151-5.521 8.507-7.25 10.228-10.127 1.723-2.877 1.264-6.214-1.266-8.398-2.528-2.19-6.204-2.648-7.239-1.957-1.031.688-4.022 3.224-5.512 7.361-1.495 4.144-2.412 7.482-5.633 10.13-3.212 2.645-11.486 5.292-17.919 3.793-6.433-1.495-8.73-3.452-11.146-9.779-2.413-6.327-5.284-16.797-6.55-17.949-1.261-1.15-2.87-2.072-5.627-.118-2.759 1.954-2.988 4.834-3.332 7.138-.347 2.298 0 4.952 2.754 8.287 2.758 3.335 5.632 6.67 6.667 10.12 1.034 3.453 4.134 8.749-.232 8.978-4.364.229-6.315.344-9.65-2.874-3.332-3.224-16.319-12.083-19.876-14.963-3.563-2.877-5.055-3.794-5.055-3.794-6.009-.105-12.027-2.576-18.036-6.67 0 0 3.447 8.857 4.134 12.192.69 3.338.576 5.174.576 5.174s13.095 6.674 18.269 9.207c5.168 2.531 15.624 8.516 20.676 11.619 5.06 3.113 9.309 7.944 18.272 6.104 8.964-1.843 27.111-7.364 32.971-9.091 5.863-1.728 22.063-5.754 28.037-9.894 5.974-4.141 6.549-3.912 7.579-8.055 1.039-4.142-.001-6.445-2.64-8.17"
          S.path ! A.d "M478.4968 414.2092c.996-.132 1.396-.268 4.451-.664 3.06-.402 1.925 2.528 1.394 3.658-.529 1.129-1.461 3.392-2.718 5.519-1.271 2.136.394 2.468 1.257 2.798.864.337 2.125.467 4.584 1.134 2.463.66 1.992-1.134 2.06-2.063.068-.935.197-5.792.468-7.52.265-1.728 1.858-1.264 2.456-.932.599.332 2.125 1.193 3.392 1.858 1.258.673 1.857-.062 2.124-.794.266-.731.86-2.06 1.396-3.993.532-1.928-.664-1.53-1.865-1.53-1.193 0-2.921 0-4.913-.065-1.992-.067-.732-1.998-.732-1.998s1.464-2.392 2.592-4.19c1.132-1.796.735-2.061-.399-2.399-1.125-.335-4.649-1.132-5.645-1.396-.996-.262-1.461-.132-1.461.535s-.134 4.122-.134 5.456c0 1.328-.13 2.128-1.861 2.195-1.727.064-2.791-.938-4.184-2.465-1.397-1.526-1.992-.929-2.127-.33-.133.6-1.265 4.991-1.529 6.186-.269 1.198.398 1.133 1.394 1"
          S.path ! A.d "M378.7262 462.9045c-1.942-2.033 2.997-2.112 5.918-2.112 2.918 0 7.699-1.546 9.239-2.519 1.543-.975 4.217-1.466 7.376-3.009 3.165-1.548 1.217-2.036-2.021-2.844-3.244-.815-11.916-4.473-11.916-4.473s-4.214 2.278-6.566 3.658c-2.35 1.384-5.512 3.332-10.62 3.983-5.107.649-6.646.896-6.89 1.057-.241.162 1.219 1.381 3.161 4.147 1.948 2.765 2.756 4.551 5.19 8.698 2.43 4.149-.405 1.711-2.434-.894-1.14-1.463-3.694-4.924-6.068-7.383-1.843-1.919-3.74-3.107-3.74-3.107l-1.619 3.496v1.22c0 1.141-.973 6.75-1.296 9.024-.326 2.281.564 2.281 2.349 3.092 1.783.815 5.347 2.844 14.918 8.86 9.562 6.015 13.127 10 13.127 10s.323-2.604.323-5.204c0-2.598-.082-7.883-2.187-13.82-2.109-5.933-4.296-9.836-6.244-11.87"
          S.path ! A.d "M356.528 449.6223c2.239.453 3.139 1.015 6.28 1.015 3.142 0 4.488-1.015 7.741-1.015 3.255 0 5.5-1.122 10.773-3.923 5.271-2.806.224-2.021-3.477-1.686-3.709.335-13.353-1.12-17.508-2.696-4.15-1.569-1.117-1.793 0-1.461 1.126.342 1.687.68 9.988 2.137 8.305 1.461 11.335-.449 15.596-1.568 4.269-1.129-1.005-1.682-1.005-1.682s-15.04-4.267-22.56-12.683c-5.745-6.435-7.69-12.35-8.29-14.775-2.942 3.503-6.221 6.544-9.656 9.218.267 1.164.778 3.089 1.569 4.881 1.233 2.809 4.822 6.511 4.822 6.511s-4.49-1.797-6.505-3.928c-1.388-1.464-2.616-3.721-3.247-4.993-4.935 3.435-10.033 6.173-14.729 8.433.562.449 1.258 1.026 2.042 1.719 2.016 1.796 3.923 4.153 6.506 8.302 2.579 4.155.223 3.82-2.133 0-2.358-3.812-8.19-7.741-9.313-8.302-.129-.064-.282-.114-.44-.155-.6.276-1.191.544-1.775.805-3.18 1.422-6.186 2.696-9.051 3.897 1.922 1.554 6.376 5.904 7.899 8.136 1.687 2.469 5.161 4.714 6.403 6.395 1.229 1.682 2.577 3.588 4.258 5.61 1.687 2.019 11.784 13.354 14.476 17.617 2.695 4.263 1.12-1.122.449-4.038-.673-2.917-1.687-7.07-2.579-10.326-.899-3.253 1.008-1.907 1.346-.111.338 1.795.784 1.906 1.572 5.386.784 3.476 2.8 8.639 3.702 12.23.893 3.588 1.234 1.906 2.13.227.899-1.685 2.242-4.606 2.804-6.401.561-1.793 1.011-5.831 1.122-12.005.111-6.167-2.915-8.638-2.915-9.538-.001-.891 1.456-1.679 3.705-1.233"
          S.path ! A.d "M399.778 462.9992c-.907.399-3.929 1.416-5.333 1.616-1.413.202-2.415.3-2.415.3s2.818 3.938 7.046 3.938h12.172s-7.346-4.34-8.254-5.348c-.901-1.015-2.314-.911-3.216-.506"
          S.path ! A.d "M488.1325 457.7893s-.123 3.482-.481 4.678c-.361 1.205-1.199 3.004.241 3.483 1.44.482 2.76 1.078 3.594.84.846-.237.481-1.919 0-3.358-.477-1.441-1.196-3.245-2.278-4.441z"
          S.path ! A.d "M509.2487 471.712c.481 1.079 1.442 1.319 2.163 1.562.72.237 1.681.237 1.681-1.083 0-1.318.237-3-.838-4.44-1.081-1.442-1.653-2.491-2.279-.36-.632 2.129-1.203 3.239-.727 4.321"
          S.path ! A.d "M435.6852 457.6692c.6.12 2.88.841 2.88.841s0-3.362.479-5.643c.48-2.274 1.441-3.838.603-3.838-.841 0-1.319.721-1.925 1.679-.597.958-2.28 1.201-2.877 3.961-.603 2.761.24 2.882.84 3"
      S.g
        ! A.fill "#DE6F10"
        $ do
          S.path ! A.d "M145.089 362.8986c-2.414 1.831-5.576 2.58-5.576 2.58s-1.497-.079-1.497.503c0 .581 1.748 0 3.577-.332 1.831-.335 4.327-2.166 5.244-2.833.915-.667 2.247-1.501 1.829-2.668-.416-1.167-1.165.917-3.577 2.75"
          S.path ! A.d "M165.8068 373.9836c-.499.579-4.491 3.582-4.491 3.582s-1.249.831-2.582 1.331c-1.33.502-1.662 1.255-1.662 1.255s.25.329 1.662-.083c1.415-.42 5.578-3.338 6.906-4.504 1.331-1.17 1.917-1.499 1.417-1.998-.498-.5-.748-.165-1.25.417"
          S.path ! A.d "M81.7643 224.6413c.746.91 1.656 2.151 2.07 1.736.415-.411-.085-.827-1.077-1.989-.993-1.159-1.572-1.738-1.572-1.738s-1.406-2.239-2.235-3.069c-.828-.828-2.07-1.242-.497.663 1.575 1.909 2.568 3.483 3.311 4.397"
          S.path ! A.d "M75.3922 238.6496c.91.833 1.736 1.575 2.73 2.652.994 1.077 1.74 2.236 2.317 1.659.582-.582-1.489-1.821-2.399-2.986-.911-1.162-1.656-1.904-2.815-2.816-1.161-.913-2.566-1.659-2.566-1.659s1.822 2.322 2.733 3.15"
          S.path ! A.d "M77.7716 261.2302c1.58 1.663 3.91 2.163 4.243 1.501.334-.667-.167-1.204-1.493-1.865-1.322-.661-3.475-2.07-4.552-2.816-1.075-.749-2.151-1.577-2.898-2.32-.743-.747-1.623-1.417-1.902-1.164-.278.256 2.192 2.912 2.94 3.332.749.414 2.08 1.666 3.662 3.332"
          S.path ! A.d "M82.3493 279.3108c0-.664.164-.996-1.167-1.084-1.331-.083-3.161-.329-3.161-.329s-2.58-1.002-2.746-.503c-.165.503 2.162 1.505 3.163 1.669.998.168 2.245.5 2.827.829.584.335 1.084.082 1.084-.582"
          S.path ! A.d "M84.3434 298.9826c-2.827 0-5.243-.67-5.409-.253-.165.417 1.331 1.087 2.747 1.584 1.416.502 4.08.667 5.91.749 1.829.083 2.162-.332 2.079-1.246-.083-.922-2.495-.834-5.327-.834"
          S.path ! A.d "M106.4782 320.4777c-.416-.414-1.413-.082-2.996.25-1.578.338-4.16.837-5.658.755-1.497-.082-4.742-.168-4.742-.168s-1.829 0-1.829.415c0 .417 2.412.335 5.907.749 3.493.417 5.822-.332 7.487-.585 1.666-.25 2.248-.996 1.831-1.416"
          S.path ! A.d "M115.632 335.8137c-1.748.667-2.994.832-4.327.832-1.331 0-4.493.585-4.493.585s-1.497.167-1.247.752c.248.582.748 0 2.077-.168 1.334-.167 2.332 0 4.662-.082 2.33-.085 3.661-.67 5.076-.917 1.415-.252 2.993-1.002 2.247-1.918-.751-.917-2.249.249-3.995.916"
          S.path ! A.d "M133.4401 347.3947c-.999 1.002-4.827 3.585-4.827 3.585s-.748.585-2.247 1.334c-1.498.749-1.415 1.088-1.163 1.502.25.414 1.163-.585 1.995-.917.831-.335 3.579-2.172 4.993-3.332 1.414-1.173 3.244-2.089 2.911-2.918-.333-.834-.663-.25-1.662.746"
          S.path ! A.d "M103.8044 197.382s.331.762 3.403 4.608c3.076 3.842 1.429.217.66-.766-.77-.992-5.269-7.355-6.808-9.113-1.533-1.757-1.754-.878-.985.217.768 1.097 3.73 5.054 3.73 5.054"
          S.path ! A.d "M97.3288 217.1364c.438-.438-.551-.877-2.305-3.072-1.757-2.197-5.269-6.696-5.269-6.696s-.989-2.086-1.318-1.868c-.329.22 1.207 3.512 2.634 4.943 1.428 1.425 3.293 4.17 4.282 5.376.989 1.207 1.537 1.757 1.976 1.317"
          S.path ! A.d "M105.8522 254.1506c0-1.075-3.476-.911-5.047-1.243-1.574-.332-4.389-.91-4.389-.91s-3.312-.582-3.394-.165c-.083.408.663.826 2.484 1.161 1.821.328 4.554 1.157 6.624 1.489 2.07.332 3.722.747 3.722-.332"
          S.path ! A.d "M97.3288 234.152c2.304 1.865 3.84 2.745 5.048 3.403 1.208.658 2.195 1.649 2.855.88.658-.773-.551-1.318-2.525-2.198-1.976-.878-2.964-1.647-2.964-1.647s-1.097-.547-2.088-1.097c-.986-.549-2.631-1.207-.326.659"
          S.path ! A.d "M117.198 220.9812c-1.428-1.207-2.636-1.871-2.636-1.871s-1.756-1.646-2.085-1.097c-.329.553 1.974 2.198 3.071 3.184 1.099.99 3.075 3.845 4.062 3.294.989-.549-.987-2.303-2.412-3.51"
          S.path ! A.d "M104.2326 272.5647s-1.916.496-3.164.832c-1.245.335-1.33.919.917.919s3.162-.584 5.408-1.005c2.246-.414 2.999-.664 2.662-1.413-.332-.752-1.498-.5-2.415-.25-.911.25-3.408.917-3.408.917"
          S.path ! A.d "M107.7272 291.2268c-.167.42 1.58 0 2.744-.414 1.166-.417 3.578-1.663 4.993-2.084 1.417-.414 1.417-.667 1.417-1.501 0-.832-1.501-.168-3.329.417-1.831.585-4.161 2.419-4.161 2.419s-1.498.749-1.664 1.163"
          S.path ! A.d "M131.7731 302.567c1.666-1.005 2-1.751 1.415-2.253-.581-.497-1.081-.415-2.411.667-1.334 1.084-3.911 2.914-3.911 2.914s-1.331.503-2.33 1.002c-.999.5-2.248 1.334-1.915 1.834.332.5 2.414 0 3.494-.917 1.083-.917 3.997-2.251 5.658-3.247"
          S.path ! A.d "M143.091 317.5627c.666-.588 2.661-1.246 3.579-1.916.916-.667 1.498-2.665.748-2.915-.748-.249-1.165.832-2.744 1.995-1.583 1.17-6.991 4.752-6.991 4.752s.082 0-1.416.585c-1.498.581-.832 1.002.417.834 1.249-.17 2.08-.17 3.577-1.331 1.499-1.169 2.163-1.419 2.83-2.004"
          S.path ! A.d "M159.8981 331.8117c1.416-.582 3.496-2.415 4.496-3.329.996-.92 2.244-2.086 1.497-2.668-.751-.582-1.581.168-2.746 1.246-1.166 1.087-4.245 4.337-4.245 4.337s-.414.082-2.081 1.416c-1.665 1.331.084 1.081.667.5.583-.582 1.001-.917 2.412-1.502"
          S.path ! A.d "M403.9694 365.4787s-3.162-.749-5.578-2.58c-2.409-1.833-3.158-3.916-3.576-2.75-.414 1.167.917 2.001 1.834 2.668.91.667 3.408 2.498 5.239 2.833 1.834.332 3.576.913 3.576.332 0-.582-1.495-.503-1.495-.503"
          S.path ! A.d "M384.7467 378.8967c-1.334-.5-2.58-1.331-2.58-1.331s-3.99-3.003-4.492-3.582c-.496-.582-.749-.917-1.252-.417-.496.499.085.828 1.423 1.998 1.324 1.166 5.489 4.084 6.902 4.504 1.413.412 1.663.083 1.663.083s-.332-.753-1.664-1.255"
          S.path ! A.d "M461.7145 224.6413c.747-.914 1.739-2.488 3.315-4.397 1.569-1.904.335-1.49-.496-.663-.829.83-2.234 3.069-2.234 3.069s-.585.579-1.571 1.738c-.996 1.163-1.493 1.578-1.081 1.989.416.415 1.327-.826 2.067-1.736"
          S.path ! A.d "M463.0427 242.9607c.576.578 1.322-.582 2.321-1.659.988-1.077 1.817-1.819 2.728-2.652.91-.828 2.73-3.15 2.73-3.15s-1.404.746-2.566 1.659c-1.157.912-1.903 1.654-2.813 2.816-.907 1.165-2.981 2.404-2.4 2.986"
          S.path ! A.d "M472.3171 254.565c-.282-.253-1.163.417-1.907 1.164-.746.743-1.822 1.571-2.898 2.32-1.078.746-3.229 2.154-4.551 2.816-1.326.661-1.825 1.199-1.496 1.866.335.661 2.665.161 4.246-1.502 1.581-1.666 2.912-2.918 3.661-3.332.751-.419 3.218-3.077 2.945-3.332"
          S.path ! A.d "M465.4616 277.8977s-1.831.247-3.162.329c-1.328.088-1.163.42-1.163 1.084 0 .664.499.917 1.081.582.585-.329 1.83-.661 2.826-.828.999-.165 3.329-1.167 3.165-1.669-.168-.5-2.747.502-2.747.502"
          S.path ! A.d "M459.1354 298.9826c-2.824 0-5.237-.088-5.322.834-.082.914.25 1.329 2.08 1.246 1.831-.082 4.496-.247 5.907-.749 1.41-.497 2.915-1.166 2.75-1.584-.171-.417-2.586.253-5.415.253"
          S.path ! A.d "M450.404 321.3147s-3.25.086-4.746.168c-1.498.082-4.075-.417-5.663-.755-1.574-.332-2.576-.664-2.99-.25-.418.42.164 1.166 1.83 1.416 1.663.253 3.993 1.002 7.49.585 3.494-.414 5.907-.332 5.907-.749 0-.415-1.828-.415-1.828-.415"
          S.path ! A.d "M436.6686 337.2307s-3.161-.585-4.487-.585c-1.334 0-2.583-.165-4.331-.832-1.748-.667-3.245-1.833-3.994-.916-.749.916.832 1.666 2.246 1.918 1.416.247 2.747.832 5.075.917 2.33.082 3.332-.085 4.663.082 1.331.168 1.827.75 2.077.168.25-.585-1.249-.752-1.249-.752"
          S.path ! A.d "M417.116 352.3137c-1.495-.749-2.248-1.334-2.248-1.334s-3.823-2.583-4.825-3.585c-.996-.996-1.331-1.58-1.663-.746-.332.829 1.498 1.745 2.912 2.918 1.416 1.16 4.16 2.997 4.993 3.332.831.332 1.748 1.331 1.995.917.252-.414.331-.751-1.164-1.502"
          S.path ! A.d "M436.2761 201.99c3.073-3.845 3.4-4.608 3.4-4.608s2.962-3.957 3.736-5.055c.77-1.094.55-1.974-.99-.217-1.531 1.758-6.037 8.121-6.803 9.113-.769.984-2.42 4.608.657.767"
          S.path ! A.d "M455.0436 205.4992c-.329-.217-1.313 1.869-1.313 1.869s-3.515 4.499-5.276 6.695c-1.751 2.195-2.738 2.634-2.301 3.072.439.441.988-.111 1.975-1.318.984-1.206 2.856-3.95 4.282-5.376 1.425-1.428 2.963-4.721 2.633-4.942"
          S.path ! A.d "M437.6296 254.1506c0 1.079 1.654.664 3.727.332 2.066-.332 4.798-1.161 6.621-1.489 1.821-.335 2.569-.753 2.483-1.161-.079-.417-3.393.165-3.393.165s-2.817.578-4.388.91c-1.571.332-5.05.168-5.05 1.243"
          S.path ! A.d "M445.826 233.4934c-.99.549-2.086 1.097-2.086 1.097s-.987.768-2.966 1.647c-1.971.88-3.182 1.425-2.524 2.198.661.768 1.649-.224 2.856-.88 1.205-.658 2.745-1.539 5.049-3.403 2.301-1.866.658-1.209-.329-.659"
          S.path ! A.d "M423.8717 224.4919c.986.551 2.962-2.304 4.064-3.294 1.093-.986 3.4-2.632 3.071-3.184-.331-.547-2.086 1.098-2.086 1.098s-1.204.664-2.633 1.87c-1.429 1.207-3.403 2.96-2.416 3.51"
          S.path ! A.d "M436.0876 273.3108c2.248.42 3.164 1.005 5.412 1.005 2.242 0 2.156-.585.911-.92-1.246-.335-3.159-.831-3.159-.831s-2.497-.667-3.411-.917c-.917-.25-2.083-.503-2.415.25-.335.749.417.999 2.662 1.413"
          S.path ! A.d "M434.0925 290.0637s-2.33-1.834-4.161-2.418c-1.83-.585-3.329-1.249-3.329-.418 0 .835 0 1.087 1.417 1.502 1.413.42 3.828 1.666 4.99 2.083 1.166.414 2.914.834 2.75.414-.169-.414-1.667-1.163-1.667-1.163"
          S.path ! A.d "M418.943 304.8972c-.992-.5-2.326-1.002-2.326-1.002s-2.58-1.831-3.908-2.915c-1.334-1.081-1.831-1.163-2.412-.666-.585.502-.25 1.248 1.41 2.253 1.669.996 4.578 2.33 5.663 3.247 1.078.917 3.161 1.416 3.493.917.332-.5-.918-1.334-1.92-1.834"
          S.path ! A.d "M407.2125 320.0637c-1.495-.585-1.413-.585-1.413-.585s-5.41-3.582-6.988-4.752c-1.58-1.163-1.998-2.244-2.745-1.995-.751.25-.17 2.248.747 2.915.911.67 2.915 1.328 3.576 1.916.667.585 1.334.835 2.832 2.004 1.493 1.161 2.33 1.161 3.579 1.331 1.247.168 1.911-.253.412-.834"
          S.path ! A.d "M386.6608 332.8137c-1.66-1.334-2.077-1.416-2.077-1.416s-3.08-3.25-4.243-4.337c-1.17-1.078-1.995-1.828-2.747-1.246-.749.582.499 1.748 1.495 2.668.999.914 3.079 2.747 4.493 3.329 1.419.585 1.83.92 2.412 1.502.582.581 2.33.831.667-.5"
      S.g
        ! A.fill "#E9B528"
        $ do
          S.path ! A.d "M271.6915 131.1755c-11.332.193-24.625-1.371-31.941-4.097-2.599.575-5.2 1.148-7.8 1.72 12.058 4.54 22.132 6.302 39.741 6.477 17.611-.176 27.685-1.937 39.738-6.477-2.6-.572-5.201-1.145-7.801-1.72-7.315 2.727-20.607 4.291-31.937 4.097"
          S.path ! A.d "M312.9103 121.7307c-.898-.748-6.056-4.425-7.402-5.097-1.347-.676-.297-2.475-.074-3.224.224-.751 6.054-2.401 9.271-3.225 3.212-.824 2.69-1.5 2.69-1.5s-1.872-2.175-13.535-3.449c-11.658-1.274-32.137-.974-32.137-.974s-20.482-.3-32.146.974c-11.66 1.274-13.529 3.449-13.529 3.449s-.525.676 2.692 1.5c3.214.825 9.044 2.475 9.267 3.225.227.749 1.274 2.548-.073 3.224-1.346.671-6.504 4.349-7.4 5.097-.897.752-.971 1.95.448 2.025 1.421.074 1.445.05 5.456-.751 12.002-2.386 23.296-3.054 35.287-3.219 11.987.165 23.28.834 35.284 3.219 4.008.8 4.032.825 5.457.751 1.414-.075 1.341-1.273.444-2.025"
          S.path ! A.d "m227.1618 111.4504-5.138 4.085 6.324 2.768 6.781-4.808z"
          S.path ! A.d "m316.1754 111.4504-7.966 2.045 6.784 4.808 6.321-2.768z"
          S.path ! A.d "M299.6373 126.6828c-8.002-.948-13.08-1.984-27.894-1.852-14.812.131-19.888.904-27.894 1.852 5.041 2.022 13.191 3.04 27.894 3.04 14.708 0 22.856-1.019 27.894-3.04"
      S.g
        ! A.fill "#005D95"
        $ do
          S.path ! A.d "M283.005 358.42c-.952-1.498-1.226-1.359-2.316-.405-1.087.952-2.181-2.319-2.316-4.361-.136-2.037.816-8.301.816-8.301s-5.31 1.09-8.166 2.039c-2.857.955-5.58 1.228-7.893 1.775-2.314.547-3.54 1.085-4.765.816-1.223-.27-3.811-.408-5.854-.408-2.041 0-1.902.408-3.946 2.45-2.039 2.037-2.586 3.127-4.219 6.942-1.634 3.806-2.179 7.347-2.721 11.974-.359 3.031-.945 5.122-1.311 6.212h24.399c.291-.782.67-1.766 1.001-2.495.639-1.407 1.981-2.3 2.939-2.75.961-.449 1.793-.449 2.236-1.527.447-1.091 1.663-1.986 2.942-2.561 1.278-.575 3.515-.255 5.563.321 2.042.572 2.747-.832 3.318-1.599.576-.768.835-1.854 1.922-3.256 1.087-1.41.27-2.689.27-2.689s-.947-.68-1.899-2.177"
          S.path ! A.d "M322.1496 359.0676c-.317-1.407-.191-1.596-1.023-1.793-.832-.193-2.236-.446-3.45-.954-1.214-.512-1.087 2.747-1.087 2.747s-2.88.313-6.136-.064c-3.259-.385-7.093-3.322-8.436-4.285-1.34-.958-2.813-3.129-2.813-3.129s-1.023.958-2.045 1.534c-1.022.576-1.599 2.621-1.786 4.666-.194 2.046 2.365 4.535 2.553 6.58.194 2.048-2.235 6.138-3.452 7.799-.828 1.14-1.902 3.567-2.494 4.987h11.777c.247-.607.649-1.369 1.264-1.982 1.211-1.216 3.262-1.472 3.262-1.472s0-.511.446-1.596c.443-1.087 1.66-2.365 4.599-3.517 2.942-1.15 6.459-1.343 6.459-1.343s1.401-1.15 2.427-2.747c1.019-1.597.256-4.024-.065-5.431"
      S.g
        ! A.fill "#E9B528"
        $ do
          S.path ! A.d "m269.275 16.9006 6.11-.495-.558-5.339 6.529.914.285-5.269-6.888.635 1.193-5.691-7.588-.07 1.337 5.761-6.674-.635v5.269l6.601-.772z"
          S.path ! A.d "M282.6027 25.5398h-8.202v-6.998c-.781-.158-1.59-.237-2.421-.237-.734 0-1.449.064-2.143.189v7.046h-8.484c-.285.889-.44 1.835-.44 2.813 0 .4.028.797.08 1.191h21.968c.053-.394.079-.791.079-1.191 0-.979-.152-1.924-.437-2.813"
      S.g
        ! A.fill "#005D95"
        $ do
          S.path ! A.d "M271.9796 38.3942c4.877 0 9.018-2.87 10.487-6.85h-20.978c1.47 3.98 5.609 6.85 10.491 6.85"
          S.path ! A.d "M276.51 19.1833v4.809h5.439c-1.127-2.125-3.062-3.838-5.439-4.809"
          S.path ! A.d "M267.448 19.1833c-2.379.971-4.314 2.684-5.443 4.809h5.443Z"
      S.g
        ! A.fill "#DE6F10"
        $ do
          S.path ! A.d "M278.2584 108.4455c-2.069-.979-6.585-2.906-6.585-2.906s-4.29 2.115-6.622 3.287c-2.332 1.169-2.032.828-2.746 2.528-.715 1.7.073 2.301 1.088 2.753 1.018.455 8.394 4.232 8.394 4.232s7.3-3.398 9.066-4.232c1.772-.829 1.437-1.659.946-2.945-.491-1.282-1.472-1.734-3.541-2.717"
          S.path ! A.d "M293.322 106.4455c3.564 0 6.454 2.788 6.454 6.226s-2.89 6.226-6.454 6.226c-3.564 0-6.454-2.788-6.454-6.226s2.89-6.226 6.454-6.226"
          S.path ! A.d "M250.0177 106.4455c3.566 0 6.457 2.788 6.457 6.226s-2.891 6.226-6.457 6.226c-3.565 0-6.457-2.788-6.457-6.226s2.892-6.226 6.457-6.226"
      S.g
        ! A.fill "#E9B528"
        $ do
          S.path ! A.d "m264.6373 110.5969 7.216 3.677 7.14-3.677-7.308-3.425Z"
          S.path ! A.d "M293.322 107.632c-2.151 0-3.891 1.668-3.891 3.721 0 2.057 1.74 3.721 3.891 3.721 2.157 0 3.894-1.665 3.894-3.721 0-2.054-1.737-3.721-3.894-3.721"
          S.path ! A.d "M250.0177 107.632c-2.156 0-3.896 1.668-3.896 3.721 0 2.057 1.739 3.721 3.896 3.721 2.152 0 3.892-1.665 3.892-3.721 0-2.054-1.741-3.721-3.892-3.721"
          S.path ! A.d "M236.5412 91.2815c1.66.617 3.821.347 3.821.347s.653-2.865-.926-4.26c-1.581-1.39-3.01-2.396-3.935-3.325-.926-.932-1.157-1.241-1.157-1.241s0 2.477-.119 4.027c-.114 1.547.657 3.83 2.316 4.452"
          S.path ! A.d "M239.9645 93.2946c-.654 0-1.185.502-1.185 1.119 0 .622.531 1.128 1.185 1.128.652 0 1.183-.506 1.183-1.128 0-.617-.53-1.119-1.183-1.119"
          S.path ! A.d "M231.1398 93.2136c-.501.698-1.581 1.818-1.581 1.818s1.312.038 2.393.813c1.08.775 2.469 1.432 3.742 1.28 1.274-.159 1.814-1.359 1.542-2.21-.268-.85-.885-1.736-2.971-2.515-2.083-.771-2.623.115-3.125.814"
          S.path ! A.d "M235.6715 100.755c-4.055.364-9.416-4.119-9.416-4.119-.498 3.6-2.727 5.47-6.137 6.153l.314.159s3.171 1.62 6.917 2.189c1.694.259 3.201-.032 5.023-.398 2.197-.446 4.666-1.071 6.002-1.897 2.445-1.51 1.716-5.426 1.716-5.426s-.361 2.972-4.419 3.339"
          S.path ! A.d "M219.8605 96.6848c-1.665-.626-4.161-1.826-5.202-1.879-1.04-.051-2.55-.314-2.289 1.617.259 1.931 2.236 2.87 4.16 2.923 1.925.053 2.915-.677 4.06-1.254 1.143-.574.934-.779-.729-1.407"
          S.path ! A.d "M207.1681 89.796c-1.818-1.302-3.436-1.666-3.436-1.666s-1.194 3.131-.52 5.063c.677 1.931 2.082 2.45 3.799 2.396 1.717-.047 4.266-.939 3.537-2.241-.726-1.302-1.557-2.246-3.38-3.552"
          S.path ! A.d "M208.8322 97.5896c.775 0 1.403.453 1.403 1.012 0 .559-.628 1.012-1.403 1.012s-1.403-.453-1.403-1.012c0-.559.628-1.012 1.403-1.012"
          S.path ! A.d "M212.7057 83.0285c-1.124-5.338-.936-11.146 4.122-18.545 5.06-7.403 13.863-10.398 13.863-10.398s.281-.562 3.091-3.557c2.81-3 8.526-6.745 8.526-6.745s-6.631 1.637-10.403 2.843c.001.067.003.129.003.199 0 2.56-2.033 4.638-4.542 4.638-.958 0-1.85-.307-2.585-.825-2.047.398-8.86 4.47-10.602 5.923.433.71.685 1.546.685 2.442 0 2.555-2.036 4.634-4.548 4.634-.751 0-1.461-.182-2.087-.517-.204.326-.398.652-.58.986-1.429 2.627-2.484 5.149-3.258 7.455 1.164.804 1.945 2.304 1.945 4.022 0 2.546-1.723 4.616-3.856 4.636-.148 1.499-.135 2.547-.078 2.994.187 1.5.749 2.436 3.37 3.186 2.624.75 6.185 5.339 6.185 5.339.252.001 2.124-3.371.749-8.71"
          S.path ! A.d "M228.82 48.8479c.957-.777 1.124-1.966.364-2.646-.752-.682-2.14-.603-3.097.181-.955.781-1.122 1.97-.364 2.651.754.681 2.142.602 3.097-.186"
          S.path ! A.d "M211.8556 60.3156c1.075-.982 1.264-2.465.41-3.321-.85-.853-2.415-.751-3.495.23-1.078.974-1.261 2.462-.409 3.316.85.856 2.415.752 3.494-.225"
          S.path ! A.d "M204.3698 74.7346c0-1.423-1.174-2.577-2.621-2.577-1.448 0-2.623 1.154-2.623 2.577 0 1.426 1.174 2.58 2.623 2.58 1.446 0 2.621-1.154 2.621-2.58"
          S.path ! A.d "M258.3253 38.3474c-1.359.297-3.875 1.115-7.639 3.088h.069c2.617 0 4.653 1.672 4.653 3.841 0 2.171-2.379 4.526-4.995 4.526-2.614 0-4.397-2.272-4.397-4.441 0-.51.121-1.001.335-1.451-1.115.689-2.307 1.451-3.577 2.307-8.338 5.62-10.303 8.337-14.424 16.021-4.122 7.677-5.621 16.107-3.842 21.073 1.782 4.963 8.337 5.993 8.432 5.993.092 0-.749-.749-.844-1.682-.093-.942.188-1.409.468-3.284.281-1.868.094-4.116.094-4.116s1.499-.189 2.34.841c.847 1.031 2.063 2.248 2.905 3.275.843 1.03 3.09 3 3.09 3s1.315-1.876 1.315-4.124c0-2.245-1.498-4.679-1.78-8.615-.282-3.934 1.78-10.96 5.619-16.111 3.843-5.152 11.053-9.833 13.207-10.866 2.156-1.027 2.529-2.623 2.624-3.56.094-.936.279-1.59.465-3.932.19-2.343-1.965-2.248-4.118-1.783"
          S.path ! A.d "M250.032 47.2443c1.474 0 2.815-1.327 2.815-2.542 0-1.217-1.147-2.156-2.623-2.156-1.476 0-2.671.989-2.671 2.203 0 1.215 1.002 2.495 2.479 2.495"
          S.path ! A.d "M262.4435 96.2185c2.01.818 4.28.358 5.348-.355 1.069-.715 1.428-2.536.162-3.578-1.262-1.039-3.143-1.003-4.309-.354-1.167.651-3.794 2.499-3.794 2.499s.583.978 2.593 1.788"
          S.path ! A.d "M268.8732 98.4753c-.727 1.119-1.261 1.799-3.493 1.896-2.232.097-4.656-.047-6.11-1.508-1.457-1.456-2.475-3.501-2.475-3.501l-2.521-.048s-.823 3.505-1.938 4.473c-1.116.974-4.997 1.122-6.694-.145-1.699-1.267-3.249-2.823-3.54-2.626-.291.196-.001 1.459 1.745 2.968 1.745 1.504 2.955 2.433 5.773 2.433h16.002s3.25.191 4.173-1.754c.919-1.944.964-3.163.531-3.647-.433-.487-.724.337-1.453 1.459"
          S.path ! A.d "M244.5504 95.7663c2.401 1.333 3.729.521 4.602-.554.877-1.071 1.039-1.559 1.039-1.559s-2.269-.815-3.37-1.464c-1.104-.648-1.849-1.268-2.95-1.138-1.104.132-1.265.294-1.265.294s-.455 3.085 1.944 4.421"
          S.path ! A.d "M275.423 92.2844c-1.261 1.042-.902 2.863.161 3.578 1.072.714 3.341 1.173 5.352.355 2.013-.809 2.594-1.788 2.594-1.788s-2.627-1.849-3.793-2.5c-1.169-.648-3.047-.683-4.314.355"
          S.path ! A.d "M297.7414 99.6428c-1.695 1.265-5.58 1.119-6.694.145-1.117-.968-1.94-4.473-1.94-4.473l-2.522.047s-1.023 2.045-2.474 3.502c-1.461 1.46-3.882 1.605-6.116 1.508-2.228-.096-2.762-.778-3.49-1.896-.726-1.122-1.017-1.945-1.455-1.46-.432.484-.385 1.703.535 3.648.92 1.944 4.17 1.753 4.17 1.753h16.006c2.813 0 4.026-.928 5.772-2.433 1.745-1.508 2.033-2.771 1.745-2.968-.289-.196-1.844 1.359-3.537 2.627"
          S.path ! A.d "M296.5578 92.1882c-1.099.649-3.364 1.464-3.364 1.464s.158.488 1.031 1.559c.875 1.075 2.21 1.887 4.608.554 2.398-1.336 1.943-4.422 1.943-4.422s-.162-.162-1.264-.294c-1.103-.13-1.847.491-2.954 1.139"
          S.path ! A.d "M309.152 86.8293c-.114-1.55-.114-4.027-.114-4.027s-.23.309-1.155 1.241c-.932.929-2.357 1.935-3.941 3.326-1.578 1.394-.923 4.259-.923 4.259s2.16.271 3.818-.347c1.657-.621 2.429-2.905 2.315-4.452"
          S.path ! A.d "M304.6002 94.4118c0-.616-.529-1.118-1.179-1.118-.657 0-1.19.502-1.19 1.118 0 .623.532 1.128 1.19 1.128.65 0 1.179-.505 1.179-1.128"
          S.path ! A.d "M307.6886 97.1242c1.273.152 2.662-.503 3.74-1.28 1.082-.774 2.392-.812 2.392-.812s-1.078-1.122-1.583-1.819c-.5-.699-1.04-1.586-3.124-.814-2.083.778-2.7 1.665-2.974 2.516-.261.851.274 2.051 1.549 2.209"
          S.path ! A.d "M317.1242 96.6359s-5.357 4.484-9.416 4.119c-4.058-.367-4.419-3.34-4.419-3.34s-.731 3.916 1.713 5.427c1.334.825 3.809 1.45 6.003 1.897 1.822.365 3.332.656 5.026.397 3.746-.568 6.92-2.189 6.92-2.189l.309-.159c-3.409-.683-5.636-2.551-6.136-6.152"
          S.path ! A.d "M328.7233 94.8064c-1.04.053-3.541 1.254-5.199 1.879-1.666.627-1.878.834-.731 1.408 1.143.576 2.13 1.306 4.058 1.254 1.922-.054 3.903-.992 4.161-2.923.262-1.933-1.252-1.668-2.289-1.618"
          S.path ! A.d "M336.214 89.796c-1.822 1.306-2.654 2.25-3.385 3.552-.726 1.302 1.821 2.194 3.54 2.241 1.717.054 3.118-.465 3.797-2.396.679-1.932-.523-5.063-.523-5.063s-1.611.364-3.429 1.666"
          S.path ! A.d "M334.548 97.5886c-.773 0-1.404.455-1.404 1.012 0 .56.632 1.012 1.404 1.012.778 0 1.407-.452 1.407-1.012 0-.557-.629-1.012-1.407-1.012"
          S.path ! A.d "M337.0392 75.5832c0-1.717.788-3.218 1.948-4.021-.773-2.307-1.824-4.828-3.253-7.456-.182-.334-.379-.66-.582-.986-.629.335-1.334.518-2.092.518-2.509 0-4.54-2.079-4.54-4.635 0-.896.25-1.732.683-2.442-1.746-1.453-8.558-5.524-10.605-5.923-.735.519-1.622.825-2.58.825-2.51 0-4.543-2.077-4.543-4.637 0-.071.003-.133.003-.2-3.771-1.207-10.397-2.842-10.397-2.842s5.707 3.743 8.519 6.744c2.81 2.996 3.091 3.557 3.091 3.557s8.804 2.996 13.865 10.398c5.057 7.4 5.242 13.207 4.119 18.545-1.372 5.34.503 8.712.749 8.712 0 0 3.559-4.59 6.183-5.34 2.621-.751 3.185-1.687 3.373-3.186.053-.446.067-1.495-.079-2.993-2.133-.021-3.862-2.092-3.862-4.638"
          S.path ! A.d "M314.5592 48.8479c.955.788 2.345.867 3.101.186.755-.68.593-1.869-.365-2.651-.958-.784-2.345-.863-3.1-.181-.758.68-.591 1.869.364 2.646"
          S.path ! A.d "M331.5265 60.3156c1.079.977 2.645 1.081 3.494.225.856-.854.667-2.342-.414-3.316-1.073-.98-2.643-1.083-3.491-.23-.853.856-.667 2.34.411 3.321"
          S.path ! A.d "M341.6325 72.1565c-1.445 0-2.624 1.154-2.624 2.577 0 1.426 1.179 2.58 2.624 2.58 1.448 0 2.624-1.154 2.624-2.58 0-1.423-1.176-2.577-2.624-2.577"
          S.path ! A.d "M281.403 44.0617c.091.937.47 2.533 2.624 3.56 2.153 1.033 9.368 5.714 13.206 10.866 3.847 5.151 5.901 12.178 5.624 16.111-.285 3.936-1.777 6.37-1.777 8.614 0 2.248 1.307 4.125 1.307 4.125s2.248-1.97 3.092-3c.838-1.027 2.057-2.245 2.901-3.275.843-1.03 2.342-.842 2.342-.842s-.186 2.248.094 4.117c.282 1.874.565 2.342.47 3.284-.097.933-.937 1.682-.84 1.682.091 0 6.65-1.03 8.427-5.993 1.778-4.966.279-13.396-3.843-21.073-4.12-7.684-6.085-10.402-14.423-16.022-1.27-.855-2.456-1.617-3.579-2.306.218.451.332.941.332 1.451 0 2.168-1.777 4.44-4.393 4.44-2.616 0-4.995-2.355-4.995-4.526 0-2.168 2.039-3.84 4.655-3.84h.07c-3.764-1.973-6.277-2.791-7.64-3.088-2.154-.466-4.308-.56-4.119 1.782.188 2.342.371 2.997.465 3.933"
          S.path ! A.d "M271.6915 82.3747s-.608 2.547-1.422 3.628c-.815 1.083-1.432 2.048-1.199 3.366.235 1.315 1.739 2.193 2.621 2.193.879 0 2.386-.878 2.618-2.193.237-1.318-.379-2.283-1.196-3.366-.814-1.081-1.422-3.628-1.422-3.628"
          S.path ! A.d "M271.7374 92.7873c-.746 0-1.352.61-1.352 1.359 0 .748.606 1.356 1.352 1.356.75 0 1.358-.608 1.358-1.356 0-.749-.608-1.359-1.358-1.359"
          S.path ! A.d "M266.9 87.1643s2.346-2.607 3.214-4.257c.869-1.649 1.578-3.125 1.578-3.125s.705 1.476 1.574 3.125c.87 1.65 3.215 4.257 3.215 4.257s3.3-1.738 5.21-8.077c1.913-6.34-.438-13.025-1.305-20.233-.867-7.206-1.564-19.622-1.564-19.622-2.501 1.431-4.863 2.039-7.131 2.08-2.27-.041-4.633-.649-7.135-2.08 0 0-.693 12.416-1.562 19.622-.869 7.209-3.214 13.894-1.302 20.233 1.909 6.339 5.208 8.077 5.208 8.077"
          S.path ! A.d "M290.5338 44.7014c0 1.215 1.34 2.542 2.818 2.542 1.476 0 2.481-1.28 2.481-2.495 0-1.214-1.199-2.203-2.674-2.203-1.476 0-2.625.938-2.625 2.156"
      S.g
        ! A.fill "#DE6F10"
        $ do
          S.path ! A.d "M232.9401 66.8254c2.95 0 5.341 2.37 5.341 5.293s-2.391 5.293-5.341 5.293-5.341-2.37-5.341-5.293 2.391-5.293 5.341-5.293"
          S.path ! A.d "M242.2091 53.776c-2.137-1.438-5.275-.863-7.014 1.283-1.732 2.151-1.406 5.063.736 6.5 2.137 1.441 5.281.863 7.016-1.282 1.736-2.143 1.405-5.057-.738-6.501"
      S.g
        ! A.fill "#E9B528"
        $ do
          S.path ! A.d "M232.7296 68.4777c-1.713 0-3.104 1.319-3.104 2.955 0 1.631 1.391 2.959 3.104 2.959 1.716 0 3.107-1.328 3.107-2.959 0-1.635-1.391-2.955-3.107-2.955"
          S.path ! A.d "M239.9884 54.3606c-1.375-.376-3.075.301-3.792 1.511-.717 1.212.042 2.503 1.875 2.877 3.375.689 4.98-3.548 1.917-4.388"
      S.g
        ! A.fill "#DE6F10"
        $ do
          S.path ! A.d "M271.6706 67.42c-3.15 0-5.699 2.469-5.699 5.501 0 3.037 2.55 5.499 5.699 5.499s5.698-2.462 5.698-5.499c0-3.032-2.548-5.501-5.698-5.501"
          S.path ! A.d "M271.6706 54.732c3.028 0 5.483 2.369 5.483 5.292 0 2.922-2.455 5.292-5.483 5.292-3.029 0-5.484-2.37-5.484-5.292 0-2.923 2.455-5.292 5.484-5.292"
          S.path ! A.d "M271.6706 42.6423c2.889 0 5.231 2.259 5.231 5.046 0 2.787-2.342 5.047-5.231 5.047s-5.231-2.26-5.231-5.047 2.342-5.046 5.231-5.046"
          S.path ! A.d "M310.445 66.8244c-2.95 0-5.345 2.368-5.345 5.291 0 2.924 2.395 5.295 5.345 5.295 2.942 0 5.333-2.371 5.333-5.295.001-2.922-2.391-5.291-5.333-5.291"
          S.path ! A.d "M308.1881 55.0588c-1.739-2.146-4.881-2.721-7.014-1.283-2.146 1.445-2.472 4.358-.74 6.502 1.733 2.145 4.88 2.722 7.017 1.281 2.139-1.437 2.468-4.349.737-6.5"
      S.g
        ! A.fill "#E9B528"
        $ do
          S.path ! A.d "M310.6505 68.4777c-1.716 0-3.109 1.319-3.109 2.955 0 1.631 1.393 2.959 3.109 2.959 1.713 0 3.106-1.328 3.106-2.959 0-1.635-1.393-2.955-3.106-2.955"
          S.path ! A.d "M303.3927 54.3606c-3.065.839-1.458 5.077 1.922 4.388 1.827-.374 2.588-1.665 1.871-2.877-.72-1.21-2.415-1.887-3.793-1.511"
          S.path ! A.d "M271.6706 69.0232c-1.666 0-3.021 1.306-3.021 2.915 0 1.608 1.355 2.908 3.021 2.908s3.021-1.3 3.021-2.908c0-1.609-1.355-2.915-3.021-2.915"
          S.path ! A.d "M271.6706 61.8767c1.605 0 2.906-1.254 2.906-2.8 0-1.546-1.302-2.806-2.906-2.806-1.602 0-2.906 1.259-2.906 2.806 0 1.546 1.304 2.8 2.906 2.8"
          S.path ! A.d "M271.6706 49.2424c1.404 0 2.548-1.101 2.548-2.459 0-1.354-1.144-2.46-2.548-2.46-1.407 0-2.548 1.106-2.548 2.46 0 1.358 1.141 2.459 2.548 2.459"
      S.g
        ! A.fill "#DE6F10"
        $ do
          S.path ! A.d "M450.0837 447.2278c-2.58 0-4.681 2.095-4.681 4.681 0 2.583 2.101 4.681 4.681 4.681 2.589 0 4.685-2.098 4.685-4.681 0-2.586-2.096-4.681-4.685-4.681"
          S.path ! A.d "M463.281 450.3489c-2.643 0-4.796 2.151-4.796 4.799 0 2.65 2.153 4.798 4.796 4.798 2.656 0 4.808-2.149 4.808-4.798s-2.151-4.799-4.808-4.799"
          S.path ! A.d "M501.694 458.51c-2.654 0-4.805 2.151-4.805 4.798 0 2.654 2.152 4.805 4.805 4.805 2.648 0 4.799-2.152 4.799-4.805 0-2.648-2.151-4.798-4.799-4.798"
          S.path ! A.d "M476.49 453.466c-2.651 0-4.799 2.151-4.799 4.805 0 2.648 2.149 4.799 4.799 4.799 2.649 0 4.802-2.152 4.802-4.799 0-2.654-2.152-4.805-4.802-4.805"
          S.path ! A.d "M479.9694 441.9475c-2.651 0-4.802 2.148-4.802 4.802 0 2.647 2.152 4.801 4.802 4.801 2.647 0 4.799-2.154 4.799-4.801 0-2.655-2.152-4.802-4.799-4.802"
          S.path ! A.d "M483.3288 430.422c-2.648 0-4.802 2.152-4.802 4.805 0 2.651 2.154 4.801 4.802 4.801 2.653 0 4.804-2.151 4.804-4.801 0-2.654-2.152-4.805-4.804-4.805"
      S.g
        ! A.fill "#E9B528"
        $ do    
          S.path ! A.d "M450.4372 449.0998c1.291 0 2.339 1.048 2.339 2.339 0 1.292-1.048 2.34-2.339 2.34-1.292 0-2.34-1.048-2.34-2.34 0-1.291 1.048-2.339 2.34-2.339"
          S.path ! A.d "M463.6462 452.2678c-1.319 0-2.401 1.075-2.401 2.401 0 1.322 1.081 2.404 2.401 2.404 1.324 0 2.401-1.082 2.401-2.404-.002-1.326-1.077-2.401-2.401-2.401"
          S.path ! A.d "M502.0505 460.4309c-1.319 0-2.401 1.075-2.401 2.398 0 1.326 1.081 2.399 2.401 2.399 1.321 0 2.401-1.072 2.401-2.399-.002-1.322-1.08-2.398-2.401-2.398"
          S.path ! A.d "M476.8454 455.3908c-1.318 0-2.395 1.072-2.395 2.398 0 1.327 1.076 2.399 2.395 2.399 1.328 0 2.406-1.072 2.406-2.399 0-1.326-1.078-2.398-2.406-2.398"
          S.path ! A.d "M480.3268 443.8664c-1.321 0-2.4 1.078-2.4 2.401 0 1.325 1.078 2.398 2.4 2.398 1.325 0 2.401-1.072 2.401-2.398 0-1.323-1.075-2.401-2.401-2.401"
          S.path ! A.d "M483.6891 432.3469c-1.324 0-2.397 1.079-2.397 2.401 0 1.324 1.072 2.402 2.397 2.402 1.322 0 2.403-1.078 2.403-2.402 0-1.322-1.081-2.401-2.403-2.401"



{- |
Flag of Malta coat of arms.
Drawn for a @viewbox 0 0 900 600@
-}
mtCoA :: Svg
mtCoA = 
  S.g
    ! A.transform (S.translate (-14.21) (-568.61) <> S.scale 0.98 0.98)
    $ do
      S.path 
        ! A.fill "#FFFFFF"
        ! A.d "M97.239 599.85c-.0949.00001-.17181.077-.17182.17182v44.457c-7.2241 0-13.735 6.598-13.735 14.129h-44.852c-.09489.00001-.1718.077-.17181.17181v48.139c.000011.0949.07693.17181.17181.17182h44.458c0 7.494 6.9466 13.734 14.128 13.734v44.852c.00001.0949.077.17181.17182.17182h48.139c.0949-.00001.17179-.077.1718-.17182v-44.458c7.2484 0 13.745-7.1261 13.745-14.128h44.841c.0949-.00001.17181-.077.17182-.17182v-48.139c-.00001-.0949-.077-.17179-.17182-.1718h-44.457c0-8.1046-7.5922-13.736-14.13-13.736v-44.851c-.00001-.0949-.077-.17181-.17181-.17182z"
      S.g
        ! A.fill "none"
        ! A.stroke "#000000"
        ! A.strokeWidth "0.1"
        ! A.strokeLinecap "round"
        ! A.strokeLinejoin "round"
        $ do
          S.path ! A.d "M124.59 691.7c.0636-.0324.13339-.0491.20239-.0655.0893-.0222.18107-.032.27197-.0453.084-.009.16651-.0258.24871-.0445.10906-.0274.2205-.0404.33232-.0496.17779-.0102.35597-.009.53397-.008.13293.00046.2658.005.3987.007.11702.001.23285.0209.34765.042.15241.0297.30356.0649.45624.0933.13901.0243.27846.0453.41675.0735.0928.021.18648.0381.2795.0583.0587.0147.11803.0253.17761.0354.0639.009.12768.0194.19063.0339.0596.0146.11939.0276.17937.0401.0639.0135.12808.0253.19254.0358.0563.009.11244.0194.16877.0285.0566.005.11277.0131.16923.0187.0467.005.094.005.14092.006.0393-.00023.0788.00069.11813.002.0198.00069.0396.002.0596.002.0179-.00023.0358-.00024.0537-.00023.0113.0001.006-.00022.0164.001.0276.0144-.006.0795-.0338.0651-.0104-.00018-.005-.00015-.0163-.00006-.0178.00001-.0356 0-.0534-.0002-.0205.00002-.0411.001-.0616.002-.04.001-.0801.003-.12019.002-.0476-.00006-.0951-.00099-.14257-.004-.0566-.005-.1132-.0102-.16928-.0197-.0571-.009-.11469-.014-.17174-.0232-.064-.0118-.12785-.0241-.19123-.0388-.0602-.0122-.12058-.0239-.18012-.039-.063-.014-.12673-.0231-.1903-.0337-.0596-.0113-.11873-.025-.17893-.0327-.0962-.0109-.19115-.0294-.28665-.0451-.14052-.021-.28133-.0403-.42121-.0653-.15264-.0278-.30443-.0599-.45549-.0954-.11123-.0263-.22351-.0566-.33876-.054-.13728.006-.2744.0153-.41179.0183-.0321.00046-.0642.001-.0963.001-.14268-.00047-.28512-.0109-.42782-.0106-.10984.005-.21861.0189-.32648.0408-.0832.0149-.1657.0338-.24954.045-.0896.0137-.17983.0235-.26888.0408-.0656.0156-.13006.0352-.19524.0525-.0295-.0139.003-.0835.0326-.0697z"
          S.path ! A.d "M138.95 698.7c-.0202.0174-.0457.0313-.0677.0475-.0111.008-.0316.025-.042.0334.0135-.0208-.0628.0715-.049.0528.012-.0163.0254-.0322.0394-.0477.007-.008-.0129.0167-.019.0252-.0156.0217-.0162.0238-.0291.0454-.0193.0326-.0285.067-.0317.10199.0001.0246.004.049.0102.0732.005.0181.0173.0345.0269.0515.009.0147.0141.0304.0222.0454.008.0136.0193.0262.0293.0391.0101.0104.0167.0224.0308.0305.0287.0121-.0118.0598-.0406.0476v0c-.0143-.008-.0271-.017-.0358-.0287-.0114-.0131-.0208-.027-.0286-.0414-.009-.0138-.0178-.0277-.0256-.0419-.0101-.0174-.0202-.0346-.0273-.0526-.0103-.0223-.0169-.0454-.0176-.0688-.00014-.0326.006-.065.0209-.096.003-.006.006-.0131.0101-.0196.0278-.0504.0719-.0983.11029-.14349.007-.008.0149-.0164.0232-.0242.007-.007.015-.0127.0224-.019.0303-.0227.0621-.0451.0993-.0621.0311.009.00023.0609-.0306.0517z"
          S.path ! A.d "M132.96 696.24c-.016-.0393-.0163-.0829-.0257-.12393-.004-.0161-.009-.0317-.0129-.0476-.005-.0182-.008-.0365-.0127-.0548-.023-.11236-.054-.22301-.0936-.3306-.0374-.11609-.0627-.23558-.0888-.35459-.0193-.078-.0344-.15767-.0624-.23316-.005-.0141-.0114-.0277-.0171-.0417-.006-.0138-.0118-.0279-.0191-.0412-.0291-.0526-.0714-.10583-.10488-.15593-.0118-.0177-.0828-.1269-.0933-.14291-.017-.0252-.0335-.0508-.0511-.0755-.0184-.0257-.0383-.0503-.0568-.0759-.0627-.0868-.12188-.17616-.18432-.26318-.0483-.0727-.10101-.14237-.1512-.21375-.0458-.0643-.12205-.0922-.19106-.12431-.0821-.0413-.16232-.0858-.24594-.12384-.0553-.0264-.11535-.0403-.17441-.0554-.0674-.0177-.13447-.0353-.20302-.0474-.0139-.002-.0275-.006-.0416-.007-.19417-.0174.0812.0154-.13223-.008-.0692-.008-.13794-.0196-.20646-.0318-.10187-.0189-.20422-.0343-.30603-.0534-.0741-.0157-.14959-.0214-.22479-.0288-.0805-.011-.16151-.0115-.24256-.0128-.10112-.008-.20215-.0119-.30356-.0125-.0625-.002-.12507.00017-.18754-.00067-.0588-.00092-.11727-.006-.17571-.0112-.0577-.004-.11555-.0126-.17356-.012-.0314.00024-.0626.002-.094.003-.0717-.00092-.14321-.006-.21476-.0104-.0353-.001-.0704-.003-.10521.004-.0179.004-.0477.0128-.0646.0178-.0725.0251-.14571.0477-.22072.0637-.0638.0139-.12659.0321-.18911.0508-.0412.0118-.0819.0259-.12367.0354-.0413.009-.0837.0138-.12557.0196-.0471.0113-.0956.0157-.1432.0244-.0195.003-.0387.008-.0582.0118-.0443.008-.072.0108-.11625.0164-.0893.0101-.17827.0215-.26695.036-.0671.0119-.13408.0251-.20017.0417-.053.012-.1062.023-.15903.0356-.0507.0123-.10206.0214-.15237.0352-.0297.006-.0573.018-.0862.0265-.0213.008-.0416.0185-.0625.0277-.0271.0186-.0588.028-.0875.0435-.0217.0144-.0433.0284-.0655.0418-.0155.0125-.0296.0265-.0457.0382-.004.005-.009.008-.0148.0109-.0562-.0245.001-.15699.0576-.13255v0c.005-.005.009-.009.0147-.014.0154-.0149.0312-.0296.0494-.0412.0228-.0147.0435-.0325.0679-.0446.029-.0154.058-.0313.089-.0424.0212-.007.0419-.0157.0619-.0256.0305-.0132.0607-.0274.0923-.0375.0514-.0167.10311-.032.15654-.0406.0542-.009.10715-.0241.15994-.0394.0686-.0185.13677-.0382.20653-.0514.0926-.017.18408-.0382.27667-.0545.0192-.003.0383-.007.0576-.009.0831-.0112.16735-.0129.25043-.025.0813-.0158.16279-.0312.24383-.0484.0633-.0169.12657-.0337.1897-.0512.0734-.0225.14603-.0485.22129-.0637.0563-.009.11284-.0138.17003-.0135.075-.004.15005-.009.22519-.0101.0155.00045.031.00069.0466.001.0148.0009.0294.002.0442.003.0605.002.12114-.003.18163-.003.12178-.002.24352.00099.36509.009.099.009.19762.0213.29701.0253.08.006.1593.0178.2395.021.0757.008.1511.0205.22723.0252.0479.003.0962.005.14397.0102.0587.006.11714.0142.17617.0171.0698.007.13939.0149.20795.0305.10356.0235.0268.008.1174.0378.013.004.0267.007.0401.0101.0667.0177.13289.0371.19939.0556.06.0161.11831.0366.17853.0515.0898.0261.17805.0598.26044.10419.0339.0221.0567.0353.0874.0612.0339.0286.0616.0635.0926.095.0594.0574.11913.1145.17638.17413.0708.0752.14311.15076.20456.23403.0193.0262.0372.0534.0551.0805.0171.026.0332.0526.0498.0789.0351.0606.0551.0931.0862.15529.0378.0757.0677.15513.10455.23127.0373.0874.0648.17768.0862.27022.0325.11379.0663.22719.0966.34157.005.0218.0101.0438.0154.0654.0241.091.0594.17918.0756.2723.0134.0764.009.0413.0164.1179.005.0519.0117.10448.003.1564.0522.0371-.0353.16011-.0875.12301z"
          S.path ! A.d "M128.41 695.2c.0663-.0378.14197-.0534.21301-.0797.064-.0279.13163-.0452.19734-.0681.019-.007.0669-.0248.0842-.0337.0217-.011.0422-.0242.0635-.0359.0781-.0432.15742-.0842.23656-.12539.14096-.0678.2758-.14788.41799-.21303.034-.0156.0687-.0299.10295-.0448.0982-.042.20377-.0611.30496-.0937.0453-.0147.0893-.033.13463-.0475.13382-.0428.16135-.0459.29769-.0768.18478-.0396.37166-.0682.55836-.097.19827-.0305.0648-.0128.25359-.0357.12812-.0174.25696-.0255.38611-.0284.0257-.00069.0514-.002.0771-.001.0232.00023.0463.002.0695.003.0803.008.15933.0256.23363.0571.0166.007.0322.0165.0469.027.057.0327-.0198.1671-.0769.13448v0c-.0165-.006-.0332-.0105-.0504-.014-.0306-.004-.062-.009-.0931-.0101-.054-.002-.10803.003-.1619.005-.0472.003-.1052.007-.15183.0129-.13671.0179-.27128.051-.40701.0745-.29445.0584.0467-.008-.25904.0476-.18918.0344-.37733.0745-.56537.11454-.13141.0272-.15572.0337-.28611.0554-.0399.007-.0804.0101-.11992.0183-.0342.007-.0673.019-.10071.0294-.0722.0225-.13196.044-.20342.0689-.0935.0343-.0971.0333-.18541.0742-.11051.0512-.21502.11434-.3253.16608-.0733.0343-.14688.0697-.224.0949-.018.006-.0367.009-.0549.0148-.1073.0309.0192-.003-.0803.0232-.0672.0184-.13308.0398-.19645.0689-.0549.0214-.12139.0496-.1808.0521-.007.00023-.0151-.001-.0225-.002-.0576-.0285.0101-.1643.0673-.13577z"
          S.path ! A.d "M130.22 696.46c.0652-.0475.14095-.0783.21395-.11177.066-.0313.12963-.0664.1916-.10509.089-.0537.17029-.11819.2553-.17758.089-.0595.18097-.11453.27351-.16833.0866-.0511.17834-.0921.2729-.12567.10255-.0297.20517-.0588.30626-.0934.11943-.0477.24056-.0917.3629-.1315.079-.025.15861-.0478.23781-.0722.0596-.0178.1206-.03.18214-.0386.0428-.006.0843-.0176.12676-.0242.004-.00069.008-.001.0118-.002.0592.028-.007.16759-.0661.13953v0c-.005.002-.0101.004-.0148.006-.0435.0133-.0875.0248-.13221.033-.0635.0124-.12421.0356-.18652.0529-.0842.0249-.1653.0591-.24618.0929-.11858.0497-.23763.10021-.36316.12991-.10121.0308-.2034.0584-.30431.0901-.0278.009-.0677.0223-.095.0337-.061.0255-.11752.0607-.17441.094-.0931.056-.18721.11074-.27497.17519-.0443.0301-.0893.0587-.13452.0874-.0185.0117-.0574.0385-.076.05-.0126.008-.0257.0147-.0386.022-.0631.0328-.12826.0614-.18943.0978-.0573.0311-.11634.0649-.17944.0827-.008.002-.0158.003-.0236.004-.0599-.0272.004-.16826.0641-.14104z"
          S.path ! A.d "M138.95 698.7c-.0202.0174-.0457.0313-.0677.0475-.0111.008-.0316.025-.042.0334.0135-.0208-.0628.0715-.049.0528.012-.0163.0254-.0322.0394-.0477.007-.008-.0129.0167-.019.0252-.0156.0217-.0162.0238-.0291.0454-.0193.0326-.0285.067-.0317.10199.0001.0246.004.049.0102.0732.005.0181.0173.0345.0269.0515.009.0147.0141.0304.0222.0454.008.0136.0193.0262.0293.0391.0101.0104.0167.0224.0308.0305.0287.0121-.0118.0598-.0406.0476v0c-.0143-.008-.0271-.017-.0358-.0287-.0114-.0131-.0208-.027-.0286-.0414-.009-.0138-.0178-.0277-.0256-.0419-.0101-.0174-.0202-.0346-.0273-.0526-.0103-.0223-.0169-.0454-.0176-.0688-.00014-.0326.006-.065.0209-.096.003-.006.006-.0131.0101-.0196.0278-.0504.0719-.0983.11029-.14349.007-.008.0149-.0164.0232-.0242.007-.007.015-.0127.0224-.019.0303-.0227.0621-.0451.0993-.0621.0311.009.00023.0609-.0306.0517z"
          S.path ! A.d "M130.22 696.46c.0652-.0475.14095-.0783.21395-.11177.066-.0313.12963-.0664.1916-.10509.089-.0537.17029-.11819.2553-.17758.089-.0595.18097-.11453.27351-.16833.0866-.0511.17834-.0921.2729-.12567.10255-.0297.20517-.0588.30626-.0934.11943-.0477.24056-.0917.3629-.1315.079-.025.15861-.0478.23781-.0722.0596-.0178.1206-.03.18214-.0386.0428-.006.0843-.0176.12676-.0242.004-.00069.008-.001.0118-.002.0592.028-.007.16759-.0661.13953v0c-.005.002-.0101.004-.0148.006-.0435.0133-.0875.0248-.13221.033-.0635.0124-.12421.0356-.18652.0529-.0842.0249-.1653.0591-.24618.0929-.11858.0497-.23763.10021-.36316.12991-.10121.0308-.2034.0584-.30431.0901-.0278.009-.0677.0223-.095.0337-.061.0255-.11752.0607-.17441.094-.0931.056-.18721.11074-.27497.17519-.0443.0301-.0893.0587-.13452.0874-.0185.0117-.0574.0385-.076.05-.0126.008-.0257.0147-.0386.022-.0631.0328-.12826.0614-.18943.0978-.0573.0311-.11634.0649-.17944.0827-.008.002-.0158.003-.0236.004-.0599-.0272.004-.16826.0641-.14104z"
          S.path ! A.d "M139.95 685.83c-.13352.0691-.2863.085-.43375.0991-.12414.0101-.24874.008-.37308.004-.0335.00046-.066-.003-.0988-.009-.0546-.0288.0132-.15743.0679-.12867v0c.0338.003.0674.002.10121-.00023.12717-.006.25416-.0144.38112-.0234.14111-.0121.28486-.0267.41758-.0794.0583.0263-.004.16372-.0621.13738z"
          S.path ! A.d "M140.95 687.54c-.13072.0755-.24603.10579-.39623.10051-.15614-.0217-.29793-.089-.43687-.15947-.0779-.0423-.15078-.089-.20845-.15659-.0633-.0821-.10443-.17803-.14162-.27399-.0344-.0752-.0551-.15465-.0762-.23414-.0548-.0377.0341-.16701.0889-.12929v0c.0205.078.0418.15536.0783.22778.0382.0959.0753.19427.13024.28187.057.0658.13498.1.21247.13701.13875.0636.27654.13521.42925.15851.1451.002.25102-.0335.38289-.0907.0588.0266-.004.16509-.0627.1385z"
          S.path ! A.d "M144.02 692.17c-.14145-.0572-.26933-.1427-.40053-.21972-.11418-.0644-.21566-.14725-.31926-.22681-.064-.047-.12288-.10291-.19224-.14233-.0326-.0185-.0636-.0302-.0981-.0446-.12278-.0423-.25335-.0456-.38176-.0512-.11848-.004-.237-.005-.35555-.005-.10804-.004-.21486.007-.32106.0257-.0832.0181-.16376.0441-.24038.0811-.0912.0592-.1805.12334-.26064.19705-.097.0835-.17836.18202-.25674.28256-.0897.11867-.1905.22825-.2826.34492-.0576.063-.10909.13095-.16404.19615-.0653.074-.11811.15806-.17581.23798-.072.0973-.1365.20011-.21093.29552-.058.0757-.11946.14957-.18787.21613-.0879.0689-.19631.0952-.30225.12247-.14077.0279-.28262.0515-.42545.066-.16104.0202-.32156.0143-.48215-.005-.13611-.0211-.26915-.0585-.40057-.0991-.12228-.0383-.23661-.0954-.34743-.15886-.12812-.069-.24235-.15897-.35105-.25491-.0986-.0865-.19364-.17664-.28927-.2663-.10502-.10334-.21664-.19829-.33759-.28235-.17833-.11043-.34998-.23104-.52547-.34587-.15673-.0982-.31997-.18572-.49001-.25852-.11941-.0563-.24722-.0618-.3766-.0632-.0643-.0331.0137-.18462.078-.15156v0c.12949.008.25927.0198.3818.066.17408.0669.34174.1489.50034.24722.17709.11343.34678.23768.51993.35696.11931.0879.23087.18463.3366.28849.0949.0903.18822.18199.28791.26706.1101.0922.22468.1799.3499.25084.10873.0643.21856.1275.34117.1619.13217.0376.26644.07.40263.0889.1586.0166.31706.0247.47625.008.14238-.0161.28335-.0413.42408-.068.10233-.0217.20716-.044.28873-.11412.0684-.0696.12921-.14632.18859-.22354.0731-.0971.13869-.19968.21116-.29728.0561-.0771.10916-.15669.17291-.22778.0567-.0687.11067-.13949.16809-.20753.0922-.11802.19239-.22964.28397-.34824.0782-.0981.16115-.19222.25636-.27434.0806-.0716.16753-.13765.26237-.18922.0791-.0355.16047-.0653.2456-.0829.10718-.0213.21529-.0308.3247-.0265.11964-.00046.23931-.003.35895.00023.12972.005.26126.0131.38408.0592.0312.0132.0708.0291.10071.0454.0704.0385.13095.0927.19571.13952.10241.0798.20292.16256.3181.22385.1346.0713.26649.14746.39257.23309.056.0322-.0197.16426-.0757.13213z"
          S.path ! A.d "M136.74 687.68c.0778.0462.14936.10305.21551.16456.0531.0521.10119.10862.15677.15813.0551.0486.11564.0908.17819.1292.0766.0538.15693.1001.24016.14264.0842.0488.16862.0972.25056.14948.0747.0466.15258.0877.22593.13648.0911.0499.17829.10614.26746.15922.0823.0523.1649.104.25238.14722.0996.0485.20005.0945.30597.12716.14045.0402.28613.042.43056.0308.12858-.014.25191-.0498.37104-.0986.0345-.0164.0687-.0325.10129-.0522.059.0261-.002.1652-.0616.1391v0c-.0343.021-.0696.0399-.1059.0571-.12168.0548-.24873.0955-.38223.10908-.14558.009-.29161-.00006-.4323-.0415-.10551-.0359-.20633-.082-.30476-.13424-.0874-.0442-.17235-.0927-.25573-.14395-.0887-.0544-.17557-.11173-.26543-.16411-.0733-.0487-.1506-.0903-.22545-.13641-.0826-.0505-.1678-.0969-.25116-.14614-.0822-.045-.16338-.0917-.23968-.14627-.0613-.0418-.12171-.0856-.17837-.1334-.0559-.0491-.10474-.10452-.15801-.1564-.0675-.0593-.14144-.1098-.21097-.16651-.0553-.0322.0203-.16263.0757-.1305z"
          S.path ! A.d "M140.15 689.59c-.0221.003-.0379.0175-.0541.0394-.0269.0285-.0516.0587-.0725.0917-.0509.0774-.19702.33763-.0528.0842.004-.006-.008.0125-.0125.0188-.0335.0418-.0588.0889-.0877.13379-.052.07-.0955.14617-.13423.22415-.002.005-.008.0167-.007.0157-.00046.00069-.00046.001-.00091.002-.0182.0319-.036.0641-.0511.0976-.011.0263-.0191.0535-.0277.0805-.006.004-.013.008-.0206.0103-.0452.0202-.0911.0387-.13736.0563-.0357.0162-.0723.0272-.11052.0354-.0315.007-.0646.00046-.0967.003-.0374.00022-.075-.00018-.11231-.002-.0613-.004-.12288-.0109-.18121-.0313-.0735-.0309-.1438-.0692-.21298-.10873-.0631-.0378-.12308-.0828-.17852-.1311-.0672-.0667-.12411-.14188-.18076-.21745-.0541-.0343-.13463.0933-.0805.12752.0467.0842.10905.15843.18031.22282.0584.0463.11879.0916.18211.13109.0345.0213.0696.0416.10559.06.00002.00014-.00002.00023 0 .00046.002.0113.007.0212.017.0277.0451.0998.10868.18952.17137.27875.0425.0586.0858.1167.12931.1745.0666.0706.13266.14136.1991.21208.0782.0733.15118.15125.23087.22283.0624.0521.12203.10857.18926.15436.053.0353.10968.0657.16779.0917.0863.0404.1784.0634.27069.0851.12976.0239.25974.0466.39105.06.0866.0116.17123.008.25548-.0139.0888-.0252.16488-.0801.24161-.1293.0971-.0634.19649-.12284.29531-.18346.0112-.006.0228-.0127.034-.0192.0597.0267.12274-.11425.0631-.14094-.0111.006-.0224.0116-.0336.0175-.0983.0569-.19916.11001-.29261.17494-.0779.0524-.15208.11411-.24251.14363-.0815.0209-.16171.0208-.24474.005-.13036-.0175-.26036-.0369-.39016-.0582-.0934-.0168-.18517-.0364-.27292-.0738-.0582-.0233-.11377-.0537-.16511-.0895-.0644-.0489-.12284-.10603-.1848-.15794-.0772-.0743-.14829-.15439-.22728-.22685-.0659-.0695-.13686-.13359-.20314-.20268-.0438-.0579-.0869-.11657-.12661-.17718-.0211-.0344-.0423-.069-.0635-.10336.0294.004.0594.006.0891.007.0382.00069.0763-.00046.11454-.00092.0331-.001.0666.002.0993-.003.038-.007.0751-.0162.11141-.0295.0471-.0168.0933-.0369.13871-.0578.0845-.0367.10939-.12636.15257-.20403.0188-.0448.0271-.0927.0488-.13647.006-.0119.007-.0143.009-.0175.0115-.0205.0227-.0402.0327-.0609.002-.002.002-.002.005-.007.0302-.044.0567-.0903.0877-.13378.0113-.0164.0259-.0403.0398-.0635-.002.004-.002.003-.004.007-.0262.0468.0258-.0413.0308-.0488.0197-.0333.0451-.0618.0703-.0908.0185-.0195.0363-.0529.0671-.0478.0327.026.0525.0658.0761.0998.0535.084.12006.15832.18925.22954.10031.1098.22318.19216.35169.26487.1517.0838.31538.13441.48546.16287.15163.0242.3035.0209.45503.00045.16089-.0216.31354-.0773.46802-.12438.0649-.0215.13281-.0354.19687-.0596.0248-.008.0469-.0219.0694-.0349.0573.0256.11769-.10959.0604-.13513-.022.0123-.043.0264-.0672.0345-.0599.0261-.12619.0323-.18926.0478-.15417.0365-.30498.0872-.4613.11453-.1506.0244-.30074.0356-.4519.006-.16737-.0312-.32713-.0861-.47919-.16331-.13024-.0672-.25036-.14747-.35214-.25414-.0699-.0675-.1372-.13808-.19462-.21656-.0267-.0353-.0501-.0759-.0895-.0984-.009-.002-.0172-.003-.0246-.002zm-.45638.73378c.003-.006-.006.0118-.009.0175-.002.003-.004.005-.005.008.005-.008.0101-.0168.0148-.0251z"
          S.path ! A.d "M140.66 686.81c.0378.0993.0797.19688.13375.2884.0435.065.10368.1158.16644.16138.0606.0468.12975.0749.20331.0933.0497.0106.10021.0185.15102.0177.056.0283-.0106.16035-.0667.13207v0c-.053.003-.10591-.004-.15784-.014-.0752-.019-.14518-.0504-.20812-.0964-.0658-.0452-.12396-.0993-.17228-.16315-.0628-.0889-.11115-.18764-.13507-.29427-.0531-.0362.0324-.16137.0855-.12513z"
          S.path ! A.d "M134.14 689.75c-1.0029.41205-1.7458.8924-1.4696 2.0126.27624 1.1202 1.1284 1.4175.55592 2.5429"
          S.path ! A.d "M127.4 700.72c.13185-.17789-.17458-.46109-.82337-.37526-.0867-.17889-.84003-.17407-1.4792.093.4288-.39228.915-1.0489.97649-1.8514.0667-.86946-1.0016-2.0367-1.8931-1.769-.48666-.51348-1.5903-.86771-2.4885-.67857"
          S.path ! A.d "M135.2 700.44c-.14655-.70332-.78168-3.073-4.5938-1.0749"
          S.path ! A.d "M133.43 688.97c-.012.007-.0239.0136-.0361.02-.0338.0176-.064.0308-.0982.048-.0624.0313-.12288.0658-.18351.10021-.14665.0844-.28158.18672-.41295.29291-.12451.0997-.22318.2263-.32102.35111-.15028.19226-.28035.39901-.40468.60865.021-.0359.0356-.0763.063-.10759.0231-.0264-.0338.0613-.0498.0925-.0337.0657-.0663.13462-.0869.2059-.005.0176-.008.0358-.0123.0537-.0177.1084-.0183.21846-.0284.32762-.008.083-.0159.16596-.0249.24885.0565.0414-.0409.17456-.0974.13325v0c-.006-.0776.003-.15481.0109-.23194.011-.11021.0146-.22097.0285-.33092.008-.0456.009-.0599.0225-.10441.0558-.18641.17357-.35003.26398-.51859.11922-.20192.24838-.39838.39716-.58.10119-.11869.20115-.24014.32127-.34049.12903-.107.2642-.20637.41335-.284.0955-.0486.19302-.10276.29949-.12168.0581.0272-.006.16401-.0641.13684z"
          S.path ! A.d "M129.99 687.84c-.0729.12438-.13728.2571-.23146.36782-.0125.0148-.0264.0285-.0395.0429-.0689.07-.15215.1209-.23901.16497-.0658.0315-.13236.0609-.19831.0918-.0468.0237-.0957.0421-.14476.0601-.0357.0114-.0654.0324-.0937.0562-.0635-.0272.00069-.17677.0641-.14958v0c.0294-.0215.0599-.0393.0955-.0485.0507-.0203.0988-.0458.14781-.0698.0675-.0328.13526-.0649.20134-.10041.0871-.0489.17109-.10336.23806-.17878.0513-.0586.096-.1202.13851-.18527.008-.0126.0317-.0516.0248-.038-.0185.0364-.0399.0714-.0598.10702-.0511-.041.0453-.16139.0965-.12047z"
          S.path ! A.d "M137.75 696.86c-.10111.0527-.20712.0952-.3142.13383-.10924.0394-.21737.0817-.32599.12273-.0849.0307-.16894.0641-.2551.091-.0666.0195-.13195.0413-.19729.0645-.0789.0255-.1563.0554-.23668.076-.062.0139-.12559.018-.1889.02-.0356.001-.0712-.00069-.10673-.003-.0591-.0301.0119-.16943.071-.1393v0c.0367-.002.0734-.004.11018-.005.0634-.002.12651-.005.18718-.0259.0794-.0254.15676-.0569.23736-.0785.0666-.0184.13315-.0368.19664-.0644.0861-.0338.17278-.0658.25863-.1002.10994-.0453.2178-.0961.33117-.13244.0577-.0206.11524-.042.17293-.0627.0322-.0115.0605-.0226.0936-.0308.0105-.003.0212-.004.0319-.006.0596.0278-.006.16824-.0656.14041z"
          S.path ! A.d "M137.77 696.78c-.021-.0531-.0281-.1103-.0411-.16566-.009-.0462-.0298-.0888-.053-.12955-.022-.0375-.0466-.0733-.0697-.11015-.0234-.032-.0363-.0694-.0531-.10479-.0328-.0512-.065-.10284-.10114-.15177-.0219-.0269-.0413-.057-.0667-.0809-.0308-.0288-.0672-.0536-.10061-.079-.0762-.0547-.15289-.10865-.2338-.15603-.0936-.0604-.19542-.10484-.29696-.14988-.12991-.0646-.26601-.11451-.40312-.16138-.11996-.0433-.2436-.0757-.36767-.10485-.11052-.0247-.22297-.0394-.33589-.0468-.10122-.005-.20236-.006-.30357-.001-.11182.007-.22289.0166-.33309.0367-.1239.0223-.24803.0419-.3704.0719-.0852.021-.16831.0482-.2481.0847-.0639.0325-.12013.0774-.17977.11666-.0628.0415-.12675.0809-.19045.12084-.0357.0235-.0724.0456-.10937.067-.009.006-.0167.0149-.0233.0236-.002.003-.006.011-.005.008.0702-.12.0874-.15649.0635-.10685-.008.0187-.0139.038-.0191.0575-.001.003-.003.007-.004.0105.0489.0391-.0433.15436-.0921.11527v0c.002-.003.004-.007.006-.0104.008-.0185.0107-.039.0177-.058.0279-.0646.0594-.13448.11646-.17802.0383-.0272.0774-.0534.11541-.081.0627-.0426.12598-.0843.19118-.12296.0594-.0403.11672-.0844.18178-.11516.0837-.0416.16953-.0787.26021-.10255.12233-.0335.24656-.0532.37203-.0709.10989-.014.22016-.0287.33115-.0284.10214-.004.20442-.005.30657-.00045.11455.006.22907.0155.34065.044.1266.026.252.0562.37553.0946.0551.0175.0874.027.1416.0477.0895.0343.17446.0788.26046.12074.099.0512.1967.10462.29097.1642.0794.0511.16092.0995.23478.15856.0613.0509.12029.10438.16647.16988.0385.051.0687.10711.0964.1646.0177.0347.028.073.0509.10474.0246.0354.0511.0696.0734.10651.0228.0419.0432.0845.057.13023.0185.0566.0295.11517.0365.17434.0525.0366-.0338.16015-.0862.12359z"
          S.path ! A.d "M134.97 689.83c-.0827.0427-.17476.0609-.26217.091-.0229.008-.0453.0167-.068.0251-.11996.0438-.23906.0892-.35391.14506-.0795.0387-.15747.0801-.23316.12569-.0533.0381-.10919.0736-.15674.11896-.0203.0194-.0452.0484-.0638.0696-.0101.0138-.02.0273-.0295.0413-.0101.0145-.0372.0593-.0288.0439.02-.0365.0395-.0735.0637-.10736.012-.0168-.0184.0371-.0269.0559-.0243.0539-.0321.0773-.0533.13318-.0517.14672-.0842.29909-.10438.45307-.0153.1326-.009.26594-.005.3989.003.14153.0259.28133.0506.42039.0131.0703.0291.14091.0526.20855.0323.093.077.18231.1169.27207.0955.20705.19328.41315.29589.61678.0796.14805.17703.28722.29026.41148.0144.0143.0287.0285.0432.0427.0265.0259.0523.0513.0805.0752.0444.0377.0925.0709.13801.10706.0993.074.18354.16466.27257.25006.0867.0927.173.18549.26045.27741.089.0942.1828.18336.27503.27419.0903.0867.17996.17384.2676.26328.0824.0824.16835.16088.2578.23556.0692.0602.14784.10729.22227.16033.0625.0431.12632.0842.19053.12474.0583.0351.11543.0718.17567.10359.051.0236.10051.0522.15471.0677.0339.0128.0682.0241.10172.0376.024.0153.0506.0253.0766.0365.0262.0109.0519.0227.0772.0354.0229.0118.0446.0256.0665.0391.0154.007.0294.0157.0439.0242.0163.0113.0311.0235.0443.0384.0434.0541-.0121.12927-.0669.16689-.0565-.0236-.00091-.15677.0556-.13316v0c.0322-.0418.003-.005-.0593.11117-.00069.001.002-.002.003-.003.002-.006-.006-.0133-.009-.0177-.0128-.0133-.0256-.0262-.0402-.0374-.0142-.009-.0285-.0166-.0446-.0219-.0229-.0114-.045-.0236-.0665-.0373-.0259-.0115-.0524-.0213-.0779-.0338-.0253-.0121-.0512-.0228-.0767-.0344-.0338-.0122-.0675-.0253-.10283-.0323-.0563-.0142-.11115-.0338-.16265-.0608-.0608-.0314-.11751-.0694-.17588-.10507-.0663-.0374-.1334-.0738-.1954-.11834-.0771-.0497-.1546-.0986-.22816-.15334-.0917-.0719-.18276-.14514-.26436-.22868-.0889-.0882-.1752-.17885-.26543-.26566-.0961-.087-.19238-.17348-.27833-.27085-.0871-.0922-.1706-.18771-.25978-.27791-.0829-.0907-.17388-.17357-.26894-.25152-.0901-.0723-.17813-.14731-.26526-.22311-.0372-.0338-.0632-.0561-.098-.0933-.083-.0885-.15463-.1868-.21744-.29045-.11113-.19932-.21034-.40519-.29924-.61538-.014-.0348-.0288-.0693-.0419-.10441-.0491-.13255-.0839-.27034-.11089-.40897-.0268-.1381-.049-.27736-.0559-.41808-.004-.13576-.002-.27165.007-.40721.0131-.15287.038-.3048.0945-.44842.0666-.17455.14986-.34542.26743-.49192.0239-.0266.0403-.0461.0668-.0703.0484-.0442.10388-.0802.15872-.11583.077-.045.15843-.0811.23474-.12713.11581-.066.23556-.12409.36445-.16033.10231-.0295.20507-.0621.3111-.0747.0587.0277-.007.1659-.0654.13817z"
          S.path ! A.d "M143.44 693.6c-.006.00092-.0117.002-.0177.003-.024.002-.0482.002-.0723.003-.0193.001-.0417.004-.0608.006-.0651.006-.13053.006-.19571.0117-.0312.003-.0628.005-.0934.0127-.0139.003-.0315.009-.045.0127-.0607.0222-.124.034-.18757.0438-.044.003-.0851.0196-.1258.0352-.0276.0148-.0569.0277-.0807.0485-.0229.0228-.0416.0497-.0605.0758-.0187.0231-.036.0467-.0506.0725.13338-.25566.0656-.106.0364-.046-.0314.064-.0697.12462-.10586.1858-.0101.0166-.0232.0317-.0348.0469-.0252.0325-.0497.0655-.0719.10011-.0295.0505-.0803.13285.0571-.0984.003-.005-.005.0108-.008.0162-.013.026-.004.008-.0171.0347-.02.0447-.0423.0883-.064.13211-.031.0619-.0635.12293-.0976.18314-.0564.11761-.13368.2225-.20057.33377-.0245.0375-.0462.0767-.0724.11304-.0235.032-.0485.0615-.0768.0893-.0291.0272-.062.0496-.0955.0708-.03.0167-.0561.0392-.0852.0571-.0203.0126-.0267.0154-.0481.0263-.0455.0256-.096.0392-.1457.0539-.0234.008-.0461.0174-.0697.0246-.0184.006-.0375.009-.0563.0135-.0387.0102-.079.0134-.11888.0144-.0344-.001-.0689-.00023-.1031-.003-.0269-.004-.0542-.002-.0812-.00046-.0406.004-.0812.007-.12188.003-.028-.002-.0559-.005-.084-.006-.022-.00092-.0437-.00023-.0654-.004-.008-.001-.0158-.003-.0237-.005-.0563-.0295.0133-.16241.0697-.13284v0c.009.00005.0173.00023.0259.00092.0219.001.0437.001.0655-.00008.03-.00069.0599-.003.0899-.006.0395-.003.079-.00092.11839.003.0272.002.0545.004.0816-.00014.0353-.002.0707-.00092.10598-.004.0382-.002.0769-.003.11387-.0139.0434-.0155.0855-.0342.1298-.0468.0497-.0169.0986-.0357.14508-.0602.0436-.0236.0851-.0508.1283-.0747.0331-.0185.0634-.0414.0898-.0687.0277-.0291.0524-.0609.0755-.0939.0273-.0413.0511-.0847.0766-.12712.0401-.0674.18472-.30001.0101-.005.0349-.0616.0667-.12474.10125-.18657.0261-.0484.0518-.0971.0763-.14635.0401-.085.0885-.16565.13717-.24588.0225-.0345.0467-.068.073-.0997.005-.006.0178-.0235.0225-.03.003-.005.0124-.0194.0101-.0145-.12931.23077-.0849.15092-.0582.10031.0379-.0814.0713-.16264.12591-.2365.0166-.0262.0357-.0508.0538-.076.0188-.0245.0379-.0487.0618-.0685.0276-.0216.0569-.041.0889-.0555.0439-.0215.0904-.0363.13716-.0502.0599-.0146.12011-.0282.18165-.0339.0488-.011.0967-.0248.14568-.0345.0655-.0101.13165-.0155.19795-.0124.0391.002.0873.00046.12335.0179.004.002.008.005.0119.008.0569.03-.0139.16414-.0708.13408z"
          S.path ! A.d "M142.38 695.47c-.00091.003-.001.006-.002.009-.004.0122-.014.0314-.0199.0418-.0547.0959-.0906.17187-.15391.25145-.008.008-.0161.0176-.0249.0256-.0196.0179-.0423.0336-.0642.0482-.0304.0204-.0572.0373-.0898.0546-.0168.009-.0341.0168-.0511.0252-.0748.0358-.15549.0545-.23758.0624-.0479.006-.0961.0106-.14427.0148-.0463.007-.0932.0114-.14002.014-.0144.00069-.0288.002-.0432.002-.0132-.00023-.0264-.002-.0396-.003-.0511-.007-.10316-.0123-.15171-.0308-.0124-.006-.022-.0153-.0309-.0258-.0561-.0348.0258-.16711.082-.13234v0c.008.008.0141.0126.0262.0119.0219-.001.0434-.004.0652-.005.0347-.002.0694-.001.10402-.001.0694.00092.13859.007.20781.0124.0179-.00092.0276-.001.0453-.004.0346-.005.0685-.0151.10229-.0235.0863-.0269.16722-.067.2506-.10125.0522-.0221.11208-.0436.15779-.0777.0237-.0177.0291-.0259.0485-.0476.007-.009.0138-.0186.0202-.0281.006-.009.0243-.0391.0188-.029-.0253.046-.0523.0911-.078.13681-.006.0103.0122-.0203.0183-.0305.006-.009.011-.019.0166-.0284.004-.007.009-.0151.0136-.0227-.0504-.0399.0438-.15852.0942-.11858z"
          S.path ! A.d "M138.47 700.3c.0491-.0192.10134-.0282.15211-.0417.0344-.009.0684-.0193.10254-.0288.0455-.0137.0913-.0276.13449-.0478.0411-.0193.0802-.0432.11935-.066.0645-.0417.13242-.0777.19807-.11737.0111-.008.0225-.0154.0336-.0235.0174-.0127.0548-.0424.0715-.055.0395-.0299.08-.0583.1212-.0859.0631-.0416.12797-.0805.18931-.12461.0429-.0317.0779-.0719.11451-.11035.0437-.0482.0903-.0936.13751-.13833.0276-.0284.0499-.0614.0728-.0935.0156-.0237.037-.0411.0587-.0587.0233-.0189.0452-.0403.0704-.0566.0112-.007.005-.004.0171-.009.0597.0264-.003.16713-.0623.14071v0c-.0105.008-.005.004-.0158.0126-.0226.0231-.0458.046-.0738.0628-.008.006-.0125.008-.0194.0158-.0136.0147-.0241.0324-.036.0485-.026.0384-.0509.078-.0834.1113-.045.0475-.0901.0952-.13801.13984-.0377.0371-.0776.0717-.11577.10826-.0641.0585-.13194.11011-.20536.15647-.0267.0175-.0536.0346-.08.0525-.0457.0308-.0898.0643-.13806.0912-.0324.0197-.0651.0388-.097.0594-.0212.0136-.0486.0328-.0695.0466-.0124.008-.0251.0163-.0376.0245-.0834.0506-.17056.0965-.26496.12292-.017.004-.0339.009-.0511.0122-.0455.008-.11523.0159-.15953-.003-.006-.003-.0111-.007-.0166-.0111-.0568-.0301.0143-.16415.0711-.13399z"
          S.path ! A.d "M139.88 698.03c-.0513-.00092-.11305.098-.0671.13065-.004.0575.0148.11257.0371.16466.0194.0418.0417.0817.0568.12526.016.0462.0317.0929.0502.13827.0176.0504.0374.0993.0618.14675.0267.0667.0601.13021.0958.1924.0254.0431.0546.0837.0788.12751.0875.159-.0461-.0765.0461.0851.0348.0554.0691.11161.10873.16377.0261.0344.0332.0412.0618.0734.0309.0378.0694.068.10828.0971.0121.009.0248.0171.0367.0264.0132.0103.0256.0218.0385.0327.0147.0113.0296.0227.0443.034.0714.0553.1582.0786.24206.10739.0224.007.0454.0131.0685.0179.064.035.14635-.11577.0823-.15078-.0202-.008-.04-.017-.0572-.0308-.0713-.0503-.14047-.10403-.21835-.14408-.0242-.0131-.0668-.0354-.0899-.0515-.0122-.008-.0235-.0185-.0349-.0282-.0362-.0307-.0698-.0637-.10425-.0962-.0287-.0337-.0333-.0377-.0591-.0738-.0288-.0404-.0547-.0828-.0819-.12438.00024-.007.00024-.0134.00092-.0201.00046-.004.00092-.008.002-.0111.0149-.0174.0299-.0348.0474-.0497.0394-.0308.0817-.0586.12036-.0904.0157-.0103.0321-.021.0483-.0304.0291-.0168.0599-.0304.0891-.047.0584.0283.12503-.10947.0667-.1378-.004-.00047-.009-.001-.0135-.001-.0419.00022-.0816.0244-.11588.0456-.0472.0279-.0866.0665-.12752.10245-.0271.0232-.05.051-.072.0788-.0287.0358-.0541.0743-.077.11454-.007-.0103-.0139-.0204-.0214-.0304-.009-.0116-.0188-.0226-.0277-.034-.03-.0385-.0562-.0798-.0805-.12215-.0117-.021-.0238-.042-.0354-.0631-.0217-.0399-.0411-.0814-.0667-.11902-.0244-.0443-.0507-.0877-.0653-.13646-.0148-.0465-.031-.0933-.051-.1378-.0181-.0431-.0367-.0859-.0528-.12976-.0118-.0415-.0213-.0893-.0434-.12662-.002-.004-.005-.007-.008-.0107-.007-.005-.0138-.007-.021-.007z"
          S.path ! A.d "M140.66 697.48c-.99947.72845-2.8596 1.5929-3.2432 2.2392"
          S.path ! A.d "M127.61 695.3c-.1957.0882-.0495.29025.10162.22807 0 0 .74426-.4946 1.3624-.0981 1.1438.73377.28539 1.4708.37454 1.5122.0978.12482.90659-.85595 1.7908-.40812.64755.32799.44545 1.0781.3307 1.597.23576.16239.79859-1.2511 1.4145-1.9672.29352.47149 1.0654.43384.89092-.15631-.17447-.59014-.54234-2.2043-2.1639-3.3262-.61693-.253-.71124-.4678-.35939-.75314.57532-1.0513-1.5383-3.2746-3.9807-3.8506"
          S.path ! A.d "M139.2 698.07c-.0506.0107-.10157.0197-.15029.0374-.0376.0136-.0576.0242-.0939.0413-.0935.0472-.18814.0918-.28408.13383-.0861.0359-.1641.0872-.24289.13635-.0753.0437-.14369.0965-.20853.15408-.0819.072-.16486.1428-.24833.21295-.0822.0688-.17228.12707-.259.18984-.0874.0679-.17685.13272-.26756.19595-.0828.0621-.17356.1116-.26478.15993-.10969.0569-.21787.1164-.3309.1665-.0823.0335-.16573.0639-.24732.0991-.0128.006-.0256.0114-.0383.0169-.0273.0118-.0478.0193-.0739.034-.0454.0255-.0886.0561-.13272.0837-.0882.06-.18038.10889-.27959.14763-.0103.004-.0207.008-.0311.0116-.009.003-.0185.005-.0275.009-.0252.009-.0495.021-.0745.0306-.0283.0108-.0471.017-.0756.0266-.0599.0195-.11884.0415-.17786.0633-.0284.0115-.0588.0163-.0885.0229-.0189.007-.0372.0166-.056.0244-.0273.006-.0384-.014-.0481-.036-.003-.009-.006-.0187-.008-.0284-.0101-.0479-.0103-.0977-.0134-.14628-.003-.0446-.005-.0718-.008-.1164-.005-.11672-.042-.22686-.0795-.33625-.041-.1119-.0767-.22549-.10725-.34064-.0137-.0436-.0176-.0911-.0394-.13202-.0104-.0194-.0176-.0254-.0323-.0419-.0583-.0554-.12917-.0954-.19588-.13962-.0789-.0465-.15222-.1007-.22489-.15611-.0652-.0527-.14205-.0859-.2184-.11866-.1387-.0571-.2831-.0987-.42815-.13612-.14396-.0393-.28919-.0735-.43389-.11003-.0572-.0127-.11406-.0306-.17247-.0376-.0217-.003-.0438-.003-.0656-.004-.0818-.005-.0527-.003-.13286-.0102-.10336-.0132-.20757-.0153-.31149-.0207-.0998-.005-.1997-.004-.29955-.005-.0965-.005-.19302-.007-.28948-.0119-.0651-.00023-.12978-.0115-.19478-.0119-.0528.005-.10198.0271-.15065.0467-.0367.0128-.0673.0278-.0949.0552-.0625-.026-.001-.17323.0612-.14726v0c.0309-.0297.0661-.052.10696-.0661.0494-.0184.1003-.0312.1526-.038.0691-.006.13828-.0102.20763-.0107.0975-.00047.19486.004.29234.006.0995.00091.199.004.29847.008.0327.00093.0653.002.0981.003.0746.00045.14928-.003.2239-.00069.0579.003.0758.003.13318.0122.0209.003.0416.008.0625.0122.0592.0107.11891.0176.17788.0293.14952.0264.29942.0522.44673.0893.0467.0142.11459.034.16055.0513.0874.0329.1714.0754.25221.12177.0715.0437.14047.091.21068.13658.0781.047.15868.0901.23298.14315.0662.05.13193.10139.18644.16439.0115.0148.024.03.0343.0457.0229.035.0388.074.0565.11167.0423.10724.0809.21585.11787.32501.0351.11263.0665.22687.0797.34442.0104.10897.0126.21844.002.32758-.00024.008-.00069.0162-.00069.0243-.00009.004-.00007.008-.00003.0126.00001.001-.00092.003.00021.004.003.002.015-.008.0175-.007.019-.009.038-.0181.0582-.024.0333-.0111.0639-.0288.0959-.0432.0607-.027.12326-.0496.18436-.0755.0351-.0134.0402-.0158.0761-.0273.0229-.007.0465-.0119.0689-.0206.0124-.005.053-.0274.063-.033.045-.0257.0895-.0522.13475-.0773.0341-.0189.0689-.0368.10271-.0561.0155-.009.0306-.0183.046-.0275.0306-.0183.0565-.0346.0883-.0509.0503-.0259.10283-.0474.15423-.0708.087-.0353.17204-.075.25509-.1186.10783-.0558.21662-.10947.32721-.15959.0924-.0457.17998-.0992.2623-.16144.0902-.0646.17806-.13228.26807-.19713.0874-.0604.17501-.12073.25665-.18885.0816-.0696.16101-.14195.24614-.20737.0682-.0526.13704-.10424.20972-.15052.0793-.0514.16033-.0997.24664-.13852.0949-.0467.18941-.0942.28607-.13697.0651-.026.13717-.0534.20881-.0412.008.001.0156.005.0234.007.0585.0304-.0132.16818-.0717.13777z"
          S.path ! A.d "M132.89 692.87c-.0369-.018-.0634-.0506-.0955-.0755-.0275-.0213-.0315-.0213-.0639-.0383-.0879-.0453-.18036-.0807-.27243-.11632-.0148-.005-.0293-.0119-.0445-.0167-.0344-.0107-.07-.0175-.10466-.0273-.048-.0135-.0953-.0297-.14313-.0436-.0877-.0243-.17652-.044-.26438-.0675-.0989-.0121-.19405-.0426-.29107-.0636-.0585-.015-.11695-.0291-.17474-.0463-.005-.002-.0106-.004-.016-.007-.0593-.032.0162-.17154.0753-.13957v0c.006.00046.0117.00092.0177.002.0626.005.12487.0139.18686.0238.0989.0163.20014.0236.29468.06.0877.024.17544.0481.26448.0665.0498.0106.0996.0212.14841.0356.0637.0187.0404.0137.10132.0357.0151.005.0304.0101.0456.0152.0944.0334.19005.0669.27129.12709.0542.0435.11726.081.14672.14681.0547.0349-.0275.16386-.0822.129z"
          S.path ! A.d "M130.18 692.04c.0158-.0453.0266-.0911.0329-.13858.006-.0481.0109-.0962.0126-.14462.003-.0347-.004-.0687-.0124-.10206-.0106-.0416-.0271-.0812-.0397-.12212-.0161-.0517-.0326-.10341-.053-.15355-.0269-.0622-.0601-.1214-.0912-.18157-.0439-.0781-.0875-.15633-.13283-.23357-.0561-.0887-.11857-.17326-.18153-.25719-.0555-.0734-.11266-.14565-.17152-.2164-.062-.0723-.12376-.1447-.18663-.21621-.0745-.0807-.14789-.16243-.2227-.24286-.0642-.0687-.13014-.13559-.19805-.20049-.0731-.0731-.15029-.14191-.22983-.20787-.0935-.0721-.18324-.14879-.27341-.22496-.0864-.0618-.17124-.12543-.25905-.18518-.0883-.0598-.18245-.11051-.27647-.1606-.0936-.0489-.19151-.0883-.29043-.12473-.10136-.0301-.20355-.0567-.30325-.0921-.098-.0364-.19236-.0814-.28841-.12243-.0928-.0432-.19093-.0726-.28845-.10272-.10102-.0337-.20609-.0522-.30996-.0747-.15161-.0315-.30214-.0681-.45234-.10558-.1517-.0387-.30344-.0771-.45674-.10898-.093-.0192-.18598-.0391-.27996-.0531-.0275-.004-.11544-.0147-.14282-.018-.12132-.0131-.24189-.0319-.36237-.0509-.0801-.0115-.16046-.0219-.23956-.0393-.009-.002-.1033-.0249-.11475-.0276-.10449-.0239-.21104-.0377-.31774-.0468-.0945-.007-.1885-.0177-.28295-.0247-.0888-.007-.17784-.007-.2668-.006-.0911.002-.18222.004-.27329.007-.0727.004-.14551.005-.21829.006-.0649-.003-.12963.002-.19426.007-.0764.005-.15267.0105-.22863.0196-.0724.008-.14456.0181-.21749.0203-.0455.002-.0908-.003-.13617-.005-.0299-.00024-.0599-.00069-.0897-.002-.0202-.001-.0405-.002-.0607-.002-.009.00018-.0176-.00006-.0264-.00046-.0558-.0284.0112-.16005.0671-.1316v0c.009-.00046.0179-.00068.0269-.00046.0209-.00011.042-.001.0629-.002.0305-.001.0611-.002.0917-.002.0483-.002.0963-.0102.14455-.0139.0733-.008.14651-.0162.21956-.0262.0756-.008.15125-.0153.22732-.0143.065-.00045.12991-.005.19492-.007.0737-.001.1474-.006.22078-.0131.0922-.0101.18499-.0162.27777-.0128.0891.003.1782.003.26724.007.0957.005.19106.0155.28694.0176.10841.008.2161.0222.32302.0422.11781.0196.23331.0491.35064.071.12407.014.2489.0161.37297.0303.14263.0189.28434.0436.42601.0686.15471.0299.3086.0638.46132.10274.14857.037.29585.0789.44134.12662.10051.0318.20087.0636.30353.0878.0992.028.19709.0609.29193.10134.0955.0414.18834.0888.28761.12086.0998.0339.20092.0636.30116.0962.10101.0344.20249.069.29667.11987.0949.0511.18526.1076.27523.16679.0888.059.1786.1167.26175.18354.0956.0695.19086.13968.27721.22067.0245.0225.0596.0543.0835.0778.0476.0467.0918.0967.14015.14266.0658.0666.13431.13048.20143.19573.0789.077.15772.15451.22512.24199.0596.0756.11848.1519.18055.22559.0598.0691.11749.1399.17676.20941.0675.082.13143.1672.1835.25991.0432.0813.086.16276.12617.24555.0297.0637.061.1268.0853.1929.0203.0516.0389.10395.052.15788.0119.0429.0234.086.0365.12842.008.0346.0142.0698.0149.10526.00068.0447.003.0895-.002.13401-.007.055-.0191.1088-.043.15935.0505.0399-.0438.15891-.0943.11892z"
          S.path ! A.d "M123.41 690.09c.0418-.003.0833.004.12433.0114.0279.002.0559.004.0839.005.0277-.001.0553-.002.083-.00092.0326.00006.065-.00046.0975-.004.0332-.006.0692.00046.10209-.002.0126-.00092.0252-.004.0378-.005.0151-.002.0302-.003.0453-.004.0446-.003.0887-.0114.13315-.0154.0273-.002.0548-.003.0822-.005.10612-.008.0979-.0111.20709-.0136.036-.00092.072.00012.10799.00018.039-.00068.0781-.001.11713-.002.12502-.002.13057-.005.25463.00091.10307.005.20494.0161.30718.0292.003.00047.1438.0168.15079.017.0302.001.0606-.002.0908-.002.0872.001.17431.0108.26095.0195.0274.002.0549.004.0824.006.0283.002.0567.003.0851.005.0916.008.18278.0218.27278.0403.0739.0159.14779.0314.22303.0392.0952.0149.19067.0269.28571.0423.0864.015.17146.0394.25867.0494.0223.003.0447.004.0671.005.15055.004.29628.0449.44166.0802.10397.0184.20616.0455.30842.0715.0278.005.0549.0135.0827.0187.0162.003.0325.004.0486.007.0472.008.0936.02.13979.0328.05.0135.0988.0316.14941.0427.13483.0296-.0479-.0147.0883.019.0651.0185.1295.039.19511.0556.0469.012.094.0248.13982.0406.0337.0132.0697.0185.10446.0278.06.016-.005.001.0656.0162.0818.0212.16323.0441.24182.0752.0553.0249.11076.0492.16579.0745.0357.0171.071.0349.10556.0541.0306.0197.0608.04.0913.0596.0411.0263.0775.0597.11001.0958.0269.0322.0532.0649.0788.0982.0161.0235.0336.0467.0469.0719.0103.0195.0145.0329.0221.0535.0134.0431.0259.0865.0374.1301.0113.0357.0211.0717.0301.10806.0125.0514.0142.10461.0138.15728-.00069.0341-.005.0681-.0117.10154-.005.023-.0146.0446-.0262.0648-.0836.14598-.0521.1007-.0924.15761-.0174.02-.0394.0344-.063.046-.0118.007-.006.004-.0178.0101-.0581-.0259.003-.16289.061-.13702v0c.0123-.008.006-.004.0192-.0123.0219-.0136.0434-.0281.0569-.0507.0303-.0496.0242-.0396-.062.10858-.002.004.004-.009.007-.013.008-.0156.0168-.0312.0215-.0486.009-.0299.0141-.0597.009-.091-.003-.0529-.004-.10602-.009-.15885-.006-.0376-.0142-.0752-.0266-.11132-.0113-.0404-.0309-.0779-.0439-.11782-.0174-.0453-.028-.094-.0581-.13334-.0246-.0326-.0536-.0608-.0824-.0895-.0327-.035-.0635-.0721-.10322-.0996-.029-.021-.0556-.0456-.0882-.0613-.0351-.0173-.0703-.0356-.10773-.0468-.0581-.0197-.11687-.0371-.17517-.056-.0412-.0125-.0814-.0266-.12214-.0403-.0262-.009-.0531-.0158-.0793-.0249-.0126-.004-.0249-.0101-.0374-.0146-.0108-.005-.0214-.0105-.0326-.0148-.009-.003-.019-.005-.0285-.008-.0343-.0104-.0682-.0222-.10145-.0352-.046-.0152-.0927-.027-.14044-.0352-.069-.0112-.13828-.0214-.20646-.0369-.15697-.0457.0663.0202-.0839-.0269-.0499-.0156-.10151-.0251-.15275-.0348-.032-.005-.0617-.0101-.0934-.0171-.0592-.0135-.11618-.0352-.17662-.0434-.10659-.0168-.21406-.028-.31986-.0498-.0565-.008-.0745-.0115-.13217-.0194-.0786-.0108-.15803-.0191-.23528-.0375-.0252-.006-.0498-.0144-.0747-.0215-.0203-.006-.0405-.0121-.0609-.0173-.0854-.0213-.17323-.0317-.25971-.0471-.092-.018-.18224-.0438-.27387-.0635-.0773-.0158-.15555-.0165-.23418-.0159-.0687-.00047-.13709-.001-.20563-.005-.11479-.006-.05-.004-.16589-.0124-.0275-.002-.0551-.003-.0826-.005-.0879-.002-.17569-.005-.26308-.0151-.0279-.003-.0554-.0101-.0834-.0119-.0268-.002-.13703.002-.1607.003-.10844.004-.21705.008-.32559.007-.14069-.001-.10929-.004-.24828-.0126-.0375-.002-.0752-.004-.11271-.006-.0748-.002-.13396-.002-.20847-.008-.0304-.002-.0607-.006-.0911-.008-.0258-.002-.0517-.002-.0775-.005-.0393-.004-.0781-.0128-.1175-.0154-.0137-.001-.0273-.003-.0409-.004-.0108-.001-.0213-.004-.0323-.005-.008-.00069-.0168.00022-.0252.00045-.0249.0002-.05.00024-.0747-.002-.031-.004-.0621-.004-.0932-.004-.0274.00069-.0548.00046-.0822-.00092-.0293.00092-.0587.002-.088.00024-.0415.00006-.0847-.00046-.12256-.0194-.0564-.0303.0151-.16319.0715-.13288z"
          S.path ! A.d "M125.65 692.09c.0101-.002.0198-.005.0299-.007.0391-.006.0791-.004.11848-.003.0557.00092.0261-.00001.0821.002.0699.005.13964.0101.20927.0176.0447.007.0895.003.13438.002.0295-.00069.0546-.00069.0841-.00069.10052.002.20111.002.30167.005.1229.005.2457.0101.3687.0111.0233.00023.0464.001.0697.00092.0289-.00046.0578-.003.0867-.004.0733-.00069.11091.005.18474.006.2133.005.005-.006.22291.008.1876.0167.37296.0505.56002.0717.13631.0164.27134.0405.40788.0551.082.009.16438.0137.24667.0196.0208.002.0417.004.0626.004.0239.00069.0477-.00016.0715-.00022.10475.004.20901.0159.31319.0273.0674.007.13463.0116.20238.0113.0773-.005.15575-.00021.23223.0119.0419.0101.0845.0181.12387.0358.0205.009.0321.0162.0515.0269.0404.0259.0763.0579.11028.0914.0293.0273.0568.0571.0778.0914.0204.0376.0253.0799.0276.12185.004.0347-.002.0696-.008.10369-.0177.0842-.0723.1545-.11459.22762-.0168.0305-.0358.059-.0639.0798-.0557.0326-.1145.0593-.16943.0935-.0274.0162-.0515.0368-.0765.0563-.0678-.0287.00001-.18832.0678-.15959v0c.0259-.0232.0518-.0466.0827-.0631.0509-.0275.10381-.0496.15701-.0718.0252-.0234.0416-.0539.0594-.0829-.0231.0402-.0463.0803-.0693.12052-.003.005.006-.009.008-.014.0107-.0193.0187-.0402.0244-.0615.006-.0336.008-.0676.0115-.10146-.005-.0379-.0142-.0753-.0268-.11148-.004-.009-.0135-.0287-.0193-.0373-.014-.0208-.0372-.0336-.0538-.0521-.0334-.0313-.0701-.0598-.11029-.0819-.0551-.0264-.11314-.0466-.1746-.0509-.0764-.006-.1528-.007-.22906-.014-.0691-.002-.13807-.002-.20713-.004-.0218-.00004-.0658-.00023-.087.00046-.0808.003-.1616.0107-.2425.004-.12514-.0139-.25104-.0197-.37611-.0345-.14044-.0105-.28129-.0155-.42142-.0298-.19158-.0179-.384-.0235-.57564-.0411-.0365-.004-.0731-.009-.10964-.0129-.0341-.005-.0682-.0105-.10237-.0148-.14608-.018-.0369-.00046-.1783-.0176-.14768-.0179-.0123-.007-.14627-.016-.12132-.005-.24245-.0142-.36366-.0217-.0978-.007-.19558-.0141-.29344-.0192-.0301-.00091-.0524-.001-.0824-.003-.0437-.003-.0869-.0105-.13075-.011-.0715-.004-.14305-.003-.21452-.006-.0908-.004.009.00022-.0814-.003-.0366-.001-.0756-.001-.11102-.0123-.008-.002-.0147-.007-.0221-.0101-.0567-.0297.0132-.16335.07-.13367z"
          S.path ! A.d "M126.89 695.7c.099.054.17979.13672.25829.21647.10833.10455.19781.22604.29561.33998.0685.0766.13942.15158.21607.22013.0474.0425.0842.0696.13473.10889.14488.11034.28565.22581.42382.3444.0898.0775.18044.15444.264.2387.0403.0407.0859.0916.12437.13389.0811.0884.15422.18374.23536.27197.0485.0528.0618.0627.11395.10999.13662.11809.29525.12657.46672.14461.11016.008.22031.0244.33104.0186.0585-.003.0661-.007.12262-.0179.12317-.0263.23825-.0778.35336-.12719.0994-.0445.20165-.087.29105-.15041.0167-.0118.0323-.0254.0483-.038.0552-.0485.0293-.0245.0778-.0717.0714.0295.002.19777-.0697.16821v0c-.0522.0533-.0245.027-.0833.0784-.10773.079-.22198.14719-.34755.19441-.11546.0459-.23351.0854-.35327.11855-.067.0148-.13424.0277-.20302.0318-.0901.005-.18079-.00046-.27056-.008-.0325-.004-.0651-.007-.0973-.0127-.13404-.0238-.26161-.0726-.3715-.15372-.0201-.0162-.041-.0316-.0604-.0486-.11029-.0973-.20084-.2143-.29764-.32428-.11987-.13286-.24614-.26004-.38332-.3752-.14119-.11455-.28594-.22456-.4255-.34109-.12372-.10568-.24058-.21883-.34714-.34198-.0992-.11381-.19452-.23057-.28876-.34847-.0811-.0808-.17025-.15551-.23774-.24859-.0556-.0338.0239-.16473.0795-.13101z"
          S.path ! A.d "M126.6 696.16c.0184.0623.0225.12928.027.19486.004.0623.008.12456.0136.18669.004.0596.0108.11868.0171.17791.004.0525.0144.10385.0241.15511.011.069.0244.13728.0401.20483.0143.0485.0274.0988.0505.14231.0108.0204.0295.0476.042.0663.0173.0228.0306.0424.0512.0612.0483.0445.11159.0799.16616.11118.018.009.036.0182.0539.0273.0459.0233.0679.0351.11503.0555.0699.0302.14123.0542.21258.0785.1537.0528.3072.10644.45975.16405.0919.0355.18673.0565.28106.0794.0651.0189.13058.0357.19597.053.0684.0161.13567.0386.20428.0532.0601.0106.11918.0301.17976.0353.0265-.002.014-.00012.0378-.005.0428.0255-.006.14928-.0489.12384v0c-.0268.008-.0128.005-.042.008-.0626.00069-.12515-.008-.1863-.0252-.0681-.018-.13635-.0347-.20411-.0544-.0655-.0179-.13033-.04-.19744-.0477-.0981-.0154-.19624-.0304-.29327-.0547-.15771-.0394-.31479-.0842-.46642-.15153-.12594-.0567-.25316-.1113-.37221-.18806-.0779-.053-.15643-.10668-.21407-.19245-.043-.0658-.0759-.13411-.0945-.21605-.0165-.0694-.0296-.1396-.0375-.21131-.008-.052-.0158-.10386-.0246-.1556-.009-.0592-.0127-.11878-.0172-.17858-.006-.0607-.0106-.12154-.0167-.18223-.004-.0696-.0129-.13829-.0183-.20769-.0373-.0322.0244-.14021.0617-.10808z"
          S.path ! A.d "M126.11 697.71c.0307-.0313.0665-.0568.1006-.084.0271-.0203.0576-.034.0884-.0475.0287-.009.0579-.0181.0873-.0251.026-.006.0527-.007.0792-.007.0261-.001.052.003.0772.0101.0309.008.0596.021.0864.038.0254.0163.0488.0354.0711.0556.0276.0212.0528.0445.0735.0725.0278.0369.0542.0749.0772.11503.0205.0331.0338.0696.048.10549.0176.0353.026.0738.0367.11149.007.0344.0149.0685.0212.10283.006.0278.016.0545.0232.0819.009.044.0104.0891.0162.13364.005.0334.006.0674.0116.10071.007.0426.0124.0856.0217.12769.007.0357.0143.0712.0224.10667.0101.032.0167.0647.0274.0964.012.0279.0283.0535.0411.0812.016.0323.0353.0628.0539.0937.0184.0362.0392.0711.0606.10564.0219.0306.0446.0607.0677.0904.0282.0357.0602.0681.0922.10031.044.0393.0855.0808.12207.12705.0312.0389.0596.0801.089.12034.0226.0295.0441.06.0645.091.0265.0418.055.0823.0835.12273.0312.0395.0592.0814.08.12735.0163.0455.0287.0924.0406.13934.0125.0489.0256.0976.0351.14706.008.033.0162.0657.0202.0994.004.0293.00046.059.005.0882.006.0261.009.0526.0111.0792.003.0369.002.0739.00069.11091-.00045.0245-.001.0489-.001.0734.00069.0193-.004.0382-.007.0572-.002.0121-.00069.006-.002.0179.049.0369-.0381.15223-.0871.11528v0c.002-.0102.002-.005.002-.0165.002-.0187.007-.0368.008-.0555-.00016-.0234-.00069-.0467-.001-.07-.00092-.0364-.002-.0729-.001-.10934.00011-.0273.00023-.0547-.007-.0813-.007-.0283-.007-.0566-.008-.0858-.003-.033-.009-.0646-.0206-.0957-.012-.0478-.0281-.0946-.0376-.14307-.0101-.0465-.0198-.0933-.0382-.13735-.0199-.0457-.0427-.0889-.077-.12579-.0306-.0404-.0596-.0826-.0814-.12857-.0177-.0321-.0409-.0606-.0639-.0889-.0306-.0381-.0621-.0752-.0936-.11255-.037-.0457-.0746-.09-.11844-.12958-.0331-.0333-.0622-.0696-.0903-.107-.0234-.03-.0471-.0597-.0693-.0905-.0223-.0341-.045-.068-.0611-.10546-.0191-.0317-.0365-.0644-.0538-.0971-.0122-.0281-.0261-.0555-.0405-.0825-.0157-.0304-.0211-.0644-.0299-.0973-.008-.0343-.0186-.068-.0255-.1026-.0101-.043-.0185-.0865-.0214-.1305-.003-.0332-.005-.0664-.0122-.0991-.008-.0441-.0106-.0886-.016-.13294-.004-.0296-.006-.0592-.02-.0863-.007-.0332-.0172-.0655-.0228-.0989-.009-.0378-.0197-.0758-.0348-.11153-.0123-.0356-.0286-.0695-.0465-.10253-.0249-.0385-.0539-.0743-.0767-.11419-.018-.0288-.0403-.0544-.0667-.076-.0229-.0185-.0457-.0369-.0712-.0519-.0247-.0174-.0515-.0304-.0809-.0379-.0235-.006-.0477-.0116-.0723-.009-.026.002-.052.004-.0773.0104-.0291.008-.0582.0166-.0862.0283-.0306.013-.0597.0288-.0853.0505-.0332.027-.0645.0563-.0991.0816-.059-.025-.00011-.16384.0589-.13888z"
          S.path ! A.d "M128.06 700.19c.0383.0256.068.0622.10588.0883.0264.0181.0511.0285.08.0425.12849.0559.26599.0857.40185.11742.1588.0383.32078.06.48184.0862.14517.0283.29316.0341.44053.0412.16731.0101.33481.004.50223.002.16548-.001.33092-.005.49638-.002.17719.006.3541.0161.53135.02.21559.006.43123.004.64681-.00092.20432-.004.40803-.0182.61142-.0372.19964-.0171.39962-.0292.59887-.0506.12158-.0122.24401-.0175.36495-.0357.0525-.008.0954-.017.14737-.0273.14413-.0331.29029-.0553.43623-.0785.14044-.0224.28234-.0333.4235-.0499.11737-.0155.23384-.0369.35049-.057.0591-.008.11653-.0229.17342-.0399.0235-.006.0461-.0151.0697-.0212.0583.0275-.006.16474-.0647.13727v0c-.024.009-.048.0173-.0717.0267-.0602.0236-.12278.0393-.18433.0589-.0382.0111-.0666.02-.10593.0286-.0827.018-.1671.0254-.2508.037-.14385.0209-.28647.0505-.43119.0656-.14552.0165-.29093.0356-.43256.0742-.0779.0174-.15581.036-.23445.0494-.0964.0164-.19394.0252-.29115.0351-.067.005-.13427.008-.20134.0139-.1322.0104-.26405.0258-.39643.0343-.20555.0167-.41086.0373-.61702.045-.21437.005-.42868.001-.64286-.0101-.17438-.0109-.34834-.0278-.52294-.0351-.0795-.00046-.1591-.002-.23853.002-.0878.004-.17543.0129-.26345.0113-.16592-.003-.33176-.009-.49766-.0127-.074-.004-.0838-.004-.15729-.0109-.0946-.009-.1877-.0279-.28243-.0351-.16419-.0153-.32811-.0379-.48767-.0806-.13446-.0373-.26986-.0761-.39223-.14497-.0671-.0426-.13433-.0877-.1763-.15704-.0551-.0341.0252-.16384.0802-.12981z"
          S.path ! A.d "M124.76 700.54c-.0993.0101-.19904.007-.29857.009-.18972.004-.0301.003-.22064.003-.0382.001-.0765.002-.11464.003-.206.0101-.0394.006-.24799.0145-.10416.004-.20825.002-.31243.001-.13128-.003-.26223.008-.39271.023-.10887.012-.2174.0272-.32652.0366-.083.006-.16461.0229-.24619.0399-.0733.018-.14773.0291-.22071.0489-.0889.0273-.17616.0601-.26424.0902-.0777.0284-.15667.0516-.23395.0811-.0801.0399-.16482.0639-.25038.0842-.0973.0222-.19232.0538-.28797.083-.0651.0171-.12842.0412-.19272.0614-.0255.006-.0509.0132-.0765.0193-.0557-.0292.007-.17368.0626-.14444v0c.026-.009.052-.0177.0784-.025.0675-.0234.13365-.0505.19974-.078.094-.0346.19021-.0551.28692-.0777.0828-.0227.16589-.0442.24573-.0781.08-.0319.15978-.0641.24029-.0943.0854-.0291.17196-.0531.25893-.0759.0738-.0217.14938-.0344.22379-.0534.0832-.0172.16665-.0331.25046-.0462.10998-.0165.21993-.0327.33033-.0452.13553-.018.27128-.0339.40684-.0514.22692-.0264.45474-.0383.68299-.0334.11086.002.10636.00022.21551.0101.091.008.18528.016.26906.0592.0521.0306-.0135.16579-.0655.13518z"
          S.path ! A.d "M119.94 700.98c.005-.003.0101-.006.0149-.008.0267-.0105.0582-.009.0863-.009.0403-.007.081-.0101.12182-.009.0352.002.0704-.0001.10559.00045.002-.00012.0421-.002.0431-.002.009-.00069.0188-.002.0282-.003.0319-.002.0635-.00023.0954.002.0283.003.0561.0107.0829.0202.009.003.0307.0129.04.0165.006.002.0119.004.018.006.0274.007.0538.0179.0814.0241.006.001.0117.002.0176.003.0215.003.0435.004.0647.009.019.005.0365.0132.0537.0224.0149.009.027.0211.0399.0325.0593.0326-.0176.1722-.0769.1396v0c-.0194.00069-.0386.004-.0581.003-.0196-.001-.0423-.003-.0612-.008-.0197-.006-.038-.0159-.0563-.0247-.005-.002-.0102-.004-.0156-.006-.0271-.009-.0578-.009-.0858-.0133-.007-.00046-.0137-.00092-.0204-.001-.0213-.00047-.0268.001-.0489.001-.0303.00045-.061-.00007-.091-.005-.0279-.007-.056-.0136-.0831-.0232-.007-.003-.014-.006-.0212-.009-.0105-.003-.0257-.006-.0366-.007-.0359-.00069-.0719.00069-.10737.007-.0393.005-.0794.007-.11874.001-.0209.00069-.0597.002-.0766-.0124-.003-.002-.004-.006-.006-.008-.0584-.0297.0117-.16737.0702-.13762z"
          S.path ! A.d "M125.79 701.11c-.0458.0417-.0975.0741-.15243.10203-.0518.0237-.10854.0292-.16464.033-.0669-.002-.13326-.005-.19954-.0135-.0506-.006-.0992-.021-.14778-.0358-.0315-.009-.0595-.0241-.085-.0443-.0242-.0262-.0384-.058-.0481-.0917-.008-.0366-.0143-.0735-.0191-.1107-.002-.0444-.006-.0886-.0108-.13284-.003-.0302-.004-.0605-.006-.0908-.00069-.0179-.00047-.0358-.0002-.0537-.0522-.0379.0372-.161.0894-.12307v0c.00023.0177.00069.0355.00023.0532-.00068.0299-.00068.0599.005.0894.007.0432.0152.0862.0137.13008.001.0384.008.0762.0137.11412.006.0325.023.0593.0409.0867.021.0234.0501.031.0801.0374.0502.0105.10011.0224.15161.024.0649.007.12998.0147.19532.0155.0544-.003.10859-.007.15731-.0339.0513-.0287.0972-.0653.14762-.0954.0596.026-.002.16627-.0613.1403z"
          S.path ! A.d "M125.8 702.33c-.0808-.007-.16025-.0254-.24082-.035-.0804-.008-.16112-.0125-.24185-.0134-.10613.003-.21198.0131-.31777.0224-.11124.0151-.22336.0176-.33507.0257-.0739.004-.14678.0141-.21819.0347-.0488.0192-.0944.0473-.13651.0796-.0112.0106-.0242.0214-.0332.0344-.006.008-.009.018-.0144.0269.021-.0384.0421-.0769.0631-.11531-.0147.0287-.0247.0599-.0294.0921-.002.0295.003.0589.005.0883.002.0266.004.0531.005.0797.00092.029.00069.0144.00069.044.0505.0391-.036.166-.0865.1269v0c-.00002-.0301-.00019-.015.00046-.0457.00092-.0281.003-.0565-.00016-.0845-.004-.029-.009-.0581-.0102-.0875.004-.0331.0101-.0661.0258-.0953.04-.0749.0681-.1535.13113-.20751.0448-.0364.0928-.0688.14638-.0881.0739-.0215.14957-.0356.22571-.0444.11284-.0149.22599-.0302.33967-.0347.10427-.007.20885-.0123.31337-.0101.081.001.16111.0141.24215.0162.0795.008.16253.0143.23372.0561.0533.0312-.0156.16509-.0689.13394z"
          S.path ! A.d "M121.58 696.22c-.0631.0244-.12957.038-.1937.0594-.0452.015-.0703.0256-.11499.0431-.13962.0659-.27093.14731-.40112.2299-.0921.0609-.18694.1173-.28125.1746-.0866.0596-.17423.11713-.25872.17952-.0274.0219-.0544.0445-.0812.0672-.0609-.0255-.00069-.16888.0601-.14339v0c.0291-.0288.0587-.0572.0898-.0838.0835-.0673.16889-.13311.26311-.18486.0985-.061.1944-.12563.28875-.19285.1273-.0846.25618-.16907.40142-.21997.0954-.0329.19375-.0686.29589-.0664.0585.0289-.0101.16658-.0681.13769z"
          S.path ! A.d "M118.04 696.61c-.0699.0716-.13555.14706-.20024.22333-.0667.0831-.13789.1625-.20119.24827-.011.0173-.14198.22389.0455-.0813.006-.0101-.0107.0208-.0157.0315-.0129.0277-.022.0556-.03.0849-.009.0414-.0124.0838-.014.12592-.002.0433.005.0863.0102.12915.0104.0665.016.13329.0202.20032.007.0691.0121.1382.0151.2075.002.0499-.00091.0996-.00091.14938-.00024.0328-.00092.0654-.001.0982-.00023.0176-.00013.009-.00045.026.0509.0369-.0362.1567-.0871.11977v0c-.00023-.0163-.00016-.008-.00047-.0249-.00045-.0315-.00091-.0629-.001-.0944-.00017-.0463-.004-.0925-.006-.13879-.003-.0694-.009-.13832-.0149-.20741-.003-.0677-.0104-.13493-.0183-.20215-.002-.0468-.005-.0934-.004-.14024-.00092-.0403-.001-.0809.006-.1208.0241-.12089.0954-.22426.16241-.32617.0664-.0901.13615-.17788.2088-.26304.0587-.0643.11626-.13122.18601-.18396.059.0248.00069.16363-.0583.1389z"
          S.path ! A.d "M114.52 700.27c.0592.0748.0902.16728.11564.25805.0212.0835.027.16965.0261.25552-.003.0824-.0303.16006-.0572.23706-.0528.14714-.12964.28701-.23168.40578-.0417.0475-.099.0735-.15303.1037-.0499.0303-.0986.0623-.15321.0833-.0325.0163-.0675.0234-.10336.0267-.0501.003-.0989.0149-.14735.0272-.0612-.0291.007-.1732.0687-.14407v0c.0481-.014.0968-.0212.14703-.0206.0361-.004.0689-.0117.0999-.0317.0526-.0286.10205-.0627.15518-.0904.057-.0312.11286-.0619.15148-.1165.0441-.0563.11556-.17306-.005.0369-.008.014.015-.0284.0218-.043.017-.0362.0246-.058.0389-.0954.0303-.078.0625-.15687.0679-.24138.002-.0825-.007-.16565-.0265-.2459-.0143-.0474-.0311-.0931-.0494-.13917-.0125-.0317-.027-.0626-.0383-.0947-.005-.0138-.008-.0283-.0125-.0425-.0548-.0362.0306-.16531.0854-.12909z"
          S.path ! A.d "M122.56 689.4c.0652-.005.13037-.007.19542-.0139.088-.009.17634-.0123.26471-.0123.0841.00045.16826-.003.25215-.0101.22456-.0173.44973-.005.67384.0123.29071.0151.57999.0493.86845.0875.19708.0256.3952.0414.59257.0643.19855.0214.39569.0542.5925.0878.2197.0406.43924.082.659.12235.13953.0285.28099.0452.42164.0666.0915.014.14161.0236.23234.0398.10635.0169.21252.035.31849.0542.0255.005.14958.0282.17687.0326.0329.005.066.009.099.0141.17682.029.35123.071.52469.11541.13226.0312.26084.0752.38564.12869.0732.0322.14376.0697.21377.10811.0645.0319.12702.0672.18517.10946.0324.0254.0605.0555.0871.0868.0219.0268.0412.0556.0623.083.0223.0309.0485.0586.0744.0864.028.0312.0559.0624.0867.0909.0369.0338.0738.0675.11216.0995.0402.0302.076.0655.11039.10198.0158.0166.028.0362.037.0572.003.007.006.0131.009.0197.026.0171-.0145.0784-.0404.0612-.003-.007-.005-.0136-.009-.0199-.008-.0194-.0225-.0359-.0383-.0496-.0377-.0324-.0737-.0666-.11209-.0981-.0388-.0322-.0755-.0666-.11109-.10236-.0301-.0294-.0596-.0596-.0872-.0915-.0245-.0295-.0518-.0566-.0743-.0878-.0198-.0283-.0395-.0568-.0613-.0836-.0257-.0305-.0558-.0571-.0887-.0796-.0613-.0369-.12496-.0694-.1871-.10473-.031-.0175-.062-.0363-.0948-.0505-.0405-.0175-.0832-.0297-.12434-.0455-.12817-.0446-.25626-.0903-.38921-.11888-.1767-.0357-.35391-.0686-.53097-.1023-.032-.007-.0637-.0141-.0958-.0198-.029-.005-.0583-.009-.0876-.013-.13861-.0199-.27801-.0343-.41598-.0586-.21703-.0354-.43281-.0776-.6495-.11482-.2217-.0345-.44396-.0664-.66313-.1151-.19376-.0404-.3876-.0833-.58533-.0991-.20015-.0189-.40036-.0378-.60123-.0474-.29094-.0187-.58161-.0428-.87047-.0832-.0649-.006-.18878-.0184-.25466-.0236-.13299-.0104-.26632-.0158-.39941-.0248-.0811-.007-.16261-.0109-.24393-.006-.0891.006-.17813.0135-.26734.0182-.0621.001-.12454.002-.18636-.005-.0286-.0146.006-.0819.0343-.0674z"
          S.path ! A.d "M129.55 693.22c-.007.004-.0148.008-.0225.0115-.0529.0229-.1119.0336-.16838.0433-.0561.0107-.11326.007-.16997.009-.045.003-.0897-.003-.13446-.005-.0205-.00092-.0411-.00092-.0616-.001-.007-.00012-.0151-.00092-.0226-.00046-.085.004.0223.003-.0652.003-.0577-.002-.11518-.009-.17296-.0107-.0647-.002-.12927-.005-.19391-.008-.1037-.0001-.20753.004-.31089.0123-.0226.002-.0451.003-.0677.005-.0246.002-.0491.004-.0737.005-.0823.004-.1646.002-.24688-.002-.051-.002-.10188-.006-.15289-.006-.0234.00021-.0466.001-.0699.002-.0641.001-.12821.00045-.19227.003-.0776.0111-.15468.0185-.23284.0232-.0441.002-.0883.005-.13197.011-.02.003-.0369.007-.0567.0106-.0516.0115-.10114.0303-.15062.0486-.0356.0118-.0696.0276-.1033.0437-.0291.0159-.0581.0323-.0876.0475-.0194.0108-.04.0196-.0589.0316-.005.003-.0157.0112-.0202.0147-.0173.0137-.0323.0299-.0452.0476-.0105.0173-.0215.0343-.0333.0508-.0115.0146-.0247.0276-.0365.0419-.007.0101-.016.0182-.0253.0261-.006.005-.0108.0118-.017.0169-.00069.00069-.001.002-.002.002-.0285-.0116-.001-.079.0275-.0673.00091-.00092.002-.002.002-.002.006-.007.0119-.0127.0181-.0188.009-.009.0174-.0194.0255-.0297.0122-.0149.0254-.0291.0369-.0447.0113-.0166.022-.0336.0334-.0502.0144-.0185.0298-.036.0487-.0501.0256-.0202.0529-.0379.083-.0509.0296-.0146.0585-.0304.0873-.0465.0358-.0182.0711-.0377.1084-.0528.0504-.0201.10124-.0393.15399-.0521.0642-.0149.12909-.0257.19484-.0311.0762-.009.1527-.0156.22944-.0151.0648-.002.12969-.004.19452-.007.0351-.001.0703-.001.10543-.003.0346-.002.044-.003.0794-.007.0159-.002.0318-.003.0477-.005.0618-.007.12359-.014.18575-.0171.0729-.004.0702-.002.14263-.002.0219.00003.0437-.00022.0655-.00023.0566.001.11331.002.16982.006.0163.001.0715.007.0893.008.0125.001.0252.002.0377.004.0631.006.12623.0118.18946.0163.0587.004.11686.003.17556.006.0868.008-.0193-.003.0596.008.0274.004.0553.003.0829.004.0213.00069.0426.00014.0639.00045.0197.00023.0283.001.048.001.008.00001.0159-.00024.0239-.00046.008-.00023.0158-.00023.0236-.00092.0512-.004.10126-.0175.15222-.0231.0238-.004.0476-.008.0713-.0117.0312-.005.0326-.007.0629-.0109.008-.001.0163-.002.0246-.003.006-.00019.0111.00092.0166.001.0303.0147-.004.0861-.0345.0715z"
          S.path ! A.d "M135.94 691.99c-.0384.008-.0777.0111-.11577.0205-.0283.007-.0327.0101-.0597.0202-.0371.0162-.0696.0408-.092.0748-.006.009-.0231.0371-.016.0287.0118-.014.0202-.0304.0303-.0457-.0167.0491-.0359.10112-.035.15388.00018.0109.002.0216.003.0325.018.0935.0525.18286.0848.27211.0371.10884.094.2093.14922.30962.0607.10716.12701.21089.19402.31417.0791.10647.15693.21384.23423.32159.062.0861.12635.17027.18533.2584.042.0642.0835.12879.12537.19312.0404.0593.0868.11411.13401.16792.054.0615.0978.13072.13817.20158.0406.0778.0778.15705.11415.23679.0468.10329.0811.2113.10769.32136.0152.0592.0245.11946.0365.17922.009.045.0165.0902.0261.13499.0292.0202-.0183.0891-.0475.0689v0c-.0124-.0443-.021-.0895-.0263-.1353-.0118-.0567-.0246-.11317-.0436-.168-.0329-.10699-.0708-.21218-.10871-.31747-.0329-.0823-.067-.16411-.10948-.24202-.0125-.0232-.0254-.0476-.0394-.0699-.029-.0459-.0642-.0875-.0978-.13005-.0446-.0572-.0905-.11353-.13165-.17337-.0429-.0621-.0861-.12376-.13077-.18447-.0606-.086-.12357-.17016-.18816-.25319-.0814-.10476-.16455-.20849-.23554-.32076-.0678-.1033-.13492-.20711-.19392-.31577-.0558-.10101-.1112-.20287-.14963-.31208-.0324-.0929-.0644-.18687-.079-.28449-.001-.0117-.003-.0234-.003-.0352-.001-.0527.015-.10506.0316-.15431.05-.0941.0711-.1639.16999-.2076.055-.0205.1137-.0351.17283-.0285.0287.0147-.006.0824-.0345.0678z"
          S.path ! A.d "M131.25 694.02c-.11652.0176-.23324.033-.34933.0535-.17198.0291-.33929.0786-.50473.13285-.10786.0346-.21554.0699-.32547.0974-.0598.015-.0948.0221-.15471.035-.14984.0301-.29813.0673-.44735.10011-.12631.0257-.25316.0485-.37962.0735-.0755.0169-.15035.0369-.22296.0639-.0589.0218-.10988.06-.16209.0942-.0519.0328-.10211.0682-.1519.10401-.0507.0385-.1038.0736-.1566.10904-.0345.0251-.0727.0439-.11022.0638-.0322.0194-.0661.0344-.10072.0486-.0264.0114-.0538.02-.081.0293-.0302.007-.0593.0175-.0878.0296-.0227.0125-.0459.0247-.0675.0391-.0146.007-.0255.0201-.04.0278-.0101.006-.0191.0143-.0291.0205-.0129.0115-.0275.0208-.0419.0305-.007.004-.004.002-.0109.006-.028-.0125.002-.0786.0295-.066.007-.004.003-.002.0107-.007.0139-.0101.027-.0201.0413-.0292.0101-.007.0196-.0148.0299-.0214.014-.009.026-.0215.0406-.0301.0223-.0149.0456-.0288.0698-.0406.0291-.0119.0586-.0228.0891-.0306.0276-.008.0545-.0159.0801-.0293.0344-.0154.0681-.0319.10071-.0504.0385-.0207.0766-.0421.11138-.0689.0524-.0375.10541-.0741.15768-.11177.0501-.0355.10122-.0695.15212-.10373.052-.0348.1043-.0702.16324-.0922.0745-.031.15107-.0571.22988-.0752.12846-.032.25707-.0629.38695-.0886.14927-.0325.29817-.0665.44719-.0999.16266-.0383.32407-.0823.48166-.13825.16455-.055.33175-.10193.5039-.1265.11012-.0146.22244-.0289.33354-.0185.0295.0151-.006.0848-.0355.0697z"
          S.path ! A.d "M132.27 695.21c-.1163.007-.2311.025-.34511.0482-.16207.0381-.32695.0601-.49188.0812-.15971.0342-.31968.0673-.47943.10132-.0609.0123-.12088.0277-.1767.0555-.0258.0128-.0509.0284-.0757.0431-.0623.0399-.12092.0861-.17283.13884-.0399.0409-.0748.0859-.10929.13118-.0358.0518-.0705.10416-.10547.15638-.0455.067-.10365.12381-.16332.17805-.0603.0513-.12512.0969-.18835.14437-.0416.0303-.0791.0652-.11591.10112-.0168.0202-.0363.0381-.0534.058-.005.004-.009.009-.0135.0131-.0282-.0117-.00069-.0784.0277-.0666.005-.005.009-.0101.0137-.0151.0189-.0219.0377-.044.057-.0654.0377-.0379.0772-.0738.11943-.10672.0633-.0509.12898-.0986.19066-.15146.059-.0517.11415-.10765.15861-.17255.0347-.0512.0689-.10276.10472-.15311.0354-.0462.0718-.0915.11164-.13402.0537-.054.11357-.10138.17728-.14312.0307-.018.0446-.027.0766-.0426.0592-.0287.12226-.0481.18463-.0683.15784-.0458.3185-.0822.48164-.10324.0769-.0124.15386-.0246.23042-.0388.0795-.0148.0953-.02.17586-.0341.0293-.005.0589-.009.0883-.0141.0692-.008.13806-.0173.20771-.0193.0331-.00092.0601-.001.0925.004.009.001.0187.004.028.006.0289.0151-.007.0832-.0355.0682z"
          S.path ! A.d "M132.59 696.14c-.009.0101-.0184.0204-.028.0302-.0221.0225-.0557.0534-.0781.0747-.0406.0388-.08.0789-.11926.11896-.0566.0621-.11783.11981-.17346.18287-.0672.0822-.1297.16775-.18436.25874.009-.0153.0157-.0331.0283-.0458.008-.009-.0105.0218-.0156.0329-.004.0101-.009.0198-.0131.0297-.0116.0272-.0217.055-.0318.0828-.0149.0434-.0283.0873-.0408.13144-.0119.0401-.0235.0803-.0344.12061-.0174.0717-.0398.14208-.0616.21257-.008.0312-.0202.061-.0336.0902-.009.0178-.012.0374-.0156.0568.025.0189-.0195.0778-.0445.0589.004-.0188.004-.0383.0127-.056.0117-.0268.0247-.0533.0291-.0825.0179-.071.0382-.14127.0603-.21104.0136-.042.0262-.0842.0391-.12639.0108-.0424.0222-.0847.0358-.12622.0319-.0897.0667-.17723.11988-.25736.0544-.0917.11557-.17927.18659-.25905.0591-.0617.11924-.12241.17539-.18688.0681-.0714.13843-.14082.21631-.20168.0303.0125.00069.084-.0296.0715z"
          S.path ! A.d "M119.59 702.38c.0274.011.0512.0298.0796.0386.006.002.012.003.018.004.0492.004.0986.003.14786.004.0528.00091.10552.002.15822.005.0322.002.0645.002.0967.003.0453.001.0895-.009.1339-.0159.0478-.009.0961-.0155.14344-.0264.0338-.0101.0663-.023.0982-.0376.0293-.0126.0564-.0296.0834-.0464.0193-.0101.0375-.0216.0561-.0329.011-.008.0224-.0157.035-.0212.007-.002.0157-.005.0204-.0118.00047-.001.00092-.002.001-.004.0285.011.002.0783-.0261.0673v0l-.003.003c-.007.005-.0151.008-.023.0122-.0121.007-.0236.0158-.0353.0239-.0191.0136-.0388.0263-.0588.0385-.0273.0173-.0549.0339-.0848.0466-.0332.0153-.0666.0303-.10151.041-.0487.0132-.0984.0214-.14743.0327-.0101.001-.0196.003-.0295.004-.0332.003-.0661-.001-.0994-.001-.0333.001-.0666.001-.0999.003-.0537.002-.10744.002-.16115-.00019-.0486-.003-.0975-.005-.14558-.0123-.0357-.009-.0704-.0248-.0958-.0522-.0278-.0164.0109-.0819.0387-.0655z"
          S.path ! A.d "M120.66 702.28c.006.002.0124.004.0185.007.0309.014.0596.0325.0895.0481.0384.02.0366.0186.0767.0366.0776.0353.1597.0585.24084.0837.11841.0362.24033.058.36094.0853.10756.0253.21545.049.32343.0723.0151.003.0301.006.0453.008.0633.009.12775.0111.19155.0142.21963.0105-.0497-.003.18567.009.17214.0101.34364.0267.51477.0474.0487.005.073.008.12297.008.0299.00003.0598-.002.0897-.003.10776-.00092.21542.004.32301.009.11817.004.23587.0178.35402.022.0501.002.0654.00069.11365-.00069.075-.004.14918-.0148.22375-.0225.0155-.004.0574.00046.0703-.0101.002-.002.006-.0102.005-.008-.0115.0191-.0232.0382-.0348.0572-.0257-.0202.0221-.0809.0478-.0606v0c-.0141.0251-.0272.0508-.0423.0753-.0123.0202-.0685.0262-.0884.0317-.0776.0141-.15592.023-.23297.0399-.0532.008-.0664.0106-.12218.0153-.12264.0101-.24586.009-.36875.005-.0997-.005-.11764-.005-.21649-.0153-.0325-.003-.0649-.007-.0973-.0123-.0272-.004-.0541-.0101-.0813-.014-.0553-.008-.0678-.007-.12263-.009-.0768.00069-.1536.003-.23039.00023-.0768-.002-.12145-.005-.19836-.0127-.0331-.003-.0662-.007-.0992-.0107-.0888-.0117-.092-.0112-.17723-.0259-.0607-.0104-.12052-.0242-.1809-.036-.0151-.003-.0302-.005-.0453-.008-.11136-.0171-.22308-.0323-.33364-.0541-.058-.0125-.0799-.0162-.13685-.0328-.0725-.0211-.14374-.047-.21518-.0715-.0803-.0287-.16185-.0541-.24095-.0861-.0625-.0305-.12571-.0654-.17115-.11929-.0276-.0165.0113-.0815.0389-.065z"
          S.path ! A.d "M120.71 699.19c.0428-.0466.0927-.0859.14488-.12121.0563-.0377.11602-.0696.17744-.098.0545-.0218.10784-.0461.16109-.0707.0452-.0192.0869-.0454.13089-.0671.029-.0152.0602-.0262.0918-.0346.0369-.007.0734-.0175.10934-.0288.0157-.006.0321-.009.0477-.0143.002-.00047.004-.001.006-.002.0556.0261-.006.15715-.0616.13105v0c-.002.00069-.003.001-.005.002-.0178.008-.0356.016-.0529.0248-.0356.0158-.0724.0259-.1114.0286-.0328.007-.0616.0251-.0904.0418-.0436.0273-.0883.0529-.13532.0739-.0539.0257-.10736.0523-.16273.0747-.0608.0304-.11817.0667-.17624.10194-.0448.0311-.0868.0657-.13173.0962-.059-.0248-.00069-.16359.0584-.13885z"
          S.path ! A.d "M118.29 698.43c.0487.0421.0961.0855.14965.12118.071.0416.13847.0883.20351.13855.0571.0453.12016.0817.18743.1095.10171.0316.20572.0549.31028.0747.13116.0168.2628.0297.3943.0434.0983.0101.19605.0242.29476.0293.0688.00068.13747.003.2062.003.0423-.00023.0848-.002.12692.00092.0537.007.10782.0102.16187.0128.0584.00067.11667.002.17494.005.0189-.00045.039.006.0576.00047.028.0132-.003.0794-.0313.0661v0c-.0205.006-.0423.004-.0635.006-.0593.003-.11857.004-.17779-.00069-.0533-.003-.10626-.009-.15866-.0191-.0425-.002-.0852.001-.12763.002-.071.005-.14197.0124-.21321.008-.0998-.007-.19948-.0153-.29935-.0209-.13198-.008-.26383-.0208-.39359-.047-.1044-.0195-.2092-.043-.30706-.0852-.0667-.0303-.13007-.0673-.18919-.11076-.0665-.0481-.13505-.0931-.20309-.13892-.052-.0405-.10848-.0789-.14444-.13528-.0275-.0176.014-.0823.0414-.0648z"
          S.path ! A.d "M115.65 698.04c.0797-.0635.16985-.11232.25998-.15913.0944-.0532.19396-.0954.2946-.13485.079-.0278.15807-.0562.23851-.0798.0724-.02.14763-.0246.22231-.0283.095-.004.18991-.006.28477.00091.0789.005.15679.0184.23375.0359.0548.013.10817.0321.16031.0533.007.003.0136.006.0205.009.0304.0171-.0101.0889-.0403.0719v0c-.007-.003-.0138-.005-.0206-.008-.0532-.0185-.10729-.0346-.16219-.0471-.0781-.016-.15734-.0222-.23685-.027-.0938-.005-.18763-.006-.28149-.005-.0743.002-.1487.006-.21999.0291-.0808.0256-.16091.0535-.23974.0844-.10101.0431-.20072.0892-.29694.14221-.0831.0432-.16545.0878-.24723.13335-.0298-.0129.00069-.0832.0306-.0703z"
          S.path ! A.d "M112.93 699.92c.0468.0343.0923.0702.13918.10446.0523.0302.10259.0636.1534.0963.029.0214.0596.0395.0933.0523.0106.004.0195.0101.0284.0166.0272.0161-.0106.0803-.0379.0642v0c-.009-.006-.0176-.0106-.0279-.0132-.0346-.0116-.0679-.0266-.0986-.0463-.0521-.0308-.10461-.0611-.15422-.0958-.0495-.0323-.0998-.0659-.13531-.11398-.0274-.0169.0123-.0814.0397-.0646z"
          S.path ! A.d "M112.47 700.66c-.0453.0405-.0924.0788-.13987.11663-.0677.053-.13693.10352-.20062.16124-.0349.0359-.0682.0744-.0954.11654-.006.0101-.0245.0403-.0178.0306.0102-.0151.0191-.031.0286-.0464-.0172.0388-.0343.0796-.0386.12231-.003.026-.00001.0387.003.0648.0107.061.0342.11985.0752.16699.008.0101.0184.0184.0276.0276.044.0344.0954.0591.15013.0705.0366.008.063.008.10061.0116.12208.004.24377-.009.36543-.0172.1247-.006.24947-.0109.37423-.0158.0655-.003.0347-.001.0925-.005.0361.0178-.006.1028-.0419.0851v0c-.0621.0121-.0291.007-.0989.016-.0212.002-.0425.004-.0638.005-.10324.005-.20696-.00069-.30996.0105-.1212.009-.24315.0219-.36463.0115-.0922-.013-.1789-.0308-.25235-.0924-.009-.009-.0198-.0182-.0286-.0284-.0425-.0486-.0663-.10962-.0776-.17252-.002-.0248-.005-.0426-.003-.0676.003-.0427.0194-.0832.0353-.12237.001-.002.0576-.10712.079-.13923.0283-.0425.0619-.0819.098-.11783.0626-.0582.13158-.10806.20033-.15864.0449-.0341.088-.0708.13425-.10309.0297.0128-.00046.0829-.0302.0701z"
          S.path ! A.d "M113.37 704.37c.0489.0469.0807.10834.11281.16721.0362.0699.0591.14291.0657.22119-.001.05-.0199.097-.0446.13986-.0662.11505-.0478.0875-.0975.15513-.0453.058-.0899.11768-.14522.1667-.0116.0103-.0242.0196-.0363.0294-.0956.0715-.20973.10866-.32129.14678-.0885.0293-.17874.0532-.26915.0758-.0528.0145-.10642.0251-.16003.0358-.031.008-.0627.012-.094.0186-.0308-.0148.004-.0874.0347-.0726v0c.0317-.009.064-.0168.0966-.0228.0549-.0101.10902-.022.16167-.0408.0935-.0273.18468-.0612.27665-.0931.1079-.0365.22055-.067.3128-.13681.0117-.009.0239-.0187.0351-.0288.0549-.0493.0986-.10959.14374-.16738.009-.012.0203-.05.0259-.0362.006.0153-.0168.0285-.0228.0439-.005.0133.014-.0247.0203-.0375.016-.0327.0307-.0669.0319-.10377-.00092-.0106-.001-.0212-.003-.0318-.0101-.0642-.0372-.12489-.0619-.18435-.0325-.061-.0666-.12085-.10339-.17928-.0277-.0175.0134-.0827.0412-.0652z"
          S.g
            ! A.strokeWidth "0.3"
            $ do
              S.path ! A.d "M117.69 701.76c-1.2445.00069-2.5083.007-3.7844.017-.29348.10111-.57749.13442-.7736.0814-.35308-.0954-.70589-.0741-.93692.0134 6.5818 2.0575 14.112 4.4078 14.202 4.4331.1382.0387.38692.51555.35347.59059-.0335.0751-.66012.12386-.71946.0998-.20497-.0748-5.6079-1.689-11.064-3.3154.73966 1.2749.10528 2.0821-.24563 2.3687-.35162.28717-1.2882.15076-1.8403.15168-.552.00091-.55352.1698-.79776.29351-.39073.19791-.77806.31278-.95213.13468.10192-.26096.2614-1.2696.93646-1.4318.39858-.0317 1.1352-.22579 1.1521-.59866.0169-.37287-1.3462-.32402-2.413-.72618-.90252-.34025-1.0814-.94542-.98569-1.7244-.41962-.12492-.65007-.19398-1.0251-.30559-1.4888.0219-4.0682.0464-6.0425.0756a26.669 26.669 0 0 0 18.55 7.6 26.669 26.669 0 0 0 18.095-7.1441c-3.5568-.24554-8.3051-.40726-12.044-.50157.12669.16018-.0242.45891-.19061.47115-.21167.0156-.58489-.0366-.74631-.0148s-.23526.31962.0349.34273c.7321.0626 1.0991.0827 1.0702.44474-.008.27037-.28949.41283-.76778.46444-1.2426.11781-2.2429-.17541-2.5418-.65369-.34873.31969-3.3443-.12935-4.0935-.16465-.7492-.0353-.88099-.4409-.8895-.80941-.001-.0639.009-.12598.0179-.18837-.51901-.001-1.0337-.004-1.5584-.004z"
              S.path ! A.d "M135.48 683.65c-.2835.006-.50992.0686-.76824.24743-.49702.34414-2.8329 3.4293-3.0166 3.672.10955.0604.21206.10949.29396.12886.49859.11786 1.3563.29391 1.5624.32393.0403.006.0726.0347.0989.072.0503-.24723.16121-.50186.41254-.68367.35942-.21928.51478-.33866.3029-.59464-.21187-.25597-.56552-.88893-.2331-1.4514.3324-.56253.61305-1.0424 1.2054-1.2009.59231-.15849 1.5764-.27908 1.2519-.42864-.48627-.0424-.82658-.0915-1.1101-.0851zm4.2953 1.5839c-.24654.0253-.59801.20563-.71455.40851-.51144.2258-1.1039.58078-.90513.86891.19874.28812.78796.92073.86084 1.9463-.46294-.001-.80861.00005-1.179-.70067-.38399-.4079-.89059-.73854-1.5342-.72841-.19637.0444-.38484.20895-.11587.36241.13545.065.34273.21285.44428.25996-.11398.24642-.26446.70658-.19954.8273.0649.12071 1.1567.51587 1.6479 1.2886.49916.79766.31952 1.6409.25549 1.9311-.5648-.84271-1.3518-1.6085-1.9588-1.8559-.60701-.24744-1.9488-.20687-2.2407-.0711-.027-.51583-.49522-.87854-.52035-1.2103-.001-.0164.00092-.0374 0-.0546-.0603.0681-.15134.12116-.28948.13423-.49584.0469-1.565-.0707-1.7906-.0899-.2256-.0192-.87254-.53771-1.149-.68143-.27647-.14373-1.776-.42704-2.1736-.37047-.31457.0375-.46253-.03-.51857-.19777-.0974.29943-.21183.64892-.28322.80359-1.408-.3392-4.0698-.67482-4.3481-.70336-.69263-.0481-2.0889.0265-2.3629.10247-.27394.076-.46091.54843.11007.49798.57099-.0505 1.5306-.11356 1.7338.50201.0227.44975.0591.81957-.19419.97719-.25323.15762-.6524.38076-.60984.52484.0426.14405.22833.24244.89127.19238.66295-.0501 1.674-.0374 1.813.57226.13026.45743.13935.95502-.0801 1.1154-.21943.16043-.1923.4176.11454.35302.30684-.0646.99054-.13741 1.3423-.008.35174.12937 1.1276 1.0812.49934 1.515-.39924.23414-.37236.6899.0242.46667.39652-.22325 1.0302-.37179 1.357-.0792.32683.2926.30753 1.0768-.15212 1.1862-.22973-.0287-.68155-.0474-1.2004-.0609.0267.0487.0552.0977.0725.14498 0 0-2.8106-.0644-3.0868-.0729.001-.0213-.002-.0416-.001-.0627-.26982.008-.55525.0131-.79373.0251-1.6594.0833-3.7664.44549-4.421 1.1754-1.1162-.0937-2.6128-.13635-3.609.32349.50053.54091.94457 1.0513 1.0698 1.3199.0657.10172.18473.23177.33826.38076.22693-.28086.66723-.65976 1.7351-.28367.52287.62684 1.8003 1.3743 3.004 1.0837-.61594.65357-1.0672 1.4302-.75391 1.7521-.42976.15265-.6004.41811-.64698.70961.005.005.0114.0101.0166.0152-.006-.00001-.0119.00002-.0179 0-.009.0624-.0193.12448-.0179.18838.008.3685.1403.77409.88948.8094.74919.0353 3.7448.48435 4.0935.16465.29896.47828 1.2993.77149 2.5418.6537.47829-.0517.75931-.19407.76779-.46445.0288-.362-.33816-.38213-1.0702-.44474-.27016-.0231-.19633-.32084-.0349-.34273.16142-.0218.53465.0303.74632.0148.21167-.0156.40531-.49805.0242-.5642-.38116-.0661-.90332-.0598-.90918-.30918-.0337-.14826.0792-.42618.31723-.46354.23801-.0373.72564-.14037.78837-.31051.78225.38068 1.0407.68873 2.1293.70291 1.0886.0142 3.4218.0469 3.6694-.0851.24753-.13196.54919-.22793.76375-.2009.21457.027 1.1258-.38119 1.238-.70872.11738.4739.25461.43904.62164.30002.36703-.13903 1.3874-.69186 1.65-1.0481.0235.27542.3204 1.0093.99687.6962-.0525.30513.34384 1.0355.96241 1.0425.4012.005 1.8261-1.4636 1.924-1.8327.0717-.31139-.00069-.59222-.009-.72975-.009-.13752-.50333-.18165-.58569-.18166-.0321-.27895.0676-.83885-.12617-1.1369.35549-.43676 1.2026-1.2473 1.5248-1.6488.32228-.40142.55747-1.028.88636-1.2926.32889-.2646.67726-.54844.8962-.45369.21894.0948.44046.18261.45056.24608.13137-.15097.29211-.55765-.12842-.76109-.30049-.0482-.61969-.0919-.77986-.0627.004-.32866-.44729-.72508-.86936-.54586-.42206.17923-1.5934 1.4966-1.7029 1.613-.092.23222-.19541.25553-.20044.54542-.23777.30006-1.761 1.6381-2.8448 1.6344.0935-.50546-.23333-1.1405-.47069-1.3271.0993-.26004.18085-.62832-.0291-.89888-.20994-.27056-.87887-1.8015-1.4031-2.3101.59651.0719 1.0691.95978 1.6828 1.3069.61367.34718 1.9516.68826 2.715.19195.7634-.4963 1.4358-1.5093 1.9172-1.5705.48141-.0612.87874-.0477 1.694.35122.86353.36051 1.0327.0918 1.1034-.0587.0707-.1504.43909-.16254.5141-.17271.0751-.0102.15684-.38436.009-.56375-.14792-.17941-.9654-.49315-1.5459-.9065-.58048-.41335-1.3508-1.1105-1.6542-1.8412.24034-.36846.40304-.74846.27965-.95034-.001-.002-.005-.004-.006-.007-.15574-.0439-.30508-.0877-.39552-.13378.006-.0189.0178-.0651.0277-.10246-.22134-.071-.46269-.0512-.5132.23669-.23444-.24533-.43007-.58809-.51543-.62327.2059-.20702.19344-.53038.081-.59418-.11248-.0638-.37625-.14563-.46085-.0627.0271-.23168-.21014-.55678-.38928-.51768-.0668-.2358-.33813-.85004-.52303-.97406-.0462-.0311-.11693-.0398-.1991-.0313zm-26.63 12.972c-.23327.47611-.35785 1.048-.23535 1.7172-.88528.0143-2.3253.17006-2.8492 1.2832.7972.24947 1.2333.38664 2.1405.67023.23103-.0875.58384-.10882.93692-.0135.6033.16299 2.026-.41411 2.0613-1.664-.10001-.0424-.21719-.0646-.35436-.0493-.51036.0573-.96933-.53402-1.1235-1.0219-.05-.15819-.28902-.51791-.57628-.92214zm-3.3181 3.9459c-.0954.77904.0832 1.3844.98614 1.7248 1.0667.40216 2.4299.35332 2.413.72618-.0169.37287-.75355.567-1.1521.59866-.67506.16221-.83454 1.1708-.93646 1.4318.17407.1781.5614.0632.95213-.13467.24424-.12372.24576-.2926.79776-.29352.55202-.00092 1.4886.1355 1.8403-.15168.35091-.28658.98529-1.0938.24563-2.3687-2.5275-.7535-3.0866-.91968-5.1463-1.5329z"
              S.path ! A.d "M103.95 699.29c1.908.61113 22.318 6.9787 22.456 7.0174.13821.0387.38682.51556.35336.5906-.0335.075-.66019.12387-.71953.0998-.42096-.15372-22.623-6.7578-22.623-6.7578-.38761-.13113-.132-1.1441.53355-.94995z"
          S.path ! A.d "M125.06 665.2c-.0867.001-.17317.005-.2595.012-.0577-.0294-.12714.10658-.0694.13602.16965.015.34044.0143.51052.009.11225-.0121.22208.009.33245.0255.10466.0286.10445.0453.11901.14675.009.14.0329.27794.0609.41521.0182.087.022.17552.0251.26399.00068.0695.002.13905.003.2085.00007.0308.004.0615-.002.0917-.005.0232-.006.0467-.007.0703-.00069.0476-.002.0951-.004.14273.001.0759-.004.15221.004.22774.0244.10962.0644.21436.11454.31455.0706.13879.16776.26121.27114.37673.10259.11519.20853.22743.31812.33602.1059.099.20115.20857.29262.3208.0952.13166.19223.26178.29351.38882.0976.11924.19767.23601.31231.33915.16621.13715.3582.23875.55481.32484.0674.038.15724-.12083.0899-.15884-.19208-.0913-.3812-.19133-.55614-.31276-.0443-.0377-.0717-.0588-.11096-.10112-.0704-.0761-.1291-.1623-.19554-.24161-.1008-.12558-.20398-.24954-.29976-.37897-.0904-.11465-.18455-.22717-.29128-.32707-.10849-.10877-.21635-.2177-.31857-.33243-.1003-.11669-.19312-.23971-.26757-.37495-.0497-.0944-.0961-.19279-.11857-.29754-.006-.0758-.00022-.1522-.003-.2282-.001-.0446-.004-.0892-.002-.13377.00091-.023.003-.0455.008-.0681.00091-.005.00091-.011.001-.0166.0126.0862.033.1716.0524.25638.0265.11759.0587.23267.10918.34228.0471.10421.11112.19707.18613.28277.10815.11913.23289.16828.38299.21343.18014.0416.36442.0632.54855.0774.14808.009.29647.007.44475.009.13202.002.26355.00007.39462-.0166.12201-.02.24263-.0494.36153-.0832.0774-.0189.15379-.0397.22685-.0716.0475-.0212.0919-.0471.1311-.0814.0367-.0295.0688-.064.10245-.0967.0332-.0375.0754-.0642.11364-.0958.0523-.0364.103-.0758.15617-.11096.0383-.0248.075-.0512.11051-.0797.035-.0264.0656-.0583.0949-.0908.0219-.0315.0432-.0639.0666-.0945.0201-.0269.0438-.0505.0653-.0761.0289-.0357.0577-.072.0855-.10872.0197-.034.0393-.0681.0591-.10202.003.006.008.0109.0148.0144.10768.002.21498-.0113.32215-.0201.0746-.0108.14911-.0238.22415-.0313.0709-.005.14198-.004.21298-.005.0563-.00092.11202-.004.16778.004.0595.0179.11802.0379.17809.0537.0836.0251.1688.0445.25324.0662.056.0139.11082.0293.16555.0474.0335.0165.065.0361.0985.0528.0479.0222.0972.0407.14676.0591.0636.0176.10507.0674.17002.0797.051.017.0953.0273.14693.041.0542.0162.10872.0397.16284.0562.06.021.14788.027.20988.0386.0893.0203.20617.0226.29738.0255.0618.002.12776-.009.1895-.0105.0553-.0108.0782-.0427.0162-.1713-.0603-.001-.0923.004-.15251.001-.0909-.005-.18167-.0111-.27203-.0229-.0616-.0109-.12465-.0161-.18389-.0385-.0547-.0156-.10968-.0294-.16466-.0443-.0508-.0174-.10557-.0225-.15615-.0412-.0641-.0131-.12658-.0314-.19061-.0448-.0494-.0178-.099-.0355-.14765-.0555-.0349-.0153-.0662-.0351-.0993-.0537-.0538-.0199-.10713-.0399-.16241-.0555-.0833-.0268-.1701-.0422-.25459-.0649-.0613-.0136-.12122-.0327-.18165-.0497-.0556-.009-.1114-.0101-.16778-.0101-.0716-.00014-.14334.00091-.21477.006-.0741.005-.14741.0164-.22104.0264-.10829.004-.21676.009-.32394.026-.0359-.0183-.0764.0283-.0873.0725-.0425.005-.0914.0702-.0743.10783-.004.005-.008.0103-.012.0157-.0209.0266-.0448.05-.0657.0766-.0254.0284-.0463.0608-.0662.093-.0272.0338-.0592.0642-.0917.0926-.0354.0264-.0693.0544-.10784.0766-.0554.0328-.10559.0747-.15839.1114-.0375.0332-.0818.0582-.11499.0962-.0353.0311-.0639.069-.10202.0971-.0364.0357-.0796.0598-.12572.081-.0715.0292-.14565.0476-.22102.064-.11789.0302-.23728.0549-.35661.0788-.13032.017-.26105.0201-.39239.0166-.14644.00005-.29248-.006-.43848-.0179-.18359-.0144-.3666-.0362-.54721-.0729-.1458-.0377-.27519-.0864-.37987-.19999-.0756-.0829-.1387-.17386-.18344-.27741-.0475-.11107-.0784-.22688-.10336-.34497-.0284-.13314-.091-.25353-.10858-.38861-.0326-.18064-.0452-.17029-.0579-.29729-.0205-.1378-.0393-.27608-.0626-.41343-.0242-.0912-.0427-.12431-.13602-.15571-.10838-.0212-.21775-.0377-.32841-.0399-.0866-.003-.17336-.004-.25996-.003z"
          S.path ! A.d "M133.79 665.68c-.0239.0429-.041.0882-.0531.13557-.0148.065-.0168.13178-.0137.19815.005.0445.012.0899.0364.1285.0149.0236.0269.0334.0465.053.0106.008.0205.0175.0319.0248.0218.014.0717.0373.0937.0479.05.024.0998.0477.15045.07.0599.0227.0303.0123.0886.0314.0722.0392-.0203.2094-.0925.17015v0c-.0626-.0139-.0309-.006-.0949-.0248-.0367-.0135-.0673-.0238-.10276-.0404-.0644-.0302-.12169-.0711-.17099-.12252-.009-.0101-.0182-.0189-.0264-.0292-.0375-.0469-.0584-.10227-.0657-.16155-.005-.0692-.00091-.13864.0131-.20668.0137-.0545.0311-.10775.0631-.15457-.0508-.0408.0453-.16049.0961-.11972z"
          S.path ! A.d "M134.08 666.79c-.0841.0147-.17062.0101-.25558.007-.11064-.002-.22077-.009-.33043-.0236-.0512-.007-.0991-.0187-.15077-.0128-.0129.002-.0236.008-.0347.0136-.0572-.0255.003-.16045.0601-.13497.0138-.008.0281-.0159.0437-.0206.0558-.0144.11339-.0153.17072-.0176.11202-.003.22376.003.33516.0156.0473.006.0945.0131.14188.0186.0238.003.0455.004.0686.0101.008.002.0149.005.0223.008.0579.0301-.0131.16656-.071.13645z"
          S.path ! A.d "M128.43 673.93c.19189.10747.38323.21604.57919.316.1275.0597.25316.12499.38581.17283.0594.0215.0943.0308.15425.0484.11326.035.22814.0639.34318.0923.13045.0379.25993.0788.39149.11296.16549.0409.33125.0811.49532.12742.161.0485.32289.0939.4847.13956.12004.0377.24313.0669.36041.11279.0887.0347.14473.10679.19699.18267.0948.1523.1615.31965.2265.48619.0554.15703.11084.3139.16867.47006.0455.12595.087.25336.13046.38007.0575.16183.11117.32494.16593.48769.0321.0884.0631.17719.0961.26528.0597.0396-.0338.18021-.0934.14055v0c-.0417-.0802-.0808-.16125-.11022-.2469-.0579-.16424-.10936-.33045-.15983-.49708-.0404-.12728-.0804-.25509-.12997-.37905-.0625-.15089-.11909-.3041-.1777-.45649-.0681-.16909-.13251-.33982-.21021-.5048-.0447-.0784-.0907-.15761-.18308-.18333-.12242-.0349-.24847-.0558-.37049-.0924-.16233-.0443-.32413-.0906-.4855-.13826-.16376-.0464-.3299-.0838-.49349-.13081-.12879-.0393-.25578-.0837-.38339-.12671-.11638-.0293-.23477-.0494-.35119-.0785-.19117-.0498-.38102-.10909-.5593-.19504-.1969-.10128-.40474-.20375-.55042-.37551-.0551-.0337.0242-.16348.0793-.12985z"
          S.path ! A.d "M133.05 680.06c-.11934.005-.23645-.0157-.34811-.0566-.071-.0282-.13096-.073-.18335-.12762-.0558-.0612-.12361-.10766-.19411-.15012-.1119-.0675-.23556-.11089-.35612-.15953-.0435-.0176-.0868-.0357-.13008-.0535-.0446-.0179-.0891-.0357-.13367-.0536-.24833-.0909-.50043-.17103-.75548-.24078-.13831-.0363-.28062-.0527-.42339-.0507-.0836.004-.0423.001-.12435.009-.0667-.0332.0115-.19012.0782-.15698v0c.0832-.008.0415-.005.12553-.008.14687-.003.29386.007.43894.0306.26373.0465.52278.11856.77077.22041.20792.0872.41518.17911.59614.316.0677.0496.13344.1014.19031.16342.0535.0557.10691.0914.18195.114.11129.0312.22598.0411.3382.0675.0581.0302-.0132.16721-.0713.13697z"
          S.path ! A.d "M134.2 681.02c-.25447.0191-.50908-.008-.76261-.0274-.18697-.014-.37406-.0251-.56133-.0338-.0892-.005-.17803-.008-.26721-.002-.0592-.0293.0101-.16876.0691-.13948v0c.093-.0151.18647-.0188.28057-.0194.19268-.004.38556-.005.57813.003.13647.006.27275.0118.40885.024.0883.008.16524.0147.25146.0332.026.006.0512.0146.0768.0218.0596.0312-.0141.17148-.0736.14026z"
          S.path ! A.d "M133.3 677.66c-.051-.001-.11333.096-.0681.12885-.008.16542.026.32806.0685.48681.0414.13759.0877.27373.13871.40805.0475.11084.0827.22549.11185.34228.0325.13231.0539.26694.0757.40134.0149.12637.0267.25286.0398.37943.009.0943.0118.18902.0135.28366.003.0986-.008.197-.0129.2953-.003.0647-.002.0323-.004.0962.0571.0418.1555-.0924.0985-.13423.003-.0642.001-.032.005-.0967.007-.0976.0148-.19562.0103-.29351-.00002-.003.00002-.005 0-.008.0108-.003.0214-.007.0318-.012.0594-.0282.11705-.0593.17494-.0904.0665-.0426.13341-.085.19463-.13512.0599-.05.1232-.0958.1803-.149.003-.003.006-.007.0101-.0101.0428-.0351.0842-.0715.12439-.10962.0451-.0413.0842-.0878.1208-.13647.0138-.0204.0275-.0413.0408-.0622.0341-.0409.0668-.0826.0953-.12752.0967-.16356.0766-.12791.13155-.22282.008-.0147.0171-.0295.0255-.0443.005-.009.009-.0164.0161-.0282.10635-.18167.21403-.36286.31409-.5481.0584-.11202.11569-.22488.16465-.34139.0215-.0351.0414-.0709.0587-.10782-.009-.007-.0205-.009-.0318-.007-.051-.0107-.12122.0849-.0838.12438-.004.005-.008.009-.0125.0144-.0101.0144-.019.0293-.0308.0421-.0126.0183-.0262.0359-.0376.055-.0218.0302-.04.0632-.0618.0936-.0123.0154-.0242.031-.0353.0474-.007.0101-.0128.0206-.0201.0304-.003.004-.007.008-.0103.012-.0238.0275-.0523.0509-.0751.0792-.0739.091-.12627.19834-.1812.30155-.0254.0492-.0479.0998-.0685.15124-.0192.0453-.0393.0898-.0564.13601-.0171.043-.0314.0868-.047.13021-.0137.0387-.0282.0774-.0425.11588-.0101.0112-.0197.0225-.0295.0336-.0401.0447-.0815.0883-.12305.13154-.00022.00023-.00045.00069-.00091.00091-.0541.0453-.11064.0877-.16958.12663-.11032.07-.21943.14147-.33154.2085-.0733.0437-.14855.0857-.21432.1405-.008-.003-.0157-.003-.0233-.002-.002-.0413-.003-.0823-.007-.12348-.009-.12943-.0178-.25932-.0354-.38793-.0211-.13343-.0457-.26635-.081-.39686-.0305-.11726-.0657-.2328-.11187-.34498-.0506-.1381-.0891-.27988-.12705-.42191-.0367-.14819-.0685-.29757-.09-.44877-.006-.005-.0134-.007-.0206-.007zm1.9776.43444c-.0536.11254-.1084.22466-.16645.33513-.0549.10194-.11237.20266-.16957.30336-.005.0101-.008.0152-.0166.0295-.0427.0733-.085.14713-.12663.22103-.008.0141-.0157.0281-.0237.0421-.008.0134-.0307.0533-.0233.0399.0189-.0343.0385-.0683.0577-.10246-.0139.0229-.0289.0447-.0448.0662.0162-.0417.0314-.0838.0456-.12618.0141-.0429.0282-.0855.0456-.12706.009-.0319.0259-.0603.0393-.0904.003-.006.0183-.0439.021-.0506.0173-.0454.0386-.0889.0609-.13198.006-.008.011-.0159.0201-.0286.0236-.0327.0513-.062.0788-.0913.0243-.027.044-.0579.0658-.0868.0235-.0309.0438-.0636.064-.0967.0129-.021.0267-.0419.0408-.0622.009-.0143.0205-.0276.0304-.0416.00023-.00047.00069-.00092.00092-.001z"
          S.path ! A.d "M137.55 676.75c.0943-.0249.19054-.0407.28644-.0575.0751-.0135.1513-.0172.22745-.0177.0512.00046.10241-.00022.15362-.001.0749-.001.14978.004.22447.0101.1523.0155.30498.0267.45743.0404.22326.0202.44534.0488.66649.0853.23459.0348.46615.0847.69314.15315.149.0423.28502.11486.41559.19634.12339.0807.2448.16415.36898.24368.15687.0969.31378.19365.47148.28916.12778.0715.24911.15271.36125.24677.0704.0592.1296.12948.18653.20119.0367.0503.0698.10353.10943.15151.0509.0574.10839.10788.16677.15741.0632.0521.12295.10785.18381.1626.0325.0294.0568.065.0802.10172.0548.0354-.0286.16457-.0834.12918v0c-.0214-.0363-.0422-.0717-.0772-.0971-.064-.0502-.12894-.0993-.18998-.15315-.0579-.0532-.11144-.10965-.16199-.1699-.0392-.0471-.0752-.0971-.11379-.1447-.0581-.0684-.11374-.13922-.18936-.18953-.11706-.0856-.23972-.16248-.36705-.23196-.16108-.0903-.32099-.18377-.47351-.28802-.12104-.0845-.23701-.17609-.35965-.25824-.13171-.0794-.27709-.1291-.42541-.16845-.2288-.0623-.46194-.1046-.6958-.14318-.21822-.0368-.43578-.0782-.65583-.10288-.14895-.0181-.29848-.0339-.44585-.0627-.0719-.011-.14425-.0219-.21717-.02-.051-.001-.10197-.003-.15281.001-.0773.006-.15437.0161-.23079.0293-.0929.0175-.18593.0397-.28044.0455-.0586-.0284.008-.16629.0671-.13787z"
          S.path ! A.d "M142.31 678.92c-.0317.00024-.0633.002-.0949.007-.0579-.0301-.12894.10591-.0712.13603.0443.0222.0943.0262.14274.0304.0417.004.0509.004.0926.007.0875.006.17462.014.26173.0242.0934.0101.18749.015.28056.0273.11169.0167.22214.0382.33198.0644.0223.007.0452.0126.0681.0179.0139.0185.0271.0376.0384.0578.011.0194.0259.0525.0349.0721.0373.0855.0783.16919.11947.2528.0442.0791.0905.15673.13556.23534.0196.0455.0384.093.0479.14184.0119.0622.0122.1258.0135.18881-.001.11663-.0265.23055-.0559.34273-.004.0153-.008.0305-.0129.0456-.001.00092-.002.002-.003.003-.0614-.0265-.12391.11802-.0626.14451.0135-.009.0271-.0186.0389-.03.0668-.11166.12631-.19744.16106-.32081.0345-.11729.0651-.23729.0613-.36062-.001-.0213-.002-.0427-.004-.064-.009-.0883-.0371-.17393-.0783-.25235-.0428-.0796.008-.16885-.0307-.25038-.0345-.0721-.0561-.14597-.0946-.2161-.0203-.0787-.0377-.12084-.09-.14918-.0605-.0211-.12147-.0406-.18567-.047-.11337-.0209-.22684-.0414-.34184-.051-.0943-.009-.18829-.0166-.28278-.0223-.0292-.002-.0586-.004-.0877-.007-.058-.006-.11543-.0159-.1736-.0197-.0528-.004-.10587-.008-.15883-.008zm1.2971 1.7378c-.0176.0338-.0332.0596 0 0z"
          S.path ! A.d "M123.09 675.85c.26364.10698.51699.23785.77922.34825.0772.0325.15552.0618.23328.0928.14753.0567.3309.12979.48175.17743.14359.0453.38941.10718.53458.14391.21928.0555.2973.0739.51467.12679.28942.0679.5766.14855.8495.26779.15016.0656.20007.0959.34483.17302.29905.17395.55081.41171.79734.65125.0823.0819.16682.16149.2515.24091.0712.0427-.0294.21032-.10051.16767v0c-.0931-.0669-.18608-.13425-.27002-.21274-.0769-.0687-.15122-.14011-.22916-.20752-.17943-.15523-.37321-.29533-.57618-.41788-.15746-.085-.17765-.1019-.34407-.16764-.27846-.10996-.57224-.16942-.8635-.23406-.1877-.0399-.33478-.0692-.5215-.11639-.3451-.0873-.68334-.20114-1.0116-.33884-.30776-.13894-.62211-.28158-.88512-.49777-.0231-.0189-.0436-.0407-.0653-.061-.0577-.0341.0227-.17005.0803-.13596z"
          S.path ! A.d "M128.19 681.78c.088.12285.15347.26006.22432.3931.0714.13208.15149.25962.23911.38151.0756.10193.16337.19352.25078.28516.12583.12728.28014.21713.43621.30154.078.0362.13696.067.22015.0918.0829.0248.2326.0529.31533.0678.15303.0275.19696.0326.35062.0549.22624.0197.45219.062.67995.0625.11712.00022.22319-.0122.33958-.0229.29834-.0437.58827-.12705.87912-.20396.16395-.0445.32092-.10909.47725-.17466.14516-.0735.30189-.10745.46214-.12623.20348-.008.40719-.006.61082-.011.0802.0408-.0159.22978-.0961.189v0c-.19929-.001-.39845-.0206-.5978-.0102-.0597.007-.0997.0101-.15844.0223-.10393.0217-.20187.0628-.29852.10565-.15948.0706-.32353.12916-.48678.19028-.29247.10426-.58866.20434-.8996.2352-.0569.005-.11364.0114-.17065.0143-.28579.014-.57276-.0174-.85578-.0528-.30531-.0448-.60138-.10031-.8726-.256-.15562-.0911-.30505-.19244-.42907-.3249-.0865-.0938-.17078-.1894-.25093-.28871-.0908-.11778-.1767-.23985-.25044-.36913-.0735-.13947-.14634-.28058-.2028-.42789-.0537-.0357.0305-.16233.0842-.12663z"
          S.path ! A.d "M134.6 682.87c.18942-.10946.40495-.15545.61737-.19654.26423-.0484.53289-.061.79956-.0894.30275-.0272.60731-.0387.91087-.021.19605.008.38446.061.57381.107.19317.0411.38192.098.56896.16055.0206.008.0413.0153.0618.023.0662.0363-.0192.19247-.0856.15619v0c-.0217-.005-.0435-.0106-.0652-.016-.19243-.0452-.38323-.0963-.57269-.15263-.0874-.0235-.17494-.0493-.26449-.0634-.10387-.0165-.20952-.0211-.31444-.0241-.30629.002-.61149.027-.91748.0389-.26287.009-.52554.0271-.78573.0675-.20007.0409-.3968.0933-.59191.15361-.061-.0276.004-.17122.065-.14363z"
          S.path ! A.d "M138.6 683.21c.0627.0126.12456.0343.18366.0591.0307.0114.0616.0208.0911.0353.0266.012.0527.0249.0796.0364.0358.0191.0715.0383.1078.0565.065.0311.12053.0789.17879.12073.0784.0547.15005.11819.22369.17893.0645.0547.12867.10903.19616.16001.0722.0484.14285.0986.21066.15298.0773.0632.1484.13342.22018.20266.1.0891.19477.18323.28676.2805.10614.11678.20574.23923.3103.3574.0772.0915.16044.17748.22824.2764.0646.0899.11059.19046.15893.28942.0517.10864.10165.21811.15079.32792.0419.10302.10546.19327.16541.28586.0331.0469.0661.0934.10614.1346.0589.0362-.0264.175-.0854.13882v0c-.0405-.0414-.0757-.0867-.11083-.13265-.0636-.0896-.12923-.17864-.17232-.28058-.0503-.10968-.0965-.22118-.14927-.32966-.0461-.0998-.0918-.20015-.15455-.29105-.0222-.0317-.0367-.0542-.0621-.0835-.0541-.0626-.11847-.11578-.17287-.17815-.10486-.11793-.20583-.23914-.30943-.35818-.0898-.10041-.18246-.19791-.27823-.29263-.0705-.0703-.14175-.13977-.21681-.20519-.0669-.0553-.13717-.10605-.20795-.15606-.0686-.0494-.13414-.10253-.19885-.15689-.0747-.0593-.14713-.12154-.22317-.17922-.0546-.0461-.10875-.0938-.17043-.13013-.0343-.0209-.0699-.0396-.10378-.0613-.0264-.0129-.054-.0233-.0801-.0367-.0288-.0156-.0607-.0203-.0918-.0295-.062-.0168-.12418-.033-.18326-.0588-.0566-.0309.0164-.16433.073-.13336z"
          S.path ! A.d "M142.52 687.31c.0413.0599.0764.12498.12723.17773.0363.0377.0652.0569.10685.0885.11991.0873.26434.12418.40319.16939.097.0307.19369.0624.28942.0969.0334.0119.0656.0261.0989.0383.0587.0325-.0179.17071-.0766.13825v0c-.0336-.0116-.0669-.0242-.10102-.0341-.0975-.0325-.19832-.0527-.29672-.082-.14386-.0394-.28826-.0803-.41001-.17073-.0191-.0151-.0391-.029-.0574-.0451-.0764-.0675-.13525-.15373-.16933-.2496-.0541-.0362.0314-.16368.0854-.12745z"
          S.path ! A.d "M141.86 686.12c.10989-.00046.21501.0275.31646.0673.11529.047.21188.12647.30979.20137.0784.059.14946.12655.22396.19014.0612.0504.10342.11573.14046.18461.0298.0495.047.10445.0668.15834.002.006.004.0118.006.0178.0522.0354-.0312.15827-.0834.12288v0c-.002-.005-.004-.011-.006-.0166-.0217-.0503-.0437-.10062-.0715-.14802-.0353-.0671-.076-.13216-.13537-.18059-.0768-.0595-.15264-.12004-.23044-.17815-.0976-.0728-.19124-.15286-.30509-.19998-.0543-.0212-.10822-.0403-.16503-.0537-.0175-.004-.0353-.007-.053-.0109-.0157-.003-.0315-.006-.047-.009-.0125-.003-.0249-.007-.0373-.0104-.0572-.0299.0134-.16461.0705-.13469z"
          S.path ! A.d "M117.59 685.67c-.0494.004-.0992.10508-.0519.132.0158.009.0309.0188.0452.0295-.00016.00069.00015.00024 0 .00093-.0258.0906-.0516.17983-.0846.26577-.0152.0395-.031.0785-.0478.11678-.018.0405-.0441.0829-.0631.13334-.00046.001-.00091.003-.001.005-.0189.0308-.038.0623-.0577.0908-.18315.26563-.41064.49943-.6519.71678v.00046c-.21958.17583-.45251.33312-.69128.48457-.00045.00022-.00091.00069-.001.00091-.006.004-.0333.0224-.0604.0417-.0136.0101-.0275.0196-.0393.0291-.0118.009-.0207.0158-.0313.0304-.10499.14545-.17717.30573-.24385.46531v.00046l-.00046.00046c-.0498.11357-.10041.22677-.15347.33825-.019.0399-.0391.0799-.0591.12036-.0179.0364-.0413.0756-.0595.12081-.18886.3167-.40835.61598-.64655.89934-.0493.0545-.0968.10929-.14585.16106-.19143.20201-.40066.38892-.6009.58792-.0144.003-.0315-.001-.0417.007-.0219.0169-.0361.0393-.0461.0631-.0101.0239-.0158.0495-.0125.077.003.0274.021.0601.0528.0734.0153.006.0327.004.0456-.006.26625-.2064.50169-.44565.72932-.68859l.00092-.00091c.26766-.30157.49925-.63305.70202-.97988v-.00045c.16818-.28433.30721-.58342.43668-.88457v-.00046c.0218-.0523.0434-.10352.0657-.15436.009-.009.0197-.0188.0291-.026.0162-.0123.0368-.0242.0587-.0384l.003-.002c.23912-.13514.46726-.28649.68502-.4537.00069-.00046.001-.00092.002-.001.25122-.21278.48202-.45366.67024-.72662.0345-.05.0644-.10102.0954-.14944l.00045-.00045c.1475-.22473.23303-.3833.30114-.60762.10453.0767.21736.14144.33868.18882.10486.041.14898.0598.25996.0945.26093.0814.53124.12876.80225.16107.074.006.14776.0155.22192.0192.22063.0111.44321-.005.65951-.0497.0583.029.12674-.10834.0685-.13735-.14589-.00014-.29209.0172-.43804.009-.11531-.006-.29269-.0324-.40403-.047-.36394-.0472-.72556-.11164-1.077-.21835-.15622-.0512-.29955-.13283-.43535-.22417-.0103-.0122-.0205-.0188-.0318-.0214-.0239-.0156-.0485-.0297-.0747-.0412-.007-.004-.0136-.005-.0206-.004zm-.92976 1.6143c-.0242.0213-.0408.0499-.0653.0707l-.00045.00046c-.19932.15293-.40992.2887-.6273.41432.003-.002.006-.004.009-.007.025-.0177.0486-.0333.0582-.0398l.001-.00092c.21443-.13605.4225-.28193.62415-.43803zm-2.6868 3.1468.002.006c-.001-.00021-.002.00069-.004.00046zm-.0166.0806c.00092.00045.002.00092.003.001l-.004.004z"
          S.path ! A.d "M118.97 686.29c.0268.0933.0241.19499.00005.28885-.006.0238-.0151.0466-.0225.0699-.0529.11817-.10921.24196-.20229.33402-.0566.0561-.12399.0938-.19328.13156-.16621.0788-.35083.0899-.53145.10156-.16305.002-.32667.002-.48925-.0118-.0826-.007-.1515-.0173-.23328-.0282-.13261-.0193-.26588-.0382-.39422-.0777-.009-.004-.0186-.007-.0278-.011-.0579-.0317.0168-.16811.0747-.13643v0c.009.002.0191.004.0287.006.13752.0174.27641.0232.41442.0355.23916.0198.47839.0439.71871.0407.17592-.004.35563-.004.51531-.0885.066-.0367.13165-.0736.18462-.12882.016-.0166.0476-.0766.0432-.0539-.007.0357-.0315.0658-.0516.0963-.0134.0202.0209-.0437.0314-.0655.008-.0232.0183-.0459.0252-.0696.0293-.10041.0294-.2058.0231-.30924-.0526-.0366.0337-.1606.0863-.12398z"
          S.path ! A.d "M115.01 692.02c.0196-.0334.0387-.0672.0589-.10021.008-.0124-.0139.0257-.0212.0384-.0352.0615-.0711.12251-.10629.184-.0196.0344.039-.0689.0597-.10255.007-.0119-.0132.0247-.0196.0372-.006.0117-.0115.0236-.0173.0354-.0326.0713-.0467.14864-.0637.2246-.0149.076-.0283.15201-.0364.22897-.011.0971-.008.19014.0144.2852.0311.10852.0976.16548.17632.24032.0795.0749.16181.14749.25107.21051.0977.0713.2091.11203.32457.14367.1381.0339.28043.0494.42243.0498.15599-.004.30989-.028.46255-.0588.12274-.0299.24526-.0609.36788-.0913.11513-.029.23151-.0534.34817-.0756.1552-.0331.31158-.0609.46836-.0855.17042-.025.34269-.0308.51463-.0344.0274-.001.0548-.002.0822-.004.11333-.007.0854-.0101.20073-.0129.0992-.003.19809.00092.2971.006.15918.0119.31766.033.47541.0571.13661.0176.27322.0349.40918.0572.14538.0289.29296.044.44023.0595.17049.0108.34024.03.51081.0399.20057.00068.3991.0307.59895.0432.20184.0173.4043.0246.60635.0388.24365.016.48596.0435.72609.0875.19406.0376.38516.0969.55362.2018.097.0649.16179.1604.22844.25355.0272.0383.0529.0777.0773.11777.0583.0374-.0299.17473-.0882.13733v0c-.0263-.0377-.0535-.0747-.0796-.11257-.0652-.0891-.13103-.18312-.22714-.24109-.17953-.0894-.37303-.12284-.56828-.16186-.12879-.0242-.25763-.0524-.38742-.0707-.054-.008-.16474-.0171-.21927-.0217-.0366-.003-.0732-.006-.10975-.009-.20057-.0177-.40146-.0312-.60225-.0461-.19954-.014-.39903-.0288-.59845-.0446-.16888-.0157-.33748-.0342-.50637-.0496-.14705-.0158-.29438-.0314-.43875-.0646-.13611-.0236-.27367-.0353-.41049-.0537-.15939-.0213-.31941-.0396-.48031-.0437-.19167-.006-.3836-.002-.57519.004-.17184.005-.34378.0132-.51402.0385-.15321.0223-.3064.0447-.45936.0687-.11637.0227-.23177.0501-.34743.0761-.12541.0305-.24835.0704-.37359.10165-.15318.0323-.30843.0543-.4653.0552-.1429-.004-.28601-.0165-.42382-.057-.11697-.0332-.22874-.0787-.32572-.15379-.0892-.064-.17794-.13002-.2557-.20787-.0736-.0733-.14636-.14919-.18191-.24916-.0103-.0394-.0178-.0617-.0219-.10252-.006-.0637.004-.12774.006-.19125.008-.0772.0226-.15332.0348-.2299.0162-.0771.0332-.15456.0617-.2281.0415-.0884.0874-.16379.13755-.25189.0192-.0337-.0385.0673-.0578.1008-.008.0142.0162-.0282.0242-.0424.0323-.0555.0645-.111.0969-.1665.0602.0232.006.16488-.0545.14176z"
          S.path ! A.d "M121.72 693.46c.15124-.0197.30441-.0176.45665-.018.16008.006.31969.003.4789-.0147.10484-.0181.21068-.0444.29526-.11258.0168-.0136.0318-.0293.0476-.0441.0657-.0665.12738-.13753.17881-.21583.0109-.0166.041-.068.0311-.0508-.0193.0342-.0399.0677-.0599.1014.0217-.0486.0585-.1007.05-.15649-.0235-.0497-.0523-.0968-.08-.14418-.0117-.0217-.0237-.0431-.0352-.0648-.0535-.0348.0285-.16081.0819-.12604.0124.0202.0263.0393.0377.0602.0307.0491.0603.0987.0793.15357.0169.0512-.006.0989-.0273.14562-.095.16783-.17904.33085-.32521.46019-.0163.0137-.0318.0284-.0489.041-.09.0662-.19819.0992-.30701.118-.16088.0204-.32221.019-.48417.0201-.14607-.00047-.29338.003-.43831-.018-.0571-.0291.0114-.16383.0687-.1347z"
          S.path ! A.d "M114.98 689.56c.0479.0822.0828.17094.13079.25316.0393.0674.049.0774.0946.1402.0745.0846.16155.15847.26333.20804.0598.0291.0904.0375.15271.0589.20358.0588.39539.0266.60003-.006.27447-.0546.53949-.14659.80083-.24505.13215-.0487.26044-.10531.38072-.1786.0373-.0227.0739-.0463.11161-.0685.0628.0277-.002.17567-.0653.14799v0c-.0381.0253-.0759.0512-.11467.0755-.12822.082-.2623.15413-.40131.21632-.0959.0422-.14749.0666-.24799.10259-.18099.0647-.36873.11106-.55836.14168-.19944.0235-.4006.0372-.59588-.0215-.0261-.008-.0527-.0156-.0783-.0253-.13614-.0513-.2543-.13508-.34872-.24574-.0974-.13019-.17327-.26514-.2108-.42486-.0544-.0368.0323-.16514.0867-.12835z"
          S.path ! A.d "M114.15 689.23c-.0658.10402-.14113.20216-.22499.29223-.077.0765-.16584.139-.25677.19753-.0952.0611-.18769.12614-.28083.19024-.10119.0632-.19958.13064-.29954.19574-.11329.0778-.22839.15259-.34538.22466-.10091.0614-.20553.11623-.30749.17585-.11829.0626-.23494.12814-.35165.19363-.1741.0903-.32686.21342-.47647.33878-.12917.11409-.25711.23358-.36143.37161-.0182.0241-.0344.0495-.0516.0742-.0146.0232-.0554.0943-.0436.0696.0154-.0321.0305-.0654.0542-.0918.0166-.0184-.0224.0442-.032.067-.0282.0676-.0409.13556-.0517.20746-.007.11889-.0114.23787-.0198.35671.0651.0478-.0477.20126-.11279.15341v0c.005-.12133.0101-.24288.0229-.36364.009-.0595.011-.0871.0267-.14457.0434-.15904.142-.29508.22696-.43418.11995-.16928.26184-.32159.42196-.45383.14708-.12149.30079-.23377.47209-.31929.11528-.0612.2316-.12021.34612-.18279.10112-.0606.20601-.11413.3066-.17547.11589-.0781.23046-.15822.34891-.23234.0993-.0614.1989-.12241.29538-.18808.0921-.0647.185-.12843.28043-.18818.0899-.0602.17922-.12251.25381-.20155.0772-.0866.14525-.18064.21417-.27381.0598.0231.005.16395-.0543.14091z"
          S.path ! A.d "M107.06 683.23c.064.15699.0956.32425.13817.48772.0435.14147.0727.28651.11045.42952.0351.12455.0771.24676.12735.36594.0742.17436.1704.3378.2635.50242.15094.23013.33197.44134.55063.61004.0562.0434.11608.082.17411.12303.3652.23755.75176.43944 1.133.64948.20829.12098.42582.22419.65648.29384.24313.0662.49315.0971.74382.11544.25932.002.51836-.0114.77751-.0181.27853-.0144.55471-.0549.83023-.0966.21287-.0347.42392-.0776.63147-.13609.0866-.0289.0446-.0133.12606-.0469.0607.028-.005.1711-.0659.1431v0c-.0834.0347-.0406.0183-.12868.0488-.21035.0677-.42524.11906-.64335.15515-.27437.0427-.55019.0761-.82786.0871-.26027.0108-.52079.0292-.78136.0213-.25122-.0201-.50152-.0509-.74369-.12414-.22982-.0759-.45616-.16177-.66995-.27643-.3899-.19587-.78368-.38898-1.1411-.64132-.28912-.22032-.53477-.44156-.71621-.76203-.0939-.16831-.18325-.33885-.25582-.51762-.0486-.11959-.0948-.24032-.13082-.36439-.0405-.14292-.0647-.28893-.10988-.43043-.0462-.16409-.0895-.32887-.13328-.4937-.0531-.0361.0321-.16132.0853-.12517z"
          S.path ! A.d "M109.92 687.21c.25308.20728.51812.39843.79479.57274.33515.20892.70247.36384 1.0861.45858.0786.0194.15842.033.23762.0495.36258.0388.73663.0789 1.1.0217.0584-.009.11564-.0239.17346-.0358.38686-.0877.75269-.24509 1.1148-.40346.18466-.0813.36412-.17346.54376-.26501.0754.034-.005.2115-.08.17757v0c-.17975.0955-.35945.19159-.54752.27007-.36135.15817-.72804.30867-1.1147.39361-.15288.0319-.20305.0468-.36022.0611-.30919.0282-.62325.0138-.92966-.0332-.0795-.017-.15963-.0313-.23856-.0509-.38572-.0954-.754-.25254-1.0877-.4683-.27339-.1836-.54738-.37519-.77152-.61866-.055-.0337.0244-.16343.0794-.12973z"
          S.path ! A.d "M115.23 699.75c-.0509.004-.10305.10746-.0546.13558.0998.0784.20584.1518.28859.24877.077.11001.13601.23126.1897.35391.0611.13753.12044.27538.18255.41253.031.0573.0562.11719.0801.17764.00005.00012-.00005.00022 0 .00046-.0149.0274-.0295.0548-.0456.0823-.006.0101-.0131.0206-.017.0264-.005.006-.009.0114-.0144.017-.0566-.0233-.11161.11006-.055.13332.005-.005.0108-.0101.0161-.0152.0449-.0589.0814-.1317.11678-.19284.0158-.0273-.0462.0793-.0581.0989.0379-.0692.049-.0888.0681-.12304.0102.0264.0202.0528.0305.0792.0103.029.0187.0587.0229.0886-.0125.002-.0255.004-.038.005-.0555-.0275-.12041.10353-.0649.13109.10562-.0115.15865-.0531.18972-.17986.005-.0578-.008-.11373-.0264-.16824-.0115-.0323-.0226-.0644-.034-.0967.0104-.0188.021-.0376.0309-.0568.029-.057.05-.11859.0465-.18345-.002-.078-.006-.15562-.0188-.23266-.0237-.14587-.0565-.29017-.0922-.43355-.0529-.0368-.13966.0881-.0868.12483.0225.14681.0614.29047.0895.43624.0147.0738.0205.14861.0224.22371.00069.0248-.003.0494-.009.0734-.0188-.0505-.0396-.10062-.0649-.14856-.0603-.138-.12039-.27608-.1821-.41342-.0571-.12158-.11448-.24385-.19641-.35122-.0841-.0977-.18363-.1823-.29441-.24833-.007-.004-.0142-.005-.0214-.005zm.63893 1.4184c-.009.0164-.0189.0329-.0282.0493.005-.009.009-.017.0148-.0269.002-.003.008-.0137.0135-.0224z"
          S.path ! A.d "M113.44 677.94c.13575.0958.24309.22611.36046.34263.1178.11314.24551.21507.38348.30254.0695.044.13656.0806.20817.12079.13242.0784.26816.15518.38478.25646.0824.08.11445.18934.13816.2983.0267.16215.0277.32709.0286.491.001.1392-.002.2784-.007.41752-.002.0359-.003.0718-.002.10769.0536.0383-.0367.1645-.0902.12623v0c-.004-.0329-.006-.0656-.006-.0989-.004-.13308-.006-.26621-.006-.39936-.002-.16585-.002-.33226-.0202-.4973-.0166-.10871-.0386-.22176-.12226-.30015-.12305-.0918-.26902-.14522-.40265-.21931-.21987-.11772-.42343-.24547-.59529-.42942-.11615-.12488-.22396-.25637-.33019-.3897-.0547-.0331.0233-.16214.0781-.12904z"
          S.path ! A.d "M117.45 686.01c-.0797-.11849-.15578-.23981-.22892-.36255-.0924-.14967-.1867-.29822-.27881-.44814-.0575-.0828-.10921-.17071-.17616-.24658-.0449-.0509-.0591-.0602-.11057-.10523-.14794-.1156-.31242-.20525-.48342-.28126-.15242-.0612-.30709-.11713-.46349-.16731-.10154-.0335-.20519-.0603-.31049-.0787-.0903-.0177-.18075-.0358-.27238-.045-.0427-.008-.0877-.0132-.11758-.0473-.0183-.0397-.002-.0871.005-.12784.0148-.11888.0332-.2372.0525-.3554.0251-.15952.0473-.31942.0662-.47978.0224-.177.0326-.35514.046-.53296.011-.18709.0153-.37461.0189-.56199.006-.13018.002-.26025-.002-.39038.003-.0683-.0181-.12801-.0507-.18667-.0437-.0623-.0793-.12943-.11464-.19663-.0175-.0371-.0342-.0731-.0605-.10485-.054-.0341.0263-.16131.0803-.12725v0c.0238.0331.0443.067.0638.10275.0428.0618.081.12697.11873.19191.03.059.054.12087.0583.18758.0139.12254.0231.24548.0197.36893-.00069.1874-.003.37486-.0173.5618-.0125.17925-.0231.35884-.0478.53693-.0187.16321-.0396.32616-.071.48751-.0203.12291-.0417.24564-.0617.36859-.0101.0436-.029.0899-.027.13469.0262.0309.0793.0215.11482.0283.0938.006.18702.0157.27881.0363.10589.0205.20953.0507.31482.0739.16175.0389.32151.0865.47414.1534.17395.0748.34321.16329.48434.29168.11619.10663.20651.22104.2915.35381.0964.14659.19247.29317.28197.44404.0782.12749.15442.25735.20845.39727.0536.0355-.03.16187-.0837.12636z"
          S.path ! A.d "M109.71 694.13c.0912.0206.18108.0474.26993.0765.095.0308.19067.0596.28318.0972.0797.0355.15722.076.23448.11641.0945.0486.18451.10453.27181.16495.0659.0459.13353.0894.19671.13895.0551.0409.10996.082.16509.12277.0423.0293.0835.0594.12185.0938.0431.0375.0804.0802.11479.12562.0456.0633.0932.12514.13497.19106.0292.0508.0637.0984.0996.14454.0355.0471.0732.0925.10953.13892.0717.0786.13701.16215.19993.24783.0916.1163.16855.2427.24107.37144.066.11747.12521.23856.18817.35767.0447.0872.0927.17259.14706.25412.064.091.13771.17418.21085.25784.0947.10527.18695.21254.2843.31537.0955.10385.18819.21017.27882.31826.0902.10534.17511.21499.26097.32385.0748.0962.15071.19121.22046.29113.054.0737.0983.15274.13124.23783.0283.0746.0463.15293.0604.23139.0163.0667.0242.13484.0399.20158.0226.0869.0519.17171.0786.25735.0197.0604.0348.12209.0509.18348.057.0389-.0348.17294-.0916.13406v0c-.0195-.0594-.0383-.11891-.0532-.17968-.0274-.0873-.0557-.1743-.0757-.26368-.0153-.0672-.0211-.13598-.0398-.20249-.0161-.0765-.0325-.15335-.0603-.22659-.0318-.0832-.0752-.16037-.1309-.23014-.0745-.095-.15081-.18848-.22395-.28452-.0862-.10814-.1781-.21164-.26156-.32197-.0903-.10762-.18583-.21054-.27985-.3149-.0957-.10534-.19295-.20957-.28196-.3206-.072-.087-.14531-.1739-.20599-.26934-.0532-.0806-.1071-.1609-.15471-.24494-.0661-.11665-.12422-.23747-.18994-.35437-.0738-.12739-.15554-.24973-.23948-.37063-.0615-.0895-.1214-.18026-.18722-.26661-.0361-.0471-.0734-.0934-.10729-.14223-.0361-.0454-.074-.0898-.10496-.13892-.0425-.0653-.0919-.1261-.13268-.19273-.0331-.046-.0661-.0917-.10887-.12943-.0372-.0346-.0805-.0604-.1227-.0884-.0573-.0378-.11156-.0803-.16686-.12106-.0642-.0476-.13238-.0886-.20033-.13055-.0896-.0557-.17833-.11308-.26967-.16596-.0751-.0429-.15151-.0846-.23256-.11523-.0938-.0336-.18852-.0641-.28284-.096-.0881-.0278-.17923-.049-.26259-.0897-.0565-.031.0166-.16418.0731-.13315z"
          S.path ! A.d "M102.46 683.3c-.22718-.0258-.44748-.0918-.66776-.15063-.19329-.0431-.38632-.0892-.58208-.11966-.18696-.0337-.37684-.0442-.56618-.0544-.16219-.009-.32423-.0101-.48569.009-.15193.0274-.30253.0706-.44409.13262-.1538.0869-.28047.21025-.39043.34691.0339-.0431-.11861.16965-.0819.13284.0215-.0217.021-.0653.0492-.0774.0231-.0101-.0203.0457-.0295.069-.0245.0616-.0282.0785-.0474.14154-.0372.1374-.0439.27983-.0502.42124-.0112.11734.004.22956.0392.34131.0474.11825.12004.22395.19254.32795.0618.0839.12886.16374.19574.2436.0629.0717.11451.15188.1724.22742.0414.0502.0867.0966.13113.14401.0448.0477.0972.0878.14735.12956.0724.0657.15205.12239.22897.18246.0688.0521.12988.11225.18977.17389.0282.0347.0592.0669.0966.0916.0529.0308-.0197.15532-.0725.12455v0c-.0387-.0234-.0742-.0511-.10362-.0858-.0622-.0578-.12246-.11766-.1914-.16765-.0781-.0595-.15792-.11722-.22799-.18632-.0478-.0458-.10051-.0864-.14577-.13477-.0442-.0475-.092-.0914-.1353-.13988-.0588-.074-.11345-.15114-.17416-.2236-.0667-.08-.13275-.16043-.19879-.24098-.0769-.10314-.1489-.21111-.19657-.33128-.0357-.11213-.0542-.22485-.0448-.34304.002-.14096.009-.28275.044-.42011.0594-.20659.15403-.38429.27774-.56079.111-.13609.23735-.26111.39642-.34003.14353-.0617.29446-.10893.44926-.1317.16322-.0178.32694-.0204.49098-.0131.19044.006.38046.0208.56826.0546.19675.0303.39175.0702.58527.11686.22084.0479.44311.0959.65603.17248.0586.0317-.016.16968-.0745.13805z"
          S.path ! A.d "M101.81 687.15c.096.12802.19725.25187.29237.38049.0581.0811.12194.15778.18229.23718.0619.0913.10814.19279.15484.29253.0513.11432.0989.23012.14638.3461.0655.1405.10666.29011.14236.44047.0478.18708.0663.37896.0769.57116.005.16186.012.32398-.005.48529-.0156.15936-.053.31551-.0896.4711-.0379.13891-.0812.27635-.13709.40913-.0617.13679-.13241.27101-.21611.39568-.033.0551-.0744.10434-.11175.15641-.0241.0309-.0126.0159-.0341.0451-.0589-.0233-.004-.16191.0549-.13862v0c.0226-.0312.0108-.0151.0353-.0481.0385-.0519.0792-.10217.11162-.15823.0212-.0334.0852-.13517-.0357.0656-.008.0126.0138-.0261.0208-.039.0265-.0493.0519-.099.0738-.15055.055-.12933.095-.26397.13285-.39919.0387-.15587.0753-.31293.0936-.47271.0178-.15873.011-.31802.003-.47728-.0115-.1915-.0282-.38315-.0741-.57-.0324-.15282-.0686-.30645-.13274-.44952-.0472-.1155-.0935-.23136-.14706-.34412-.0436-.10231-.09-.20428-.14467-.30102-.0617-.0763-.12874-.14775-.1908-.22365-.10408-.12433-.20972-.25024-.2854-.39444-.055-.0354.0284-.16513.0834-.12972z"
          S.path ! A.d "M100.64 691.55c-.0747.14289-.1568.28141-.22722.42653-.0926.18117-.13677.37894-.16985.5781-.026.14274-.0412.28579.006.42494.0426.0997.10291.19018.15876.28268.0657.10843.12769.21893.18701.331.0534.0981.0939.20329.12129.31148.0227.12866.0307.25969.0419.38983.0134.12401.009.24773-.0101.37071-.0172.10457-.0636.20029-.1096.29466-.044.0862-.0871.1727-.13141.25862-.0448.084-.18828.32683-.0485.0863.0499.0402-.0451.15774-.095.11745v0c.30134-.52366-.0465.0832.0478-.0841.0416-.0842.0833-.16803.12598-.25158.0469-.0941.0956-.18911.11487-.29337.0178-.12024.0217-.24037.008-.36153-.0101-.1318-.019-.26395-.035-.39509-.0248-.10731-.068-.20882-.12034-.30565-.0593-.11201-.12274-.22173-.18587-.33156-.0534-.0954-.11408-.18667-.16031-.28575-.05-.13368-.0502-.27151-.0264-.41166.0312-.20366.0779-.40434.17193-.58934.0733-.15154.15563-.29804.24008-.44366-.0505-.0406.0452-.15945.0957-.11888z"
          S.path ! A.d "M99.736 688.54c.0657.0671.11824.14554.16939.22385.0725.12222.11511.25854.15546.39388.0476.15045.0851.30361.11766.45792.0284.14393.0344.29065.0392.43685.007.16102-.006.32113-.0239.48092-.0215.15831-.057.314-.0952.46897-.028.11491-.0656.22713-.0937.34202-.0139.0511-.006.0264-.0232.0741.0512.04-.0432.16067-.0944.12061v0c.0174-.045.0101-.0216.0229-.0703.0231-.11176.0588-.22027.0852-.33125.0364-.15442.0733-.30891.0957-.46616.0185-.15857.0334-.31747.0241-.47734-.001-.14708-.002-.29545-.0332-.43988-.0314-.15336-.0756-.30351-.11881-.45384-.0393-.13738-.0801-.2756-.14313-.40428-.0482-.0807-.11101-.15117-.16432-.2285-.0541-.034.026-.16162.0802-.12761z"
          S.path ! A.d "M129.99 664.25c.0209-.0347.0401-.0706.0628-.10413.009-.0131-.0142.0281-.0208.0424-.0324.0695-.0527.1306-.0684.2055-.0149.0974-.022.19761-.003.29497.004.018.009.0356.0138.0533.0305.0943.0917.17052.16373.23633.0806.0663.17491.11317.26386.16713.0985.0605.19747.11986.29958.17398.15641.0741.31946.13317.48148.19363.18442.0724.37087.13928.56229.1906.14724.0348.29578.064.44264.10041.0793.021.15734.048.2295.0875.0335.0183.0568.0349.0883.0559.0659.0469.12102.10565.17006.16949.0357.0557.0764.10699.11842.15798.0603.0376-.0285.17974-.0888.14208v0c-.043-.0503-.0783-.10593-.11846-.15837-.051-.0588-.10315-.11659-.17193-.15522-.0275-.0157-.0614-.0356-.0896-.0496-.0729-.0359-.15188-.0588-.23099-.0764-.14941-.0332-.3009-.0549-.45086-.0855-.19573-.0425-.38714-.10166-.57166-.18006-.15907-.0677-.3161-.13999-.46482-.22861-.0994-.0594-.20202-.11307-.29918-.17615-.0895-.0557-.18116-.10905-.26091-.17865-.0756-.0678-.14279-.13543-.17759-.23375-.0116-.04-.0209-.0671-.027-.10846-.0119-.0814-.005-.16362.008-.2443.0101-.0478.0112-.0622.0257-.10788.0377-.11887.10759-.22372.17001-.33042.062.0241.005.17022-.0568.1461z"
          S.path ! A.d "M128.31 663.93c-.10281-.0563-.1953-.13001-.29056-.19806-.0881-.0652-.17882-.12557-.2794-.16955-.0566-.0195-.11419-.0472-.17483-.0522-.0101-.00092-.0201.00018-.0302.00024-.0366.007-.0678.0248-.0959.049-.0116.0101-.0421.0444-.0327.0323.17634-.22785.0789-.0914.0575-.061-.0284.0525-.0583.11986-.0325.18004.005.0107.0124.0196.0186.0294.0102.0101.0196.0206.0305.0295.0458.0376.10145.0634.15456.0887.0456.0217.0918.0424.13763.0637.0227.0106.0453.0209.0679.0318.0363.0173.0846.0418.12175.0584.0537.0241.10875.0449.16284.068.0725.0322.1474.0567.22424.0758.0469.012.0964.0177.14337.003.041-.0259.10545-.10884-.0676.0865-.003.003.005-.007.006-.0112.004-.009.006-.0184.009-.0281.007-.0347-.005-.0685-.0216-.0985-.0176-.0282-.0387-.0535-.0624-.0767-.0304-.0295-.055-.064-.0793-.0986-.0102-.0152-.0222-.0288-.0346-.0424-.0493-.042.0498-.15816.099-.11617v0c.0137.0131.0264.027.0382.0419.0243.0341.05.067.0765.0993.0205.0271.0474.0489.065.0783.0202.0336.0335.0685.0285.10845-.0182.077-.0705.14956-.14323.18344-.0521.0162-.10472.0159-.15772.002-.0804-.0161-.16013-.0357-.23773-.0623-.12415-.0418-.24663-.0886-.36533-.14422-.094-.0458-.20763-.10132-.28028-.17844-.0106-.0113-.0193-.0243-.029-.0364-.007-.0116-.0143-.0227-.0197-.0348-.0275-.0612-.0138-.12647.0154-.18398.0589-.0928.0358-.0603.1661-.2061.0339-.0379.0834-.0588.13286-.0648.0749.001.14761.0219.21834.0455.10394.041.20252.094.29443.15763.0947.068.19125.13861.26372.23091.0505.0416-.0475.16055-.098.11897z"
          S.path ! A.d "M127.35 664.89c.17512.007.34584.057.51267.10703.32302.10126.62629.25394.92374.41344.18871.10736.37711.21704.54802.35152.0837.0678.14683.139.18924.23803.0166.0451.022.0926.0258.14012.0281.02-.0191.0865-.0472.0663v0c-.005-.0457-.0118-.0913-.0259-.13532-.005-.0116-.009-.0237-.0152-.0349-.0404-.0781-.11007-.13402-.17881-.18611-.17916-.12172-.36984-.2245-.5634-.3214-.30112-.15007-.60583-.29314-.91715-.42097-.10153-.0373-.13192-.0501-.23149-.0812-.0717-.0225-.14448-.0394-.21707-.0585-.0128-.003-.0256-.007-.0384-.0107-.0286-.015.007-.0824.0353-.0675z"
          S.path ! A.d "M124.54 665.37c-.0623.0642-.11814.13381-.17227.20492-.0885.11858-.15607.25091-.22281.38256-.0634.14315-.12975.28464-.19821.4255-.11186.23111-.23485.45711-.35302.68501-.11252.21403-.21122.43409-.30068.65861-.0706.17641-.13003.357-.18522.53871-.0605.20927-.12169.4186-.15884.63355-.0105.0606-.0182.12173-.0273.18255-.0289.22588-.0521.45237-.0712.67921.0304.005.0608.0101.0904.017.0171-.27177.0376-.54326.069-.81387.0174-.13211.0244-.20383.0497-.33244.0299-.15259.0757-.30164.11499-.45191.0551-.18496.11831-.3672.19149-.54586.0914-.22653.19276-.44856.30739-.66444.11648-.22418.23641-.44673.34452-.67515.0638-.13576.12354-.27339.18568-.40985.009-.0174.018-.0349.0269-.0524.009-.0178.0201-.0346.0273-.0533.004-.0102-.0224.0374-.0175.0277.0264-.0516.0595-.10001.0936-.14676.0565-.0752.11622-.14763.17763-.2188.03.0121.0588-.0586.0286-.0707zm-1.7186 4.792c-.006.10227-.0128.20458-.0179.30693-.00014.003-.00022.006-.00046.0101.0359-.00009.0691-.0114.10202-.0399.002-.038.003-.0761.004-.11409.002-.0439.005-.0877.008-.13154-.0244-.0122-.0594-.0219-.0958-.0314zm-.0295.70425c-.005.2763-.005.55283.005.82909.003.20068.0266.39954.0613.59686.0254-.006.0491-.0114.0747-.0183-.00091-.005-.002-.0104-.003-.0157-.0386-.22327-.0555-.4489-.0515-.67562-.00091-.23497.003-.46984.0101-.7047-.0325-.001-.0644-.006-.0967-.0116zm.2716 1.945c-.025.006-.0514.0136-.0757.0197.00091.003.001.006.002.008.0393.12632.0826.25125.12573.37629.0395.1156.0737.23271.10649.35034.0371.12628.0655.25483.10071.38165.0116.0531.0326.10235.0564.15078.032.0211.0821-.0544.0502-.0756-.0218-.0498-.0424-.0997-.0528-.15346-.0316-.12786-.0614-.2562-.1002-.38211-.0352-.11732-.0669-.23615-.1065-.35212-.0366-.10767-.0738-.21501-.10648-.32395z"
          S.path ! A.d "M145.12 679.86c.10357.10284.19197.21925.28133.33425.0831.10826.16598.21777.23462.33597.0446.0784.0717.16378.093.2509.0226.0988.0285.20014.0314.30113.003.081.001.16181-.0135.24159-.0101.0566-.029.11078-.0477.16491-.016.0389-.0279.0792-.0408.11924-.001.005-.003.0102-.004.0153.0254.0195-.0206.0794-.046.0599v0c.001-.005.003-.0101.004-.0151.0118-.039.0225-.0785.0381-.11617.018-.0531.0377-.1057.0465-.16136.0146-.0779.0157-.15697.0116-.23594-.004-.10021-.009-.20104-.0305-.29937-.0196-.0871-.0421-.17349-.09-.25002-.074-.11183-.16209-.21363-.24357-.31993-.092-.11709-.18283-.23565-.2652-.35978-.0278-.0175.0135-.083.0413-.0655z"
          S.path ! A.d "M132.4 681.08c-.1778.14823-.36852.28016-.55848.41215-.19686.13283-.40597.24556-.61937.34907-.0881.0427-.18133.0714-.27612.0943-.0309-.0148.004-.0876.0348-.0728v0c.0955-.0273.18977-.0591.27871-.1039.21352-.10721.42373-.22189.62128-.35683.18444-.12848.36902-.25695.54902-.39157.0295.0127-.00023.0823-.0298.0697z"
          S.path ! A.d "M143.5 686.6c.16608.14073.30586.30905.45163.46995.10865.12762.22601.24757.35347.35636.12082.10644.25352.19787.3874.2868.13324.0882.25883.18694.36772.30391.0681.0771.13364.1572.18202.24832.0308.0628.0392.13751-.0394.17834-.062.0152-.12665.0137-.19007.0134-.009-.00016-.0183-.00024-.0275-.00047-.0282-.0145.006-.081.034-.0666v0c.009-.00008.0185-.00015.0278-.00023.0617-.00069.12463.001.18517-.0121.0262-.0179.0234-.0189-.0129.0414-.003.005.004-.0101.005-.0153.002-.0263-.0149-.051-.0239-.0741-.0496-.0888-.11637-.16576-.18431-.24086-.10924-.11562-.23551-.21198-.36766-.3002-.13375-.09-.26624-.18237-.38692-.28966-.12637-.1091-.24817-.22393-.3595-.34846-.14971-.15949-.29038-.32701-.44157-.48509-.0277-.0168.0119-.082.0396-.0652z"
          S.path ! A.d "M115.37 679.5c.34702.0602.69631.0813 1.0479.0832.24664.002.49298-.013.73954-.014.34127.006.68106.0469 1.02.0846.35121.0439.702.0915 1.0546.1232.24846.0161.49446.0538.73878.10052.2469.0554.49742.0902.74807.12325.4444.0507.88957.0936 1.3347.13751.22044.026.44593.0395.65905.10609.0103.005.0211.009.0309.0151.0309.019.0642.0533.0946.0753.0599.0435.067.0467.13243.0894.0864.0594.17765.11427.25427.18667.0357.0337.0405.0437.0692.0821.0525.0886.0717.19067.0993.2886.0202.0931.0544.18186.0865.2713.0135.0356.0262.0715.04.10702.0279.0187-.0161.0843-.044.0657v0c-.0146-.0346-.0282-.0695-.0421-.10442-.0323-.089-.0675-.17706-.0882-.26977-.0276-.0971-.0452-.19883-.0966-.2871-.0102-.0133-.0194-.0276-.0307-.0401-.0821-.0919-.20052-.14254-.29614-.21767-.0734-.0533-.0636-.0436-.12767-.0989-.0245-.0211-.0608-.064-.0897-.0792-.0101-.005-.0208-.008-.0314-.0116-.22566-.0404-.45682-.0342-.68451-.0545-.4434-.0363-.88504-.0875-1.3242-.15888-.24865-.0389-.49577-.0854-.7426-.13444-.24571-.0429-.49234-.0814-.74194-.0921-.35609-.0248-.71175-.0581-1.066-.10251-.33357-.043-.66662-.0996-1.003-.11418-.25022.001-.49942.0242-.74941.0334-.3491.004-.69888-.0117-1.0362-.11078-.0351-.0188.009-.10144.0443-.0826z"
          S.path ! A.d "M125.97 684.55c-.17545.0975-.36222.1729-.54681.25107-.1826.0788-.3734.13582-.5631.19455-.24952.0758-.49966.14984-.75063.22074-.3269.0938-.66147.15667-.99579.21709-.41379.0765-.83344.11034-1.2531.13252-.53489.0265-1.0703-.007-1.603-.0537-.35322-.0323-.70344-.0882-1.0528-.14787-.18632-.0335-.37224-.0717-.55322-.1279-.10969-.0341-.13739-.0474-.24187-.0891-.12977-.0702-.0688-.0333-.18375-.10944-.0363-.0211.0135-.10677.0499-.0857v0c.11706.0703.0553.036.18568.10196.25792.0952.52398.16703.79553.21143.35417.0536.71008.0938 1.0676.1175.53204.0373 1.0651.0656 1.5987.0583.17277-.007.27735-.0101.44873-.0228.26706-.02.53299-.0554.79712-.0991.33038-.0602.663-.11312.98724-.20188.25018-.07.49866-.14586.74856-.2168.18959-.0547.38096-.10619.56005-.19083.1782-.0784.35674-.15606.5367-.23033.0297.0135-.002.0837-.0317.0702z"
          S.path ! A.d "M115.64 683.81c.15605.0323.30997.0739.46378.11537.17702.0391.3494.0923.5183.15765.16487.0705.32741.14597.47965.24092.22162.14156.35728.36999.49568.58629.0884.13162.16764.26888.24687.40611.031.02-.0162.093-.0471.0731v0c-.0853-.13082-.16834-.26299-.25534-.39266-.13709-.21562-.26597-.4525-.48406-.59712-.15217-.0942-.31417-.16925-.47862-.2394-.16842-.0654-.34078-.11653-.51646-.159-.15342-.0399-.3074-.0784-.45931-.12365-.0287-.0156.008-.0831.0367-.0676z"
          S.path ! A.d "M124.66 693.48c.10699.13094.19739.26593.31374.38992.13495.12356.2746.24128.40313.37169.1176.11719.22161.2466.31832.38126.0852.126.17475.25633.21036.40626-.001.0745-.0399.12076-.11555.15849-.0331.0165-.0729.0127-.10967.0157-.11649.009-.187.004-.30526.00024-.21174-.0112-.42389-.0241-.63337-.0581-.0323-.017.008-.0932.0401-.0762v0c.21311.0201.42721.0263.64064.0423.10607.005.19326.0122.29879.009.0346-.00091.0705-.0181.10349-.008.0154.005.003.0378.0169.0452.0199.0102.0189-.0716.0192-.0642-.04-.14574-.13233-.27119-.21297-.39673-.0956-.13531-.1979-.26598-.31558-.38299-.12914-.12986-.27514-.2399-.40524-.36871-.11561-.12396-.21371-.2606-.30708-.4019-.027-.017.013-.0808.0402-.0637z"
          S.path ! A.d "M117.12 700.27c.0849.13127.18321.25276.29337.36339.10144.0963.21161.18244.31773.2733.0675.0606.1431.10935.22003.15665.0998.056.20758.0956.31103.14435.0807.0317.15896.0674.2345.10971.0479.0308.0799.0476.0635.10861-.0467.0942-.0863.14514-.18239.18253-.0899.0256-.18474.0258-.27747.025-.1883-.003-.37561-.026-.56226-.0494-.14508-.0217-.29095-.0374-.43619-.0577-.0345-.0181.008-.0995.0427-.0814v0c.14707.0146.29368.0326.44045.0498.18482.0228.36945.0501.55547.0605.0901.004.18312.008.27043-.0183.0416-.0172.0782-.0376.10839-.0718.006-.007.0201-.032.0177-.0227-.004.0158-.0154.0288-.0231.0432.0236-.0611-.007-.0691-.0563-.10011-.077-.0398-.15716-.0715-.23771-.10302-.10453-.047-.21202-.0885-.31106-.14663-.0755-.0498-.1512-.0991-.22152-.1561-.10973-.0863-.22175-.16995-.32311-.26617-.11233-.11264-.2212-.23315-.28658-.38011-.027-.018.0155-.0815.0424-.0635z"
          S.path ! A.d "M110.06 691.99c-.12427.14809-.24748.29663-.36211.45239-.0353.054-.0751.10558-.10616.16231-.006.0116.008-.036.021-.0338.0126.002-.0113.023-.0167.0345-.005.0109-.0101.022-.015.0331-.0368.11032-.0735.22076-.10968.33136-.0434.12497-.0809.25185-.10756.38145-.0171.0718-.0133.12758.0162.19468.0588.11658.18101.17318.29257.22797.0312.0136.0625.0272.0938.0408.037.0208-.0121.10798-.0491.0872v0c-.0312-.0142-.0622-.0284-.0934-.0426-.11266-.0614-.2288-.12725-.28806-.24684-.0275-.064-.0368-.12646-.0216-.19544.022-.12798.057-.2531.10126-.37513.0379-.11389.0775-.22724.11606-.34088.0546-.12353.12571-.23869.2024-.34963.10984-.15131.22733-.29664.35536-.43307.0304.0124.001.0842-.0293.0718z"
          S.path ! A.d "M106.8 681.67c-.0101.0128-.0202.0255-.0299.0386-.0427.0581-.0825.11803-.12064.17911-.0469.0752-.0561.0861-.0312.054-.0585.11237-.10436.23005-.13718.35222-.0265.11822-.0423.23868-.0519.35938-.014.13254-.0215.26559-.0266.39874-.0107.12999.003.25788.0258.38571.0242.13042.063.25741.1004.3845.0275.0959.0646.18835.10435.27965.0455.10976.10274.21366.16324.31572.0634.11301.14772.21001.23548.30429.0339.0209-.0155.10071-.0494.0798v0c-.0884-.0951-.17136-.19455-.23551-.30801-.0609-.10378-.11361-.21161-.15998-.32269-.0385-.0913-.0796-.18197-.10687-.27755-.0396-.12573-.08-.25162-.10386-.38148-.0216-.12864-.0351-.25785-.026-.38851.004-.13339.0114-.26664.0265-.39931.0101-.12145.0254-.24268.0518-.36177.0324-.12066.0747-.23798.13217-.34917.0799-.14286.15913-.28947.26833-.41273.0295.0123.00045.0818-.029.0696z"
          S.path ! A.d "M98.819 683.21c-.0482.0855-.12533.24369-.18539.37314-.0946.20887-.1722.42517-.24365.6429-.0648.22055-.096.448-.11259.67661-.0152.2562.004.51246.0382.76633.0393.23667.1128.46514.21497.68176.11974.18905.28447.34421.44984.49296.10879.0963.21773.19254.33382.27998.0545.0398.10955.0786.16651.11476.0301.0175-.0111.0885-.0413.071v0c-.0585-.0341-.11447-.0719-.1697-.11093-.11649-.0863-.22996-.17639-.34067-.26993-.1698-.14588-.33946-.29952-.45351-.4946-.10634-.21389-.1857-.43969-.22248-.67655-.0361-.25573-.0553-.5144-.0364-.77259.016-.22863.0441-.45644.10965-.67691.0712-.21883.1486-.43629.24434-.64575.0833-.17899.17133-.35604.27619-.52362.0303.0118.002.0833-.0279.0715z"
          S.path ! A.d "M101.95 692.07c.0605.2213.0825.45136.1123.67833.0229.18447.0427.36989.0399.55606-.001.0749-.006.13184-.0117.20581-.0125.13901-.0568.26924-.11748.3938-.053.0994-.10955.1985-.18992.27851-.0475.0472-.0609.0544-.11476.095-.0931.0654-.19293.12098-.29468.17169-.0332-.015.002-.0931.0352-.0782v0c.10116-.0547.20141-.11188.29573-.17779.0493-.0373.0686-.0493.11191-.0926.0152-.0152.0292-.0314.0428-.0478.0134-.0162.0228-.0358.0381-.05.006-.005-.0132.0296-.009.0229.0116-.0169.0199-.0358.0298-.0537.0601-.12088.10388-.24726.11382-.38306.004-.071.008-.12693.008-.19872-.00045-.18379-.0231-.36648-.0435-.54883-.0302-.23639-.0557-.47338-.0896-.7093-.0263-.0183.0167-.0804.0431-.0621z"
          S.g
            ! A.strokeWidth "0.05"
            $ do
              S.path ! A.d "M123.89 663.04c.16874.10723.56534.4021.64007.62483"
              S.path ! A.d "M123.63 663.69c.38595.32106.42221.33571.45754.42762"
              S.path ! A.d "M123.32 664.17c.25707.23436.41744.45561.41744.45561"
              S.path ! A.d "M122.89 664.82c.2707.21193.43171.45931.43171.45931"
              S.path ! A.d "M122.45 665.12c.29748.18059.54302.60207.54302.60207"
              S.path ! A.d "M122.01 665.39c.27637.152.81763.73002.81763.73002"
              S.path ! A.d "M121.71 665.85c.39071.2867.90587.77632.90587.77632"
              S.path ! A.d "M121.05 666.33c.391.0756 1.4168.55432 1.4512.68083"
              S.path ! A.d "M120.82 666.86c.57177.058 1.5797.53534 1.5797.53534"
              S.path ! A.d "M120.74 667.42c.49861.0433 1.6354.25256 1.6354.25256"
              S.path ! A.d "M120.7 668.2c.56297-.0183 1.5002.13591 1.5002.13591"
              S.path ! A.d "M120.47 668.77c.50093-.0261 1.6478.0704 1.6478.0704"
              S.path ! A.d "M120.43 669.32c.72978-.0604 1.6161-.0846 1.6161-.0846"
              S.path ! A.d "M120.39 669.97c.53888-.22425 1.5973-.22381 1.5973-.22381"
              S.path ! A.d "M121.2 671.15c.41739-.0648.60901-.0923.74157-.0636"
              S.path ! A.d "M121.22 671.66c.31399-.16474.7597-.19242.79671-.1853"
              S.path ! A.d "M120.72 672.57c.10884-.0285.20784-.0705.20784-.0705"
              S.path ! A.d "M121.55 672.24c.23606-.0893.56799-.15528.56799-.15528"
              S.path ! A.d "M121.25 671.89c.18238-.071.81974-.15796.81974-.15796"
              S.path ! A.d "M120.93 672.93c.22707-.12759.41699-.10081.41699-.10081"
              S.path ! A.d "M121.06 673.49c.28561-.10164 1.2421-.25569 1.2421-.25569"
              S.path ! A.d "M121.12 674.07c.6245-.24481 1.3132-.3184 1.3132-.3184"
              S.path ! A.d "M121.09 674.59c.38095-.20151 1.3789-.51775 1.3789-.51775"
              S.path ! A.d "M121.15 675.15c.27577-.12785.98762-.57948 1.3706-.54386"
          S.g
            ! A.strokeWidth "0.3"
            $ do
              S.path ! A.d "M131.29 667.94c.20144.0637.39463.10828.57474.14036.78887.14056 1.0517.25686 1.3736.29038.28373.0295.43869-.59719.23222-.69261-.64985-.3003-.81071-.61735-.94185-.91858.76647-.14512 1.4573.30512 1.6282.16555.1709-.13956.48156-.45894.20536-.97315-.18321-.34114-.73305-.33328-1.0125-.44967-.50728-.21124-2.7622-1.1645-3.1987-1.5946-.43647-.43013-1.5233-.64562-2.0081-.66757-.78564-.40483-1.1074-.48841-1.2456-.58434-.16175-.5491-.64252-1.1895-.74721-1.5083v0c-.54212.72155-.42433 1.6447-.78881 1.9651-.97928.44772-2.3714 2.4838-2.5991 3.1494-.16191.4734-.57509 1.946-.73906 3.3652m-.0679 1.135c.00091.17228.007.33963.0235.49713.0296.14134.10506.57524.18427 1.0237m6.2049-2.7148c-.26541-.25915-.50506-.45254-.67823-.50619.0867-.66411.21656-.9972.21656-1.43 1.0931-.007 1.8482-.28161 2.0814-.4783.21241.20486.41358.3496.60846.46677m-8.2853 5.47c.0773.4137.15087.78294.19805.93124.12998.40861.0541 1.0257-.73468 1.4103-.17364.0847-.67459.24433-1.3087.434 1.1009.24544 2.2887.64482 2.5548.76733.40268.18537 1.2031.43625 1.553.51769.34989.0814.58172.16484.77942.69306.19769.52822 1.0893 2.6544 1.225 2.906.43291.52566 2.1139 2.885 2.3973 3.4336.0797.15424.15582.32675.23311.50514.50616-.12624.93693-.25412 1.1928-.37718 1.739-.22749 3.6452-.76114 4.2779-1.0631.63262-.30197 1.5512-.10842 1.9539.0183.64574.058.85988-.11612 1.4792.26801.6193.38412 2.0155 1.359 2.3347 2.0949.25835.40946.58481.8748.80223.85593.21744-.0189.75544-.21878 1.0506.19686.16406.50404.008 1.0874-.0349 1.2143.44107.22464 1.8249.40555 2.5316.72035.70669.31483 1.1859.3481.91544-.0873-.27045-.43535-2.089-2.271-2.3839-2.5092-.54789-.65795-3.4023-3.2606-3.9794-3.9535-.5771-.6929-1.259-.9499-2.3128-1.102-1.0538-.1521-2.7705-.0819-2.7705-.0819-.11004-.22467-.0812-.43786.10962-.6264.72519-.64056 1.6368-2.0537 1.9034-2.4958.55958-.52754 1.3362-.84183 1.7919-.7736.45577.0683 3.31 1.3357 3.5486 1.702.2386.36633.39448.71001.63937.66174.24489-.0483.5252.0661.84161.0936.23858.40889.18703.71947.18703.71947-.28246.36867-.3235.66928-.006.81387.31767.14458.70083.11479 1.3324.39418.6316.2794 1.0601.52119 1.3002.61924-.0174-.33273.17828-1.2081-.25862-1.851-.43691-.64288-.94995-1.6086-1.8434-2.1611-.89347-.55245-4.3924-2.3894-4.7257-2.6282-.64642-.34007-1.7137-.25174-2.4524-.13736-1.0796.34624-2.4503 1.8218-3.4743 1.9781-.26642-1.2752-.99614-1.8801-1.5414-2.1517-.1915-1.285-1.5572-3.5224-2.6922-4.87m-14.589 7.4409c-.43626.1299-.79103.24046-.90649.29397-1.0359.16772-2.5643.51726-3.9785 1.1521l3.5128 3.43.17763 1.2152-1.1857-.28009-3.6497-3.7678c-1.0106.62576-1.8494 1.4452-2.23 2.5137-.61503.313-2.0681.63348-4.1298-.35302-1.3843-.59474-4.0844.27841-4.3342 2.7042-.20306 1.8197 1.0916 3.1878 1.74 3.8313.64845.64347.35259 1.5265.0564 1.9481-.29622.45205-.53849 1.9611-.0734 2.485.46512.5239 1.0161 1.0736.8877 1.7615-.23761 1.0782.002 1.691.5414 1.051.53967-.64002 1.1152-.93403 1.57-1.2134.45481-.27941.46101-1.5675.10381-2.1016-.20531-.66332-.0318-.60377-.18926-.99508 1.0819-.92197 1.8284-1.6269.9745-2.6841-.85393-1.0572-2.8651-2.7504-2.9673-3.1647-.17086-.61605-.1162-1.8686.80984-2.1459.55302-.19133 1.5109-.0569 2.2108.30648.69989.36346 2.4536.34825 2.7803.15214.9532 1.7791 2.3274 3.1032 3.0282 3.7351.7008.63191 1.3813.93216 1.5333 1.1427.15206.21057.27748.61139-.0725 1.2242s-1.2693 2.5405-1.6009 2.8765c-.33157.33604-.25697.9101.0166 1.0125.2735.10244 1.839 1.696 2.3517 2.1848.51272.48876 2.2508 2.7081 2.4049 3.196.15416.4879.61314 1.0792 1.1235 1.0219.51034-.0572.76598.38427.74853.58926-.0665.55679-.1174.79126-.24608 1.0349.78597-.004 1.5748-.009 2.3486-.009.53071-.00022 1.0514.003 1.5763.004-.48284-.49484-1.0922-.87354-1.4175-1.6219-1.0063-.84595-2.0205-1.6412-2.2756-2.0358-.34409-.73811-2.8837-3.1903-3.3387-3.5852-.9912-.93216-.96306-1.9141-.20223-2.7803 1.1133-.65393 1.6146-.92964 1.8376-1.1821.1643.60852.2592 1.1847.0224 2.0242-.2368.8395.10081 1.5217.73782 1.5584.63701.0367 1.4862.15526 1.8103.098.32409-.0572.32694-.26314.90381-.28636.57686-.0233 3.3785.20662 3.66.31141.58319.23149 1.1086.1693 1.5365-.13602.44271.003.82193.54973.78793 1.1969.27618.008 3.0868.0729 3.0868.0729-.10144-.27671-.38745-.57934-.57988-.88547-.30636-.48739-.40227-.75169-.88545-1.0148-.67377-.36684-1.2404-.90623-1.6904-.97807-.19139-.0306-1.497-.0744-2.1539-.0917-.65694-.0174-3.2791-.0246-3.6322-.33244-.35308-.30789-.37574-.90448.13646-1.5772.48884-.25361 2.2494-2.5508 2.4783-4.2063.95321-.13207 3.8562-.51242 4.8528-.74631.40285-.0946 1.3249-.26278 2.2098-.434-.0196-.0255-.0386-.0544-.0587-.077-.35493-.40126-2.0413-1.393-2.3472-2.1025-.30587-.70947-1.1423-2.6502-1.5651-2.9812-.42278-.33099-1.4-.68715-2.6958-.50469-.39054-.0744-1.345-.0949-2.3844-.42194-.56391-.16343-1.9223-.0989-2.3884-.37986-.44914-.26091-1.3547-.5721-1.3781-1.0523z"
              S.path ! A.d "M122.02 669.64c.16293-1.4235.58003-2.9044.74247-3.3794.21702-.63447 1.4885-2.4985 2.4555-3.0608-.30645-.26716-.64481-.52499-.82371-.55974-.0254-.005-.0553-.008-.0877-.009l.00004.00001c-.22709-.009-.58369.077-.46488.36062-.0846.008-.21149.0394-.3217.0832-.0334.0602-.0863.10309-.17943.10469-.0392.0393-.0538.0816-.0175.12439.12568.14784.22046.32097.30424.36196-.18388-.0892-.35294-.10454-.48277-.0882-.0254.16058-.0416.276-.0609.40135.0652.0653.13625.12699.20314.16331-.081-.0336-.15219-.0524-.2179-.0649-.0111.0752-.0383.23961-.0417.27517-.0197.21535-.34631.0683-.49352.0206-.0963-.0312-.15995.0675-.18926.16465.15037.15802.34634.20462.50291.2792-.2056-.0807-.38688-.10985-.52125-.10784-.002.0935-.0384.16385-.1481.18123.00023.005-.002.007-.002.012.14027.11969.23671.16502.29397.18882-.1381-.0422-.25846-.053-.35527-.0439-.0388.0298-.0884.041-.12751.0371-.0411.0394-.0694.11543-.0958.19822.0237.0361.0646.0723.12662.10604-.0542-.0168-.10527-.0244-.15302-.026-.0309.10589-.061.21625-.10738.29038-.0239.0381-.0565.0669-.0954.0832.0224.0206.0472.0413.0783.0613-.41942-.11693-.911.2836-.69038.48993-.16819.0114-.47174.49398-.19822.51902-.2349.17507-.46314.43044-.0976.58746-.4004.064-.55142.70152-.0354.76153-.26421.22187-.56085.51292-.24116.61075-.16613.15915-.20448.47698-.0349.53512-.16124.13389-.36963.58303-.0188.63221-.0986.0659-.16718.29881-.10927.45543m.72856.37546c.006.00069.0156.00069.021.001.2116.0156.13237.25674.0577.29039.0869.021.11519.26497.0152.30871.0872.0356.10324.285.0323.31366.0624.073.0798.16978.0314.23624m.96382.37543c-.0823-.46493-.15523-.88478-.1862-1.0322-.0165-.16041-.0241-.33003-.0252-.50531m-1.5046 1.2364c.035.0226.0854.0417.14588.0591-.009-.0173-.0183-.0353-.0273-.0533-.0397-.002-.0792-.003-.11857-.006zm.15973.0864v-.00001c-.13656.22011-.20918.51846.12932.47965-.26807.17177-.12276.42526.17987.36779-.11023.27573-.27465.57992.11766.55391-.42471.28116-.35135.59735.086.59687-.24001.18318-.43381.4791-.0497.48859-.16297.26243-.17852.56522.13468.58703-.18298.1788-.28134.22436-.12886.30291.0756.0389.21486.0783.35748.10336.13369-.0464.27808-.0951.33916-.12484.7888-.38463.86466-1.0017.73467-1.4103-.0474-.14916-.12164-.52182-.19939-.93842"
              S.path ! A.d "M131.41 666.79c-.0729.10538-.86706 1.2101-1.3208 1.5691-.58488.46285-1.4308 1.2492-2.4273 1.813-.76664.4337-2.2441 1.2661-2.9906 1.5217-.50734.17369-2.068.80207-2.6819.7208-.35062-.0464-.5997-.26246-.78345-.49173-.0225.0304-.0594.0543-.11275.0662-.0626.014-.28796.0249-.52081.0144.4096.8187 1.2518.9531 1.6192.96466.43287.0137 1.7684-.37285 3.0358-.86577 1.2514-.48671 3.4973-1.8649 4.3656-2.5472.86827-.68236 1.8759-1.9776 2.336-2.5978m-9.5459 2.7799c-.50513.0101-1.2135.10223-1.5758.32215-.32496.20344-.46249.44954-.49397.72708.24805-.0245.57682-.0336.73468-.0161.0467-.059.10733-.1151.18434-.14765.2563-.10834.93394.0553 1.2327.1557.29876.1004.71143.25865.9745-.26801.22327-.447-.19154-.6985-.63938-.75704-.10281-.0135-.24863-.0193-.417-.0161zm-.25682.37854c.73391-.008.98135.0765.82864.27885-.15434.20458-.26834.005-.67472-.065-.40639-.0706-1.1247-.0549-1.3208.072-.21303.15223-.18493.027.0962-.11633.3473-.12085.73331-.16358 1.0707-.16957z"
          S.path ! A.d "M99.866 670.12c.09719.0185.18185.0745.26113.13114.0734.0583.14617.11674.21505.18025.0786.0758.15038.15729.2135.24632.0387.0627.0821.12225.12322.18336.0449.0575.081.12109.1177.18396.0237.0324.0475.0772.0897.0883.009.002.0182.003.0273.004.0121-.00046.0242.00014.0362-.002.0256-.004.10265-.0236.12312-.0289.0861-.0223.17164-.0463.25713-.0707.23201-.0631.4645-.12443.69591-.18975.0713-.0223.14211-.046.21377-.067.0783-.0229.15734-.0432.23601-.0648.08-.0213.16041-.0408.23985-.0639.0833-.0243.16546-.0521.24817-.0783.29963-.0947.16266-.0492.44758-.14888.35168-.1408.6985-.29321 1.0509-.43221.0534-.0197.1066-.0399.16015-.0592.11909-.0428.18815-.0668.30815-.10214.12255-.0361.2471-.0643.37108-.0949.11509-.0299.23085-.0573.3457-.0882.0429-.0116.0854-.0247.12839-.0358.0974-.0251.14655-.0339.24392-.0538.19873-.0413.39954-.0701.60168-.0877.15732-.0114.31468.004.47192.009.11045.006.2204.0167.331.0192.0569-.004.11375-.007.17078-.006.0164.001.0327.00023.049.00018.0737.0356-.0101.20932-.0838.17376v0c-.0186.007-.038.008-.0575.0109-.0605.0104-.12097.0213-.18211.0268-.11699.0114-.23407.0259-.35189.0172-.15874-.008-.31832-.0169-.47614.009-.20716.0263-.41213.0668-.61385.12104-.0844.0216-.16193.0421-.24699.0613-.15695.0355-.31482.0676-.46874.11543-.18269.0583-.36141.12649-.54127.19293-.0533.0197-.10692.0383-.16003.0584-.0539.0204-.10738.042-.16106.063-.16811.0696-.33448.1425-.49896.22039-.11775.0558-.25414.12591-.37196.18015-.0692.0318-.13934.0614-.20902.0921-.0743.0301-.14783.0624-.22302.0903-.18232.0676-.29461.10013-.48341.14646-.2122.0521-.42753.0933-.64636.1025-.11183.014-.16091.0188-.26864.0371-.13294.0226-.2635.0562-.39449.0878-.12879.0281-.26288.0625-.39414.0298-.057-.0204-.0979-.0464-.13318-.0972-.042-.0592-.0818-.12003-.11857-.18265-.037-.0607-.0839-.11396-.1315-.16649-.0698-.0819-.13962-.1637-.21108-.24407-.064-.0668-.13179-.12988-.21159-.17781-.04304-.0283-.0867-.0554-.1306-.0823-.0214-.0131-.0614-.0368-.08159-.0527-.0097-.008-.01787-.0169-.02681-.0254-.0759-.0425.02435-.22143.10025-.1789z"
          S.path ! A.d "M109.99 663.76c.0177-.00001.0354-.00092.0531-.00004.0235.001.0469.005.0704.007.0916.008.18521.0179.27735.0142.0338-.001.0673-.006.101-.009.18262-.0189.36193-.0586.54421-.0801.10905-.0108.21901-.0143.32698-.034.0396-.007.0206-.004.0572-.009.0826.0396-.0107.23426-.0933.19467v0c-.04.0133-.0191.006-.0626.0207-.11512.0344-.23153.0623-.35083.0783-.1848.0357-.36875.0774-.55608.0979-.0337.001-.0673.003-.10104.003-.11222-.001-.22739-.0196-.32753-.0731-.014-.007-.0263-.0179-.0395-.0268-.0776-.0428.0232-.2256.10076-.18285z"
          S.path ! A.d "M111.67 664.05c.0187-.004.0373-.009.0562-.0123.0344-.005.12253-.0108.15489-.0131.0882-.006.17641-.0107.26468-.0156.16126-.004.32196-.0186.48299-.0272.20302-.008.4048.0121.60524.0421.12458.0225.24825.0497.37277.0725.053.006.10506.0164.15653.0302.0781.0411-.0187.22507-.0968.18401v0c-.0568-.00046-.11373.003-.17032-.004-.13321-.01-.26681-.013-.40019-.0196-.19831-.0161-.39548-.0455-.59428-.0546-.0276-.00022-.0553-.001-.0829-.00069-.13408.002-.26697.0237-.40072.0314-.0873.006-.17452.011-.2621.006-.0417-.002-.0985-.007-.13978-.0188-.0145-.004-.0279-.0114-.0419-.0171-.078-.0406.0176-.22434.0956-.18379z"
          S.path ! A.d "M104.5 665.33c.13004-.0302.26143-.0515.39391-.0677.13796-.0135.27638-.0184.41492-.0192.098-.002.19595.007.29369.0135.11497.003.22981.0107.34391.0253.0127.003.0255.005.0382.008.087.0449-.0189.24991-.10584.205v0c-.0146.001-.0293.002-.0439.003-.11527.00069-.22932-.0112-.34327-.028-.0978-.0104-.19577-.0154-.29397-.005-.14322.0151-.28549.0382-.42907.05-.11895.009-.24329.0263-.36034-.004-.0764-.0389.0154-.21903.0918-.18009z"
          S.path ! A.d "M101.87 667.21c.0733-.002.14523.0205.21406.0437.0597.0229.11507.0548.17148.0845.0749.0381.14937.0768.22649.11014.11254.0488.22802.0908.3448.12826.14812.0476.28911.11294.42908.18013.1084.0526.21862.10264.32058.16717.0607.0354.1134.0814.16562.12776.0398.0378.0795.0757.11899.11384.0303.0315.0393.011.068-.0119.0379-.0348.079-.0655.12231-.0932.10517-.0734.21805-.13469.33133-.1944.20579-.10117.4269-.16663.64398-.23875.24211-.0793.4921-.13024.74108-.1824.21952-.0422.43763-.0929.65911-.12434.0514-.007.103-.0124.1545-.0186.24873-.0259.49903-.0278.74863-.0391.19179-.009.38373-.0157.57499-.0331.18431-.0201.36668-.0564.54714-.0984.13602-.0343.27268-.0652.41004-.0936.13678-.0278.27237-.0608.40812-.0931.14581-.0344.28943-.0764.43291-.11921.0924-.0269.1837-.0575.27687-.0817.0602-.0169.12233-.0267.1843-.0349.0323-.005.0609-.0212.0912-.0324.0317-.0138.0658-.0206.0992-.0289.0781.0369-.009.22111-.0871.18417v0c-.0328.0118-.0661.0213-.0996.0308-.0324.009-.063.0234-.0946.0348-.0636.0196-.12781.0367-.192.0542-.0984.0318-.19213.0755-.28944.1103-.14378.0517-.28922.0988-.43967.12729-.13389.0278-.26919.0485-.40217.0806-.1417.0335-.28162.0723-.42032.11676-.18236.0494-.36732.0904-.55611.1055-.19409.0119-.3879.0264-.58141.0456-.25761.0251-.51469.0547-.7714.0878-.26399.0275-.52967.0466-.78971.10233-.0371.009-.0744.0168-.11132.0264-.21335.0551-.42169.12927-.63732.17606-.041.009-.0824.0178-.12313.0283-.16742.0433-.32994.10265-.49242.16122-.10406.0423-.20569.0902-.30513.14244-.0405.0229-.0779.0494-.11448.0782-.0312.0177-.061.0232-.0941.005-.0465-.0303-.0834-.071-.12243-.10999-.0117-.01-.0292-.0256-.042-.0342-.0413-.0276-.0888-.0453-.13282-.0677-.10969-.0493-.21799-.10168-.32839-.14941-.14409-.058-.29275-.10428-.43405-.1693-.10978-.0528-.22023-.10402-.32671-.16339-.0756-.0378-.15467-.0694-.22413-.11841-.0312-.0198-.0294-.0183-.059-.0385-.008-.006-.0163-.0125-.0252-.0176-.0248-.0139-.0541-.0202-.081-.028-.0688-.0155-.1408-.0272-.20305-.0618-.0753-.0405.0202-.21797.0955-.17746z"
          S.path ! A.d "M105.16 664.9c.0538-.0633.11539-.11949.17957-.1721.0548-.0486.11665-.0876.18025-.12338.0566-.0341.11755-.0571.18006-.0773.0652-.0196.13269-.0227.20025-.0223.0704.001.13862.0177.2033.0448.0649.0266.12363.0663.17813.11003.0539.0461.10478.0957.15578.14494.0794.066.14908.14243.21294.2233.071.0942.12868.19755.18964.29834.0417.0753.0941.14325.15133.20721.0535.0612.1158.1131.1774.16569.0878.0716.16187.1563.23467.24245.0535.0615.10033.12831.14717.19487.0333.045.0675.0892.10078.13427.0275.0352.0557.0697.0814.10633.029.0317.046.0718.0733.10473.002.00045.005.003.007.002.011-.007.0331-.0497.0391-.0593.0386-.0612.008-.0117.0517-.0834.0703-.10891.16016-.2049.26582-.28033.0744-.0531.11678-.0713.19845-.11374.2769-.12307.57876-.16988.87528-.22034.26416-.044.52963-.0796.79402-.12204.1381-.0207.27502-.0492.41338-.0683.0624-.009.12855-.0146.19129-.0209.14242-.014.28544-.021.42776-.0358.11162-.0124.22361-.0222.33577-.0278.0881-.007.17664-.009.26477-.0159.0761-.005.15166-.0154.2266-.0293.0414-.009.083-.0137.12518-.0157.082.0406-.0136.23391-.0957.19333v0c-.0425.008-.0852.0144-.12733.024-.0767.0161-.15427.0294-.23246.0351-.0902.007-.18025.0136-.26991.0258-.11334.0103-.2261.0254-.33921.0379-.14835.0224-.29628.0473-.44453.0704-.20369.0353-.40902.0615-.61104.10603-.2747.0629-.5465.14014-.82535.18357-.318.0472-.0168.004-.32746.0453-.17419.0233-.34961.0477-.51088.12212-.0331.0166-.0672.0314-.0994.0497-.1246.0709-.23595.16576-.3222.28029-.0167.0238-.0483.0802-.078.091-.0133.005-.0228.001-.0358-.001-.0394-.0233-.0567-.0655-.0814-.1022-.008-.0113-.0148-.0232-.0232-.034-.0183-.0236-.0421-.0429-.0602-.0668-.0355-.0425-.0686-.0869-.10302-.13035-.0526-.0579-.10719-.11383-.16013-.17143-.0783-.0808-.15591-.16229-.22899-.24794-.0572-.0589-.11651-.11546-.1756-.1724-.0572-.0633-.11149-.12893-.16082-.19859-.0686-.0938-.12853-.19276-.19381-.28874-.0345-.0465-.0671-.095-.10373-.13991-.0194-.0238-.0435-.0478-.0639-.0708-.01-.011-.0191-.0223-.0286-.0335-.0489-.0505-.0975-.10134-.15201-.14599-.0536-.0411-.10908-.081-.16983-.11088-.065-.0214-.1313-.0317-.19962-.0361-.0649-.003-.1293.00092-.19153.0213-.0624.0194-.12009.0501-.17691.0821-.0635.0382-.12375.0812-.17909.13069-.0564.0496-.1089.10404-.16892.14918-.0798-.0334-.00091-.22142.0787-.18801z"
          S.path ! A.d "M101.87 668.77c.0181.13206-.0125.26414-.0443.39157-.0456.16134-.11642.31397-.19345.4624-.14891.25677-.0859.1708-.16405.27454-.0901-.0353-.007-.24761.0833-.21228v0c.0566-.0909.0298-.0488-.0734.13054.0647-.13642.12193-.27686.16789-.42071.0421-.15263.0774-.30699.10324-.46325-.0691-.0513.0518-.21408.12083-.16281z"
          S.path ! A.d "M97.027 675.04c.11209-.0344.23093-.0318.34696-.0313.15042-.009.29989.007.44854.0276.15239.029.30598.0504.45801.0813.19536.0445.39132.0866.58574.13517.13744.0396.27884.0743.40797.13757.0181.009.03533.0194.05299.029.07562.0403.1348.0992.19038.16288.03616.0465.08347.0822.12549.12307.041.0367.07673.0786.11575.11722.035.0361.06444.0765.09651.11502.02388.0289.04323.0611.0645.092.0032.005.0052.0102.0095.0137.0026.002.0066.001.0099.002.05823-.0473.09972-.11163.14522-.17032.0558-.072.0653-.0821.12416-.15272.1729-.21713.39593-.38281.61706-.547.34096-.26302.6908-.51404 1.0441-.76012.18346-.12518.35825-.25616.5208-.40755.11576-.11318.22543-.23253.33466-.35199.0951-.10652.19469-.20873.29904-.30621.15061-.13394.31082-.25652.46876-.38158.20742-.16789.41664-.33352.62681-.49796.0405-.0305.0807-.0613.12139-.0915.10602-.0788.15956-.1189.27112-.19052.12806-.0822.26124-.15433.3961-.22451.19003-.0941.38387-.18032.57719-.26741.16047-.0747.32722-.13443.49533-.18923.1062-.0306.20057-.0846.29045-.14731.0399-.0298.0808-.0583.11917-.0902.0281-.0244.0619-.0402.0942-.0582.0778.0344-.003.21772-.0812.18329v0c-.0314.0203-.0634.0399-.0926.0632-.0447.0397-.0865.0828-.13365.11976-.0951.0731-.19541.12682-.30768.16946-.16781.0742-.33395.15258-.50609.21653-.0602.0277-.11619.0526-.1751.083-.14442.0745-.28197.16158-.4244.23962-.0783.0452-.18924.10842-.26564.15584-.17514.10871-.34615.22447-.51426.34369-.0362.0266-.0728.0526-.10844.0799-.17139.13105-.33498.27227-.51006.39855-.14914.10718-.30287.209-.44272.32835-.10583.10091-.20521.2079-.30167.3178-.11228.12309-.22494.24602-.34195.36462-.17959.17564-.37105.33838-.56383.49928-.33321.27207-.67156.53995-1.0444.75674-.0606.0393-.19868.12793-.26145.17154-.0332.0231-.0667.0458-.0979.0715-.0796.0656-.14465.14669-.21388.22239-.0395.046-.0772.0935-.11839.13788-.0287.0309-.06849.0749-.11246.0864-.0076.002-.01572.00092-.02358.002-.0065-.002-.01329-.003-.01949-.006-.03731-.0165-.06145-.0637-.08643-.0932-.02637-.0427-.05003-.0873-.08816-.12097-.03967-.0371-.08321-.0702-.11947-.11101-.04281-.0403-.08629-.0798-.12846-.12077-.0086-.009-.03715-.0381-.04627-.046-.04411-.0378-.0981-.0633-.1515-.0847-.15838-.0494-.32077-.0827-.48291-.11708-.0348-.008-.06979-.0153-.1044-.0241-.15763-.0401-.31096-.0962-.47005-.13102-.14838-.0361-.296-.0775-.4482-.0945-.14631-.0174-.29363-.0231-.44032-.0367-.10724-.002-.21661.0109-.32214-.0127-.0778-.0388.01354-.22212.09132-.18337z"
          S.path ! A.d "M122.18 664.29c.0469.0217.15002-.002.20043.0105.0436.0121.0149.11489-.0287.10272-.0535.002-.10652-.002-.15882-.0148-.0174-.004-.0349-.008-.0521-.0129-.0836-.0236-.1671-.0578-.23086-.11848-.0424-.0134-.0364-.0611.0364-.0505.0727.0105.13917.0435.23368.0832z"
          S.path ! A.d "M119.96 665.1c-.0755.0491-.1574.0863-.23674.12822-.0863.0507-.16734.1096-.2389.17944-.0718.0717-.13544.15061-.19528.23238-.0779.10227-.14859.20976-.21309.32089-.0101.0185-.0477.0655-.0293.0556.0194-.0104.0119-.05.0327-.0575.0183-.007-.0157.0356-.0225.0538-.0211.0562-.032.1141-.0434.1728-.022.12447.10143.46714.10092.59315.002.0778.0986.25755.11628.33387.003.005.005.0109.008.0164.0374.0224-.0527.0881-.0527.0881s-.008-.0107-.0116-.0161c-.0259-.0694-.12687-.24519-.13045-.31823-.002-.12573-.12614-.46827-.10436-.59251.0117-.0596.0229-.1193.0432-.17675.0271-.0764.0686-.14725.10527-.21881.0101-.0194.0204-.0384.0306-.0578.0631-.10805.1335-.21142.2107-.30998.061-.0818.12398-.16281.19799-.23347.0738-.0668.15298-.12793.24079-.17544.075-.0399.15108-.0792.22977-.11138.0395.0161.002.10925-.038.0932z"
          S.path ! A.d "M112.61 668.11c.0113-.0824.00002-.16618-.0165-.24712-.0117-.061-.0435-.10831-.0899-.1478-.0425-.0317-.093-.0492-.14219-.0669-.0534-.0208-.10559-.0434-.15332-.0753-.0207-.0154-.0469-.0277-.0582-.0522.0209-.0359.0398-.073.0628-.10762.00069-.00092.0315-.0155.0319-.0156.0293-.0131.0596-.0243.0897-.0355.11704-.0326.23314-.0675.34691-.11017.11362-.0399.22875-.0792.33397-.1388.0201-.0114.0396-.0241.0593-.0362.14957-.10284.30117-.20268.45541-.29839.14101-.0872.28514-.16894.42669-.25515.12245-.0712.23988-.14998.35709-.2293.0862-.0597.17415-.11667.26463-.16961.008-.005.0164-.0101.0246-.0152.0534.0233-.001.14903-.0548.12575-.009.007-.0182.0136-.0273.0203-.0899.0633-.18252.12258-.27171.18694-.11907.0834-.23992.16428-.36335.24113-.14231.086-.2877.1668-.42724.25733-.14903.0973-.29632.19744-.45065.28623-.12732.0731-.25946.13847-.40032.18155-.066.0181-.13174.0372-.19861.0518-.006.001-.0863.017-.0966.0193-.0126.003-.0251.006-.0376.009-.0279.008-.056.0165-.0838.0249-.005.002-.0107.003-.016.005-.003.001-.0101.007-.009.004.0157-.0338.0349-.0657.0524-.0986-.00092.00069-.003.001-.003.002.001.003.053.029.0579.0332.0493.0273.10341.0449.1543.0689.0493.0213.10011.0405.14321.0732.0516.0388.0848.0788.10463.14172.024.0859.0365.17707.0118.26433.0432.033-.0345.13487-.0778.1019z"
          S.path ! A.d "M117.07 664.15c-.0423.0823-.0819.16562-.11731.25107-.0299.0655-.0365.13611-.0432.20672-.005.0765-.0142.15257-.0208.2289-.0101.0728-.0149.1461-.0198.21937-.006.1175-.0101.2352-.006.35283.0105.1621.0234.32417.0447.48526.0222.13649.0636.26845.1089.39875.0437.12168.0936.24057.14631.35852.0621.1365.12583.27227.19181.40694.0672.12218.14673.2365.22824.34933.0533.0735.10562.14746.16173.21885.0672.0848.14848.1557.22967.22646.12416.10301.25923.19181.39444.27942.10625.0664.21624.12734.32706.18586.0877.0454.1846.0632.27979.0853.0876.0199.17498.0411.26305.0588.052.007.10283.0194.15319.0338.0503.0273-.0141.14572-.0643.11845v0c-.0511-.0128-.10302-.022-.15545-.027-.0904-.013-.17987-.031-.26938-.0489-.0958-.0227-.19003-.0497-.27907-.0926-.11818-.0453-.23444-.0971-.34141-.16529-.13811-.0858-.27521-.17392-.39423-.28568-.047-.0455-.0553-.0519-.0982-.0996-.0428-.0476-.0791-.10021-.12032-.14904-.0576-.068-.11424-.1367-.17073-.20562-.0859-.10896-.17363-.21724-.23646-.34184-.0712-.13385-.13197-.2721-.18932-.41237-.052-.11851-.1005-.23849-.14738-.35912-.047-.12961-.0894-.26104-.11376-.39707-.0292-.16042-.0456-.32268-.0473-.48583.001-.12463.005-.24935.0196-.37323.008-.0734.0108-.14733.0208-.22057.005-.0771.015-.15366.0217-.23057.008-.0694.0109-.13976.0373-.20543.0349-.0912.0743-.18054.12534-.26412-.0428-.0345.0386-.13524.0814-.10072z"
          S.path ! A.d "M112.83 668.1c.004.006.008.0119.0121.0181.0127.0213.0225.0442.0362.0649.0101.0152.0212.0295.0316.0444.0301.0412.0548.086.0819.12908.0185.0281.037.0561.0547.0847.036.0571.0627.11889.0894.18063.0332.0787.0692.15608.10457.23374.0307.0685.0733.13063.11149.19501.0552.0971.11062.19403.16591.29108.0605.10659.13622.20346.20791.30258.0976.12666.20439.24654.3178.35926.0739.0728.15038.14328.23687.20097.0603.0403.0814.05.14624.0856.19164.10252.39533.17948.59469.26522.12253.0521.24842.0985.37837.12867.0793.0184.11724.0223.19773.0343.0312.005.0623.009.0934.0144.0688.0362-.0166.19835-.0854.16214v0c-.0319-.004-.0637-.007-.0956-.0108-.0914-.0143-.10895-.0151-.19884-.0365-.0984-.0234-.19261-.0555-.28763-.0895-.0321-.0114-.0642-.0226-.0964-.0339-.20514-.078-.40262-.16365-.59001-.27915-.13593-.0869-.2686-.17925-.38561-.29102-.11417-.11563-.22152-.23756-.31263-.37252-.0732-.1003-.14428-.20215-.20442-.31099-.0571-.0965-.11532-.19236-.16551-.29268-.0335-.0696-.0674-.13888-.10453-.20655-.0391-.0742-.0832-.14614-.11163-.2255-.0225-.0671-.047-.13307-.0755-.19779-.0152-.0294-.0347-.0564-.0545-.0828-.0305-.0399-.0575-.082-.0857-.12359-.028-.0441-.0594-.0867-.0764-.13664-.0444-.0293.0248-.13407.0692-.10473z"
          S.path ! A.d "M116.16 670.84c.13439.0194.26877.0382.40365.0541.14685.0215.29452.0343.44244.0454.17375.0157.34784.0239.52224.0263.12378-.002.24686-.0154.36965-.0299.0686.0339-.0113.19561-.0799.16172v0c-.1232.0161-.24696.0301-.37148.0277-.17379-.005-.34794-.0106-.52061-.0326-.14716-.0197-.29483-.0331-.44275-.0452-.13122-.0147-.26882-.0308-.38554-.0971-.0469-.0264.0154-.13695.0623-.11051z"
          S.path ! A.d "M119.27 670.07c-.0819.0269-.16251.0569-.24049.0937-.0797.0421-.1635.0753-.24486.11384-.0956.0505-.19246.0981-.29015.14421-.0803.0397-.16443.0739-.2383.12498-.0236.0197-.0497.039-.0685.0637-.003.004-.005.009-.008.0129.0185-.0316.0371-.0631.0556-.0947-.014.0232-.0185.0484-.0212.0749.044.0327-.0331.1363-.0771.10362.003-.0279.006-.056.02-.081.0533-.0933.0745-.14629.15503-.20759.0772-.0553.16208-.0979.24738-.13911.0953-.0449.19068-.0892.2857-.13438.0826-.0386.16597-.0759.24687-.11806.074-.0337.15185-.0651.23397-.0697.0477.0237-.008.1362-.0557.11254z"
          S.path ! A.d "M114.05 672.28c.0181-.00091.0363-.003.0544-.003.0412-.00019.11014.004.1496.007.10973.008.21928.0182.32894.0268.34363.0134.68095.0851 1.021.13074.213.0259.4266.0461.63997.0686.0529.008.10603.0101.15935.0101.0557.0279-.0101.15921-.0657.13131v0c-.0571.008-.11443.0123-.17219.0115-.22117.002-.44192-.0109-.66237-.028-.34107-.0277-.68604-.0477-1.0174-.13938-.12928-.0291-.10457-.0256-.22384-.0455-.0755-.0126-.15303-.0204-.22727-.0395-.0153-.004-.0298-.0101-.0447-.0149-.0491-.0256.0111-.14131.0603-.11574z"
          S.path ! A.d "M116.81 672.57c.10476-.032.21532-.0271.3233-.0208.0809.003.15949.0203.2383.0367.10574.0284.19889.0865.28568.15148.11351.0921.19307.19947.26522.32501.033.0604.0552.1253.0637.1935.004.0336.004.0677.003.10142.0441.0322-.0317.13617-.0759.10402v0c.00019-.0335.001-.067-.00091-.10041-.0114-.061-.0405-.11574-.0741-.16745-.0369-.0529-.0756-.10335-.11637-.15335-.0106-.013-.087-.10631-.0988-.11917-.015-.0163-.0317-.0308-.0475-.0462-.0826-.0666-.17084-.12749-.27117-.16418-.0789-.0224-.16003-.0238-.24164-.0244-.0275-.001-.0836-.003-.11096-.003-.0535.00011-.10717.005-.16069.005-.0123-.00002-.0247-.001-.037-.002-.049-.0238.007-.13903.056-.11527z"
          S.path ! A.d "M119.13 675.61c-.13522.0556-.28049.0792-.42456.0986-.11876.0129-.24032.0192-.35933.004-.0243-.003-.0482-.008-.0723-.0121-.14343-.0265-.28088-.077-.41857-.12376-.11408-.0412-.23073-.0747-.34546-.11382-.0865-.0295-.10773-.0393-.19158-.073-.11221-.0481-.22123-.10493-.32125-.17516-.035-.0292-.0181-.014-.0509-.0458-.0503-.0308.0222-.14915.0725-.11839v0c.0306.0311.0147.0167.048.0437.11046.053.22934.0858.34245.13238.17683.065.35246.13279.5271.20335.13657.0474.27293.098.41584.12296.0571.009.0851.0153.14289.0188.0949.006.19017-.002.28424-.0135.0962-.0154.0501-.007.14756-.0264.0715-.0142.144-.0315.21694-.0363.0143-.00091.0285.00047.0428.00069.0482.024-.008.13764-.0565.11368z"
          S.path ! A.d "M114.69 674.65c.2326-.0566.46574-.11087.69931-.16334.13898-.0313.27749-.0647.41598-.0981.0683.0324-.008.19321-.0763.16089v0c-.14161.0497-.28535.0925-.43133.12751-.13275.0322-.26496.0667-.40042.0859-.0661.009-.14373.0178-.21164.0132-.0192-.001-.0379-.007-.0568-.0105-.0491-.0259.012-.14154.0611-.11561z"
          S.path ! A.d "M106.95 674.86c-.0417.0978-.12093.17996-.16916.27459-.0508.095-.0562.20508-.0675.31154-.00091.0153.0698.35662.069.37195.0505.0369-.0869.1188-.0869.1188s-.0958-.37312-.0956-.38798c.007-.10473-.035-.22928.0119-.32369.0518-.10437.0862-.20775.14113-.31042-.0426-.0335-.0241-.1575.19713-.0548z"
          S.path ! A.d "M104.13 676.11c.0277-.016.013-.009.0197-.0131.0245-.0153.0504-.0281.0746-.0438.0243-.0156.0479-.0321.072-.0479.0934-.0654.19127-.12358.28659-.18587.05-.0319.0977-.0671.14462-.10333.0649-.0518.0722.0433-.069.16117v0c-.0506.0414-.10041.0838-.15415.12111-.0483.0318-.096.065-.14578.0946-.0436.0259-.0889.049-.13363.0727-.0698.0354-.002.002-.065.0311-.0273.0127-.0546.03-.0857.0298-.0495-.0236-.11256-.0197-.0651-.047z"
          S.path ! A.d "M104.56 676.47c.0603-.0517.12228-.10137.18395-.15136.0666-.0545.13159-.11105.19541-.16881.0393-.038.0806-.0739.12319-.10822.0785-.0564.0931.0394-.0679.15953v0c-.0419.0356-.084.071-.12289.10969-.0646.0598-.13093.11768-.1988.17365-.0329.0256-.0658.0508-.1013.0727-.0114.007-.0355.0213-.0496.0259-.005.002-.0256.0284-.0305.029-.0489-.0222-.0399-.0514.0684-.14211z"
          S.path ! A.d "M104.92 676.83c.0816-.0734.15026-.16034.23309-.23233.0228-.0198.0463-.0387.0695-.0581.0763-.0627.15733-.11968.23067-.1859.0356-.0321.0622-.0605.0956-.0947.0417-.0445.0827-.0895.12393-.13429.0782.0319.047-.005-.075.18433v0c-.0422.0497-.0848.0988-.12984.14585-.016.0163-.0316.0329-.0478.0489-.0926.0912-.19244.17447-.29205.25762-.0689.0543-.0606.0485-.12786.0992-.0375.0283-.075.0595-.11661.0818-.005.002-.0101.004-.0146.006-.0504-.0216-.0482-.0295-.007-.0661z"
          S.path ! A.d "M109.78 669.95c.007-.0776.0222-.15405.0405-.22972.0237-.0918.0541-.18197.0937-.26819.006-.0117.012-.0238.0187-.0352.0315-.0543.0622-.10908.0958-.16212.008-.012.018-.0221.0275-.0327.0304-.0342.0639-.0627.0996-.091.0449-.033.0913-.0639.13684-.0961.0609.0265-.002.17001-.0624.14354-.0465.0325-.0925.0656-.1375.1002-.0338.0275-.0661.0552-.095.0881-.008.0101-.0297.0418-.0244.03.0106-.0236.0903-.16064.0382-.0674-.0385.0833-.0666.17077-.0904.25935-.012.0437-.0153.0532-.0249.0969-.0119.0539-.0193.10905-.0376.16135.0437.0335-.0351.13643-.0788.103z"
          S.path ! A.d "M111.09 681.56c.0828.0614.15212.13808.22156.21364.0575.0603.11038.12444.16736.18517.0624.0601.12613.11839.18387.18309.065.0779.1298.15579.19818.23075.0548.0591.11122.11661.16642.17531.0553.0608.11447.11823.17634.17228.026.0235.0552.042.0855.0593.0479.0274-.0167.14048-.0646.11304v0c-.0323-.0155-.0638-.0322-.0913-.0554-.0629-.0543-.1203-.11384-.17632-.17507-.0543-.0591-.11191-.11467-.16932-.17068-.0696-.074-.13494-.15164-.1987-.23061-.0568-.0658-.1162-.12902-.18046-.18774-.0565-.0605-.11242-.12151-.16932-.18162-.0734-.0723-.14854-.14348-.21521-.22202-.0464-.028.0197-.1374.0661-.10936z"
          S.path ! A.d "M106.66 676.96c.0891.0621.25005.24813.3265.3251.0663.0686.13267.13701.19557.20868.0497.0596.0992.11916.15232.17569.0579.067.12485.12496.1917.18265.073.0687.14751.13539.22274.20151.0271.0238.0536.0481.08.0727.0477.0289-.0203.14134-.0681.11245v0c-.0269-.0233-.054-.0464-.082-.0685-.0783-.0624-.15601-.12574-.2251-.19847-.0652-.0606-.13265-.11948-.19028-.18754-.0517-.0575-.10124-.11696-.15379-.17378-.0632-.0707-.1303-.13768-.19615-.2058-.0796-.0749-.24824-.25225-.31949-.33581-.0462-.028.0198-.13692.0661-.10888z"
          S.path ! A.d "M108.31 678.64c.0805.0765.55311.5836.63627.65738.0866.0716.51425.5179.60332.58635.0645.0472.1225.10181.17807.15902.067.0662.12669.13919.18626.21208.0626.0893-.032.1755-.0746.11886-.0586-.0739-.11791-.14716-.18236-.21606-.0542-.0573-.11124-.11211-.17721-.15578-.0926-.0638-.52539-.504-.60967-.57866-.0834-.0765-.5626-.58236-.62685-.67618-.0454-.0283.0213-.13535.0669-.10701z"
          S.path ! A.d "M120.83 671.12c-.007.002-.0136.005-.0206.007-.0186.005-.0633.0154-.079.0186-.0431.009-.0757.0148-.11962.0205-.0203.003-.0409.004-.0613.007-.0739.009-.14826.008-.22238.003-.0267-.003-.19617-.008-.22206-.0146-.004-.00069-.0124-.002-.0124-.002-.0315-.0168-.0262-.0695-.0262-.0695s.074-.003.0782-.002c.0282.006.19598.0103.22483.003.081-.0176.16145-.0382.24407-.047.0203-.002.0407-.005.0611-.006.05-.003.0997-.003.14931.004.009.001.0177.002.0263.005.005.001.0101.004.015.006.0286.015-.007.0824-.0352.0675z"
          S.path ! A.d "M120.85 671.4c-.0369.0206-.18062.0424-.2211.05-.011.002-.0218.005-.0328.007-.0416.007-.0826.0175-.1241.025-.0417.007-.14478-.003-.18694.00046-.0365.003-.16434.0174-.20089.0156-.0363-.0182.0428-.0856.0428-.0856s.17042-.0275.20984-.0353c.0813-.0153.22396-.0133.30674-.0167.0334-.001.12551-.0209.15667-.0249.0229-.003.0461-.008.0692-.008.005-.0001.0101.00069.0147.001.0302.0145-.004.0857-.0341.0712z"
          S.path ! A.d "M120.86 671.68c-.008.003-.0154.007-.0235.0101-.0584.0202-.12398.0272-.18514.0318-.039.002-.0782-.00002-.11718-.001-.0121-.00045-.0242-.001-.0363-.001-.0286.00021-.0563.003-.0847.006-.0681.005-.13629.006-.20448.006-.02-.00092-.0402-.00047-.06-.004-.0129-.003-.0252-.007-.0372-.0121-.0307-.0168.009-.0891.0395-.0724.006.001.0175.003.024.004.0267.002.0532-.004.0796-.006.0713-.007.14195-.0197.21353-.0237.1436.001-.0522-.00092.0816.002.0517.001.1033-.00099.1549-.002.0237-.001.055-.003.0788-.005.0311-.002.0631-.008.0945-.005.006.00045.0112.002.0169.004.0299.0147-.005.0854-.0347.0707z"
          S.path ! A.d "M114.71 677.36c.0431-.0111.0878-.009.13181-.009.12813.00046-.0517-.002.0882.00023.11076.002.22027.0202.32915.0391.1057.0169.20987.0418.31142.0756.10283.0364.20667.0695.31117.10061.087.0247.17264.0531.25972.0772.11194.0228.22104.0576.3304.0901.0908.03.17646.0736.25664.12545.0268.0173.0872.0611.11344.0799.0701.0529.14823.0934.22345.13833.0512.0305.0501.0306.0986.0627.0783.0552.15062.11803.22006.18388.0446.0406.0829.0877.12859.1271.0322.0278.0339.0275.0688.0512.0924.0474.19073.0811.28638.12105.0953.0387.18569.0881.28108.1264.0927.0387.1913.0551.29078.0629.0888.005.17771-.00069.26649.003.0547.003.0751.006.12862.0118.0184.003.0369.006.0553.009.0353.006.066.0128.1014.0183.0616.009.12364.0156.18547.0227.099.0135.19805.025.29736.0354.061.009.12258.0102.18354.0187.0463.006.0714.0119.11739.0208.10462.0193.20816.0428.31442.051.0803.005.15983-.006.23944-.014.0698-.009.14019-.0127.21043-.0166.0418-.004.0839.00022.12563-.003.0171-.001.0506-.006.0671-.008.0733-.0101.14421-.0314.21688-.0444.0203-.004.0408-.006.0611-.0101.14023-.0189.2819-.0196.423-.0136.13767.009.27477.0257.41252.0341.12456.005.24854.0167.37249.0294.0966.007.19226.021.28615.0446.0881.0222.17418.0525.2603.0811.0968.0312.19502.0568.29144.089.0687.0372-.019.19894-.0877.16176v0c-.0228-.004-.0457-.008-.0684-.0128-.078-.0174-.15386-.043-.23147-.0618-.17946-.0439-.3595-.0856-.53666-.13833-.0446-.008-.0835-.0161-.12847-.0213-.0793-.009-.1593-.0101-.23894-.014-.13988-.003-.27966-.008-.419-.0218-.0343-.002-.11144-.007-.14628-.008-.089-.002-.17806.005-.26692.009-.0467.003-.063.004-.10828.009-.053.006-.10525.0175-.15846.022-.065.004-.13016.006-.19497.014-.069.003-.13834.00017-.20668.0126-.0819.0168-.16465.0319-.24875.0252-.10855-.004-.21654-.018-.32284-.0403-.0554-.0121-.1108-.0244-.16605-.0371-.0152-.003-.0301-.008-.0455-.011-.0245-.005-.0535-.006-.0783-.008-.10338-.003-.20712-.001-.30996-.0137-.0213-.003-.0429-.006-.0641-.0101-.14722-.0267.0213.001-.11517-.0255-.053-.0104-.10704-.0136-.16081-.0162-.13072-.005-.26191-.006-.3919-.0226-.0993-.0137-.19775-.033-.29022-.0732-.0965-.0371-.1934-.0731-.28728-.11652-.095-.0426-.19207-.0819-.28189-.13487-.0326-.0214-.0418-.0261-.0715-.0517-.0455-.0392-.0861-.084-.13031-.12464-.0683-.065-.13679-.13095-.22167-.17423-.0526-.0293-.10652-.056-.1592-.0852-.0587-.0325-.0586-.0343-.11484-.0706-.0183-.0118-.0367-.0236-.0551-.0353-.0575-.0386-.11475-.0795-.17496-.11388-.0609-.0348-.12552-.063-.18912-.0921-.0197-.008-.039-.0169-.0591-.0242-.0182-.006-.0369-.0114-.0554-.0172-.0686-.0212-.13697-.0433-.20449-.0678-.0874-.0268-.17647-.0466-.2657-.0661-.10535-.029-.20715-.0679-.31041-.10336-.0285-.009-.0705-.0236-.0996-.031-.0695-.0178-.14079-.0272-.2111-.0405-.1073-.0177-.21489-.0335-.32272-.0476-.022-.002-.0607-.007-.0833-.009-.0329-.002-.0662-.00069-.0988-.006-.007-.001-.0146-.004-.0219-.005-.0481-.0246.0101-.138.0578-.11347z"
          S.path ! A.d "M89.145 85.709c-.03481-.0012-.0903.01913-.14258.05078.05345.0804.12221.09816.19531.16016.04963.03834.09393.07999.14453.11719.0391.0288.04504.03199.08594.05859.09732.06494.20225.12133.30664.17383.0166.0086.03213.01739.04883.02539.0659.0332.0317.01372.0957.04492.04411.0216.08531.04556.12891.06836.09683.05512.19768.10154.29688.15234.07673.03665.15026.08349.22656.12109.04313.0213.06197.02868.10547.04687.04431.0196.09297.03144.13476.05664.0183.011.02306.0155.03906.0293.04033.03841.07332.08426.10352.13086.01973.03253.03478-.009.05468.02344.05114-.0053.10097-.0094.16016-.01563-.0034-.0051-.0063-.01057-.0098-.01563-.04171-.06463-.08285-.05223-.12695-.11523-.03263-.04546-.06778-.08925-.10938-.12695-.04877-.04454-.10306-.08193-.16016-.11523-.10768-.06137-.21938-.11822-.33203-.16992-.10111-.04709-.20007-.09858-.30078-.14648-.09175-.04585-.17903-.09623-.26953-.14453-.10163-.05662-.20529-.11087-.30664-.16797-.08206-.05059-.16297-.10218-.23047-.17188-.03784-.03674-.07052-.02684-.11133-.06055l-.002-.002c-.006-.0055-.01379-.0074-.02539-.0078zm2.1063 1.545c.04102-.04102-.10831.01397-.15625.01953.03848.06813.04562.06103.08119.13081.0284.05923.05844.11803.08594.17773.0583.03859.14824-.09812.08984-.13672-.0283-.05946-.05664-.11883-.08594-.17773-.01492-.02965-.03822.0098-.01478-.01362z"
          S.path ! A.d "M113.25 661.52c.0663.005.1641.0185.22923.0314.0566.007.12445-.0164.18107-.009.0271.003.0591.006.0863.008.0592.004.11864.008.17693.0201.0314.006.0506.0128.081.0218.0548.0189.22072-.0459.27344-.022.059.0332-.0782.1389-.0782.1389v0s-.21549.0377-.26981.0202c-.0324-.008-.0481-.0122-.0811-.0182-.0437-.008-.0874-.0116-.13153-.0157-.0148-.001-.0294-.003-.0441-.004-.0858-.008-.17132-.0205-.2555-.0386-.0628-.0131-.12655-.0286-.18397-.0581-.0467-.0258-.0305-.10011.0163-.0743z"
          S.path ! A.d "M115.31 661.78c.10269-.0413.21468-.0493.32388-.0577.088-.006.17651-.005.2637.009.0465.008.0611.0122.10649.0236.10061.0316.17285.12248.27235.15738.0116.004.0233.008.0349.0122.0572.031.0113.11064-.0459.0797v0c-.013-.002-.0259-.004-.0388-.006-.0392-.008-.0562-.011-.0955-.0229-.0701-.0211-.13668-.052-.2072-.0716-.0451-.009-.0603-.0142-.10675-.018-.0895-.007-.17874.005-.26821.005-.0905.001-.1811.004-.27158.004-.007.00003-.0141-.00069-.0211-.00092-.0485-.0228.005-.13716.0538-.11436z"
          S.path ! A.d "M118.94 660.7c.0904 0-.13726.11699-.20649.1747-.0505.0458-.0651.27006-.10183.32768-.0101.0157-.038.0638-.0274.0485.0215-.031-.0174.0521.003.0202-.0486.12083-.009.13541-.0315.26311-.0176.12685-.032.25432-.033.38247.003.062.007.12524.0255.18502.009.0293.0184.0481.031.0761.0555.0369-.0314.16781-.087.13094v0c-.0125-.0277-.0226-.0488-.0329-.0774-.0205-.0573-.0318-.1175-.0354-.17804-.007-.12429.001-.24879.0208-.37172.0217-.13227.0426-.26621.0925-.3914.0448-.082.0528-.33962.10522-.41701.0374-.0552.0838-.10351.13427-.14702.0617-.0519.12443-.10402.19418-.14473.0504.0215-.10548.11859-.0508.11859z"
          S.path ! A.d "M118.09 662.36c-.007-.008-.0147-.0163-.021-.0252-.017-.024-.047-.0764-.0603-.0998-.0359-.0635-.0697-.12803-.10288-.19291-.0405-.0861-.0828-.17315-.10532-.26615-.003-.014-.006-.0284-.008-.0426-.008-.0567-.007-.1147.004-.17099.006-.0346.0131-.0529.0234-.0867.005-.0144.0108-.0287.0162-.0431-.0537-.0421.0454-.16848.0991-.12645v0c-.005.0139-.0106.0277-.0159.0416-.005.015-.0112.0297-.0159.0449-.0209.0683-.0284.14071-.0211.21167.003.0131.005.0264.009.0392.0248.0857.0786.16228.11821.24119.0568.10238.11721.20759.14564.32225.004.0151.005.0305.008.0457.0455.0307-.0269.13788-.0724.10715z"
          S.g
            ! A.strokeWidth "0.05"
            $ do
              S.path ! A.d "M124.7 660.48c-.60787.21519-1.0041.73536-1.0041.73536"
              S.path ! A.d "M124.23 660.06c-.45325.40816-.80468.85989-.80468.85989"
              S.path ! A.d "M123.97 659.77c-.52914.44463-.7551.85755-.7551.85755l-.008.0237"
              S.path ! A.d "M123.52 659.41c-.46855.42167-.64897.81808-.64897.81808"
              S.path ! A.d "M123 659.17c-.45953.57991-.49565.76916-.49565.76916"
              S.path ! A.d "M122.46 658.97c-.22214.33276-.34319.79581-.34319.79581"
              S.path ! A.d "M121.95 658.86c-.31854.57232-.32076.80237-.32076.80237"
              S.path ! A.d "M121.23 658.82c-.1185.70516-.0594.85293-.0594.85293"
              S.path ! A.d "M120.7 658.94c-.0226.7742.013.85799.013.85799"
              S.path ! A.d "M120.34 659.06c-.0141.7824.071.87087.071.87087"
              S.path ! A.d "M119.88 659.33c.0264.60625.14217.72125.14217.72125"
              S.path ! A.d "M119.5 659.66c.20988.61898.23458.60969.23458.60969"
              S.path ! A.d "M119.18 659.9c.17725.46097.22323.50213.22323.50213"
          S.path ! A.d "M119.71 662.35c-.0652-.00009-.13026.003-.19508.013-.0987.0126-.19595.0315-.29261.055-.0675.018-.13479.0376-.20314.0519-.0523.0109-.10447.0207-.15704.0299-.0594.0114-.11904.0233-.17988.0219-.089.004-.17879.002-.26621.021-.0491-.0255-.10949.09-.0604.11544.009.003.0193.007.0291.008.0716.0136.15422.004.2264-.003.0643-.006.12713-.0215.18971-.0367.0514-.0108.10329-.0194.15526-.0269.0672-.0118.13325-.0278.19956-.0434.0934-.0189.18837-.0305.28321-.0399.0836-.003.16732-.009.25102-.005.0442.002.0879.006.13198.008.0827.003.0425.002.12126.003.009.005.0194.005.0291.003.0107.005.0182.0101.021.0157.0253.0274.17979.02.21297.0367.10575.0547.10668.0937.21701.13469.0642.0265.0196.0711.0546.13422.025.0595.0183.12585.0197.18882-.002.077.0166.15194.0291.22729.009.0452.001.0911.008.13647.0119.0297-.004.065.012.0921.0297.0145.0619-.0143.0792-.0371.0275-.0283.0234-.0691.008-.10246.007-.0619.00091-.12407.004-.18613.005-.12716.0342-.25461.012-.38166-.0163-.10467-.1195-.15584-.19867-.22639-.0723-.0619-.2056-.11975-.29798-.14631-.0575-.0147-.0922-.0324-.12573-.038-.00015-.00003-.00023.00003-.00045 0-.002-.001-.004-.003-.006-.004-.0749-.009-.0358-.005-.11587-.0125-.0651-.005-.13074-.008-.19599-.008z"
          S.path ! A.d "M123.76 662.63c-.011-.001-.0223-.002-.0332-.004-.0522-.0102-.10316-.0286-.1539-.0439-.0464-.014-.0858-.10783-.13225-.12099-.17309-.0425-.34889-.0559-.51922-.10824-.0782-.0235-.16455-.007-.2466-.0122-.0538-.003-.10568.0111-.15845.0185-.0311.003-.0622.007-.0935.0101-.0515-.0253.008-.14657.0596-.12131v0c.0322-.007.0644-.0132.097-.0173.0532-.008.1065-.0154.16029-.0173.0886-.003.17688.003.26467.015.17734.0281.35441.0677.51872.14201.0641.0266.12843.0526.19095.0828.0241.0116.0609.0298.0839.0453.008.006.0162.0129.0243.0194.0476.0265-.0149.13862-.0624.11214z"
          S.path ! A.d "M121.37 664.22c-.0369.0617-.0812.1188-.12772.17353-.0482.0544-.093.1114-.13638.16963-.0521.0677-.1147.12611-.18765.1704-.0491.0275-.1042.0341-.15935.0378-.0704.007-.14041.002-.2096-.0114-.0752-.0155-.1476-.0403-.2205-.0635-.0287-.008-.0543-.0227-.0793-.0389-.0512-.029.0173-.14965.0685-.1206.0279.009.0562.0172.0847.0247.0726.0215.14357.0495.21794.0643.0669.0107.13413.0204.20216.0181.0601-.003.1061-.0123.15598-.0491.0683-.0511.13135-.10923.18461-.176.0436-.0559.0889-.1104.13494-.16432.0403-.0499.0771-.10249.1185-.15128.0495.0198.003.13642-.0468.11656z"
          S.path ! A.d "M121.83 664.83c-.0229-.0158-.0488-.0267-.0719-.0418-.003-.002-.005-.003-.008-.005-.004-.0237-.0982-.0646.004-.0436.0252.0113.0984.0311.1232.0431.0426.0166.0944-.0144.1327.0108.0473.026.0705.0847-.00021.0693-.0801-.017-.13883-.0113-.18016-.0331z"
          S.path ! A.d "M119.04 663.51c.002.0101.005.0193.006.0291.003.0264.006.0911.006.11391.002.0835.002.16701.00069.25055-.002.12723-.0154.25418-.0428.37854-.0191.087-.0331.12834-.0585.21463-.0505.16121-.11313.31898-.18951.46975-.0604.11918-.15646.27266-.21573.3725-.0836.11886-.19554.21189-.31616.29117-.0225.0148-.0457.0282-.0687.0423-.0773.0424-.04.0235-.11141.0574-.0684-.0305.004-.19165.0719-.16113.0767-.0496.0369-.0237.11927-.0779.0375-.0251.10369-.0685.13955-.0956.0946-.0715.1792-.15564.24284-.25611-.0193.0349-.0345.0725-.058.10474-.0203.0278.0331-.0605.0482-.0914.075-.15193.13734-.30992.19349-.46959.0263-.0802.049-.14446.07-.22594.0326-.12629.0503-.25635.0536-.38667.006-.15183.006-.30501.0325-.455-.0447-.0326.0319-.13797.0767-.10546z"
          S.path ! A.d "M114.86 666.58c.0417.0714.0694.14956.10404.2243.0307.0662.0498.10051.0841.16597.11586.20774.24522.40778.37617.60626.17816.27012.38745.51702.60822.75284.0954.0987.19306.19508.30376.27664.0351.0258.0698.0526.10796.0735.082.0449.24581.105.32831.13709.25794.0954.1269.049.39319.13876.0598.033-.018.17374-.0778.14076v0c-.26439-.0946-.13452-.0454-.38974-.14716-.14364-.0667-.18699-.0815-.31751-.16132-.1544-.0946-.28931-.21764-.41994-.34175-.0367-.0373-.0744-.0738-.11024-.11204-.18644-.1991-.35052-.41801-.49642-.64824-.12607-.20519-.25343-.41005-.36702-.62248-.0665-.13535-.12527-.27414-.17022-.41826-.0275-.0183.0156-.0831.0431-.0648z"
          S.path ! A.d "M127.54 682.09c-.4874.19323-2.6005.86245-2.8104.92979-.20989.0674-.24591.2381.084.12821.32987-.10988 2.7926-.90894 2.8155-.92428.006-.047-.0616-.12413-.0891-.13372z"
          S.path ! A.d "M127.87 682.56c-.64928.22815-2.5694.80246-2.6572.82534-.0879.0229-.0729.20453.009.18109.0822-.0235 2.5507-.76694 2.7341-.86379.0114-.0338-.0861-.14264-.0861-.14264z"
          S.path ! A.d "M129.08 684.55c-.005-.00019-.0101.00045-.0148.002-.35295.23092-1.741.3231-2.0542.36913 0 0 .0122.0144.12484.14408.10357-.00092.45727-.045.85324-.10784.217.41162.78079 1.3704.85548 1.6116.0337.10994.14676.0886.1056-.0653-.039-.14615-.67569-1.3931-.77853-1.5763.39409-.0665.79918-.14724 1.0242-.22193 0 0-.0441-.15256-.11588-.15526z"
          S.path ! A.d "M129.19 684.87c.0116.0476.006.0971.001.14516-.007.0577-.0151.11522-.0187.17322-.005.0537.005.10611.0181.15785.0156.0588.0342.11655.0536.17412.0219.0634.0429.12721.0679.1895.0268.0703.0568.13907.0903.20641.0315.0632.0594.12816.0851.19389.0174.0476.037.0943.0587.14009.0193.0401.042.0781.0703.11239.0372.0439.082.0801.127.11551.0452.0387.0926.0747.1397.11097.0192.0132.0356.0308.0557.0427.004.002.0156.007.0199.009.0289.0162-.009.0844-.038.0682v0c-.0296-.0106-.0574-.0245-.0837-.042-.0495-.0331-.0983-.0669-.14389-.10512-.0446-.0382-.0878-.0781-.12359-.12484-.0272-.0355-.0522-.0725-.0727-.11241-.0216-.045-.0419-.0907-.0615-.13663-.0286-.0627-.0602-.12395-.0896-.18623-.0314-.069-.0641-.1376-.0896-.20908-.0224-.0642-.0451-.12834-.0658-.19316-.019-.0582-.037-.11672-.0534-.1757-.0131-.0536-.0217-.10798-.0176-.16333.002-.0562.005-.11243.0141-.16811.007-.0533.0125-.1067.0123-.16058-.0263-.0188.0179-.0808.0442-.0621z"
          S.path ! A.d "M131.92 687.75c.056.0193.10763.0489.16226.0714.0165.007.0334.0127.0501.0191.0634.0243.12569.0522.19111.0708.0423.012.0493.0118.0934.0192.10704.0151.21474.0251.322.0386.0923.0131.18491.0244.2775.0356.0863.011.1727.0207.25867.0338.0451.008.0906.0106.13631.011.0406-.002.0811.00046.12168.00068.0155-.00011.0308.00069.0462.002.0305.0156-.006.0875-.0366.0719-.016.00092-.0319.002-.0478.002-.0409.00046-.0817.003-.12259.00092-.0477-.00013-.0954.0002-.14305.00046-.0883-.002-.17559-.0129-.26265-.027-.0935-.0117-.18747-.0195-.28132-.0283-.10714-.0122-.21478-.0225-.32074-.0428-.0983-.0218-.19672-.045-.28839-.088-.0692-.0341-.13959-.0689-.19473-.12401-.0283-.0165.0105-.0831.0388-.0667z"
          S.path ! A.d "M120.2 667.32c.0147.093-.001.18835-.0146.28059-.02.12558-.0466.24997-.0718.3746-.022.1007-.0293.20363-.0332.30634-.00018.0423.002.0848.0117.12597.008.0349.0228.0671.038.0994.0314.055.0677.10681.0974.16281.0195.0373.0337.0768.044.11746.008.0341.011.0691.0142.10385.00023.004.00069.009.00092.0131.0275.0195-.0185.0845-.046.0649-.00068-.004-.001-.008-.002-.0117-.005-.0336-.009-.0674-.015-.10081-.002-.006-.007-.0282-.009-.0342-.009-.0265-.0248-.0504-.0377-.0749-.0319-.054-.0703-.10377-.10051-.15881-.009-.0182-.0228-.0421-.0304-.0611-.0204-.0502-.0287-.10369-.0301-.15754.00003-.10091.008-.20158.0267-.30086.0228-.12142.0457-.24281.065-.36482.0175-.10735.0335-.21495.0476-.32278-.0261-.0189.0186-.0804.0447-.0615z"
          S.path ! A.d "M119.79 669.15c.0292.0635.0527.12955.0774.19495.0263.0733.06.14364.0946.21334.0281.054.0646.10278.10334.14949.0423.0485.0864.0957.12507.14704.0126.0166.0246.0337.0326.053.0271.0176-.0144.0814-.0415.0638-.012-.0142-.0259-.0267-.039-.0399-.0456-.0448-.0891-.0917-.12884-.14183-.0371-.0488-.0728-.0985-.10438-.15109-.038-.0659-.0751-.13241-.10252-.20362-.0277-.0718-.0533-.14563-.0602-.22283-.0265-.0184.017-.0809.0435-.0624z"
          S.path ! A.d "M124.28 677.6c.009.0795.0184.15907.0314.23807.013.0791.044.15082.0809.22116.0365.066.0866.11697.15095.15522.0589.034.12647.038.19265.0425.0556.004.11172-.00007.16718.005.0561.0161.0804.0806.10517.1277.0581.11186.10986.22669.15456.34451.0335.0886.0601.1796.0838.27125.0233.0845.0418.17007.0644.25469.0157.0602.0376.11816.063.1748.0289.0191-.0162.0873-.0451.0682v0c-.0271-.056-.0501-.1137-.0651-.1743-.0216-.0853-.0396-.17128-.0635-.25591-.0236-.0905-.0506-.1803-.0853-.26724-.0467-.11703-.101-.23066-.15317-.34528-.0139-.0303-.0401-.10152-.0672-.12338-.009-.007-.015-.007-.0257-.009-.0564-.001-.11301.003-.16945-.001-.0675-.004-.13547-.0112-.1957-.0447-.0651-.0389-.11891-.0879-.15617-.1552-.0371-.071-.068-.14384-.0826-.22318-.0148-.0801-.0247-.16117-.0289-.24245-.0263-.0187.0177-.0806.044-.0619z"
          S.path ! A.d "M121.84 686.12c.0143.086.0417.16837.0764.24803.0273.0596.0665.11234.1051.16497.0215.0291.0383.0598.0517.0933.0157.0534.0271.10815.0356.16317.008.0522.009.10482.0101.15741.001.0387-.005.0769-.0178.11335-.0162.0561-.0476.10405-.0773.15398-.029-.0113-.002-.0797.0267-.0684v0c-.0624.11242-.00068.003.005-.0274.0126-.0354.0205-.0724.0187-.11021-.001-.0519-.003-.10386-.0101-.15525-.009-.0554-.0204-.11029-.0325-.16501-.0115-.0339-.0282-.0627-.0508-.0907-.0405-.051-.0814-.1019-.10994-.16084-.0372-.0809-.0669-.16556-.0746-.2549-.0261-.0186.0176-.0801.0438-.0616z"
          S.path ! A.d "M123.43 661.9c-.088-.005-.16792-.0497-.24425-.0902-.10744-.068-.20385-.15187-.30316-.23097-.0841-.0621-.16571-.12599-.23748-.20204-.0588-.0696-.0902-.15666-.12586-.23922-.0423-.10923-.1225-.19102-.20589-.26993-.10458-.0879-.20303-.18283-.31144-.26605-.0696-.0546-.14647-.0952-.23112-.1199-.0925-.0212-.18764-.0284-.28209-.0363-.13887-.0103-.27782-.0168-.41706-.0131-.0954.004-.19106.008-.28539.0237-.0461.007-.0801.0161-.12541.0264-.1129.0274-.22536.0557-.33566.0924-.1068.0373-.20662.0902-.30423.14669-.0882.054-.17277.1131-.2547.17601-.0641.0454-.11335.10644-.16651.16333-.0312.0322-.0164.0164-.0446.0471-.0323-.0131-.001-.0892.0311-.0761v0c.0292-.0328.0139-.0161.0458-.05.0531-.058.10427-.11776.16837-.16419.0827-.0661.16818-.12886.25926-.18315.098-.0552.19895-.106.30505-.14393.11135-.036.22409-.0677.33786-.0951.13635-.0321.27491-.0528.41526-.0545.13843-.003.27577.008.41334.0227.0943.0101.18891.0187.281.0421.085.026.1645.0637.2373.11523.11211.0788.21535.16907.31454.26342.0838.0826.1607.16625.20587.27695.0348.0828.0613.17235.12044.24173.0726.0743.1602.12885.24184.19239.1001.0778.19488.16243.29911.2347.0745.0408.15054.0826.23366.10284.0283.0149-.007.0815-.035.0667z"
          S.g
            ! A.strokeWidth "0.3"
            $ do
              S.path ! A.d "M125.34 661.03c-.76434-.007-1.2265.10449-1.2676.73974-.31877.17642-.99532-.36828-1.0997-.88186-.1944-.61265-.63048-1.0513-1.4064-1.0567-.77596-.005-2.2472.44026-2.5668 1.3479-.10208.68403-.15658 1.1338-.17043 1.2608-.2804.0953-.55121.004-.57158.13249.0261.3494.12714.6595-.28839.67728-.41553.0178-1.5971-.70747-1.8176-1.0353-.49924-.20507-.89769-.19689-1.1723-.0836-.27457.11331-1.0498-.0237-1.4058-.2123-.35591-.18869-1.5236-.0522-1.7114-.0711-.38109-.0356-.55492-.59317-.20021-.71544.3547-.12229 1.6019-.13301 1.9028-.10476.50864.0603.67657-.24779 1.1214-.25534.44482-.007 1.3078-.0277 1.3078-.0277.33869.0317.46692.24981.76477.31057.29785.0608 1.2616-.0142 1.7449-.54891.4833-.53471 1.5675-1.7681 2.8814-1.7962 1.3139-.0282 2.5456.67897 2.9157 1.2326.39801.54208.98568.65995 1.0393 1.0878z"
              S.path ! A.d "M121.57 659.83c-.77596-.005-2.2468.44046-2.5664 1.3481-.10208.68404-.15662 1.1338-.17047 1.2608-.2804.0953-.55144.004-.57181.13244.0199.26756.083.51139-.0747.61924.00046.00023.00046.00069.00092.00092.3199.20648.67727.1499 1.2559-.0175.57866-.16736.95191.3414.77897.81164-.17295.47022-.1928.86621.42505.90023.61786.034.75797-.49909.90246-.74856.1445-.24947.41681-.23942.566-.54272.12853-.6274.76187-.48229 1.1593-.41925.39742.063.23786-.45181.40403-.52036.49768.17771.67079-.60629.39731-.88635-.31878.17641-.99543-.36829-1.0998-.88188-.1944-.61264-.63075-1.0514-1.4067-1.0568z"
              S.path ! A.d "M122.77 663.12c-.29388-.003-.57158.0875-.65191.47965-.14919.30331-.4215.29326-.566.54273-.14449.24947-.2846.78256-.90246.74855-.61785-.034-.598-.43-.42505-.90023.17294-.47023-.20031-.97899-.77897-.81164-.36685.1061-.64474.16716-.88055.14542-.0598.35904.11478.82664-.27654.84015-.26303.0254-.68926-.0247-.92971-.0375-.3324-.0177-1.3444-.8774-1.698-.8774-.35365 0-.88405.45711-1.302.73065-.41795.27353-2.0598 1.5343-2.732 2.0492-.80111.49507-1.5264 1.288-1.9946 1.9123-.83375.57858-1.3496 1.1747-1.8931 1.8116-.54347.63696-2.1045 3.5884-2.5646 4.8613-.77553.34222-1.2682 1.0124-1.3951 1.1888-.12693.17639.12239.4703.26488.45324-.0552.086.21035.42406.42372.39686-.11781.13579.27101.4092.37852.3338-.13065.0777.0958.48003.28501.46039l.11902-.098 1.7705-1.6116c.006-.006.0132-.0108.0201-.0152.006-.80374.23044-1.7715.47428-2.2099.27878-.50108 2.0006-2.2165 2.4188-3.4931.26595-.1661.55251-.52921.85728-.80357.31699-.13475 1.3282-.43927 1.9011-1.0045-.33715 1.6851.32953 2.8656 1.0192 4.0264-.1667.98695.10551 1.7568.54453 2.6689-.0326.40876.0323 2.1027.086 2.7093.0234.48024.92893.79135 1.3781 1.0523.46607.28093 1.8245.21643 2.3884.37987 1.0393.32704 1.9938.34752 2.3844.42193 1.2958-.18245 2.273.17369 2.6958.50468.42277.331 1.2592 2.2718 1.5651 2.9812.30586.70947 1.9923 1.7012 2.3472 2.1025.35493.40125.64754 1.271.58569 1.7745-.0619.50347.006.72631.52881.66398.39767-.0565 1.8972.22674 2.1736.37047.27645.14372.92334.66219 1.149.68143.22567.0192 1.2948.13685 1.7906.0899.49583-.0469.43152-.58786.22538-.61788-.20613-.03-1.0637-.20609-1.5623-.32395-.49858-.11786-1.6156-1.103-2.0559-1.651-.44033-.54805-.67183-1.3092-.95526-1.8577-.28344-.54856-1.9644-2.9079-2.3973-3.4336-.13573-.25162-1.0274-2.3778-1.225-2.906-.1977-.52823-.42953-.61164-.77942-.69307-.34988-.0814-1.1503-.33232-1.553-.51769-.26849-.12358-1.475-.52947-2.584-.7743-1.0296-.1687-1.2157-.25175-1.3593-1.004-.0144-.57423.004-1.7446.13069-2.197.0728-.24729.10338-1.6198.10338-1.6198s.0896-.42691.15749-.77897c.0483-.0883.0844-.17743.0873-.26934.0153-.48812-.0265-1.1797.12082-1.4774.10487-.59562-.29924-1.4471-.21343-1.9964.0537-.16738.54405-.87659.91052-1.1879.36646-.31133.28666-.14121.50872-.0308.22206.11035.44351.28913.56946.38769.15362.12022.24872.0602.30558-.0306.097-.15502.12559-.46817.22985-.56848.0794.008.20131-.0443.1906-.19439.12439-.0197.15693-.10575.14926-.21875-.0206-.0908.059-.34602.20611-.29835.1472.0477.47413.19468.49382-.0206.0141-.15373.1168-.7464.17971-1.1893-.13591-.0225-.2902-.0482-.4425-.0497z"
              S.path ! A.d "M110.93 663.22c-.3809-.016-1.026.27662-1.3136.75793-.48607.17346-2.2057.35392-2.8779.29665-.67214-.0572-1.3194-.14076-1.8152.0215-.49577.16225-.70247.4825-.70247.72886 0 .24636.13545.93071-.0519 1.0895-.18734.15879-.91639.41591-1.3204.4273-.80731.14666-1.4823.75164-1.4823 1.1382 0 .38664.26546 1.381-.15928 1.5387-.42475.15767-1.7047.43138-1.9078.94407-.20319.51268-.28764 1.8733-.27338 2.349-.65367.71059-2.1442 2.0418-2.3584 2.2335-.21416.19173.028.5224.51006.88412.48205.36173 2.3675 1.8921 3.3768 1.9414.44446-.22337 1.0165-.74573 1.1799-.84877.3372.17892 1.9152.52023 2.2421.56645.18938.0268.55662-.0132.87739-.0559h.00047c-.054-.10141-.0702-.20819-.009-.2443-.0269.0188-.0715.0158-.12126-.001-.0498-.0172-.10462-.0484-.15258-.0864-.0479-.0379-.089-.0826-.11051-.12617-.0216-.0436-.0237-.086.006-.11991-.0533.007-.10974-.009-.16375-.0384-.054-.0292-.10553-.0718-.14856-.11768-.0432-.046-.078-.0953-.0984-.1387-.0103-.0219-.0169-.042-.0192-.0596-.002-.0174-.00069-.0318.006-.0425-.0179.002-.0374-.00069-.0578-.008-.0201-.007-.0407-.0174-.0613-.0314-.00008-.00005-.00047.00006-.00047 0-.0415-.0279-.082-.0683-.11408-.11499-.0322-.0467-.0558-.0996-.0635-.15168-.008-.0521.00047-.10355.0323-.14765.0372-.0517.11468-.15135.21254-.26711.014-.0166.0163-.0221.0314-.0394-.25658-.0901-.73858-.37341-.81567-.75749-.0314-.15654.46958-.63014.65907-.63133.006-.00003.012.00092.0175.002.3249.058.60582.43562.74407.82461.00023-.00019.00069-.00023.00092-.00046.0629-.0461.1306-.0895.19955-.13244.0215-.0135.041-.0281.0631-.0412.0897-.0527.18375-.10215.28278-.14586.0576-.15919.13229-.34465.22014-.54855.0879-.2038.18866-.42579.29843-.65861.21955-.46566.47459-.97345.73244-1.4618.25786-.48829.51859-.95701.74854-1.3432.11499-.19308.2221-.36547.31768-.50962.0956-.14415.1795-.25997.24743-.3396.27174-.31849.53647-.62655.83759-.92752.15056-.15048.31046-.29934.48456-.44653.1741-.1472.36248-.29294.57092-.43758.11705-.15607.25006-.32276.39643-.49263.14635-.16986.30606-.34278.47605-.51185.17001-.16909.3503-.33444.53826-.48815.18797-.15371.38363-.29593.5839-.41969.67215-.51492 2.314-1.7757 2.732-2.0492.13381-.0876.28486-.1956.43222-.29978-.27502.00091-.53306.008-.97002-.0528-.76951-.10636-2.4092-.26063-2.7436-.38255-.0418-.0153-.091-.0237-.14541-.026zm1.7602 4.9933c-.57303.56493-1.5838.86932-1.9007 1.004-.15238.13717-.30043.29667-.4434.4425-.0715.0729-.14172.14235-.21074.20403-.0691.0617-.13665.11551-.20313.15704-.0252.0769-.0556.15534-.0895.23491-.0112.0263-.0251.0531-.0371.0797-.0248.0545-.0497.10923-.0779.16465-.006.0124-.0136.0251-.0201.0376-.00024.00068-.00069.001-.00092.002-.0806.15462-.17356.31159-.27427.46935l-.00046.00045c-.027.0423-.0564.084-.0846.12618-.002.002-.003.004-.004.007-.0459.0689-.0945.13723-.14272.20582-.009.0131-.018.0263-.0273.0393-.009.0138-.0188.0275-.0286.0412-.024.0339-.046.0682-.0707.10202-.0156.0213-.0309.0419-.0465.0631-.003.003-.005.007-.008.0103-.002.003-.005.006-.008.0101-.002.002-.003.004-.005.006-.11082.14885-.22375.29625-.33646.43804-.42368.53331-.83454 1.0035-1.0425 1.2904l-.00046.00047-.00046.00045c-.00069.00092-.001.002-.002.003.46544-.37559 1.15-.9013 2.0546-1.5257 1.1656-.69541 1.7091-1.1243 3.1316-1.4175-.00023-.00091-.00069-.002-.00092-.003-.0468-.14636-.0862-.29645-.11857-.45011-.00012-.00091-.00023-.002-.00045-.003-.00016-.00068-.00023-.001-.00047-.002-.00009-.00046-.00045-.00092-.00045-.001-.003-.0133-.006-.0261-.009-.0393-.00023-.001-.00018-.003-.00046-.004-.00045-.002-.00092-.005-.001-.007-.0306-.15525-.0524-.315-.0653-.47919-.00005-.00069.00006-.002 0-.002-.00008-.001-.00045-.002-.00045-.003-.00002-.00024-.00046-.00069-.00046-.00092-.00014-.00069-.00045-.001-.00045-.002-.00023-.004-.00092-.008-.001-.0116-.00047-.005-.00092-.009-.001-.0144-.00013-.001-.00046-.003-.00046-.004v-.00137c-.0122-.17709-.0131-.36024-.001-.54944v-.00092c.00015-.003.00046-.005.00046-.008.00004-.001-.00011-.003 0-.004.006-.0966.0158-.19483.0291-.29485.0001-.00068.00046-.002.00046-.002.0134-.10072.0305-.20295.0515-.30739z"
              S.path ! A.d "M121.14 671.37c.0872.0356.10321.28508.0322.31374.0913.1068.0898.26594-.0803.30388-.11469.0256-.77597.0413-1.0282-.0678-.10612-.0458-.0675-.23278.0177-.22733-.0536-.0343-.15782-.22786-.036-.24699-.067-.0201-.13991-.29359-.0233-.30824-.12883-.0805-.12036-.23029-.009-.29628.1062-.0632.823-.10201 1.0546-.0701.21161.0156.13251.25644.0579.29008.0869.021.11498.2651.015.30885z"
              S.path ! A.d "M103.86 674.11c-.18948.001-.69048.47479-.65906.63133.0771.38409.55909.66738.81567.75748.14724-.16944.34889-.3743.60491-.5624-.13825-.389-.41917-.76659-.74407-.82462-.005-.00092-.0113-.002-.0175-.002z"
              S.path ! A.d "m107.02 675.74-1.8614 1.6941c-.24508.23766.13813.60456.33055.48448.20756-.15137 1.7945-1.5974 1.9175-1.7344.19727-.24047-.20805-.60346-.3866-.44416z"
              S.path ! A.d "m106.12 677.4 5.835 6.0236 1.1856.27997-.17776-1.2152-6.0197-5.8776z"
              S.path ! A.d "M122.74 685.94c-.8524.12574-1.5801.22502-2.1584.3038.039.20513.0764.4115.10158.48456.0497.14355.19328.74005.19328.74005.56726-.0716 1.8078-.11865 2.2139-.0663-.3866-.42586-.44662-.76287-.35033-1.4622z"
              S.path ! A.d "M120.33 670.42c-.08-.15509-.009-.41504.0961-.48533-.35084-.0492-.14244-.49833.0188-.63221-.16957-.0582-.13123-.37597.0349-.53512-.31969-.0978-.0231-.38889.24116-.61076-.51607-.0601-.36505-.69747.0354-.76152-.24734-.10622-.22093-.25726-.10648-.3982-.0301-.0966-.021-.19519-.006-.29226-.0786-.22057-.42771-.67378-.7926-.78572h.00001c-.19699.2586-.35671.50635-.38581.59699-.0859.54929.31831 1.4008.21343 1.9964-.0268.0541-.0455.12439-.0613.2009.0326.49184.12047 1.2107.28234 1.4855.13279.60248.15226.61861.18254.61156.008-.00093.0216-.002.0304-.003.0531-.0102.12246-.0192.19865-.0268"
      S.circle
        ! A.fill "none" ! A.stroke "#000000" ! A.strokeWidth "0.5"
        ! A.cx "121.31" ! A.cy "682.85" ! A.r "26.67"
      S.circle
        ! A.fill "none" ! A.stroke "#000000" ! A.strokeWidth "0.5"
        ! A.cx "121.31" ! A.cy "682.85" ! A.r "35.76"
      S.circle 
        ! A.fill "#000000" ! A.cx "105.43" ! A.cy "709.34" ! A.r "1.28"
      S.circle
        ! A.fill "#000000" ! A.cx "137.18" ! A.cy "709.34" ! A.r "1.28"
      S.g
        ! A.transform (S.translate 28.616 591.12 <> S.scale 0.229 0.229)
        $ do
          S.path ! A.d "M404.47 532.49c.99081-.51767 1.5347-.1558 1.9753.39856.66504.0399 1.3429-.0805 1.6172 1.089.94217.23241 1.3364.77136 1.0925 1.62.68125.44821.91177 1.0823.40117 1.9909.51767 1.1478-.0237 1.6314-.40091 1.9944.12114.73915-.0853 1.3463-1.092 1.6274-.25292 1.0174-.91596 1.0858-1.6171 1.0966-.46203.53013-1.0625.79853-1.9761.40193-.84079.39394-1.4857.18647-1.9761-.40193-.92204.18065-1.3543-.35634-1.6171-1.0966-.97003-.36761-1.1421-.95692-1.092-1.6274-.67435-.63875-.81281-1.3124-.4009-1.9944-.41239-.79019-.47132-1.5032.40117-1.9909-.0179-.96973.39061-1.4728 1.0925-1.62.26888-.58454.37352-1.2436 1.6172-1.089.44538-.43301.84414-.86603 1.9753-.39856z"
          S.path ! A.d "M400.11 523.75c-1.3788-.0199-2.6689 1.0172-4.1641 2.1035-2.1748 1.5801-4.0082 2.706-3.0488 5.3398.98288 2.6984 3.2079 1.1294 3.8516 3.7383l-.0801.25c-2.0542 1.7323-2.9742-.96865-5.3555.63672-2.3242 1.5669-1.4635 3.6816-.63282 6.2383.83073 2.5566 1.3353 4.6473 4.1367 4.5488 2.8701-.10092 2.0699-2.6999 4.75-2.5059l.20899.15235c1.0128 2.489-1.8378 2.5282-1.0469 5.2891.772 2.6947 3.0481 2.5293 5.7363 2.5293 2.6882-.00003 4.8335.16541 5.6055-2.5293.79095-2.7608-1.9288-2.8001-.91602-5.2891l.20899-.1543c2.6801-.19406 1.8368 2.532 4.707 2.6328 2.8014.0985 3.347-2.1172 4.1777-4.6738.83067-2.5567 1.6505-4.5444-.67382-6.1113-2.3813-1.6054-3.2583.96672-5.3125-.76563l-.0801-.24805c.64364-2.6089 2.9723-.96345 3.9551-3.6621.95935-2.6338-.97951-3.8378-3.1543-5.418-2.1748-1.5801-3.811-2.9744-6.0195-1.248-2.2626 1.7686-.0868 3.4-2.3691 4.8184h-.25977c-2.2823-1.4183.001-3.1278-2.2617-4.8965-.69014-.53946-1.3362-.76633-1.9629-.77539zm.78906 3.1524c.49038.028.8574.29499 1.0684.87109.50636 1.3826-.0522 3.1848 2.2617 3.8242h.47266c2.3139-.63943 1.7554-2.4416 2.2617-3.8242.55109-1.5049 2.1724-.90484 4.2539.56445 2.0406 1.5255 3.1145 2.8839 1.8535 3.873-1.1585.90883-3.0463.93381-2.9394 3.332l.14843.44922c1.3232 2.0031 2.8626.91446 4.334.96875 1.6015.059 1.5315 1.787.77734 4.2207-.82028 2.4121-1.779 3.8526-3.1094 2.959-1.2224-.82093-1.8303-2.6064-4.0781-1.7637l-.38086.27734c-1.4961 1.8774.013 3.0057.41602 4.4219.43872 1.5414-1.2239 2.0082-3.7715 2.043-2.5476-.0347-4.2141-.50155-3.7754-2.043.40306-1.4162 1.9141-2.5445.41797-4.4219l-.38281-.27734c-2.2479-.84277-2.8538.94272-4.0762 1.7637-1.3304.89357-2.2891-.54684-3.1094-2.959-.75419-2.4336-.82614-4.1616.77539-4.2207 1.4714-.0543 3.0128 1.0343 4.3359-.96875l.14649-.45117c.10689-2.3983-1.781-2.4213-2.9395-3.3301-1.261-.98915-.18707-2.3475 1.8535-3.873 1.1708-.82648 2.1976-1.3767 2.9688-1.4336.075-.006.14674-.006.21679-.002z"
          S.path ! A.d "M404.43 519.01c-.63951.00091-1.1975.26698-1.2031.91016v.002a17.762 17.762 0 0 0-.002 0l-.002 7.8906c.0165.13791.0439.27341.0859.4082.002.006.002.0119.004.0176.0152.047.0354.094.0547.14062.0182.0436.0382.0877.0605.13086.02.039.0389.0785.0625.11719.0463.0752.10031.14871.16211.22266.0201.0242.0445.0482.0664.0723.0602.0657.12628.13064.20118.19531.0214.0185.0418.0382.0645.0566.10242.083.21508.16491.3457.24609h.25977c.12793-.0795.2364-.15941.33789-.24024.0285-.0227.0555-.0455.082-.0684.0702-.0603.13379-.12068.1914-.18165.0225-.0239.0476-.0482.0684-.0723.0625-.0721.11641-.14565.16407-.21875.0302-.0467.0552-.0936.0801-.14063.0143-.0268.0283-.0531.041-.0801.0254-.0542.0507-.10934.0703-.16407.0479-.13413.0799-.26922.10157-.40625l.002-7.9453v-.0371a17.762 17.762 0 0 0-.002 0c-.0119-.65894-.48907-.81611-1.168-.85156-.0432-.002-.0863-.004-.12891-.004zm-16.719 11.842c-.43314.003-.66964.3713-.87109.89648-.24794.64635-.20143 1.3294.44922 1.5469.0205.007.0419.0137.0625.0195l7.4355 2.4199c.0156.003.0312.007.0469.01.12235.0223.24658.0357.37304.0371.0106.00011.0207.002.0312.002.0432-.00023.087-.004.13086-.008.0558-.004.11282-.0115.16993-.0215.0359-.006.0709-.0128.10742-.0215.0882-.0212.1775-.0487.26953-.0859.0293-.0118.0601-.0274.0898-.041.0741-.034.14949-.0733.22657-.11914.0352-.0209.0696-.0429.10546-.0664.10583-.0696.21401-.14565.32618-.24024l.0801-.24804c-.00015-.00065.00016-.001 0-.002-.002-.01-.005-.0174-.008-.0273-.0335-.13182-.0719-.25007-.11328-.36133-.0149-.0399-.031-.0778-.0469-.11523-.0306-.0725-.0638-.13923-.0976-.20313-.0218-.0408-.0433-.0836-.0664-.12109-.0138-.0225-.0287-.0411-.043-.0625-.0341-.0514-.067-.10305-.10351-.14844-.0379-.0468-.0789-.0898-.11914-.13086-.0162-.0166-.0323-.0331-.0488-.0488-.15291-.14465-.31947-.25359-.49609-.34375l-7.5566-2.457c-.12271-.0409-.23403-.0592-.33399-.0586zm33.451.0469c-.0757-.00083-.15527.008-.23828.0293l-.0176.006c-.0117.003-.0235.006-.0352.01-.0167.005-.0325.0117-.0488.0176-.004.001-.008.002-.0117.004l-7.4512 2.418c-.12597.0585-.24632.12691-.36133.20898-.004.003-.008.005-.0117.008-.0446.0323-.0884.0703-.13086.10742-.025.022-.05.0445-.0742.0684-.0393.0385-.0782.0772-.11523.12109l-.006.006c-.0531.0639-.10448.13247-.15234.20899-.018.0286-.0336.0632-.0508.0937-.0377.0674-.0738.13926-.10742.2168-.0176.0404-.0344.0816-.0508.125-.0412.1095-.0802.22563-.11328.35547-.003.01-.005.0173-.008.0273-.00016.00065.00016.001 0 .002l.0801.24609c.11831.0998.23077.18302.34179.25586.0247.0162.0498.03.0742.0449.0929.0571.18491.10614.27344.14649.0138.006.0273.0156.041.0215.1024.0442.20137.0767.29883.10156.0217.005.0429.009.0645.0137.0668.0145.13232.0225.19726.0293.0417.004.0839.0103.125.0117.003.00011.007-.00009.01 0 .005.00017.0104-.002.0156-.002.13656.003.27075-.007.40235-.0273l7.6016-2.4688a17.762 17.762 0 0 0 0-.002c.61686-.21607.61691-.71663.4414-1.3711-.15131-.56417-.48784-1.0264-.98242-1.0332zm-15.436.22071c-.25849.19272-.59285.35595-1.0293.47656h-.47266c-.42296-.11688-.74885-.27406-1.0039-.45898v1.2168c.29696-.10447.68155-.0954 1.248.13867.5304-.27712.93087-.30126 1.2578-.17968zm-7.0938 3.2305c.1198.31828.18379.70283.16211 1.1894l-.14649.45117c-.22654.34295-.45938.59049-.69727.77344l1.2442.4043c-.21659-.61953-.12595-1.1693.58789-1.5684-.006-.33113.0389-.60727.12695-.83399zm11.643.0332-1.123.36523c.0934.23682.095.52088 0 .85157.57682.3795.82774.89192.58203 1.5918l1.2617-.41015c-.24568-.18424-.48696-.43716-.72071-.79102l-.14843-.44922c-.0209-.46931.037-.84625.14843-1.1582zm-9.8574 6.6055-.85156 1.1699c.3336-.0111.71167.0501 1.1562.2168l.38281.27734c.26245.32933.42775.635.52735.92383l.89257-1.2285c-.0114-.013-.0239-.0255-.0351-.0391-.92205.18065-1.3544-.35738-1.6172-1.0977-.17827-.0676-.32713-.14098-.45508-.22265zm8.0918.0508c-.12791.0663-.27668.12369-.44922.17187-.25292 1.0173-.91606 1.0869-1.6172 1.0977-.0198.0227-.0403.0427-.0605.0644l.89648 1.2344c.0981-.29778.26732-.61409.53906-.95508l.38086-.27734c.42861-.16069.79611-.22427 1.1211-.21875zm1.3125 3.0527c-.14174-.009-.29539-.007-.46289.006l-.20899.15235c-.0568.13961-.0982.26942-.13281.39453-.009.0344-.0175.0682-.0254.10156-.0243.10196-.042.19969-.0527.29297-.002.0174-.006.0356-.008.0527-.01.104-.0112.2023-.006.29688.002.0389.007.0758.0117.11328.007.0554.0162.10944.0273.16211.009.0402.0164.0804.0273.11914.004.016.0108.0311.0156.0469.0383.12323.0874.24092.14453.35352.00092.002.001.004.002.006l.002.002 4.6699 6.4297a17.762 17.762 0 0 0 .002-.002c.40085.55866.88509.40594 1.4648.0293.56152-.36488.92185-.9214.58399-1.4629l-.002-.002c-.003-.006-.008-.0101-.0117-.0156l-.0234-.0352c-.0137-.0191-.0285-.0384-.043-.0566l-4.5996-6.334c-.0732-.0788-.15257-.15186-.23633-.2207-.0132-.0108-.0255-.0227-.0391-.0332-.0714-.0557-.1504-.1042-.23242-.15039-.0277-.0154-.0549-.0307-.084-.0449-.0798-.0394-.16794-.0726-.25976-.10157-.0323-.0101-.0618-.0226-.0957-.0312-.12424-.0321-.25891-.0555-.4082-.0664-.007-.00052-.0125-.001-.0195-.002zm-10.723.002c-.16111.01-.30654.0318-.43945.0644-.0139.003-.0254.01-.0391.0137-.1141.0305-.21974.0662-.31641.11133-.0192.009-.0361.0199-.0547.0293-.0924.047-.18026.10007-.25976.1582-.008.006-.0159.01-.0234.0156-.0883.0665-.16909.13797-.24609.21484l-4.6973 6.4609a17.762 17.762 0 0 0 .002.002c-.37246.53761-.0776.94468.44922 1.3711.53209.43063 1.1865.59794 1.5957.0684.001-.002.002-.004.004-.006l.01-.0117c.0129-.0174.0252-.0349.0371-.0527l4.5957-6.3203c.008-.0134.0141-.0275.0215-.041.0569-.10482.10639-.21401.14649-.32812.007-.0203.015-.0399.0215-.0606.0108-.0344.0204-.07.0293-.10547.0155-.0624.0263-.12699.0352-.19336.004-.0288.009-.0563.0117-.0859.008-.0974.0102-.19922.002-.30664-.001-.0157-.004-.0329-.006-.0488-.009-.095-.0268-.19477-.0508-.29883-.008-.0356-.0173-.0707-.0274-.10742-.0336-.12294-.0732-.24983-.1289-.38672l-.20899-.15039c-.1675-.0121-.32084-.0139-.46289-.006z"
      S.defs
        $ do
          S.path
            ! A.id_ "HaskellSvgIcons-mtCoA-a"
            ! A.d "m303.76 250.55 8.7591 8.7591c-8.2161 19.606-13.247 27.714-26.562 35.224-13.315 7.51-28.503 9.7794-38.713 9.5728.0909-17.094 5.305-33.567 15.031-43.716 9.726-10.149 26.031-17.826 31.642-18.947.8084 1.5001 2.6391 4.8323 2.6391 4.8323-8.4279 1.31-18.757 3.6987-28.185 13.212-9.4279 9.5135-17.091 27.354-11.271 32.841 5.8197 5.4866 16.631 3.5099 26.237-2.0488 9.6056-5.5587 20.065-22.257 20.85-27.355-3.0892-2.9285-7.5738-6.1536-7.5738-6.1536z"
          S.path
            ! A.id_ "HaskellSvgIcons-mtCoA-b"
            ! A.d "M268.37 259.49c-.93562.94411-1.8465 1.9878-2.7359 3.0756 2.9821 4.3458 7.908 15.54 8.8803 21.871-6.7692-.64835-13.502-2.1475-18.4-4.2689-.58697 2.0278-.94927 3.96-1.0192 5.701 5.6852-.008 20.89 3.2662 25.576 5.835.89451-.44573 1.785-.91242 2.6641-1.4211.16173-.0936.32399-.19854.48614-.29831-4.9098-8.1314-10.807-22.447-13.475-32.368-.66281.59422-1.3213 1.2131-1.9763 1.8741z"
          S.path 
            ! A.id_ "HaskellSvgIcons-mtCoA-c"
            ! A.d "M276.04 253.3c6.5561 5.784 14.53 14.732 21.241 22.824 1.2738-1.8101 2.4198-3.6014 3.403-5.2867-6.7493-6.1101-15.86-14.642-19.915-20.125-1.572.7334-3.153 1.59-4.7288 2.5881z"
      S.g
        ! A.fill "none"
        ! A.stroke "#000000"
        ! A.strokeWidth "1.746"
        ! A.strokeLinejoin "round"
        ! A.transform (S.rotateAround 90 (-188.66) 401.5 <> S.scale 0.229 0.229)
        $ do
          S.use ! A.xlinkHref "#HaskellSvgIcons-mtCoA-a"
          S.use ! A.xlinkHref "#HaskellSvgIcons-mtCoA-b"
          S.use ! A.xlinkHref "#HaskellSvgIcons-mtCoA-c"
      S.g
        ! A.fill "none"
        ! A.stroke "#000000"
        ! A.strokeWidth "1.746"
        ! A.strokeLinejoin "round"
        ! A.transform (S.rotateAround 180 107 387.19 <> S.scale 0.229 0.229)
        $ do
          S.use ! A.xlinkHref "#HaskellSvgIcons-mtCoA-a"
          S.use ! A.xlinkHref "#HaskellSvgIcons-mtCoA-b"
          S.use ! A.xlinkHref "#HaskellSvgIcons-mtCoA-c"
      S.g
        ! A.fill "none"
        ! A.stroke "#000000"
        ! A.strokeWidth "1.746"
        ! A.strokeLinejoin "round"
        ! A.transform (S.matrix 0 (-0.229) 0.229 0 29.782 775.54)
        $ do
          S.use ! A.xlinkHref "#HaskellSvgIcons-mtCoA-a"
          S.use ! A.xlinkHref "#HaskellSvgIcons-mtCoA-b"
          S.use ! A.xlinkHref "#HaskellSvgIcons-mtCoA-c"
      S.g
        ! A.fill "none"
        ! A.stroke "#000000"
        ! A.strokeWidth "1.746"
        ! A.strokeLinejoin "round"
        ! A.transform (S.translate 28.616 591.32 <> S.scale 0.229 0.229)
        $ do
          S.use ! A.xlinkHref "#HaskellSvgIcons-mtCoA-a"
          S.use ! A.xlinkHref "#HaskellSvgIcons-mtCoA-b"
          S.use ! A.xlinkHref "#HaskellSvgIcons-mtCoA-c"
      S.path ! A.d "M92.465 702.14c-.7956-1.3789-1.8327-3.1491-2.408-3.6106.34526-.24694.81052-.59574 1.0615-.65934-.01436.87906 1.3269 2.7003 1.3269 2.7003.30159-.19131 1.9435-1.2774 1.9435-1.2774-.54305-.84496-1.0279-1.4923-1.4143-1.7521.4684-.35357.9894-.64946 1.1338-.67698.0087.42517.26398 1.137 1.0098 2.0187 0 0 1.8271-.96922 2.4201-1.7065.20473.36913.77632 1.2499.77632 1.2499-.85701.15571-4.7126 2.554-5.8496 3.714z"
      S.path ! A.d "M90.07 685.69c-2.0487.36899-3.0974 2.1202-2.7478 4.0959.34958 1.9757 2.134 3.3505 4.0923 3.014 1.9583-.33656 3.0579-2.1354 2.688-4.2258-.36988-2.0904-1.9837-3.2531-4.0324-2.8841zm.29654 1.1875c1.6545-.29275 3.0428.50598 3.2681 1.7794.22531 1.2734-.79068 2.5475-2.4505 2.8412-1.6598.29369-2.9829-.75904-3.1731-1.834-.19021-1.075.70108-2.4938 2.3555-2.7865z"
      S.path ! A.d "M94.52 674.34c-.0455.005-.09998.0391-.16176.11886-.68645 1.1111-2.1804 2.0833-3.4948 3.0076-.19539-.94488-.90292-1.5411-1.7264-1.5857-.87079-.0472-1.7527.65302-1.9032 1.1123-.21238.64802-.46742 3.3682-.46742 3.3682 1.7092-.12501 5.4587.14168 6.7551.61325 0 0 .04911-.91174.1474-1.4578-.85066.22117-2.7695-.15542-2.7695-.15542l.0371-.63701s1.1576-.96661 1.9643-1.5711c.26174-.20183 1.7187-1.5491 1.7712-2.5929.005-.0991-.05196-.23064-.15207-.22031zm-4.101 4.9946c-.78455.0216-2.407-.0419-2.864-.24475.16129-1.5658.65993-2.1429 1.4871-2.0592.77237.0781 1.5819.50718 1.377 2.304z"
      S.path ! A.d "m97.578 658.64.78832.74205c-1.4994.11373-3.3574 1.5247-3.321 2.7267.01945.64331.23474 1.524 1.0708 2.1644.83605.64042 1.7138.81603 2.3954.69157.68166-.12447 1.7811-1.0546 1.7763-1.5651-.005-.51049-1.1849-1.9242-1.9308-1.9261l1.2452-1.3229c.30928.76332 1.5941 1.8864 2.0659 2.0311-.54392 1.2849-1.2102 2.6279-2.6208 3.2854-1.4107.65748-2.8592.61667-4.1941-.63987-1.2598-1.1858-.7701-3.4653.01881-4.3594.86872-.98457 2.3001-1.7404 2.706-1.8279z"
      S.path ! A.d "m105.67 652.02.21293 4.9945s.0893 1.7775-.33807 2.8691l1.552-1.0685c-.59139-.49351-.45451-1.986-.45451-1.986l2.5221-1.3138s1.1832.77884 1.0491 1.7019c0 0 2.2299-.81021 2.1414-.84712-1.2286-.49092-2.7739-1.5948-2.7739-1.5948zm.78486 1.5577 2.2728 1.5447-2.2449 1.1859z"
      S.path ! A.d "M118.24 648.71c-.30833 1.2257-.30155 3.6319.11468 5.6367 1.5574-.11175 2.7536-.59665 3.2953-1.251l.10081 1.645-4.8962.30001c.0635-2.2481-.0834-4.9179-.69101-6.2034z"
      S.path ! A.d "M129.42 649.64c-.66138 1.077-1.3758 3.3748-1.5793 5.4121 1.5194.35998 2.8059.25573 3.5187-.20627l-.39665 1.5996-4.7612-1.1806c.73409-2.1258 1.3938-4.717 1.1992-6.1255z"
      S.path ! A.d "m141.72 655.04-4.4019 2.3693s-1.5607.85541-2.7294.94675l1.6383.93087c.18629-.74739 1.5891-1.275 1.5891-1.275l2.282 1.6969s-.18503 1.4044-1.0742 1.6862c0 0 1.7014 1.6535 1.6961 1.5578-.094-1.3197.22575-3.1917.22575-3.1917zm-1.0597 1.3855-.39916 2.7189-2.0461-1.5032z"
      S.path ! A.d "m144.07 666.9-.73282-1.2556c1.1137-.12621 4.4133-2.2405 5.9303-3.3066l.25098.43001-1.1915 6.6819c1.276-.57349 3.2917-1.7267 3.817-2.3394-.0175.0305.83231 1.426.83231 1.426-1.4448-.14782-4.0646 1.2714-6.0378 2.5826l-.20357-.34878.98116-6.4897s-3.2847 1.6449-3.6461 2.6196z"
      S.path ! A.d "M154.17 676.56c-.1275-.97049-.14484-1.6554-.62683-1.8709-.0399-.0349-.0515-.40319-.0515-.40319l1.1969-.20082c.50398 1.2942 1.062 4.8732.981 5.7923.0416-.0278-1.2342.20706-1.2342.20706l-.0503-.34502c.40345-.46529-.004-2.1597-.004-2.1597-1.8227.18967-5.0038.71499-5.4491 1.3333l-.28371-1.691c.6455.22639 3.8493-.11692 5.5213-.66207z"
      S.path ! A.d "M147.9 691.33c.0456-.004.1005-.0377.16341-.11657.70201-1.1013 2.2095-2.0524 3.5368-2.9582.18207.94753.88114 1.5536 1.7039 1.6098.87004.0595 1.7617-.62829 1.9187-1.0854.22148-.64497.51477-3.3612.51477-3.3612-1.7108.10091-5.4561-.21848-6.7459-.70823 0 0-.0619.91095-.16789 1.4556.85369-.20919 2.767.19436 2.767.19436l-.046.63643s-1.1711.95021-1.9862 1.5433c-.26455.19812-1.7403 1.5248-1.8075 2.5677-.006.099.0488.23136.14897.22242zm4.1709-4.9364c.78478-.0106 2.4061.0758 2.8603.28501-.18331 1.5634-.69003 2.1334-1.5159 2.0381-.7712-.089-1.5746-.52937-1.3444-2.3231z"
      S.path ! A.d "m145.82 695.8-1.0893 1.7227c.80043-.0929 1.8749.57151 2.7366 1.1839.26906.81136 1.3576 2.8759 1.2047 4.8507l1.4018-2.2169c-.57445-.29399-1.2517-.59956-1.6033-2.7409 1.7505-.57655 3.0549-.73753 3.6002-.41722l1.2242-1.9359c-1.3746.76279-4.5744 1.4822-5.0924 1.2975-.53944-.34325-2.0954-.87784-2.3824-1.7439z"
      S.path
        ! A.fill "none"
        ! A.stroke "#CF142B"
        ! A.strokeWidth "2.81"
        ! A.d "M204.30662 658.60783H159.6778c0-8.1046-7.5922-13.736-14.13-13.736V599.85H97.06718v44.62882c-7.2241 0-13.735 6.598-13.735 14.129H38.30837v48.48263h44.62981c0 7.494 6.9466 13.734 14.128 13.734v45.02382h48.48262v-44.62982c7.2484 0 13.745-7.1261 13.745-14.128h45.01282z"
      S.path
        ! A.fillRule "evenodd"
        ! A.stroke "#000000"
        ! A.strokeWidth "0.15"
        ! A.strokeDashoffset "0.11339"
        ! A.d "M101.82 604.43c-.0949.00001-.1718.077-.17181.17181v47.957c0 .0949.077.17182.17181.17182.0949 0 .17182-.077.17182-.17182v-47.785h38.632v47.796c0 .0949.077.17181.17181.17181.0949 0 .17182-.077.17182-.17181v-47.967c-.00001-.0949-.077-.1718-.17182-.17181zm-58.759 58.759c-.09489.00001-.1718.077-.17181.17182v38.976c.00001.0949.07693.1718.17181.17181h48.362l-.24091-.34363h-47.949v-38.632h47.965l.21719-.34363zm108.14 0 .22845.34363h47.953v38.632h-47.965l-.20987.34363h48.347c.0949-.00001.1718-.077.17181-.17181v-38.976c-.00001-.0949-.077-.17181-.17181-.17182zm-49.381 49.777c-.0949 0-.17181.077-.17181.17181v47.957c.00001.0949.077.17181.17181.17182h38.976c.0949-.00001.17181-.077.17182-.17182v-47.957c0-.0949-.077-.17181-.17182-.17181-.0949 0-.17181.077-.17181.17181v47.785h-38.632v-47.785c0-.0949-.077-.17181-.17182-.17181z"
      S.path
        ! A.fillRule "evenodd"
        ! A.stroke "#000000"
        ! A.strokeWidth "0.15"
        ! A.strokeDashoffset "0.11339"
        ! A.d "M99.072 601.68c-.095.00001-.17181.077-.17182.17182v47.547l.34362.35259v-47.728h44.13v44.762l.34363.0112v-44.945c-.00001-.0949-.077-.17181-.17181-.17182zm44.302 48.17v4.8278l.34363.30022v-3.5432zm-44.13 3.0926-.34362.71767v1.2935l.34362-.27338zm-58.93 7.4958c-.09489.00001-.1718.077-.17181.17181v44.474c.00001.0949.07693.17181.17181.17182h47.547l.34407-.34363h-47.719v-44.13h44.795v-.34363zm49.525 0-1.4935.34363h4.8058l.27651-.34363zm59.346 0 .26846.34363h1.8107l-.7047-.34363zm5.5674 0-.33691.34363h47.718v44.13h-44.775l-.004.34363h44.951c.0949-.00001.1718-.077.17181-.17182v-44.474c-.00001-.0949-.077-.1718-.17181-.17181zm-63.337 44.474.7132.34363h1.3216l-.30547-.34363zm58.048 0-.26576.34363h3.1485l1.1365-.16421 1.0085-.17942zm-5.7454 5.7906-.34363.29217v1.8072l.34363-.74229zm-44.818.0129v3.553l.18255.71902.16107.89083v-4.8671zm44.474 5.2309v47.724h-44.13v-44.781l-.34362-.00091v44.954c.00001.0949.077.1718.17182.17181h44.474c.0949-.00001.1718-.077.17181-.17181v-47.574z"



{- |
Flag of Portugal coat of arms.
Drawn for a @viewbox 0 0 600 400@
-}
ptCoA :: Svg
ptCoA = do
  S.g
    ! A.fill "#FFFF00"
    ! A.fillRule "evenodd"
    ! A.stroke "#000000"
    ! A.strokeWidth "0.5"
    ! A.strokeLinecap "round"
    ! A.strokeLinejoin "round"
    $ do
      S.path ! A.d "m318.24,262.04c-30.21-0.91-168.74-87.38-169.69-101.15l7.6496-12.757c13.741,19.966,155.36,104.06,169.27,101.08l-7.2299,12.823"
      S.path ! A.d "m154.59,146.4c-2.7101,7.2937,36.149,31.318,82.903,59.754,46.752,28.434,87.065,46.006,90.053,43.486,0.18256-0.32544,1.4701-2.5409,1.352-2.5232-0.56001,0.84402-1.9234,1.1104-4.0506,0.49741-12.631-3.6433-45.575-18.765-86.374-43.506-40.798-24.743-76.294-47.544-81.811-57.232-0.38363-0.67116-0.65702-1.8962-0.60146-2.8487l-0.13405-0.002-1.1747,2.0532-0.16139,0.32191h-0.00088zm164.36,116.04c-0.51238,0.92957-1.4675,0.96044-3.2816,0.76112-11.3-1.2506-45.589-17.925-86.162-42.213-47.21-28.26-86.2-54.01-81.97-60.74l1.1509-2.0346,0.22665,0.0706c-3.8037,11.405,76.948,57.578,81.702,60.522,46.724,28.947,86.115,45.851,89.601,41.458l-1.2682,2.181v-0.002z"
      S.path ! A.d "m240.17,169.23c30.237-0.23901,67.55-4.1319,89.023-12.69l-4.6265-7.5168c-12.692,7.0247-50.21,11.644-84.652,12.335-40.736-0.37483-69.49-4.1681-83.897-13.835l-4.3672,8.0045c26.484,11.207,53.623,13.587,88.52,13.703"
      S.path ! A.d "m330.44,156.71c-0.73904,1.1818-14.743,6.0113-35.373,9.5753-13.988,2.1325-32.234,3.9555-55.004,3.9776-21.633,0.0203-39.305-1.5196-52.684-3.3329-21.656-3.3955-32.833-8.1201-36.965-9.7896,0.39509-0.78581,0.64908-1.337,1.0301-2.0708,11.895,4.736,23.124,7.5918,36.279,9.6158,13.291,1.8,30.75,3.362,52.276,3.3417,22.664-0.0229,40.709-1.9844,54.616-4.0534,21.155-3.4122,32.711-7.8034,34.334-9.8425l1.494,2.5788h-0.002zm-4.0603-7.6226c-2.293,1.8415-13.718,5.8932-33.819,9.1034-13.415,1.9226-30.472,3.6433-52.265,3.6645-20.704,0.0203-37.619-1.375-50.485-3.2491-20.414-2.6661-31.279-7.4754-35.196-8.8776,0.3898-0.67381,0.78666-1.3423,1.1941-2.0135,3.0479,1.5346,13.533,5.7909,34.226,8.7224,12.72,1.8036,29.661,3.1477,50.262,3.1265,21.69-0.0221,38.553-1.7762,51.883-3.6883,20.205-2.7799,31.077-7.9472,32.728-9.241l1.4728,2.4509v0.002z"
      S.path ! A.d "m140.88,205.66c18.598,10.003,59.905,15.044,98.994,15.391,35.591,0.0564,81.958-5.5016,99.297-14.69l-0.47712-10.012c-5.4246,8.4773-55.113,16.609-99.206,16.276-44.093-0.3325-85.038-7.1429-98.687-15.959l0.0794,8.9914"
      S.path ! A.d "m340.12,204.22,0.00088,2.3874c-2.606,3.1159-18.946,7.8255-39.437,11.142-15.595,2.391-35.927,4.1945-61.262,4.1945-24.069,0-43.263-1.7163-58.148-4.0014-23.529-3.4264-38.579-9.4262-41.6-11.217l0.0132-2.7852c9.0748,6.0334,33.661,10.447,41.917,11.798,14.788,2.2701,33.868,3.9732,57.817,3.9732,25.216,0,45.434-1.7912,60.931-4.1663,14.701-2.1237,35.644-7.6465,39.767-11.324h0.00088zm0.01-8.4922,0.00088,2.3874c-2.606,3.1142-18.946,7.8237-39.437,11.14-15.595,2.391-35.927,4.1945-61.262,4.1945-24.069,0-43.263-1.7145-58.148-4.0014-23.529-3.4246-38.579-9.4245-41.6-11.216l0.0132-2.7852c9.0748,6.0325,33.661,10.447,41.917,11.796,14.788,2.2719,33.868,3.9758,57.817,3.9758,25.216,0,45.434-1.7921,60.931-4.169,14.701-2.1237,35.644-7.6465,39.767-11.324l0.00088,0.002z"
      S.path ! A.d "m239.79,260.32c-42.772-0.25489-79.421-11.659-87.16-13.544l5.6433,8.8344c13.67,5.7503,49.424,14.32,81.927,13.371,32.504-0.94809,60.91-3.466,80.928-13.211l5.7862-9.1555c-13.642,6.425-60.068,13.639-87.125,13.705"
      S.path ! A.d "m323.3,253.72c-0.85016,1.2991-1.7171,2.5823-2.5963,3.8294-9.4417,3.3293-24.319,6.8245-30.597,7.844-12.824,2.6423-32.665,4.594-50.274,4.6029-37.89-0.55474-68.905-7.9719-83.496-14.299l-1.1773-2.0241,0.19225-0.30427,1.9966,0.77435c25.948,9.2834,55.091,12.987,82.698,13.652,17.538,0.0617,35.095-2.01,49.292-4.5491,21.771-4.3621,30.574-7.65,33.275-9.1405l0.68701-0.38541h-0.00088zm5.0172-8.2753c0.022,0.0256,0.0441,0.0503,0.0653,0.0776-0.63585,1.0733-1.2911,2.1652-1.9622,3.2623-5.0357,1.8-18.702,5.7988-38.659,8.5893-13.149,1.7912-21.322,3.526-47.479,4.034-49.015-1.2471-80.75-10.831-88.289-13.195l-1.1174-2.1431c28.406,7.4154,57.422,12.592,89.408,13.121,23.931-0.50976,34.112-2.2719,47.152-4.0499,23.271-3.6186,34.996-7.4498,38.515-8.5558-0.0441-0.0635-0.0961-0.13053-0.15433-0.19932l2.5231-0.9428-0.002,0.002z"
      S.path ! A.d "m328.83,197.76c0.13873,28.137-14.26,53.386-25.858,64.525-16.408,15.759-38.163,25.896-63.569,26.363-28.37,0.52117-55.12-17.974-62.295-26.099-14.028-15.885-25.449-36.057-25.815-63.243,1.7376-30.709,13.793-52.1,31.268-66.769s40.743-21.813,60.121-21.302c22.358,0.59003,48.475,11.558,66.521,33.332,11.823,14.266,16.943,29.748,19.627,53.193zm-89.186-96.342c54.485,0,99.296,44.338,99.296,98.703,0,54.364-44.811,98.704-99.296,98.704s-98.924-44.339-98.924-98.704,44.439-98.703,98.924-98.703"
      S.path ! A.d "m239.91,101.08c54.534,0,99.011,44.483,99.011,99.022,0,54.538-44.478,99.02-99.011,99.02-54.534,0-99.011-44.481-99.011-99.02s44.478-99.022,99.011-99.022zm-96.832,99.0224c0,53.26,43.736,96.842,96.832,96.842,53.097,0,96.833-43.582,96.833-96.842,0-53.262-43.737-96.844-96.833-96.844s-96.832,43.584-96.832,96.844z"
      S.path ! A.d "m239.99,109.31c49.731,0,90.693,40.821,90.693,90.704,0,49.884-40.963,90.703-90.693,90.703s-90.693-40.819-90.693-90.703c0-49.883,40.964-90.704,90.693-90.704zm-88.515,90.7034c0,48.685,39.979,88.524,88.515,88.524s88.515-39.839,88.515-88.524c0-48.686-39.978-88.525-88.515-88.525-48.536,0-88.515,39.839-88.515,88.525z"
      S.path ! A.d "m243.98,100.68-8.48545,0,0.01,198.96,8.51455,0z"
      S.path ! A.d "m243.13,99.546h2.1598l0.0185,201.25h-2.1616l-0.0159-201.25zm-8.4213,0.0018h2.1766l0.003,201.25h-2.1783v-201.25z"
      S.path ! A.d "m338.99,203.935,0-7.3554-5.99-5.58-34-9-49-5-59,3-42,10-8.48,6.28,0,7.3572l21.48-9.637,51-8h49l36,4,25,6z"
      S.path ! A.d "m239.95,184.77c23.383-0.0432,46.07,2.2154,64.065,5.7194,18.569,3.7121,31.637,8.3556,36.105,13.571l-0.005,2.5823c-5.3884-6.4902-22.973-11.248-36.518-13.968-17.858-3.474-40.393-5.7168-63.647-5.6736-24.538,0.0459-47.387,2.3698-64.984,5.8032-14.12,2.8019-32.951,8.3679-35.302,13.858v-2.689c1.2911-3.8003,15.313-9.4792,34.984-13.417,17.729-3.4572,40.62-5.7415,65.302-5.7864zm0.01-8.4922c23.383-0.0423,46.07,2.2172,64.065,5.7194,18.569,3.7139,31.637,8.3556,36.105,13.571l-0.005,2.5823c-5.3884-6.4885-22.973-11.247-36.518-13.966-17.858-3.4757-40.393-5.7185-63.647-5.6736-24.538,0.0441-47.276,2.3698-64.875,5.8014-13.626,2.5832-33.226,8.3696-35.412,13.86v-2.6908c1.2911-3.7588,15.597-9.6414,34.985-13.417,17.729-3.4572,40.62-5.7397,65.302-5.7864z"
      S.path ! A.d "m239.48,132.96c36.849-0.18433,68.99,5.1523,83.695,12.685l5.3638,9.279c-12.781-6.888-47.456-14.05-89.005-12.979-33.854,0.20814-70.027,3.7271-88.176,13.41l6.4035-10.709c14.895-7.7241,50.022-11.643,81.72-11.684"
      S.path ! A.d "m239.97,140.62c21.017-0.0556,41.325,1.1298,57.476,4.0437,15.041,2.7993,29.385,7.0009,31.436,9.2604l1.5901,2.8099c-4.9881-3.257-17.401-6.8836-33.339-9.906-16.006-3.0083-36.3-4.0049-57.2-3.9502-23.722-0.0811-42.152,1.1712-57.969,3.9291-16.728,3.13-28.334,7.6015-31.197,9.7261l1.5583-2.9704c5.5631-2.8381,14.39-6.2592,29.223-8.9297,16.357-2.988,34.983-3.8841,58.423-4.0128h-0.00088zm-0.009-8.4843c20.113-0.0529,39.972,1.068,55.452,3.8506,12.209,2.3768,24.283,6.0872,28.704,9.3892l2.3256,3.6954c-3.9536-4.3947-18.836-8.5593-31.974-10.892-15.361-2.6494-34.395-3.698-54.508-3.8656-21.108,0.0591-40.615,1.352-55.752,4.1081-14.441,2.7481-23.76,6.0016-27.703,8.5425l2.0451-3.0868c5.4414-2.8646,14.232-5.4954,25.303-7.6465,15.249-2.7764,34.876-4.0358,56.108-4.0949z"
      S.path ! A.d "m289.15,241.26c-18.218-3.4008-36.469-3.8947-49.217-3.7447-61.407,0.71967-81.244,12.609-83.665,16.209l-4.5894-7.4815c15.634-11.332,49.073-17.687,88.587-17.037,20.518,0.33602,38.224,1.6986,53.119,4.5835l-4.2358,7.4727"
      S.path ! A.d "m239.58,236.46c17.082,0.25488,33.849,0.96044,50.033,3.9784l-1.172,2.069c-15.031-2.7746-31.055-3.8365-48.803-3.75-22.663-0.17727-45.585,1.9394-65.541,7.6668-6.2968,1.7524-16.721,5.8006-17.784,9.1458l-1.1659-1.9226c0.33601-1.9773,6.6363-6.081,18.414-9.3901,22.858-6.5458,44.239-7.6491,66.019-7.799v0.002zm0.77519-8.5963c17.698,0.33073,35.975,1.1492,53.74,4.6681l-1.2206,2.1537c-16.042-3.1847-31.369-4.2466-52.415-4.5702-22.735,0.0414-46.851,1.6625-68.778,8.0372-7.0791,2.062-19.297,6.5202-19.704,10.05l-1.1659-2.0655c0.26545-3.2059,10.842-7.388,20.358-10.156,22.096-6.4241,46.275-8.076,69.186-8.1174z"
      S.path ! A.d "M327.58,247.38,320.201,258.829,299,240,244,203,182,169,149.81,157.99,156.67,145.27,159,144l20,5,66,34,38,24,32,23,13,15z"
      S.path ! A.d "m148.65,158.29c5.646-3.8294,47.139,14.655,90.555,40.834,43.301,26.254,84.677,55.921,80.942,61.473l-1.2285,1.9323-0.56354,0.4445c0.12083-0.0864,0.74345-0.84755-0.0609-2.906-1.8449-6.0704-31.195-29.491-79.894-58.895-47.475-28.309-87.041-45.371-90.997-40.494l1.247-2.3892h-0.00089zm180.44,88.927c3.57-7.052-34.916-36.044-82.632-64.272-48.813-27.666-83.994-43.951-90.42-39.095l-1.4278,2.5991c-0.0124,0.14287,0.052-0.17727,0.35364-0.4101,1.1685-1.0195,3.1052-0.95074,3.9792-0.96662,11.065,0.16581,42.667,14.709,87.006,40.128,19.428,11.315,82.071,51.491,81.832,62.789,0.0168,0.97102,0.0803,1.1712-0.28485,1.6519l1.5936-2.4236v-0.002z"
  S.g
    $ do
      S.path
        ! A.fill "#FFFFFF"
        ! A.stroke "#000000"
        ! A.strokeWidth "0.67" 
        ! A.d "m180.6,211.01c0,16.271,6.6628,30.987,17.457,41.742,10.815,10.778,25.512,17.579,41.809,17.579,16.381,0,31.247-6.6525,42.016-17.389,10.769-10.735,17.443-25.552,17.446-41.88h-0.002v-79.189l-118.74-0.14111,0.0123,79.278h0.002z"
      S.path
        ! A.fill "#FF0000"
        ! A.stroke "#000000"
        ! A.strokeWidth "0.5"
        ! A.d "m182.82,211.12v0.045c0,15.557,6.4414,29.724,16.775,40.009,10.354,10.305,24.614,16.712,40.214,16.712,15.681,0,29.912-6.3606,40.222-16.626,10.308-10.265,16.697-24.433,16.699-40.044h-0.002v-76.826l-113.84-0.0185-0.0697,76.748m91.022-53.747,0.004,48.891-0.0414,5.1717h0.00088c0,1.3608-0.082,2.9122-0.24076,4.2333-0.92512,7.7294-4.4801,14.467-9.7451,19.708-6.1636,6.1357-14.671,9.9413-24.047,9.9413-9.327,0-17.639-3.9379-23.829-10.1-6.3497-6.32-10.03-14.986-10.03-23.947l-0.0132-54.023,67.94,0.12259,0.002,0.002z"
  S.g
    ! A.id_ "HaskellSvgIcons-ptCoA-quina"
    ! A.fill "#FFFFFF"
    $ do
      S.path
        ! A.fill "#003399"
        ! A.d "m232.636,202.406v0.005c0,2.2119,0.84927,4.2272,2.2118,5.6894,1.3652,1.4667,3.2454,2.3777,5.302,2.3777,2.0672,0,3.9439-0.90487,5.3029-2.3654,1.3581-1.4587,2.2021-3.47219,2.2021-5.693v-10.768l-14.992-0.0123-0.0273,10.766"
      S.circle ! A.r "1.486" ! A.cx "236.074" ! A.cy "195.735"
      S.circle ! A.r "1.486" ! A.cx "244.392" ! A.cy "195.735"
      S.circle ! A.r "1.486" ! A.cx "240.225" ! A.cy "199.735"
      S.circle ! A.r "1.486" ! A.cx "236.074" ! A.cy "203.905"
      S.circle ! A.r "1.486" ! A.cx "244.392" ! A.cy "203.905"
  S.use ! A.xlinkHref "#HaskellSvgIcons-ptCoA-quina" ! A.y "-25.5"  
  S.use ! A.xlinkHref "#HaskellSvgIcons-ptCoA-quina" ! A.x "-20.7"
  S.use ! A.xlinkHref "#HaskellSvgIcons-ptCoA-quina" ! A.x " 20.7"
  S.use ! A.xlinkHref "#HaskellSvgIcons-ptCoA-quina" ! A.y " 25.5"  
  S.defs $ do
    S.g
      ! A.id_ "HaskellSvgIcons-ptCoA-castle"
      ! A.fill "#FFFF00"
      ! A.stroke "#000000"
      ! A.strokeWidth "0.5"
      $ do
        S.path ! A.stroke "none" ! A.d "m190.19,154.43c0.13493-5.521,4.0524-6.828,4.0806-6.8474,0.0282-0.0185,4.2314,1.4076,4.2173,6.8986l-8.2978-0.0512"
        S.path ! A.d "m186.81,147.69-0.68172,6.3447,4.1406,0.009c0.0397-5.2493,3.9739-6.1225,4.0691-6.1031,0.0891-0.005,3.9889,1.1606,4.0929,6.1031h4.1511l-0.74962-6.3932-15.022,0.0379v0.002z"
        S.path ! A.d "m185.85,154.06h16.946c0.35717,0,0.64908,0.35277,0.64908,0.78404,0,0.43039-0.29191,0.78141-0.64908,0.78141h-16.946c-0.35717,0-0.64908-0.35102-0.64908-0.78141,0-0.43127,0.29191-0.78404,0.64908-0.78404z"
        S.path ! A.d "m192.01,154.03c0.0185-3.3126,2.2621-4.2501,2.2736-4.2483,0.00088,0,2.3423,0.96661,2.3609,4.2483h-4.6344"
        S.path ! A.d "m186.21,145.05h16.245c0.34218,0,0.62263,0.31839,0.62263,0.70468,0,0.38717-0.28045,0.70467-0.62263,0.70467h-16.245c-0.34218,0-0.62263-0.31573-0.62263-0.70467,0-0.38629,0.28045-0.70468,0.62263-0.70468z"
        S.path ! A.d "m186.55,146.47h15.538c0.32719,0,0.59529,0.31662,0.59529,0.70379,0,0.38805-0.2681,0.70467-0.59529,0.70467h-15.538c-0.32719,0-0.59529-0.31662-0.59529-0.70467,0-0.38717,0.2681-0.70379,0.59529-0.70379z"
        S.path ! A.d "m191.57,135.88,1.2267,0.002v0.87136h0.89513v-0.89076l1.2567,0.004v0.88723h0.89778v-0.89076h1.2576l-0.002,2.0117c0,0.31574-0.25398,0.52035-0.54854,0.52035h-4.4113c-0.29633,0-0.56972-0.23724-0.5706-0.52652l-0.003-1.9879h0.00088z"
        S.path ! A.d "m196.19,138.57,0.27691,6.4514-4.3028-0.0159,0.28486-6.4523,3.741,0.0168"
        S.path 
          ! A.id_ "HaskellSvgIcons-ptCoA-cp1"
          ! A.d "m190.94,141.56,0.13141,3.4775-4.1256,0.002,0.11641-3.4793h3.8786-0.00089z"
        S.use
          ! A.xlinkHref "#HaskellSvgIcons-ptCoA-cp1"
          ! A.x "10.6"
        S.path
          ! A.id_ "HaskellSvgIcons-ptCoA-cp2"
          ! A.d "m186.3,139.04,1.1994,0.003v0.87224h0.8775v-0.89253l1.2294,0.004v0.889h0.87926v-0.89253l1.2302,0.002-0.002,2.0117c0,0.31398-0.2487,0.51859-0.5362,0.51859h-4.3169c-0.28926,0-0.55824-0.23548-0.55913-0.52564l-0.003-1.9888h0.00088z"
        S.use
          ! A.xlinkHref "#HaskellSvgIcons-ptCoA-cp2"
          ! A.x "10.6"
        S.path
          ! A.fill "#000000"
          ! A.stroke "none"
          ! A.d "m193.9,140.61c-0.0265-0.62706,0.87661-0.63411,0.86603,0v1.5364h-0.866v-1.536"
        S.path
          ! A.id_ "HaskellSvgIcons-ptCoA-cp3"
          ! A.fill "#000000"
          ! A.stroke "none"
          ! A.d "m188.57,142.84c-0.003-0.6059,0.83693-0.61824,0.82635,0v1.1871h-0.826v-1.187"
        S.use
          ! A.xlinkHref "#HaskellSvgIcons-ptCoA-cp3"
          ! A.x "10.64"
  S.g
    ! A.id_ "HaskellSvgIcons-ptCoA-castle3"
    $ do
      S.use 
        ! A.xlinkHref "#HaskellSvgIcons-ptCoA-castle"
      S.use
        ! A.xlinkHref "#HaskellSvgIcons-ptCoA-castle"
        ! A.y "46.32"
      S.use
        ! A.xlinkHref "#HaskellSvgIcons-ptCoA-castle"
        ! A.transform (S.matrix 0.704 (-0.709) 0.709 0.704 (-35.34) 275.1)
  S.use
    ! A.xlinkHref "#HaskellSvgIcons-ptCoA-castle"
    ! A.x "45.7"
  S.use
    ! A.xlinkHref "#HaskellSvgIcons-ptCoA-castle3"
    ! A.transform (S.matrix (-1) 0 0 1 479.79 0)



{- |
Flag of Slovenia coat of arms.
Drawn for a @viewbox 0 0 240 120@
-}
siCoA :: Svg
siCoA =
  S.g
    ! A.fill "#0000FF"
    ! A.transform (S.matrix 0.3914 0 0 0.3914 60 60)
    $ do
      S.defs $ do
        S.path
          ! A.id_ "HaskellSvgIcons-siCoA-star"
          ! A.fill "#FFFF00"
          ! A.d "m0-84.5 1.125 2.551443L3.897114-82.25 2.25-80l1.647114 2.25L1.125-78.051443 0-75.5l-1.125-2.551443-2.772114.301443L-2.25-80l-1.647114-2.25 2.772114.301443"
      S.path 
        ! A.d "M-37.175342-94.368205a92.195445 92.195445 0 0 1 74.350684 0Q43-12 0-1q-43-11-37.175342-93.368205Z"
      S.use
        ! A.xlinkHref "#HaskellSvgIcons-siCoA-star"
      S.use
        ! A.xlinkHref "#HaskellSvgIcons-siCoA-star"
        ! A.x "-10.5"
        ! A.y "-14"
      S.use
        ! A.xlinkHref "#HaskellSvgIcons-siCoA-star"
        ! A.x "10.5"
        ! A.y "-14"
      S.path
        ! A.fill "#FFFFFF"
        ! A.d "m0-70 9 18 6-8 15 20a10 10 0 0 1-.384761 2.747211A46.400549 46.400549 0 0 1 0-6.090878a46.400549 46.400549 0 0 1-29.615239-31.161911A10 10 0 0 1-30-40l15-20 6 8z"
      S.path
        ! A.id_ "HaskellSvgIcons-siCoA-water"
        ! A.d "M-29.615239-37.252789A10 10 0 0 0-15-31.339746a10 10 0 0 1 10 0 10 10 0 0 0 10 0 10 10 0 0 1 10 0 10 10 0 0 0 14.615239-5.913043L30-37.113249v7.320508a10 10 0 0 0-5 1.339746 10 10 0 0 1-10 0 10 10 0 0 0-10 0 10 10 0 0 1-10 0 10 10 0 0 0-10 0 10 10 0 0 1-10 0 10 10 0 0 0-5-1.339746v-7.320508"
      S.use
        ! A.xlinkHref "#HaskellSvgIcons-siCoA-water"
        ! A.y "5.7735"
      S.path
        ! A.fill "#FF0000"
        ! A.d "M-40-93.066239a92.195445 92.195445 0 0 1 2.824658-1.301966l2.97064 47.448778A49.301041 49.301041 0 0 0 0-3.036262a49.301041 49.301041 0 0 0 34.204702-43.883164l2.97064-47.448778A92.195445 92.195445 0 0 1 40-93.066239L37.099526-46.73819A52.201533 52.201533 0 0 1 0 0a52.201533 52.201533 0 0 1-37.099526-46.738189Z"




{- |
Flag of Slovakia coat of arms.
Drawn for a @viewbox 0 0 900 600@
-}
skCoA :: Svg
skCoA = 
  S.g $ do
    S.path
      ! A.fill "#FFFFFF"
      ! A.d "m 393.479,141 h -8.103 -115.459 -115.456 -8.103 l -0.847,8.059 c -0.184,1.752 -4.511,43.971 -4.511,136.69 0,43.563 14.726,81.996 43.77,114.23 20.349,22.585 46.923,41.599 81.242,58.129 l 3.905,1.881 3.906,-1.881 c 34.32,-16.53 60.896,-35.544 81.246,-58.129 29.044,-32.234 43.771,-70.667 43.771,-114.23 0,-92.718 -4.328,-134.938 -4.512,-136.69 z"
    S.path
      ! A.fill "#EE1C25"
      ! A.d "M 269.917,450 C 220.577,426.234 150,379.062 150,285.749 150,192.436 154.461,150 154.461,150 h 115.456 115.459 c 0,0 4.463,42.437 4.463,135.749 0,93.313 -70.578,140.485 -119.922,164.251 z"
    S.path
      ! A.fill "#FFFFFF"
      ! A.d "m 280.484,261.284 c 13.36,0.216 39.425,0.739 62.635,-7.027 0,0 -0.613,8.306 -0.613,17.98 0,9.677 0.613,17.982 0.613,17.982 -21.289,-7.125 -47.58,-7.273 -62.635,-7.082 v 51.539 H 259.38 v -51.539 c -15.055,-0.191 -41.345,-0.043 -62.635,7.082 0,0 0.613,-8.305 0.613,-17.982 0,-9.675 -0.613,-17.98 -0.613,-17.98 23.21,7.766 49.275,7.243 62.635,7.027 v -32.368 c -12.177,-0.108 -29.723,0.473 -49.563,7.113 0,0 0.613,-8.305 0.613,-17.982 0,-9.676 -0.613,-17.981 -0.613,-17.981 19.81,6.628 37.336,7.219 49.509,7.114 -0.626,-20.498 -6.597,-46.332 -6.597,-46.332 0,0 12.289,0.959 17.202,0.959 4.918,0 17.203,-0.959 17.203,-0.959 0,0 -5.969,25.835 -6.596,46.33 12.174,0.106 29.699,-0.485 49.509,-7.114 0,0 -0.613,8.305 -0.613,17.981 0,9.677 0.613,17.982 0.613,17.982 -19.839,-6.639 -37.386,-7.221 -49.563,-7.113 v 32.368 z"
    S.path
      ! A.fill "#0B4EA2"
      ! A.d "m 269.904,329.094 c -24.852,0 -38.163,34.469 -38.163,34.469 0,0 -7.385,-16.344 -27.661,-16.344 -13.719,0 -23.829,12.201 -30.256,23.5 24.959,39.705 64.78,64.207 96.079,79.281 31.305,-15.075 71.152,-39.571 96.112,-79.281 -6.427,-11.299 -16.537,-23.5 -30.256,-23.5 -20.277,0 -27.693,16.344 -27.693,16.344 0,0 -13.308,-34.469 -38.162,-34.469 z"



{- |
Flag of San Marino coat of arms.
Drawn for a @viewbox 0 0 800 600@
-}
smCoA :: Svg
smCoA =
  S.g $ do
    S.g
      ! A.fill "none"
      ! A.stroke "#000000"
      ! A.strokeWidth "0.933"
      $ do
        S.g
          ! A.fill "#FFFFFF"
          ! A.strokeWidth "1.09"
          $ do
            S.circle ! A.r "4.04" ! A.cx "459.44" ! A.cy "171.23"
            S.circle ! A.r "4.04" ! A.cx "340.72" ! A.cy "171.23"
            S.circle ! A.r "5.08" ! A.cx "461.69" ! A.cy "157.02"
            S.circle ! A.r "5.08" ! A.cx "338.47" ! A.cy "157.02"
            S.circle ! A.r "4.88" ! A.cx "453.28" ! A.cy "147.12"
            S.circle ! A.r "4.88" ! A.cx "346.87" ! A.cy "147.12"
            S.circle ! A.r "4.21" ! A.cx "438.49" ! A.cy "143.36"
            S.circle ! A.r "4.21" ! A.cx "361.66" ! A.cy "143.36"
            S.circle ! A.r "3.90" ! A.cx "423.77" ! A.cy "141.72"
            S.circle ! A.r "3.90" ! A.cx "376.39" ! A.cy "141.72"
        S.g
          ! A.fill "#000000"
          ! A.strokeLinecap  "round"
          ! A.strokeLinejoin "round"
          $ do
            S.path
              ! A.d "m392.488 132.016c-13.4834 15.5386-37.154 7.94825-47.9528 13.9984-18.7842 10.523 1.64882 35.4862 5.49625 40.2579l20.4697-5.3427c-7.51535-6.013-22.5874-16.2266-18.0484-24.525 4.65236-8.50925 29.3711 0.12401 40.1806-18.0396 2.27362-3.82028 0.53149-7.12735-0.14528-6.349z"
            S.path
              ! A.fill "#F1BF31" 
              ! A.d "m392.488 132.481c-13.4834 15.5422-36.3898 8.0941-47.1862 14.1449-18.7848 10.5242 2.4313 34.8756 6.27875 39.649l17.6817-5.3445c-7.5183-6.013-21.7996-16.536-17.2606-24.835 4.65118-8.50865 29.8222-0.0307 40.6317-18.1949 2.27362-3.82028 0.5315-6.19725-0.14528-5.4195z"
            S.path
              ! A.strokeWidth "0.633"
              ! A.d "m393.711 133.678c-14.6026 19.7168-36.5226 9.7636-45.9432 17.455-10.6418 8.69055 4.8626 25.7953 12.3431 32.5624l1.16943-0.42933c-6.0691-5.75375-24.0579-22.8396-12.6278-32.0652 8.2193-6.63605 31.3311 2.02086 45.1075-17.0546z"
            S.path
              ! A.fill "#D99F31"
              ! A.stroke "none"
              ! A.d "m357.83 171.306c-0.35847 0.67855-0.89469 1.84901-1.25611 3.33189-6.24155-7.43505-10.917-15.14-5.99825-21.5044 4.47816-5.79565 15.453-3.17304 26.8778-7.187 5.2329-1.55197 10.3689-4.31575 14.7431-9.4943-0.42048 1.13386-0.85512 2.5063-1.33761 3.87992-11.5955 14.7638-34.7527 7.689-39.1671 15.7612-2.60433 4.7628 1.09487 10.2584 6.13819 15.2126z"
            S.path
              ! A.stroke "none"
              ! A.d "m352.11 169.98c1.30334-0.37618 1.96831-1.09843 2.6935-1.94174 0.29528 0.35729 0.60118 0.7128 0.91772 1.06713-0.49901 0.66142-1.06949 1.31044-1.9252 1.75925-1.03465 0.54272-2.16792 0.68091-3.22914 0.68091-0.3555-0.47658-0.70157-0.95965-1.03701-1.44567 0.86103 0.0862 1.82717 0.098 2.58012-0.11988zm-2.8115-5.7715c1.13504-0.17835 1.5939-0.29292 2.49272-0.8002 0.1559 0.34311 0.32893 0.68681 0.51791 1.03051-0.75826 0.44055-1.37775 0.70453-2.42775 0.91949-1.0559 0.21792-2.15138 0.15355-3.12284-0.008-0.20787-0.44527-0.40098-0.89055-0.57519-1.33523 0.94842 0.18307 2.17441 0.34134 3.11516 0.1937zm1.5385-4.8125c-2.07343-0.19843-4.08544-1.28327-5.4951-2.82756 0.0998-0.41339 0.2309-0.82146 0.39271-1.22067 0.81142 1.01456 2.57009 2.76909 5.1862 2.99705-0.0549 0.34842-0.0821 0.69862-0.0838 1.05118zm1.806-4.554c-1.48229-0.86398-2.70473-2.22815-3.45709-3.77185 0.27519-0.19607 0.56338-0.37796 0.86693-0.54567 0.5498 1.16693 1.58327 2.74134 3.38917 3.64311-0.28937 0.20787-0.5557 0.43228-0.79901 0.67441zm3.9835-6.1505c0.24567 1.40728 0.99035 2.59665 2.14547 3.45118-0.38268 0.0803-0.75472 0.16595-1.11614 0.25748-1.02401-0.95019-1.69134-2.17677-1.9311-3.58051 0.29586-0.0455 0.59645-0.088 0.90177-0.12815zm7.098-0.6195c0.36909 1.04586 1.11201 1.96772 2.09173 2.70709 0.10925 0.0815 0.16477 0.18366 0.18189 0.28642l-1.10669 0.13937c-0.99922-0.84803-1.74567-1.89095-2.10296-3.06437l0.93603-0.0685zm6.9235-0.688c0.67145 1.03229 1.58976 1.90276 2.68464 2.55237-0.42638 0.085-0.85275 0.16653-1.27795 0.24271-0.97855-0.72638-1.7941-1.62874-2.39646-2.66398 0.32893-0.0413 0.65905-0.0845 0.98976-0.1311zm6.187-1.259c0.89527 0.86634 2.02972 1.50827 3.24153 1.92048-0.42992 0.16417-0.86338 0.3183-1.29862 0.46417-1.11733-0.51082-2.14016-1.21712-2.9504-2.11712 0.33662-0.0845 0.67205-0.17363 1.00748-0.26752zm6.2295-2.395c0.83031 0.6 1.92106 0.99626 2.89783 1.2378-0.33071 0.23149-0.66614 0.45118-1.00512 0.66378-0.99685-0.31595-2.01791-0.78603-2.79744-1.45807 0.30237-0.14233 0.60414-0.29055 0.90473-0.44351zm4.592-2.906c0.65964 0.33071 1.42913 0.56456 2.18149 0.72638-0.23799 0.26339-0.48071 0.51733-0.72697 0.76477-0.79016-0.20551-1.57854-0.4937-2.25295-0.89469 0.26752-0.19252 0.53386-0.39153 0.79842-0.59645z"
            S.path
              ! A.fill "none"
              ! A.strokeWidth "0.604"
              ! A.d "m393.76 134.456c0.0437 0.95374-0.22618 1.77579-1.125 3.28878-10.8118 18.1636-36.2918 9.84035-40.9435 18.3508-4.47225 8.17915 9.6425 18.5168 17.2376 24.5716-1.33288 0.4813-2.73839 0.90295-4.21654 1.26023l-1.32697 0.71811-1.96654 0.62067c-6.0691-5.7555-24.0414-22.6854-12.613-31.9087 8.22225-6.63605 31.1776 2.17382 44.954-16.9016z"
            S.path
              ! A.d "m407.522 132.016c13.4852 15.5386 37.1558 7.94825 47.9522 13.9984 18.7848 10.523-1.64823 35.4862-5.4933 40.2579l-20.4726-5.3427c7.5183-6.013 22.588-16.2266 18.0514-24.525-4.65296-8.50925-29.3734 0.12401-40.1835-18.0396-2.27303-3.82028-0.52854-7.12735 0.14587-6.349z"
            S.path
              ! A.fill "#F1BF31"
              ! A.d "m407.671 132.481c13.4834 15.5422 36.3898 8.0941 47.1862 14.1449 18.7842 10.5242-2.4313 34.8756-6.27875 39.649l-17.6823-5.3445c7.5189-6.013 21.7996-16.536 17.2624-24.835-4.65237-8.50865-29.824-0.0307-40.6329-18.1949-2.27363-3.82028-0.5315-6.19725 0.14527-5.4195z"
            S.path
              ! A.strokeWidth "0.633"
              ! A.d "m438.879 183.266c6.0697-5.75375 24.0585-22.8396 12.6284-32.0652-8.2205-6.63605-31.3317 2.02086-45.1081-17.0546l0.0496-0.46832c14.602 19.7168 36.5226 9.7636 45.9432 17.455 10.6258 8.6752-4.95 25.7374-12.46 32.5282z"
            S.path
              ! A.fill "#D99F31"
              ! A.stroke "none"
              ! A.d "m442.329 171.306c0.35787 0.67855 0.89409 1.84901 1.25551 3.33189 6.24155-7.43505 10.9176-15.14 5.9988-21.5044-4.47815-5.79625-15.4548-3.17245-26.8796-7.1876-5.2329-1.55197-10.3683-4.31575-14.742-9.4937 0.42048 1.13268 0.85335 2.50394 1.33642 3.87638 11.5931 14.7685 34.7575 7.69195 39.1701 15.7648 2.60315 4.7628-1.09548 10.2584-6.13935 15.2126z"
            S.path
              ! A.stroke "none"
              ! A.d "m448.048 170.6c-1.50177-0.37264-2.24764-1.0311-3.23268-1.9252-0.29587 0.34134-0.60118 0.6815-0.91536 1.01988 0.68918 0.66437 1.39725 1.31575 2.46202 1.78996 0.92007 0.40807 1.88917 0.56457 2.81398 0.61063 0.34547-0.45177 0.68327-0.90768 1.01279-1.36831-0.73642 0.0454-1.51004 0.0296-2.14075-0.12697zm2.8125-6.3925c-1.13563-0.17835-1.59331-0.29292-2.49213-0.8002-0.1559 0.34311-0.32952 0.68681-0.51791 1.03051 0.75768 0.43996 1.37598 0.70453 2.42657 0.91949 1.0565 0.21792 2.15197 0.15355 3.12284-0.008 0.20846-0.44527 0.40217-0.89055 0.57579-1.33523-0.94901 0.18307-2.175 0.34134-3.11516 0.1937zm-1.538-4.8125c2.07401-0.19902 4.08425-1.28445 5.4939-2.82756-0.0992-0.41339-0.23091-0.82028-0.39272-1.22008-0.81023 1.01456-2.5689 2.76791-5.18445 2.99587 0.0543 0.34842 0.0815 0.69921 0.0833 1.05177zm-1.8045-4.554c1.48051-0.86339 2.70236-2.22815 3.45472-3.77126-0.2746-0.19666-0.56338-0.37855-0.86693-0.54626-0.5498 1.16693-1.58327 2.74075-3.38799 3.64252 0.28996 0.20787 0.5563 0.43287 0.80019 0.675zm-3.986-6.1505c-0.24626 1.40728-0.99095 2.59606-2.14489 3.45059 0.38268 0.0803 0.75414 0.16594 1.11555 0.25748 1.02343-0.9502 1.69134-2.17678 1.93052-3.57993-0.29587-0.0455-0.59587-0.088-0.90118-0.12815zm-7.098-0.6195c-0.3691 1.04586-1.11083 1.96772-2.09233 2.70709-0.10866 0.0815-0.16476 0.18307-0.1813 0.28582l1.10788 0.13996c0.99862-0.84803 1.74508-1.89094 2.10236-3.06437l-0.93661-0.0685zm-6.9225-0.688c-0.67146 1.0317-1.59036 1.90217-2.68642 2.55178 0.42697 0.085 0.85334 0.16712 1.27913 0.2433 0.97737-0.72638 1.79351-1.62874 2.39528-2.66398-0.32835-0.0408-0.65788-0.0844-0.988-0.1311zm-6.188-1.259c-0.89528 0.86634-2.02914 1.50827-3.24036 1.91989 0.42933 0.16417 0.86339 0.31771 1.29744 0.46417 1.11851-0.51082 2.14016-1.21712 2.9504-2.11653-0.33603-0.0845-0.67205-0.17363-1.00748-0.26752zm-6.2285-2.3945c-0.82973 0.59941-1.92048 0.99567-2.89784 1.23721 0.3313 0.23149 0.66733 0.45 1.00571 0.66319 0.99568-0.31595 2.01615-0.78544 2.79627-1.45689-0.30296-0.14174-0.60414-0.29055-0.90414-0.44351zm-4.5935-2.9065c-0.65906 0.3313-1.42855 0.56457-2.17973 0.72638 0.2374 0.26339 0.48012 0.51674 0.72579 0.76418 0.79016-0.20551 1.57737-0.4937 2.25237-0.8941-0.26752-0.19311-0.53386-0.39153-0.79843-0.59645z"
            S.path
              ! A.fill "none"
              ! A.strokeWidth "0.604"
              ! A.d "m406.399 134.456c-0.0437 0.95374 0.22677 1.77579 1.12795 3.28878 10.8088 18.1636 36.2894 9.84035 40.9424 18.3508 4.47048 8.17915-9.6437 18.5168-17.2394 24.5716 1.33288 0.4813 2.73839 0.90295 4.21713 1.26023l1.32638 0.71811 1.96654 0.62067c6.0691-5.7555 24.0414-22.6854 12.6136-31.9087-8.22225-6.63605-31.1782 2.17382-44.9546-16.9016z"
        S.g
          $ do
            S.path
              ! A.fill "#000000"
              ! A.d "m400.079 166.698h-6.84155s0.81023-6.52205-0.10571-10.9406c-0.74114-3.57284-3.59174-7.67365-3.59174-10.6807 0-3.00591 3.25571-11.4526 3.25571-11.4526h7.28326 7.28445s3.0998 8.44665 3.0998 11.4526c0 3.00709-2.69587 7.1079-3.43701 10.6807-0.91535 4.41851-0.1057 10.9406-0.1057 10.9406h-6.84155z"
            S.path
              ! A.fill "#F1BF31"
              ! A.stroke "none"
              ! A.d "m400.079 166.698h-6.84155s1.05295-6.5114 0.20374-10.9406c-0.69154-3.60414-3.1252-6.401-3.44646-10.0571-0.4565-5.1579 4.04232-12.0762 4.04232-12.0762h6.04195 6.0425s4.34351 6.9183 3.88819 12.0762c-0.32126 3.6561-2.60138 6.45295-3.29291 10.0571-0.84862 4.42913 0.20374 10.9406 0.20374 10.9406h-6.84155z"
            S.path
              ! A.fill "#D99F31"
              ! A.stroke "none"
              ! A.d "m389.977 144.402c0.43051-0.14646 0.88583-0.24862 1.31811-0.24862 1.50118 0 2.09528 0.98031 2.09528 0.98031s3.93189-0.91004 6.68919-0.91004c2.75729 0 6.69036 0.91004 6.69036 0.91004s0.59409-0.98031 2.09468-0.98031c0.38091 0 0.77953 0.0791 1.1628 0.19902 0.0254 0.45826 0.0224 0.90944-0.0159 1.34823-0.32185 3.65846-2.60374 6.45294-3.29292 10.0571-0.42047 2.18918-0.37677 4.88623-0.22382 7.0553l-6.41515 3.0502-6.41515-3.05079c0.15296-2.16909 0.19784-4.86555-0.22204-7.05475-0.69154-3.60413-3.12461-6.39865-3.44823-10.0571-0.0372-0.42283-0.0414-0.85689-0.0171-1.29862z"
            S.path
              ! A.fill "#000000"
              ! A.stroke "none"
              ! A.d "m407.092 146.815c-0.29882 0.94311-0.77835 2.45256-1.1941 3.975-0.41516 1.52185-0.7683 3.05374-0.81555 4.04468-0.19074 3.8693 0.47244 8.0699 1.24194 11.863h-0.27875c-1.08661-3.31772-2.34508-8.42835-2.29665-11.8695 0.0272-2.09468 1.35237-6.15235 2.03091-8.0935 0.97795-2.80335 0.77657-4.69665 0.0868-6.57345-0.69095-1.88563-1.87028-3.75413-2.83819-6.4949-0.006-0.0177-0.004-0.0319 0.002-0.0425h1.29744c0.99035 2.69646 2.10354 4.58209 2.76614 6.49135 0.67264 1.9376 0.88465 3.89528-0.002 6.6998zm-13.2495 19.883c0.77303-3.82619 1.41732-7.97245 1.24252-11.863-0.0437-0.98859-0.39685-2.52048-0.81614-4.04468-0.41516-1.52422-0.89646-3.03367-1.1941-3.97441-0.88878-2.8063-0.18071-6.13291 0.74587-8.7508 0.80374-2.26949 1.77165-4.01398 2.01614-4.44095h1.34705c-0.41279 0.67737-4.64291 7.8266-2.79626 13.1114 0.67677 1.94115 2.00079 5.99825 2.03032 8.09115 0.0466 3.43701-1.21595 8.5571-2.29902 11.8712h-0.27638z"
            S.path
              ! A.d "m400.079 166.698h-6.84155s1.05295-6.5114 0.20374-10.9406c-0.69154-3.60414-3.1252-6.401-3.44646-10.0571-0.4565-5.1579 4.04232-12.0762 4.04232-12.0762h6.04195 6.0425s4.34351 6.9183 3.88819 12.0762c-0.32126 3.6561-2.60138 6.45295-3.29291 10.0571-0.84862 4.42913 0.20374 10.9406 0.20374 10.9406h-6.84155z"
            S.ellipse
              ! A.fill "#FFFFFF"
              ! A.strokeWidth "0.915"
              ! A.cx "400"
              ! A.cy "140.64"
              ! A.rx "3.409"
              ! A.ry "2.507"
            S.ellipse
              ! A.strokeWidth "1.029"
              ! A.cx "400"
              ! A.cy "140.492"
              ! A.rx "3.835"
              ! A.ry "2.735"
            S.circle
              ! A.fill "#FFFFFF"
              ! A.strokeWidth "0.915"
              ! A.cx "400"
              ! A.cy "148.23"
              ! A.r  "3.683"
            S.circle
              ! A.strokeWidth "1.029"
              ! A.cx "400"
              ! A.cy "148.23"
              ! A.r  "4.143"
        S.g
          $ do
            S.path
              ! A.strokeWidth "0.904"
              ! A.d "m360.414 204.281s-1.05709-1.06536-1.37835-1.93524c-0.25512-0.68503-0.27815-1.85433-0.27815-1.85433l-3.78779-6.0691 8.5075-8.08935 16.1764-4.64055 20.3953-1.45748h0.0313l20.3982 1.45748 16.174 4.64055 8.5063 8.08935-3.78662 6.0691s-0.0231 1.16929-0.27815 1.85433c-0.32243 0.86988-1.37894 1.93524-1.37894 1.93524l-18.9714-6.4122-20.6634-0.9254-20.6924 0.9254-18.9738 6.4122z"
            S.path
              ! A.fill "#F1BF31"
              ! A.d "m360.873 203.597s-0.75768-0.94725-1.04646-1.65532c-0.41752-1.02342-0.36318-2.81338-0.36318-2.81338l-4.49351-4.70493 8.5069-8.08935 16.1746-4.64055 20.429-1.45748 20.4266 1.45748 16.177 4.64055 8.50395 8.08935-4.49056 4.70493s0.052 1.78996-0.36555 2.81338c-0.28642 0.70807-1.04645 1.65532-1.04645 1.65532l-18.5144-5.72715-20.6906-0.92775-20.6924 0.92775-18.515 5.72715z"
            S.path
              ! A.fill "#000000"
              ! A.d "M358.832,207.288A41.168,12.777 0 1,1 441.168,207.288A41.168,10.824 0 1,1 358.832,207.288z"
            S.path
              ! A.fill "#F1BF31"
              ! A.d "M360.208,207.288A39.792,12.312 0 1,1 439.792,207.288A39.792,10.523 0 1,1 360.208,207.288z"
            S.ellipse 
              ! A.fill "#D99F31"
              ! A.cx "400"
              ! A.cy "208.415"
              ! A.rx "36.785"
              ! A.ry "9.395"
            S.path
              ! A.strokeWidth "1.01"
              ! A.d "m435.909 206.262c-7.0565 2.68819-20.2819 4.03287-35.8589 4.0311-15.5776 0-28.8018-1.34409-35.8577-4.03169"
            S.path
              ! A.d "m432.459 203.885c-7.4947 2.17441-19.092 3.40335-32.4088 3.40216-13.317 0-24.9124-1.22834-32.4071-3.40216"
            S.path
              ! A.d "m427.478 202.07c-7.2313 1.42677-16.78 2.21279-27.4282 2.21279s-20.1962-0.78602-27.4276-2.21279"
            S.path
              ! A.d "m419.092 200.318c-5.65925 0.62421-12.1181 0.9561-19.0424 0.9561-6.92365 0-13.3825-0.33188-19.0418-0.9561"
            S.ellipse
              ! A.cx "400"
              ! A.cy "208.415"
              ! A.rx "36.475"
              ! A.ry "9.093"
            S.path
              ! A.fill "#000000"
              ! A.strokeLinejoin "round"
              ! A.d "m354.757 192.762c-3.61122-4.80295-6.8309-8.07285-14.6486-10.8342 1.07303-0.86398 2.97107-1.64882 4.7941-2.09705 2.9752-0.73288 6.01535-0.33484 7.97065 0.68918-1.55257-5.55476 1.42854-11.0941 1.42854-11.0941s4.81772-0.27579 9.6992 3.64606c0.15945-6.72695 2.13189-9.92065 2.13189-9.92065s5.07045 0.24331 10.2573 5.39645c0.988-6.9579 4.74213-10.7344 4.74213-10.7344s6.22915 1.95118 9.79015 8.52345c2.37283-9.52265 9.1559-13.2532 9.1559-13.2532s6.78545 3.73051 9.1571 13.2532c3.5622-6.57225 9.79195-8.52345 9.79195-8.52345s3.73051 3.64016 4.74213 10.7344c5.1868-5.15315 10.2567-5.39645 10.2567-5.39645s1.97303 3.1937 2.13307 9.92065c4.88091-3.92185 10.1782-2.4626 10.1782-2.4626s2.50157 4.35591 0.94842 9.91065c1.95414-1.02401 4.99607-1.42205 7.97125-0.68918 1.82244 0.44823 3.72048 1.23307 4.7941 2.09705-7.0016 2.54115-11.1916 6.0313-14.804 10.8342-3.37855-6.9018-21.4548-14.4927-45.1689-14.4927-23.7112 0-41.9434 7.59094-45.3213 14.4927z"
            S.path
              ! A.fill "#F1BF31"
              ! A.strokeLinejoin "round"
              ! A.d "m354.757 191.986c-3.08799-4.84016-7.5455-8.3823-12.1695-10.1722 1.07363-0.86338 2.95867-1.1935 4.95591-1.33287 2.34213-0.16182 4.29154 0.16594 5.9451 0.95079-1.55315-5.55175 0.9691-11.2305 0.9691-11.2305s4.96654 0.0189 9.84805 3.94075c0.16004-6.72695 2.29252-10.0636 2.29252-10.0636s4.75512 0.52913 9.94135 5.68465c1.11319-6.9455 4.74862-10.8656 4.74862-10.8656s6.22855 1.93288 9.78955 8.50275c2.37343-9.5203 9.0006-12.923 9.0006-12.923s6.6301 3.40276 9.00355 12.923c3.56044-6.56989 9.78955-8.50275 9.78955-8.50275s3.75178 3.51083 4.74863 10.8656c5.1868-5.1555 9.94135-5.68465 9.94135-5.68465s2.13189 3.33661 2.29252 10.0636c4.8815-3.92185 10.4664-2.85709 10.4664-2.85709s1.90394 4.59508 0.35138 10.1468c1.65236-0.78485 3.60177-1.1126 5.94215-0.95079 1.99724 0.13937 3.88465 0.46949 4.95768 1.33287-4.62343 1.78996-9.0815 5.3321-12.1689 10.1722-3.37855-6.9018-21.61-13.8596-45.3242-13.8596-23.7112 0-41.9434 6.9579-45.3213 13.8596z"
            S.path
              ! A.fill "#000000"
              ! A.d "m352.995 194.157c0-8.75375 20.9002-16.1852 47.0534-16.1852 26.1555 0 46.2815 7.7303 46.2815 15.4104 0 1.84016-1.62579 3.42343-3.77067 4.76929 0.20729-0.57696 0.31122-1.16693 0.31122-1.76279 0-7.6801-16.6666-13.9051-42.822-13.9051-26.1532 0-42.8197 6.225-42.8197 13.9051 0 0.59586 0.10571 1.18582 0.31181 1.76279-2.14548-1.34586-4.54548-2.15551-4.54548-3.99449z"
            S.path
              ! A.fill "#F1BF31"
              ! A.strokeWidth "0.904"
              ! A.d "m354.222 193.382c0-6.64195 19.6748-14.9451 45.828-14.9451 26.1538 0 45.8286 8.30315 45.8286 14.9451 0 1.84016-2.04744 2.02441-2.23229 1.45807-2.19803-6.73405-17.4425-12.6679-43.5963-12.6679-26.1532 0-41.3976 5.93385-43.5963 12.6679-0.18484 0.56634-2.2317 0.38208-2.2317-1.45807z"
            S.path
              ! A.fill "#000000"
              ! A.strokeWidth "0.45"
              ! A.strokeLinejoin "round"
              ! A.d "m399.577 172.094c0.15177-2.3504 0.46299-7.5685 0.46299-7.5685 0.007-0.052 0.0732-0.82796 0.0791-0.77422 0 0 0.29292 5.98995 0.43406 8.3386 0.14114 2.3439 0.28878 6.01475 0.28878 6.01475 0 0.0207-0.0165 0.0396-0.0396 0.0396l-1.50296 0.008c-0.0212 0-0.0395-0.0189-0.0395-0.0396 0 0 0.16595-3.675 0.31713-6.0189zm38.4561 13.549c0.40866-0.81201 0.91713-1.84311 1.2874-2.65453 0.75296-1.65532 2.10946-4.30453 2.10946-4.30453 0.0189-0.0502-0.0437-0.0785-0.0709-0.0336 0 0-1.69842 2.40118-2.65335 3.8935-0.50374 0.78957-1.18523 1.79055-1.72145 2.56713zm-12.8116-4.64353c0.22795-0.51083 1.29508-2.88957 2.12362-4.41556 0.98681-1.81417 2.76969-4.51181 2.76969-4.51181 0.0289-0.0454 0.0898-0.01 0.0667 0.0378 0 0-1.27914 2.73012-2.01378 4.51181-0.7187 1.73977-1.71378 4.51182-1.71378 4.51182l-0.65965 0.009zm-11.599-2.087c0.28169-1.11968 0.85748-3.3685 1.31575-4.95059 0.64429-2.21752 1.03819-3.45709 1.78996-5.63975 0.0165-0.0514 0.0856-0.0325 0.075 0.0189-0.42402 2.25472-0.6502 3.52972-1.03642 5.79095-0.27402 1.6122-0.63839 3.91358-0.80138 4.94941zm-39.3096 2.24384l-0.57106 0.004c-0.0378-0.0271-1.03169-2.79862-1.75039-4.53891-0.73524-1.78103-2.01437-4.51115-2.01437-4.51115-0.0224-0.0485 0.0378-0.0839 0.0667-0.0378 0 0 1.78346 2.69764 2.76968 4.51181 0.82914 1.52422 1.89567 3.90414 2.12363 4.41497zm10.8817-2.07498c-0.16418-1.03642-0.52973-3.33721-0.80315-4.94884-0.38445-2.26065-0.6124-3.53565-1.03583-5.79097-0.009-0.0532 0.0579-0.0703 0.075-0.0207 0.75118 2.18268 1.14567 3.42402 1.78878 5.64155 0.45945 1.5815 1.03465 3.8315 1.31752 4.9506zm-23.1862 6.6231c-0.41339-0.82086-0.93779-1.88386-1.31693-2.71595-0.75591-1.65532-2.10945-4.30454-2.10945-4.30454-0.0206-0.0502 0.0431-0.0785 0.0679-0.0336 0 0 1.69902 2.40118 2.65394 3.89351 0.51614 0.80728 1.21831 1.83779 1.76044 2.62146z"
        S.g
          ! A.strokeWidth "0.777"
          ! A.strokeLinecap  "round"
          ! A.strokeLinejoin "round"
          $ do
            S.path
              ! A.fill "#D99F31"
              ! A.strokeWidth "0.719"
              ! A.d "m361.605 197.422c-0.33662-1.9063-1.98485-3.44056-3.25571-3.21674-1.26851 0.22264-3.07264 2.12244-2.73603 4.02638 0.33425 1.90571 2.71713 3.29056 3.988 3.0691 1.26909-0.22441 2.33976-1.97481 2.00374-3.87874z"
            S.path
              ! A.fill "#F1BF31"
              ! A.stroke "none"
              ! A.d "m359.49 195.078c0.35315 0.41752 0.56693 0.95787 0.56693 1.54783 0 1.32343-1.07126 2.39469-2.39351 2.39469-0.43819 0-0.84802-0.11811-1.20058-0.32244-0.065-0.17008-0.11516-0.34666-0.14705-0.52855-0.29114-1.65118 0.97146-3.1435 2.06989-3.3372 0.0809-0.0142 0.16003-0.0206 0.24035-0.0206 0.29646 0 0.58996 0.0945 0.86397 0.26634z"
            S.path
              ! A.d "m360.903 197.466c-0.29055-1.64882-1.41792-2.82815-2.51634-2.63504-1.10079 0.19311-2.36103 1.68779-2.07225 3.33661 0.29292 1.64823 2.05571 2.84823 3.15414 2.65512 1.10019-0.19252 1.72559-1.70846 1.43445-3.35669z"
            S.path
              ! A.fill "#D99F31"
              ! A.d "m375.4 192.846l-0.59764-3.58347-2.413-1.21653s-2.59311 0.70393-4.20886 1.27855c-1.67362 0.59409-4.21063 1.73149-4.21063 1.73149l-0.60236 1.05295 0.75413 4.05296 1.35118 1.20236 9.0201-2.70531 0.90709-1.813z"
            S.path
              ! A.fill "#F1BF31"
              ! A.stroke "none"
              ! A.d "m365.464 195.441l7.226-2.2865 0.45-0.7485-0.6245-3.7525-0.26-0.257-8.0245 2.944 0.611 3.4025z"
            S.path
              ! A.strokeWidth "1.09"
              ! A.d "m365.464 195.441l7.226-2.2865 0.45-0.7485-0.475-3.001m2.55548 3.44149l-2.08047-0.442"
            S.path
              ! A.fill "#F1BF31"
              ! A.stroke "none"
              ! A.d "m385.724 189.003c-0.0721-0.82618 0.54035-1.55729 1.36713-1.62756 0.82795-0.0726 1.55728 0.5374 1.62932 1.36653 0.0732 0.82618-0.53976 1.55492-1.36594 1.62756-0.82855 0.0726-1.55729-0.54035-1.63052-1.36653zm-3.48189 3.32244c-0.072-0.82618 0.54035-1.55551 1.36653-1.62815 0.82855-0.0726 1.55729 0.53977 1.62993 1.36654 0.0726 0.82618-0.53977 1.55728-1.36595 1.62992-0.82855 0.0703-1.55728-0.54036-1.63051-1.36831zm-3.55394-2.66811c-0.0732-0.82677 0.53976-1.55551 1.36594-1.62756 0.82619-0.0732 1.40552 0.53977 1.47816 1.36595 0.0726 0.82854-0.38799 1.55728-1.21654 1.62992-0.82618 0.0703-1.55552-0.53977-1.62756-1.36831zm3.03071-3.32244c-0.072-0.82618 0.54035-1.55492 1.36653-1.62756 0.82677-0.0726 1.55729 0.54035 1.62756 1.36653 0.0732 0.82618-0.53976 1.5567-1.36594 1.62756-0.82618 0.0726-1.55492-0.53976-1.62815-1.36653z"
            S.path
              ! A.fill "#D99F31"
              ! A.stroke "none"
              ! A.d "m385.814 189.398c0.19725-0.52559 0.68149-0.92008 1.27736-0.97145 0.68977-0.0597 1.31044 0.35315 1.54075 0.97205-0.19724 0.52618-0.68149 0.9183-1.27736 0.97027-0.68977 0.0608-1.30984-0.35374-1.54075-0.97087zm-4.00512-2.66752c0.23032 0.6183 0.8504 1.03111 1.53839 0.97087 0.59645-0.0526 1.08071-0.44646 1.27736-0.97205-0.22972-0.61654-0.85098-1.03051-1.53897-0.97028-0.59528 0.052-1.07953 0.44587-1.27677 0.97146zm-3.03189 3.32126c0.23032 0.6189 0.85099 1.03229 1.54075 0.97382 0.58406-0.0514 0.98681-0.43229 1.14626-0.94429-0.18838-0.63307-0.71102-1.06181-1.40964-0.99981-0.59587 0.052-1.08012 0.44528-1.27737 0.97028zm3.55571 2.66693c0.22855 0.61772 0.84922 1.03287 1.5378 0.97264 0.59823-0.052 1.08248-0.44645 1.27854-0.97264-0.2309-0.61653-0.85098-1.02992-1.54016-0.96968-0.59468 0.0526-1.07894 0.44586-1.27618 0.96968z"
            S.path
              ! A.strokeWidth "0.933"
              ! A.d "m385.724 189.003c-0.0721-0.82618 0.54035-1.55729 1.36713-1.62756 0.82795-0.0726 1.55728 0.5374 1.62932 1.36653 0.0732 0.82618-0.53976 1.55492-1.36594 1.62756-0.82855 0.0726-1.55729-0.54035-1.63052-1.36653zm-3.48189 3.32244c-0.072-0.82618 0.54035-1.55551 1.36653-1.62815 0.82855-0.0726 1.55729 0.53977 1.62993 1.36654 0.0726 0.82618-0.53977 1.55728-1.36595 1.62992-0.82855 0.0703-1.55728-0.54036-1.63051-1.36831zm-3.55394-2.66811c-0.0732-0.82677 0.53976-1.55551 1.36594-1.62756 0.82619-0.0732 1.40552 0.53977 1.47816 1.36595 0.0726 0.82854-0.38799 1.55728-1.21654 1.62992-0.82618 0.0703-1.55552-0.53977-1.62756-1.36831zm3.03071-3.32244c-0.072-0.82618 0.54035-1.55492 1.36653-1.62756 0.82677-0.0726 1.55729 0.54035 1.62756 1.36653 0.0732 0.82618-0.53976 1.5567-1.36594 1.62756-0.82618 0.0726-1.55492-0.53976-1.62815-1.36653z"
            S.path 
              ! A.fill "#D99F31"
              ! A.stroke "none"
              ! A.d "m392.853 190.393v-3.8935l2.2695-2.113h9.918l2.2695 2.113 0.002 3.8915-2.2715 1.9645h-9.918z"
            S.path
              ! A.fill "#F1BF31"
              ! A.stroke "none"
              ! A.d "m405.238 184.846l-0.798 0.814v3.717l-0.633 0.625-7.51-0.054-0.623-0.6235v-3.569l-0.6725-0.9095z"
            S.path
              ! A.d "m392.853 190.393v-3.8935l2.2695-2.113h9.918l2.2695 2.113 0.002 3.8915-2.2715 1.9645h-9.918z"
            S.path
              ! A.strokeWidth "1.09"
              ! A.d "m393.463 190.23l2.21103-0.85099m10.9926 0.91122l-2.22639-0.91358m-9.0502 2.72835l0.90118-2.10355m8.4195 2.10355l-0.90118-2.10355m0.63071-4.34114v3.71634l-0.63071 0.6248-7.5118-0.0537-0.62362-0.62303v-3.71634"
            S.path
              ! A.fill "#F1BF31"
              ! A.stroke "none"
              ! A.d "m414.374 189.003c0.0732-0.82618-0.53918-1.55729-1.36595-1.62756-0.82795-0.0726-1.55728 0.5374-1.62932 1.36653-0.0709 0.82618 0.53976 1.55492 1.36831 1.62756 0.82618 0.0726 1.55491-0.54035 1.62697-1.36653zm3.48307 3.32244c0.072-0.82618-0.54035-1.55551-1.36712-1.62815-0.82618-0.0726-1.55728 0.53977-1.62933 1.36654-0.0709 0.82618 0.53976 1.55728 1.36831 1.62992 0.82618 0.0703 1.55492-0.54036 1.62815-1.36831zm3.55394-2.66811c0.0732-0.82677-0.53976-1.55551-1.36594-1.62756-0.82618-0.0732-1.40552 0.53977-1.47874 1.36595-0.072 0.82854 0.39035 1.55728 1.21712 1.62992 0.82618 0.0703 1.55552-0.53977 1.62756-1.36831zm-3.02893-3.32244c0.0703-0.82618-0.53977-1.55492-1.3689-1.62756-0.82619-0.0726-1.55492 0.54035-1.62697 1.36653-0.0732 0.82618 0.53976 1.5567 1.36594 1.62756 0.82618 0.0726 1.55492-0.53976 1.62992-1.36653z"
            S.path
              ! A.fill "#D99F31"
              ! A.stroke "none"
              ! A.d "m414.285 189.398c-0.19666-0.52618-0.68149-0.92008-1.27736-0.97145-0.68918-0.0597-1.30926 0.35315-1.54016 0.97145 0.19783 0.52618 0.68208 0.9189 1.27795 0.97087 0.68977 0.0608 1.31044-0.35374 1.53957-0.97087zm1.18937-2.66811c0.19725 0.52559 0.6809 0.9189 1.27854 0.97145 0.688 0.0602 1.30807-0.35256 1.53839-0.97086-0.19666-0.525-0.6809-0.91949-1.27855-0.97146-0.68799-0.0602-1.30806 0.35374-1.53838 0.97087zm3.16122 3.3502c0.15827 0.5126 0.56162 0.89409 1.14862 0.94547 0.68859 0.0585 1.30866-0.35492 1.5378-0.97441-0.19725-0.525-0.68149-0.91771-1.27736-0.96968-0.69803-0.062-1.21949 0.36614-1.40906 0.99862zm-3.68622 2.63917c0.19666 0.52559 0.68149 0.92008 1.27796 0.97205 0.68917 0.0602 1.30925-0.35374 1.54016-0.96968-0.19666-0.52618-0.6815-0.92008-1.27796-0.97264-0.6874-0.0602-1.30866 0.35315-1.54016 0.97027z"
            S.path
              ! A.strokeWidth "0.933"
              ! A.d "m414.374 189.003c0.0732-0.82618-0.53918-1.55729-1.36595-1.62756-0.82795-0.0726-1.55728 0.5374-1.62932 1.36653-0.0709 0.82618 0.53976 1.55492 1.36831 1.62756 0.82618 0.0726 1.55491-0.54035 1.62697-1.36653zm3.48307 3.32244c0.072-0.82618-0.54035-1.55551-1.36712-1.62815-0.82618-0.0726-1.55728 0.53977-1.62933 1.36654-0.0709 0.82618 0.53976 1.55728 1.36831 1.62992 0.82618 0.0703 1.55492-0.54036 1.62815-1.36831zm3.55394-2.66811c0.0732-0.82677-0.53976-1.55551-1.36594-1.62756-0.82618-0.0732-1.40552 0.53977-1.47874 1.36595-0.072 0.82854 0.39035 1.55728 1.21712 1.62992 0.82618 0.0703 1.55552-0.53977 1.62756-1.36831zm-3.02893-3.32244c0.0703-0.82618-0.53977-1.55492-1.3689-1.62756-0.82619-0.0726-1.55492 0.54035-1.62697 1.36653-0.0732 0.82618 0.53976 1.5567 1.36594 1.62756 0.82618 0.0726 1.55492-0.53976 1.62992-1.36653z"
            S.path
              ! A.fill "#D99F31"
              ! A.d "m424.7 192.846l0.59823-3.58347 2.4124-1.21653s2.59311 0.70393 4.20886 1.27855c1.67303 0.59409 4.21063 1.73149 4.21063 1.73149l0.60237 1.05295-0.75355 4.05296-1.35176 1.20236-9.02011-2.70531-0.90708-1.813z"
            S.path
              ! A.fill "#F1BF31"
              ! A.stroke "none"
              ! A.d "m434.635 195.441l-7.2235-2.2865-0.453-0.7485 0.627-3.7525 0.257-0.257 8.0275 2.944-0.6125 3.4025z"
            S.path
              ! A.strokeWidth "1.09"
              ! A.d "m434.635 195.441l-7.2235-2.2865-0.453-0.7485 0.476-3.001m-1.88401 4.9525l1.8605-1.2025"
            S.path
              ! A.fill "#D99F31"
              ! A.strokeWidth "0.719"
              ! A.d "m438.405 197.422c0.33662-1.9063 1.98544-3.44056 3.25335-3.21674 1.27087 0.22264 3.07559 2.12244 2.74134 4.02638-0.33661 1.90571-2.72008 3.29056-3.99095 3.0691-1.2685-0.22441-2.33976-1.97481-2.00374-3.87874z"
            S.path
              ! A.fill "#F1BF31"
              ! A.stroke "none"
              ! A.d "m439.953 196.626c0-0.58996 0.21378-1.13032 0.56811-1.54784 0.27342-0.17185 0.56752-0.26634 0.86338-0.26634 0.0786 0 0.15945 0.007 0.23859 0.0207 1.10019 0.1937 2.36043 1.68603 2.06988 3.33721-0.0319 0.18248-0.0821 0.36023-0.14704 0.53031-0.35256 0.20374-0.76182 0.32067-1.19883 0.32067-1.32224 0-2.39409-1.07126-2.39409-2.39468z"
            S.path
              ! A.d "m439.106 197.466c0.29055-1.64882 1.4185-2.82815 2.51693-2.63504 1.10019 0.19311 2.36279 1.68779 2.07224 3.33661-0.29114 1.64823-2.05394 2.84823-3.15413 2.65512-1.10079-0.19252-1.72559-1.70846-1.43504-3.35669z"
            S.path
              ! A.strokeWidth "0.833"
              ! A.d "m424.278 192.878l0.65197-3.89292 2.56181-1.27086s2.77677 0.75591 4.50827 1.37067c1.78937 0.63485 4.50768 1.8437 4.50768 1.8437l0.64547 1.12736-0.80551 4.35178-1.44921 1.28918-9.6614-2.89843-0.959-1.921zm-31.9069-6.5321l2.39646-2.24233h10.6246l2.39586 2.24233 0.004 4.21063-2.39999 2.08228h-10.6246l-2.39646-2.08228v-4.21063zm-16.5502 6.5321l-0.65197-3.89292-2.56241-1.27086s-2.77618 0.75591-4.50768 1.37067c-1.78996 0.63485-4.50768 1.8437-4.50768 1.8437l-0.64311 1.12736 0.80315 4.35178 1.44922 1.28918 9.6614-2.89843 0.95905-1.92048z"
        S.g
          ! A.strokeLinecap  "round"
          ! A.strokeLinejoin "round"
          $ do
            S.path
              ! A.fill "#D99F31"
              ! A.strokeWidth "0.952"
              ! A.d "m408.129 95.8505c1.77579 0 3.07146 1.58445 3.07146 3.36378 0 1.77992-1.29567 3.52382-3.07146 3.52382-2.3191 0-5.6864-2.74311-5.57245-0.56043l0.0561 1.10433 1.2313 10.1451c3.02244 0.6809-10.5544 0.6809-7.53305 0l1.23543-10.1906 0.0537-1.05886c0.11044-2.18091-3.34016 0.56043-5.57065 0.56043-1.77756 0-3.07087-1.7439-3.07087-3.52382 0-1.77933 1.29331-3.36378 3.07087-3.36378 1.7504 0 3.68327 1.63052 4.92284 0.863975 1.95-1.20236-0.39685-3.90768-0.39685-5.7307 0-1.7752 1.74449-3.22441 3.52382-3.22441 1.77756 0 3.52382 1.44922 3.52382 3.22441 0 1.82303-2.36279 4.44922-0.39507 5.7307 1.17401 0.766535 3.10925-0.863975 4.92106-0.863975z"
            S.path
              ! A.fill "#F1BF31"
              ! A.stroke "none"
              ! A.d "m397.49 91.5085c-0.20846-0.24803-0.36201-0.52323-0.4624-0.81142 0.37854-1.31811 1.66063-2.36988 3.05315-2.36988 0.61004 0 1.19823 0.20315 1.7002 0.540945-0.1063 0.360235-0.91712 0.434645-1.68307 1.07716-1.09843 0.91949-1.68779 2.65984-2.60787 1.56319zm0.5055 5.0955c0.14173 0.198425 0.2185 0.410435 0.2185 0.6313 0 1.09902-1.8998 1.98957-4.24429 1.98957-1.96359 0-3.61536-0.626575-4.09843-1.47638 0.56929-0.881695 1.59567-1.47342 2.69056-1.47342 1.63642 0 3.87461 1.3937 5.03325 0.679135 0.16948-0.10453 0.30059-0.22205 0.40039-0.350195zm3.2675 0.168c0-0.51319 0.2433-0.99331 0.66555-1.40256-0.10512 0.625985 0.0212 1.18288 0.6372 1.58504 1.09666 0.714565 3.33662-0.679135 5.0309-0.679135 1.07776 0 2.08937 0.573425 2.66516 1.4315-0.65079 1.04055-2.35689 1.78228-4.35768 1.78228-2.5624 0-4.64114-1.21654-4.64114-2.71712z"
            S.path
              ! A.d "m407.596 96.2765c1.65886 0 3.15768 1.35532 3.15768 3.01594 0 1.65946-1.49882 3.01536-3.15768 3.01536s-5.7372-2.90256-5.6392-0.68976l0.0537 1.18169 0.69744 9.78365c2.82401 0.63544-8.0829 0.63544-5.2612 0l0.70157-9.8268 0.0502-1.13859c0.0974-2.21102-4.10434 0.68977-5.63505 0.68977-1.65886 0-3.15827-1.35591-3.15827-3.01536 0-1.66063 1.49941-3.01594 3.15827-3.01594 1.63405 0 3.87402 1.39075 5.0327 0.678545 1.82126-1.12323-0.68327-3.77067-0.68327-5.47145 0-1.65827 1.5059-3.1559 3.16653-3.1559 1.66122 0 3.16654 1.49764 3.16654 3.1559 0 1.70079-2.51634 4.27382-0.67914 5.47145 1.09488 0.712205 3.33721-0.678545 5.02916-0.678545z"
            S.circle
              ! A.fill "#F1F1F2"
              ! A.strokeWidth "1.703"
              ! A.cx "400"
              ! A.cy "116.288"
              ! A.r  "7.901"
            S.path
              ! A.fill "#000000"
              ! A.stroke "none"
              ! A.d "m401.46 121.283c0.52973-0.6626 1.11496-1.50355 1.35827-2.28839 0.17894-0.57283 0.77422-0.30354 0.64548 0.18484-0.22618 0.85335-0.74528 1.74626-1.25374 2.4502zm-8.69537-4.65354c0.137-0.11575 0.29232-0.26103 0.47716-0.40866 0.18307-0.14764 0.39862-0.30531 0.65433-0.4506 0.33425-0.2244 0.10158-0.7435-0.30531-0.54626-0.42815 0.20847-0.78071 0.42697-1.0128 0.58347zm-0.0502 1.17166l0.41161 0.73464c0.57697-0.61004 1.54252-1.49882 1.69607-1.64232 0.35669-0.33839-0.10571-0.72874-0.41103-0.51083-0.35078 0.25099-0.85925 0.63544-1.2189 0.96733-0.19783 0.18248-0.36673 0.34429-0.47775 0.45118zm0.59764 1.76279l0.51319 0.59763c1.21299-0.94311 2.29075-2.08642 2.46496-2.27362 0.34252-0.37146-0.0543-0.87638-0.46063-0.5067-0.19311 0.20374-1.76693 1.60335-2.5063 2.17382l-0.0112 0.009zm10.7829 1.33288c0.38209-0.43229 0.79724-1.03642 0.93425-1.73563 0.0502-0.24744 0.22677-0.36555 0.40335-0.32835 0.17007 0.0372 0.29468 0.21378 0.25511 0.45059-0.13936 0.84272-0.57992 1.55906-0.99271 2.04036zm-6.05668 0.77172c1.10728-1.26614 1.91457-2.34803 2.64331-3.56457 0.10984-0.18307 0.30944-0.22854 0.45649-0.15591 0.15591 0.0744 0.22855 0.26162 0.12225 0.47953-0.4565 0.93485-1.07303 1.90394-1.6187 2.59311-0.54626 0.69154-0.95138 1.16516-0.95138 1.16516zm-2.24082-1.37469c0.74079-0.68533 1.58901-1.55227 2.05828-2.12777 0.27815-0.34074 0.88229-0.0768 0.5374 0.43406-0.44232 0.65374-1.12559 1.45984-1.75866 2.04272z"
            S.path
              ! A.fill "#D99F31"
              ! A.d "m406.135 133.626h-6.0573l-6.03305-0.002c-1.02402 1.72913-4.2567 2.90256-6.90235 1.52185-1.87855-0.98209-2.263-3.21201-2.263-3.21201s5.0622 0.18484 5.08935-4.2939c0-4.53898 2.60729-7.50415 6.3555-7.0553 1.63583 0.19488 2.74253 1.01988 3.75355 1.93878 1.01338-0.9189 2.12421-1.74626 3.76299-1.93878 3.74705-0.44469 6.349 2.51634 6.349 7.0199 0 4.51654 5.0888 4.33346 5.0888 4.33346s-0.38386 2.22579-2.26299 3.20788c-2.65571 1.38484-5.9073 0.19724-6.8805-1.52008z"
            S.path
              ! A.fill "#D99F31"
              ! A.stroke "none"
              ! A.d "m406.139 133.624h-0.41752c-1.12146 1.03996-2.88426 2.09468-5.64155 2.70532-2.75965-0.61063-4.52008-1.66536-5.64095-2.70532h-0.39449s-4.24016 3.0065-7.2136 0.75177c-1.09843-0.83091-1.33051-1.97717-1.33051-1.97717s5.0888-0.27756 5.0888-4.79409c0-4.50355 2.44429-6.401 5.73305-6.401 1.43681 0 2.74429 0.70984 3.75768 1.62992 1.01102-0.92008 2.32146-1.62992 3.75827-1.62992 3.28878 0 5.7325 1.89744 5.7325 6.401 0 4.51654 5.087 4.79409 5.087 4.79409s-0.23268 1.14626-1.32874 1.97717c-2.97579 2.25473-7.18995-0.75177-7.18995-0.75177z"
            S.path
              ! A.fill "#F1BF31"
              ! A.strokeWidth "0.904"
              ! A.d "m391.164 125.035c-0.26515 0.63957 0.15591 2.86358 0.15591 2.86358s0.1376 2.01969-1.45099 3.5563c-1.10905 1.07363-3.64606 1.54134-3.64606 1.54134m22.7788-7.9612c0.26634 0.63957-0.15532 2.86359-0.15532 2.86359s-0.137 2.01968 1.44922 3.5563c1.10846 1.07362 3.64606 1.54134 3.64606 1.54134"
            S.path
              ! A.fill "#F1BF31"
              ! A.stroke "none"
              ! A.d "m399.982 135.868c-6.29585-1.43032-7.112-5.32975-6.9372-5.28605 0.41279 0.10157 1.86673 2.94567 7.03405 4.38307 5.1685-1.4374 6.6195-4.2815 7.03525-4.38307 0.17421-0.0437-0.64193 3.85571-6.9372 5.28605h-0.19488zm-7.7355-11.121c0-1.52421 2.52638-2.80157 5.93445-3.15177 0.70335 0.29586 1.34528 0.73582 1.89922 1.23838 0.55157-0.50138 1.19173-0.94134 1.89331-1.23662 3.39921 0.35256 5.9179 1.62815 5.9179 3.15 0 3.61063-4.1256 5.3569-7.82365 5.3551-3.69804 0-7.82125-1.74449-7.82125-5.3551z"
            S.path
              ! A.d "m406.139 133.624h-0.41752c-1.12146 1.03996-2.88426 2.09468-5.64155 2.70532-2.75965-0.61063-4.52008-1.66536-5.64095-2.70532h-0.39449s-4.24016 3.0065-7.2136 0.75177c-1.09843-0.83091-1.33051-1.97717-1.33051-1.97717s5.0888-0.27756 5.0888-4.79409c0-4.50355 2.44429-6.401 5.73305-6.401 1.43681 0 2.74429 0.70984 3.75768 1.62992 1.01102-0.92008 2.32146-1.62992 3.75827-1.62992 3.28878 0 5.7325 1.89744 5.7325 6.401 0 4.51654 5.087 4.79409 5.087 4.79409s-0.23268 1.14626-1.32874 1.97717c-2.97579 2.25473-7.18995-0.75177-7.18995-0.75177z"
            S.path
              ! A.fill "#000000"
              ! A.d "m407.625 130.618s-0.75177 5.0516-7.5455 6.5551c-6.7955-1.50355-7.54725-6.5551-7.54725-6.5551s0.75177 4.20827 7.54725 5.7118c6.7937-1.50355 7.5455-5.7118 7.5455-5.7118z"
    S.g
      ! A.strokeWidth "0.933"
      ! A.strokeLinecap "round"
      ! A.strokeLinejoin "round"
      $ do
        S.path
          ! A.fill "#A0CFEB"
          ! A.d "m398.792 227.491c13.5414-0.23681 71.818-10.0081 71.818 70.925 0 77.3055-70.5605 108.048-70.5605 108.048s-70.563-29.7809-70.563-113.912c0-75.068 69.3055-65.06 69.3055-65.06z"
        S.path
          ! A.fill "#94BB79"
          ! A.d "m421.681 348.386c4.12972-2.30492 8.889-3.6189 13.953-3.6189 8.237 0 15.6608 3.47422 20.8902 9.03605-20.5866 37.0152-56.4735 52.66-56.4735 52.66s-34.9589-14.7555-55.6635-52.8325c5.2199-5.4614 12.577-8.8636 20.7284-8.8636 5.67935 0 10.9718 1.65059 15.4252 4.49941 5.23465-5.62915 12.7046-9.1488 20.9976-9.1488 7.8508 0 14.964 3.1565 20.1426 8.2683z"
        S.path
          ! A.fill "#658D5C"
          ! A.d "m433.967 345.161c3.55453 0.41102 9.77305 3.75827 12.7796 8.2695-2.33563 3.86043-6.82265 9.9939-9.3 13.3742-5.49565-8.06695-16.8821-18.8676-16.0931-18.0874 0.11397 0.11043 0.59174-0.27756 0.73051-0.35492 1.09606-0.61181 2.1189-1.16634 3.12165-1.63937 2.01851-0.78839 4.14745-1.35472 6.3573-1.6689 0.75768-0.0248 1.55315 0.008 2.40414 0.10689zm-24.18 50.7695c-4.49587 2.37401-7.9943 3.89587-9.7382 4.63051-1.74626-0.73464-5.2453-2.25649-9.7382-4.63051-8.7077-7.0512-26.641-23.5075-39.267-47.4296 4.07185-2.27894 8.76435-3.57874 13.7616-3.57874 0.40925 0 2.10531 0.4937 3.34724 1.07716 7.93585 3.72874 17.7561 14.4348 14.1378 16.4823-2.6563 1.49883-10.255-0.96141-10.6542 1.97835-0.14941 1.11319 14.0964 8.9386 22.1918 15.8303 6.63605 5.6492 17.0014 14.7957 15.959 15.6402zm17.297-7.0315c-9.0632-8.89665-29.4466-26.9964-46.503-39.6762 4.72678-5.0622 11.2654-8.4077 18.5829-9.0071l0.38445 0.0514c9.84215 1.41024 18.7577 11.9634 15.1388 14.0108-2.65571 1.49941-10.2555-0.96142-10.6536 1.97894-0.1311 0.98032 10.1924 7.22125 16.2366 12.4181 5.93445 5.10175 9.81495 8.76735 14.2164 13.5762-2.48917 2.40649-4.97362 4.62047-7.40255 6.64785z"
        S.path
          ! A.fill "#000000"
          ! A.d "m422.071 347.943c1.88563 1.77933 2.70768 3.26161 2.71418 3.27224 0.1807 0.30059-0.0213 0.99213-0.5628 0.48544 0 0-0.75-0.71457-2.95275-2.86063-2.96457-2.89252-8.09351-6.5492-12.339-7.2632-0.40749-0.0685-0.58406-0.26989-0.53387-0.56516 0.0473-0.29646 0.30532-0.57697 0.71221-0.51083 0.0768 0.0124 6.3449 1.1941 12.962 7.44215zm-34.8745 5.5545c0.19488 0.1748 0.24685 0.41575 0.13878 0.59409-0.11397 0.18662-0.35492 0.22796-0.55866 0.0809-3.58583-2.54764-5.33565-3.61477-7.41435-4.91871-0.16359-0.10393-0.27224-0.27638-0.14941-0.45886 0.0809-0.12224 0.24921-0.20137 0.40866-0.24744 0.32599-0.0933 0.81851-0.10984 1.13386 0.0874 2.10591 1.32225 3.51969 2.4626 6.44115 4.8626z"
        S.path
          ! A.fill "none"
          ! A.stroke "#000000"
          ! A.strokeWidth "1.244"
          ! A.d "m421.681 348.386c4.12972-2.30492 8.889-4.08366 13.953-4.08366 8.2766 0 15.7329 3.63543 20.9664 9.36554m-112.312-0.225c5.22695-5.6823 12.6236-9.2947 20.8276-9.2947 5.67935 0 10.9718 2.2695 15.4252 5.1183 5.23465-5.62915 12.7046-9.76715 20.9976-9.76715 7.8508 0 14.964 3.77481 20.1426 8.8866"
        S.path
          ! A.fill "none"
          ! A.stroke "#4C819A"
          ! A.strokeWidth "0.777"
          ! A.d "m367.911 230.52h66.967m-75.9135 3.71221h84.1205m-90.2515 3.71279h95.794m-100.444 3.71457h104.632m-108.329 3.71221h111.648m-114.663 3.7122h117.374m-119.856 3.7128h122.102m-124.169 3.7122h126.052m-127.756 3.7128h129.332m-130.752 3.71398h132.079m-133.248 3.71043h134.356m-135.301 3.7128h136.22m-50.2455 3.71279h51.0055m-137.726 0h51.354m51.9835 3.71162h35.002m-138.918 0h35.4443m74.937 3.71516h29.0174m-139.824 0h29.234m87.8725 3.7122h23.08m-140.456 0h22.9943m100.604 3.7128h17.1172m-140.856 0h17.0947m111.114 3.70984h12.7996m-141.032 0h13.0288m119.299 3.7128h8.77205m-141.027 0h8.4815"
        S.defs $ do
          S.g
            ! A.id_ "HaskellSvgIcons-smCoA-tower"
            ! A.fill "none"
            $ do
              S.path
                ! A.fill "#000000"
                ! A.d "m356.655 300.398l-0.0165-7.225 7.7485-3.024 7.7495 2.093 0.0165 8.156z"
              S.path
                ! A.fill "#FFFFFF"
                ! A.d "m373.237 333.224l3.39449 13.9482c-3.52559-1.54666-7.4185-2.40591-11.5158-2.40591l-0.72873-57.564 3.09862 0.89055v6.05255l3.87461 0.99685v-5.9947l5.27125 1.3872v9.84155l-3.39449 5.0374v27.8102z"
              S.path 
                ! A.fill "#BDBFC1"
                ! A.d "m364.387 332.147v-28.6636-6.07735-10.2024l-0.001-0.0005-3.09922 1.3559v5.96515l-3.87461 1.54489v-5.98995l-5.2695 2.23642v9.5321l3.78721 4.54252 0.0892 27.3933-3.87638 14.0817c3.69331-1.87736 7.84605-2.97933 12.2445-3.08917v-0.0921-12.5368z"
              S.path
                ! A.stroke "#000000"
                ! A.strokeWidth "1.09"
                ! A.d "m364.249 332.04l-8.2305 1.7439m-1.73985 8.66869l10.0483-2.12244 10.8644 1.16752m-11.2246-5.22463l-8.8677 1.8065m17.6528-24.6833l-8.364-1.73564-8.48325 2.58897m16.8472 3.09805l-8.364-1.59686-8.48325 2.45019m0-7.85847l8.48325-2.7431 8.364 1.76694m-16.8472 12.7258l8.48325-2.26299 8.364 1.48819m-16.7705 4.66358l8.4065-2.07638 8.44075 1.38072m-16.8472 4.60156l8.4065-1.89153 8.5199 1.27087m-3.0963-24.4116v3.83682m-3.09981-0.58288v3.91359m3.09981 0.82795v3.91654m-7.90395-4.2815v3.91358m0 4.10965v3.913m-3.7193 1.3624v3.60472m0-19.4197v3.60414m3.7193-9.1069v3.91594m2.4961-10.9818l12.2274 2.97697m-12.2274-2.97697l-12.2598 4.44686"
              S.path
                ! A.stroke "#000000"
                ! A.strokeWidth "1.244"
                ! A.d "m364.387 344.776v-57.5725"
              S.path
                ! A.fill "#000000"
                ! A.d "m370.586 334.677l-3.72283-0.51319 0.004-11.7809c0-1.44981 0.88051-2.33622 1.67362-2.33622 1.40611 0 2.04508 1.58445 2.04508 2.95689z"
              S.path
                ! A.stroke "#000000"
                ! A.d "m373.237 333.225l3.39449 13.9482c-3.52559-1.54666-7.4185-2.40591-11.5158-2.40591-4.6689 0-9.07735 1.11674-12.972 3.09744l3.87402-14.0794-0.0892-27.3933-3.78485-4.54311v-9.5321l5.2689-2.2376v5.9882l3.87461-1.5437v-5.96515l3.09981-1.35531 3.09862 0.89055v6.05255l3.87461 0.99685v-5.9947l5.27125 1.3872v9.84155l-3.39449 5.0374v27.8102zm3.10037 13.42c-3.40926-1.40964-7.30215-2.18622-11.2205-2.18622-4.47224 0-8.8636 1.01162-12.6466 2.82166l3.84745-13.4132-0.0791-27.4778c0-0.0224-0.0561-0.17894-0.0703-0.19666l-3.71457-4.4563v-9.21435l4.64882-1.9748v5.52105c0 0.25275 0.18898 0.3815 0.42579 0.28642l3.87461-1.54252c0.0803-0.0313 0.19429-0.19961 0.19429-0.28701v-5.7638l2.81162-1.22953 2.76614 0.79606v5.8175c0 0.10985 0.12461 0.27225 0.23209 0.29882l3.87461 0.99863c0.21791 0.0561 0.38858-0.0762 0.38858-0.29882v-5.5937l4.6506 1.22303v9.50905l-3.34075 4.9565c-0.0106 0.0147-0.0537 0.15768-0.0537 0.1748v27.8102l3.41102 13.4208zm1.21476 0.45532c0.075 0.30886-0.7559 0.0201-1.04645-0.10866-3.48603-1.53012-7.3376-2.37874-11.3888-2.37874-4.6193 0-8.97995 1.10374-12.8333 3.06201-0.29941 0.15177-1.14862 0.42992-1.05885 0.1063l4.48228-14.038-0.0868-27.2392-3.71457-4.45808c-0.0148-0.0172-0.0709-0.1748-0.0709-0.19783v-9.5321c0-0.0833 0.11043-0.25099 0.18661-0.28406l5.2701-2.23878c0.23859-0.10157 0.4317 0.0272 0.4317 0.28465v5.5311l3.25394-1.29508v-5.7561c0-0.0803 0.11161-0.25099 0.18661-0.28229l3.09981-1.35531c0.0206-0.0106 0.18662-0.0213 0.20965-0.0147l3.09803 0.89055c0.10217 0.0295 0.22441 0.19134 0.22441 0.29705v5.8116l3.25335 0.83858v-5.5931c0-0.22677 0.17244-0.35728 0.39035-0.30118l5.2695 1.38721c0.10807 0.0265 0.23091 0.18897 0.23091 0.29881v9.84155c0 0.0165-0.0413 0.16004-0.052 0.17245l-3.34075 4.96004v27.6774l4.00512 13.914zm-13.1485-43.577l8.364 1.89094m-8.364-1.89094l-8.475 2.8689"
          S.g
            ! A.id_ "HaskellSvgIcons-smCoA-feather"
            ! A.fill "#000000"
            ! A.stroke "#000000"
            $ do
              S.path
                ! A.d "m369.418 268.702c-0.28288-2.57008-1.2815-6.72875-4.71556-6.1996 0.17481 4.46811 5.8612 21.2906-0.63779 22.4528l-0.21733-0.23268c0.085-7.6382-7.5496-15.9744-6.0632-22.627 0.98032-4.37717 4.29213-6.7447 8.70355-6.7447 8.04566 0 9.15885 9.99805 3.27934 13.503l-0.34902-0.15177z"
              S.path
                ! A.fill "#FFFFFF"
                ! A.d "m369.854 267.53c-0.65433-2.86949-2.23228-6.61065-5.8447-5.97105l-0.23681 0.31122c0.16595 4.80472 6.18955 19.4179 0.4565 21.9986-0.15355-8.3675-7.6949-13.7976-5.75965-21.6414 0.5374-2.17382 2.70531-4.87559 4.81535-5.6681 0.98977-0.37382 2.11772-0.68386 3.18898-0.66319 7.25845 0.14941 9.14175 7.67185 3.38032 11.6338z"
              S.path
                ! A.stroke "none"
                ! A.d "m359.574 264.713c0.62067-1.69842 2.65335-3.42048 4.46575-3.63543 0.37677-0.046 0.67973 0.29232 0.82914 0.71161l-0.17303-0.004c-0.20788 0-0.41103 0.0271-0.61477 0.0744 0.0106 0.31004 0.036 0.63366 0.0744 0.96614-0.85039 0.0531-2.32559 0.39508-3.82972 2.23819-0.69567 0.85512-1.06536 0.50433-0.75177-0.35078z"
              S.path
                ! A.strokeWidth "1.09"
                ! A.d "m359.997 265.232l4.24902-1.73563m-3.92717 3.26811l4.20119-1.81359m-3.8628 3.43288l4.19941-1.97894m-3.39213 3.52205l3.78544-1.95532m-2.51634 3.38563l2.94862-1.67598m-0.82264 2.69941l1.29095-0.71693"
              S.path
                ! A.stroke "none"
                ! A.d "m369.137 259.592c-2.22756-3.28288-7.8319-1.43681-9.27695 0.6437-0.10335 0.15177-0.47303-0.075-0.68091-0.15827-0.0278-0.0106-0.0532-0.0242-0.0774-0.0389 0.38858-0.64488 0.87225-1.29626 1.425-1.88327 2.71418-1.73386 7.4362-2.08287 9.3372 0.98208 0.14705 0.23859 0.0414 0.47776-0.13524 0.58524-0.17598 0.10807-0.43582 0.0998-0.59173-0.13051z"
        S.use
          ! A.xlinkHref "#HaskellSvgIcons-smCoA-tower"
        S.use
          ! A.xlinkHref "#HaskellSvgIcons-smCoA-tower"
          ! A.x "35.338"
          ! A.y "-5.423"  
        S.use
          ! A.xlinkHref "#HaskellSvgIcons-smCoA-tower"
          ! A.x "70.673"  
        S.use
          ! A.xlinkHref "#HaskellSvgIcons-smCoA-feather"
        S.use
          ! A.xlinkHref "#HaskellSvgIcons-smCoA-feather"
          ! A.x "35.338"
          ! A.y "-5.423"  
        S.use
          ! A.xlinkHref "#HaskellSvgIcons-smCoA-feather"
          ! A.x "70.673"
        S.g
          ! A.stroke "#000000"
          $ do
            S.path
              ! A.fill "#000000"
              ! A.d "m446.259 240.532c3.26398 2.15315 14.8104 8.6439 16.5189 45.6354 3.33071 72.0965-58.0165 114.162-58.0165 114.162s77.6215-33.0508 77.6215-114.226l0.0001-0.00026c0-34.1728-13.5668-71.191-40.4758-71.191l-14.7915 0.0465-21.4842 10.0512c-1.125-1.56969-3.27166-2.59134-5.3504-2.59134-2.07579 0-4.2254 1.02165-5.3504 2.59134l-21.4837-10.0512-15.2554-0.0465c-26.9108 0-40.4776 37.0182-40.4776 71.191l0.00005 0.00027c0 81.1752 77.621 114.226 77.621 114.226s-61.3472-42.066-58.0165-114.162c1.70905-36.9916 13.2555-43.4823 16.5195-45.6354l18.1308 6.04764 22.914-13.4114c1.4947 1.59862 3.04017 2.73498 5.4006 2.73248 2.35866 0 3.68149-0.92834 5.39646-2.73248l22.7604 13.5668z"
            S.path
              ! A.fill "#D99F31"
              ! A.d "m431.453 214.144l-31.1716 13.5443-31.171-13.5443-10.9189 0.76801c-26.9108 0-40.4776 37.0182-40.4776 71.191v0.00024c0 81.1752 77.621 114.226 77.621 114.226s-62.1214-42.066-58.793-114.162c1.70905-36.9916 13.5667-44.4124 16.8307-46.5656l19.9756 5.55915 26.9332-15.9212 26.9314 15.9212 19.5115-5.55915c3.26398 2.15315 15.1216 9.574 16.8307 46.5656 3.33012 72.0965-58.7935 114.162-58.7935 114.162s77.6215-33.0508 77.6215-114.226l-0.00005-0.00024c0-34.1728-13.5668-71.191-40.4758-71.191z"
            S.path
              ! A.fill "#000000"
              ! A.stroke "none"
              ! A.d "m437.336 228.911c-3.71634 0.4376-6.31831 2.92973-6.4506 6.73525-0.0709 2.03918 0.90118 5.06635 2.30256 6.34725l-0.83683 0.91596c-1.65472-1.5142-2.86772-4.88743-2.78209-7.31105 0.1494-4.26675 3.14587-7.24017 7.61575-7.7634zm-74.5104-1.076c4.47048 0.52324 7.46695 3.49666 7.61635 7.7634 0.085 2.42363-1.12795 5.79685-2.78209 7.31105l-0.83683-0.91595c1.40138-1.28091 2.37284-4.30808 2.30197-6.34725-0.13288-3.80552-2.73426-6.29765-6.4512-6.73525zm-8.73434 7.44655c-5.39825 3.48602-10.2922 10.0972-13.0346 16.9258-0.15177 0.35728-0.38445 0.46358-0.62067 0.37795-0.21201-0.0768-0.30118-0.38209-0.20374-0.68327 2.58543-7.17755 7.43505-13.6642 13.5336-18.186l0.3254 1.56555zm7.1995-12.852c-13.2136 0-23.0197 9.30415-29.6392 26.4685-0.15118 0.32008-0.45473 0.56456-0.78307 0.44882-0.26103-0.0939-0.29055-0.46595-0.17244-0.80197 6.62185-17.4892 16.7256-27.1996 30.5947-27.1996 6.0372 0 11.2276 1.48701 15.6703 4.75157l0.24271 1.60985c-4.45866-3.62776-9.737-5.27715-15.913-5.27715zm0 3.564c-11.5294 0-20.5176 9.7193-26.1821 24.0189-0.16181 0.34252-0.39449 0.52323-0.71044 0.39449-0.24508-0.0998-0.27165-0.46713-0.14704-0.77008 5.37755-14.4614 14.8146-24.727 27.0396-24.727 6.1323 0 11.387 1.94173 15.8114 6.19785l-0.2067 1.37953c-4.33465-4.45335-9.52975-6.4937-15.6048-6.4937zm13.2195 12.5915c-2.30079-6.8699-6.0567-9.51435-13.3778-9.51435-9.65495 0-17.6032 8.77265-22.8561 22.0382-0.12874 0.30295-0.35315 0.4813-0.64134 0.38386-0.24922-0.085-0.28878-0.42756-0.17658-0.73701 5.1136-13.4794 13.317-23.0805 23.674-23.0805 7.68605 0 11.7904 3.16063 14.015 9.84865l-0.6372 1.06122zm51.0465 0.093l-0.67028-0.95729c2.20099-6.8002 6.29115-10.0222 14.0026-10.0453 12.427 0.0579 21.9674 14.0586 26.928 32.3327 0.0998 0.35906 0.0331 0.74764-0.28878 0.81142-0.31535 0.0602-0.56693-0.17834-0.65787-0.51909-4.97304-18.0348-14.4372-31.1699-25.9046-31.2296-7.3813 0.0207-11.1166 2.69055-13.409 9.6071zm43.388 21.7645c0.10453 0.41161 0.0667 0.75827-0.29646 0.84744-0.29468 0.075-0.56279-0.14764-0.66023-0.58524-4.7693-20.384-14.9746-34.3636-29.1804-34.3636-6.11105 0-11.3238 1.52185-15.6396 5.964l-0.19784-1.42972c4.42796-4.27205 9.6933-5.6947 15.8374-5.6947 15.1234 0 25.6424 14.935 30.137 35.2618zm3.8275 0.535c0.075 0.38622-0.0555 0.74941-0.3874 0.80374-0.31654 0.0514-0.57343-0.22028-0.64843-0.59233-4.693-22.305-15.788-38.723-33.151-38.723-6.10455 0-11.3286 2.09764-15.7258 5.7555l0.16654-1.60748c4.42205-3.40453 9.5764-5.3114 15.5592-5.3114 18.2924 0 29.687 17.3061 34.184 39.6726zm-31.651-28.224c9.512 1.1628 18.0579 12.3042 21.6726 26.9858 0.0856 0.37382-0.002 0.74351-0.31949 0.82855-0.30945 0.085-0.58347-0.11457-0.71634-0.5941-4.11319-15.8274-12.2634-24.675-20.7614-25.7569l0.12461-1.46338z"
            S.path
              ! A.fill "#none"
              ! A.d "m419.351 240.512c-0.73229-0.86634-2.92914-3.98859-2.92914-10.2703m-0.29409 8.36515c-0.68386-0.91594-2.32441-3.61004-2.32441-8.36515m-0.86103 6.4825c-0.58169-0.89174-1.75925-3.11398-1.75925-6.4825m-1.35059 4.64469c-0.39981-0.79784-1.11614-2.52402-1.11614-4.64469m-27.5044 10.2703c0.73229-0.86634 2.92913-3.98859 2.92913-10.2703m0.2941 8.36515c0.68386-0.91594 2.32441-3.61004 2.32441-8.36515m0.86516 6.4801c0.58051-0.89351 1.75512-3.11457 1.75512-6.4801m1.34941 4.64528c0.3998-0.79784 1.11732-2.52461 1.11732-4.64528"
            S.circle
              ! A.fill "#D99F31"
              ! A.stroke "none"
              ! A.cx "400"
              ! A.cy "229.24"
              ! A.r  "6.2"
            S.path
              ! A.fill "none"
              ! A.d "m394.135 227.779c0.66023-2.80335 3.14114-4.88977 6.14585-4.88977 2.62677 0 4.87913 1.59449 5.84705 3.86811m0.33012 4.06182c-0.70157 2.74252-3.21437 4.76929-6.17715 4.76929-2.70295 0-5.012-1.69075-5.92795-4.07185m7.562 1.62815c-0.50197 0.21142-1.05472 0.32776-1.63405 0.32776-2.28189 0-4.1439-1.80886-4.22953-4.07185m7.87325 1.99547c-0.46241 0.77835-1.16634 1.39784-2.00965 1.74863m-1.19173-1.89863c-0.14115 0.0313-0.29056 0.0479-0.44233 0.0479-1.06299 0-1.93937-0.80905-2.04508-1.84547m-2.11181-1.24134c0.12461-0.55453 0.36792-0.88878 0.46949-1.04469"
            S.path
              ! A.fill "none"
              ! A.d "m394.135 227.779c0-2.91733 2.55827-5.35865 6.14585-5.35865 2.73838 0 5.84705 1.9246 5.84705 4.33701m0.33012 4.06181c0 2.69469-3.21437 5.07875-6.17715 5.07875-2.70295 0-5.92795-1.96476-5.92795-4.3813"
            S.path
              ! A.fill "#000000"
              ! A.d "m423.345 242.22c3.26575 4.3311 8.30965 7.07125 13.9654 7.07125 7.39785 0 13.0294-4.59686 13.0294-11.9451-0.1683-3.89292-2.79685-8.7018-9.01595-8.7018-4.04055 0-7.4705 3.89528-7.4705 7.93585 0 2.23405 0.42815 3.58346 1.80059 5.2636-5.53585-1.77933-9.19845-4.72973-9.19845-11.0108 0-6.44055 4.27087-11.0546 11.2683-11.6356 23.3852-1.94351 37.6748 24.0148 40.428 59.8935 3.92422 51.177-23.6782 91.9745-65.637 115.271-5.8571 3.25099-10.4498 5.8512-12.4394 6.69215l-0.0265 6.36555c15.975-6.1063 34.4959-17.8914 46.0465-28.4416 21.9922-20.0906 42.9732-54.0775 39.7902-99.852-2.01142-28.9063-11.0126-48.293-22.0624-57.8705-18.8924-16.3807-44.6516-9.838-44.6516 9.57755 0 4.23957 1.66713 8.2246 4.17343 11.387zm-46.592 0c-3.26634 4.3311-8.30965 7.07125-13.9672 7.07125-7.39605 0-13.0276-4.59686-13.0276-11.9451 0.1683-3.89292 2.79685-8.7018 9.01595-8.7018 4.03996 0 7.4705 3.89528 7.4705 7.93585 0 2.23405-0.42815 3.58346-1.80059 5.2636 5.53525-1.77933 9.19845-4.72973 9.19845-11.0108 0-6.44055-4.27087-11.0546-11.2683-11.6356-23.3852-1.94351-37.6742 24.0148-40.428 59.8935-3.92422 51.177 23.6782 91.9745 65.637 115.271 5.8571 3.25099 10.4498 5.8512 12.4394 6.69215l0.0265 6.36555c-15.975-6.1063-34.4959-17.8914-46.0465-28.4416-21.9922-20.0906-42.9732-54.0775-39.7902-99.852 2.01142-28.9063 11.0126-48.293 22.0624-57.8705 18.8924-16.3807 44.6516-9.838 44.6516 9.57755 0 4.23957-1.66595 8.2246-4.17342 11.387z"
            S.path
              ! A.fill "#F1BF31"
              ! A.d "m400.048 406.956c-15.975-6.1069-34.4959-18.6685-46.0465-29.2181-21.9922-20.0906-41.5784-53.303-38.3953-99.078 2.01201-28.9046 10.5496-47.2069 21.5976-56.785 18.8929-16.3778 43.2579-8.92205 43.2579 8.95925 0 9.83975-7.98545 17.8382-17.8311 17.8382-5.96105 0-12.2546-4.83662-11.6315-12.101 0.1683-3.89115 3.37618-6.9951 7.30865-6.9951 4.04055 0 7.31635 3.27401 7.31635 7.31635 0 2.23228-1.46339 4.38543-3.03898 5.72895 6.22265-0.22205 11.677-5.5063 11.677-11.7874 0-6.44055-4.89154-11.8288-11.889-12.4098-23.3852-1.94351-38.4974 24.6313-41.0468 60.668-3.62481 51.2045 24.297 92.5955 66.2555 115.89 5.88365 3.26575 10.4935 5.25475 12.466 6.08325 1.97421-0.82855 6.5823-2.81752 12.466-6.08325 41.9587-23.2943 69.8805-64.6855 66.2555-115.89-2.54941-36.0366-17.6616-62.6115-41.0468-60.668-6.99745 0.5811-11.8866 5.9693-11.8866 12.4098 0 6.2811 5.45195 11.5654 11.677 11.7874-1.57618-1.34351-3.04193-3.49666-3.04193-5.72895 0-4.04233 3.27638-7.31635 7.31695-7.31635 3.93248 0 7.1427 3.10394 7.31105 6.9951 0.62244 7.26435-5.67285 12.101-11.6338 12.101-9.84565 0-17.8294-7.99845-17.8294-17.8382 0-17.8813 24.3638-25.337 43.2561-8.95925 11.0504 9.57815 19.588 27.8806 21.5976 56.785 3.18307 45.7748-16.4032 78.9875-38.3953 99.078-11.5506 10.5496-30.0714 23.1112-46.0465 29.2181z"
    S.g
      ! A.fill "#000000"
      ! A.stroke "#000000"
      ! A.strokeWidth "0.933"
      ! A.strokeLinecap "round"
      ! A.strokeLinejoin "round"
      $ do
        S.path 
          ! A.d "m302.443 357.768s-3.28465-1.32638-4.73859-2.05335c-2.5252-1.2626-8.21575-8.26535-14.5736-11.9551-9.75885-5.6622-19.2041-4.20236-27.8327-7.90865 1.93288 9.03605 8.02085 17.198 18.101 21.5209 8.28071 3.55217 21.6414 0.49843 23.0947 0.6189 1.45394 0.12284 6.0691 1.90394 6.0691 1.90394l-0.11988-2.12657z"
        S.path 
          ! A.d "m267.223 369.044l0.0874-0.26398c5.338-0.72638 10.3382-1.93642 15.5309-3.25335 11.5046-2.91496 16.8945-0.54803 26.2176 5.8329 0.58346 0.3998 1.275 0.9567 1.9435 1.20827 1.51122 0.57107 2.4815 0.17244 3.94075 0.17244l0.13347 0.0266 2.18563 1.70906c0.16653 0.13051 0.0667 0.24449-0.0909 0.27815-1.90393 0.39212-4.50413 0.38622-6.49664 0.20551-3.00651-0.27402-9.1943 6.8516-18.0018 6.8516-11.1603 0-18.4937-4.93938-25.4498-12.7672z"
        S.path
          ! A.fill "#658D5C"
          ! A.d "m316.303 374.316c-1.74213 0.062-3.59882 0.062-5.3179 0.35079-5.1325 0.86397-10.2136 6.4553-18.0183 6.67975-10.3854 0.29881-16.9429-4.59272-24.0414-11.5736 10.3276-1.55256 18.3106-7.51595 28.9666-4.16279 5.4632 1.71908 11.8848 8.5996 17.0138 7.61399l1.39724 1.09193z"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m309.878 372.946s-9.11045 1.49705-14.785 1.51181c-9.16535 0.0206-23.1928-3.79961-23.1928-3.79961s13.986 4.2313 23.1928 4.41792c5.6622 0.11456 14.785-1.2 14.785-1.2v-0.93012z"
        S.path
          ! A.fill "none"
          ! A.strokeWidth "0.777" 
          ! A.d "m284.538 262.675c0.075-0.28701 0.0189-0.63366-0.16004-1.063-0.18248-0.44468-0.46476-0.91771-0.76358-1.42027-0.31181-0.52559-0.64193-1.07776-0.90296-1.65296-0.26397-0.58523-0.46712-1.2124-0.50905-1.86673l1.41614-0.40512c0.10158 0.7937 0.57933 1.81299 1.1191 2.61437 0.2681 0.39862 0.53976 0.72697 0.77066 0.93425 0.11575 0.1057 0.20966 0.17066 0.27078 0.19664 0.033 0.0165 0.42667 0.44704 0.42667 0.44704l-1.17136 2.61615c-0.0871 0.19549-0.60383 0.0124-0.49635-0.40037z"
        S.path
          ! A.strokeWidth "0.777"
          ! A.d "m338.065 388.946c-0.046-1.89981 0.33012-1.19173 2.37697-0.35728 0.43642 0.17657 0.11457 0.60413-0.25925 0.83681-1.22303 0.76417-2.30256 2.38346-2.82166 2.02027-1.40787-0.98445-0.52145-1.01929 0.70394-2.4998z"
        S.path
          ! A.d "m289.158 254.936c-6.0254 15.3189-8.05985 42.4441-5.9752 54.761 6.4069 37.8674 37.5957 73.3685 66.1455 79.1055 24.8309 4.99075 39.9668 16.1162 49.852 27.9821 6.4612 7.7551 9.91065 11.2766 19.1876 26.7201 3.39035 5.6439-2.40886 6.78545-4.80059 2.1059-6.52795-12.7654-10.0453-18.4382-19.04-28.4728-9.65905-10.7764-23.8672-20.4514-47.0575-25.0802-27.6544-5.5205-60.049-41.0841-66.4565-78.9495-2.08524-12.3189-0.26162-41.7296 6.06259-57.275l2.08229-0.89705"
        S.path
          ! A.d "m330.29 387.334c-4.30217 0.47185-7.2112 6.7175-11.5276 10.6476-7.94825 7.23425-20.6846 7.9565-28.8054 3.1252-0.34015-0.20374-0.5126-0.6567-0.12815-0.74527 10.0966-2.29017 11.4136-16.0689 32.4608-14.713 2.46674 0.15945 3.50905 0.66438 5.98585 0.66438l2.01437 1.02106z"
        S.path
          ! A.d "m314.307 323.269l0.13937 0.0679c0.1063 6.15474 4.77343 14.5488 5.91735 21.3183 0.98681 5.8299-0.43583 10.7032-2.66989 16.1344-0.55866 1.35354-1.86909 4.07421-1.92047 5.4071-0.0478 1.24134 0.73051 2.38996 1.38897 3.41752 0.23032 0.36141 1.62343 2.19035 1.47992 2.54527-5.5766-4.82894-2.29606-1.6813-4.61693-6.13345-1.19645-2.29606-2.62264-4.38071-3.80846-6.6933-6.26045-12.2114-6.3762-26.064 4.09016-36.0638z"
        S.path
          ! A.d "m354.556 389.97c-2.73898-0.88464-5.52755-1.97598-7.0305-4.77934-2.5252-4.70551-1.98485-8.50864-4.57441-13.3777-4.91221-9.2374-14.3699-10.2319-19.1433-18.7949-0.96792 7.87975-2.02441 19.6524 10.2425 28.0718 4.3187 2.96279 10.9051 3.6437 12.4914 4.83366 1.58858 1.18996 2.5435 2.89016 2.5435 2.89016l5.47085 1.1563z"
        S.path
          ! A.fill "#658D5C"
          ! A.d "m349.244 388.53c-0.90118-0.95905-1.9122-1.9246-2.98169-2.69882-2.50336-1.81063-7.9246-1.9813-12.0177-4.9813-5.71596-4.19232-8.67875-8.0888-10.2668-14.997-0.96378-4.18996-0.22264-7.53955-0.0254-11.0232 5.149 7.47875 14.0941 8.1827 18.88 17.1296 2.90905 5.43605 2.52283 13.7038 8.48385 17.009l-2.07225-0.43819z"
        S.path
          ! A.strokeWidth "0.777"
          ! A.d "m300.355 347.397s-0.34075 0.41043-0.82027 1.77756c-0.21378 0.61417 1.13326 2.46437 1.02342 1.82244-0.27402-1.56969 0.49842-2.67402 0.49842-2.67402l-0.70157-0.92598z"
        S.path
          ! A.fill "#658D5C"
          ! A.d "m302.443 357.768s-3.28465-0.70748-4.73859-1.43209c-2.5252-1.26436-8.1142-8.59604-14.5736-12.2652-9.26045-5.25885-17.3268-4.16043-26.4378-6.8244 2.58544 9.72285 7.52716 15.5392 16.7061 19.66 8.2199 3.68977 21.6414 0.49902 23.0947 0.6189 1.45394 0.12284 6.0691 2.05985 6.0691 2.05985l-0.11988-1.81713z"
        S.path
          ! A.fill "#466343"
          ! A.d "m315.478 368.908c-0.4063-2.89252-3.6939-7.0559-5.07045-9.74825-2.01555-3.94783-3.52914-8.2559-3.97972-12.6827-0.97146-9.53625 1.21653-14.6817 7.4929-21.7488 0.0461 2.07166 0.32421 2.79863 0.9496 4.725 2.62618 8.09175 6.30355 14.7798 5.1118 23.5772-0.5876 4.33111-4.12382 10.4976-4.28563 13.1445-0.0827 1.37067 0.69095 2.97993 1.37422 4.13445l-1.59272-1.40138z"
        S.path
          ! A.d "m291.921 343.116c-6.73585-11.1974-22.5342-6.17895-32.8872-15.5805-5.0244-4.56319-7.2691-11.4319-8.27185-17.9646-0.29941-1.94528-1.12973-9.6567-0.67677-11.1538 0.0827-0.27815 0.36319-0.34488 0.57933-0.13288 3.43228 3.35552 6.87285 5.52285 10.8466 8.214 9.4388 6.3886 13.3134 12.385 18.1778 22.3476 6.37085 13.0453 12.1447 5.61025 12.2321 14.2701z"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m312.93 328.102s-2.13839 11.2022-1.81477 18.4069c0.33248 7.36065 3.59646 18.5498 3.59646 18.5498h-0.62126s-3.38386-11.1827-3.5935-18.5498c-0.20788-7.2384 2.43307-18.4069 2.43307-18.4069z"
        S.path
          ! A.fill "#658D5C"
          ! A.d "m281.964 336.012c-3.62862-1.15123-7.78551-1.85014-12.2024-2.91413-4.13977-0.99685-7.52065-3.25807-10.6766-6.10215-4.8998-4.4185-6.5197-10.3424-7.4746-16.6978-0.53563-3.56339-0.68091-7.01635-0.44233-10.6222 0.39449 0.69508 0.89469 1.38248 1.54843 1.85138 3.21437 2.30315 6.564 3.91004 9.78365 6.23565 2.81338 2.03268 4.81122 3.37382 7.1185 5.97345 2.91673 3.29114 5.35215 6.84745 7.40375 10.7327 1.61752 3.06615 3.00413 6.66085 5.0953 9.4429z"
        S.path
          ! A.fill "#A48253"
          ! A.d "m282.118 333.911c1.08366 1.44508 5.4567 3.32245 7.04705 3.52559l1.54665 3.85808v-0.00005c-2.27178-2.65837-5.26653-4.17895-8.74741-5.28332z"
        S.circle
          ! A.fill "#D99F31"
          ! A.cx "271.96"
          ! A.cy "304.79"
          ! A.r  "4.417"
        S.path
          ! A.fill "#F1BF31"
          ! A.stroke "none"
          ! A.d "m272.469 300.875c-0.22364 0.52367-0.35938 1.12912-0.35938 1.78125 0 1.94764 1.15049 3.53125 2.5625 3.53125 0.3918 0 0.76155-0.12675 1.09375-0.34375 0.0919-0.33421 0.14063-0.68228 0.14063-1.04688 0-2.01267-1.49482-3.67002-3.4375-3.92187z"
        S.circle
          ! A.fill "none"
          ! A.strokeWidth "1.244"
          ! A.cx "271.96"
          ! A.cy "304.79"
          ! A.r  "4.719"
        S.path
          ! A.d "m285.013 302.83s2.06162-7.676 4.00276-12.4264c4.59036-11.2458 12.5516-11.6687 16.6086-20.5742 2.32264 6.0124 4.17756 13.7427 0.11988 22.4132-4.68366 10.0164-16.6689 15.8941-16.6689 15.8941l-4.06241-5.3067z"
        S.path
          ! A.fill "#466343"
          ! A.d "m305.587 271.848c5.9823 16.3305-1.91634 28.0884-16.4197 36.1966l-3.82027-5.2801c2.49331-10.4876 4.28327-15.6514 12.2958-23.1036 3.16832-2.94626 5.9445-3.90296 7.9441-7.813z"
        S.path
          ! A.fill "#A48253"
          ! A.d "m288.712 255.666c-5.97105 15.6951-7.7362 41.9398-5.6805 54.084 6.424 37.9571 37.5272 73.589 66.2345 79.357 24.7559 4.9748 39.5563 16.1244 49.7504 27.6461 4.76103 5.38405 8.60255 10.6412 11.7644 15.5912 2.72008 4.25846 5.0498 8.9055 7.3376 12.5823 0.36969 0.5935-2.71949 1.87086-3.04606 1.3435-2.4189-3.91004-4.64233-8.84055-7.42855-13.3565-3.17067-5.1372-8.61675-10.3925-13.353-15.9838-10.0784-11.8996-23.4998-20.8424-46.7604-25.4846-27.5032-5.48975-59.512-40.6193-65.9025-78.39-2.07638-12.2705-0.54626-40.7498 4.92106-55.7845l2.16319-1.60454z"
        S.path
          ! A.d "m285.719 329.932c-1.23366-1.18169-3.00886-2.30905-4.1941-3.54035-11.0274-11.4449-8.1313-31.4374 3.96319-41.2022 0.41162-0.33013 0.72284-0.17481 0.78071 0.31122 0.48603 4.02814 1.1126 7.81889 2.72835 12.2563 3.68977 10.1344 4.29154 15.9466 0.93839 24.5752-2.04508 5.25945 0.006 9.89825 0.006 9.89825l-4.22245-2.29843z"
        S.path
          ! A.strokeWidth "0.623"
          ! A.d "m324.604 379.212c-7.0553-2.41241-14.3433-1.76516-20.2104-7.85495-6.77125-7.024-8.237-17.8896-6.4677-24.1642 0.0868-0.30473 0.32362-0.55453 0.51437-0.31949 1.50355 1.84134 2.30079 3.16654 4.27737 4.62343 7.0677 5.21455 15.7447 7.826 18.7405 15.7908 0.59823 1.58445 0.79607 3.24508 1.35355 4.84193 1.90866 5.47145 5.03975 7.1244 9.5746 10.1114l-7.7823-3.02894z"
        S.path
          ! A.fill "#658D5C"
          ! A.d "m330.117 382.116c-6.6012-5.59785-18.4966-3.5876-25.5804-11.1809-5.2016-5.5748-7.3943-14.3664-6.10455-21.9904 6.287 5.60195 13.5974 7.14035 19.3158 13.4298 6.72935 7.40435 0.99921 12.3726 13.6683 19.5774l-1.29922 0.16418z"
        S.path
          ! A.d "m294.865 341.944l0.0189-0.17185c1.64055-1.95414 0.50256-7.82365-0.0354-10.1764-0.92776-4.05532-1.04233-7.54135-0.36733-11.671 0.77894-4.76929 3.39036-9.0756 6.06735-13.024 1.19351-1.75866 5.07045-7.2573 5.47265-9.24865 0.0331-0.17008 0.21378-0.15767 0.28878 0.006 1.47815 3.22323 2.25059 7.14745 2.84705 10.6317 0.83268 4.87914 1.0937 9.3136-0.60059 14.8618-1.51535 4.96654-3.55276 8.1809-6.67325 11.5216-1.32047 1.41201-4.42677 4.52422-4.8815 6.2061-0.0827 0.30709-0.61004 2.54587-0.4937 4.18347l-1.64291-3.1187z"
        S.path
          ! A.strokeWidth "0.948"
          ! A.d "m283.939 277.75s0.20965 0.0313 1.09429-0.56221c0.88405-0.59173 1.95531-1.61102 2.41063-2.88425 0.45414-1.27087 3.64193-11.8618 7.89865-18.417 4.97244-7.65945 10.1362-11.0935 16.3984-16.7144 0.98386 6.0691 1.12737 15.9608-4.00335 23.8984-4.69843 7.26735-16.6122 12.4435-17.9929 12.9832-1.3813 0.53976-3.74823 0.93898-5.10825 2.74489-0.77008 1.01929-1.2998 3.0065-1.2998 3.0065l0.60236-4.05532z"
        S.path
          ! A.d "m282.442 278.762s-0.51733-0.0248-1.18583-0.96733c-0.66614-0.94547-1.33642-2.40236-1.33642-3.9 0-3.16594 3.00237-12.642 1.513-19.816-2.84233-13.6914-7.1445-19.1811-7.8065-24.2616-0.26398-2.02677-11.4449 13.8301-8.04565 28.5449 1.68543 7.2927 10.1616 15.4441 11.351 16.5154 1.18996 1.07126 2.81338 2.46023 3.58996 4.60098 0.7996 2.20748 0.62953 4.71909 0.62953 4.71909l1.29094-5.43545z"
        S.path
          ! A.d "m289.004 255.212c0.80374-1.96063 2.13248-4.28327 3.36201-5.31085 3.02244-2.5252 11.4904-8.81455 14.3823-13.399 6.4382-10.2071 5.139-22.7788 4.46634-24.968-5.58305 4.85433-10.6784 8.0563-16.3701 16.092-4.96831 7.0134-6.05435 20.7296-6.4364 23.3298-0.41929 2.8376-1.67953 5.9049-1.67953 5.9049l2.2754-1.64882z"
        S.path
          ! A.fill "#658D5C"
          ! A.strokeWidth "0.948"
          ! A.d "m283.998 279.97l0.22441-1.97244c1.53189-0.58582 2.89488-2.11181 3.51319-3.59055 2.66811-6.38446 4.2939-12.8746 8.04155-18.7712 4.86496-7.65355 10.076-10.6311 15.3354-14.8352 0.24508 6.76419 1.43681 13.8897-3.94902 22.7546-3.06083 5.0327-11.9805 10.0199-17.5323 12.2102-2.48327 0.98032-4.26024 1.77698-5.63325 4.20473z"
        S.path
          ! A.d "m261.115 266.482c8.51105 7.0884 10.9382 10.4026 13.4416 21.3679 0.2935 1.28445 1.92284 6.83445 2.26831 7.5183 0.81968 1.63169 2.51575 2.40413 3.56043 3.74291 0.11398 0.14765 0.39685 3.03603 0.44055 3.41634 0.0266 0.22973-0.15 0.22382-0.28051 0.10571-1.3246-1.21063-2.02027-3.1063-3.56516-4.24016-1.32874-0.97559-5.8181-1.93346-7.7551-2.73248-4.94587-2.04094-8.9805-5.85945-11.8453-10.3317-3.7813-5.90255-4.20886-13.94-3.29941-20.7054 0.20965-1.55315 0.41929-3.42342 0.96969-4.89567 0.0768-0.20315 0.19724-0.1559 0.30059 0.006 2.01673 3.14174 3.31181 4.70493 5.76435 6.74825z"
        S.path
          ! A.fill "#658D5C"
          ! A.d "m279.992 299.389l0.23504 2.0061c-4.04055-5.46735-5.39235-3.85157-10.9778-6.16475-4.8626-2.01142-8.80985-5.7638-11.6356-10.1575-4.2189-6.56105-4.14035-16.2697-2.35866-23.6676 2.26535 4.46575 11.129 8.9451 14.5305 14.5199 2.18799 3.58524 3.54566 7.84605 4.63169 11.8848 0.54212 2.01969 1.15453 6.09155 1.98957 7.76105 0.62244 1.24784 2.50807 2.91556 3.58524 3.81792z"
        S.path
          ! A.fill "#658D5C"
          ! A.d "m295.366 342.052c1.50768-2.30197 0.18661-8.1366-0.29469-10.7776-0.7435-4.08662-0.79724-7.61575-0.13051-11.7402 1.0878-6.74115 5.35455-11.2571 9.12345-16.7203 0.74292-1.07776 1.48406-2.16791 2.06752-3.34252 4.33111 12.192 5.54585 24.6455-3.89291 34.8856-1.42441 1.54548-4.8502 4.52481-5.3758 6.4016-0.28229 1.00512-0.37973 2.07224-0.45886 3.11043l-1.03819-1.81712z"
        S.path
          ! A.fill "#A48253"
          ! A.d "m331.315 385.465s-0.53386 0.84921-3.04016 0.84921l1.24289 1.2192c0.25017-0.0784 0.50714-0.14533 0.77146-0.19993 2.39586-0.4937 3.13346-0.42107 4.69252 0.18306"
        S.path
          ! A.fill "#466343"
          ! A.d "m328.275 386.314c-2.5063 0-10.3441-1.30157-16.6146 0.33662-9.4553 2.47086-13.3588 11.3156-20.4662 14.459 10.797 4.64941 18.6992 3.50492 27.6838-3.68091 3.62005-2.89435 5.92197-8.41799 10.6398-9.89557z"
        S.path
          ! A.fill "none"
          ! A.d "m405.404 431.001s0.0992-1.37835 1.68957-1.93052c1.37244-0.47776 2.08288 0.61417 2.08288 0.61417"
        S.path
          ! A.fill "#A48253"
          ! A.strokeWidth "0.777"
          ! A.d "m340.475 388.878s-0.84922 0.49488-1.10019 0.7187c-0.57934 0.51909-1.34174 0.90118-1.57796 1.3252l-0.92244-0.0856c0.57343-0.47717 1.17933-1.29331 1.50532-1.69016 0.19134-0.23032 0.004-1.10669 0.004-1.10669l2.09114 0.83858z"
        S.path
          ! A.fill "#658D5C"
          ! A.stroke "none"
          ! A.d "m287.558 255.574c1.69665-4.80414 1.65768-10.1492 2.60787-15.1382 2.00197-10.5166 4.98957-13.9358 12.587-20.9705 2.42067-2.24055 4.89981-3.87047 7.5325-5.86005 0.42638 3.0254 0.62481 5.56475 0.31772 8.60255-1.49469 14.86-7.82365 18.3674-18.4352 27.4554-2.05807 1.76044-2.58898 4.22717-4.60985 5.91085z"
        S.path 
          ! A.fill "#A48253"
          ! A.stroke "none"
          ! A.d "m287.961 254.318c0.27697-0.40453 0.54271-0.63839 0.68622-0.57048 0.11457 0.0543 0.12992 0.28878 0.0614 0.61772-0.33308 0.43111-0.70513 0.83918-1.1504 1.21004 0.14646-0.41516 0.27992-0.83445 0.40276-1.25729z"
        S.path
          ! A.fill "none"
          ! A.d "m287.558 255.574c1.69665-4.80414 1.65768-10.1492 2.60787-15.1382 2.00197-10.5166 4.98957-13.9358 12.587-20.9705 2.42067-2.24055 4.89981-3.87047 7.5325-5.86005 0.42638 3.0254 0.62481 5.56475 0.31772 8.60255-1.49469 14.86-7.82365 18.3674-18.4352 27.4554-2.05807 1.76044-2.58898 4.22717-4.60985 5.91085z"
        S.path
          ! A.stroke "none"
          ! A.d "m288.224 256.116s0.38208-1.16457 0.95728-2.65158c0.5752-1.48642 0.42757 0.39862 0.42757 0.39862l-0.33839 1.61989-1.04645 0.63307z"
        S.path
          ! A.fill "#658D5C"
          ! A.stroke "none"
          ! A.d "m282.056 278.96l-0.77658 2.49331c-0.43582-3.24449-1.80236-4.69016-4.13976-6.8061-10.1805-9.21025-14.5305-20.0504-10.2596-32.7248 1.49527-4.43032 2.93445-6.874 6.08385-10.33 1.98897 3.40807 2.95275 5.44665 4.3311 9.1447 3.49252 9.38445 4.88563 14.69 3.50079 25.4392-0.49016 3.79724-2.31083 8.42125 0.20965 11.7974 0.27579 0.36732 0.61004 0.79724 1.05059 0.98622z"
        S.path
          ! A.fill "none"
          ! A.d "m282.056 278.96l-0.77658 2.49331c-0.43582-3.24449-1.80236-4.69016-4.13976-6.8061-10.1805-9.21025-14.5305-20.0504-10.2596-32.7248 1.49527-4.43032 2.93445-6.874 6.08385-10.33 1.98897 3.40807 2.95275 5.44665 4.3311 9.1447 3.49252 9.38445 4.88563 14.69 3.50079 25.4392-0.49016 3.79724-2.31083 8.42125 0.20965 11.7974 0.27579 0.36732 0.61004 0.79724 1.05059 0.98622z"
        S.path
          ! A.fill "#A48253"
          ! A.stroke "none"
          ! A.d "m281.765 284.471s0.24567-2.46437-0.13642-3.96319c-0.18898-0.74586-0.68326-1.84607-0.68326-1.84607s1.2248 0.62303 1.50531 0.5687c0.28051-0.052-0.68563 5.24055-0.68563 5.24055z"
        S.path
          ! A.fill "#A48253"
          ! A.stroke "none"
          ! A.d "m285.922 260.331c-0.58701 0.23917-2.39173-2.30433-2.61142-4.02579-0.20729-1.63642-0.87874-0.95315-0.79961 0.34666 0.14765 2.41712 3.0378 5.0061 2.63741 6.5427 0.5439-1.32048 0.80079-2.2754 0.77362-2.86359z"
        S.path
          ! A.fill "none"
          ! A.strokeWidth "0.777"
          ! A.d "m285.922 260.331c-0.58701 0.23917-2.39173-2.30433-2.61142-4.02579-0.20729-1.63642-0.87874-0.95315-0.79961 0.34666 0.14765 2.41712 2.72835 4.56614 2.32796 6.1004"
        S.circle
          ! A.fill "#D99F31"
          ! A.stroke "none"
          ! A.cx "281.443"
          ! A.cy "253.512"
          ! A.r  "4.416"
        S.path
          ! A.fill "#F1BF31"
          ! A.stroke "none"
          ! A.d "m281.706 253.088c-1.19646-0.83918-1.72146-2.15492-1.17107-2.94213 0.54981-0.78484 1.96595-0.74291 3.16418 0.0957 1.19764 0.83858 1.72086 2.15492 1.17106 2.93976-0.5498 0.78662-1.96594 0.7435-3.16417-0.0933z"
        S.circle
          ! A.fill "none"
          ! A.strokeWidth "1.315"
          ! A.cx "281.402"
          ! A.cy "253.639"
          ! A.r  "4.607"
        S.circle
          ! A.fill "#D99F31"
          ! A.stroke "none"
          ! A.cx "303.963"
          ! A.cy "344.419"
          ! A.r  "4.572"
        S.path
          ! A.fill "#F1BF31"
          ! A.stroke "none"
          ! A.d "m303.43 343.97c-0.97559-1.34291-1.00866-2.98169-0.0744-3.65846 0.93425-0.67855 2.48149-0.14114 3.45709 1.20236 0.97323 1.34173 1.00866 2.97933 0.0744 3.65906-0.93425 0.67854-2.48091 0.14114-3.45709-1.20296z"
        S.circle
          ! A.fill "none"
          ! A.strokeWidth "1.4"
          ! A.cx "303.963"
          ! A.cy "344.419"
          ! A.r  "4.805"
        S.path
          ! A.fill "none"
          ! A.d "m406.8 432.551s0.0502-1.39134 1.69016-1.77756c1.49527-0.35079 2.08228 0.92539 2.08228 0.92539m7.22835 15.6142c-2.98818 0.61713-4.81535-3.13287-3.78957-4.05531 0.67087-0.60177 2.32323-0.47303 3.53563 0.1187 2.16792 1.05708 1.58623 3.6626 0.25394 3.93661z"
        S.path
          ! A.fill "#A48253"
          ! A.stroke "none"
          ! A.d "m417.799 447.313c-2.48149 0.6313-4.43091-2.70118-3.7872-3.43583 0.5935-0.67737 1.8496-0.71221 3.0626-0.12343 2.16791 1.05945 2.04271 3.225 0.7246 3.55926z"
        S.path
          ! A.fill "none"
          ! A.d "m417.799 447.313c-2.48149 0.6313-4.43091-2.70118-3.7872-3.43583 0.5935-0.67737 1.8496-0.71221 3.0626-0.12343 2.16791 1.05945 2.04271 3.225 0.7246 3.55926z"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m287.438 256.177c3.1435-9.15885 4.89567-15.5976 10.1008-24.5445 3.54035-6.08385 10.4834-14.6941 10.4834-14.6941s-6.5386 8.83465-9.9307 14.9598c-4.79469 8.66045-5.8701 12.3874-9.69685 23.4579l-0.9567 0.82087z"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m272.549 235.821s-1.14803 14.387 0.66023 23.2943c1.62579 8.00195 7.27325 19.6317 7.27325 19.6317s0.31595 0.23445-1.3187-4.07599c-1.67953-4.42677-3.82027-9.32305-5.18029-15.5811-1.93052-8.88426-1.43446-23.2689-1.43446-23.2689z"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m259.099 273.201s1.90394 4.97953 3.53622 7.95475c4.48052 8.17205 8.3256 12.4476 15.9726 17.7732l0.22441-0.6874c-7.37305-5.23465-10.8402-9.414-15.5788-17.0858-1.83721-2.97756-4.15453-7.95475-4.15453-7.95475z"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m286.481 276.543s9.1565-8.45435 13.8384-15.0656c4.13799-5.84645 9.10275-16.21 9.10275-16.21s-4.53426 10.4918-8.55 16.3736c-4.51004 6.60355-13.1516 14.902-13.1516 14.902h-1.23957z"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m295.454 342.794c1.74212-4.19646 4.36241-9.975 6.3183-16.6317 2.45433-8.35275 3.91122-12.4228 4.19232-21.9278-0.14114 9.49075-1.15275 12.7718-3.1624 20.6776-1.71083 6.7299-4.05295 12.6366-5.7951 16.8307l-1.55315 1.05118z"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m290.24 300.668s6.89705-6.0313 9.97915-11.4296c4.06063-7.11615 4.7439-12.828 4.7439-12.828s-0.0661 5.7431-4.12559 12.8581c-3.08091 5.4006-10.3234 12.2882-10.3234 12.2882l-0.27402-0.88878z0"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m282.38 334.885s-5.9504-3.77008-9.2126-6.5191c-12.6573-10.6618-20.5866-25.0323-20.5866-25.0323s7.24665 15.1736 20.1212 25.653c3.42224 2.78445 9.67795 6.67325 9.67795 6.67325v-0.77481z"
        S.path
          ! A.fill "none"
          ! A.d "m283.201 336.413s-1.13977-0.48661-0.54626-1.57205"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m328.64 379.995c-5.58545-3.51083-13.4445-8.74135-20.527-16.0164-2.42481-2.49212-5.91495-6.6691-5.91495-6.6691s2.8317 4.42028 5.14075 6.8244c6.3142 6.57165 14.987 12.7382 20.5724 16.2496l0.72874-0.38858z"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m347.968 386.704s-10.5059-7.5366-15.2315-14.1142c-2.57126-3.57579-3.81909-5.78505-5.55885-9.8321 2.08878 4.05532 3.50493 6.25395 6.33485 9.8321 4.73209 5.98525 14.4555 13.184 14.4555 13.184v0.93012z"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m295.95 400.21c15.4476-2.14725 21.4565-11.1726 34.614-13.2224-1.38662 0.0726-1.13327-0.47126-2.39351-0.20551-11.6026 2.44783-18.6974 11.2246-32.2205 13.428z"
        S.circle
          ! A.fill "#D99F31"
          ! A.stroke "none"
          ! A.cx "314.799"
          ! A.cy "382.209"
          ! A.r  "4.572"
        S.path
          ! A.fill "#F1BF31"
          ! A.stroke "none"
          ! A.d "m319.287 381.34c-0.0402 0.14823-0.0998 0.29173-0.17775 0.42756-0.67087 1.16102-2.5063 1.35354-4.09902 0.43405-1.59449-0.92007-2.34449-2.60551-1.67303-3.76653 0.19074-0.33071 0.47716-0.58287 0.825-0.75295 0.20846-0.0289 0.42047-0.0443 0.6372-0.0443 2.22697 0 4.0813 1.5939 4.4876 3.70216z"
        S.circle
          ! A.fill "none"
          ! A.strokeWidth "1.4"
          ! A.cx "314.8"
          ! A.cy "382.209"
          ! A.r "4.805"
        S.path
          ! A.fill "#A48253"
          ! A.stroke "none"
          ! A.d "m330.798 384.331s0.42933 0.24331 0.6933 0.54213c0.26576 0.29941 0.36379 0.6561 0.18071 0.88405 0 0 0.10571 0.2622 0.44823 0.51083 0.45886 0.33425 1.063 0.30768 1.72972 0.41161 0.84922 0.137 1.44509 0.25335 2.04686 0.42992 0.60472 0.17657 1.36239 0.49016 1.36239 0.49016l-3.42579-1.7067-3.03543-1.56201z"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m297.758 357.549s-8.52695-2.23583-19.4214-6.3012c-10.8951-4.06772-18.2368-10.872-18.2368-10.872s7.34175 6.18365 18.2368 10.2508c10.8945 4.06772 19.4214 5.99235 19.4214 5.99235v0.93012z"
        S.circle
          ! A.fill "#D99F31"
          ! A.strokeWidth "1.244"
          ! A.cx "334.687"
          ! A.cy "394.974"
          ! A.r  "4.882"
        S.path
          ! A.fill "#F1BF31"
          ! A.stroke "none"
          ! A.d "m338.153 397.954c-1.46103 0.55394-3.39153-0.39626-4.47638-2.27598-1.17107-2.02678-0.91418-4.36654 0.57283-5.22695l0.0638-0.0349c0.12283-0.009 0.24626-0.0154 0.37145-0.0154 2.52461 0 4.57205 2.04685 4.57205 4.57441 0 1.1374-0.41574 2.17795-1.10374 2.97874z"
        S.circle
          ! A.fill "none"
          ! A.cx "334.683"
          ! A.cy "394.974"
          ! A.r  "4.572"
        S.path
          ! A.fill "#A48253"
          ! A.stroke "none"
          ! A.d "m289.595 332.55s0.5191 1.58859 0.92422 2.57657c0.30059 0.73347 0.83622 1.85197 0.83622 1.85197s-1.11851 0.23918-1.11851 0.11457c0-0.1252-0.87225-4.52422-0.87225-4.52422l0.23032-0.0189z"
        S.path
          ! A.fill "#658D5C"
          ! A.stroke "none"
          ! A.d "m289.006 333.474c-1.65118-2.52874-5.162-5.34215-7.14685-7.40375-3.41339-3.54449-5.5317-7.6063-6.31005-12.4914-1.83779-11.5464 1.52008-19.3116 9.9455-27.117 0.53209 8.1 5.1638 14.8152 6.1441 22.904 1.40551 11.6026-5.97755 13.7894-0.84922 25.1445l-1.78346-1.03642z"
        S.path
          ! A.fill "#A48253"
          ! A.stroke "none"
          ! A.d "m287.887 331.17s0.0986 0.50079 0.2374 1.12086c0.32894 0.39803 0.62657 0.79429 0.88051 1.18229l1.4622 0.8498-0.7813-2.66693-1.79882-0.48602z"
        S.path
          ! A.fill "none"
          ! A.d "m289.006 333.474c-1.65118-2.52874-5.162-5.34215-7.14685-7.40375-3.41339-3.54449-5.5317-7.6063-6.31005-12.4914-1.83779-11.5464 1.52008-19.3116 9.9455-27.117 0.53209 8.1 5.1638 14.8152 6.1441 22.904 1.40551 11.6026-5.97755 13.7894-0.84922 25.1445"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m288.996 331.076c-3.35552-5.04745-4.01162-7.5142-5.4301-12.7158-2.66811-9.7689-2.68465-21.6325-0.17421-25.966-2.51044 4.33346-3.02717 16.1368-0.60001 25.9748 1.36654 5.5435 2.45374 8.43605 5.56475 13.5414l0.63957-0.83445z"
        S.path
          ! A.fill "none"
          ! A.d "m288.588 332.886c-0.81968-0.95729 0.22855-2.52933 1.17107-1.14213"
    S.g
      ! A.fill "#000000"
      ! A.stroke "#000000"
      ! A.strokeWidth "0.933"
      ! A.strokeLinecap "round"
      ! A.strokeLinejoin "round"
      $ do
        S.path
          ! A.strokeWidth "0.777"
          ! A.d "m514.668 257.68c-0.013-0.0437 0.0135-0.23032 0.039-0.26752 0 0 0.297-0.43405 0.6-1.14626 0.30705-0.7246 0.61415-1.72146 0.6313-2.83464l1.65885 0.34133c-1.3825 4.93878-1.4386 6.6892-1.4386 6.6892-0.013 0.41575-0.48365 0.47953-0.6065 0.0833l-0.88405-2.86535z"
        S.path
          ! A.d "m519.124 275.312c1.32345-0.86811 1.7675-3.11044 1.8502-4.56142 0.14765-2.60374-2.02205-4.90866-2.13425-7.32105-0.0709-1.54725 1.26615-1.7067 1.5195-2.91319 0.2244-1.07776-3.96145-4.85611-2.8317-7.83365 0.80785-2.12835 2.50395-1.08189 3.15175-3.30768 0.6827-2.35689-1.435-5.7248 1.2874-7.30925 1.32225-0.77008 3.264 0.35078 3.8392-1.7126 0.5858-2.09941 0.11985-6.2705 3.1435-6.56515 4.0116-0.39272 4.6317 7.8195 5.3693 8.39645 0.76595 0.6 1.79175-0.5002 2.88425-0.0667 2.94625 1.17343-0.20785 6.60885-1.22125 8.42185 7.47285 0.30532 0.63955 4.95237-0.50845 7.0181 0.3177 0.75414 2.2299 1.03407 2.5435 2.1821 0.2055 0.7559-0.36145 1.42028-0.88465 1.88326-1.67365 1.47816-4.1711 2.03269-5.9882 3.22855l-0.24925 0.17894c-0.062 0.68268 1.8313 2.68228-0.72045 3.52972-4.76515 1.58623-7.7988 2.62618-9.63605 7.43921-0.4943 1.29153-0.66675 5.25529-0.75825 4.84843l-0.65615-5.53585z"
        S.path
          ! A.fill "#658D5C"
          ! A.d "m519.848 279.074l-0.82795-3.63779c0.2238-0.12107 0.41455-0.30177 0.59765-0.47599 0.96965-0.93189 1.43265-3.50905 1.50765-4.80236 0.16185-2.80926-1.87735-4.42028-1.9789-6.75651-0.052-1.2124 1.2939-1.64645 1.5112-2.79448 0.27635-1.46162-3.7559-4.99548-2.6988-7.75926 0.7187-1.87263 2.4602-0.90531 3.16415-3.34488 0.6124-2.12598-1.2248-5.91735 1.07305-7.19055 1.3878-0.76595 3.38445 0.46535 4.0553-1.99311 0.50845-1.85847 0.11635-5.0309 2.7431-5.2943 3.57105-0.35728 4.1067 6.81435 5.03505 7.5266 1.02995 0.78897 1.84785-0.23504 2.8382 0.15177 1.4929 0.58287 1.125 2.64272 0.78895 3.83032-0.38855 1.38071-1.0612 2.51929-1.63225 3.80197-0.11165 0.25571-0.114 0.49606 0.1872 0.61063 0.9384 0.35492 1.73975 0.20492 2.06575 1.43621 0.4423 1.67186-2.126 3.49843-2.6947 4.82363-0.4429 1.0317 1.29155 1.29331 1.51715 2.65985 0.32185 1.92874-6.15175 4.09016-6.64785 4.99547-0.0579 1.26437 1.62165 2.57244-0.4193 3.25571-5.1266 1.71733-10.2449 4.94587-10.1846 10.9571z"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m519.398 275.86s6.52795-11.6226 8.41535-19.8744c1.30395-5.7118 1.87915-14.9581 1.87915-14.9581s-0.2829 9.2132-1.4138 14.9398c-1.7232 8.7059-8.4697 20.987-8.4697 20.987l-0.411-1.09429z"
        S.path
          ! A.strokeWidth "0.777"
          ! A.d "m519.608 286.898c-0.008-0.0478 0.048-0.23032 0.0809-0.26575 0 0 1.275-1.34114 2.0327-2.19863 0.29525-0.33248 0.4795-0.73523 0.58995-1.06299 0.1057-0.31772 0.1388-0.5504 0.1388-0.5504 0.0295-0.20551 0.20785-0.31771 0.4051-0.25098l2.1697 0.71634c0.29705 0.0974 0.336 0.36732 0.0809 0.54803-0.014 0.008-1.66775 1.17933-2.26535 1.8939-1.3205 1.57382-1.66715 2.16909-2.19865 3.79311-0.1246 0.37559-0.5362 0.34665-0.6-0.046l-0.43405-2.57658z"
        S.path
          ! A.fill "#A48253"
          ! A.strokeWidth "0.777"
          ! A.d "m520.348 289.424c0.54565-1.67008 0.91535-2.29902 2.25475-3.89587 0.6313-0.75177 2.32555-1.94941 2.32555-1.94941l-2.17025-0.71634s-0.14115 1.02519-0.80315 1.77756c-0.76005 0.85925-2.04095 2.20689-2.04095 2.20689l0.43405 2.57716z"
        S.path
          ! A.d "m511.694 247.35s2.726 5.43365 5.07225 13.7888c4.8378 17.2506 5.46495 39.649 3.3803 51.9685-6.4075 37.8674-40.6624 73.2755-68.315 78.796-23.1928 4.62815-36.8734 14.5134-46.5945 25.236-7.5579 8.73485-10.4794 13.9424-17.3333 27.9054-2.10945 4.29803-9.01535 5.14135-6.04605-0.90945 5.37345-9.49075 10.477-18.2569 18.3484-27.5882 10.2336-11.5654 24.9366-22.9098 49.7652-27.8994 28.549-5.7366 61.442-41.0841 67.85-78.9495 2.08405-12.3189 1.44215-39.1695-5.5193-56.443l-0.60825-5.9049"
        S.path
          ! A.strokeWidth "0.846"
          ! A.d "m497.255 240.334s-8.04805-0.30532-4.17756-6.401c-3.68327-1.81063-8.1242-5.0935-3.37205-7.80295-0.21319-0.92363-3.02244-1.81063-2.81103-3.98859 0.12284-1.25197 1.7067-1.8248 1.8437-2.36279-0.52323-0.98622-4.19587-5.7012-2.92323-7.10905 1.95355-2.15965 6.17481 0.44173 8.09706 1.60098 0.47834-0.2935 1.18642-0.88878 1.66181-1.20472 2.80512-1.85847 2.99173 2.63681 3.75945 4.07362 0.35315 0.65847 2.56712-1.125 4.06182-0.33425 2.58485 1.36654 1.4433 4.70315 2.09295 6.9555 0.6472-0.0703 1.57795-0.59764 2.22575-0.64134 4.19-0.28051 1.9205 7.0949 1.74155 9.414 6.66085-0.96082 1.5372 5.8736 1.9063 11.7437 0.10215 1.62166-0.4004 5.20335-1.6506 3.82678-3.9425-4.34174-14.8996-3.15414-12.4559-7.7699z"
        S.path
          ! A.stroke "1"
          ! A.d "m496.324 264.527c-1.44154-0.11634-4.56851-0.55866-5.18505-1.9252-0.97382-2.16792 1.55905-2.9126 1.43445-3.07678-0.88642-1.17992-4.99488-1.93523-5.0179-3.58819-0.0165-1.16043 1.92284-1.99075 1.57973-3.04783-0.46949-1.44685-3.23682-3.64843-2.16378-5.2571 1.30039-1.94528 4.03465 0.6685 5.35275 0.65197 0.62716-0.008 1.51417-1.39725 2.71594-1.41851 1.76929-0.029 2.84705 3.41339 3.51556 3.32008 0.73937-0.10157 1.19173-1.11732 1.91872-1.33464 2.21695-0.66733 2.85 1.72972 3.37205 3.29055 1.0317 3.08563 2.1443-0.57697 3.812 0.14941 4.21475 1.83957 2.47915 10.0931 3.70215 11.084 0.73645 0.59528 2.11715 0.52087 2.6593 1.36181 1.1545 1.7941-0.42935 5.4189 0.45885 8.664 0.35965 1.3128 4.4557 5.1248 4.4557 5.1248s0.636 3.81792 0.5315 3.6189c-1.8455-3.55098-2.24645-4.3937-5.55-6.9183-3.1748-2.4248-7.9996-0.50197-9.1128-1.77283-1.2378-1.41614 0.1931-2.70827-0.45-3.32835-0.2457-0.23504-3.97265 0.15118-4.5331 0.0951-2.64922-0.26575-5.0805-2.67638-3.49607-5.6929z"
        S.path
          ! A.fill "#658D5C"
          ! A.strokeWidth "1"
          ! A.d "m518.514 278.198l0.42755 2.37697c-6.7955-9.72105-12.3414-5.85945-13.7988-7.4392-1.10905-1.20237 0.30475-2.06811-0.6-3.01063-0.9573-0.99863-6.66911 1.11496-8.36576-3.32008-0.35315-0.92244 0.90708-2.44607 0.26988-2.57067-1.44508-0.28288-3.39272-0.24272-4.38485-1.55079-0.41338-0.54626-0.7689-1.2939-0.22854-1.88386 0.28051-0.30473 0.61063-0.56398 0.84449-0.91063 0.88288-1.3128-4.48642-2.32559-4.50295-4.27973-0.0106-1.11968 1.46161-1.52421 0.92185-2.90256-0.47126-1.20649-2.10118-3.20374-1.2691-4.51654 1.00925-1.58976 3.27225 0.41162 4.53308 0.55689 0.6189 0.0709 1.66949-1.3872 2.69114-1.41614 1.62579-0.0479 2.3191 2.97284 3.56221 2.85059 1.2124-0.11988 2.5896-2.00551 3.91655-0.36732 0.9242 1.14212 0.90295 4.47697 3.0685 3.51083 0.51735-0.23032 1.2874-0.86162 1.86675-0.61004 3.46535 1.49882 2.5807 7.0677 3.4423 10.0305 0.463 1.59035 2.11595 1.23957 2.7077 2.22342 0.2864 0.47776 0.5256 1.03051 0.57285 1.59036 0.042 0.48012-0.0325 0.95374-0.0974 1.42677-0.2681 1.92047-0.0874 3.64606 0.401 5.52755 0.3856 1.49882 2.4933 4.27677 4.02165 4.68425z"
        S.path
          ! A.d "m520.088 307.84l0.34015-0.27992c1.19825-0.0213 2.0268-2.49804 2.3876-3.44527 1.5012-3.93426-1.19585-10.4622 3.34725-10.4416 0.2321-1.62757 0.56515-5.625 2.0451-6.69036 1.0736-0.77362 2.12595 0.19961 3.15175-0.1057 0.76005-1.53189 1.12145-4.43918 3.30355-4.84784 0.69155-0.12874 2.1431 0.99449 2.38405 0.87225 0.5953-0.29882 1.3016-3.41811 3.04785-3.88937 1.07715-0.29055 2.0929 0.82205 2.48505 0.57106 0.63955-0.40925 1.25845-1.07775 1.78995-1.64468 2.27775-2.43307 5.1177-2.475 5.04155 0.77067-0.027 1.1563-0.76655 2.78858-1.17935 3.84331-0.1417 0.35728 1.4321 1.1061 1.67125 1.56555 0.80555 1.53425-2.02615 3.35551-2.6598 4.56378 0.0435 0.20373 1.4994 0.49428 1.7167 0.79901 1.88565 2.63741-3.57105 5.52755-4.95175 7.14865-0.5439 0.63779 1.3246 2.0563 1.06535 3.16063-1.0441 4.42854-7.86495 2.79863-9.375 3.48602-0.525 0.24095-0.68505 2.61201-1.12915 3.21437-1.92045 2.59548-9.5262-0.57519-11.2536 1.05059-1.5738 1.48229-2.09705 4.00926-3.09805 5.8116-0.2161 0.39213-0.63365 0.27166-0.5982-0.1376l0.4677-5.3752z"
        S.path
          ! A.fill "#658D5C"
          ! A.d "m520.538 308.03c1.4079-0.0685 2.28605-2.63268 2.7112-3.74764 0.55455-1.45335 0.802-2.90256 0.8581-4.45158 0.0851-2.25059-1.5242-6.20434 1.97005-5.6687 0 0 0.73705-5.2754 2.24825-6.49194 0.98505-0.79134 2.7437-0.34252 3.1689-0.6567 1.0075-0.74291 0.61715-3.95965 2.79035-4.37067 0.84155-0.16004 2.351 0.67264 2.99235 0.35315 0.8037-0.4004 1.0919-2.81398 2.6303-3.22441 0.962-0.25571 2.2364 0.78248 2.8636 0.39036 1.3246-0.82677 2.33325-3.44292 4.2065-2.91733 2.11415 0.59174 1.3683 3.80138 0.8309 5.11595-0.38445 0.94075 0.68505 1.2815 1.06475 1.97244 0.71045 1.29744-1.6506 3.35906-1.94525 4.50354-0.11225 0.4252 0.9283 0.9443 1.18935 1.22303 1.57205 1.67953-2.4768 4.64882-3.56455 5.57716-0.32425 0.27578-1.02815 0.82795-1.06715 1.27086-0.0832 0.94193 0.9319 1.62933 0.6703 2.77796-0.8888 3.89882-6.316 2.74901-8.44845 3.46122-0.85985 0.28582-0.98445 2.03209-1.51595 2.76142-1.7061 2.34212-9.18605 0.0791-11.1933 1.9122-1.2 1.09607-2.16795 2.9817-2.82995 4.45808l0.3697-4.24843z"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m521.658 307.028c0.2362-0.0661 9.06675-7.0949 14.0268-12.4831 4.0618-4.41201 9.4577-12.121 9.4577-12.121s-5.3315 7.86085-9.3018 12.4305c-5.0203 5.77855-13.9447 13.5024-14.1809 13.5691-0.2368 0.0661-0.23915-1.32933 0-1.39548z"
        S.path
          ! A.d "m523.694 284.444c-2.07815-1.20827-1.7693-7.67365 1.27085-10.6075 2.5559-2.4691 9.7063 4.8 7.487 7.8065-1.22715 1.66359-6.5675 4.07421-8.7579 2.80099z"
        S.path
          ! A.d "m532.498 280.529c-1.28565 1.05708-4.27145-0.32362-5.7868-1.83898-1.38895-1.39134-2.23285-3.51968-1.4014-4.50177 1.6376-1.94351 6.2014-4.73386 8.3941-2.8943 2.1821 1.82953-0.0415 8.27835-1.2059 9.23505z"
        S.path
          ! A.fill "#A48253"
          ! A.d "m532.078 281.366c-1.16695 1.58031-6.2622 3.61713-8.1496 2.52047-1.6423-0.95492-1.6234-6.8374 1.35825-9.71695 1.88095-1.81476 8.8925 4.35178 6.79135 7.19645z"
        S.path
          ! A.fill "#D99F31"
          ! A.strokeWidth "1.09"
          ! A.d "m533.248 271.806c1.8189 1.52657 0.0584 7.45455-1.0488 8.3634-0.9402 0.77481-3.6124-0.25925-5.1614-1.80768-1.4073-1.41024-2.07815-3.3809-1.5319-4.02815 1.68365-1.99606 5.9238-4.05354 7.74215-2.52756z"
        S.path
          ! A.fill "#F1BF31"
          ! A.stroke "none"
          ! A.d "m531.891 271.844c-0.52735 0.5568-0.875 1.50977-0.875 2.59375 0 1.68392 0.8431 3.05749 1.89065 3.10937 0.14395-0.45772 0.27745-0.94121 0.375-1.4375 0.1685-0.85662 0.2537-1.73033 0.1875-2.4375-0.0662-0.70716-0.28955-1.21091-0.57815-1.45312-0.005-0.005-0.01-0.0111-0.0155-0.0156-0.2463-0.20005-0.57355-0.31783-0.96875-0.35938-0.005-0.0005-0.011 0.00049-0.0155 0z"
        S.path
          ! A.strokeWidth "0.863"
          ! A.d "m493.752 286.796c-0.58111-1.79174-3.34311-3.02717-3.63308-5.18445-0.1311-0.98032 0.94252-2.64744 0.85276-2.938-0.47717-1.55728-3.07441-3.56516-1.7439-5.50215 1.71732-2.50216 4.16279 0.0809 6.19845 0.67264 0.33366-0.12697 0.44586-1.24606 1.24134-1.45748 3.11634-0.82854 5.8299 4.23367 6.64845 4.54075 2.41655 0.91595 4.3122-3.35964 5.6262 5.98405 1.03405-0.24743 2.4396-0.50256 3.0632 0.56044 2.5701 4.40374 1.0695 13.8927 6.2055 16.4422l0.16655 0.33661c-0.0703 0.37323-0.2368 3.17836-0.99035 2.26359-1.29805-1.57382-2.3197-3.8126-4.5803-4.20886-2.38585-0.41752-12.8032 3.35138-13.0831-1.38071-0.0331-0.55866 0.72284-1.3252 0.47304-1.86733-0.59529-1.30334-6.85336-0.84685-7.51006-4.34528-0.25689-1.37244 0.70807-2.62264 1.06535-3.91594z"
        S.path
          ! A.fill "#658D5C"
          ! A.strokeWidth "0.863"
          ! A.d "m517.578 301.936c-3.8309-5.9445-5.5441-3.70216-11.3616-3.26398-1.32695 0.0992-5.8016 0.28642-5.72245-1.95414 0.023-0.63779 0.5067-0.80551 0.10985-1.57382-0.84511-1.64468-6.08803-1.3435-6.87698-4.38898-0.40866-1.57618 0.45709-3.70039 0.23681-4.29449-0.7311-1.97834-3.98622-3.82854-3.0189-6.41989 0.12874-0.34429 0.31949-0.66202 0.38209-1.0317 0.19488-1.1439-2.14311-3.76418-1.10256-5.45255 1.20886-1.96359 3.31949-0.4128 4.92697 0.31536 1.15039 0.52205 0.85925-0.49607 1.61988-0.74705 1.32815-0.44055 2.98347 0.82854 3.87229 1.67953 0.4984 0.47953 2.074 2.35925 2.475 2.54586 0.93835 0.43583 2.53285-0.0602 3.62125 0.32185 0.97735 0.34488 1.63995 4.44921 1.7876 5.49565l0.18895 0.13111c0.89055-0.19312 2.20275-0.18485 2.73665 0.68326 2.4289 3.96142 1.2354 13.4191 6.44645 16.2904l-0.3213 1.66359z"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m517.278 301.663s-6.9183-11.4426-12.89-17.4284c-3.80965-3.81615-10.6412-8.82875-10.6412-8.82875s6.89587 5.2305 10.6412 9.26045c5.44845 5.8612 11.4951 16.9966 11.4951 16.9966h1.3949z"
        S.path
          ! A.d "m509.884 319.282c0.30885 0.14704 0.96675 0.0325 1.37835 0.14291 3.0484 0.83268-1.314 9.67206-1.5614 11.6126-0.0644 0.51733 0.2675 2.18918 0.235 2.30079l-0.66495 3.76241c-0.1181 0.39035 0.0726-3.74351-0.52735-4.77343-1.0624-1.82717-4.4138-0.84095-6.13525-1.1067-2.84648-0.43819-0.6254-2.87126-1.86085-3.36555-2.04095-0.81614-6.2994 0.34902-6.8061-2.68878-0.18898-1.13386 0.55866-2.34685 0.48189-3.31595-1.46339-1.69429-5.22225-2.07224-4.7876-5.04745 0.14941-1.03169 1.65413-2.12657 1.61338-2.79508-0.052-0.80964-3.15-3.0815-2.41122-4.73563 0.45296-1.01102 1.32697-1.01516 1.40965-1.60512 0.0874-0.61063-2.51162-4.51181-0.32599-5.56655 2.62264-1.26496 4.78878 1.6937 6.67795 1.8313 0.9567 0.0703 1.80237-1.49527 3.24922-1.17342 1.52657 0.34074 1.69667 2.38583 2.39232 3.52146 0.67445 0.0248 1.33705-0.69744 2.08645-0.77422 3.19725-0.33484 2.70295 4.7876 3.5256 6.5504 0.0998 0.21437 1.0612-0.36732 1.45745-0.21142 0.6685 0.25926 0.91595 1.00453 1.0128 1.65709 0.2811 1.91811-0.7429 3.96968-0.43935 5.7803z"
        S.path
          ! A.d "m530.144 326.956c0.6006 6.0378-7.58505 0.0909-12.0862 2.48976-1.3429 0.71339-4.48465 3.1187-4.2561 2.54115l1.13325-2.85296c0.37385-0.31594 1.58035-0.32008 2.00435-0.51319 0.9756-0.44409 2.31025-1.98838 3.2055-3.66437 1.2396-2.32323 0.3945-4.94941 1.14805-6.6567 1.1545-2.61024 2.961-0.21023 3.73935-0.77421 1.44095-1.04469 1.68425-6.32245 5.20395-6.37675 0.92715-0.0147 0.90885 0.16417 1.5508 0.47362 0.7323-1.06713 0.9691-2.37933 2.39175-2.82343 1.02755-0.32185 1.7291 0.59351 2.6787 0.58465 0.68095-0.53327 3.3201-4.95532 5.4827-4.43623 2.4319 0.58288 0.96615 4.90808 0.7831 6.4925 0.2681 0.29469 0.60415 0.28819 1.0299 0.85748 1.67365 2.23996-0.949 4.6317-1.8502 6.3951 0.23685 0.52914 0.9136 0.49784 1.06125 1.17048 0.6 2.73484-4.5945 3.07146-5.1301 3.80256 0 0.25276 0.3998 0.54508 0.3549 1.1185-0.26395 3.34902-8.025 2.45434-8.4449 2.17206z"
        S.path
          ! A.d "m477.587 346.87c0.15355-1.14449-2.24055-2.88012-1.23543-4.45217 0.81554-1.27441 2.67815-0.61595 3.42756-1.27205 0.64606-2.02677-0.42697-4.75926 2.38642-5.3888 1.42795-0.31712 2.21279 1.12972 2.67579 2.23052 0.17421 0.40866 0.80787 2.93563 1.05295 3.02303 0.52736 0.18898 1.92461-0.80964 2.62441-0.71044 1.90571 0.27461 0.40276 3.84095 0.98209 4.84843 0.40689 0.70808 1.42205 0.14941 2.07047 0.37205 1.92224 0.66024 0.42933 3.85926 0.42933 5.2258 0 0.83682 1.38484 1.09193 1.49941 2.5122 0.20138 2.54587-1.95 2.82167-3.17304 4.46634-0.17007 0.23033-0.21141 0.34252-0.0183 0.57698 2.1071 2.56889 0.91359 3.82087-1.4185 5.51695-2.74665 1.99489-6.9762 3.26575-5.42305 7.5307 0 0-1.38897 2.85059-1.53838 1.90217-0.22028-1.39548 0.45649-2.81989 0.0703-4.3376-0.41339-1.61929-5.3634-3.74764-5.56065-5.4939-0.14115-1.2313 1.2874-1.41614 1.3996-2.52461 0.12933-1.26024-4.2939-2.42363-3.77657-4.92107 0.27992-1.35 1.71909-1.74626 2.34803-2.83642-0.10157-1.06063-5.03505-4.82894-0.70334-5.8116 0.54567-0.12461 1.41319-0.11634 1.8809-0.4565z"
        S.path
          ! A.fill "#658D5C"
          ! A.d "m481.75 372.916c0.1683-1.22953 0.31771-2.89075 0.004-4.09666-0.45236-1.74449-4.29626-3.93898-4.46634-5.4508-0.10985-0.96319 0.6254-1.21476 0.77893-2.4189 0.20788-1.62283-3.78898-2.66161-3.31594-4.89567 0.28819-1.36831 1.99783-2.02205 1.83543-3.23681-0.0892-0.67677-2.11358-2.34863-1.68189-4.08662 0.35079-1.40551 1.875-0.84508 2.75906-1.55256 0.97027-0.77303-1.90158-3.1311-0.98563-4.54961 0.72638-1.12677 2.71358-0.63306 3.27638-1.43031 0.58346-0.82441-0.46713-4.26674 2.3002-4.90867 2.18917-0.50669 2.63504 4.19174 3.56339 4.875 0.87815 0.64843 1.27677-0.5126 2.65099-0.32598 1.35413 0.18484 0.31004 3.49252 0.84566 4.48937 0.57874 1.0813 1.49883 0.22205 2.43544 0.5563 1.51122 0.53977 0.0206 3.74587 0.0206 4.86083 0 1.16457 1.2313 1.1628 1.34114 2.54115 0.17893 2.24054-1.95178 2.80748-3.07914 4.18819-0.31181 0.37972-0.33898 0.73287 0.007 1.10492 2.02855 2.18563 0.59764 3.49842-1.3748 4.92283-3.06437 2.21516-6.66495 3.43996-5.12185 7.90215l-1.79233 1.51181z"
        S.path
          ! A.d "m531.058 337.065c1.5242-0.39213 3.61715-1.87854 5.08935-0.70335 2.79035 2.22933-2.0699 6.13345-2.96695 8.22225-0.017 0.76181 1.5526 1.02107 1.4504 2.55532-0.17835 2.69764-3.77185 2.12244-5.462 3.08563-0.13345 0.48602 0.6183 0.90708 0.6183 1.3872 0 3.81851-5.76555 2.37697-7.9642 3.09154-0.6998 0.22618 0.47955 2.24823-2.02085 3.1937-1.07955 0.4063-2.6244-0.0213-3.7187-0.21437-1.3264-0.23445-2.67815-0.50847-4.03405-0.43406-0.55865 0.0313-1.1315 0.17835-1.69255 0.12933-0.24035-0.0213-0.41275-0.1376-0.32185-0.40925l6.3-18.5852c0.13465-0.39862 2.87185 0.6378 3.4819 0.6378 0.67855 0 1.3453-1.42441 1.8189-1.8567 1.6441-1.50118 2.4378 0.6313 3.81025 0.63957 1.0004 0.004 3.81615-5.589 5.612-0.73937z"
        S.path
          ! A.strokeWidth "0.777"
          ! A.d "m499.83 340.094c-0.049-0.78544-1.62933 1.60453-1.62933 1.60453s1.12323 1.1067 1.88745 1.76279c0.9425 0.81201 2.5228 1.95355 2.5228 1.95355l0.1518-1.17697s-2.79276-1.95177-2.93272-4.1439z"
        S.path
          ! A.d "m498.153 332.518c0.42815 0.6059 0.16004 1.42441-0.13288 2.03209-0.32126 0.67086-0.51023 1.07185-0.94901 1.65531-1.43681 1.90394-4.62756 3.60414-6.0685 2.61615-1.3122-0.89941-3.99508-8.7809-1.89567-10.1386 1.99666-1.29213 7.17755 1.1876 9.04605 3.83504z"
        S.path
          ! A.d "m490.57 336.029c0.62303-0.94311 1.53307-1.65945 2.42185-2.33622 1.26378-0.96733 4.47992-2.67815 5.9002-1.30748 1.86262 1.79941 2.75967 7.23955 0.59586 9.12875-2.85059 2.49212-7.464-0.37737-9.26045-2.84409-0.6183-0.84862-0.17008-1.86496 0.34252-2.64095z"
        S.path
          ! A.fill "#A48253"
          ! A.d "m493.292 334.184c1.94764-1.44685 4.16044-2.25059 4.99725-1.37008 2.24647 2.3693 2.35927 6.90355 0.7996 8.22815-1.57145 1.33346-5.224 1.22716-8.3758-2.75493-0.66496-0.84094 0.6124-2.64153 2.57894-4.10315z"
        S.path
          ! A.fill "#D99F31"
          ! A.strokeWidth "1.09"
          ! A.d "m497.646 332.256c1.05237 1.93523-4.68839 7.33345-6.60295 6.0549-1.32874-0.88465-3.13937-7.67835-1.83544-8.85415 1.84193-1.663 7.5242 1.11732 8.4384 2.79921z"
        S.path
          ! A.fill "#F1BF31"
          ! A.stroke "none"
          ! A.d "m490.641 329.5c-0.47064 0.0306-0.83673 0.15553-1.0625 0.35937-0.0285 0.0258-0.067 0.11921-0.10937 0.23438 0.78185 0.38655 2.17713 0.73662 3.60937 1.375 2.04575 0.91048 3.46033 2.10899 4.0625 1.76562 0.0958-0.33218 0.10073-0.59098 0.0312-0.71875-0.14553-0.26775-0.62961-0.74254-1.28125-1.1875-0.65163-0.44495-1.46835-0.8852-2.3125-1.21875-0.84414-0.33355-1.71393-0.56172-2.4375-0.60937-0.18089-0.0119-0.34311-0.0102-0.5 0z"
        S.path
          ! A.fill "#466343"
          ! A.d "m512.038 356.94c2.87125-0.13878 5.61675 1.13622 7.35235 0.50905 2.58485-0.93012 1.0069-2.94212 2.25295-3.05433 1.24605-0.11456 7.53305 0.34666 7.5266-2.78209 0-0.60236-0.5067-0.8374-0.2805-1.51594 0.22615-0.67913 4.9565-0.45059 5.1266-2.97756 0.10745-1.61102-1.36005-1.62933-1.13385-2.60551 0.22615-0.9756 5.2925-5.76851 2.7679-7.75275-1.7386-1.36654-4.5868 1.01929-4.85495 0.32184-0.35075-0.90944-0.4293-1.67007-1.58205-1.77755-1.66715-0.15355-2.67405 2.4998-3.76185 2.4998-1.09015 0-1.5862-1.09016-2.7035-0.99036-1.46165 0.12874-1.6819 2.36103-2.928 2.36103-1.24545 0-3.18895-0.69154-3.18895-0.69154l-6.2994 18.5846s1.03995-0.0974 1.7067-0.12874z"
        S.path
          ! A.fill "none"
          ! A.strokeWidth "0.623"
          ! A.d "m515.124 349.614s5.91555-2.24055 9.39095-4.26674c3.32245-1.93701 7.99785-5.71655 7.99785-5.71655m-17.3888 9.98325s5.91555-1.92932 9.39095-3.95551c3.32245-1.93937 7.99785-6.02775 7.99785-6.02775"
        S.path
          ! A.strokeWidth "0.777"
          ! A.d "m477.297 379.028s2.34213-0.56752 3.28111-0.56752c0.93779 0 1.49232 0.45472 1.49232 0.45472l1.06536-1.95767s-3.18544 0.37795-4.12973 0.29291l-1.70905 1.77756z"
        S.path
          ! A.fill "none"
          ! A.d "m463.168 400.047c-1.86024-2.26949 4.31102-8.15435 6.6071-6.489 1.64468 1.1941 3.7122 6.3142 2.07461 7.8425-1.82776 1.7002-7.20295 0.45236-8.6817-1.35354z"
        S.path
          ! A.strokeWidth "0.777"
          ! A.d "m460.324 392.568l-0.68563-0.0472c-1.20414-1.50177-1.64233-1.56142-3.40689-2.04331-0.56102-0.15355-0.63956-0.74528-0.0337-0.90709l2.13484-0.56043c0.33839-0.088 1.2437 0.72047 1.50059 0.91122 0.40748 0.30295 2.47914 0.74705 1.71969 1.48051l-1.22895 1.16635z"
        S.path
          ! A.fill "none"
          ! A.d "m459.855 391.228c0.87165-1.31221 6.28465-1.62402 9.44115 1.15807 1.94114 1.71378 0.37972 4.13031-1.46162 5.68935-1.82303 1.54489-4.58267 2.81988-5.71654 1.82894-3.21615-2.81339-3.31182-7.09845-2.263-8.6764z"
        S.path
          ! A.fill "#658D5C"
          ! A.d "m513.108 333.132s2.61675-2.72422 4.7256-3.78485c4.0925-2.06161 10.7433 1.25611 11.7313-0.61063 0.50435-0.95079-0.2569-1.64646 0.37795-1.8998 0.63365-0.25335 7.89035 1.18582 8.17855-2.09528 0.0543-0.59114-0.7553-0.88996-0.1264-1.52185 0.63075-0.63071 5.2134-0.93779 4.75455-3.10394-0.1447-0.6933-1.1421-0.88878-0.8864-1.58208 0.25335-0.69567 3.6874-3.95965 2.22165-5.96105-0.42755-0.58406-1.5071-0.46949-1.4268-1.18347 0.2557-2.21752 1.0016-5.64565-0.8303-5.8246-1.9683-0.19075-4.2685 3.81201-5.0368 3.96615-0.95375 0.19075-1.52185-0.74941-2.475-0.4441-1.5827 0.50611-1.83545 2.85059-2.47085 2.85059-0.6331 0-0.58525-0.65433-1.60335-0.63366-3.1081 0.065-3.3691 5.0516-4.9246 6.27695-0.88645 0.69744-1.40965-0.24271-2.2837-0.062-2.1537 0.44174-1.5183 5.82755-2.65985 7.54135-1.1427 1.7126-3.61295 3.73878-4.11965 3.99449-0.50905 0.25335-1.50535 0.25099-1.50535 0.25099l-1.64055 3.82677z"
        S.path
          ! A.fill "#A48253"
          ! A.strokeWidth "0.777"
          ! A.d "m455.154 389.994s1.97244 0.6626 3.28051 0.73346c0.87992 0.0478 2.2565-0.12637 2.2565-0.12637s-0.54095 0.11398-1.125-0.29942c-0.19075-0.13523-1.54252-1.33287-1.54252-1.33287l-2.86949 1.02519z"
        S.path
          ! A.fill "#A48253"
          ! A.d "m460.398 391.64c1.45335-1.64705 5.66045-1.47048 8.7455 1.25019 1.53189 1.35118 0.51909 3.3815-1.30158 4.98899-1.83366 1.61752-4.16339 2.5187-4.95236 1.83071-3.0815-2.69469-3.55867-6.8616-2.49154-8.06991z"
        S.path
          ! A.fill "#D99F31"
          ! A.strokeWidth "1.090"
          ! A.d "m463.517 399.896c-0.69095-0.78897 0.41338-3.20787 1.88327-4.53248 1.30216-1.1752 3.42224-1.97835 3.88051-1.48643 1.79882 1.93111 3.64016 5.36695 2.21221 7.06951-1.43327 1.70905-6.4187 0.72874-7.976-1.05059z"
        S.path
          ! A.fill "#F1BF31"
          ! A.stroke "none"
          ! A.d "m469.062 394.484c-0.0464 0.006-0.0943 0.0215-0.14063 0.0312-1.49232 0.31772-2.33885 2.27882-1.89062 4.39063 0.2006 0.94383 0.62976 1.76231 1.17187 2.34375 0.002 0.002 0.0133-0.002 0.0156 0 1.29582 0.1 2.43774-0.15348 2.85938-0.65625 0.52391-0.62469 0.48832-1.6812 0.0156-2.90625-0.43676-1.13192-1.24009-2.30607-2.03125-3.20313z"
        S.path
          ! A.fill "#A48253"
          ! A.strokeWidth "0.777"
          ! A.d "m515.848 260.454s0.052-1.77107 1.4492-6.7624c0.24275-0.86988 0.90295-1.35177 0.90295-1.35177l-2.6061-0.35728s0.6644 0.6313 0.6526 1.45512c-0.033 2.33031-1.28505 4.15098-1.28505 4.15098l0.8864 2.86536z"
        S.path
          ! A.fill "#658D5C"
          ! A.strokeWidth "0.846"
          ! A.d "m512.958 255.114s-1.6943-4.95237-3.14175-6.75885c-1.53185-1.91693-2.63265-2.3191-5.41475-3.20788-2.4608-0.7872-6.30416-1.42027-6.46596-3.34901-0.16358-1.92874 0.0626-1.56378-0.63897-1.74863-2.25886-0.5935-5.0829-1.34055-4.54311-3.57756 0.53976-2.23819 1.37244-2.58661 0.40512-3.0561-1.42855-0.68918-5.18505-2.87599-4.73623-4.78997 0.44646-1.91634 2.11772-1.94173 1.41378-3.11693-0.5061-0.84035-2.31732-1.76279-2.17205-3.29468 0.10039-1.04469 1.42264-1.38307 1.38307-2.31319-0.0395-0.93189-3.58996-5.064-1.50118-6.78955 1.90394-1.57145 5.26595 1.2378 6.1252 1.59271 0.86162 0.35492 1.85197-1.4681 3.11221-1.1687 1.61988 0.38623 1.70492 2.81103 2.18209 3.67088 0.87401 1.56732 2.66223-0.47185 4.06123 0.27992 2.3321 1.25433 1.5201 5.56655 2.1496 6.43879 0.6266 0.87166 2.3498-0.52145 3.57285 0.15119 1.90215 1.05059 0.2746 7.34645 0.3986 8.37995 0.12465 1.03701 1.5077 0.14586 2.2967 0.76063 2.10115 1.63583-0.4565 6.6-0.052 10.7882 0.1394 1.44744 0.48605 3.69568 0.48605 3.69568l1.0795 7.41319z"
        S.path
          ! A.d "m496.894 399.126c0.66082 1.13504 1.86083 1.91811 2.41653 3.08504 0.78544 1.64055 0.0502 3.30768-1.93051 3.18543-0.85748-0.0526-1.64646-0.71456-2.46851-0.7813-0.66496-0.0514-2.56653 2.49154-4.41024 2.40886-2.51279-0.11043-3.71043-3.17657-5.2429-4.74449-1.22067-0.25748-2.11772 1.54075-3.47362 1.29567-2.78622-0.50256-2.65158-4.92461-3.613-6.87225-0.76771-0.57106-1.92874 0.63721-3.47362-0.45531-2.3876-1.68544-1.1374-6.98445-3.69804-8.46675-2.25472-1.3063-7.02345-0.44055-6.60885-0.65788l2.65807-1.3813c0.16595-0.0874 0.67441 0.15591 0.84036 0.18898 4.3565 0.86752 10.187 0.15354 14.6528 0.15354 2.14075 0 1.79646 1.72973 2.14075 2.08288l0.17244 0.0265c2.22342 0.15413 4.87736-0.008 6.77305 1.39311 2.29429 1.70315 0.12283 3.225 0.11457 3.60709l0.10334 0.0496 0.48544 0.16417 1.49764 0.43996c1.16043 0.37205 2.46023 0.88642 3.23858 1.875 1.13445 1.44095-0.13878 2.11359-0.17421 3.40335z"
        S.path
          ! A.fill "#466343"
          ! A.d "m467.191 386.192c0.96142 0.60827 13.7864 0.20374 15.5084 0.20374 1.86201 0 1.25374 1.47165 1.88918 2.02618 0.77244 0.35079 9.57995 0.0585 7.5744 3.38682-0.23032 0.38209-0.53209 0.72697-0.72638 1.12736l0.0449 0.36969c0.89941 0.74527 4.02224 0.80374 5.3817 2.5559 0.81023 1.04645-1.33642 2.72598-0.41693 3.38858 1.76516 1.26851 5.7118 6.9142-1.45158 5.2193-1.72323-0.40866-3.76358 4.39607-7.5118 0.0963-0.45472-0.52323-1.51122-2.04803-1.94586-2.34862-1.04646-0.72284-2.37874 0.95728-3.6626 0.74764-2.36044-0.38859-2.50748-4.52835-3.35729-6.26455-1.17106-0.81792-2.15079 0.1559-3.54803-0.83091-3.16831-2.23583 0.71456-9.9077-9.5368-8.7614l1.75866-0.91594z"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m466.256 386.406s9.65435 1.95531 15.2008 4.7504c5.09055 2.56653 11.9197 8.46319 11.9197 8.46319s-6.6567-6.26635-11.7644-8.92795c-5.2866-2.75315-14.5819-4.59508-14.5819-4.59508l-0.77422 0.30946z"
        S.path
          ! A.d "m491.113 376.212c2.50394 2.31909-1.28268 10.0447-4.1256 9.56105-4.53012-0.77185-7.0181-5.8884-6.16475-8.0687 0.91181-2.33563 7.58505-3.99685 10.2904-1.49232z"
        S.path
          ! A.fill "none"
          ! A.d "m486.598 384.988c-1.28031-0.91831-0.78839-4.16929 0.34488-6.13345 1.03819-1.79882 2.51457-2.92795 3.6437-2.57481 3.2126 1.00276 6.33305 5.22816 5.1307 7.80235-1.1811 2.53701-7.8443 1.81713-9.1193 0.90591z"
        S.path
          ! A.fill "#A48253"
          ! A.d "m490.902 376.44c2.3002 2.12953-1.35177 9.14585-3.86161 8.7183-4.31752-0.73523-5.87245-5.1809-5.3492-7.0116 0.53799-1.89153 6.6567-4.07185 9.21085-1.7067z"
        S.path
          ! A.d "m505.924 381.749c-0.411 0.5439-1.275 1.55492-2.1762 1.54665-3.84331-0.0366-3.5752-3.31772-5.5937-5.49745-0.67677-0.16417-1.17697 0.63307-2.49981 0.33189-1.73386-0.39685-1.83956-4.81476-4.43681-5.7177-1.3128-0.45531-4.9689-0.47421-6.9992 1.43209l3.63308-2.82756c3.51141 1.37834 6.67559-6.09625 10.6972-5.10355 1.14212 0.28169 1.17933 1.02756 2.50039 0.91122 2.93565-0.25984 5.92145-2.18622 9.45475-1.01988 2.1142 0.69803-0.63305 3.52972 2.0398 3.2061 1.7191-0.20964 4.2809-0.20138 4.7917 1.93524 0.28055 1.17283-0.3242 1.70433-0.19545 2.55354 0.34665 0.27047 6.79845 2.51457 3.38445 4.24193 0.54035 1.51654 3.13345 2.5317 1.761 4.38957-1.2874 1.74626-4.0299-0.19075-4.79055 0.5315-0.31295 0.30118-0.30055 1.13622-0.57635 1.4811-1.138 1.41319-4.1327-1.45807-5.4112-1.72854-1.2685 4.31102-3.5693 2.28012-5.58305-0.66614z"
        S.path
          ! A.fill "#658D5C"
          ! A.d "m491.454 372.425c2.66634 0.75118 2.73898 4.86437 4.27559 5.2488 1.53603 0.38386 1.49646-0.42579 2.45847-0.20374 0.88878 0.20374 1.78583 5.3882 6.08326 4.85256 1.0943-0.13701 1.64295-1.30039 1.64295-1.30039s1.57145 2.57716 3.2238 2.80925c2.37815 0.33425 1.69725-1.8059 2.3008-1.87677 0.96615-0.11162 2.7425 1.9376 4.5183 1.9376 1.0004 0 0.8575-1.7067 1.91395-1.7067 1.0571 0 3.14355 1.00689 4.00335-0.23091 1.12325-1.61516-1.4929-3.50905-1.68365-4.08602-0.1931-0.5752 0.7435-0.59174 0.6455-1.14803-0.3638-2.05335-3.69805-2.3817-3.98685-3.1063-0.28815-0.72224 0.46535-1.46811 0.1831-2.59311-0.47715-1.91457-3.1937-1.9813-4.42265-1.70906-2.84645 0.63367-0.26575-2.40236-2.2943-3.25747-3.4925-1.47284-8.57305 1.31634-9.8705 0.77008-0.87226-0.36733-1.20474-0.47599-1.95001-0.6065-3.14587-0.54626-6.04605 4.04292-8.03325 5.0002l0.99212 1.2065z"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m490.467 370.994s9.64847-0.59409 15.3107 1.37658c4.89805 1.70433 11.3634 6.9118 11.3634 6.9118s-6.96615-5.1242-12.1482-6.62955c-5.57482-1.61752-14.8666-0.73111-14.8666-0.73111l0.34075-0.92775z"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m481.945 371.67s1.84547-12.28 1.68602-20.172c-0.0957-4.74449-1.00098-12.1228-1.00098-12.1228s1.26909 7.6488 1.46634 12.5888c0.29232 7.3376-1.37717 18.7754-1.37717 18.7754l-0.77421 0.93071z"
        S.path
          ! A.d "m472.62 371.22c0.17657 0.525 1.9624 1.04233 1.8 3.0313-0.19488 2.43721-3.86811 1.68838-5.5766 2.83405-0.64607 0.43583 0.76535 2.52875 0.0248 3.52146-1.32697 1.77107-5.83465 0.71457-6.1624 1.15394-0.60472 0.81024 1.46929 3.04016-0.71634 4.26969-3.03838 1.70846-9.4518-0.99331-12.9106 2.07165-0.20374 0.18307-1.54901 1.69429-1.60098 1.70906-1.97717 0.52086-7.22185 1.60275-6.60885 1.34527 3.07677-1.2998 8.025-2.56653 8.99235-4.68189 0.82677-1.80236 0.20137-5.2057 0.53976-7.15335 0.50256-2.91083 2.64095-1.73976 3.34489-2.66398 0.56929-0.74705-0.48958-4.80413 1.81063-6.71635 1.61575-1.34114 3.34961-0.41987 4.82539-1.48287 1.54252-1.10847-0.78897-4.81477 2.25886-5.8695 1.83189-0.63307 3.73583 1.41201 4.15099 1.32225 1.13976-0.24449 2.47441-3.67737 4.78583-3.21556 2.30256 0.45827 1.275 3.4943 1.17697 4.89981 3.85984 0.47953 1.77106 3.34961-0.13465 5.625z"
        S.path
          ! A.fill "#658D5C"
          ! A.d "m441.417 390.864s8.2075-3.42993 8.87775-5.1514c1.03228-2.63918-0.0933-6.63605 1.3435-7.59095 0.93662-0.62481 1.875-0.31181 2.48977-1.2 0.61594-0.88878-0.18307-5.1951 2.03445-6.93485 1.38897-1.08839 2.64094-0.1128 4.33346-1.30217 1.82303-1.28563-0.48012-4.45984 2.3067-5.50395 1.64055-0.61476 3.28937 1.39311 4.10728 1.17933 1.57146-0.40925 2.40178-3.53622 4.7067-3.20197 1.85374 0.26811 0.94665 2.15552 0.82854 3.94075-0.0685 1.02579 1.54016 0.54981 2.01851 1.98721 0.35078 1.04645-1.08012 3.29468-2.03741 4.13209-0.54626 0.47716 1.66359 1.31575 1.53071 2.80216-0.1931 2.13662-4.31515 2.28603-5.27184 2.62855-1.23544 0.44055-0.12107 2.28661-0.95965 3.36201-1.34114 1.71909-4.77934 0.65197-5.39235 1.47224-0.56044 0.74941 0.68563 2.67993-0.89233 3.86398-1.63996 1.22953-8.01495 0.45059-9.049 0.83268-3.07264 1.1315-5.5748 2.31083-5.5748 2.31083l-5.39999 2.37343z"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m450.209 386.042s8.97225-6.45295 13.5608-12.2232c2.53051-3.18307 5.8736-8.0185 5.8736-8.0185s-3.23681 5.0138-5.7201 8.32795c-4.52835 6.0437-13.5662 12.9496-13.5662 12.9496l-0.14823-1.03583z"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m517.264 328.63c3.4488-1.86437 9.71105-5.09115 14.8252-9.7565 3.43995-3.13937 7.9252-8.93445 7.9252-8.93445s-4.45395 6.0939-7.9252 9.3992c-5.2199 4.97126-11.8412 8.51105-15.2906 10.3754l0.46535-1.08366z"
        S.path
          ! A.fill "#466343"
          ! A.d "m509.938 333.264l-0.79135 2.63268c0-3.63603-0.1435-5.3675-4.4492-5.139-0.66735 0.0331-1.35415 0.10748-2.01675 0.004-2.188-0.34252-0.50195-1.65708-1.19765-2.65807-0.85155-1.22067-6.6112-0.12401-7.0819-3.01063-0.18071-1.11673 1.06417-2.44606 0.15118-3.32245-1.38248-1.32401-4.82599-2.47205-4.45808-4.8998 0.15355-0.99863 1.49114-1.72323 1.29803-2.65335-0.25807-1.23957-2.73307-3.39508-2.12835-4.75689 0.4813-1.08603 1.36418-0.73523 1.44744-1.76043 0.0951-1.14449-1.90807-4.00099-0.12283-4.8691 2.35453-1.14449 3.94902 1.09016 5.9693 1.25433 1.17165 0.0951 1.96653-1.30039 3.18957-1.02756 1.58209 0.35078 1.59214 2.89783 2.60969 3.41929 0.3738 0.18898 1.49465-0.76004 2.02205-0.82027 2.83405-0.3254 2.1909 5.17205 3.1559 6.45945 0.35075 0.46535 1.0984 0.002 1.6051 0.16004 1.77345 0.55216-0.1264 6.5628 0.60475 7.36655 0.2486 0.27402 1.1498 0.12047 1.54425 0.23032 1.48055 0.41574 0.44645 4.23779 0.202 5.17675-0.5504 2.10768-2.45435 6.24745-1.55315 8.214z"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m509.828 332.84s-2.74665-10.9352-6.64605-16.8118c-3.22856-4.86674-10.3028-10.8674-10.3028-10.8674s6.76715 6.04605 9.83742 10.8674c3.76415 5.90905 6.33305 16.8118 6.33305 16.8118h0.77835z"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m515.794 275.694s-6.4925-10.546-12.0738-16.0311c-4.55554-4.48111-12.9827-9.9933-12.9827-9.9933s8.0309 5.6705 12.362 10.1658c5.2943 5.4933 11.455 15.8586 11.455 15.8586h1.23955z"
        S.path
          ! A.fill "#A48253"
          ! A.d "m512.964 250.457c1.0819 2.70827 2.6327 6.89585 3.66435 10.8059 4.8402 18.336 5.2866 39.5244 3.2144 51.7665-6.3809 37.7061-40.6642 72.7855-68.103 78.263-23.2966 4.6506-37.0666 14.7455-46.8461 25.5348-4.63642 5.1136-8.3386 10.2148-11.204 15.0774-2.84233 4.81949-4.7067 8.9516-7.22955 13.1038-0.0295 0.0147-0.0744 0.0336-0.14114 0.0561-0.17008 0.0608-0.39686 0.11397-0.65788 0.16417-0.55453 0.10394-1.25669 0.18484-1.92283 0.21201-0.67914 0.029-1.2815 0.002-1.64469-0.0874l-0.0868-0.0231c0.35492-0.54981 0.70807-1.08544 1.05472-1.65473 2.40591-3.96555 4.49705-7.8313 7.24785-12.4246 2.74252-4.57618 5.9864-9.4057 10.4008-14.3953 10.1758-11.5028 24.6378-22.6294 49.3536-27.5964 28.7722-5.7827 61.6275-41.4632 68.062-79.4835 2.0947-12.3809 2.04925-33.7606-5.8181-56.926l0.6561-2.39232z"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m511.844 248.246c-2.38585-6.0815-4.06535-9.424-7.5201-14.9676-4.46281-7.1616-13.5278-16.8809-13.5278-16.8809s8.57715 9.75885 12.7967 16.8514c4.464 7.50415 6.50905 12.1216 9.07145 20.4685l-0.82025-5.47145z"
        S.path
          ! A.fill "#A48253"
          ! A.stroke "none"
          ! A.d "m513.234 254.084s-0.36555-0.90945-0.55455-1.50768c-0.39445-1.23957-0.7122-3.26162-0.7122-3.26162s0.5882 1.41615 0.98035 2.34863c0.34425 0.82205 0.89465 2.45197 0.89465 2.45197l-0.60825-0.0313z"
        S.path
          ! A.d "m514.378 317.002c-1.77755-1.47638-6.6508-5.9693-6.6508-8.26595 0-2.73602 2.55475-2.26535 3.1689-2.66575-0.10985-1.10847-3.85805-3.84567-2.35455-6.3124 0.9904-1.62756 3.24335-1.17107 4.0778-1.83484 0.63775-1.74449-1.83725-6.27051 0.14705-8.72481 1.17575-1.45393 2.0852-0.36791 2.6374-0.50019 0.1104-0.76477 0.0874-1.5437 0.1742-2.30906 0.15-1.35354 0.64015-2.69764 2.21395-2.77795 2.20275-0.11457 3.6998 2.71299 4.74865 4.26614 0.23385-0.13464 1.38245-0.29645 1.6252-0.41693 2.71005-1.3252 1.72735 7.0819 1.80415 8.37815 0.6313-0.0213 1.91275-0.37382 2.4732-0.046 2.90255 1.71261-2.86535 10.7179-3.4795 12.8363-0.25575 0.88051 3.04545 0.17244 0.5102 3.37146-1.47815 1.86674-3.36375 3.51909-4.99545 5.25119l-6.1004-0.24922z"
        S.path
          ! A.fill "#658D5C"
          ! A.d "m515.298 323.974c1.10255-2.90493 0.71045-5.7366-1.4805-7.32285-2.34625-1.69902-5.475-5.7325-5.47085-8.0687 0.007-2.76142 2.75075-1.07953 2.87775-2.38524 0.0957-0.97441-3.6065-3.89587-2.28665-6.0425 0.85985-1.39547 3.15005-1.23366 3.72935-1.93346 0.9638-1.16457-1.42615-6.3307 0.46535-8.7366 1.03995-1.32284 1.8461 0.0833 2.5394-0.40512 0.67085-0.4754-0.40515-4.42441 2.14075-4.53898 2.45255-0.10984 4.2561 4.00335 4.6488 3.87638 0.7931-0.25512 1.73565-1.08366 2.62855-0.23622 0.8699 0.82441 0.59825 7.8443 0.59825 7.8443s1.6671-0.16181 2.20095 0.16594c2.21695 1.36418-1.76515 9.3331-2.8866 11.5176-0.9567 1.86437 1.84605 2.09882 0.40925 4.01339-2.36455 3.15414-7.09015 6.939-7.8378 11.5796"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m518.028 321.924s1.7752-11.4201 2.2671-17.446c0.4028-4.94115-0.69565-13.0742-0.69565-13.0742s0.63365 7.82365 0.2309 12.7654c-0.4919 6.02365-3.1376 20.3563-3.1376 20.3563l1.33525-2.60138z"
        S.path
          ! A.d "m492.06 364.365c0.9939-2.55413-1.93347-10.0435 0.27578-11.3551 1.26261-0.75177 2.05985 0.66024 3.28938-0.55039 1.57145-1.55315-0.88701-7.40195 1.98661-9.25216 1.66949-1.07362 2.99175 0.47362 4.59925-0.98444 1.0671-0.97146 1.11435-4.88563 3.82675-5.5642 1.8024-0.45059 2.63035 0.77657 4.2272 0.99685 1.3535 0.18425 5.9486-6.2191 8.8051-4.68898 2.9923 1.60512 0.3431 5.00255-0.25925 7.27794-0.3154 1.18996 2.23225 1.02166 1.9931 3.01418-0.21735 1.82126-2.3002 3.64666-2.302 4.4126 0 0.81437 2.10535 1.36831 2.19035 2.89252 0.16775 2.96279-4.60745 3.37973-6.212 4.64056-0.8415 0.66023 1.0831 2.78858-0.1045 4.74862-1.25845 2.08229-6.61715 0.62067-7.5077 1.06712-0.7246 0.36555-0.017 3.89529-0.9201 5.14666-1.4675 2.03563-8.46496 0.12519-11.0563 0.54862-3.4689 0.5687-4.98543 1.27913-7.16695 3.87047l4.33524-6.22085z"
        S.path
          ! A.fill "#658D5C"
          ! A.d "m487.657 368.456s2.73426-1.41614 3.71929-2.99587c0.9691-1.55965 1.09429-2.11949 1.0565-4.58445-0.0231-1.49705-1.32697-6.64845 0.14114-7.4687 1.2065-0.67264 1.875 0.64606 3.37854-0.77422 1.83307-1.73149-0.85571-7.7238 1.75453-9.34195 1.57382-0.97559 2.99532 0.75 4.81477-0.87815 1.24135-1.11023 1.02935-4.84606 3.47365-5.4579 1.5319-0.38445 2.7508 0.80965 4.2 1.00453 1.77165 0.23859 5.80985-5.6516 8.34035-4.27323 1.10905 0.60473 1.4374 1.45335 1.23365 2.67048-0.2197 1.31161-0.9632 2.47086-1.24725 3.75177-0.36555 1.65059 1.86615 1.50532 1.6648 3.24745-0.189 1.65413-2.1514 3.24094-2.1514 4.31457 0 1.17519 1.7693 1.93878 1.88385 3.38445 0.21555 2.74016-5.51515 2.79449-5.97815 4.29744-0.45885 1.48937 0.6561 2.60611-0.42755 4.36241-1.17105 1.89449-5.20335 0.2185-6.77895 0.86161-1.31515 0.53386-0.5191 3.50493-1.31635 4.69548-2.201 3.28228-12.8504-1.32756-17.2252 4.68602l-0.53622-1.50177z"
        S.path
          ! A.strokeWidth "0.45"
          ! A.d "m487.976 368.836s11.3226-9.63605 17.5347-16.7746c4.78405-5.4933 11.2458-14.9162 11.2458-14.9162s-6.0319 9.5386-10.6252 15.072c-5.6114 6.75885-15.9916 15.8652-15.9916 15.8652l-2.16378 0.75354z"
        S.path
          ! A.fill "#A48253"
          ! A.stroke "none"
          ! A.d "m486.963 369.091l1.85611-0.5374s-0.68091 0.79902-0.95492 1.04645c-0.23269 0.20729-0.84272 0.77776-0.84272 0.77776l-0.0585-1.28681z"
        S.path
          ! A.fill "#D99F31"
          ! A.strokeWidth "1.09"
          ! A.d "m486.87 384.764c-0.91772-0.65846-0.68091-3.67087 0.47716-5.67875 1.05059-1.8189 2.67875-2.70118 3.35375-2.38583 2.4809 1.16457 5.5872 5.0622 4.59625 7.18585-0.98386 2.10768-7.2124 1.74626-8.42714 0.87874z"
        S.path
          ! A.fill "#D99F31"
          ! A.strokeWidth "1.09"
          ! A.d "m486.87 384.764c-0.91772-0.65846-0.68091-3.67087 0.47716-5.67875 1.05059-1.8189 2.67875-2.70118 3.35375-2.38583 2.4809 1.16457 5.5872 5.0622 4.59625 7.18585-0.98386 2.10768-7.2124 1.74626-8.42714 0.87874z"
        S.path
          ! A.fill "#F1BF31"
          ! A.stroke "none"
          ! A.d "m491.359 377.719c-0.27752 0.11743-0.53145 0.27483-0.73437 0.5-1.02107 1.13386-0.54262 3.2262 1.0625 4.67187 0.81629 0.73435 1.76736 1.15884 2.64062 1.25 0.003-0.002 0.0122 0.002 0.0156 0 0.22095-0.15174 0.37483-0.31663 0.45313-0.48437 0.34923-0.74843-0.0269-2.09591-0.9375-3.40625-0.67849-0.9763-1.6093-1.90396-2.5-2.53125z"
        S.path
          ! A.d "m516.644 254.586c-2.35455-0.8126-3.9638-5.16615-2.98405-9.02775 0.97205-3.82323 10.7309-2.26594 9.6803 2.28779-0.8303 3.5941-4.69845 7.42915-6.69625 6.73995z"
        S.path
          ! A.d "m523.074 246.464c-0.34725 2.29252-3.3673 2.54823-4.76515 2.26299-1.487-0.29882-4.29215-1.87854-3.9638-3.77657 0.6957-4.02815 3.94725-7.13385 5.8636-6.8309 2.0953 0.33189 3.42405 4.65295 2.86535 8.3445z"
        S.path
          ! A.fill "#A48253"
          ! A.d "m516.848 253.845c-1.98305-0.30709-3.53385-4.39961-2.58485-8.1325 0.8888-3.50315 9.23325-1.288 8.475 1.99489-0.82795 3.58995-3.95255 6.43639-5.89015 6.13759z"
        S.path
          ! A.fill "#D99F31"
          ! A.strokeWidth "1.09"
          ! A.d "m520.134 238.734c1.62815 0.25689 3.3555 3.92598 2.7886 7.65945-0.27165 1.80355-3.08505 1.70433-4.52245 1.41378-1.54845-0.31418-4.15455-1.35-3.9071-2.77796 0.6874-3.98267 4.14215-6.53444 5.64095-6.29529z"
        S.path
          ! A.fill "#F1BF31"
          ! A.stroke "none"
          ! A.d "m519.859 239.266c-0.0739 0.006-0.1556 0.0246-0.25 0.0468 0.10145 0.65378 0.5141 1.61433 0.7031 2.71875 0.251 1.46339 0.21925 3.85023 1.2344 3.67188 0.62925-0.11081 0.8995-0.61025 0.9062-1.57813-0.0004-0.005 0-0.0104 0-0.0156-0.0844-0.96678-0.30585-1.87923-0.60935-2.64062-0.5278-1.32405-1.34795-2.13229-1.79685-2.20313-0.0485-0.008-0.11365-0.006-0.1875 0z"
        S.path
          ! A.fill "none"
          ! A.d "m382.268 446.704c-0.77008-1.13445 0.99212-4.61634 4.68189-4.19646 1.61752 0.18484 0.83504 2.52638-1.17284 3.92835-1.40787 0.98032-2.73838 1.40315-3.50905 0.26811z"
        S.path
          ! A.fill "#A48253"
          ! A.d "m382.268 446.704c-0.77008-1.13445 0.35079-3.57166 4.06358-3.72934 1.33288-0.0585 1.45335 2.05926-0.55453 3.46123-1.40787 0.98031-2.73838 1.40314-3.50905 0.2681z"
        S.path
          ! A.fill "none"
          ! A.d "m394.916 431s-0.0998-1.37894-1.69016-1.93052c-1.37067-0.47834-2.23819 0.61418-2.23819 0.61418m2.37756 3.17716s-0.0502-1.39134-1.68838-1.77756c-1.49469-0.35079-2.08465 0.92599-2.08465 0.92599"
    S.g
      ! A.fill "#000000"
      $ do
        S.path
          ! A.fill "#FFFFFF"
          ! A.d "m401.704 427.164c7.68955-0.0904 13.4716-0.82146 20.0468-2.11949-1.55138 5.27305-4.65296 15.3042 7.7445 15.3042 9.02125 0 18.5976-5.4254 27.897-0.65374 20.3108 10.4168 35.6463 2.97756 48.0443-10.9695 0 0-9.16657 1.95768-18.5977 1.54901 0 0 7.06535-6.02125 7.74865-13.9488-6.1996 4.64882-12.3998 5.32795-18.6012 5.32795-6.19605 0-10.1598-3.74409-18.2764-5.0244 0.45708-2.80512 0.94724-5.6622 1.67834-9.6012 0.79666-4.30039-0.38858-7.79055-6.6443-8.5258-13.614-1.59803-26.8004 6.2551-50.892 6.63305-24.2563-0.37795-40.8821-8.2311-54.4985-6.63305-6.2557 0.73524-7.44095 4.2254-6.6437 8.5258 0.73051 3.93898 1.22067 6.79605 1.67481 9.6012-8.1136 1.28032-12.078 5.0244-18.2734 5.0244-6.20435 0-12.4016-0.67913-18.6018-5.32795 0.68327 7.92755 7.7492 13.9488 7.7492 13.9488-9.4305 0.40866-18.5982-1.54901-18.5982-1.54901 12.3998 13.947 27.734 21.3862 48.0449 10.9695 9.2994-4.77166 18.8758 0.65374 27.897 0.65374 12.3974 0 9.29585-10.0311 7.7451-15.3042 7.03585 1.38898 14.824 2.15374 23.3534 2.15374l0.003-0.0342z"
        S.path
          ! A.d "m337.705 427.301c-0.90118 0.41693-1.36417-0.1624-0.34843-0.6815 0.72048-0.36968 3.83032-1.72381 6.07916-2.16555 0.0874-0.0165 0.17008 0.0437 0.18248 0.13288l0.0815 0.6c0.0124 0.0768-0.0502 0.16004-0.12637 0.17244-2.11595 0.37618-5.1124 1.59036-5.8683 1.94174zm0.519 2.946c-0.90118 0.41693-1.36594-0.16181-0.34843-0.6809 0.71812-0.36792 3.98622-1.97481 6.23681-2.41713 0.0626-0.0124 0.15235 0.0372 0.1748 0.0974l0.22618 0.59823c0.0354 0.0974-0.0165 0.18838-0.11811 0.20729-2.11772 0.37382-5.41715 1.84606-6.17125 2.19508zm32.3145 5.392c-3.86398-0.4004-8.42715-1.57146-13.272-2.24646-6.13345-0.85512-11.4668-0.5374-17.8518 2.3563-0.35138 0.16004-0.53799 0.17657-0.675 0.18071-0.11811 0.004-0.29882-0.0272-0.33602-0.20552-0.0295-0.137 0.0644-0.26515 0.1494-0.34901 0.0974-0.0969 0.24272-0.18603 0.41929-0.27756 5.9427-3.0378 12.1606-3.58347 18.4004-2.73426 4.83603 0.65788 9.4435 1.67067 13.2992 2.06989 2.1691 0.22441 4.64646-0.14114 5.462-1.44744 0.21437-0.34075 0.82914 0.39685 0.62776 0.71634-1.23366 1.97657-4.11792 2.15551-6.22325 1.93701zm-33.6075-11.0435c-0.16181 0.0626-0.31772 0.10217-0.43405 0.10393-0.0974 0-0.25276-0.0248-0.30296-0.17066-0.0461-0.13465 0.0419-0.25276 0.10748-0.32186 0.0797-0.0803 0.20197-0.16003 0.34902-0.22795 2.33799-1.07539 2.94449-1.26437 6.3685-2.17618 0.28818-0.0768 0.50256 0.0939 0.55217 0.31358 0.0473 0.21615-0.0667 0.46536-0.35493 0.53327-2.67224 0.63603-3.97441 1.05059-6.28525 1.94587zm-0.527-2.999c-0.15236 0.0602-0.29527 0.0957-0.40925 0.0915-0.10748-0.004-0.23917-0.0455-0.28819-0.17422-0.0484-0.12283 0.01-0.24331 0.0762-0.32184 0.0732-0.0856 0.17894-0.16596 0.31949-0.22855 2.35926-1.03996 3.30178-1.37657 6.5888-1.9996 0.27579-0.0537 0.5002 0.098 0.57697 0.29527 0.085 0.21733-0.0231 0.46654-0.32185 0.52323-3.20964 0.60768-4.34587 0.94193-6.54215 1.81418zm34.1425 9.0065c-2.6374-0.27225-5.6392-0.86161-8.8199-1.38071-0.33012-0.0543-0.45709-0.34075-0.41752-0.57933 0.0396-0.23918 0.24921-0.46949 0.57933-0.41575 3.16004 0.51496 6.1441 1.10256 8.762 1.37421 1.07716 0.11044 2.06811-0.0408 2.92973-0.37736 0.31122-0.12283 0.56456 0.0579 0.65197 0.28465 0.0892 0.22618 0.0265 0.52913-0.28465 0.65138-1.01279 0.39921-2.16555 0.57106-3.40098 0.44291zm-13.876 5.25c-5.2636-0.82027-11.7544 0.0685-16.7811 2.57244-0.22027 0.10984-0.41929 0.14764-0.5687 0.1624-0.12224 0.01-0.30531 0.006-0.38445-0.13524-0.0437-0.0791-0.0331-0.16181-0.008-0.22205 0.0248-0.0608 0.0667-0.11811 0.11811-0.1683 0.0998-0.10335 0.26221-0.21614 0.47599-0.32776 7.4079-3.59055 13.0642-3.35138 17.4703-2.85118 4.72323 0.53386 8.8677 1.55905 13.3878 1.8998 0.39271 0.0289 0.50019 0.38209 0.60236 0.6874 0.0933 0.28229 0.26516 0.79961-1.14862 0.64784-4.47402-0.47363-8.5689-1.54843-13.1634-2.26536zm13.833-2.9805c-5.00195-0.5191-11.6398-2.22579-18.0042-2.50807-0.32775-0.0148-0.53504-0.23504-0.53681-0.48602-0.002-0.26162 0.21083-0.47126 0.54508-0.4565 6.3874 0.28406 13.102 1.80591 18.1228 2.325 1.85374 0.19311 3.88052-0.17422 4.85434-1.04645 0.29232-0.26339 1.04645 0.7246 0.76653 0.9744-1.29212 1.15808-3.74173 1.40552-5.74785 1.19764zm-31.7325 0.1075c-0.90118 0.41752-1.36417-0.16181-0.34901-0.6809 0.82205-0.42166 5.34215-2.55768 7.75335-2.71772 0.33189-0.0231 0.5746 0.18071 0.64547 0.41516 0.0774 0.25984-0.0685 0.53149-0.42579 0.5563-2.16732 0.1435-6.75825 2.02618-7.624 2.42716z"
        S.path
          ! A.d "m462.392 427.301c0.90118 0.41693 1.36594-0.1624 0.34901-0.6815-0.72106-0.36968-3.82913-1.72381-6.07795-2.16555-0.0892-0.0165-0.17243 0.0437-0.18425 0.13288l-0.0815 0.6c-0.01 0.0768 0.0502 0.16004 0.12637 0.17244 2.11595 0.37618 5.1124 1.59036 5.8683 1.94174zm-0.5185 2.946c0.90118 0.41693 1.36417-0.16181 0.34901-0.6809-0.7187-0.36792-3.98917-1.97481-6.2374-2.41713-0.062-0.0124-0.15177 0.0372-0.1748 0.0974l-0.22559 0.59823c-0.0378 0.0974 0.0142 0.18838 0.11811 0.20729 2.11595 0.37382 5.41715 1.84606 6.17065 2.19508zm-32.3145 5.392c3.86339-0.4004 8.42715-1.57146 13.272-2.24646 6.1311-0.85512 11.4674-0.5374 17.8518 2.3563 0.35079 0.16004 0.5374 0.17657 0.675 0.18071 0.11811 0.004 0.29882-0.0272 0.33661-0.20552 0.029-0.137-0.065-0.26515-0.14941-0.34901-0.098-0.0969-0.2433-0.18603-0.42224-0.27756-5.94035-3.0378-12.1606-3.58347-18.398-2.73426-4.8378 0.65788-9.4435 1.67067-13.2992 2.06989-2.1691 0.22441-4.64646-0.14114-5.462-1.44744-0.21437-0.34075-0.82913 0.39685-0.62775 0.71634 1.23366 1.97657 4.11791 2.15551 6.22325 1.93701zm33.608-11.0435c0.16181 0.0626 0.31771 0.10217 0.43405 0.10393 0.0974 0 0.25276-0.0248 0.30296-0.17066 0.046-0.13465-0.0414-0.25276-0.10748-0.32186-0.0791-0.0803-0.20138-0.16003-0.34902-0.22795-2.338-1.07539-2.9439-1.26437-6.3685-2.17618-0.29055-0.0768-0.50433 0.0939-0.55217 0.31358-0.0472 0.21615 0.0667 0.46536 0.35493 0.53327 2.67224 0.63603 3.97382 1.05059 6.28525 1.94587zm0.5265-2.999c0.15177 0.0602 0.29527 0.0957 0.40925 0.0915 0.10807-0.004 0.23917-0.0455 0.28819-0.17422 0.0484-0.12283-0.01-0.24331-0.0762-0.32184-0.0709-0.0856-0.18071-0.16596-0.31949-0.22855-2.35926-1.03996-3.30178-1.37657-6.5888-1.9996-0.27579-0.0537-0.5002 0.098-0.57697 0.29527-0.085 0.21733 0.0224 0.46654 0.32008 0.52323 3.21378 0.60768 4.34941 0.94193 6.5439 1.81418zm-34.1425 9.0065c2.6374-0.27225 5.6392-0.86161 8.8199-1.38071 0.33248-0.0543 0.45531-0.34075 0.41752-0.57933-0.0396-0.23918-0.24921-0.46949-0.57933-0.41575-3.16004 0.51496-6.1435 1.10256-8.762 1.37421-1.07776 0.11044-2.06811-0.0408-2.92973-0.37736-0.31122-0.12283-0.56456 0.0579-0.65138 0.28465-0.0898 0.22618-0.0271 0.52913 0.28406 0.65138 1.01279 0.39921 2.16555 0.57106 3.40098 0.44291zm13.876 5.25c5.2636-0.82027 11.7561 0.0685 16.7811 2.57244 0.22027 0.10984 0.41929 0.14764 0.5687 0.1624 0.12224 0.01 0.30531 0.006 0.38445-0.13524 0.0431-0.0791 0.0331-0.16181 0.008-0.22205-0.0248-0.0608-0.0667-0.11811-0.11634-0.1683-0.10157-0.10335-0.26398-0.21614-0.47776-0.32776-7.40845-3.59055-13.0642-3.35138-17.4703-2.85118-4.72323 0.53386-8.8677 1.55905-13.3854 1.8998-0.39448 0.0289-0.50256 0.38209-0.60472 0.6874-0.0933 0.28229-0.26516 0.79961 1.14862 0.64784 4.47402-0.47363 8.5689-1.54843 13.1634-2.26536zm-13.8335-2.9805c5.00255-0.5191 11.6404-2.22579 18.0042-2.50807 0.32775-0.0148 0.53563-0.23504 0.5374-0.48602 0.003-0.26162-0.21319-0.47126-0.54567-0.4565-6.38445 0.28406-13.102 1.80591-18.1222 2.325-1.85374 0.19311-3.88052-0.17422-4.85434-1.04645-0.29232-0.26339-1.04409 0.7246-0.76594 0.9744 1.29153 1.15808 3.74173 1.40552 5.74665 1.19764zm31.733 0.1075c0.90118 0.41752 1.36594-0.16181 0.34901-0.6809-0.82441-0.42166-5.3427-2.55768-7.7551-2.71772-0.32834-0.0231-0.57342 0.18071-0.6437 0.41516-0.0774 0.25984 0.0679 0.53149 0.4252 0.5563 2.16792 0.1435 6.75885 2.02618 7.6246 2.42716z"
        S.g
          ! A.stroke "#000000"
          ! A.strokeLinecap "round"
          ! A.strokeLinejoin "round"
          $ do
            S.path
              ! A.strokeWidth "0.933"
              ! A.d "m400.04 427.329c-10.3441 0-17.1048-1.5815-26.3462-3.25335-21.515-3.89292-26.1928-0.93425-26.1928 2.78858 0 1.19351 1.10492 1.54666 1.90157 1.1876 0.40749-0.18484 0.74351-0.86988 0.74351-0.86988-0.75768-0.008-1.25433-0.30945-1.09429-1.24783 0.45945-2.71772 6.04665-3.95552 24.642-0.92776 9.2705 1.50709 16.0104 2.788 26.3546 2.788l-0.008-0.46536zm0.0165 0c10.3447 0 17.1053-1.5815 26.3468-3.25335 21.515-3.89292 26.1928-0.93425 26.1928 2.78858 0 1.19351-1.10492 1.54666-1.90157 1.1876-0.40749-0.18484-0.74351-0.86988-0.74351-0.86988 0.75768-0.008 1.25433-0.30945 1.09429-1.24783-0.45945-2.71772-6.04665-3.95552-24.642-0.92776-9.2705 1.50709-16.0104 2.788-26.3552 2.788l0.008-0.46536z"
            S.path
              ! A.d "m342.374 416.79c-3.40866 0.54626-6.53565 1.71083-9.7311 2.96516-8.70825 3.4193-18.6992 2.89607-26.4378-2.60787 0.53976 3.91122 2.25472 7.31695 4.7628 10.3046 0.61299 0.72697 2.49212 2.5872 2.49212 2.5872 0.313 0.3254 0.25689 0.53327-0.1872 0.54567-5.92795 0.25335-11.3114 0.17658-17.1402-0.91122 13.7616 15.134 27.5858 18.9006 46.4304 9.7441 9.90235-4.80886 18.15 0.62067 28.0394 0.62067 10.4894 0 9.5014-6.86635 7.19235-14.6238l1.25846 0.13583c1.6878 4.76634 4.33937 16.523-8.4508 15.5722-9.85865-0.73111-17.7508-5.75435-27.6838-1.01575-15.2941 7.29624-26.3462 7.19234-39.6538-2.68229-2.71358-2.0126-7.08605-5.6309-8.951-8.39055-0.45236-0.67027 0.004-1.07126 0.68386-0.86161 5.0516 1.56791 12.7004 1.57205 16.5939 1.46988-3.15236-3.17067-6.69865-9.05495-6.5451-13.2762 0.0206-0.54626 0.27992-0.64961 0.74351-0.4128 7.20885 3.73524 9.9142 5.2364 18.3212 5.2364 4.95 0 15.0638-5.59134 18.0744-5.0126l0.18838 0.61299z"
            S.path
              ! A.strokeWidth "0.933"
              ! A.d "m457.723 416.79c3.40748 0.54626 6.53445 1.71083 9.7317 2.96516 8.70825 3.4193 18.6998 2.89607 26.4378-2.60787-0.53977 3.91122-2.25709 7.31695-4.76516 10.3046-0.61063 0.72697-2.48918 2.5872-2.48918 2.5872-0.31358 0.3254-0.25806 0.53327 0.18662 0.54567 5.9256 0.25335 11.3114 0.17658 17.1402-0.91122-13.764 15.134-27.5859 18.9006-46.4327 9.7441-9.9-4.80886-18.1476 0.62067-28.0364 0.62067-10.49 0-9.50195-6.86635-7.1929-14.6238l-1.25611 0.13583c-1.69015 4.76634-4.34173 16.523 8.44901 15.5722 9.85809-0.73111 17.7502-5.75435 27.6833-1.01575 15.2941 7.29624 26.3462 7.19234 39.6538-2.68229 2.71359-2.0126 7.08605-5.6309 8.9504-8.39055 0.45535-0.67027-0.006-1.07126-0.68265-0.86161-5.05215 1.56791-12.701 1.57205-16.5939 1.46988 3.14941-3.17067 6.69805-9.05495 6.5445-13.2762-0.0206-0.54626-0.28051-0.64961-0.7435-0.4128-7.20885 3.73524-9.9142 5.2364-18.3212 5.2364-4.95237 0-15.0638-5.59134-18.0744-5.0126l-0.18898 0.61299z"
            S.path
              ! A.d "m399.473 405.15c-11.8264 0.0856-21.8008-2.06752-30.1246-3.94489-6.9-1.55669-14.935-3.33661-22.0092-2.39586-5.15315 0.68976-7.2567 2.96516-6.3762 8.16025 1.09607 6.4571 2.05926 12.9685 3.23268 19.405 0.67677 3.71457 2.65571 4.21299 6.14645 3.59587 5.0262-0.88878 21.147-4.49292 24.7683 0.0856 3.4754 4.39134 0.0886 7.5579-4.74921 7.6388-0.67677 0.01-0.45827-0.46122-0.23032-0.46122 4.62815 0 7.88565-2.67815 4.89567-6.78485-3.14941-4.32756-18.2315-1.15512-24.3732 0.27992-3.9059 0.91181-6.50315 0.40925-7.22185-4.38544-0.99035-6.60885-1.59862-11.1496-3.6939-19.6955-3.54213-14.4455 22.2378-7.75335 29.6646-6.02775 10.1244 2.3504 18.577 3.86162 30.584 4.22126 12.0307-0.35964 20.4827-1.87086 30.6071-4.22126 7.425-1.72559 33.2067-8.4177 29.667 6.02775-2.09705 8.54585-2.7059 13.0866-3.69626 19.6955-0.71811 4.79469-3.31594 5.29725-7.22125 4.38544-6.14235-1.43504-21.2238-4.60749-24.3738-0.27992-2.98996 4.10669 0.26752 6.78485 4.89626 6.78485 0.22796 0 0.44587 0.47126-0.2309 0.46122-4.83544-0.0809-8.22461-3.24745-4.74863-7.6388 3.62067-4.57855 19.7416-0.97441 24.7683-0.0856 3.49016 0.61712 5.4691 0.1187 6.14585-3.59587 1.17107-6.4364 2.13662-12.9478 3.23327-19.405 0.88051-5.1951-1.22303-7.4705-6.37915-8.16025-7.07365-0.94075-15.1069 0.83917-22.0063 2.39586-8.3238 1.87737-18.2988 4.03052-30.1258 3.94489h-1.04882z"
        S.g
          $ do
            S.path ! A.d "m361.531 417.226c-1.61929-0.13878-4.2254-0.28406-4.2254-0.28406l-0.94488-12.8817 3.13111 0.37323 0.65019 10.0518c0.31772 0.0189 1.72323 0.11221 2.65985 0.21437 1.06477 0.11575 2.78445 0.38622 2.78445 0.38622l0.19666 2.58721s-2.62559-0.30827-4.25198-0.44705z"
            S.path ! A.d "m368.29 417.947l-0.7055-12.4225 3.154 0.484 0.7055 12.422z"
            S.path ! A.d "m377.81 412.179l1.07126 0.18307c1.59626 0.27224 1.71909-0.27815 1.70846-0.94902-0.0165-0.81023-0.39271-1.30807-2.0061-1.58386l-0.81969-0.13996 0.046 2.48977zm0.11397 4.9376l1.49233 0.25512c1.73858 0.29527 2.16142-0.0265 2.14488-0.89823-0.0189-0.99922-0.62067-1.59922-2.49744-1.9187l-1.19232-0.20375 0.0526 2.76556zm1.83366 2.76555l-4.99843-0.85334-0.22618-12.271 4.49528 0.76653c3.08563 0.525 4.75099 1.87855 4.7941 4.20886 0.0165 0.97559-0.53386 1.62284-1.13563 1.97185 0.86811 0.48425 2.10118 1.59272 2.13248 3.21851 0.0414 2.28012-1.34351 3.59173-5.0616 2.95866z"
            S.path ! A.d "m391.53 421.566c-1.67126-0.15767-4.33937-0.52972-4.33937-0.52972l-0.12224-6.1825-0.12106-6.2067 7.12265 0.73937 0.0224 1.22066 0.0248 1.23958-3.98268-0.41339 0.0502 2.54823 4.18583 0.43347 0.046 2.30491-4.18583-0.43346 0.049 2.62027c0.3183 0.049 1.75039 0.26929 2.7124 0.35492 1.08189 0.0974 2.8565 0.13465 2.8565 0.13465l0.0478 2.4626s-2.69882-0.13465-4.36654-0.29292z"
            S.path ! A.d "m401.918 415.228c1.663-0.029 2.39173-0.73701 2.37106-1.8691-0.0213-1.18937-0.53622-1.68779-2.04331-1.66063l-1.39488 0.023 0.0614 3.52323 1.00571-0.0165zm6.962 6.4175c-2.4567-0.0809-3.77894-1.31221-5.0746-2.76556l-1.37067-1.53602c-0.19488 0.0165-0.40512 0.0201-0.61654 0.0242l-0.81201 0.0147 0.0732 4.32934-3.07973 0.0514-0.21378-12.3868 4.7817-0.0827c2.74488-0.0485 4.76929 1.18287 4.8189 3.93839 0.0231 1.34291-0.59351 2.53523-1.84961 3.30945l1.18937 1.2437c0.66851 0.6933 1.41614 1.15453 2.72658 1.47047l-0.57284 2.38937z"
            S.path ! A.d "m408.991 411.684l-0.015-2.45 10.9515-1.5115 0.0145 2.452-3.904 0.538 0.0585 9.887-3.1435 0.4325-0.0585-9.886z"
            S.path ! A.d "m426.623 409.195c-0.37559 1.34586-0.77422 2.68464-1.17933 4.02342 0.85925-0.0868 1.76043-0.24035 2.58661-0.48779-0.37145-1.19587-0.73642-2.38937-1.07775-3.59764l-0.32953 0.062zm3.35079 8.99645l-1.21654-3.32422c-0.64547 0.23681-1.34114 0.37618-2.04094 0.4819-0.70571 0.1057-1.41614 0.17834-2.09055 0.28228l-1.32933 3.81437-3.18485 0.59587 3.84981-10.6246-1.34823 0.25334-0.0248-2.44783c2.84705-0.46536 5.60845-0.98445 8.364-1.57028l0.11161 2.43189-1.35945 0.25512 3.54804 9.2374-3.27874 0.61477z"
            S.path ! A.d "m438.3 417.4c-2.02264 0.0355-3.09213-0.31359-4.01339-0.80551l0.86161-2.29607c1.14744 0.38386 1.81595 0.5439 3.15768 0.52087 1.47638-0.0272 2.19863-0.49016 2.20926-1.16044 0.008-0.44882-0.33425-0.7624-0.91772-1.04645-0.58405-0.28465-1.3624-0.5191-2.14134-0.82264-1.56083-0.60827-3.16594-1.50295-3.12874-3.63957 0.0437-2.42539 2.75138-3.6626 4.9252-3.7004 1.95414-0.0349 3.0502 0.36555 4.00099 0.76654l-0.79075 2.22579c-0.96142-0.26162-1.92697-0.48603-3.1624-0.463-1.22067 0.0206-1.93288 0.65375-1.94115 1.1067-0.007 0.35138 0.33603 0.6313 0.93838 0.91535 0.59174 0.27875 1.38485 0.53799 2.17559 0.86988 1.58681 0.66319 3.21674 1.62816 3.18131 3.63426-0.0502 2.75905-2.81989 3.85158-5.35456 3.89468z"



{- |
Flag of the Holy See coat of arms.
Drawn for a @viewbox 0 0 2500 2500@
-}
vaCoA :: Svg
vaCoA =
  S.g
    ! A.fill "none"
    ! A.stroke "#000000"
    ! A.strokeWidth "3.205"
    ! A.strokeLinejoin "round"
    ! A.strokeLinecap  "round"
    $ do
      S.g
        ! A.fill "#FFE000"
        ! A.id_ "HaskellSvgIcons-vaCoA-tiara"
        $ do
          S.g
            ! A.id_ "HaskellSvgIcons-vaCoA-tiaraBand"
            $ do
              S.path
                ! A.fill "#FFFFFF" 
                ! A.d "m1781.07 990.292l16.1062 3.84122 25.6631 4.16908 11.7604 1.2926 -2.0767 49.9158s -2.8084 33.1782 -7.6882 48.9616c -3.6176 11.701 -15.781 33.1806 -15.781 33.1806l -7.6882 11.7346 -45.3199 -39.2502s7.7255 -10.947 10.5207 -16.995c3.5074 -7.5891 7.6882 -23.8739 7.6882 -23.8739l4.451 -25.897 2.4279 -32.776zm -56.9911 151.477l41.2735 36.0131s -8.3454 7.4281 -13.3532 9.7114c -9.8241 4.4794 -20.7674 7.5168 -31.5621 7.2836 -7.7283 -0.167 -15.3195 -2.9727 -22.3505 -6.1856 -15.7215 -7.1841 -33.0314 -14.7311 -43.1678 -28.7322 -3.5868 -4.9543 -5.0026 -11.5703 -4.8894 -17.6856 0.1281 -6.9328 6.2807 -19.8312 6.2807 -19.8312s2.3909 8.636 5.1333 12.0223c4.513 5.5725 11.1176 9.3021 17.5966 12.3749 4.8475 2.2989 10.1441 4.0219 15.4999 4.336 6.9511 0.4078 14.1627 -0.6737 20.6367 -3.2371 3.3392 -1.3222 8.9021 -6.0696 8.9021 -6.0696z"
              S.path
                ! A.fill "#FFFFFF"
                ! A.d "m1658.65 877.67s3.2943 6.60021 4.297 10.1276c1.7151 6.03329 2.9083 12.326 2.8613 18.5981 -0.047 6.28734 -1.4684 12.5389 -3.1474 18.5982 -2.5161 9.0802 -6.3199 17.7833 -10.3005 26.3235 -2.5243 5.41581 -6.054 10.3236 -8.5837 15.7369 -4.0792 8.72864 -6.9937 17.956 -10.5867 26.8957 -2.9986 7.46093 -6.8645 14.6102 -9.156 22.3178 -3.0437 10.2378 -4.5617 20.8914 -6.0086 31.4738 -1.2447 9.103 -2.2289 18.2805 -2.289 27.468 -0.071 10.8993 0.257 21.9099 2.289 32.6182 2.0132 10.6096 4.9766 21.2042 9.7283 30.9015 3.8299 7.8163 8.9314 15.1035 14.8784 21.4595 4.9155 5.2533 10.7063 9.7565 16.8814 13.4478 5.6111 3.3542 11.951 5.3107 18.0259 7.7254 8.392 3.3358 25.4328 9.3354 25.4328 9.3354s -23.527 -11.5926 -31.7275 -21.3526c -6.7839 -8.0741 -10.5208 -18.6192 -12.8756 -28.8986 -2.7273 -11.9056 -2.3831 -24.473 -1.1445 -36.6239 1.3326 -13.0719 5.1794 -25.8174 9.156 -38.3408 4.1968 -13.2172 10.0958 -25.835 15.4508 -38.6268 3.8591 -9.2188 8.276 -18.2009 12.0172 -27.4681 4.4171 -10.9412 8.7643 -21.9345 12.3034 -33.1905 2.1584 -6.86471 4.8495 -13.7214 5.4303 -20.894 0.6311 -7.79253 -0.3834 -15.7424 -2.1702 -23.3535 -2.5031 -10.6626 -5.5983 -21.6488 -11.8358 -30.6517 -3.7541 -5.41848 -8.8987 -10.1529 -14.7694 -13.1509 -5.7326 -2.92745 -12.5435 -5.40098 -18.8584 -4.1538 -2.1092 0.41656 -5.2985 3.6779 -5.2985 3.6779z"
              S.path
                ! A.fill "#FFFFFF"
                ! A.d "m1711.59 945.594s4.4543 -17.9908 5.2084 -27.1872c0.6452 -7.8667 0.2242 -15.8223 -0.6069 -23.6716 -0.9248 -8.73396 -1.4686 -17.7937 -4.8557 -25.897 -3.5136 -8.40592 -9.0243 -16.1296 -15.5787 -22.4577 -6.46 -6.23687 -14.2939 -11.3052 -22.6599 -14.5671 -8.8012 -3.43152 -18.4915 -4.27873 -27.9203 -4.8557 -8.0878 -0.49492 -16.2402 0.19161 -24.2785 1.21393 -4.6447 0.59072 -9.3229 1.33124 -13.7578 2.8325 -4.1142 1.39268 -11.7346 5.66498 -11.7346 5.66498l29.9434 48.9616s9.3726 -5.51792 14.5671 -6.8789c5.494 -1.43944 11.3253 -1.54575 16.995 -1.21393 5.757 0.33691 11.7257 0.89368 16.9949 3.23714 6.7067 2.98278 12.4901 7.98381 17.5468 13.3041 6.1021 6.41995 11.5485 13.7867 14.9589 21.9611 3.1668 7.59027 3.5823 16.072 4.7213 24.2172 0.2473 1.76811 0.4565 5.33646 0.4565 5.33646z"
              S.path ! A.d "m1717.05 906.676s -5.3336 -16.5594 -10.3697 -23.474c -5.8495 -8.03107 -13.3653 -15.3911 -22.2554 -19.8275 -9.4283 -4.70495 -30.9939 -6.21691 -30.9939 -6.21691l11.4135 21.1281 -19.9659 -0.48705 -10.4269 -17.4343 -19.2319 8.7057 -9.5679 -15.6448 20.4311 -9.47347 -9.4144 -15.1852 20.4231 -1.9427 8.8924 14.7s15.8737 0.0481 23.5878 1.66764c5.2383 1.09979 10.3852 2.90955 15.1204 5.40504 4.5315 2.38821 8.6981 5.52167 12.4464 9.01294 4.5081 4.199 8.7319 8.8641 11.8742 14.1632 3.0537 5.14968 6.5418 16.7274 6.5418 16.7274z"
              S.path ! A.d "m1581.65 845.092l31.8993 46.5923m -17.9701 -54.7363l -15.0315 8.78851 -14.3063 10.8728 30.9015 47.2106 13.734 -10.5866 14.1198 -8.18363z"
              S.path ! A.d "m1653.79 1035.87l17.8828 -36.9101 19.1392 7.6135 7.7552 -19.059 -19.026 -8.86935 9.8713 -21.3164 -14.0201 -6.29475 -10.5867 20.4578 -19.1933 -8.02412 -8.4281 19.9631 18.6084 7.80376 -17.1675 36.6241z"
              S.path ! A.d "m1796.92 1024.83l18.2088 -0.4047v21.0414l17.5333 0.8317 -2.9826 21.3575 -16.3572 -1.0293s -2.6981 12.5748 -5.1215 18.4951c -2.5132 6.1396 -9.6623 17.3995 -9.6623 17.3995l -19.4228 -4.8557s7.0265 -11.0483 9.7114 -16.995c2.4047 -5.3259 5.665 -16.5903 5.665 -16.5903l -19.9387 -2.5165 3.4705 -20.1921 18.0868 1.2625z"
          S.use
            ! A.xlinkHref "#HaskellSvgIcons-vaCoA-tiaraBand"
            ! A.transform (S.matrix (-1) 0 0 1 3717.75 0)
          S.path
            ! A.fill "#FFFFFF"
            ! A.d "m1756.660034,735.60199l-27.420044,29.445984l16.880005,50.930054l9.670044,35.794983l-27.72998,25.825989l50.72998,70.487488l161.23999,-15.495483l51.809937,-55.520996l-19.77002,-17.833984l-0.439941,-43.257996l16.880005,-50.930054l-25.410034,-25.723999l-22.939941,-61.257996s-4.800049,-17.080994 -8.869995,-24.893005c-2.430054,-4.670959 -5.830078,-8.790955 -9.160034,-12.875977c-3.97998,-4.893982 -8,-9.869995 -12.869995,-13.877014c-4.420044,-3.630981 -9.540039,-6.346008 -14.589966,-9.013c-5.440063,-2.865967 -10.900024,-5.955994 -16.850098,-7.471985c-6.139893,-1.562988 -18.939941,-1.541016 -18.939941,-1.541016s-12.790039,-0.026001 -18.949951,1.541016c-5.950073,1.515015 -11.410034,4.606018 -16.840088,7.471985c-5.059937,2.666992 -10.179932,5.382019 -14.589966,9.013c-4.880005,4.007019 -8.900024,8.983032 -12.880005,13.877014c-3.319946,4.085022 -6.719971,8.205017 -9.150024,12.875977c-4.069946,7.812012 -8.869995,24.893005 -8.869995,24.893005l-20.939941,57.536011z"
          S.ellipse
            ! A.rx "97.59"
            ! A.ry "29"
            ! A.cx "1859"
            ! A.cy "972"
            ! A.fill "#FF0000"
            ! A.stroke "#000000"
            ! A.strokeWidth "4"
          S.path ! A.d "m1963.27 933.128s -3.1773 -2.84544 -4.9603 -3.99962c -3.7472 -2.4257 -7.7685 -4.47267 -11.9369 -6.06964 -5.6064 -2.14787 -11.5532 -3.28842 -17.3997 -4.65339 -6.6974 -1.56366 -13.4146 -3.13944 -20.2321 -4.04642 -7.9733 -1.06074 -16.0331 -1.53775 -24.0762 -1.61857 -8.6068 -0.0865 -25.7932 1.21392 -25.7932 1.21392s -17.1689 -1.30099 -25.7932 -1.21392c -8.0431 0.0812 -16.1029 0.55783 -24.0762 1.61857 -6.8175 0.90698 -13.5347 2.48276 -20.2321 4.04642 -5.8465 1.36497 -11.7933 2.50552 -17.3997 4.65339 -4.1684 1.59697 -8.1897 3.64394 -11.9369 6.06964 -1.783 1.15418 -4.9603 3.99962 -4.9603 3.99962m218.711 -42.6925s -5.1828 -5.26865 -8.6021 -5.91895c -2.2098 -0.42027 -4.7416 0.21473 -6.5754 1.51741 -2.372 1.68499 -3.9554 4.56016 -4.6534 7.38473 -0.6248 2.52827 -0.3529 5.36837 0.6069 7.78937 0.8132 2.05124 2.0996 4.33782 4.1476 5.15919 4.8004 1.92528 15.3837 -2.02435 15.3837 -2.02435zm5.1557 -3.59224c5.8013 0.17064 7.9138 3.10789 9.4541 6.47428m -243.23 -2.882l -0.3074 13.9074s10.5833 3.94958 15.3837 2.02435c2.048 -0.82135 3.3344 -3.10795 4.1476 -5.15919 0.9598 -2.421 1.2317 -5.2611 0.6069 -7.78937 -0.698 -2.82457 -2.2814 -5.69974 -4.6534 -7.38473 -1.8338 -1.30268 -4.3681 -1.95069 -6.5754 -1.51741 -3.4449 0.67621 -8.602 5.91895 -8.602 5.91895zm -5.1558 -3.59224c -5.8013 0.17064 -7.9138 3.10789 -9.4541 6.47428m198.167 1.34599l -8.4468 -0.94606m -130.044 0.94606l8.4468 -0.94606m75.9916 0.81471c -2.8651 -0.42255 -7.6006 -4.2094 -7.6006 -4.2094m -22.7856 4.2094c2.8651 -0.42255 7.6006 -4.2094 7.6006 -4.2094m140.936 -19.3466s -4.2156 3.34715 -7.2851 3.85745l -1.211 0.6445s -1.9472 5.72805 -3.6621 8.17385c -1.7189 2.45145 -6.4648 6.25 -6.4648 6.25s -4.787 -4.14415 -7.7442 -4.9512c -1.9395 -0.52925 -4.1634 -0.54345 -6.0253 0.21485 -1.9759 0.8047 -3.5479 2.53495 -4.7364 4.30665 -1.4037 2.09245 -2.7058 4.58275 -2.5879 7.0996 0.1411 3.01385 3.877 8.1836 3.877 8.1836l -2.5781 4.51175 -3.6621 2.373c -6.3145 -1.9131 -12.631 -3.93545 -18.9454 -7.53905 -1.7321 -1.88775 -3.3581 -4.30185 -4.5214 -9.0332 0 0 4.5436 -2.69345 5.5957 -4.95115 1.1824 -2.5374 1.6683 -6.00595 0.2148 -8.39845 -1.6161 -2.66045 -5.2762 -4.0421 -8.3887 -4.0918 -2.2801 -0.0364 -4.6888 1.14055 -6.25 2.80275 -1.6788 1.7875 -2.9748 4.46475 -2.5781 6.88475 0.4042 2.4662 4.7363 5.81055 4.7363 5.81055s -1.8003 4.55785 -3.8379 5.4297c -6.0115 2.57205 -9.9784 4.0405 -15.2441 4.8535 -5.2104 0.80445 -11.0723 1.4648 -16.2988 -0.0195 -3.376 -0.95875 -6.845 -2.7304 -8.9649 -5.5273 -0.6311 -0.83265 -0.8593 -3.00785 -0.8593 -3.00785s6.4664 -1.67915 9.0429 -3.6621c2.5589 -1.9694 5.2823 -4.56845 5.8106 -7.7539 0.531 -3.20115 -1.1709 -6.58965 -3.0176 -9.2578 -1.8303 -2.6446 -4.582 -4.73805 -7.5293 -6.0254 -1.3298 -0.5809 -4.3066 -0.64455 -4.3066 -0.64455s -0.6294 0.5709 -0.9375 0.8594c -1.2438 1.59805 -2.9535 2.8626 -4.7657 3.8086 -0.032 0.0185 -0.076 0.0508 -0.1074 0.0684 -0.044 0.0245 -0.1285 0.0438 -0.1758 0.0684 -0.3793 0.18905 -0.7491 0.41 -1.1328 0.5664 -0.1998 0.0815 -0.51 0.0933 -0.7422 0.15625 -1.269 0.42885 -2.4707 0.78125 -2.4707 0.78125s3.8635 1.19585 4.9512 2.7344c0.6719 0.95035 0.9629 2.10935 1.084 3.31055 0.1485 0.7129 0.2344 1.43385 0.2051 2.1289 -0.047 1.10925 -0.3223 2.23315 -0.7032 3.33005 -0.3486 1.27815 -0.8392 2.5073 -1.6699 3.4961 -0.4512 0.53715 -1.0035 0.98495 -1.5918 1.38675 -0.028 0.0227 -0.049 0.0558 -0.078 0.0781 -0.03 0.0231 -0.086 0.0362 -0.1172 0.0586 -1.0379 0.67075 -2.2093 1.1684 -3.3789 1.49415 -1.3714 0.3819 -4.186 0.0793 -4.2871 0.0684 0.1034 0.0002 5.51 -0.01 7.666 -1.5625 0.067 -0.0431 0.1299 -0.092 0.1953 -0.1367 1.5102 -1.205 2.5998 -2.97625 3.2617 -4.88285 0.2091 -0.7666 0.415 -1.54335 0.4883 -2.31445 0.096 -1.01385 0.1157 -2.0935 0.01 -3.1445 -0.3302 -1.5845 -1.0609 -3.1235 -2.2168 -4.1504 -2.4174 -2.1477 -9.3244 -2.40865 -9.4141 -2.4121 -0.1069 0.004 -6.99 0.2671 -9.4043 2.4121 -1.1559 1.0269 -1.8866 2.5659 -2.2168 4.1504 -0.1059 1.051 -0.087 2.13065 0.01 3.1445 0.073 0.7711 0.2792 1.54785 0.4883 2.31445 0.6619 1.9066 1.7515 3.67785 3.2617 4.88285 0.065 0.0447 0.1286 0.0936 0.1953 0.1367 2.1559 1.5529 7.5623 1.5627 7.666 1.5625 -0.1011 0.0109 -2.9156 0.31355 -4.2871 -0.0684 -1.1696 -0.32575 -2.341 -0.8234 -3.3789 -1.49415 -0.031 -0.0224 -0.087 -0.0355 -0.1172 -0.0586 -0.029 -0.0223 -0.05 -0.0554 -0.078 -0.0781 -0.5883 -0.4018 -1.1406 -0.8496 -1.5918 -1.38675 -0.8306 -0.9888 -1.3213 -2.21795 -1.6699 -3.4961 -0.3809 -1.0969 -0.6563 -2.2208 -0.7031 -3.33005 -0.029 -0.69505 0.057 -1.416 0.205 -2.1289 0.1211 -1.2012 0.4219 -2.3602 1.0938 -3.31055 1.0878 -1.53855 4.9414 -2.7344 4.9414 -2.7344s -1.2009 -0.352 -2.4707 -0.78125c -0.2299 -0.0625 -0.5344 -0.0755 -0.7324 -0.15625 -0.3891 -0.15855 -0.7679 -0.38405 -1.1524 -0.57615 -0.042 -0.0218 -0.1172 -0.0368 -0.1562 -0.0586 -0.026 -0.0145 -0.062 -0.0435 -0.088 -0.0586 -1.8212 -0.94695 -3.5456 -2.2132 -4.7949 -3.81835 -0.3082 -0.2885 -0.9375 -0.8594 -0.9375 -0.8594s -2.967 0.0637 -4.2969 0.64455c -2.9473 1.28735 -5.7088 3.3808 -7.5391 6.0254 -1.8467 2.66815 -3.5486 6.05665 -3.0176 9.2578 0.5283 3.18545 3.2615 5.7845 5.8204 7.7539 2.5765 1.98295 9.0332 3.6621 9.0332 3.6621s -0.2283 2.1752 -0.8594 3.00785c -2.1199 2.7969 -5.5889 4.56855 -8.9649 5.5273 -5.2265 1.48435 -11.0884 0.824 -16.2988 0.0195 -5.2657 -0.813 -9.2326 -2.28145 -15.2441 -4.8535 -2.0376 -0.87185 -3.8379 -5.4297 -3.8379 -5.4297s4.3321 -3.34435 4.7363 -5.81055c0.3967 -2.42 -0.8993 -5.09725 -2.5781 -6.88475 -1.5612 -1.6622 -3.9602 -2.83915 -6.2403 -2.80275 -3.1125 0.0497 -6.7823 1.43135 -8.3984 4.0918 -1.4535 2.3925 -0.9675 5.86105 0.2149 8.39845 1.0521 2.2577 5.5957 4.95115 5.5957 4.95115 -1.1633 4.73135 -2.7894 7.14545 -4.5215 9.0332 -6.3144 3.6036 -12.6308 5.62595 -18.9453 7.53905l -3.6524 -2.373 -2.5879 -4.51175s3.7359 -5.16975 3.877 -8.1836c0.1179 -2.51685 -1.1842 -5.00715 -2.5879 -7.0996 -1.1885 -1.7717 -2.7604 -3.50195 -4.7363 -4.30665 -1.8619 -0.7583 -4.0859 -0.7441 -6.0254 -0.21485 -2.9572 0.80705 -7.7442 4.9512 -7.7442 4.9512s -4.7459 -3.79855 -6.4648 -6.25c -1.7149 -2.4458 -3.6524 -8.17385 -3.6524 -8.17385l -1.2109 -0.6445c -3.0703 -0.50455 -7.2949 -3.85745 -7.2949 -3.85745l -4.4434 0.9375s -4.1014 2.19525 -4.1504 4.1504c -0.067 2.70015 3.7256 3.9183 5.4395 6.00585 1.4706 1.7913 2.8406 3.6673 4.1406 5.58595 1.225 1.80785 2.8428 3.47495 3.4375 5.57615 0.6494 2.29425 -0.9739 4.97205 0 7.14845 1.2278 2.74365 3.7734 5.4157 6.7188 6.01565 2.6155 0.53275 7.5879 -2.57815 7.5879 -2.57815l -0.1465 19.8828 10.3027 9.30665 9.7266 20.3125 -3.8575 5.1465 1.1426 10c7.4813 -9.58415 20.5018 -13.7912 32.1875 -17.1484 15.7316 -4.5196 44.5698 -4.8416 58.0078 -4.7168 4.4794 0.0416 7.2559 0.13675 7.2559 0.13675s44.2954 -1.44185 65.2539 4.58005c11.6856 3.3576 24.7062 7.5643 32.1875 17.1484l1.1426 -10 -3.8574 -5.1465 9.7265 -20.3125 10.3028 -9.30665 -0.1465 -19.8828s4.9724 3.1109 7.5879 2.57815c2.9454 -0.59995 5.4909 -3.272 6.7187 -6.01565 0.9739 -2.1764 -0.6494 -4.8542 0 -7.14845 0.5947 -2.1012 2.2125 -3.7683 3.4375 -5.57615 1.3 -1.91865 2.6798 -3.79465 4.1504 -5.58595 1.7139 -2.08755 5.4967 -3.3057 5.4297 -6.00585 -0.049 -1.95515 -4.1504 -4.1504 -4.1504 -4.1504l -4.4434 -0.9375zm -148.33 -2.6074c1.0489 0.98195 3.1026 2.8469 4.7949 3.81835 0.08 0.0418 0.1633 0.0768 0.2441 0.1172 0.5048 0.26415 1.2018 0.50155 1.8848 0.7324 2.913 0.7925 7.9353 0.26675 8.0469 0.2539h0.01 0.02c0.1114 0.0128 5.1327 0.53605 8.0468 -0.2539 0.6767 -0.22865 1.3711 -0.46095 1.875 -0.72265 0.094 -0.047 0.1896 -0.0878 0.2832 -0.1367 1.692 -0.9767 3.7202 -2.82985 4.7657 -3.8086 0.5223 -0.6711 0.9659 -1.39145 1.2988 -2.1582 1.1552 -2.6608 1.1017 -6.11155 -0.2051 -8.7012 -1.5377 -3.0469 -5.1755 -4.49675 -8.0859 -6.2793 -2.5063 -1.53495 -7.9125 -3.72505 -7.9981 -3.75975 -0.1 0.0405 -5.4757 2.22685 -7.9785 3.75975 -2.9104 1.78255 -6.558 3.2324 -8.0957 6.2793 -1.3068 2.58965 -1.3603 6.0404 -0.2051 8.7012 0.3329 0.76675 0.7765 1.4871 1.2989 2.1582z"
          S.path ! A.d "m1980.77 829.789s -10.8864 -5.06097 -16.5904 -6.87893c -10.4126 -3.31869 -21.2354 -5.21582 -31.9667 -7.28356 -12.4669 -2.40215 -25.2596 -3.0515 -37.6221 -5.94324 -3.8919 -0.91037 -7.5305 -2.76907 -11.445 -3.57657 -5.4002 -1.11395 -11.0611 -2.8737 -16.4523 -1.71675 -2.9678 0.6369 -7.8193 4.578 -7.8193 4.578s -4.8672 -3.93997 -7.8193 -4.578c -5.3894 -1.16479 -11.0521 0.6028 -16.4523 1.71675 -3.9145 0.8075 -7.5531 2.6662 -11.445 3.57657 -12.3625 2.89174 -25.1552 3.54109 -37.6221 5.94324 -10.7313 2.06774 -21.5541 3.96487 -31.9667 7.28356 -5.704 1.81796 -16.5904 6.87893 -16.5904 6.87893m197.457 -45.1211s5.3501 -2.82415 7.2852 -5.05855c1.2834 -1.48195 2.5069 -3.2978 2.6367 -5.25395 0.1511 -2.277 -0.6209 -4.853 -2.2266 -6.4746 -1.5608 -1.57635 -4.061 -2.21855 -6.2793 -2.22655 -1.8556 -0.006 -3.842 0.6124 -5.2539 1.8164 -1.63 1.39005 -2.7809 3.5372 -3.0371 5.66405 -0.2186 1.81445 0.5096 3.6987 1.3672 5.3125 1.3002 2.44695 5.5078 6.2207 5.5078 6.2207zm -151.123 0s4.2076 -3.77375 5.5078 -6.2207c0.8576 -1.6138 1.5858 -3.49805 1.3672 -5.3125 -0.2562 -2.12685 -1.4071 -4.274 -3.0371 -5.66405 -1.4119 -1.204 -3.3983 -1.8224 -5.2539 -1.8164 -2.2183 0.008 -4.7088 0.6502 -6.2696 2.22655 -1.6057 1.6216 -2.3776 4.1976 -2.2265 6.4746 0.1298 1.95615 1.3435 3.772 2.6269 5.25395 1.9351 2.2344 7.2852 5.05855 7.2852 5.05855zm -41.0742 18.0078l -11.9336 15.5762s -0.084 4.10895 0.8105 5.86915c1.2312 2.4238 5.8594 5.66405 5.8594 5.66405l0.8496 21.3868 -11.3086 19.5996 -0.9863 0.20505 7.2949 3.85745c0.342 0.0562 0.6808 0.11165 0.9863 0.0879 4.3781 -0.34225 7.0688 -5.2579 10.8789 -7.44145 4.8491 -2.779 10.0115 -4.98805 15.1661 -7.1484 7.1244 -2.9859 14.3588 -5.7335 21.7382 -8.0176 9.3031 -2.87955 18.6911 -5.75975 28.3301 -7.14845 7.298 -1.0514 14.7122 -1.54535 22.0996 -1.4453 2.4625 0.0333 4.9209 0.12695 7.3731 0.29295 6.5689 0.44475 19.3704 3.40415 19.4726 3.42775 0.086 -0.0198 12.9093 -2.9827 19.4824 -3.42775 9.8085 -0.66405 19.7421 -0.2495 29.4727 1.15235 9.639 1.3887 19.027 4.2689 28.3301 7.14845 7.3794 2.2841 14.6139 5.0317 21.7383 8.0176 5.1546 2.16035 10.3169 4.3694 15.166 7.1484 3.8101 2.18355 6.5008 7.0992 10.8789 7.44145 0.3085 0.024 0.6505 -0.0304 0.9961 -0.0879l7.2851 -3.85745 -0.9863 -0.20505 -11.3086 -19.5996 0.8496 -21.3868s4.638 -3.24025 5.8692 -5.66405c0.8943 -1.7602 0.8007 -5.86915 0.8007 -5.86915l -11.9335 -15.5762c -0.0001 0 -6.0157 6.00765 -9.9122 7.28515 -2.0507 0.67235 -4.4136 0.6401 -6.4746 0 -2.501 -0.7768 -4.4344 -2.81105 -6.4746 -4.45315 -4.6088 -3.70965 -9.2257 -7.54105 -12.9492 -12.1386 -2.1328 -2.6335 -5.2637 -8.7012 -5.2637 -8.7012s -12.9078 10.1416 -20.6347 12.1387c -7.5767 1.95835 -15.96 1.6057 -23.4668 -0.6055 -1.8839 -0.5549 -5.0293 -3.0664 -5.0293 -3.0664 -8.8263 -5.6214 -17.652 -8.69745 -26.4258 -7.85155 -8.7738 -0.8459 -17.5995 2.23015 -26.4258 7.85155 0 0 -3.1552 2.5115 -5.0391 3.0664 -7.5068 2.2112 -15.89 2.56385 -23.4667 0.6055 -7.727 -1.99715 -20.6348 -12.1387 -20.6348 -12.1387s -3.1309 6.0677 -5.2637 8.7012c -3.7235 4.5976 -8.3404 8.429 -12.9492 12.1386 -2.0402 1.6421 -3.9736 3.67635 -6.4746 4.45315 -2.061 0.6401 -4.4239 0.67235 -6.4746 0 -3.8965 -1.2775 -9.9121 -7.28515 -9.9121 -7.28515z"
          S.path ! A.d "m1985.89 796.364s0.4479 -5.70292 -0.1618 -8.45505c -0.5584 -2.5204 -1.694 -4.94002 -3.136 -7.08123 -1.5129 -2.2464 -5.6473 -5.84156 -5.6473 -5.84156m -1.4343 27.6901c -0.0001 0 3.3941 0.1231 4.8535 -0.6055 2.6029 -1.2996 6.0742 -6.2695 6.0742 -6.2695s6.6614 4.60745 10.3125 4.04295c1.8007 -0.2784 3.2946 -1.88475 4.248 -3.4375 1.0106 -1.6457 1.6515 -3.78155 1.2207 -5.66405 -0.3431 -1.49915 -1.6576 -2.6497 -2.832 -3.6426 -2.2813 -1.92865 -6.3955 -1.66185 -7.8906 -4.24805 -1.1818 -2.04435 -0.4569 -4.8105 0.1953 -7.08005 1.3607 -4.7357 4.7512 -8.64825 7.4902 -12.7442 1.7395 -2.60125 5.2931 -4.38305 5.6641 -7.49025 0.2006 -1.67945 -2.0215 -4.6582 -2.0215 -4.6582s -5.2216 -0.11815 -7.6855 0.61525c -4.0775 1.21385 -8.3071 2.99495 -11.2012 6.11325 -2.4056 2.5919 -3.1206 6.36555 -4.3848 9.668 -0.9609 2.50985 -2.4219 7.68555 -2.4219 7.68555s -6.0411 -0.013 -8.7011 1.21095c -3.5158 1.6175 -7.1107 4.1574 -8.7012 7.6855 -1.2473 2.7667 -1.0733 6.27265 0 9.11135 1.0815 2.86035 3.4928 5.23565 6.0742 6.875 2.8465 1.80775 9.7071 2.83205 9.7071 2.83205zm -234.71 -27.69s -4.1344 3.59516 -5.6473 5.84156c -1.442 2.14121 -2.5776 4.56083 -3.136 7.08123 -0.6097 2.75213 -0.1618 8.45505 -0.1618 8.45505m -16.9364 -45.4847s -2.2221 2.97875 -2.0215 4.6582c0.371 3.1072 3.9246 4.889 5.6641 7.49025 2.739 4.0959 6.1295 8.00845 7.4902 12.7442 0.6522 2.26955 1.3771 5.0357 0.1953 7.08005 -1.4951 2.5862 -5.6093 2.3194 -7.8906 4.24805 -1.1744 0.9929 -2.4889 2.14345 -2.832 3.6426 -0.4308 1.8825 0.2101 4.01835 1.2207 5.66405 0.9534 1.55275 2.4473 3.1591 4.248 3.4375 3.6511 0.5645 10.3125 -4.04295 10.3125 -4.04295s3.4713 4.9699 6.0743 6.2695c1.4594 0.7286 4.8535 0.6055 4.8535 0.6055s6.8703 -1.0243 9.7168 -2.83205c2.5814 -1.63935 4.9829 -4.01465 6.0644 -6.875 1.0733 -2.8387 1.2473 -6.34465 0 -9.11135 -1.5905 -3.5281 -5.1854 -6.068 -8.7012 -7.6855 -2.66 -1.22395 -8.7011 -1.21095 -8.7011 -1.21095s -1.461 -5.1757 -2.4219 -7.68555c -1.2642 -3.30245 -1.9792 -7.0761 -4.3848 -9.668 -2.8941 -3.1183 -7.1236 -4.8994 -11.2011 -6.11325 -2.4639 -0.7334 -7.6856 -0.61525 -7.6856 -0.61525zm135.626 14.3174l8.3246 -2.43757 8.3246 2.43757m -14.4926 20.0821s -6.481 -5.90993 -7.6882 -9.91375c -0.5271 -1.74815 -0.45 -3.84915 0.4046 -5.46267 1.1684 -2.20587 5.8673 -4.65339 5.8673 -4.65339s -7.0852 -3.44282 -8.9021 -6.67661c -1.0288 -1.83119 -1.1579 -4.24509 -0.607 -6.27195 0.8741 -3.21533 3.2994 -5.96975 5.8673 -8.09287 3.185 -2.63316 11.2261 -5.26034 11.2261 -5.26034s8.0266 2.61995 11.2261 5.26034c2.5698 2.12081 4.9932 4.87754 5.8673 8.09287 0.5509 2.02686 0.4218 4.44076 -0.607 6.27195 -1.8169 3.23379 -8.9021 6.67661 -8.9021 6.67661s4.6989 2.44752 5.8673 4.65339c0.8546 1.61352 0.9317 3.71452 0.4046 5.46267 -1.2072 4.00382 -7.6882 9.91375 -7.6882 9.91375l -6.168 0.40463zm22.6719 -26.8875s13.4369 5.72681 17.9891 11.1064c1.2701 1.50095 2.3519 3.50054 2.2255 5.46267 -0.4485 6.96199 -10.3184 18.2089 -10.3184 18.2089l -19.9282 -8.28243h -12.9438l -19.9282 8.28243s -9.8699 -11.2469 -10.3184 -18.2089c -0.1264 -1.96213 0.9554 -3.96172 2.2255 -5.46267 4.5522 -5.37958 17.9891 -11.1064 17.9891 -11.1064"
          S.path ! A.d "m1844.36 669.248l8.0562 -6.20056 6.5065 0.13988 -6.6557 -0.14309s -3.591 -2.44764 -4.578 -4.29188c -0.958 -1.79023 -1.4152 -4.02072 -1.0015 -6.00863 0.5525 -2.65484 2.0852 -5.45855 4.4277 -6.82475 2.2371 -1.30479 7.7551 -0.47145 7.7551 -0.47145s5.5027 -0.84166 7.7551 0.47145c2.3428 1.36572 3.8752 4.16991 4.4277 6.82475 0.4137 1.98791 -0.043 4.2184 -1.0015 6.00863 -0.987 1.84424 -4.578 4.29188 -4.578 4.29188l -6.6557 0.14309 6.5065 -0.13988 8.0562 6.20056m52.5845 5.06845l -2.6798 4.65503m32.6326 -20.0046l -7.5149 0.98202m8.513 8.80375l -11.5169 0.60428m -1.4979 -13.7479c1.4677 0.93659 4.1545 2.86005 4.5946 4.63497 0.7761 3.12938 -0.6743 7.07048 -3.1391 9.14891 -2.3885 2.01406 -9.252 1.50107 -9.252 1.50107m -181.69 33.5875s11.2946 -2.8202 16.9546 -4.17785c8.0811 -1.93833 16.0993 -4.19579 24.2786 -5.665 9.2622 -1.66374 18.6201 -2.88431 28.0067 -3.55413 11.7104 -0.83564 35.2159 -0.57225 35.2159 -0.57225s23.488 -0.26449 35.2159 0.57225c9.3866 0.66969 18.7445 1.89039 28.0067 3.55413 8.1793 1.46921 16.1975 3.72667 24.2786 5.665 5.66 1.35765 16.9546 4.17785 16.9546 4.17785m -171.551 -30.1651l2.6798 4.65503m -32.6326 -20.0046l7.5149 0.98202m -8.513 8.80375l11.5169 0.60428m -6.4754 16.0764s12.5425 -3.18763 18.8753 -4.50628c6.9234 -1.44166 13.8728 -2.81916 20.8871 -3.71964 8.0675 -1.03566 16.1997 -1.55541 24.3248 -1.92859 9.6296 -0.44228 28.917 -0.36651 28.917 -0.36651s19.2699 -0.0764 28.917 0.36651c8.1252 0.37308 16.2573 0.89293 24.3248 1.92859 7.0143 0.90048 13.9637 2.27798 20.8871 3.71964 6.3328 1.31865 18.8753 4.50628 18.8753 4.50628m -170.239 -14.5393s -6.8635 0.51299 -9.252 -1.50107c -2.4648 -2.07843 -3.9152 -6.01953 -3.1391 -9.14891 0.6108 -2.46349 5.5498 -5.21314 5.5498 -5.21314m63.1382 74.0024c -11.9767 0.7232 -24.0098 1.474 -35.8108 3.6418 -12.2927 2.25809 -24.4854 5.39728 -36.2155 9.71141 -11.113 4.08716 -22.8689 22.6434 -32.0955 15.2222 -1.983 -1.59501 0.7525 -5.08407 1.7168 -7.43927 1.8655 -4.55651 4.429 -8.93224 7.7254 -12.5895 2.4138 -2.67809 7.9759 -3.02712 8.5837 -6.58089 0.4416 -2.58142 -3.4743 -4.09285 -4.2918 -6.58088 -1.0439 -3.17647 -1.5387 -6.81352 -0.5723 -10.0144 1.2405 -4.10872 6.5254 -6.17981 7.7254 -10.3005 1.043 -3.58184 -2.5475 -7.83256 -0.8584 -11.1589 2.133 -4.20065 11.3369 -2.77746 12.0173 -7.43927 0.3317 -2.27285 -3.8251 -2.9802 -4.578 -5.15025 -0.5324 -1.53446 0.3091 -3.24011 0.2861 -4.86414 -0.031 -2.20169 0.392 -4.60137 -0.5723 -6.58088 -0.857 -1.7593 -3.702 -2.13985 -4.2918 -4.00576 -0.5582 -1.76572 -0.1716 -4.13356 1.1445 -5.43639 1.0368 -1.02642 3.6319 0.44281 4.2918 -0.85837 1.3318 -2.62589 -2.5388 -5.31434 -3.7196 -8.01151 -1.4064 -3.21256 -3.2072 -6.31351 -4.0057 -9.72827 -0.6313 -2.69961 -2.9585 -6.88614 -0.5723 -8.29764 2.7325 -1.61631 5.4768 3.23869 8.0115 5.15025 3.3453 2.52289 7.1094 4.81707 9.4422 8.29764 1.6831 2.51135 0.7428 6.50932 2.9483 8.57708 2.6468 2.48143 7.7583 0.49134 10.4996 2.86794 2.3561 2.04271 4.4414 5.55009 3.7196 8.58376 -0.6897 2.89871 -7.5314 2.81792 -6.867 5.72252 0.7892 3.45006 6.8133 3.17917 10.3005 2.57514 2.033 -0.35214 3.4624 -2.24683 5.1503 -3.43351 1.3108 -0.92157 2.389 -2.23216 3.8627 -2.86127 1.6908 -0.72182 5.4363 -0.9299 5.4363 -0.9299l -2.1459 -0.50072s -3.1717 -2.52782 -3.505 -4.36342c -0.3139 -1.72858 0.4369 -3.73179 1.6452 -5.00719 1.3551 -1.43043 3.5376 -2.16034 5.5079 -2.14594 1.6471 0.0118 3.4459 0.66342 4.578 1.85981 1.1609 1.22684 1.8244 3.11308 1.6452 4.7926 -0.1565 1.46787 -1.1275 2.87998 -2.289 3.79116 -1.2578 0.98685 -4.578 1.43063 -4.578 1.43063l2.289 0.64379 6.1517 8.4407 26.5387 -1.45409s3.2734 -3.3392 2.6302 -5.1592c -0.6891 -1.94976 -2.503 -2.66777 -5.665 -2.52901 -8.5812 0.37659 -10.3395 -6.82843 -10.015 -12.0381 0.27 -4.33353 5.4839 -7.27436 9.5092 -8.90214 3.8768 -1.56776 10.7873 3.59271 12.5439 -0.20233 1.5397 -3.32652 -5.8181 -5.02096 -6.9801 -8.49749 -0.5029 -1.50446 -0.5077 -3.33604 0.2023 -4.75454 1.8128 -3.62158 5.7132 -6.02963 9.408 -7.68822 1.5569 -0.69888 5.0552 -0.80928 5.0552 -0.80928s3.4821 0.10463 5.0552 0.80928c3.6961 1.65563 7.5952 4.06664 9.408 7.68822 0.71 1.4185 0.7052 3.25008 0.2023 4.75454 -1.162 3.47653 -8.5198 5.17097 -6.9801 8.49749 1.7566 3.79504 8.6671 -1.36543 12.5439 0.20233 4.0253 1.62778 9.2392 4.56861 9.5092 8.90214 0.3245 5.20968 -1.4338 12.4147 -10.015 12.0381 -3.162 -0.13876 -4.9759 0.57925 -5.665 2.52901 -0.6432 1.82 2.6302 5.1592 2.6302 5.1592l26.5387 1.45409 6.1517 -8.4407 2.289 -0.64379s -3.3202 -0.44378 -4.578 -1.43063c -1.1615 -0.91118 -2.1325 -2.32329 -2.289 -3.79116 -0.1792 -1.67952 0.4843 -3.56576 1.6452 -4.7926 1.1321 -1.19639 2.9309 -1.84798 4.578 -1.85981 1.9703 -0.0144 4.1528 0.71551 5.5079 2.14594 1.2083 1.2754 1.9591 3.27861 1.6452 5.00719 -0.3333 1.8356 -3.505 4.36342 -3.505 4.36342l -2.1459 0.50072s3.7455 0.20808 5.4363 0.9299c1.4737 0.62911 2.5519 1.9397 3.8627 2.86127 1.6879 1.18668 3.1173 3.08137 5.1503 3.43351 3.4872 0.60403 9.5113 0.87492 10.3005 -2.57514 0.6644 -2.9046 -6.1773 -2.82381 -6.867 -5.72252 -0.7218 -3.03367 1.3635 -6.54105 3.7196 -8.58376 2.7413 -2.3766 7.8528 -0.38651 10.4996 -2.86794 2.2055 -2.06776 1.2652 -6.06573 2.9483 -8.57708 2.3328 -3.48057 6.0969 -5.77475 9.4422 -8.29764 2.5347 -1.91156 5.279 -6.76656 8.0115 -5.15025 2.3862 1.4115 0.059 5.59803 -0.5723 8.29764 -0.7985 3.41476 -2.5993 6.51571 -4.0057 9.72827 -1.1808 2.69717 -5.0514 5.38562 -3.7196 8.01151 0.6599 1.30118 3.255 -0.16805 4.2918 0.85837 1.3161 1.30283 1.7027 3.67067 1.1445 5.43639 -0.5898 1.86591 -3.4348 2.24646 -4.2918 4.00576 -0.9643 1.97951 -0.5415 4.37919 -0.5723 6.58088 -0.023 1.62403 0.8185 3.32968 0.2861 4.86414 -0.7529 2.17005 -4.9097 2.8774 -4.578 5.15025 0.6804 4.66181 9.8843 3.23862 12.0173 7.43927 1.6891 3.32633 -1.9014 7.57705 -0.8584 11.1589 1.2 4.12072 6.4849 6.19181 7.7254 10.3005 0.9664 3.20087 0.4716 6.83792 -0.5723 10.0144 -0.8175 2.48803 -4.7334 3.99946 -4.2918 6.58088 0.6078 3.55377 6.1699 3.9028 8.5837 6.58089 3.2964 3.65727 5.8599 8.033 7.7254 12.5895 0.9643 2.3552 3.6998 5.84426 1.7168 7.43927 -9.2266 7.42112 -20.9825 -11.1351 -32.0955 -15.2222 -11.7301 -4.31413 -23.9228 -7.45332 -36.2155 -9.71141 -11.801 -2.1678 -23.8341 -2.91831 -35.8108 -3.6418 -6.9678 -0.42091 -20.9375 -0.40462 -20.9375 -0.40462s -13.9523 -0.0172 -20.9375 0.40462z"
          S.path ! A.d "m1869.06 595.401l -10.1836 0.11745 -10.1836 -0.11745m16.9312 -33.8799c2.6422 -5.60081 -1.9753 -9.7497 -6.7476 -13.8571 -4.7723 4.10743 -9.3897 8.25632 -6.7475 13.8571m14.0661 46.73c3.8943 0.2869 8.6316 4.26757 11.5881 1.71675 1.336 -1.1526 0.6752 -3.66318 0 -5.29332 -1.5743 -3.80071 -8.4131 -4.62493 -8.7268 -8.72683 -0.2706 -3.53784 5.1908 -5.2117 6.2948 -8.58376 0.5489 -1.67687 0.6808 -3.66554 0 -5.29332 -2.7515 -6.57773 -14.4931 -6.95114 -16.5271 -13.6805 -0.9011 -2.98148 5.9324 -6.49335 6.7999 -6.86893 4.3393 -1.87871 9.7036 2.65867 13.9877 0.7993 2.899 -1.25827 6.1252 -4.1237 6.0696 -7.28357 -0.06 -3.43827 -3.7256 -6.31645 -6.8789 -7.68821 -6.1079 -2.65702 -16.2205 5.9042 -19.9783 0.40464 -3.4586 -5.06171 8.643 -11.0806 7.0297 -16.995 -0.7665 -2.81003 -6.9773 -5.26035 -6.9773 -5.26035s -6.2021 2.43824 -6.9773 5.26035c -1.6239 5.91151 10.4883 11.9333 7.0297 16.995 -3.7578 5.49956 -13.8704 -3.06166 -19.9783 -0.40464 -3.1533 1.37176 -6.8184 4.24994 -6.8789 7.68821 -0.056 3.15987 3.1706 6.0253 6.0696 7.28357 4.2841 1.85937 9.6484 -2.67801 13.9877 -0.7993 0.8674 0.37558 7.701 3.88745 6.7999 6.86893 -2.034 6.7294 -13.7756 7.10281 -16.5271 13.6805 -0.6809 1.62778 -0.5489 3.61645 0 5.29332 1.1039 3.37206 6.5654 5.04592 6.2948 8.58376 -0.3137 4.1019 -7.1525 4.92612 -8.7268 8.72683 -0.6753 1.63014 -1.336 4.14072 0 5.29332 2.9565 2.55082 7.6937 -1.42985 11.588 -1.71675 2.433 -0.17924 7.3187 0 7.3187 0s4.8683 -0.18054 7.3186 0z"
          S.path
            ! A.fill "none"
            ! A.d "m1953.74 953.499s -7.1544 -3.01914 -10.8036 -4.34009c -6.5977 -2.3883 -13.2592 -4.63213 -20.0298 -6.47428 -6.5995 -1.79562 -13.2329 -3.68914 -20.0298 -4.45107 -14.5762 -1.63399 -44.0021 -0.20232 -44.0021 -0.20232s -29.4085 -1.43357 -44.0021 0.20232c -6.7969 0.76191 -13.4303 2.65545 -20.0298 4.45107 -6.7706 1.84215 -13.4321 4.08598 -20.0298 6.47428 -3.6492 1.32095 -10.8036 4.34009 -10.8036 4.34009m201.899 -222.5s -11.9524 -4.75619 -18.0259 -6.86702c -5.1003 -1.77255 -10.2059 -3.58154 -15.4508 -4.86412 -6.3972 -1.56438 -12.932 -2.53824 -19.4565 -3.43352 -9.3932 -1.28887 -18.8433 -2.20847 -28.307 -2.78448 -8.5842 -0.52248 -25.7932 -0.60697 -25.7932 -0.60697s -17.1915 0.0836 -25.7932 0.60697c -9.4637 0.57579 -18.9138 1.49561 -28.307 2.78448 -6.5245 0.89528 -13.0593 1.86914 -19.4565 3.43352 -5.2449 1.28258 -10.3505 3.09157 -15.4508 4.86412 -6.0735 2.11083 -18.0259 6.86702 -18.0259 6.86702m -14.1568 120.41s17.5596 -5.91847 26.4055 -8.671c9.1286 -2.84052 18.1733 -6.06275 27.5157 -8.09285 11.184 -2.43029 22.6108 -3.62932 33.9899 -4.85571 11.0585 -1.19184 33.2791 -2.42786 33.2791 -2.42786s22.2032 1.23478 33.2791 2.42786c11.3792 1.22574 22.8059 2.42542 33.9899 4.85571 9.3424 2.0301 18.3871 5.25233 27.5157 8.09285 8.8459 2.75253 26.4055 8.671 26.4055 8.671"
      S.g
        ! A.fill "#CCCCCC"
        ! A.id_ "HaskellSvgIcons-vaCoA-silverKey"
        $ do
          S.g
            ! A.id_ "HaskellSvgIcons-vaCoA-keybase"
            $ do
              S.path ! A.d "m1533.28 904.042l101.171 86.7132s -5.1334 11.2137 -7.279 16.9889c -1.9789 5.3266 -3.8171 10.7271 -5.1455 16.252 -1.9584 8.145 -4.1351 24.7886 -4.1351 24.7886l -117.942 -108.035c1.6729 -24.6894 15.5662 -33.4882 33.3308 -36.7078z"
              S.path ! A.d "m1518.99 958.197l -24.2832 27.1672 15.1647 14.5924 -23.4623 22.89 -15.1647 -15.1647 -25.5145 27.2017 -0.2368 33.7431 58.0835 45.4939 20.0288 -14.8785 -1.1445 -32.3322 15.4508 8.5838 15.4508 -9.4422 0.8583 29.1849 -12.5895 -9.1561 -13.734 18.0259 -1.4306 32.0461 43.7772 38.9131 53.0494 -47.0794 -4.0084 -14.1122 -2.3054 -12.678 -1.2464 -25.1286 1.9803 -27.4395z"
              S.path ! A.d "m1494.71 985.364l -0.6211 29.9932 15.6428 -15.2612z"
              S.path
                ! A.fill "none" 
                ! A.d "m1571.935 1140.425l -1.8207 34.26245m -18.6096  -139.675l0.6445 31.7845m -14.8106  -17.3405l0.8297 25.8846m -14.425  -36.3405l0.5416 28.9249m -21.4347 15.2245l0.3115 30.6476m24.7368  -9.675l44.0639 36.8974 45.0552  -39.54m -171.018  -66.875l57.579 49.1932 18.8843  -16.8814  -14.8785  -12.5895 16.5953  -15.7369 12.8756 11.1589 14.5924  -14.8785 18.8843 18.312  -17.1507 13.4474 16.0062 14.5929  -15.1647 14.0202"
              S.path ! A.d "m1901.35 1229.35l48.6021 44.5794 10.7633 31.4287 -62.6421 -6.6732 -35.6637 -35.2765 -37.9692 -35.1752 -164.039 -142.138s3.4783 -13.1014 5.635 -19.5218c3.124 -9.3004 6.8664 -18.3846 10.5645 -27.472 0.9279 -2.2802 2.9156 -6.7855 2.9156 -6.7855l183.014 162.24z"
              S.path ! A.d "m1942.67 1236.04c27.0945 37.8682 72.6912 73.6383 86.5365 90.8418 13.8452 17.2034 22.7646 33.5407 2.5831 55.5383 -20.1814 21.9976 -43.064 9.5153 -61.1352 -2.5832 -18.0712 -12.0984 -49.6026 -51.3029 -94.7165 -81.3701z"
              S.path ! A.d "m1926.7 1299.75l -35.1694 -15.8738m40.928 -38.2875c2.4231 7.9655 0.5742 16.7742 3.624 24.4159 3.0153 7.5554 14.0225 19.9737 14.0225 19.9737s -6.9976 0.9775 -10.2616 2.2451c -4.731 1.8372 -11.9561 2.7096 -13.172 7.6371 -1.0633 4.3091 4.0612 8.0262 7.0898 11.2707 2.9045 3.1116 6.6447 5.3721 10.3159 7.5262 6.1364 3.6005 12.391 7.6535 19.393 8.9161 8.7653 1.5806 25.1291 -10.7555 26.6468 -1.9791 0.6311 3.6495 -7.3892 1.3125 -10.7131 2.9459 -7.7584 3.8123 -11.6492 12.1174 -4.8208 17.8939 4.3853 3.7097 11.2751 2.3464 16.9994 2.8209 5.4887 0.455 11.7572 -2.745 16.5227 0.016 5.6107 3.2507 12.6678 11.1061 9.6914 16.867 -3.0627 5.9283 -14.4837 5.7692 -19.9267 1.9095 -4.0245 -2.8539 -2.947 -9.4733 -3.5417 -14.371 -0.1769 -1.4578 0 -2.937 0 -4.4055"
              S.circle
                ! A.cx "2154.66"
                ! A.cy "1480.14"
                ! A.r  "129.6871"
              S.path
                ! A.fill "#FFFFFF"
                ! A.d "m2106.13 1485.65c -22.3554 0 -40.4781 18.1226 -40.4781 40.478 0 22.3555 18.1227 40.4781 40.4781 40.4781s40.4781 -18.1226 40.4781 -40.4781l14.0261 -0.6088c0 22.3554 18.1227 40.4781 40.4781 40.4781s40.4781 -18.1227 40.4781 -40.4781 -18.1227 -40.4781 -40.4781 -40.4781l0.6088 -7.9375c22.3555 0 40.4781 -18.1227 40.4781 -40.4781s -18.1226 -40.4781 -40.4781 -40.4781c -22.3554 0 -40.4781 18.1227 -40.4781 40.4781l -14.026 -1.2177c0 -22.3555 -18.1227 -40.4781 -40.4781 -40.4781 -22.3555 0 -40.4781 18.1226 -40.4781 40.4781 0 22.3554 18.1226 40.4781 40.4781 40.4781z"
              S.circle ! A.cx "2154.66" ! A.cy "1446.05" ! A.r "14.61"
              S.circle ! A.cx "2189.36" ! A.cy "1480.14" ! A.r "14.61"
              S.circle ! A.cx "2155.27" ! A.cy "1511.20" ! A.r "14.61"
              S.circle ! A.cx "2119.34" ! A.cy "1480.14" ! A.r "14.61"
              S.path
                ! A.fill "#FFFFFF"
                ! A.d "m2152.23 1558.42c -5.3378 10.9567 -12.6202 15.941 -21.919 21.919 13.2474 5.754 29.4005 4.6966 43.838 0 -9.2987 -4.6497 -16.0413 -11.9958 -21.919 -21.919zm -76.5786 -80.2317c -10.9566 -5.3378 -15.9409 -12.6203 -21.919 -21.919 -5.7539 13.2473 -4.6965 29.4005 0 43.838 4.6498 -9.2988 11.9959 -16.0414 21.919 -21.919zm159.246 3.6531c10.9567 -5.3378 15.941 -12.6203 21.919 -21.919 5.754 13.2473 4.6966 29.4005 0 43.838 -4.6497 -9.2988 -11.9958 -16.0414 -21.919 -21.919zm -78.4052 -80.8406c -5.3378 -10.9566 -12.6203 -15.9409 -21.919 -21.919 13.2473 -5.7539 29.4005 -4.6965 43.838 0 -9.2988 4.6498 -16.0414 11.9959 -21.919 21.919z"
          S.g
            ! A.fill "#FFE000"
            $ do
              S.g
                ! A.id_ "HaskellSvgIcons-vaCoA-keydeco"
                $ do
                  S.path ! A.d "m1533.48 903.819s0.7031 -5.06124 0.0001 -7.43925c -1.1438 -3.86881 -3.5741 -7.46776 -6.5809 -10.1575 -2.5433 -2.27495 -5.8071 -3.92372 -9.1561 -4.57801 -3.6147 -0.70621 -7.4637 -0.11504 -11.0158 0.85837 -2.4196 0.6631 -6.7534 3.32254 -6.7534 3.32254l -14.8491 6.11961 -5.5107 17.6674s -3.1741 5.5789 -3.9314 8.65611c -0.8104 3.29294 -1.4088 6.87107 -0.5723 10.1574 0.9826 3.86017 3.2315 7.61137 6.2948 10.1574 2.8332 2.35479 6.6269 3.72901 10.3005 4.00577 2.8265 0.21295 8.2977 -1.85982 8.2977 -1.85982 1.5802 -18.6113 9.856 -32.8133 33.4766 -36.9102z"
                  S.path ! A.d "m1500.27 885.645l -38.7531 -17.0196 -3.1474 3.00431 21.1189 38.2016s5.9243 -8.73821 9.3535 -12.7364c3.5106 -4.09311 11.4281 -11.4499 11.4281 -11.4499z"
                  S.circle ! A.cx "1457.29" ! A.cy "865.26" ! A.r "15.95"
                  S.path ! A.d "m1566.19 932.256c3.3899 27.9522 7.3216 55.9043 16.0248 83.8565l31.0688 28.459c -6.625 -29.2317 -18.4423 -58.4633 -18.3681 -87.695z"
                  S.path ! A.d "m1613.05 972.415l -85.4875 -6.36886 27.2007 24.9158 78.0675 3.37974 1.1469 -3.98967z"
                  S.path ! A.d "m1718.36 1066.92c -22.4447 8.4602 -31.4178 22.3089 -37.8571 37.1712 -6.3529 0.5589 -12.3057 0.6177 -14.4104 -4.1336 5.3477 -34.6998 30.2103 -45.5513 35.7531 -47.747 14.9497 -2.8246 12.1788 8.8497 16.5144 14.7094z"
                  S.path ! A.d "m1745.88 1092.82c -22.4446 8.4601 -31.4177 22.3089 -37.857 37.1711 -6.3529 0.5589 -12.3057 0.6177 -14.4104 -4.1336 5.3477 -34.6998 30.2103 -45.5512 35.753 -47.747 14.9498 -2.8246 12.1789 8.8497 16.5144 14.7095z"
                  S.path ! A.d "m2058.66 1354.69c -7.33655  -0.2015  -15.0781 1.5039  -15.0781 1.5039 0.3035 8.02055  -2.9456 16.58265  -11.7969 26.2305  -7.63945 8.32695  -15.6662 11.70345  -23.67185 12.041l -0.01 0.01s -2.8398 17.65195 2.5879 23.25195c6.3562 6.5581 27.11915 3.87695 27.11915 3.87695l1.7676  -1.1325a129.6875 129.6875 0 0 1 31.91405  -39.7949l0.332  -1.2595s3.0386  -16.5234  -2.1484  -21.5c -2.35045  -2.27015  -6.6137  -3.0726  -11.01565 0z"
                  S.circle ! A.cx "2254.51" ! A.cy "1375.42" ! A.r "17.65"
                  S.circle ! A.cx "2260.60" ! A.cy "1580.00" ! A.r "17.65"
                  S.circle ! A.cx "2062.11" ! A.cy "1591.57" ! A.r "17.65"
      S.g
        ! A.fill "#FFE000"
        ! A.id_ "HaskellSvgIcons-vaCoA-goldenKey"
        ! A.transform (S.matrix (-1) 0 0 1 3718.256 0)
        $ do
          S.use 
            ! A.xlinkHref "#HaskellSvgIcons-vaCoA-keybase"
          S.use
            ! A.xlinkHref "#HaskellSvgIcons-vaCoA-keydeco"
            ! A.fill "#CCCCCC"
      S.g
        ! A.id_ "HaskellSvgIcons-vaCoA-cord"
        $ do
          S.g
            ! A.fill "#FA0204"
            $ do
              S.path
                ! A.id_ "HaskellSvgIcons-vaCoA-cordPiece1"
                ! A.d "m1869.19 1175.78c0 5.3802 -4.4998 7.4585 -13.2427 7.4585s -12.7861 -2.5349 -12.7861 -7.9152c0 -5.3802 4.0432 -6.6974 12.7861 -6.6974s13.2427 1.7739 13.2427 7.1541z"
              S.use
                ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece1"
                ! A.x "6.39"
                ! A.y "14.309"
              S.path
                ! A.d "m1877.34 1208.69c -1.772 5.0801 -6.7053 5.5604 -14.9604 2.681 -8.255 -2.8795 -11.2378 -6.6047 -9.4658 -11.6847 1.772 -5.0801 6.0234 -4.9922 14.2785 -2.1127 8.2551 2.8794 11.9197 6.0364 10.1477 11.1164z"
              S.path
                ! A.id_ "HaskellSvgIcons-vaCoA-cordPiece2"
                ! A.d "m1877.51 1222.51c -1.065 5.2737 -5.8872 6.4202 -14.4571 4.6895s -12.0312 -5.0159 -10.9662 -10.2897c1.065 -5.2737 5.289 -5.7645 13.8588 -4.0338 8.5699 1.7306 12.6295 4.3602 11.5645 9.634z"
              S.use
                ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece2"
                ! A.x "3.959"
                ! A.y "16.14"
              S.path ! A.d "m1921.73 1216.2c -2.5904 -0.6912 -2.3033 -5.3033 -1.583 -7.8857 1.107 -3.9686 8.3538 -9.11 8.3538 -9.11s1.7671 5.5627 0.9501 8.1851c -1.1615 3.7283 -3.948 9.8173 -7.7209 8.8106z"
              S.path ! A.d "m1912.29 1224.42c -2.8216 -0.6217 -3.1818 -5.5227 -2.444 -8.3162 1.142 -4.3238 9.6454 -9.3253 9.6454 -9.3253s1.4762 6.0417 0.5196 8.831c -1.2669 3.6937 -3.9075 9.6508 -7.721 8.8105z"
              S.path ! A.d "m1901.52 1240.01c -4.2916 -1.1384 -3.8048 -8.7623 -2.6592 -13.0521 0.946 -3.5426 3.7155 -9.1195 7.2774 -8.2489 4.1673 1.0185 4.1144 8.3214 3.1027 12.4905 -0.9208 3.7948 -3.9464 9.8117 -7.7209 8.8105z"
              S.path ! A.d "m1888.73 1252.19c -4.2142 -0.9262 -6.0068 -7.6384 -5.1637 -11.8701 0.8851 -4.4419 5.3598 -10.4103 9.7819 -9.4309 4.4624 0.9884 6.0053 8.3528 4.9293 12.7949 -1.0033 4.1426 -5.3845 9.4211 -9.5475 8.5061z"
              S.path ! A.d "m1886.51 1259.58c -1.0768 5.087 -7.5039 6.86 -11.4614 5.5691 -4.1541 -1.355 -9.5785 -7.1863 -8.4416 -12.5236 1.1474 -5.3859 8.1788 -6.8138 12.3239 -5.2257 3.8656 1.4809 8.6428 7.1552 7.5791 12.1802z"
              S.path ! A.d "m1801.47 1210.29s5.1379 2.5312 7.3489 4.7921c2.321 2.3733 5.1107 3.3218 3.709 6.9229 -1.4145 3.6339 -5.8427 2.3881 -8.1269 -0.1558 -2.1302 -2.3723 -2.931 -11.5592 -2.931 -11.5592z"
              S.path ! A.d "m1826.84 1219.06c5.2115 1.0469 5.1081 7.1209 2.4435 10.8465 -2.7971 3.9106 -10.8836 8.9923 -16.3493 7.8872 -5.5156 -1.1152 -4.8437 -7.7572 -1.7951 -11.658 2.843 -3.6377 10.5528 -8.1097 15.7009 -7.0757z"
              S.path
                ! A.id_ "HaskellSvgIcons-vaCoA-cordPiece3"
                ! A.d "m1844.26 1230.55c4.8531 2.1688 3.4146 8.0709 0 11.1182 -3.5896 3.1987 -12.5967 6.3749 -17.6849 4.0932 -5.1345 -2.3024 -3.0165 -8.6334 0.8162 -11.767 3.5744 -2.9224 12.0797 -5.5868 16.8737 -3.4444z"
              S.use
                ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece3"
                ! A.x "14.00"
                ! A.y "10.66"
              S.path ! A.d "m1862.97 1250.68c4.7874 0.7544 6.069 7.4153 4.5846 11.6962 -1.5593 4.494 -7.4731 10.6689 -12.4956 9.8697 -5.0684 -0.8064 -5.9818 -8.1322 -4.2007 -12.6343 1.6611 -4.1985 7.3836 -9.6772 12.1127 -8.932z"
              S.path ! A.d "m1875.1 1265.33c3.9649 2.3077 3.0331 9.5902 0.4105 13.5334 -2.7541 4.1391 -9.845 8.622 -14.0023 6.1932 -4.1951 -2.451 -2.7353 -10.302 0.2157 -14.3787 2.7522 -3.8018 9.4605 -7.6274 13.3771 -5.3479z"
              S.path ! A.d "m1789.02 1225.44c4.2435 -0.3761 7.1824 5.9652 7.1269 10.5849 -0.059 4.8498 -3.317 12.4028 -7.771 12.7899 -4.4945 0.3906 -7.3089 -6.7007 -7.0653 -11.611 0.2273 -4.5791 3.5185 -11.3927 7.7102 -11.7644z"
              S.path ! A.d "m1802.91 1237.65c4.1568 0.9325 5.0275 7.8673 3.5694 12.2512 -1.5316 4.6021 -6.9326 10.8061 -11.2933 9.82 -4.4004 -0.9952 -4.9243 -8.6065 -3.1985 -13.21 1.6094 -4.293 6.8172 -9.7825 10.9234 -8.8615z"
              S.path ! A.d "m1815.79 1246.24c4.9212 1.1581 5.952 9.7707 4.2258 15.2152 -1.8133 5.7155 -8.2076 13.4205 -13.3701 12.1958 -5.2096 -1.2359 -5.8298 -10.6887 -3.7868 -16.4059 1.9054 -5.3317 8.071 -12.1493 12.9322 -11.0055z"
              S.path ! A.d "m1826.22 1256.8c5.0144 -0.6444 9.0048 7.0573 9.301 12.7613 0.3098 5.9882 -2.9706 15.4482 -8.2344 16.115 -5.3117 0.6727 -9.2128 -7.9599 -9.3081 -14.0304 -0.089 -5.6613 3.2892 -14.2102 8.2424 -14.8467z"
              S.path
                ! A.id_ "HaskellSvgIcons-vaCoA-cordPiece4"
                ! A.d "m1838.59 1265.66c4.5564 -0.5341 8.1822 5.85 8.4514 10.578 0.2815 4.9637 -2.6993 12.8053 -7.4822 13.358 -4.8266 0.5576 -8.3713 -6.5981 -8.4579 -11.63 -0.081 -4.6927 2.9887 -11.779 7.4895 -12.3067z"
              S.use
                ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece4"
                ! A.x "12.79"
                ! A.y "10.35"
              S.path
                ! A.id_ "HaskellSvgIcons-vaCoA-cordPiece5"
                ! A.d "m1929.28 1250.88c -3.2434 2.8459 -9.7124 0.3125 -12.6215 -2.8742 -3.0537 -3.345 -5.2098 -10.4862 -1.8005 -13.4679 3.4404 -3.009 10.2869 0.1121 13.2276 3.611 2.7423 3.263 4.3982 9.9199 1.1944 12.7311z"
              S.use
                ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece5"
                ! A.x "-7"
                ! A.y "12.79"
              S.use
                ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece5"
                ! A.x "-19.48"
                ! A.y "23.45"
              S.path ! A.d "m1905.19 1281.18c -1.1383 4.1621 -7.9325 5.6128 -12.1161 4.5566 -4.3915 -1.1087 -10.1258 -5.8797 -8.9239 -10.2466 1.2128 -4.4066 8.646 -5.5749 13.0279 -4.2756 4.0865 1.2117 9.1366 5.8543 8.0121 9.9656z"
              S.path ! A.d "m1887.18 1278.19c3.6414 2.5388 2.7856 10.5507 0.377 14.8888 -2.5295 4.5537 -9.0418 9.4855 -12.86 6.8135 -3.8529 -2.6965 -2.5122 -11.3338 0.1981 -15.8188 2.5276 -4.1825 8.6887 -8.3913 12.2858 -5.8835z"
              S.path ! A.d "m1869.62 1287.55c3.9649 2.3077 3.0332 9.5902 0.4105 13.5334 -2.7541 4.1392 -9.8449 8.622 -14.0022 6.1932 -4.1952 -2.451 -2.7354 -10.302 0.2157 -14.3787 2.7522 -3.8017 9.4604 -7.6273 13.3771 -5.3479z"
              S.path
                ! A.id_ "HaskellSvgIcons-vaCoA-cordPiece6"
                ! A.d "m1831.34 1312.91c -3.3916 3.2346 -0.7555 11.2719 2.7733 15.2819 3.7054 4.2091 11.7943 8.1045 15.3483 4.7027 3.5863 -3.4329 0.2927 -12.0241 -3.5934 -16.1312 -3.6241 -3.83 -11.1791 -7.0483 -14.5293 -3.8532z"
              S.use
                ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece6"
                ! A.x "-7.32"
                ! A.y "13.78"
              S.path
                ! A.id_ "HaskellSvgIcons-vaCoA-cordPiece7"
                ! A.d "m1820.83 1339.55c -4.3482 1.7486 -4.8759 10.1907 -3.083 15.2224 1.8833 5.282 7.9545 11.896 12.5156 10.0521 4.6026 -1.8607 4.7247 -11.0608 2.6358 -16.315 -1.9481 -4.8998 -7.7742 -10.687 -12.0694 -8.9598z"
              S.use
                ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece7"
                ! A.x "-10.55"
                ! A.y "14.85"
              S.path
                ! A.id_ "HaskellSvgIcons-vaCoA-cordPiece8"
                ! A.d "m1802.66 1371.04c -4.5705 1.0369 -6.4304 9.2885 -5.4581 14.5409 1.0218 5.5138 5.9673 13.0069 10.763 11.9097 4.8395 -1.1073 6.4191 -10.1716 5.1899 -15.6905 -1.1464 -5.1468 -5.981 -11.7847 -10.4958 -10.7605z"
              S.use
                ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece8"
                ! A.x "-10.12"
                ! A.y "15.93"
              S.path
                ! A.id_ "HaskellSvgIcons-vaCoA-cordPiece9"
                ! A.d "m1784.06 1403.3c -4.6836 0.1712 -8.0416 7.9347 -8.0603 13.2763 -0.019 5.6077 3.4514 13.888 8.3674 13.6993 4.9609 -0.1905 8.1942 -8.8046 8.0099 -14.4558 -0.1719 -5.2701 -3.6915 -12.6895 -8.3179 -12.5204z"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece9" ! A.x "-10.33" ! A.y "19.16"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece9" ! A.x "-22.39" ! A.y "37.02"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece9" ! A.x "-34.87" ! A.y "52.31"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece9" ! A.x "-47.79" ! A.y "66.51"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece9" ! A.x "-61.99" ! A.y "78.14"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece9" ! A.x "-75.55" ! A.y "90.62"
              S.path ! A.d "m1692.79 1500.17l -5.2618 20.5953s2.9353 7.3347 5.9995 7.026c5.4811 -0.552 6.9648 -9.0469 8.0099 -14.4557 0.9476 -8.4237 -8.7476 -13.1656 -8.7476 -13.1656z"
              S.path ! A.d "m2017.21 1513.25c1.6097 6.1241 15.2598 11.3138 15.2598 11.3138l -6.6509 -27.7579c -5.7168 0.154 -9.4945 12.4363 -8.6089 16.4441z"
              S.path ! A.d "m2016.01 1490.95c -4.3589 -1.7217 -10.549 4.0428 -12.7088 8.9283 -2.2663 5.1293 -2.4091 14.1062 2.1699 15.9053 4.6206 1.8154 11.0377 -4.7785 13.1357 -10.0289 1.9564 -4.8966 1.7085 -13.1047 -2.5973 -14.8056z"
              S.path
                ! A.id_ "HaskellSvgIcons-vaCoA-cordPiece10"
                ! A.d "m2000.82 1478.67c -4.6803 -0.2433 -8.7113 7.193 -9.202 12.5121 -0.5142 5.584 2.2105 14.1386 7.124 14.3851 4.9583 0.2487 8.9402 -8.046 9.2562 -13.6913 0.2944 -5.2647 -2.5557 -12.9661 -7.1789 -13.2065z"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece10" ! A.x "-13.40" ! A.y "-13.70"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece10" ! A.x "-25.88" ! A.y "-29.23"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece10" ! A.x "-38.66" ! A.y "-42.32"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece10" ! A.x "-49.01" ! A.y "-60.28"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece10" ! A.x "-60.28" ! A.y "-76.41"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece10" ! A.x "-70.63" ! A.y "-93.46"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece10" ! A.x "-79.76" ! A.y "-113.25"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece10" ! A.x "-89.81" ! A.y "-131.21"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece10" ! A.x "-98.03" ! A.y "-152.52"
              S.path ! A.d "m1883.85 1304.56s -1.6473 26.6763 8.0374 28.389c6.0386 1.0678 10.7782 -14.9091 10.7782 -14.9091z"
              S.path
                ! A.id_ "HaskellSvgIcons-vaCoA-cordPiece11"
                ! A.d "m1862.02 1610.75c -2.8778 3.699 0.9139 11.2601 4.9952 14.7063 4.2852 3.6171 12.8598 6.2779 15.8737 2.3895 3.0412 -3.9239 -1.4825 -11.936 -5.9313 -15.4255 -4.149 -3.2541 -12.0958 -5.3239 -14.9385 -1.6701z"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece11" ! A.x "18.3" ! A.y "-2.15"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece11" ! A.x "36.8" ! A.y "-5.81"
              S.path
                ! A.id_ "HaskellSvgIcons-vaCoA-cordPiece12"
                ! A.d "m1916.18 1603.8c -2.2897 4.0891 2.5943 10.9952 7.1468 13.7895 4.7797 2.9327 13.6566 4.2758 16.0525 -0.021 2.4176 -4.336 -3.2579 -11.578 -8.1802 -14.3601 -4.5906 -2.5942 -12.7581 -3.4473 -15.02 0.592z"
              S.use
                ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece12"
                ! A.x "20.02"
                ! A.y "-3.22"
              S.path
                ! A.id_ "HaskellSvgIcons-vaCoA-cordPiece13"
                ! A.d "m1953.48 1595.43c -1.9026 4.283 3.5981 10.7088 8.389 13.071 5.03 2.4789 13.993 2.9969 15.982 -1.5028 2.0071 -4.5407 -4.3126 -11.2279 -9.4707 -13.5437 -4.8105 -2.1594 -13.0218 -2.255 -14.9012 1.9759z"
              S.use
                ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece13"
                ! A.x "18.94"
                ! A.y "-5.59"
              S.path
                ! A.id_ "HaskellSvgIcons-vaCoA-cordPiece14"
                ! A.d "m1991.26 1583.89c -1.6462 4.3879 4.2246 10.4775 9.1467 12.5525 5.1677 2.1773 14.1457 2.1649 15.8653 -2.4445 1.7353 -4.6513 -4.9685 -10.9534 -10.2545 -12.9604 -4.9296 -1.8714 -13.1322 -1.4816 -14.7584 2.8528z"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece14" ! A.x "19.16" ! A.y "-6.24"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece14" ! A.x "37.67" ! A.y "-13.99"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece14" ! A.x "57.48" ! A.y "-22.17"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece14" ! A.x "77.50" ! A.y "-28.63"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece14" ! A.x "79.87" ! A.y "-44.34"
              S.path ! A.d "m2066.71 1534.88s13.5498 1.9917 14.7891 -2.8749c1.6456 -6.4625 -15.4209 -12.7452 -15.4209 -12.7452z"
              S.path
                ! A.id_ "HaskellSvgIcons-vaCoA-cordPiece15"
                ! A.d "m1701.62 1575.59c -3.9861 2.4647 -3.066 10.8731 -0.4409 15.5252 2.7567 4.8833 9.8673 10.3646 14.0469 7.7697 4.2177 -2.6186 2.7685 -11.7047 -0.186 -16.5255 -2.7555 -4.4957 -9.4834 -9.2042 -13.421 -6.7695z"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece15" ! A.x "18.94" ! A.y "7.75"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece15" ! A.x "37.03" ! A.y "10.55"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece15" ! A.x "56.83" ! A.y "15.50"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece15" ! A.x "74.70" ! A.y "18.08"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece15" ! A.x "92.35" ! A.y "21.74"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece15" ! A.x "110.4" ! A.y "26.69"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece15" ! A.x "128.3" ! A.y "29.92"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece15" ! A.x "146.6" ! A.y "32.72"
              S.path ! A.d "m1648.16 1517.51c -4.1667 -2.1454 -10.8978 2.9772 -13.5312 7.6245 -2.7637 4.8794 -3.7956 13.7979 0.5824 16.042 4.4179 2.2645 11.457 -3.6607 14.0652 -8.6773 2.4321 -4.6785 2.9991 -12.8708 -1.1168 -14.9901z"
              S.path ! A.d "m1642.01 1534.4c -4.4151 -1.5719 -10.4047 4.4008 -12.3964 9.3572 -2.0898 5.2037 -1.9258 14.1803 2.7119 15.8218 4.6799 1.6566 10.868 -5.1526 12.7855 -10.4717 1.7879 -4.9605 1.2598 -13.1554 -3.1015 -14.7082z"
              S.path ! A.d "m1647.74 1549.94c -4.5395 -1.1649 -9.9626 5.3264 -11.4964 10.4431 -1.6092 5.3718 -0.6317 14.2965 4.1358 15.5106 4.8109 1.2252 10.3558 -6.1173 11.7829 -11.5884 1.3306 -5.1022 0.061 -13.2154 -4.4229 -14.3661z"
              S.path ! A.d "m1662.37 1556.31c -4.499 -1.3127 -10.1315 4.9978 -11.8319 10.0615 -1.784 5.3163 -1.0989 14.2682 3.6263 15.6376 4.7683 1.3819 10.5504 -5.7753 12.1556 -11.1967 1.4968 -5.056 0.4935 -13.2064 -3.9506 -14.5032z"
              S.path
                ! A.id_ "HaskellSvgIcons-vaCoA-cordPiece16"
                ! A.d "m1671.91 1558.81c -4.5474 1.1337 -6.2318 9.4229 -5.1483 14.6535 1.1385 5.4908 6.242 12.8773 11.0134 11.6786 4.8148 -1.2097 6.2017 -10.3055 4.8557 -15.7971 -1.2554 -5.1213 -6.2297 -11.6551 -10.7217 -10.5354z"
              S.use
                ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece16"
                ! A.x "16.79"
                ! A.y "6.24"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece6" ! A.x "8.61" ! A.y "-11.19"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece6" ! A.x "4.66" ! A.y "6.47"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece6" ! A.x "4.91" ! A.y "26.68"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece6" ! A.x "4.66" ! A.y "47.87"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece6" ! A.x "5.57" ! A.y "68.57"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece6" ! A.x "2.22" ! A.y "87.75"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece6" ! A.x "4.66" ! A.y "109.06"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece6" ! A.x "2.22" ! A.y "126.41"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece6" ! A.x "4.66" ! A.y "143.46"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece6" ! A.x "4.66" ! A.y "163.86"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece6" ! A.x "3.44" ! A.y "183.95"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece6" ! A.x "3.74" ! A.y "203.13"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece6" ! A.x "4.35" ! A.y "223.52"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece6" ! A.x "4.35" ! A.y "243.31"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece6" ! A.x "3.74" ! A.y "263.10"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece6" ! A.x "2.52" ! A.y "283.19"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece6" ! A.x "2.52" ! A.y "305.11"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece6" ! A.x "1.92" ! A.y "327.94"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece6" ! A.x "1.92" ! A.y "349.25"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece6" ! A.x "1.92" ! A.y "369.04"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece6" ! A.x "1.31" ! A.y "391.27"
              S.path
                ! A.id_ "HaskellSvgIcons-vaCoA-cordPiece17"
                ! A.d "m1882.24 1303.18c2.4423 3.7068 -1.3196 10.8321 -5.1636 13.9699 -4.036 3.2931 -11.9117 5.4626 -14.4688 1.5665 -2.5804 -3.9315 1.8636 -11.4583 6.0421 -14.6207 3.8968 -2.949 11.1785 -4.577 13.5912 -0.9154z"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece17" ! A.x "2.74" ! A.y "16.13"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece17" ! A.x "2.43" ! A.y "34.1"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece17" ! A.x "2.13" ! A.y "52.36"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece17" ! A.x "1.82" ! A.y "69.11"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece17" ! A.x "2.74" ! A.y "87.07"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece17" ! A.x "1.52" ! A.y "104.42"
              S.path ! A.d "m1883.25 1426.06c2.6959 3.8337 -1.4565 11.2029 -5.6994 14.448 -4.4549 3.4059 -13.148 5.6497 -15.9706 1.6202 -2.8482 -4.0661 2.0571 -11.8504 6.6693 -15.1211 4.3012 -3.05 12.3386 -4.7336 15.0017 -0.9467z"
              S.path
                ! A.id_ "HaskellSvgIcons-vaCoA-cordPiece18"
                ! A.d "m1882.09 1443.58c3.3915 3.2345 0.7554 11.2718 -2.7734 15.2819 -3.7054 4.209 -11.7943 8.1044 -15.3482 4.7026 -3.5863 -3.4328 -0.2928 -12.0241 3.5933 -16.1312 3.6241 -3.83 11.1791 -7.0482 14.5293 -3.8532z"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece18" ! A.x "0.61" ! A.y "20.40"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece18" ! A.x "0.92" ! A.y "40.49"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece18" ! A.x "0.31" ! A.y "62.11"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece18" ! A.x "0.92" ! A.y "82.20"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece18" ! A.x "0.31" ! A.y "102.6"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece18" ! A.x "0.61" ! A.y "123.0"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece18" ! A.x "0.61" ! A.y "143.7"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece18" ! A.x "-0.3" ! A.y "164.4"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece18" ! A.x "0.92" ! A.y "183.2"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece18" ! A.x "0.92" ! A.y "203.1"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece18" ! A.x "0.31" ! A.y "224.3"
              S.use ! A.xlinkHref "#HaskellSvgIcons-vaCoA-cordPiece18" ! A.x "0.31" ! A.y "245.3"
          S.g 
            $ do
              S.path
                ! A.fill "#FA0204"
                ! A.d "m1849.64 1848.26c19.9021 5.5241 31.7591 5.236 48.2193 0.4305l -17.4364 -27.9844"
              S.path
                ! A.fill "#FFE000"
                ! A.d "m1888.31 1776.16 -31.7083 -8.1414s0.3666 -35.1832 20.3893 -32.1154c16.6195 2.5464 11.9853 40.3409 11.319 40.2568z"
              S.circle
                ! A.fill "#FFE000"
                ! A.cx "1872.88"
                ! A.cy "1722.97"
                ! A.r "12.91"
              S.path
                ! A.fill "#FA0204"
                ! A.d "m1885.37 1791.86c7.0484 17.8642 11.3696 33.2411 4.7358 53.3857m7.5972 3.4126c -10.2262 -8.2551 -36.5822 -5.8322 -47.9812 -0.3475 -4.4526 0 -16.4454 -83.2401 25.7219 -81.1827 38.7211 1.8892 24.9493 81.9145 22.2593 81.5302z"
          S.g
            $ do
              S.path
                ! A.fill "#FA0204"
                ! A.d "m1815.2 1866.34c19.2918 12.2385 37.2498 11.1397 54.2468 0.4305l -40.2546 -41.9766"
              S.circle
                ! A.fill "#FFE000"
                ! A.cx "1843.39"
                ! A.cy "1738.25"
                ! A.r  "12.91"
              S.path
                ! A.fill "#FFE000"
                ! A.d "m1859.33 1780.02 -32.7202 -0.6458s -4.2451 -26.6125 16.1449 -27.7691c16.9243 -0.96 17.2516 28.3629 16.5753 28.4149z"
              S.path
                ! A.fill "#FA0204"
                ! A.d "m1843.61 1860.74c -6.2615 -13.9097 -6.9109 -31.0263 -5.1664 -49.5109m -9.4716 50.372c -7.6816 -13.1828 -9.1065 -30.0153 -3.0137 -51.233m43.4039 56.6355c -4.9263 -6.1908 -40.2274 -8.8289 -54.0959 -0.3918 -5.02 0 -18.5411 -93.8481 28.9999 -91.5285 43.6557 2.13 28.1288 92.3536 25.096 91.9203z"



{- |
Flag of Kosovo coat of arms.
Drawn for a @viewbox 0 0 840 600@
-}
xkCoA :: Svg
xkCoA = 
    S.path
      ! A.stroke "none"
      ! A.strokeWidth "0"
      ! A.fill "#D0A650"
      ! A.d (S.toValue dirs)
  where
    dirs :: String
    dirs = "m 424.54,190.13 c 3.51,4.10 5.86,8.2 5.86,13.18 -2.95,1.45 -7.02,2.05 -9.38,4.69 14.65,-2.05 17.57,14.93 33.97,8.48 0.59,2.35 2.94,4.40 5.86,3.51 l 1.75,-4.67 c 6.43,-1.75 4.67,8.78 11.73,6.72 3.51,2.93 1.16,7.90 3.51,11.43 0,4.09 1.75,7.60 3.51,11.12 1.75,-2.03 2.91,-4.97 7.02,-4.09 2.91,3.21 5.27,6.14 5.86,9.66 -1.19,6.74 -2.94,12.59 4.08,16.11 v 2.05 c 4.70,2.05 15.24,-2.05 15.24,6.14 -0.59,2.93 2.91,0.29 4.10,2.05 2.91,-1.17 7.02,-0.57 10.54,-0.57 2.91,6.14 -3.51,10.54 -5.27,16.11 2.91,2.91 1.75,8.20 1.16,11.70 l -1.75,0.87 c 4.67,0.87 10.54,-0.56 14.65,2.07 l 7.62,2.91 c 3.51,-2.03 7.59,-2.35 12.29,-2.03 3.51,2.63 -1.19,7.02 1.75,9.06 4.11,0 7.62,0.59 8.18,4.11 l 0.59,1.16 c 2.91,-5.27 11.13,-1.75 14.65,-5.55 5.86,0 7.02,6.43 9.94,9.94 1.19,9.09 -9.94,13.20 -6.43,22.27 -2.35,4.39 -7.02,7.90 -10.54,12.01 1.16,0.59 0.56,2.03 0.56,2.91 -3.51,2.07 -0.56,8.22 -5.27,8.78 -0.56,3.82 -7.59,2.35 -5.27,6.46 4.70,6.14 -2.32,9.94 -2.32,15.53 -2.94,3.23 -8.81,-2.94 -8.81,3.23 -3.51,0.87 -7.02,-3.23 -9.34,0.28 -1.19,4.11 2.32,5.55 1.75,9.66 5.83,-0.59 7.59,5.27 9.94,8.78 l 5.86,5.86 c -5.86,4.67 -13.49,-0.59 -20.51,2.03 -1.75,-0.87 0,-3.2 -1.75,-4.07 -1.75,-2.07 -5.27,-2.07 -8.18,-2.63 0.56,2.63 -4.70,3.51 -2.35,6.71 0,0.87 1.16,3.51 -1.16,3.51 -4.70,1.47 -4.10,-4.07 -8.22,-2.03 -5.27,2.03 -1.16,9.94 -8.78,9.06 1.16,7.05 -11.70,11.73 -2.91,17.88 1.16,1.16 0.56,3.51 0.56,5.27 -5.27,4.70 -14.62,2.94 -20.48,1.19 -4.70,-1.19 -1.75,-7.05 -3.51,-10.25 -1.75,-2.94 -7.02,-4.98 -7.02,-9.09 -3.51,-1.44 -6.46,-2.35 -8.81,-5.27 -8.18,7.90 -18.16,15.53 -29.86,15.81 -5.27,2.63 -8.21,13.20 -16.40,8.81 -3.21,5.27 -12.89,0 -13.47,7.59 -3.81,1.47 -2.05,6.46 -4.39,8.78 -0.87,5.86 0,10.85 4.97,14.37 2.05,4.39 -4.39,4.39 -1.75,8.50 0.59,1.44 0,3.51 -0.87,4.10 -1.75,0.87 -2.33,1.75 -1.75,3.51 -1.45,0 -2.05,0.87 -3.21,2.03 -1.47,2.91 -6.14,4.39 -9.38,6.43 -3.21,0.87 -5.56,-1.44 -7.60,-3.51 -0.59,3.23 -3.23,4.98 -6.44,4.98 -4.69,0 -3.81,-4.11 -7.32,-5.86 1.45,-5.27 -3.23,-7.59 -1.75,-12.29 3.81,-2.91 10.24,-4.98 8.48,-11.13 -4.09,-4.95 -2.63,-12.29 -6.72,-18.16 -2.63,-2.32 -7.02,-5.83 -5.56,-11.42 3.81,-4.39 0,-9.66 -2.05,-14.33 -0.87,-3.82 -3.21,-7.34 -3.21,-11.73 -6.44,-3.79 -6.74,-13.77 -15.82,-14.65 -6.44,0 -7.60,-8.18 -14.05,-7.62 -0.59,-1.16 -2.05,-2.03 -3.23,-3.2 -4.67,3.2 -10.54,-0.87 -16.39,0.56 -3.81,-6.43 3.21,-15.21 -7.04,-19.04 v -4.07 c 1.17,0.56 1.75,-0.59 2.05,-1.19 0.58,-4.39 -7.32,-4.95 -4.09,-9.94 -1.75,-1.47 -3.81,-2.07 -2.63,-4.98 -4.40,-9.06 -17.58,-8.18 -20.51,-17.28 2.35,-2.03 2.35,-4.11 3.23,-5.86 -2.05,-3.51 -2.63,-7.31 -2.05,-11.10 2.05,-0.59 3.21,-3.23 4.39,-5.30 -2.63,-1.75 -5.85,-4.39 -8.78,-3.51 -5.27,-0.87 -9.08,-4.95 -13.77,-7.31 -1.17,-1.16 -0.57,-3.23 -0.57,-4.67 6.44,-2.07 -0.87,-11.15 7.02,-9.97 2.05,-2.63 6.44,-3.51 9.66,-5.56 3.23,-0.57 5.86,0.59 9.08,1.47 2.63,3.49 7.32,2.03 9.96,4.97 2.63,-0.59 5.86,-2.05 9.08,-0.59 0,-4.97 2.33,-7.90 5.86,-11.42 0.58,-2.03 3.79,-3.51 6.43,-4.67 4.98,1.16 10.84,1.16 14.37,-2.35 2.33,1.47 4.39,-1.45 7.02,-1.45 3.21,-0.59 5.85,0.28 8.20,1.75 0.28,-5.86 10.54,-0.87 12.59,-7.90 2.33,-4.69 -6.44,-6.44 -5.86,-10.55 -1.45,-4.69 2.05,-7.02 3.81,-10.24 2.05,-0.87 4.39,-2.05 7.02,-1.47 6.74,-2.33 1.47,-16.11 12.31,-11.12 0,1.45 -0.59,3.21 0.28,3.51 3.81,0 4.39,-4.39 7.04,-5.86 1.16,-4.09 -1.47,-9.08 2.03,-12.29 1.75,-0.29 3.23,-0.87 4.39,-2.35 0,-3.21 -1.75,-4.97 -4.39,-7.02 -0.87,1.46 -3.21,0.29 -4.68,0.87 0,-3.51 -2.04,-5.85 -2.63,-9.08 -1.75,-0.87 -2.63,-2.33 -2.03,-4.39 2.63,-2.63 0,-9.08 6.14,-7.62 2.33,-2.04 6.44,-0.58 8.78,-4.09 6.14,-3.51 14.35,-3.51 19.04,-9.96 2.05,0.29 4.39,-1.75 6.44,0 0.58,3.81 6.15,2.33 6.15,5"