{-# OPTIONS_GHC -F -pgmF tasty-discover -optF --in-place #-}
-- GENERATED BY tasty-discover
{-# LANGUAGE FlexibleInstances #-}

module Main (main, ingredients, tests) where

import Data.String (fromString)
import Prelude
import qualified BackupFiles.ValidTest
import qualified ConfigTest
import qualified DiscoverTest
import qualified ModulesGlob.Sub.OneTest
import qualified ModulesGlob.TwoTest
import qualified SubMod.FooBaz
import qualified SubMod.PropTest
import qualified SubMod.SubSubMod.PropTest
import qualified System.Environment as E
import qualified Test.Tasty as T
import qualified Test.Tasty.Discover as TD
import qualified Test.Tasty.HUnit as HU
import qualified Test.Tasty.Hedgehog as H
import qualified Test.Tasty.Hspec as HS
import qualified Test.Tasty.Ingredients as T
import qualified Test.Tasty.QuickCheck as QC
import qualified Test.Tasty.SmallCheck as SC

{- HLINT ignore "Evaluate" -}
{- HLINT ignore "Use let" -}






class TestGroup a where testGroup :: String -> a -> IO T.TestTree
instance TestGroup T.TestTree        where testGroup _ a = pure a
instance TestGroup [T.TestTree]      where testGroup n a = pure $ T.testGroup n a
instance TestGroup (IO T.TestTree)   where testGroup _ a = a
instance TestGroup (IO [T.TestTree]) where testGroup n a = T.testGroup n <$> a

class TestCase a where testCase :: String -> a -> IO T.TestTree
instance TestCase (IO ())                      where testCase n = pure . HU.testCase      n
instance TestCase (IO String)                  where testCase n = pure . HU.testCaseInfo  n
instance TestCase ((String -> IO ()) -> IO ()) where testCase n = pure . HU.testCaseSteps n

tests :: IO T.TestTree
tests = do
  t0 <- pure $ QC.testProperty "validTest" BackupFiles.ValidTest.prop_validTest

  t1 <- HS.testSpec "modules" ConfigTest.spec_modules

  t2 <- HS.testSpec "ignores" ConfigTest.spec_ignores

  t3 <- HS.testSpec "badModuleGlob" ConfigTest.spec_badModuleGlob

  t4 <- HS.testSpec "backupFilesIgnored" ConfigTest.spec_backupFilesIgnored

  t5 <- HS.testSpec "modulesGlobIgnoresDirectories" ConfigTest.spec_modulesGlobIgnoresDirectories

  t6 <- HS.testSpec "customModuleName" ConfigTest.spec_customModuleName

  t7 <- testCase "noTreeDisplayDefault" ConfigTest.unit_noTreeDisplayDefault

  t8 <- testCase "treeDisplay" ConfigTest.unit_treeDisplay

  t9 <- pure $ QC.testProperty "mkModuleTree" ConfigTest.prop_mkModuleTree

  t10 <- HS.testSpec "commentHandling" ConfigTest.spec_commentHandling

  t11 <- TD.tasty (TD.description "assertionExample" <> TD.name "ConfigTest.tasty_assertionExample") ConfigTest.tasty_assertionExample

  t12 <- TD.tasty (TD.description "skippedAssertion" <> TD.name "ConfigTest.tasty_skippedAssertion") ConfigTest.tasty_skippedAssertion

  t13 <- TD.tasty (TD.description "platformAssertion" <> TD.name "ConfigTest.tasty_platformAssertion") ConfigTest.tasty_platformAssertion

  t14 <- HS.testSpec "symlinksNotFollowed" ConfigTest.spec_symlinksNotFollowed

  t15 <- TD.tasty (TD.description "symlinksNotFollowed" <> TD.name "ConfigTest.tasty_symlinksNotFollowed") ConfigTest.tasty_symlinksNotFollowed

  t16 <- testCase "listCompare" DiscoverTest.unit_listCompare

  t17 <- pure $ QC.testProperty "additionCommutative" DiscoverTest.prop_additionCommutative

  t18 <- pure $ SC.testProperty "sortReverse" DiscoverTest.scprop_sortReverse

  t19 <- HS.testSpec "prelude" DiscoverTest.spec_prelude

  t20 <- testGroup "addition" DiscoverTest.test_addition

  t21 <- testGroup "multiplication" DiscoverTest.test_multiplication

  t22 <- testGroup "generateTree" DiscoverTest.test_generateTree

  t23 <- testGroup "generateTrees" DiscoverTest.test_generateTrees

  t24 <- TD.tasty (TD.description "reverse" <> TD.name "DiscoverTest.tasty_reverse") DiscoverTest.tasty_reverse

  t25 <- TD.tasty (TD.description "skip me" <> TD.name "DiscoverTest.tasty_skip_me") DiscoverTest.tasty_skip_me

  t26 <- TD.tasty (TD.description "tree of testCase not skipped" <> TD.name "DiscoverTest.tasty_tree_of_testCase_not_skipped") DiscoverTest.tasty_tree_of_testCase_not_skipped

  t27 <- testCase "platformExpression linux" DiscoverTest.unit_platformExpression_linux

  t28 <- testCase "platformExpression darwin" DiscoverTest.unit_platformExpression_darwin

  t29 <- testCase "platformExpression windows" DiscoverTest.unit_platformExpression_windows

  t30 <- testCase "platformExpression mingw32" DiscoverTest.unit_platformExpression_mingw32

  t31 <- testCase "platformExpression not linux" DiscoverTest.unit_platformExpression_not_linux

  t32 <- testCase "platformExpression not linux false" DiscoverTest.unit_platformExpression_not_linux_false

  t33 <- testCase "platformExpression not darwin" DiscoverTest.unit_platformExpression_not_darwin

  t34 <- testCase "platformExpression not darwin false" DiscoverTest.unit_platformExpression_not_darwin_false

  t35 <- testCase "platformExpression not windows" DiscoverTest.unit_platformExpression_not_windows

  t36 <- testCase "platformExpression not windows false" DiscoverTest.unit_platformExpression_not_windows_false

  t37 <- testCase "platformExpression not mingw32" DiscoverTest.unit_platformExpression_not_mingw32

  t38 <- testCase "platformExpression not mingw32 false" DiscoverTest.unit_platformExpression_not_mingw32_false

  t39 <- testCase "platformExpression not unix" DiscoverTest.unit_platformExpression_not_unix

  t40 <- testCase "platformExpression not unix false linux" DiscoverTest.unit_platformExpression_not_unix_false_linux

  t41 <- testCase "platformExpression not unix false darwin" DiscoverTest.unit_platformExpression_not_unix_false_darwin

  t42 <- testCase "platformExpression and true" DiscoverTest.unit_platformExpression_and_true

  t43 <- testCase "platformExpression and false" DiscoverTest.unit_platformExpression_and_false

  t44 <- testCase "platformExpression and false windows" DiscoverTest.unit_platformExpression_and_false_windows

  t45 <- testCase "platformExpression and both positive" DiscoverTest.unit_platformExpression_and_both_positive

  t46 <- testCase "platformExpression and both positive false" DiscoverTest.unit_platformExpression_and_both_positive_false

  t47 <- testCase "platformExpression and three terms" DiscoverTest.unit_platformExpression_and_three_terms

  t48 <- testCase "platformExpression or true" DiscoverTest.unit_platformExpression_or_true

  t49 <- testCase "platformExpression or true darwin" DiscoverTest.unit_platformExpression_or_true_darwin

  t50 <- testCase "platformExpression or false" DiscoverTest.unit_platformExpression_or_false

  t51 <- testCase "platformExpression or windows mingw32" DiscoverTest.unit_platformExpression_or_windows_mingw32

  t52 <- testCase "platformExpression or three platforms" DiscoverTest.unit_platformExpression_or_three_platforms

  t53 <- testCase "platformExpression unix linux" DiscoverTest.unit_platformExpression_unix_linux

  t54 <- testCase "platformExpression unix darwin" DiscoverTest.unit_platformExpression_unix_darwin

  t55 <- testCase "platformExpression unix windows" DiscoverTest.unit_platformExpression_unix_windows

  t56 <- testCase "platformExpression complex1" DiscoverTest.unit_platformExpression_complex1

  t57 <- testCase "platformExpression complex2" DiscoverTest.unit_platformExpression_complex2

  t58 <- testCase "platformExpression unknown" DiscoverTest.unit_platformExpression_unknown

  t59 <- testCase "platformExpression empty" DiscoverTest.unit_platformExpression_empty

  t60 <- testCase "platformExpression unknown current" DiscoverTest.unit_platformExpression_unknown_current

  t61 <- testCase "platformExpression unix freebsd" DiscoverTest.unit_platformExpression_unix_freebsd

  t62 <- testCase "platformExpression not unix freebsd" DiscoverTest.unit_platformExpression_not_unix_freebsd

  t63 <- TD.tasty (TD.description "linuxOnly" <> TD.name "DiscoverTest.tasty_linuxOnly") DiscoverTest.tasty_linuxOnly

  t64 <- TD.tasty (TD.description "notWindows" <> TD.name "DiscoverTest.tasty_notWindows") DiscoverTest.tasty_notWindows

  t65 <- TD.tasty (TD.description "unixLike" <> TD.name "DiscoverTest.tasty_unixLike") DiscoverTest.tasty_unixLike

  t66 <- TD.tasty (TD.description "complexPlatform1" <> TD.name "DiscoverTest.tasty_complexPlatform1") DiscoverTest.tasty_complexPlatform1

  t67 <- TD.tasty (TD.description "complexPlatform2" <> TD.name "DiscoverTest.tasty_complexPlatform2") DiscoverTest.tasty_complexPlatform2

  t68 <- TD.tasty (TD.description "platformSpecific" <> TD.name "DiscoverTest.tasty_platformSpecific") DiscoverTest.tasty_platformSpecific

  t69 <- TD.tasty (TD.description "platformAndSkip" <> TD.name "DiscoverTest.tasty_platformAndSkip") DiscoverTest.tasty_platformAndSkip

  t70 <- TD.tasty (TD.description "platformGroup" <> TD.name "DiscoverTest.tasty_platformGroup") DiscoverTest.tasty_platformGroup

  t71 <- TD.tasty (TD.description "platformFlavored" <> TD.name "DiscoverTest.tasty_platformFlavored") DiscoverTest.tasty_platformFlavored

  t72 <- TD.tasty (TD.description "platformProperty" <> TD.name "DiscoverTest.tasty_platformProperty") DiscoverTest.tasty_platformProperty

  t73 <- TD.tasty (TD.description "testTree no darwin" <> TD.name "DiscoverTest.tasty_testTree_no_darwin") DiscoverTest.tasty_testTree_no_darwin

  t74 <- pure $ H.testPropertyNamed "reverse" (fromString "DiscoverTest.hprop_reverse") DiscoverTest.hprop_reverse

  t75 <- TD.tasty (TD.description "goldenTest" <> TD.name "DiscoverTest.tasty_goldenTest") DiscoverTest.tasty_goldenTest

  t76 <- pure $ QC.testProperty "subTest" ModulesGlob.Sub.OneTest.prop_subTest

  t77 <- pure $ QC.testProperty "topLevelTest" ModulesGlob.TwoTest.prop_topLevelTest

  t78 <- pure $ QC.testProperty "additionCommutative" SubMod.FooBaz.prop_additionCommutative

  t79 <- pure $ QC.testProperty "multiplationDistributiveOverAddition" SubMod.FooBaz.prop_multiplationDistributiveOverAddition

  t80 <- pure $ QC.testProperty "additionAssociative" SubMod.PropTest.prop_additionAssociative

  t81 <- pure $ QC.testProperty "additionCommutative" SubMod.SubSubMod.PropTest.prop_additionCommutative

  pure $ T.testGroup "test/Driver.hs" [t0,t1,t2,t3,t4,t5,t6,t7,t8,t9,t10,t11,t12,t13,t14,t15,t16,t17,t18,t19,t20,t21,t22,t23,t24,t25,t26,t27,t28,t29,t30,t31,t32,t33,t34,t35,t36,t37,t38,t39,t40,t41,t42,t43,t44,t45,t46,t47,t48,t49,t50,t51,t52,t53,t54,t55,t56,t57,t58,t59,t60,t61,t62,t63,t64,t65,t66,t67,t68,t69,t70,t71,t72,t73,t74,t75,t76,t77,t78,t79,t80,t81]
ingredients :: [T.Ingredient]
ingredients = T.defaultIngredients
main :: IO ()
main = do
  args <- E.getArgs
  E.withArgs ([] ++ args) $    tests >>= T.defaultMainWithIngredients ingredients

